/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.find;

import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.MatchSystem;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.ValidationSystem;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.Find;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.FinderCertificateSource;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.ItemFinderIteration;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.ListItemSource;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.util.ItemSource;

public class CertificateFinderIteration
extends ItemFinderIteration<ECertificate> {
    protected int mSourceIndex = -1;
    protected ECertificate mSubject;

    public CertificateFinderIteration(ECertificate aSubject, ValidationSystem aValidationSystem) {
        this.mSubject = aSubject;
        this._initSources(aValidationSystem);
    }

    @Override
    protected void _initSources(ValidationSystem iDS) {
        if (this.mSubject == null) {
            return;
        }
        this.mSources.add(new ListItemSource<ECertificate>(iDS.getCachedCACertificates(this.mSubject.getIssuer().stringValue())));
        this.mSources.add(new ListItemSource<ECertificate>(iDS.getUserInitialCertificateSet()));
        this.mSources.add(new ListItemSource<ECertificate>(iDS.getFindSystem().getTrustedCertificates()));
        this.mSources.add(new FinderCertificateSource(this.mSubject, iDS.getFindSystem().getCertificateFinders()));
    }

    @Override
    public boolean _nextSource(ValidationSystem iDS) {
        ++this.mSourceIndex;
        if (this.mSourceIndex < this.mSources.size()) {
            this.mCurrentSource = (ItemSource)this.mSources.get(this.mSourceIndex);
        }
        return this.mSourceIndex < this.mSources.size();
    }

    @Override
    public boolean nextIteration(ValidationSystem iDS) throws ESYAException {
        MatchSystem matchSystem = iDS.getMatchSystem();
        while (super.nextIteration(iDS)) {
            if (!Find.isMatchingIssuer(matchSystem, this.mSubject, (ECertificate)this.mCurrentItem)) continue;
            return true;
        }
        return false;
    }
}

