/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.match.ocsp;

import java.util.Arrays;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ECertID;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ESingleResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.match.ocsp.OCSPResponseMatcher;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;

public class CertIDOCSPResponseMatcher
extends OCSPResponseMatcher {
    @Override
    protected boolean _matchOCSPResponse(ECertificate aCertificate, ECertificate aIssuer, EOCSPResponse aOCSPResponse) {
        boolean bl = OCSPResponseMatcher.a;
        if (aOCSPResponse.getResponseStatus() != 0) {
            return false;
        }
        for (int i2 = 0; i2 < aOCSPResponse.getSingleResponseCount(); ++i2) {
            ESingleResponse eSingleResponse = aOCSPResponse.getSingleResponse(i2);
            ECertID eCertID = eSingleResponse.getCertID();
            if (!this.a(aCertificate, aIssuer, eCertID)) continue;
            return true;
        }
        return false;
    }

    private boolean a(ECertificate eCertificate, ECertificate eCertificate2, ECertID eCertID) {
        if (!eCertID.getSerialNumber().equals(eCertificate.getSerialNumber())) {
            return false;
        }
        try {
            DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier(eCertID.getHashAlgorithm());
            byte[] byArray = eCertificate.getIssuer().getEncoded();
            byte[] byArray2 = DigestUtil.digest(digestAlg, byArray);
            if (!Arrays.equals(eCertID.getIssuerNameHash(), byArray2)) {
                return false;
            }
            byte[] byArray3 = eCertificate2.getSubjectPublicKeyInfo().getSubjectPublicKey();
            byte[] byArray4 = DigestUtil.digest(digestAlg, byArray3);
            if (!Arrays.equals(eCertID.getIssuerKeyHash(), byArray4)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }
}

