/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.signature;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1IA5String;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1UTF8String;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EATSHashIndex;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ECertificateChoices;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EContentInfo;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EIssuerAndSerialNumber;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EOtherHashAlgAndValue;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ERevocationInfoChoice;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESigPolicyQualifierInfo;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignaturePolicy;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignedData;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignerIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignerInfo;
import tr.gov.tubitak.uekae.esya.api.asn.esya.EESYAOID;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.pkixtsp.ETSTInfo;
import tr.gov.tubitak.uekae.esya.api.asn.profile.TurkishESigProfile;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CMSSignatureException;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CMSSignatureUtil;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CertRevocationInfoFinder;
import tr.gov.tubitak.uekae.esya.api.cmssignature.SignableByteArray;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeUtil;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.IAttribute;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.MessageDigestAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.MimeTypeAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.SignaturePolicyIdentifierAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.SignatureTimeStampAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.provider.CMSSigProviderUtil;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.BaseSignedData;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.ESignatureType;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.SignatureParser;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.c;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.CertificateValidationException;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.DefaultValidationParameters;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.Checker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ProfileRevocationValueMatcherChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.TurkishProfileAttributesChecker;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.OID;
import tr.gov.tubitak.uekae.esya.api.common.bundle.GenelDil;
import tr.gov.tubitak.uekae.esya.api.common.crypto.BaseSigner;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.tools.Chronometer;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.HashInfo;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.ArgErrorException;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.ECAlgorithmUtil;
import tr.gov.tubitak.uekae.esya.api.infra.mobile.IMobileSigner;
import tr.gov.tubitak.uekae.esya.api.signature.SignatureRuntimeException;
import tr.gov.tubitak.uekae.esya.api.signature.attribute.SignaturePolicyIdentifier;
import tr.gov.tubitak.uekae.esya.api.signature.attribute.TimestampInfo;
import tr.gov.tubitak.uekae.esya.api.signature.certval.ValidationInfoResolver;
import tr.gov.tubitak.uekae.esya.api.signature.certval.ValidationInfoResolverFromCertStore;
import tr.gov.tubitak.uekae.esya.api.signature.impl.TimestampInfoImp;
import tr.gov.tubitak.uekae.esya.asn.cms.SPUserNotice;
import tr.gov.tubitak.uekae.esya.asn.cms.SignerIdentifier;
import tr.gov.tubitak.uekae.esya.asn.cms.SignerInfo;
import tr.gov.tubitak.uekae.esya.asn.cms._etsi101733Values;
import tr.gov.tubitak.uekae.esya.asn.etsiqc._etsiqcValues;
import tr.gov.tubitak.uekae.esya.asn.x509.Attribute;

public abstract class Signer {
    protected EAttribute mParentCounterSignatureAttribute;
    protected Signer mParent;
    protected boolean mIsCounterSignature;
    protected int mCSIndex = -1;
    protected ESignerInfo mSignerInfo;
    protected ESignatureType mSignatureType;
    protected BaseSignedData mSignedData;
    private static final DigestAlg a;
    private static final Boolean b;
    private static final int c = 1;
    private static final Boolean d;
    static Asn1ObjectIdentifier e;
    static Asn1ObjectIdentifier f;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public static int g;
    private static final String[] h;
    private static final String[] i;

    Signer() {
        try {
            LV.getInstance().checkLD(LV.Urunler.CMSIMZA);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(Signer.a(-12460, 30311) + lE.getMessage(), lE);
        }
    }

    Signer(BaseSignedData baseSignedData) {
        try {
            LV.getInstance().checkLD(LV.Urunler.CMSIMZA);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(Signer.a(-12511, -28593) + lE.getMessage(), lE);
        }
        this.mSignedData = baseSignedData;
        this.mSignerInfo = new ESignerInfo(new SignerInfo());
    }

    public ESignerInfo getSignerInfo() {
        return this.mSignerInfo;
    }

    public BaseSignedData getBaseSignedData() {
        return this.mSignedData;
    }

    public ECertificate getSignerCertificate() {
        List<ECertificate> list = this.mSignedData.getSignedData().getCertificates();
        if (list == null) {
            return null;
        }
        return this.mSignerInfo.getSignerCertificate(list);
    }

    public Pair<SignatureAlg, AlgorithmParams> getSignatureAlg() throws CryptoException {
        EAlgorithmIdentifier eAlgorithmIdentifier = this.mSignerInfo.getSignatureAlgorithm();
        Pair<SignatureAlg, AlgorithmParams> pair = SignatureAlg.fromAlgorithmIdentifier(eAlgorithmIdentifier);
        return pair;
    }

    public HashInfo getContentHashInfo() throws ESYAException {
        List<EAttribute> list = this.mSignerInfo.getSignedAttribute(MessageDigestAttr.OID);
        if (!list.isEmpty()) {
            EAttribute eAttribute = list.get(0);
            byte[] byArray = MessageDigestAttr.toMessageDigest(eAttribute).getHash();
            DigestAlg digestAlg = DigestAlg.fromOID(this.mSignerInfo.getDigestAlgorithm().getAlgorithm().value);
            return new HashInfo(digestAlg, byArray);
        }
        return null;
    }

    public void convert(ESignatureType aType, Map<String, Object> aParameters) throws CMSSignatureException {
        this.a(null, aType);
        if (this.a()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv2, new String[0]));
        }
        if (this.b()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv3, new String[0]));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (aParameters != null) {
            hashMap.putAll(aParameters);
        }
        this._convert(aType, this.mIsCounterSignature, hashMap);
        this.c();
        this.mSignatureType = aType;
    }

    private boolean a() {
        Signer signer = this.mParent;
        int n2 = g;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV2()) {
                return true;
            }
            signer = signer.mParent;
            if (n2 == 0) continue;
        }
        return false;
    }

    public Calendar getESAv2Time() throws ESYAException {
        Signer signer = this.mParent;
        int n2 = g;
        Calendar calendar = null;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV2()) {
                List<EAttribute> list = signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV2);
                calendar = SignatureTimeStampAttr.toTime(list.get(0));
                return calendar;
            }
            signer = signer.mParent;
            if (n2 == 0) continue;
        }
        return calendar;
    }

    public List<TimestampInfo> getAllTimeStamps() throws ESYAException {
        ArrayList<TimestampInfo> arrayList = new ArrayList<TimestampInfo>();
        List<TimestampInfo> list = this.a(AttributeOIDs.id_aa_ets_contentTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_escTimeStamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_signatureTimeStampToken);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_certCRLTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV2);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV3);
        this.a(list, arrayList);
        Collections.sort(arrayList, new c(this));
        return arrayList;
    }

    public List<TimestampInfo> getAllArchiveTimeStamps() throws ESYAException {
        ArrayList<TimestampInfo> arrayList = new ArrayList<TimestampInfo>();
        List<TimestampInfo> list = this.a(AttributeOIDs.id_aa_ets_archiveTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV2);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV3);
        this.a(list, arrayList);
        arrayList.sort(Comparator.comparingLong(timestampInfo -> timestampInfo.getTSTInfo().getTime().getTimeInMillis()));
        return arrayList;
    }

    private void a(List<TimestampInfo> list, List<TimestampInfo> list2) {
        Iterator<TimestampInfo> iterator = list.iterator();
        int n2 = g;
        while (iterator.hasNext()) {
            TimestampInfo timestampInfo = iterator.next();
            list2.add(timestampInfo);
            if (n2 == 0) continue;
        }
    }

    private List<TimestampInfo> a(Asn1ObjectIdentifier asn1ObjectIdentifier) throws ESYAException {
        List<EAttribute> list = this.mSignerInfo.getUnsignedAttribute(asn1ObjectIdentifier);
        int n2 = g;
        ArrayList<TimestampInfo> arrayList = new ArrayList<TimestampInfo>(list.size());
        for (EAttribute eAttribute : list) {
            EContentInfo eContentInfo = new EContentInfo(eAttribute.getValue(0));
            ESignedData eSignedData = new ESignedData(eContentInfo.getContent());
            ETSTInfo eTSTInfo = new ETSTInfo(eSignedData.getEncapsulatedContentInfo().getContent());
            TimestampInfoImp timestampInfoImp = new TimestampInfoImp(CMSSigProviderUtil.convertTimestampType(asn1ObjectIdentifier), eSignedData, eTSTInfo);
            arrayList.add(timestampInfoImp);
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public boolean _checkIfSignerIsESAV3() {
        block4: {
            List<EAttribute> list = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV3);
            if (list == null || list.size() <= 0) break block4;
            return true;
        }
        return false;
    }

    public boolean _checkIfSignerIsESAV2() {
        block9: {
            List<EAttribute> list;
            block8: {
                List<EAttribute> list2 = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestamp);
                list = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV2);
                if (list2 == null || list2.size() <= 0) break block8;
                return true;
            }
            if (list == null || list.size() <= 0) break block9;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _convert(ESignatureType aType, boolean aIsCounterSignature, Map<String, Object> aParameters) throws CMSSignatureException {
        ECertificate eCertificate;
        ESignatureType eSignatureType = SignatureParser.parse(this.mSignerInfo, aIsCounterSignature);
        ArrayList<ECertificate> arrayList = new ArrayList<ECertificate>();
        arrayList.addAll(this.mSignedData.getSignedData().getCertificates());
        Object object = aParameters.get(Signer.a(-12449, -16413));
        ECertificate eCertificate2 = null;
        if (object != null && object instanceof ECertificate) {
            eCertificate2 = (ECertificate)object;
            arrayList.add(eCertificate2);
        }
        if ((eCertificate = this.getSignerCertificate()) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error(Signer.a(-12426, 28276));
            }
            throw new CMSSignatureException(Signer.a(-12490, -7254));
        }
        aParameters.put(Signer.a(-12448, -31537), eCertificate);
        Signer signer = null;
        try {
            signer = ESignatureType.createSigner(aType, this.mSignedData, this.mSignerInfo);
        }
        catch (Exception exception) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error(Signer.a(-12494, -26783), exception);
            }
            throw new CMSSignatureException(Signer.a(-12435, 27680), exception);
        }
        this.a(aIsCounterSignature, eCertificate, null, aParameters);
        signer._convert(eSignatureType, aParameters);
    }

    public boolean remove() throws CMSSignatureException {
        if (this.a()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv2, new String[0]));
        }
        if (this.b()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv3, new String[0]));
        }
        if (!this.mIsCounterSignature) {
            return this.mSignedData.removeSigner(this.mSignerInfo);
        }
        return this.mParent.removeUnSignedAttribute(this.mParentCounterSignatureAttribute);
    }

    private boolean b() throws CMSSignatureException {
        Signer signer = this.mParent;
        int n2 = g;
        Signer signer2 = this;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV3()) {
                List<EAttribute> list = signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV3);
                EATSHashIndex eATSHashIndex = this.a(list.get(list.size() - 1));
                List<Asn1OctetString> list2 = Arrays.asList(eATSHashIndex.getUnsignedAttrsHashIndex());
                DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier(eATSHashIndex.gethashIndAlgorithm());
                List<EAttribute> list3 = signer.getSignerInfo().getUnsignedAttribute(AttributeOIDs.id_countersignature);
                for (EAttribute eAttribute : list3) {
                    try {
                        ESignerInfo eSignerInfo = new ESignerInfo(eAttribute.getValue(0));
                        if (Arrays.equals(eSignerInfo.getSignature(), signer2.getSignerInfo().getSignature())) {
                            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                            ((Attribute)eAttribute.getObject()).encode(asn1DerEncodeBuffer);
                            Asn1OctetString asn1OctetString = new Asn1OctetString(DigestUtil.digest(digestAlg, asn1DerEncodeBuffer.getMsgCopy()));
                            asn1DerEncodeBuffer.reset();
                            if (list2.contains(asn1OctetString)) {
                                return true;
                            }
                        }
                    }
                    catch (ESYAException eSYAException) {
                        this.logger.error(eSYAException.getMessage(), eSYAException);
                        throw new CMSSignatureException(Signer.a(-12419, 6135), eSYAException);
                    }
                    if (n2 == 0) continue;
                }
            }
            signer2 = signer;
            signer = signer.mParent;
            if (n2 == 0) continue;
        }
        return false;
    }

    public Calendar getESAv3Time() throws ESYAException {
        Signer signer = this.mParent;
        int n2 = g;
        Signer signer2 = this;
        Calendar calendar = null;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV3()) {
                List<EAttribute> list = signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV3);
                EATSHashIndex eATSHashIndex = this.a(list.get(list.size() - 1));
                List<Asn1OctetString> list2 = Arrays.asList(eATSHashIndex.getUnsignedAttrsHashIndex());
                DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier(eATSHashIndex.gethashIndAlgorithm());
                List<EAttribute> list3 = signer.getSignerInfo().getUnsignedAttribute(AttributeOIDs.id_countersignature);
                for (EAttribute eAttribute : list3) {
                    try {
                        ESignerInfo eSignerInfo = new ESignerInfo(eAttribute.getValue(0));
                        if (Arrays.equals(eSignerInfo.getSignature(), signer2.getSignerInfo().getSignature())) {
                            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                            ((Attribute)eAttribute.getObject()).encode(asn1DerEncodeBuffer);
                            Asn1OctetString asn1OctetString = new Asn1OctetString(DigestUtil.digest(digestAlg, asn1DerEncodeBuffer.getMsgCopy()));
                            asn1DerEncodeBuffer.reset();
                            if (list2.contains(asn1OctetString)) {
                                int n3 = this.a(list, eAttribute);
                                calendar = SignatureTimeStampAttr.toTime(list.get(n3));
                                return calendar;
                            }
                        }
                    }
                    catch (ESYAException eSYAException) {
                        this.logger.error(eSYAException.getMessage(), eSYAException);
                        throw new ESYAException(Signer.a(-12446, 8948), eSYAException);
                    }
                    if (n2 == 0) continue;
                }
            }
            signer2 = signer;
            signer = signer.mParent;
            if (n2 == 0) continue;
        }
        return calendar;
    }

    private int a(List<EAttribute> list, EAttribute eAttribute) throws CryptoException {
        int n2 = g;
        for (int i2 = 0; i2 < list.size() - 1; ++i2) {
            EATSHashIndex eATSHashIndex = this.a(list.get(i2));
            List<Asn1OctetString> list2 = Arrays.asList(eATSHashIndex.getUnsignedAttrsHashIndex());
            DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier(eATSHashIndex.gethashIndAlgorithm());
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            ((Attribute)eAttribute.getObject()).encode(asn1DerEncodeBuffer);
            Asn1OctetString asn1OctetString = new Asn1OctetString(DigestUtil.digest(digestAlg, asn1DerEncodeBuffer.getMsgCopy()));
            asn1DerEncodeBuffer.reset();
            if (!list2.contains(asn1OctetString)) continue;
            return i2;
        }
        return list.size() - 1;
    }

    private EATSHashIndex a(EAttribute eAttribute) {
        try {
            EContentInfo eContentInfo = new EContentInfo(eAttribute.getValue(0));
            ESignedData eSignedData = new ESignedData(eContentInfo.getContent());
            EAttribute eAttribute2 = eSignedData.getSignerInfo(0).getUnsignedAttribute(AttributeOIDs.id_aa_ATSHashIndex).get(0);
            return new EATSHashIndex(eAttribute2.getValue(0));
        }
        catch (ESYAException eSYAException) {
            throw new ESYARuntimeException(Signer.a(-12430, 5738), eSYAException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCounterSigner(ESignatureType aType, ECertificate aCer, BaseSigner aSignerInterface, List<IAttribute> aOptionalAttributes, Map<String, Object> aParameters) throws CertificateValidationException, CMSSignatureException {
        this.a(aCer, aType);
        int n2 = g;
        if (this.mSignedData.checkIfAnyESAv2Exist() && this.b()) {
            if (!this.logger.isDebugEnabled()) throw new CMSSignatureException(Signer.a(-12437, 28143));
            this.logger.error(Signer.a(-12470, -24774));
            throw new CMSSignatureException(Signer.a(-12437, 28143));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (aParameters != null) {
            hashMap.putAll(aParameters);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Signer.a(-12423, 16931) + aCer + Signer.a(-12474, 13889));
        }
        Signer signer = null;
        SignatureAlg signatureAlg = null;
        try {
            signatureAlg = SignatureAlg.fromName(aSignerInterface.getSignatureAlgorithmStr());
            signer = ESignatureType.createSigner(aType, this.mSignedData);
        }
        catch (ArgErrorException argErrorException) {
            throw new CMSSignatureException(Signer.a(-12438, -3409), argErrorException);
        }
        catch (Exception exception) {
            throw new CMSSignatureException(Signer.a(-12471, -23917), exception);
        }
        DigestAlg digestAlg = signatureAlg.getDigestAlg();
        AlgorithmParameterSpec algorithmParameterSpec = aSignerInterface.getAlgorithmParameterSpec();
        digestAlg = CMSSignatureUtil.getDigestAlgFromParameters(digestAlg, algorithmParameterSpec);
        hashMap.put(Signer.a(-12458, -8559), new SignableByteArray(this.mSignerInfo.getSignature()));
        signer.a(true, aCer, aSignerInterface, aOptionalAttributes, hashMap, digestAlg);
        EAttribute eAttribute = new EAttribute(new Attribute());
        eAttribute.setType(AttributeOIDs.id_countersignature);
        eAttribute.addValue(signer.getSignerInfo().getEncoded());
        this.mSignerInfo.addUnsignedAttribute(eAttribute);
        if (digestAlg != null) {
            CMSSignatureUtil.addDigestAlgIfNotExist(this.mSignedData.getSignedData(), digestAlg.toAlgorithmIdentifier());
        }
        this.c();
        if (BaseChecker.c == 0) return;
        g = ++n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCounterSigner(Signer signer) {
        int n2 = g;
        if (this.checkSignerMessageDigest(signer, this.mSignerInfo.getSignature())) {
            EAttribute eAttribute = new EAttribute(new Attribute());
            eAttribute.setType(AttributeOIDs.id_countersignature);
            eAttribute.addValue(signer.getSignerInfo().getEncoded());
            this.mSignerInfo.addUnsignedAttribute(eAttribute);
            CMSSignatureUtil.addCerIfNotExist(this.mSignedData.getSignedData(), signer.getSignerCertificate());
            EAlgorithmIdentifier eAlgorithmIdentifier = signer.getSignerInfo().getDigestAlgorithm();
            if (eAlgorithmIdentifier != null) {
                CMSSignatureUtil.addDigestAlgIfNotExist(this.mSignedData.getSignedData(), eAlgorithmIdentifier);
            }
            this.c();
            if (n2 == 0) return;
        }
        this.logger.error(Signer.a(-12477, -9322));
    }

    public boolean checkSignerMessageDigest(Signer aSigner, byte[] aContent) {
        Object object;
        List<EAttribute> list = aSigner.getSignedAttribute(AttributeOIDs.id_messageDigest);
        if (list.isEmpty()) {
            this.logger.error(Signer.a(-12463, -30235));
            return false;
        }
        EAttribute eAttribute = list.get(0);
        Asn1OctetString asn1OctetString = new Asn1OctetString();
        try {
            object = new Asn1DerDecodeBuffer(eAttribute.getValue(0));
            asn1OctetString.decode((Asn1BerDecodeBuffer)object);
        }
        catch (Exception exception) {
            this.logger.error(Signer.a(-12417, -12291), exception);
            return false;
        }
        DigestAlg digestAlg = DigestAlg.fromOID(aSigner.getSignerInfo().getDigestAlgorithm().getAlgorithm().value);
        if (digestAlg == null) {
            this.logger.error(Signer.a(-12427, 3664));
            return false;
        }
        try {
            object = DigestUtil.digest(digestAlg, aContent);
        }
        catch (CryptoException cryptoException) {
            this.logger.error(Signer.a(-12492, -12630), cryptoException);
            return false;
        }
        boolean bl = Arrays.equals(asn1OctetString.value, (byte[])object);
        if (!bl) {
            this.logger.error(Signer.a(-12451, -32658));
            return false;
        }
        this.logger.error(Signer.a(-12440, -31347));
        return true;
    }

    public List<Signer> getCounterSigners() throws CMSSignatureException {
        List<EAttribute> list = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_countersignature);
        ArrayList<Signer> arrayList = new ArrayList<Signer>();
        int n2 = g;
        for (EAttribute eAttribute : list) {
            try {
                for (int i2 = 0; i2 < eAttribute.getValueCount(); ++i2) {
                    ESignerInfo eSignerInfo = new ESignerInfo(eAttribute.getValue(i2));
                    ESignatureType eSignatureType = SignatureParser.parse(eSignerInfo, true);
                    Signer signer = ESignatureType.createSigner(eSignatureType, this.mSignedData, eSignerInfo);
                    signer.setParent(this, eAttribute, i2);
                    arrayList.add(signer);
                    if (n2 == 0) continue;
                    break;
                }
            }
            catch (Exception exception) {
                throw new CMSSignatureException(Signer.a(-12480, 19586), exception);
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public ESignatureType getType() {
        return this.mSignatureType;
    }

    protected void setParent(Signer aParent, EAttribute aAttr, int aIndex) {
        this.mParent = aParent;
        this.mParentCounterSignatureAttribute = aAttr;
        this.mCSIndex = aIndex;
        if (this.mParent != null) {
            this.mIsCounterSignature = true;
        }
    }

    public boolean isCounterSignature() {
        return this.mIsCounterSignature;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void a(boolean bl, ECertificate eCertificate, BaseSigner baseSigner, List<IAttribute> list, Map<String, Object> map, DigestAlg digestAlg) throws CMSSignatureException {
        Object object2;
        List<IAttribute> list2;
        HashMap<String, Object> hashMap;
        int n2;
        block39: {
            block36: {
                block38: {
                    block37: {
                        n2 = g;
                        if (bl && this.b(list)) {
                            throw new CMSSignatureException(Signer.a(-12452, -1312));
                        }
                        hashMap = new HashMap<String, Object>();
                        if (map != null) {
                            hashMap.putAll(map);
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(Signer.a(-12422, -15252) + digestAlg);
                        }
                        this.a(bl, eCertificate, digestAlg, hashMap);
                        DigestAlg digestAlg2 = (DigestAlg)hashMap.get(Signer.a(-12476, 19342));
                        if (this.mSignatureType == ESignatureType.TYPE_EPES && !this.a(list)) {
                            throw new CMSSignatureException(Signer.a(-12483, 20883));
                        }
                        list2 = this._getMandatorySignedAttributes(bl, digestAlg2);
                        this.mSignerInfo.setVersion(1);
                        if (eCertificate != null || !(baseSigner instanceof IMobileSigner)) break block36;
                        object2 = ((IMobileSigner)baseSigner).getSignerIdentifier();
                        if (object2 == null) {
                            throw new CMSSignatureException(Signer.a(-12418, -28676));
                        }
                        this.mSignerInfo.setSignerIdentifier((ESignerIdentifier)object2);
                        DigestAlg object3 = ((IMobileSigner)baseSigner).getDigestAlg();
                        list2 = this._getMandatorySignedAttributes(bl, object3);
                        if (!object3.equals(DigestAlg.SHA1)) break block37;
                        hashMap.put(Signer.a(-12479, -20764), ((IMobileSigner)baseSigner).getSigningCertAttr());
                        if (n2 == 0) break block38;
                        int n3 = BaseChecker.c;
                        BaseChecker.c = ++n3;
                    }
                    hashMap.put(Signer.a(-12442, -19247), ((IMobileSigner)baseSigner).getSigningCertAttrv2());
                }
                if (n2 == 0) break block39;
            }
            object2 = new ESignerIdentifier(new SignerIdentifier());
            ((ESignerIdentifier)object2).setIssuerAndSerialNumber(new EIssuerAndSerialNumber(eCertificate));
            this.mSignerInfo.setSignerIdentifier((ESignerIdentifier)object2);
        }
        if (list != null) {
            list2.addAll(list);
        }
        this.mSignerInfo.setDigestAlgorithm(digestAlg.toAlgorithmIdentifier());
        for (IAttribute exception : list2) {
            if (exception.isSigned()) {
                exception.setParameters(hashMap);
                exception.setValue();
                this.mSignerInfo.addSignedAttribute(exception.getAttribute());
            }
            if (n2 == 0) continue;
        }
        this.a(hashMap);
        object2 = null;
        try {
            SignatureAlg signatureAlg = SignatureAlg.fromName(baseSigner.getSignatureAlgorithmStr());
            AlgorithmParameterSpec algorithmParameterSpec = baseSigner.getAlgorithmParameterSpec();
            EAlgorithmIdentifier eAlgorithmIdentifier = signatureAlg.toAlgorithmIdentifierFromSpec(algorithmParameterSpec);
            this.mSignerInfo.setSignatureAlgorithm(eAlgorithmIdentifier);
            if (eCertificate != null) {
                ECAlgorithmUtil.checkKeyAndSigningAlgorithmConsistency(eCertificate, signatureAlg);
                ECAlgorithmUtil.checkDigestAlgForECCAlgorithm(eCertificate, signatureAlg);
            }
            Chronometer chronometer = new Chronometer(Signer.a(-12445, -18388));
            chronometer.start();
            byte[] byArray = this.mSignerInfo.getSignedAttributes().getEncoded();
            object2 = baseSigner.sign(byArray);
            if (eCertificate == null && baseSigner instanceof IMobileSigner) {
                eCertificate = ((IMobileSigner)baseSigner).getSigningCert();
                hashMap.put(Signer.a(-12432, 20850), eCertificate);
            }
            this.logger.info(chronometer.stopSingleRun());
            this.mSignerInfo.setSignature((byte[])object2);
            if (eCertificate != null) {
                ECAlgorithmUtil.checkDigestAlgForECCAlgorithm(eCertificate, signatureAlg);
                CMSSignatureUtil.addCerIfNotExist(this.mSignedData.getSignedData(), eCertificate);
            }
        }
        catch (ArgErrorException argErrorException) {
            throw new CMSSignatureException(Signer.a(-12473, -673), argErrorException);
        }
        catch (Exception exception) {
            throw new CMSSignatureException(GenelDil.mesaj(GenelDil.IMZALAMADA_HATA) + " " + exception.getMessage(), exception);
        }
        this._addUnsignedAttributes(hashMap);
    }

    private boolean a(List<IAttribute> list) {
        Iterator<IAttribute> iterator = list.iterator();
        int n2 = g;
        while (iterator.hasNext()) {
            IAttribute iAttribute = iterator.next();
            if (iAttribute instanceof SignaturePolicyIdentifierAttr) {
                return true;
            }
            if (n2 == 0) continue;
        }
        return false;
    }

    private boolean b(List<IAttribute> list) {
        int n2 = g;
        if (list != null) {
            for (IAttribute iAttribute : list) {
                if (iAttribute instanceof MimeTypeAttr) {
                    return true;
                }
                if (n2 == 0) continue;
            }
        }
        return false;
    }

    protected CertificateStatusInfo _validateCertificate(ECertificate aCer, Map<String, Object> aParams, Calendar aDate, boolean gelismis) throws CMSSignatureException {
        CertificateStatusInfo certificateStatusInfo;
        block8: {
            CertRevocationInfoFinder certRevocationInfoFinder = new CertRevocationInfoFinder(gelismis);
            certificateStatusInfo = certRevocationInfoFinder.validateCertificate(aCer, aParams, aDate);
            int n2 = g;
            List<CertRevocationInfoFinder.CertRevocationInfo> list = certRevocationInfoFinder.getCertRevRefs(certificateStatusInfo);
            aParams.put(Signer.a(-12459, -25494), list);
            try {
                boolean bl = Boolean.TRUE.equals(aParams.get(Signer.a(-12493, 20926)));
                if (!this.isTurkishProfile() || bl) break block8;
                ArrayList<BaseChecker> arrayList = new ArrayList<BaseChecker>();
                ProfileRevocationValueMatcherChecker profileRevocationValueMatcherChecker = new ProfileRevocationValueMatcherChecker(certificateStatusInfo, true);
                TurkishProfileAttributesChecker turkishProfileAttributesChecker = new TurkishProfileAttributesChecker(true);
                arrayList.add(profileRevocationValueMatcherChecker);
                arrayList.add(turkishProfileAttributesChecker);
                for (Checker checker : arrayList) {
                    CheckerResult checkerResult = new CheckerResult();
                    checker.setParameters(aParams);
                    boolean bl2 = checker.check(this, checkerResult);
                    if (!bl2) {
                        throw new CMSSignatureException(checkerResult.getCheckResult());
                    }
                    if (n2 == 0) continue;
                    break;
                }
            }
            catch (Exception exception) {
                this.logger.error(Signer.a(-12428, -5861) + exception.getMessage());
                throw new SignatureRuntimeException(exception);
            }
        }
        return certificateStatusInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(boolean bl, ECertificate eCertificate, DigestAlg digestAlg, Map<String, Object> map) {
        int n2;
        block87: {
            block86: {
                block85: {
                    block84: {
                        block83: {
                            block82: {
                                block81: {
                                    block80: {
                                        Object object;
                                        block79: {
                                            block78: {
                                                block77: {
                                                    block76: {
                                                        block74: {
                                                            block75: {
                                                                n2 = g;
                                                                if (digestAlg != null) {
                                                                    map.put(Signer.a(-12466, 2999), digestAlg);
                                                                    map.put(Signer.a(-12509, 1564), digestAlg);
                                                                }
                                                                if (eCertificate != null) {
                                                                    map.put(Signer.a(-12432, 20850), eCertificate);
                                                                }
                                                                map.put(Signer.a(-12482, 12942), this.mSignedData.getSignedData().getEncapsulatedContentInfo().getContentType());
                                                                if (bl) break block74;
                                                                if (this.mSignedData.a() != null) break block75;
                                                                object = this.mSignedData.getSignedData().getEncapsulatedContentInfo().getContent();
                                                                if (object != null) {
                                                                    map.put(Signer.a(-12444, 23836), new SignableByteArray((byte[])object));
                                                                }
                                                                if (n2 == 0) break block74;
                                                            }
                                                            map.put(Signer.a(-12458, -8559), this.mSignedData.a());
                                                        }
                                                        if (map.containsKey(Signer.a(-12476, 19342))) break block76;
                                                        map.put(Signer.a(-12476, 19342), a);
                                                        if (!this.logger.isDebugEnabled()) break block77;
                                                        this.logger.debug(Signer.a(-12510, 16735) + digestAlg + Signer.a(-12454, 23634));
                                                        if (n2 == 0) break block77;
                                                    }
                                                    if (!(map.get(Signer.a(-12476, 19342)) instanceof DigestAlg)) {
                                                        map.put(Signer.a(-12476, 19342), a);
                                                        this.logger.debug(Signer.a(-12495, 17019) + digestAlg + Signer.a(-12443, -15204));
                                                    }
                                                }
                                                if (map.containsKey(Signer.a(-12512, -16280))) break block78;
                                                map.put(Signer.a(-12457, -2161), b);
                                                if (!this.logger.isDebugEnabled()) break block79;
                                                this.logger.debug(Signer.a(-12486, -22707));
                                                if (n2 == 0) break block79;
                                            }
                                            if (!(map.get(Signer.a(-12457, -2161)) instanceof Boolean)) {
                                                map.put(Signer.a(-12457, -2161), b);
                                                this.logger.debug(Signer.a(-12462, 14029));
                                            }
                                        }
                                        if (!map.containsKey(Signer.a(-12455, -22017))) {
                                            map.put(Signer.a(-12441, -13861), new ValidationInfoResolverFromCertStore());
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug(Signer.a(-12439, -8914));
                                            }
                                        }
                                        object = (ValidationInfoResolver)map.get(Signer.a(-12441, -13861));
                                        List list = (List)map.get(Signer.a(-12488, 24411));
                                        List list2 = (List)map.get(Signer.a(-12429, 23625));
                                        List list3 = (List)map.get(Signer.a(-12472, 574));
                                        if (list != null) {
                                            object.addCertificates(list);
                                        }
                                        if (list2 != null) {
                                            object.addCRLs(list2);
                                        }
                                        if (list3 != null) {
                                            object.addOCSPResponses(list3);
                                        }
                                        if (map.containsKey(Signer.a(-12469, 8155))) break block80;
                                        map.put(Signer.a(-12431, 12379), DefaultValidationParameters.DEFAULT_TRUST_SIGNINGTIMEATTR);
                                        if (!this.logger.isDebugEnabled()) break block81;
                                        this.logger.debug(Signer.a(-12496, -21571));
                                        if (n2 == 0) break block81;
                                    }
                                    if (!(map.get(Signer.a(-12431, 12379)) instanceof Boolean)) {
                                        map.put(Signer.a(-12431, 12379), DefaultValidationParameters.DEFAULT_TRUST_SIGNINGTIMEATTR);
                                        this.logger.debug(Signer.a(-12453, -10066));
                                    }
                                }
                                if (map.containsKey(Signer.a(-12420, -10248))) break block82;
                                map.put(Signer.a(-12433, 16859), DefaultValidationParameters.DEFAULT_GRACE_PERIOD);
                                if (!this.logger.isDebugEnabled()) break block83;
                                this.logger.debug(Signer.a(-12434, 8415) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                                if (n2 == 0) break block83;
                            }
                            if (!(map.get(Signer.a(-12433, 16859)) instanceof Long)) {
                                map.put(Signer.a(-12433, 16859), DefaultValidationParameters.DEFAULT_GRACE_PERIOD);
                                this.logger.debug(Signer.a(-12450, -30856) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                            }
                        }
                        if (map.containsKey(Signer.a(-12484, 20764))) break block84;
                        map.put(Signer.a(-12436, 19886), DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE);
                        if (!this.logger.isDebugEnabled()) break block85;
                        this.logger.debug(Signer.a(-12465, -12052) + DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE + ".");
                        if (n2 == 0) break block85;
                    }
                    if (!(map.get(Signer.a(-12436, 19886)) instanceof Long)) {
                        map.put(Signer.a(-12436, 19886), DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE);
                        this.logger.debug(Signer.a(-12487, 19962) + DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE + ".");
                    }
                }
                if (map.containsKey(Signer.a(-12481, 27766))) break block86;
                map.put(Signer.a(-12461, -17400), DefaultValidationParameters.DEFAULT_IGNORE_GRACE);
                if (!this.logger.isDebugEnabled()) break block87;
                this.logger.debug(Signer.a(-12468, -12566) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                if (n2 == 0) break block87;
            }
            if (!(map.get(Signer.a(-12461, -17400)) instanceof Boolean)) {
                map.put(Signer.a(-12461, -17400), DefaultValidationParameters.DEFAULT_IGNORE_GRACE);
                this.logger.debug(Signer.a(-12491, 19482) + DefaultValidationParameters.DEFAULT_IGNORE_GRACE + ".");
            }
        }
        if (!map.containsKey(Signer.a(-12507, 30427))) {
            map.put(Signer.a(-12424, -9511), d);
            if (!this.logger.isDebugEnabled()) return;
            this.logger.debug(Signer.a(-12478, -6310));
            if (n2 == 0) return;
        }
        if (map.get(Signer.a(-12424, -9511)) instanceof Boolean) return;
        map.put(Signer.a(-12424, -9511), d);
        this.logger.debug(Signer.a(-12421, -28986));
    }

    public List<EAttribute> getSignedAttribute(Asn1ObjectIdentifier aOID) {
        return this.mSignerInfo.getSignedAttribute(aOID);
    }

    public List<EAttribute> getUnsignedAttribute(Asn1ObjectIdentifier aOID) {
        return this.mSignerInfo.getUnsignedAttribute(aOID);
    }

    public List<EAttribute> getAttribute(Asn1ObjectIdentifier aOID) {
        List<EAttribute> list = this.mSignerInfo.getUnsignedAttribute(aOID);
        List<EAttribute> list2 = this.mSignerInfo.getSignedAttribute(aOID);
        list.addAll(list2);
        return list;
    }

    public boolean removeUnSignedAttribute(EAttribute aAttribute) {
        boolean bl = this.mSignerInfo.removeUnSignedAttribute(aAttribute);
        this.c();
        return bl;
    }

    private void c() {
        Signer signer = this.mParent;
        EAttribute eAttribute = this.mParentCounterSignatureAttribute;
        int n2 = g;
        ESignerInfo eSignerInfo = this.mSignerInfo;
        while (signer != null) {
            eAttribute.setValue(this.mCSIndex, eSignerInfo.getEncoded());
            eAttribute = signer.mParentCounterSignatureAttribute;
            eSignerInfo = signer.mSignerInfo;
            signer = signer.mParent;
            if (n2 == 0) continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(ECertificate eCertificate, ESignatureType eSignatureType) {
        int n2 = g;
        try {
            block11: {
                block10: {
                    if (eSignatureType != ESignatureType.TYPE_BES && eSignatureType != ESignatureType.TYPE_EPES) break block10;
                    LV.getInstance().checkLD(LV.Urunler.CMSIMZA);
                    if (n2 == 0) break block11;
                }
                LV.getInstance().checkLD(LV.Urunler.CMSIMZAGELISMIS);
            }
            boolean bl = LV.getInstance().isTL(LV.Urunler.CMSIMZA);
            if (eCertificate == null) return;
            if (!bl) return;
            if (eCertificate.getSubject().getCommonNameAttribute().toLowerCase().contains(Signer.a(-12467, 14668))) return;
            throw new ESYARuntimeException(Signer.a(-12475, -26629));
        }
        catch (LE lE) {
            throw new ESYARuntimeException(Signer.a(-12511, -28593) + lE.getMessage(), lE);
        }
    }

    public boolean isTurkishProfile() {
        try {
            TurkishESigProfile turkishESigProfile = this.mSignerInfo.getProfile();
            if (turkishESigProfile == null) {
                return false;
            }
        }
        catch (Exception exception) {
            this.logger.warn(Signer.a(-12505, 28237), exception);
            return false;
        }
        return true;
    }

    protected void _addCertRevocationValuesToSignedData(List<CertRevocationInfoFinder.CertRevocationInfo> aList) throws CMSSignatureException {
        this.a(aList, this.mSignedData.getSignedData());
    }

    protected void _addCertRevocationValuesToSignedData(List<ECertificate> aCerts, List<ECRL> aCrls, List<EOCSPResponse> aOCSPResponses) throws CMSSignatureException {
        this.a(aCerts, aCrls, aOCSPResponses, this.mSignedData.getSignedData());
    }

    public List<CertRevocationInfoFinder.CertRevocationInfo> findTSCertificateRevocationValues(EAttribute aTSAttr, Map<String, Object> aParamMap) throws CMSSignatureException {
        return this.a(aTSAttr, aParamMap);
    }

    private List<CertRevocationInfoFinder.CertRevocationInfo> a(EAttribute eAttribute, Map<String, Object> map) throws CMSSignatureException {
        CertificateStatusInfo certificateStatusInfo;
        Calendar calendar = null;
        EContentInfo eContentInfo = null;
        try {
            eContentInfo = new EContentInfo(eAttribute.getValue(0));
        }
        catch (Exception exception) {
            throw new CMSSignatureException(Signer.a(-12447, -11614), exception);
        }
        BaseSignedData baseSignedData = new BaseSignedData(eContentInfo);
        ECertificate eCertificate = baseSignedData.getSignerList().get(0).getSignerCertificate();
        if (eCertificate == null) {
            throw new CMSSignatureException(Signer.a(-12425, 10381));
        }
        calendar = Calendar.getInstance();
        CertRevocationInfoFinder certRevocationInfoFinder = new CertRevocationInfoFinder(true);
        try {
            certificateStatusInfo = certRevocationInfoFinder.validateCertificate(eCertificate, map, calendar);
        }
        catch (CertificateValidationException certificateValidationException) {
            try {
                calendar = SignatureTimeStampAttr.toTime(eAttribute);
            }
            catch (ESYAException eSYAException) {
                this.logger.warn(Signer.a(-12489, 31781), eSYAException);
                throw certificateValidationException;
            }
            certRevocationInfoFinder = new CertRevocationInfoFinder(true);
            certificateStatusInfo = certRevocationInfoFinder.validateCertificate(eCertificate, map, calendar);
        }
        return certRevocationInfoFinder.getCertRevRefs(certificateStatusInfo);
    }

    protected void _addTSCertRevocationValues(Map<String, Object> aParameters, Asn1ObjectIdentifier aTSOID, boolean intoTimestamp) throws CMSSignatureException {
        List<EAttribute> list = this.mSignerInfo.getUnsignedAttribute(aTSOID);
        if (list.isEmpty()) {
            list = this.mSignerInfo.getSignedAttribute(aTSOID);
            if (list.isEmpty()) {
                throw new CMSSignatureException(Signer.a(-12456, 736) + aTSOID);
            }
        }
        this._addTSCertRevocationValues(list.get(list.size() - 1), aParameters, intoTimestamp);
    }

    protected void _addTSCertRevocationValues(EAttribute aTSAttr, Map<String, Object> aParamMap, boolean intoTimestamp) throws CMSSignatureException {
        block5: {
            List<CertRevocationInfoFinder.CertRevocationInfo> list;
            block4: {
                list = this.a(aTSAttr, aParamMap);
                int n2 = g;
                if (!intoTimestamp) break block4;
                this.b(list, aTSAttr);
                if (n2 == 0) break block5;
            }
            this._addCertRevocationValuesToSignedData(list);
        }
    }

    private void b(List<CertRevocationInfoFinder.CertRevocationInfo> list, EAttribute eAttribute) throws CMSSignatureException {
        EContentInfo eContentInfo = null;
        ESignedData eSignedData = null;
        try {
            eContentInfo = new EContentInfo(eAttribute.getValue(0));
            eSignedData = new ESignedData(eContentInfo.getContent());
        }
        catch (Exception exception) {
            throw new CMSSignatureException(Signer.a(-12464, -17710), exception);
        }
        this.a(list, eSignedData);
        eContentInfo.setContent(eSignedData.getEncoded());
        eAttribute.setValue(0, eContentInfo.getEncoded());
    }

    private void a(List<CertRevocationInfoFinder.CertRevocationInfo> list, ESignedData eSignedData) throws CMSSignatureException {
        List<ECertificate> list2 = AttributeUtil.getCertificates(list);
        List<ECRL> list3 = AttributeUtil.getCRLs(list);
        List<EOCSPResponse> list4 = AttributeUtil.getOCSPResponses(list);
        this.a(list2, list3, list4, eSignedData);
    }

    /*
     * WARNING - void declaration
     */
    private void a(List<ECertificate> list, List<ECRL> list2, List<EOCSPResponse> list3, ESignedData eSignedData) throws CMSSignatureException {
        List<Object> list5 = new ArrayList();
        int n2 = g;
        if (eSignedData.getCertificateSet() != null) {
            list5 = Arrays.asList(eSignedData.getCertificateSet().getCertificates());
        }
        for (ECertificate list42 : list) {
            if (!list5.contains(list42)) {
                eSignedData.addCertificateChoices(new ECertificateChoices(list42));
            }
            if (n2 == 0) continue;
        }
        List<ECRL> list6 = new ArrayList();
        if (eSignedData.getRevocationInfoChoices() != null) {
            list6 = eSignedData.getRevocationInfoChoices().getCRLs();
        }
        for (ECRL eCRL : list2) {
            if (!list6.contains(eCRL)) {
                eSignedData.addRevocationInfoChoice(new ERevocationInfoChoice(eCRL));
            }
            if (n2 == 0) continue;
        }
        ArrayList arrayList = new ArrayList();
        if (eSignedData.getRevocationInfoChoices() != null) {
            List<EOCSPResponse> list4 = eSignedData.getOSCPResponses();
        }
        for (EOCSPResponse eOCSPResponse : list3) {
            void var8_12;
            if (!var8_12.contains(eOCSPResponse)) {
                eSignedData.addRevocationInfoChoice(new ERevocationInfoChoice(eOCSPResponse));
            }
            if (n2 == 0) continue;
        }
    }

    private void a(Map<String, Object> map) throws CMSSignatureException {
        Asn1ObjectIdentifier asn1ObjectIdentifier = AttributeOIDs.id_aa_ets_contentTimestamp;
        if (this.mSignerInfo.getSignedAttribute(asn1ObjectIdentifier).size() > 0) {
            this._addTSCertRevocationValues(map, asn1ObjectIdentifier, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignaturePolicyIdentifier getSignaturePolicy() {
        int n2 = g;
        if (this.getType() == ESignatureType.TYPE_BES) {
            return null;
        }
        ESignaturePolicy eSignaturePolicy = null;
        try {
            eSignaturePolicy = this.getSignerInfo().getPolicyAttr();
        }
        catch (Exception exception) {
            this.logger.warn(Signer.a(-12485, -15237), exception);
            throw new SignatureRuntimeException();
        }
        if (eSignaturePolicy == null) {
            return null;
        }
        OID oID = new OID(eSignaturePolicy.getSignaturePolicyId().getPolicyObjectIdentifier().value);
        EOtherHashAlgAndValue eOtherHashAlgAndValue = eSignaturePolicy.getSignaturePolicyId().getHashInfo();
        ESigPolicyQualifierInfo[] eSigPolicyQualifierInfoArray = eSignaturePolicy.getSignaturePolicyId().getPolicyQualifiers();
        String string = null;
        String string2 = null;
        ESigPolicyQualifierInfo[] eSigPolicyQualifierInfoArray2 = eSigPolicyQualifierInfoArray;
        int n3 = eSigPolicyQualifierInfoArray2.length;
        int n4 = 0;
        do {
            block13: {
                ESigPolicyQualifierInfo eSigPolicyQualifierInfo;
                block14: {
                    block12: {
                        if (n4 >= n3) return new SignaturePolicyIdentifier(oID, DigestAlg.fromAlgorithmIdentifier(eOtherHashAlgAndValue.getHashAlg()), eOtherHashAlgAndValue.getHashValue(), string, string2);
                        eSigPolicyQualifierInfo = eSigPolicyQualifierInfoArray2[n4];
                        if (!Arrays.equals(eSigPolicyQualifierInfo.getObjectIdentifier().getValue(), _etsi101733Values.id_spq_ets_uri)) break block12;
                        Asn1IA5String asn1IA5String = new Asn1IA5String();
                        eSigPolicyQualifierInfo.decodeQualifier(asn1IA5String);
                        string = asn1IA5String.value;
                        if (n2 == 0) break block13;
                    }
                    if (!Arrays.equals(eSigPolicyQualifierInfo.getObjectIdentifier().getValue(), _etsi101733Values.id_spq_ets_unotice)) break block14;
                    SPUserNotice sPUserNotice = new SPUserNotice();
                    eSigPolicyQualifierInfo.decodeQualifier(sPUserNotice);
                    string2 = ((Asn1UTF8String)sPUserNotice.explicitText.getElement()).value;
                    if (n2 == 0) break block13;
                }
                this.logger.warn(Signer.a(-12506, 22772) + eSigPolicyQualifierInfo.getObjectIdentifier());
            }
            ++n4;
        } while (n2 == 0);
        return new SignaturePolicyIdentifier(oID, DigestAlg.fromAlgorithmIdentifier(eOtherHashAlgAndValue.getHashAlg()), eOtherHashAlgAndValue.getHashValue(), string, string2);
    }

    protected abstract List<IAttribute> _getMandatorySignedAttributes(boolean var1, DigestAlg var2);

    protected abstract void _addUnsignedAttributes(Map<String, Object> var1) throws CMSSignatureException;

    protected abstract void _convert(ESignatureType var1, Map<String, Object> var2) throws CMSSignatureException;

    public abstract Calendar getTime() throws ESYAException;

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[87];
                var3_1 = 0;
                var2_2 = "}u\u00b4\u0014\u009a\u00ee\u0084\u009e2\u00ed\u0080~\u00c8z,\u0000\u0019\u00970\u0099\u001b\u0086\u00f3\u00ae\u007f\u00b4\u000b\u0087\u00de\u00d3\u00e8\u00e1\u00c9:\u0005S,\u00daZn\u0087d+`\u00e7\u00e2\u009c\u00bf\u00bc\u00e0]\u00c2\u009a\u0090\u00e5\u00f3s\u00f8^\u0017\u00f4\u00ac\u00983\u00bd\u0092\u00e2\u00e8_\u00e8\u00d5\u0016\u00e3\u00f5\u0087\u00e3\u001e\u00af\u00c3\u00ef?\u001c\u00e5\u0015\u00ce\\\u00d86@W\u0010\u00ff\u00ab/\u00d91\u00fda2:g\u00ca\u00e8\u0099\u00cf1\u00a4\u008c/\u00f0s\u001c\u00ec\u00c8.\u00f1\u0098Z\u00d1\b\u00b3\u0013S\u00ebj\u00b9\u009b1Pe\u00c7x\u00ae\u0082B\t\u00e2\u00fe%\u00c0^\u00f4x\u0005\u0005\u00e1\u00c8\u008fR^\u00f16g\u00ee/\"\"l\u0012\u00e7\u0089\u0092&\u00d1\u000bO\u009c\u0099\u00b0\u00e0\u0003\u00b7\u0013\u009e\u009d\u00c6\be\u00ach\u0002\u008ag\u00ee>\u00fc\u0084\u0000Y\u0000\u0018\u00f9gi\u0086\u00e6\u00be\u00cbV\u00bf\u00e89\u00c1s\u008e\u009e\u00c8\u009e\u00ec\u00bc\u0092\u00a4\u00e7\u00ce\u0018$\u00be\u00bd@\u00a4c\u0089\u00d9\u00a1E5\u00c9B9\u00f3/\u00d4h\u00ff\u00b4d\u00fcs\u0092\u008eS\u0089h\u009aM\u00f0h{S\u00f8T*o\u001b&gq\u0019\u00b1\\\u00cb\u009d]r7\f\u008bxH\u00be1a\u00a0i\u00c5_D\u00a6\u0088\u00f1Q\u001f\u00da\u00c5\u00fdT'\u00d3\u00e7\u00b1\u00f8Zk\u00dc'\u00eb\u00e2\u009cH\u00f3\u00a0\u00ed\u00a2e\u00aa\u00be\u0095\u00eb\u00b3\u00fcr\u00a4^(\u00c0\u00f71\u00a0\u000e\u00d5\u00c5\u009dj\u00eez(\u009c\u0005\u009b\u00e7\u00d7\u00e1\u00cb\u00c7Q\u00bb \u00a6\u00afF\u000b\u0010\u00a0\u00d2.\u001d\u00eaD\u00be`M\u00bef\u00b6e}X\u008b3\u00ba\u00a8)\u00b4\u00a9\u001a.\u00b6\u0093\u00bc\u00b9\u00f9'\u00ac\u0089\u00e4<6\u0019\u00c0B\u00ab\u00db}t\u009e\u0089\u00e4\u00f7\u00b8)m&],\u00fd)5\\\u00d0\u00be\u00fb\u0092a]}\u0084\u009aU\u0016\u0007\u00cb\u0085\u0096 \u00c3I\u0092M\u0090\u00ea\u009bOV`\u00ca\u00c8\u008f\u0015\u009c\u00ef\"\u00ca\u00be]b^\u00d3\u00b4\u0087\u0080\u00d4\u00d1\u0006x\u00ad\u00f6\u008co\u00a9[\u00b3.\u00a7\u00b7\b\u00bb\u0001R`k\u00fcK9\u0085\u00bf'\u00b0\u00c2@2\u00c3(o\u0088\"\u00aa\u00be\f\u0012W5\u00c9\u00e3\u00f6x\u0099L\u00d2\u009e\u0017\u00f2\u00e4-\u00b5\u00db\u00a02Z\u00ce\u00b5\u00ac\u00ccpv\u00c2\u0019R\u0097\u00c4Y\u00ff\u00f0\u0089\u008b\u0081\u00d8!\u0012S\u0099\u00f3\u00acZ\u000fL\u0016\u0080\u008c1\u00f1\u00b2H\u00aa\u0007\u00c2\u00f33c\u00cb\u00f7\u0016\u008c\u00ff\u001d\u0019\u0005\u0016\u00b1\u0086\u0086\u00fcN\u00a0\u00bf\u00d6\u0095\u009c5J0\u00b6\u000b!m\u0092\u0004\u00c82\u00da41MH\u00be\u0099\u000f*\u00e9\u0087\u001b\u00b3\u00d5f[\u0006\u0013q\u00ab\u00b8\u00cf\u009c\u00ae\u00c6P\u00d8\u0099\u0082\u00a3*\u0007XL\u009c\u00d0\u000e^\u00cc\u00de?\u0010\u0003\u00d0\u00c8)\u00e0m\u009dEi\u000b\t\u00c5w\u00d2%4\u00bd\u0015\u00bb\u00d0\u001dH\u00cf\u00acn\u0086\u00a6\u00cdy\"@65J@\u00ef=\u00ec\u00e3-P;5\u0011d@\u00ca\u008f\u0080g\u00ef\u00e1\n0\u00f7\u00afdGO\u009a\u0083\u0098\u001e\u0004SXs\u0003\u00acF\u00d6~\u00ca.\u0093\u00bd\u00c3~\u00eeuV\u00f9\u009f\u00ba\u00f3\u00c4\u00e7\b\u0086r\u00cd\u00e2.\u0005LA\\\u00bf\u0098\u009c\u000e>Z\u00a89(\u00ab\u00e3\u00d3Ikm\u00dd\u0081%\u000f\u00d6.-8\u0013,\u00bf\u00da\u0086\u001e\u0007\u00c7\u00ec\u00bb=n\u0092mjS\u00ce\u000b\u0002\u00f5-R?\u00cf\u0013\u00ad\u00c2\u00bfT\u00cb\u00ee\u00e4\u00192\u00b8\u0080\u00d3\u00ca3\u00fd\u00cc.\u00fd \u00ed\u0000\u009fZ\u0019\u00a8\u00e0\u0015\u00a2\u00a2U\u00e9\u00f1\u00ac&\u0080m\u00c0\u0001\u00cc\u00e6\u00deQ\u00cd\u000b4eF~\u001a\u00c1F<}r01\u00fb0W\u00d7\u00e1\u00bc\f\u00b1)\u00f6\u00b4\u000f\u00d8TeqT\u00eea#\u008f\u0097\u00eeI^ys\u00d6zl\u00f2\u00d6\u00cf\u00ce\u00f0\u00e5]\u0001\u00f0\u00b1\u0006#i\u00b4\u0081B\u00f6\u000fE\u00f0@c\u00a1{\u00e0\u000e\u0095\u00c0\u00f7\u00ad\u00f3\u00cb\u0003\u00e4\u00e0(\u000b\u009e\u00a7\u00ca\t<\u0088\u0096\u00aa\u0092\u0018nO\u00faN:\u00e0\n1\u00a9\u00d2\u001c$\u0096\u00cc\u00bbtA:\u00d6\u001e8\u001c5\u00d5\u0017+\u0016Gl\u001c\u00db2\u00ea\u00bbr\u00f1D<:\u00c4\u008c<\u008d\u0002\n\u008e\u00e9\u00cb\u0016\u00ba)\u009fw6z\u0083u\u007f\u00fb\u00c6\u009b\u00de\u00c5\u00d4tO=\u00c0\u0001\u00d1\u00e3^\u00cd\u009f.\u0000=\t\u00ce1<d \u000f\u0080\u00b7z9'\u00e1\u00b0\f\u0002i-\u00b8\u00d52\u00df\u0006\u0097r\b\u0019\u008a\u00c9*2\u00b7[\u0099\u00fd\u00d4c6p\u00173\u00e6\u00d3)\u00e5ZA]\u0000z\u000b\tQ\u0007\u0082 \u00c1\u00d5v\u000f\u00b0\u001a\u00ee\u00836\u0002P\u00d9\u0088\u001f\u0000\u00ee\u000b\u008f5\u0096\u00fb\u00c5>tr\u0085b1Mj\u00ff+~\u00e5\u00e4\u00ab\u0007\u00a5\u00f9t\f\u00c31y\u001c\u00f4\u00c34\u00e5\u00ecR\u00ef\u00b2\u00ed R/\u00c9+3=\" J\u00c0\u00a7'\u008d3\u0004I+\u00c0\u0013#\u00f0\u00cc\t\u00d8\u00f6\u00b2\u00bc\u00a1v\u00fe\u00b6n\u001aPC\u00aa\u00f7Q\u00ee\u001b\u0018M\u0002\n!\u009c&P\u0081\u00c8R_\u00cd{2\u00e2\u00b6\u00ec\u00fc\u00c4\u009a\u001d\u00e7\u00ebC\u000e\u00f2!K\u0082\u00a2\u00b4\u0086>\u00e3>4Fn\u0012EYk>\u00cb\f\u009dS\u001bY\u009ac\u00d2\u0084\u0080\u00ca\"\u0014\b\u008b\u00ef\u00a7\u0095\u00d62s6\u0086\\\u007fN0+\u00aa\u009b\u00c2FN\u009d\u0087\u00b5\u0018\u00f6\u00b0\u00b7r\u0002v\u0019\u00de\u00a4y\u00e8\u00d2\u00c9\u00edc6\u00c6H={|\u00ff\u0012\u0018\u00a3\u00cd\u001a\u00dc\u0018VG]\u00fb\u00c0b\u00b3\u00da\u009c\u0083\u009e/F\u00f5\u00c5\u00d9\u00ef-\u00b2G\u0015\u0010\u00b9 \"\u0081U6\u0011q~G\u00bf*\u00d3\u0084\u00e1\u00d2\u00bc\u00a8\u00ff\u00d4\u0098gW\u00ef\u00a5V\u0007%(N\u00da\u00e4\u00af6\u00d0\u0001q\u000e\u001f6\u00f8u\u0014\u00f1\u00a9\u0001\u00fc\u00829\u009b\u00c3\u00a1h\u0002\u008eDd}\u0013\u00d0\u009f\f\u00d7@qF\u00a9\u00ad\u00ea%4L\u0018\b\u00f3\u000e\u00d9pR\u0013h]\u00c4\u001d%\u00f85\u0007\u00b3I\u00d9\u00b6[e\u00b9!\u0091\u0098\u00de\u00be\u008d}(7`\u00cc\u007f\u00d0C#e\u0093\u00b1\u00dd\u00ba\u0015\u0001\u00a2q\u00a9^\u0016\u0018\u00d7\u00a8\u0089}\u00ce\u00aej\u00fc\u00ebV\u00be\u00aef\u0094U\u00c8\u0086\u00dc\u00d0\u00b8\u00ccU\u00fe(\u00c2.\u00d5z\u00e8i\u00caL\u00d3\u00f9-\u00e7[\u00aa\u0001\u009eN\u00c4M],\u001aI\u008f\u009c\u00fa\u00bf\u00c5\u00f2\u008e\u00c9\u00b7A9\u0093\u00dd+~\u00b3\u00b8UReN\u00eb\u008a\u009cD\u00cb\u00f1\u00d4\u0012:\u00af\u0093C\u0016\u0081\u00de\u00af\u00bacU\u00ee\u00e1n\u00d4\u0097\u00fe\u00c6\u0087o\u0099-\u00df\u00d6\u00ffwm%AL,<p\u0018q\u00fe8\u00fb\u00c6\u00f4\u0096\u0019\u00b7\u00fcf\u00f6$@\u0005\u00f8\u00af\u00b8D~\u0095\u00ed\u008dt\u00073\u00bb\u00f7o\u00ebD\ts\u00b9\u007f\u008c\u00af\u00dc\u00c9\u00d7\u000e\u001dUn\u00bb|+\u0089\u00cau\u00fek\u00be7D\u0099\u00ebL;k\u009d52ZYm\u0092C\u0010\u0000\u00ea\u001b[\u0015\u00d5\u00c7\u00ecy\u00e0\u0085\u00d9\u00d0\u008d\u00ee\u009bsX!\u00ba!/\u00b7t\u000eO\u00e4\u00ce\u00d3sX\u000fP\u00e7\u00acRa\u001f\u0096\u00e0'\"\u00ef\u001d\u00caX\u0004\u00e5S\u00bcp\u00d0\u00ef\u0018\u000b+\u0001\u00d6\u00f2W\u00f8V\u00f3g(F\u009cP\u00f6 \u00adM\u0019\u0090.\u00e5\u00d8\u0013\u0097\u00cc\u00b7\u00a3\u00f0\u00d2\u00b0\u00aeCok\u0018S\b36\u009d\u009b]\u00a0\u00ab\u000e2 D\u00f2\u00b9,\u00ec\u0015\u0000E\u00e1fR\u00a9B\u00bfI\u00a6\u009c\u000eD\u009f\u00cdF\u00b4\u00b6\u00ebK\u00fd\u00dd\u00a8 \u00d3\u001d\u001a%&\u00a0q\u00e1\u00b1C\u00cb~Q\u001e!\u0085\u0014\u0096*\u0012\u00d4\u0093\u00d4\u00c7\u00e4\u0003d\u00a0g\u001f:\u007f\u00d8\u008e\u008d\u00d331\u00d5\u00ce\u00e0\u00b7.\u00f9\u00f0\u00c2]\u00cf,\u00d9'Gn\u00d0\u00be\u00e5\u00cc/\u00a71\u0010\u001eS\u00ca}\u00f53\u0017\u0014\u009dUp\u00dc\u00bd\u00d97\u00c9\u008e\u00f8\u00b6\u00e2\u0085S\u0015]\u00fbss\u001c\u00b1 \u0094H \u00a8\u0086\u00f9.\u00a5\u0090\u00f2\u0005\u00b0\u000ehR\u0087+\u008fe\u0015\u00de9\u00a3G\u00bf\u00ec\u009b\u00e9\u00e4w\u00ec\u00e8|\t\u00ef\u0088n\u00a7\u0015\n\u00b0\u0081*\u0001\u00f8$\u00bb\u001fw\u00f7\u008a\u00bb9\u0091<;L$\u00a4\u00028W\u0006\u00d3\u009b\u00f1\u0099X2G\u0010\u0098\u0095G\u001anKn\b\u0010\u0003\u00c1%\u00fa\u00c6\u0019_\u00b3f\u00e0\u00ea\u00c2c\u00c5\u00b9:Q\u00b2J\u00d0\u00db8J>\u00c8\u00a6\u00dc\u00d68\u008c\u00ba\u00c7\u00bf\u008dq\u00c7a(\u0015\u001f9\u0086sI\u0081\u0002\u00bc\u00b2\u008a0\u00cc\u0086-\u00c7>>\u00d0\u009a\u00de?[\u0089\u00ae#\u00a6,T,\u00e0w\u0098\u0018w\u00dc\u00966\u00d3w\u001eu~\u00f8c\u0095\u0015\u00c4\u0097Y\u00b7\u0011\u00f9s\u0010[\u00d3&[\u00c2\u0018q}8\u00e6IQ\u00d6\u00fd\u008b\u00bds\u0013\u00d9f\u008e9NX4\u001d\u00a2b\u00c8\u000et8\u00b7\u00b6\u00ce`_I:[\u00bb&w\u00e1\u00ae\u001d%\u0085\u0002\\\u00d8\u00d2\u0018\u0091\u0007^\u0094\\\u00d8\u00fb\u001d\u009e\u00b6\u00a1\r\u00b96nl\u0004\u00e9V*\u008e\u0096\u00d7\u00b1\u00887\u0080\u00dd\u00f2\u0007\u00120-\u00d8\u00f8\u00b4\u008f\u00faUY\u00a9d\u009e3*;i\u00a0J\u0097\u00bdF\u009fR\u0097(\u0081s^\u00ad\u00bdl\u00cc\u00c5\u00c6\u009c\u0093m\u00e5\u0098\u00bcP\r\u00cb[A\u0089\"\n!\u00e7H\u00e3\u00b2\u00ff\u0006G9\u00fc\u0091\"i\u00d59\u00b3\u001b5\u00de\u00fdJ\u00a7\\][\u0007\u00bf&\u00b0_\u0007\u0003\u009d\u00c9\u001es\u00f5#\u0093\u008c\u0086\u00b8\u00ae\u0004\u009c?_\u00c1^\u009e\u00a9t\u00b3# \u00d5\u0095N\u0090c\u00e0\u00ebj\u001f\u008c\u001bn\u00b1Q\u00bbf\u001c\u00de\u00e6\u0085\u0099\u008a<\u0004\u00aed\u00d3:&\u00ca3\u008d4\u00c6e\u00d0\u00a52\u001a\u00c1\u00acu\u00cd\u008d\u00f3gc\u00e1%r)\u00b1\u00f2g\\\rW\u00cf\u008f\u00d6`\n.\u00ef1n=\u0015\u00a8@\u0083\u00f2\u009d\u00aa\u00a5\u00e0\u00b5\u00b0\u00b4\u00d5\u00dcy\u0011Nf\u00cc\u00f4t\u00f9V4\u00cc\u009b\u00df\u00ea\u00148\u000eh\u0090)\u000f\u0088\u00be\u00ef\u00cf\u00e8F\u00bc\u00fb\u00ca\u00a3Q\u0002\u00f1\u00e7\u0098}\u00ba\u00e3\u00a4\u0019Y\u00c0\u00ba\u0013\u0013+^*fz\u000fU\u000eW\u0094\u00d9\u00a5\u00a1\u0084\u00db\u00014\u00fc\u00ad\\r~\u00d4\u00d3_\u0010D\u0088\u0099M\"b\u0082$\u0095\u009d\u000e\u00cd\u0086\u00f0\u00ed\u0086W\u00b2\u001b\u0011N\u0019\u00c4\u0016-\u001b\u00a5\u00d2\u00cfM\u00db\u00dd\u00a3\u001d\u00f6\u00f2\u00c8]N\u0000=\u00f9\u00e4\u001f\u009a\u0011\u0017\u00c1\u00f0>\u00b8i\u00e3x\u00c6\f-\u00bf\u00ae\u00ae\u00e2.\u0001+\u00f3ed\u00ebm\u007fN\u00b1L{\u00a4\u0087`\u00d9r.\u0006\u00ac-\u00a3\u0011\u008a{\u00b3\u00b0D@9\u0099\u00d3\u0011\u00d4\u00d6\u00cck\b\u0090.\u0094\u00cf\u0090KQ\u00a2\u008eHT\u00b2D\u00fe\u0092\u00f4\u0091u\u00fa\u00fc\u009a\u000b\u0016[\u00cd>\u0090#\u0014\u00d2\u008d\u0096da\u00a5\u008a}\u0092\u00cb\u00e3-\u00ebV\u0085\u00c3\u00d9h\u00deO\u0018\u0086\u00faGL\u0083\u0094\u00db\u0004\u0091X?Tr\u009aC4?\u0090\u00a8\u00f0V\u00e6\u00d1\u00fe\u0018l\u00d5\u0096\u0000\u00del\f\u00ce#\u00e7\u00ae.\u009f@I\u008e\u00d0\u00da\u0082\u0092\u00ba{\u001b\rm\u00b6\u00df\u00d0@\u00adT\u00dc\u00faY{\u00ea\u00f4\u001f\u001e\u0011\u00ab\u00e3\u0012\u0081\u00063\u008f\u00cdBV\u0080 \u00cf)\r\u008f\u00846\u00fb\u00d4\u00eaQYF__\u00a1\u009b2\u0092S \u00b1\u0089\u00a1h\u009e\u00c4\u00b7N\u00e1\u008d\u00ef\u00b7\u009e\u0084\u00d2\u0001a\u00c2\u0090\u0016\u00cc\u00ef\u0084\u00b6\u00b2\u0092:\u00f6F\u00ddj\u001b\u00a3\u00eav:\u00cbfd\u00e1w\u00b6\u00bc}j\u00d0?\u00f8\u00a7B\u00dex\u0005P\u0084An\u00bf\u00f8\u00f7\\d\u00125\u00ec\u00b0 \u00b8\u009e\u0015\u00b6JA\u00f1#\u000bgR.j\u0016\u0004\u00af\u00abt\u0088E\u00e2\u00b3I\u00d0\u00e2\u00fe\u008ew\u00e2\u0017\u0014cj\u00b6\u0017\u00e4\u00af\u00d0\u00fc\u00f4I\u00f6\u000b^\u00c8\u00bb\u00f1\u00ed\u0091x\u00ed\u00ed\u0011C\u00b5]\u00a0\u00feZ\u00d9\u00a3{\u00c7\u0006\u009c4\u00ab\u00dfe|\u000e\u00f3<\u00aa0\u000f\u008dK?\u008c\u0095J\"\u00d4\u00a3{\u00ba\u00012\u0011\u00df\u0017\u00f9W\u0004y\u00e1A\u00d8\u00dd%\u00b0\u00f5;^ey\u0018\u0010\u0086T\u00baA9?\u00a4,\u00fd\u00e6V\u00b4\u0096\u00d2\u001d\\I\u00f8\u00fc\u00bc\u00fe1I0\u00e6L\u00dc8\u00e0\u0010>v\u001fha\\:\u0088\u0010\u00ba\u00f6\u00ae\u009d\u00f5\u00b5L\u00dd^\u00be\u00e2D\u00f3|D+@\u00a9\u00e3\u008e\u00b62\u00b4PE\u00e7\u00b3\u00a3\u0007!*2\u00aa]\\;\u008d\u00c1\u001f\u00cc\u00b6#\u00d5\u0091\u00849\u00c9\u0010\u00c2_\u00b68\u00d6\u001d\u009dB\u00b1\u00be\u001e\u00b7p$\u0083\"\u00cc\u00a84C-\u00e3O\u0007\u00e2\u0012A5\u00b5AW\u00f0\u0092\u00af\u008f~\u00c1\u00a8\u009f\\\u00f8{%j\u00e7\u00a6\u00bf\u00e6\u00f4~>!N&\u00a5\u00dc\u00fb0\u00d2\u00ffB\u00ccH4\u00d0\u00ea49P0X\u00c3\u00d9\u00dc[\u00e2\u00ab\u0004\u00c8\u0011\u00bdFp\u00ab~\u0007\u0012\u00bf.\u00b5\u00e1c\u00ce\u00cc/\u00f9<%*\u0095\u0013\u00d8\u00a9u\"\r\u008b\u00f0\u008cn\u00b2\u001eCh\u001be\u009c\u00b9&\u0091\u00a4\u0085\u0015\u0013VK\u00b4\u007f\u00df\u00a1q\u00c0\u000f(\u00d0H\u0017^`'\u00f2~\u000b\u0089x\u00caa\u009cF\u008eS\u00f5\u0084\u0010\u00ee\u0091(s\u00cej\u00b59!mT\u00abka\r\u00852\u0006\u009e>\u00c1\u0007\u0004\u00d1=>\u0003\\`\u009fh\u00b8p1\u00ae\u00d6\u0089cG\u0004\u000e\u009b\u00c8\u00c7cs\u0086\b\u00d1Ml\u00d9\u001ao\u0013\u00cb\u00b0\u00daw\u0086\u00ec\u0013\u00d8\u00a0yR\u00a8\u00da\u008b\u00c2<q\u00e6\u008e\u001b\u00fd\u00f8x|\u007f\u00fd2\u00e0*^a\u000e\u00faG46\u00d0\u00ac\u00d5\u00fd|\u00eb\u00bf\u0000\u00135ql\u00b1j2\u00f8\u00b3\u0080\t\u00ed7\u0099'\u00b8\u00aa\u00900\u00cd\u0096\u00d0:\u0084\u00c6`\u00d7\u00abK\u001ct\u00a1\u00b1\u00fd\u0080\u0002K\u00d1q/\u0087Jo)^\u00f7FXt\u00e7#\u00aa\u00cf\u00de\u0013\u00a0i\u00e60\u00ab\u009b\u0092\u0092\u008a*\u00e0\u0098\u0097#\u0095\u00c3\u00e8I\u00baH\u008c\u009d\u00fc_\u0005nT\u0099<>WP\u00d5Uu\u00acQ\u00f5Adq'\u00ba\u008c\u00ec\u00c7\u00e9y\u00bd\u0015\u00b6\t\u00c1\u0000\u00c5!\u007fgWdY\u0089\u00b3\u00d3\u0002\u0095\u0090\u001c\u0010\u0004c2/\u008dt\u008a\u00a5\u0015\u00d8\u009d\u0002\u0017L\u00eb\u00b7=\u00d7W\u00dcLw\u0011\u00c8\u0005j;(\u00f9\u0015,+*\u009c\u007f\u00145\u009e\u00ae\u00b1\u00943\u00bb\u00f5\u00d8J!\u00ed\u00ecqw\u0087V\n\u008b5\u00e6\bn:O\u00a8\u00b5\u008fE\u00b41\u00a1kxd\u00e1ZTi\n\u0084/b\u00ee\u00b8\u0092\u009cS\u00b8o\u00a8Xr\u008dEN\u0016\u00fa\u008bD\u00cb\u0084\u0015G\u00e1J\u0002\u008f\u00947\u00d5k\u00acL\u0018\u008d\u00c3c)\u000eE:\u00b3\u00f4}\u00c1\u0084\u0007YB\u008d\u0083U\u00a2\u000e-4\u00b4=\u00d6\u00ea\u00e6\u0011\u00eb\u00f2\u00b7\u0096\u00c7\u001b>\u0086\u00a7p\u00bd\u00e6E\u007f\u00feR\u0089\u00b0Y\u00d3\u00ffL\u00a6\u00b9\u001c\u00ac \u00cf\u0089\u00c4\u0096\u00e5nHR#\u0006\u00ff\u00a3\u00be;d\u00e5(^\u0092\u00d6e\u009a\u001c{\u00bd\u00c4\u0010\u001a\u00ba\u00ad\u00dc;f\u0088\u00ef\u00c2\u00ee\u00e0]\u0014\u0093\u00b5\"\u0084<\u0096<e\u00db\u00c5\u000bzE\u008e3\u0093\u00e6\u0080\u00b4\u00d1\u00f1\u00c7z\u00fb\u0000\u00d4\u00b3u\u00beD\b\u00a5\u00f5\u001e\u009b\u0004\u0018\u0016<_\u0087Z\u008b\\S\u00ff\u00b2Y\u00d4z\u008cL\u00c6\",\u00bd\u00c6\u0097\u00de\u00004Q\u00c2*\u00e9>*\u00e51d\u0080\u000eA\u00d7+\u00ad\u00ceA k$kv\u0006\u0019\u00c5\n+\u00ee\u0091\u00e7\u00964\u001elj5\u00b0\u00e5\u0081;\u0006\u00d8u|>\u0092\u00ec\u00ce4\u00bbg\u0098\u001b\u00de\u00c0e}\u00fa.\"o\u0081\u008d\u0086E\u00fa\u0006t\u008f?\u00f4\u009f\rbY\u008d\u000e\u0096\u008ex%\u007f\u00b2\u00eb\u00e3\u0088\u00e3n\u0081\u00db\u0014\u00ba\t\u0019\u00a6F\u000bX\b\u00e3\u009f\u00fd\u0003\u00b0\u00c7\u00a7\u0091\u00e9\u0010\u0002\u00cb\u00f6\u00c4\u0085\t\u00a84\u00bc\u0011\r`fo\u00bc\u009fJ\u00ac%\u00d7\u0080/\u00e2E\u00aa\u00c8\u008c";
                var4_3 = "}u\u00b4\u0014\u009a\u00ee\u0084\u009e2\u00ed\u0080~\u00c8z,\u0000\u0019\u00970\u0099\u001b\u0086\u00f3\u00ae\u007f\u00b4\u000b\u0087\u00de\u00d3\u00e8\u00e1\u00c9:\u0005S,\u00daZn\u0087d+`\u00e7\u00e2\u009c\u00bf\u00bc\u00e0]\u00c2\u009a\u0090\u00e5\u00f3s\u00f8^\u0017\u00f4\u00ac\u00983\u00bd\u0092\u00e2\u00e8_\u00e8\u00d5\u0016\u00e3\u00f5\u0087\u00e3\u001e\u00af\u00c3\u00ef?\u001c\u00e5\u0015\u00ce\\\u00d86@W\u0010\u00ff\u00ab/\u00d91\u00fda2:g\u00ca\u00e8\u0099\u00cf1\u00a4\u008c/\u00f0s\u001c\u00ec\u00c8.\u00f1\u0098Z\u00d1\b\u00b3\u0013S\u00ebj\u00b9\u009b1Pe\u00c7x\u00ae\u0082B\t\u00e2\u00fe%\u00c0^\u00f4x\u0005\u0005\u00e1\u00c8\u008fR^\u00f16g\u00ee/\"\"l\u0012\u00e7\u0089\u0092&\u00d1\u000bO\u009c\u0099\u00b0\u00e0\u0003\u00b7\u0013\u009e\u009d\u00c6\be\u00ach\u0002\u008ag\u00ee>\u00fc\u0084\u0000Y\u0000\u0018\u00f9gi\u0086\u00e6\u00be\u00cbV\u00bf\u00e89\u00c1s\u008e\u009e\u00c8\u009e\u00ec\u00bc\u0092\u00a4\u00e7\u00ce\u0018$\u00be\u00bd@\u00a4c\u0089\u00d9\u00a1E5\u00c9B9\u00f3/\u00d4h\u00ff\u00b4d\u00fcs\u0092\u008eS\u0089h\u009aM\u00f0h{S\u00f8T*o\u001b&gq\u0019\u00b1\\\u00cb\u009d]r7\f\u008bxH\u00be1a\u00a0i\u00c5_D\u00a6\u0088\u00f1Q\u001f\u00da\u00c5\u00fdT'\u00d3\u00e7\u00b1\u00f8Zk\u00dc'\u00eb\u00e2\u009cH\u00f3\u00a0\u00ed\u00a2e\u00aa\u00be\u0095\u00eb\u00b3\u00fcr\u00a4^(\u00c0\u00f71\u00a0\u000e\u00d5\u00c5\u009dj\u00eez(\u009c\u0005\u009b\u00e7\u00d7\u00e1\u00cb\u00c7Q\u00bb \u00a6\u00afF\u000b\u0010\u00a0\u00d2.\u001d\u00eaD\u00be`M\u00bef\u00b6e}X\u008b3\u00ba\u00a8)\u00b4\u00a9\u001a.\u00b6\u0093\u00bc\u00b9\u00f9'\u00ac\u0089\u00e4<6\u0019\u00c0B\u00ab\u00db}t\u009e\u0089\u00e4\u00f7\u00b8)m&],\u00fd)5\\\u00d0\u00be\u00fb\u0092a]}\u0084\u009aU\u0016\u0007\u00cb\u0085\u0096 \u00c3I\u0092M\u0090\u00ea\u009bOV`\u00ca\u00c8\u008f\u0015\u009c\u00ef\"\u00ca\u00be]b^\u00d3\u00b4\u0087\u0080\u00d4\u00d1\u0006x\u00ad\u00f6\u008co\u00a9[\u00b3.\u00a7\u00b7\b\u00bb\u0001R`k\u00fcK9\u0085\u00bf'\u00b0\u00c2@2\u00c3(o\u0088\"\u00aa\u00be\f\u0012W5\u00c9\u00e3\u00f6x\u0099L\u00d2\u009e\u0017\u00f2\u00e4-\u00b5\u00db\u00a02Z\u00ce\u00b5\u00ac\u00ccpv\u00c2\u0019R\u0097\u00c4Y\u00ff\u00f0\u0089\u008b\u0081\u00d8!\u0012S\u0099\u00f3\u00acZ\u000fL\u0016\u0080\u008c1\u00f1\u00b2H\u00aa\u0007\u00c2\u00f33c\u00cb\u00f7\u0016\u008c\u00ff\u001d\u0019\u0005\u0016\u00b1\u0086\u0086\u00fcN\u00a0\u00bf\u00d6\u0095\u009c5J0\u00b6\u000b!m\u0092\u0004\u00c82\u00da41MH\u00be\u0099\u000f*\u00e9\u0087\u001b\u00b3\u00d5f[\u0006\u0013q\u00ab\u00b8\u00cf\u009c\u00ae\u00c6P\u00d8\u0099\u0082\u00a3*\u0007XL\u009c\u00d0\u000e^\u00cc\u00de?\u0010\u0003\u00d0\u00c8)\u00e0m\u009dEi\u000b\t\u00c5w\u00d2%4\u00bd\u0015\u00bb\u00d0\u001dH\u00cf\u00acn\u0086\u00a6\u00cdy\"@65J@\u00ef=\u00ec\u00e3-P;5\u0011d@\u00ca\u008f\u0080g\u00ef\u00e1\n0\u00f7\u00afdGO\u009a\u0083\u0098\u001e\u0004SXs\u0003\u00acF\u00d6~\u00ca.\u0093\u00bd\u00c3~\u00eeuV\u00f9\u009f\u00ba\u00f3\u00c4\u00e7\b\u0086r\u00cd\u00e2.\u0005LA\\\u00bf\u0098\u009c\u000e>Z\u00a89(\u00ab\u00e3\u00d3Ikm\u00dd\u0081%\u000f\u00d6.-8\u0013,\u00bf\u00da\u0086\u001e\u0007\u00c7\u00ec\u00bb=n\u0092mjS\u00ce\u000b\u0002\u00f5-R?\u00cf\u0013\u00ad\u00c2\u00bfT\u00cb\u00ee\u00e4\u00192\u00b8\u0080\u00d3\u00ca3\u00fd\u00cc.\u00fd \u00ed\u0000\u009fZ\u0019\u00a8\u00e0\u0015\u00a2\u00a2U\u00e9\u00f1\u00ac&\u0080m\u00c0\u0001\u00cc\u00e6\u00deQ\u00cd\u000b4eF~\u001a\u00c1F<}r01\u00fb0W\u00d7\u00e1\u00bc\f\u00b1)\u00f6\u00b4\u000f\u00d8TeqT\u00eea#\u008f\u0097\u00eeI^ys\u00d6zl\u00f2\u00d6\u00cf\u00ce\u00f0\u00e5]\u0001\u00f0\u00b1\u0006#i\u00b4\u0081B\u00f6\u000fE\u00f0@c\u00a1{\u00e0\u000e\u0095\u00c0\u00f7\u00ad\u00f3\u00cb\u0003\u00e4\u00e0(\u000b\u009e\u00a7\u00ca\t<\u0088\u0096\u00aa\u0092\u0018nO\u00faN:\u00e0\n1\u00a9\u00d2\u001c$\u0096\u00cc\u00bbtA:\u00d6\u001e8\u001c5\u00d5\u0017+\u0016Gl\u001c\u00db2\u00ea\u00bbr\u00f1D<:\u00c4\u008c<\u008d\u0002\n\u008e\u00e9\u00cb\u0016\u00ba)\u009fw6z\u0083u\u007f\u00fb\u00c6\u009b\u00de\u00c5\u00d4tO=\u00c0\u0001\u00d1\u00e3^\u00cd\u009f.\u0000=\t\u00ce1<d \u000f\u0080\u00b7z9'\u00e1\u00b0\f\u0002i-\u00b8\u00d52\u00df\u0006\u0097r\b\u0019\u008a\u00c9*2\u00b7[\u0099\u00fd\u00d4c6p\u00173\u00e6\u00d3)\u00e5ZA]\u0000z\u000b\tQ\u0007\u0082 \u00c1\u00d5v\u000f\u00b0\u001a\u00ee\u00836\u0002P\u00d9\u0088\u001f\u0000\u00ee\u000b\u008f5\u0096\u00fb\u00c5>tr\u0085b1Mj\u00ff+~\u00e5\u00e4\u00ab\u0007\u00a5\u00f9t\f\u00c31y\u001c\u00f4\u00c34\u00e5\u00ecR\u00ef\u00b2\u00ed R/\u00c9+3=\" J\u00c0\u00a7'\u008d3\u0004I+\u00c0\u0013#\u00f0\u00cc\t\u00d8\u00f6\u00b2\u00bc\u00a1v\u00fe\u00b6n\u001aPC\u00aa\u00f7Q\u00ee\u001b\u0018M\u0002\n!\u009c&P\u0081\u00c8R_\u00cd{2\u00e2\u00b6\u00ec\u00fc\u00c4\u009a\u001d\u00e7\u00ebC\u000e\u00f2!K\u0082\u00a2\u00b4\u0086>\u00e3>4Fn\u0012EYk>\u00cb\f\u009dS\u001bY\u009ac\u00d2\u0084\u0080\u00ca\"\u0014\b\u008b\u00ef\u00a7\u0095\u00d62s6\u0086\\\u007fN0+\u00aa\u009b\u00c2FN\u009d\u0087\u00b5\u0018\u00f6\u00b0\u00b7r\u0002v\u0019\u00de\u00a4y\u00e8\u00d2\u00c9\u00edc6\u00c6H={|\u00ff\u0012\u0018\u00a3\u00cd\u001a\u00dc\u0018VG]\u00fb\u00c0b\u00b3\u00da\u009c\u0083\u009e/F\u00f5\u00c5\u00d9\u00ef-\u00b2G\u0015\u0010\u00b9 \"\u0081U6\u0011q~G\u00bf*\u00d3\u0084\u00e1\u00d2\u00bc\u00a8\u00ff\u00d4\u0098gW\u00ef\u00a5V\u0007%(N\u00da\u00e4\u00af6\u00d0\u0001q\u000e\u001f6\u00f8u\u0014\u00f1\u00a9\u0001\u00fc\u00829\u009b\u00c3\u00a1h\u0002\u008eDd}\u0013\u00d0\u009f\f\u00d7@qF\u00a9\u00ad\u00ea%4L\u0018\b\u00f3\u000e\u00d9pR\u0013h]\u00c4\u001d%\u00f85\u0007\u00b3I\u00d9\u00b6[e\u00b9!\u0091\u0098\u00de\u00be\u008d}(7`\u00cc\u007f\u00d0C#e\u0093\u00b1\u00dd\u00ba\u0015\u0001\u00a2q\u00a9^\u0016\u0018\u00d7\u00a8\u0089}\u00ce\u00aej\u00fc\u00ebV\u00be\u00aef\u0094U\u00c8\u0086\u00dc\u00d0\u00b8\u00ccU\u00fe(\u00c2.\u00d5z\u00e8i\u00caL\u00d3\u00f9-\u00e7[\u00aa\u0001\u009eN\u00c4M],\u001aI\u008f\u009c\u00fa\u00bf\u00c5\u00f2\u008e\u00c9\u00b7A9\u0093\u00dd+~\u00b3\u00b8UReN\u00eb\u008a\u009cD\u00cb\u00f1\u00d4\u0012:\u00af\u0093C\u0016\u0081\u00de\u00af\u00bacU\u00ee\u00e1n\u00d4\u0097\u00fe\u00c6\u0087o\u0099-\u00df\u00d6\u00ffwm%AL,<p\u0018q\u00fe8\u00fb\u00c6\u00f4\u0096\u0019\u00b7\u00fcf\u00f6$@\u0005\u00f8\u00af\u00b8D~\u0095\u00ed\u008dt\u00073\u00bb\u00f7o\u00ebD\ts\u00b9\u007f\u008c\u00af\u00dc\u00c9\u00d7\u000e\u001dUn\u00bb|+\u0089\u00cau\u00fek\u00be7D\u0099\u00ebL;k\u009d52ZYm\u0092C\u0010\u0000\u00ea\u001b[\u0015\u00d5\u00c7\u00ecy\u00e0\u0085\u00d9\u00d0\u008d\u00ee\u009bsX!\u00ba!/\u00b7t\u000eO\u00e4\u00ce\u00d3sX\u000fP\u00e7\u00acRa\u001f\u0096\u00e0'\"\u00ef\u001d\u00caX\u0004\u00e5S\u00bcp\u00d0\u00ef\u0018\u000b+\u0001\u00d6\u00f2W\u00f8V\u00f3g(F\u009cP\u00f6 \u00adM\u0019\u0090.\u00e5\u00d8\u0013\u0097\u00cc\u00b7\u00a3\u00f0\u00d2\u00b0\u00aeCok\u0018S\b36\u009d\u009b]\u00a0\u00ab\u000e2 D\u00f2\u00b9,\u00ec\u0015\u0000E\u00e1fR\u00a9B\u00bfI\u00a6\u009c\u000eD\u009f\u00cdF\u00b4\u00b6\u00ebK\u00fd\u00dd\u00a8 \u00d3\u001d\u001a%&\u00a0q\u00e1\u00b1C\u00cb~Q\u001e!\u0085\u0014\u0096*\u0012\u00d4\u0093\u00d4\u00c7\u00e4\u0003d\u00a0g\u001f:\u007f\u00d8\u008e\u008d\u00d331\u00d5\u00ce\u00e0\u00b7.\u00f9\u00f0\u00c2]\u00cf,\u00d9'Gn\u00d0\u00be\u00e5\u00cc/\u00a71\u0010\u001eS\u00ca}\u00f53\u0017\u0014\u009dUp\u00dc\u00bd\u00d97\u00c9\u008e\u00f8\u00b6\u00e2\u0085S\u0015]\u00fbss\u001c\u00b1 \u0094H \u00a8\u0086\u00f9.\u00a5\u0090\u00f2\u0005\u00b0\u000ehR\u0087+\u008fe\u0015\u00de9\u00a3G\u00bf\u00ec\u009b\u00e9\u00e4w\u00ec\u00e8|\t\u00ef\u0088n\u00a7\u0015\n\u00b0\u0081*\u0001\u00f8$\u00bb\u001fw\u00f7\u008a\u00bb9\u0091<;L$\u00a4\u00028W\u0006\u00d3\u009b\u00f1\u0099X2G\u0010\u0098\u0095G\u001anKn\b\u0010\u0003\u00c1%\u00fa\u00c6\u0019_\u00b3f\u00e0\u00ea\u00c2c\u00c5\u00b9:Q\u00b2J\u00d0\u00db8J>\u00c8\u00a6\u00dc\u00d68\u008c\u00ba\u00c7\u00bf\u008dq\u00c7a(\u0015\u001f9\u0086sI\u0081\u0002\u00bc\u00b2\u008a0\u00cc\u0086-\u00c7>>\u00d0\u009a\u00de?[\u0089\u00ae#\u00a6,T,\u00e0w\u0098\u0018w\u00dc\u00966\u00d3w\u001eu~\u00f8c\u0095\u0015\u00c4\u0097Y\u00b7\u0011\u00f9s\u0010[\u00d3&[\u00c2\u0018q}8\u00e6IQ\u00d6\u00fd\u008b\u00bds\u0013\u00d9f\u008e9NX4\u001d\u00a2b\u00c8\u000et8\u00b7\u00b6\u00ce`_I:[\u00bb&w\u00e1\u00ae\u001d%\u0085\u0002\\\u00d8\u00d2\u0018\u0091\u0007^\u0094\\\u00d8\u00fb\u001d\u009e\u00b6\u00a1\r\u00b96nl\u0004\u00e9V*\u008e\u0096\u00d7\u00b1\u00887\u0080\u00dd\u00f2\u0007\u00120-\u00d8\u00f8\u00b4\u008f\u00faUY\u00a9d\u009e3*;i\u00a0J\u0097\u00bdF\u009fR\u0097(\u0081s^\u00ad\u00bdl\u00cc\u00c5\u00c6\u009c\u0093m\u00e5\u0098\u00bcP\r\u00cb[A\u0089\"\n!\u00e7H\u00e3\u00b2\u00ff\u0006G9\u00fc\u0091\"i\u00d59\u00b3\u001b5\u00de\u00fdJ\u00a7\\][\u0007\u00bf&\u00b0_\u0007\u0003\u009d\u00c9\u001es\u00f5#\u0093\u008c\u0086\u00b8\u00ae\u0004\u009c?_\u00c1^\u009e\u00a9t\u00b3# \u00d5\u0095N\u0090c\u00e0\u00ebj\u001f\u008c\u001bn\u00b1Q\u00bbf\u001c\u00de\u00e6\u0085\u0099\u008a<\u0004\u00aed\u00d3:&\u00ca3\u008d4\u00c6e\u00d0\u00a52\u001a\u00c1\u00acu\u00cd\u008d\u00f3gc\u00e1%r)\u00b1\u00f2g\\\rW\u00cf\u008f\u00d6`\n.\u00ef1n=\u0015\u00a8@\u0083\u00f2\u009d\u00aa\u00a5\u00e0\u00b5\u00b0\u00b4\u00d5\u00dcy\u0011Nf\u00cc\u00f4t\u00f9V4\u00cc\u009b\u00df\u00ea\u00148\u000eh\u0090)\u000f\u0088\u00be\u00ef\u00cf\u00e8F\u00bc\u00fb\u00ca\u00a3Q\u0002\u00f1\u00e7\u0098}\u00ba\u00e3\u00a4\u0019Y\u00c0\u00ba\u0013\u0013+^*fz\u000fU\u000eW\u0094\u00d9\u00a5\u00a1\u0084\u00db\u00014\u00fc\u00ad\\r~\u00d4\u00d3_\u0010D\u0088\u0099M\"b\u0082$\u0095\u009d\u000e\u00cd\u0086\u00f0\u00ed\u0086W\u00b2\u001b\u0011N\u0019\u00c4\u0016-\u001b\u00a5\u00d2\u00cfM\u00db\u00dd\u00a3\u001d\u00f6\u00f2\u00c8]N\u0000=\u00f9\u00e4\u001f\u009a\u0011\u0017\u00c1\u00f0>\u00b8i\u00e3x\u00c6\f-\u00bf\u00ae\u00ae\u00e2.\u0001+\u00f3ed\u00ebm\u007fN\u00b1L{\u00a4\u0087`\u00d9r.\u0006\u00ac-\u00a3\u0011\u008a{\u00b3\u00b0D@9\u0099\u00d3\u0011\u00d4\u00d6\u00cck\b\u0090.\u0094\u00cf\u0090KQ\u00a2\u008eHT\u00b2D\u00fe\u0092\u00f4\u0091u\u00fa\u00fc\u009a\u000b\u0016[\u00cd>\u0090#\u0014\u00d2\u008d\u0096da\u00a5\u008a}\u0092\u00cb\u00e3-\u00ebV\u0085\u00c3\u00d9h\u00deO\u0018\u0086\u00faGL\u0083\u0094\u00db\u0004\u0091X?Tr\u009aC4?\u0090\u00a8\u00f0V\u00e6\u00d1\u00fe\u0018l\u00d5\u0096\u0000\u00del\f\u00ce#\u00e7\u00ae.\u009f@I\u008e\u00d0\u00da\u0082\u0092\u00ba{\u001b\rm\u00b6\u00df\u00d0@\u00adT\u00dc\u00faY{\u00ea\u00f4\u001f\u001e\u0011\u00ab\u00e3\u0012\u0081\u00063\u008f\u00cdBV\u0080 \u00cf)\r\u008f\u00846\u00fb\u00d4\u00eaQYF__\u00a1\u009b2\u0092S \u00b1\u0089\u00a1h\u009e\u00c4\u00b7N\u00e1\u008d\u00ef\u00b7\u009e\u0084\u00d2\u0001a\u00c2\u0090\u0016\u00cc\u00ef\u0084\u00b6\u00b2\u0092:\u00f6F\u00ddj\u001b\u00a3\u00eav:\u00cbfd\u00e1w\u00b6\u00bc}j\u00d0?\u00f8\u00a7B\u00dex\u0005P\u0084An\u00bf\u00f8\u00f7\\d\u00125\u00ec\u00b0 \u00b8\u009e\u0015\u00b6JA\u00f1#\u000bgR.j\u0016\u0004\u00af\u00abt\u0088E\u00e2\u00b3I\u00d0\u00e2\u00fe\u008ew\u00e2\u0017\u0014cj\u00b6\u0017\u00e4\u00af\u00d0\u00fc\u00f4I\u00f6\u000b^\u00c8\u00bb\u00f1\u00ed\u0091x\u00ed\u00ed\u0011C\u00b5]\u00a0\u00feZ\u00d9\u00a3{\u00c7\u0006\u009c4\u00ab\u00dfe|\u000e\u00f3<\u00aa0\u000f\u008dK?\u008c\u0095J\"\u00d4\u00a3{\u00ba\u00012\u0011\u00df\u0017\u00f9W\u0004y\u00e1A\u00d8\u00dd%\u00b0\u00f5;^ey\u0018\u0010\u0086T\u00baA9?\u00a4,\u00fd\u00e6V\u00b4\u0096\u00d2\u001d\\I\u00f8\u00fc\u00bc\u00fe1I0\u00e6L\u00dc8\u00e0\u0010>v\u001fha\\:\u0088\u0010\u00ba\u00f6\u00ae\u009d\u00f5\u00b5L\u00dd^\u00be\u00e2D\u00f3|D+@\u00a9\u00e3\u008e\u00b62\u00b4PE\u00e7\u00b3\u00a3\u0007!*2\u00aa]\\;\u008d\u00c1\u001f\u00cc\u00b6#\u00d5\u0091\u00849\u00c9\u0010\u00c2_\u00b68\u00d6\u001d\u009dB\u00b1\u00be\u001e\u00b7p$\u0083\"\u00cc\u00a84C-\u00e3O\u0007\u00e2\u0012A5\u00b5AW\u00f0\u0092\u00af\u008f~\u00c1\u00a8\u009f\\\u00f8{%j\u00e7\u00a6\u00bf\u00e6\u00f4~>!N&\u00a5\u00dc\u00fb0\u00d2\u00ffB\u00ccH4\u00d0\u00ea49P0X\u00c3\u00d9\u00dc[\u00e2\u00ab\u0004\u00c8\u0011\u00bdFp\u00ab~\u0007\u0012\u00bf.\u00b5\u00e1c\u00ce\u00cc/\u00f9<%*\u0095\u0013\u00d8\u00a9u\"\r\u008b\u00f0\u008cn\u00b2\u001eCh\u001be\u009c\u00b9&\u0091\u00a4\u0085\u0015\u0013VK\u00b4\u007f\u00df\u00a1q\u00c0\u000f(\u00d0H\u0017^`'\u00f2~\u000b\u0089x\u00caa\u009cF\u008eS\u00f5\u0084\u0010\u00ee\u0091(s\u00cej\u00b59!mT\u00abka\r\u00852\u0006\u009e>\u00c1\u0007\u0004\u00d1=>\u0003\\`\u009fh\u00b8p1\u00ae\u00d6\u0089cG\u0004\u000e\u009b\u00c8\u00c7cs\u0086\b\u00d1Ml\u00d9\u001ao\u0013\u00cb\u00b0\u00daw\u0086\u00ec\u0013\u00d8\u00a0yR\u00a8\u00da\u008b\u00c2<q\u00e6\u008e\u001b\u00fd\u00f8x|\u007f\u00fd2\u00e0*^a\u000e\u00faG46\u00d0\u00ac\u00d5\u00fd|\u00eb\u00bf\u0000\u00135ql\u00b1j2\u00f8\u00b3\u0080\t\u00ed7\u0099'\u00b8\u00aa\u00900\u00cd\u0096\u00d0:\u0084\u00c6`\u00d7\u00abK\u001ct\u00a1\u00b1\u00fd\u0080\u0002K\u00d1q/\u0087Jo)^\u00f7FXt\u00e7#\u00aa\u00cf\u00de\u0013\u00a0i\u00e60\u00ab\u009b\u0092\u0092\u008a*\u00e0\u0098\u0097#\u0095\u00c3\u00e8I\u00baH\u008c\u009d\u00fc_\u0005nT\u0099<>WP\u00d5Uu\u00acQ\u00f5Adq'\u00ba\u008c\u00ec\u00c7\u00e9y\u00bd\u0015\u00b6\t\u00c1\u0000\u00c5!\u007fgWdY\u0089\u00b3\u00d3\u0002\u0095\u0090\u001c\u0010\u0004c2/\u008dt\u008a\u00a5\u0015\u00d8\u009d\u0002\u0017L\u00eb\u00b7=\u00d7W\u00dcLw\u0011\u00c8\u0005j;(\u00f9\u0015,+*\u009c\u007f\u00145\u009e\u00ae\u00b1\u00943\u00bb\u00f5\u00d8J!\u00ed\u00ecqw\u0087V\n\u008b5\u00e6\bn:O\u00a8\u00b5\u008fE\u00b41\u00a1kxd\u00e1ZTi\n\u0084/b\u00ee\u00b8\u0092\u009cS\u00b8o\u00a8Xr\u008dEN\u0016\u00fa\u008bD\u00cb\u0084\u0015G\u00e1J\u0002\u008f\u00947\u00d5k\u00acL\u0018\u008d\u00c3c)\u000eE:\u00b3\u00f4}\u00c1\u0084\u0007YB\u008d\u0083U\u00a2\u000e-4\u00b4=\u00d6\u00ea\u00e6\u0011\u00eb\u00f2\u00b7\u0096\u00c7\u001b>\u0086\u00a7p\u00bd\u00e6E\u007f\u00feR\u0089\u00b0Y\u00d3\u00ffL\u00a6\u00b9\u001c\u00ac \u00cf\u0089\u00c4\u0096\u00e5nHR#\u0006\u00ff\u00a3\u00be;d\u00e5(^\u0092\u00d6e\u009a\u001c{\u00bd\u00c4\u0010\u001a\u00ba\u00ad\u00dc;f\u0088\u00ef\u00c2\u00ee\u00e0]\u0014\u0093\u00b5\"\u0084<\u0096<e\u00db\u00c5\u000bzE\u008e3\u0093\u00e6\u0080\u00b4\u00d1\u00f1\u00c7z\u00fb\u0000\u00d4\u00b3u\u00beD\b\u00a5\u00f5\u001e\u009b\u0004\u0018\u0016<_\u0087Z\u008b\\S\u00ff\u00b2Y\u00d4z\u008cL\u00c6\",\u00bd\u00c6\u0097\u00de\u00004Q\u00c2*\u00e9>*\u00e51d\u0080\u000eA\u00d7+\u00ad\u00ceA k$kv\u0006\u0019\u00c5\n+\u00ee\u0091\u00e7\u00964\u001elj5\u00b0\u00e5\u0081;\u0006\u00d8u|>\u0092\u00ec\u00ce4\u00bbg\u0098\u001b\u00de\u00c0e}\u00fa.\"o\u0081\u008d\u0086E\u00fa\u0006t\u008f?\u00f4\u009f\rbY\u008d\u000e\u0096\u008ex%\u007f\u00b2\u00eb\u00e3\u0088\u00e3n\u0081\u00db\u0014\u00ba\t\u0019\u00a6F\u000bX\b\u00e3\u009f\u00fd\u0003\u00b0\u00c7\u00a7\u0091\u00e9\u0010\u0002\u00cb\u00f6\u00c4\u0085\t\u00a84\u00bc\u0011\r`fo\u00bc\u009fJ\u00ac%\u00d7\u0080/\u00e2E\u00aa\u00c8\u008c".length();
                var1_4 = 14;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u009d8/\u008a\u00a9:'\"\u00b9\u0007e.\u0091\u0006\u00c1iaS\u00be\u00f1\u00ae\u00cf\u0094\u00c7;\u00db\u00dc\"\u0003\u00dbd\u00ceyFP5\u001c\u0082B\u00cc\n\u00f4\u00b8\u00a7\u00a6\u00ccb\u001f\t2S\u00ba'W\u00c1\u00aa\u0019\u00a5\u0005\u0012L\u00da";
                    var4_3 = "\u009d8/\u008a\u00a9:'\"\u00b9\u0007e.\u0091\u0006\u00c1iaS\u00be\u00f1\u00ae\u00cf\u0094\u00c7;\u00db\u00dc\"\u0003\u00dbd\u00ceyFP5\u001c\u0082B\u00cc\n\u00f4\u00b8\u00a7\u00a6\u00ccb\u001f\t2S\u00ba'W\u00c1\u00aa\u0019\u00a5\u0005\u0012L\u00da".length();
                    var1_4 = 27;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 26;
                            break;
                        }
                        case 1: {
                            v13 = 96;
                            break;
                        }
                        case 2: {
                            v13 = 75;
                            break;
                        }
                        case 3: {
                            v13 = 76;
                            break;
                        }
                        case 4: {
                            v13 = 76;
                            break;
                        }
                        case 5: {
                            v13 = 54;
                            break;
                        }
                        default: {
                            v13 = 119;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        Signer.h = var5;
        Signer.i = new String[87];
        Signer.a = DigestAlg.SHA256;
        Signer.b = true;
        Signer.d = true;
        Signer.e = new Asn1ObjectIdentifier(_etsiqcValues.id_etsi_qcs_QcCompliance);
        Signer.f = EESYAOID.oid_TK_nesoid;
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0xFFFFCF73) & 0xFFFF;
        if (i[n4] == null) {
            int n5;
            int n6;
            char[] cArray = h[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 96;
                    break;
                }
                case 1: {
                    n6 = 117;
                    break;
                }
                case 2: {
                    n6 = 126;
                    break;
                }
                case 3: {
                    n6 = 73;
                    break;
                }
                case 4: {
                    n6 = 220;
                    break;
                }
                case 5: {
                    n6 = 179;
                    break;
                }
                case 6: {
                    n6 = 185;
                    break;
                }
                case 7: {
                    n6 = 197;
                    break;
                }
                case 8: {
                    n6 = 222;
                    break;
                }
                case 9: {
                    n6 = 1;
                    break;
                }
                case 10: {
                    n6 = 8;
                    break;
                }
                case 11: {
                    n6 = 42;
                    break;
                }
                case 12: {
                    n6 = 72;
                    break;
                }
                case 13: {
                    n6 = 209;
                    break;
                }
                case 14: {
                    n6 = 253;
                    break;
                }
                case 15: {
                    n6 = 162;
                    break;
                }
                case 16: {
                    n6 = 229;
                    break;
                }
                case 17: {
                    n6 = 29;
                    break;
                }
                case 18: {
                    n6 = 85;
                    break;
                }
                case 19: {
                    n6 = 236;
                    break;
                }
                case 20: {
                    n6 = 130;
                    break;
                }
                case 21: {
                    n6 = 105;
                    break;
                }
                case 22: {
                    n6 = 119;
                    break;
                }
                case 23: {
                    n6 = 13;
                    break;
                }
                case 24: {
                    n6 = 133;
                    break;
                }
                case 25: {
                    n6 = 146;
                    break;
                }
                case 26: {
                    n6 = 11;
                    break;
                }
                case 27: {
                    n6 = 217;
                    break;
                }
                case 28: {
                    n6 = 210;
                    break;
                }
                case 29: {
                    n6 = 101;
                    break;
                }
                case 30: {
                    n6 = 114;
                    break;
                }
                case 31: {
                    n6 = 59;
                    break;
                }
                case 32: {
                    n6 = 140;
                    break;
                }
                case 33: {
                    n6 = 54;
                    break;
                }
                case 34: {
                    n6 = 206;
                    break;
                }
                case 35: {
                    n6 = 74;
                    break;
                }
                case 36: {
                    n6 = 251;
                    break;
                }
                case 37: {
                    n6 = 208;
                    break;
                }
                case 38: {
                    n6 = 166;
                    break;
                }
                case 39: {
                    n6 = 125;
                    break;
                }
                case 40: {
                    n6 = 46;
                    break;
                }
                case 41: {
                    n6 = 190;
                    break;
                }
                case 42: {
                    n6 = 99;
                    break;
                }
                case 43: {
                    n6 = 109;
                    break;
                }
                case 44: {
                    n6 = 124;
                    break;
                }
                case 45: {
                    n6 = 50;
                    break;
                }
                case 46: {
                    n6 = 196;
                    break;
                }
                case 47: {
                    n6 = 56;
                    break;
                }
                case 48: {
                    n6 = 71;
                    break;
                }
                case 49: {
                    n6 = 172;
                    break;
                }
                case 50: {
                    n6 = 239;
                    break;
                }
                case 51: {
                    n6 = 40;
                    break;
                }
                case 52: {
                    n6 = 5;
                    break;
                }
                case 53: {
                    n6 = 107;
                    break;
                }
                case 54: {
                    n6 = 142;
                    break;
                }
                case 55: {
                    n6 = 39;
                    break;
                }
                case 56: {
                    n6 = 9;
                    break;
                }
                case 57: {
                    n6 = 84;
                    break;
                }
                case 58: {
                    n6 = 250;
                    break;
                }
                case 59: {
                    n6 = 234;
                    break;
                }
                case 60: {
                    n6 = 49;
                    break;
                }
                case 61: {
                    n6 = 200;
                    break;
                }
                case 62: {
                    n6 = 123;
                    break;
                }
                case 63: {
                    n6 = 144;
                    break;
                }
                case 64: {
                    n6 = 81;
                    break;
                }
                case 65: {
                    n6 = 90;
                    break;
                }
                case 66: {
                    n6 = 115;
                    break;
                }
                case 67: {
                    n6 = 204;
                    break;
                }
                case 68: {
                    n6 = 228;
                    break;
                }
                case 69: {
                    n6 = 70;
                    break;
                }
                case 70: {
                    n6 = 167;
                    break;
                }
                case 71: {
                    n6 = 31;
                    break;
                }
                case 72: {
                    n6 = 247;
                    break;
                }
                case 73: {
                    n6 = 202;
                    break;
                }
                case 74: {
                    n6 = 213;
                    break;
                }
                case 75: {
                    n6 = 68;
                    break;
                }
                case 76: {
                    n6 = 23;
                    break;
                }
                case 77: {
                    n6 = 225;
                    break;
                }
                case 78: {
                    n6 = 244;
                    break;
                }
                case 79: {
                    n6 = 75;
                    break;
                }
                case 80: {
                    n6 = 195;
                    break;
                }
                case 81: {
                    n6 = 211;
                    break;
                }
                case 82: {
                    n6 = 86;
                    break;
                }
                case 83: {
                    n6 = 36;
                    break;
                }
                case 84: {
                    n6 = 26;
                    break;
                }
                case 85: {
                    n6 = 43;
                    break;
                }
                case 86: {
                    n6 = 241;
                    break;
                }
                case 87: {
                    n6 = 122;
                    break;
                }
                case 88: {
                    n6 = 224;
                    break;
                }
                case 89: {
                    n6 = 102;
                    break;
                }
                case 90: {
                    n6 = 161;
                    break;
                }
                case 91: {
                    n6 = 132;
                    break;
                }
                case 92: {
                    n6 = 3;
                    break;
                }
                case 93: {
                    n6 = 32;
                    break;
                }
                case 94: {
                    n6 = 212;
                    break;
                }
                case 95: {
                    n6 = 103;
                    break;
                }
                case 96: {
                    n6 = 154;
                    break;
                }
                case 97: {
                    n6 = 135;
                    break;
                }
                case 98: {
                    n6 = 152;
                    break;
                }
                case 99: {
                    n6 = 188;
                    break;
                }
                case 100: {
                    n6 = 242;
                    break;
                }
                case 101: {
                    n6 = 51;
                    break;
                }
                case 102: {
                    n6 = 20;
                    break;
                }
                case 103: {
                    n6 = 18;
                    break;
                }
                case 104: {
                    n6 = 219;
                    break;
                }
                case 105: {
                    n6 = 88;
                    break;
                }
                case 106: {
                    n6 = 112;
                    break;
                }
                case 107: {
                    n6 = 138;
                    break;
                }
                case 108: {
                    n6 = 246;
                    break;
                }
                case 109: {
                    n6 = 177;
                    break;
                }
                case 110: {
                    n6 = 93;
                    break;
                }
                case 111: {
                    n6 = 106;
                    break;
                }
                case 112: {
                    n6 = 16;
                    break;
                }
                case 113: {
                    n6 = 175;
                    break;
                }
                case 114: {
                    n6 = 95;
                    break;
                }
                case 115: {
                    n6 = 17;
                    break;
                }
                case 116: {
                    n6 = 62;
                    break;
                }
                case 117: {
                    n6 = 183;
                    break;
                }
                case 118: {
                    n6 = 24;
                    break;
                }
                case 119: {
                    n6 = 65;
                    break;
                }
                case 120: {
                    n6 = 0;
                    break;
                }
                case 121: {
                    n6 = 14;
                    break;
                }
                case 122: {
                    n6 = 191;
                    break;
                }
                case 123: {
                    n6 = 28;
                    break;
                }
                case 124: {
                    n6 = 61;
                    break;
                }
                case 125: {
                    n6 = 129;
                    break;
                }
                case 126: {
                    n6 = 64;
                    break;
                }
                case 127: {
                    n6 = 69;
                    break;
                }
                case 128: {
                    n6 = 187;
                    break;
                }
                case 129: {
                    n6 = 243;
                    break;
                }
                case 130: {
                    n6 = 76;
                    break;
                }
                case 131: {
                    n6 = 143;
                    break;
                }
                case 132: {
                    n6 = 168;
                    break;
                }
                case 133: {
                    n6 = 25;
                    break;
                }
                case 134: {
                    n6 = 151;
                    break;
                }
                case 135: {
                    n6 = 34;
                    break;
                }
                case 136: {
                    n6 = 180;
                    break;
                }
                case 137: {
                    n6 = 148;
                    break;
                }
                case 138: {
                    n6 = 94;
                    break;
                }
                case 139: {
                    n6 = 22;
                    break;
                }
                case 140: {
                    n6 = 194;
                    break;
                }
                case 141: {
                    n6 = 60;
                    break;
                }
                case 142: {
                    n6 = 252;
                    break;
                }
                case 143: {
                    n6 = 237;
                    break;
                }
                case 144: {
                    n6 = 110;
                    break;
                }
                case 145: {
                    n6 = 205;
                    break;
                }
                case 146: {
                    n6 = 159;
                    break;
                }
                case 147: {
                    n6 = 245;
                    break;
                }
                case 148: {
                    n6 = 149;
                    break;
                }
                case 149: {
                    n6 = 12;
                    break;
                }
                case 150: {
                    n6 = 193;
                    break;
                }
                case 151: {
                    n6 = 63;
                    break;
                }
                case 152: {
                    n6 = 38;
                    break;
                }
                case 153: {
                    n6 = 45;
                    break;
                }
                case 154: {
                    n6 = 48;
                    break;
                }
                case 155: {
                    n6 = 227;
                    break;
                }
                case 156: {
                    n6 = 186;
                    break;
                }
                case 157: {
                    n6 = 233;
                    break;
                }
                case 158: {
                    n6 = 78;
                    break;
                }
                case 159: {
                    n6 = 235;
                    break;
                }
                case 160: {
                    n6 = 174;
                    break;
                }
                case 161: {
                    n6 = 44;
                    break;
                }
                case 162: {
                    n6 = 215;
                    break;
                }
                case 163: {
                    n6 = 137;
                    break;
                }
                case 164: {
                    n6 = 58;
                    break;
                }
                case 165: {
                    n6 = 201;
                    break;
                }
                case 166: {
                    n6 = 79;
                    break;
                }
                case 167: {
                    n6 = 53;
                    break;
                }
                case 168: {
                    n6 = 118;
                    break;
                }
                case 169: {
                    n6 = 57;
                    break;
                }
                case 170: {
                    n6 = 4;
                    break;
                }
                case 171: {
                    n6 = 82;
                    break;
                }
                case 172: {
                    n6 = 240;
                    break;
                }
                case 173: {
                    n6 = 158;
                    break;
                }
                case 174: {
                    n6 = 136;
                    break;
                }
                case 175: {
                    n6 = 218;
                    break;
                }
                case 176: {
                    n6 = 2;
                    break;
                }
                case 177: {
                    n6 = 221;
                    break;
                }
                case 178: {
                    n6 = 120;
                    break;
                }
                case 179: {
                    n6 = 156;
                    break;
                }
                case 180: {
                    n6 = 27;
                    break;
                }
                case 181: {
                    n6 = 139;
                    break;
                }
                case 182: {
                    n6 = 192;
                    break;
                }
                case 183: {
                    n6 = 255;
                    break;
                }
                case 184: {
                    n6 = 231;
                    break;
                }
                case 185: {
                    n6 = 91;
                    break;
                }
                case 186: {
                    n6 = 216;
                    break;
                }
                case 187: {
                    n6 = 164;
                    break;
                }
                case 188: {
                    n6 = 155;
                    break;
                }
                case 189: {
                    n6 = 52;
                    break;
                }
                case 190: {
                    n6 = 163;
                    break;
                }
                case 191: {
                    n6 = 131;
                    break;
                }
                case 192: {
                    n6 = 153;
                    break;
                }
                case 193: {
                    n6 = 182;
                    break;
                }
                case 194: {
                    n6 = 232;
                    break;
                }
                case 195: {
                    n6 = 141;
                    break;
                }
                case 196: {
                    n6 = 199;
                    break;
                }
                case 197: {
                    n6 = 41;
                    break;
                }
                case 198: {
                    n6 = 113;
                    break;
                }
                case 199: {
                    n6 = 214;
                    break;
                }
                case 200: {
                    n6 = 147;
                    break;
                }
                case 201: {
                    n6 = 127;
                    break;
                }
                case 202: {
                    n6 = 6;
                    break;
                }
                case 203: {
                    n6 = 19;
                    break;
                }
                case 204: {
                    n6 = 145;
                    break;
                }
                case 205: {
                    n6 = 226;
                    break;
                }
                case 206: {
                    n6 = 104;
                    break;
                }
                case 207: {
                    n6 = 249;
                    break;
                }
                case 208: {
                    n6 = 89;
                    break;
                }
                case 209: {
                    n6 = 21;
                    break;
                }
                case 210: {
                    n6 = 170;
                    break;
                }
                case 211: {
                    n6 = 248;
                    break;
                }
                case 212: {
                    n6 = 238;
                    break;
                }
                case 213: {
                    n6 = 100;
                    break;
                }
                case 214: {
                    n6 = 181;
                    break;
                }
                case 215: {
                    n6 = 67;
                    break;
                }
                case 216: {
                    n6 = 7;
                    break;
                }
                case 217: {
                    n6 = 169;
                    break;
                }
                case 218: {
                    n6 = 108;
                    break;
                }
                case 219: {
                    n6 = 80;
                    break;
                }
                case 220: {
                    n6 = 165;
                    break;
                }
                case 221: {
                    n6 = 150;
                    break;
                }
                case 222: {
                    n6 = 97;
                    break;
                }
                case 223: {
                    n6 = 134;
                    break;
                }
                case 224: {
                    n6 = 171;
                    break;
                }
                case 225: {
                    n6 = 121;
                    break;
                }
                case 226: {
                    n6 = 230;
                    break;
                }
                case 227: {
                    n6 = 160;
                    break;
                }
                case 228: {
                    n6 = 189;
                    break;
                }
                case 229: {
                    n6 = 15;
                    break;
                }
                case 230: {
                    n6 = 176;
                    break;
                }
                case 231: {
                    n6 = 203;
                    break;
                }
                case 232: {
                    n6 = 35;
                    break;
                }
                case 233: {
                    n6 = 173;
                    break;
                }
                case 234: {
                    n6 = 30;
                    break;
                }
                case 235: {
                    n6 = 47;
                    break;
                }
                case 236: {
                    n6 = 77;
                    break;
                }
                case 237: {
                    n6 = 128;
                    break;
                }
                case 238: {
                    n6 = 157;
                    break;
                }
                case 239: {
                    n6 = 10;
                    break;
                }
                case 240: {
                    n6 = 87;
                    break;
                }
                case 241: {
                    n6 = 184;
                    break;
                }
                case 242: {
                    n6 = 98;
                    break;
                }
                case 243: {
                    n6 = 111;
                    break;
                }
                case 244: {
                    n6 = 37;
                    break;
                }
                case 245: {
                    n6 = 83;
                    break;
                }
                case 246: {
                    n6 = 116;
                    break;
                }
                case 247: {
                    n6 = 92;
                    break;
                }
                case 248: {
                    n6 = 66;
                    break;
                }
                case 249: {
                    n6 = 254;
                    break;
                }
                case 250: {
                    n6 = 33;
                    break;
                }
                case 251: {
                    n6 = 198;
                    break;
                }
                case 252: {
                    n6 = 207;
                    break;
                }
                case 253: {
                    n6 = 55;
                    break;
                }
                case 254: {
                    n6 = 223;
                    break;
                }
                default: {
                    n6 = 178;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            Signer.i[n4] = new String(cArray).intern();
        }
        return i[n4];
    }
}

