/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check;

import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import java.util.List;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignedData;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.Signer;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.Types;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.ValidationMessage;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;

public class ContentTypeAttrChecker
extends BaseChecker {
    private static final String d;

    @Override
    protected boolean _check(Signer aSigner, CheckerResult aCheckerResult) {
        aCheckerResult.setCheckerName(CMSSignatureI18n.getMsg(E_KEYS.CONTENT_TYPE_ATTRIBUTE_CHECKER, new String[0]), ContentTypeAttrChecker.class);
        ESignedData eSignedData = (ESignedData)this.getParameters().get(d);
        List<EAttribute> list = aSigner.getSignedAttribute(AttributeOIDs.id_contentType);
        if (list.isEmpty()) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.NO_CONTENT_TYPE_ATTRIBUTE_IN_SIGNED_DATA, new String[0])));
            aCheckerResult.setResultStatus(Types.CheckerResult_Status.NOTFOUND);
            return false;
        }
        EAttribute eAttribute = list.get(0);
        Asn1ObjectIdentifier asn1ObjectIdentifier = new Asn1ObjectIdentifier();
        try {
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(eAttribute.getValue(0));
            asn1ObjectIdentifier.decode(asn1DerDecodeBuffer);
        }
        catch (Exception exception) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.CONTENT_TYPE_ATTRIBUTE_DECODE_ERROR, new String[0]), exception));
            return false;
        }
        if (!eSignedData.getEncapsulatedContentInfo().getContentType().equals(asn1ObjectIdentifier)) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.CONTENT_TYPE_ATTRIBUTE_CHECKER_UNSUCCESSFUL, new String[0])));
            return false;
        }
        aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.CONTENT_TYPE_ATTRIBUTE_CHECKER_SUCCESSFUL, new String[0])));
        aCheckerResult.setResultStatus(Types.CheckerResult_Status.SUCCESS);
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block12: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block11: {
                char[] cArray3 = "+)C!EBS?)T)VM".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block11;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block12;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 7) {
                        case 0: {
                            n7 = 123;
                            break;
                        }
                        case 1: {
                            n7 = 118;
                            break;
                        }
                        case 2: {
                            n7 = 16;
                            break;
                        }
                        case 3: {
                            n7 = 104;
                            break;
                        }
                        case 4: {
                            n7 = 2;
                            break;
                        }
                        case 5: {
                            n7 = 12;
                            break;
                        }
                        default: {
                            n7 = 22;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        d = new String(cArray).intern();
    }
}

