/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import java.io.ByteArrayInputStream;
import java.util.List;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.Signer;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.Types;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.ValidationMessage;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.SigningCertificateV2AttrChecker;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.asn.cms.ESSCertID;
import tr.gov.tubitak.uekae.esya.asn.cms.IssuerAndSerialNumber;
import tr.gov.tubitak.uekae.esya.asn.cms.IssuerSerial;
import tr.gov.tubitak.uekae.esya.asn.cms.SignerInfo;
import tr.gov.tubitak.uekae.esya.asn.cms.SigningCertificate;
import tr.gov.tubitak.uekae.esya.asn.util.UtilEsitlikler;
import tr.gov.tubitak.uekae.esya.asn.x509.Name;

public class SigningCertificateAttrChecker
extends BaseChecker {
    @Override
    protected boolean _check(Signer aSigner, CheckerResult aCheckerResult) {
        Object object;
        ECertificate eCertificate;
        block12: {
            aCheckerResult.setCheckerName(CMSSignatureI18n.getMsg(E_KEYS.SIGNING_CERTIFICATE_ATTRIBUTE_CHECKER, new String[0]), SigningCertificateAttrChecker.class);
            eCertificate = aSigner.getSignerCertificate();
            List<EAttribute> list = aSigner.getSignedAttribute(AttributeOIDs.id_aa_signingCertificate);
            if (list.isEmpty()) {
                SigningCertificateV2AttrChecker signingCertificateV2AttrChecker = new SigningCertificateV2AttrChecker();
                signingCertificateV2AttrChecker.setParameters(this.getParameters());
                return signingCertificateV2AttrChecker.check(aSigner, aCheckerResult);
            }
            EAttribute eAttribute = list.get(0);
            SigningCertificate signingCertificate = null;
            try {
                signingCertificate = new SigningCertificate();
                object = new Asn1DerDecodeBuffer(eAttribute.getValue(0));
                signingCertificate.decode((Asn1BerDecodeBuffer)object);
            }
            catch (Exception exception) {
                aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNING_CERTIFICATE_DECODE_ERROR, new String[0]), exception));
                return false;
            }
            object = signingCertificate.certs.elements[0];
            if (((SignerInfo)aSigner.getSignerInfo().getObject()).sid.getElement() instanceof IssuerAndSerialNumber) {
                IssuerAndSerialNumber issuerAndSerialNumber = (IssuerAndSerialNumber)((SignerInfo)aSigner.getSignerInfo().getObject()).sid.getElement();
                IssuerSerial issuerSerial = ((ESSCertID)object).issuerSerial;
                if (issuerAndSerialNumber == null || issuerSerial == null) break block12;
                boolean bl = this.a(issuerAndSerialNumber, issuerSerial);
                if (!bl) {
                    aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.ISSUER_SERIAL_DOESNOT_MATCH_SIGNER_IDENTIFIER, new String[0])));
                    return false;
                }
            }
        }
        try {
            if (!this.a(eCertificate, (ESSCertID)object)) {
                aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.CERT_HASH_DOESNOT_MATCH, new String[0])));
                return false;
            }
        }
        catch (Exception exception) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNING_CERTIFICATE_ATTRIBUTE_HASH_CALCULATION_ERROR, new String[0]), exception));
            return false;
        }
        aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNING_CERTIFICATE_ATTRIBUTE_CHECK_SUCCESSFUL, new String[0])));
        aCheckerResult.setResultStatus(Types.CheckerResult_Status.SUCCESS);
        return true;
    }

    private boolean a(IssuerAndSerialNumber issuerAndSerialNumber, IssuerSerial issuerSerial) {
        int n2;
        Name name;
        Name name2 = (Name)issuerSerial.issuer.elements[0].getElement();
        if (!UtilEsitlikler.esitMi(name2, name = issuerAndSerialNumber.issuer)) {
            return false;
        }
        int n3 = issuerSerial.serialNumber.value.intValue();
        return n3 == (n2 = issuerAndSerialNumber.serialNumber.value.intValue());
    }

    private boolean a(ECertificate eCertificate, ESSCertID eSSCertID) throws ESYAException {
        try {
            byte[] byArray = eSSCertID.certHash.value;
            return this._checkDigest(byArray, new ByteArrayInputStream(eCertificate.getEncoded()), DigestAlg.SHA1);
        }
        catch (Exception exception) {
            throw new ESYAException(exception);
        }
    }
}

