/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import java.io.ByteArrayInputStream;
import java.util.List;
import tr.gov.tubitak.uekae.esya.api.asn.BaseASNWrapper;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EESSCertIDv2;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.Signer;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.Types;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.ValidationMessage;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.asn.cms.ESSCertIDv2;
import tr.gov.tubitak.uekae.esya.asn.cms.IssuerAndSerialNumber;
import tr.gov.tubitak.uekae.esya.asn.cms.IssuerSerial;
import tr.gov.tubitak.uekae.esya.asn.cms.SignerInfo;
import tr.gov.tubitak.uekae.esya.asn.cms.SigningCertificateV2;
import tr.gov.tubitak.uekae.esya.asn.util.UtilEsitlikler;
import tr.gov.tubitak.uekae.esya.asn.x509.Name;

public class SigningCertificateV2AttrChecker
extends BaseChecker {
    private static final String d;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _check(Signer aSigner, CheckerResult aCheckerResult) {
        IssuerAndSerialNumber issuerAndSerialNumber;
        boolean bl;
        Object object;
        aCheckerResult.setCheckerName(CMSSignatureI18n.getMsg(E_KEYS.SIGNING_CERTIFICATE_V2_ATTRIBUTE_CHECKER, new String[0]), SigningCertificateV2AttrChecker.class);
        ECertificate eCertificate = aSigner.getSignerCertificate();
        List<EAttribute> list = aSigner.getSignedAttribute(AttributeOIDs.id_aa_signingCertificateV2);
        if (list.isEmpty()) {
            aCheckerResult.addMessage(new ValidationMessage(AttributeOIDs.id_aa_signingCertificateV2 + d));
            return false;
        }
        EAttribute eAttribute = list.get(0);
        SigningCertificateV2 signingCertificateV2 = null;
        try {
            signingCertificateV2 = new SigningCertificateV2();
            object = new Asn1DerDecodeBuffer(eAttribute.getValue(0));
            signingCertificateV2.decode((Asn1BerDecodeBuffer)object);
        }
        catch (Exception exception) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNING_CERTIFICATE_DECODE_ERROR, new String[0]), exception));
            return false;
        }
        object = new EESSCertIDv2(signingCertificateV2.certs.elements[0]);
        boolean bl2 = false;
        if (this.getSignedData().getEncapsulatedContentInfo().getContentType().equals(AttributeOIDs.id_ct_TSTInfo)) {
            bl2 = true;
        }
        boolean bl3 = ((SignerInfo)aSigner.getSignerInfo().getObject()).sid.getElement() instanceof IssuerAndSerialNumber;
        boolean bl4 = false;
        if (((ESSCertIDv2)((BaseASNWrapper)object).getObject()).issuerSerial == null) {
            bl4 = true;
        }
        if (bl4 && (!bl2 || bl2 && !bl3)) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.ISSUER_SERIAL_DOESNOT_EXISTS, new String[0])));
            return false;
        }
        if (bl3 && !bl4 && !(bl = this.a(issuerAndSerialNumber = (IssuerAndSerialNumber)((SignerInfo)aSigner.getSignerInfo().getObject()).sid.getElement(), ((ESSCertIDv2)((BaseASNWrapper)object).getObject()).issuerSerial))) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.ISSUER_SERIAL_DOESNOT_MATCH_SIGNER_IDENTIFIER, new String[0])));
            return false;
        }
        try {
            if (!this.a(eCertificate, (EESSCertIDv2)object)) {
                aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.CERT_HASH_DOESNOT_MATCH, new String[0])));
                return false;
            }
        }
        catch (Exception exception) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNING_CERTIFICATE_ATTRIBUTE_HASH_CALCULATION_ERROR, new String[0]), exception));
            return false;
        }
        aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNING_CERTIFICATE_ATTRIBUTE_CHECK_SUCCESSFUL, new String[0])));
        aCheckerResult.setResultStatus(Types.CheckerResult_Status.SUCCESS);
        return true;
    }

    private boolean a(IssuerAndSerialNumber issuerAndSerialNumber, IssuerSerial issuerSerial) {
        int n2;
        Name name;
        Name name2 = (Name)issuerSerial.issuer.elements[0].getElement();
        if (!UtilEsitlikler.esitMi(name2, name = issuerAndSerialNumber.issuer)) {
            return false;
        }
        int n3 = issuerSerial.serialNumber.value.intValue();
        return n3 == (n2 = issuerAndSerialNumber.serialNumber.value.intValue());
    }

    private boolean a(ECertificate eCertificate, EESSCertIDv2 eESSCertIDv2) throws ESYAException {
        try {
            byte[] byArray = ((ESSCertIDv2)eESSCertIDv2.getObject()).certHash.value;
            return this._checkDigest(byArray, new ByteArrayInputStream(eCertificate.getEncoded()), DigestAlg.fromOID(eESSCertIDv2.getHashAlgorithm().getAlgorithm().value));
        }
        catch (Exception exception) {
            throw new ESYAException(exception);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block12: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block11: {
                char[] cArray3 = "L=k]\u0019\u001a>P\u001dH\u0014\u001c\u001dy@\u0011]\u000e\u001c\u0015w`\u0015[\u001f#A>B\u0000[\b\u001c\u0011kw\u0011\b\u000fU\u0011ko\u0001A\u001b\u0018\u0012zj".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block11;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block12;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 7) {
                        case 0: {
                            n7 = 3;
                            break;
                        }
                        case 1: {
                            n7 = 116;
                            break;
                        }
                        case 2: {
                            n7 = 47;
                            break;
                        }
                        case 3: {
                            n7 = 122;
                            break;
                        }
                        case 4: {
                            n7 = 117;
                            break;
                        }
                        case 5: {
                            n7 = 115;
                            break;
                        }
                        default: {
                            n7 = 30;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        d = new String(cArray).intern();
    }
}

