/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerDecodeContext;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1MissingRequiredException;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1OpenType;
import com.objsys.asn1j.runtime.Asn1SeqOrderException;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1TagMatchFailedException;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.IntHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EATSHashIndex;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignedData;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignerInfo;
import tr.gov.tubitak.uekae.esya.api.asn.pkixtsp.ETSTInfo;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CMSSignatureException;
import tr.gov.tubitak.uekae.esya.api.cmssignature.ISignable;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.Signer;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.Types;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.ValidationMessage;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.tools.CombinedInputStream;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.asn.cms.CMSVersion;
import tr.gov.tubitak.uekae.esya.asn.cms.CertificateSet;
import tr.gov.tubitak.uekae.esya.asn.cms.ContentInfo;
import tr.gov.tubitak.uekae.esya.asn.cms.DigestAlgorithmIdentifiers;
import tr.gov.tubitak.uekae.esya.asn.cms.EncapsulatedContentInfo;
import tr.gov.tubitak.uekae.esya.asn.cms.RevocationInfoChoices;
import tr.gov.tubitak.uekae.esya.asn.cms.SignedAttributes;
import tr.gov.tubitak.uekae.esya.asn.cms.SignedData;
import tr.gov.tubitak.uekae.esya.asn.cms.SignerIdentifier;
import tr.gov.tubitak.uekae.esya.asn.cms.SignerInfo;
import tr.gov.tubitak.uekae.esya.asn.pkixtsp.TSTInfo;
import tr.gov.tubitak.uekae.esya.asn.x509.AlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.asn.x509.Attribute;

public class TimeStampMessageDigestChecker
extends BaseChecker {
    protected static Logger logger;
    private Types.TS_Type d = null;
    private ESignedData e = null;
    private static final String[] h;
    private static final String[] i;

    public TimeStampMessageDigestChecker(Types.TS_Type aTSType, ESignedData aSignedData) {
        this.d = aTSType;
        this.e = aSignedData;
    }

    @Override
    protected boolean _check(Signer aSigner, CheckerResult aCheckerResult) {
        block11: {
            aCheckerResult.setCheckerName(CMSSignatureI18n.getMsg(E_KEYS.TIMESTAMP_MESSAGE_DIGEST_CHECKER, new String[0]), TimeStampMessageDigestChecker.class);
            if (!this.e.getEncapsulatedContentInfo().getContentType().equals(AttributeOIDs.id_ct_TSTInfo)) {
                aCheckerResult.addMessage(new ValidationMessage(TimeStampMessageDigestChecker.b(13746, 26390)));
                return false;
            }
            ETSTInfo eTSTInfo = null;
            try {
                eTSTInfo = new ETSTInfo(this.e.getEncapsulatedContentInfo().getContent());
            }
            catch (Exception exception) {
                aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.TS_MESSAGE_DIGEST_CHECKER_DECODE_ERROR, new String[0]), exception));
                return false;
            }
            try {
                InputStream inputStream;
                DigestAlg digestAlg;
                byte[] byArray;
                block12: {
                    byArray = eTSTInfo.getHashedMessage();
                    byte[] byArray2 = (byte[])this.getParameters().get(TimeStampMessageDigestChecker.b(13756, -31381));
                    if (Arrays.equals(byArray, byArray2)) break block11;
                    AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)eTSTInfo.getHashAlgorithm().getObject();
                    digestAlg = DigestAlg.fromOID(algorithmIdentifier.algorithm.value);
                    inputStream = this.a((SignerInfo)aSigner.getSignerInfo().getObject(), digestAlg);
                    if (inputStream == null) {
                        aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.TS_MESSAGE_DIGEST_CHECKER_DIGEST_CALCULATION_ERROR, new String[0])));
                        return false;
                    }
                    if (this._checkDigest(byArray, inputStream, digestAlg)) break block11;
                    if (this.d == Types.TS_Type.ESA) break block12;
                    aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.TS_MESSAGE_DIGEST_CHECKER_UNSUCCESSFUL, new String[0])));
                    return false;
                }
                inputStream = this.a((SignerInfo)aSigner.getSignerInfo().getObject());
                if (!this._checkDigest(byArray, inputStream, digestAlg)) {
                    aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.TS_MESSAGE_DIGEST_CHECKER_UNSUCCESSFUL, new String[0])));
                    return false;
                }
            }
            catch (Exception exception) {
                aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.TS_MESSAGE_DIGEST_CHECKER_DIGEST_CALCULATION_ERROR, new String[0]), exception));
                return false;
            }
        }
        aCheckerResult.setResultStatus(Types.CheckerResult_Status.SUCCESS);
        aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.TS_MESSAGE_DIGEST_CHECKER_SUCCESSFUL, new String[0])));
        return true;
    }

    private InputStream a(SignerInfo signerInfo) throws CMSSignatureException {
        InputStream inputStream = null;
        byte[] byArray = (byte[])this.getParameters().get(TimeStampMessageDigestChecker.b(13749, 25126));
        inputStream = this.a(byArray, signerInfo);
        return inputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream a(SignerInfo signerInfo, DigestAlg digestAlg) throws CMSSignatureException {
        ESignedData eSignedData;
        InputStream inputStream = null;
        int n2 = CheckerResult.h;
        if (this.d == Types.TS_Type.CONTENT) {
            inputStream = this.a();
        }
        if (this.d == Types.TS_Type.EST) {
            inputStream = new ByteArrayInputStream(signerInfo.signature.value);
            if (n2 == 0) return inputStream;
        }
        if (this.d == Types.TS_Type.ESC) {
            inputStream = new ByteArrayInputStream(this.b(signerInfo));
            if (n2 == 0) return inputStream;
        }
        if (this.d == Types.TS_Type.ES_REFS) {
            inputStream = new ByteArrayInputStream(this.c(signerInfo));
            if (n2 == 0) return inputStream;
        }
        if (this.d == Types.TS_Type.ESA) {
            eSignedData = (ESignedData)this.getParameters().get(TimeStampMessageDigestChecker.b(13735, 14209));
            byte[] byArray = (byte[])this.getParameters().get(TimeStampMessageDigestChecker.b(13730, 18835));
            inputStream = this.a((SignedData)eSignedData.getObject(), byArray, signerInfo);
            if (n2 == 0) return inputStream;
        }
        if (this.d != Types.TS_Type.ESAv3) return inputStream;
        eSignedData = (ESignedData)this.getParameters().get(TimeStampMessageDigestChecker.b(13750, -30008));
        return this.a((SignedData)eSignedData.getObject(), signerInfo, digestAlg);
    }

    private InputStream a() {
        ESignedData eSignedData = (ESignedData)this.getParameters().get(TimeStampMessageDigestChecker.b(13750, -30008));
        byte[] byArray = eSignedData.getEncapsulatedContentInfo().getContent();
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        ISignable iSignable = (ISignable)this.getParameters().get(TimeStampMessageDigestChecker.b(13728, 2551));
        if (iSignable != null) {
            try {
                return iSignable.getAsInputStream();
            }
            catch (Exception exception) {
                logger.warn(TimeStampMessageDigestChecker.b(13753, -16908), exception);
                return null;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] b(SignerInfo signerInfo) {
        byte[] byArray = signerInfo.signature.value;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        Attribute[] attributeArray = signerInfo.unsignedAttrs.elements;
        Attribute attribute = null;
        Attribute attribute2 = null;
        Attribute attribute3 = null;
        int n2 = CheckerResult.h;
        for (Attribute attribute4 : attributeArray) {
            if (attribute4.type.equals(AttributeOIDs.id_aa_signatureTimeStampToken)) {
                attribute = attribute4;
                if (n2 == 0) continue;
            }
            if (attribute4.type.equals(AttributeOIDs.id_aa_ets_certificateRefs)) {
                attribute2 = attribute4;
                if (n2 == 0) continue;
            }
            if (!attribute4.type.equals(AttributeOIDs.id_aa_ets_revocationRefs)) continue;
            attribute3 = attribute4;
            if (n2 == 0) continue;
        }
        try {
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            if (attribute == null) {
                logger.error(TimeStampMessageDigestChecker.b(13740, 15720));
                return null;
            }
            attribute.encode(asn1DerEncodeBuffer, false);
            byArray2 = asn1DerEncodeBuffer.getMsgCopy();
            asn1DerEncodeBuffer.reset();
            if (attribute2 == null) {
                logger.error(TimeStampMessageDigestChecker.b(13755, 16732));
                return null;
            }
            attribute2.encode(asn1DerEncodeBuffer, false);
            byArray3 = asn1DerEncodeBuffer.getMsgCopy();
            asn1DerEncodeBuffer.reset();
            if (attribute3 == null) {
                logger.error(TimeStampMessageDigestChecker.b(13748, 12053));
                return null;
            }
            attribute3.encode(asn1DerEncodeBuffer, false);
            byArray4 = asn1DerEncodeBuffer.getMsgCopy();
        }
        catch (Exception exception) {
            logger.warn(TimeStampMessageDigestChecker.b(13743, 26115), exception);
            return null;
        }
        if (byArray == null) return null;
        if (byArray2 == null) return null;
        if (byArray3 == null) return null;
        if (byArray4 == null) return null;
        byte[] byArray5 = this.a(byArray, byArray2);
        byte[] byArray6 = this.a(byArray5, byArray3);
        return this.a(byArray6, byArray4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] c(SignerInfo signerInfo) {
        Attribute[] attributeArray = signerInfo.unsignedAttrs.elements;
        Attribute attribute = null;
        Attribute attribute2 = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        Attribute[] attributeArray2 = attributeArray;
        int n2 = CheckerResult.h;
        for (Attribute attribute3 : attributeArray2) {
            if (attribute3.type.equals(AttributeOIDs.id_aa_ets_certificateRefs)) {
                attribute = attribute3;
                if (n2 == 0) continue;
            }
            if (!attribute3.type.equals(AttributeOIDs.id_aa_ets_revocationRefs)) continue;
            attribute2 = attribute3;
            if (n2 == 0) continue;
        }
        try {
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            if (attribute == null) {
                logger.error(TimeStampMessageDigestChecker.b(13731, -7094));
                return null;
            }
            attribute.encode(asn1DerEncodeBuffer, false);
            byArray = asn1DerEncodeBuffer.getMsgCopy();
            asn1DerEncodeBuffer.reset();
            if (attribute2 == null) {
                logger.error(TimeStampMessageDigestChecker.b(13759, -22464));
                return null;
            }
            attribute2.encode(asn1DerEncodeBuffer, false);
            byArray2 = asn1DerEncodeBuffer.getMsgCopy();
        }
        catch (Asn1Exception asn1Exception) {
            logger.warn(TimeStampMessageDigestChecker.b(13753, -16908), asn1Exception);
            return null;
        }
        if (byArray == null) return null;
        if (byArray2 == null) return null;
        return this.a(byArray, byArray2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream a(byte[] var1_1, SignerInfo var2_2) throws CMSSignatureException {
        var4_3 = new CombinedInputStream();
        var3_4 = CheckerResult.h;
        try {
            block29: {
                block30: {
                    block28: {
                        var5_5 = this.a(var1_1);
                        var6_8 = new Asn1BerDecodeBuffer(var5_5);
                        var12_9 = 0;
                        var13_10 = 0;
                        var14_11 = this.matchTag(var6_8, Asn1Tag.SEQUENCE);
                        var15_12 = new Asn1BerDecodeContext(var6_8, var14_11);
                        var16_13 = new IntHolder();
                        if (var15_12.matchElemTag((short)0, (short)0, 2, var16_13, false) == false) throw new Asn1MissingRequiredException(var6_8);
                        var7_14 = new CMSVersion();
                        var7_14.decode(var6_8, true, var16_13.value);
                        if (var3_4 != 0) {
                            throw new Asn1MissingRequiredException(var6_8);
                        }
                        if (var15_12.matchElemTag((short)0, (short)32, 17, var16_13, false) == false) throw new Asn1MissingRequiredException(var6_8);
                        var8_15 = new DigestAlgorithmIdentifiers();
                        var8_15.decode(var6_8, true, var16_13.value);
                        if (var3_4 != 0) {
                            throw new Asn1MissingRequiredException(var6_8);
                        }
                        var12_9 = var6_8.getByteCount();
                        if (var15_12.matchElemTag((short)0, (short)32, 16, var16_13, false) == false) throw new Asn1MissingRequiredException(var6_8);
                        var9_16 = new EncapsulatedContentInfo();
                        var9_16.decode(var6_8, true, var16_13.value);
                        if (var3_4 != 0) {
                            throw new Asn1MissingRequiredException(var6_8);
                        }
                        var13_10 = var6_8.getByteCount();
                        if (var9_16.eContent == null) break block28;
                        var4_3.addInputStream(new ByteArrayInputStream(var5_5, var12_9, var13_10 - var12_9));
                        if (var3_4 == 0) break block29;
                    }
                    var17_17 = null;
                    try {
                        var17_17 = (ISignable)this.getParameters().get(TimeStampMessageDigestChecker.b(13745, -3493));
                    }
                    catch (Exception var18_19) {
                        TimeStampMessageDigestChecker.logger.warn(TimeStampMessageDigestChecker.b(13753, -16908), var18_19);
                        var17_17 = null;
                    }
                    if (var17_17 != null) break block30;
                    var18_20 = null;
                    ** try [egrp 6[TRYBLOCK] [5 : 339->347)] { 
lbl42:
                    // 1 sources

                    ** GOTO lbl-1000
                }
                var4_3.addInputStream(var17_17.getAsInputStream());
            }
            var12_9 = var6_8.getByteCount();
            if (var15_12.matchElemTag((short)128, (short)32, 0, var16_13, true)) {
                var10_24 = new CertificateSet();
                var10_24.decode(var6_8, false, var16_13.value);
                if (var16_13.value == -9999) {
                    this.matchTag(var6_8, Asn1Tag.EOC);
                }
            }
            var13_10 = var6_8.getByteCount();
            var4_3.addInputStream(new ByteArrayInputStream(var5_5, var12_9, var13_10 - var12_9));
            var12_9 = var6_8.getByteCount();
            if (var15_12.matchElemTag((short)128, (short)32, 1, var16_13, true)) {
                var11_25 = new RevocationInfoChoices();
                var11_25.decode(var6_8, false, var16_13.value);
                if (var16_13.value == -9999) {
                    this.matchTag(var6_8, Asn1Tag.EOC);
                }
            }
            var13_10 = var6_8.getByteCount();
            var4_3.addInputStream(new ByteArrayInputStream(var5_5, var12_9, var13_10 - var12_9));
            var17_18 = this.matchTag(var6_8, Asn1Tag.SET);
            var18_21 = new Asn1BerDecodeContext(var6_8, var17_18);
            var20_26 = 0;
            do lbl-1000:
            // 3 sources

            {
                if (var18_21.expired() != false) return var4_3;
                var19_23 = new SignerInfo();
                var12_9 = var6_8.getByteCount();
                var19_23.decode(var6_8, true, var20_26);
                var13_10 = var6_8.getByteCount();
                var21_27 = new ESignerInfo(var2_2);
                if (!var21_27.getSignerIdentifier().equals(var21_27.getSignerIdentifier())) continue;
                var22_28 = new byte[var13_10 - var12_9];
                System.arraycopy(var5_5, var12_9, var22_28, 0, var13_10 - var12_9);
                this.a(var22_28, var4_3);
                if (var3_4 == 0) ** GOTO lbl-1000
            } while (var3_4 == 0);
            return var4_3;
        }
        catch (Exception var5_7) {
            throw new CMSSignatureException(TimeStampMessageDigestChecker.b(13758, -27461), var5_7);
        }
lbl-1000:
        // 1 sources

        {
            var4_3.close();
            return var18_20;
        }
lbl85:
        // 1 sources

        catch (IOException var19_22) {
            TimeStampMessageDigestChecker.logger.warn(TimeStampMessageDigestChecker.b(13733, 16062), var19_22);
        }
        return var18_20;
        finally {
            try {
                var4_3.close();
            }
            catch (IOException var24_30) {
                TimeStampMessageDigestChecker.logger.warn(TimeStampMessageDigestChecker.b(13747, -29160), var24_30);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(byte[] byArray, CombinedInputStream combinedInputStream) throws ESYAException {
        int n2 = CheckerResult.h;
        try {
            TSTInfo tSTInfo = this.c((SignedData)this.e.getObject());
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(byArray);
            int n4 = 0;
            int n5 = 0;
            int n3 = this.matchTag(asn1DerDecodeBuffer, Asn1Tag.SEQUENCE);
            Asn1BerDecodeContext asn1BerDecodeContext = new Asn1BerDecodeContext(asn1DerDecodeBuffer, n3);
            IntHolder intHolder = new IntHolder();
            n4 = asn1DerDecodeBuffer.getByteCount();
            if (!asn1BerDecodeContext.matchElemTag((short)0, (short)0, 2, intHolder, false)) throw new Asn1MissingRequiredException(asn1DerDecodeBuffer);
            CMSVersion cMSVersion = new CMSVersion();
            cMSVersion.decode(asn1DerDecodeBuffer, true, intHolder.value);
            if (n2 != 0) {
                throw new Asn1MissingRequiredException(asn1DerDecodeBuffer);
            }
            n5 = asn1DerDecodeBuffer.getByteCount();
            combinedInputStream.addInputStream(new ByteArrayInputStream(byArray, n4, n5 - n4));
            n4 = asn1DerDecodeBuffer.getByteCount();
            if (asn1BerDecodeContext.expired()) throw new Asn1MissingRequiredException(asn1DerDecodeBuffer);
            Asn1Tag asn1Tag2 = asn1DerDecodeBuffer.peekTag();
            if (!asn1Tag2.equals((short)0, (short)32, 16)) {
                if (!asn1Tag2.equals((short)128, (short)0, 0)) throw new Asn1MissingRequiredException(asn1DerDecodeBuffer);
            }
            SignerIdentifier signerIdentifier = new SignerIdentifier();
            signerIdentifier.decode(asn1DerDecodeBuffer, true, intHolder.value);
            if (n2 != 0) {
                throw new Asn1MissingRequiredException(asn1DerDecodeBuffer);
            }
            if (n2 != 0) {
                throw new Asn1MissingRequiredException(asn1DerDecodeBuffer);
            }
            n5 = asn1DerDecodeBuffer.getByteCount();
            combinedInputStream.addInputStream(new ByteArrayInputStream(byArray, n4, n5 - n4));
            n4 = asn1DerDecodeBuffer.getByteCount();
            if (!asn1BerDecodeContext.matchElemTag((short)0, (short)32, 16, intHolder, false)) throw new Asn1MissingRequiredException(asn1DerDecodeBuffer);
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier();
            algorithmIdentifier.decode(asn1DerDecodeBuffer, true, intHolder.value);
            if (n2 != 0) {
                throw new Asn1MissingRequiredException(asn1DerDecodeBuffer);
            }
            n5 = asn1DerDecodeBuffer.getByteCount();
            combinedInputStream.addInputStream(new ByteArrayInputStream(byArray, n4, n5 - n4));
            n4 = asn1DerDecodeBuffer.getByteCount();
            if (asn1BerDecodeContext.matchElemTag((short)128, (short)32, 0, intHolder, true)) {
                SignedAttributes signedAttributes = new SignedAttributes();
                signedAttributes.decode(asn1DerDecodeBuffer, false, intHolder.value);
                if (intHolder.value == -9999) {
                    this.matchTag(asn1DerDecodeBuffer, Asn1Tag.EOC);
                }
            }
            n5 = asn1DerDecodeBuffer.getByteCount();
            combinedInputStream.addInputStream(new ByteArrayInputStream(byArray, n4, n5 - n4));
            n4 = asn1DerDecodeBuffer.getByteCount();
            if (!asn1BerDecodeContext.matchElemTag((short)0, (short)32, 16, intHolder, false)) throw new Asn1MissingRequiredException(asn1DerDecodeBuffer);
            AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier();
            algorithmIdentifier2.decode(asn1DerDecodeBuffer, true, intHolder.value);
            if (n2 != 0) {
                throw new Asn1MissingRequiredException(asn1DerDecodeBuffer);
            }
            n5 = asn1DerDecodeBuffer.getByteCount();
            combinedInputStream.addInputStream(new ByteArrayInputStream(byArray, n4, n5 - n4));
            n4 = asn1DerDecodeBuffer.getByteCount();
            if (!asn1BerDecodeContext.matchElemTag((short)0, (short)0, 4, intHolder, false)) throw new Asn1MissingRequiredException(asn1DerDecodeBuffer);
            Asn1OctetString asn1OctetString = new Asn1OctetString();
            asn1OctetString.decode(asn1DerDecodeBuffer, true, intHolder.value);
            if (n2 != 0) {
                throw new Asn1MissingRequiredException(asn1DerDecodeBuffer);
            }
            n5 = asn1DerDecodeBuffer.getByteCount();
            combinedInputStream.addInputStream(new ByteArrayInputStream(byArray, n4, n5 - n4));
            if (asn1BerDecodeContext.matchElemTag((short)128, (short)32, 1, intHolder, true)) {
                int n6 = intHolder.value;
                Asn1BerDecodeContext asn1BerDecodeContext2 = new Asn1BerDecodeContext(asn1DerDecodeBuffer, n6);
                int n7 = 0;
                while (!asn1BerDecodeContext2.expired()) {
                    Attribute attribute = new Attribute();
                    n4 = asn1DerDecodeBuffer.getByteCount();
                    attribute.decode(asn1DerDecodeBuffer, true, n7);
                    n5 = asn1DerDecodeBuffer.getByteCount();
                    if (attribute.type.equals(AttributeOIDs.id_aa_ets_archiveTimestampV2) || attribute.type.equals(AttributeOIDs.id_aa_ets_archiveTimestamp)) {
                        TSTInfo tSTInfo2 = this.a(attribute);
                        if (tSTInfo2.genTime.getTime().before(tSTInfo.genTime.getTime())) {
                            combinedInputStream.addInputStream(new ByteArrayInputStream(byArray, n4, n5 - n4));
                        }
                        if (n2 == 0) continue;
                    }
                    combinedInputStream.addInputStream(new ByteArrayInputStream(byArray, n4, n5 - n4));
                    if (n2 == 0) continue;
                }
                if (n6 == -9999) {
                    this.matchTag(asn1DerDecodeBuffer, Asn1Tag.EOC);
                }
                if (intHolder.value == -9999) {
                    this.matchTag(asn1DerDecodeBuffer, Asn1Tag.EOC);
                }
            }
            if (!asn1BerDecodeContext.expired()) {
                asn1Tag2 = asn1DerDecodeBuffer.peekTag();
                if (asn1Tag2.equals((short)0, (short)0, 2)) throw new Asn1SeqOrderException();
                if (asn1Tag2.equals((short)0, (short)32, 16)) throw new Asn1SeqOrderException();
                if (asn1Tag2.equals((short)128, (short)32, 0)) throw new Asn1SeqOrderException();
                if (asn1Tag2.equals((short)0, (short)0, 4)) throw new Asn1SeqOrderException();
                if (asn1Tag2.equals((short)128, (short)32, 1)) {
                    throw new Asn1SeqOrderException();
                }
            }
            if (n3 != -9999) return;
            this.matchTag(asn1DerDecodeBuffer, Asn1Tag.EOC);
            return;
        }
        catch (Exception exception) {
            throw new ESYAException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream a(SignedData signedData, byte[] byArray, SignerInfo signerInfo) throws CMSSignatureException {
        byte[] byArray2 = this.a(signedData);
        int n2 = CheckerResult.h;
        ISignable iSignable = null;
        if (signedData.encapContentInfo.eContent == null) {
            try {
                iSignable = (ISignable)this.getParameters().get(TimeStampMessageDigestChecker.b(13728, 2551));
            }
            catch (Exception exception) {
                logger.warn(TimeStampMessageDigestChecker.b(13753, -16908), exception);
                return null;
            }
            if (iSignable == null) {
                return null;
            }
        }
        byte[] byArray3 = this.a(signedData.certificates);
        byte[] byArray4 = this.a(signedData.crls);
        byte[] byArray5 = this.d(signerInfo);
        if (byArray2 == null) return null;
        if (byArray5 == null) {
            return null;
        }
        CombinedInputStream combinedInputStream = new CombinedInputStream();
        try {
            block38: {
                block39: {
                    block37: {
                        if (iSignable != null) {
                            combinedInputStream.addInputStream(new ByteArrayInputStream(byArray2));
                            try {
                                combinedInputStream.addInputStream(iSignable.getAsInputStream());
                            }
                            catch (IOException iOException) {
                                throw new CMSSignatureException(iOException);
                            }
                        } else {
                            combinedInputStream.addInputStream(new ByteArrayInputStream(byArray2));
                        }
                        if (byArray3 == null || byArray4 == null) break block37;
                        combinedInputStream.addInputStream(new ByteArrayInputStream(byArray3));
                        combinedInputStream.addInputStream(new ByteArrayInputStream(byArray4));
                        if (n2 == 0) break block38;
                    }
                    if (byArray3 != null || byArray4 == null) break block39;
                    combinedInputStream.addInputStream(new ByteArrayInputStream(byArray4));
                    if (n2 == 0) break block38;
                }
                if (byArray3 != null && byArray4 == null) {
                    combinedInputStream.addInputStream(new ByteArrayInputStream(byArray3));
                }
            }
            combinedInputStream.addInputStream(new ByteArrayInputStream(byArray5));
            return combinedInputStream;
        }
        catch (Exception exception) {
            logger.error(TimeStampMessageDigestChecker.b(13738, 2584), exception);
            return combinedInputStream;
        }
        finally {
            try {
                combinedInputStream.close();
            }
            catch (IOException iOException) {
                logger.warn(TimeStampMessageDigestChecker.b(13747, -29160), iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream a(SignedData signedData, SignerInfo signerInfo, DigestAlg digestAlg) throws CMSSignatureException {
        byte[] byArray3 = this.b(signedData);
        ISignable iSignable = null;
        if (signedData.encapContentInfo.eContent == null) {
            try {
                iSignable = (ISignable)this.getParameters().get(TimeStampMessageDigestChecker.b(13728, 2551));
            }
            catch (Exception exception) {
                logger.warn(TimeStampMessageDigestChecker.b(13753, -16908), exception);
                return null;
            }
            if (iSignable == null) {
                return null;
            }
        }
        byte[] byArray2 = this.e(signerInfo);
        byte[] byArray = this.b();
        if (byArray3 == null) return null;
        if (byArray2 == null) {
            return null;
        }
        CombinedInputStream combinedInputStream = new CombinedInputStream();
        try {
            combinedInputStream.addInputStream(new ByteArrayInputStream(byArray3));
            if (iSignable != null) {
                try {
                    byte[] byArray4 = iSignable.getMessageDigest(digestAlg);
                    combinedInputStream.addInputStream(new ByteArrayInputStream(byArray4));
                }
                catch (Exception exception) {
                    throw new ESYARuntimeException(TimeStampMessageDigestChecker.b(13754, 2155), exception);
                }
            }
            try {
                combinedInputStream.addInputStream(new ByteArrayInputStream(DigestUtil.digest(digestAlg, signedData.encapContentInfo.eContent.value)));
            }
            catch (Exception exception) {
                throw new ESYARuntimeException(TimeStampMessageDigestChecker.b(13736, 10802), exception);
            }
            combinedInputStream.addInputStream(new ByteArrayInputStream(byArray2));
            combinedInputStream.addInputStream(new ByteArrayInputStream(byArray));
            return combinedInputStream;
        }
        catch (Exception exception) {
            logger.error(TimeStampMessageDigestChecker.b(13742, 22913), exception);
            return combinedInputStream;
        }
        finally {
            try {
                combinedInputStream.close();
            }
            catch (IOException iOException) {
                logger.warn(TimeStampMessageDigestChecker.b(13747, -29160), iOException);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] a(byte[] byArray) {
        int n2 = CheckerResult.h;
        try {
            Asn1BerDecodeBuffer asn1BerDecodeBuffer = new Asn1BerDecodeBuffer(byArray);
            int n3 = this.matchTag(asn1BerDecodeBuffer, Asn1Tag.SEQUENCE);
            Asn1BerDecodeContext asn1BerDecodeContext = new Asn1BerDecodeContext(asn1BerDecodeBuffer, n3);
            IntHolder intHolder = new IntHolder();
            if (!asn1BerDecodeContext.matchElemTag((short)0, (short)0, 6, intHolder, false)) throw new Asn1MissingRequiredException(asn1BerDecodeBuffer);
            Asn1Type asn1Type = new Asn1ObjectIdentifier();
            ((Asn1ObjectIdentifier)asn1Type).decode(asn1BerDecodeBuffer, true, intHolder.value);
            if (n2 != 0) {
                throw new Asn1MissingRequiredException(asn1BerDecodeBuffer);
            }
            if (!asn1BerDecodeContext.matchElemTag((short)128, (short)32, 0, intHolder, true)) throw new Asn1MissingRequiredException(asn1BerDecodeBuffer);
            asn1Type = new Asn1OpenType();
            ((Asn1OpenType)asn1Type).decode(asn1BerDecodeBuffer, true, 0);
            if (intHolder.value != -9999) return ((Asn1OpenType)asn1Type).value;
            this.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
            return ((Asn1OpenType)asn1Type).value;
        }
        catch (Exception exception) {
            logger.warn(TimeStampMessageDigestChecker.b(13753, -16908), exception);
            return null;
        }
    }

    private byte[] a(SignedData signedData) {
        Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
        try {
            signedData.encapContentInfo.encode(asn1DerEncodeBuffer);
        }
        catch (Exception exception) {
            throw new ESYARuntimeException(TimeStampMessageDigestChecker.b(13737, -4786), exception);
        }
        return asn1DerEncodeBuffer.getMsgCopy();
    }

    private byte[] b(SignedData signedData) {
        Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
        try {
            signedData.encapContentInfo.eContentType.encode(asn1DerEncodeBuffer);
        }
        catch (Exception exception) {
            throw new ESYARuntimeException(TimeStampMessageDigestChecker.b(13757, 26371), exception);
        }
        return asn1DerEncodeBuffer.getMsgCopy();
    }

    private byte[] b() {
        Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
        try {
            EAttribute eAttribute = this.e.getSignerInfo(0).getUnsignedAttribute(AttributeOIDs.id_aa_ATSHashIndex).get(0);
            EATSHashIndex eATSHashIndex = new EATSHashIndex(eAttribute.getValue(0));
            ((EATSHashIndex.MyATSHashIndex)eATSHashIndex.getObject()).encode(asn1DerEncodeBuffer);
        }
        catch (Exception exception) {
            throw new ESYARuntimeException(TimeStampMessageDigestChecker.b(13752, -3548), exception);
        }
        return asn1DerEncodeBuffer.getMsgCopy();
    }

    protected int matchTag(Asn1BerDecodeBuffer paramAsn1BerDecodeBuffer, Asn1Tag paramAsn1Tag) throws Asn1Exception, IOException {
        return this.matchTag(paramAsn1BerDecodeBuffer, paramAsn1Tag.mClass, paramAsn1Tag.mForm, paramAsn1Tag.mIDCode);
    }

    protected int matchTag(Asn1BerDecodeBuffer paramAsn1BerDecodeBuffer, short paramShort1, short paramShort2, int paramInt) throws Asn1Exception, IOException {
        IntHolder intHolder = new IntHolder();
        Asn1Tag asn1Tag = new Asn1Tag();
        if (paramAsn1BerDecodeBuffer.matchTag(paramShort1, paramShort2, paramInt, asn1Tag, intHolder)) {
            return intHolder.value;
        }
        throw new Asn1TagMatchFailedException(paramAsn1BerDecodeBuffer, new Asn1Tag(paramShort1, paramShort2, paramInt), asn1Tag);
    }

    private byte[] a(CertificateSet certificateSet) {
        try {
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            int n2 = certificateSet.encode(asn1DerEncodeBuffer, false);
            asn1DerEncodeBuffer.encodeTagAndLength((short)128, (short)32, 0, n2);
            return asn1DerEncodeBuffer.getMsgCopy();
        }
        catch (Exception exception) {
            logger.warn(TimeStampMessageDigestChecker.b(13753, -16908), exception);
            return null;
        }
    }

    private byte[] a(RevocationInfoChoices revocationInfoChoices) {
        try {
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            int n2 = revocationInfoChoices.encode(asn1DerEncodeBuffer, false);
            asn1DerEncodeBuffer.encodeTagAndLength((short)128, (short)32, 1, n2);
            return asn1DerEncodeBuffer.getMsgCopy();
        }
        catch (Exception exception) {
            logger.warn(TimeStampMessageDigestChecker.b(13753, -16908), exception);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] d(SignerInfo signerInfo) {
        int n2 = CheckerResult.h;
        try {
            TSTInfo tSTInfo = this.c((SignedData)this.e.getObject());
            Attribute[] attributeArray = signerInfo.unsignedAttrs.elements;
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            for (Attribute attribute : attributeArray) {
                if (!(attribute.type.equals(AttributeOIDs.id_aa_ets_archiveTimestampV2) || attribute.type.equals(AttributeOIDs.id_aa_ets_archiveTimestamp) || attribute.type.equals(AttributeOIDs.id_aa_ets_archiveTimestampV3))) {
                    arrayList.add(attribute);
                    if (n2 == 0) continue;
                }
                TSTInfo tSTInfo2 = this.a(attribute);
                if (!tSTInfo2.genTime.getTime().before(tSTInfo.genTime.getTime())) continue;
                arrayList.add(attribute);
                if (n2 == 0) continue;
            }
            signerInfo.unsignedAttrs.elements = arrayList.toArray(new Attribute[0]);
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            signerInfo.encode(asn1DerEncodeBuffer, false);
            signerInfo.unsignedAttrs.elements = attributeArray;
            return asn1DerEncodeBuffer.getMsgCopy();
        }
        catch (Exception exception) {
            logger.error(TimeStampMessageDigestChecker.b(13739, 19824), exception);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] e(SignerInfo signerInfo) {
        int n2 = CheckerResult.h;
        try {
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            if (signerInfo.signature == null) throw new Asn1MissingRequiredException(TimeStampMessageDigestChecker.b(13751, -5467));
            int n3 = signerInfo.signature.encode(asn1DerEncodeBuffer, true);
            if (n2 != 0) {
                throw new Asn1MissingRequiredException(TimeStampMessageDigestChecker.b(13751, -5467));
            }
            if (signerInfo.signatureAlgorithm == null) throw new Asn1MissingRequiredException(TimeStampMessageDigestChecker.b(13741, 3314));
            n3 = signerInfo.signatureAlgorithm.encode(asn1DerEncodeBuffer, true);
            if (n2 != 0) {
                throw new Asn1MissingRequiredException(TimeStampMessageDigestChecker.b(13741, 3314));
            }
            if (signerInfo.signedAttrs != null) {
                n3 = signerInfo.signedAttrs.encode(asn1DerEncodeBuffer, false);
                n3 += asn1DerEncodeBuffer.encodeTagAndLength((short)128, (short)32, 0, n3);
            }
            if (signerInfo.digestAlgorithm == null) throw new Asn1MissingRequiredException(TimeStampMessageDigestChecker.b(13732, 8841));
            n3 = signerInfo.digestAlgorithm.encode(asn1DerEncodeBuffer, true);
            if (n2 != 0) {
                throw new Asn1MissingRequiredException(TimeStampMessageDigestChecker.b(13732, 8841));
            }
            if (signerInfo.sid == null) throw new Asn1MissingRequiredException(TimeStampMessageDigestChecker.b(13734, 30368));
            n3 = signerInfo.sid.encode(asn1DerEncodeBuffer, true);
            if (n2 != 0) {
                throw new Asn1MissingRequiredException(TimeStampMessageDigestChecker.b(13734, 30368));
            }
            if (signerInfo.version == null) throw new Asn1MissingRequiredException(TimeStampMessageDigestChecker.b(13744, 23189));
            n3 = signerInfo.version.encode(asn1DerEncodeBuffer, true);
            if (n2 == 0) return asn1DerEncodeBuffer.getMsgCopy();
            throw new Asn1MissingRequiredException(TimeStampMessageDigestChecker.b(13744, 23189));
        }
        catch (Exception exception) {
            logger.error(TimeStampMessageDigestChecker.b(13729, 23794), exception);
            return null;
        }
    }

    private byte[] a(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    private TSTInfo a(Attribute attribute) throws ESYAException {
        try {
            ContentInfo contentInfo = new ContentInfo();
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(this._getAttributeValue(attribute));
            contentInfo.decode(asn1DerDecodeBuffer);
            SignedData signedData = new SignedData();
            asn1DerDecodeBuffer.reset();
            asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(contentInfo.content.value);
            signedData.decode(asn1DerDecodeBuffer);
            return this.c(signedData);
        }
        catch (Exception exception) {
            throw new ESYAException(exception);
        }
    }

    private TSTInfo c(SignedData signedData) throws ESYAException {
        try {
            TSTInfo tSTInfo = new TSTInfo();
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(signedData.encapContentInfo.eContent.value);
            tSTInfo.decode(asn1DerDecodeBuffer);
            return tSTInfo;
        }
        catch (Exception exception) {
            throw new ESYAException(exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u0018\u00c9cXI\u00e9z\u00caO\"b\u0080y\u00c3\u00e2\u00a3D\u0011FC\u0013}\u0092c=\u00bc\u0096\u0080\u00a3\u00cd/:}?\u00d3\u0012\u00ba\u00fb\u00a607\u00cc2\u00bc\u00a5\u00b2!\u008a\u0003l\u0014\u00f5\u00fc\u00a4\u0010\u00b2\u008e\u00c5\u00cf\u00ac\u00ba\u0097k\u00c2\u00f7\u00ac\u00c0:\u0011\u000e/\u00144\u00ddq\u00e3\u0011R\u00b8\\\u0014\u00bd\u00b6\u0017,r\u00d2\u0010Y\u00ffF\u00ae\u001e^\u00b9\u00ba\u00c7C\u0086{\u001a%\u00a4&\u000f\u00b2\u00f1\u00b0\u0016\u0013\u0012\u001b\u001d\u00c4i\u00bd\u0086\u00ae\u00daf\u009c\u0017\u008d\u000f\u00d6,\u00bb\u0007\u00d5\u0081\u00be cd6=R\u00d3[\r\u0087\u0092\u0017\f\u00c6sj+E\u0003\u00fe\u00a2+\u00030P\u0091(E\u00d6\u0003@\u00b9k\u0005E\u00d2)\u001a\u0093\u0017`\u00cetH\u0013X\u00cf\u00e9\u00ea\u00af-\u00dc^L\u0095D\u00d0\u00c4\u00f1\u008fu\u0088\u009b\u0016\u00e1\u00f6[#%J\u00d5\u00b9\u00aeI\u00c6\u00e3\u0092\u009b\u00d0\u00e8k\bd\u009a\u009aM}\u00e1\u00d49\u00c8\u0082\u00db\u00fcaS\u0017S\u0080\u008c\u009eu\u000f#\u00d3\u008b\u001a\u0010f\u00e0\u009f\u00eb\u00f3\u0006\u00f5\u0004\u008bS\u00bc\u00b1\u008fS?\u000b<twB\u0081\u0098\u0001\u0004Q]q(\u00b6}\u00aa&\u0019lR}^\u00d1\u00c6\u00f6\u0006\u00c7.\u00118\u00e9<\u00df\u00fee\bk\u00ceQ\u001f\u00behBq\u00bb\u00895b[\u0084\u00f9\u00ce\u001b\t\u00f9\u0012\u00c6\u00a6L]9\u00a0G\u001a\u00ec\u00d0\u009bN!hI\u00ff\u00eb\u00cb\u0011A\u00f9Q\u00bd\u00c3\u00d6\\\u00cb\fw5\u00e3\u001eW\u0014\u009f\u00db(*\u00afdu\u0083\u00bf\u000b\u00f29\u00fa\u00e0\u00f2\u008d\u00b5\u0016\u009f\u0091\b\u00ff\u00e0*\u0081hd\u00d2\u00ac\u00ae\u0002\u00f3Q\u00b1q\u00d1\u00ac\u00f0]\u00a2\u00e7\u009d\u00d2&B\r9Q3TkF\u00b3\u00d1\u0098\u00d3\u00ee\u00b1\u00e6\u00d4\u00a5\u0004cG\u00a3\u00d4\u00b2\u000e\u00ddT\u00c7y_m\u00b8P\u00df\u0098\u00a57d|\u0012+\u00cf\u0094\u00b6q\u001c\u00fa\u00a6\u00bc\u00f1\u0002\u00e2ga\u0098Tm\u0090\u0007\u0083\u0085T\u00a9\u0085\u009b\u00c2\u001e\u0019\u00e8R\u00ed^\u00c3\u00d8\u00b2Q\u00b1\u00a8\u00adc\u00a5\u008a\u009cTC\u00f37\u00d9,\u001e.\u00da\u00cf\u00e8>\u00c6\u00d96\u00fc\u00c2\u00c2\u00da\u0091:2V\u00c1\u00c4\u00a4\u0092U\u0082\u00bf\u00b4(o\u00e1\u00ec\u00d8\u00b6\u000f\u00f5\u00b9$\u00a0\u00bdd\u00cb\u00f6g\u0007\u00be\u00e5\u00db5\u00cb\u00a5'x\u00cb\u0003\u00b3>\u00d3Q,\u0094B\u00a7\u0006\u00b0\u00f0\u0014\u00e1\u00fa\u00cb\u0007F\u00ceR\u00cfI\u00cf\u001dYY\u00bb|)\u008c\u00d8\u00fcJ\u000f\u00ba\u00e7\u00f3\u00e4\u00f9\u001a\u00ddOuPi#\u00a0\u00f3%\tud:\u0005\u00f7\u00ab\u009e{\u00d7\r\u00ca[\u00be5\u00f3T\u00cc\u00cf\u0091\u009fd1x(\u0004[\u00a1\u00eb;l\u001c\u0088\u00db\u00b5\u00bc\u001b\u0006\u0088g8\u00bf\u00fc:~\u0092R\u007f\u001e0\u00e3\u00f2\u00ebxl\u00c0\u00d6\u00ffX5\u00c3\u001a4\u008a\u00a8,p\u00e9\u007f\u00cd\u00fb\u00c7l2\u00c7\u00a1z\u00af=\u00ec\u00de\u009a\u00a6d\u00ad\u00d3\u0007\u00acd\u00acZ&\u0081\u00b9\u0086\u0081\u00d8\u00b3\u0087:A\u00d7\u00c2-sl\u00ec\u00e4A\u0098\u0010\u009e\u00ad@\u00ab\u001c6\u0081\u00fa\u0000\u00c5\u00f4\u00861\u00d9o6&1\u00f9W\u00cf\u00fe\u0087\u00cc:\u00d3\u00a0\u00f8\u008fn\u00e4\u00c4\u0007\u008e\u00fe\u00ff\u0097\u0084\u00f7\u00c4L\u0086\u00c1\u0084\u00c7K\u008d\u00ea\u0090L\u00af'\u00b5\u00ca\u00e5(\u0005\u00d3\u000b\u00e0\u00b8\u007f%\u00c7\u00d6y\u009a\u0099\u0007!\u00cc\\\b\u0016Po\u00e8\u00fe\u008f\u00af\u00d8\u000e\u00cc\u009fT\u0091\u00c6\u00d9\u00cfp\u0080;\u0017\u00f5\u00d6\u00d9\u001fTani\u0088\u00b6\u00e7\u00a5!p\u00173\u0080\u00af\u00ba\u00d5\u000b\u0081\u00c6\u007f\u00a5\u00de\u00b7M\u00c6\u00ca\u00bf\u0013\u0084\u00ca_";
                var4_3 = "\u0018\u00c9cXI\u00e9z\u00caO\"b\u0080y\u00c3\u00e2\u00a3D\u0011FC\u0013}\u0092c=\u00bc\u0096\u0080\u00a3\u00cd/:}?\u00d3\u0012\u00ba\u00fb\u00a607\u00cc2\u00bc\u00a5\u00b2!\u008a\u0003l\u0014\u00f5\u00fc\u00a4\u0010\u00b2\u008e\u00c5\u00cf\u00ac\u00ba\u0097k\u00c2\u00f7\u00ac\u00c0:\u0011\u000e/\u00144\u00ddq\u00e3\u0011R\u00b8\\\u0014\u00bd\u00b6\u0017,r\u00d2\u0010Y\u00ffF\u00ae\u001e^\u00b9\u00ba\u00c7C\u0086{\u001a%\u00a4&\u000f\u00b2\u00f1\u00b0\u0016\u0013\u0012\u001b\u001d\u00c4i\u00bd\u0086\u00ae\u00daf\u009c\u0017\u008d\u000f\u00d6,\u00bb\u0007\u00d5\u0081\u00be cd6=R\u00d3[\r\u0087\u0092\u0017\f\u00c6sj+E\u0003\u00fe\u00a2+\u00030P\u0091(E\u00d6\u0003@\u00b9k\u0005E\u00d2)\u001a\u0093\u0017`\u00cetH\u0013X\u00cf\u00e9\u00ea\u00af-\u00dc^L\u0095D\u00d0\u00c4\u00f1\u008fu\u0088\u009b\u0016\u00e1\u00f6[#%J\u00d5\u00b9\u00aeI\u00c6\u00e3\u0092\u009b\u00d0\u00e8k\bd\u009a\u009aM}\u00e1\u00d49\u00c8\u0082\u00db\u00fcaS\u0017S\u0080\u008c\u009eu\u000f#\u00d3\u008b\u001a\u0010f\u00e0\u009f\u00eb\u00f3\u0006\u00f5\u0004\u008bS\u00bc\u00b1\u008fS?\u000b<twB\u0081\u0098\u0001\u0004Q]q(\u00b6}\u00aa&\u0019lR}^\u00d1\u00c6\u00f6\u0006\u00c7.\u00118\u00e9<\u00df\u00fee\bk\u00ceQ\u001f\u00behBq\u00bb\u00895b[\u0084\u00f9\u00ce\u001b\t\u00f9\u0012\u00c6\u00a6L]9\u00a0G\u001a\u00ec\u00d0\u009bN!hI\u00ff\u00eb\u00cb\u0011A\u00f9Q\u00bd\u00c3\u00d6\\\u00cb\fw5\u00e3\u001eW\u0014\u009f\u00db(*\u00afdu\u0083\u00bf\u000b\u00f29\u00fa\u00e0\u00f2\u008d\u00b5\u0016\u009f\u0091\b\u00ff\u00e0*\u0081hd\u00d2\u00ac\u00ae\u0002\u00f3Q\u00b1q\u00d1\u00ac\u00f0]\u00a2\u00e7\u009d\u00d2&B\r9Q3TkF\u00b3\u00d1\u0098\u00d3\u00ee\u00b1\u00e6\u00d4\u00a5\u0004cG\u00a3\u00d4\u00b2\u000e\u00ddT\u00c7y_m\u00b8P\u00df\u0098\u00a57d|\u0012+\u00cf\u0094\u00b6q\u001c\u00fa\u00a6\u00bc\u00f1\u0002\u00e2ga\u0098Tm\u0090\u0007\u0083\u0085T\u00a9\u0085\u009b\u00c2\u001e\u0019\u00e8R\u00ed^\u00c3\u00d8\u00b2Q\u00b1\u00a8\u00adc\u00a5\u008a\u009cTC\u00f37\u00d9,\u001e.\u00da\u00cf\u00e8>\u00c6\u00d96\u00fc\u00c2\u00c2\u00da\u0091:2V\u00c1\u00c4\u00a4\u0092U\u0082\u00bf\u00b4(o\u00e1\u00ec\u00d8\u00b6\u000f\u00f5\u00b9$\u00a0\u00bdd\u00cb\u00f6g\u0007\u00be\u00e5\u00db5\u00cb\u00a5'x\u00cb\u0003\u00b3>\u00d3Q,\u0094B\u00a7\u0006\u00b0\u00f0\u0014\u00e1\u00fa\u00cb\u0007F\u00ceR\u00cfI\u00cf\u001dYY\u00bb|)\u008c\u00d8\u00fcJ\u000f\u00ba\u00e7\u00f3\u00e4\u00f9\u001a\u00ddOuPi#\u00a0\u00f3%\tud:\u0005\u00f7\u00ab\u009e{\u00d7\r\u00ca[\u00be5\u00f3T\u00cc\u00cf\u0091\u009fd1x(\u0004[\u00a1\u00eb;l\u001c\u0088\u00db\u00b5\u00bc\u001b\u0006\u0088g8\u00bf\u00fc:~\u0092R\u007f\u001e0\u00e3\u00f2\u00ebxl\u00c0\u00d6\u00ffX5\u00c3\u001a4\u008a\u00a8,p\u00e9\u007f\u00cd\u00fb\u00c7l2\u00c7\u00a1z\u00af=\u00ec\u00de\u009a\u00a6d\u00ad\u00d3\u0007\u00acd\u00acZ&\u0081\u00b9\u0086\u0081\u00d8\u00b3\u0087:A\u00d7\u00c2-sl\u00ec\u00e4A\u0098\u0010\u009e\u00ad@\u00ab\u001c6\u0081\u00fa\u0000\u00c5\u00f4\u00861\u00d9o6&1\u00f9W\u00cf\u00fe\u0087\u00cc:\u00d3\u00a0\u00f8\u008fn\u00e4\u00c4\u0007\u008e\u00fe\u00ff\u0097\u0084\u00f7\u00c4L\u0086\u00c1\u0084\u00c7K\u008d\u00ea\u0090L\u00af'\u00b5\u00ca\u00e5(\u0005\u00d3\u000b\u00e0\u00b8\u007f%\u00c7\u00d6y\u009a\u0099\u0007!\u00cc\\\b\u0016Po\u00e8\u00fe\u008f\u00af\u00d8\u000e\u00cc\u009fT\u0091\u00c6\u00d9\u00cfp\u0080;\u0017\u00f5\u00d6\u00d9\u001fTani\u0088\u00b6\u00e7\u00a5!p\u00173\u0080\u00af\u00ba\u00d5\u000b\u0081\u00c6\u007f\u00a5\u00de\u00b7M\u00c6\u00ca\u00bf\u0013\u0084\u00ca_".length();
                var1_4 = 35;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "Mb\rT&\f&\u008d\n\b\u0086(]\u0092\u009a!}\u00f0\u0004\u00d0\u0017\u008dm\u0095\u008a\u001d\r\u0010\u00f3\u0016g=\u00afA3\u00d8\u00e4\u00a4m\u00a0\u00ee\u000f\u000f\u0018\"\u00af\u008f.\u00aa";
                    var4_3 = "Mb\rT&\f&\u008d\n\b\u0086(]\u0092\u009a!}\u00f0\u0004\u00d0\u0017\u008dm\u0095\u008a\u001d\r\u0010\u00f3\u0016g=\u00afA3\u00d8\u00e4\u00a4m\u00a0\u00ee\u000f\u000f\u0018\"\u00af\u008f.\u00aa".length();
                    var1_4 = 15;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 45;
                            break;
                        }
                        case 1: {
                            v13 = 125;
                            break;
                        }
                        case 2: {
                            v13 = 75;
                            break;
                        }
                        case 3: {
                            v13 = 12;
                            break;
                        }
                        case 4: {
                            v13 = 51;
                            break;
                        }
                        case 5: {
                            v13 = 93;
                            break;
                        }
                        default: {
                            v13 = 62;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        TimeStampMessageDigestChecker.h = var5;
        TimeStampMessageDigestChecker.i = new String[32];
        TimeStampMessageDigestChecker.logger = LoggerFactory.getLogger(TimeStampMessageDigestChecker.class);
    }

    private static String b(int n2, int n3) {
        int n4 = (n2 ^ 0x35A1) & 0xFFFF;
        if (i[n4] == null) {
            int n5;
            int n6;
            char[] cArray = h[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 34;
                    break;
                }
                case 1: {
                    n6 = 82;
                    break;
                }
                case 2: {
                    n6 = 134;
                    break;
                }
                case 3: {
                    n6 = 169;
                    break;
                }
                case 4: {
                    n6 = 218;
                    break;
                }
                case 5: {
                    n6 = 28;
                    break;
                }
                case 6: {
                    n6 = 5;
                    break;
                }
                case 7: {
                    n6 = 179;
                    break;
                }
                case 8: {
                    n6 = 229;
                    break;
                }
                case 9: {
                    n6 = 85;
                    break;
                }
                case 10: {
                    n6 = 20;
                    break;
                }
                case 11: {
                    n6 = 123;
                    break;
                }
                case 12: {
                    n6 = 81;
                    break;
                }
                case 13: {
                    n6 = 112;
                    break;
                }
                case 14: {
                    n6 = 255;
                    break;
                }
                case 15: {
                    n6 = 174;
                    break;
                }
                case 16: {
                    n6 = 137;
                    break;
                }
                case 17: {
                    n6 = 252;
                    break;
                }
                case 18: {
                    n6 = 128;
                    break;
                }
                case 19: {
                    n6 = 212;
                    break;
                }
                case 20: {
                    n6 = 251;
                    break;
                }
                case 21: {
                    n6 = 44;
                    break;
                }
                case 22: {
                    n6 = 52;
                    break;
                }
                case 23: {
                    n6 = 249;
                    break;
                }
                case 24: {
                    n6 = 21;
                    break;
                }
                case 25: {
                    n6 = 74;
                    break;
                }
                case 26: {
                    n6 = 97;
                    break;
                }
                case 27: {
                    n6 = 147;
                    break;
                }
                case 28: {
                    n6 = 18;
                    break;
                }
                case 29: {
                    n6 = 50;
                    break;
                }
                case 30: {
                    n6 = 79;
                    break;
                }
                case 31: {
                    n6 = 63;
                    break;
                }
                case 32: {
                    n6 = 32;
                    break;
                }
                case 33: {
                    n6 = 23;
                    break;
                }
                case 34: {
                    n6 = 202;
                    break;
                }
                case 35: {
                    n6 = 0;
                    break;
                }
                case 36: {
                    n6 = 65;
                    break;
                }
                case 37: {
                    n6 = 11;
                    break;
                }
                case 38: {
                    n6 = 195;
                    break;
                }
                case 39: {
                    n6 = 200;
                    break;
                }
                case 40: {
                    n6 = 152;
                    break;
                }
                case 41: {
                    n6 = 118;
                    break;
                }
                case 42: {
                    n6 = 55;
                    break;
                }
                case 43: {
                    n6 = 121;
                    break;
                }
                case 44: {
                    n6 = 196;
                    break;
                }
                case 45: {
                    n6 = 131;
                    break;
                }
                case 46: {
                    n6 = 51;
                    break;
                }
                case 47: {
                    n6 = 105;
                    break;
                }
                case 48: {
                    n6 = 108;
                    break;
                }
                case 49: {
                    n6 = 89;
                    break;
                }
                case 50: {
                    n6 = 75;
                    break;
                }
                case 51: {
                    n6 = 61;
                    break;
                }
                case 52: {
                    n6 = 167;
                    break;
                }
                case 53: {
                    n6 = 130;
                    break;
                }
                case 54: {
                    n6 = 95;
                    break;
                }
                case 55: {
                    n6 = 41;
                    break;
                }
                case 56: {
                    n6 = 77;
                    break;
                }
                case 57: {
                    n6 = 53;
                    break;
                }
                case 58: {
                    n6 = 58;
                    break;
                }
                case 59: {
                    n6 = 159;
                    break;
                }
                case 60: {
                    n6 = 201;
                    break;
                }
                case 61: {
                    n6 = 161;
                    break;
                }
                case 62: {
                    n6 = 155;
                    break;
                }
                case 63: {
                    n6 = 172;
                    break;
                }
                case 64: {
                    n6 = 243;
                    break;
                }
                case 65: {
                    n6 = 62;
                    break;
                }
                case 66: {
                    n6 = 133;
                    break;
                }
                case 67: {
                    n6 = 57;
                    break;
                }
                case 68: {
                    n6 = 246;
                    break;
                }
                case 69: {
                    n6 = 187;
                    break;
                }
                case 70: {
                    n6 = 205;
                    break;
                }
                case 71: {
                    n6 = 93;
                    break;
                }
                case 72: {
                    n6 = 191;
                    break;
                }
                case 73: {
                    n6 = 69;
                    break;
                }
                case 74: {
                    n6 = 114;
                    break;
                }
                case 75: {
                    n6 = 185;
                    break;
                }
                case 76: {
                    n6 = 73;
                    break;
                }
                case 77: {
                    n6 = 107;
                    break;
                }
                case 78: {
                    n6 = 110;
                    break;
                }
                case 79: {
                    n6 = 225;
                    break;
                }
                case 80: {
                    n6 = 168;
                    break;
                }
                case 81: {
                    n6 = 88;
                    break;
                }
                case 82: {
                    n6 = 33;
                    break;
                }
                case 83: {
                    n6 = 214;
                    break;
                }
                case 84: {
                    n6 = 100;
                    break;
                }
                case 85: {
                    n6 = 68;
                    break;
                }
                case 86: {
                    n6 = 178;
                    break;
                }
                case 87: {
                    n6 = 45;
                    break;
                }
                case 88: {
                    n6 = 122;
                    break;
                }
                case 89: {
                    n6 = 227;
                    break;
                }
                case 90: {
                    n6 = 26;
                    break;
                }
                case 91: {
                    n6 = 151;
                    break;
                }
                case 92: {
                    n6 = 56;
                    break;
                }
                case 93: {
                    n6 = 12;
                    break;
                }
                case 94: {
                    n6 = 83;
                    break;
                }
                case 95: {
                    n6 = 30;
                    break;
                }
                case 96: {
                    n6 = 46;
                    break;
                }
                case 97: {
                    n6 = 239;
                    break;
                }
                case 98: {
                    n6 = 232;
                    break;
                }
                case 99: {
                    n6 = 244;
                    break;
                }
                case 100: {
                    n6 = 111;
                    break;
                }
                case 101: {
                    n6 = 235;
                    break;
                }
                case 102: {
                    n6 = 38;
                    break;
                }
                case 103: {
                    n6 = 47;
                    break;
                }
                case 104: {
                    n6 = 35;
                    break;
                }
                case 105: {
                    n6 = 163;
                    break;
                }
                case 106: {
                    n6 = 222;
                    break;
                }
                case 107: {
                    n6 = 150;
                    break;
                }
                case 108: {
                    n6 = 80;
                    break;
                }
                case 109: {
                    n6 = 72;
                    break;
                }
                case 110: {
                    n6 = 94;
                    break;
                }
                case 111: {
                    n6 = 87;
                    break;
                }
                case 112: {
                    n6 = 166;
                    break;
                }
                case 113: {
                    n6 = 115;
                    break;
                }
                case 114: {
                    n6 = 129;
                    break;
                }
                case 115: {
                    n6 = 136;
                    break;
                }
                case 116: {
                    n6 = 14;
                    break;
                }
                case 117: {
                    n6 = 103;
                    break;
                }
                case 118: {
                    n6 = 15;
                    break;
                }
                case 119: {
                    n6 = 71;
                    break;
                }
                case 120: {
                    n6 = 248;
                    break;
                }
                case 121: {
                    n6 = 66;
                    break;
                }
                case 122: {
                    n6 = 199;
                    break;
                }
                case 123: {
                    n6 = 31;
                    break;
                }
                case 124: {
                    n6 = 226;
                    break;
                }
                case 125: {
                    n6 = 197;
                    break;
                }
                case 126: {
                    n6 = 149;
                    break;
                }
                case 127: {
                    n6 = 117;
                    break;
                }
                case 128: {
                    n6 = 186;
                    break;
                }
                case 129: {
                    n6 = 207;
                    break;
                }
                case 130: {
                    n6 = 242;
                    break;
                }
                case 131: {
                    n6 = 8;
                    break;
                }
                case 132: {
                    n6 = 116;
                    break;
                }
                case 133: {
                    n6 = 210;
                    break;
                }
                case 134: {
                    n6 = 19;
                    break;
                }
                case 135: {
                    n6 = 9;
                    break;
                }
                case 136: {
                    n6 = 253;
                    break;
                }
                case 137: {
                    n6 = 183;
                    break;
                }
                case 138: {
                    n6 = 60;
                    break;
                }
                case 139: {
                    n6 = 165;
                    break;
                }
                case 140: {
                    n6 = 104;
                    break;
                }
                case 141: {
                    n6 = 142;
                    break;
                }
                case 142: {
                    n6 = 139;
                    break;
                }
                case 143: {
                    n6 = 36;
                    break;
                }
                case 144: {
                    n6 = 216;
                    break;
                }
                case 145: {
                    n6 = 49;
                    break;
                }
                case 146: {
                    n6 = 193;
                    break;
                }
                case 147: {
                    n6 = 230;
                    break;
                }
                case 148: {
                    n6 = 237;
                    break;
                }
                case 149: {
                    n6 = 247;
                    break;
                }
                case 150: {
                    n6 = 3;
                    break;
                }
                case 151: {
                    n6 = 48;
                    break;
                }
                case 152: {
                    n6 = 92;
                    break;
                }
                case 153: {
                    n6 = 190;
                    break;
                }
                case 154: {
                    n6 = 162;
                    break;
                }
                case 155: {
                    n6 = 231;
                    break;
                }
                case 156: {
                    n6 = 209;
                    break;
                }
                case 157: {
                    n6 = 154;
                    break;
                }
                case 158: {
                    n6 = 109;
                    break;
                }
                case 159: {
                    n6 = 78;
                    break;
                }
                case 160: {
                    n6 = 146;
                    break;
                }
                case 161: {
                    n6 = 113;
                    break;
                }
                case 162: {
                    n6 = 153;
                    break;
                }
                case 163: {
                    n6 = 217;
                    break;
                }
                case 164: {
                    n6 = 124;
                    break;
                }
                case 165: {
                    n6 = 37;
                    break;
                }
                case 166: {
                    n6 = 245;
                    break;
                }
                case 167: {
                    n6 = 96;
                    break;
                }
                case 168: {
                    n6 = 98;
                    break;
                }
                case 169: {
                    n6 = 101;
                    break;
                }
                case 170: {
                    n6 = 135;
                    break;
                }
                case 171: {
                    n6 = 238;
                    break;
                }
                case 172: {
                    n6 = 170;
                    break;
                }
                case 173: {
                    n6 = 106;
                    break;
                }
                case 174: {
                    n6 = 189;
                    break;
                }
                case 175: {
                    n6 = 171;
                    break;
                }
                case 176: {
                    n6 = 211;
                    break;
                }
                case 177: {
                    n6 = 144;
                    break;
                }
                case 178: {
                    n6 = 250;
                    break;
                }
                case 179: {
                    n6 = 140;
                    break;
                }
                case 180: {
                    n6 = 164;
                    break;
                }
                case 181: {
                    n6 = 99;
                    break;
                }
                case 182: {
                    n6 = 254;
                    break;
                }
                case 183: {
                    n6 = 7;
                    break;
                }
                case 184: {
                    n6 = 13;
                    break;
                }
                case 185: {
                    n6 = 10;
                    break;
                }
                case 186: {
                    n6 = 125;
                    break;
                }
                case 187: {
                    n6 = 157;
                    break;
                }
                case 188: {
                    n6 = 203;
                    break;
                }
                case 189: {
                    n6 = 208;
                    break;
                }
                case 190: {
                    n6 = 148;
                    break;
                }
                case 191: {
                    n6 = 156;
                    break;
                }
                case 192: {
                    n6 = 206;
                    break;
                }
                case 193: {
                    n6 = 233;
                    break;
                }
                case 194: {
                    n6 = 160;
                    break;
                }
                case 195: {
                    n6 = 221;
                    break;
                }
                case 196: {
                    n6 = 177;
                    break;
                }
                case 197: {
                    n6 = 240;
                    break;
                }
                case 198: {
                    n6 = 236;
                    break;
                }
                case 199: {
                    n6 = 158;
                    break;
                }
                case 200: {
                    n6 = 64;
                    break;
                }
                case 201: {
                    n6 = 184;
                    break;
                }
                case 202: {
                    n6 = 29;
                    break;
                }
                case 203: {
                    n6 = 91;
                    break;
                }
                case 204: {
                    n6 = 138;
                    break;
                }
                case 205: {
                    n6 = 24;
                    break;
                }
                case 206: {
                    n6 = 192;
                    break;
                }
                case 207: {
                    n6 = 2;
                    break;
                }
                case 208: {
                    n6 = 4;
                    break;
                }
                case 209: {
                    n6 = 145;
                    break;
                }
                case 210: {
                    n6 = 84;
                    break;
                }
                case 211: {
                    n6 = 59;
                    break;
                }
                case 212: {
                    n6 = 102;
                    break;
                }
                case 213: {
                    n6 = 180;
                    break;
                }
                case 214: {
                    n6 = 204;
                    break;
                }
                case 215: {
                    n6 = 182;
                    break;
                }
                case 216: {
                    n6 = 241;
                    break;
                }
                case 217: {
                    n6 = 143;
                    break;
                }
                case 218: {
                    n6 = 141;
                    break;
                }
                case 219: {
                    n6 = 119;
                    break;
                }
                case 220: {
                    n6 = 223;
                    break;
                }
                case 221: {
                    n6 = 1;
                    break;
                }
                case 222: {
                    n6 = 27;
                    break;
                }
                case 223: {
                    n6 = 86;
                    break;
                }
                case 224: {
                    n6 = 228;
                    break;
                }
                case 225: {
                    n6 = 194;
                    break;
                }
                case 226: {
                    n6 = 43;
                    break;
                }
                case 227: {
                    n6 = 25;
                    break;
                }
                case 228: {
                    n6 = 42;
                    break;
                }
                case 229: {
                    n6 = 173;
                    break;
                }
                case 230: {
                    n6 = 76;
                    break;
                }
                case 231: {
                    n6 = 17;
                    break;
                }
                case 232: {
                    n6 = 120;
                    break;
                }
                case 233: {
                    n6 = 213;
                    break;
                }
                case 234: {
                    n6 = 6;
                    break;
                }
                case 235: {
                    n6 = 90;
                    break;
                }
                case 236: {
                    n6 = 175;
                    break;
                }
                case 237: {
                    n6 = 176;
                    break;
                }
                case 238: {
                    n6 = 67;
                    break;
                }
                case 239: {
                    n6 = 220;
                    break;
                }
                case 240: {
                    n6 = 132;
                    break;
                }
                case 241: {
                    n6 = 224;
                    break;
                }
                case 242: {
                    n6 = 127;
                    break;
                }
                case 243: {
                    n6 = 70;
                    break;
                }
                case 244: {
                    n6 = 39;
                    break;
                }
                case 245: {
                    n6 = 215;
                    break;
                }
                case 246: {
                    n6 = 188;
                    break;
                }
                case 247: {
                    n6 = 22;
                    break;
                }
                case 248: {
                    n6 = 54;
                    break;
                }
                case 249: {
                    n6 = 16;
                    break;
                }
                case 250: {
                    n6 = 40;
                    break;
                }
                case 251: {
                    n6 = 234;
                    break;
                }
                case 252: {
                    n6 = 198;
                    break;
                }
                case 253: {
                    n6 = 219;
                    break;
                }
                case 254: {
                    n6 = 181;
                    break;
                }
                default: {
                    n6 = 126;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            TimeStampMessageDigestChecker.i[n4] = new String(cArray).intern();
        }
        return i[n4];
    }
}

