/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.crypto.alg;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1OpenType;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.common.OID;
import tr.gov.tubitak.uekae.esya.api.common.crypto.Algorithms;
import tr.gov.tubitak.uekae.esya.api.common.crypto.algorithms._aesValues;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Algorithm;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Mod;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.OAEPPadding;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Padding;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.params.ParamsWithGCMSpec;
import tr.gov.tubitak.uekae.esya.api.crypto.params.ParamsWithIV;
import tr.gov.tubitak.uekae.esya.asn.algorithms.GCMParameters;
import tr.gov.tubitak.uekae.esya.asn.algorithms._algorithmsValues;
import tr.gov.tubitak.uekae.esya.asn.x509.AlgorithmIdentifier;

public class CipherAlg
implements Algorithm {
    private static Map<OID, CipherAlg> a;
    private static Map<String, CipherAlg> b;
    public static final CipherAlg AES128_CBC;
    public static final CipherAlg AES128_CBC_NOPADDING;
    public static final CipherAlg AES128_CFB;
    public static final CipherAlg AES128_ECB;
    public static final CipherAlg AES128_ECB_NOPADDING;
    public static final CipherAlg AES128_OFB;
    public static final CipherAlg AES128_GCM;
    public static final CipherAlg AES192_CBC;
    public static final CipherAlg AES192_CBC_NOPADDING;
    public static final CipherAlg AES192_CFB;
    public static final CipherAlg AES192_ECB;
    public static final CipherAlg AES192_ECB_NOPADDING;
    public static final CipherAlg AES192_OFB;
    public static final CipherAlg AES192_GCM;
    public static final CipherAlg AES256_CBC;
    public static final CipherAlg AES256_CBC_NOPADDING;
    public static final CipherAlg AES256_CFB;
    public static final CipherAlg AES256_ECB;
    public static final CipherAlg AES256_ECB_NOPADDING;
    public static final CipherAlg AES256_OFB;
    public static final CipherAlg AES256_GCM;
    public static final CipherAlg RC2_CBC;
    public static final CipherAlg DES_CBC;
    public static final CipherAlg DES_CBC_NOPADDING;
    public static final CipherAlg DES_ECB;
    public static final CipherAlg DES_ECB_NOPADDING;
    public static final CipherAlg DES_EDE3_CBC;
    public static final CipherAlg DES_EDE3_CBC_NOPADDING;
    public static final CipherAlg DES_EDE3_ECB;
    public static final CipherAlg DES_EDE3_ECB_NOPADDING;
    public static final CipherAlg RSA_PKCS1;
    public static final CipherAlg RSA_RAW;
    @Deprecated
    public static final CipherAlg RSA_OAEP;
    public static final CipherAlg RSA_ECB_PKCS1;
    @Deprecated
    public static final CipherAlg RSA_ECB_OAEP;
    public static final CipherAlg RSA_OAEP_SHA256;
    public static final CipherAlg RSA_OAEP_SHA512;
    protected int[] mOID;
    protected String mName;
    protected int mBlockSize;
    protected Mod mMod;
    protected Padding mPadding;
    public static boolean c;
    private static final String[] f;
    private static final String[] g;

    public CipherAlg(int[] aOId, String aName, int aBlockSize, Mod aMod, Padding aPadding) {
        this(aOId, aName, aBlockSize, aMod, aPadding, true);
    }

    public CipherAlg(int[] aOId, String aName, int aBlockSize, Mod aMod, Padding aPadding, boolean addToRegistry) {
        this.mOID = aOId;
        this.mName = aName;
        this.mBlockSize = aBlockSize;
        this.mMod = aMod;
        this.mPadding = aPadding;
        if (addToRegistry && aOId != null) {
            OID oID = new OID(aOId);
            a.put(oID, this);
        }
        b.put(aName, this);
    }

    @Override
    public int[] getOID() {
        return this.mOID;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public int getBlockSize() {
        return this.mBlockSize;
    }

    public Mod getMod() {
        return this.mMod;
    }

    public Padding getPadding() {
        return this.mPadding;
    }

    public EAlgorithmIdentifier toAlgorithmIdentifier(byte[] aIV) throws CryptoException {
        EAlgorithmIdentifier eAlgorithmIdentifier = new EAlgorithmIdentifier(new AlgorithmIdentifier());
        eAlgorithmIdentifier.setAlgorithm(new Asn1ObjectIdentifier(this.getOID()));
        if (aIV != null) {
            try {
                Asn1OctetString asn1OctetString = new Asn1OctetString(aIV);
                Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                asn1OctetString.encode(asn1DerEncodeBuffer);
                Asn1OpenType asn1OpenType = new Asn1OpenType(asn1DerEncodeBuffer.getMsgCopy());
                eAlgorithmIdentifier.setParameters(asn1OpenType);
            }
            catch (Asn1Exception asn1Exception) {
                throw new CryptoException(CipherAlg.a(-29954, 19223), asn1Exception);
            }
        }
        return eAlgorithmIdentifier;
    }

    public static CipherAlg fromOID(int[] aOid) {
        OID oID = new OID(aOid);
        return a.get(oID);
    }

    public static CipherAlg fromName(String aAlgName) {
        return b.get(aAlgName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Pair<CipherAlg, AlgorithmParams> fromAlgorithmIdentifier(EAlgorithmIdentifier aAlgoritma) throws CryptoException {
        Object object;
        int[] nArray = aAlgoritma.getAlgorithm().value;
        Asn1OpenType asn1OpenType = aAlgoritma.getParameters();
        Asn1OctetString asn1OctetString = new Asn1OctetString();
        ParamsWithIV paramsWithIV = null;
        if (Arrays.equals(nArray, _algorithmsValues.id_RSAES_OAEP)) {
            try {
                OAEPPadding oAEPPadding = null;
                if (asn1OpenType.equals(new byte[]{48, 0})) {
                    oAEPPadding = OAEPPadding.OAEP_SHA1_MGF1;
                    return new Pair<CipherAlg, Object>(new CipherAlg(_algorithmsValues.id_RSAES_OAEP, CipherAlg.a(-29956, -9368), 0, Mod.NONE, oAEPPadding), null);
                }
                oAEPPadding = OAEPPadding.fromRSAES_OAEP_params(asn1OpenType.value);
                return new Pair<CipherAlg, Object>(new CipherAlg(_algorithmsValues.id_RSAES_OAEP, CipherAlg.a(-29956, -9368), 0, Mod.NONE, oAEPPadding), null);
            }
            catch (IOException iOException) {
                throw new CryptoException(CipherAlg.a(-29968, -19467), iOException);
            }
        }
        if (asn1OpenType != null && asn1OpenType.value.length > 1 && (asn1OpenType.value[0] != 5 || asn1OpenType.value[1] != 0)) {
            try {
                if (CipherAlg.isGCMOID(nArray)) {
                    object = new Asn1DerDecodeBuffer(asn1OpenType.value);
                    GCMParameters gCMParameters = new GCMParameters();
                    gCMParameters.decode((Asn1BerDecodeBuffer)object);
                    asn1OctetString = gCMParameters.aes_nonce;
                    paramsWithIV = new ParamsWithGCMSpec(asn1OctetString.value);
                } else {
                    object = new Asn1DerEncodeBuffer();
                    asn1OpenType.encode((Asn1BerEncodeBuffer)object);
                    Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(((Asn1BerEncodeBuffer)object).getMsgCopy());
                    asn1OctetString.decode(asn1DerDecodeBuffer);
                    paramsWithIV = new ParamsWithIV(asn1OctetString.value);
                }
            }
            catch (Asn1Exception asn1Exception) {
                throw new CryptoException(CipherAlg.a(-29967, -7990), asn1Exception);
            }
            catch (IOException iOException) {
                throw new CryptoException(CipherAlg.a(-29958, 22549), iOException);
            }
        }
        object = CipherAlg.fromOID(nArray);
        return new Pair<CipherAlg, Object>(new CipherAlg(((CipherAlg)object).getOID(), ((CipherAlg)object).getName(), ((CipherAlg)object).getBlockSize(), ((CipherAlg)object).getMod(), ((CipherAlg)object).getPadding()), paramsWithIV);
    }

    public static boolean isGCMOID(int[] oid) {
        block7: {
            block6: {
                if (Arrays.equals(oid, _aesValues.id_aes128_GCM) || Arrays.equals(oid, _aesValues.id_aes192_GCM)) break block6;
                if (!Arrays.equals(oid, _aesValues.id_aes256_GCM)) break block7;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.mName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o2) {
        CipherAlg cipherAlg;
        block28: {
            block27: {
                block26: {
                    if (this == o2) {
                        return true;
                    }
                    if (o2 != null && this.getClass() == o2.getClass()) break block26;
                    return false;
                }
                cipherAlg = (CipherAlg)o2;
                if (this.mBlockSize != cipherAlg.mBlockSize) {
                    return false;
                }
                if (this.mMod != cipherAlg.mMod) {
                    return false;
                }
                if (this.mName == null) break block27;
                if (this.mName.equals(cipherAlg.mName)) break block28;
                return false;
            }
            if (cipherAlg.mName == null) break block28;
            return false;
        }
        if (!Arrays.equals(this.mOID, cipherAlg.mOID)) {
            return false;
        }
        if (this.mPadding == cipherAlg.mPadding) return true;
        return false;
    }

    public int hashCode() {
        int n2;
        block12: {
            boolean bl;
            block14: {
                block13: {
                    boolean bl2 = DigestAlg.e;
                    int n3 = this.mOID != null ? Arrays.hashCode(this.mOID) : 0;
                    int n4 = n3;
                    int n5 = 31 * n4;
                    int n6 = this.mName != null ? this.mName.hashCode() : 0;
                    n4 = n5 + n6;
                    n4 = 31 * n4 + this.mBlockSize;
                    int n7 = 31 * n4;
                    int n8 = this.mMod != null ? this.mMod.hashCode() : 0;
                    n4 = n7 + n8;
                    int n9 = 31 * n4;
                    int n10 = this.mPadding != null ? this.mPadding.hashCode() : 0;
                    n4 = n9 + n10;
                    n2 = n4;
                    if (!bl2) break block12;
                    if (!CryptoException.b) break block13;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
            CryptoException.b = bl;
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[12];
                var3_1 = 0;
                var2_2 = "\u00fc\u00a9\u00b6\u00fc)\u00a5c\u00e0\u0087\u009e$j*1=\u00b1\u00aaud\u00f7\u00ea\u00a3Z2/Mz\u00f2\u001e\bF%\u00ead3\u0005\u00b7\u0154\u0097\u00cc\u00e0\u00abH\u00ad\u0176\u00f7\u0120\u009dV\u009b2\u0099@\u00be\u00ab\u00d5\u00de\b\u0090;\u0164zc\r#x>\u00d4(\u00ad\u00e2'dE\u00ca\u0083\u00d2\u0014\u001ep\u0099\u00d5\u00dc\u008d|#\u00b7\u00c5\u00b0\u0093\u009d\u009e\u00cb\u00c1\u0002\u0081\u00d0#\u0014\u00bcR\u00cd\u0091V\u0005-2\u009d\u00e7\u00f5\u00d75\u0016\u00de\u00d0\u00a0\u00a4\u0080d\u001d\b\u0080\u0005\u00f1\u00eb\u00f2\u0004\u0007hoe\u0080\u008d\u009e\u0092c\u0097i\u009b\u00daL\u0006\u00c3\u00ed\u00f8\u0011\u009dc\u0016\u000e@WR1\u00a5\u0011S\u00b0R\u00a8\u0006\u00c4\u0003\u00ac\r\u001b\u00e19\u00e7\u00c8\u00cb\u00fe\u00eb\u00e7\u00dc\u00ba\u00b0\u00dc\f[t1U\u00c2\u0091\u00d9G\u00ee`\u00f3\u00fd\r\u00eb\u00ed'f\u0000\u00f7\u0081\u008b\u00fa\u00f3\u008b\u00c7\u00d9";
                var4_3 = "\u00fc\u00a9\u00b6\u00fc)\u00a5c\u00e0\u0087\u009e$j*1=\u00b1\u00aaud\u00f7\u00ea\u00a3Z2/Mz\u00f2\u001e\bF%\u00ead3\u0005\u00b7\u0154\u0097\u00cc\u00e0\u00abH\u00ad\u0176\u00f7\u0120\u009dV\u009b2\u0099@\u00be\u00ab\u00d5\u00de\b\u0090;\u0164zc\r#x>\u00d4(\u00ad\u00e2'dE\u00ca\u0083\u00d2\u0014\u001ep\u0099\u00d5\u00dc\u008d|#\u00b7\u00c5\u00b0\u0093\u009d\u009e\u00cb\u00c1\u0002\u0081\u00d0#\u0014\u00bcR\u00cd\u0091V\u0005-2\u009d\u00e7\u00f5\u00d75\u0016\u00de\u00d0\u00a0\u00a4\u0080d\u001d\b\u0080\u0005\u00f1\u00eb\u00f2\u0004\u0007hoe\u0080\u008d\u009e\u0092c\u0097i\u009b\u00daL\u0006\u00c3\u00ed\u00f8\u0011\u009dc\u0016\u000e@WR1\u00a5\u0011S\u00b0R\u00a8\u0006\u00c4\u0003\u00ac\r\u001b\u00e19\u00e7\u00c8\u00cb\u00fe\u00eb\u00e7\u00dc\u00ba\u00b0\u00dc\f[t1U\u00c2\u0091\u00d9G\u00ee`\u00f3\u00fd\r\u00eb\u00ed'f\u0000\u00f7\u0081\u008b\u00fa\u00f3\u008b\u00c7\u00d9".length();
                var1_4 = 13;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00f7\u009a\u00f3\u0010O[\u008f6\u00f6\u0080\u00ba\u001b\u00c88HQ\u008c\u000e\u00b3\u0001\u0018\u00a9\u00d2\u01c1;~u\u00fd\u00fag\u0120\u00ae\u01ea\u00b6\u000f\u00fe\u00195%+\u0007gK^\"\u00f1\u0132#\u00a9:\u008b\u0096|\u0091\u00bek\u00b101@B\u0003\u00d7;\u00ab1\u00f0\u0002:\u0097\u008a\u00ba\f~\t\u000b\u00bf\u001e\u00ae\u00e7m\u00ae5\u00cb\u001b\u00a8\u00ef3x\u01d22\u0152\u00e6\u00a6\u0086q\u00f1WU\u008a\u0016\u0088-\u0091\u00e0\u01a2\u00c2\u0005";
                    var4_3 = "\u00f7\u009a\u00f3\u0010O[\u008f6\u00f6\u0080\u00ba\u001b\u00c88HQ\u008c\u000e\u00b3\u0001\u0018\u00a9\u00d2\u01c1;~u\u00fd\u00fag\u0120\u00ae\u01ea\u00b6\u000f\u00fe\u00195%+\u0007gK^\"\u00f1\u0132#\u00a9:\u008b\u0096|\u0091\u00bek\u00b101@B\u0003\u00d7;\u00ab1\u00f0\u0002:\u0097\u008a\u00ba\f~\t\u000b\u00bf\u001e\u00ae\u00e7m\u00ae5\u00cb\u001b\u00a8\u00ef3x\u01d22\u0152\u00e6\u00a6\u0086q\u00f1WU\u008a\u0016\u0088-\u0091\u00e0\u01a2\u00c2\u0005".length();
                    var1_4 = 49;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 58;
                            break;
                        }
                        case 1: {
                            v13 = 84;
                            break;
                        }
                        case 2: {
                            v13 = 68;
                            break;
                        }
                        case 3: {
                            v13 = 71;
                            break;
                        }
                        case 4: {
                            v13 = 64;
                            break;
                        }
                        case 5: {
                            v13 = 90;
                            break;
                        }
                        default: {
                            v13 = 38;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CipherAlg.f = var5;
        CipherAlg.g = new String[12];
        CipherAlg.a = new HashMap<OID, CipherAlg>();
        CipherAlg.b = new HashMap<String, CipherAlg>();
        CipherAlg.AES128_CBC = new CipherAlg(_aesValues.id_aes128_CBC, Algorithms.CIPHER_AES128_CBC, 16, Mod.CBC, Padding.PKCS7);
        CipherAlg.AES128_CBC_NOPADDING = new CipherAlg(_aesValues.id_aes128_CBC, Algorithms.CIPHER_AES128_CBC_NOPADDING, 16, Mod.CBC, Padding.NONE, false);
        CipherAlg.AES128_CFB = new CipherAlg(_aesValues.id_aes128_CFB, Algorithms.CIPHER_AES128_CFB, 16, Mod.CFB, Padding.PKCS7);
        CipherAlg.AES128_ECB = new CipherAlg(_aesValues.id_aes128_ECB, Algorithms.CIPHER_AES128_ECB, 16, Mod.ECB, Padding.PKCS7);
        CipherAlg.AES128_ECB_NOPADDING = new CipherAlg(_aesValues.id_aes128_ECB, Algorithms.CIPHER_AES128_ECB_NOPADDING, 16, Mod.ECB, Padding.NONE, false);
        CipherAlg.AES128_OFB = new CipherAlg(_aesValues.id_aes128_OFB, Algorithms.CIPHER_AES128_OFB, 16, Mod.OFB, Padding.PKCS7);
        CipherAlg.AES128_GCM = new CipherAlg(_aesValues.id_aes128_GCM, Algorithms.CIPHER_AES128_GCM, 16, Mod.GCM, Padding.NONE);
        CipherAlg.AES192_CBC = new CipherAlg(_aesValues.id_aes192_CBC, Algorithms.CIPHER_AES192_CBC, 16, Mod.CBC, Padding.PKCS7);
        CipherAlg.AES192_CBC_NOPADDING = new CipherAlg(_aesValues.id_aes192_CBC, Algorithms.CIPHER_AES192_CBC_NOPADDING, 16, Mod.CBC, Padding.NONE, false);
        CipherAlg.AES192_CFB = new CipherAlg(_aesValues.id_aes192_CFB, Algorithms.CIPHER_AES192_CFB, 16, Mod.CFB, Padding.PKCS7);
        CipherAlg.AES192_ECB = new CipherAlg(_aesValues.id_aes192_ECB, Algorithms.CIPHER_AES192_ECB, 16, Mod.ECB, Padding.PKCS7);
        CipherAlg.AES192_ECB_NOPADDING = new CipherAlg(_aesValues.id_aes192_ECB, Algorithms.CIPHER_AES192_ECB_NOPADDING, 16, Mod.ECB, Padding.NONE, false);
        CipherAlg.AES192_OFB = new CipherAlg(_aesValues.id_aes192_OFB, Algorithms.CIPHER_AES192_OFB, 16, Mod.OFB, Padding.PKCS7);
        CipherAlg.AES192_GCM = new CipherAlg(_aesValues.id_aes192_GCM, Algorithms.CIPHER_AES192_GCM, 16, Mod.GCM, Padding.NONE);
        CipherAlg.AES256_CBC = new CipherAlg(_aesValues.id_aes256_CBC, Algorithms.CIPHER_AES256_CBC, 16, Mod.CBC, Padding.PKCS7);
        CipherAlg.AES256_CBC_NOPADDING = new CipherAlg(_aesValues.id_aes256_CBC, Algorithms.CIPHER_AES256_CBC_NOPADDING, 16, Mod.CBC, Padding.NONE, false);
        CipherAlg.AES256_CFB = new CipherAlg(_aesValues.id_aes256_CFB, Algorithms.CIPHER_AES256_CFB, 16, Mod.CFB, Padding.PKCS7);
        CipherAlg.AES256_ECB = new CipherAlg(_aesValues.id_aes256_ECB, Algorithms.CIPHER_AES256_ECB, 16, Mod.ECB, Padding.PKCS7);
        CipherAlg.AES256_ECB_NOPADDING = new CipherAlg(_aesValues.id_aes256_ECB, Algorithms.CIPHER_AES256_ECB_NOPADDING, 16, Mod.ECB, Padding.NONE, false);
        CipherAlg.AES256_OFB = new CipherAlg(_aesValues.id_aes256_OFB, Algorithms.CIPHER_AES256_OFB, 16, Mod.OFB, Padding.PKCS7);
        CipherAlg.AES256_GCM = new CipherAlg(_aesValues.id_aes256_GCM, Algorithms.CIPHER_AES256_GCM, 16, Mod.GCM, Padding.NONE);
        CipherAlg.RC2_CBC = new CipherAlg(_algorithmsValues.rc2_cbc, CipherAlg.a(-29957, -20089), 8, Mod.CBC, Padding.PKCS7);
        CipherAlg.DES_CBC = new CipherAlg(_algorithmsValues.des_cbc, Algorithms.CIPHER_DES_CBC, 8, Mod.CBC, Padding.PKCS7);
        CipherAlg.DES_CBC_NOPADDING = new CipherAlg(_algorithmsValues.des_cbc, Algorithms.CIPHER_DES_CBC_NOPADDING, 8, Mod.CBC, Padding.NONE, false);
        CipherAlg.DES_ECB = new CipherAlg(_algorithmsValues.des_ecb, Algorithms.CIPHER_DES_ECB, 8, Mod.ECB, Padding.PKCS7);
        CipherAlg.DES_ECB_NOPADDING = new CipherAlg(_algorithmsValues.des_ecb, Algorithms.CIPHER_DES_ECB_NOPADDING, 8, Mod.ECB, Padding.NONE, false);
        CipherAlg.DES_EDE3_CBC = new CipherAlg(_algorithmsValues.des_EDE3_CBC, Algorithms.CIPHER_DES_EDE3_CBC, 8, Mod.CBC, Padding.PKCS7);
        CipherAlg.DES_EDE3_CBC_NOPADDING = new CipherAlg(_algorithmsValues.des_EDE3_CBC, Algorithms.CIPHER_DES_EDE3_CBC_NOPADDING, 8, Mod.CBC, Padding.NONE, false);
        CipherAlg.DES_EDE3_ECB = new CipherAlg(_algorithmsValues.des_EDE3_ECB, Algorithms.CIPHER_DES_EDE3_ECB, 8, Mod.ECB, Padding.PKCS7);
        CipherAlg.DES_EDE3_ECB_NOPADDING = new CipherAlg(_algorithmsValues.des_EDE3_ECB, Algorithms.CIPHER_DES_EDE3_ECB_NOPADDING, 8, Mod.ECB, Padding.NONE, false);
        CipherAlg.RSA_PKCS1 = new CipherAlg(_algorithmsValues.rsaEncryption, CipherAlg.a(-29955, -2097), 0, Mod.NONE, Padding.PKCS1);
        CipherAlg.RSA_RAW = new CipherAlg(null, Algorithms.CIPHER_RSA_RAW, 0, Mod.NONE, Padding.NONE);
        CipherAlg.RSA_OAEP = new CipherAlg(_algorithmsValues.id_RSAES_OAEP, CipherAlg.a(-29959, 26419), 0, Mod.NONE, OAEPPadding.OAEP_SHA1_MGF1);
        CipherAlg.RSA_ECB_PKCS1 = new CipherAlg(null, CipherAlg.a(-29966, 15316), 0, Mod.ECB, Padding.PKCS1);
        CipherAlg.RSA_ECB_OAEP = new CipherAlg(null, CipherAlg.a(-29965, 12014), 0, Mod.ECB, OAEPPadding.OAEP_SHA1_MGF1);
        CipherAlg.RSA_OAEP_SHA256 = new CipherAlg(_algorithmsValues.id_RSAES_OAEP, CipherAlg.a(-29953, -2186), 0, Mod.NONE, OAEPPadding.OAEP_SHA256_MGF1);
        CipherAlg.RSA_OAEP_SHA512 = new CipherAlg(_algorithmsValues.id_RSAES_OAEP, CipherAlg.a(-29960, 10536), 0, Mod.NONE, OAEPPadding.OAEP_SHA512_MGF1);
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0xFFFF8AFB) & 0xFFFF;
        if (g[n4] == null) {
            int n5;
            int n6;
            char[] cArray = f[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 24;
                    break;
                }
                case 1: {
                    n6 = 87;
                    break;
                }
                case 2: {
                    n6 = 161;
                    break;
                }
                case 3: {
                    n6 = 15;
                    break;
                }
                case 4: {
                    n6 = 54;
                    break;
                }
                case 5: {
                    n6 = 114;
                    break;
                }
                case 6: {
                    n6 = 189;
                    break;
                }
                case 7: {
                    n6 = 207;
                    break;
                }
                case 8: {
                    n6 = 125;
                    break;
                }
                case 9: {
                    n6 = 67;
                    break;
                }
                case 10: {
                    n6 = 126;
                    break;
                }
                case 11: {
                    n6 = 10;
                    break;
                }
                case 12: {
                    n6 = 216;
                    break;
                }
                case 13: {
                    n6 = 112;
                    break;
                }
                case 14: {
                    n6 = 27;
                    break;
                }
                case 15: {
                    n6 = 241;
                    break;
                }
                case 16: {
                    n6 = 58;
                    break;
                }
                case 17: {
                    n6 = 60;
                    break;
                }
                case 18: {
                    n6 = 110;
                    break;
                }
                case 19: {
                    n6 = 84;
                    break;
                }
                case 20: {
                    n6 = 19;
                    break;
                }
                case 21: {
                    n6 = 107;
                    break;
                }
                case 22: {
                    n6 = 20;
                    break;
                }
                case 23: {
                    n6 = 26;
                    break;
                }
                case 24: {
                    n6 = 78;
                    break;
                }
                case 25: {
                    n6 = 232;
                    break;
                }
                case 26: {
                    n6 = 215;
                    break;
                }
                case 27: {
                    n6 = 103;
                    break;
                }
                case 28: {
                    n6 = 131;
                    break;
                }
                case 29: {
                    n6 = 194;
                    break;
                }
                case 30: {
                    n6 = 244;
                    break;
                }
                case 31: {
                    n6 = 100;
                    break;
                }
                case 32: {
                    n6 = 11;
                    break;
                }
                case 33: {
                    n6 = 245;
                    break;
                }
                case 34: {
                    n6 = 99;
                    break;
                }
                case 35: {
                    n6 = 227;
                    break;
                }
                case 36: {
                    n6 = 178;
                    break;
                }
                case 37: {
                    n6 = 168;
                    break;
                }
                case 38: {
                    n6 = 220;
                    break;
                }
                case 39: {
                    n6 = 198;
                    break;
                }
                case 40: {
                    n6 = 120;
                    break;
                }
                case 41: {
                    n6 = 173;
                    break;
                }
                case 42: {
                    n6 = 77;
                    break;
                }
                case 43: {
                    n6 = 38;
                    break;
                }
                case 44: {
                    n6 = 214;
                    break;
                }
                case 45: {
                    n6 = 191;
                    break;
                }
                case 46: {
                    n6 = 52;
                    break;
                }
                case 47: {
                    n6 = 57;
                    break;
                }
                case 48: {
                    n6 = 49;
                    break;
                }
                case 49: {
                    n6 = 163;
                    break;
                }
                case 50: {
                    n6 = 164;
                    break;
                }
                case 51: {
                    n6 = 1;
                    break;
                }
                case 52: {
                    n6 = 196;
                    break;
                }
                case 53: {
                    n6 = 71;
                    break;
                }
                case 54: {
                    n6 = 7;
                    break;
                }
                case 55: {
                    n6 = 137;
                    break;
                }
                case 56: {
                    n6 = 91;
                    break;
                }
                case 57: {
                    n6 = 172;
                    break;
                }
                case 58: {
                    n6 = 211;
                    break;
                }
                case 59: {
                    n6 = 166;
                    break;
                }
                case 60: {
                    n6 = 185;
                    break;
                }
                case 61: {
                    n6 = 115;
                    break;
                }
                case 62: {
                    n6 = 246;
                    break;
                }
                case 63: {
                    n6 = 184;
                    break;
                }
                case 64: {
                    n6 = 199;
                    break;
                }
                case 65: {
                    n6 = 39;
                    break;
                }
                case 66: {
                    n6 = 254;
                    break;
                }
                case 67: {
                    n6 = 224;
                    break;
                }
                case 68: {
                    n6 = 152;
                    break;
                }
                case 69: {
                    n6 = 138;
                    break;
                }
                case 70: {
                    n6 = 106;
                    break;
                }
                case 71: {
                    n6 = 235;
                    break;
                }
                case 72: {
                    n6 = 23;
                    break;
                }
                case 73: {
                    n6 = 42;
                    break;
                }
                case 74: {
                    n6 = 25;
                    break;
                }
                case 75: {
                    n6 = 36;
                    break;
                }
                case 76: {
                    n6 = 156;
                    break;
                }
                case 77: {
                    n6 = 56;
                    break;
                }
                case 78: {
                    n6 = 73;
                    break;
                }
                case 79: {
                    n6 = 142;
                    break;
                }
                case 80: {
                    n6 = 14;
                    break;
                }
                case 81: {
                    n6 = 30;
                    break;
                }
                case 82: {
                    n6 = 86;
                    break;
                }
                case 83: {
                    n6 = 225;
                    break;
                }
                case 84: {
                    n6 = 165;
                    break;
                }
                case 85: {
                    n6 = 201;
                    break;
                }
                case 86: {
                    n6 = 221;
                    break;
                }
                case 87: {
                    n6 = 122;
                    break;
                }
                case 88: {
                    n6 = 158;
                    break;
                }
                case 89: {
                    n6 = 127;
                    break;
                }
                case 90: {
                    n6 = 46;
                    break;
                }
                case 91: {
                    n6 = 40;
                    break;
                }
                case 92: {
                    n6 = 121;
                    break;
                }
                case 93: {
                    n6 = 2;
                    break;
                }
                case 94: {
                    n6 = 69;
                    break;
                }
                case 95: {
                    n6 = 212;
                    break;
                }
                case 96: {
                    n6 = 33;
                    break;
                }
                case 97: {
                    n6 = 187;
                    break;
                }
                case 98: {
                    n6 = 88;
                    break;
                }
                case 99: {
                    n6 = 9;
                    break;
                }
                case 100: {
                    n6 = 35;
                    break;
                }
                case 101: {
                    n6 = 250;
                    break;
                }
                case 102: {
                    n6 = 90;
                    break;
                }
                case 103: {
                    n6 = 144;
                    break;
                }
                case 104: {
                    n6 = 240;
                    break;
                }
                case 105: {
                    n6 = 0;
                    break;
                }
                case 106: {
                    n6 = 177;
                    break;
                }
                case 107: {
                    n6 = 66;
                    break;
                }
                case 108: {
                    n6 = 82;
                    break;
                }
                case 109: {
                    n6 = 146;
                    break;
                }
                case 110: {
                    n6 = 136;
                    break;
                }
                case 111: {
                    n6 = 236;
                    break;
                }
                case 112: {
                    n6 = 95;
                    break;
                }
                case 113: {
                    n6 = 74;
                    break;
                }
                case 114: {
                    n6 = 200;
                    break;
                }
                case 115: {
                    n6 = 61;
                    break;
                }
                case 116: {
                    n6 = 104;
                    break;
                }
                case 117: {
                    n6 = 238;
                    break;
                }
                case 118: {
                    n6 = 230;
                    break;
                }
                case 119: {
                    n6 = 206;
                    break;
                }
                case 120: {
                    n6 = 53;
                    break;
                }
                case 121: {
                    n6 = 252;
                    break;
                }
                case 122: {
                    n6 = 167;
                    break;
                }
                case 123: {
                    n6 = 8;
                    break;
                }
                case 124: {
                    n6 = 6;
                    break;
                }
                case 125: {
                    n6 = 72;
                    break;
                }
                case 126: {
                    n6 = 17;
                    break;
                }
                case 127: {
                    n6 = 190;
                    break;
                }
                case 128: {
                    n6 = 155;
                    break;
                }
                case 129: {
                    n6 = 210;
                    break;
                }
                case 130: {
                    n6 = 226;
                    break;
                }
                case 131: {
                    n6 = 179;
                    break;
                }
                case 132: {
                    n6 = 149;
                    break;
                }
                case 133: {
                    n6 = 43;
                    break;
                }
                case 134: {
                    n6 = 162;
                    break;
                }
                case 135: {
                    n6 = 16;
                    break;
                }
                case 136: {
                    n6 = 48;
                    break;
                }
                case 137: {
                    n6 = 130;
                    break;
                }
                case 138: {
                    n6 = 170;
                    break;
                }
                case 139: {
                    n6 = 80;
                    break;
                }
                case 140: {
                    n6 = 31;
                    break;
                }
                case 141: {
                    n6 = 141;
                    break;
                }
                case 142: {
                    n6 = 239;
                    break;
                }
                case 143: {
                    n6 = 251;
                    break;
                }
                case 144: {
                    n6 = 116;
                    break;
                }
                case 145: {
                    n6 = 222;
                    break;
                }
                case 146: {
                    n6 = 151;
                    break;
                }
                case 147: {
                    n6 = 217;
                    break;
                }
                case 148: {
                    n6 = 55;
                    break;
                }
                case 149: {
                    n6 = 70;
                    break;
                }
                case 150: {
                    n6 = 153;
                    break;
                }
                case 151: {
                    n6 = 85;
                    break;
                }
                case 152: {
                    n6 = 209;
                    break;
                }
                case 153: {
                    n6 = 234;
                    break;
                }
                case 154: {
                    n6 = 135;
                    break;
                }
                case 155: {
                    n6 = 101;
                    break;
                }
                case 156: {
                    n6 = 108;
                    break;
                }
                case 157: {
                    n6 = 228;
                    break;
                }
                case 158: {
                    n6 = 44;
                    break;
                }
                case 159: {
                    n6 = 68;
                    break;
                }
                case 160: {
                    n6 = 119;
                    break;
                }
                case 161: {
                    n6 = 148;
                    break;
                }
                case 162: {
                    n6 = 237;
                    break;
                }
                case 163: {
                    n6 = 63;
                    break;
                }
                case 164: {
                    n6 = 102;
                    break;
                }
                case 165: {
                    n6 = 181;
                    break;
                }
                case 166: {
                    n6 = 180;
                    break;
                }
                case 167: {
                    n6 = 192;
                    break;
                }
                case 168: {
                    n6 = 128;
                    break;
                }
                case 169: {
                    n6 = 160;
                    break;
                }
                case 170: {
                    n6 = 159;
                    break;
                }
                case 171: {
                    n6 = 97;
                    break;
                }
                case 172: {
                    n6 = 134;
                    break;
                }
                case 173: {
                    n6 = 94;
                    break;
                }
                case 174: {
                    n6 = 105;
                    break;
                }
                case 175: {
                    n6 = 195;
                    break;
                }
                case 176: {
                    n6 = 202;
                    break;
                }
                case 177: {
                    n6 = 5;
                    break;
                }
                case 178: {
                    n6 = 75;
                    break;
                }
                case 179: {
                    n6 = 124;
                    break;
                }
                case 180: {
                    n6 = 253;
                    break;
                }
                case 181: {
                    n6 = 223;
                    break;
                }
                case 182: {
                    n6 = 248;
                    break;
                }
                case 183: {
                    n6 = 98;
                    break;
                }
                case 184: {
                    n6 = 186;
                    break;
                }
                case 185: {
                    n6 = 242;
                    break;
                }
                case 186: {
                    n6 = 13;
                    break;
                }
                case 187: {
                    n6 = 37;
                    break;
                }
                case 188: {
                    n6 = 89;
                    break;
                }
                case 189: {
                    n6 = 231;
                    break;
                }
                case 190: {
                    n6 = 21;
                    break;
                }
                case 191: {
                    n6 = 182;
                    break;
                }
                case 192: {
                    n6 = 205;
                    break;
                }
                case 193: {
                    n6 = 157;
                    break;
                }
                case 194: {
                    n6 = 92;
                    break;
                }
                case 195: {
                    n6 = 4;
                    break;
                }
                case 196: {
                    n6 = 188;
                    break;
                }
                case 197: {
                    n6 = 208;
                    break;
                }
                case 198: {
                    n6 = 243;
                    break;
                }
                case 199: {
                    n6 = 197;
                    break;
                }
                case 200: {
                    n6 = 50;
                    break;
                }
                case 201: {
                    n6 = 3;
                    break;
                }
                case 202: {
                    n6 = 229;
                    break;
                }
                case 203: {
                    n6 = 83;
                    break;
                }
                case 204: {
                    n6 = 64;
                    break;
                }
                case 205: {
                    n6 = 62;
                    break;
                }
                case 206: {
                    n6 = 249;
                    break;
                }
                case 207: {
                    n6 = 133;
                    break;
                }
                case 208: {
                    n6 = 32;
                    break;
                }
                case 209: {
                    n6 = 81;
                    break;
                }
                case 210: {
                    n6 = 139;
                    break;
                }
                case 211: {
                    n6 = 109;
                    break;
                }
                case 212: {
                    n6 = 233;
                    break;
                }
                case 213: {
                    n6 = 176;
                    break;
                }
                case 214: {
                    n6 = 45;
                    break;
                }
                case 215: {
                    n6 = 132;
                    break;
                }
                case 216: {
                    n6 = 213;
                    break;
                }
                case 217: {
                    n6 = 18;
                    break;
                }
                case 218: {
                    n6 = 140;
                    break;
                }
                case 219: {
                    n6 = 218;
                    break;
                }
                case 220: {
                    n6 = 118;
                    break;
                }
                case 221: {
                    n6 = 145;
                    break;
                }
                case 222: {
                    n6 = 22;
                    break;
                }
                case 223: {
                    n6 = 79;
                    break;
                }
                case 224: {
                    n6 = 117;
                    break;
                }
                case 225: {
                    n6 = 41;
                    break;
                }
                case 226: {
                    n6 = 143;
                    break;
                }
                case 227: {
                    n6 = 93;
                    break;
                }
                case 228: {
                    n6 = 169;
                    break;
                }
                case 229: {
                    n6 = 183;
                    break;
                }
                case 230: {
                    n6 = 51;
                    break;
                }
                case 231: {
                    n6 = 28;
                    break;
                }
                case 232: {
                    n6 = 154;
                    break;
                }
                case 233: {
                    n6 = 171;
                    break;
                }
                case 234: {
                    n6 = 129;
                    break;
                }
                case 235: {
                    n6 = 193;
                    break;
                }
                case 236: {
                    n6 = 76;
                    break;
                }
                case 237: {
                    n6 = 219;
                    break;
                }
                case 238: {
                    n6 = 204;
                    break;
                }
                case 239: {
                    n6 = 174;
                    break;
                }
                case 240: {
                    n6 = 12;
                    break;
                }
                case 241: {
                    n6 = 147;
                    break;
                }
                case 242: {
                    n6 = 123;
                    break;
                }
                case 243: {
                    n6 = 203;
                    break;
                }
                case 244: {
                    n6 = 34;
                    break;
                }
                case 245: {
                    n6 = 150;
                    break;
                }
                case 246: {
                    n6 = 59;
                    break;
                }
                case 247: {
                    n6 = 65;
                    break;
                }
                case 248: {
                    n6 = 111;
                    break;
                }
                case 249: {
                    n6 = 113;
                    break;
                }
                case 250: {
                    n6 = 47;
                    break;
                }
                case 251: {
                    n6 = 255;
                    break;
                }
                case 252: {
                    n6 = 175;
                    break;
                }
                case 253: {
                    n6 = 247;
                    break;
                }
                case 254: {
                    n6 = 96;
                    break;
                }
                default: {
                    n6 = 29;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            CipherAlg.g[n4] = new String(cArray).intern();
        }
        return g[n4];
    }
}

