/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.crypto.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import tr.gov.tubitak.uekae.esya.api.crypto.Crypto;
import tr.gov.tubitak.uekae.esya.api.crypto.Digester;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.util.RandomUtil;

public class DigestUtil {
    private static final int a = 10000;

    public static byte[] digest(DigestAlg aDigestAlg, byte[] aInput, int aOffset, int aLength) throws CryptoException {
        Digester digester = Crypto.getDigester(aDigestAlg);
        digester.update(aInput, aOffset, aLength);
        return digester.digest();
    }

    public static byte[] digest(DigestAlg aDigestAlg, byte[] aInput) throws CryptoException {
        return DigestUtil.digest(aDigestAlg, aInput, 0, aInput.length);
    }

    public static byte[] digestFile(DigestAlg aDigestAlg, String aFileName) throws CryptoException, IOException {
        return DigestUtil.digestFile(aDigestAlg, aFileName, 10000);
    }

    public static byte[] digestFile(DigestAlg aDigestAlg, String aFileName, int aBlockSize) throws CryptoException, IOException {
        FileInputStream fileInputStream = new FileInputStream(aFileName);
        byte[] byArray = DigestUtil.digestStream(aDigestAlg, fileInputStream, aBlockSize);
        fileInputStream.close();
        return byArray;
    }

    public static byte[] digestStream(DigestAlg aDigestAlg, InputStream aInputStream) throws CryptoException, IOException {
        return DigestUtil.digestStream(aDigestAlg, aInputStream, 10000);
    }

    public static byte[] digestStream(DigestAlg aDigestAlg, InputStream aInputStream, int aBlockSize) throws CryptoException, IOException {
        int n2;
        Digester digester = Crypto.getDigester(aDigestAlg);
        byte[] byArray = new byte[aBlockSize];
        boolean bl = RandomUtil.b;
        while ((n2 = aInputStream.read(byArray)) != -1) {
            digester.update(byArray, 0, n2);
            if (!bl) continue;
        }
        aInputStream.close();
        return digester.digest();
    }
}

