/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore;

import com.objsys.asn1j.runtime.Asn1BitString;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1Type;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.security.PublicKey;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.attrcert.EAttributeCertificate;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EBasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ECertID;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EResponseData;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ESingleResponse;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.BitArray;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtension;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EKeyUsage;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectKeyIdentifier;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.Base64;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.AsymmetricAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.SignUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.GuvenlikSeviyesi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzetTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzneTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.SILTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.SertifikaTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoKokSertifika;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoNitelikSertifikasi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOCSP;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOCSPToWrite;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOzet;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSIL;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSertifika;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSertifikaOcsps;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSilinecekKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNEklenecekKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNRawImza;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNSilinecekKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.depo.KOKGuvenSeviyesi;
import tr.gov.tubitak.uekae.esya.asn.depo.KokSertifikaTipi;
import tr.gov.tubitak.uekae.esya.asn.util.AsnIO;
import tr.gov.tubitak.uekae.esya.asn.util.UtilName;
import tr.gov.tubitak.uekae.esya.asn.x509.Certificate;
import tr.gov.tubitak.uekae.esya.asn.x509.KeyUsage;
import tr.gov.tubitak.uekae.esya.asn.x509.Name;

public class CertStoreUtil {
    private static Logger a;
    public static final String DEPO_DIZIN_ADI;
    private static HashMap<String, byte[]> b;
    private static HashMap<Integer, DigestAlg> c;
    public static final DigestAlg OZET_TIPI_SHA1;
    public static final DigestAlg OZET_TIPI_SHA256;
    public static final DigestAlg OZET_TIPI_SHA384;
    public static final DigestAlg OZET_TIPI_SHA512;
    private static final Boolean d;
    private static final String e;
    private static final byte[] f;
    private static final byte[] g;
    private static final String h;
    private static final byte[] i;
    private static final byte[] j;
    private static final byte[] k;
    private static final byte[] l;
    private static final String[] m;
    private static final String[] n;

    private static void a(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        byte[] byArray3 = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray3[i2] = (byte)(byArray[i2] ^ byArray2[i2]);
        }
        try {
            String string = Base64.encode(DigestUtil.digest(DigestAlg.SHA1, byArray3));
            b.put(string, byArray3);
            String string2 = Base64.encode(DigestUtil.digest(DigestAlg.SHA512, byArray3));
            b.put(string2, byArray3);
        }
        catch (CryptoException cryptoException) {
            a.error(CertStoreUtil.a(2112, -5692), cryptoException);
        }
    }

    public static void addPubKey(String hash, byte[] publicKey) {
        b.put(hash, publicKey);
    }

    private static boolean a() {
        try {
            String string = "/" + CertStoreUtil.class.getName().replace(".", "/") + CertStoreUtil.a(2114, 8980);
            String string2 = CertStoreUtil.class.getResource(string).toString();
            String string3 = string2.substring(0, string2.length() - string.length());
            URL uRL = new URL(string3 + CertStoreUtil.a(2124, 19443));
            Manifest manifest = null;
            try {
                manifest = new Manifest(uRL.openStream());
            }
            catch (IOException iOException) {
                a.trace(CertStoreUtil.a(2122, 20484));
                return true;
            }
            String string4 = manifest.getMainAttributes().getValue(CertStoreUtil.a(2133, -24573));
            if (string4 == null) {
                a.info(CertStoreUtil.a(2142, -21774));
                return true;
            }
            a.info(CertStoreUtil.a(2136, -4508));
            return false;
        }
        catch (Exception exception) {
            a.error(CertStoreUtil.a(2151, 33), exception);
            return true;
        }
    }

    private static DepoASNKokSertifika a(DepoKokSertifika depoKokSertifika) throws CertStoreException {
        try {
            DepoASNKokSertifika depoASNKokSertifika = new DepoASNKokSertifika();
            ECertificate eCertificate = new ECertificate(depoKokSertifika.getValue());
            DepoASNEklenecekKokSertifika depoASNEklenecekKokSertifika = CertStoreUtil.asnCertTOAsnEklenecek((Certificate)eCertificate.getObject(), depoKokSertifika.getKokTipi(), depoKokSertifika.getKokGuvenSeviyesi());
            depoASNKokSertifika.set_eklenecekSertifika(depoASNEklenecekKokSertifika);
            return depoASNKokSertifika;
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreUtil.a(2143, -16661), exception);
        }
    }

    private static DepoASNKokSertifika a(DepoSilinecekKokSertifika depoSilinecekKokSertifika) throws CertStoreException {
        try {
            DepoASNKokSertifika depoASNKokSertifika = new DepoASNKokSertifika();
            ECertificate eCertificate = new ECertificate(depoSilinecekKokSertifika.getValue());
            DepoASNSilinecekKokSertifika depoASNSilinecekKokSertifika = CertStoreUtil.asnCertTOAsnSilinecek((Certificate)eCertificate.getObject());
            depoASNKokSertifika.set_silinecekSertifika(depoASNSilinecekKokSertifika);
            return depoASNKokSertifika;
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreUtil.a(2119, -25482), exception);
        }
    }

    public static DepoASNSilinecekKokSertifika asnCertTOAsnSilinecek(Certificate aCert) throws CertStoreException {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            throw new CertStoreException(CertStoreUtil.a(2126, -19354) + lE.getMessage(), lE);
        }
        try {
            DepoASNSilinecekKokSertifika depoASNSilinecekKokSertifika = new DepoASNSilinecekKokSertifika();
            depoASNSilinecekKokSertifika.kokIssuerName = aCert.tbsCertificate.issuer;
            depoASNSilinecekKokSertifika.kokSerialNumber = aCert.tbsCertificate.serialNumber;
            depoASNSilinecekKokSertifika.kokSubjectName = aCert.tbsCertificate.subject;
            ECertificate eCertificate = new ECertificate(aCert);
            depoASNSilinecekKokSertifika.kokSertifikaValue = new Asn1OctetString(eCertificate.getEncoded());
            return depoASNSilinecekKokSertifika;
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreUtil.a(2128, -24777), exception);
        }
    }

    public static DepoASNEklenecekKokSertifika asnCertTOAsnEklenecek(Certificate aCert, SertifikaTipi aTip, GuvenlikSeviyesi aSeviye) throws CertStoreException {
        int n2 = CertStore.k;
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            throw new CertStoreException(CertStoreUtil.a(2126, -19354) + lE.getMessage(), lE);
        }
        try {
            DepoASNEklenecekKokSertifika depoASNEklenecekKokSertifika = new DepoASNEklenecekKokSertifika();
            depoASNEklenecekKokSertifika.kokEndDate = aCert.tbsCertificate.validity.notAfter;
            depoASNEklenecekKokSertifika.kokStartDate = aCert.tbsCertificate.validity.notBefore;
            depoASNEklenecekKokSertifika.kokSerialNumber = aCert.tbsCertificate.serialNumber;
            depoASNEklenecekKokSertifika.kokIssuerName = aCert.tbsCertificate.issuer;
            depoASNEklenecekKokSertifika.kokSubjectName = aCert.tbsCertificate.subject;
            depoASNEklenecekKokSertifika.kokGuvenSeviyesi = KOKGuvenSeviyesi.valueOf(aSeviye.getIntValue());
            depoASNEklenecekKokSertifika.kokSertifikaTipi = KokSertifikaTipi.valueOf(aTip.getIntValue());
            ECertificate eCertificate = new ECertificate(aCert);
            depoASNEklenecekKokSertifika.kokSertifikaValue = new Asn1OctetString(eCertificate.getEncoded());
            EKeyUsage eKeyUsage = eCertificate.getExtensions().getKeyUsage();
            if (eKeyUsage != null) {
                depoASNEklenecekKokSertifika.kokKeyUsage = (KeyUsage)eKeyUsage.getObject();
            }
            ESubjectKeyIdentifier eSubjectKeyIdentifier = eCertificate.getExtensions().getSubjectKeyIdentifier();
            if (eSubjectKeyIdentifier != null) {
                depoASNEklenecekKokSertifika.kokSubjectKeyIdentifier = new Asn1OctetString(eSubjectKeyIdentifier.getValue());
            }
            depoASNEklenecekKokSertifika.kokSertifikaHash = new Asn1OctetString();
            if (CertStoreException.b != 0) {
                CertStore.k = ++n2;
            }
            return depoASNEklenecekKokSertifika;
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreUtil.a(2118, 31963), exception);
        }
    }

    public static DepoSertifika eSYASertifikaTODepoSertifika(ECertificate aSertifika) throws CertStoreException {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            throw new CertStoreException(CertStoreUtil.a(2135, -20078) + lE.getMessage(), lE);
        }
        DepoSertifika depoSertifika = new DepoSertifika();
        depoSertifika.setValue(aSertifika.getEncoded());
        depoSertifika.setSerialNumber(aSertifika.getSerialNumber().toByteArray());
        depoSertifika.setIssuerName(CertStoreUtil.normalizeName((Name)aSertifika.getIssuer().getObject()));
        depoSertifika.setSubjectName(CertStoreUtil.normalizeName((Name)aSertifika.getSubject().getObject()));
        Asn1BitString asn1BitString = (Asn1BitString)aSertifika.getExtensions().getKeyUsage().getObject();
        if (asn1BitString != null) {
            depoSertifika.setKeyUsageStr(CertStoreUtil.a(asn1BitString));
        }
        depoSertifika.setSubjectKeyID(aSertifika.getExtensions().getSubjectKeyIdentifier().getValue());
        depoSertifika.setEndDate(new Date(aSertifika.getNotAfter().getTimeInMillis()));
        depoSertifika.setStartDate(new Date(aSertifika.getNotBefore().getTimeInMillis()));
        String string = aSertifika.getEmail();
        if (string != null) {
            depoSertifika.setEPosta(string);
        }
        return depoSertifika;
    }

    private static DepoKokSertifika a(ECertificate eCertificate) throws CertStoreException {
        DepoKokSertifika depoKokSertifika = new DepoKokSertifika();
        depoKokSertifika.setValue(eCertificate.getEncoded());
        depoKokSertifika.setSerialNumber(eCertificate.getSerialNumber().toByteArray());
        depoKokSertifika.setIssuerName(CertStoreUtil.normalizeName((Name)eCertificate.getIssuer().getObject()));
        depoKokSertifika.setSubjectName(CertStoreUtil.normalizeName((Name)eCertificate.getSubject().getObject()));
        EKeyUsage eKeyUsage = eCertificate.getExtensions().getKeyUsage();
        if (eKeyUsage != null) {
            depoKokSertifika.setKeyUsageStr(CertStoreUtil.a((Asn1BitString)eKeyUsage.getObject()));
        }
        ESubjectKeyIdentifier eSubjectKeyIdentifier = eCertificate.getExtensions().getSubjectKeyIdentifier();
        if (eSubjectKeyIdentifier != null) {
            depoKokSertifika.setSubjectKeyIdentifier(eSubjectKeyIdentifier.getValue());
        }
        depoKokSertifika.setEndDate(new Date(eCertificate.getNotAfter().getTimeInMillis()));
        depoKokSertifika.setStartDate(new Date(eCertificate.getNotBefore().getTimeInMillis()));
        return depoKokSertifika;
    }

    public static DepoKokSertifika asnCertTODepoEklenecek(Certificate aCert) throws CertStoreException {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            throw new CertStoreException(CertStoreUtil.a(2126, -19354) + lE.getMessage(), lE);
        }
        try {
            ECertificate eCertificate = new ECertificate(aCert);
            return CertStoreUtil.a(eCertificate);
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreUtil.a(2127, 5716), exception);
        }
    }

    private static DepoSilinecekKokSertifika a(Certificate certificate) throws CertStoreException {
        try {
            DepoSilinecekKokSertifika depoSilinecekKokSertifika = new DepoSilinecekKokSertifika();
            ECertificate eCertificate = new ECertificate(certificate);
            depoSilinecekKokSertifika.setValue(eCertificate.getEncoded());
            depoSilinecekKokSertifika.setIssuerName(UtilName.name2byte((Name)eCertificate.getIssuer().getObject()));
            depoSilinecekKokSertifika.setSubjectName(UtilName.name2byte((Name)eCertificate.getSubject().getObject()));
            depoSilinecekKokSertifika.setSerialNumber(eCertificate.getSerialNumber().toByteArray());
            return depoSilinecekKokSertifika;
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreUtil.a(2123, -26987), exception);
        }
    }

    public static DepoSilinecekKokSertifika asnSilinecekToDepoSilinecek(DepoASNSilinecekKokSertifika aSilinecek) throws CertStoreException {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            throw new CertStoreException(CertStoreUtil.a(2126, -19354) + lE.getMessage(), lE);
        }
        try {
            ECertificate eCertificate = new ECertificate(aSilinecek.kokSertifikaValue.value);
            return CertStoreUtil.a((Certificate)eCertificate.getObject());
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreUtil.a(2131, 7852), exception);
        }
    }

    public static DepoKokSertifika asnEklenecekTODepoKok(DepoASNEklenecekKokSertifika aEklenecek) throws CertStoreException {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            throw new CertStoreException(CertStoreUtil.a(2126, -19354) + lE.getMessage(), lE);
        }
        try {
            byte[] byArray = aEklenecek.kokSertifikaValue.value;
            ECertificate eCertificate = new ECertificate(byArray);
            DepoKokSertifika depoKokSertifika = CertStoreUtil.a(eCertificate);
            depoKokSertifika.setKokTipi(SertifikaTipi.getNesne(aEklenecek.kokSertifikaTipi.getValue()));
            depoKokSertifika.setKokGuvenSeviyesi(GuvenlikSeviyesi.getNesne(aEklenecek.kokGuvenSeviyesi.getValue()));
            return depoKokSertifika;
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreUtil.a(2115, -29653), exception);
        }
    }

    public static DepoNitelikSertifikasi asnAttributeCertToDepoNitelikSertifikasi(EAttributeCertificate aAttrCert) {
        DepoNitelikSertifikasi depoNitelikSertifikasi = new DepoNitelikSertifikasi();
        depoNitelikSertifikasi.setHolderDNName(aAttrCert.getHolder().getEntityName().getElement(0).toString());
        depoNitelikSertifikasi.setValue(aAttrCert.getEncoded());
        return depoNitelikSertifikasi;
    }

    public static DepoSIL asnCRLTODepoSIL(byte[] aCRL) throws CertStoreException, IOException, ESYAException {
        DepoSIL depoSIL;
        block13: {
            block12: {
                int n2 = CertStore.k;
                try {
                    LV.getInstance().checkLD(LV.Urunler.ORTAK);
                }
                catch (LE lE) {
                    throw new ESYAException(CertStoreUtil.a(2126, -19354) + lE.getMessage(), lE);
                }
                depoSIL = new DepoSIL();
                ECRL eCRL = new ECRL(aCRL);
                depoSIL.setIssuerName(CertStoreUtil.normalizeName((Name)eCRL.getIssuer().getObject()));
                depoSIL.setThisUpdate(new Date(eCRL.getThisUpdate().getTimeInMillis()));
                depoSIL.setNextUpdate(new Date(eCRL.getNextUpdate().getTimeInMillis()));
                BigInteger bigInteger = eCRL.getCRLNumber();
                if (bigInteger != null) {
                    depoSIL.setSILNumber(bigInteger.toByteArray());
                }
                depoSIL.setValue(eCRL.getEncoded());
                EExtension eExtension = eCRL.getCRLExtensions().getDeltaCRLIndicator();
                if (eExtension != null) {
                    depoSIL.setBaseSILNumber(eExtension.getValue());
                }
                if (eExtension == null) break block12;
                depoSIL.setSILTipi(SILTipi.DELTA);
                if (n2 == 0) break block13;
            }
            depoSIL.setSILTipi(SILTipi.BASE);
        }
        return depoSIL;
    }

    public static DepoOCSPToWrite asnOCSPResponseTODepoOCSP(EOCSPResponse aOCSPResponse) throws CertStoreException {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            throw new CertStoreException(CertStoreUtil.a(2126, -19354) + lE.getMessage(), lE);
        }
        try {
            EBasicOCSPResponse eBasicOCSPResponse = aOCSPResponse.getBasicOCSPResponse();
            byte[] byArray = eBasicOCSPResponse.getTbsResponseData().getResponderID().getEncoded();
            Date date = new Date(eBasicOCSPResponse.getTbsResponseData().getProducetAt().getTime().getTime());
            DepoOCSPToWrite depoOCSPToWrite = new DepoOCSPToWrite();
            depoOCSPToWrite.setOCSPResponderID(byArray);
            depoOCSPToWrite.setOCSPProducedAt(date);
            depoOCSPToWrite.setBasicOCSPResponse(eBasicOCSPResponse.getEncoded());
            depoOCSPToWrite.setOCSPResponse(aOCSPResponse.getEncoded());
            return depoOCSPToWrite;
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreUtil.a(2125, -1803), exception);
        }
    }

    public static boolean verifyDepoKokSertifika(DepoKokSertifika aKok) throws CertStoreException {
        return CertStoreUtil.verifyDepoKokSertifika(aKok, null);
    }

    public static boolean verifyDepoKokSertifika(DepoKokSertifika aKok, String hash) throws CertStoreException {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            throw new CertStoreException(CertStoreUtil.a(2126, -19354) + lE.getMessage(), lE);
        }
        if (aKok.getKokGuvenSeviyesi().equals(GuvenlikSeviyesi.PERSONAL)) {
            return true;
        }
        DepoASNKokSertifika depoASNKokSertifika = CertStoreUtil.a(aKok);
        return CertStoreUtil.a(depoASNKokSertifika, aKok.getSatirImzasi(), hash);
    }

    public static boolean verifyDepoSilinecekKokSertifika(DepoSilinecekKokSertifika aKok) throws CertStoreException {
        return CertStoreUtil.a(aKok, null);
    }

    private static boolean a(DepoSilinecekKokSertifika depoSilinecekKokSertifika, String string) throws CertStoreException {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            throw new CertStoreException(CertStoreUtil.a(2126, -19354) + lE.getMessage(), lE);
        }
        DepoASNKokSertifika depoASNKokSertifika = CertStoreUtil.a(depoSilinecekKokSertifika);
        return CertStoreUtil.a(depoASNKokSertifika, depoSilinecekKokSertifika.getSatirImzasi(), string);
    }

    private static boolean a(DepoASNKokSertifika depoASNKokSertifika, byte[] byArray, String string) throws CertStoreException {
        try {
            DepoASNRawImza depoASNRawImza = new DepoASNRawImza();
            AsnIO.derOku((Asn1Type)depoASNRawImza, byArray);
            byte[] byArray2 = depoASNRawImza.imza.value;
            byte[] byArray3 = depoASNRawImza.publicKeyHash.value;
            SignatureAlg signatureAlg = SignatureAlg.RSA_SHA512;
            if (byArray3.length == 20) {
                signatureAlg = SignatureAlg.RSA_SHA1;
            }
            PublicKey publicKey = CertStoreUtil.a(string);
            byte[] byArray4 = AsnIO.derEncode(depoASNKokSertifika);
            boolean bl = SignUtil.verify(signatureAlg, byArray4, byArray2, publicKey);
            if (!bl) {
                a.debug(CertStoreUtil.a(2138, 24182) + string);
            }
            return bl;
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreUtil.a(2132, 11695), exception);
        }
    }

    private static PublicKey a(String string) throws CryptoException, CertStoreException {
        byte[] byArray;
        block10: {
            block8: {
                int n2;
                block9: {
                    n2 = CertStore.k;
                    if (string != null) break block8;
                    if (!d.booleanValue()) break block9;
                    byArray = b.get(CertStoreUtil.a(2134, -4549));
                    if (n2 == 0) break block10;
                }
                byArray = b.get(CertStoreUtil.a(2116, 28546));
                if (n2 == 0) break block10;
            }
            byArray = b.get(string);
            if (byArray == null) {
                throw new CertStoreException(CertStoreUtil.a(2137, 10601) + string);
            }
        }
        return KeyUtil.decodePublicKey(AsymmetricAlg.RSA, byArray);
    }

    public static boolean verifyEncodedRootCertificate(byte[] aDogrulanacak, DepoASNRawImza aSatirImza) throws CertStoreException {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            throw new CertStoreException(CertStoreUtil.a(2126, -19354) + lE.getMessage(), lE);
        }
        try {
            byte[] byArray = aSatirImza.imza.value;
            byte[] byArray2 = aSatirImza.publicKeyHash.value;
            String string = Base64.encode(byArray2);
            byte[] byArray3 = b.get(string);
            if (byArray3 == null) {
                return false;
            }
            PublicKey publicKey = KeyUtil.decodePublicKey(AsymmetricAlg.RSA, byArray3);
            SignatureAlg signatureAlg = SignatureAlg.RSA_SHA512;
            if (byArray2.length == 20) {
                signatureAlg = SignatureAlg.RSA_SHA1;
            }
            return SignUtil.verify(signatureAlg, aDogrulanacak, byArray, publicKey);
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreUtil.a(2129, -220), exception);
        }
    }

    private static String a(Asn1BitString asn1BitString) {
        int n2 = asn1BitString.numbits;
        int n3 = 9 - n2;
        BitArray bitArray = new BitArray(n2, asn1BitString.value);
        int n4 = CertStore.k;
        String string = bitArray.toString().replaceAll(" ", "");
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuffer.append("0");
            if (n4 == 0) continue;
        }
        return stringBuffer.toString();
    }

    public static byte[] getNormalizeName(Name aName) {
        try {
            return CertStoreUtil.normalizeName(aName);
        }
        catch (Exception exception) {
            a.warn(CertStoreUtil.a(2130, -13540), exception);
            return null;
        }
    }

    public static byte[] normalizeName(Name aName) throws CertStoreException {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            throw new CertStoreException(CertStoreUtil.a(2126, -19354) + lE.getMessage(), lE);
        }
        try {
            Name name = UtilName.string2Name(UtilName.name2String(aName), true);
            return UtilName.name2byte(name);
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreUtil.a(2120, -4734), exception);
        }
    }

    public static List<DepoOzet> convertToDepoOzet(byte[] aValue, OzneTipi aObjectType) {
        int n2 = CertStore.k;
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(CertStoreUtil.a(2126, -19354) + lE.getMessage(), lE);
        }
        Set<Integer> set = c.keySet();
        ArrayList<DepoOzet> arrayList = new ArrayList<DepoOzet>();
        for (Integer n3 : set) {
            try {
                DepoOzet depoOzet = new DepoOzet();
                byte[] byArray = DigestUtil.digest(c.get(n3), aValue);
                depoOzet.setHashValue(byArray);
                depoOzet.setHashType(n3);
                depoOzet.setObjectType(aObjectType.getIntValue());
                arrayList.add(depoOzet);
            }
            catch (Exception exception) {
                a.error(CertStoreUtil.a(2117, -358), exception);
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public static boolean isOCSPResponseForCertificate(EBasicOCSPResponse aBasicOCSPResponse, ECertificate aCer) {
        ESingleResponse eSingleResponse = CertStoreUtil.getOCSPResponseForCertificate(aBasicOCSPResponse, aCer);
        boolean bl = eSingleResponse != null;
        return bl;
    }

    public static ESingleResponse getOCSPResponseForCertificate(EBasicOCSPResponse aBasicOCSPResponse, ECertificate aCer) {
        int n2 = CertStore.k;
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(CertStoreUtil.a(2126, -19354) + lE.getMessage(), lE);
        }
        EResponseData eResponseData = aBasicOCSPResponse.getTbsResponseData();
        BigInteger bigInteger = aCer.getSerialNumber();
        for (int i2 = 0; i2 < eResponseData.getSingleResponseCount(); ++i2) {
            ESingleResponse eSingleResponse = eResponseData.getSingleResponse(i2);
            ECertID eCertID = eSingleResponse.getCertID();
            if (!bigInteger.equals(eCertID.getSerialNumber()) || !CertStoreUtil.a(eCertID, aCer)) continue;
            return eSingleResponse;
        }
        return null;
    }

    private static boolean a(ECertID eCertID, ECertificate eCertificate) {
        try {
            DigestAlg digestAlg = DigestAlg.fromOID(eCertID.getHashAlgorithm().getAlgorithm().value);
            byte[] byArray = DigestUtil.digest(digestAlg, eCertificate.getIssuer().getEncoded());
            return Arrays.equals(byArray, eCertID.getIssuerNameHash());
        }
        catch (Exception exception) {
            a.error(CertStoreUtil.a(2113, 18727), exception);
            return false;
        }
    }

    public static DepoSertifikaOcsps toDepoSertifikaOcsps(ESingleResponse aSingleResponse, DepoOCSP aDepoOCSP, DepoSertifika aDepoSertifika) throws CertStoreException {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(CertStoreUtil.a(2126, -19354) + lE.getMessage(), lE);
        }
        try {
            DepoSertifikaOcsps depoSertifikaOcsps = new DepoSertifikaOcsps();
            depoSertifikaOcsps.setOcspNo(aDepoOCSP.getOCSPNo());
            depoSertifikaOcsps.setSertifikaNo(aDepoSertifika.getSertifikaNo());
            depoSertifikaOcsps.setThisUpdate(new Date(aSingleResponse.getThisUpdate().getTime().getTime()));
            depoSertifikaOcsps.setStatus(new Long(aSingleResponse.getCertificateStatus()));
            java.util.Date date = null;
            if (aSingleResponse.getRevocationTime() != null) {
                date = aSingleResponse.getRevocationTime().getTime();
            }
            Date date2 = null;
            if (date != null) {
                date2 = new Date(date.getTime());
            }
            depoSertifikaOcsps.setRevocationTime(date2);
            depoSertifikaOcsps.setRevocationReason(new Long(aSingleResponse.getRevokationReason()));
            return depoSertifikaOcsps;
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreUtil.a(2140, 10833), exception);
        }
    }

    /*
     * Opcode count of 13429 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[33];
                var3_1 = 0;
                var2_2 = "\u00fd\u00cd\u00fcH\u00fd{\u00a0\u00ee\u00f8\u00adiI\u0002\u001f\u0012K\u00d0\u00cfE\u0015G\u0007\u00b52 _\u00a1\u0080\u0089[\u00e3,`\u00c0\u00d8\u0001\u0018\u0088w\u0010\u00bd\u001d6O\u00b6\u009f*\u00dcs\u00c9\u00c6\u00ab~*#\u00aa\u00c1\b\u00ea\u0097DW\u00e3W78\u00a1\u001a4\u00bb7\u00cf\u00b9d&^\u00f2\u0088\u00d2\u0081(C\u00a2I\u0084*\u00a77\u008dt\u00cf\u00a4\u001a#\u00e3\u00caPc.X\u00ddQg@\u0010\u00ca-\u00141\u00e1\\\u00c9-\u0010}\u0019\u00ed9\u000b\u0089#\u00e1cE\u00d2V\u008e\u00bb\u001cp3\u00fc9\u0093\u00d9BV\u00d3?/\tF\u00b2f\u0014\u00ce\"w\u00d7;\u001d\u00a1\u00b9\u0082\u0099\u0012\u00e2\u0000\t\u0016d\u00e1\u0014\u00e1\u0012\u00a7\u00a6\u00858\u00c7\u00b8\u001d\u009b\u00d4\u008d\u00d1\u00c6\u008f\b\"\u008cZZ\u00ee)\u00b3\u00b2\u00f5\u0016\u007f\u009b\u008fw\u0083\u00cfwCKw\u007f\u008b\u00d1LD\u001e\u00ffs\u00aaP\u0091l\u001clh\u0098\u00b0\u00ad\u009e#\u009d\u00e6\u0014\nNl\u00db\u00a3\u00b5\u00af\u00cb\u00a5\u009e]\u00a6\u00d6\u0086\u00b2\u00da\u00e5zZ\u0096\u00dc\u000e\u00f1;\u00f2\u0090\u00cd\\\u00ea\u001c\u00cddI\u0015\u0085\u00ac\u0084\u00c6\u00ae\u00df\u00b9\u0017\t\u0090;\u00a8xo\u00e3\u0002\u000b\u00bad\u00ec\u00bb\u001d\u0010R` \u0015\u0099\u0092\u00afjt\u009b@\u00ae\b\u000fp\u00e4\u00c0D\u00c5Yf\u00ffZ=`\u00f7\u0007,\u00e6\u00dd\u00ec\u00a4\u0002p\u00f0}Q\f\u00ba\u00b9\u00b3\u008d0\u00a1_DS\u00be\u0007/\u00b4\u00b2\u0006\u001c}\u00fb\u0096\u00d1o\u0016\u0005o\u00c0\u00e9j\u001cJ9\u00ec8\u008bbOq\u0097\u00b9\u0085\u0087\u00e5\u00cex\u00bf\u001d|[\u00efo\u008f\u00cc\u00f6#2L<.,\u00b3\u00ee\u009ay'\u0090\u009c\u0011\u007fTW_\u00b2\fE\u000eP\u00bcSK\u0000\u0095\u00c2\u009d\u0015'\u00c1\u009e\u00cdu\u0090v\t\u008c;'\u00c9\u00a6\u00e9\u00d3D\u00c4sZ\u00a4\u001d\u000b\u00b5}\u00e7\u00dd\u00cd$\u00c5.s\u00d4,\u00edSE\u00d8u\n=2\u00d4-$\u008b\u00188|\u00a6*\u0098_@M\u0015}\u0010p\u0097\u00faTHk\u00e4H\u00e9}IovD\u00e5\u001b\u00f1%w\u00d6\u00a1g\u00e5j6\u00dag\u00b6\u00fa\u00d4X\u009aMA\u00c8\u0087$$\nVq\u009c\u00b8@B\u00b2\u00b0<\u00fdIg\u00f4sJ~\u00843\u00ff\u008b\u007f\u00f7\u0010\u0018\u00a5_Dk\u00cb\u009ct\u00d1)\u00b1\u00fd\u00fd\u00a9S\u0011@\u0002i\u00cc[&B\u00d7\u00c1\u0080\u0016\u0017\u00d3\u00f2\u0007\u00f7I\u00e8\u00b5d$\u00f2\u00ae\u00bdb\u0017\u00e2\u00cef\u00fd\u0015AdXk\u009b\u001d\u0001\u0095\u00c7\u00e5l\u000b\u00a4\u0013\u00a5\u0086\u0096>\u00f9\u00d7\u00c0Y\u00b1\u009d\u00ea\u00d9\u00a1\u00f9\u001br\u00f7-\u0084P6#\u001e\u007f\u0081\u00f5\u0086\u0010\u0092\u00d2U#\u0014\u009f@9^\u00b8\u00c5\r\u00f5\u000fc0mU\u009e49\u00b9&\u0095TX\u00e3\u0014\u0003\u00b3\u0084\u00af\u00fe\u0084\u00d6\u00ef:\u001d;^\u001a1\u00b1\u001c\u00da-h*\u00c3x\u00ad\u0081n\u0014\u00d1\u00c3\u00a0\u00ad\u0090[i\u008d\u008c\u00ab\u0096&\u0082\u00fb\u00b8\"\u00a1jg\u0012\u0085\u00be\u00c3V\u0003\u00d6Z\u00b7\u00d4\u0013-!>\u0017\u00ba\u001e\u00ec\u0012\u0011H]\u00f4\u00ab\u008d\u008b\u00cc\u00d9p~j\u0010\u0017\u009d\u0093\u008b\u00f3\u00a7\u00b0)\u0016\u00ff\u00f7\u00eb\u00e5\u0089A\u0007$\u00b6\u00c3\u00dc\u00c0\u00fa7)\u008d\u00c1\u000fKH\u00c0\u00f9\"\u00a9\u0093\u001a\u00c2`\u00a4\u00dc\u0093\u00ac\u0084\u00ec\u0002\u00e3j\u009f\u00faS\u00f1F\u0004\u00ec\u001b\u00c92p4A;\u00f9\u00e1\u00b5\u00ab\u0017\u0098\u00f4\u0011\u0099\"uV\u00cfe\u00c4x\u0016\u00dd\u00f2\u00ed\u00c8\u001c\u009f\"\u0091a\n)r\u0088\b\u00b6tL:\u009f\u0014\u00a0\u0004\u0017h\u001d\u0095I\r/\u0088\u00cf\u00a4\u00bd\u0002\u00aar%\u00af:C\u00e17\u00d0\t\u00bf|%\u0019\u00bd\u0086\u00cck\u00d7bS S\u00da\u00b6>\u0005X\u00b9\u00cdte\u0095q\u00ad\u00e5\u00a4A\f=c\u00b6\u0006\u00b11TT\u0095\u000b^\u0011\u00bd\u00de\u0098\u00edA\u0015\u00ba\u0004\bl\u00ee(\u0080\u00d7\u0086\u00e3u\u0017\u0013\u00a9\u00b0r\n\u000b\u0095x\u00b1\u00a7B\u00f5\u001b\u00a1\u00e2\u00d8,my\u0082\u0019\u0002\u008b\u00d2\u00d7\u0005\u0016Og\u00b4>\u0000\u00de\u00a5\u00b0\t]\u00f3\u00ecc\u009d\u0094\u0002*\u001f\u00d8\u00f2\u00c9hz\u0081\u00dfB\u0088\u00ef0-\u0005\u0092\u00d2+\u00c8\u001b3\u0080\u00d1\u00b0\u0094:\u00a8c\u0018\u0090H\"}-\u00e1\u00d4O\u00b9\\\u0004WB\u00e1\u0005\u0092\u00d1S\u008e\u000e\u00ea\u008c\n\u00f8%\u00beHa\u00afs\u0019\u0081\u0086m\u0002;Y\u00c2P\u00e3Ds!\u0002\u001d\u009e\u007f\u00b6<I\u009e\u00ef\u0090!\t\u00f9>\u00f4\u00d6cByW\u00a1\u0014\u00e8\u00e8\u00e1\u00df\u0013\u00b6\u00f6\u00b5\u00a4C2A\u009e3\u0091|\u0084!\u00d2\u00f4]\u00e7\u0015\u0002v1\u00037\u00d2\u00c0K\u0014\u001a\u00b2.\u00cd0\u00ec\u00e8>\u008ei\u0093/\u00d2K\u00c9\u00bc\u00deQ\u00c1\u009c\u0096\u00d1\u0003x5\u0019\u00e3\u001b\u00ff\u00c2Z\u0014Q\u00d1\u008c'EVw_\u001aMTHg,\u0099\u00f1G\u00fe\u00b7v\u00ddZ;\u00f0$\u00ef\u00e6\u0097\u00c5o\u0088q)\u00af\u00f3;\u00a3g\u00ae\u009d\u00d0}\u00c2r\u0089\u0091\u00a0\u0088~\u0081h\u00d2\u00cf\u00cb\u008a_`\u0094a\u00ad\u00d7\u00ed\u00db\u0086\u00e6\u00e0@$\u0089R\u00ff\u0097\u00ff(\u008e\u0000\u001f\u00d8>\u00ca\u0019\u008d\u00b5s\u009d>\u00b8\u0015\u0011\u00fa\u0012@\u00dd\u00ec\u000b\u00ee.~U\u00f7ND\u008f\u0098\u00a8c\u00adZ\u00d8\u00b3O!\"N\u00a1\u009ak:\u00914\u00b3\u00fdj\u0085 /\u00e1R\u007f\u00d1\u00dcGgS=\u00e6\u00ad\u00a3Ht\u001ap>\u00a6.\u0091\u00a1\u001c\u00a4\u009a\u0081\u00ee\u008eUG\u00e4j;\u009b\u00ab^g\u00e5\"g9\u00bc\u00c0~m\u00b2\u00ff>\u00f5t\u009f5\u00d5\u00e0\u00f9\u00ed.\u00d9\u00dcv\u000f\u00ad\u009bH\u00d5\u0012dV\f\u00f3\u00e3\u008eo\u00f1\u008b\u00b9\u00f6\u00ab.\u0006\u00b6\u00abh[\u008a9S\u00fa8\u008f\t\u00a5K-\u00dcuH#\u0017\u00afG\u0097\u0086eS\u001c\u0085i\u00d2\bb\u0004\u007f-\u00a9\u0002@\u00da\u00bcM\u00c4\u00fa\u001e\\+t\u00fdd\u0000\u008a){\u0090+?l\u00197\u0019\u0017\u00ebg/\u00a1_\u00b7\u00f3\u00f0\tr\u00c8k\u00f4\u001cg\u00fb\u00f6i\u0019\u00f2\u00a1\u00c1\u00c0\u008a{Pn\u009d\u0001N\u00a8\u0096\u0003?\u0017\u0013F0\u00b0\u00b8\u0018\u0096\u00d5\u001cg\u008b6]\u00d2\u00fc\u00e1\u00d4\u00b8Ml\u00c4y*/d96\u001d7kc?1U\u00b5\u00b6\u00b6\u001cw^\u00a6\u00dbj\u009c{\"\u00d1R]=\u00f0W\u00b5f\u00b4\u00ba|=\u001f\u001d\f\u0097\u00b6\u00d9\u00f7=Kp\u00b3~\u000f";
                var4_3 = "\u00fd\u00cd\u00fcH\u00fd{\u00a0\u00ee\u00f8\u00adiI\u0002\u001f\u0012K\u00d0\u00cfE\u0015G\u0007\u00b52 _\u00a1\u0080\u0089[\u00e3,`\u00c0\u00d8\u0001\u0018\u0088w\u0010\u00bd\u001d6O\u00b6\u009f*\u00dcs\u00c9\u00c6\u00ab~*#\u00aa\u00c1\b\u00ea\u0097DW\u00e3W78\u00a1\u001a4\u00bb7\u00cf\u00b9d&^\u00f2\u0088\u00d2\u0081(C\u00a2I\u0084*\u00a77\u008dt\u00cf\u00a4\u001a#\u00e3\u00caPc.X\u00ddQg@\u0010\u00ca-\u00141\u00e1\\\u00c9-\u0010}\u0019\u00ed9\u000b\u0089#\u00e1cE\u00d2V\u008e\u00bb\u001cp3\u00fc9\u0093\u00d9BV\u00d3?/\tF\u00b2f\u0014\u00ce\"w\u00d7;\u001d\u00a1\u00b9\u0082\u0099\u0012\u00e2\u0000\t\u0016d\u00e1\u0014\u00e1\u0012\u00a7\u00a6\u00858\u00c7\u00b8\u001d\u009b\u00d4\u008d\u00d1\u00c6\u008f\b\"\u008cZZ\u00ee)\u00b3\u00b2\u00f5\u0016\u007f\u009b\u008fw\u0083\u00cfwCKw\u007f\u008b\u00d1LD\u001e\u00ffs\u00aaP\u0091l\u001clh\u0098\u00b0\u00ad\u009e#\u009d\u00e6\u0014\nNl\u00db\u00a3\u00b5\u00af\u00cb\u00a5\u009e]\u00a6\u00d6\u0086\u00b2\u00da\u00e5zZ\u0096\u00dc\u000e\u00f1;\u00f2\u0090\u00cd\\\u00ea\u001c\u00cddI\u0015\u0085\u00ac\u0084\u00c6\u00ae\u00df\u00b9\u0017\t\u0090;\u00a8xo\u00e3\u0002\u000b\u00bad\u00ec\u00bb\u001d\u0010R` \u0015\u0099\u0092\u00afjt\u009b@\u00ae\b\u000fp\u00e4\u00c0D\u00c5Yf\u00ffZ=`\u00f7\u0007,\u00e6\u00dd\u00ec\u00a4\u0002p\u00f0}Q\f\u00ba\u00b9\u00b3\u008d0\u00a1_DS\u00be\u0007/\u00b4\u00b2\u0006\u001c}\u00fb\u0096\u00d1o\u0016\u0005o\u00c0\u00e9j\u001cJ9\u00ec8\u008bbOq\u0097\u00b9\u0085\u0087\u00e5\u00cex\u00bf\u001d|[\u00efo\u008f\u00cc\u00f6#2L<.,\u00b3\u00ee\u009ay'\u0090\u009c\u0011\u007fTW_\u00b2\fE\u000eP\u00bcSK\u0000\u0095\u00c2\u009d\u0015'\u00c1\u009e\u00cdu\u0090v\t\u008c;'\u00c9\u00a6\u00e9\u00d3D\u00c4sZ\u00a4\u001d\u000b\u00b5}\u00e7\u00dd\u00cd$\u00c5.s\u00d4,\u00edSE\u00d8u\n=2\u00d4-$\u008b\u00188|\u00a6*\u0098_@M\u0015}\u0010p\u0097\u00faTHk\u00e4H\u00e9}IovD\u00e5\u001b\u00f1%w\u00d6\u00a1g\u00e5j6\u00dag\u00b6\u00fa\u00d4X\u009aMA\u00c8\u0087$$\nVq\u009c\u00b8@B\u00b2\u00b0<\u00fdIg\u00f4sJ~\u00843\u00ff\u008b\u007f\u00f7\u0010\u0018\u00a5_Dk\u00cb\u009ct\u00d1)\u00b1\u00fd\u00fd\u00a9S\u0011@\u0002i\u00cc[&B\u00d7\u00c1\u0080\u0016\u0017\u00d3\u00f2\u0007\u00f7I\u00e8\u00b5d$\u00f2\u00ae\u00bdb\u0017\u00e2\u00cef\u00fd\u0015AdXk\u009b\u001d\u0001\u0095\u00c7\u00e5l\u000b\u00a4\u0013\u00a5\u0086\u0096>\u00f9\u00d7\u00c0Y\u00b1\u009d\u00ea\u00d9\u00a1\u00f9\u001br\u00f7-\u0084P6#\u001e\u007f\u0081\u00f5\u0086\u0010\u0092\u00d2U#\u0014\u009f@9^\u00b8\u00c5\r\u00f5\u000fc0mU\u009e49\u00b9&\u0095TX\u00e3\u0014\u0003\u00b3\u0084\u00af\u00fe\u0084\u00d6\u00ef:\u001d;^\u001a1\u00b1\u001c\u00da-h*\u00c3x\u00ad\u0081n\u0014\u00d1\u00c3\u00a0\u00ad\u0090[i\u008d\u008c\u00ab\u0096&\u0082\u00fb\u00b8\"\u00a1jg\u0012\u0085\u00be\u00c3V\u0003\u00d6Z\u00b7\u00d4\u0013-!>\u0017\u00ba\u001e\u00ec\u0012\u0011H]\u00f4\u00ab\u008d\u008b\u00cc\u00d9p~j\u0010\u0017\u009d\u0093\u008b\u00f3\u00a7\u00b0)\u0016\u00ff\u00f7\u00eb\u00e5\u0089A\u0007$\u00b6\u00c3\u00dc\u00c0\u00fa7)\u008d\u00c1\u000fKH\u00c0\u00f9\"\u00a9\u0093\u001a\u00c2`\u00a4\u00dc\u0093\u00ac\u0084\u00ec\u0002\u00e3j\u009f\u00faS\u00f1F\u0004\u00ec\u001b\u00c92p4A;\u00f9\u00e1\u00b5\u00ab\u0017\u0098\u00f4\u0011\u0099\"uV\u00cfe\u00c4x\u0016\u00dd\u00f2\u00ed\u00c8\u001c\u009f\"\u0091a\n)r\u0088\b\u00b6tL:\u009f\u0014\u00a0\u0004\u0017h\u001d\u0095I\r/\u0088\u00cf\u00a4\u00bd\u0002\u00aar%\u00af:C\u00e17\u00d0\t\u00bf|%\u0019\u00bd\u0086\u00cck\u00d7bS S\u00da\u00b6>\u0005X\u00b9\u00cdte\u0095q\u00ad\u00e5\u00a4A\f=c\u00b6\u0006\u00b11TT\u0095\u000b^\u0011\u00bd\u00de\u0098\u00edA\u0015\u00ba\u0004\bl\u00ee(\u0080\u00d7\u0086\u00e3u\u0017\u0013\u00a9\u00b0r\n\u000b\u0095x\u00b1\u00a7B\u00f5\u001b\u00a1\u00e2\u00d8,my\u0082\u0019\u0002\u008b\u00d2\u00d7\u0005\u0016Og\u00b4>\u0000\u00de\u00a5\u00b0\t]\u00f3\u00ecc\u009d\u0094\u0002*\u001f\u00d8\u00f2\u00c9hz\u0081\u00dfB\u0088\u00ef0-\u0005\u0092\u00d2+\u00c8\u001b3\u0080\u00d1\u00b0\u0094:\u00a8c\u0018\u0090H\"}-\u00e1\u00d4O\u00b9\\\u0004WB\u00e1\u0005\u0092\u00d1S\u008e\u000e\u00ea\u008c\n\u00f8%\u00beHa\u00afs\u0019\u0081\u0086m\u0002;Y\u00c2P\u00e3Ds!\u0002\u001d\u009e\u007f\u00b6<I\u009e\u00ef\u0090!\t\u00f9>\u00f4\u00d6cByW\u00a1\u0014\u00e8\u00e8\u00e1\u00df\u0013\u00b6\u00f6\u00b5\u00a4C2A\u009e3\u0091|\u0084!\u00d2\u00f4]\u00e7\u0015\u0002v1\u00037\u00d2\u00c0K\u0014\u001a\u00b2.\u00cd0\u00ec\u00e8>\u008ei\u0093/\u00d2K\u00c9\u00bc\u00deQ\u00c1\u009c\u0096\u00d1\u0003x5\u0019\u00e3\u001b\u00ff\u00c2Z\u0014Q\u00d1\u008c'EVw_\u001aMTHg,\u0099\u00f1G\u00fe\u00b7v\u00ddZ;\u00f0$\u00ef\u00e6\u0097\u00c5o\u0088q)\u00af\u00f3;\u00a3g\u00ae\u009d\u00d0}\u00c2r\u0089\u0091\u00a0\u0088~\u0081h\u00d2\u00cf\u00cb\u008a_`\u0094a\u00ad\u00d7\u00ed\u00db\u0086\u00e6\u00e0@$\u0089R\u00ff\u0097\u00ff(\u008e\u0000\u001f\u00d8>\u00ca\u0019\u008d\u00b5s\u009d>\u00b8\u0015\u0011\u00fa\u0012@\u00dd\u00ec\u000b\u00ee.~U\u00f7ND\u008f\u0098\u00a8c\u00adZ\u00d8\u00b3O!\"N\u00a1\u009ak:\u00914\u00b3\u00fdj\u0085 /\u00e1R\u007f\u00d1\u00dcGgS=\u00e6\u00ad\u00a3Ht\u001ap>\u00a6.\u0091\u00a1\u001c\u00a4\u009a\u0081\u00ee\u008eUG\u00e4j;\u009b\u00ab^g\u00e5\"g9\u00bc\u00c0~m\u00b2\u00ff>\u00f5t\u009f5\u00d5\u00e0\u00f9\u00ed.\u00d9\u00dcv\u000f\u00ad\u009bH\u00d5\u0012dV\f\u00f3\u00e3\u008eo\u00f1\u008b\u00b9\u00f6\u00ab.\u0006\u00b6\u00abh[\u008a9S\u00fa8\u008f\t\u00a5K-\u00dcuH#\u0017\u00afG\u0097\u0086eS\u001c\u0085i\u00d2\bb\u0004\u007f-\u00a9\u0002@\u00da\u00bcM\u00c4\u00fa\u001e\\+t\u00fdd\u0000\u008a){\u0090+?l\u00197\u0019\u0017\u00ebg/\u00a1_\u00b7\u00f3\u00f0\tr\u00c8k\u00f4\u001cg\u00fb\u00f6i\u0019\u00f2\u00a1\u00c1\u00c0\u008a{Pn\u009d\u0001N\u00a8\u0096\u0003?\u0017\u0013F0\u00b0\u00b8\u0018\u0096\u00d5\u001cg\u008b6]\u00d2\u00fc\u00e1\u00d4\u00b8Ml\u00c4y*/d96\u001d7kc?1U\u00b5\u00b6\u00b6\u001cw^\u00a6\u00dbj\u009c{\"\u00d1R]=\u00f0W\u00b5f\u00b4\u00ba|=\u001f\u001d\f\u0097\u00b6\u00d9\u00f7=Kp\u00b3~\u000f".length();
                var1_4 = 99;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "k\u00ee\u00e4\u00ebY\u00a6\u009aI\u00c3\u00ca\u0098\"\u0012r\u00d6\u00ceZgV\"m\u009c\u00ad\u00ef\u00a3\u00cfK\u00fc''\u00fcE\u0003\u00c5\u0098\u0097v\u00cc\u00f3\u00e7\u00e9\u008b\u008d2\u0094J\u008e'\u00ff0\u00ab\u00a6\u008b\u0094\u00e9\u0012\u008b\u0001\u00ff\u0018J\u0001\u0097VK\u00ae\u00f3\u009ag\u0000\u00b3i\u008a^\u00d0\u00b0\u0006,\u00ad\u001aP\u00f4I\u0005\u001a\u00dd\u00bf\u0000&\u008c\u00ce\u00ee$\u00dd\u0097E\u008f\u0000\u0018Eg";
                    var4_3 = "k\u00ee\u00e4\u00ebY\u00a6\u009aI\u00c3\u00ca\u0098\"\u0012r\u00d6\u00ceZgV\"m\u009c\u00ad\u00ef\u00a3\u00cfK\u00fc''\u00fcE\u0003\u00c5\u0098\u0097v\u00cc\u00f3\u00e7\u00e9\u008b\u008d2\u0094J\u008e'\u00ff0\u00ab\u00a6\u008b\u0094\u00e9\u0012\u008b\u0001\u00ff\u0018J\u0001\u0097VK\u00ae\u00f3\u009ag\u0000\u00b3i\u008a^\u00d0\u00b0\u0006,\u00ad\u001aP\u00f4I\u0005\u001a\u00dd\u00bf\u0000&\u008c\u00ce\u00ee$\u00dd\u0097E\u008f\u0000\u0018Eg".length();
                    var1_4 = 31;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 124;
                            break;
                        }
                        case 1: {
                            v13 = 67;
                            break;
                        }
                        case 2: {
                            v13 = 112;
                            break;
                        }
                        case 3: {
                            v13 = 63;
                            break;
                        }
                        case 4: {
                            v13 = 50;
                            break;
                        }
                        case 5: {
                            v13 = 100;
                            break;
                        }
                        default: {
                            v13 = 20;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CertStoreUtil.m = var5;
        CertStoreUtil.n = new String[33];
        CertStoreUtil.DEPO_DIZIN_ADI = CertStoreUtil.a(2121, 27138);
        CertStoreUtil.e = CertStoreUtil.a(2139, -31698);
        CertStoreUtil.h = CertStoreUtil.a(2141, -4923);
        CertStoreUtil.a = LoggerFactory.getLogger(CertStoreUtil.class);
        CertStoreUtil.b = new HashMap<K, V>();
        CertStoreUtil.c = new HashMap<K, V>();
        CertStoreUtil.OZET_TIPI_SHA1 = DigestAlg.SHA1;
        CertStoreUtil.OZET_TIPI_SHA256 = DigestAlg.SHA256;
        CertStoreUtil.OZET_TIPI_SHA384 = DigestAlg.SHA384;
        CertStoreUtil.OZET_TIPI_SHA512 = DigestAlg.SHA512;
        CertStoreUtil.f = new byte[]{58, -42, 99, 86, 93, 100, 104, 122, 67, -4, 36, -29, -123, 35, 47, 47, 11, 15, 89, 102, -16, 123, -13, 122, -52, -94, 101, -4, 120, -18, 103, 115, 105, -15, -125, -49, -40, 16, 102, 40, 121, 28, 12, 97, 79, -27, -110, -19, 56, 31, -9, 94, -62, -12, -22, 64, -95, -82, 90, 43, 81, -11, 16, 99, 58, -45, -66, 64, -55, -88, 103, -101, -78, -30, -93, -122, 123, -44, -115, -74, -37, -103, -93, -85, 66, 71, -102, 63, 66, -75, -96, -112, -114, -49, 86, -115, -57, 9, 101, 5, 90, 88, 94, 105, 76, -20, 40, 57, 54, 107, 57, 5, -81, 99, -6, -55, -13, 88, 82, -48, 78, 124, -106, 69, -34, -72, -36, 74, 124, 52, 1, -54, -79, -84, 33, 116, 126, -12, 22, -31, 120, 68, 68, 28, 127, 59, -124, -118, -85, 111, 59, 114, -122, -2, -80, -17, -81, 52, 39, -13, 6, -63, -86, -47, -75, -2, -20, 118, 107, 83, -83, 27, 16, 13, 62, -106, -90, -108, 59, -34, -126, 92, -42, -27, -21, -76, 120, 124, 73, -33, -13, -123, 17, 108, 31, 44, 102, 86, -73, 68, 2, -117, 108, -86, 26, -15, 105, -70, 97, -118, -43, -102, -124, -23, 19, -87, 88, -94, 22, -23, 17, -102, -93, -113, 79, -76, -19, -4, 66, -66, 79, 26, 80, -45, -58, -22, -15, -93, 30, 59, -38, 123, 82, -60, -20, -123, -128, 46, 101, 121, 18, 53, -14, -57, 82, -62, -103, 125, -112, 24, 11, -125, -81, -30, 20, 7, 22, -26, 61, 96, -68, -113, 61, -11, -88, -63, 55, -3, -112, -119, 85, 79, -80, 33, -29, 22, 1, 37, -84, -24, -86, -27, 91, -105, 108, -86, 37, -106, 16, 12, 100, -37, -60, 100, -18, -77, -113, -92, 72, 108, 110, -48, -78, -28, 43, 16, -77, -102, -39, -13, 43, -79, -103, -6, -95, -98, 85, 28, 112, 126, 90, -50, -2, 76, -70, -29, -124, 11, -6, 12, 71, -20, -32, -84, -61, 11, 44, 80, -10, 74, -60, 70, 15, -104, -85, -32, 33, -47, 109, 84, 10, -99, -90, 118, 44, -112, -107, -48, -31, 72, -2, -10, -112, -44, -57, -57, -86, 68, -41, -28, 0, -47, 110, 37, 77, -16, -63, -120, 12, 54, -116, -62, -107, -60, 12, 30, -31, 78, -125, 84, -94, 61, -57, -115, 46, -19, -32, -84, 66, 56, 0, -50, -109, -3, -20, -124, -77, -86, 12, 75, -87, 76, 125, -84, -115, 80, -18, 97, 0, -13, 8, 64, -42, 118, -119, -58, -57, 87, -48, 117, -15, -110, 97, -16, 33, -2, -114, -113, 0, 85, 27, -45, -109, -119, -97, 77, 88, -124, -55, -35, 76, -42, -21, -85, -17, 41, 96, 90, -39, 89, 127, 116, -76, 69, 14, 2, -110, 81, 112, 58, 48, 12, -97, 63, 90, -52, 103, -19, -66, -123, -106, -29, 5, -78, -57, 110, -7, 65, -20, 22, 65, -95, -55, -83, 95, -71, -14, -30, -4, 12, -49, 16, -112, -112, 90, -104, -104, -5, -17, 79, -88, 34, -65, -21, -51, 103, 87, 45, -102, 67, -73, -101, 55, -60, -30, 21, -105, 99, -41, -44, -38, -14, -10, 96, -12, 110, 102, 115, 32, 103};
        CertStoreUtil.g = new byte[]{10, 84, 97, 116, 109, 105, 110, 115, 105, 122, 108, 101, 114, 46, 46, 46, 10, 10, 89, 101, 114, 121, -4, 122, -4, 32, 103, -10, 122, 108, 101, 114, 105, 110, 101, 32, 100, 101, 118, 32, 98, 105, 114, 32, 109, 101, 109, 101, 32, 103, 105, 98, 105, 32, 103, -10, 114, -4, 110, -4, 121, 111, 114, 46, 32, 77, 101, 109, 101, 121, 101, 32, 97, -16, -3, 122, 108, 97, 114, -3, 110, -3, 32, 117, 122, 97, 116, -3, 112, 32, 101, 109, 109, 101, 107, 32, 105, -25, 105, 110, 32, 98, 105, 114, 98, 105, 114, 108, 101, 114, 105, 110, 105, 32, 105, 116, 105, 121, 111, 114, 44, 32, 101, 122, 105, 121, 111, 114, 59, 32, 100, 97, 104, 97, 115, -3, 44, 32, 97, 108, 116, 116, 97, 110, 32, 97, 108, 116, 97, 32, 98, 105, 114, 98, 105, 114, 108, 101, 114, 105, 110, 100, 101, 110, 32, 110, 101, 102, 114, 101, 116, 32, 101, 100, 105, 121, 111, 114, 108, 97, 114, 46, 10, 10, 72, 101, 109, 101, 110, 32, 104, 101, 112, 115, 105, 32, 109, 111, 100, 101, 114, 110, 32, 100, -4, 110, 121, 97, 110, -3, 110, 32, 34, 121, 101, 110, 105, 34, 108, 105, 107, 32, 102, 101, 116, 105, -2, 105, 122, 109, 105, 32, 107, 97, 114, -2, -3, 115, -3, 110, 100, 97, 32, 98, -4, 121, -4, 108, 101, 110, 105, 121, 111, 114, 46, 32, 10, 10, 83, 97, 104, 105, 112, 32, 111, 108, 100, 117, 107, 108, 97, 114, -3, 32, 110, 101, 32, 118, 97, 114, 115, 97, 44, 32, 103, -10, 122, 108, 101, 114, 105, 110, 100, 101, 32, 118, 101, 32, 103, -10, 110, -4, 108, 108, 101, 114, 105, 110, 100, 101, 32, -25, 111, 107, 32, -25, 97, 98, 117, 107, 32, 101, 115, 107, 105, 121, 111, 114, 59, 32, 104, 101, 108, 101, 32, 100, 101, 32, 101, 115, 107, 105, 32, 100, 111, 115, 116, 108, 97, 114, 33, 46, 46, 10, 10, 66, 105, 114, 97, 122, 32, 100, 97, 32, -2, 97, -2, -3, 114, -3, 121, 111, 114, 108, 97, 114, 32, 107, 101, 110, 100, 105, 32, 104, 97, 108, 108, 101, 114, 105, 110, 101, 33, 32, 10, 10, 76, 97, 102, -3, 110, 32, 103, 101, 108, 105, -2, 105, 32, 121, 97, 44, 32, 116, -4, 112, 108, -4, 32, 100, 97, 108, 109, 97, 32, 109, 111, 100, 97, 115, -3, 32, -25, -3, 107, -3, 121, 111, 114, 44, 32, 104, 101, 109, 101, 110, 32, 100, 97, 108, 103, -3, -25, 32, 111, 108, 117, 121, 111, 114, 108, 97, 114, 59, 32, 97, 109, 97, 32, 98, 97, 107, -3, 121, 111, 114, 108, 97, 114, 32, 121, 105, 110, 101, 32, 109, 117, 116, 115, 117, 122, 108, 97, 114, 46, 32, 80, 105, 108, 111, 116, 108, 117, 107, 32, 109, 111, 100, 97, 32, 111, 108, 117, 121, 111, 114, 44, 32, 117, -25, 117, -2, 32, 100, 101, 114, 115, 105, 32, 97, 108, -3, 121, 111, 114, 108, 97, 114, 44, 32, 98, 114, -10, 118, 101, 108, 101, 114, 32, 102};
        CertStoreUtil.i = new byte[]{35, 21, 107, 29, 34, -65, 28, -59, -34, 20, -92, 80, -2, -16, -19, -39, -42, 91, -115, 50, -59, -15, -58, -63, 35, -117, 114, 25, -19, -97, 65, 85, -80, 104, 30, 110, 75, 94, 81, -105, -112, -13, 40, 2, -119, 25, -26, 13, 119, -105, 57, -5, -76, -11, -69, -3, 7, 114, 28, -93, 117, 121, -11, -83, 66, -29, -90, 62, 17, 75, 1, -3, 89, -22, 45, -118, 45, 46, 114, -60, 48, -44, -13, -25, -39, 53, 66, 101, -19, 11, -108, -73, 36, 8, -54, 126, -22, 89, 81, -80, 67, 112, 109, -114, -106, -4, 10, -55, -44, 69, -115, -91, 73, -43, 116, -70, 45, -67, -92, -69, -31, 79, 84, 127, -1, -3, 36, 76, 38, -58, -89, 98, 41, 100, -64, 106, -42, 5, 110, 13, -14, -121, 94, 72, -57, 1, 109, -98, 61, 30, 1, -124, 88, 51, -22, 46, 13, 31, 107, -22, 108, 26, 103, 118, 8, -83, 74, 52, -118, 67, -57, 57, -100, -55, 67, -87, -1, 91, 67, -110, 76, -72, 10, -67, -128, 88, 14, -12, 43, 89, -17, 50, 12, -67, -105, -40, 30, -7, 78, 27, 83, -23, -96, -117, 74, -100, 82, -97, 100, -67, -126, 36, 39, -86, -33, 10, 77, -45, 113, -65, 99, -106, -121, -47, -84, 80, 121, -80, -64, -66, 47, -99, 104, -127, -44, -66, -53, -109, -100, -53, 86, 35, -34, -98, 83, -5, 52, -60, -75, 42, 102, 46, 58, -38, -110, -60, -98, 72, -78, -79, 43, -48, 69, 81, 60, 92, 37, 102, -102, 64, -112, 82, 61, 3, 29, 63, 106, -30, 93, 108, 10, 88, 3, -122, 20, 75, -103, -88, -12, -59, -104, -88, 26, -107, -88, -33, 6, 103, 57, 84, 80, 46, 72, 54, 71, -65, -100, 48, 17, 109, 87, -109, -39, 7, -101, 102, -39, -65, 0, -126, 70, -51, -117, -88, -29, 22, -82, 79, 85, -105, -80, 111, -110, -58, -83, -99, -114, 122, 78, -6, -96, -106, -85, 63, -6, -3, -1, -88, -7, -73, -42, 121, -102, -111, -50, 50, 110, 7, 94, 46, 98, -38, -71, -61, 18, 20, -65, -35, 47, -21, 51, 107, 34, 99, -111, 10, -81, 113, 110, 69, 42, -114, -67, 62, 26, -53, -56, -57, 22, -4, -80, -112, 77, 77, -107, 67, -7, -117, -124, 68, 90, -88, -41, -2, 34, 10, 76, -56, 32, 38, 78, -81, -101, 59, -39, -6, -128, -124, -13, 114, -38, 13, 87, -42, 95, 111, -81, -65, -24, 62, -120, -121, -71, -13, -54, -77, -43, -106, -124, 114, 29, 56, 109, -54, 26, 119, 62, -113, -88, -64, -30, -76, 64, 33, 28, 90, -26, -31, -17, -62, 41, -48, 50, 86, 83, 70, -68, -36, 79, -15, -14, 83, 51, 108, 111, -87, -76, 72, -80, -118, -28, -122, -9, -71, -11, -68, 55, -126, -24, -118, -88, 16, 109, 38, -125, 74, -16, 60, -77, -2, -110, 92, 127, 20, 64, 111, -126, -86, 83, 109, -125, -79, -116, 97, -56, -15, 54, -60, -70, 117, -21, 85, 82, 25, 95, -115, -68, -106, 117, -94, -76, -86, -49, 51, -81, 112, 126, 106, -59, -19, -54, 90, 75, 95, -102, 44, -13, 2, -43, -117};
        CertStoreUtil.j = new byte[]{19, -105, 105, 63, 18, -78, 26, -52, -12, -110, -20, -42, 9, -3, -20, -40, -41, 94, -115, 49, 71, -13, -55, -63, 19, 9, 112, 19, -17, 29, 67, 84, -80, -38, -108, -63, -77, -51, 20, 17, -117, -110, 97, -114, -104, -128, -2, -89, -49, -50, 107, -92, -69, -119, 126, -56, 89, 92, 17, -120, 89, -57, -28, -117, 76, 77, -102, 66, -112, 100, -123, 9, -34, 87, -17, 10, 54, 26, 114, 118, 6, -55, 91, 97, 122, 71, 123, 100, -119, -71, -78, -50, -103, -19, 69, -89, -20, -64, -26, 21, -19, -72, 115, -121, -52, 60, -65, -29, 108, 52, -34, 40, 116, -89, 1, 5, 90, -47, -16, -53, 75, 90, -76, 51, 98, 85, 11, -15, 76, 113, -115, 106, -9, 72, 73, 101, -57, 18, 0, -34, -105, -31, -77, 44, -36, -74, 25, -33, 51, -34, -78, 92, -84, 14, 98, -113, 106, -51, 55, -112, -45, -46, -57, -82, -57, -71, -77, 123, 4, 108, 114, -80, -53, -97, 118, 41, 78, -108, 37, 116, -37, 8, -2, 38, 53, -3, -78, -80, -60, -8, -34, -56, -84, 20, 28, -31, 21, -88, -115, 24, -81, 97, 0, -80, -12, -33, 83, -71, 77, -92, -104, -57, 97, -98, -127, 20, -12, 93, 15, -93, -90, -71, 102, -117, -38, -116, -54, -3, 123, -20, -62, -70, -58, 119, -53, -18, -89, -44, 98, 6, 5, -71, 36, -10, -105, 17, 111, 80, -98, 110, 102, -96, -20, -1, 54, -97, -60, -67, -126, 65, 14, -47, 85, 53, -15, 127, 11, 20, 98, 125, 83, 89, 72, -90, 74, 3, 124, 29, -49, -58, -19, -40, 115, 105, -121, 13, 97, 79, -36, 117, -104, -124, -89, -64, -126, 73, -27, -56, -86, 41, 91, -116, 119, 97, -109, -103, -32, 71, 10, -90, 127, -59, 110, 35, 28, 14, -7, -96, -40, -101, 69, -21, -122, -114, 116, -93, 119, -111, 116, 54, -25, 69, -89, 74, -50, 14, 123, 2, 1, -20, -71, -85, 91, -61, 120, -106, 38, 125, -39, 66, -11, 25, 120, -121, -82, -106, -51, -18, -8, -119, -55, -10, -46, 81, 66, 58, -107, -76, 98, 112, -81, 68, -66, 60, -121, 20, -91, 121, 13, 45, 64, -88, 110, 32, -75, 31, 35, -7, 111, 90, 18, 98, -82, 125, -6, -120, -110, -50, -13, -18, -3, 87, 72, -91, -79, -28, 54, -36, 55, -9, 77, 63, -49, -66, -119, 40, -65, -30, -33, -1, 103, 115, 11, -54, 51, -39, 126, 11, 104, -29, -57, 68, -12, -118, -108, -57, 80, -78, 106, 94, -29, 97, 62, -118, 33, -44, -62, 4, 83, -117, 60, 3, 3, 48, 124, 67, 82, -52, 126, 122, 106, -124, -53, 42, 21, -52, 57, 111, 67, -124, 119, 86, 106, 13, 55, 49, 55, 52, 5, 11, -117, -99, 102, 33, -38, -127, 33, -125, -124, -1, 84, -88, 93, 106, -59, -124, 74, 116, 65, 18, -18, 54, -108, 50, 33, -35, 109, -56, -34, 43, -70, -60, 63, 95, -70, -35, -66, 33, 75, 95, 83, 101, 87, 36, -86, 60, 70, 126, -121, -102, 46, -63, 63, 78, 45, -114, -43, -58, 30, -122, -49, 20, 67, -41, 89, 46, -16, 3, -43, -118};
        CertStoreUtil.k = new byte[]{53, 19, -27, -119, 57, 24, 5, 91, -54, -92, -62, -17, 6, -128, -119, 13, -22, -87, 94, -72, -9, 20, -21, 96, -46, 31, 33, -19, 65, 8, -75, 81, 114, 114, 98, 22, 91, 118, -108, 118, -20, 84, -13, 0, -93, -35, 19, 35, 87, 47, 2, 114, 111, -112, -92, 63, 109, 68, -76, 113, -21, 103, -57, -25, 5, -10, 86, 30, 71, -116, -60, 98, -13, -59, -27, -27, -128, 46, 79, 14, -96, 60, 46, 36, 61, -29, -117, -63, 88, -31, -95, -25, 107, -25, -36, 93, -113, 52, 117, 82, 48, 8, -14, 58, 48, 123, 40, -99, 69, -78, -42, -39, -101, -38, 52, -88, -49, -14, 19, -39, 115, 116, -14, 99, -116, -93, 24, -8, 111, 118, -9, 86, 119, -13, -28, -99, 95, -119, 98, -17, 33, 0, 63, -116, -51, 39, 69, -36, -122, -2, -25, 84, 48, 22, -110, 70, -104, -81, 57, 117, -49, -83, -56, 84, 15, 28, 72, -70, 29, 25, 4, -42, -93, 25, 95, -37, -94, 45, 108, 21, 58, 122, 5, -6, -29, -77, -110, -58, 88, 33, 41, 119, -20, -65, 23, -105, 117, 103, -6, 44, -43, -39, -45, -56, -86, 91, -1, 59, -114, 77, 42, 69, 83, 29, 18, 85, 10, 78, 12, -29, 65, 37, -39, 96, -87, -48, -85, -17, 35, -89, -47, -117, 93, 67, -51, -59, 63, 63, 58, -68, 70, -119, -116, -106, 7, 107, 49, -127, -7, -34, 101, 27, 54, 48, -108, 95, -19, 99, -44, 106, -82, 109, -47, 91, 101, -7, -1, -62, 23, -109, -67, -17, 74, -39, -105, -7, 7, -113, 39, -100, 113, 102, 72, 1, -31, 10, -46, -1, 68, -71, 94, -36, 5, 12, -75, 19, -73, -3, -51, 12, -118, -23, -12, -87, -77, 113, -91, -107, 8, 69, 17, -81, -101, 29, 123, 32, 35, -104, 71, 102, -85, 31, -102, -70, -77, 33, 110, -78, 22, 75, -86, 121, 11, -37, -38, 125, 53, 56, -94, -107, -6, -47, 111, -27, -71, -117, 112, -46, 126, 44, 98, 118, 30, 55, -104, 82, -19, -48, 78, 83, -1, -64, -107, -91, -95, -17, 58, -127, 90, -19, -66, 121, 48, -94, 14, -91, -56, 18, -76, 73, 14, 29, -7, -28, 51, -34, 64, 66, -35, 105, 16, 5, -88, -77, 31, -117, -107, 123, 5, -27, 16, 73, 96, 113, 58, -57, 98, -42, -73, -113, 87, -37, 73, -38, 61, -56, 86, 37, -30, -69, -109, 102, 30, -121, 23, -5, -87, 84, 22, -121, 26, 47, -81, 32, -25, 104, 117, 5, -66, 78, 23, 120, 36, 99, -27, -16, 2, 109, 104, -35, 61, -101, 123, 21, -95, 108, -117, 34, 92, 4, 100, -66, -1, -29, -75, 64, -77, 68, 105, 51, -121, -102, -68, 16, 19, -117, 3, 84, 41, 97, -30, 115, -119, 27, -72, -12, 31, 91, -56, 98, -106, -125, 94, -39, 77, 71, 115, 36, -85, 91, 122, 15, 54, 121, 124, 103, -61, 70, 80, -92, -95, 114, -22, -22, -44, 23, -29, -93, -63, 98, -87, -42, 75, -93, 60, -91, -86, 57, 31, 125, -108, 64, -94, 87, -104, 38, -114, 84, 117, 111, -68, 48, 65, 125, -51, 126, -8, 33, -117, -105};
        CertStoreUtil.l = new byte[]{5, -111, -25, -85, 9, 21, 3, 82, -32, 34, -118, 105, -15, -115, -120, 12, -21, -84, 94, -69, 117, 22, -28, 96, -30, -99, 35, -25, 67, -118, -73, 80, 114, -88, -28, -63, -17, -78, -45, -54, 114, 114, -92, 114, -72, -54, 85, -31, 84, 31, -57, 96, -79, 120, -20, -33, 47, 12, 119, 54, 25, -120, 16, 125, -71, 20, 126, -59, 117, 60, -4, -38, 11, -126, -89, -95, -38, -96, -28, 12, 4, -122, 60, -52, 104, 111, 56, -47, 103, 5, 70, -120, 99, -40, -17, -66, 49, 106, 106, 77, 82, -116, 58, 126, -33, 67, -54, -58, 89, 91, 2, -95, 99, 91, 4, 121, -18, 127, -64, -29, -98, -15, 43, -44, -17, -45, -59, 106, -54, 13, -12, -100, 119, 94, -112, 22, -50, -54, -16, 3, 93, 88, -41, -55, 56, -47, 111, 4, 59, 68, 110, -43, 72, -127, -38, -12, 2, -26, -72, -29, 60, -29, -56, -111, -2, -55, 111, -117, -78, 96, -103, 105, -74, 104, -90, -62, -38, 34, 43, -14, 54, 89, 96, -75, 65, -103, 125, -128, 16, 4, -3, 111, -85, 50, -25, 84, 27, -107, -69, -83, 33, 123, 77, -105, -99, 2, -86, -91, 65, 74, 39, -79, 32, -63, 57, 61, -110, 4, 2, -107, 109, 82, 60, 115, 106, 16, -6, -57, -92, -121, 113, 120, -105, 68, 121, -28, 27, 48, 24, 116, -73, -64, -52, 57, 107, 117, -33, -77, 62, -25, -79, 61, 87, 91, -15, 111, -127, -16, -99, 48, 40, -82, 70, 85, 43, 51, 41, -47, 86, -53, -58, 15, -34, 58, 50, -118, -19, 124, 23, 79, 113, 113, -106, -58, 8, 43, 3, -22, -33, -12, 72, -61, -122, 21, -124, 7, -5, 46, -4, 25, -125, 62, -94, 101, 44, -34, 71, 80, -45, 96, 7, -100, -81, -80, -38, 27, -91, -36, -50, -41, -32, -23, -63, 118, 33, 71, 101, 84, 108, -22, 38, -11, 54, -88, -47, 34, 39, -47, -19, 98, -15, -30, -28, 35, -19, -127, -72, 44, 124, 42, -100, -20, 94, -116, -87, -38, 110, -65, -92, 0, 50, 23, 109, -21, -36, -122, -15, 31, -85, -111, -32, -31, -102, -116, -15, -73, 81, -94, -80, -128, 119, -110, 9, -7, -62, 86, 95, 51, -120, 41, 16, -96, -62, -111, -51, 21, 71, 36, -14, -104, -12, -65, 10, -59, -39, 112, 5, 11, -16, 126, 121, -111, -82, 76, 109, 123, -29, 59, 96, -63, 25, 119, -122, -122, -1, -99, 22, 127, -8, -20, -37, -121, 122, -124, 53, -7, 38, 56, 40, 80, 79, 39, 15, 71, 8, -110, 107, -30, -45, -124, -84, -89, -80, 105, -73, 49, -28, 117, -52, -42, -45, 102, 72, -24, 15, -87, -34, 125, -62, -104, -114, -71, -16, 49, 5, -65, 110, 123, -81, -121, 90, 2, -34, -54, -24, -128, -98, -2, 68, 86, 95, 76, -116, -108, 7, -9, -14, -125, 113, -78, -97, 96, -104, 102, 14, -53, 79, 39, 111, -76, -26, 64, -14, -23, -89, -14, -100, 5, 13, 108, -31, -76, 38, 70, 81, 38, -81, 99, -8, 113, -32, 92, -43, -31, -123, -103, -48, 51, -4, -96, 116, 80, 28, 51, -66, 124, -5, 32, -117, -106};
        CertStoreUtil.a(CertStoreUtil.f, CertStoreUtil.g);
        CertStoreUtil.a(CertStoreUtil.i, CertStoreUtil.j);
        CertStoreUtil.a(CertStoreUtil.k, CertStoreUtil.l);
        CertStoreUtil.d = CertStoreUtil.a();
        CertStoreUtil.c.put(OzetTipi.SHA1.getIntValue(), CertStoreUtil.OZET_TIPI_SHA1);
        CertStoreUtil.c.put(OzetTipi.SHA256.getIntValue(), CertStoreUtil.OZET_TIPI_SHA256);
        CertStoreUtil.c.put(OzetTipi.SHA384.getIntValue(), CertStoreUtil.OZET_TIPI_SHA384);
        CertStoreUtil.c.put(OzetTipi.SHA512.getIntValue(), CertStoreUtil.OZET_TIPI_SHA512);
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0x847) & 0xFFFF;
        if (n[n4] == null) {
            int n5;
            int n6;
            char[] cArray = m[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 127;
                    break;
                }
                case 1: {
                    n6 = 221;
                    break;
                }
                case 2: {
                    n6 = 195;
                    break;
                }
                case 3: {
                    n6 = 84;
                    break;
                }
                case 4: {
                    n6 = 75;
                    break;
                }
                case 5: {
                    n6 = 31;
                    break;
                }
                case 6: {
                    n6 = 40;
                    break;
                }
                case 7: {
                    n6 = 211;
                    break;
                }
                case 8: {
                    n6 = 161;
                    break;
                }
                case 9: {
                    n6 = 85;
                    break;
                }
                case 10: {
                    n6 = 224;
                    break;
                }
                case 11: {
                    n6 = 52;
                    break;
                }
                case 12: {
                    n6 = 1;
                    break;
                }
                case 13: {
                    n6 = 3;
                    break;
                }
                case 14: {
                    n6 = 215;
                    break;
                }
                case 15: {
                    n6 = 186;
                    break;
                }
                case 16: {
                    n6 = 35;
                    break;
                }
                case 17: {
                    n6 = 131;
                    break;
                }
                case 18: {
                    n6 = 82;
                    break;
                }
                case 19: {
                    n6 = 142;
                    break;
                }
                case 20: {
                    n6 = 47;
                    break;
                }
                case 21: {
                    n6 = 17;
                    break;
                }
                case 22: {
                    n6 = 81;
                    break;
                }
                case 23: {
                    n6 = 8;
                    break;
                }
                case 24: {
                    n6 = 14;
                    break;
                }
                case 25: {
                    n6 = 91;
                    break;
                }
                case 26: {
                    n6 = 95;
                    break;
                }
                case 27: {
                    n6 = 16;
                    break;
                }
                case 28: {
                    n6 = 170;
                    break;
                }
                case 29: {
                    n6 = 226;
                    break;
                }
                case 30: {
                    n6 = 182;
                    break;
                }
                case 31: {
                    n6 = 133;
                    break;
                }
                case 32: {
                    n6 = 18;
                    break;
                }
                case 33: {
                    n6 = 248;
                    break;
                }
                case 34: {
                    n6 = 151;
                    break;
                }
                case 35: {
                    n6 = 205;
                    break;
                }
                case 36: {
                    n6 = 183;
                    break;
                }
                case 37: {
                    n6 = 62;
                    break;
                }
                case 38: {
                    n6 = 122;
                    break;
                }
                case 39: {
                    n6 = 43;
                    break;
                }
                case 40: {
                    n6 = 135;
                    break;
                }
                case 41: {
                    n6 = 33;
                    break;
                }
                case 42: {
                    n6 = 222;
                    break;
                }
                case 43: {
                    n6 = 110;
                    break;
                }
                case 44: {
                    n6 = 128;
                    break;
                }
                case 45: {
                    n6 = 184;
                    break;
                }
                case 46: {
                    n6 = 94;
                    break;
                }
                case 47: {
                    n6 = 39;
                    break;
                }
                case 48: {
                    n6 = 15;
                    break;
                }
                case 49: {
                    n6 = 144;
                    break;
                }
                case 50: {
                    n6 = 140;
                    break;
                }
                case 51: {
                    n6 = 201;
                    break;
                }
                case 52: {
                    n6 = 29;
                    break;
                }
                case 53: {
                    n6 = 19;
                    break;
                }
                case 54: {
                    n6 = 243;
                    break;
                }
                case 55: {
                    n6 = 55;
                    break;
                }
                case 56: {
                    n6 = 152;
                    break;
                }
                case 57: {
                    n6 = 80;
                    break;
                }
                case 58: {
                    n6 = 239;
                    break;
                }
                case 59: {
                    n6 = 106;
                    break;
                }
                case 60: {
                    n6 = 98;
                    break;
                }
                case 61: {
                    n6 = 225;
                    break;
                }
                case 62: {
                    n6 = 118;
                    break;
                }
                case 63: {
                    n6 = 242;
                    break;
                }
                case 64: {
                    n6 = 103;
                    break;
                }
                case 65: {
                    n6 = 104;
                    break;
                }
                case 66: {
                    n6 = 61;
                    break;
                }
                case 67: {
                    n6 = 76;
                    break;
                }
                case 68: {
                    n6 = 175;
                    break;
                }
                case 69: {
                    n6 = 143;
                    break;
                }
                case 70: {
                    n6 = 219;
                    break;
                }
                case 71: {
                    n6 = 232;
                    break;
                }
                case 72: {
                    n6 = 191;
                    break;
                }
                case 73: {
                    n6 = 86;
                    break;
                }
                case 74: {
                    n6 = 196;
                    break;
                }
                case 75: {
                    n6 = 214;
                    break;
                }
                case 76: {
                    n6 = 5;
                    break;
                }
                case 77: {
                    n6 = 102;
                    break;
                }
                case 78: {
                    n6 = 77;
                    break;
                }
                case 79: {
                    n6 = 120;
                    break;
                }
                case 80: {
                    n6 = 213;
                    break;
                }
                case 81: {
                    n6 = 136;
                    break;
                }
                case 82: {
                    n6 = 59;
                    break;
                }
                case 83: {
                    n6 = 25;
                    break;
                }
                case 84: {
                    n6 = 71;
                    break;
                }
                case 85: {
                    n6 = 247;
                    break;
                }
                case 86: {
                    n6 = 42;
                    break;
                }
                case 87: {
                    n6 = 126;
                    break;
                }
                case 88: {
                    n6 = 20;
                    break;
                }
                case 89: {
                    n6 = 69;
                    break;
                }
                case 90: {
                    n6 = 237;
                    break;
                }
                case 91: {
                    n6 = 172;
                    break;
                }
                case 92: {
                    n6 = 141;
                    break;
                }
                case 93: {
                    n6 = 56;
                    break;
                }
                case 94: {
                    n6 = 70;
                    break;
                }
                case 95: {
                    n6 = 44;
                    break;
                }
                case 96: {
                    n6 = 198;
                    break;
                }
                case 97: {
                    n6 = 145;
                    break;
                }
                case 98: {
                    n6 = 157;
                    break;
                }
                case 99: {
                    n6 = 26;
                    break;
                }
                case 100: {
                    n6 = 22;
                    break;
                }
                case 101: {
                    n6 = 207;
                    break;
                }
                case 102: {
                    n6 = 6;
                    break;
                }
                case 103: {
                    n6 = 210;
                    break;
                }
                case 104: {
                    n6 = 41;
                    break;
                }
                case 105: {
                    n6 = 7;
                    break;
                }
                case 106: {
                    n6 = 30;
                    break;
                }
                case 107: {
                    n6 = 189;
                    break;
                }
                case 108: {
                    n6 = 229;
                    break;
                }
                case 109: {
                    n6 = 158;
                    break;
                }
                case 110: {
                    n6 = 236;
                    break;
                }
                case 111: {
                    n6 = 245;
                    break;
                }
                case 112: {
                    n6 = 173;
                    break;
                }
                case 113: {
                    n6 = 63;
                    break;
                }
                case 114: {
                    n6 = 199;
                    break;
                }
                case 115: {
                    n6 = 50;
                    break;
                }
                case 116: {
                    n6 = 132;
                    break;
                }
                case 117: {
                    n6 = 185;
                    break;
                }
                case 118: {
                    n6 = 238;
                    break;
                }
                case 119: {
                    n6 = 208;
                    break;
                }
                case 120: {
                    n6 = 0;
                    break;
                }
                case 121: {
                    n6 = 235;
                    break;
                }
                case 122: {
                    n6 = 12;
                    break;
                }
                case 123: {
                    n6 = 150;
                    break;
                }
                case 124: {
                    n6 = 230;
                    break;
                }
                case 125: {
                    n6 = 72;
                    break;
                }
                case 126: {
                    n6 = 32;
                    break;
                }
                case 127: {
                    n6 = 11;
                    break;
                }
                case 128: {
                    n6 = 202;
                    break;
                }
                case 129: {
                    n6 = 177;
                    break;
                }
                case 130: {
                    n6 = 137;
                    break;
                }
                case 131: {
                    n6 = 49;
                    break;
                }
                case 132: {
                    n6 = 24;
                    break;
                }
                case 133: {
                    n6 = 9;
                    break;
                }
                case 134: {
                    n6 = 192;
                    break;
                }
                case 135: {
                    n6 = 4;
                    break;
                }
                case 136: {
                    n6 = 28;
                    break;
                }
                case 137: {
                    n6 = 79;
                    break;
                }
                case 138: {
                    n6 = 66;
                    break;
                }
                case 139: {
                    n6 = 57;
                    break;
                }
                case 140: {
                    n6 = 162;
                    break;
                }
                case 141: {
                    n6 = 165;
                    break;
                }
                case 142: {
                    n6 = 240;
                    break;
                }
                case 143: {
                    n6 = 109;
                    break;
                }
                case 144: {
                    n6 = 36;
                    break;
                }
                case 145: {
                    n6 = 139;
                    break;
                }
                case 146: {
                    n6 = 64;
                    break;
                }
                case 147: {
                    n6 = 93;
                    break;
                }
                case 148: {
                    n6 = 74;
                    break;
                }
                case 149: {
                    n6 = 92;
                    break;
                }
                case 150: {
                    n6 = 90;
                    break;
                }
                case 151: {
                    n6 = 212;
                    break;
                }
                case 152: {
                    n6 = 159;
                    break;
                }
                case 153: {
                    n6 = 146;
                    break;
                }
                case 154: {
                    n6 = 129;
                    break;
                }
                case 155: {
                    n6 = 168;
                    break;
                }
                case 156: {
                    n6 = 2;
                    break;
                }
                case 157: {
                    n6 = 87;
                    break;
                }
                case 158: {
                    n6 = 13;
                    break;
                }
                case 159: {
                    n6 = 68;
                    break;
                }
                case 160: {
                    n6 = 204;
                    break;
                }
                case 161: {
                    n6 = 27;
                    break;
                }
                case 162: {
                    n6 = 163;
                    break;
                }
                case 163: {
                    n6 = 174;
                    break;
                }
                case 164: {
                    n6 = 188;
                    break;
                }
                case 165: {
                    n6 = 203;
                    break;
                }
                case 166: {
                    n6 = 171;
                    break;
                }
                case 167: {
                    n6 = 108;
                    break;
                }
                case 168: {
                    n6 = 73;
                    break;
                }
                case 169: {
                    n6 = 100;
                    break;
                }
                case 170: {
                    n6 = 34;
                    break;
                }
                case 171: {
                    n6 = 96;
                    break;
                }
                case 172: {
                    n6 = 88;
                    break;
                }
                case 173: {
                    n6 = 60;
                    break;
                }
                case 174: {
                    n6 = 169;
                    break;
                }
                case 175: {
                    n6 = 111;
                    break;
                }
                case 176: {
                    n6 = 134;
                    break;
                }
                case 177: {
                    n6 = 194;
                    break;
                }
                case 178: {
                    n6 = 250;
                    break;
                }
                case 179: {
                    n6 = 148;
                    break;
                }
                case 180: {
                    n6 = 209;
                    break;
                }
                case 181: {
                    n6 = 153;
                    break;
                }
                case 182: {
                    n6 = 51;
                    break;
                }
                case 183: {
                    n6 = 249;
                    break;
                }
                case 184: {
                    n6 = 244;
                    break;
                }
                case 185: {
                    n6 = 253;
                    break;
                }
                case 186: {
                    n6 = 99;
                    break;
                }
                case 187: {
                    n6 = 37;
                    break;
                }
                case 188: {
                    n6 = 58;
                    break;
                }
                case 189: {
                    n6 = 38;
                    break;
                }
                case 190: {
                    n6 = 124;
                    break;
                }
                case 191: {
                    n6 = 181;
                    break;
                }
                case 192: {
                    n6 = 179;
                    break;
                }
                case 193: {
                    n6 = 197;
                    break;
                }
                case 194: {
                    n6 = 155;
                    break;
                }
                case 195: {
                    n6 = 45;
                    break;
                }
                case 196: {
                    n6 = 130;
                    break;
                }
                case 197: {
                    n6 = 180;
                    break;
                }
                case 198: {
                    n6 = 10;
                    break;
                }
                case 199: {
                    n6 = 255;
                    break;
                }
                case 200: {
                    n6 = 167;
                    break;
                }
                case 201: {
                    n6 = 107;
                    break;
                }
                case 202: {
                    n6 = 254;
                    break;
                }
                case 203: {
                    n6 = 176;
                    break;
                }
                case 204: {
                    n6 = 48;
                    break;
                }
                case 205: {
                    n6 = 233;
                    break;
                }
                case 206: {
                    n6 = 53;
                    break;
                }
                case 207: {
                    n6 = 166;
                    break;
                }
                case 208: {
                    n6 = 101;
                    break;
                }
                case 209: {
                    n6 = 113;
                    break;
                }
                case 210: {
                    n6 = 217;
                    break;
                }
                case 211: {
                    n6 = 23;
                    break;
                }
                case 212: {
                    n6 = 154;
                    break;
                }
                case 213: {
                    n6 = 200;
                    break;
                }
                case 214: {
                    n6 = 78;
                    break;
                }
                case 215: {
                    n6 = 112;
                    break;
                }
                case 216: {
                    n6 = 46;
                    break;
                }
                case 217: {
                    n6 = 228;
                    break;
                }
                case 218: {
                    n6 = 246;
                    break;
                }
                case 219: {
                    n6 = 190;
                    break;
                }
                case 220: {
                    n6 = 115;
                    break;
                }
                case 221: {
                    n6 = 123;
                    break;
                }
                case 222: {
                    n6 = 218;
                    break;
                }
                case 223: {
                    n6 = 241;
                    break;
                }
                case 224: {
                    n6 = 193;
                    break;
                }
                case 225: {
                    n6 = 125;
                    break;
                }
                case 226: {
                    n6 = 21;
                    break;
                }
                case 227: {
                    n6 = 149;
                    break;
                }
                case 228: {
                    n6 = 67;
                    break;
                }
                case 229: {
                    n6 = 54;
                    break;
                }
                case 230: {
                    n6 = 83;
                    break;
                }
                case 231: {
                    n6 = 105;
                    break;
                }
                case 232: {
                    n6 = 156;
                    break;
                }
                case 233: {
                    n6 = 138;
                    break;
                }
                case 234: {
                    n6 = 160;
                    break;
                }
                case 235: {
                    n6 = 65;
                    break;
                }
                case 236: {
                    n6 = 97;
                    break;
                }
                case 237: {
                    n6 = 251;
                    break;
                }
                case 238: {
                    n6 = 117;
                    break;
                }
                case 239: {
                    n6 = 178;
                    break;
                }
                case 240: {
                    n6 = 147;
                    break;
                }
                case 241: {
                    n6 = 231;
                    break;
                }
                case 242: {
                    n6 = 220;
                    break;
                }
                case 243: {
                    n6 = 121;
                    break;
                }
                case 244: {
                    n6 = 223;
                    break;
                }
                case 245: {
                    n6 = 216;
                    break;
                }
                case 246: {
                    n6 = 252;
                    break;
                }
                case 247: {
                    n6 = 119;
                    break;
                }
                case 248: {
                    n6 = 116;
                    break;
                }
                case 249: {
                    n6 = 114;
                    break;
                }
                case 250: {
                    n6 = 89;
                    break;
                }
                case 251: {
                    n6 = 187;
                    break;
                }
                case 252: {
                    n6 = 227;
                    break;
                }
                case 253: {
                    n6 = 234;
                    break;
                }
                case 254: {
                    n6 = 164;
                    break;
                }
                default: {
                    n6 = 206;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            CertStoreUtil.n[n4] = new String(cArray).intern();
        }
        return n[n4];
    }
}

