/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.ItemSource;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.NotFoundException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzetTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzneTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.SILTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoDizin;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOzet;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSIL;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.ops.CertStoreRootCertificateOps;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.CRLSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.util.RsItemSource;

public class CertStoreCRLOps {
    private static Logger a;
    private final CertStore b;
    private static final String[] c;
    private static final String[] d;

    public CertStoreCRLOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(CertStoreCRLOps.a(2031, -2653), lE);
            throw new ESYARuntimeException(CertStoreCRLOps.a(2021, 7830) + lE.getMessage(), lE);
        }
        this.b = aDepo;
    }

    public DepoSIL readStoreCRL(Long aSILNo) throws CertStoreException {
        if (aSILNo <= 0L) {
            throw new CertStoreException(CertStoreCRLOps.a(2029, 2529));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            DepoSIL depoSIL = depoVEN.sILOku(aSILNo);
            return depoSIL;
        }
        catch (NotFoundException notFoundException) {
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(2019, 22139), notFoundException);
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(2036, 1627), certStoreException);
        }
    }

    public void writeCRL(ECRL aCRL, Long aDizinNo) throws CertStoreException {
        this.writeCRL(aCRL.getEncoded(), aDizinNo);
    }

    public void writeCRL(byte[] aCRL, Long aDizinNo) throws CertStoreException {
        DepoSIL depoSIL = null;
        try {
            depoSIL = CertStoreUtil.asnCRLTODepoSIL(aCRL);
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreCRLOps.a(2042, -4336), exception);
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            List<DepoOzet> list = CertStoreUtil.convertToDepoOzet(depoSIL.getValue(), OzneTipi.SIL);
            depoVEN.sILYaz(depoSIL, list, aDizinNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(CertStoreCRLOps.a(2017, -16160), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemSource<DepoSIL> listStoreCRL() throws CertStoreException {
        ItemSource<DepoSIL> itemSource2;
        try {
            ItemSource<DepoSIL> itemSource;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            itemSource2 = itemSource = depoVEN.sILListele();
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(CertStoreCRLOps.a(2030, 26520), certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(CertStoreCRLOps.a(2030, 26520), certStoreException2);
                }
            }
        }
        try {
            JDBCUtil.commit(this.b.getConn());
            return itemSource2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreCRLOps.a(1995, 32520), certStoreException);
        }
    }

    public List<ECRL> listCRL(CRLSearchTemplate aSAS, SILTipi[] aTipler) throws CertStoreException {
        ItemSource<DepoSIL> itemSource = this.listStoreCRL(aSAS, aTipler);
        ArrayList<ECRL> arrayList = new ArrayList<ECRL>();
        boolean bl = CertStoreRootCertificateOps.c;
        try {
            DepoSIL depoSIL = itemSource.nextItem();
            while (depoSIL != null) {
                arrayList.add(new ECRL(depoSIL.getValue()));
                depoSIL = itemSource.nextItem();
                if (!bl) continue;
                break;
            }
        }
        catch (Exception exception) {
            throw new CertStoreException(exception);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemSource<DepoSIL> listStoreCRL(CRLSearchTemplate aSAS, SILTipi[] aTipler) throws CertStoreException {
        ItemSource<DepoSIL> itemSource2;
        try {
            ItemSource<DepoSIL> itemSource;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSAS, aTipler);
            String string = pair.first();
            List<Object> list = pair.second();
            itemSource2 = itemSource = depoVEN.sILListele(string, list.toArray());
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(CertStoreCRLOps.a(2037, -16268), certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(CertStoreCRLOps.a(2037, -16268), certStoreException2);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return itemSource2;
            JDBCUtil.commit(this.b.getConn());
            return itemSource2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreCRLOps.a(1992, 682), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoDizin> listCRLDirectories(long aSILNo) throws CertStoreException {
        List<DepoDizin> list2;
        if (aSILNo <= 0L) {
            throw new CertStoreException(CertStoreCRLOps.a(2029, 2529));
        }
        try {
            List<DepoDizin> list;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            list2 = list = ((RsItemSource)depoVEN.sILDizinleriniListele(aSILNo)).toList();
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(aSILNo + CertStoreCRLOps.a(2039, 1577), certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(aSILNo + CertStoreCRLOps.a(2039, 1577), certStoreException2);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return list2;
            JDBCUtil.commit(this.b.getConn());
            return list2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(2047, 11148), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteCRLFromDirectory(long aSILNo, long aDizinNo) throws CertStoreException {
        if (aSILNo <= 0L) throw new CertStoreException(CertStoreCRLOps.a(2029, 2529));
        if (aDizinNo <= 0L) {
            throw new CertStoreException(CertStoreCRLOps.a(2029, 2529));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.dizindenSILSil(aSILNo, aDizinNo);
            JDBCUtil.commit(this.b.getConn());
            return;
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() == null) throw new CertStoreException(aSILNo + CertStoreCRLOps.a(2040, -16045) + aDizinNo + CertStoreCRLOps.a(2046, 14836), certStoreException);
            JDBCUtil.rollback(this.b.getConn());
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(2040, -16045) + aDizinNo + CertStoreCRLOps.a(2046, 14836), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void moveCRL(long aSILNo, long aEskiDizinNo, long aYeniDizinNo) throws CertStoreException {
        if (aSILNo <= 0L) throw new CertStoreException(CertStoreCRLOps.a(2029, 2529));
        if (aEskiDizinNo <= 0L) throw new CertStoreException(CertStoreCRLOps.a(2029, 2529));
        if (aYeniDizinNo <= 0L) {
            throw new CertStoreException(CertStoreCRLOps.a(2029, 2529));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.sILTasi(aSILNo, aEskiDizinNo, aYeniDizinNo);
            JDBCUtil.commit(this.b.getConn());
            return;
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() == null) throw new CertStoreException(aSILNo + CertStoreCRLOps.a(2045, -25748) + aEskiDizinNo + CertStoreCRLOps.a(2024, 8076) + aYeniDizinNo + CertStoreCRLOps.a(2016, 5715), certStoreException);
            JDBCUtil.rollback(this.b.getConn());
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(2045, -25748) + aEskiDizinNo + CertStoreCRLOps.a(2024, 8076) + aYeniDizinNo + CertStoreCRLOps.a(2016, 5715), certStoreException);
        }
    }

    public void deleteCRL(long aSILNo) throws CertStoreException {
        if (aSILNo <= 0L) {
            throw new CertStoreException(CertStoreCRLOps.a(2022, 30695));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.sILSil(aSILNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(2020, -18765), certStoreException);
        }
    }

    public int deleteCRL(CRLSearchTemplate aSAS) throws CertStoreException {
        Long l2 = aSAS.getDizinNo();
        boolean bl = CertStoreRootCertificateOps.c;
        SILTipi[] sILTipiArray = new SILTipi[]{SILTipi.BASE, SILTipi.DELTA};
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSAS, sILTipiArray);
            String string = pair.first();
            List<Object> list = pair.second();
            ItemSource<DepoSIL> itemSource = depoVEN.sILListele(string, list.toArray());
            int n2 = 0;
            DepoSIL depoSIL = itemSource.nextItem();
            while (depoSIL != null) {
                block11: {
                    block10: {
                        if (l2 != null) break block10;
                        n2 += depoVEN.sILSil(depoSIL.getSILNo());
                        if (!bl) break block11;
                    }
                    n2 += depoVEN.dizindenSILSil(depoSIL.getSILNo(), l2);
                }
                depoSIL = itemSource.nextItem();
                if (!bl) continue;
            }
            JDBCUtil.commit(this.b.getConn());
            return n2;
        }
        catch (Exception exception) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(CertStoreCRLOps.a(2026, -8955), exception);
        }
    }

    private Pair<String, List<Object>> a(CRLSearchTemplate cRLSearchTemplate, SILTipi[] sILTipiArray) {
        ArrayList<Object> arrayList;
        boolean bl;
        StringBuffer stringBuffer;
        block38: {
            stringBuffer = new StringBuffer("");
            bl = CertStoreRootCertificateOps.c;
            arrayList = new ArrayList<Object>();
            stringBuffer.append(CertStoreCRLOps.a(2018, -12060));
            if (sILTipiArray == null || sILTipiArray.length == 0) break block38;
            stringBuffer.append(CertStoreCRLOps.a(2034, 12020));
            stringBuffer.append(CertStoreCRLOps.a(2038, -13044));
            stringBuffer.append("(");
            for (int i2 = 0; i2 < sILTipiArray.length - 1; ++i2) {
                stringBuffer.append(sILTipiArray[i2].getIntValue() + CertStoreCRLOps.a(2028, 4400));
                if (!bl) continue;
            }
            stringBuffer.append(sILTipiArray[sILTipiArray.length - 1].getIntValue());
            stringBuffer.append(")");
        }
        if (cRLSearchTemplate != null) {
            block41: {
                OzetTipi ozetTipi;
                block39: {
                    block40: {
                        Long l2 = cRLSearchTemplate.getDizinNo();
                        if (l2 != null) {
                            stringBuffer.append(CertStoreCRLOps.a(2043, 2759));
                            arrayList.add(l2);
                        }
                        byte[] byArray = cRLSearchTemplate.getValue();
                        if (byArray != null) {
                            stringBuffer.append(CertStoreCRLOps.a(2044, -13566));
                            arrayList.add(byArray);
                        }
                        byte[] byArray2 = cRLSearchTemplate.getHash();
                        ozetTipi = cRLSearchTemplate.getHashType();
                        if (byArray2 == null) break block39;
                        stringBuffer.append(CertStoreCRLOps.a(1996, 31674));
                        arrayList.add(OzneTipi.SIL.getIntValue());
                        arrayList.add(byArray2);
                        if (ozetTipi == null) break block40;
                        stringBuffer.append(CertStoreCRLOps.a(2023, -10678));
                        arrayList.add(ozetTipi.getIntValue());
                        if (!bl) break block41;
                    }
                    stringBuffer.append(CertStoreCRLOps.a(2025, -14126));
                    if (!bl) break block41;
                }
                if (ozetTipi == null) break block41;
                stringBuffer.append(CertStoreCRLOps.a(1993, 8150));
                arrayList.add(OzneTipi.SIL.getIntValue());
                arrayList.add(ozetTipi.getIntValue());
            }
            byte[] byArray = cRLSearchTemplate.getIssuer();
            if (byArray != null) {
                stringBuffer.append(CertStoreCRLOps.a(2041, -27179));
                arrayList.add(byArray);
            }
            byte[] byArray3 = cRLSearchTemplate.getSILNumber();
            if (byArray3 != null) {
                stringBuffer.append(CertStoreCRLOps.a(2027, 20288));
                arrayList.add(byArray3);
            }
            Date date = cRLSearchTemplate.getPublishedBefore();
            if (date != null) {
                stringBuffer.append(CertStoreCRLOps.a(2032, 5159));
                arrayList.add(date);
            }
            Date date2 = cRLSearchTemplate.getPublishedAfter();
            if (date2 != null) {
                stringBuffer.append(CertStoreCRLOps.a(2033, -7647));
                arrayList.add(date2);
            }
            Date date3 = cRLSearchTemplate.getValidAt();
            if (date3 != null) {
                stringBuffer.append(CertStoreCRLOps.a(2035, 22220));
                arrayList.add(date3);
                arrayList.add(date3);
            }
            byte[] byArray4 = cRLSearchTemplate.getBaseSILNumber();
            if (byArray4 != null) {
                stringBuffer.append(CertStoreCRLOps.a(1994, -32720));
                arrayList.add(byArray4);
            }
        }
        return new Pair<String, List<Object>>(stringBuffer.toString(), arrayList);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[37];
                var3_1 = 0;
                var2_2 = "\u00c82\u00ad}\u00be\u00f9\u009b\u0003\u00e8\u00b2\u00b2\u008a\u0007$x\u0003\u00c9\u0093\u00cb-\u0096\u0005vus\u00b6~$\u00ec0\u0090\u001d\u0099\u00ca/%Z\u00e6\u00fa:\u0085\u00b2Y\t\u0088\u00f5\u00fe\u00c1\u000e\u009f\u001e\u00c1\u00f7\u000eH\u00a1,\u0011S\u0096\n\u00b3\u009f\u0017\u00d8\u0012\u00cc\u0085\fi\u00da%\u00c5\u00a0\u009f[\u00ed.\u008fjiE\u00d6\u00f9\u0003n\u00d86*'\r\u00ef\u00f2yJ\\X\u00c2T\u00ed\u00e5\u008aSTg']\u009eQ\u00e1\nb\u0010\u0085\u0005N\u001bW\u00ea\u00be\u00c4WD^\u000e\u0090\u0081$@7a*\u00bd\u00f6\u00fb\u00d1\u0010\u00c0\u0084)0\u009baf\u00ebr\u009ewT\u008c\u00da\u0089\b\u0091'\u0094x\u0087ms`\u00d1\u00b6\u00df\u0006\u00e5\u0017\u00f0\u00c0\u00a9\u001b[[\u00f0\u001a\u00cbE0y\u0089\u0086A\u00d7jmO\u0080\u00eb\u00b3\u00fb\u00be9f\u0086wL\u00bb\u00cf\u00a5j\"J3g\u00d2\u00d7Q\u00acf\u00a9W\u00e7E!\u00bcj\u00a3\u00cd\u00af>$\u0081X\u0018j\u0015L.\u00a2\u0080`\b\u00df|#%\u00bc\u009di\u00devO\u008d\u0098J\u0018\u0092\u00e5\u008b\u00a4\u00ef\u0010\u0084A\u00d3\u0083\u00c5\u00fbE\u00d3\u00f2\u001d\u0002(\u00905\u00e2\u00f9\u00b4\u00e6I\u000b\u00d7H\u00cf;Ae\u0006&t\u0084\\O\u00de\u00b9\tP\u00f2\u00c4\u00c5\u0000D\u008f\u00c0\u00bb\u00ca\u0095\u00042[\u008f\u00bc.\u0093&\u00d4S\u00ba\u0014Js\u001cuY\u00d5\u00ba\u00d8\u00d4\u00d6$rX\u00ca\u0010\u000f\u00d6{\u0085\u0087o&\u00e7\u0015\u00e9x\u0081\u00d7()\u00be\u00ea\u0003=t~#\u009b\u00a7\u00c7\u00cf\u00f3\u00af\u0005\u00e9\u00dc\u0082\u00dc\u00ed\u00c6\u00ee\u00e1\u00f1[\u00e6\u00d7o\u00c4\u00bcS\u00a0\u00b1\u00b9\u00e3j\u0082\u00fea\u0007tS\u00bbG\u00c4\u00d6,\u00e1\u008ej\u00aaQ)\u0095g\u0003\n\u00be\u00bf\u00f3\u00d9\u00a5\u009eK\u00c9\u00ed@\u00feJf\u00cf\u0013\u0001O\u00e26\u00e8\u00a6|\n\u00eej\u00ab;\u00e0\u00b0\u007f:\u009f\u00de\u00fa<\u0010A\\\u00ff\u0007\u008f\u00d2\u00a7\u00b8]\u00f4|#\u00e17Q\u00ca\u009d\u0089\u00c0\u0086!g\u001b\b\u00fcHN\u0086`\u00a0\u000bV\u00f6\u00c8\u00f3\u001b\u00dd\u00e5s\u00fa\u00df\u00fe@C].yV\u00b9H*\u0016\u00f4\u00c9\u00cd\u00bd\u00ad\u00c4\u00a4\u00d1\u00cb\u008f\u0016\u00c6-\u00dd\u00a8\u0016\u00a4\u00b8n%\u00ed\u00fa\u00ec\u0096\u009a,\u00e8\u001b\u00947\u000bf\u00bdx1Tf\u00bc\u00bc$\u00fe\u0014}\u00d9:\u00e2\u001cO5\u00aa\u008a\u00e3\u00b9.\u0093h\u00f7\u0000\u00a4\u00f0\u0099\u0084\n3\u00d2\u00d2aQzQSV\u00d5\u00146NS\u00101\u0010\u0082`1\u008b{\n\u00a5X\u00ed\u00e2\u00b6\u00ac\u008f\u0006D\u000e\u008a9\u0098\u000b\u00c9\u00e3,\u00ed?o?w9\u00ec\u000e\u00a0\u00b3\u00854\u0002=\u00e9\u0010\u00ecf&\u007f\u0091e\u00f0\u001d\u00c4\u0010f^\u00b6\u0011\u00a1\u00f0\u00e2\u0094\u008dQc\u008f\u00f4\u00d5 \u00a4($\u00d5\u000b\rP\u0018&\u00b9!\u00e7i-\u0014[\u00ef0i=7\u00ccs@5\u00008\u0004 \u00d5W\u008d\u0017\u0002<>\u0010FV\u00d9\u0080A\u0094\u00ba\u0013\u0085_\u00e4^\u00e3\u00f5\u00dd\u00c4\u008c\u0006v\u00e0n\u00db\u00ff\u0099L\u00d0\u00ec\u001dz\u00f7\u00e0\u00a4 +\u00d6\u00ca,\u0002\u00d1\u008e7\u008b\u0016|\u0012\b\u0007\u00949\u00c9/\u00a7\u00e1\u00cbg}(\u00bc\r\u0012\u00ac\u0018e\u000b<\u001a3xmY\u00d67\u00a6U\u00c5NW\u0005^\u009b\u00c0%T\u0098\u0011\u00c1\u008d\u00e4\u00e0\u00e9\u0084\u00e4\"\u0019\u0095;l\u00c7\u00ab^\u00e9\u00de_X&\u00b4~s\u001fp4B\u00a4\u00ff\u0097\u0091\u00ca\u00a9\u00fc\u00be\u00ea!\u0085\u00a1f\u00ca\u00a8S\u0091*\u0012\u00e1\u001bM\u0010\u00f8[\u001b8\u000e-\u007f\u00a8\u00b3\u009e\u00a0\u00ea9-\u00f6\u0099e\u00a4\u00be6\u00c8>\u00ad\u00fc\u00be\u00c9\u00ac%\u00e9\u001be\u00d5_\u008e\u00d7J(\u00e6\u00d1\u008dZ`^\u00dbr\u0015\u00e9)\u00da\u0080+DH0\u00a3\u001f\u0094\u00e9\u0016}\u00e3\u0019\u001c\u0006\u00f5\u0010\u007f\u00beTQ\u0011z\u00beg\u0014\u008b\u00a6\u00e4\r\u00c7\u00aeG\u0013\u00f7\u008cg\u00f6d\u00b1\u00d5\u00e5\u00b0Ln\u001a\u0015\u008f\u00f6d\u0007\u00d7\u00efE;\u00b7\u0089oVe\u00a5\u00f5g\u00b6\u0001\u00f3\u0012\u0089\u0005W\u0015\u007f{\u00b4)\u00b2\u0000\u00c3\u00d9#4\u00db@d\u00e6\u0015\u00bb*\u0018\u001c\u00d0\u0089\u00f7V\u00cc=q\u00c4\u00fc\u00cb\u0090\u00ea\u000552\u008d\u00f3\u00b2T\u0087qb\u00ce$\r\u00c9-\u00ed%\t\u009f*\u00a5>\u00a8\u00bb\u00aa)\u00e6EGw0\u00a1\u00ab\u00a0\u000b2Q\u0085u\fw\u008e1\u00e0\u000b`\u00b9\u00b5\u00b1i\u00ce\u0000\u001b\u00df\u00d7\u009b\u009b\u00ad\u0012\u009e2b\u00dd\u00e8n\u00a0\u00d5\u0004H\u00a3\u00bdy\u00ac\u00a4\u00fc\u0088\u00e3\u00ae,\u007f>M\u009a@\u0092\u00b1\u00c1\u0084\u0084\u00c5\u00eagk\u00d8\u00e1\u0098\u00f1\u00ac\u0084p@\u0010\u00dfN\u00d9~8\u00a1?\u00afB\u000b\u0094\u0016\u0018\u0002Sy\u00b4\u0000\u0092\u0095\u00e66`\u0094\u00b8\u00a9\u001cc\u00f8pc\u00b14\u0080u$\u0092\u001f\u0080L\u00c4\u00d8\u00f8\u00ca\n\u008e\u00f8\u00bf\u00b8|\u00f0*n\u0011\u00e0\u009a\u00b6J6CB(i\u00b3MS\u00df\u00ba:\u00eb\u00fc\u00fb\u0004/\u001c\u00cd2\u00fd>\u001b\u0012\u00deZ\u00cb\u00b9Z\u0083FkC\u0004t\u00fc1\u00cf\u008cB3\u0015\u008fcH\u00ff\u00bbC\"\u0012\u009btG\u0002k\u008d\u00d2\u000b\u00bf\u00b1\u00e9\u00e1q\u001e\u0099\u00c0] 0\u00a1S\u0099x\u00a6\u00d6\u008f\u00d2o^\u00ca\u009e\n\u00e4\u00bc/I\u009b\u00be\u00f2\u0083O:\u0093\u00df\u00cb\u00c3\u00ce\u00ab\u0097En\u00f0\u00fd\u0094\u00e94\u00ca#\u00c3\u0082\u00a5\u00deQ\u00c6\u00db4'B\u00b6\u00bf\u00c5\u00b8\u008b\u00a8\u00c9?\u0091\u0015\u0095n\u0018\u00c5\u0090\u00eegMypt\u001d8\u00e0+\u00aa\u008d\u0007\u0015M'\u00a4\u00bed\u00da\u0016\u0017\u001e\u00f6V\u0007\u0091\u00f9\u00847\u00b1WBc\u00f1/\u00a5U\u00ee\u0002\u00c8\u00d6\u00ee\u000e\u00d0";
                var4_3 = "\u00c82\u00ad}\u00be\u00f9\u009b\u0003\u00e8\u00b2\u00b2\u008a\u0007$x\u0003\u00c9\u0093\u00cb-\u0096\u0005vus\u00b6~$\u00ec0\u0090\u001d\u0099\u00ca/%Z\u00e6\u00fa:\u0085\u00b2Y\t\u0088\u00f5\u00fe\u00c1\u000e\u009f\u001e\u00c1\u00f7\u000eH\u00a1,\u0011S\u0096\n\u00b3\u009f\u0017\u00d8\u0012\u00cc\u0085\fi\u00da%\u00c5\u00a0\u009f[\u00ed.\u008fjiE\u00d6\u00f9\u0003n\u00d86*'\r\u00ef\u00f2yJ\\X\u00c2T\u00ed\u00e5\u008aSTg']\u009eQ\u00e1\nb\u0010\u0085\u0005N\u001bW\u00ea\u00be\u00c4WD^\u000e\u0090\u0081$@7a*\u00bd\u00f6\u00fb\u00d1\u0010\u00c0\u0084)0\u009baf\u00ebr\u009ewT\u008c\u00da\u0089\b\u0091'\u0094x\u0087ms`\u00d1\u00b6\u00df\u0006\u00e5\u0017\u00f0\u00c0\u00a9\u001b[[\u00f0\u001a\u00cbE0y\u0089\u0086A\u00d7jmO\u0080\u00eb\u00b3\u00fb\u00be9f\u0086wL\u00bb\u00cf\u00a5j\"J3g\u00d2\u00d7Q\u00acf\u00a9W\u00e7E!\u00bcj\u00a3\u00cd\u00af>$\u0081X\u0018j\u0015L.\u00a2\u0080`\b\u00df|#%\u00bc\u009di\u00devO\u008d\u0098J\u0018\u0092\u00e5\u008b\u00a4\u00ef\u0010\u0084A\u00d3\u0083\u00c5\u00fbE\u00d3\u00f2\u001d\u0002(\u00905\u00e2\u00f9\u00b4\u00e6I\u000b\u00d7H\u00cf;Ae\u0006&t\u0084\\O\u00de\u00b9\tP\u00f2\u00c4\u00c5\u0000D\u008f\u00c0\u00bb\u00ca\u0095\u00042[\u008f\u00bc.\u0093&\u00d4S\u00ba\u0014Js\u001cuY\u00d5\u00ba\u00d8\u00d4\u00d6$rX\u00ca\u0010\u000f\u00d6{\u0085\u0087o&\u00e7\u0015\u00e9x\u0081\u00d7()\u00be\u00ea\u0003=t~#\u009b\u00a7\u00c7\u00cf\u00f3\u00af\u0005\u00e9\u00dc\u0082\u00dc\u00ed\u00c6\u00ee\u00e1\u00f1[\u00e6\u00d7o\u00c4\u00bcS\u00a0\u00b1\u00b9\u00e3j\u0082\u00fea\u0007tS\u00bbG\u00c4\u00d6,\u00e1\u008ej\u00aaQ)\u0095g\u0003\n\u00be\u00bf\u00f3\u00d9\u00a5\u009eK\u00c9\u00ed@\u00feJf\u00cf\u0013\u0001O\u00e26\u00e8\u00a6|\n\u00eej\u00ab;\u00e0\u00b0\u007f:\u009f\u00de\u00fa<\u0010A\\\u00ff\u0007\u008f\u00d2\u00a7\u00b8]\u00f4|#\u00e17Q\u00ca\u009d\u0089\u00c0\u0086!g\u001b\b\u00fcHN\u0086`\u00a0\u000bV\u00f6\u00c8\u00f3\u001b\u00dd\u00e5s\u00fa\u00df\u00fe@C].yV\u00b9H*\u0016\u00f4\u00c9\u00cd\u00bd\u00ad\u00c4\u00a4\u00d1\u00cb\u008f\u0016\u00c6-\u00dd\u00a8\u0016\u00a4\u00b8n%\u00ed\u00fa\u00ec\u0096\u009a,\u00e8\u001b\u00947\u000bf\u00bdx1Tf\u00bc\u00bc$\u00fe\u0014}\u00d9:\u00e2\u001cO5\u00aa\u008a\u00e3\u00b9.\u0093h\u00f7\u0000\u00a4\u00f0\u0099\u0084\n3\u00d2\u00d2aQzQSV\u00d5\u00146NS\u00101\u0010\u0082`1\u008b{\n\u00a5X\u00ed\u00e2\u00b6\u00ac\u008f\u0006D\u000e\u008a9\u0098\u000b\u00c9\u00e3,\u00ed?o?w9\u00ec\u000e\u00a0\u00b3\u00854\u0002=\u00e9\u0010\u00ecf&\u007f\u0091e\u00f0\u001d\u00c4\u0010f^\u00b6\u0011\u00a1\u00f0\u00e2\u0094\u008dQc\u008f\u00f4\u00d5 \u00a4($\u00d5\u000b\rP\u0018&\u00b9!\u00e7i-\u0014[\u00ef0i=7\u00ccs@5\u00008\u0004 \u00d5W\u008d\u0017\u0002<>\u0010FV\u00d9\u0080A\u0094\u00ba\u0013\u0085_\u00e4^\u00e3\u00f5\u00dd\u00c4\u008c\u0006v\u00e0n\u00db\u00ff\u0099L\u00d0\u00ec\u001dz\u00f7\u00e0\u00a4 +\u00d6\u00ca,\u0002\u00d1\u008e7\u008b\u0016|\u0012\b\u0007\u00949\u00c9/\u00a7\u00e1\u00cbg}(\u00bc\r\u0012\u00ac\u0018e\u000b<\u001a3xmY\u00d67\u00a6U\u00c5NW\u0005^\u009b\u00c0%T\u0098\u0011\u00c1\u008d\u00e4\u00e0\u00e9\u0084\u00e4\"\u0019\u0095;l\u00c7\u00ab^\u00e9\u00de_X&\u00b4~s\u001fp4B\u00a4\u00ff\u0097\u0091\u00ca\u00a9\u00fc\u00be\u00ea!\u0085\u00a1f\u00ca\u00a8S\u0091*\u0012\u00e1\u001bM\u0010\u00f8[\u001b8\u000e-\u007f\u00a8\u00b3\u009e\u00a0\u00ea9-\u00f6\u0099e\u00a4\u00be6\u00c8>\u00ad\u00fc\u00be\u00c9\u00ac%\u00e9\u001be\u00d5_\u008e\u00d7J(\u00e6\u00d1\u008dZ`^\u00dbr\u0015\u00e9)\u00da\u0080+DH0\u00a3\u001f\u0094\u00e9\u0016}\u00e3\u0019\u001c\u0006\u00f5\u0010\u007f\u00beTQ\u0011z\u00beg\u0014\u008b\u00a6\u00e4\r\u00c7\u00aeG\u0013\u00f7\u008cg\u00f6d\u00b1\u00d5\u00e5\u00b0Ln\u001a\u0015\u008f\u00f6d\u0007\u00d7\u00efE;\u00b7\u0089oVe\u00a5\u00f5g\u00b6\u0001\u00f3\u0012\u0089\u0005W\u0015\u007f{\u00b4)\u00b2\u0000\u00c3\u00d9#4\u00db@d\u00e6\u0015\u00bb*\u0018\u001c\u00d0\u0089\u00f7V\u00cc=q\u00c4\u00fc\u00cb\u0090\u00ea\u000552\u008d\u00f3\u00b2T\u0087qb\u00ce$\r\u00c9-\u00ed%\t\u009f*\u00a5>\u00a8\u00bb\u00aa)\u00e6EGw0\u00a1\u00ab\u00a0\u000b2Q\u0085u\fw\u008e1\u00e0\u000b`\u00b9\u00b5\u00b1i\u00ce\u0000\u001b\u00df\u00d7\u009b\u009b\u00ad\u0012\u009e2b\u00dd\u00e8n\u00a0\u00d5\u0004H\u00a3\u00bdy\u00ac\u00a4\u00fc\u0088\u00e3\u00ae,\u007f>M\u009a@\u0092\u00b1\u00c1\u0084\u0084\u00c5\u00eagk\u00d8\u00e1\u0098\u00f1\u00ac\u0084p@\u0010\u00dfN\u00d9~8\u00a1?\u00afB\u000b\u0094\u0016\u0018\u0002Sy\u00b4\u0000\u0092\u0095\u00e66`\u0094\u00b8\u00a9\u001cc\u00f8pc\u00b14\u0080u$\u0092\u001f\u0080L\u00c4\u00d8\u00f8\u00ca\n\u008e\u00f8\u00bf\u00b8|\u00f0*n\u0011\u00e0\u009a\u00b6J6CB(i\u00b3MS\u00df\u00ba:\u00eb\u00fc\u00fb\u0004/\u001c\u00cd2\u00fd>\u001b\u0012\u00deZ\u00cb\u00b9Z\u0083FkC\u0004t\u00fc1\u00cf\u008cB3\u0015\u008fcH\u00ff\u00bbC\"\u0012\u009btG\u0002k\u008d\u00d2\u000b\u00bf\u00b1\u00e9\u00e1q\u001e\u0099\u00c0] 0\u00a1S\u0099x\u00a6\u00d6\u008f\u00d2o^\u00ca\u009e\n\u00e4\u00bc/I\u009b\u00be\u00f2\u0083O:\u0093\u00df\u00cb\u00c3\u00ce\u00ab\u0097En\u00f0\u00fd\u0094\u00e94\u00ca#\u00c3\u0082\u00a5\u00deQ\u00c6\u00db4'B\u00b6\u00bf\u00c5\u00b8\u008b\u00a8\u00c9?\u0091\u0015\u0095n\u0018\u00c5\u0090\u00eegMypt\u001d8\u00e0+\u00aa\u008d\u0007\u0015M'\u00a4\u00bed\u00da\u0016\u0017\u001e\u00f6V\u0007\u0091\u00f9\u00847\u00b1WBc\u00f1/\u00a5U\u00ee\u0002\u00c8\u00d6\u00ee\u000e\u00d0".length();
                var1_4 = 15;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0096w\u009e\u00e1\u00bc\u00c6\u0011\u00e9\u0082\u00837e!\u0012\u00c7{\u007f\r\u00bf\u00b9\u00a4\u0097\u00b2T\u00ca\u009f;p\u00aa\u00b1\u00ef\u00d3-dr\u00c0l\u00af\u008e\u009b\u00e9\u00e8R)P\u00b0\u00d3Mr7J\u00c1\u001ck\u00b4\u0090%\u00cc\u00da\u000e\u00da\u0095J\u00f83\u0087\u00df\u00c8L\u00ca\u00c7idu\u00bc$\u00c1\"\u00cf\u00e1c\u00da\u00b1\u00d5\u00d3\u00a7\u008b\u0018-\u00c7\u00f7\u000f\u00ed\u00ae\u008ejig\u0085\u001e\u0017\u000fH\u00e9\u009ak&\u00fdQfq\u00df\u0098\u00b8?\u00a3\u0017xMx#\u00f2\u009f\u000f\u000b";
                    var4_3 = "\u0096w\u009e\u00e1\u00bc\u00c6\u0011\u00e9\u0082\u00837e!\u0012\u00c7{\u007f\r\u00bf\u00b9\u00a4\u0097\u00b2T\u00ca\u009f;p\u00aa\u00b1\u00ef\u00d3-dr\u00c0l\u00af\u008e\u009b\u00e9\u00e8R)P\u00b0\u00d3Mr7J\u00c1\u001ck\u00b4\u0090%\u00cc\u00da\u000e\u00da\u0095J\u00f83\u0087\u00df\u00c8L\u00ca\u00c7idu\u00bc$\u00c1\"\u00cf\u00e1c\u00da\u00b1\u00d5\u00d3\u00a7\u008b\u0018-\u00c7\u00f7\u000f\u00ed\u00ae\u008ejig\u0085\u001e\u0017\u000fH\u00e9\u009ak&\u00fdQfq\u00df\u0098\u00b8?\u00a3\u0017xMx#\u00f2\u009f\u000f\u000b".length();
                    var1_4 = 42;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 87;
                            break;
                        }
                        case 1: {
                            v13 = 14;
                            break;
                        }
                        case 2: {
                            v13 = 21;
                            break;
                        }
                        case 3: {
                            v13 = 53;
                            break;
                        }
                        case 4: {
                            v13 = 94;
                            break;
                        }
                        case 5: {
                            v13 = 49;
                            break;
                        }
                        default: {
                            v13 = 56;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CertStoreCRLOps.c = var5;
        CertStoreCRLOps.d = new String[37];
        CertStoreCRLOps.a = LoggerFactory.getLogger(CertStoreCRLOps.class);
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0x7E8) & 0xFFFF;
        if (d[n4] == null) {
            int n5;
            int n6;
            char[] cArray = c[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 212;
                    break;
                }
                case 1: {
                    n6 = 103;
                    break;
                }
                case 2: {
                    n6 = 254;
                    break;
                }
                case 3: {
                    n6 = 50;
                    break;
                }
                case 4: {
                    n6 = 250;
                    break;
                }
                case 5: {
                    n6 = 170;
                    break;
                }
                case 6: {
                    n6 = 240;
                    break;
                }
                case 7: {
                    n6 = 130;
                    break;
                }
                case 8: {
                    n6 = 65;
                    break;
                }
                case 9: {
                    n6 = 156;
                    break;
                }
                case 10: {
                    n6 = 73;
                    break;
                }
                case 11: {
                    n6 = 207;
                    break;
                }
                case 12: {
                    n6 = 236;
                    break;
                }
                case 13: {
                    n6 = 66;
                    break;
                }
                case 14: {
                    n6 = 120;
                    break;
                }
                case 15: {
                    n6 = 204;
                    break;
                }
                case 16: {
                    n6 = 150;
                    break;
                }
                case 17: {
                    n6 = 63;
                    break;
                }
                case 18: {
                    n6 = 27;
                    break;
                }
                case 19: {
                    n6 = 90;
                    break;
                }
                case 20: {
                    n6 = 128;
                    break;
                }
                case 21: {
                    n6 = 151;
                    break;
                }
                case 22: {
                    n6 = 31;
                    break;
                }
                case 23: {
                    n6 = 206;
                    break;
                }
                case 24: {
                    n6 = 55;
                    break;
                }
                case 25: {
                    n6 = 179;
                    break;
                }
                case 26: {
                    n6 = 231;
                    break;
                }
                case 27: {
                    n6 = 245;
                    break;
                }
                case 28: {
                    n6 = 169;
                    break;
                }
                case 29: {
                    n6 = 235;
                    break;
                }
                case 30: {
                    n6 = 161;
                    break;
                }
                case 31: {
                    n6 = 96;
                    break;
                }
                case 32: {
                    n6 = 173;
                    break;
                }
                case 33: {
                    n6 = 108;
                    break;
                }
                case 34: {
                    n6 = 136;
                    break;
                }
                case 35: {
                    n6 = 126;
                    break;
                }
                case 36: {
                    n6 = 2;
                    break;
                }
                case 37: {
                    n6 = 113;
                    break;
                }
                case 38: {
                    n6 = 192;
                    break;
                }
                case 39: {
                    n6 = 230;
                    break;
                }
                case 40: {
                    n6 = 46;
                    break;
                }
                case 41: {
                    n6 = 243;
                    break;
                }
                case 42: {
                    n6 = 64;
                    break;
                }
                case 43: {
                    n6 = 85;
                    break;
                }
                case 44: {
                    n6 = 188;
                    break;
                }
                case 45: {
                    n6 = 54;
                    break;
                }
                case 46: {
                    n6 = 183;
                    break;
                }
                case 47: {
                    n6 = 110;
                    break;
                }
                case 48: {
                    n6 = 12;
                    break;
                }
                case 49: {
                    n6 = 6;
                    break;
                }
                case 50: {
                    n6 = 127;
                    break;
                }
                case 51: {
                    n6 = 17;
                    break;
                }
                case 52: {
                    n6 = 255;
                    break;
                }
                case 53: {
                    n6 = 14;
                    break;
                }
                case 54: {
                    n6 = 175;
                    break;
                }
                case 55: {
                    n6 = 18;
                    break;
                }
                case 56: {
                    n6 = 125;
                    break;
                }
                case 57: {
                    n6 = 23;
                    break;
                }
                case 58: {
                    n6 = 105;
                    break;
                }
                case 59: {
                    n6 = 44;
                    break;
                }
                case 60: {
                    n6 = 8;
                    break;
                }
                case 61: {
                    n6 = 198;
                    break;
                }
                case 62: {
                    n6 = 189;
                    break;
                }
                case 63: {
                    n6 = 72;
                    break;
                }
                case 64: {
                    n6 = 36;
                    break;
                }
                case 65: {
                    n6 = 216;
                    break;
                }
                case 66: {
                    n6 = 81;
                    break;
                }
                case 67: {
                    n6 = 11;
                    break;
                }
                case 68: {
                    n6 = 201;
                    break;
                }
                case 69: {
                    n6 = 10;
                    break;
                }
                case 70: {
                    n6 = 30;
                    break;
                }
                case 71: {
                    n6 = 214;
                    break;
                }
                case 72: {
                    n6 = 35;
                    break;
                }
                case 73: {
                    n6 = 199;
                    break;
                }
                case 74: {
                    n6 = 134;
                    break;
                }
                case 75: {
                    n6 = 51;
                    break;
                }
                case 76: {
                    n6 = 228;
                    break;
                }
                case 77: {
                    n6 = 145;
                    break;
                }
                case 78: {
                    n6 = 200;
                    break;
                }
                case 79: {
                    n6 = 181;
                    break;
                }
                case 80: {
                    n6 = 1;
                    break;
                }
                case 81: {
                    n6 = 84;
                    break;
                }
                case 82: {
                    n6 = 88;
                    break;
                }
                case 83: {
                    n6 = 217;
                    break;
                }
                case 84: {
                    n6 = 61;
                    break;
                }
                case 85: {
                    n6 = 29;
                    break;
                }
                case 86: {
                    n6 = 82;
                    break;
                }
                case 87: {
                    n6 = 141;
                    break;
                }
                case 88: {
                    n6 = 53;
                    break;
                }
                case 89: {
                    n6 = 248;
                    break;
                }
                case 90: {
                    n6 = 237;
                    break;
                }
                case 91: {
                    n6 = 129;
                    break;
                }
                case 92: {
                    n6 = 147;
                    break;
                }
                case 93: {
                    n6 = 58;
                    break;
                }
                case 94: {
                    n6 = 25;
                    break;
                }
                case 95: {
                    n6 = 131;
                    break;
                }
                case 96: {
                    n6 = 135;
                    break;
                }
                case 97: {
                    n6 = 148;
                    break;
                }
                case 98: {
                    n6 = 37;
                    break;
                }
                case 99: {
                    n6 = 122;
                    break;
                }
                case 100: {
                    n6 = 15;
                    break;
                }
                case 101: {
                    n6 = 139;
                    break;
                }
                case 102: {
                    n6 = 74;
                    break;
                }
                case 103: {
                    n6 = 227;
                    break;
                }
                case 104: {
                    n6 = 70;
                    break;
                }
                case 105: {
                    n6 = 104;
                    break;
                }
                case 106: {
                    n6 = 137;
                    break;
                }
                case 107: {
                    n6 = 33;
                    break;
                }
                case 108: {
                    n6 = 191;
                    break;
                }
                case 109: {
                    n6 = 233;
                    break;
                }
                case 110: {
                    n6 = 220;
                    break;
                }
                case 111: {
                    n6 = 174;
                    break;
                }
                case 112: {
                    n6 = 163;
                    break;
                }
                case 113: {
                    n6 = 209;
                    break;
                }
                case 114: {
                    n6 = 208;
                    break;
                }
                case 115: {
                    n6 = 13;
                    break;
                }
                case 116: {
                    n6 = 42;
                    break;
                }
                case 117: {
                    n6 = 239;
                    break;
                }
                case 118: {
                    n6 = 71;
                    break;
                }
                case 119: {
                    n6 = 112;
                    break;
                }
                case 120: {
                    n6 = 246;
                    break;
                }
                case 121: {
                    n6 = 253;
                    break;
                }
                case 122: {
                    n6 = 241;
                    break;
                }
                case 123: {
                    n6 = 9;
                    break;
                }
                case 124: {
                    n6 = 197;
                    break;
                }
                case 125: {
                    n6 = 57;
                    break;
                }
                case 126: {
                    n6 = 92;
                    break;
                }
                case 127: {
                    n6 = 184;
                    break;
                }
                case 128: {
                    n6 = 49;
                    break;
                }
                case 129: {
                    n6 = 146;
                    break;
                }
                case 130: {
                    n6 = 249;
                    break;
                }
                case 131: {
                    n6 = 138;
                    break;
                }
                case 132: {
                    n6 = 87;
                    break;
                }
                case 133: {
                    n6 = 155;
                    break;
                }
                case 134: {
                    n6 = 196;
                    break;
                }
                case 135: {
                    n6 = 154;
                    break;
                }
                case 136: {
                    n6 = 26;
                    break;
                }
                case 137: {
                    n6 = 185;
                    break;
                }
                case 138: {
                    n6 = 67;
                    break;
                }
                case 139: {
                    n6 = 59;
                    break;
                }
                case 140: {
                    n6 = 98;
                    break;
                }
                case 141: {
                    n6 = 24;
                    break;
                }
                case 142: {
                    n6 = 79;
                    break;
                }
                case 143: {
                    n6 = 4;
                    break;
                }
                case 144: {
                    n6 = 210;
                    break;
                }
                case 145: {
                    n6 = 116;
                    break;
                }
                case 146: {
                    n6 = 83;
                    break;
                }
                case 147: {
                    n6 = 0;
                    break;
                }
                case 148: {
                    n6 = 118;
                    break;
                }
                case 149: {
                    n6 = 149;
                    break;
                }
                case 150: {
                    n6 = 102;
                    break;
                }
                case 151: {
                    n6 = 89;
                    break;
                }
                case 152: {
                    n6 = 152;
                    break;
                }
                case 153: {
                    n6 = 221;
                    break;
                }
                case 154: {
                    n6 = 47;
                    break;
                }
                case 155: {
                    n6 = 133;
                    break;
                }
                case 156: {
                    n6 = 211;
                    break;
                }
                case 157: {
                    n6 = 123;
                    break;
                }
                case 158: {
                    n6 = 20;
                    break;
                }
                case 159: {
                    n6 = 205;
                    break;
                }
                case 160: {
                    n6 = 91;
                    break;
                }
                case 161: {
                    n6 = 106;
                    break;
                }
                case 162: {
                    n6 = 153;
                    break;
                }
                case 163: {
                    n6 = 158;
                    break;
                }
                case 164: {
                    n6 = 225;
                    break;
                }
                case 165: {
                    n6 = 121;
                    break;
                }
                case 166: {
                    n6 = 56;
                    break;
                }
                case 167: {
                    n6 = 19;
                    break;
                }
                case 168: {
                    n6 = 238;
                    break;
                }
                case 169: {
                    n6 = 60;
                    break;
                }
                case 170: {
                    n6 = 177;
                    break;
                }
                case 171: {
                    n6 = 119;
                    break;
                }
                case 172: {
                    n6 = 215;
                    break;
                }
                case 173: {
                    n6 = 28;
                    break;
                }
                case 174: {
                    n6 = 213;
                    break;
                }
                case 175: {
                    n6 = 140;
                    break;
                }
                case 176: {
                    n6 = 34;
                    break;
                }
                case 177: {
                    n6 = 247;
                    break;
                }
                case 178: {
                    n6 = 222;
                    break;
                }
                case 179: {
                    n6 = 100;
                    break;
                }
                case 180: {
                    n6 = 80;
                    break;
                }
                case 181: {
                    n6 = 176;
                    break;
                }
                case 182: {
                    n6 = 107;
                    break;
                }
                case 183: {
                    n6 = 160;
                    break;
                }
                case 184: {
                    n6 = 38;
                    break;
                }
                case 185: {
                    n6 = 178;
                    break;
                }
                case 186: {
                    n6 = 193;
                    break;
                }
                case 187: {
                    n6 = 45;
                    break;
                }
                case 188: {
                    n6 = 195;
                    break;
                }
                case 189: {
                    n6 = 142;
                    break;
                }
                case 190: {
                    n6 = 69;
                    break;
                }
                case 191: {
                    n6 = 229;
                    break;
                }
                case 192: {
                    n6 = 40;
                    break;
                }
                case 193: {
                    n6 = 115;
                    break;
                }
                case 194: {
                    n6 = 242;
                    break;
                }
                case 195: {
                    n6 = 124;
                    break;
                }
                case 196: {
                    n6 = 132;
                    break;
                }
                case 197: {
                    n6 = 180;
                    break;
                }
                case 198: {
                    n6 = 77;
                    break;
                }
                case 199: {
                    n6 = 3;
                    break;
                }
                case 200: {
                    n6 = 224;
                    break;
                }
                case 201: {
                    n6 = 202;
                    break;
                }
                case 202: {
                    n6 = 114;
                    break;
                }
                case 203: {
                    n6 = 109;
                    break;
                }
                case 204: {
                    n6 = 143;
                    break;
                }
                case 205: {
                    n6 = 162;
                    break;
                }
                case 206: {
                    n6 = 232;
                    break;
                }
                case 207: {
                    n6 = 78;
                    break;
                }
                case 208: {
                    n6 = 22;
                    break;
                }
                case 209: {
                    n6 = 157;
                    break;
                }
                case 210: {
                    n6 = 186;
                    break;
                }
                case 211: {
                    n6 = 219;
                    break;
                }
                case 212: {
                    n6 = 76;
                    break;
                }
                case 213: {
                    n6 = 187;
                    break;
                }
                case 214: {
                    n6 = 5;
                    break;
                }
                case 215: {
                    n6 = 94;
                    break;
                }
                case 216: {
                    n6 = 41;
                    break;
                }
                case 217: {
                    n6 = 144;
                    break;
                }
                case 218: {
                    n6 = 101;
                    break;
                }
                case 219: {
                    n6 = 226;
                    break;
                }
                case 220: {
                    n6 = 43;
                    break;
                }
                case 221: {
                    n6 = 21;
                    break;
                }
                case 222: {
                    n6 = 97;
                    break;
                }
                case 223: {
                    n6 = 111;
                    break;
                }
                case 224: {
                    n6 = 39;
                    break;
                }
                case 225: {
                    n6 = 234;
                    break;
                }
                case 226: {
                    n6 = 52;
                    break;
                }
                case 227: {
                    n6 = 171;
                    break;
                }
                case 228: {
                    n6 = 251;
                    break;
                }
                case 229: {
                    n6 = 7;
                    break;
                }
                case 230: {
                    n6 = 203;
                    break;
                }
                case 231: {
                    n6 = 48;
                    break;
                }
                case 232: {
                    n6 = 223;
                    break;
                }
                case 233: {
                    n6 = 252;
                    break;
                }
                case 234: {
                    n6 = 218;
                    break;
                }
                case 235: {
                    n6 = 95;
                    break;
                }
                case 236: {
                    n6 = 194;
                    break;
                }
                case 237: {
                    n6 = 164;
                    break;
                }
                case 238: {
                    n6 = 159;
                    break;
                }
                case 239: {
                    n6 = 86;
                    break;
                }
                case 240: {
                    n6 = 32;
                    break;
                }
                case 241: {
                    n6 = 244;
                    break;
                }
                case 242: {
                    n6 = 117;
                    break;
                }
                case 243: {
                    n6 = 75;
                    break;
                }
                case 244: {
                    n6 = 165;
                    break;
                }
                case 245: {
                    n6 = 182;
                    break;
                }
                case 246: {
                    n6 = 62;
                    break;
                }
                case 247: {
                    n6 = 172;
                    break;
                }
                case 248: {
                    n6 = 168;
                    break;
                }
                case 249: {
                    n6 = 93;
                    break;
                }
                case 250: {
                    n6 = 166;
                    break;
                }
                case 251: {
                    n6 = 167;
                    break;
                }
                case 252: {
                    n6 = 99;
                    break;
                }
                case 253: {
                    n6 = 68;
                    break;
                }
                case 254: {
                    n6 = 16;
                    break;
                }
                default: {
                    n6 = 190;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            CertStoreCRLOps.d[n4] = new String(cArray).intern();
        }
        return d[n4];
    }
}

