/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.ItemSource;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.NotFoundException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.DizinYardimci;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoDizin;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.ops.CertStoreRootCertificateOps;

public class CertStoreDirectoryOps {
    private static Logger a;
    private final CertStore b;
    private static final String[] c;
    private static final String[] d;

    public CertStoreDirectoryOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(CertStoreDirectoryOps.a(-19918, -31314));
            throw new ESYARuntimeException(CertStoreDirectoryOps.a(-19916, 2239) + lE.getMessage());
        }
        this.b = aDepo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DepoDizin readDirectory(long aDizinNo) throws CertStoreException {
        DepoDizin depoDizin;
        if (aDizinNo <= 0L) {
            throw new CertStoreException(CertStoreDirectoryOps.a(-19914, 27525));
        }
        try {
            DepoDizin depoDizin2;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoDizin = depoDizin2 = depoVEN.dizinOku(aDizinNo);
        }
        catch (NotFoundException notFoundException) {
            try {
                throw new CertStoreException(aDizinNo + CertStoreDirectoryOps.a(-19906, -27081), notFoundException);
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aDizinNo + CertStoreDirectoryOps.a(-19919, 15801), certStoreException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aDizinNo + CertStoreDirectoryOps.a(-19919, 15801), certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return depoDizin;
            JDBCUtil.commit(this.b.getConn());
            return depoDizin;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aDizinNo + CertStoreDirectoryOps.a(-19909, 31210), certStoreException);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DepoDizin findDirectory(String aDizinAdi) throws CertStoreException {
        DepoDizin depoDizin;
        try {
            DepoDizin depoDizin2;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoDizin = depoDizin2 = depoVEN.dizinBul(aDizinAdi);
        }
        catch (NotFoundException notFoundException) {
            try {
                throw new CertStoreException(aDizinAdi + CertStoreDirectoryOps.a(-19915, 30157) + notFoundException);
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aDizinAdi + CertStoreDirectoryOps.a(-19910, -19074) + certStoreException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aDizinAdi + CertStoreDirectoryOps.a(-19910, -19074), certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return depoDizin;
            JDBCUtil.commit(this.b.getConn());
            return depoDizin;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aDizinAdi + CertStoreDirectoryOps.a(-19920, -10829), certStoreException);
        }
    }

    public void renameDirectory(long aDizinNo, String aYeniAd) throws CertStoreException {
        if (aDizinNo <= 0L) {
            throw new CertStoreException(CertStoreDirectoryOps.a(-19908, -25937));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.dizinAdiDegistir(aDizinNo, aYeniAd);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aDizinNo + CertStoreDirectoryOps.a(-19913, 31191) + aYeniAd + CertStoreDirectoryOps.a(-19912, 14608), certStoreException);
        }
    }

    public void writeDirectory(String aDizinAdi) throws CertStoreException {
        DepoDizin depoDizin = new DepoDizin();
        depoDizin.setDizinAdi(aDizinAdi);
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.dizinYaz(depoDizin);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aDizinAdi + CertStoreDirectoryOps.a(-19905, -26116), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoDizin> listDirectory() throws CertStoreException {
        ArrayList<DepoDizin> arrayList2;
        boolean bl = CertStoreRootCertificateOps.c;
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            ArrayList<DepoDizin> arrayList = new ArrayList<DepoDizin>();
            ItemSource<DepoDizin> itemSource = depoVEN.dizinListele();
            DepoDizin depoDizin = itemSource.nextItem();
            while (depoDizin != null) {
                arrayList.add(depoDizin);
                depoDizin = itemSource.nextItem();
                if (!bl) continue;
            }
            arrayList2 = arrayList;
        }
        catch (Exception exception) {
            try {
                throw new CertStoreException(CertStoreDirectoryOps.a(-19924, -24607), exception);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(CertStoreDirectoryOps.a(-19924, -24607), certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return arrayList2;
            JDBCUtil.commit(this.b.getConn());
            return arrayList2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreDirectoryOps.a(-19917, -12577), certStoreException);
        }
    }

    public void deleteDirectory(long aDizinNo) throws CertStoreException {
        if (aDizinNo == DizinYardimci.getDefaultDizinNo()) {
            throw new CertStoreException(CertStoreDirectoryOps.a(-19907, -13755));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.dizinSil(aDizinNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aDizinNo + CertStoreDirectoryOps.a(-19911, 15949), certStoreException);
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[17];
                var3_1 = 0;
                var2_2 = "w8\u008dK\u00e1\u00c4\u00b2\u001c\u00ab\u00b4\u00df-u\u00b7>O\u0002G\u00ee\u00ab\u0012\u00c0\u00a8!\u00c3\u00f7?\u00b8\u00ec*\u00a1\u00c3`\u001dE\u00b0G>\u00c1c2\u00f81-\u00c8K\u00b9\u008e\u00ee\u001e\u00863\u00d5\u00a0\u00c9^\u00f0n-\u00f2\u0091W\u00b3%\fT\u0084L\u00e3\u00c3\u00be\u00d4\u008c\u0099\u00f5\u00b5;\n\u00c4\u00d1n\u00b55\u00d5\u00d9s\t\u00d8\u0004\u009f\u0014\u001a%K\u0095\u00b5\u0096i=\u009c\u000e\u00bc{'#\u001f+\u00cdxf\u00c1|:\u00c1\u0087HG \b\u0005^\u0006\u00d8\u00d8J\u00fdK\u0015\u00a9\u00d9I\u00d7D-B\f\u00a7\u00af]\u00da\u0011\u00ebn\u0089\u0086\u00f9I\u00f1\u00ef\u0085\u00fc\u00e7\u0013\u00a8\u0000\u008e\u0094I\u00d9\u00dc\u00aa\u0085\u009a\u00a5V\u00f2\u00d9q\u0003\u00ad\u009c\u0019\u0017\u00c5{=\u00a1\u0000w\u00fbz~os\u00ed8?F\u00ff\u00cc\u00b4\u00ad\u009b\u00fanBF\u0086\u00a8\u00da\u0094\u009f\u00e5\u00a2H1d\u00f9\u0084\u0084\u0092\u00c9\u00db\u00e6\u00ad\u00b8=\u00c1\u0099\u00a8\u0006\u00afe\u00f2\u00db8vO)\u00be\u00bb\u00bch_9X\u00f1\bX\u00f8}\rP\u009e\u00a0w\u0018.\u00acw\u00f1\u00ab\u00e5\u000b\u00e4k\\\u00ae\u00dbw\u00d0\u00af4\u00c2qSA\u009dl\u0012?\u00e1\u00eb\u009dS\u009d\u0011I\u00b7\u009f*\u00d7\u009a\u0015\u00e2\u000bs\u00db\u00de7%\u00a51$>B>I\u0090\u00a5F\u00d6SN\u00f2\u0082\u00ab\u00c1k\u00f7x\u00fbIl\u0006\u00b5CJ\u00c4\u00cd~ J\u00ca\u00ee\u001a&\u00d7\u00c5\u00da\u0004[\u00d6\u00e9\u009b%w\u00ef\u00da\u00f0\u0014\u0003\u009f\u00eb=\u001d\u00ad\"q3\u007f(\u00d29\u008d\u00ed\u0018R-\u00e3\u008a\u00c6\u00e1\u0094\u00d3\u00cd\u00dc\u00aa\u0083\u0010\u0089\u009cf\u001f\u0098\u0081\u0088\u00a4\u0089\u00df\u00c4j\u0086\u0082\u00c5U\u00fe\u00b9\u00f0\u000f\u009d\u001d'\u00c7i$\t[\u00ce\u00dapt\u00b4>\u00da%\u001a\u00b7\u0096\u00cf\u00e8ajJ@\u0001\u00efwc\u0085sxZ\u00bc\u009d\u0094\u00d5k\u00cc\u007ff\u00d0\u001b\u0082\u000fq/u\u00f5#,\u0092zO\u00b6R\u0088Ym\u0005\u0003\u00d5b\u00db\u008c\u0089+\u00bd'\u008c%j\"\u009a\u008e\u00fa>qn\u0001w\u0090\u00a2\u00e9\u001b\u0013~\u00bd\u0001\u0007\"\u00ae\u0084\u00a5'\u009d\u0004\u00b2\u00df\u00f0\u00e8\u0006L&\u008bn\u00b1\u00b6*\tyBc\u0018\u00c1\u008d\u00bcL\u00a0#\u00af\u00ea\u00e7\u00cdE|\u0006!\u0083\u00eb\u00c5\u0097\u0081$\u00e3\u00c3:szR\u00c9\u001e\\\u008a\u0098\u00be;\u00fe\u00c3\u00d5\u00ec\u0014\u008e\u0017\r\u00c6~7~O\u00e0S\u00acov\u0087\u00e8\r\u00ae\u00cc\u00d04(\u00a1\u00f3\u00e3\u00b4\u00d5y\u0094\u0086\u00bdj\u0007\u0001\u000f\u007fG\u00fc\u00f0\u00da\u00e7\u00c5\u00ab4!\u00e4\u00bf\boJ\u0018\u00d8\u001d\u00d4\u00b6\u009f\u0090\u00e0=$$x'\u00ac\u0017I\u00c6\u00f67oO\u00c2S\u00e8&\u00ff\u0085\u00ece\u00a4\u0096\f\u00a5\u00e7\u00b9\u00b4\u00d0\u00c1\u0084S\u008f\u00a2\u00c5\u00e7n\u00ff\u00ab\u0006\u0003\u00d2\u009fe\u001a\u0003~A\u0001s0\u00e3\u0094\u008amLT2\u00d4U\u00e6\u0084r\u00e5L\u00ddII\u0093\u00a50";
                var4_3 = "w8\u008dK\u00e1\u00c4\u00b2\u001c\u00ab\u00b4\u00df-u\u00b7>O\u0002G\u00ee\u00ab\u0012\u00c0\u00a8!\u00c3\u00f7?\u00b8\u00ec*\u00a1\u00c3`\u001dE\u00b0G>\u00c1c2\u00f81-\u00c8K\u00b9\u008e\u00ee\u001e\u00863\u00d5\u00a0\u00c9^\u00f0n-\u00f2\u0091W\u00b3%\fT\u0084L\u00e3\u00c3\u00be\u00d4\u008c\u0099\u00f5\u00b5;\n\u00c4\u00d1n\u00b55\u00d5\u00d9s\t\u00d8\u0004\u009f\u0014\u001a%K\u0095\u00b5\u0096i=\u009c\u000e\u00bc{'#\u001f+\u00cdxf\u00c1|:\u00c1\u0087HG \b\u0005^\u0006\u00d8\u00d8J\u00fdK\u0015\u00a9\u00d9I\u00d7D-B\f\u00a7\u00af]\u00da\u0011\u00ebn\u0089\u0086\u00f9I\u00f1\u00ef\u0085\u00fc\u00e7\u0013\u00a8\u0000\u008e\u0094I\u00d9\u00dc\u00aa\u0085\u009a\u00a5V\u00f2\u00d9q\u0003\u00ad\u009c\u0019\u0017\u00c5{=\u00a1\u0000w\u00fbz~os\u00ed8?F\u00ff\u00cc\u00b4\u00ad\u009b\u00fanBF\u0086\u00a8\u00da\u0094\u009f\u00e5\u00a2H1d\u00f9\u0084\u0084\u0092\u00c9\u00db\u00e6\u00ad\u00b8=\u00c1\u0099\u00a8\u0006\u00afe\u00f2\u00db8vO)\u00be\u00bb\u00bch_9X\u00f1\bX\u00f8}\rP\u009e\u00a0w\u0018.\u00acw\u00f1\u00ab\u00e5\u000b\u00e4k\\\u00ae\u00dbw\u00d0\u00af4\u00c2qSA\u009dl\u0012?\u00e1\u00eb\u009dS\u009d\u0011I\u00b7\u009f*\u00d7\u009a\u0015\u00e2\u000bs\u00db\u00de7%\u00a51$>B>I\u0090\u00a5F\u00d6SN\u00f2\u0082\u00ab\u00c1k\u00f7x\u00fbIl\u0006\u00b5CJ\u00c4\u00cd~ J\u00ca\u00ee\u001a&\u00d7\u00c5\u00da\u0004[\u00d6\u00e9\u009b%w\u00ef\u00da\u00f0\u0014\u0003\u009f\u00eb=\u001d\u00ad\"q3\u007f(\u00d29\u008d\u00ed\u0018R-\u00e3\u008a\u00c6\u00e1\u0094\u00d3\u00cd\u00dc\u00aa\u0083\u0010\u0089\u009cf\u001f\u0098\u0081\u0088\u00a4\u0089\u00df\u00c4j\u0086\u0082\u00c5U\u00fe\u00b9\u00f0\u000f\u009d\u001d'\u00c7i$\t[\u00ce\u00dapt\u00b4>\u00da%\u001a\u00b7\u0096\u00cf\u00e8ajJ@\u0001\u00efwc\u0085sxZ\u00bc\u009d\u0094\u00d5k\u00cc\u007ff\u00d0\u001b\u0082\u000fq/u\u00f5#,\u0092zO\u00b6R\u0088Ym\u0005\u0003\u00d5b\u00db\u008c\u0089+\u00bd'\u008c%j\"\u009a\u008e\u00fa>qn\u0001w\u0090\u00a2\u00e9\u001b\u0013~\u00bd\u0001\u0007\"\u00ae\u0084\u00a5'\u009d\u0004\u00b2\u00df\u00f0\u00e8\u0006L&\u008bn\u00b1\u00b6*\tyBc\u0018\u00c1\u008d\u00bcL\u00a0#\u00af\u00ea\u00e7\u00cdE|\u0006!\u0083\u00eb\u00c5\u0097\u0081$\u00e3\u00c3:szR\u00c9\u001e\\\u008a\u0098\u00be;\u00fe\u00c3\u00d5\u00ec\u0014\u008e\u0017\r\u00c6~7~O\u00e0S\u00acov\u0087\u00e8\r\u00ae\u00cc\u00d04(\u00a1\u00f3\u00e3\u00b4\u00d5y\u0094\u0086\u00bdj\u0007\u0001\u000f\u007fG\u00fc\u00f0\u00da\u00e7\u00c5\u00ab4!\u00e4\u00bf\boJ\u0018\u00d8\u001d\u00d4\u00b6\u009f\u0090\u00e0=$$x'\u00ac\u0017I\u00c6\u00f67oO\u00c2S\u00e8&\u00ff\u0085\u00ece\u00a4\u0096\f\u00a5\u00e7\u00b9\u00b4\u00d0\u00c1\u0084S\u008f\u00a2\u00c5\u00e7n\u00ff\u00ab\u0006\u0003\u00d2\u009fe\u001a\u0003~A\u0001s0\u00e3\u0094\u008amLT2\u00d4U\u00e6\u0084r\u00e5L\u00ddII\u0093\u00a50".length();
                var1_4 = 42;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = ";\u001aCS\u00e4\t\u0000\u00e8\u00e6\u00a2\u00f1\u00ef\u00f9\u00a3\u0096[u\u00f8\u0010\u009d\u0083\u00f7\u001cF1\u0088\u00e1\u00ea\u00a8\\4%\u00bf\u00a6p\u0014\u008e>r\u0018\u00f2\u00a2\u00d2=,\u0014\u0002\u00a6PXi\u0097\u00e4\u0014#\u00af\u00df2\u00a5\u00ef\u009bZ\u00e0\u00f5\u009e?\u0097\u008bJ\u00c3\t\u00bf\u00dacZM\u00e5\u0090\u00be\u0095\u00172^\u00e5\u0014\u0000#\u008c\r";
                    var4_3 = ";\u001aCS\u00e4\t\u0000\u00e8\u00e6\u00a2\u00f1\u00ef\u00f9\u00a3\u0096[u\u00f8\u0010\u009d\u0083\u00f7\u001cF1\u0088\u00e1\u00ea\u00a8\\4%\u00bf\u00a6p\u0014\u008e>r\u0018\u00f2\u00a2\u00d2=,\u0014\u0002\u00a6PXi\u0097\u00e4\u0014#\u00af\u00df2\u00a5\u00ef\u009bZ\u00e0\u00f5\u009e?\u0097\u008bJ\u00c3\t\u00bf\u00dacZM\u00e5\u0090\u00be\u0095\u00172^\u00e5\u0014\u0000#\u008c\r".length();
                    var1_4 = 44;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 36;
                            break;
                        }
                        case 1: {
                            v13 = 85;
                            break;
                        }
                        case 2: {
                            v13 = 19;
                            break;
                        }
                        case 3: {
                            v13 = 65;
                            break;
                        }
                        case 4: {
                            v13 = 74;
                            break;
                        }
                        case 5: {
                            v13 = 6;
                            break;
                        }
                        default: {
                            v13 = 71;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CertStoreDirectoryOps.c = var5;
        CertStoreDirectoryOps.d = new String[17];
        CertStoreDirectoryOps.a = LoggerFactory.getLogger(CertStoreDirectoryOps.class);
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0xFFFFB23C) & 0xFFFF;
        if (d[n4] == null) {
            int n5;
            int n6;
            char[] cArray = c[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 149;
                    break;
                }
                case 1: {
                    n6 = 113;
                    break;
                }
                case 2: {
                    n6 = 51;
                    break;
                }
                case 3: {
                    n6 = 216;
                    break;
                }
                case 4: {
                    n6 = 105;
                    break;
                }
                case 5: {
                    n6 = 235;
                    break;
                }
                case 6: {
                    n6 = 64;
                    break;
                }
                case 7: {
                    n6 = 188;
                    break;
                }
                case 8: {
                    n6 = 78;
                    break;
                }
                case 9: {
                    n6 = 13;
                    break;
                }
                case 10: {
                    n6 = 119;
                    break;
                }
                case 11: {
                    n6 = 240;
                    break;
                }
                case 12: {
                    n6 = 84;
                    break;
                }
                case 13: {
                    n6 = 72;
                    break;
                }
                case 14: {
                    n6 = 4;
                    break;
                }
                case 15: {
                    n6 = 136;
                    break;
                }
                case 16: {
                    n6 = 237;
                    break;
                }
                case 17: {
                    n6 = 65;
                    break;
                }
                case 18: {
                    n6 = 52;
                    break;
                }
                case 19: {
                    n6 = 24;
                    break;
                }
                case 20: {
                    n6 = 45;
                    break;
                }
                case 21: {
                    n6 = 219;
                    break;
                }
                case 22: {
                    n6 = 46;
                    break;
                }
                case 23: {
                    n6 = 35;
                    break;
                }
                case 24: {
                    n6 = 89;
                    break;
                }
                case 25: {
                    n6 = 201;
                    break;
                }
                case 26: {
                    n6 = 121;
                    break;
                }
                case 27: {
                    n6 = 110;
                    break;
                }
                case 28: {
                    n6 = 174;
                    break;
                }
                case 29: {
                    n6 = 126;
                    break;
                }
                case 30: {
                    n6 = 209;
                    break;
                }
                case 31: {
                    n6 = 148;
                    break;
                }
                case 32: {
                    n6 = 112;
                    break;
                }
                case 33: {
                    n6 = 26;
                    break;
                }
                case 34: {
                    n6 = 42;
                    break;
                }
                case 35: {
                    n6 = 255;
                    break;
                }
                case 36: {
                    n6 = 236;
                    break;
                }
                case 37: {
                    n6 = 215;
                    break;
                }
                case 38: {
                    n6 = 63;
                    break;
                }
                case 39: {
                    n6 = 67;
                    break;
                }
                case 40: {
                    n6 = 210;
                    break;
                }
                case 41: {
                    n6 = 19;
                    break;
                }
                case 42: {
                    n6 = 102;
                    break;
                }
                case 43: {
                    n6 = 60;
                    break;
                }
                case 44: {
                    n6 = 124;
                    break;
                }
                case 45: {
                    n6 = 34;
                    break;
                }
                case 46: {
                    n6 = 8;
                    break;
                }
                case 47: {
                    n6 = 193;
                    break;
                }
                case 48: {
                    n6 = 125;
                    break;
                }
                case 49: {
                    n6 = 27;
                    break;
                }
                case 50: {
                    n6 = 183;
                    break;
                }
                case 51: {
                    n6 = 10;
                    break;
                }
                case 52: {
                    n6 = 135;
                    break;
                }
                case 53: {
                    n6 = 141;
                    break;
                }
                case 54: {
                    n6 = 160;
                    break;
                }
                case 55: {
                    n6 = 220;
                    break;
                }
                case 56: {
                    n6 = 156;
                    break;
                }
                case 57: {
                    n6 = 62;
                    break;
                }
                case 58: {
                    n6 = 241;
                    break;
                }
                case 59: {
                    n6 = 228;
                    break;
                }
                case 60: {
                    n6 = 254;
                    break;
                }
                case 61: {
                    n6 = 167;
                    break;
                }
                case 62: {
                    n6 = 85;
                    break;
                }
                case 63: {
                    n6 = 22;
                    break;
                }
                case 64: {
                    n6 = 53;
                    break;
                }
                case 65: {
                    n6 = 165;
                    break;
                }
                case 66: {
                    n6 = 132;
                    break;
                }
                case 67: {
                    n6 = 20;
                    break;
                }
                case 68: {
                    n6 = 70;
                    break;
                }
                case 69: {
                    n6 = 191;
                    break;
                }
                case 70: {
                    n6 = 68;
                    break;
                }
                case 71: {
                    n6 = 99;
                    break;
                }
                case 72: {
                    n6 = 175;
                    break;
                }
                case 73: {
                    n6 = 32;
                    break;
                }
                case 74: {
                    n6 = 145;
                    break;
                }
                case 75: {
                    n6 = 217;
                    break;
                }
                case 76: {
                    n6 = 185;
                    break;
                }
                case 77: {
                    n6 = 2;
                    break;
                }
                case 78: {
                    n6 = 95;
                    break;
                }
                case 79: {
                    n6 = 195;
                    break;
                }
                case 80: {
                    n6 = 118;
                    break;
                }
                case 81: {
                    n6 = 76;
                    break;
                }
                case 82: {
                    n6 = 92;
                    break;
                }
                case 83: {
                    n6 = 146;
                    break;
                }
                case 84: {
                    n6 = 247;
                    break;
                }
                case 85: {
                    n6 = 139;
                    break;
                }
                case 86: {
                    n6 = 140;
                    break;
                }
                case 87: {
                    n6 = 200;
                    break;
                }
                case 88: {
                    n6 = 107;
                    break;
                }
                case 89: {
                    n6 = 224;
                    break;
                }
                case 90: {
                    n6 = 6;
                    break;
                }
                case 91: {
                    n6 = 178;
                    break;
                }
                case 92: {
                    n6 = 207;
                    break;
                }
                case 93: {
                    n6 = 233;
                    break;
                }
                case 94: {
                    n6 = 238;
                    break;
                }
                case 95: {
                    n6 = 49;
                    break;
                }
                case 96: {
                    n6 = 221;
                    break;
                }
                case 97: {
                    n6 = 109;
                    break;
                }
                case 98: {
                    n6 = 157;
                    break;
                }
                case 99: {
                    n6 = 225;
                    break;
                }
                case 100: {
                    n6 = 88;
                    break;
                }
                case 101: {
                    n6 = 74;
                    break;
                }
                case 102: {
                    n6 = 83;
                    break;
                }
                case 103: {
                    n6 = 152;
                    break;
                }
                case 104: {
                    n6 = 108;
                    break;
                }
                case 105: {
                    n6 = 30;
                    break;
                }
                case 106: {
                    n6 = 192;
                    break;
                }
                case 107: {
                    n6 = 61;
                    break;
                }
                case 108: {
                    n6 = 1;
                    break;
                }
                case 109: {
                    n6 = 198;
                    break;
                }
                case 110: {
                    n6 = 71;
                    break;
                }
                case 111: {
                    n6 = 232;
                    break;
                }
                case 112: {
                    n6 = 143;
                    break;
                }
                case 113: {
                    n6 = 204;
                    break;
                }
                case 114: {
                    n6 = 212;
                    break;
                }
                case 115: {
                    n6 = 57;
                    break;
                }
                case 116: {
                    n6 = 184;
                    break;
                }
                case 117: {
                    n6 = 106;
                    break;
                }
                case 118: {
                    n6 = 171;
                    break;
                }
                case 119: {
                    n6 = 133;
                    break;
                }
                case 120: {
                    n6 = 251;
                    break;
                }
                case 121: {
                    n6 = 239;
                    break;
                }
                case 122: {
                    n6 = 128;
                    break;
                }
                case 123: {
                    n6 = 75;
                    break;
                }
                case 124: {
                    n6 = 246;
                    break;
                }
                case 125: {
                    n6 = 194;
                    break;
                }
                case 126: {
                    n6 = 3;
                    break;
                }
                case 127: {
                    n6 = 111;
                    break;
                }
                case 128: {
                    n6 = 104;
                    break;
                }
                case 129: {
                    n6 = 203;
                    break;
                }
                case 130: {
                    n6 = 180;
                    break;
                }
                case 131: {
                    n6 = 169;
                    break;
                }
                case 132: {
                    n6 = 66;
                    break;
                }
                case 133: {
                    n6 = 14;
                    break;
                }
                case 134: {
                    n6 = 137;
                    break;
                }
                case 135: {
                    n6 = 170;
                    break;
                }
                case 136: {
                    n6 = 17;
                    break;
                }
                case 137: {
                    n6 = 55;
                    break;
                }
                case 138: {
                    n6 = 15;
                    break;
                }
                case 139: {
                    n6 = 101;
                    break;
                }
                case 140: {
                    n6 = 186;
                    break;
                }
                case 141: {
                    n6 = 176;
                    break;
                }
                case 142: {
                    n6 = 223;
                    break;
                }
                case 143: {
                    n6 = 122;
                    break;
                }
                case 144: {
                    n6 = 142;
                    break;
                }
                case 145: {
                    n6 = 150;
                    break;
                }
                case 146: {
                    n6 = 222;
                    break;
                }
                case 147: {
                    n6 = 154;
                    break;
                }
                case 148: {
                    n6 = 82;
                    break;
                }
                case 149: {
                    n6 = 48;
                    break;
                }
                case 150: {
                    n6 = 206;
                    break;
                }
                case 151: {
                    n6 = 94;
                    break;
                }
                case 152: {
                    n6 = 43;
                    break;
                }
                case 153: {
                    n6 = 33;
                    break;
                }
                case 154: {
                    n6 = 131;
                    break;
                }
                case 155: {
                    n6 = 117;
                    break;
                }
                case 156: {
                    n6 = 155;
                    break;
                }
                case 157: {
                    n6 = 245;
                    break;
                }
                case 158: {
                    n6 = 100;
                    break;
                }
                case 159: {
                    n6 = 21;
                    break;
                }
                case 160: {
                    n6 = 242;
                    break;
                }
                case 161: {
                    n6 = 7;
                    break;
                }
                case 162: {
                    n6 = 250;
                    break;
                }
                case 163: {
                    n6 = 79;
                    break;
                }
                case 164: {
                    n6 = 9;
                    break;
                }
                case 165: {
                    n6 = 69;
                    break;
                }
                case 166: {
                    n6 = 213;
                    break;
                }
                case 167: {
                    n6 = 36;
                    break;
                }
                case 168: {
                    n6 = 248;
                    break;
                }
                case 169: {
                    n6 = 103;
                    break;
                }
                case 170: {
                    n6 = 77;
                    break;
                }
                case 171: {
                    n6 = 134;
                    break;
                }
                case 172: {
                    n6 = 151;
                    break;
                }
                case 173: {
                    n6 = 40;
                    break;
                }
                case 174: {
                    n6 = 253;
                    break;
                }
                case 175: {
                    n6 = 91;
                    break;
                }
                case 176: {
                    n6 = 179;
                    break;
                }
                case 177: {
                    n6 = 23;
                    break;
                }
                case 178: {
                    n6 = 18;
                    break;
                }
                case 179: {
                    n6 = 230;
                    break;
                }
                case 180: {
                    n6 = 5;
                    break;
                }
                case 181: {
                    n6 = 98;
                    break;
                }
                case 182: {
                    n6 = 120;
                    break;
                }
                case 183: {
                    n6 = 189;
                    break;
                }
                case 184: {
                    n6 = 87;
                    break;
                }
                case 185: {
                    n6 = 244;
                    break;
                }
                case 186: {
                    n6 = 231;
                    break;
                }
                case 187: {
                    n6 = 44;
                    break;
                }
                case 188: {
                    n6 = 243;
                    break;
                }
                case 189: {
                    n6 = 214;
                    break;
                }
                case 190: {
                    n6 = 197;
                    break;
                }
                case 191: {
                    n6 = 177;
                    break;
                }
                case 192: {
                    n6 = 234;
                    break;
                }
                case 193: {
                    n6 = 50;
                    break;
                }
                case 194: {
                    n6 = 38;
                    break;
                }
                case 195: {
                    n6 = 47;
                    break;
                }
                case 196: {
                    n6 = 138;
                    break;
                }
                case 197: {
                    n6 = 159;
                    break;
                }
                case 198: {
                    n6 = 11;
                    break;
                }
                case 199: {
                    n6 = 187;
                    break;
                }
                case 200: {
                    n6 = 116;
                    break;
                }
                case 201: {
                    n6 = 172;
                    break;
                }
                case 202: {
                    n6 = 25;
                    break;
                }
                case 203: {
                    n6 = 12;
                    break;
                }
                case 204: {
                    n6 = 0;
                    break;
                }
                case 205: {
                    n6 = 226;
                    break;
                }
                case 206: {
                    n6 = 218;
                    break;
                }
                case 207: {
                    n6 = 127;
                    break;
                }
                case 208: {
                    n6 = 164;
                    break;
                }
                case 209: {
                    n6 = 205;
                    break;
                }
                case 210: {
                    n6 = 181;
                    break;
                }
                case 211: {
                    n6 = 31;
                    break;
                }
                case 212: {
                    n6 = 130;
                    break;
                }
                case 213: {
                    n6 = 58;
                    break;
                }
                case 214: {
                    n6 = 96;
                    break;
                }
                case 215: {
                    n6 = 93;
                    break;
                }
                case 216: {
                    n6 = 182;
                    break;
                }
                case 217: {
                    n6 = 56;
                    break;
                }
                case 218: {
                    n6 = 162;
                    break;
                }
                case 219: {
                    n6 = 202;
                    break;
                }
                case 220: {
                    n6 = 173;
                    break;
                }
                case 221: {
                    n6 = 211;
                    break;
                }
                case 222: {
                    n6 = 90;
                    break;
                }
                case 223: {
                    n6 = 80;
                    break;
                }
                case 224: {
                    n6 = 153;
                    break;
                }
                case 225: {
                    n6 = 29;
                    break;
                }
                case 226: {
                    n6 = 166;
                    break;
                }
                case 227: {
                    n6 = 39;
                    break;
                }
                case 228: {
                    n6 = 129;
                    break;
                }
                case 229: {
                    n6 = 114;
                    break;
                }
                case 230: {
                    n6 = 16;
                    break;
                }
                case 231: {
                    n6 = 73;
                    break;
                }
                case 232: {
                    n6 = 37;
                    break;
                }
                case 233: {
                    n6 = 196;
                    break;
                }
                case 234: {
                    n6 = 161;
                    break;
                }
                case 235: {
                    n6 = 86;
                    break;
                }
                case 236: {
                    n6 = 115;
                    break;
                }
                case 237: {
                    n6 = 81;
                    break;
                }
                case 238: {
                    n6 = 252;
                    break;
                }
                case 239: {
                    n6 = 158;
                    break;
                }
                case 240: {
                    n6 = 59;
                    break;
                }
                case 241: {
                    n6 = 249;
                    break;
                }
                case 242: {
                    n6 = 208;
                    break;
                }
                case 243: {
                    n6 = 41;
                    break;
                }
                case 244: {
                    n6 = 163;
                    break;
                }
                case 245: {
                    n6 = 28;
                    break;
                }
                case 246: {
                    n6 = 168;
                    break;
                }
                case 247: {
                    n6 = 147;
                    break;
                }
                case 248: {
                    n6 = 227;
                    break;
                }
                case 249: {
                    n6 = 190;
                    break;
                }
                case 250: {
                    n6 = 229;
                    break;
                }
                case 251: {
                    n6 = 199;
                    break;
                }
                case 252: {
                    n6 = 144;
                    break;
                }
                case 253: {
                    n6 = 97;
                    break;
                }
                case 254: {
                    n6 = 123;
                    break;
                }
                default: {
                    n6 = 54;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            CertStoreDirectoryOps.d[n4] = new String(cArray).intern();
        }
        return d[n4];
    }
}

