/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EBasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ESingleResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.ItemSource;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.NotFoundException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzetTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzneTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOCSP;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOCSPToWrite;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOzet;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSertifika;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.ops.CertStoreRootCertificateOps;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.OCSPSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.util.RsItemSource;

public class CertStoreOCSPOps {
    private static Logger a;
    private final CertStore b;
    private static final String[] c;
    private static final String[] d;

    public CertStoreOCSPOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(CertStoreOCSPOps.a(12327, -16955));
            throw new ESYARuntimeException(CertStoreOCSPOps.a(12321, 9717) + lE.getMessage());
        }
        this.b = aDepo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DepoOCSP readStoreOCSPResponse(long aOCSPNo) throws CertStoreException {
        DepoOCSP depoOCSP;
        try {
            DepoOCSP depoOCSP2;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoOCSP = depoOCSP2 = depoVEN.ocspCevabiOku(aOCSPNo);
        }
        catch (NotFoundException notFoundException) {
            try {
                throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(12336, 17763), notFoundException);
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(12323, -25737), certStoreException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(12323, -25737), certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return depoOCSP;
            JDBCUtil.commit(this.b.getConn());
            return depoOCSP;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(12326, 10439), certStoreException);
        }
    }

    public void writeOCSPResponseAndCertificate(EOCSPResponse aResponse, ECertificate aCertificate) throws CertStoreException {
        EBasicOCSPResponse eBasicOCSPResponse = aResponse.getBasicOCSPResponse();
        boolean bl = CertStoreRootCertificateOps.c;
        ESingleResponse eSingleResponse = CertStoreUtil.getOCSPResponseForCertificate(eBasicOCSPResponse, aCertificate);
        if (eSingleResponse == null) {
            throw new CertStoreException(CertStoreOCSPOps.a(12343, -24829));
        }
        DepoSertifika depoSertifika = CertStoreUtil.eSYASertifikaTODepoSertifika(aCertificate);
        DepoOCSPToWrite depoOCSPToWrite = CertStoreUtil.asnOCSPResponseTODepoOCSP(aResponse);
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            List<DepoOzet> list = CertStoreUtil.convertToDepoOzet(depoOCSPToWrite.getBasicOCSPResponse(), OzneTipi.OCSP_BASIC_RESPONSE);
            List<DepoOzet> list2 = CertStoreUtil.convertToDepoOzet(depoOCSPToWrite.getOCSPResponse(), OzneTipi.OCSP_RESPONSE);
            ArrayList<DepoOzet> arrayList = new ArrayList<DepoOzet>(list);
            arrayList.addAll(list2);
            List<DepoOzet> list3 = CertStoreUtil.convertToDepoOzet(depoSertifika.getValue(), OzneTipi.SERTIFIKA);
            depoVEN.ocspCevabiVeSertifikaYaz(depoOCSPToWrite, arrayList, depoSertifika, list3, eSingleResponse);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(CertStoreOCSPOps.a(12335, -4751), certStoreException);
        }
        if (bl) {
            int n2 = CertStoreException.b;
            CertStoreException.b = ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoOzet> listOCSPResponseHashes(long aOCSPNo) throws CertStoreException {
        List<DepoOzet> list2;
        try {
            List<DepoOzet> list;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            ItemSource<DepoOzet> itemSource = depoVEN.ocspOzetleriniListele(aOCSPNo);
            list2 = list = ((RsItemSource)itemSource).toList();
        }
        catch (Exception exception) {
            try {
                throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(12331, 26773), exception);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(12331, 26773), certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return list2;
            JDBCUtil.commit(this.b.getConn());
            return list2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(12324, -14727), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemSource<DepoOCSP> listStoreOCSPResponses(OCSPSearchTemplate aSablon) throws CertStoreException {
        ItemSource<DepoOCSP> itemSource2;
        try {
            ItemSource<DepoOCSP> itemSource;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSablon);
            String string = pair.first();
            List<Object> list = pair.second();
            itemSource2 = itemSource = depoVEN.ocspCevabiListele(string, list.toArray());
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(CertStoreOCSPOps.a(12332, -694), certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(CertStoreOCSPOps.a(12332, -694), certStoreException2);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return itemSource2;
            JDBCUtil.commit(this.b.getConn());
            return itemSource2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreOCSPOps.a(12328, 3107), certStoreException);
        }
    }

    public EBasicOCSPResponse listOCSPResponses(OCSPSearchTemplate aSablon) throws CertStoreException {
        ItemSource<DepoOCSP> itemSource = this.listStoreOCSPResponses(aSablon);
        if (itemSource == null) {
            return null;
        }
        DepoOCSP depoOCSP = null;
        try {
            depoOCSP = itemSource.nextItem();
            itemSource.close();
            if (depoOCSP == null) {
                return null;
            }
            return new EBasicOCSPResponse(depoOCSP.getBasicOCSPResponse());
        }
        catch (Exception exception) {
            throw new CertStoreException(depoOCSP.getOCSPNo() + CertStoreOCSPOps.a(12334, 6954), exception);
        }
    }

    public int deleteOCSPResponse(long aOCSPNo) throws CertStoreException {
        try {
            if (aOCSPNo <= 0L) {
                throw new CertStoreException(CertStoreOCSPOps.a(12322, -6640));
            }
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            int n2 = depoVEN.ocspCevabiSil(aOCSPNo);
            JDBCUtil.commit(this.b.getConn());
            return n2;
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(12347, -9506), certStoreException);
        }
    }

    private Pair<String, List<Object>> a(OCSPSearchTemplate oCSPSearchTemplate) {
        ArrayList<Object> arrayList;
        StringBuffer stringBuffer;
        block30: {
            OzetTipi ozetTipi;
            block28: {
                boolean bl;
                block29: {
                    stringBuffer = new StringBuffer("");
                    arrayList = new ArrayList<Object>();
                    stringBuffer.append(CertStoreOCSPOps.a(12330, -203));
                    byte[] byArray = oCSPSearchTemplate.getHash();
                    ozetTipi = oCSPSearchTemplate.getHashType();
                    bl = CertStoreRootCertificateOps.c;
                    if (byArray == null) break block28;
                    stringBuffer.append(CertStoreOCSPOps.a(12338, -10453));
                    arrayList.add(OzneTipi.OCSP_RESPONSE.getIntValue());
                    arrayList.add(OzneTipi.OCSP_BASIC_RESPONSE.getIntValue());
                    arrayList.add(byArray);
                    if (ozetTipi == null) break block29;
                    stringBuffer.append(CertStoreOCSPOps.a(12329, 18986));
                    arrayList.add(ozetTipi.getIntValue());
                    if (!bl) break block30;
                }
                stringBuffer.append(CertStoreOCSPOps.a(12339, -30140));
                if (!bl) break block30;
            }
            if (ozetTipi == null) break block30;
            stringBuffer.append(CertStoreOCSPOps.a(12341, -27285));
            arrayList.add(OzneTipi.OCSP_RESPONSE.getIntValue());
            arrayList.add(OzneTipi.OCSP_BASIC_RESPONSE.getIntValue());
            arrayList.add(ozetTipi.getIntValue());
        }
        byte[] byArray = oCSPSearchTemplate.getOCSPResponderID();
        if (byArray != null) {
            stringBuffer.append(CertStoreOCSPOps.a(12337, -28886));
            arrayList.add(byArray);
        }
        byte[] byArray2 = oCSPSearchTemplate.getOCSPValue();
        if (byArray2 != null) {
            stringBuffer.append(CertStoreOCSPOps.a(12333, -22061));
            arrayList.add(byArray2);
        }
        Date date = oCSPSearchTemplate.getProducedAtAfter();
        if (date != null) {
            stringBuffer.append(CertStoreOCSPOps.a(12340, 15986));
            arrayList.add(date);
        }
        Date date2 = oCSPSearchTemplate.getProducedAt();
        if (date2 != null) {
            stringBuffer.append(CertStoreOCSPOps.a(12320, 3848));
            arrayList.add(date2);
        }
        Date date3 = oCSPSearchTemplate.getProducedAtBefore();
        if (date3 != null) {
            stringBuffer.append(CertStoreOCSPOps.a(12325, -14217));
            arrayList.add(date3);
        }
        byte[] byArray3 = oCSPSearchTemplate.getCertSerialNumber();
        if (byArray3 != null) {
            stringBuffer.append(CertStoreOCSPOps.a(12342, 25463));
            arrayList.add(byArray3);
        }
        return new Pair<String, List<Object>>(stringBuffer.toString(), arrayList);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[25];
                var3_1 = 0;
                var2_2 = "UX\u00fa\u0004\u008e\u008c\u00cd\u00832\u0014\u00bb\u00b9\u00fb\u00e6\u0082|oA\u00e0\u00aaCh\u00bc\u00c7\u00e7\u0087Y\u00b1\u008b<\u00d6\u00f1\u00b9\u00e2\u00b3\u0080(6\u00ee\u00a8\u00e7/\u0006\u00f7\u000f*\u0011\u00ff\u00cd\u0098\u00e7]\u00d4\u009e\u00a0h\u0095\u00b8\u00df\u00a3\u00da\n\u0012\u00c4\u00e285\u0003\u008b\u00d5\u008cg5\f\u001c{3\u00c2<\u00dehy%\u008b\u00a6\u00db=I\u001bJ\u0090\u00e4\u00f7\u00c9\r\u0012\u0082s#X\u0093S\u008a\u00c8\u00ea\u00bb\u00d8\f\u00faF.\u00fd\u00f3\u00182\u00db[-Z\u00d4\u00a6\u001b\u009a\u00ac\u00f3\u0094\u0012g\u00c3\u009e\u00d44\u0097\u00f5G0\u00a3\u0017*\t9\u0014z8\u00d2\u00f5\u00e4\u00d3\u009d\t\u00f8>+\u00d6\u00c7KF\u008d\u00a5\u00c5\u00a3\u0089Al\u008f_\u00ca\u00fd\u00bal\u00d9x*\u0016\u0088\u00cf\u00c0\u00b2N\u00e1\u0000n\u00c1\u00f9\u001aW\u00ef(\u00f1\u00fc\u00a3't\u0016\u00a6\u0092\u00e9\u00de\u00ac\u0000,8d\u0003\u00d0n\r\u0085\u001a\u00bf\u008dZT\u001ey\u00e8\f,\u00f2\u00b3\u00a9.\u00cdg\u0002N\u00c5\u00b2Y\u0091Z\u0007}G\u00e3-\"\u00a2\u0014[Sgv\u00feE\u00bbUL&X9\u00ab\u0018\u00bb\u000e\u00f5\u009e\u0083\u0007\u00ba\u0090(\u00b7DV\u0082m&\u00ce\u0018]\u00df\u00f5\u00ddU\u00d5\u0090\u0080\u00e8\u0002\u00d2]UH\u00db\u00e4\u00fa\u00d2\u0090\u00fa\u00133\u0097\u00e7\u00f4>\u008b\u0012\u001d\u00ea\u00f080\u00ebw\u00f7I-\u009fz\u0093\u0092\u00ad\u00e4R\u0004db\u0097<\u008b\u00f0$\u009f\u0014\u00a8\u00f4\u00ffMIk\u0006y\u00b7\u0017\u00c3\u0087\u00e8\u001c+/\u00b3\u00d2\u00d6i\u0090\u00cb!c\u00f7\u00b8\u00cd\u00e7\u00c7pN\u00caYo\u00b3\u00cd\u0010S\u0002\u00eb_>\u0080\u00b1K\u000f8a\u0088\u00b69lx\u00dd\u0000j\fQ\u0093\u00a1\u0016\u00c9\u00f9\u00b5\u00eeK}V/\u00c1\u00e5\u00f4%\u00baX\u00d6\u0088\u0088*\u00e4#\u00ac\u00ebD\u00d8\u008e\u009f\u001b\u00b1\u00cb\u00f9A\u00e7\u00c10f\u00d7\u00c6\u00beT\u00bf\u00db\u00a4L \u00eb\u00c4\u00fc9^\u0010\u009b\r\u00a2\u00adH\u00a7\u0082\u0090\u00ad)9\u00f4\u00da>dG\u0087\u00e8<\u0084\u00a3l\u00f5\u000e\u00ec\u00fah9=\u00a8v\u00b0\u00c8\u0092\u00d3\u0010\u00d2\u00cdba\u00a5\u00e0\u00ea\u00cdW\u00fdf\u00d7\u009d\u00a9\u0084\u0081\u00f2\u00f0\u00df\u0003\u00a7\u00d2\u00c9\u0014\u00d9\u00f7J\u0013\u00c8+\u00f4\u0002\u00c1\u0012\u00e4\u00cab\u00af\u00ed\u008b\u0003\u00b5\u00b7v:\u00cc\u00a6\u00d95\\\u00e4\u00c0JH\u00190\u00e2\u00d7r\u00c8\u00c1y\u00e10\u00b0\u00d7\u00ebZB\u0085K+\u00eda\u00eb\u00d7\u0083\u0091\u00d2\u00bf@\u00a9`\u00d5\u00e8\u00bf\u00ae\u00d2\u0013\u00f7\u00e7\u00c9\u001d\u0018\u00d2Dj\u0000\u009c_\u0094\u00d6<=O\u00d0'\u00a5\u00ffd\u0016\u00a0\u0010\u00d5\u00e6\u0092#\u00bb\u00a9\u00b7oYv\u00b3\u00fa\u000e\u00e4\u00ffz\u00e2\u00c3>\u008d\u00f5\u008f\u00e6\u00fbQ\u00f3\u00b2!\u00ce\u00d0\u00ba\u00fb\u00dbs,\u00e6j\u00a3\u00e85\u0083\u0099z\u00df\u00b3\u0014\u0096 :\u00b0\u00ef\u00e4@\u00ea\u009a\r\\p\u0087\u0012\u00e2\u00c98\u00c4>\u0002L(2[\u00dbi\u00c8\u008e ~`@1\u00ae7\u00f2\u008c\u00b4\u0097\u008d\u0082T\u008f\u00dd\u00faZ\u00fa,\u00b6\u00a9\u0017\u00ffr\u00f4\u0010\u0019\u000e13-\u0005y$\u00a0\u00dcG\u00ac\\\u00f7K\u007f\u0013\u00d7C\u008b\u0085\u00f0\u00fe\u00d1\u007f;\u009b\u009c\u00a5f\u0098b\u009dS\u00d6H:\u00b5w\u00f6\u000f\u00b9\u00a3|\u00a2\u00df\u0004\u00c2A\u0089\u0006\u0003O\u00000\u001f\u008a2\u00ac\u00e6\u00aa\u0012V\u00d9N?\u009f\u001c\r\u00e8\u0003\u0090zL'i\u0000(\u00b3 \u00b0\u00a9\u0093\u0002\u0093a\u0003kP\u00e5\u00db\u00e3|A!\u0003~\u0002\u00d9h\u00ded\u00aaa\u00d4bU\u00ec\u00ab\u00f1\u0080\u00bf\u00165\u00d7s\u0096\u00c6\u0081\u00bd\u001e[\u00b2\u00e1\u00d0\u00d6\u009c6{\u00fd\u00e1\u00d8\u00de\u00a0\u00b2\u0014\u00aa5\u00f0\u0092\u00f2\u00e3\u001dj@\u009e\u0086&\u00bd\u0095\u00c8\u00c2\u0096\u00b2T\u00babv\u00d4\u00a0\u008f\u0087\u00ad\u00a1j+\u001a5\bY\u0012\u009d\u00127\u00d9p\u0010\u00f5K\u00fb]]\u00c3\u0007\u00dc\u009e\u00cdy\u00b2Ez\u00b8\u0007)k\u0007Pp\u00db\u008f\u00945\u0011o\u0019\u00ea\u00c1,\u00d5\u0004\u00f4O>\u00e8\u00b7\u00e2\u00bb(\u00ad@)\u00d5\u007f\u001cZk\u00ef\u0013C\u00a6+P\u0013Zm\u009a\u00a1O&b\u00a0\u00b1/\u00ba4\u00aa&j\nY\u00cdIL\u001b\u00b7;\u00fc\u00ea\u0013\u00c58a\u000f%}NT<+\u0089oXa\u0098!D\u00cbf\u00c2\u0090\u00aa\u00e7\u00a8\\*ET$Ml\u0086\n=\u00a6O\u0003\u0098l%\n\u00a3\u00f1x>\u00cc\u00f7}t\u0086|\u00c6\u00fe5^\u00e8\u0004\u00bd\u0081\u00db\u00c5\u00fa\u00be\u009d\u00c2f4d\u00d5\u00e9\u0094\u00d1\u00e3\u00b0\u00db\u00c5\u00cdg\u00d91\u00e4\u0090{\u008aA\u00b33\u0006\u001f\u00b7\u00b6wF\u00b5\u00be\\\u0004=B\u0088\\f\u00b3\u00f9\u0013\u00af\u0089\u00cea\u00a4_\u00c5n,\u0092\u00d6\u00b0[\u0010\u00a9\u0017\u00e0\u008e\u00b4\u0082\u00f3~\u0092\u00be\u00c4V\u00f5\u00baC\u009e?\t\u0002O\u00af\u00e6d\u00d0V\u008fj\u008b\u0084OS\u00a32{N\u00e6\u009e\u0098\u00a4+\u00a1\u0000\u00a4\u0090\u00eaw\u00dc\u0083\u00f6\u0085\u00a3\u00c9\u00fb\u0013\u00e0\n\u00e8\u00fdf\u00a0\u00a96\tcQi\u008a\u001a \u00ae\u0085\u009b\u007f\u00d3\u00ee\u0016(C\u0003\u00aau\u0080\u00c2\u00b8\u000brO\u00a2\u0098\u00de\u009514\u00canbC+\u008a\u00de8\u00db\u00fb\u00cc\u00da\u00ad\u00b7\u0004\u00b5\u0096U\u0001$\u00d5\u00e9\u00ebB\r\u00c7K~\u0085'\u0091|\\\u009a\u0018\u000fR>U\u0090\u00faY\u00a08\u00a2W\u00d0q\u008c\u0005j\u00e9\b\t#I\u00c8\u008dg\u00e7F\u00f7\u00a2\u00d2D\u0012\u00b6\u00cb\u00ec\u001a\u0006HN\u0016\u00ac\u00e0\u00a9\u00b9";
                var4_3 = "UX\u00fa\u0004\u008e\u008c\u00cd\u00832\u0014\u00bb\u00b9\u00fb\u00e6\u0082|oA\u00e0\u00aaCh\u00bc\u00c7\u00e7\u0087Y\u00b1\u008b<\u00d6\u00f1\u00b9\u00e2\u00b3\u0080(6\u00ee\u00a8\u00e7/\u0006\u00f7\u000f*\u0011\u00ff\u00cd\u0098\u00e7]\u00d4\u009e\u00a0h\u0095\u00b8\u00df\u00a3\u00da\n\u0012\u00c4\u00e285\u0003\u008b\u00d5\u008cg5\f\u001c{3\u00c2<\u00dehy%\u008b\u00a6\u00db=I\u001bJ\u0090\u00e4\u00f7\u00c9\r\u0012\u0082s#X\u0093S\u008a\u00c8\u00ea\u00bb\u00d8\f\u00faF.\u00fd\u00f3\u00182\u00db[-Z\u00d4\u00a6\u001b\u009a\u00ac\u00f3\u0094\u0012g\u00c3\u009e\u00d44\u0097\u00f5G0\u00a3\u0017*\t9\u0014z8\u00d2\u00f5\u00e4\u00d3\u009d\t\u00f8>+\u00d6\u00c7KF\u008d\u00a5\u00c5\u00a3\u0089Al\u008f_\u00ca\u00fd\u00bal\u00d9x*\u0016\u0088\u00cf\u00c0\u00b2N\u00e1\u0000n\u00c1\u00f9\u001aW\u00ef(\u00f1\u00fc\u00a3't\u0016\u00a6\u0092\u00e9\u00de\u00ac\u0000,8d\u0003\u00d0n\r\u0085\u001a\u00bf\u008dZT\u001ey\u00e8\f,\u00f2\u00b3\u00a9.\u00cdg\u0002N\u00c5\u00b2Y\u0091Z\u0007}G\u00e3-\"\u00a2\u0014[Sgv\u00feE\u00bbUL&X9\u00ab\u0018\u00bb\u000e\u00f5\u009e\u0083\u0007\u00ba\u0090(\u00b7DV\u0082m&\u00ce\u0018]\u00df\u00f5\u00ddU\u00d5\u0090\u0080\u00e8\u0002\u00d2]UH\u00db\u00e4\u00fa\u00d2\u0090\u00fa\u00133\u0097\u00e7\u00f4>\u008b\u0012\u001d\u00ea\u00f080\u00ebw\u00f7I-\u009fz\u0093\u0092\u00ad\u00e4R\u0004db\u0097<\u008b\u00f0$\u009f\u0014\u00a8\u00f4\u00ffMIk\u0006y\u00b7\u0017\u00c3\u0087\u00e8\u001c+/\u00b3\u00d2\u00d6i\u0090\u00cb!c\u00f7\u00b8\u00cd\u00e7\u00c7pN\u00caYo\u00b3\u00cd\u0010S\u0002\u00eb_>\u0080\u00b1K\u000f8a\u0088\u00b69lx\u00dd\u0000j\fQ\u0093\u00a1\u0016\u00c9\u00f9\u00b5\u00eeK}V/\u00c1\u00e5\u00f4%\u00baX\u00d6\u0088\u0088*\u00e4#\u00ac\u00ebD\u00d8\u008e\u009f\u001b\u00b1\u00cb\u00f9A\u00e7\u00c10f\u00d7\u00c6\u00beT\u00bf\u00db\u00a4L \u00eb\u00c4\u00fc9^\u0010\u009b\r\u00a2\u00adH\u00a7\u0082\u0090\u00ad)9\u00f4\u00da>dG\u0087\u00e8<\u0084\u00a3l\u00f5\u000e\u00ec\u00fah9=\u00a8v\u00b0\u00c8\u0092\u00d3\u0010\u00d2\u00cdba\u00a5\u00e0\u00ea\u00cdW\u00fdf\u00d7\u009d\u00a9\u0084\u0081\u00f2\u00f0\u00df\u0003\u00a7\u00d2\u00c9\u0014\u00d9\u00f7J\u0013\u00c8+\u00f4\u0002\u00c1\u0012\u00e4\u00cab\u00af\u00ed\u008b\u0003\u00b5\u00b7v:\u00cc\u00a6\u00d95\\\u00e4\u00c0JH\u00190\u00e2\u00d7r\u00c8\u00c1y\u00e10\u00b0\u00d7\u00ebZB\u0085K+\u00eda\u00eb\u00d7\u0083\u0091\u00d2\u00bf@\u00a9`\u00d5\u00e8\u00bf\u00ae\u00d2\u0013\u00f7\u00e7\u00c9\u001d\u0018\u00d2Dj\u0000\u009c_\u0094\u00d6<=O\u00d0'\u00a5\u00ffd\u0016\u00a0\u0010\u00d5\u00e6\u0092#\u00bb\u00a9\u00b7oYv\u00b3\u00fa\u000e\u00e4\u00ffz\u00e2\u00c3>\u008d\u00f5\u008f\u00e6\u00fbQ\u00f3\u00b2!\u00ce\u00d0\u00ba\u00fb\u00dbs,\u00e6j\u00a3\u00e85\u0083\u0099z\u00df\u00b3\u0014\u0096 :\u00b0\u00ef\u00e4@\u00ea\u009a\r\\p\u0087\u0012\u00e2\u00c98\u00c4>\u0002L(2[\u00dbi\u00c8\u008e ~`@1\u00ae7\u00f2\u008c\u00b4\u0097\u008d\u0082T\u008f\u00dd\u00faZ\u00fa,\u00b6\u00a9\u0017\u00ffr\u00f4\u0010\u0019\u000e13-\u0005y$\u00a0\u00dcG\u00ac\\\u00f7K\u007f\u0013\u00d7C\u008b\u0085\u00f0\u00fe\u00d1\u007f;\u009b\u009c\u00a5f\u0098b\u009dS\u00d6H:\u00b5w\u00f6\u000f\u00b9\u00a3|\u00a2\u00df\u0004\u00c2A\u0089\u0006\u0003O\u00000\u001f\u008a2\u00ac\u00e6\u00aa\u0012V\u00d9N?\u009f\u001c\r\u00e8\u0003\u0090zL'i\u0000(\u00b3 \u00b0\u00a9\u0093\u0002\u0093a\u0003kP\u00e5\u00db\u00e3|A!\u0003~\u0002\u00d9h\u00ded\u00aaa\u00d4bU\u00ec\u00ab\u00f1\u0080\u00bf\u00165\u00d7s\u0096\u00c6\u0081\u00bd\u001e[\u00b2\u00e1\u00d0\u00d6\u009c6{\u00fd\u00e1\u00d8\u00de\u00a0\u00b2\u0014\u00aa5\u00f0\u0092\u00f2\u00e3\u001dj@\u009e\u0086&\u00bd\u0095\u00c8\u00c2\u0096\u00b2T\u00babv\u00d4\u00a0\u008f\u0087\u00ad\u00a1j+\u001a5\bY\u0012\u009d\u00127\u00d9p\u0010\u00f5K\u00fb]]\u00c3\u0007\u00dc\u009e\u00cdy\u00b2Ez\u00b8\u0007)k\u0007Pp\u00db\u008f\u00945\u0011o\u0019\u00ea\u00c1,\u00d5\u0004\u00f4O>\u00e8\u00b7\u00e2\u00bb(\u00ad@)\u00d5\u007f\u001cZk\u00ef\u0013C\u00a6+P\u0013Zm\u009a\u00a1O&b\u00a0\u00b1/\u00ba4\u00aa&j\nY\u00cdIL\u001b\u00b7;\u00fc\u00ea\u0013\u00c58a\u000f%}NT<+\u0089oXa\u0098!D\u00cbf\u00c2\u0090\u00aa\u00e7\u00a8\\*ET$Ml\u0086\n=\u00a6O\u0003\u0098l%\n\u00a3\u00f1x>\u00cc\u00f7}t\u0086|\u00c6\u00fe5^\u00e8\u0004\u00bd\u0081\u00db\u00c5\u00fa\u00be\u009d\u00c2f4d\u00d5\u00e9\u0094\u00d1\u00e3\u00b0\u00db\u00c5\u00cdg\u00d91\u00e4\u0090{\u008aA\u00b33\u0006\u001f\u00b7\u00b6wF\u00b5\u00be\\\u0004=B\u0088\\f\u00b3\u00f9\u0013\u00af\u0089\u00cea\u00a4_\u00c5n,\u0092\u00d6\u00b0[\u0010\u00a9\u0017\u00e0\u008e\u00b4\u0082\u00f3~\u0092\u00be\u00c4V\u00f5\u00baC\u009e?\t\u0002O\u00af\u00e6d\u00d0V\u008fj\u008b\u0084OS\u00a32{N\u00e6\u009e\u0098\u00a4+\u00a1\u0000\u00a4\u0090\u00eaw\u00dc\u0083\u00f6\u0085\u00a3\u00c9\u00fb\u0013\u00e0\n\u00e8\u00fdf\u00a0\u00a96\tcQi\u008a\u001a \u00ae\u0085\u009b\u007f\u00d3\u00ee\u0016(C\u0003\u00aau\u0080\u00c2\u00b8\u000brO\u00a2\u0098\u00de\u009514\u00canbC+\u008a\u00de8\u00db\u00fb\u00cc\u00da\u00ad\u00b7\u0004\u00b5\u0096U\u0001$\u00d5\u00e9\u00ebB\r\u00c7K~\u0085'\u0091|\\\u009a\u0018\u000fR>U\u0090\u00faY\u00a08\u00a2W\u00d0q\u008c\u0005j\u00e9\b\t#I\u00c8\u008dg\u00e7F\u00f7\u00a2\u00d2D\u0012\u00b6\u00cb\u00ec\u001a\u0006HN\u0016\u00ac\u00e0\u00a9\u00b9".length();
                var1_4 = 45;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "4.\u00f7(\u007fK \u00c9\u0005UU+\u00ac\u00a7\u0080!|\u008c\u00dc\u00f4\u00b5r\u00c7\u00c4_K]\u00b6\u00cb\u000b\u00a6\u00d73bH\u00ae\u0012\u00a5;\u00c32\u00f9\u00d6d\u00acfFz\n`U{\u0092Z7\u00db\nM\u00ed\u007f\u008aOb\u00a3\u00aaGO9=VW\u00b4f \b\u00947\n\u00c6'2\u00e4\u00c7\u0083\u00bb\u001b\u00018\u0019V\u00a3E\u00eeO6S\u0096e\u0003\u00a0|\u0006\u0004\u00a4}\u00af#$\u0099$\fJ\u0090\u00c9\u00cbA\u008c\u001e\u0080\u00ca\u0084\u0099,\u00bc\u00ee\u00ebM\u00f5\u0010\u00c7\u00f1\u00c7\u00c3\u00f5\u00fd\u00e1x\u00e9|)+b\u00cf=\u0091\u0099}x\u0097\u00d7\u001b7/\u000e\u00bb\u0080z\u00e0\u00a6\u00a7\b\u00f1\u008doD\u008b\u00b6\u00f9\u00d4}\u00120\u00fe";
                    var4_3 = "4.\u00f7(\u007fK \u00c9\u0005UU+\u00ac\u00a7\u0080!|\u008c\u00dc\u00f4\u00b5r\u00c7\u00c4_K]\u00b6\u00cb\u000b\u00a6\u00d73bH\u00ae\u0012\u00a5;\u00c32\u00f9\u00d6d\u00acfFz\n`U{\u0092Z7\u00db\nM\u00ed\u007f\u008aOb\u00a3\u00aaGO9=VW\u00b4f \b\u00947\n\u00c6'2\u00e4\u00c7\u0083\u00bb\u001b\u00018\u0019V\u00a3E\u00eeO6S\u0096e\u0003\u00a0|\u0006\u0004\u00a4}\u00af#$\u0099$\fJ\u0090\u00c9\u00cbA\u008c\u001e\u0080\u00ca\u0084\u0099,\u00bc\u00ee\u00ebM\u00f5\u0010\u00c7\u00f1\u00c7\u00c3\u00f5\u00fd\u00e1x\u00e9|)+b\u00cf=\u0091\u0099}x\u0097\u00d7\u001b7/\u000e\u00bb\u0080z\u00e0\u00a6\u00a7\b\u00f1\u008doD\u008b\u00b6\u00f9\u00d4}\u00120\u00fe".length();
                    var1_4 = 93;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 80;
                            break;
                        }
                        case 1: {
                            v13 = 127;
                            break;
                        }
                        case 2: {
                            v13 = 17;
                            break;
                        }
                        case 3: {
                            v13 = 47;
                            break;
                        }
                        case 4: {
                            v13 = 4;
                            break;
                        }
                        case 5: {
                            v13 = 40;
                            break;
                        }
                        default: {
                            v13 = 40;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CertStoreOCSPOps.c = var5;
        CertStoreOCSPOps.d = new String[25];
        CertStoreOCSPOps.a = LoggerFactory.getLogger(CertStoreOCSPOps.class);
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0x3023) & 0xFFFF;
        if (d[n4] == null) {
            int n5;
            int n6;
            char[] cArray = c[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 67;
                    break;
                }
                case 1: {
                    n6 = 3;
                    break;
                }
                case 2: {
                    n6 = 174;
                    break;
                }
                case 3: {
                    n6 = 102;
                    break;
                }
                case 4: {
                    n6 = 202;
                    break;
                }
                case 5: {
                    n6 = 82;
                    break;
                }
                case 6: {
                    n6 = 24;
                    break;
                }
                case 7: {
                    n6 = 149;
                    break;
                }
                case 8: {
                    n6 = 239;
                    break;
                }
                case 9: {
                    n6 = 83;
                    break;
                }
                case 10: {
                    n6 = 143;
                    break;
                }
                case 11: {
                    n6 = 30;
                    break;
                }
                case 12: {
                    n6 = 4;
                    break;
                }
                case 13: {
                    n6 = 120;
                    break;
                }
                case 14: {
                    n6 = 103;
                    break;
                }
                case 15: {
                    n6 = 133;
                    break;
                }
                case 16: {
                    n6 = 243;
                    break;
                }
                case 17: {
                    n6 = 229;
                    break;
                }
                case 18: {
                    n6 = 36;
                    break;
                }
                case 19: {
                    n6 = 56;
                    break;
                }
                case 20: {
                    n6 = 168;
                    break;
                }
                case 21: {
                    n6 = 227;
                    break;
                }
                case 22: {
                    n6 = 28;
                    break;
                }
                case 23: {
                    n6 = 178;
                    break;
                }
                case 24: {
                    n6 = 198;
                    break;
                }
                case 25: {
                    n6 = 173;
                    break;
                }
                case 26: {
                    n6 = 159;
                    break;
                }
                case 27: {
                    n6 = 74;
                    break;
                }
                case 28: {
                    n6 = 142;
                    break;
                }
                case 29: {
                    n6 = 255;
                    break;
                }
                case 30: {
                    n6 = 75;
                    break;
                }
                case 31: {
                    n6 = 33;
                    break;
                }
                case 32: {
                    n6 = 189;
                    break;
                }
                case 33: {
                    n6 = 77;
                    break;
                }
                case 34: {
                    n6 = 126;
                    break;
                }
                case 35: {
                    n6 = 130;
                    break;
                }
                case 36: {
                    n6 = 106;
                    break;
                }
                case 37: {
                    n6 = 199;
                    break;
                }
                case 38: {
                    n6 = 228;
                    break;
                }
                case 39: {
                    n6 = 181;
                    break;
                }
                case 40: {
                    n6 = 145;
                    break;
                }
                case 41: {
                    n6 = 17;
                    break;
                }
                case 42: {
                    n6 = 38;
                    break;
                }
                case 43: {
                    n6 = 57;
                    break;
                }
                case 44: {
                    n6 = 107;
                    break;
                }
                case 45: {
                    n6 = 14;
                    break;
                }
                case 46: {
                    n6 = 54;
                    break;
                }
                case 47: {
                    n6 = 197;
                    break;
                }
                case 48: {
                    n6 = 166;
                    break;
                }
                case 49: {
                    n6 = 232;
                    break;
                }
                case 50: {
                    n6 = 123;
                    break;
                }
                case 51: {
                    n6 = 140;
                    break;
                }
                case 52: {
                    n6 = 73;
                    break;
                }
                case 53: {
                    n6 = 183;
                    break;
                }
                case 54: {
                    n6 = 121;
                    break;
                }
                case 55: {
                    n6 = 70;
                    break;
                }
                case 56: {
                    n6 = 146;
                    break;
                }
                case 57: {
                    n6 = 208;
                    break;
                }
                case 58: {
                    n6 = 91;
                    break;
                }
                case 59: {
                    n6 = 153;
                    break;
                }
                case 60: {
                    n6 = 93;
                    break;
                }
                case 61: {
                    n6 = 136;
                    break;
                }
                case 62: {
                    n6 = 5;
                    break;
                }
                case 63: {
                    n6 = 25;
                    break;
                }
                case 64: {
                    n6 = 13;
                    break;
                }
                case 65: {
                    n6 = 1;
                    break;
                }
                case 66: {
                    n6 = 252;
                    break;
                }
                case 67: {
                    n6 = 201;
                    break;
                }
                case 68: {
                    n6 = 10;
                    break;
                }
                case 69: {
                    n6 = 7;
                    break;
                }
                case 70: {
                    n6 = 154;
                    break;
                }
                case 71: {
                    n6 = 115;
                    break;
                }
                case 72: {
                    n6 = 48;
                    break;
                }
                case 73: {
                    n6 = 62;
                    break;
                }
                case 74: {
                    n6 = 204;
                    break;
                }
                case 75: {
                    n6 = 98;
                    break;
                }
                case 76: {
                    n6 = 250;
                    break;
                }
                case 77: {
                    n6 = 112;
                    break;
                }
                case 78: {
                    n6 = 235;
                    break;
                }
                case 79: {
                    n6 = 59;
                    break;
                }
                case 80: {
                    n6 = 231;
                    break;
                }
                case 81: {
                    n6 = 251;
                    break;
                }
                case 82: {
                    n6 = 23;
                    break;
                }
                case 83: {
                    n6 = 124;
                    break;
                }
                case 84: {
                    n6 = 150;
                    break;
                }
                case 85: {
                    n6 = 248;
                    break;
                }
                case 86: {
                    n6 = 209;
                    break;
                }
                case 87: {
                    n6 = 244;
                    break;
                }
                case 88: {
                    n6 = 186;
                    break;
                }
                case 89: {
                    n6 = 215;
                    break;
                }
                case 90: {
                    n6 = 22;
                    break;
                }
                case 91: {
                    n6 = 137;
                    break;
                }
                case 92: {
                    n6 = 116;
                    break;
                }
                case 93: {
                    n6 = 253;
                    break;
                }
                case 94: {
                    n6 = 170;
                    break;
                }
                case 95: {
                    n6 = 88;
                    break;
                }
                case 96: {
                    n6 = 64;
                    break;
                }
                case 97: {
                    n6 = 219;
                    break;
                }
                case 98: {
                    n6 = 20;
                    break;
                }
                case 99: {
                    n6 = 15;
                    break;
                }
                case 100: {
                    n6 = 46;
                    break;
                }
                case 101: {
                    n6 = 16;
                    break;
                }
                case 102: {
                    n6 = 152;
                    break;
                }
                case 103: {
                    n6 = 176;
                    break;
                }
                case 104: {
                    n6 = 160;
                    break;
                }
                case 105: {
                    n6 = 127;
                    break;
                }
                case 106: {
                    n6 = 188;
                    break;
                }
                case 107: {
                    n6 = 141;
                    break;
                }
                case 108: {
                    n6 = 55;
                    break;
                }
                case 109: {
                    n6 = 49;
                    break;
                }
                case 110: {
                    n6 = 225;
                    break;
                }
                case 111: {
                    n6 = 45;
                    break;
                }
                case 112: {
                    n6 = 210;
                    break;
                }
                case 113: {
                    n6 = 254;
                    break;
                }
                case 114: {
                    n6 = 117;
                    break;
                }
                case 115: {
                    n6 = 51;
                    break;
                }
                case 116: {
                    n6 = 167;
                    break;
                }
                case 117: {
                    n6 = 240;
                    break;
                }
                case 118: {
                    n6 = 226;
                    break;
                }
                case 119: {
                    n6 = 196;
                    break;
                }
                case 120: {
                    n6 = 193;
                    break;
                }
                case 121: {
                    n6 = 26;
                    break;
                }
                case 122: {
                    n6 = 221;
                    break;
                }
                case 123: {
                    n6 = 185;
                    break;
                }
                case 124: {
                    n6 = 131;
                    break;
                }
                case 125: {
                    n6 = 171;
                    break;
                }
                case 126: {
                    n6 = 237;
                    break;
                }
                case 127: {
                    n6 = 118;
                    break;
                }
                case 128: {
                    n6 = 94;
                    break;
                }
                case 129: {
                    n6 = 63;
                    break;
                }
                case 130: {
                    n6 = 138;
                    break;
                }
                case 131: {
                    n6 = 27;
                    break;
                }
                case 132: {
                    n6 = 164;
                    break;
                }
                case 133: {
                    n6 = 200;
                    break;
                }
                case 134: {
                    n6 = 42;
                    break;
                }
                case 135: {
                    n6 = 44;
                    break;
                }
                case 136: {
                    n6 = 179;
                    break;
                }
                case 137: {
                    n6 = 129;
                    break;
                }
                case 138: {
                    n6 = 230;
                    break;
                }
                case 139: {
                    n6 = 207;
                    break;
                }
                case 140: {
                    n6 = 195;
                    break;
                }
                case 141: {
                    n6 = 212;
                    break;
                }
                case 142: {
                    n6 = 125;
                    break;
                }
                case 143: {
                    n6 = 163;
                    break;
                }
                case 144: {
                    n6 = 86;
                    break;
                }
                case 145: {
                    n6 = 161;
                    break;
                }
                case 146: {
                    n6 = 206;
                    break;
                }
                case 147: {
                    n6 = 92;
                    break;
                }
                case 148: {
                    n6 = 241;
                    break;
                }
                case 149: {
                    n6 = 85;
                    break;
                }
                case 150: {
                    n6 = 9;
                    break;
                }
                case 151: {
                    n6 = 151;
                    break;
                }
                case 152: {
                    n6 = 53;
                    break;
                }
                case 153: {
                    n6 = 60;
                    break;
                }
                case 154: {
                    n6 = 216;
                    break;
                }
                case 155: {
                    n6 = 35;
                    break;
                }
                case 156: {
                    n6 = 84;
                    break;
                }
                case 157: {
                    n6 = 132;
                    break;
                }
                case 158: {
                    n6 = 76;
                    break;
                }
                case 159: {
                    n6 = 99;
                    break;
                }
                case 160: {
                    n6 = 139;
                    break;
                }
                case 161: {
                    n6 = 213;
                    break;
                }
                case 162: {
                    n6 = 95;
                    break;
                }
                case 163: {
                    n6 = 81;
                    break;
                }
                case 164: {
                    n6 = 61;
                    break;
                }
                case 165: {
                    n6 = 211;
                    break;
                }
                case 166: {
                    n6 = 109;
                    break;
                }
                case 167: {
                    n6 = 135;
                    break;
                }
                case 168: {
                    n6 = 11;
                    break;
                }
                case 169: {
                    n6 = 52;
                    break;
                }
                case 170: {
                    n6 = 233;
                    break;
                }
                case 171: {
                    n6 = 119;
                    break;
                }
                case 172: {
                    n6 = 114;
                    break;
                }
                case 173: {
                    n6 = 157;
                    break;
                }
                case 174: {
                    n6 = 165;
                    break;
                }
                case 175: {
                    n6 = 187;
                    break;
                }
                case 176: {
                    n6 = 205;
                    break;
                }
                case 177: {
                    n6 = 21;
                    break;
                }
                case 178: {
                    n6 = 203;
                    break;
                }
                case 179: {
                    n6 = 47;
                    break;
                }
                case 180: {
                    n6 = 169;
                    break;
                }
                case 181: {
                    n6 = 218;
                    break;
                }
                case 182: {
                    n6 = 80;
                    break;
                }
                case 183: {
                    n6 = 182;
                    break;
                }
                case 184: {
                    n6 = 217;
                    break;
                }
                case 185: {
                    n6 = 18;
                    break;
                }
                case 186: {
                    n6 = 144;
                    break;
                }
                case 187: {
                    n6 = 147;
                    break;
                }
                case 188: {
                    n6 = 172;
                    break;
                }
                case 189: {
                    n6 = 191;
                    break;
                }
                case 190: {
                    n6 = 238;
                    break;
                }
                case 191: {
                    n6 = 72;
                    break;
                }
                case 192: {
                    n6 = 155;
                    break;
                }
                case 193: {
                    n6 = 19;
                    break;
                }
                case 194: {
                    n6 = 37;
                    break;
                }
                case 195: {
                    n6 = 214;
                    break;
                }
                case 196: {
                    n6 = 177;
                    break;
                }
                case 197: {
                    n6 = 2;
                    break;
                }
                case 198: {
                    n6 = 242;
                    break;
                }
                case 199: {
                    n6 = 32;
                    break;
                }
                case 200: {
                    n6 = 79;
                    break;
                }
                case 201: {
                    n6 = 108;
                    break;
                }
                case 202: {
                    n6 = 50;
                    break;
                }
                case 203: {
                    n6 = 29;
                    break;
                }
                case 204: {
                    n6 = 224;
                    break;
                }
                case 205: {
                    n6 = 31;
                    break;
                }
                case 206: {
                    n6 = 97;
                    break;
                }
                case 207: {
                    n6 = 40;
                    break;
                }
                case 208: {
                    n6 = 158;
                    break;
                }
                case 209: {
                    n6 = 110;
                    break;
                }
                case 210: {
                    n6 = 162;
                    break;
                }
                case 211: {
                    n6 = 236;
                    break;
                }
                case 212: {
                    n6 = 223;
                    break;
                }
                case 213: {
                    n6 = 134;
                    break;
                }
                case 214: {
                    n6 = 65;
                    break;
                }
                case 215: {
                    n6 = 66;
                    break;
                }
                case 216: {
                    n6 = 89;
                    break;
                }
                case 217: {
                    n6 = 69;
                    break;
                }
                case 218: {
                    n6 = 113;
                    break;
                }
                case 219: {
                    n6 = 0;
                    break;
                }
                case 220: {
                    n6 = 245;
                    break;
                }
                case 221: {
                    n6 = 249;
                    break;
                }
                case 222: {
                    n6 = 100;
                    break;
                }
                case 223: {
                    n6 = 192;
                    break;
                }
                case 224: {
                    n6 = 87;
                    break;
                }
                case 225: {
                    n6 = 58;
                    break;
                }
                case 226: {
                    n6 = 41;
                    break;
                }
                case 227: {
                    n6 = 71;
                    break;
                }
                case 228: {
                    n6 = 194;
                    break;
                }
                case 229: {
                    n6 = 148;
                    break;
                }
                case 230: {
                    n6 = 247;
                    break;
                }
                case 231: {
                    n6 = 180;
                    break;
                }
                case 232: {
                    n6 = 128;
                    break;
                }
                case 233: {
                    n6 = 101;
                    break;
                }
                case 234: {
                    n6 = 68;
                    break;
                }
                case 235: {
                    n6 = 246;
                    break;
                }
                case 236: {
                    n6 = 190;
                    break;
                }
                case 237: {
                    n6 = 90;
                    break;
                }
                case 238: {
                    n6 = 184;
                    break;
                }
                case 239: {
                    n6 = 34;
                    break;
                }
                case 240: {
                    n6 = 39;
                    break;
                }
                case 241: {
                    n6 = 8;
                    break;
                }
                case 242: {
                    n6 = 222;
                    break;
                }
                case 243: {
                    n6 = 12;
                    break;
                }
                case 244: {
                    n6 = 220;
                    break;
                }
                case 245: {
                    n6 = 6;
                    break;
                }
                case 246: {
                    n6 = 175;
                    break;
                }
                case 247: {
                    n6 = 111;
                    break;
                }
                case 248: {
                    n6 = 43;
                    break;
                }
                case 249: {
                    n6 = 234;
                    break;
                }
                case 250: {
                    n6 = 78;
                    break;
                }
                case 251: {
                    n6 = 122;
                    break;
                }
                case 252: {
                    n6 = 104;
                    break;
                }
                case 253: {
                    n6 = 156;
                    break;
                }
                case 254: {
                    n6 = 96;
                    break;
                }
                default: {
                    n6 = 105;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            CertStoreOCSPOps.d[n4] = new String(cArray).intern();
        }
        return d[n4];
    }
}

