/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Type;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.GuvenlikSeviyesi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzetTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzneTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.SertifikaTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoKokSertifika;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOzet;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSilinecekKokSertifika;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.CertificateSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.KeyUsageSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.util.RsItemSource;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNEklenecekKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNImza;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNImzalar;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNKokSertifikalar;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNRawImza;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNSilinecekKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.x509.Certificate;

public class CertStoreRootCertificateOps {
    private static Logger a;
    private final CertStore b;
    public static boolean c;
    private static final String[] d;
    private static final String[] e;

    public CertStoreRootCertificateOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(CertStoreRootCertificateOps.a(-15142, -2650));
            throw new ESYARuntimeException(CertStoreRootCertificateOps.a(-15139, -8050) + lE.getMessage());
        }
        this.b = aDepo;
    }

    public void deleteRootCertificate(long aKokNo) throws CertStoreException {
        if (aKokNo <= 0L) {
            throw new CertStoreException(CertStoreRootCertificateOps.a(-15143, 26187));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.kokSertifikaSil(aKokNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aKokNo + CertStoreRootCertificateOps.a(-15136, -23973), certStoreException);
        }
    }

    public byte[] createRootCertificatesTobeSigned(List<Certificate> aEklenecekList, List<SertifikaTipi> aTipler, List<GuvenlikSeviyesi> aSeviyeler, List<Certificate> aSilinecekList) throws CertStoreException, Asn1Exception {
        byte[] byArray;
        block13: {
            boolean bl;
            block15: {
                block14: {
                    Asn1Type asn1Type;
                    int n2;
                    int n3;
                    boolean bl2;
                    int n4;
                    block12: {
                        n4 = 0;
                        bl2 = c;
                        int n5 = 0;
                        int n6 = 0;
                        n3 = 0;
                        if (aEklenecekList != null) {
                            n4 = aEklenecekList.size();
                            n5 = aTipler.size();
                            n6 = aSeviyeler.size();
                        }
                        if (aSilinecekList != null) {
                            n3 = aSilinecekList.size();
                        }
                        if (n4 == n5 && n5 == n6) break block12;
                        throw new CertStoreException(CertStoreRootCertificateOps.a(-15168, 15762));
                    }
                    DepoASNKokSertifikalar depoASNKokSertifikalar = new DepoASNKokSertifikalar();
                    depoASNKokSertifikalar.elements = new DepoASNKokSertifika[n4 + n3];
                    for (n2 = 0; n2 < n4; ++n2) {
                        DepoASNKokSertifika depoASNKokSertifika = new DepoASNKokSertifika();
                        asn1Type = CertStoreUtil.asnCertTOAsnEklenecek(aEklenecekList.get(n2), aTipler.get(n2), aSeviyeler.get(n2));
                        depoASNKokSertifika.set_eklenecekSertifika((DepoASNEklenecekKokSertifika)asn1Type);
                        depoASNKokSertifikalar.elements[n2] = depoASNKokSertifika;
                        if (!bl2) continue;
                    }
                    for (int i2 = 0; i2 < n3; ++i2) {
                        asn1Type = new DepoASNKokSertifika();
                        DepoASNSilinecekKokSertifika depoASNSilinecekKokSertifika = CertStoreUtil.asnCertTOAsnSilinecek(aSilinecekList.get(i2));
                        asn1Type.set_silinecekSertifika(depoASNSilinecekKokSertifika);
                        depoASNKokSertifikalar.elements[n2] = asn1Type;
                        ++n2;
                        if (!bl2) continue;
                    }
                    Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                    depoASNKokSertifikalar.encode(asn1DerEncodeBuffer);
                    byArray = asn1DerEncodeBuffer.getMsgCopy();
                    if (CertStoreException.b == 0) break block13;
                    if (!bl2) break block14;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
            c = bl;
        }
        return byArray;
    }

    public void addPersonalRootCertificate(Certificate aCert, SertifikaTipi aTip) throws CertStoreException {
        DepoKokSertifika depoKokSertifika = CertStoreUtil.asnCertTODepoEklenecek(aCert);
        depoKokSertifika.setKokTipi(aTip);
        depoKokSertifika.setKokGuvenSeviyesi(GuvenlikSeviyesi.PERSONAL);
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            List<DepoOzet> list = CertStoreUtil.convertToDepoOzet(depoKokSertifika.getValue(), OzneTipi.KOK_SERTIFIKA);
            depoVEN.kokSertifikaYaz(depoKokSertifika, list);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(CertStoreRootCertificateOps.a(-15166, 24054), certStoreException);
        }
    }

    public boolean verifySignature(DepoKokSertifika aKok) throws CertStoreException {
        boolean bl = CertStoreUtil.verifyDepoKokSertifika(aKok);
        if (!bl) {
            this.deleteRootCertificate(aKok.getKokSertifikaNo());
        }
        return bl;
    }

    public List<DepoKokSertifika> listStoreRootCertificates() throws CertStoreException {
        return this.listStoreRootCertificates(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoKokSertifika> listStoreRootCertificates(String hash) throws CertStoreException {
        boolean bl = c;
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            List list = ((RsItemSource)depoVEN.kokSertifikaListele()).toList();
            ArrayList<DepoKokSertifika> arrayList = new ArrayList<DepoKokSertifika>();
            for (DepoKokSertifika depoKokSertifika : list) {
                block9: {
                    try {
                        boolean bl2 = CertStoreUtil.verifyDepoKokSertifika(depoKokSertifika, hash);
                        if (bl2) {
                            arrayList.add(depoKokSertifika);
                            if (!bl) break block9;
                        }
                        depoVEN.kokSertifikaSil(depoKokSertifika.getKokSertifikaNo());
                    }
                    catch (Exception exception) {
                        a.error(CertStoreRootCertificateOps.a(-15155, -6725), exception);
                    }
                }
                if (!bl) continue;
            }
            JDBCUtil.commit(this.b.getConn());
            return arrayList;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreRootCertificateOps.a(-15130, 9349), certStoreException);
        }
    }

    public List<DepoKokSertifika> listStoreRootCertificates(CertificateSearchTemplate aSAS, SertifikaTipi[] aTipler, GuvenlikSeviyesi[] aSeviyeler) throws CertStoreException {
        return this.listStoreRootCertificates(aSAS, aTipler, aSeviyeler, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoKokSertifika> listStoreRootCertificates(CertificateSearchTemplate aSAS, SertifikaTipi[] aTipler, GuvenlikSeviyesi[] aSeviyeler, String hash) throws CertStoreException {
        boolean bl = c;
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSAS, aTipler, aSeviyeler);
            String string = pair.first();
            List<Object> list = pair.second();
            List list2 = ((RsItemSource)depoVEN.kokSertifikaListele(string, list.toArray())).toList();
            ArrayList<DepoKokSertifika> arrayList = new ArrayList<DepoKokSertifika>();
            for (DepoKokSertifika depoKokSertifika : list2) {
                block9: {
                    try {
                        boolean bl2 = CertStoreUtil.verifyDepoKokSertifika(depoKokSertifika, hash);
                        if (bl2) {
                            arrayList.add(depoKokSertifika);
                            if (!bl) break block9;
                        }
                        depoVEN.kokSertifikaSil(depoKokSertifika.getKokSertifikaNo());
                    }
                    catch (Exception exception) {
                        a.error(CertStoreRootCertificateOps.a(-15148, -25556), exception);
                    }
                }
                if (!bl) continue;
            }
            JDBCUtil.commit(this.b.getConn());
            return arrayList;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreRootCertificateOps.a(-15131, 28427), certStoreException);
        }
    }

    public void addSignedRootCertificates(byte[] aImzaliKokSertifikalar) throws CertStoreException {
        boolean bl = c;
        try {
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(aImzaliKokSertifikalar);
            DepoASNImzalar depoASNImzalar = new DepoASNImzalar();
            depoASNImzalar.decode(asn1DerDecodeBuffer);
            DepoASNImza[] depoASNImzaArray = depoASNImzalar.elements;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            for (DepoASNImza depoASNImza : depoASNImzaArray) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                int n2;
                DepoASNKokSertifika depoASNKokSertifika;
                block23: {
                    byte[] byArray = null;
                    depoASNKokSertifika = depoASNImza.imzalanan;
                    n2 = depoASNKokSertifika.getChoiceID();
                    DepoASNRawImza depoASNRawImza = depoASNImza.imza;
                    object6 = new Asn1DerEncodeBuffer();
                    depoASNRawImza.encode((Asn1BerEncodeBuffer)object6);
                    object5 = ((Asn1BerEncodeBuffer)object6).getMsgCopy();
                    object4 = new Asn1DerEncodeBuffer();
                    depoASNKokSertifika.encode((Asn1BerEncodeBuffer)object4);
                    byArray = ((Asn1BerEncodeBuffer)object4).getMsgCopy();
                    boolean bl2 = false;
                    try {
                        bl2 = CertStoreUtil.verifyEncodedRootCertificate(byArray, depoASNRawImza);
                    }
                    catch (Exception exception) {
                        a.error(CertStoreRootCertificateOps.a(-15164, -1695), exception);
                        if (!bl) continue;
                    }
                    if (bl2) break block23;
                    try {
                        object3 = null;
                        if (n2 == 1) {
                            object2 = (DepoASNEklenecekKokSertifika)depoASNKokSertifika.getElement();
                            object3 = ((DepoASNEklenecekKokSertifika)object2).kokSertifikaValue.value;
                        } else if (n2 == 2) {
                            object2 = (DepoASNSilinecekKokSertifika)depoASNKokSertifika.getElement();
                            object3 = ((DepoASNSilinecekKokSertifika)object2).kokSertifikaValue.value;
                        }
                        object2 = new ECertificate((byte[])object3);
                        object = ((ECertificate)object2).getSerialNumberHex();
                        String string = ((ECertificate)object2).getSubject().stringValue();
                        a.error(CertStoreRootCertificateOps.a(-15157, 929) + (String)object + CertStoreRootCertificateOps.a(-15144, 27442) + string + CertStoreRootCertificateOps.a(-15159, -8828));
                        continue;
                    }
                    catch (Exception exception) {
                        a.error(CertStoreRootCertificateOps.a(-15147, -27288), exception);
                        if (!bl) continue;
                    }
                }
                try {
                    if (n2 == 1) {
                        object3 = (DepoASNEklenecekKokSertifika)depoASNKokSertifika.getElement();
                        object2 = CertStoreUtil.asnEklenecekTODepoKok((DepoASNEklenecekKokSertifika)object3);
                        ((DepoKokSertifika)object2).setSatirImzasi((byte[])object5);
                        object = CertStoreUtil.convertToDepoOzet(((DepoKokSertifika)object2).getValue(), OzneTipi.KOK_SERTIFIKA);
                        depoVEN.kokSertifikaYaz((DepoKokSertifika)object2, (List<DepoOzet>)object);
                    }
                    if (n2 != 2) continue;
                    object3 = (DepoASNSilinecekKokSertifika)depoASNKokSertifika.getElement();
                    object2 = CertStoreUtil.asnSilinecekToDepoSilinecek((DepoASNSilinecekKokSertifika)object3);
                    ((DepoSilinecekKokSertifika)object2).setSatirImzasi((byte[])object5);
                    depoVEN.silinecekKokSertifikaYaz((DepoSilinecekKokSertifika)object2);
                    continue;
                }
                catch (Exception exception) {
                    try {
                        object6 = null;
                        if (n2 == 1) {
                            object5 = (DepoASNEklenecekKokSertifika)depoASNKokSertifika.getElement();
                            object6 = ((DepoASNEklenecekKokSertifika)object5).kokSertifikaValue.value;
                        } else if (n2 == 2) {
                            object5 = (DepoASNSilinecekKokSertifika)depoASNKokSertifika.getElement();
                            object6 = ((DepoASNSilinecekKokSertifika)object5).kokSertifikaValue.value;
                        }
                        object5 = new ECertificate((byte[])object6);
                        object4 = ((ECertificate)object5).getSerialNumberHex();
                        String string = ((ECertificate)object5).getSubject().stringValue();
                        a.error(CertStoreRootCertificateOps.a(-15160, 7890) + (String)object4 + CertStoreRootCertificateOps.a(-15156, -32059) + string + CertStoreRootCertificateOps.a(-15153, 17846), exception);
                        continue;
                    }
                    catch (Exception exception2) {
                        a.error(CertStoreRootCertificateOps.a(-15137, -32051), exception2);
                    }
                }
                if (!bl) continue;
            }
            JDBCUtil.commit(this.b.getConn());
        }
        catch (Exception exception) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            a.error(CertStoreRootCertificateOps.a(-15165, 29111), exception);
            throw new CertStoreException(CertStoreRootCertificateOps.a(-15154, -30588), exception);
        }
    }

    private Pair<String, List<Object>> a(CertificateSearchTemplate certificateSearchTemplate, SertifikaTipi[] sertifikaTipiArray, GuvenlikSeviyesi[] guvenlikSeviyesiArray) {
        ArrayList<Object> arrayList;
        StringBuffer stringBuffer;
        block39: {
            boolean bl;
            block38: {
                stringBuffer = new StringBuffer("");
                arrayList = new ArrayList<Object>();
                bl = c;
                stringBuffer.append(CertStoreRootCertificateOps.a(-15161, 11643));
                if (certificateSearchTemplate != null) {
                    block37: {
                        OzetTipi ozetTipi;
                        block35: {
                            block36: {
                                byte[] byArray = certificateSearchTemplate.getValue();
                                if (byArray != null) {
                                    stringBuffer.append(CertStoreRootCertificateOps.a(-15129, 7425));
                                    arrayList.add(byArray);
                                }
                                byte[] byArray2 = certificateSearchTemplate.getHash();
                                ozetTipi = certificateSearchTemplate.getHashType();
                                if (byArray2 == null) break block35;
                                stringBuffer.append(CertStoreRootCertificateOps.a(-15132, 8266));
                                arrayList.add(OzneTipi.KOK_SERTIFIKA.getIntValue());
                                arrayList.add(byArray2);
                                if (ozetTipi == null) break block36;
                                stringBuffer.append(CertStoreRootCertificateOps.a(-15133, 535));
                                arrayList.add(ozetTipi.getIntValue());
                                if (!bl) break block37;
                            }
                            stringBuffer.append(CertStoreRootCertificateOps.a(-15151, -24235));
                            if (!bl) break block37;
                        }
                        if (ozetTipi == null) break block37;
                        stringBuffer.append(CertStoreRootCertificateOps.a(-15150, 7223));
                        arrayList.add(OzneTipi.KOK_SERTIFIKA.getIntValue());
                        arrayList.add(ozetTipi.getIntValue());
                    }
                    byte[] byArray = certificateSearchTemplate.getIssuer();
                    if (byArray != null) {
                        stringBuffer.append(CertStoreRootCertificateOps.a(-15167, -26319));
                        arrayList.add(byArray);
                    }
                    byte[] byArray3 = certificateSearchTemplate.getSubject();
                    if (byArray3 != null) {
                        stringBuffer.append(CertStoreRootCertificateOps.a(-15149, 266));
                        arrayList.add(byArray3);
                    }
                    byte[] byArray4 = certificateSearchTemplate.getSerialNumber();
                    if (byArray4 != null) {
                        stringBuffer.append(CertStoreRootCertificateOps.a(-15140, 13157));
                        arrayList.add(byArray4);
                    }
                    byte[] byArray5 = certificateSearchTemplate.getSubjectKeyID();
                    if (byArray5 != null) {
                        stringBuffer.append(CertStoreRootCertificateOps.a(-15152, -13592));
                        arrayList.add(byArray5);
                    }
                    KeyUsageSearchTemplate keyUsageSearchTemplate = certificateSearchTemplate.getAnahtarKullanim();
                    if (keyUsageSearchTemplate != null) {
                        stringBuffer.append(CertStoreRootCertificateOps.a(-15145, -9911));
                        arrayList.add(keyUsageSearchTemplate.sorguOlustur());
                    }
                }
                if (sertifikaTipiArray == null || sertifikaTipiArray.length == 0) break block38;
                stringBuffer.append(CertStoreRootCertificateOps.a(-15162, 26266));
                stringBuffer.append(CertStoreRootCertificateOps.a(-15134, 29103));
                for (int i2 = 0; i2 < sertifikaTipiArray.length - 1; ++i2) {
                    stringBuffer.append(sertifikaTipiArray[i2].getIntValue() + CertStoreRootCertificateOps.a(-15135, -26079));
                    if (!bl) continue;
                }
                stringBuffer.append(sertifikaTipiArray[sertifikaTipiArray.length - 1].getIntValue() + CertStoreRootCertificateOps.a(-15146, -8712));
            }
            if (guvenlikSeviyesiArray == null || guvenlikSeviyesiArray.length == 0) break block39;
            stringBuffer.append(CertStoreRootCertificateOps.a(-15138, -4369));
            stringBuffer.append(CertStoreRootCertificateOps.a(-15141, -818));
            for (int i3 = 0; i3 < guvenlikSeviyesiArray.length - 1; ++i3) {
                stringBuffer.append(guvenlikSeviyesiArray[i3].getIntValue() + CertStoreRootCertificateOps.a(-15163, 10145));
                if (!bl) continue;
            }
            stringBuffer.append(guvenlikSeviyesiArray[guvenlikSeviyesiArray.length - 1].getIntValue() + CertStoreRootCertificateOps.a(-15158, -26683));
        }
        return new Pair<String, List<Object>>(stringBuffer.toString(), arrayList);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[40];
                var3_1 = 0;
                var2_2 = "\u009a$W\u0005\u00c3\u00ae0\u00f1\u0084\u0003<\u00ca\u00a18\u00d9\u0005\u0003\b\u001c\u00059\u0083\u00e4\u00c9n`\u00df[{\u00c7k\u00de\u0003\u0096\u00b9\u00a4\u00fe\u00d9kK\u00d1?\u00f8JWl\\\u0084\u00ad\u0015PANQ\u00c4M\u00bbj\u00da\u00b4\u0080\u00e6\u00d1P\u009e\u00e6\u00f6]\u00da\u0016a\u00f6X\u00e6\u00a3\u00a0p\u00ae\"\u0016\u000bi1L27\u009bXW\u00ef\u00ef\u00ec\u00d2\u0086\u0015\u0093\u00c6\u0098\u0003X\u00cd\u00b1\u009cS\u0097\u00dc\u00d4\u0090\u0094T\u008e\u00cd\"\u009e\u009c\u00dc\t\u0091X!\u00e1g[\u00f4bd\u0015\u00c7\u00ddH\u001dDWqc\u00a4j\u008fM^\u00bf=\u000f9_U\u00e3\u00a9\u00f3\u0018\u00f9\u0099\u00ba\u000f\u000f\u00a3\u0090\u00f6\u0007\u00de\u0088\u0084\u009d=Q\u0082k\u0013J\u00ce\u00c3\u00b2\u00a0\u0010\u007f\u00c4\u00b9\u008c8Y\u0007-\u00af\u00e3QzzG\u00fc\u00bc\u00c5ws\u0012;\u00de\u00aa\u009d\u00cc\u00bd\u0019\u00b6>\u0086\u008c\u00af!Si\u009e\u00d4Z\u0010M\u0019\u00a9\u008c#g\u009cr-<\u00ad\u0084:\u00bd\u00c0-\u009d\u0099\u00ebq\f\u00ac\u0094\u0095\u00fa\u00ed\u00d3\u0015\u0092m\u0017\u000b\u0092)v\u00a7i\u00e4G\u00fb\u009be>\u00f4\u0015\u001aw\u008b\u00cf\u00b4-\u00e9\u0003\u00b1A\u00d4\u00179\u0088\u008d\u009d\n\u001c\u00adH\u00c9mvk\u0098y\u001c\u00e7\u0083\u00b6'F\u0001\u00bfn\u00ff\u008c\u00e0]\u00d9\u001b\u0002>\u00ba\u0017\u001f=6\u008cT*bb\u00d8KOo\u00f6\u0015\u00f6b\u0013\u00c5\u00ec\u00f5\u009a\u00f6\u009c\u000b\u00c8\u00fb\u00fb\u0088X\u0003$\f\u008c\u00f2\u00e7\u00ca\u0097fL'8,\r\u00ee\u00b7|\u000b\u00ec\u0007\u0005\u0095G\u009c\u00a1\u0094\u001b\u009f\f-\u00e1\u00a2\u00b2\u0093\u00df\u00f6 \u001bay\u0019\u0017\u008b\u009eui\u0082\u00ee\u001fv\u00b3\u00afbK\u0091\u00d7\u0016\u001e\u00c7\u00d2\u00d7A\u00b5k\u00d2\u0087\u0081\u00bb\u009d\u00cd\u0096\u00dc\u00d6-\u00fc\u00ae\u0091\u0093.56\u0081\u001e?Y\u00edR\u00ae\u00a0\u0096s\u00cag\u00a3\u00b5?\u00c9W\u009f\u00a7\u0007\ri++~e`\u00ba\u00fa\u00af\u00c1KJaJ\u00a3d\u00f3\u0016\u00fb\u00fe'\u009d\u00951\u00a7&\u009c\u009b\u001f\u00de\u0001\u00fea\u009c\u001e@\u001ech<l\u00933\u00af\u00d8\u00d1\u00ff?\u00a2\u00cd\u0097\u0014\u000bY\u0011\u00ea\u00ad\u00f93\u001a\u008bFO\u00daM\u000b\u00bdm\u00d4\u00cb\u001fE\u00b2\u00e0\u0011\u00c9\u00ea\u0010\u00de\u00d8\u00e3\u00b3\u0000r\u00baM\u00944`\u00df\u001e\u00acFp\u0002\u00f1\u00ce'\u00fd\t\u00ccW\r\u0081\u009e\u008e8`\u00cf\u0006\u0092\u00d6\u00f3'\u001d\u0082;%\u0080\u008aYV\u0004\u00c6\u00eb,\u008e\u00f3\u00a3\u00cd\u00de\u00b5n\u0099\u00e15\u00f3\u0010Bzp\u00e7r\u00f8\u00f4\u001c]\u001eY\u009a9\u0004\u00a2e\u001a\u0015\u00c4\u00ea\u00bc\u00df0\u00ebl\u0018\u00e8Q\u00a4/q\u009c\u008eieCVc\u00a4j\u0093F\u0085\u0002fBV\u0002Yx\u0083st\u00d4\u00adY\f\u00d9\u00d8)L\u00a5%\u00b0\u0082x\u001d\u00d6\u00d5\u0013\u00f7\u00d6\u008ef\u0087\u000e]\u0089\u008e\u0087\u00d8\u00d6\u009e?0\u00a3\u007fy\u0088\f\u00d2,\u00a3^\u0004\n\f\u00e5m\u0099,78\u00f2\u00017\u0094\u0096.\u0084\u0007=\u00e4\u0081\u00f4R\u00c6\u00c1\u00b7;l\u00e2\u00b1\u0002}\u00ec\u0002\u00b1\u00ab2\u00b7nZ\u001e\u001e\u00ea\u00a8\u00f6E\u00bf\u00bcIJ\u0097m\u0016\u00a8\u009f?0J\u00ff\u0092\u008f\u0093~\u00d6I\u00ff\u00c4\u00fa\u00a6Mp\u0017Rd\u0002\u00a8\u00c2\u00b2H<t\u00f2\u00dc\u00ca\u00f0f\u00a0\u0005\u00adC\u00b8\u00a8\u0098\u0012>\\OQ\u00a1\u000e\u00b6f\u00c6\u00a6\u00a5\u00b1\u00f6\u00ae\u00ab2[\u000fl\u00a0\u008a\u0093\u00e1\u001b\u00f4\u00ee\u00e0\u0090I\u00c1\u00ac\t\u00bc\u00b9\u00f4\u00db\u00ae<\u00e0\u00e4\u0080\u001e\u00f4\u00ce\\\u0004/%\u00a5\u0096\u00ee\u00c8CW\u0099\u00dc\u00bb\u00d8\u00b1\u0097v\u00bd'\u00dc\u00db%\u00a8\u0005\u00b2\u00b6(Y\u0002\u0006fP\u0083\u0007\u00acgX\u00fc'\u00f3\u00d8\u00ab+\u00a3\u00b3y\u00f6\u000bTo\u0003\u00e0e3 \u00be}\u009f\u008bq\u00d6>\u00b0\u00bac\u0005\u00f8\u00cb \u00c7\u00c8EK\r{\u00df\u00ea\u00ce\u00b5L\u00bef\u009a&\u00da\u00e2\u00f7S`\u00cf4Q\u00fa.\u00e5\u00e6\u007fe\u001d\u00f5\u00b1\u00e9\u00b6\u0091\u00d2\u00144\u00cf_\u008f\"\u00bc\u00f0\u00e7\u00a2\u00aa\u0096\u00f8\u009a:\u00e5N\u009aL\u00b6j\u00924_\u00e1\u00c9\u00fb\u00be\u0015}.\u001ajo\u00cf\"\u00cb\u00eaI\u00e3\u00f4\u00c2\u00ba\u00bcR\u00caf\u009c\u00ac\u00b98\u00f0]\u008e\u0083\u00ef\\\u0090\u008f\u00e6\u00d7\u009a\u00fc\u00e3\u0091x\u0005\u00af\u008f\u00bd\u00d55\u001b\u0005\u00b64\u00fa\u00d0A\u00e2]\u009f\u00e1\f\u00c842r\u000f\u00d5\u00ad\u00c2\u00b9L\u0010N\r\u00a7\u00ee\u00c1\u0019\t\u00fai{\u00af\u00c8\u00e5s\u00c1\u000bz\u00e42\u00cfF\u00e5\u0000\f\u0080\u00fd\u0082\u00bd\u00dc0\u0096\u0015\u00fe\u00e8\u0094\u00f5\u00e0G\u00d9=)Cc\u00ed\u008d\u00e7\u0097\u00d4\u00ed\u009e\u00f2\u00b3\u008a\u001a\u00f7#jH\u001b\u0017\u009b\u0097\u00b0\u00b8\u00e9\u00e3\u0088W\u00e5\u00a3'8\u009c\u000b\u0087F7\u00c7\u0088\u00b7*\u00f9\u00f7\u00e9P`\u00a9\u00f7V6H\u008e\u00bfQ\u0090]\u009e\u00db\u009f\u00d8\u00be\u00a1\u0085\u00eb<IY`\u0018\u00e0\u000b\u0095\u0005\u00eb\u00cbA\u008d\u00f2,\u0095,\u00b6d\u000b^\u0084\u00a8\u00f6\u0090\u00e2C\u0014/W-\u001b\u00d1\fr\u00a5\u00cc\u0013\u0089\bLd\u00cb\u0014\fe\u00af\u00e5\u00f2\u00e5Wl\u00a9\nF\u0097\u00c5r\u009c3\u00a2\u00a4\u00c5f6\u00a7\u00d0\u0006\u00f1\u008d\u008a\u00c1\u00edn\u007f`\u00a7)BhcCvz\u00bf\u00fc{k\u00cc4\u0094\u00d6\u00df\u0013u\u0011\u009a\u00b6\u001f\u00e2\u00ef\u00ae\u00da`RM\u0098\u001b\u00c7\b\u00a49\u00df\u00d1\u0082\u00124\u00ed\u001e=a\u00ce\u00dc\u001b\u00a7\u00ba\u00bc\u00b2D<\u00c2\u001av\u00dckxA\f)\u00b7\u00b4N\u00ccV\u0010e\u00d9~\u009c\u00b4\u00f2Z\u008b@\u00ce6\u00be\u00de\u00der\u0084p3d\u0098;\u009ctD[\u00d5\u00ce\u00f2\u00fd\u00dc\u0018\u008bi\fH\u00c3\u0091\r\u00d5\u008f\u00f3\u00f6?\u00d9`\u008be\u00b9!Ii|\u00fe\n\u00eehEnD\u00fd\u00cf\u008a\u009a\u00cd\u00d1]7i;\u0089\u00c2qjtW\u0010\u00a4\u00f3\u00a2\u00f6\u0017\u0018nC\u0082\u0081;\u000f\u00d92\u009a\u00e1EB'O\u00c9\u00cf\u00a9\u00b68\n\u0080\u008c\u0000\u00bdn\u0093FI\u00c4\u00f0e?)\u0098\u0014uA\u00e6\f^%\u00f5\u0095\u0013\u00d9w\u00b0\u00fd3H\u00ea\u008eP\u0005'\u0015\u008a\u0088\u001a\u00ed!\u00d6\u00e2\u008cH\u009e\u00c1\u00d3J%\u00e4\u0001\u00e0$S\u00e4\u00be";
                var4_3 = "\u009a$W\u0005\u00c3\u00ae0\u00f1\u0084\u0003<\u00ca\u00a18\u00d9\u0005\u0003\b\u001c\u00059\u0083\u00e4\u00c9n`\u00df[{\u00c7k\u00de\u0003\u0096\u00b9\u00a4\u00fe\u00d9kK\u00d1?\u00f8JWl\\\u0084\u00ad\u0015PANQ\u00c4M\u00bbj\u00da\u00b4\u0080\u00e6\u00d1P\u009e\u00e6\u00f6]\u00da\u0016a\u00f6X\u00e6\u00a3\u00a0p\u00ae\"\u0016\u000bi1L27\u009bXW\u00ef\u00ef\u00ec\u00d2\u0086\u0015\u0093\u00c6\u0098\u0003X\u00cd\u00b1\u009cS\u0097\u00dc\u00d4\u0090\u0094T\u008e\u00cd\"\u009e\u009c\u00dc\t\u0091X!\u00e1g[\u00f4bd\u0015\u00c7\u00ddH\u001dDWqc\u00a4j\u008fM^\u00bf=\u000f9_U\u00e3\u00a9\u00f3\u0018\u00f9\u0099\u00ba\u000f\u000f\u00a3\u0090\u00f6\u0007\u00de\u0088\u0084\u009d=Q\u0082k\u0013J\u00ce\u00c3\u00b2\u00a0\u0010\u007f\u00c4\u00b9\u008c8Y\u0007-\u00af\u00e3QzzG\u00fc\u00bc\u00c5ws\u0012;\u00de\u00aa\u009d\u00cc\u00bd\u0019\u00b6>\u0086\u008c\u00af!Si\u009e\u00d4Z\u0010M\u0019\u00a9\u008c#g\u009cr-<\u00ad\u0084:\u00bd\u00c0-\u009d\u0099\u00ebq\f\u00ac\u0094\u0095\u00fa\u00ed\u00d3\u0015\u0092m\u0017\u000b\u0092)v\u00a7i\u00e4G\u00fb\u009be>\u00f4\u0015\u001aw\u008b\u00cf\u00b4-\u00e9\u0003\u00b1A\u00d4\u00179\u0088\u008d\u009d\n\u001c\u00adH\u00c9mvk\u0098y\u001c\u00e7\u0083\u00b6'F\u0001\u00bfn\u00ff\u008c\u00e0]\u00d9\u001b\u0002>\u00ba\u0017\u001f=6\u008cT*bb\u00d8KOo\u00f6\u0015\u00f6b\u0013\u00c5\u00ec\u00f5\u009a\u00f6\u009c\u000b\u00c8\u00fb\u00fb\u0088X\u0003$\f\u008c\u00f2\u00e7\u00ca\u0097fL'8,\r\u00ee\u00b7|\u000b\u00ec\u0007\u0005\u0095G\u009c\u00a1\u0094\u001b\u009f\f-\u00e1\u00a2\u00b2\u0093\u00df\u00f6 \u001bay\u0019\u0017\u008b\u009eui\u0082\u00ee\u001fv\u00b3\u00afbK\u0091\u00d7\u0016\u001e\u00c7\u00d2\u00d7A\u00b5k\u00d2\u0087\u0081\u00bb\u009d\u00cd\u0096\u00dc\u00d6-\u00fc\u00ae\u0091\u0093.56\u0081\u001e?Y\u00edR\u00ae\u00a0\u0096s\u00cag\u00a3\u00b5?\u00c9W\u009f\u00a7\u0007\ri++~e`\u00ba\u00fa\u00af\u00c1KJaJ\u00a3d\u00f3\u0016\u00fb\u00fe'\u009d\u00951\u00a7&\u009c\u009b\u001f\u00de\u0001\u00fea\u009c\u001e@\u001ech<l\u00933\u00af\u00d8\u00d1\u00ff?\u00a2\u00cd\u0097\u0014\u000bY\u0011\u00ea\u00ad\u00f93\u001a\u008bFO\u00daM\u000b\u00bdm\u00d4\u00cb\u001fE\u00b2\u00e0\u0011\u00c9\u00ea\u0010\u00de\u00d8\u00e3\u00b3\u0000r\u00baM\u00944`\u00df\u001e\u00acFp\u0002\u00f1\u00ce'\u00fd\t\u00ccW\r\u0081\u009e\u008e8`\u00cf\u0006\u0092\u00d6\u00f3'\u001d\u0082;%\u0080\u008aYV\u0004\u00c6\u00eb,\u008e\u00f3\u00a3\u00cd\u00de\u00b5n\u0099\u00e15\u00f3\u0010Bzp\u00e7r\u00f8\u00f4\u001c]\u001eY\u009a9\u0004\u00a2e\u001a\u0015\u00c4\u00ea\u00bc\u00df0\u00ebl\u0018\u00e8Q\u00a4/q\u009c\u008eieCVc\u00a4j\u0093F\u0085\u0002fBV\u0002Yx\u0083st\u00d4\u00adY\f\u00d9\u00d8)L\u00a5%\u00b0\u0082x\u001d\u00d6\u00d5\u0013\u00f7\u00d6\u008ef\u0087\u000e]\u0089\u008e\u0087\u00d8\u00d6\u009e?0\u00a3\u007fy\u0088\f\u00d2,\u00a3^\u0004\n\f\u00e5m\u0099,78\u00f2\u00017\u0094\u0096.\u0084\u0007=\u00e4\u0081\u00f4R\u00c6\u00c1\u00b7;l\u00e2\u00b1\u0002}\u00ec\u0002\u00b1\u00ab2\u00b7nZ\u001e\u001e\u00ea\u00a8\u00f6E\u00bf\u00bcIJ\u0097m\u0016\u00a8\u009f?0J\u00ff\u0092\u008f\u0093~\u00d6I\u00ff\u00c4\u00fa\u00a6Mp\u0017Rd\u0002\u00a8\u00c2\u00b2H<t\u00f2\u00dc\u00ca\u00f0f\u00a0\u0005\u00adC\u00b8\u00a8\u0098\u0012>\\OQ\u00a1\u000e\u00b6f\u00c6\u00a6\u00a5\u00b1\u00f6\u00ae\u00ab2[\u000fl\u00a0\u008a\u0093\u00e1\u001b\u00f4\u00ee\u00e0\u0090I\u00c1\u00ac\t\u00bc\u00b9\u00f4\u00db\u00ae<\u00e0\u00e4\u0080\u001e\u00f4\u00ce\\\u0004/%\u00a5\u0096\u00ee\u00c8CW\u0099\u00dc\u00bb\u00d8\u00b1\u0097v\u00bd'\u00dc\u00db%\u00a8\u0005\u00b2\u00b6(Y\u0002\u0006fP\u0083\u0007\u00acgX\u00fc'\u00f3\u00d8\u00ab+\u00a3\u00b3y\u00f6\u000bTo\u0003\u00e0e3 \u00be}\u009f\u008bq\u00d6>\u00b0\u00bac\u0005\u00f8\u00cb \u00c7\u00c8EK\r{\u00df\u00ea\u00ce\u00b5L\u00bef\u009a&\u00da\u00e2\u00f7S`\u00cf4Q\u00fa.\u00e5\u00e6\u007fe\u001d\u00f5\u00b1\u00e9\u00b6\u0091\u00d2\u00144\u00cf_\u008f\"\u00bc\u00f0\u00e7\u00a2\u00aa\u0096\u00f8\u009a:\u00e5N\u009aL\u00b6j\u00924_\u00e1\u00c9\u00fb\u00be\u0015}.\u001ajo\u00cf\"\u00cb\u00eaI\u00e3\u00f4\u00c2\u00ba\u00bcR\u00caf\u009c\u00ac\u00b98\u00f0]\u008e\u0083\u00ef\\\u0090\u008f\u00e6\u00d7\u009a\u00fc\u00e3\u0091x\u0005\u00af\u008f\u00bd\u00d55\u001b\u0005\u00b64\u00fa\u00d0A\u00e2]\u009f\u00e1\f\u00c842r\u000f\u00d5\u00ad\u00c2\u00b9L\u0010N\r\u00a7\u00ee\u00c1\u0019\t\u00fai{\u00af\u00c8\u00e5s\u00c1\u000bz\u00e42\u00cfF\u00e5\u0000\f\u0080\u00fd\u0082\u00bd\u00dc0\u0096\u0015\u00fe\u00e8\u0094\u00f5\u00e0G\u00d9=)Cc\u00ed\u008d\u00e7\u0097\u00d4\u00ed\u009e\u00f2\u00b3\u008a\u001a\u00f7#jH\u001b\u0017\u009b\u0097\u00b0\u00b8\u00e9\u00e3\u0088W\u00e5\u00a3'8\u009c\u000b\u0087F7\u00c7\u0088\u00b7*\u00f9\u00f7\u00e9P`\u00a9\u00f7V6H\u008e\u00bfQ\u0090]\u009e\u00db\u009f\u00d8\u00be\u00a1\u0085\u00eb<IY`\u0018\u00e0\u000b\u0095\u0005\u00eb\u00cbA\u008d\u00f2,\u0095,\u00b6d\u000b^\u0084\u00a8\u00f6\u0090\u00e2C\u0014/W-\u001b\u00d1\fr\u00a5\u00cc\u0013\u0089\bLd\u00cb\u0014\fe\u00af\u00e5\u00f2\u00e5Wl\u00a9\nF\u0097\u00c5r\u009c3\u00a2\u00a4\u00c5f6\u00a7\u00d0\u0006\u00f1\u008d\u008a\u00c1\u00edn\u007f`\u00a7)BhcCvz\u00bf\u00fc{k\u00cc4\u0094\u00d6\u00df\u0013u\u0011\u009a\u00b6\u001f\u00e2\u00ef\u00ae\u00da`RM\u0098\u001b\u00c7\b\u00a49\u00df\u00d1\u0082\u00124\u00ed\u001e=a\u00ce\u00dc\u001b\u00a7\u00ba\u00bc\u00b2D<\u00c2\u001av\u00dckxA\f)\u00b7\u00b4N\u00ccV\u0010e\u00d9~\u009c\u00b4\u00f2Z\u008b@\u00ce6\u00be\u00de\u00der\u0084p3d\u0098;\u009ctD[\u00d5\u00ce\u00f2\u00fd\u00dc\u0018\u008bi\fH\u00c3\u0091\r\u00d5\u008f\u00f3\u00f6?\u00d9`\u008be\u00b9!Ii|\u00fe\n\u00eehEnD\u00fd\u00cf\u008a\u009a\u00cd\u00d1]7i;\u0089\u00c2qjtW\u0010\u00a4\u00f3\u00a2\u00f6\u0017\u0018nC\u0082\u0081;\u000f\u00d92\u009a\u00e1EB'O\u00c9\u00cf\u00a9\u00b68\n\u0080\u008c\u0000\u00bdn\u0093FI\u00c4\u00f0e?)\u0098\u0014uA\u00e6\f^%\u00f5\u0095\u0013\u00d9w\u00b0\u00fd3H\u00ea\u008eP\u0005'\u0015\u008a\u0088\u001a\u00ed!\u00d6\u00e2\u008cH\u009e\u00c1\u00d3J%\u00e4\u0001\u00e0$S\u00e4\u00be".length();
                var1_4 = 3;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "Q\u0082\fP\u00e2+5\u00a3t\u0095E\u00faM\u008c\u00c3\u00db\u00e5U#\u000f\u0087\u00cd\u00f3\u00a7H\u0086\u00ac}\u00b1[9ILH^pR\u00b8t!*\u008fh\u00e9&\u000e\u0014\u00db\u000f\u001a\u0010\u00e1\u00f3=\u00d2\u0097vX\u0083\u0085\u0003\u0084\u00f5\u00ce\u00b3\u0081\u0081\u0096\u001dc\nUB\u0090\u00b2:hk`i\u00f8\u000e]%";
                    var4_3 = "Q\u0082\fP\u00e2+5\u00a3t\u0095E\u00faM\u008c\u00c3\u00db\u00e5U#\u000f\u0087\u00cd\u00f3\u00a7H\u0086\u00ac}\u00b1[9ILH^pR\u00b8t!*\u008fh\u00e9&\u000e\u0014\u00db\u000f\u001a\u0010\u00e1\u00f3=\u00d2\u0097vX\u0083\u0085\u0003\u0084\u00f5\u00ce\u00b3\u0081\u0081\u0096\u001dc\nUB\u0090\u00b2:hk`i\u00f8\u000e]%".length();
                    var1_4 = 3;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 2;
                            break;
                        }
                        case 1: {
                            v13 = 66;
                            break;
                        }
                        case 2: {
                            v13 = 98;
                            break;
                        }
                        case 3: {
                            v13 = 65;
                            break;
                        }
                        case 4: {
                            v13 = 105;
                            break;
                        }
                        case 5: {
                            v13 = 8;
                            break;
                        }
                        default: {
                            v13 = 86;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CertStoreRootCertificateOps.d = var5;
        CertStoreRootCertificateOps.e = new String[40];
        CertStoreRootCertificateOps.a = LoggerFactory.getLogger(CertStoreRootCertificateOps.class);
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0xFFFFC4C7) & 0xFFFF;
        if (e[n4] == null) {
            int n5;
            int n6;
            char[] cArray = d[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 31;
                    break;
                }
                case 1: {
                    n6 = 122;
                    break;
                }
                case 2: {
                    n6 = 79;
                    break;
                }
                case 3: {
                    n6 = 63;
                    break;
                }
                case 4: {
                    n6 = 59;
                    break;
                }
                case 5: {
                    n6 = 73;
                    break;
                }
                case 6: {
                    n6 = 39;
                    break;
                }
                case 7: {
                    n6 = 67;
                    break;
                }
                case 8: {
                    n6 = 107;
                    break;
                }
                case 9: {
                    n6 = 8;
                    break;
                }
                case 10: {
                    n6 = 190;
                    break;
                }
                case 11: {
                    n6 = 58;
                    break;
                }
                case 12: {
                    n6 = 197;
                    break;
                }
                case 13: {
                    n6 = 146;
                    break;
                }
                case 14: {
                    n6 = 136;
                    break;
                }
                case 15: {
                    n6 = 34;
                    break;
                }
                case 16: {
                    n6 = 161;
                    break;
                }
                case 17: {
                    n6 = 251;
                    break;
                }
                case 18: {
                    n6 = 171;
                    break;
                }
                case 19: {
                    n6 = 127;
                    break;
                }
                case 20: {
                    n6 = 176;
                    break;
                }
                case 21: {
                    n6 = 215;
                    break;
                }
                case 22: {
                    n6 = 78;
                    break;
                }
                case 23: {
                    n6 = 18;
                    break;
                }
                case 24: {
                    n6 = 232;
                    break;
                }
                case 25: {
                    n6 = 104;
                    break;
                }
                case 26: {
                    n6 = 16;
                    break;
                }
                case 27: {
                    n6 = 92;
                    break;
                }
                case 28: {
                    n6 = 213;
                    break;
                }
                case 29: {
                    n6 = 216;
                    break;
                }
                case 30: {
                    n6 = 25;
                    break;
                }
                case 31: {
                    n6 = 89;
                    break;
                }
                case 32: {
                    n6 = 241;
                    break;
                }
                case 33: {
                    n6 = 74;
                    break;
                }
                case 34: {
                    n6 = 193;
                    break;
                }
                case 35: {
                    n6 = 99;
                    break;
                }
                case 36: {
                    n6 = 234;
                    break;
                }
                case 37: {
                    n6 = 40;
                    break;
                }
                case 38: {
                    n6 = 36;
                    break;
                }
                case 39: {
                    n6 = 100;
                    break;
                }
                case 40: {
                    n6 = 52;
                    break;
                }
                case 41: {
                    n6 = 45;
                    break;
                }
                case 42: {
                    n6 = 102;
                    break;
                }
                case 43: {
                    n6 = 133;
                    break;
                }
                case 44: {
                    n6 = 55;
                    break;
                }
                case 45: {
                    n6 = 90;
                    break;
                }
                case 46: {
                    n6 = 24;
                    break;
                }
                case 47: {
                    n6 = 200;
                    break;
                }
                case 48: {
                    n6 = 21;
                    break;
                }
                case 49: {
                    n6 = 189;
                    break;
                }
                case 50: {
                    n6 = 148;
                    break;
                }
                case 51: {
                    n6 = 199;
                    break;
                }
                case 52: {
                    n6 = 117;
                    break;
                }
                case 53: {
                    n6 = 156;
                    break;
                }
                case 54: {
                    n6 = 110;
                    break;
                }
                case 55: {
                    n6 = 70;
                    break;
                }
                case 56: {
                    n6 = 5;
                    break;
                }
                case 57: {
                    n6 = 157;
                    break;
                }
                case 58: {
                    n6 = 10;
                    break;
                }
                case 59: {
                    n6 = 206;
                    break;
                }
                case 60: {
                    n6 = 68;
                    break;
                }
                case 61: {
                    n6 = 87;
                    break;
                }
                case 62: {
                    n6 = 131;
                    break;
                }
                case 63: {
                    n6 = 95;
                    break;
                }
                case 64: {
                    n6 = 201;
                    break;
                }
                case 65: {
                    n6 = 113;
                    break;
                }
                case 66: {
                    n6 = 178;
                    break;
                }
                case 67: {
                    n6 = 32;
                    break;
                }
                case 68: {
                    n6 = 218;
                    break;
                }
                case 69: {
                    n6 = 235;
                    break;
                }
                case 70: {
                    n6 = 204;
                    break;
                }
                case 71: {
                    n6 = 72;
                    break;
                }
                case 72: {
                    n6 = 4;
                    break;
                }
                case 73: {
                    n6 = 219;
                    break;
                }
                case 74: {
                    n6 = 118;
                    break;
                }
                case 75: {
                    n6 = 37;
                    break;
                }
                case 76: {
                    n6 = 62;
                    break;
                }
                case 77: {
                    n6 = 202;
                    break;
                }
                case 78: {
                    n6 = 50;
                    break;
                }
                case 79: {
                    n6 = 65;
                    break;
                }
                case 80: {
                    n6 = 154;
                    break;
                }
                case 81: {
                    n6 = 141;
                    break;
                }
                case 82: {
                    n6 = 128;
                    break;
                }
                case 83: {
                    n6 = 174;
                    break;
                }
                case 84: {
                    n6 = 253;
                    break;
                }
                case 85: {
                    n6 = 119;
                    break;
                }
                case 86: {
                    n6 = 28;
                    break;
                }
                case 87: {
                    n6 = 54;
                    break;
                }
                case 88: {
                    n6 = 211;
                    break;
                }
                case 89: {
                    n6 = 124;
                    break;
                }
                case 90: {
                    n6 = 226;
                    break;
                }
                case 91: {
                    n6 = 221;
                    break;
                }
                case 92: {
                    n6 = 182;
                    break;
                }
                case 93: {
                    n6 = 86;
                    break;
                }
                case 94: {
                    n6 = 130;
                    break;
                }
                case 95: {
                    n6 = 149;
                    break;
                }
                case 96: {
                    n6 = 103;
                    break;
                }
                case 97: {
                    n6 = 13;
                    break;
                }
                case 98: {
                    n6 = 162;
                    break;
                }
                case 99: {
                    n6 = 158;
                    break;
                }
                case 100: {
                    n6 = 180;
                    break;
                }
                case 101: {
                    n6 = 120;
                    break;
                }
                case 102: {
                    n6 = 135;
                    break;
                }
                case 103: {
                    n6 = 105;
                    break;
                }
                case 104: {
                    n6 = 153;
                    break;
                }
                case 105: {
                    n6 = 132;
                    break;
                }
                case 106: {
                    n6 = 116;
                    break;
                }
                case 107: {
                    n6 = 167;
                    break;
                }
                case 108: {
                    n6 = 41;
                    break;
                }
                case 109: {
                    n6 = 85;
                    break;
                }
                case 110: {
                    n6 = 108;
                    break;
                }
                case 111: {
                    n6 = 169;
                    break;
                }
                case 112: {
                    n6 = 109;
                    break;
                }
                case 113: {
                    n6 = 7;
                    break;
                }
                case 114: {
                    n6 = 64;
                    break;
                }
                case 115: {
                    n6 = 175;
                    break;
                }
                case 116: {
                    n6 = 181;
                    break;
                }
                case 117: {
                    n6 = 112;
                    break;
                }
                case 118: {
                    n6 = 60;
                    break;
                }
                case 119: {
                    n6 = 192;
                    break;
                }
                case 120: {
                    n6 = 66;
                    break;
                }
                case 121: {
                    n6 = 51;
                    break;
                }
                case 122: {
                    n6 = 214;
                    break;
                }
                case 123: {
                    n6 = 82;
                    break;
                }
                case 124: {
                    n6 = 188;
                    break;
                }
                case 125: {
                    n6 = 93;
                    break;
                }
                case 126: {
                    n6 = 195;
                    break;
                }
                case 127: {
                    n6 = 166;
                    break;
                }
                case 128: {
                    n6 = 217;
                    break;
                }
                case 129: {
                    n6 = 173;
                    break;
                }
                case 130: {
                    n6 = 42;
                    break;
                }
                case 131: {
                    n6 = 88;
                    break;
                }
                case 132: {
                    n6 = 220;
                    break;
                }
                case 133: {
                    n6 = 48;
                    break;
                }
                case 134: {
                    n6 = 208;
                    break;
                }
                case 135: {
                    n6 = 126;
                    break;
                }
                case 136: {
                    n6 = 236;
                    break;
                }
                case 137: {
                    n6 = 209;
                    break;
                }
                case 138: {
                    n6 = 152;
                    break;
                }
                case 139: {
                    n6 = 22;
                    break;
                }
                case 140: {
                    n6 = 26;
                    break;
                }
                case 141: {
                    n6 = 151;
                    break;
                }
                case 142: {
                    n6 = 248;
                    break;
                }
                case 143: {
                    n6 = 186;
                    break;
                }
                case 144: {
                    n6 = 172;
                    break;
                }
                case 145: {
                    n6 = 249;
                    break;
                }
                case 146: {
                    n6 = 123;
                    break;
                }
                case 147: {
                    n6 = 9;
                    break;
                }
                case 148: {
                    n6 = 61;
                    break;
                }
                case 149: {
                    n6 = 183;
                    break;
                }
                case 150: {
                    n6 = 198;
                    break;
                }
                case 151: {
                    n6 = 114;
                    break;
                }
                case 152: {
                    n6 = 210;
                    break;
                }
                case 153: {
                    n6 = 3;
                    break;
                }
                case 154: {
                    n6 = 137;
                    break;
                }
                case 155: {
                    n6 = 43;
                    break;
                }
                case 156: {
                    n6 = 19;
                    break;
                }
                case 157: {
                    n6 = 142;
                    break;
                }
                case 158: {
                    n6 = 243;
                    break;
                }
                case 159: {
                    n6 = 94;
                    break;
                }
                case 160: {
                    n6 = 145;
                    break;
                }
                case 161: {
                    n6 = 0;
                    break;
                }
                case 162: {
                    n6 = 244;
                    break;
                }
                case 163: {
                    n6 = 81;
                    break;
                }
                case 164: {
                    n6 = 164;
                    break;
                }
                case 165: {
                    n6 = 227;
                    break;
                }
                case 166: {
                    n6 = 27;
                    break;
                }
                case 167: {
                    n6 = 49;
                    break;
                }
                case 168: {
                    n6 = 57;
                    break;
                }
                case 169: {
                    n6 = 129;
                    break;
                }
                case 170: {
                    n6 = 106;
                    break;
                }
                case 171: {
                    n6 = 71;
                    break;
                }
                case 172: {
                    n6 = 44;
                    break;
                }
                case 173: {
                    n6 = 98;
                    break;
                }
                case 174: {
                    n6 = 69;
                    break;
                }
                case 175: {
                    n6 = 231;
                    break;
                }
                case 176: {
                    n6 = 138;
                    break;
                }
                case 177: {
                    n6 = 247;
                    break;
                }
                case 178: {
                    n6 = 30;
                    break;
                }
                case 179: {
                    n6 = 77;
                    break;
                }
                case 180: {
                    n6 = 224;
                    break;
                }
                case 181: {
                    n6 = 223;
                    break;
                }
                case 182: {
                    n6 = 239;
                    break;
                }
                case 183: {
                    n6 = 15;
                    break;
                }
                case 184: {
                    n6 = 46;
                    break;
                }
                case 185: {
                    n6 = 134;
                    break;
                }
                case 186: {
                    n6 = 144;
                    break;
                }
                case 187: {
                    n6 = 230;
                    break;
                }
                case 188: {
                    n6 = 76;
                    break;
                }
                case 189: {
                    n6 = 170;
                    break;
                }
                case 190: {
                    n6 = 254;
                    break;
                }
                case 191: {
                    n6 = 38;
                    break;
                }
                case 192: {
                    n6 = 168;
                    break;
                }
                case 193: {
                    n6 = 185;
                    break;
                }
                case 194: {
                    n6 = 229;
                    break;
                }
                case 195: {
                    n6 = 252;
                    break;
                }
                case 196: {
                    n6 = 11;
                    break;
                }
                case 197: {
                    n6 = 177;
                    break;
                }
                case 198: {
                    n6 = 222;
                    break;
                }
                case 199: {
                    n6 = 80;
                    break;
                }
                case 200: {
                    n6 = 159;
                    break;
                }
                case 201: {
                    n6 = 240;
                    break;
                }
                case 202: {
                    n6 = 143;
                    break;
                }
                case 203: {
                    n6 = 225;
                    break;
                }
                case 204: {
                    n6 = 111;
                    break;
                }
                case 205: {
                    n6 = 233;
                    break;
                }
                case 206: {
                    n6 = 160;
                    break;
                }
                case 207: {
                    n6 = 75;
                    break;
                }
                case 208: {
                    n6 = 20;
                    break;
                }
                case 209: {
                    n6 = 121;
                    break;
                }
                case 210: {
                    n6 = 163;
                    break;
                }
                case 211: {
                    n6 = 14;
                    break;
                }
                case 212: {
                    n6 = 115;
                    break;
                }
                case 213: {
                    n6 = 33;
                    break;
                }
                case 214: {
                    n6 = 255;
                    break;
                }
                case 215: {
                    n6 = 83;
                    break;
                }
                case 216: {
                    n6 = 96;
                    break;
                }
                case 217: {
                    n6 = 53;
                    break;
                }
                case 218: {
                    n6 = 140;
                    break;
                }
                case 219: {
                    n6 = 207;
                    break;
                }
                case 220: {
                    n6 = 12;
                    break;
                }
                case 221: {
                    n6 = 125;
                    break;
                }
                case 222: {
                    n6 = 6;
                    break;
                }
                case 223: {
                    n6 = 238;
                    break;
                }
                case 224: {
                    n6 = 155;
                    break;
                }
                case 225: {
                    n6 = 139;
                    break;
                }
                case 226: {
                    n6 = 147;
                    break;
                }
                case 227: {
                    n6 = 203;
                    break;
                }
                case 228: {
                    n6 = 91;
                    break;
                }
                case 229: {
                    n6 = 179;
                    break;
                }
                case 230: {
                    n6 = 194;
                    break;
                }
                case 231: {
                    n6 = 196;
                    break;
                }
                case 232: {
                    n6 = 35;
                    break;
                }
                case 233: {
                    n6 = 246;
                    break;
                }
                case 234: {
                    n6 = 101;
                    break;
                }
                case 235: {
                    n6 = 212;
                    break;
                }
                case 236: {
                    n6 = 17;
                    break;
                }
                case 237: {
                    n6 = 228;
                    break;
                }
                case 238: {
                    n6 = 56;
                    break;
                }
                case 239: {
                    n6 = 205;
                    break;
                }
                case 240: {
                    n6 = 97;
                    break;
                }
                case 241: {
                    n6 = 187;
                    break;
                }
                case 242: {
                    n6 = 191;
                    break;
                }
                case 243: {
                    n6 = 242;
                    break;
                }
                case 244: {
                    n6 = 250;
                    break;
                }
                case 245: {
                    n6 = 237;
                    break;
                }
                case 246: {
                    n6 = 2;
                    break;
                }
                case 247: {
                    n6 = 245;
                    break;
                }
                case 248: {
                    n6 = 1;
                    break;
                }
                case 249: {
                    n6 = 29;
                    break;
                }
                case 250: {
                    n6 = 47;
                    break;
                }
                case 251: {
                    n6 = 150;
                    break;
                }
                case 252: {
                    n6 = 23;
                    break;
                }
                case 253: {
                    n6 = 84;
                    break;
                }
                case 254: {
                    n6 = 184;
                    break;
                }
                default: {
                    n6 = 165;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            CertStoreRootCertificateOps.e[n4] = new String(cArray).intern();
        }
        return e[n4];
    }
}

