/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.ocsp;

import com.objsys.asn1j.runtime.Asn1BigInteger;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EBasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ECertID;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EResponseData;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ESingleResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtension;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtensions;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.SignUtil;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.AbstractConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.util.HashMultiMap;
import tr.gov.tubitak.uekae.esya.asn.ocsp.BasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.asn.ocsp.CertID;
import tr.gov.tubitak.uekae.esya.asn.ocsp.OCSPRequest;
import tr.gov.tubitak.uekae.esya.asn.ocsp.OCSPResponse;
import tr.gov.tubitak.uekae.esya.asn.ocsp.Request;
import tr.gov.tubitak.uekae.esya.asn.ocsp.TBSRequest;
import tr.gov.tubitak.uekae.esya.asn.ocsp.Version;
import tr.gov.tubitak.uekae.esya.asn.ocsp._SeqOfRequest;
import tr.gov.tubitak.uekae.esya.asn.ocsp._ocspValues;
import tr.gov.tubitak.uekae.esya.asn.x509.AlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.asn.x509.Extension;
import tr.gov.tubitak.uekae.esya.asn.x509.Extensions;

public class OCSPClient {
    protected static Logger logger;
    public static final int REASON_UNSPECIFIED = 0;
    public static final int REASON_KEY_COMPROMISE = 1;
    public static final int REASON_CA_COMPROMISE = 2;
    public static final int REASON_AFFILIATION_CHANGED = 3;
    public static final int REASON_SUPERSEDED = 4;
    public static final int REASON_CESSATION_OF_OPERATION = 5;
    public static final int REASON_CERTIFICATE_HOLD = 6;
    public static final int REASON_PRIVILEGE_WITHDRAWN = 9;
    public static final int REASON_AA_COMPROMISE = 10;
    public static final int STATUS_RESPONSE_HAS_INVALID_SIGNATURE = 1;
    public static final int STATUS_RESPONSE_CANT_BE_RECEIVED = 2;
    public static final int STATUS_RESPONCE_INVALID_NONCE = 3;
    private static final String a;
    private static final String b;
    private static final String c;
    private static final String d;
    private static final String e;
    public static final Asn1ObjectIdentifier NONCE_OID;
    private int f;
    protected HashMultiMap<BigInteger, ESingleResponse> singleResponses;
    protected ECertificate signingCertificate;
    protected EBasicOCSPResponse mBasicResponse;
    protected EOCSPResponse mOCSPResponce;
    private static final Logger g;
    private String h;
    private HttpURLConnection i;
    private URL j;
    private byte[] k;
    private int l;
    private boolean m;
    private boolean n;
    private boolean o;
    private boolean p;
    public static DigestAlg digestAlgForOcspRequest;
    public static int q;
    private static final String[] r;
    private static final String[] s;

    protected OCSPClient() {
        block6: {
            boolean bl;
            block8: {
                block7: {
                    this.h = null;
                    this.i = null;
                    this.j = null;
                    int n2 = q;
                    this.k = null;
                    this.l = 0;
                    this.m = true;
                    this.n = true;
                    this.o = true;
                    this.p = false;
                    this.singleResponses = new HashMultiMap();
                    try {
                        LV.getInstance().checkLD(LV.Urunler.ORTAK);
                    }
                    catch (LE lE) {
                        throw new ESYARuntimeException(OCSPClient.a(-7225, -18918) + lE.getMessage());
                    }
                    if (n2 == 0) break block6;
                    if (!AbstractConfigElement.b) break block7;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
            AbstractConfigElement.b = bl;
        }
    }

    public OCSPClient(String aConnectionAddress) throws ESYAException {
        this();
        try {
            this.j = new URL(aConnectionAddress);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ESYAException(malformedURLException);
        }
        this.h = aConnectionAddress;
    }

    public void setCheckSignature(boolean aCheckSignature) {
        this.m = aCheckSignature;
    }

    public void setCheckNonce(boolean aCheckNonce) {
        this.n = aCheckNonce;
    }

    public void setCheckResponseStatus(boolean aCheckResponseStatus) {
        this.o = aCheckResponseStatus;
    }

    public void setCheckDate(boolean aCheckDate) {
        this.p = aCheckDate;
    }

    public void openConnection() throws ESYAException {
        this.openConnection(null);
    }

    public void closeConnection() throws ESYAException {
        this.i.disconnect();
    }

    public void openConnection(String aTimeOut) throws ESYAException {
        int n2 = q;
        try {
            this.i = (HttpURLConnection)this.j.openConnection();
            if (aTimeOut != null) {
                this.i.setConnectTimeout(Integer.parseInt(aTimeOut));
                this.i.setReadTimeout(Integer.parseInt(aTimeOut));
            }
            this.i.setRequestProperty(OCSPClient.a(-7179, 21301), OCSPClient.a(-7175, -3393));
            this.i.setRequestProperty(OCSPClient.a(-7214, -29749), OCSPClient.a(-7184, 18478));
            this.i.setRequestMethod(OCSPClient.a(-7191, -7761));
            this.i.setDoOutput(true);
            this.i.setUseCaches(false);
            this.i.connect();
        }
        catch (IOException iOException) {
            g.error(OCSPClient.a(-7199, 29605) + this.h, iOException);
            throw new ESYAException(OCSPClient.a(-7224, 5044) + this.h, iOException);
        }
        if (AbstractConfigElement.b) {
            q = ++n2;
        }
    }

    public Calendar getProducedAt() {
        return this.mBasicResponse.getProducedAt();
    }

    public void queryCertificate(ECertificate aCertificateToQuery, ECertificate aIssuerCertificate) throws ESYAException {
        this.queryCertificate(new ECertificate[]{aCertificateToQuery}, new ECertificate[]{aIssuerCertificate});
    }

    public EOCSPResponse queryCertificate(ECertificate[] aCertificatesToQuery, ECertificate[] aIssuerCertificates) throws ESYAException {
        if (this.i == null) {
            g.error(OCSPClient.a(-7200, 25648));
            throw new ESYAException(OCSPClient.a(-7203, -32292));
        }
        byte[] byArray = this.a(aCertificatesToQuery, aIssuerCertificates);
        this.a(byArray);
        g.debug(OCSPClient.a(-7197, -6557));
        return this.mOCSPResponce;
    }

    public EOCSPResponse queryCertificate(BigInteger aSertifikaSeriNo, byte[] aSMSubjectHashDegeri, byte[] aSMAcikAnahtarHashDegeri) throws ESYAException {
        if (this.i == null) {
            g.error(OCSPClient.a(-7211, -10010));
            throw new ESYAException(OCSPClient.a(-7174, -26832));
        }
        byte[] byArray = this.a(aSertifikaSeriNo, aSMSubjectHashDegeri, aSMAcikAnahtarHashDegeri);
        this.a(byArray);
        g.debug(OCSPClient.a(-7206, 16383));
        return this.mOCSPResponce;
    }

    public int getStatus() {
        return this.l;
    }

    private EOCSPResponse a(byte[] byArray) throws ESYAException {
        block10: {
            block11: {
                int n2 = q;
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(this.i.getOutputStream());
                    dataOutputStream.write(byArray);
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    g.error(OCSPClient.a(-7210, 24276), iOException);
                    throw new ESYAException(OCSPClient.a(-7221, -8959), iOException);
                }
                try {
                    g.debug(OCSPClient.a(-7232, 15105));
                    this.mOCSPResponce = this.b();
                    g.debug(OCSPClient.a(-7227, 10202));
                }
                catch (Exception exception) {
                    this.l = 2;
                    g.error(OCSPClient.a(-7252, -8973), exception);
                    throw new ESYAException(OCSPClient.a(-7190, 26555), exception);
                }
                if (!this.o) break block10;
                if (!this.checkResponseStatus()) break block11;
                this.a(this.mOCSPResponce);
                if (n2 == 0) break block10;
            }
            this.mOCSPResponce = null;
            g.error(OCSPClient.a(-7181, 6105));
            throw new ESYAException(OCSPClient.a(-7217, -1077));
        }
        return this.mOCSPResponce;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(ECertificate[] eCertificateArray, ECertificate[] eCertificateArray2) throws ESYAException {
        g.debug(OCSPClient.a(-7223, -12684));
        int n2 = q;
        if (eCertificateArray == null || eCertificateArray.length == 0) {
            g.error(OCSPClient.a(-7228, 24207));
            throw new ESYAException(OCSPClient.a(-7208, -10019));
        }
        int n3 = eCertificateArray.length;
        Request[] requestArray = new Request[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            ECertificate eCertificate = eCertificateArray[i2];
            ECertificate eCertificate2 = eCertificateArray2[i2];
            try {
                requestArray[i2] = this.a(eCertificate, eCertificate2);
                continue;
            }
            catch (Exception exception) {
                g.error(OCSPClient.a(-7251, 15849), exception);
                throw new ESYAException(OCSPClient.a(-7253, -8810), exception);
            }
        }
        return this.a(requestArray);
    }

    private byte[] a(BigInteger bigInteger, byte[] byArray, byte[] byArray2) throws ESYAException {
        Request[] requestArray = new Request[1];
        try {
            requestArray[0] = this.b(bigInteger, byArray, byArray2);
        }
        catch (Exception exception) {
            g.error(OCSPClient.a(-7178, 21854), exception);
            return null;
        }
        return this.a(requestArray);
    }

    private byte[] a(Request[] requestArray) throws ESYAException {
        Extension extension;
        OCSPRequest oCSPRequest = new OCSPRequest();
        TBSRequest tBSRequest = new TBSRequest();
        try {
            extension = this.a();
        }
        catch (Exception exception) {
            g.warn(OCSPClient.a(-7230, 22845), exception);
            throw new ESYAException(OCSPClient.a(-7182, -28099));
        }
        tBSRequest.requestList = new _SeqOfRequest(requestArray);
        tBSRequest.requestExtensions = new Extensions(new Extension[]{extension});
        tBSRequest.version = new Version(0L);
        oCSPRequest.tbsRequest = tBSRequest;
        Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
        try {
            oCSPRequest.encode(asn1DerEncodeBuffer);
        }
        catch (Exception exception) {
            g.error(OCSPClient.a(-7220, -13682), exception);
            throw new ESYAException(OCSPClient.a(-7226, 18058));
        }
        byte[] byArray = asn1DerEncodeBuffer.getMsgCopy();
        g.debug(OCSPClient.a(-7187, 7137));
        return byArray;
    }

    private Extension a() throws ESYAException {
        try {
            Extension extension = new Extension();
            extension.extnID = NONCE_OID;
            this.k = new byte[16];
            SecureRandom.getInstance(OCSPClient.a(-7177, -28415)).nextBytes(this.k);
            Asn1OctetString asn1OctetString = new Asn1OctetString(this.k);
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            asn1OctetString.encode(asn1DerEncodeBuffer);
            extension.extnValue = new Asn1OctetString(asn1DerEncodeBuffer.getMsgCopy());
            return extension;
        }
        catch (Exception exception) {
            throw new ESYAException(exception);
        }
    }

    private EOCSPResponse b() throws ESYAException {
        OCSPResponse oCSPResponse = new OCSPResponse();
        InputStream inputStream = null;
        try {
            inputStream = this.i.getInputStream();
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(inputStream);
            oCSPResponse.decode(asn1DerDecodeBuffer);
            g.debug(OCSPClient.a(-7186, -7011));
        }
        catch (IOException iOException) {
            g.error(OCSPClient.a(-7209, 19434), iOException);
            throw new ESYAException(OCSPClient.a(-7169, 6862), iOException);
        }
        catch (Exception exception) {
            g.error(OCSPClient.a(-7254, 6840), exception);
            throw new ESYAException(OCSPClient.a(-7196, 29521), exception);
        }
        return new EOCSPResponse(oCSPResponse);
    }

    private Request a(ECertificate eCertificate, ECertificate eCertificate2) throws Exception {
        BigInteger bigInteger = eCertificate.getSerialNumber();
        byte[] byArray = DigestUtil.digest(digestAlgForOcspRequest, eCertificate2.getSubject().getEncoded());
        byte[] byArray2 = DigestUtil.digest(digestAlgForOcspRequest, eCertificate2.getSubjectPublicKeyInfo().getSubjectPublicKey());
        return this.b(bigInteger, byArray, byArray2);
    }

    private Request b(BigInteger bigInteger, byte[] byArray, byte[] byArray2) throws ESYAException {
        CertID certID = new CertID();
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgForOcspRequest.getOID());
        Asn1OctetString asn1OctetString = new Asn1OctetString(byArray);
        Asn1OctetString asn1OctetString2 = new Asn1OctetString(byArray2);
        Asn1BigInteger asn1BigInteger = new Asn1BigInteger(bigInteger);
        certID.hashAlgorithm = algorithmIdentifier;
        certID.issuerNameHash = asn1OctetString;
        certID.issuerKeyHash = asn1OctetString2;
        certID.serialNumber = asn1BigInteger;
        return new Request(certID);
    }

    public int getResponseStatus() {
        return this.f;
    }

    public ESingleResponse getSingleResponse(ECertificate aCertificateToQuery, ECertificate aIssuerCertificate) throws ESYAException {
        List<ESingleResponse> list = this.singleResponses.get(aCertificateToQuery.getSerialNumber());
        int n2 = q;
        if (list == null) {
            throw new ESYAException(OCSPClient.a(-7216, 31421));
        }
        for (ESingleResponse eSingleResponse : list) {
            ECertID eCertID = eSingleResponse.getCertID();
            if (OCSPClient.isEqual(eCertID, aCertificateToQuery, aIssuerCertificate)) {
                return eSingleResponse;
            }
            if (n2 == 0) continue;
        }
        throw new ESYAException(OCSPClient.a(-7204, 29951));
    }

    public static boolean isEqual(ECertID certID, ECertificate aCertificateToQuery, ECertificate aIssuerCertificate) {
        block5: {
            if (certID.getSerialNumber().equals(aCertificateToQuery.getSerialNumber())) {
                try {
                    byte[] byArray = aIssuerCertificate.getSubject().getEncoded();
                    byte[] byArray2 = aIssuerCertificate.getSubjectPublicKeyInfo().getSubjectPublicKey();
                    DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier(certID.getHashAlgorithm());
                    byte[] byArray3 = DigestUtil.digest(digestAlg, byArray);
                    byte[] byArray4 = DigestUtil.digest(digestAlg, byArray2);
                    if (!Arrays.equals(certID.getIssuerNameHash(), byArray3) || !Arrays.equals(certID.getIssuerKeyHash(), byArray4)) break block5;
                    return true;
                }
                catch (CryptoException cryptoException) {
                    logger.warn(OCSPClient.a(-7171, -5901), cryptoException);
                    return false;
                }
            }
        }
        return false;
    }

    public EBasicOCSPResponse getBasicResponse() {
        return this.mBasicResponse;
    }

    public EOCSPResponse getOCSPResponse() {
        return this.mOCSPResponce;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkResponseStatus() {
        int n2;
        this.f = n2 = this.mOCSPResponce.getResponseStatus();
        g.debug(OCSPClient.a(-7192, 12065) + n2);
        switch (n2) {
            case 0: {
                g.debug(OCSPClient.a(-7198, -4382));
                return true;
            }
            case 1: {
                g.debug(OCSPClient.a(-7201, -856));
                return false;
            }
            case 2: {
                g.debug(OCSPClient.a(-7229, -30944));
                return false;
            }
            case 3: {
                g.debug(OCSPClient.a(-7195, 5935));
                return false;
            }
            case 5: {
                g.debug(OCSPClient.a(-7170, -21951));
                return false;
            }
            case 6: {
                g.debug(OCSPClient.a(-7207, 6403));
                return false;
            }
        }
        return false;
    }

    public void checkResponse() throws ESYAException {
        this.a(this.mOCSPResponce);
    }

    private void a(EOCSPResponse eOCSPResponse) throws ESYAException {
        int n2;
        block17: {
            block18: {
                block15: {
                    block16: {
                        n2 = q;
                        try {
                            this.mBasicResponse = eOCSPResponse.getBasicOCSPResponse();
                        }
                        catch (Exception exception) {
                            g.error(OCSPClient.a(-7196, 29521), exception);
                            throw new ESYAException(OCSPClient.a(-7196, 29521), exception);
                        }
                        if (!this.n) break block15;
                        if (this.checkNonce()) break block16;
                        this.mOCSPResponce = null;
                        this.l = 3;
                        g.error(OCSPClient.a(-7218, 7604));
                        throw new ESYAException(OCSPClient.a(-7189, 11467));
                    }
                    g.debug(OCSPClient.a(-7255, 2193));
                }
                if (!this.m) break block17;
                if (this.checkSignature()) break block18;
                this.mOCSPResponce = null;
                this.l = 1;
                g.error(OCSPClient.a(-7205, -23082));
                throw new ESYAException(OCSPClient.a(-7173, -12375));
            }
            g.debug(OCSPClient.a(-7185, -27696));
        }
        EResponseData eResponseData = this.mBasicResponse.getTbsResponseData();
        int n3 = eResponseData.getSingleResponseCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            ESingleResponse eSingleResponse = eResponseData.getSingleResponse(i2);
            if (this.p) {
                Calendar calendar = Calendar.getInstance();
                if (!this.checkDate(eSingleResponse, calendar)) {
                    g.error(OCSPClient.a(-7215, -5452));
                    throw new ESYAException(OCSPClient.a(-7249, -1012));
                }
            }
            this.singleResponses.put(eSingleResponse.getCertID().getSerialNumber(), eSingleResponse);
            if (n2 == 0) continue;
        }
    }

    public boolean checkDate(ESingleResponse aResponse, Calendar aDate) {
        block7: {
            if (aDate.before(aResponse.getThisUpdate())) {
                g.warn(OCSPClient.a(-7231, 23262));
                return false;
            }
            if (aResponse.getNextUpdate() == null || !aDate.after(aResponse.getNextUpdate())) break block7;
            g.warn(OCSPClient.a(-7256, 13814));
            return false;
        }
        return true;
    }

    public byte[] getNonce() {
        return this.k;
    }

    public boolean checkNonce() {
        EExtensions eExtensions = this.mBasicResponse.getResponseExtensions();
        int n2 = q;
        if (eExtensions == null) {
            g.error(OCSPClient.a(-7180, 20305));
            return false;
        }
        for (int i2 = 0; i2 < eExtensions.getExtensionCount(); ++i2) {
            EExtension eExtension = eExtensions.getExtension(i2);
            if (!eExtension.getIdentifier().equals(NONCE_OID)) continue;
            byte[] byArray = eExtension.getValue();
            Asn1OctetString asn1OctetString = new Asn1OctetString();
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(byArray);
            try {
                asn1OctetString.decode(asn1DerDecodeBuffer);
            }
            catch (Exception exception) {
                g.error(OCSPClient.a(-7202, 24734), exception);
                return false;
            }
            if (Arrays.equals(asn1OctetString.value, this.k)) {
                return true;
            }
            return false;
        }
        g.error(OCSPClient.a(-7172, -23617));
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkSignature() {
        byte[] byArray = null;
        byArray = this.mBasicResponse.getTbsResponseData().getEncoded();
        byte[] byArray2 = this.mBasicResponse.getSignature();
        int n2 = q;
        if (this.mBasicResponse.getObject() == null || ((BasicOCSPResponse)this.mBasicResponse.getObject()).certs == null) {
            g.error(OCSPClient.a(-7194, -20229));
            return false;
        }
        for (int i2 = 0; i2 < this.mBasicResponse.getCertificateCount(); ++i2) {
            ECertificate eCertificate = this.mBasicResponse.getCertificate(i2);
            try {
                Pair<SignatureAlg, AlgorithmParams> pair = SignatureAlg.fromAlgorithmIdentifier(this.mBasicResponse.getSignatureAlgorithm());
                PublicKey publicKey = KeyUtil.decodePublicKey(eCertificate.getSubjectPublicKeyInfo());
                if (SignUtil.verify(pair.first(), pair.second(), byArray, byArray2, publicKey)) {
                    return true;
                }
                byte[] byArray3 = new byte[byArray2.length];
                int n3 = byArray2.length - 1;
                for (int i3 = 0; i3 < byArray2.length; ++i3) {
                    byArray3[i3] = byArray2[n3 - i3];
                    if (n2 == 0) continue;
                }
                if (!SignUtil.verify(pair.first(), pair.second(), byArray, byArray3, publicKey)) continue;
                return true;
            }
            catch (CryptoException cryptoException) {
                g.error(OCSPClient.a(-7183, -21016), cryptoException);
                return false;
            }
        }
        g.debug(OCSPClient.a(-7213, 8440));
        return false;
    }

    public ECertificate getSigningCertificate() throws ESYAException {
        if (this.mBasicResponse == null) {
            throw new ESYAException(OCSPClient.a(-7193, 1360));
        }
        if (this.signingCertificate != null) {
            return this.signingCertificate;
        }
        if (this.checkSignature()) {
            return this.signingCertificate;
        }
        return null;
    }

    public void setDigestAlgForOcspRequest(DigestAlg digestAlg) {
        digestAlgForOcspRequest = digestAlg;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[71];
                var3_1 = 0;
                var2_2 = "\u00b7r\u00f8\u0013\u00e3\u008aJ\u00b57\u00e7#\u0082y\r\u00af=@\u00f2K\u00b4\u00a4W\u0084*\u001c\u00c4\u0083\u00ab\u0098\u00f4W\u00d8&&\u00e1&\u00c5r/]4\u00e4]oc3\u00ce\u00bc3-\u00b6V8;\u00a2Qd\u0093\u00cc\u013c\u00d1\u00b4\u010e(\u015fg\u001e\u00cd \u00b97\u00dfw\u00bf\u00be,{\u00073\u0005\u00e5\u00f2\u0018\u00ea2\u00046\u00e8\u00e61\u0155\u00e1-J\u008c\u00d2\u0189!K8i4\u00c5\r\u00ea\u00aeA\u01c5\u00c0\u0095\u0086\u00f2\u019e\u0016\u00e0\u01f6\u00a8\u001d']\u00a2\u0016\u00eb\u018dju\u00fad\u00fa{:\nD\t\u00e7\u0006\u00e9\u0005\u00d7\u0093{:(\u00f3\u000f~\u00d2'\u00db\u00a0=\u00d8\u009a>\u00b1>\u0080P\u0003\u00db/\u00a7\u0014\u00cf\u001c\u0088P\u0012\u0093\f\u00a6+\u00e0\u00ee\u0095-O\u01d1\u00fa\u0098\u01d6\u000b\u010d#\u00f0\u0082\u001ec+\u00e3!\u00f0\u00e8\u009cqe\u00b0\u00ect\u00d5\u0014\u00d66J\u00f4\u00b7\u00d3B\u00b9\u001f\u00e4\u0001k\u00e8\u00d8\u00f5n&@'\u0082\u00f5P\u008d\u00e2 \u0018T\u00d8&\u0099\u009d\u0097\u0099\u0088\u0166\u00c5\u0019\u00c6\u01e7\u0012\u01e5\u00b55\u00a7?\u00a5)\u00ceP\u0000\u0098\u00d3\u00e3\u0088\u01fd\u00da\u008b\u00d3\u001c\u00a6Qj\u00dd\u00e5\u00c9\u0011\u001ai\u00f3\u0154\u00ae\u00af_\u00f3\u011dQ\u0097\u008a>\u00fa\u00a8\u008d`T\u0181\u01ad\f#?\u009b\u00e7@\u0014\u009a\u00d1}\u0016\u00b7\u001b\u00ea\u00b1\u00af\u00c8(\u00a9\u013c\u00e8\u00f9\u0164E\u0093j\u00fb\u0085\u0082\"C\u008d\u00bcX\u00e9\u009a\u01aa\u000e\u00b0\u00b7\u00be\u0016\u00ee\u0017\u00c4\u0098\u018d\u00ca?\u01d4\u000f\u01b9\u0016GL@i1\u00f8.p\u00ddu\u00cb\u00d6 \u00e22n0\u00f5\u00c0\u00b75A.\u008b\u0090q!\u00c6\u00a5\u009c\u00f2_c\u00ce\u008e g\u0093\u00ff\u00a3\u00b0\u00a5\u00ef:dH\u009e\u0089\u008e\u00c9t\u0082\u00c76\u009fn#!\u0090\u0005\u00f6\u00c4\u00f5\u0002\u00f3\u0088\u0088K1\u0010\u008b\u00ca#\u00fc\u00d2\u00d6 \u00d8l\u00af\u008a\u00bd\u009b\u00a2\u00bd\u00f6\u001f\u0091?\u00dd\u000e\u0013U\u00ff\u00b1\u00ae\u00ee\u00b2\u001b\u00af\tw\u0010\u0087g\u00c0q;>Rp\u00acp\u0097\u00c5\u00e1x\u00ed\u0018,\u00dbM!O\u001e\u00c9\u0087y\u0090MN\u00ddeu\u00b7k\u00b2q\u00a3\u0097q>f\u0018\u009a\u00c4\u009b\u00c2\u0095b\u0092\b\u0012a pp\u00a2\u00c0O\u00dd\u00ad\u00a7@M\re\u00e9)\u0000\u0013\u0000Q\u00e8\u00abY3\u00e7[\u00d9\u0089\u00c2\u0087\u00cf\u00e3(3\u00d9\u0097\u0000lq^-R\u00eb\u009e\u00d7\u00e7qu\u00deS\u01afyW\u01a6\u00ed\u0103b6\u00a6\u0002j\u00b5\u00e9\u0092\u0015\u00ac\u00e3F\nr\u0096\u00ae\u00a4V\u00db\u000e\u00a6\u00dd\u00fd\u0002\u00b6\u00e0\u00d4\u00a6\u00e4\u00fe\u0019\u00fa\u00b9\u00a8\u009fg^\u00cf\u0080I\u0169\u00f9\b\u00b5\u0007\u0140\u00cf<YK\u0080\u0006\u00c2\u00b5\u00bc\u013b\u0015\u00c24b\u00ed\u00e8\u00c8;\u00a5\u00e1\u000b\u0010|\u00dd\u007f\u00ff\u00f1<4\u00f2\u0014\u00e6-0-\u0006\u0096(SA,\u00e4\u00aa\u01a8\u00aa\u00d3\u0093hc\u00d8\u00e2\"c\n\u00ba\u00c4d\u00ff\u00d1\u001b\u0082N\u00a0\u0086\u0096S@\u00cd\u00f6\u008ciwS\u00ec\u00a1\u008e\u00f4\u0158'\u00b3Fv\u00fb&\u00fe\u0080\u0099\u00dc\u000e\u00be#.\u00d2RI\u009b(\u00af>\u00d5\u00b0\u00fap8\u00a6\u00d78\u000e&%\u00a0\u008f\u008e\u00bc\u0019ay\f\u0019*\u0090\u00ed\u00f2\u0084\u008b\u0098\u001e\u000b\u00b8\u0011o{\u00d5^\u0093D,\u0097TK\u0083\u00a4\u00a4\u0084\u001e\u0012N\u00ad Q\u0095d\u017a\u00183\u001b-T\u01dcd\u0083 P\u001cy\u00c3\u00010\u000flX\u00c2\u01b0\u00c8\u00b3\u0011`/M\u0001?\u00d1@b\u0099\u00c2b\u00b0\u00bcQ,d\u00cd\u0014l=%G\u009d=\u00aa\u00dd\u0140b\u0086\u01c18\u011b\u00f9t\u008b\u0131 \u000e\"V\u001d\u00d6\n\u00ed\u00d6\u0014\u00b9[\u00d0\u00b7Q\u0084]\u0085m\u0085\u00a0 \u00c6\u00d6\u0004&4\u0082\u00d9\u00a9\u00db\u00a6\u00ce\u0089\u00d9\u00e8\u001d\f\u0095\u00ae\u0002kwAV\u0099\u00007\u00e6$'\u00e9\u00d2=iO\u00ac\u00ad\u00d3yU\u011bU\u00a5l\u00a6\u009c\u0001\u001d\u0019\u00b7zt9\u00ef\u00d5\u00c6p\u00f7\u0093[\u00d6a\u0085\u001b\u000f\u0092\u00a9\u0003\u0101\bn\u00d0@\"\u00c0\u00b9\tW\u0014\u01c4\u00bb/G\u0085\u00b9\u00dc@\b\u0143\u00e6X\u00ec\u00a0\u00f2\u00ca'=\u00b1\u0163\u0019\u009cC\u0093[\u009a\u00e0\u0001\u0013<\u0172oc~!\u0007\u01fe\u00baV.\u00dc\u0090\u001e\u00f4\u001a\u00b2\u001b\u00af7\u00f5\u00d5V+\u008e5\n\n\u00c3\u0018\u00dc)\u00e1\u0170\u00e8\u00dbc\u01bf\u00a6\u00be<\u000ek\u014c\u0007\u001f\u0117MU\u0099\u00cab=\u00a1&\u008dJ\u00daQ\u000e86\u00dd\u00d7\"\u00ab\u008a\u000f$8\u0016\u00d42h\u01c7\u00c6\u00cc\u0011\u00aa\u00d8\u0014\u00ff\u0014\u000e%\u00995\u00bd\u00f7_\u000e\u00acz\u00db\u0007\u0003\u009e\u009f\u00dd,+\u00dee\u00e8D\u0096\u00da\u00ddG\u00dfIa\u00d0\u009a\u008d@`G\u00d6\u0018(\u00ae\u00ceH\u0019V\u00cba\u00d5\u00f8\u0016?\u00da\u0094\u001b\u00bc+\u00b8\u000f\u00ae\u00aeBED\u001c\u0084\u00b6\u000e'BL\u00acp\u00deA\u00c3\u00a5N\u0089\u007f\u00aen\u00caX\u0092E\u00ban.\u00c0\u00e0\u0084\u009c*A\u0017(\u00d1\u00ed\u00bb\u00f91\u00f3\u001b[\u0081\u0092\u0086\u00c5\u00c3i7\u00f6\u0015\u0016|`U\u00e6\u0010\f\u00f1o\u00cfH\u00cf9@g\u0146\u00a4\u00fb\u01a0\u00c1\u018aZ4W\u00ea\u00ean\u00b5L\u00f2\u00cf\u0092\u00c4wc\u001a\u00faj*\u00d5\u0096T\u00f6\u00a7;=\u00d3\u0118'5A\u0085\u0157\b{\u00d0~\u009c\u00dd\u00d1p7\u00a7r_XMx\u008c.b\u00b3\u0083\u00d0\u0097\u000e\u009b\u00b2\u00db\u00b6B\u0003R\u0017\u0152\u0098t\"\u001a%\u001b<\u0084/p\u00dc\u00db\u0093\u0014j\u00f9=G\u00fe\u00d0\u00f44[\b\u0012\u001e\u001a3/\u00002\u00a2\u00b0\u001e\u0015%\u00be\r\u00e06\u00b5\u00a5oS1!TS\u009f\u00ac\u00ca\u0095_\u01b4Ah\u00c4V\u0080\u0081$\u0019\u001f\u013b\f\u00b3w\u00de\u000e\u00e2\u0014F\u00f5\u01d0\u00c4!\u01fb\u001e\u000e`x\u00b2/{\u00b0\u00f2\u00f6\u00eb6\b_\u0086x\u00d0\u0013'\u00d23\u00e2\f\u00a4Y\u001d\u00ff=\u00ce\u00d3\u0080\u001b\u00e3\u000f?\u008ce\u0017*\u00abj\u00e8\u00f3=S\u00f2\u00a2\u00fb\u0018r\u00af\u00da\u009f@\u00d8\u00d04\u0081+\u0018r\u0087\u0081\u0011q\u0086\u001e\u00aa\u00c6\u00caGK\u00c8-(o\u00b1@ka\u00c0[T\u0000\u001a\u00d4\u00ed2]\u007f~\u00e7\u00a0\u00e4o\u00ec\u0095\u00c4\u008a\u00af\u007f\u00baq\u009f%c\u008c\u00e3\"\u0015\u00e4\u0017W\u00b8\u00b8\u00be\u00a7\u0012L(q\u00dd\u00afo6\u00c0#\u00c1\u00da\u00aaY\u00bc\u0014\u0001V)\u00e4\u00ee\u009c\u00ee{\\+\u00cd\u00a9\u0084\u0010r\u00fb\u00f8\u00e8\f\u00cc\u00ceE(\u0093\u009b\u0003\u00a0c\u008d\"e\u00ee\u0098V\u009a:\u00ae\u0133\u00c6\u00c4\u0151\u009f\u01fd,#\u0080y\u0010\u001c\u00ea\u0011\u000e\f\u00ed\u0099d/^\u00175?\u0016\u01de\u001f\u00a5\u019a\u00ceL\u001b\u0000\u00ab\u00fd\u00e7\u00ac5AOVx\u015d\u0015\u00ba\u00ce\u00e7}\u00cb\u00d7\u00c1\u00a3\u00c9\u00ab\u00d3N\u0095\u00a8\u00fe:\u00fd\u00ad\u00c7L\u0094<\u0080,\u0010\u00b6\u00eaF\u0019\u00b8\u00fe\u0090\u0087\u0012\u008ezC`\u0010\u00b5\u001a}\rGg\u0084\u00ef\u0000\u00b3\u00c7\u00da\u00bf\u00can\u00e98\u0084\u0014[\u000f\u00bd\u00f9\u0084{\u00d2\u00b6\u00fa\u0002\u00831PbFc;\u00dc\u0090'_\u0090\u00ef\u009c\u001e\u00af\b]\u00e1\u0092\u00e9ZRS1\u001a^\u001a\u00f3l_\u00d4\u0088\u00e5qVH\ng\u0084t\u0094\u00b1\u0005\u00ef3\u00d9&;\u00f7\u008f\u007f\u00b5\u00a9z\u001a\u017b\u00bc\u00a9Q';1\u00e9\u001f\u0002\u00ad\u00960\u00e1aa\u00c8\u00944b\u00c9\u00ce\u00baK\u00f0\u0091;L\u0089\u0013n\u00af^\u00d1\u009e\u00f6\u0003\u00ea\u00c9\u00c6\u00fd/\u00afX\u00f58V\u0086\u008e\u0096\u001d\u00ef\u0086\u0015)\u00cb\u00b6t\u0086\u0093\u00ac\u00e7\u001a\u00a7UDj]\u00a1\u0086\u000b'4\u00b0X\u00e5fuy\u00ce7V\u009f\u00c4\u0089\u00ed\u00e8c\u0190<P\u00d4\n\u00a9\u00a9\u00a5q\u00c4\u00f3\u001f&\u00e3\u00baD\u00c5\u00a7\u00c0M\u0000bN\u00a4\u000f\u00f8\u00e2\u008f\u00126\u00ee\u0081L\u00a99\u00c0\u009e\u000b\u0018\u00ec\u00d5\u0085\u0089\u00f4sG\u00ce<\u0005\u00f6\u0080\u009a\\|x?\u00f8[R\u001fNm0\u00a1X\u00db\u00e2\u009f\u00cd\u00b7\u0171>U/GQ\u00a0\u00b3V\u00f1\u00de\u00ab\f1\u00f5\u00ff\u001e+\u001f\u001c\u00c3\u009a8eb(\u0090\u00c7f\u0013\u00c9\u00d4\u0098\u0098\u0099\u0000\u0099\u00d9\u00df\u01b6\u0091\nl\u00bf\u00e2\u00d0I\u00df\u00c3\u00c8\u00f9Q\u001c\u00ef\u00deC,\u00c0\u00f7\u00b5\u00dd\u00fd\u000b\u01c6\u00b1\u00fd\u00bc\u00b9\u0161\u0018\u0018\u00a3\u00cf\u00df\u0096)\u00a7\u00c0\u0179\u013f\u0013\fQ~\u009aqd\u00024\u00f1L:o\u0085'\u00e7}\u00fc\u009cw\u0012\u00aa\u0004\u0099\u00bd\u0016U;\u001c\u00f0\u0090\u00cf\u0013%Y\u0084\\\u00d0\u00ed}\u0015\u007fN\u001b\u00e8\u0087y\u00db\u00b56~0\u0095&\u001f\u01e5\t\u000b\u0011\u0001sD\u0083\t\u00c9\u00afR\u00ed\u001f\u00af\u0014/\u0093|#A\u001e]\u001a9\u0090\u00d7\u00e0\u017b\u00d7[)\u00ec^\u009d\u00f8[\u009e/\u0095)\u008f\u0000\u0013\u00f9\u00d4\u00a8\u0089\u00c4~C<\u00a0Y\u00b6\u00f1<\u0084Wc\u0004\u009d%\u0085\u0094\t\u00d2\u016f\u0012\u00de\u0176z\u01503 \u00da\u0004hh\u008cI\u00d7\u00e5\u00c7\u0099\u0019\u00ca\u00fd\u00db\u00f9\u0004\u00ecn\u00b9\u00e0\u00d2\u00d5\u00ee\u0105\u0080\u0096\u00b5\u00f1\u01c9\u0086\u00a8\u0001\u0004\u00a6\u0092\u0096\u0099\u00df\u009ao\u00f8\u00fb\u00b9\f\u0012%\u00b0\u00ea\u00ef\u0018\u0018\u009cj\\\u00ac\u00ca1i\\(\u0014\u009a\u0090sV_\u0000_\u00ad\u00b6\u00dc{\u00ec#\u00f6.\u00d5\u0082\u00bac\u00bf\u00ed\u00b3\u00fb\u00baBr\u00aa\u00b7\u00e3ao\u00fd\u00a2n\u00adC,g\u0097l\u00afuP\u0015C\u00c4\u000f01\u00ea\u00d2|\u00be\u00eb\u00fc\u00e7\u00d24\u00ac\u00dc\u00b5\u0014\u0144\u00e6?\u00ec\u0087\u00cc\u009c\u00ee\u0000\u0196\u00e7\u00e2\u00cc\u00f7\u00f6 \u00a7`\u00a1\u01c8";
                var4_3 = "\u00b7r\u00f8\u0013\u00e3\u008aJ\u00b57\u00e7#\u0082y\r\u00af=@\u00f2K\u00b4\u00a4W\u0084*\u001c\u00c4\u0083\u00ab\u0098\u00f4W\u00d8&&\u00e1&\u00c5r/]4\u00e4]oc3\u00ce\u00bc3-\u00b6V8;\u00a2Qd\u0093\u00cc\u013c\u00d1\u00b4\u010e(\u015fg\u001e\u00cd \u00b97\u00dfw\u00bf\u00be,{\u00073\u0005\u00e5\u00f2\u0018\u00ea2\u00046\u00e8\u00e61\u0155\u00e1-J\u008c\u00d2\u0189!K8i4\u00c5\r\u00ea\u00aeA\u01c5\u00c0\u0095\u0086\u00f2\u019e\u0016\u00e0\u01f6\u00a8\u001d']\u00a2\u0016\u00eb\u018dju\u00fad\u00fa{:\nD\t\u00e7\u0006\u00e9\u0005\u00d7\u0093{:(\u00f3\u000f~\u00d2'\u00db\u00a0=\u00d8\u009a>\u00b1>\u0080P\u0003\u00db/\u00a7\u0014\u00cf\u001c\u0088P\u0012\u0093\f\u00a6+\u00e0\u00ee\u0095-O\u01d1\u00fa\u0098\u01d6\u000b\u010d#\u00f0\u0082\u001ec+\u00e3!\u00f0\u00e8\u009cqe\u00b0\u00ect\u00d5\u0014\u00d66J\u00f4\u00b7\u00d3B\u00b9\u001f\u00e4\u0001k\u00e8\u00d8\u00f5n&@'\u0082\u00f5P\u008d\u00e2 \u0018T\u00d8&\u0099\u009d\u0097\u0099\u0088\u0166\u00c5\u0019\u00c6\u01e7\u0012\u01e5\u00b55\u00a7?\u00a5)\u00ceP\u0000\u0098\u00d3\u00e3\u0088\u01fd\u00da\u008b\u00d3\u001c\u00a6Qj\u00dd\u00e5\u00c9\u0011\u001ai\u00f3\u0154\u00ae\u00af_\u00f3\u011dQ\u0097\u008a>\u00fa\u00a8\u008d`T\u0181\u01ad\f#?\u009b\u00e7@\u0014\u009a\u00d1}\u0016\u00b7\u001b\u00ea\u00b1\u00af\u00c8(\u00a9\u013c\u00e8\u00f9\u0164E\u0093j\u00fb\u0085\u0082\"C\u008d\u00bcX\u00e9\u009a\u01aa\u000e\u00b0\u00b7\u00be\u0016\u00ee\u0017\u00c4\u0098\u018d\u00ca?\u01d4\u000f\u01b9\u0016GL@i1\u00f8.p\u00ddu\u00cb\u00d6 \u00e22n0\u00f5\u00c0\u00b75A.\u008b\u0090q!\u00c6\u00a5\u009c\u00f2_c\u00ce\u008e g\u0093\u00ff\u00a3\u00b0\u00a5\u00ef:dH\u009e\u0089\u008e\u00c9t\u0082\u00c76\u009fn#!\u0090\u0005\u00f6\u00c4\u00f5\u0002\u00f3\u0088\u0088K1\u0010\u008b\u00ca#\u00fc\u00d2\u00d6 \u00d8l\u00af\u008a\u00bd\u009b\u00a2\u00bd\u00f6\u001f\u0091?\u00dd\u000e\u0013U\u00ff\u00b1\u00ae\u00ee\u00b2\u001b\u00af\tw\u0010\u0087g\u00c0q;>Rp\u00acp\u0097\u00c5\u00e1x\u00ed\u0018,\u00dbM!O\u001e\u00c9\u0087y\u0090MN\u00ddeu\u00b7k\u00b2q\u00a3\u0097q>f\u0018\u009a\u00c4\u009b\u00c2\u0095b\u0092\b\u0012a pp\u00a2\u00c0O\u00dd\u00ad\u00a7@M\re\u00e9)\u0000\u0013\u0000Q\u00e8\u00abY3\u00e7[\u00d9\u0089\u00c2\u0087\u00cf\u00e3(3\u00d9\u0097\u0000lq^-R\u00eb\u009e\u00d7\u00e7qu\u00deS\u01afyW\u01a6\u00ed\u0103b6\u00a6\u0002j\u00b5\u00e9\u0092\u0015\u00ac\u00e3F\nr\u0096\u00ae\u00a4V\u00db\u000e\u00a6\u00dd\u00fd\u0002\u00b6\u00e0\u00d4\u00a6\u00e4\u00fe\u0019\u00fa\u00b9\u00a8\u009fg^\u00cf\u0080I\u0169\u00f9\b\u00b5\u0007\u0140\u00cf<YK\u0080\u0006\u00c2\u00b5\u00bc\u013b\u0015\u00c24b\u00ed\u00e8\u00c8;\u00a5\u00e1\u000b\u0010|\u00dd\u007f\u00ff\u00f1<4\u00f2\u0014\u00e6-0-\u0006\u0096(SA,\u00e4\u00aa\u01a8\u00aa\u00d3\u0093hc\u00d8\u00e2\"c\n\u00ba\u00c4d\u00ff\u00d1\u001b\u0082N\u00a0\u0086\u0096S@\u00cd\u00f6\u008ciwS\u00ec\u00a1\u008e\u00f4\u0158'\u00b3Fv\u00fb&\u00fe\u0080\u0099\u00dc\u000e\u00be#.\u00d2RI\u009b(\u00af>\u00d5\u00b0\u00fap8\u00a6\u00d78\u000e&%\u00a0\u008f\u008e\u00bc\u0019ay\f\u0019*\u0090\u00ed\u00f2\u0084\u008b\u0098\u001e\u000b\u00b8\u0011o{\u00d5^\u0093D,\u0097TK\u0083\u00a4\u00a4\u0084\u001e\u0012N\u00ad Q\u0095d\u017a\u00183\u001b-T\u01dcd\u0083 P\u001cy\u00c3\u00010\u000flX\u00c2\u01b0\u00c8\u00b3\u0011`/M\u0001?\u00d1@b\u0099\u00c2b\u00b0\u00bcQ,d\u00cd\u0014l=%G\u009d=\u00aa\u00dd\u0140b\u0086\u01c18\u011b\u00f9t\u008b\u0131 \u000e\"V\u001d\u00d6\n\u00ed\u00d6\u0014\u00b9[\u00d0\u00b7Q\u0084]\u0085m\u0085\u00a0 \u00c6\u00d6\u0004&4\u0082\u00d9\u00a9\u00db\u00a6\u00ce\u0089\u00d9\u00e8\u001d\f\u0095\u00ae\u0002kwAV\u0099\u00007\u00e6$'\u00e9\u00d2=iO\u00ac\u00ad\u00d3yU\u011bU\u00a5l\u00a6\u009c\u0001\u001d\u0019\u00b7zt9\u00ef\u00d5\u00c6p\u00f7\u0093[\u00d6a\u0085\u001b\u000f\u0092\u00a9\u0003\u0101\bn\u00d0@\"\u00c0\u00b9\tW\u0014\u01c4\u00bb/G\u0085\u00b9\u00dc@\b\u0143\u00e6X\u00ec\u00a0\u00f2\u00ca'=\u00b1\u0163\u0019\u009cC\u0093[\u009a\u00e0\u0001\u0013<\u0172oc~!\u0007\u01fe\u00baV.\u00dc\u0090\u001e\u00f4\u001a\u00b2\u001b\u00af7\u00f5\u00d5V+\u008e5\n\n\u00c3\u0018\u00dc)\u00e1\u0170\u00e8\u00dbc\u01bf\u00a6\u00be<\u000ek\u014c\u0007\u001f\u0117MU\u0099\u00cab=\u00a1&\u008dJ\u00daQ\u000e86\u00dd\u00d7\"\u00ab\u008a\u000f$8\u0016\u00d42h\u01c7\u00c6\u00cc\u0011\u00aa\u00d8\u0014\u00ff\u0014\u000e%\u00995\u00bd\u00f7_\u000e\u00acz\u00db\u0007\u0003\u009e\u009f\u00dd,+\u00dee\u00e8D\u0096\u00da\u00ddG\u00dfIa\u00d0\u009a\u008d@`G\u00d6\u0018(\u00ae\u00ceH\u0019V\u00cba\u00d5\u00f8\u0016?\u00da\u0094\u001b\u00bc+\u00b8\u000f\u00ae\u00aeBED\u001c\u0084\u00b6\u000e'BL\u00acp\u00deA\u00c3\u00a5N\u0089\u007f\u00aen\u00caX\u0092E\u00ban.\u00c0\u00e0\u0084\u009c*A\u0017(\u00d1\u00ed\u00bb\u00f91\u00f3\u001b[\u0081\u0092\u0086\u00c5\u00c3i7\u00f6\u0015\u0016|`U\u00e6\u0010\f\u00f1o\u00cfH\u00cf9@g\u0146\u00a4\u00fb\u01a0\u00c1\u018aZ4W\u00ea\u00ean\u00b5L\u00f2\u00cf\u0092\u00c4wc\u001a\u00faj*\u00d5\u0096T\u00f6\u00a7;=\u00d3\u0118'5A\u0085\u0157\b{\u00d0~\u009c\u00dd\u00d1p7\u00a7r_XMx\u008c.b\u00b3\u0083\u00d0\u0097\u000e\u009b\u00b2\u00db\u00b6B\u0003R\u0017\u0152\u0098t\"\u001a%\u001b<\u0084/p\u00dc\u00db\u0093\u0014j\u00f9=G\u00fe\u00d0\u00f44[\b\u0012\u001e\u001a3/\u00002\u00a2\u00b0\u001e\u0015%\u00be\r\u00e06\u00b5\u00a5oS1!TS\u009f\u00ac\u00ca\u0095_\u01b4Ah\u00c4V\u0080\u0081$\u0019\u001f\u013b\f\u00b3w\u00de\u000e\u00e2\u0014F\u00f5\u01d0\u00c4!\u01fb\u001e\u000e`x\u00b2/{\u00b0\u00f2\u00f6\u00eb6\b_\u0086x\u00d0\u0013'\u00d23\u00e2\f\u00a4Y\u001d\u00ff=\u00ce\u00d3\u0080\u001b\u00e3\u000f?\u008ce\u0017*\u00abj\u00e8\u00f3=S\u00f2\u00a2\u00fb\u0018r\u00af\u00da\u009f@\u00d8\u00d04\u0081+\u0018r\u0087\u0081\u0011q\u0086\u001e\u00aa\u00c6\u00caGK\u00c8-(o\u00b1@ka\u00c0[T\u0000\u001a\u00d4\u00ed2]\u007f~\u00e7\u00a0\u00e4o\u00ec\u0095\u00c4\u008a\u00af\u007f\u00baq\u009f%c\u008c\u00e3\"\u0015\u00e4\u0017W\u00b8\u00b8\u00be\u00a7\u0012L(q\u00dd\u00afo6\u00c0#\u00c1\u00da\u00aaY\u00bc\u0014\u0001V)\u00e4\u00ee\u009c\u00ee{\\+\u00cd\u00a9\u0084\u0010r\u00fb\u00f8\u00e8\f\u00cc\u00ceE(\u0093\u009b\u0003\u00a0c\u008d\"e\u00ee\u0098V\u009a:\u00ae\u0133\u00c6\u00c4\u0151\u009f\u01fd,#\u0080y\u0010\u001c\u00ea\u0011\u000e\f\u00ed\u0099d/^\u00175?\u0016\u01de\u001f\u00a5\u019a\u00ceL\u001b\u0000\u00ab\u00fd\u00e7\u00ac5AOVx\u015d\u0015\u00ba\u00ce\u00e7}\u00cb\u00d7\u00c1\u00a3\u00c9\u00ab\u00d3N\u0095\u00a8\u00fe:\u00fd\u00ad\u00c7L\u0094<\u0080,\u0010\u00b6\u00eaF\u0019\u00b8\u00fe\u0090\u0087\u0012\u008ezC`\u0010\u00b5\u001a}\rGg\u0084\u00ef\u0000\u00b3\u00c7\u00da\u00bf\u00can\u00e98\u0084\u0014[\u000f\u00bd\u00f9\u0084{\u00d2\u00b6\u00fa\u0002\u00831PbFc;\u00dc\u0090'_\u0090\u00ef\u009c\u001e\u00af\b]\u00e1\u0092\u00e9ZRS1\u001a^\u001a\u00f3l_\u00d4\u0088\u00e5qVH\ng\u0084t\u0094\u00b1\u0005\u00ef3\u00d9&;\u00f7\u008f\u007f\u00b5\u00a9z\u001a\u017b\u00bc\u00a9Q';1\u00e9\u001f\u0002\u00ad\u00960\u00e1aa\u00c8\u00944b\u00c9\u00ce\u00baK\u00f0\u0091;L\u0089\u0013n\u00af^\u00d1\u009e\u00f6\u0003\u00ea\u00c9\u00c6\u00fd/\u00afX\u00f58V\u0086\u008e\u0096\u001d\u00ef\u0086\u0015)\u00cb\u00b6t\u0086\u0093\u00ac\u00e7\u001a\u00a7UDj]\u00a1\u0086\u000b'4\u00b0X\u00e5fuy\u00ce7V\u009f\u00c4\u0089\u00ed\u00e8c\u0190<P\u00d4\n\u00a9\u00a9\u00a5q\u00c4\u00f3\u001f&\u00e3\u00baD\u00c5\u00a7\u00c0M\u0000bN\u00a4\u000f\u00f8\u00e2\u008f\u00126\u00ee\u0081L\u00a99\u00c0\u009e\u000b\u0018\u00ec\u00d5\u0085\u0089\u00f4sG\u00ce<\u0005\u00f6\u0080\u009a\\|x?\u00f8[R\u001fNm0\u00a1X\u00db\u00e2\u009f\u00cd\u00b7\u0171>U/GQ\u00a0\u00b3V\u00f1\u00de\u00ab\f1\u00f5\u00ff\u001e+\u001f\u001c\u00c3\u009a8eb(\u0090\u00c7f\u0013\u00c9\u00d4\u0098\u0098\u0099\u0000\u0099\u00d9\u00df\u01b6\u0091\nl\u00bf\u00e2\u00d0I\u00df\u00c3\u00c8\u00f9Q\u001c\u00ef\u00deC,\u00c0\u00f7\u00b5\u00dd\u00fd\u000b\u01c6\u00b1\u00fd\u00bc\u00b9\u0161\u0018\u0018\u00a3\u00cf\u00df\u0096)\u00a7\u00c0\u0179\u013f\u0013\fQ~\u009aqd\u00024\u00f1L:o\u0085'\u00e7}\u00fc\u009cw\u0012\u00aa\u0004\u0099\u00bd\u0016U;\u001c\u00f0\u0090\u00cf\u0013%Y\u0084\\\u00d0\u00ed}\u0015\u007fN\u001b\u00e8\u0087y\u00db\u00b56~0\u0095&\u001f\u01e5\t\u000b\u0011\u0001sD\u0083\t\u00c9\u00afR\u00ed\u001f\u00af\u0014/\u0093|#A\u001e]\u001a9\u0090\u00d7\u00e0\u017b\u00d7[)\u00ec^\u009d\u00f8[\u009e/\u0095)\u008f\u0000\u0013\u00f9\u00d4\u00a8\u0089\u00c4~C<\u00a0Y\u00b6\u00f1<\u0084Wc\u0004\u009d%\u0085\u0094\t\u00d2\u016f\u0012\u00de\u0176z\u01503 \u00da\u0004hh\u008cI\u00d7\u00e5\u00c7\u0099\u0019\u00ca\u00fd\u00db\u00f9\u0004\u00ecn\u00b9\u00e0\u00d2\u00d5\u00ee\u0105\u0080\u0096\u00b5\u00f1\u01c9\u0086\u00a8\u0001\u0004\u00a6\u0092\u0096\u0099\u00df\u009ao\u00f8\u00fb\u00b9\f\u0012%\u00b0\u00ea\u00ef\u0018\u0018\u009cj\\\u00ac\u00ca1i\\(\u0014\u009a\u0090sV_\u0000_\u00ad\u00b6\u00dc{\u00ec#\u00f6.\u00d5\u0082\u00bac\u00bf\u00ed\u00b3\u00fb\u00baBr\u00aa\u00b7\u00e3ao\u00fd\u00a2n\u00adC,g\u0097l\u00afuP\u0015C\u00c4\u000f01\u00ea\u00d2|\u00be\u00eb\u00fc\u00e7\u00d24\u00ac\u00dc\u00b5\u0014\u0144\u00e6?\u00ec\u0087\u00cc\u009c\u00ee\u0000\u0196\u00e7\u00e2\u00cc\u00f7\u00f6 \u00a7`\u00a1\u01c8".length();
                var1_4 = 3;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00ca\u00eaYn\u00c3\\<\u00db\\\u00d7\t\u00a6\u00c4W\u00caN\u00ed\u00f8\u00e4o\u00f4\u00cd\u00b2\u0130\u0091\u01d1[C\rd\u00bd\u000f\u0003HI\u00eco R\u014b]\u00ad/\u0017^\u00e2\u00f8\u00b4\u009e\u00d2\u0095\u0096\u008f\u00f7\u0019\u0007JsD>\u0095\u00bb'\u00f8\u00bf\tG\u00e1=\u00d0\u008a%\u00a6\u00f1\u0080\u00e0\u00e3q\u00b5\u009b\u00d6kU\u0014\u00a4\u00f8\u00e1\u00c6\u00e2\u0155";
                    var4_3 = "\u00ca\u00eaYn\u00c3\\<\u00db\\\u00d7\t\u00a6\u00c4W\u00caN\u00ed\u00f8\u00e4o\u00f4\u00cd\u00b2\u0130\u0091\u01d1[C\rd\u00bd\u000f\u0003HI\u00eco R\u014b]\u00ad/\u0017^\u00e2\u00f8\u00b4\u009e\u00d2\u0095\u0096\u008f\u00f7\u0019\u0007JsD>\u0095\u00bb'\u00f8\u00bf\tG\u00e1=\u00d0\u008a%\u00a6\u00f1\u0080\u00e0\u00e3q\u00b5\u009b\u00d6kU\u0014\u00a4\u00f8\u00e1\u00c6\u00e2\u0155".length();
                    var1_4 = 42;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 29;
                            break;
                        }
                        case 1: {
                            v13 = 40;
                            break;
                        }
                        case 2: {
                            v13 = 86;
                            break;
                        }
                        case 3: {
                            v13 = 77;
                            break;
                        }
                        case 4: {
                            v13 = 59;
                            break;
                        }
                        case 5: {
                            v13 = 17;
                            break;
                        }
                        default: {
                            v13 = 98;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        OCSPClient.r = var5;
        OCSPClient.s = new String[71];
        OCSPClient.c = OCSPClient.a(-7188, -11636);
        OCSPClient.d = OCSPClient.a(-7222, -4067);
        OCSPClient.e = OCSPClient.a(-7219, 25911);
        OCSPClient.a = OCSPClient.a(-7212, -4669);
        OCSPClient.b = OCSPClient.a(-7176, 14980);
        OCSPClient.logger = LoggerFactory.getLogger(OCSPClient.class);
        OCSPClient.NONCE_OID = new Asn1ObjectIdentifier(_ocspValues.id_pkix_ocsp_nonce);
        OCSPClient.g = LoggerFactory.getLogger(OCSPClient.class);
        OCSPClient.digestAlgForOcspRequest = DigestAlg.SHA256;
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0xFFFFE3E9) & 0xFFFF;
        if (s[n4] == null) {
            int n5;
            int n6;
            char[] cArray = r[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 37;
                    break;
                }
                case 1: {
                    n6 = 125;
                    break;
                }
                case 2: {
                    n6 = 182;
                    break;
                }
                case 3: {
                    n6 = 42;
                    break;
                }
                case 4: {
                    n6 = 144;
                    break;
                }
                case 5: {
                    n6 = 24;
                    break;
                }
                case 6: {
                    n6 = 134;
                    break;
                }
                case 7: {
                    n6 = 192;
                    break;
                }
                case 8: {
                    n6 = 247;
                    break;
                }
                case 9: {
                    n6 = 15;
                    break;
                }
                case 10: {
                    n6 = 199;
                    break;
                }
                case 11: {
                    n6 = 71;
                    break;
                }
                case 12: {
                    n6 = 34;
                    break;
                }
                case 13: {
                    n6 = 82;
                    break;
                }
                case 14: {
                    n6 = 96;
                    break;
                }
                case 15: {
                    n6 = 162;
                    break;
                }
                case 16: {
                    n6 = 250;
                    break;
                }
                case 17: {
                    n6 = 173;
                    break;
                }
                case 18: {
                    n6 = 149;
                    break;
                }
                case 19: {
                    n6 = 55;
                    break;
                }
                case 20: {
                    n6 = 223;
                    break;
                }
                case 21: {
                    n6 = 221;
                    break;
                }
                case 22: {
                    n6 = 141;
                    break;
                }
                case 23: {
                    n6 = 77;
                    break;
                }
                case 24: {
                    n6 = 31;
                    break;
                }
                case 25: {
                    n6 = 62;
                    break;
                }
                case 26: {
                    n6 = 80;
                    break;
                }
                case 27: {
                    n6 = 234;
                    break;
                }
                case 28: {
                    n6 = 133;
                    break;
                }
                case 29: {
                    n6 = 87;
                    break;
                }
                case 30: {
                    n6 = 98;
                    break;
                }
                case 31: {
                    n6 = 95;
                    break;
                }
                case 32: {
                    n6 = 238;
                    break;
                }
                case 33: {
                    n6 = 190;
                    break;
                }
                case 34: {
                    n6 = 246;
                    break;
                }
                case 35: {
                    n6 = 174;
                    break;
                }
                case 36: {
                    n6 = 185;
                    break;
                }
                case 37: {
                    n6 = 157;
                    break;
                }
                case 38: {
                    n6 = 105;
                    break;
                }
                case 39: {
                    n6 = 123;
                    break;
                }
                case 40: {
                    n6 = 169;
                    break;
                }
                case 41: {
                    n6 = 74;
                    break;
                }
                case 42: {
                    n6 = 118;
                    break;
                }
                case 43: {
                    n6 = 184;
                    break;
                }
                case 44: {
                    n6 = 90;
                    break;
                }
                case 45: {
                    n6 = 93;
                    break;
                }
                case 46: {
                    n6 = 189;
                    break;
                }
                case 47: {
                    n6 = 140;
                    break;
                }
                case 48: {
                    n6 = 127;
                    break;
                }
                case 49: {
                    n6 = 111;
                    break;
                }
                case 50: {
                    n6 = 253;
                    break;
                }
                case 51: {
                    n6 = 14;
                    break;
                }
                case 52: {
                    n6 = 168;
                    break;
                }
                case 53: {
                    n6 = 232;
                    break;
                }
                case 54: {
                    n6 = 21;
                    break;
                }
                case 55: {
                    n6 = 205;
                    break;
                }
                case 56: {
                    n6 = 48;
                    break;
                }
                case 57: {
                    n6 = 239;
                    break;
                }
                case 58: {
                    n6 = 113;
                    break;
                }
                case 59: {
                    n6 = 85;
                    break;
                }
                case 60: {
                    n6 = 4;
                    break;
                }
                case 61: {
                    n6 = 132;
                    break;
                }
                case 62: {
                    n6 = 64;
                    break;
                }
                case 63: {
                    n6 = 160;
                    break;
                }
                case 64: {
                    n6 = 130;
                    break;
                }
                case 65: {
                    n6 = 68;
                    break;
                }
                case 66: {
                    n6 = 179;
                    break;
                }
                case 67: {
                    n6 = 46;
                    break;
                }
                case 68: {
                    n6 = 73;
                    break;
                }
                case 69: {
                    n6 = 79;
                    break;
                }
                case 70: {
                    n6 = 116;
                    break;
                }
                case 71: {
                    n6 = 164;
                    break;
                }
                case 72: {
                    n6 = 255;
                    break;
                }
                case 73: {
                    n6 = 101;
                    break;
                }
                case 74: {
                    n6 = 217;
                    break;
                }
                case 75: {
                    n6 = 56;
                    break;
                }
                case 76: {
                    n6 = 180;
                    break;
                }
                case 77: {
                    n6 = 187;
                    break;
                }
                case 78: {
                    n6 = 1;
                    break;
                }
                case 79: {
                    n6 = 188;
                    break;
                }
                case 80: {
                    n6 = 245;
                    break;
                }
                case 81: {
                    n6 = 215;
                    break;
                }
                case 82: {
                    n6 = 148;
                    break;
                }
                case 83: {
                    n6 = 131;
                    break;
                }
                case 84: {
                    n6 = 136;
                    break;
                }
                case 85: {
                    n6 = 209;
                    break;
                }
                case 86: {
                    n6 = 200;
                    break;
                }
                case 87: {
                    n6 = 159;
                    break;
                }
                case 88: {
                    n6 = 84;
                    break;
                }
                case 89: {
                    n6 = 128;
                    break;
                }
                case 90: {
                    n6 = 22;
                    break;
                }
                case 91: {
                    n6 = 63;
                    break;
                }
                case 92: {
                    n6 = 161;
                    break;
                }
                case 93: {
                    n6 = 10;
                    break;
                }
                case 94: {
                    n6 = 210;
                    break;
                }
                case 95: {
                    n6 = 119;
                    break;
                }
                case 96: {
                    n6 = 147;
                    break;
                }
                case 97: {
                    n6 = 186;
                    break;
                }
                case 98: {
                    n6 = 172;
                    break;
                }
                case 99: {
                    n6 = 218;
                    break;
                }
                case 100: {
                    n6 = 137;
                    break;
                }
                case 101: {
                    n6 = 175;
                    break;
                }
                case 102: {
                    n6 = 240;
                    break;
                }
                case 103: {
                    n6 = 146;
                    break;
                }
                case 104: {
                    n6 = 81;
                    break;
                }
                case 105: {
                    n6 = 236;
                    break;
                }
                case 106: {
                    n6 = 65;
                    break;
                }
                case 107: {
                    n6 = 43;
                    break;
                }
                case 108: {
                    n6 = 195;
                    break;
                }
                case 109: {
                    n6 = 171;
                    break;
                }
                case 110: {
                    n6 = 235;
                    break;
                }
                case 111: {
                    n6 = 108;
                    break;
                }
                case 112: {
                    n6 = 83;
                    break;
                }
                case 113: {
                    n6 = 167;
                    break;
                }
                case 114: {
                    n6 = 57;
                    break;
                }
                case 115: {
                    n6 = 225;
                    break;
                }
                case 116: {
                    n6 = 163;
                    break;
                }
                case 117: {
                    n6 = 224;
                    break;
                }
                case 118: {
                    n6 = 110;
                    break;
                }
                case 119: {
                    n6 = 230;
                    break;
                }
                case 120: {
                    n6 = 25;
                    break;
                }
                case 121: {
                    n6 = 92;
                    break;
                }
                case 122: {
                    n6 = 112;
                    break;
                }
                case 123: {
                    n6 = 11;
                    break;
                }
                case 124: {
                    n6 = 30;
                    break;
                }
                case 125: {
                    n6 = 6;
                    break;
                }
                case 126: {
                    n6 = 193;
                    break;
                }
                case 127: {
                    n6 = 13;
                    break;
                }
                case 128: {
                    n6 = 109;
                    break;
                }
                case 129: {
                    n6 = 166;
                    break;
                }
                case 130: {
                    n6 = 16;
                    break;
                }
                case 131: {
                    n6 = 115;
                    break;
                }
                case 132: {
                    n6 = 38;
                    break;
                }
                case 133: {
                    n6 = 70;
                    break;
                }
                case 134: {
                    n6 = 60;
                    break;
                }
                case 135: {
                    n6 = 158;
                    break;
                }
                case 136: {
                    n6 = 106;
                    break;
                }
                case 137: {
                    n6 = 75;
                    break;
                }
                case 138: {
                    n6 = 50;
                    break;
                }
                case 139: {
                    n6 = 208;
                    break;
                }
                case 140: {
                    n6 = 54;
                    break;
                }
                case 141: {
                    n6 = 27;
                    break;
                }
                case 142: {
                    n6 = 233;
                    break;
                }
                case 143: {
                    n6 = 226;
                    break;
                }
                case 144: {
                    n6 = 249;
                    break;
                }
                case 145: {
                    n6 = 40;
                    break;
                }
                case 146: {
                    n6 = 44;
                    break;
                }
                case 147: {
                    n6 = 227;
                    break;
                }
                case 148: {
                    n6 = 122;
                    break;
                }
                case 149: {
                    n6 = 138;
                    break;
                }
                case 150: {
                    n6 = 120;
                    break;
                }
                case 151: {
                    n6 = 201;
                    break;
                }
                case 152: {
                    n6 = 222;
                    break;
                }
                case 153: {
                    n6 = 0;
                    break;
                }
                case 154: {
                    n6 = 18;
                    break;
                }
                case 155: {
                    n6 = 181;
                    break;
                }
                case 156: {
                    n6 = 151;
                    break;
                }
                case 157: {
                    n6 = 45;
                    break;
                }
                case 158: {
                    n6 = 242;
                    break;
                }
                case 159: {
                    n6 = 213;
                    break;
                }
                case 160: {
                    n6 = 23;
                    break;
                }
                case 161: {
                    n6 = 17;
                    break;
                }
                case 162: {
                    n6 = 135;
                    break;
                }
                case 163: {
                    n6 = 206;
                    break;
                }
                case 164: {
                    n6 = 219;
                    break;
                }
                case 165: {
                    n6 = 142;
                    break;
                }
                case 166: {
                    n6 = 191;
                    break;
                }
                case 167: {
                    n6 = 248;
                    break;
                }
                case 168: {
                    n6 = 97;
                    break;
                }
                case 169: {
                    n6 = 153;
                    break;
                }
                case 170: {
                    n6 = 194;
                    break;
                }
                case 171: {
                    n6 = 202;
                    break;
                }
                case 172: {
                    n6 = 254;
                    break;
                }
                case 173: {
                    n6 = 244;
                    break;
                }
                case 174: {
                    n6 = 237;
                    break;
                }
                case 175: {
                    n6 = 26;
                    break;
                }
                case 176: {
                    n6 = 86;
                    break;
                }
                case 177: {
                    n6 = 212;
                    break;
                }
                case 178: {
                    n6 = 183;
                    break;
                }
                case 179: {
                    n6 = 216;
                    break;
                }
                case 180: {
                    n6 = 214;
                    break;
                }
                case 181: {
                    n6 = 7;
                    break;
                }
                case 182: {
                    n6 = 170;
                    break;
                }
                case 183: {
                    n6 = 59;
                    break;
                }
                case 184: {
                    n6 = 252;
                    break;
                }
                case 185: {
                    n6 = 52;
                    break;
                }
                case 186: {
                    n6 = 220;
                    break;
                }
                case 187: {
                    n6 = 72;
                    break;
                }
                case 188: {
                    n6 = 3;
                    break;
                }
                case 189: {
                    n6 = 89;
                    break;
                }
                case 190: {
                    n6 = 156;
                    break;
                }
                case 191: {
                    n6 = 203;
                    break;
                }
                case 192: {
                    n6 = 196;
                    break;
                }
                case 193: {
                    n6 = 177;
                    break;
                }
                case 194: {
                    n6 = 178;
                    break;
                }
                case 195: {
                    n6 = 126;
                    break;
                }
                case 196: {
                    n6 = 19;
                    break;
                }
                case 197: {
                    n6 = 102;
                    break;
                }
                case 198: {
                    n6 = 2;
                    break;
                }
                case 199: {
                    n6 = 228;
                    break;
                }
                case 200: {
                    n6 = 49;
                    break;
                }
                case 201: {
                    n6 = 121;
                    break;
                }
                case 202: {
                    n6 = 51;
                    break;
                }
                case 203: {
                    n6 = 197;
                    break;
                }
                case 204: {
                    n6 = 99;
                    break;
                }
                case 205: {
                    n6 = 94;
                    break;
                }
                case 206: {
                    n6 = 100;
                    break;
                }
                case 207: {
                    n6 = 155;
                    break;
                }
                case 208: {
                    n6 = 28;
                    break;
                }
                case 209: {
                    n6 = 139;
                    break;
                }
                case 210: {
                    n6 = 129;
                    break;
                }
                case 211: {
                    n6 = 103;
                    break;
                }
                case 212: {
                    n6 = 76;
                    break;
                }
                case 213: {
                    n6 = 41;
                    break;
                }
                case 214: {
                    n6 = 231;
                    break;
                }
                case 215: {
                    n6 = 91;
                    break;
                }
                case 216: {
                    n6 = 66;
                    break;
                }
                case 217: {
                    n6 = 117;
                    break;
                }
                case 218: {
                    n6 = 241;
                    break;
                }
                case 219: {
                    n6 = 33;
                    break;
                }
                case 220: {
                    n6 = 124;
                    break;
                }
                case 221: {
                    n6 = 229;
                    break;
                }
                case 222: {
                    n6 = 145;
                    break;
                }
                case 223: {
                    n6 = 107;
                    break;
                }
                case 224: {
                    n6 = 154;
                    break;
                }
                case 225: {
                    n6 = 152;
                    break;
                }
                case 226: {
                    n6 = 39;
                    break;
                }
                case 227: {
                    n6 = 165;
                    break;
                }
                case 228: {
                    n6 = 20;
                    break;
                }
                case 229: {
                    n6 = 114;
                    break;
                }
                case 230: {
                    n6 = 8;
                    break;
                }
                case 231: {
                    n6 = 5;
                    break;
                }
                case 232: {
                    n6 = 9;
                    break;
                }
                case 233: {
                    n6 = 143;
                    break;
                }
                case 234: {
                    n6 = 198;
                    break;
                }
                case 235: {
                    n6 = 36;
                    break;
                }
                case 236: {
                    n6 = 35;
                    break;
                }
                case 237: {
                    n6 = 251;
                    break;
                }
                case 238: {
                    n6 = 47;
                    break;
                }
                case 239: {
                    n6 = 243;
                    break;
                }
                case 240: {
                    n6 = 29;
                    break;
                }
                case 241: {
                    n6 = 211;
                    break;
                }
                case 242: {
                    n6 = 69;
                    break;
                }
                case 243: {
                    n6 = 58;
                    break;
                }
                case 244: {
                    n6 = 150;
                    break;
                }
                case 245: {
                    n6 = 207;
                    break;
                }
                case 246: {
                    n6 = 176;
                    break;
                }
                case 247: {
                    n6 = 204;
                    break;
                }
                case 248: {
                    n6 = 12;
                    break;
                }
                case 249: {
                    n6 = 32;
                    break;
                }
                case 250: {
                    n6 = 53;
                    break;
                }
                case 251: {
                    n6 = 67;
                    break;
                }
                case 252: {
                    n6 = 61;
                    break;
                }
                case 253: {
                    n6 = 88;
                    break;
                }
                case 254: {
                    n6 = 104;
                    break;
                }
                default: {
                    n6 = 78;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            OCSPClient.s[n4] = new String(cArray).intern();
        }
        return s[n4];
    }
}

