/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.reader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.ElementFactory;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.OcspConfigTags;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.AbstractConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.DbProviderConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.IOcspConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.IResponsibleCaElement;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.NonceControlConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.ResponsibleCaElement;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.reader.IOcspConfigurationReader;
import tr.gov.tubitak.uekae.esya.api.infra.util.HashMultiMap;

public abstract class AbstractOcspConfigurationReader
implements IOcspConfigurationReader {
    protected Document document;
    protected HashMultiMap<OcspConfigTags, IOcspConfigElement> multiMap = new HashMultiMap();
    public static OcspConfigTags[] elementNames = new OcspConfigTags[]{OcspConfigTags.SIGNER, OcspConfigTags.PREFERREDSIGNALG, OcspConfigTags.SUPPORTEDSIGNALG, OcspConfigTags.OCSPSIGNCERT, OcspConfigTags.OCSPENCRCERT, OcspConfigTags.RESPONSIBLECA, OcspConfigTags.URL, OcspConfigTags.NONCECONTROL};
    public static OcspConfigTags[] providerType = new OcspConfigTags[]{OcspConfigTags.CRLPROVIDER, OcspConfigTags.DBPROVIDER};
    public static int NEXTUPDATEMIN = 10;
    public static int NONCECACHETIME = 1;
    public static int b;

    @Override
    public void read(InputStream inputStream) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.parse(inputStream);
        this.document.getDocumentElement().normalize();
        OcspConfigTags[] ocspConfigTagsArray = elementNames;
        int n2 = ocspConfigTagsArray.length;
        int n3 = b;
        for (int i2 = 0; i2 < n2; ++i2) {
            OcspConfigTags ocspConfigTags = ocspConfigTagsArray[i2];
            this.putValueByTagNameToMap(ocspConfigTags);
            if (n3 == 0) continue;
            boolean bl = !AbstractConfigElement.b;
            AbstractConfigElement.b = bl;
            break;
        }
    }

    protected void putValueByTagNameToMap(OcspConfigTags tag) throws Exception {
        block3: {
            NodeList nodeList = this.findElementByTagNameFromDocument(tag);
            int n2 = b;
            if (nodeList == null || nodeList.getLength() <= 0) break block3;
            for (IOcspConfigElement iOcspConfigElement : this.a(tag, nodeList)) {
                this.multiMap.put(tag, iOcspConfigElement);
                if (n2 == 0) continue;
            }
        }
    }

    private List<IOcspConfigElement> a(OcspConfigTags ocspConfigTags, NodeList nodeList) throws Exception {
        ArrayList<IOcspConfigElement> arrayList = new ArrayList<IOcspConfigElement>();
        int n2 = b;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            IOcspConfigElement iOcspConfigElement;
            block13: {
                Element element;
                block12: {
                    element = (Element)nodeList.item(i2);
                    iOcspConfigElement = ElementFactory.createConfigElement(ocspConfigTags);
                    if (element == null || iOcspConfigElement == null) continue;
                    if (!(iOcspConfigElement instanceof IResponsibleCaElement)) break block12;
                    ((IResponsibleCaElement)iOcspConfigElement).addStatusProviders(this.a(element));
                }
                if (element.getNodeType() != 1 || iOcspConfigElement.getElementNames() == null) break block13;
                for (OcspConfigTags ocspConfigTags2 : iOcspConfigElement.getElementNames()) {
                    String string = this.getTagValue(ocspConfigTags2, element);
                    if (string == null) continue;
                    iOcspConfigElement.addElement(ocspConfigTags2, string);
                }
            }
            arrayList.add(iOcspConfigElement);
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    private List<IOcspConfigElement> a(Element element) throws Exception {
        ArrayList<IOcspConfigElement> arrayList;
        block7: {
            arrayList = new ArrayList<IOcspConfigElement>();
            int n2 = b;
            ArrayList<OcspConfigTags> arrayList2 = new ArrayList<OcspConfigTags>(Arrays.asList(providerType));
            NodeList nodeList = element.getElementsByTagName(OcspConfigTags.STATUSPROVIDERS.getTagName());
            if (nodeList == null || nodeList.getLength() <= 0) break block7;
            Node node = nodeList.item(0);
            String string = "";
            OcspConfigTags ocspConfigTags = null;
            for (int i2 = 0; i2 < node.getChildNodes().getLength(); ++i2) {
                string = node.getChildNodes().item(i2).getNodeName();
                ocspConfigTags = OcspConfigTags.fromValue(string);
                if (!arrayList2.contains((Object)ocspConfigTags) && n2 == 0) continue;
                NodeList nodeList2 = element.getElementsByTagName(string);
                List<IOcspConfigElement> list = this.a(ocspConfigTags, nodeList2);
                if (list == null) continue;
                arrayList.addAll(list);
                arrayList2.remove((Object)ocspConfigTags);
                continue;
            }
        }
        return arrayList;
    }

    protected NodeList findElementByTagNameFromDocument(OcspConfigTags tags) {
        return this.document.getElementsByTagName(tags.getTagName());
    }

    protected String getTagValue(OcspConfigTags tags, Element rootElement) {
        String string;
        int n2;
        block5: {
            NodeList nodeList;
            Node node;
            block4: {
                n2 = b;
                if (!rootElement.getNodeName().equals(tags.getTagName())) break block4;
                node = rootElement.getChildNodes() != null ? rootElement.getChildNodes().item(0) : null;
                String string2 = string = node != null ? node.getNodeValue() : null;
                if (n2 == 0) break block5;
            }
            node = (nodeList = rootElement.getElementsByTagName(tags.getTagName())) != null ? nodeList.item(0) : null;
            NodeList nodeList2 = node != null ? node.getChildNodes() : null;
            Node node2 = nodeList2 != null ? nodeList2.item(0) : null;
            String string3 = string = node2 != null ? node2.getNodeValue() : null;
        }
        if (AbstractConfigElement.b) {
            b = ++n2;
        }
        return string;
    }

    @Override
    public String getPreferredSignAlg() {
        return this.getStringValue(OcspConfigTags.PREFERREDSIGNALG);
    }

    @Override
    public List<IOcspConfigElement> getSigners() {
        return this.multiMap.get((Object)OcspConfigTags.SIGNER);
    }

    @Override
    public List<String> getSupportedSignAlg() {
        return this.getStringValues(OcspConfigTags.SUPPORTEDSIGNALG);
    }

    protected List<String> getStringValues(OcspConfigTags tag) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = b;
        List<IOcspConfigElement> list = this.multiMap.get((Object)tag);
        if (list != null) {
            for (IOcspConfigElement iOcspConfigElement : list) {
                arrayList.add(iOcspConfigElement.getElementValueByTagName(tag));
                if (n2 == 0) continue;
            }
        }
        return arrayList;
    }

    public String getUrl() {
        return this.getStringValue(OcspConfigTags.URL);
    }

    protected String getStringValue(OcspConfigTags tag) {
        List<String> list = this.getStringValues(tag);
        return !list.isEmpty() ? list.get(0) : null;
    }

    @Override
    public List<IOcspConfigElement> getResponsibleCas() {
        return this.multiMap.get((Object)OcspConfigTags.RESPONSIBLECA);
    }

    @Override
    public List<ECertificate> getOcspSignCertificates() {
        ArrayList<ECertificate> arrayList = new ArrayList<ECertificate>();
        int n2 = b;
        for (IOcspConfigElement iOcspConfigElement : this.multiMap.get((Object)OcspConfigTags.OCSPSIGNCERT)) {
            try {
                arrayList.add(new ECertificate(iOcspConfigElement.getElementValueByTagName(OcspConfigTags.OCSPSIGNCERT)));
            }
            catch (ESYAException eSYAException) {
                // empty catch block
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    @Override
    public ECertificate getOcspEncCertificate() {
        try {
            return new ECertificate(this.getStringValue(OcspConfigTags.OCSPENCRCERT));
        }
        catch (ESYAException eSYAException) {
            return null;
        }
    }

    @Override
    public boolean getNonceCheck() {
        List<IOcspConfigElement> list = this.multiMap.get((Object)OcspConfigTags.NONCECONTROL);
        if (list != null && !list.isEmpty()) {
            return ((NonceControlConfigElement)list.get(0)).isNonceCheck();
        }
        return false;
    }

    @Override
    public int getNonceCacheTime() {
        List<IOcspConfigElement> list = this.multiMap.get((Object)OcspConfigTags.NONCECONTROL);
        if (list != null && !list.isEmpty()) {
            return ((NonceControlConfigElement)list.get(0)).getNonceCacheTime();
        }
        return NONCECACHETIME;
    }

    @Override
    public boolean getOcspLog() {
        List<IOcspConfigElement> list = this.multiMap.get((Object)OcspConfigTags.RESPONSIBLECA);
        int n2 = b;
        for (IOcspConfigElement iOcspConfigElement : list) {
            for (IOcspConfigElement iOcspConfigElement2 : ((ResponsibleCaElement)iOcspConfigElement).getStatusProviders()) {
                if (iOcspConfigElement2 instanceof DbProviderConfigElement) {
                    return ((DbProviderConfigElement)iOcspConfigElement2).isOcspLog();
                }
                if (n2 == 0) continue;
            }
            if (n2 == 0) continue;
        }
        return false;
    }

    @Override
    public boolean getNextUpdate() {
        List<IOcspConfigElement> list = this.multiMap.get((Object)OcspConfigTags.RESPONSIBLECA);
        Iterator<IOcspConfigElement> iterator = list.iterator();
        int n2 = b;
        while (iterator.hasNext()) {
            IOcspConfigElement iOcspConfigElement = iterator.next();
            for (IOcspConfigElement iOcspConfigElement2 : ((ResponsibleCaElement)iOcspConfigElement).getStatusProviders()) {
                if (iOcspConfigElement2 instanceof DbProviderConfigElement) {
                    return ((DbProviderConfigElement)iOcspConfigElement2).isNextUpdate();
                }
                if (n2 == 0) continue;
            }
            if (n2 == 0) continue;
        }
        return false;
    }

    @Override
    public int getNextUpdateMinute() {
        List<IOcspConfigElement> list = this.multiMap.get((Object)OcspConfigTags.RESPONSIBLECA);
        Iterator<IOcspConfigElement> iterator = list.iterator();
        int n2 = b;
        while (iterator.hasNext()) {
            IOcspConfigElement iOcspConfigElement = iterator.next();
            for (IOcspConfigElement iOcspConfigElement2 : ((ResponsibleCaElement)iOcspConfigElement).getStatusProviders()) {
                if (iOcspConfigElement2 instanceof DbProviderConfigElement) {
                    return ((DbProviderConfigElement)iOcspConfigElement2).getNextUpdateMinute();
                }
                if (n2 == 0) continue;
            }
            if (n2 == 0) continue;
        }
        return NEXTUPDATEMIN;
    }

    @Override
    public boolean getSaveResponse() {
        List<IOcspConfigElement> list = this.multiMap.get((Object)OcspConfigTags.RESPONSIBLECA);
        int n2 = b;
        for (IOcspConfigElement iOcspConfigElement : list) {
            for (IOcspConfigElement iOcspConfigElement2 : ((ResponsibleCaElement)iOcspConfigElement).getStatusProviders()) {
                if (iOcspConfigElement2 instanceof DbProviderConfigElement) {
                    return ((DbProviderConfigElement)iOcspConfigElement2).isSaveResponse();
                }
                if (n2 == 0) continue;
            }
            if (n2 == 0) continue;
        }
        return false;
    }
}

