/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.apdu;

import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.common.crypto.Algorithms;
import tr.gov.tubitak.uekae.esya.api.common.crypto.BaseSigner;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.apdu.PCTerminalHandler;
import tr.gov.tubitak.uekae.esya.api.smartcard.apdu.TerminalHandler;
import tr.gov.tubitak.uekae.esya.api.smartcard.apdu.a;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.SmartCardI18n;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.BaseSmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.LoginException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.RSAPSSSignature;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.SignatureSchemeFactory;
import tr.gov.tubitak.uekae.esya.api.smartcard.util.APDUSigner;
import tr.gov.tubitak.uekae.esya.api.smartcard.util.ECSignatureTLVUtil;
import tubitak.akis.cif.akisExceptions.AkisException;
import tubitak.akis.cif.akisExceptions.AkisSWException;
import tubitak.akis.cif.commands.AbstractAkisCommands;
import tubitak.akis.cif.commands.CIFFactory;
import tubitak.akis.cif.dataStructures.AkisKey;
import tubitak.akis.cif.dataStructures.Algorithm;
import tubitak.akis.cif.dataStructures.DF_EF;
import tubitak.akis.cif.dataStructures.Version;
import tubitak.akis.cif.functions.CommandTransmitterPCSC;
import tubitak.akis.cif.functions.ICommandTransmitter;

public class APDUSmartCard
implements BaseSmartCard {
    public static int CERT_FID_START;
    public static int CERT_FID_END;
    protected Hashtable<String, Integer> serialCertIndex;
    protected Hashtable<String, Integer> serialKeyID;
    protected List<byte[]> signingCerts;
    protected List<byte[]> encryptionCerts;
    protected TerminalHandler terminalHandler;
    protected AbstractAkisCommands commands;
    protected ICommandTransmitter pcsc;
    protected Card card;
    protected boolean disableSecureMessaging = false;
    String a;
    private static Logger b;
    private String c;
    private static final String[] d;
    private static final String[] e;

    public void setCommandLoggingPath(String commandLoggingPath) {
        this.a = commandLoggingPath;
    }

    public void setDisableSecureMessaging(boolean disableSecureMessaging) {
        this.disableSecureMessaging = disableSecureMessaging;
    }

    public static boolean isSupported(String aTerminalName) {
        CardTerminal cardTerminal = TerminalFactory.getDefault().terminals().getTerminal(aTerminalName);
        return APDUSmartCard.isSupported(cardTerminal);
    }

    public static boolean isSupported(String aTerminalName, TerminalHandler aTerminalHandler) {
        Object object;
        int n2 = TerminalHandler.b;
        try {
            object = aTerminalHandler.listCardTerminals(CardTerminals.State.CARD_PRESENT);
            Iterator<CardTerminal> iterator = object.iterator();
            while (iterator.hasNext()) {
                CardTerminal cardTerminal = iterator.next();
                if (cardTerminal.getName().equals(aTerminalName)) {
                    return APDUSmartCard.isSupported(cardTerminal, aTerminalHandler);
                }
                if (n2 == 0) continue;
                break;
            }
        }
        catch (CardException cardException) {
            b.warn(APDUSmartCard.a(-27744, 4806), cardException);
            return false;
        }
        object = TerminalFactory.getDefault().terminals().getTerminal(aTerminalName);
        return APDUSmartCard.isSupported((CardTerminal)object);
    }

    public static boolean isSupported(CardTerminal aTerminal, TerminalHandler aTerminalHandler) {
        try {
            ICommandTransmitter iCommandTransmitter = aTerminalHandler.getTransmitter(aTerminal);
            return APDUSmartCard.isSupported(iCommandTransmitter);
        }
        catch (CardException cardException) {
            b.error(APDUSmartCard.a(-27741, 6736), cardException);
            return false;
        }
        catch (Exception exception) {
            b.error(APDUSmartCard.a(-27741, 6736), exception);
            return false;
        }
    }

    public static boolean isSupported(CardTerminal aTerminal) {
        try {
            CommandTransmitterPCSC commandTransmitterPCSC = new CommandTransmitterPCSC(aTerminal, false);
            return APDUSmartCard.isSupported(commandTransmitterPCSC);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            b.error(APDUSmartCard.a(-27715, 9919), noClassDefFoundError);
            return false;
        }
        catch (Exception exception) {
            b.error(APDUSmartCard.a(-27757, -2707), exception);
            return false;
        }
    }

    protected static boolean isSupported(ICommandTransmitter transmitter) {
        try {
            AbstractAkisCommands abstractAkisCommands = CIFFactory.getAkisCIFInstance(transmitter);
            return abstractAkisCommands != null;
        }
        catch (Exception exception) {
            b.error(APDUSmartCard.a(-27718, 18037), exception);
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            b.error(APDUSmartCard.a(-27739, 2388), noClassDefFoundError);
            return false;
        }
    }

    public APDUSmartCard(TerminalHandler aTerminalHandler) {
        this.terminalHandler = aTerminalHandler;
        this.initialize();
    }

    public APDUSmartCard() {
        this.terminalHandler = new PCTerminalHandler();
        this.initialize();
    }

    protected void initialize() {
        this.serialKeyID = new Hashtable();
    }

    public long[] getSlotList() throws CardException {
        int n2 = this.a(CardTerminals.State.ALL).size();
        long[] lArray = new long[n2];
        int n3 = TerminalHandler.b;
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = i2 + 1;
            if (n3 == 0) continue;
        }
        return lArray;
    }

    private List<CardTerminal> a(CardTerminals.State state) throws CardException {
        ArrayList<CardTerminal> arrayList = new ArrayList();
        try {
            arrayList = this.terminalHandler.listCardTerminals(state);
        }
        catch (CardException cardException) {
            if (!cardException.getCause().getMessage().contains(APDUSmartCard.a(-27734, -6313))) {
                throw cardException;
            }
        }
        return arrayList;
    }

    public CardTerminal[] getTerminalList() throws CardException {
        List<CardTerminal> list = this.a(CardTerminals.State.ALL);
        return list.toArray(new CardTerminal[0]);
    }

    public void openSession(ICommandTransmitter iCommandTransmitter) throws SmartCardException {
        this.pcsc = iCommandTransmitter;
        this.a();
    }

    public void openSession(CardTerminal aTerminal) throws SmartCardException {
        try {
            this.pcsc = this.terminalHandler.getTransmitter(aTerminal);
        }
        catch (CardException cardException) {
            throw new SmartCardException(cardException);
        }
        this.a();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a() throws SmartCardException {
        try {
            this.commands = CIFFactory.getAkisCIFInstance(this.pcsc);
            if (this.a != null) {
                AbstractAkisCommands.activateCommandLogging(this.a);
            }
            b.debug(APDUSmartCard.a(-27742, 23690) + (Object)((Object)this.commands.getVersion()));
            if (!this.disableSecureMessaging && this.commands.getVersion() != Version.V10_UEKAE && !APDUSmartCard.isVersion20(this.commands.getVersion())) {
                this.commands.activateSecureMsging();
            }
            this.commands.selectMF();
            this.commands.selectDFByName(APDUSmartCard.a(-27714, 28348).getBytes(APDUSmartCard.a(-27727, 32182)));
            return;
        }
        catch (Exception exception) {
            throw new SmartCardException(APDUSmartCard.a(-27733, -18431), exception);
        }
    }

    @Override
    public boolean isSessionActive() {
        try {
            this.commands.getSerial();
            return true;
        }
        catch (AkisException akisException) {
            b.warn(APDUSmartCard.a(-27719, 3718), akisException);
            return false;
        }
    }

    protected List<X509Certificate> readCertificates() throws SmartCardException {
        int n2;
        Object object;
        List<Object> list;
        CertificateFactory certificateFactory;
        int n3;
        block19: {
            this.serialCertIndex = new Hashtable();
            n3 = TerminalHandler.b;
            certificateFactory = null;
            list = new ArrayList();
            try {
                certificateFactory = CertificateFactory.getInstance(APDUSmartCard.a(-27720, 21802));
                if (APDUSmartCard.isVersion20(this.commands.getVersion())) {
                    object = new byte[]{47, 16};
                    for (n2 = 0; n2 < 10; ++n2) {
                        DF_EF dF_EF = new DF_EF();
                        dF_EF.FID = new byte[2];
                        dF_EF.FID[0] = (byte)object[0];
                        dF_EF.FID[1] = (byte)object[1];
                        list.add(dF_EF);
                        Object object2 = object;
                        object2[1] = (byte)(object2[1] + true);
                        if (n3 == 0) continue;
                        int n4 = SmartCardException.b;
                        SmartCardException.b = ++n4;
                        break;
                    }
                    if (n3 == 0) break block19;
                }
                list = this.commands.dir();
            }
            catch (CertificateException certificateException) {
                throw new SmartCardException(APDUSmartCard.a(-27760, 2923), certificateException);
            }
            catch (Exception exception) {
                throw new SmartCardException(exception);
            }
        }
        object = new ArrayList();
        n2 = 1;
        for (DF_EF dF_EF : list) {
            block20: {
                int n5 = (dF_EF.FID[0] << 8) + dF_EF.FID[1];
                if (n5 < CERT_FID_START || n5 > CERT_FID_END) break block20;
                try {
                    byte[] byArray = this.commands.readFileBySelectingUnderActiveDF(dF_EF.FID);
                    if (byArray == null) {
                        throw new AkisSWException(27266L);
                    }
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                    this.serialCertIndex.put(StringUtil.toString(x509Certificate.getSerialNumber().toByteArray()), n2);
                    ++n2;
                    object.add(x509Certificate);
                }
                catch (CertificateException certificateException) {
                    b.error(APDUSmartCard.a(-27737, 26338), certificateException);
                }
                catch (AkisSWException akisSWException) {
                    if (akisSWException.getErrorCode() != 27266L) {
                        throw new SmartCardException(akisSWException);
                    }
                }
                catch (AkisException akisException) {
                    throw new SmartCardException(akisException);
                }
            }
            if (n3 == 0) continue;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<byte[]> getSignatureCertificates() throws SmartCardException {
        List<X509Certificate> list = this.readCertificates();
        int n2 = TerminalHandler.b;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (X509Certificate x509Certificate : list) {
            if (x509Certificate.getKeyUsage()[0]) {
                try {
                    arrayList.add(x509Certificate.getEncoded());
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    b.error(APDUSmartCard.a(-27730, 30105), certificateEncodingException);
                }
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    private void b() {
        if (this.serialCertIndex == null) {
            try {
                this.readCertificates();
            }
            catch (SmartCardException smartCardException) {
                b.error(APDUSmartCard.a(-27729, 20547), smartCardException);
            }
        }
    }

    public byte[] sign(byte[] aData, X509Certificate aCertificate, String aSigningAlg) throws SmartCardException, CardException {
        SmartCard.checkLicense();
        this.b();
        return this.sign(aData, aCertificate, aSigningAlg, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sign(byte[] aData, X509Certificate aCertificate, String aSigningAlg, AlgorithmParameterSpec spec) throws CardException, SmartCardException {
        byte[] byArray;
        Object object;
        SmartCard.checkLicense();
        this.b();
        X509Certificate x509Certificate = aCertificate;
        a a2 = new a(this, x509Certificate);
        long[] lArray = this.commands.getMechanisms();
        try {
            object = SignatureSchemeFactory.getSignatureScheme(true, aSigningAlg, spec, lArray, a2);
            byArray = object.getSignParameters(aData).getSignatureInput();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SmartCardException(pKCS11Exception);
        }
        object = StringUtil.toString(aCertificate.getSerialNumber().toByteArray());
        Integer n2 = this.serialKeyID.get(object);
        if (n2 != null) {
            return this.a(byArray, (byte)n2.intValue(), aData, (String)object, x509Certificate, aSigningAlg, spec);
        }
        Integer n3 = this.serialCertIndex.get(object);
        if (n3 == null) {
            return this.a(byArray, aData, (String)object, aCertificate, aSigningAlg, spec);
        }
        n2 = n3 * 2 - 1;
        try {
            return this.a(byArray, n2.byteValue(), aData, (String)object, aCertificate, aSigningAlg, spec);
        }
        catch (Exception exception) {
            b.debug(APDUSmartCard.a(-27719, 3718), exception);
            return this.a(byArray, aData, (String)object, aCertificate, aSigningAlg, spec);
        }
    }

    private byte[] a(byte[] byArray, byte[] byArray2, String string, X509Certificate x509Certificate, String string2, AlgorithmParameterSpec algorithmParameterSpec) throws CardException {
        byte[] byArray3;
        int n2;
        block7: {
            n2 = TerminalHandler.b;
            try {
                if (APDUSmartCard.isVersion20(this.commands.getVersion())) {
                    byArray3 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
                    if (n2 == 0) break block7;
                }
                AkisKey[] objectArray = this.commands.getKeyInfos();
                byArray3 = new byte[objectArray.length];
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    byArray3[i2] = objectArray[i2].getKeyID();
                    if (n2 == 0) continue;
                    break;
                }
            }
            catch (Exception exception) {
                throw new CardException(exception);
            }
        }
        for (byte by : byArray3) {
            try {
                return this.a(byArray, by, byArray2, string, x509Certificate, string2, algorithmParameterSpec);
            }
            catch (Exception exception) {
                b.warn(APDUSmartCard.a(-27719, 3718), exception);
                if (n2 == 0) continue;
            }
        }
        throw new CardException(new AkisSWException(27015L));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(byte[] byArray, byte by, byte[] byArray2, String string, X509Certificate x509Certificate, String string2, AlgorithmParameterSpec algorithmParameterSpec) throws CardException {
        byte[] byArray3;
        block17: {
            byArray3 = null;
            try {
                if (string2 == Algorithms.SIGNATURE_RSA_PSS) {
                    if (!APDUSmartCard._in(13L, this.commands.getMechanisms())) {
                        throw new CardException(APDUSmartCard.a(-27717, 5924));
                    }
                    PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
                    String string3 = pSSParameterSpec.getDigestAlgorithm();
                    Algorithm algorithm = this.d(string3);
                    if (this.a(by)) {
                        byte by2 = (byte)(0xFFFFFF80 | by);
                        this.commands.verify((byte)1, this.c.getBytes(APDUSmartCard.a(-27727, 32182)), false);
                        byArray3 = this.commands.sign(Algorithm.PKCS_PSS, algorithm, by2, byArray);
                    }
                    break block17;
                }
                if (this.c(string2)) {
                    if (APDUSmartCard.isVersion20(this.commands.getVersion())) {
                        if (this.a(by)) {
                            byte by3 = (byte)(0xFFFFFF80 | by);
                            this.commands.verify((byte)1, this.c.getBytes(APDUSmartCard.a(-27727, 32182)), false);
                            byArray3 = this.commands.sign(Algorithm.PKCS_1_5, null, by3, byArray);
                        }
                        break block17;
                    }
                    byArray3 = this.commands.sign(byArray, by);
                    break block17;
                }
                if (!this.b(string2)) {
                    throw new CardException(APDUSmartCard.a(-27724, -30679) + string2);
                }
                Algorithm algorithm = this.a(string2);
                if (this.a(by)) {
                    byte by4 = (byte)(0xFFFFFF80 | by);
                    this.commands.verify((byte)1, this.c.getBytes(APDUSmartCard.a(-27727, 32182)), false);
                    byArray3 = this.commands.sign(Algorithm.ECC, algorithm, by4, byArray);
                    byArray3 = ECSignatureTLVUtil.addTLVToSignature(byArray3);
                }
            }
            catch (CardException cardException) {
                throw cardException;
            }
            catch (Exception exception) {
                throw new CardException(exception);
            }
        }
        if (this.a(byArray3, byArray2, x509Certificate, string2, algorithmParameterSpec)) {
            this.serialKeyID.put(string, Integer.valueOf(by));
            return byArray3;
        }
        throw new CardException(new AkisSWException(25616L));
    }

    private Algorithm a(String string) throws CardException {
        if (string.contains(APDUSmartCard.a(-27743, 31416))) {
            return Algorithm.SHA_256;
        }
        if (string.contains(APDUSmartCard.a(-27735, 30147))) {
            return Algorithm.SHA_384;
        }
        if (string.contains(APDUSmartCard.a(-27721, 15976))) {
            return Algorithm.SHA_512;
        }
        throw new CardException(APDUSmartCard.a(-27716, 9660) + string);
    }

    private boolean b(String string) {
        return string == Algorithms.SIGNATURE_ECDSA_SHA256 || string == Algorithms.SIGNATURE_ECDSA_SHA384 || string == Algorithms.SIGNATURE_ECDSA_SHA512 || string == Algorithms.SIGNATURE_ECDSA_SHA224 || string == Algorithms.SIGNATURE_ECDSA_SHA1 || string == Algorithms.SIGNATURE_ECDSA;
    }

    private boolean c(String string) {
        return string == Algorithms.SIGNATURE_RSA || string == Algorithms.SIGNATURE_RSA_MD5 || string == Algorithms.SIGNATURE_RSA_SHA1 || string == Algorithms.SIGNATURE_RSA_SHA224 || string == Algorithms.SIGNATURE_RSA_SHA256 || string == Algorithms.SIGNATURE_RSA_SHA384 || string == Algorithms.SIGNATURE_RSA_SHA512;
    }

    private boolean a(byte by) throws CardException {
        byte by2 = by;
        boolean bl = false;
        try {
            bl = this.commands.queryObject(144, by2);
            if (!bl) {
                by2 = (byte)(0xFFFFFF80 | by2);
                bl = this.commands.queryObject(144, by2);
            }
        }
        catch (Exception exception) {
            throw new CardException(exception);
        }
        return bl;
    }

    private Algorithm d(String string) throws CardException {
        if (string == Algorithms.DIGEST_SHA1) {
            return Algorithm.SHA_1;
        }
        if (string == Algorithms.DIGEST_SHA256) {
            return Algorithm.SHA_256;
        }
        throw new CardException(APDUSmartCard.a(-27759, -7127) + string);
    }

    private boolean a(Exception exception) {
        long l2;
        return exception instanceof AkisSWException && ((l2 = ((AkisSWException)exception).getErrorCode()) == 25616L || l2 == 25625L || l2 == 27015L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean a(byte[] byArray, byte[] byArray2, X509Certificate x509Certificate, String string, AlgorithmParameterSpec algorithmParameterSpec) {
        int n2 = TerminalHandler.b;
        try {
            String string2;
            block14: {
                block15: {
                    String string3;
                    block13: {
                        block12: {
                            String string4;
                            block11: {
                                if (string.equals(Algorithms.SIGNATURE_RSA_PSS)) {
                                    PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
                                    RSAPSSSignature rSAPSSSignature = new RSAPSSSignature();
                                    MessageDigest messageDigest = MessageDigest.getInstance(pSSParameterSpec.getDigestAlgorithm());
                                    messageDigest.update(byArray2);
                                    byte[] byArray3 = messageDigest.digest();
                                    messageDigest.reset();
                                    PSSParameterSpec pSSParameterSpec2 = (PSSParameterSpec)algorithmParameterSpec;
                                    return rSAPSSSignature.verifySignature(byArray, x509Certificate.getPublicKey(), byArray3, messageDigest, pSSParameterSpec2.getSaltLength());
                                }
                                string4 = Algorithms.getDigestAlgOfSignatureAlg(string);
                                if (string4 != null) break block11;
                                string3 = APDUSmartCard.a(-27758, -6794);
                                if (n2 == 0) break block12;
                            }
                            string3 = string4.replaceAll("-", "");
                        }
                        string2 = "";
                        if (!string.contains(APDUSmartCard.a(-27728, 29287))) break block13;
                        string2 = string3 + APDUSmartCard.a(-27740, 29709);
                        if (n2 == 0) break block14;
                    }
                    if (!string.contains(APDUSmartCard.a(-27723, -26155))) break block15;
                    string2 = string3 + APDUSmartCard.a(-27722, 3598);
                    if (n2 == 0) break block14;
                }
                throw new CardException(APDUSmartCard.a(-27725, 910) + string);
            }
            Signature signature = Signature.getInstance(string2);
            signature.initVerify(x509Certificate);
            signature.update(byArray2);
            return signature.verify(byArray);
        }
        catch (Exception exception) {
            b.warn(APDUSmartCard.a(-27719, 3718), exception);
            return false;
        }
    }

    @Override
    public void openSession(long aSlotID) throws SmartCardException {
        try {
            List<CardTerminal> list = this.a(CardTerminals.State.ALL);
            this.openSession(list.get((int)(aSlotID - 1L)));
        }
        catch (CardException cardException) {
            b.warn(APDUSmartCard.a(-27719, 3718), cardException);
            throw new SmartCardException(APDUSmartCard.a(-27732, -12601));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<byte[]> getEncryptionCertificates() throws SmartCardException {
        List<X509Certificate> list = this.readCertificates();
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n2 = TerminalHandler.b;
        for (X509Certificate x509Certificate : list) {
            block10: {
                if (!x509Certificate.getKeyUsage()[2]) {
                    if (x509Certificate.getKeyUsage()[3]) {
                    }
                    break block10;
                }
                arrayList.add(x509Certificate.getEncoded());
                catch (SmartCardException smartCardException) {
                    throw smartCardException;
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    b.error(APDUSmartCard.a(-27736, 23525), certificateEncodingException);
                }
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void login(String aCardPIN) throws SmartCardException, LoginException {
        int n2 = TerminalHandler.b;
        try {
            if (APDUSmartCard.isVersion20(this.commands.getVersion())) {
                this.commands.verify((byte)1, aCardPIN.getBytes(APDUSmartCard.a(-27731, 20931)), false);
                this.c = aCardPIN;
                if (n2 == 0) return;
            }
            this.commands.verify(aCardPIN.getBytes(APDUSmartCard.a(-27727, 32182)), false);
            return;
        }
        catch (AkisSWException akisSWException) {
            if (APDUSmartCard.isVersion20(this.commands.getVersion()) ? akisSWException.getErrorCode() == 27011L : akisSWException.getErrorCode() == 27012L) {
                throw new LoginException(SmartCardI18n.getMsg(E_KEYS.PIN_LOCKED, new String[0]), (Throwable)akisSWException, false, true);
            }
            if ((akisSWException.getErrorCode() & 0x63C0L) != 25536L) return;
            if (akisSWException.getErrorCode() == 25536L) {
                throw new LoginException(SmartCardI18n.getMsg(E_KEYS.PIN_LOCKED, new String[0]), (Throwable)akisSWException, false, true);
            }
            if (akisSWException.getErrorCode() != 25537L) throw new LoginException(SmartCardI18n.getMsg(E_KEYS.INCORRECT_PIN, new String[0]), (Throwable)akisSWException, false, false);
            throw new LoginException(SmartCardI18n.getMsg(E_KEYS.INCORRECT_PIN_FINAL_TRY, new String[0]), (Throwable)akisSWException, true, false);
        }
        catch (Exception exception) {
            throw new SmartCardException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void logout() throws SmartCardException {
        int n2 = TerminalHandler.b;
        try {
            if (!APDUSmartCard.isVersion20(this.commands.getVersion())) {
                this.commands.logout();
                if (n2 == 0) return;
            }
            this.commands.selectMF();
            this.commands.selectDFByName(APDUSmartCard.a(-27713, 31683).getBytes(APDUSmartCard.a(-27727, 32182)));
            return;
        }
        catch (Exception exception) {
            throw new SmartCardException(exception);
        }
    }

    @Override
    public String getSerial() throws SmartCardException {
        try {
            return StringUtil.toHexString(this.commands.getSerial());
        }
        catch (Exception exception) {
            throw new SmartCardException(APDUSmartCard.a(-27726, 5242), exception);
        }
    }

    @Override
    public String getSerial(long aSlotID) throws SmartCardException {
        String string;
        block2: {
            int n2 = TerminalHandler.b;
            try {
                String string2;
                List<CardTerminal> list = this.a(CardTerminals.State.ALL);
                this.pcsc = this.terminalHandler.getTransmitter(list.get((int)(aSlotID - 1L)));
                this.commands = CIFFactory.getAkisCIFInstance(this.pcsc);
                byte[] byArray = new byte[]{};
                byArray = this.commands.getSerial();
                this.pcsc.closeCardTerminal();
                string = string2 = StringUtil.toHexString(byArray);
                if (SmartCardException.b == 0) break block2;
                TerminalHandler.b = ++n2;
            }
            catch (Exception exception) {
                throw new SmartCardException(APDUSmartCard.a(-27738, -2910), exception);
            }
        }
        return string;
    }

    @Override
    public BaseSigner getSigner(X509Certificate aCert, String aSigningAlg) throws SmartCardException {
        return new APDUSigner(this, aCert, aSigningAlg);
    }

    @Override
    public BaseSigner getSigner(X509Certificate aCert, String aSigningAlg, AlgorithmParameterSpec aParams) throws SmartCardException {
        return new APDUSigner(this, aCert, aSigningAlg, aParams);
    }

    @Override
    public void closeSession() throws SmartCardException {
        this.pcsc.closeCardTerminal();
    }

    public static boolean isVersion20(Version aVersion) {
        return aVersion != Version.V10_UEKAE && aVersion != Version.V11_UEKAE_INF && aVersion != Version.V121_UEKAE_INF && aVersion != Version.V121_UEKAE_NXP && aVersion != Version.V121_UEKAE_UKiS && aVersion != Version.V121_UEKAE_UKIS_HHNEC && aVersion != Version.V121_UEKAE_UKiS_SMIC && aVersion != Version.V122_UEKAE_INF && aVersion != Version.V122_UEKAE_NXP && aVersion != Version.V122_UEKAE_UKiS_HHNEC && aVersion != Version.V122_UEKAE_UKiS_SMIC && aVersion != Version.V12_UEKAE_INF && aVersion != Version.V12_UEKAE_NXP && aVersion != Version.V12_UEKAE_UKiS && aVersion != Version.V13_UEKAE_INF && aVersion != Version.V14_UEKAE_INF && aVersion != Version.V14_UEKAE_NXP;
    }

    public static boolean _in(long aElement, long[] aList) {
        int n2 = TerminalHandler.b;
        if (aList == null) {
            return false;
        }
        for (int i2 = 0; i2 < aList.length; ++i2) {
            if (aList[i2] != aElement) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[36];
                var3_1 = 0;
                var2_2 = "p$[r\u00f8\u0016Y\u0015\u0016\u00f3\u00a6\u00c9n\u00e9\u00f3=3\u0014\u0019\u000e^]\u0086\u0098h\u0093t$\u00c7\u0081O\u00b85\u0018,\u00f1\u00d3C\u00ea\u0013`\u00e8\u00c7-\u0003\u00c2\u00c0\u0011\u0005Q\u0004\u0010k>\t\u00af\u00ad\b\u0002\u00e0u$\u00a3\u00a9\u0006gJ\u0084\u00a6\u0096f\u0019\u0098\u00de\u008f\u0096\u00c2j\u00d84M\u00cf\u00acN\u001d\u0015\u00ac(gS\u0091\u00faIb\u00a3\u0087D\u0005+\u00fd\u00dc\\H\u0019\u008e\u00bb\u00d6\u0084\u00cd(9|q\u00c6+o\u00f8-\u00ae\u00aa\u000f[\u0095\u00da\u00e5x\u00a7L!\u001c\u0098\u0090\n\u0090VDA\u00d4\t\f\u0099\\\u00c2MIzr\u0003\u00b2\u00fa\u0096G\u00d9\u00e9\u00ac\u0095\u00df\u00bd\u0005\u00a2\u00a3\"4\u00b0\u0018?\u009d8\u000b\f\u00bf3\u0001$z{\u00f3\b\u00c2{g\u00ed/Q\u00cf\u00c4\u0017a\u00db\u0007\u00e0\u0091\u0015\u00d8\u00fa\u0000s\u0007.\u00d1\u00cc\u00d0\u00c1\u0001\u0014\u0011\u007f\u00f1ss]\u00d6+\u00a33=c\u0010\u00f6\u00db\u0081\u0000\u008b\u0016\u00a8\u00d7!\u0014]\u00e5S\u00a3\n\u00ee\u008f\u00ee\u00bc\u001d\u00a0\u00ad\u008b\u0094\u00e1\u00ad\t\u01bc\u001ephT,\u00a0\u00e4\u00afK\u0099-O\u00ebV+X\r\u00b3\u007fq\u00d5\u00a3q\u0095\u00d0\u0093\u0011\u0013\u0099\u00af\u0010\u0019r>I.>$]\u00fd\u00a4\u00f6\u0091i\u00af\u00edD\u00b2RX>\u00ba\u0090t\t\u00cd\u00f4\u0018i\u0097\u00f2JU\u0097\u0018\u0004A\u00da\u00d7\u00e7\u009d@\u00c97\u00bb%\u009b\u008e\u009d?J\u00de\u0006\u0093R\u001a\u00a2A\u0005\u00126\u00a6\u0093\"\u00e1\u001czTr\u00db*\u00cc\u00ffI\u00c1)u\u0096\u001c\u00f5S\u00f7L\u00f5\u0006\u0002|\u00c5\u00e4\u000b\u0018\u00d8\u00d7\u000f7<6\u000ew\u00ce\u00da\u00f2\u00ed\u00ae\u0004J\u00f6\u0007n\u00850\u0007\u00f0\u00c5\u00d6\u0016{\u00d8[\u00f5\u0012\u00d9\u00ba$7\u001e(\u00f0H\u00de>\u00d5X\u009b\u009bLF\u0180\u001c\u009e\"\u00bb\u00a6\u0004\u0080\u0098\u008e\u0010:A\u00ed\u00cau\u0085\">a\u00deG\u00a8\u00b5`\u0083\u00b6\u00a9\u00e0\u00eb\u0015\t\u00e0t\u00ea\u001d\u0005\u00e5w\u0089\u00aaM\u001bS\"^\u008aa\u00be\u0000\u00ee=\u001b\u009c\u00d8\u00da=P(\u00b6\u00b9S\\\u00d9\u000f\u00825DkU\u00bd#\u0006k\u00f4F(8\u00bc\u0098\u0006+\u00da\r\u00b2\u00ae$\u001b\u0090F[\u00ee`R\u00b0\u00f6\u0093\u00b5\u00c12\u0081\u0092$\u009fY#\u00a2\u00d5[\u008e@g\u00f8U\u0080\u0016\u00eb5\u00f2nN|\r\u00b0e\u00e4C\u00eft\u00f3i\u0086\u008fr\u00d0\u00c6\u00d2\u0084\u0017\u00d7\u00f2\u00af\u00a8fM\u008a~j\u0098\u00f8'p\u00cfF0\u0099\u0015\u00c9\u00e4\u0006\u00cc\u00af\u0005\\\u00c0\u00b1\u00f3\n\u0004N\u00c0\u0010`\u0019\u00eeP\u00da\u00e3L\u009d\u0013\u00cam\u0010\u00a8\u00b5\u0088v\u00a0\u00c1\u00ce6\u00adw\u00e2\u00cdG\u00fa=";
                var4_3 = "p$[r\u00f8\u0016Y\u0015\u0016\u00f3\u00a6\u00c9n\u00e9\u00f3=3\u0014\u0019\u000e^]\u0086\u0098h\u0093t$\u00c7\u0081O\u00b85\u0018,\u00f1\u00d3C\u00ea\u0013`\u00e8\u00c7-\u0003\u00c2\u00c0\u0011\u0005Q\u0004\u0010k>\t\u00af\u00ad\b\u0002\u00e0u$\u00a3\u00a9\u0006gJ\u0084\u00a6\u0096f\u0019\u0098\u00de\u008f\u0096\u00c2j\u00d84M\u00cf\u00acN\u001d\u0015\u00ac(gS\u0091\u00faIb\u00a3\u0087D\u0005+\u00fd\u00dc\\H\u0019\u008e\u00bb\u00d6\u0084\u00cd(9|q\u00c6+o\u00f8-\u00ae\u00aa\u000f[\u0095\u00da\u00e5x\u00a7L!\u001c\u0098\u0090\n\u0090VDA\u00d4\t\f\u0099\\\u00c2MIzr\u0003\u00b2\u00fa\u0096G\u00d9\u00e9\u00ac\u0095\u00df\u00bd\u0005\u00a2\u00a3\"4\u00b0\u0018?\u009d8\u000b\f\u00bf3\u0001$z{\u00f3\b\u00c2{g\u00ed/Q\u00cf\u00c4\u0017a\u00db\u0007\u00e0\u0091\u0015\u00d8\u00fa\u0000s\u0007.\u00d1\u00cc\u00d0\u00c1\u0001\u0014\u0011\u007f\u00f1ss]\u00d6+\u00a33=c\u0010\u00f6\u00db\u0081\u0000\u008b\u0016\u00a8\u00d7!\u0014]\u00e5S\u00a3\n\u00ee\u008f\u00ee\u00bc\u001d\u00a0\u00ad\u008b\u0094\u00e1\u00ad\t\u01bc\u001ephT,\u00a0\u00e4\u00afK\u0099-O\u00ebV+X\r\u00b3\u007fq\u00d5\u00a3q\u0095\u00d0\u0093\u0011\u0013\u0099\u00af\u0010\u0019r>I.>$]\u00fd\u00a4\u00f6\u0091i\u00af\u00edD\u00b2RX>\u00ba\u0090t\t\u00cd\u00f4\u0018i\u0097\u00f2JU\u0097\u0018\u0004A\u00da\u00d7\u00e7\u009d@\u00c97\u00bb%\u009b\u008e\u009d?J\u00de\u0006\u0093R\u001a\u00a2A\u0005\u00126\u00a6\u0093\"\u00e1\u001czTr\u00db*\u00cc\u00ffI\u00c1)u\u0096\u001c\u00f5S\u00f7L\u00f5\u0006\u0002|\u00c5\u00e4\u000b\u0018\u00d8\u00d7\u000f7<6\u000ew\u00ce\u00da\u00f2\u00ed\u00ae\u0004J\u00f6\u0007n\u00850\u0007\u00f0\u00c5\u00d6\u0016{\u00d8[\u00f5\u0012\u00d9\u00ba$7\u001e(\u00f0H\u00de>\u00d5X\u009b\u009bLF\u0180\u001c\u009e\"\u00bb\u00a6\u0004\u0080\u0098\u008e\u0010:A\u00ed\u00cau\u0085\">a\u00deG\u00a8\u00b5`\u0083\u00b6\u00a9\u00e0\u00eb\u0015\t\u00e0t\u00ea\u001d\u0005\u00e5w\u0089\u00aaM\u001bS\"^\u008aa\u00be\u0000\u00ee=\u001b\u009c\u00d8\u00da=P(\u00b6\u00b9S\\\u00d9\u000f\u00825DkU\u00bd#\u0006k\u00f4F(8\u00bc\u0098\u0006+\u00da\r\u00b2\u00ae$\u001b\u0090F[\u00ee`R\u00b0\u00f6\u0093\u00b5\u00c12\u0081\u0092$\u009fY#\u00a2\u00d5[\u008e@g\u00f8U\u0080\u0016\u00eb5\u00f2nN|\r\u00b0e\u00e4C\u00eft\u00f3i\u0086\u008fr\u00d0\u00c6\u00d2\u0084\u0017\u00d7\u00f2\u00af\u00a8fM\u008a~j\u0098\u00f8'p\u00cfF0\u0099\u0015\u00c9\u00e4\u0006\u00cc\u00af\u0005\\\u00c0\u00b1\u00f3\n\u0004N\u00c0\u0010`\u0019\u00eeP\u00da\u00e3L\u009d\u0013\u00cam\u0010\u00a8\u00b5\u0088v\u00a0\u00c1\u00ce6\u00adw\u00e2\u00cdG\u00fa=".length();
                var1_4 = 18;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00d4J\u00cf\u00bfj\u00af\u000b\"X\u0002\u00faC\u00f1\u00d1\u0091\u0010c\u00c0\u008f^\u00fc\u0093\u00f6G>\u009eh\u00ea\u0095\u00c4\u00c2\u008b\u00fd\u0018\u0098z\u008f\u0002\u00c2\u00f8\u00d8fM\u0085\u00ac\u0007\n<\u00bb\u0006\u009f\u00e6\u0090T\u00cb\u00d5\u0002\u0001";
                    var4_3 = "\u00d4J\u00cf\u00bfj\u00af\u000b\"X\u0002\u00faC\u00f1\u00d1\u0091\u0010c\u00c0\u008f^\u00fc\u0093\u00f6G>\u009eh\u00ea\u0095\u00c4\u00c2\u008b\u00fd\u0018\u0098z\u008f\u0002\u00c2\u00f8\u00d8fM\u0085\u00ac\u0007\n<\u00bb\u0006\u009f\u00e6\u0090T\u00cb\u00d5\u0002\u0001".length();
                    var1_4 = 33;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 90;
                            break;
                        }
                        case 1: {
                            v13 = 70;
                            break;
                        }
                        case 2: {
                            v13 = 91;
                            break;
                        }
                        case 3: {
                            v13 = 83;
                            break;
                        }
                        case 4: {
                            v13 = 53;
                            break;
                        }
                        case 5: {
                            v13 = 121;
                            break;
                        }
                        default: {
                            v13 = 55;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        APDUSmartCard.d = var5;
        APDUSmartCard.e = new String[36];
        APDUSmartCard.CERT_FID_START = 12048;
        APDUSmartCard.CERT_FID_END = 12064;
        APDUSmartCard.b = LoggerFactory.getLogger(APDUSmartCard.class);
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0xFFFF93B2) & 0xFFFF;
        if (e[n4] == null) {
            int n5;
            int n6;
            char[] cArray = d[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 99;
                    break;
                }
                case 1: {
                    n6 = 43;
                    break;
                }
                case 2: {
                    n6 = 101;
                    break;
                }
                case 3: {
                    n6 = 162;
                    break;
                }
                case 4: {
                    n6 = 2;
                    break;
                }
                case 5: {
                    n6 = 37;
                    break;
                }
                case 6: {
                    n6 = 124;
                    break;
                }
                case 7: {
                    n6 = 229;
                    break;
                }
                case 8: {
                    n6 = 156;
                    break;
                }
                case 9: {
                    n6 = 170;
                    break;
                }
                case 10: {
                    n6 = 103;
                    break;
                }
                case 11: {
                    n6 = 108;
                    break;
                }
                case 12: {
                    n6 = 149;
                    break;
                }
                case 13: {
                    n6 = 143;
                    break;
                }
                case 14: {
                    n6 = 85;
                    break;
                }
                case 15: {
                    n6 = 163;
                    break;
                }
                case 16: {
                    n6 = 200;
                    break;
                }
                case 17: {
                    n6 = 120;
                    break;
                }
                case 18: {
                    n6 = 248;
                    break;
                }
                case 19: {
                    n6 = 83;
                    break;
                }
                case 20: {
                    n6 = 28;
                    break;
                }
                case 21: {
                    n6 = 186;
                    break;
                }
                case 22: {
                    n6 = 221;
                    break;
                }
                case 23: {
                    n6 = 231;
                    break;
                }
                case 24: {
                    n6 = 110;
                    break;
                }
                case 25: {
                    n6 = 211;
                    break;
                }
                case 26: {
                    n6 = 18;
                    break;
                }
                case 27: {
                    n6 = 55;
                    break;
                }
                case 28: {
                    n6 = 119;
                    break;
                }
                case 29: {
                    n6 = 244;
                    break;
                }
                case 30: {
                    n6 = 253;
                    break;
                }
                case 31: {
                    n6 = 36;
                    break;
                }
                case 32: {
                    n6 = 236;
                    break;
                }
                case 33: {
                    n6 = 20;
                    break;
                }
                case 34: {
                    n6 = 251;
                    break;
                }
                case 35: {
                    n6 = 182;
                    break;
                }
                case 36: {
                    n6 = 11;
                    break;
                }
                case 37: {
                    n6 = 76;
                    break;
                }
                case 38: {
                    n6 = 67;
                    break;
                }
                case 39: {
                    n6 = 42;
                    break;
                }
                case 40: {
                    n6 = 15;
                    break;
                }
                case 41: {
                    n6 = 196;
                    break;
                }
                case 42: {
                    n6 = 17;
                    break;
                }
                case 43: {
                    n6 = 95;
                    break;
                }
                case 44: {
                    n6 = 71;
                    break;
                }
                case 45: {
                    n6 = 155;
                    break;
                }
                case 46: {
                    n6 = 5;
                    break;
                }
                case 47: {
                    n6 = 89;
                    break;
                }
                case 48: {
                    n6 = 10;
                    break;
                }
                case 49: {
                    n6 = 220;
                    break;
                }
                case 50: {
                    n6 = 239;
                    break;
                }
                case 51: {
                    n6 = 98;
                    break;
                }
                case 52: {
                    n6 = 202;
                    break;
                }
                case 53: {
                    n6 = 117;
                    break;
                }
                case 54: {
                    n6 = 197;
                    break;
                }
                case 55: {
                    n6 = 46;
                    break;
                }
                case 56: {
                    n6 = 154;
                    break;
                }
                case 57: {
                    n6 = 66;
                    break;
                }
                case 58: {
                    n6 = 25;
                    break;
                }
                case 59: {
                    n6 = 8;
                    break;
                }
                case 60: {
                    n6 = 222;
                    break;
                }
                case 61: {
                    n6 = 250;
                    break;
                }
                case 62: {
                    n6 = 160;
                    break;
                }
                case 63: {
                    n6 = 40;
                    break;
                }
                case 64: {
                    n6 = 225;
                    break;
                }
                case 65: {
                    n6 = 183;
                    break;
                }
                case 66: {
                    n6 = 12;
                    break;
                }
                case 67: {
                    n6 = 81;
                    break;
                }
                case 68: {
                    n6 = 112;
                    break;
                }
                case 69: {
                    n6 = 97;
                    break;
                }
                case 70: {
                    n6 = 107;
                    break;
                }
                case 71: {
                    n6 = 152;
                    break;
                }
                case 72: {
                    n6 = 232;
                    break;
                }
                case 73: {
                    n6 = 153;
                    break;
                }
                case 74: {
                    n6 = 150;
                    break;
                }
                case 75: {
                    n6 = 113;
                    break;
                }
                case 76: {
                    n6 = 69;
                    break;
                }
                case 77: {
                    n6 = 63;
                    break;
                }
                case 78: {
                    n6 = 194;
                    break;
                }
                case 79: {
                    n6 = 38;
                    break;
                }
                case 80: {
                    n6 = 132;
                    break;
                }
                case 81: {
                    n6 = 9;
                    break;
                }
                case 82: {
                    n6 = 23;
                    break;
                }
                case 83: {
                    n6 = 241;
                    break;
                }
                case 84: {
                    n6 = 141;
                    break;
                }
                case 85: {
                    n6 = 100;
                    break;
                }
                case 86: {
                    n6 = 129;
                    break;
                }
                case 87: {
                    n6 = 56;
                    break;
                }
                case 88: {
                    n6 = 255;
                    break;
                }
                case 89: {
                    n6 = 171;
                    break;
                }
                case 90: {
                    n6 = 142;
                    break;
                }
                case 91: {
                    n6 = 48;
                    break;
                }
                case 92: {
                    n6 = 35;
                    break;
                }
                case 93: {
                    n6 = 74;
                    break;
                }
                case 94: {
                    n6 = 32;
                    break;
                }
                case 95: {
                    n6 = 118;
                    break;
                }
                case 96: {
                    n6 = 173;
                    break;
                }
                case 97: {
                    n6 = 226;
                    break;
                }
                case 98: {
                    n6 = 91;
                    break;
                }
                case 99: {
                    n6 = 148;
                    break;
                }
                case 100: {
                    n6 = 185;
                    break;
                }
                case 101: {
                    n6 = 84;
                    break;
                }
                case 102: {
                    n6 = 105;
                    break;
                }
                case 103: {
                    n6 = 41;
                    break;
                }
                case 104: {
                    n6 = 179;
                    break;
                }
                case 105: {
                    n6 = 14;
                    break;
                }
                case 106: {
                    n6 = 34;
                    break;
                }
                case 107: {
                    n6 = 26;
                    break;
                }
                case 108: {
                    n6 = 115;
                    break;
                }
                case 109: {
                    n6 = 147;
                    break;
                }
                case 110: {
                    n6 = 228;
                    break;
                }
                case 111: {
                    n6 = 22;
                    break;
                }
                case 112: {
                    n6 = 116;
                    break;
                }
                case 113: {
                    n6 = 161;
                    break;
                }
                case 114: {
                    n6 = 0;
                    break;
                }
                case 115: {
                    n6 = 209;
                    break;
                }
                case 116: {
                    n6 = 159;
                    break;
                }
                case 117: {
                    n6 = 13;
                    break;
                }
                case 118: {
                    n6 = 106;
                    break;
                }
                case 119: {
                    n6 = 252;
                    break;
                }
                case 120: {
                    n6 = 21;
                    break;
                }
                case 121: {
                    n6 = 165;
                    break;
                }
                case 122: {
                    n6 = 39;
                    break;
                }
                case 123: {
                    n6 = 31;
                    break;
                }
                case 124: {
                    n6 = 102;
                    break;
                }
                case 125: {
                    n6 = 191;
                    break;
                }
                case 126: {
                    n6 = 137;
                    break;
                }
                case 127: {
                    n6 = 199;
                    break;
                }
                case 128: {
                    n6 = 247;
                    break;
                }
                case 129: {
                    n6 = 240;
                    break;
                }
                case 130: {
                    n6 = 245;
                    break;
                }
                case 131: {
                    n6 = 204;
                    break;
                }
                case 132: {
                    n6 = 62;
                    break;
                }
                case 133: {
                    n6 = 175;
                    break;
                }
                case 134: {
                    n6 = 64;
                    break;
                }
                case 135: {
                    n6 = 195;
                    break;
                }
                case 136: {
                    n6 = 131;
                    break;
                }
                case 137: {
                    n6 = 227;
                    break;
                }
                case 138: {
                    n6 = 193;
                    break;
                }
                case 139: {
                    n6 = 128;
                    break;
                }
                case 140: {
                    n6 = 145;
                    break;
                }
                case 141: {
                    n6 = 249;
                    break;
                }
                case 142: {
                    n6 = 158;
                    break;
                }
                case 143: {
                    n6 = 3;
                    break;
                }
                case 144: {
                    n6 = 187;
                    break;
                }
                case 145: {
                    n6 = 178;
                    break;
                }
                case 146: {
                    n6 = 77;
                    break;
                }
                case 147: {
                    n6 = 33;
                    break;
                }
                case 148: {
                    n6 = 53;
                    break;
                }
                case 149: {
                    n6 = 104;
                    break;
                }
                case 150: {
                    n6 = 201;
                    break;
                }
                case 151: {
                    n6 = 19;
                    break;
                }
                case 152: {
                    n6 = 157;
                    break;
                }
                case 153: {
                    n6 = 177;
                    break;
                }
                case 154: {
                    n6 = 1;
                    break;
                }
                case 155: {
                    n6 = 180;
                    break;
                }
                case 156: {
                    n6 = 123;
                    break;
                }
                case 157: {
                    n6 = 93;
                    break;
                }
                case 158: {
                    n6 = 68;
                    break;
                }
                case 159: {
                    n6 = 169;
                    break;
                }
                case 160: {
                    n6 = 82;
                    break;
                }
                case 161: {
                    n6 = 234;
                    break;
                }
                case 162: {
                    n6 = 59;
                    break;
                }
                case 163: {
                    n6 = 237;
                    break;
                }
                case 164: {
                    n6 = 207;
                    break;
                }
                case 165: {
                    n6 = 72;
                    break;
                }
                case 166: {
                    n6 = 181;
                    break;
                }
                case 167: {
                    n6 = 213;
                    break;
                }
                case 168: {
                    n6 = 65;
                    break;
                }
                case 169: {
                    n6 = 130;
                    break;
                }
                case 170: {
                    n6 = 126;
                    break;
                }
                case 171: {
                    n6 = 203;
                    break;
                }
                case 172: {
                    n6 = 189;
                    break;
                }
                case 173: {
                    n6 = 168;
                    break;
                }
                case 174: {
                    n6 = 6;
                    break;
                }
                case 175: {
                    n6 = 246;
                    break;
                }
                case 176: {
                    n6 = 61;
                    break;
                }
                case 177: {
                    n6 = 79;
                    break;
                }
                case 178: {
                    n6 = 50;
                    break;
                }
                case 179: {
                    n6 = 114;
                    break;
                }
                case 180: {
                    n6 = 144;
                    break;
                }
                case 181: {
                    n6 = 172;
                    break;
                }
                case 182: {
                    n6 = 111;
                    break;
                }
                case 183: {
                    n6 = 49;
                    break;
                }
                case 184: {
                    n6 = 80;
                    break;
                }
                case 185: {
                    n6 = 94;
                    break;
                }
                case 186: {
                    n6 = 210;
                    break;
                }
                case 187: {
                    n6 = 70;
                    break;
                }
                case 188: {
                    n6 = 58;
                    break;
                }
                case 189: {
                    n6 = 205;
                    break;
                }
                case 190: {
                    n6 = 190;
                    break;
                }
                case 191: {
                    n6 = 51;
                    break;
                }
                case 192: {
                    n6 = 198;
                    break;
                }
                case 193: {
                    n6 = 24;
                    break;
                }
                case 194: {
                    n6 = 146;
                    break;
                }
                case 195: {
                    n6 = 174;
                    break;
                }
                case 196: {
                    n6 = 192;
                    break;
                }
                case 197: {
                    n6 = 233;
                    break;
                }
                case 198: {
                    n6 = 96;
                    break;
                }
                case 199: {
                    n6 = 134;
                    break;
                }
                case 200: {
                    n6 = 87;
                    break;
                }
                case 201: {
                    n6 = 30;
                    break;
                }
                case 202: {
                    n6 = 16;
                    break;
                }
                case 203: {
                    n6 = 223;
                    break;
                }
                case 204: {
                    n6 = 230;
                    break;
                }
                case 205: {
                    n6 = 206;
                    break;
                }
                case 206: {
                    n6 = 78;
                    break;
                }
                case 207: {
                    n6 = 242;
                    break;
                }
                case 208: {
                    n6 = 135;
                    break;
                }
                case 209: {
                    n6 = 224;
                    break;
                }
                case 210: {
                    n6 = 29;
                    break;
                }
                case 211: {
                    n6 = 215;
                    break;
                }
                case 212: {
                    n6 = 184;
                    break;
                }
                case 213: {
                    n6 = 45;
                    break;
                }
                case 214: {
                    n6 = 254;
                    break;
                }
                case 215: {
                    n6 = 151;
                    break;
                }
                case 216: {
                    n6 = 216;
                    break;
                }
                case 217: {
                    n6 = 218;
                    break;
                }
                case 218: {
                    n6 = 212;
                    break;
                }
                case 219: {
                    n6 = 52;
                    break;
                }
                case 220: {
                    n6 = 127;
                    break;
                }
                case 221: {
                    n6 = 238;
                    break;
                }
                case 222: {
                    n6 = 90;
                    break;
                }
                case 223: {
                    n6 = 214;
                    break;
                }
                case 224: {
                    n6 = 73;
                    break;
                }
                case 225: {
                    n6 = 125;
                    break;
                }
                case 226: {
                    n6 = 166;
                    break;
                }
                case 227: {
                    n6 = 176;
                    break;
                }
                case 228: {
                    n6 = 235;
                    break;
                }
                case 229: {
                    n6 = 7;
                    break;
                }
                case 230: {
                    n6 = 121;
                    break;
                }
                case 231: {
                    n6 = 133;
                    break;
                }
                case 232: {
                    n6 = 188;
                    break;
                }
                case 233: {
                    n6 = 219;
                    break;
                }
                case 234: {
                    n6 = 139;
                    break;
                }
                case 235: {
                    n6 = 75;
                    break;
                }
                case 236: {
                    n6 = 54;
                    break;
                }
                case 237: {
                    n6 = 27;
                    break;
                }
                case 238: {
                    n6 = 167;
                    break;
                }
                case 239: {
                    n6 = 4;
                    break;
                }
                case 240: {
                    n6 = 57;
                    break;
                }
                case 241: {
                    n6 = 47;
                    break;
                }
                case 242: {
                    n6 = 44;
                    break;
                }
                case 243: {
                    n6 = 92;
                    break;
                }
                case 244: {
                    n6 = 136;
                    break;
                }
                case 245: {
                    n6 = 140;
                    break;
                }
                case 246: {
                    n6 = 208;
                    break;
                }
                case 247: {
                    n6 = 217;
                    break;
                }
                case 248: {
                    n6 = 138;
                    break;
                }
                case 249: {
                    n6 = 164;
                    break;
                }
                case 250: {
                    n6 = 88;
                    break;
                }
                case 251: {
                    n6 = 60;
                    break;
                }
                case 252: {
                    n6 = 243;
                    break;
                }
                case 253: {
                    n6 = 86;
                    break;
                }
                case 254: {
                    n6 = 109;
                    break;
                }
                default: {
                    n6 = 122;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            APDUSmartCard.e[n4] = new String(cArray).intern();
        }
        return e[n4];
    }
}

