/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.smartcard.config.CardTypeConfig;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.Application;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.AEPTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.ATIKHSMTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.AcsTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.AkisTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.AladdinTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.AtikKGTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.CardTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.CardosTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.DataKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.DefaultCardTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.DirakHSMTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.GemPlusTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.ICardTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.KeyCorpTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.NCipherTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.SafeSignTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.SafenetTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.SefirotTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.TKartTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.UtimacoTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.UtimacoTemplateR2;

public class CardType
implements Serializable {
    protected static Map<String, CardType> cards;
    protected static Map<String, List<String>> cardATRs;
    public static final String JVM_BITSIZE;
    public static final CardType AKIS;
    public static final CardType AKIS_KK;
    public static final CardType CARDOS;
    public static final CardType ACS;
    public static final CardType ALADDIN;
    public static final CardType DATAKEY;
    public static final CardType GEMPLUS;
    public static final CardType KEYCORP;
    public static final CardType NCIPHER;
    public static final CardType SAFESIGN;
    public static final CardType SEFIROT;
    public static final CardType AEPKEYPER;
    public static final CardType UTIMACO;
    public static final CardType UTIMACO_R2;
    public static final CardType TKART;
    public static final CardType ATIKKG;
    public static final CardType SAFENET;
    public static final CardType ATIKHSM;
    public static final CardType DIRAKHSM;
    public static final CardType OPENDNSSOFTHSM;
    public static final CardType PROCENNEHSM;
    public static final CardType NETID;
    public static final CardType UNKNOWN;
    public static final CardType GEMALTO;
    private static Logger a;
    protected String name;
    protected ICardTemplate template;
    protected String libName;
    protected String libNamex32;
    protected String libNamex64;
    protected boolean supportsWrapUnwrap;
    protected Class<? extends CardTemplate> templateClass;
    protected Application app;
    public static int b;
    private static final String[] c;
    private static final String[] d;

    public CardType(String aLibName, String aName) {
        this.libName = aLibName;
        this.libNamex32 = aLibName;
        this.libNamex64 = aLibName;
        this.name = aName;
        this.template = new DefaultCardTemplate(this);
        cards.put(this.name, this);
    }

    public CardType(String aLibName, Class<? extends CardTemplate> aTemplateClass, String aName, Application aApp) {
        this.libNamex32 = aLibName;
        this.libNamex64 = aLibName;
        this.libName = aLibName;
        this.templateClass = aTemplateClass;
        this.name = aName;
        this.app = aApp;
        cards.put(this.name, this);
    }

    public CardType(String a32BitLibName, String a64BitLibName, Class<? extends CardTemplate> aTemplateClass, String aName, Application aApp) {
        this.libNamex32 = a32BitLibName;
        this.libNamex64 = a64BitLibName;
        this.libName = CardType.a(6035, -20885).equals(JVM_BITSIZE) ? a32BitLibName : a64BitLibName;
        this.templateClass = aTemplateClass;
        this.name = aName;
        this.app = aApp;
        cards.put(this.name, this);
    }

    public CardType(String a32BitLibName, String a64BitLibName, Class<? extends CardTemplate> aTemplateClass, String aName, Application aApp, boolean supportsWrapUnwrap) {
        this.libNamex32 = a32BitLibName;
        this.libNamex64 = a64BitLibName;
        this.libName = CardType.a(6035, -20885).equals(JVM_BITSIZE) ? a32BitLibName : a64BitLibName;
        this.templateClass = aTemplateClass;
        this.name = aName;
        this.app = aApp;
        this.supportsWrapUnwrap = supportsWrapUnwrap;
        cards.put(this.name, this);
    }

    public CardType(String aLibName, Class<? extends CardTemplate> aTemplateClass, String aName, Application aApp, boolean supportsWrapUnwrap) {
        this.libNamex32 = aLibName;
        this.libNamex64 = aLibName;
        this.libName = aLibName;
        this.templateClass = aTemplateClass;
        this.name = aName;
        this.app = aApp;
        this.supportsWrapUnwrap = supportsWrapUnwrap;
        cards.put(this.name, this);
    }

    public String getLibNamex64() {
        return this.libNamex64;
    }

    private CardType(CardTypeConfig cardTypeConfig) {
        this.a(cardTypeConfig.getLib(), cardTypeConfig.getLib32(), cardTypeConfig.getLib64());
        this.templateClass = DefaultCardTemplate.class;
        this.name = cardTypeConfig.getName();
        this.app = Application.ESIGNATURE;
        cards.put(this.name, this);
    }

    private void a(String string, String string2, String string3) {
        block9: {
            block8: {
                this.libName = string;
                this.libNamex32 = string2;
                this.libNamex64 = string3;
                if (string2 == null || !CardType.a(6063, 8408).equals(JVM_BITSIZE)) break block8;
                this.libName = string2;
            }
            if (string3 == null || !CardType.a(6025, -2028).equals(JVM_BITSIZE)) break block9;
            this.libName = string3;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLibName() {
        return this.libName;
    }

    public boolean isSupportsWrapUnwrap() {
        return this.supportsWrapUnwrap;
    }

    public void setSupportsWrapUnwrap(boolean supportsWrapUnwrap) {
        this.supportsWrapUnwrap = supportsWrapUnwrap;
    }

    public synchronized ICardTemplate getCardTemplate() {
        block7: {
            int n2 = b;
            if (this.template == null) {
                try {
                    Constructor<? extends CardTemplate> constructor;
                    block6: {
                        if (!AkisTemplate.class.equals(this.templateClass) && !DefaultCardTemplate.class.equals(this.templateClass)) break block6;
                        constructor = this.templateClass.getConstructor(CardType.class);
                        this.template = constructor.newInstance(this);
                        if (n2 == 0) break block7;
                    }
                    constructor = this.templateClass.getConstructor(null);
                    this.template = constructor.newInstance(null);
                }
                catch (Exception exception) {
                    throw new ESYARuntimeException(exception);
                }
            }
        }
        return this.template;
    }

    public static CardType[] getCardTypes() {
        return cards.values().toArray(new CardType[cards.size()]);
    }

    public static CardType getCardTypeFromATR(String aATRHex, Application aApp) {
        block19: {
            block20: {
                Iterator<CardType> iterator = cards.values().iterator();
                int n2 = b;
                while (iterator.hasNext()) {
                    CardType cardType = iterator.next();
                    if (cardType.getApplication().equals((Object)aApp)) {
                        List<String> list = cardATRs.get(cardType.getName());
                        if (list != null) {
                            for (String runtimeException : list) {
                                if (runtimeException.equalsIgnoreCase(aATRHex)) {
                                    return cardType;
                                }
                                if (n2 == 0) continue;
                            }
                        }
                        String[] stringArray = null;
                        try {
                            stringArray = cardType.getCardTemplate().getATRHashes();
                        }
                        catch (RuntimeException runtimeException) {
                            a.error(CardType.a(6071, 10653), runtimeException);
                        }
                        if (stringArray == null) {
                            continue;
                        }
                        for (String string : stringArray) {
                            if (!string.equalsIgnoreCase(aATRHex)) continue;
                            return cardType;
                        }
                    }
                    if (n2 == 0) continue;
                }
                if (!AkisTemplate.isAkisATR(aATRHex)) break block19;
                if (aApp != Application.TCKK) break block20;
                return AKIS_KK;
            }
            return AKIS;
        }
        return UNKNOWN;
    }

    public static CardType getCardType(String aLibName) {
        Iterator<CardType> iterator = cards.values().iterator();
        int n2 = b;
        while (iterator.hasNext()) {
            block15: {
                CardType cardType;
                block14: {
                    block13: {
                        cardType = iterator.next();
                        if (cardType.getLibName() == null || !cardType.getLibName().equals(aLibName)) break block13;
                        return cardType;
                    }
                    if (cardType.getLibNamex64() == null || !cardType.getLibNamex64().equals(aLibName)) break block14;
                    return cardType;
                }
                if (cardType.getLibNamex32() == null || !cardType.getLibNamex32().equals(aLibName)) break block15;
                return cardType;
            }
            if (n2 == 0) continue;
        }
        return UNKNOWN;
    }

    public static CardType getCardTypeFromName(String aCardName) {
        Iterator<CardType> iterator = cards.values().iterator();
        int n2 = b;
        while (iterator.hasNext()) {
            CardType cardType = iterator.next();
            if (cardType.getName().equals(aCardName)) {
                return cardType;
            }
            if (n2 == 0) continue;
        }
        return UNKNOWN;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void applyCardTypeConfig(List<CardTypeConfig> config) {
        Iterator<CardTypeConfig> iterator = config.iterator();
        int n2 = b;
        while (iterator.hasNext()) {
            block5: {
                CardTypeConfig cardTypeConfig;
                block4: {
                    cardTypeConfig = iterator.next();
                    if (!cards.containsKey(cardTypeConfig.getName())) break block4;
                    CardType cardType = cards.get(cardTypeConfig.getName());
                    cardType.a(cardTypeConfig.getLib(), cardTypeConfig.getLib32(), cardTypeConfig.getLib64());
                    cardType.getCardTemplate().getATRHashes();
                    cardATRs.put(cardType.getName(), cardTypeConfig.getAtrs());
                    if (n2 == 0) break block5;
                }
                new CardType(cardTypeConfig);
            }
            if (n2 == 0) continue;
        }
    }

    public String toString() {
        return this.getName();
    }

    public Application getApplication() {
        return this.app;
    }

    public static void main(String[] args) {
        CardType[] cardTypeArray;
        CardType[] cardTypeArray2 = cardTypeArray = CardType.getCardTypes();
        int n2 = cardTypeArray2.length;
        int n3 = b;
        for (int i2 = 0; i2 < n2; ++i2) {
            CardType cardType = cardTypeArray2[i2];
            if (n3 == 0) continue;
        }
        System.out.println(CardType.getCardType(CardType.a(6076, -10542)));
    }

    public String getLibNamex32() {
        return this.libNamex32;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[58];
                var3_1 = 0;
                var2_2 = "\u00f7\r\u0010\u009a\u009d\u00b5_\u00e0\f\u00c0\u00c6\u00d0\u00c2x\u00b2\u0007\u00d5ij\u001fv\b\u00ab\u001c\u0096\u0002\u00ad>\u00c0U\u0007_3\f=\u00fc\u00f81\u000b\u001a\u0014A\u00d0\u00c2\u00d0\u0012\u00e8\u00dd\u00a4p\u000b\u00139\u00e6\u001e$u\u00dd\u00b8\u0003\u00a8\u001b\u0007\u0011\u0004\u00c5S\u00d9\u00b2\n\u0002t\u0016\u0006[\u0080\u008aJ\u00bb!\t\u0003\u008bf\u0003\"\u00a1Sn\u00c3\u0007\u00a4&\u009d\u00d7x:=\u0006\u008b\u00f4\u00c9|\u00af\u001d\u0007\u00e6\u00c8\u008a\u0015\u00c4J\u00f6\u000b\u00f8\u00de\u001d\u0089I\u00fbc\u008d\u00f3\r\u00b3\u0004\u000b\u0004\u00d9\u0086\bj=\u00eci\u00b1\u00d7>k\u0014\u0012\u00f39\u001d3\u009d\u0084\u00daI\u00b9\u0093\u00f2\u00ee\\\u0092\u00e8Gf\u001a\u00ed\u0007\u00d0i\u00a6/]>\u0099\u000b\u00c0!\u0091\f\u007f\u0000\u00de\u009fo\u00faq\b\u0089\u0012\u00d9;w\u00df\u00b7c\u000f\u00dd#\u0017\u0089H\u0097U\u00ff\u00adz\u00b7\u00cc-\u00c5;\u0007\u001f\u00de\u00cfe)\u008b\u00b0\n\u00e5\u00bbE`\u00d7\"\u00be\u00c9\u00be\u001d\u0005=\u00d2\u00a0]\u0094\u0003\u00fb\u00ad\u00dd\f\u0098\u00b9\u00f0\u00b6a\u00a8Y\u0087cd\u00a5r\n\u00ad\u00b6\u0010\u00e3\u00bbT\u0017By\u00fc\u0006\u0013\u00b9\u00dat?6\u0006jH&\u009a\u00cah\u0002=\u0005\b\u00b0\u00ad\u00f1\u00ee^\u008e\u00c8B\u0007\u00d5\u00a0\u00c0\u00de\r#J\n\u008e\u009am\u00b5\u001f \u00e3X\u0003\u00dd\u0002\u008d\u00b8\u0007Y`\u0093\n\u00f0\u00c4\u009c\u0005 \u0002{QQ\bh\u000b\u00ed1\u00a8\u00ae\u0014'\u0007\u0094\u008b\"\u0087\u00d4\u0082e\t\u00e3\u00a7\u00dd%\u0019(\u00e3\u008f\u00d1\u0007\u00a1\u009e\u001a7\u00df\u00b6\u00a0\n(\u00da\u00bfP\u00b8\u008bw\u00b9u\u0083\t\u0003T\u00e5\u0088?\u00ca\u00fe\u0095\u0015\r\u00a6\u00e5\u00e4\u00c3L$\u00e9L\u00a6=\u00cc;-\u0005H\u001f\u00eee/\u0007\u0099\u0084\u00d0I\u009a\u00a7\u00d8\n0\u00a6(0\u0099Vh\u0003\\~\n\u0095M\u0082\u00d6\u0080\u0086p\u0018\u0095\u00b7\u0007<~\u0087\u0090\u00d8\u00c9\u001d\fF>E\u00eb\u00f6\u00ef\u0000\u0082}m?\u001c\u0013b\u0014\u00a7\u0000\u008bn\"$\u00c0\u001d\u00e5\u0082g\u00f9q\u001e\u0012S{\n\u0016~g\u00faUw\u00ca&\u00c2p\u0007(N\u00fc\u00de\u00e0\u00f5X\u0007\n2R\\\u00caJa\u000f\u00f80e\u00dd\u00b9q\u00c0mRU\r\u0089E\u00190\b3og/hgN}\u0007\u00b5\u00df\u000e\u0019T\u00a5\u00fb";
                var4_3 = "\u00f7\r\u0010\u009a\u009d\u00b5_\u00e0\f\u00c0\u00c6\u00d0\u00c2x\u00b2\u0007\u00d5ij\u001fv\b\u00ab\u001c\u0096\u0002\u00ad>\u00c0U\u0007_3\f=\u00fc\u00f81\u000b\u001a\u0014A\u00d0\u00c2\u00d0\u0012\u00e8\u00dd\u00a4p\u000b\u00139\u00e6\u001e$u\u00dd\u00b8\u0003\u00a8\u001b\u0007\u0011\u0004\u00c5S\u00d9\u00b2\n\u0002t\u0016\u0006[\u0080\u008aJ\u00bb!\t\u0003\u008bf\u0003\"\u00a1Sn\u00c3\u0007\u00a4&\u009d\u00d7x:=\u0006\u008b\u00f4\u00c9|\u00af\u001d\u0007\u00e6\u00c8\u008a\u0015\u00c4J\u00f6\u000b\u00f8\u00de\u001d\u0089I\u00fbc\u008d\u00f3\r\u00b3\u0004\u000b\u0004\u00d9\u0086\bj=\u00eci\u00b1\u00d7>k\u0014\u0012\u00f39\u001d3\u009d\u0084\u00daI\u00b9\u0093\u00f2\u00ee\\\u0092\u00e8Gf\u001a\u00ed\u0007\u00d0i\u00a6/]>\u0099\u000b\u00c0!\u0091\f\u007f\u0000\u00de\u009fo\u00faq\b\u0089\u0012\u00d9;w\u00df\u00b7c\u000f\u00dd#\u0017\u0089H\u0097U\u00ff\u00adz\u00b7\u00cc-\u00c5;\u0007\u001f\u00de\u00cfe)\u008b\u00b0\n\u00e5\u00bbE`\u00d7\"\u00be\u00c9\u00be\u001d\u0005=\u00d2\u00a0]\u0094\u0003\u00fb\u00ad\u00dd\f\u0098\u00b9\u00f0\u00b6a\u00a8Y\u0087cd\u00a5r\n\u00ad\u00b6\u0010\u00e3\u00bbT\u0017By\u00fc\u0006\u0013\u00b9\u00dat?6\u0006jH&\u009a\u00cah\u0002=\u0005\b\u00b0\u00ad\u00f1\u00ee^\u008e\u00c8B\u0007\u00d5\u00a0\u00c0\u00de\r#J\n\u008e\u009am\u00b5\u001f \u00e3X\u0003\u00dd\u0002\u008d\u00b8\u0007Y`\u0093\n\u00f0\u00c4\u009c\u0005 \u0002{QQ\bh\u000b\u00ed1\u00a8\u00ae\u0014'\u0007\u0094\u008b\"\u0087\u00d4\u0082e\t\u00e3\u00a7\u00dd%\u0019(\u00e3\u008f\u00d1\u0007\u00a1\u009e\u001a7\u00df\u00b6\u00a0\n(\u00da\u00bfP\u00b8\u008bw\u00b9u\u0083\t\u0003T\u00e5\u0088?\u00ca\u00fe\u0095\u0015\r\u00a6\u00e5\u00e4\u00c3L$\u00e9L\u00a6=\u00cc;-\u0005H\u001f\u00eee/\u0007\u0099\u0084\u00d0I\u009a\u00a7\u00d8\n0\u00a6(0\u0099Vh\u0003\\~\n\u0095M\u0082\u00d6\u0080\u0086p\u0018\u0095\u00b7\u0007<~\u0087\u0090\u00d8\u00c9\u001d\fF>E\u00eb\u00f6\u00ef\u0000\u0082}m?\u001c\u0013b\u0014\u00a7\u0000\u008bn\"$\u00c0\u001d\u00e5\u0082g\u00f9q\u001e\u0012S{\n\u0016~g\u00faUw\u00ca&\u00c2p\u0007(N\u00fc\u00de\u00e0\u00f5X\u0007\n2R\\\u00caJa\u000f\u00f80e\u00dd\u00b9q\u00c0mRU\r\u0089E\u00190\b3og/hgN}\u0007\u00b5\u00df\u000e\u0019T\u00a5\u00fb".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0013\u0016\u00ce/sC2eA)*\u00a6\u009e\u001cf\u0084\u0011\u008aR\u00ed\u00e0\u00a2 \u009a\u0019\u00b3i#Jk\u0094g\u0006\u0007!\u001c\u0016\u00a2\u0019\u00f6A\u008b";
                    var4_3 = "\u0013\u0016\u00ce/sC2eA)*\u00a6\u009e\u001cf\u0084\u0011\u008aR\u00ed\u00e0\u00a2 \u009a\u0019\u00b3i#Jk\u0094g\u0006\u0007!\u001c\u0016\u00a2\u0019\u00f6A\u008b".length();
                    var1_4 = 13;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 63;
                            break;
                        }
                        case 1: {
                            v13 = 67;
                            break;
                        }
                        case 2: {
                            v13 = 127;
                            break;
                        }
                        case 3: {
                            v13 = 31;
                            break;
                        }
                        case 4: {
                            v13 = 82;
                            break;
                        }
                        case 5: {
                            v13 = 20;
                            break;
                        }
                        default: {
                            v13 = 55;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CardType.c = var5;
        CardType.d = new String[58];
        CardType.cards = new TreeMap<String, CardType>();
        CardType.cardATRs = new HashMap<String, List<String>>();
        CardType.JVM_BITSIZE = System.getProperty(CardType.a(6079, -20292));
        CardType.AKIS = new CardType(CardType.a(6047, 7530), AkisTemplate.class, CardType.a(6016, -14287), Application.ESIGNATURE);
        CardType.AKIS_KK = new CardType(CardType.a(6020, -7734), AkisTemplate.class, CardType.a(6060, 31546), Application.TCKK);
        CardType.CARDOS = new CardType(CardType.a(6053, -5684), CardosTemplate.class, CardType.a(6022, 21496), Application.ESIGNATURE);
        CardType.ACS = new CardType(CardType.a(6054, -1418), AcsTemplate.class, CardType.a(6038, -29596), Application.ESIGNATURE);
        CardType.ALADDIN = new CardType(CardType.a(6072, 22858), AladdinTemplate.class, CardType.a(6059, -412), Application.ESIGNATURE);
        CardType.DATAKEY = new CardType(CardType.a(6074, 10592), DataKeyTemplate.class, CardType.a(6049, -22156), Application.ESIGNATURE);
        CardType.GEMPLUS = new CardType(CardType.a(6061, 86), GemPlusTemplate.class, CardType.a(6033, 2320), Application.ESIGNATURE);
        CardType.KEYCORP = new CardType(CardType.a(6045, 10187), KeyCorpTemplate.class, CardType.a(6050, -22252), Application.ESIGNATURE);
        CardType.NCIPHER = new CardType(CardType.a(6077, 26228), CardType.a(6040, 14173), NCipherTemplate.class, CardType.a(6018, 15371), Application.ESIGNATURE, true);
        CardType.SAFESIGN = new CardType(CardType.a(6017, -5886), SafeSignTemplate.class, CardType.a(6032, -5352), Application.ESIGNATURE, true);
        CardType.SEFIROT = new CardType(CardType.a(6055, 20769), SefirotTemplate.class, CardType.a(6024, 30963), Application.ESIGNATURE);
        CardType.AEPKEYPER = new CardType(CardType.a(6027, 22170), AEPTemplate.class, CardType.a(6056, -7972), Application.ESIGNATURE);
        CardType.UTIMACO = new CardType(CardType.a(6036, -407), UtimacoTemplate.class, CardType.a(6057, 22682), Application.ESIGNATURE, true);
        CardType.UTIMACO_R2 = new CardType(CardType.a(6031, 26895), UtimacoTemplateR2.class, CardType.a(6051, -10625), Application.ESIGNATURE, true);
        CardType.TKART = new CardType(CardType.a(6058, -31095), TKartTemplate.class, CardType.a(6041, 5264), Application.ESIGNATURE);
        CardType.ATIKKG = new CardType(CardType.a(6062, 23422), AtikKGTemplate.class, CardType.a(6021, 28545), Application.ESIGNATURE);
        CardType.SAFENET = new CardType(CardType.a(6030, 8078), SafenetTemplate.class, CardType.a(6029, 9768), Application.ESIGNATURE, true);
        CardType.ATIKHSM = new CardType(CardType.a(6048, 11172), CardType.a(6052, 15450), ATIKHSMTemplate.class, CardType.a(6073, 22362), Application.ESIGNATURE);
        CardType.DIRAKHSM = new CardType(CardType.a(6019, 11740), CardType.a(6026, -25698), DirakHSMTemplate.class, CardType.a(6023, 30285), Application.ESIGNATURE, true);
        CardType.OPENDNSSOFTHSM = new CardType(CardType.a(6028, -15494), CardType.a(6039, -2507), DefaultCardTemplate.class, CardType.a(6046, -6809), Application.ESIGNATURE);
        CardType.PROCENNEHSM = new CardType(CardType.a(6044, -31998), DefaultCardTemplate.class, CardType.a(6078, -12086), Application.ESIGNATURE);
        CardType.NETID = new CardType(CardType.a(6037, -8303), DefaultCardTemplate.class, CardType.a(6034, 15593), Application.ESIGNATURE);
        CardType.UNKNOWN = new CardType("", DefaultCardTemplate.class, CardType.a(6043, 6587), Application.ESIGNATURE);
        CardType.GEMALTO = new CardType(CardType.a(6070, 32145), CardType.a(6042, -15542), DefaultCardTemplate.class, CardType.a(6075, 28601), Application.ESIGNATURE);
        CardType.a = LoggerFactory.getLogger(CardType.class);
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0x178E) & 0xFFFF;
        if (d[n4] == null) {
            int n5;
            int n6;
            char[] cArray = c[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 23;
                    break;
                }
                case 1: {
                    n6 = 251;
                    break;
                }
                case 2: {
                    n6 = 58;
                    break;
                }
                case 3: {
                    n6 = 45;
                    break;
                }
                case 4: {
                    n6 = 193;
                    break;
                }
                case 5: {
                    n6 = 177;
                    break;
                }
                case 6: {
                    n6 = 43;
                    break;
                }
                case 7: {
                    n6 = 158;
                    break;
                }
                case 8: {
                    n6 = 229;
                    break;
                }
                case 9: {
                    n6 = 90;
                    break;
                }
                case 10: {
                    n6 = 44;
                    break;
                }
                case 11: {
                    n6 = 135;
                    break;
                }
                case 12: {
                    n6 = 225;
                    break;
                }
                case 13: {
                    n6 = 3;
                    break;
                }
                case 14: {
                    n6 = 242;
                    break;
                }
                case 15: {
                    n6 = 37;
                    break;
                }
                case 16: {
                    n6 = 83;
                    break;
                }
                case 17: {
                    n6 = 16;
                    break;
                }
                case 18: {
                    n6 = 80;
                    break;
                }
                case 19: {
                    n6 = 133;
                    break;
                }
                case 20: {
                    n6 = 185;
                    break;
                }
                case 21: {
                    n6 = 129;
                    break;
                }
                case 22: {
                    n6 = 170;
                    break;
                }
                case 23: {
                    n6 = 0;
                    break;
                }
                case 24: {
                    n6 = 84;
                    break;
                }
                case 25: {
                    n6 = 72;
                    break;
                }
                case 26: {
                    n6 = 125;
                    break;
                }
                case 27: {
                    n6 = 178;
                    break;
                }
                case 28: {
                    n6 = 240;
                    break;
                }
                case 29: {
                    n6 = 18;
                    break;
                }
                case 30: {
                    n6 = 211;
                    break;
                }
                case 31: {
                    n6 = 222;
                    break;
                }
                case 32: {
                    n6 = 70;
                    break;
                }
                case 33: {
                    n6 = 27;
                    break;
                }
                case 34: {
                    n6 = 163;
                    break;
                }
                case 35: {
                    n6 = 165;
                    break;
                }
                case 36: {
                    n6 = 144;
                    break;
                }
                case 37: {
                    n6 = 93;
                    break;
                }
                case 38: {
                    n6 = 88;
                    break;
                }
                case 39: {
                    n6 = 55;
                    break;
                }
                case 40: {
                    n6 = 134;
                    break;
                }
                case 41: {
                    n6 = 136;
                    break;
                }
                case 42: {
                    n6 = 4;
                    break;
                }
                case 43: {
                    n6 = 53;
                    break;
                }
                case 44: {
                    n6 = 76;
                    break;
                }
                case 45: {
                    n6 = 5;
                    break;
                }
                case 46: {
                    n6 = 118;
                    break;
                }
                case 47: {
                    n6 = 48;
                    break;
                }
                case 48: {
                    n6 = 149;
                    break;
                }
                case 49: {
                    n6 = 210;
                    break;
                }
                case 50: {
                    n6 = 95;
                    break;
                }
                case 51: {
                    n6 = 239;
                    break;
                }
                case 52: {
                    n6 = 188;
                    break;
                }
                case 53: {
                    n6 = 15;
                    break;
                }
                case 54: {
                    n6 = 221;
                    break;
                }
                case 55: {
                    n6 = 244;
                    break;
                }
                case 56: {
                    n6 = 117;
                    break;
                }
                case 57: {
                    n6 = 103;
                    break;
                }
                case 58: {
                    n6 = 29;
                    break;
                }
                case 59: {
                    n6 = 172;
                    break;
                }
                case 60: {
                    n6 = 213;
                    break;
                }
                case 61: {
                    n6 = 138;
                    break;
                }
                case 62: {
                    n6 = 74;
                    break;
                }
                case 63: {
                    n6 = 100;
                    break;
                }
                case 64: {
                    n6 = 128;
                    break;
                }
                case 65: {
                    n6 = 20;
                    break;
                }
                case 66: {
                    n6 = 105;
                    break;
                }
                case 67: {
                    n6 = 233;
                    break;
                }
                case 68: {
                    n6 = 235;
                    break;
                }
                case 69: {
                    n6 = 141;
                    break;
                }
                case 70: {
                    n6 = 54;
                    break;
                }
                case 71: {
                    n6 = 10;
                    break;
                }
                case 72: {
                    n6 = 32;
                    break;
                }
                case 73: {
                    n6 = 252;
                    break;
                }
                case 74: {
                    n6 = 216;
                    break;
                }
                case 75: {
                    n6 = 151;
                    break;
                }
                case 76: {
                    n6 = 75;
                    break;
                }
                case 77: {
                    n6 = 61;
                    break;
                }
                case 78: {
                    n6 = 228;
                    break;
                }
                case 79: {
                    n6 = 162;
                    break;
                }
                case 80: {
                    n6 = 232;
                    break;
                }
                case 81: {
                    n6 = 59;
                    break;
                }
                case 82: {
                    n6 = 137;
                    break;
                }
                case 83: {
                    n6 = 62;
                    break;
                }
                case 84: {
                    n6 = 98;
                    break;
                }
                case 85: {
                    n6 = 206;
                    break;
                }
                case 86: {
                    n6 = 168;
                    break;
                }
                case 87: {
                    n6 = 101;
                    break;
                }
                case 88: {
                    n6 = 126;
                    break;
                }
                case 89: {
                    n6 = 131;
                    break;
                }
                case 90: {
                    n6 = 12;
                    break;
                }
                case 91: {
                    n6 = 238;
                    break;
                }
                case 92: {
                    n6 = 200;
                    break;
                }
                case 93: {
                    n6 = 142;
                    break;
                }
                case 94: {
                    n6 = 250;
                    break;
                }
                case 95: {
                    n6 = 11;
                    break;
                }
                case 96: {
                    n6 = 245;
                    break;
                }
                case 97: {
                    n6 = 8;
                    break;
                }
                case 98: {
                    n6 = 124;
                    break;
                }
                case 99: {
                    n6 = 205;
                    break;
                }
                case 100: {
                    n6 = 209;
                    break;
                }
                case 101: {
                    n6 = 26;
                    break;
                }
                case 102: {
                    n6 = 19;
                    break;
                }
                case 103: {
                    n6 = 2;
                    break;
                }
                case 104: {
                    n6 = 114;
                    break;
                }
                case 105: {
                    n6 = 127;
                    break;
                }
                case 106: {
                    n6 = 255;
                    break;
                }
                case 107: {
                    n6 = 66;
                    break;
                }
                case 108: {
                    n6 = 82;
                    break;
                }
                case 109: {
                    n6 = 241;
                    break;
                }
                case 110: {
                    n6 = 52;
                    break;
                }
                case 111: {
                    n6 = 198;
                    break;
                }
                case 112: {
                    n6 = 160;
                    break;
                }
                case 113: {
                    n6 = 40;
                    break;
                }
                case 114: {
                    n6 = 202;
                    break;
                }
                case 115: {
                    n6 = 34;
                    break;
                }
                case 116: {
                    n6 = 132;
                    break;
                }
                case 117: {
                    n6 = 159;
                    break;
                }
                case 118: {
                    n6 = 22;
                    break;
                }
                case 119: {
                    n6 = 184;
                    break;
                }
                case 120: {
                    n6 = 217;
                    break;
                }
                case 121: {
                    n6 = 161;
                    break;
                }
                case 122: {
                    n6 = 248;
                    break;
                }
                case 123: {
                    n6 = 204;
                    break;
                }
                case 124: {
                    n6 = 104;
                    break;
                }
                case 125: {
                    n6 = 230;
                    break;
                }
                case 126: {
                    n6 = 215;
                    break;
                }
                case 127: {
                    n6 = 175;
                    break;
                }
                case 128: {
                    n6 = 173;
                    break;
                }
                case 129: {
                    n6 = 234;
                    break;
                }
                case 130: {
                    n6 = 237;
                    break;
                }
                case 131: {
                    n6 = 17;
                    break;
                }
                case 132: {
                    n6 = 157;
                    break;
                }
                case 133: {
                    n6 = 201;
                    break;
                }
                case 134: {
                    n6 = 31;
                    break;
                }
                case 135: {
                    n6 = 167;
                    break;
                }
                case 136: {
                    n6 = 50;
                    break;
                }
                case 137: {
                    n6 = 89;
                    break;
                }
                case 138: {
                    n6 = 143;
                    break;
                }
                case 139: {
                    n6 = 254;
                    break;
                }
                case 140: {
                    n6 = 169;
                    break;
                }
                case 141: {
                    n6 = 179;
                    break;
                }
                case 142: {
                    n6 = 25;
                    break;
                }
                case 143: {
                    n6 = 60;
                    break;
                }
                case 144: {
                    n6 = 24;
                    break;
                }
                case 145: {
                    n6 = 113;
                    break;
                }
                case 146: {
                    n6 = 120;
                    break;
                }
                case 147: {
                    n6 = 64;
                    break;
                }
                case 148: {
                    n6 = 147;
                    break;
                }
                case 149: {
                    n6 = 189;
                    break;
                }
                case 150: {
                    n6 = 94;
                    break;
                }
                case 151: {
                    n6 = 208;
                    break;
                }
                case 152: {
                    n6 = 85;
                    break;
                }
                case 153: {
                    n6 = 110;
                    break;
                }
                case 154: {
                    n6 = 81;
                    break;
                }
                case 155: {
                    n6 = 219;
                    break;
                }
                case 156: {
                    n6 = 190;
                    break;
                }
                case 157: {
                    n6 = 77;
                    break;
                }
                case 158: {
                    n6 = 207;
                    break;
                }
                case 159: {
                    n6 = 91;
                    break;
                }
                case 160: {
                    n6 = 123;
                    break;
                }
                case 161: {
                    n6 = 176;
                    break;
                }
                case 162: {
                    n6 = 249;
                    break;
                }
                case 163: {
                    n6 = 247;
                    break;
                }
                case 164: {
                    n6 = 145;
                    break;
                }
                case 165: {
                    n6 = 195;
                    break;
                }
                case 166: {
                    n6 = 39;
                    break;
                }
                case 167: {
                    n6 = 97;
                    break;
                }
                case 168: {
                    n6 = 130;
                    break;
                }
                case 169: {
                    n6 = 150;
                    break;
                }
                case 170: {
                    n6 = 197;
                    break;
                }
                case 171: {
                    n6 = 122;
                    break;
                }
                case 172: {
                    n6 = 187;
                    break;
                }
                case 173: {
                    n6 = 56;
                    break;
                }
                case 174: {
                    n6 = 224;
                    break;
                }
                case 175: {
                    n6 = 156;
                    break;
                }
                case 176: {
                    n6 = 71;
                    break;
                }
                case 177: {
                    n6 = 174;
                    break;
                }
                case 178: {
                    n6 = 87;
                    break;
                }
                case 179: {
                    n6 = 139;
                    break;
                }
                case 180: {
                    n6 = 140;
                    break;
                }
                case 181: {
                    n6 = 92;
                    break;
                }
                case 182: {
                    n6 = 6;
                    break;
                }
                case 183: {
                    n6 = 13;
                    break;
                }
                case 184: {
                    n6 = 199;
                    break;
                }
                case 185: {
                    n6 = 186;
                    break;
                }
                case 186: {
                    n6 = 96;
                    break;
                }
                case 187: {
                    n6 = 79;
                    break;
                }
                case 188: {
                    n6 = 49;
                    break;
                }
                case 189: {
                    n6 = 41;
                    break;
                }
                case 190: {
                    n6 = 218;
                    break;
                }
                case 191: {
                    n6 = 212;
                    break;
                }
                case 192: {
                    n6 = 36;
                    break;
                }
                case 193: {
                    n6 = 38;
                    break;
                }
                case 194: {
                    n6 = 196;
                    break;
                }
                case 195: {
                    n6 = 107;
                    break;
                }
                case 196: {
                    n6 = 223;
                    break;
                }
                case 197: {
                    n6 = 109;
                    break;
                }
                case 198: {
                    n6 = 14;
                    break;
                }
                case 199: {
                    n6 = 57;
                    break;
                }
                case 200: {
                    n6 = 227;
                    break;
                }
                case 201: {
                    n6 = 1;
                    break;
                }
                case 202: {
                    n6 = 171;
                    break;
                }
                case 203: {
                    n6 = 121;
                    break;
                }
                case 204: {
                    n6 = 73;
                    break;
                }
                case 205: {
                    n6 = 181;
                    break;
                }
                case 206: {
                    n6 = 246;
                    break;
                }
                case 207: {
                    n6 = 148;
                    break;
                }
                case 208: {
                    n6 = 47;
                    break;
                }
                case 209: {
                    n6 = 21;
                    break;
                }
                case 210: {
                    n6 = 182;
                    break;
                }
                case 211: {
                    n6 = 28;
                    break;
                }
                case 212: {
                    n6 = 51;
                    break;
                }
                case 213: {
                    n6 = 9;
                    break;
                }
                case 214: {
                    n6 = 152;
                    break;
                }
                case 215: {
                    n6 = 112;
                    break;
                }
                case 216: {
                    n6 = 65;
                    break;
                }
                case 217: {
                    n6 = 116;
                    break;
                }
                case 218: {
                    n6 = 164;
                    break;
                }
                case 219: {
                    n6 = 214;
                    break;
                }
                case 220: {
                    n6 = 63;
                    break;
                }
                case 221: {
                    n6 = 68;
                    break;
                }
                case 222: {
                    n6 = 153;
                    break;
                }
                case 223: {
                    n6 = 236;
                    break;
                }
                case 224: {
                    n6 = 180;
                    break;
                }
                case 225: {
                    n6 = 192;
                    break;
                }
                case 226: {
                    n6 = 191;
                    break;
                }
                case 227: {
                    n6 = 33;
                    break;
                }
                case 228: {
                    n6 = 194;
                    break;
                }
                case 229: {
                    n6 = 146;
                    break;
                }
                case 230: {
                    n6 = 183;
                    break;
                }
                case 231: {
                    n6 = 243;
                    break;
                }
                case 232: {
                    n6 = 203;
                    break;
                }
                case 233: {
                    n6 = 46;
                    break;
                }
                case 234: {
                    n6 = 99;
                    break;
                }
                case 235: {
                    n6 = 106;
                    break;
                }
                case 236: {
                    n6 = 226;
                    break;
                }
                case 237: {
                    n6 = 35;
                    break;
                }
                case 238: {
                    n6 = 7;
                    break;
                }
                case 239: {
                    n6 = 220;
                    break;
                }
                case 240: {
                    n6 = 231;
                    break;
                }
                case 241: {
                    n6 = 119;
                    break;
                }
                case 242: {
                    n6 = 166;
                    break;
                }
                case 243: {
                    n6 = 102;
                    break;
                }
                case 244: {
                    n6 = 155;
                    break;
                }
                case 245: {
                    n6 = 154;
                    break;
                }
                case 246: {
                    n6 = 69;
                    break;
                }
                case 247: {
                    n6 = 111;
                    break;
                }
                case 248: {
                    n6 = 42;
                    break;
                }
                case 249: {
                    n6 = 108;
                    break;
                }
                case 250: {
                    n6 = 67;
                    break;
                }
                case 251: {
                    n6 = 30;
                    break;
                }
                case 252: {
                    n6 = 78;
                    break;
                }
                case 253: {
                    n6 = 253;
                    break;
                }
                case 254: {
                    n6 = 86;
                    break;
                }
                default: {
                    n6 = 115;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            CardType.d[n4] = new String(cArray).intern();
        }
        return d[n4];
    }
}

