/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.KeySpec;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Constants;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.infra.cache.FixedSizedCache;
import tr.gov.tubitak.uekae.esya.api.smartcard.object.UnwrapObjectsResults;
import tr.gov.tubitak.uekae.esya.api.smartcard.object.WrappedObjectsWithAttributes;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.Application;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.ISmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.PKCS11ConstantsExtended;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.PKCS11Names;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SlotInfo;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.algorithm.PKCS11AlgorithmUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.KeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.KeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.symmetric.SecretKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.DirakLibOps;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.PKCS11Ops;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.key.SecretKey;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.cardobject.P11Object;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.jna.structure.CK_MECHANISM_STRUCTURE;
import tr.gov.tubitak.uekae.esya.api.smartcard.util.ECSignatureTLVUtil;

public class SmartCard
implements ISmartCard {
    private static Logger a;
    protected CardType mCardType;
    protected Application mApplication;
    protected boolean isFipsEnabled = false;
    protected FixedSizedCache<Long, long[]> slotAndMechanismListCache = new FixedSizedCache(256, Duration.ofSeconds(5L));
    protected long mSlotID = -1L;
    protected long mSessionID = -1L;
    protected long[] mechsToBeRemoved = null;
    private static final String[] b;
    private static final String[] c;

    private SmartCard() {
        try {
            LV.getInstance().checkLD(LV.Urunler.AKILLIKART);
            this.mApplication = Application.ESIGNATURE;
        }
        catch (LE lE) {
            throw new ESYARuntimeException(SmartCard.a(30345, -2603) + lE.getMessage(), lE);
        }
    }

    public SmartCard(CardType aCardType) throws PKCS11Exception, IOException {
        this(aCardType, Application.ESIGNATURE);
    }

    public SmartCard(CardType aCardType, Application aApplication) throws PKCS11Exception, IOException {
        this();
        a.debug(SmartCard.a(30347, 9585) + aCardType.getName());
        this.mCardType = aCardType;
        this.mCardType.getCardTemplate().getPKCS11Ops().initialize();
        this.mApplication = aApplication;
    }

    public SmartCard(String aCardTypeName, String smartCardDllName) throws PKCS11Exception, IOException {
        this();
        this.mCardType = CardType.getCardTypeFromName(aCardTypeName);
        if (this.mCardType == CardType.UNKNOWN) {
            this.mCardType = CardType.getCardType(smartCardDllName);
        }
        this.mCardType.getCardTemplate().getPKCS11Ops().initialize();
    }

    public SmartCard(String aCardType) throws PKCS11Exception, IOException {
        this(CardType.getCardType(aCardType));
    }

    public void setFipsMode(boolean mode) {
        this.isFipsEnabled = mode;
    }

    public boolean isFipsModeEnable() {
        return this.isFipsEnabled;
    }

    public void setApplication(Application aApplication) {
        this.mApplication = aApplication;
    }

    public Application getApplication() {
        return this.mApplication;
    }

    @Override
    public long[] getTokenPresentSlotList() throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getTokenPresentSlotList();
    }

    @Override
    public List<Pair<Long, String>> getTokenPresentSlotListWithDescription() throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getTokenPresentSlotListWithDescription();
    }

    @Override
    public long[] getSlotList() throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getSlotList();
    }

    public List<SlotInfo> getSlotInfoList() throws PKCS11Exception {
        long[] lArray = this.getSlotList();
        ArrayList<SlotInfo> arrayList = new ArrayList<SlotInfo>();
        int n2 = CardType.b;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            long l2 = lArray[i2];
            CK_TOKEN_INFO cK_TOKEN_INFO = this.getTokenInfo(l2);
            SlotInfo slotInfo = new SlotInfo();
            slotInfo.setSlotId(l2);
            slotInfo.setSlotLabel(new String(cK_TOKEN_INFO.label).trim());
            arrayList.add(slotInfo);
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public long getLatestSlotID() {
        return this.mSlotID;
    }

    public long getLatestSessionID() {
        return this.mSessionID;
    }

    @Override
    public CK_SLOT_INFO getSlotInfo(long aSlotID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getSlotInfo(aSlotID);
    }

    @Override
    public CK_SESSION_INFO getSessionInfo(long aSessionID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getSessionInfo(aSessionID);
    }

    @Override
    public boolean isTokenPresent(long aSlotID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isTokenPresent(aSlotID);
    }

    @Override
    public CK_TOKEN_INFO getTokenInfo(long aSlotID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getTokenInfo(aSlotID);
    }

    @Override
    public long[] getMechanismList(long aSlotID) throws PKCS11Exception {
        long[] lArray = this.slotAndMechanismListCache.getItem(aSlotID);
        if (lArray == null) {
            lArray = this.mCardType.getCardTemplate().getPKCS11Ops().getMechanismList(aSlotID);
            lArray = this.a(lArray, this.mechsToBeRemoved);
            this.slotAndMechanismListCache.put(aSlotID, lArray);
        }
        return lArray;
    }

    public void setMechanismsToBeRemoved(long[] mechsToRemove) {
        this.mechsToBeRemoved = mechsToRemove;
    }

    private long[] a(long[] lArray, long[] lArray2) {
        int n2;
        block9: {
            n2 = CardType.b;
            if (lArray2 != null && lArray2.length != 0) break block9;
            return lArray;
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        for (long l2 : lArray2) {
            hashSet.add(l2);
            if (n2 == 0) continue;
        }
        Object object = new ArrayList();
        for (long l3 : lArray) {
            if (hashSet.contains(l3)) continue;
            object.add(l3);
        }
        long[] lArray3 = new long[object.size()];
        for (int i2 = 0; i2 < object.size(); ++i2) {
            lArray3[i2] = (Long)object.get(i2);
            if (n2 == 0) continue;
        }
        return lArray3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getMechanismNames(long[] mechanisms) throws IllegalAccessException {
        Object[] objectArray = PKCS11Constants.class.getFields();
        Field[] fieldArray = PKCS11ConstantsExtended.class.getFields();
        int n2 = CardType.b;
        ArrayList<Field> arrayList = new ArrayList<Field>(Arrays.asList(objectArray));
        arrayList.addAll(Arrays.asList(fieldArray));
        objectArray = new String[mechanisms.length];
        for (int i2 = 0; i2 < mechanisms.length; ++i2) {
            boolean bl = false;
            long l2 = mechanisms[i2];
            for (Field field : arrayList) {
                if (field.getName().startsWith(SmartCard.a(30338, -17724)) && field.getLong(null) == l2) {
                    objectArray[i2] = field.getName();
                    bl = true;
                    if (n2 == 0) break;
                }
                if (n2 == 0) continue;
            }
            if (bl) continue;
            objectArray[i2] = StringUtil.toFourByteHex((int)l2);
            if (n2 == 0) continue;
        }
        return objectArray;
    }

    public String[] getMechanismNames(long aSlotID) throws PKCS11Exception, IllegalAccessException {
        return SmartCard.getMechanismNames(this.getMechanismList(aSlotID));
    }

    @Override
    public long openSession(long aSlotID) throws PKCS11Exception {
        long l2;
        this.mSessionID = l2 = this.mCardType.getCardTemplate().getPKCS11Ops().openSession(aSlotID);
        this.mSlotID = aSlotID;
        return l2;
    }

    @Override
    public void closeSession(long aSessionID) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().closeSession(aSessionID);
    }

    @Override
    public void login(long aSessionID, String aCardPIN) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().login(aSessionID, aCardPIN);
    }

    @Override
    public void logout(long aSessionID) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().logout(aSessionID);
    }

    @Override
    public boolean isAnyObjectExist(long aSessionID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isAnyObjectExist(aSessionID);
    }

    @Override
    public void importCertificate(long aSessionID, String aCertLabel, X509Certificate aSertifika) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().importCertificate(aSessionID, aCertLabel, aSertifika);
    }

    @Override
    public long[] createKeyPair(long aSessionID, String aKeyLabel, AlgorithmParameterSpec aParamSpec, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().createKeyPair(aSessionID, aKeyLabel, aParamSpec, aIsSign, aIsEncrypt);
    }

    @Override
    public KeySpec createKeyPair(long aSessionID, KeyPairTemplate template) throws PKCS11Exception, SmartCardException, IOException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().createKeyPair(aSessionID, template);
    }

    @Override
    public byte[] generateRSAPrivateKey(long aSessionID, int keySize) throws ESYAException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().generateRSAPrivateKey(aSessionID, keySize);
    }

    @Override
    public KeyPair generateECKeyPair(long aSessionID, ECParameterSpec ecParameterSpec) throws ESYAException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().generateECKeyPair(aSessionID, ecParameterSpec);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] a(CK_MECHANISM cK_MECHANISM, byte[] byArray) throws SmartCardException {
        byte[] byArray2;
        int n2 = CardType.b;
        if (this.mApplication == Application.EPASSPORT) {
            return byArray;
        }
        if (this.mApplication != Application.ESIGNATURE) {
            throw new SmartCardException(SmartCard.a(30336, 30359));
        }
        if (!PKCS11AlgorithmUtil.isECMechanism(cK_MECHANISM.mechanism)) {
            return byArray;
        }
        if (this.mCardType == CardType.AKIS) {
            byArray2 = ECSignatureTLVUtil.addTLVToSignature(byArray);
            if (n2 == 0) return byArray2;
        }
        if (this.mCardType == CardType.UTIMACO) {
            byArray2 = byArray;
            if (n2 == 0) return byArray2;
        }
        if (this.mCardType == CardType.NCIPHER) {
            byArray2 = ECSignatureTLVUtil.addTLVToSignature(byArray);
            if (n2 == 0) return byArray2;
        }
        if (this.mCardType == CardType.DIRAKHSM) {
            byArray2 = ECSignatureTLVUtil.addTLVToSignature(byArray);
            if (n2 == 0) return byArray2;
        }
        if (ECSignatureTLVUtil.isSignatureInTLVFormat(byArray)) return byArray;
        byArray2 = ECSignatureTLVUtil.addTLVToSignature(byArray);
        if (n2 == 0) return byArray2;
        return byArray;
    }

    @Override
    @Deprecated
    public byte[] signDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, long aMechanism, byte[] aToBeSigned) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signDataWithCertSerialNo(aSessionID, aSerialNumber, cK_MECHANISM, aToBeSigned);
        byArray = this.a(cK_MECHANISM, byArray);
        return byArray;
    }

    @Override
    public byte[] signDataWithKeyID(long aSessionID, long aKeyID, CK_MECHANISM aMechanism, byte[] aToBeSigned) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signDataWithKeyID(aSessionID, aKeyID, aMechanism, aToBeSigned);
        byArray = this.a(aMechanism, byArray);
        return byArray;
    }

    @Override
    public byte[] signDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aToBeSigned) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signDataWithCertSerialNo(aSessionID, aSerialNumber, aMechanism, aToBeSigned);
        byArray = this.a(aMechanism, byArray);
        return byArray;
    }

    @Override
    @Deprecated
    public byte[] decryptDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, long aMechanism, byte[] aData) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        return this.mCardType.getCardTemplate().getPKCS11Ops().decryptDataWithCertSerialNo(aSessionID, aSerialNumber, cK_MECHANISM, aData);
    }

    @Override
    public byte[] decryptDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aData) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        return this.mCardType.getCardTemplate().getPKCS11Ops().decryptDataWithCertSerialNo(aSessionID, aSerialNumber, aMechanism, aData);
    }

    public long[] getAllObjectIds(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        cK_ATTRIBUTEArray[0].type = 1L;
        cK_ATTRIBUTEArray[0].pValue = true;
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        return lArray;
    }

    public P11Object[] getAllObjectInfos(long aSessionID) throws PKCS11Exception {
        long[] lArray = this.getAllObjectIds(aSessionID);
        P11Object[] p11ObjectArray = new P11Object[lArray.length];
        int n2 = CardType.b;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = P11Object.getAttributesToFilled();
            this.getAttributeValue(aSessionID, lArray[i2], cK_ATTRIBUTEArray);
            p11ObjectArray[i2] = new P11Object(lArray[i2], cK_ATTRIBUTEArray);
            if (n2 == 0) continue;
        }
        return p11ObjectArray;
    }

    @Override
    public List<byte[]> getCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        return this.mCardType.getCardTemplate().getPKCS11Ops().getCertificates(aSessionID);
    }

    @Override
    public List<byte[]> getSignatureCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getSignatureCertificates(aSessionID);
    }

    @Override
    public List<byte[]> getEncryptionCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getEncryptionCertificates(aSessionID);
    }

    @Override
    public String[] getSignatureKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getSignatureKeyLabels(aSessionID);
    }

    @Override
    public long getPrivateKeyObjIDFromCertificateSerial(long aSessionID, byte[] aCertSerialNo) throws SmartCardException, PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getPrivateKeyObjIDFromCertificateSerial(aSessionID, aCertSerialNo);
    }

    @Override
    public long getPrivateKeyObjIDFromPrivateKeyLabel(long aSessionID, String aLabel) throws SmartCardException, PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getObjIDFromPrivateKeyLabel(aSessionID, aLabel);
    }

    public long getSecretKeyObjIDFromSecretKeyLabel(long aSessionID, String aLabel) throws SmartCardException, PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getObjIDFromSecretKeyLabel(aSessionID, aLabel);
    }

    @Override
    public long getPublicKeyObjIDFromPublicKeyLabel(long aSessionID, String aLabel) throws SmartCardException, PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getObjIDFromPublicKeyLabel(aSessionID, aLabel);
    }

    @Override
    public String[] getEncryptionKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getEncryptionKeyLabels(aSessionID);
    }

    @Override
    public String[] getWrapperKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getWrapperKeyLabels(aSessionID);
    }

    @Override
    public String[] getUnwrapperKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getUnwrapperKeyLabels(aSessionID);
    }

    @Override
    public CK_ATTRIBUTE[] getAllAttributes(long sessionID, long objectID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getAllAttributes(sessionID, objectID);
    }

    @Override
    public Map<Long, String> getAttributeNames() {
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        Map<Long, String> map = PKCS11Names.getAttributeNames();
        hashMap.putAll(map);
        Map<Long, String> map2 = this.mCardType.getCardTemplate().getVendorSpecificAttributeTypesWithNames();
        hashMap.putAll(map2);
        return hashMap;
    }

    @Override
    public boolean isObjectExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isObjectExist(aSessionID, aLabel);
    }

    @Override
    public void writePrivateData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().writePrivateData(aSessionID, aLabel, aData);
    }

    @Override
    public void writePublicData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().writePublicData(aSessionID, aLabel, aData);
    }

    @Override
    public List<byte[]> readPrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readPrivateData(aSessionID, aLabel);
    }

    @Override
    public List<byte[]> readPublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readPublicData(aSessionID, aLabel);
    }

    @Override
    public boolean isPublicKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isPublicKeyExist(aSessionID, aLabel);
    }

    @Override
    public boolean isPrivateKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isPrivateKeyExist(aSessionID, aLabel);
    }

    @Override
    public boolean isCertificateExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isCertificateExist(aSessionID, aLabel);
    }

    @Override
    public List<byte[]> readCertificate(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readCertificate(aSessionID, aLabel);
    }

    @Override
    public byte[] readCertificate(long aSessionID, byte[] aCertSerialNo) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readCertificate(aSessionID, aCertSerialNo);
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readPublicKeySpec(aSessionID, aLabel);
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, byte[] aCertSerialNo) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readPublicKeySpec(aSessionID, aCertSerialNo);
    }

    @Override
    public void updatePrivateData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().updatePrivateData(aSessionID, aLabel, aValue);
    }

    @Override
    public void updatePublicData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().updatePublicData(aSessionID, aLabel, aValue);
    }

    @Override
    public void deletePrivateObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().deletePrivateObject(aSessionID, aLabel);
    }

    @Override
    public void deleteObject(long sessionId, long objectHandle) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().deleteObject(sessionId, objectHandle);
    }

    @Override
    public void deletePublicObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().deletePublicObject(aSessionID, aLabel);
    }

    @Override
    public void deletePrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().deletePrivateData(aSessionID, aLabel);
    }

    @Override
    public void deletePublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().deletePublicData(aSessionID, aLabel);
    }

    @Override
    public byte[] getRandomData(long aSessionID, int aDataLength) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getRandomData(aSessionID, aDataLength);
    }

    @Override
    public byte[] getTokenSerialNo(long aSlotID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getTokenSerialNo(aSlotID);
    }

    @Override
    @Deprecated
    public byte[] signData(long aSessionID, String aKeyLabel, byte[] aToBeSigned, long aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signData(aSessionID, aKeyLabel, aToBeSigned, cK_MECHANISM);
        byArray = this.a(cK_MECHANISM, byArray);
        return byArray;
    }

    @Override
    public byte[] signData(long aSessionID, String aKeyLabel, byte[] aToBeSigned, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signData(aSessionID, aKeyLabel, aToBeSigned, aMechanism);
        byArray = this.a(aMechanism, byArray);
        return byArray;
    }

    public byte[] signAndRecoverData(long aSessionID, String aKeyLabel, byte[] aToBeSigned, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signAndRecoverData(aSessionID, aKeyLabel, aToBeSigned, aMechanism);
        byArray = this.a(aMechanism, byArray);
        return byArray;
    }

    public byte[] verifyAndRecoverData(long aSessionID, String aKeyLabel, byte[] aSignedData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().verifyAndRecoverData(aSessionID, aKeyLabel, aSignedData, aMechanism);
        byArray = this.a(aMechanism, byArray);
        return byArray;
    }

    @Override
    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aSignature, long aMechanism) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        this.verifyData(aSessionID, aKeyLabel, aData, aSignature, cK_MECHANISM);
    }

    @Override
    public void verifyData(long aSessionID, long aKeyID, byte[] aData, byte[] aSignature, long aMechanism) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        this.verifyData(aSessionID, aKeyID, aData, aSignature, cK_MECHANISM);
    }

    @Override
    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aSignature, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.b(aMechanism, aSignature);
        this.mCardType.getCardTemplate().getPKCS11Ops().verifyData(aSessionID, aKeyLabel, aData, byArray, aMechanism);
    }

    @Override
    public void verifyData(long aSessionID, long aKeyID, byte[] aData, byte[] aSignature, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.b(aMechanism, aSignature);
        this.mCardType.getCardTemplate().getPKCS11Ops().verifyData(aSessionID, aKeyID, aData, byArray, aMechanism);
    }

    private byte[] b(CK_MECHANISM cK_MECHANISM, byte[] byArray) {
        if (PKCS11AlgorithmUtil.isECMechanism(cK_MECHANISM.mechanism)) {
            try {
                if (ECSignatureTLVUtil.isSignatureInTLVFormat(byArray)) {
                    return ECSignatureTLVUtil.removeTLVFromSignature(byArray);
                }
            }
            catch (Exception exception) {
                a.error(exception.toString(), exception);
                return byArray;
            }
        }
        return byArray;
    }

    @Override
    @Deprecated
    public byte[] encryptData(long aSessionID, String aKeyLabel, byte[] aData, long aMechanism) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        return this.mCardType.getCardTemplate().getPKCS11Ops().encryptData(aSessionID, aKeyLabel, aData, cK_MECHANISM);
    }

    @Override
    public byte[] encryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().encryptData(aSessionID, aKeyLabel, aData, aMechanism);
    }

    @Override
    public byte[] encryptData(long aSessionID, long aKeyID, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().encryptData(aSessionID, aKeyID, aData, aMechanism);
    }

    @Override
    public void encryptData(long aSessionID, long aKeyID, CK_MECHANISM aMechanism, InputStream inputStream, OutputStream outputStream) throws PKCS11Exception, SmartCardException, IOException {
        SmartCard.checkLicense();
        this.mCardType.getCardTemplate().getPKCS11Ops().encryptData(aSessionID, aKeyID, aMechanism, inputStream, outputStream);
    }

    @Override
    @Deprecated
    public byte[] decryptData(long aSessionID, String aKeyLabel, byte[] aData, long aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        return this.mCardType.getCardTemplate().getPKCS11Ops().decryptData(aSessionID, aKeyLabel, aData, cK_MECHANISM);
    }

    @Override
    public byte[] decryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        return this.mCardType.getCardTemplate().getPKCS11Ops().decryptData(aSessionID, aKeyLabel, aData, aMechanism);
    }

    @Override
    public byte[] decryptData(long aSessionID, long aKeyID, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        return this.mCardType.getCardTemplate().getPKCS11Ops().decryptData(aSessionID, aKeyID, aData, aMechanism);
    }

    @Override
    public void decryptData(long aSessionID, long aKeyID, CK_MECHANISM aMechanism, InputStream inputStream, OutputStream outputStream) throws PKCS11Exception, SmartCardException, IOException {
        SmartCard.checkLicense();
        this.mCardType.getCardTemplate().getPKCS11Ops().decryptData(aSessionID, aKeyID, aMechanism, inputStream, outputStream);
    }

    @Override
    public long[] importCertificateAndKey(long aSessionID, String aCertLabel, String aKeyLabel, PrivateKey aPrivKey, X509Certificate aCert) throws PKCS11Exception, SmartCardException, IOException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().importCertificateAndKey(aSessionID, aCertLabel, aKeyLabel, aPrivKey, aCert);
    }

    @Override
    @Deprecated
    public long[] importKeyPair(long aSessionID, String aLabel, KeyPair aKeyPair, byte[] aSubject, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().importKeyPair(aSessionID, aLabel, aKeyPair, aSubject, aIsSign, aIsEncrypt);
    }

    @Override
    public void changePassword(String aOldPass, String aNewPass, long aSessionID) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().changePassword(aOldPass, aNewPass, aSessionID);
    }

    @Override
    public void formatToken(String aSOpin, String aNewPIN, String aLabel, int slotID) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().formatToken(aSOpin, aNewPIN, aLabel, slotID);
    }

    @Override
    public void setSOPin(byte[] aSOPin, byte[] aNewSOPin, long aSessionHandle) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().setSOPin(aSOPin, aNewSOPin, aSessionHandle);
    }

    @Override
    public void changeUserPin(byte[] aSOPin, byte[] aUserPin, long aSessionHandle) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().changeUserPin(aSOPin, aUserPin, aSessionHandle);
    }

    @Override
    public boolean setContainer(byte[] aContainerLabel, long aSessionHandle) {
        return this.mCardType.getCardTemplate().getPKCS11Ops().setContainer(aContainerLabel, aSessionHandle);
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, X509Certificate aPbCertificate, int aSignOrEnc) {
        return this.mCardType.getCardTemplate().getPKCS11Ops().importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarLen, aScfname, aContextName, aPbCertificate, aSignOrEnc);
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, byte[] aPbCertificate, int aSignOrEnc) {
        return this.mCardType.getCardTemplate().getPKCS11Ops().importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarLen, aScfname, aContextName, aPbCertificate, aSignOrEnc);
    }

    @Override
    public long createSecretKey(long aSessionID, SecretKey aKey) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().createSecretKey(aSessionID, aKey);
    }

    @Override
    public long importSecretKey(long aSessionID, SecretKey aKey) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().importSecretKey(aSessionID, aKey);
    }

    public long importSecretKey(long aSessionID, SecretKeyTemplate aKeyTemplate) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().importSecretKey(aSessionID, aKeyTemplate);
    }

    private void a(long l2, List<String> list) throws PKCS11Exception, SmartCardException {
        this.deletePrivateObject(l2, list.get(0));
        this.deletePrivateObject(l2, list.get(1));
    }

    protected static CardType findCardType(String aATRHex, Application aApp) {
        return CardType.getCardTypeFromATR(aATRHex, aApp);
    }

    public long[] findObjects(long aSessionID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().objeAra(aSessionID, aTemplate);
    }

    @Override
    @Deprecated
    public long[] objeAra(long aSessionID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        return this.findObjects(aSessionID, aTemplate);
    }

    @Override
    public void getAttributeValue(long aSessionID, long aObjectID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().getAttributeValue(aSessionID, aObjectID, aTemplate);
    }

    @Override
    public void changeLabel(long aSessionID, String aOldLabel, String aNewLabel) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().changeLabel(aSessionID, aOldLabel, aNewLabel);
    }

    public static void checkLicense() {
        try {
            boolean bl = LV.getInstance().isTL(LV.Urunler.AKILLIKART);
            if (bl) {
                a.debug(SmartCard.a(30339, -2999));
                Thread.sleep(2000L);
            }
        }
        catch (LE lE) {
            throw new ESYARuntimeException(SmartCard.a(30337, 20365) + lE.getMessage(), lE);
        }
        catch (InterruptedException interruptedException) {
            throw new ESYARuntimeException(SmartCard.a(30344, 777), interruptedException);
        }
    }

    @Override
    public byte[] getModulusOfKey(long aSessionID, long aObjID) throws SmartCardException, PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getModulusOfKey(aSessionID, aObjID);
    }

    @Override
    public byte[] wrapKey(long sessionID, CK_MECHANISM mechanism, String wrapperKeyLabel, String labelOfKeyToWrap) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().wrapKey(sessionID, mechanism, wrapperKeyLabel, labelOfKeyToWrap);
    }

    @Override
    public byte[] wrapKey(long sessionID, CK_MECHANISM mechanism, long wrapperKeyID, long keyID) throws PKCS11Exception, SmartCardException {
        return ((PKCS11Ops)this.mCardType.getCardTemplate().getPKCS11Ops()).wrapKey(sessionID, mechanism, wrapperKeyID, keyID);
    }

    @Override
    public WrappedObjectsWithAttributes wrapObjectsWithAttributes(long aSessionID, CK_MECHANISM aMechanism, String wrapperKeyLabel, long[] objectIDs) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().wrapObjectsWithAttributes(aSessionID, aMechanism, wrapperKeyLabel, objectIDs);
    }

    @Override
    public byte[] wrapKey(long sessionID, CK_MECHANISM mechanism, KeyTemplate wrapperKeyTemplate, KeyTemplate wrappingKeyTemplate) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().wrapKey(sessionID, mechanism, wrapperKeyTemplate, wrappingKeyTemplate);
    }

    @Override
    public long unwrapKey(long sessionID, CK_MECHANISM mechanism, String unwrapperKeyLabel, byte[] wrappedKey, KeyTemplate unwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().unwrapKey(sessionID, mechanism, unwrapperKeyLabel, wrappedKey, unwrappedKeyTemplate);
    }

    @Override
    public long unwrapKey(long sid, CK_MECHANISM mechanism, long wrapperKeyID, byte[] wrappedKey, KeyTemplate unwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        return ((PKCS11Ops)this.mCardType.getCardTemplate().getPKCS11Ops()).unwrapKey(sid, mechanism, wrapperKeyID, wrappedKey, unwrappedKeyTemplate);
    }

    @Override
    public long unwrapKey(long sessionID, CK_MECHANISM mechanism, KeyTemplate unwrapperKeyTemplate, byte[] wrappedKey, KeyTemplate unwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().unwrapKey(sessionID, mechanism, unwrapperKeyTemplate, wrappedKey, unwrappedKeyTemplate);
    }

    @Override
    public long unwrapKey(long sessionID, CK_MECHANISM mechanism, byte[] certSerialNumber, byte[] wrappedKey, KeyTemplate unwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().unwrapKey(sessionID, mechanism, certSerialNumber, wrappedKey, unwrappedKeyTemplate);
    }

    @Override
    public UnwrapObjectsResults unwrapObjectsWithAttributes(long aSessionID, CK_MECHANISM aMechanism, String wrapperKeyLabel, byte[] wrappedBytes) throws PKCS11Exception, ESYAException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().unwrapObjectsWithAttributes(aSessionID, aMechanism, wrapperKeyLabel, wrappedBytes);
    }

    @Override
    public CardType getCardType() {
        return this.mCardType;
    }

    @Override
    public long[] importKeyPair(long sessionID, KeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().importKeyPair(sessionID, template);
    }

    @Override
    public long createSecretKey(long sessionID, SecretKeyTemplate template) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().createSecretKey(sessionID, template);
    }

    public int deleteCertificate(long aSessionID, String aKeyLabel) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().deleteCertificate(aSessionID, aKeyLabel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSupportsWrapUnwrap(long sessionId) {
        PKCS11Ops pKCS11Ops;
        boolean bl;
        block5: {
            bl = true;
            pKCS11Ops = (PKCS11Ops)this.getCardType().getCardTemplate().getPKCS11Ops();
            try {
                pKCS11Ops.getmPKCS11().C_WrapKey(sessionId, new CK_MECHANISM(1L), -1L, -1L);
            }
            catch (PKCS11Exception pKCS11Exception) {
                a.warn(SmartCard.a(30346, 8804), pKCS11Exception);
                if (pKCS11Exception.getErrorCode() != 84L) break block5;
                bl = false;
            }
        }
        if (!bl) return bl;
        try {
            pKCS11Ops.getmPKCS11().C_UnwrapKey(sessionId, new CK_MECHANISM(1L), -1L, SmartCard.a(30340, 11845).getBytes(), null);
            return bl;
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.warn(SmartCard.a(30342, 27948), pKCS11Exception);
            if (pKCS11Exception.getErrorCode() != 84L) return bl;
            return false;
        }
    }

    public byte[] unwrapAndOP(long sessionID, CK_MECHANISM unwrapMechanism, long unwrapperKeyID, byte[] wrappedKey, CK_ATTRIBUTE[] unwrapTemplate, DirakLibOps.CryptoOperation operation, CK_MECHANISM operationMechanism, byte[] operationData) throws SmartCardException, PKCS11Exception {
        return ((PKCS11Ops)this.mCardType.getCardTemplate().getPKCS11Ops()).unwrapAndOP(sessionID, unwrapMechanism, unwrapperKeyID, wrappedKey, unwrapTemplate, operation, operationMechanism, operationData);
    }

    public PKCS11 getPKCS11() {
        return ((PKCS11Ops)this.getCardType().getCardTemplate().getPKCS11Ops()).getmPKCS11();
    }

    @Override
    public PKCS11Ops getPKCS11Ops() {
        return (PKCS11Ops)this.getCardType().getCardTemplate().getPKCS11Ops();
    }

    @Override
    public long deriveKey(long sessionId, CK_MECHANISM derive_mechanism, long privateKeyHandle, KeyTemplate unwrappedKeyTemplate) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().deriveKey(sessionId, derive_mechanism, privateKeyHandle, unwrappedKeyTemplate);
    }

    public long deriveKeyWithDirak(long sessionId, CK_MECHANISM_STRUCTURE mech, long privateKeyHandle) throws SmartCardException {
        SmartCard.checkLicense();
        if (this.getCardType() != CardType.DIRAKHSM) {
            throw new SmartCardException(SmartCard.a(30343, -27836));
        }
        long l2 = DirakLibOps.DirakLibJNAConnector.dirakP11lib.C_DeriveKey(sessionId, mech, privateKeyHandle, null, null, null);
        mech.read();
        return l2;
    }

    public byte[] signDataWithDIRAK(long sessionID, long privKeyID, CK_MECHANISM_STRUCTURE mechanism, byte[] aToBeSigned) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        if (this.getCardType() != CardType.DIRAKHSM) {
            throw new SmartCardException(SmartCard.a(30341, 14247));
        }
        int n2 = DirakLibOps.DirakLibJNAConnector.dirakP11lib.C_SignInit(sessionID, mechanism, privKeyID);
        if ((long)n2 != 0L) {
            throw new PKCS11Exception((long)n2);
        }
        return this.getPKCS11().C_Sign(sessionID, aToBeSigned);
    }

    public void verifyDataWithDIRAK(long aSessionID, long aKeyID, byte[] aData, byte[] aSignature, CK_MECHANISM_STRUCTURE aMechanism) throws PKCS11Exception, SmartCardException {
        if (this.getCardType() != CardType.DIRAKHSM) {
            throw new SmartCardException(SmartCard.a(30343, -27836));
        }
        byte[] byArray = this.b(new CK_MECHANISM(aMechanism.mechanism.longValue()), aSignature);
        int n2 = DirakLibOps.DirakLibJNAConnector.dirakP11lib.C_VerifyInit(aSessionID, aMechanism, aKeyID);
        if ((long)n2 != 0L) {
            throw new PKCS11Exception((long)n2);
        }
        this.getPKCS11().C_Verify(aSessionID, aData, byArray);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[12];
                var3_1 = 0;
                var2_2 = "K\u00ab\u00ae\u00c4\u0018\u00ba\u0013\u00c1\u000f!\u0083K\u00f9\u00aa(\u00b2\u00cd\u0087Z\u00c0\u00b7\u00dc\u009f\u00c7\u0000,\t\"\u00d4\u00cb\u007f 8\u00ccx\u00c0\u00cb=\u00f4\u000b\u0095pwS\u00bbk\u00e3\u00d3*\u00d1\u00bb\u00e9\u008b\u00eb\u00e5\u000b\u00a6\f}\u00faL\u00f79g\u00fa0v\u0085Dn\u00fa\u00ce]s\u0187CT@\u00e3\u0105\u0082e\u019c\u00fe\u000f\u00bc\u00e4:>\u00c8\u012f\u00d1\u0012\u00c7s\u00e3\u00e1O\u008e\u00eff\u00a1\u00dci\u00e0m^\u00f5<\u00e0+\u00ca\u018cS:\u00d29j\u00d0\u00ce\u0003c\u0096{7\u00b2$\u00ed\u00ca\u00c2W\u0086\u00b4\u00d3\u00b0\u0083\u00e6\u001bC\u009a\u00c3u\u0088~\\1\u00c0\u0011e@K\u008a\u0013.\tY\u0099O\t\u0015\u00b5\u00eb6N\u00dd\u00bf'7\u0016\u00ba0^\u00fa34\u001b\\\u0089\u00b9\u0097\u0004:\u0017\u00bf\u00cb7g\u0010WL\u0095\u0087l\u00ae\u008e\u00f3(\u008enN4b\u00a0\u00bc\u00c4\u00daf\u0010\u00fb\u007f\u001d\b!{[\u0004\u00f78\u009a=\u00af3\u00bc\u00e6\u00a4\u00c7\u00e2d\u009c~\u00cf=\u00f0[\u00e6\u0000\u00a1\u00da\u00dei}\u0014\u00b9K\u0089\u00de\u00da\n\u00eb\"\u00b9\u007f\u00c7\u00a1\u00ad\u00ff\u00e7\u00e0\u00f2\u0013\u00b9W\u001bS\u0011\u00ad\u0093xP\u001f\u009c\u008e\u008a\u00b3>\u00ff\u0004\u00e8g\u00d5=Y\u0097\u00d76\u0093\u009a\u0081\u00879*\u00e5\u00c9{\u0088\u00a23D\u00f0\u00e5\u0007\u00de\u008fR2]\u00a1r\u00ed\u009f\u0084/T\u00b0\u00db@\r0x\u00d6\u00ef#\u00d2\u0093\n\u001a\u00be-\u0082\u00be\u00ce\u0001\u008c";
                var4_3 = "K\u00ab\u00ae\u00c4\u0018\u00ba\u0013\u00c1\u000f!\u0083K\u00f9\u00aa(\u00b2\u00cd\u0087Z\u00c0\u00b7\u00dc\u009f\u00c7\u0000,\t\"\u00d4\u00cb\u007f 8\u00ccx\u00c0\u00cb=\u00f4\u000b\u0095pwS\u00bbk\u00e3\u00d3*\u00d1\u00bb\u00e9\u008b\u00eb\u00e5\u000b\u00a6\f}\u00faL\u00f79g\u00fa0v\u0085Dn\u00fa\u00ce]s\u0187CT@\u00e3\u0105\u0082e\u019c\u00fe\u000f\u00bc\u00e4:>\u00c8\u012f\u00d1\u0012\u00c7s\u00e3\u00e1O\u008e\u00eff\u00a1\u00dci\u00e0m^\u00f5<\u00e0+\u00ca\u018cS:\u00d29j\u00d0\u00ce\u0003c\u0096{7\u00b2$\u00ed\u00ca\u00c2W\u0086\u00b4\u00d3\u00b0\u0083\u00e6\u001bC\u009a\u00c3u\u0088~\\1\u00c0\u0011e@K\u008a\u0013.\tY\u0099O\t\u0015\u00b5\u00eb6N\u00dd\u00bf'7\u0016\u00ba0^\u00fa34\u001b\\\u0089\u00b9\u0097\u0004:\u0017\u00bf\u00cb7g\u0010WL\u0095\u0087l\u00ae\u008e\u00f3(\u008enN4b\u00a0\u00bc\u00c4\u00daf\u0010\u00fb\u007f\u001d\b!{[\u0004\u00f78\u009a=\u00af3\u00bc\u00e6\u00a4\u00c7\u00e2d\u009c~\u00cf=\u00f0[\u00e6\u0000\u00a1\u00da\u00dei}\u0014\u00b9K\u0089\u00de\u00da\n\u00eb\"\u00b9\u007f\u00c7\u00a1\u00ad\u00ff\u00e7\u00e0\u00f2\u0013\u00b9W\u001bS\u0011\u00ad\u0093xP\u001f\u009c\u008e\u008a\u00b3>\u00ff\u0004\u00e8g\u00d5=Y\u0097\u00d76\u0093\u009a\u0081\u00879*\u00e5\u00c9{\u0088\u00a23D\u00f0\u00e5\u0007\u00de\u008fR2]\u00a1r\u00ed\u009f\u0084/T\u00b0\u00db@\r0x\u00d6\u00ef#\u00d2\u0093\n\u001a\u00be-\u0082\u00be\u00ce\u0001\u008c".length();
                var1_4 = 27;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00ec\u0005\u00b5\u001d`.1\u0016DZ\u0014\u00aa\u00d9\u00eb\u008c\u0096@bk\u0088V\u00e1\u0084i[\u007ft\u00e1\u0081\u00db\u0005";
                    var4_3 = "\u00ec\u0005\u00b5\u001d`.1\u0016DZ\u0014\u00aa\u00d9\u00eb\u008c\u0096@bk\u0088V\u00e1\u0084i[\u007ft\u00e1\u0081\u00db\u0005".length();
                    var1_4 = 10;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 35;
                            break;
                        }
                        case 1: {
                            v13 = 36;
                            break;
                        }
                        case 2: {
                            v13 = 21;
                            break;
                        }
                        case 3: {
                            v13 = 16;
                            break;
                        }
                        case 4: {
                            v13 = 28;
                            break;
                        }
                        case 5: {
                            v13 = 30;
                            break;
                        }
                        default: {
                            v13 = 16;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        SmartCard.b = var5;
        SmartCard.c = new String[12];
        SmartCard.a = LoggerFactory.getLogger(SmartCard.class);
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0x7681) & 0xFFFF;
        if (c[n4] == null) {
            int n5;
            int n6;
            char[] cArray = b[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 96;
                    break;
                }
                case 1: {
                    n6 = 241;
                    break;
                }
                case 2: {
                    n6 = 61;
                    break;
                }
                case 3: {
                    n6 = 240;
                    break;
                }
                case 4: {
                    n6 = 225;
                    break;
                }
                case 5: {
                    n6 = 32;
                    break;
                }
                case 6: {
                    n6 = 110;
                    break;
                }
                case 7: {
                    n6 = 55;
                    break;
                }
                case 8: {
                    n6 = 221;
                    break;
                }
                case 9: {
                    n6 = 168;
                    break;
                }
                case 10: {
                    n6 = 207;
                    break;
                }
                case 11: {
                    n6 = 138;
                    break;
                }
                case 12: {
                    n6 = 165;
                    break;
                }
                case 13: {
                    n6 = 81;
                    break;
                }
                case 14: {
                    n6 = 215;
                    break;
                }
                case 15: {
                    n6 = 38;
                    break;
                }
                case 16: {
                    n6 = 166;
                    break;
                }
                case 17: {
                    n6 = 150;
                    break;
                }
                case 18: {
                    n6 = 68;
                    break;
                }
                case 19: {
                    n6 = 73;
                    break;
                }
                case 20: {
                    n6 = 249;
                    break;
                }
                case 21: {
                    n6 = 235;
                    break;
                }
                case 22: {
                    n6 = 113;
                    break;
                }
                case 23: {
                    n6 = 24;
                    break;
                }
                case 24: {
                    n6 = 12;
                    break;
                }
                case 25: {
                    n6 = 216;
                    break;
                }
                case 26: {
                    n6 = 136;
                    break;
                }
                case 27: {
                    n6 = 116;
                    break;
                }
                case 28: {
                    n6 = 124;
                    break;
                }
                case 29: {
                    n6 = 191;
                    break;
                }
                case 30: {
                    n6 = 115;
                    break;
                }
                case 31: {
                    n6 = 205;
                    break;
                }
                case 32: {
                    n6 = 119;
                    break;
                }
                case 33: {
                    n6 = 143;
                    break;
                }
                case 34: {
                    n6 = 111;
                    break;
                }
                case 35: {
                    n6 = 99;
                    break;
                }
                case 36: {
                    n6 = 39;
                    break;
                }
                case 37: {
                    n6 = 49;
                    break;
                }
                case 38: {
                    n6 = 169;
                    break;
                }
                case 39: {
                    n6 = 155;
                    break;
                }
                case 40: {
                    n6 = 144;
                    break;
                }
                case 41: {
                    n6 = 43;
                    break;
                }
                case 42: {
                    n6 = 48;
                    break;
                }
                case 43: {
                    n6 = 160;
                    break;
                }
                case 44: {
                    n6 = 42;
                    break;
                }
                case 45: {
                    n6 = 139;
                    break;
                }
                case 46: {
                    n6 = 171;
                    break;
                }
                case 47: {
                    n6 = 80;
                    break;
                }
                case 48: {
                    n6 = 211;
                    break;
                }
                case 49: {
                    n6 = 78;
                    break;
                }
                case 50: {
                    n6 = 101;
                    break;
                }
                case 51: {
                    n6 = 65;
                    break;
                }
                case 52: {
                    n6 = 251;
                    break;
                }
                case 53: {
                    n6 = 35;
                    break;
                }
                case 54: {
                    n6 = 156;
                    break;
                }
                case 55: {
                    n6 = 41;
                    break;
                }
                case 56: {
                    n6 = 100;
                    break;
                }
                case 57: {
                    n6 = 56;
                    break;
                }
                case 58: {
                    n6 = 174;
                    break;
                }
                case 59: {
                    n6 = 202;
                    break;
                }
                case 60: {
                    n6 = 0;
                    break;
                }
                case 61: {
                    n6 = 18;
                    break;
                }
                case 62: {
                    n6 = 253;
                    break;
                }
                case 63: {
                    n6 = 50;
                    break;
                }
                case 64: {
                    n6 = 193;
                    break;
                }
                case 65: {
                    n6 = 19;
                    break;
                }
                case 66: {
                    n6 = 8;
                    break;
                }
                case 67: {
                    n6 = 85;
                    break;
                }
                case 68: {
                    n6 = 57;
                    break;
                }
                case 69: {
                    n6 = 51;
                    break;
                }
                case 70: {
                    n6 = 94;
                    break;
                }
                case 71: {
                    n6 = 141;
                    break;
                }
                case 72: {
                    n6 = 200;
                    break;
                }
                case 73: {
                    n6 = 163;
                    break;
                }
                case 74: {
                    n6 = 239;
                    break;
                }
                case 75: {
                    n6 = 164;
                    break;
                }
                case 76: {
                    n6 = 135;
                    break;
                }
                case 77: {
                    n6 = 29;
                    break;
                }
                case 78: {
                    n6 = 66;
                    break;
                }
                case 79: {
                    n6 = 198;
                    break;
                }
                case 80: {
                    n6 = 46;
                    break;
                }
                case 81: {
                    n6 = 195;
                    break;
                }
                case 82: {
                    n6 = 243;
                    break;
                }
                case 83: {
                    n6 = 140;
                    break;
                }
                case 84: {
                    n6 = 82;
                    break;
                }
                case 85: {
                    n6 = 254;
                    break;
                }
                case 86: {
                    n6 = 230;
                    break;
                }
                case 87: {
                    n6 = 246;
                    break;
                }
                case 88: {
                    n6 = 10;
                    break;
                }
                case 89: {
                    n6 = 30;
                    break;
                }
                case 90: {
                    n6 = 54;
                    break;
                }
                case 91: {
                    n6 = 1;
                    break;
                }
                case 92: {
                    n6 = 212;
                    break;
                }
                case 93: {
                    n6 = 6;
                    break;
                }
                case 94: {
                    n6 = 112;
                    break;
                }
                case 95: {
                    n6 = 13;
                    break;
                }
                case 96: {
                    n6 = 53;
                    break;
                }
                case 97: {
                    n6 = 123;
                    break;
                }
                case 98: {
                    n6 = 131;
                    break;
                }
                case 99: {
                    n6 = 252;
                    break;
                }
                case 100: {
                    n6 = 222;
                    break;
                }
                case 101: {
                    n6 = 177;
                    break;
                }
                case 102: {
                    n6 = 120;
                    break;
                }
                case 103: {
                    n6 = 64;
                    break;
                }
                case 104: {
                    n6 = 105;
                    break;
                }
                case 105: {
                    n6 = 108;
                    break;
                }
                case 106: {
                    n6 = 227;
                    break;
                }
                case 107: {
                    n6 = 76;
                    break;
                }
                case 108: {
                    n6 = 44;
                    break;
                }
                case 109: {
                    n6 = 184;
                    break;
                }
                case 110: {
                    n6 = 189;
                    break;
                }
                case 111: {
                    n6 = 218;
                    break;
                }
                case 112: {
                    n6 = 153;
                    break;
                }
                case 113: {
                    n6 = 103;
                    break;
                }
                case 114: {
                    n6 = 179;
                    break;
                }
                case 115: {
                    n6 = 159;
                    break;
                }
                case 116: {
                    n6 = 157;
                    break;
                }
                case 117: {
                    n6 = 34;
                    break;
                }
                case 118: {
                    n6 = 129;
                    break;
                }
                case 119: {
                    n6 = 121;
                    break;
                }
                case 120: {
                    n6 = 172;
                    break;
                }
                case 121: {
                    n6 = 158;
                    break;
                }
                case 122: {
                    n6 = 151;
                    break;
                }
                case 123: {
                    n6 = 83;
                    break;
                }
                case 124: {
                    n6 = 52;
                    break;
                }
                case 125: {
                    n6 = 20;
                    break;
                }
                case 126: {
                    n6 = 161;
                    break;
                }
                case 127: {
                    n6 = 130;
                    break;
                }
                case 128: {
                    n6 = 197;
                    break;
                }
                case 129: {
                    n6 = 2;
                    break;
                }
                case 130: {
                    n6 = 204;
                    break;
                }
                case 131: {
                    n6 = 145;
                    break;
                }
                case 132: {
                    n6 = 181;
                    break;
                }
                case 133: {
                    n6 = 206;
                    break;
                }
                case 134: {
                    n6 = 97;
                    break;
                }
                case 135: {
                    n6 = 5;
                    break;
                }
                case 136: {
                    n6 = 125;
                    break;
                }
                case 137: {
                    n6 = 134;
                    break;
                }
                case 138: {
                    n6 = 28;
                    break;
                }
                case 139: {
                    n6 = 132;
                    break;
                }
                case 140: {
                    n6 = 208;
                    break;
                }
                case 141: {
                    n6 = 75;
                    break;
                }
                case 142: {
                    n6 = 117;
                    break;
                }
                case 143: {
                    n6 = 102;
                    break;
                }
                case 144: {
                    n6 = 247;
                    break;
                }
                case 145: {
                    n6 = 201;
                    break;
                }
                case 146: {
                    n6 = 37;
                    break;
                }
                case 147: {
                    n6 = 25;
                    break;
                }
                case 148: {
                    n6 = 162;
                    break;
                }
                case 149: {
                    n6 = 203;
                    break;
                }
                case 150: {
                    n6 = 63;
                    break;
                }
                case 151: {
                    n6 = 217;
                    break;
                }
                case 152: {
                    n6 = 74;
                    break;
                }
                case 153: {
                    n6 = 196;
                    break;
                }
                case 154: {
                    n6 = 95;
                    break;
                }
                case 155: {
                    n6 = 170;
                    break;
                }
                case 156: {
                    n6 = 154;
                    break;
                }
                case 157: {
                    n6 = 188;
                    break;
                }
                case 158: {
                    n6 = 3;
                    break;
                }
                case 159: {
                    n6 = 231;
                    break;
                }
                case 160: {
                    n6 = 84;
                    break;
                }
                case 161: {
                    n6 = 122;
                    break;
                }
                case 162: {
                    n6 = 31;
                    break;
                }
                case 163: {
                    n6 = 244;
                    break;
                }
                case 164: {
                    n6 = 21;
                    break;
                }
                case 165: {
                    n6 = 17;
                    break;
                }
                case 166: {
                    n6 = 178;
                    break;
                }
                case 167: {
                    n6 = 87;
                    break;
                }
                case 168: {
                    n6 = 186;
                    break;
                }
                case 169: {
                    n6 = 147;
                    break;
                }
                case 170: {
                    n6 = 88;
                    break;
                }
                case 171: {
                    n6 = 142;
                    break;
                }
                case 172: {
                    n6 = 250;
                    break;
                }
                case 173: {
                    n6 = 185;
                    break;
                }
                case 174: {
                    n6 = 194;
                    break;
                }
                case 175: {
                    n6 = 107;
                    break;
                }
                case 176: {
                    n6 = 149;
                    break;
                }
                case 177: {
                    n6 = 33;
                    break;
                }
                case 178: {
                    n6 = 89;
                    break;
                }
                case 179: {
                    n6 = 26;
                    break;
                }
                case 180: {
                    n6 = 214;
                    break;
                }
                case 181: {
                    n6 = 176;
                    break;
                }
                case 182: {
                    n6 = 47;
                    break;
                }
                case 183: {
                    n6 = 11;
                    break;
                }
                case 184: {
                    n6 = 232;
                    break;
                }
                case 185: {
                    n6 = 183;
                    break;
                }
                case 186: {
                    n6 = 118;
                    break;
                }
                case 187: {
                    n6 = 173;
                    break;
                }
                case 188: {
                    n6 = 91;
                    break;
                }
                case 189: {
                    n6 = 133;
                    break;
                }
                case 190: {
                    n6 = 67;
                    break;
                }
                case 191: {
                    n6 = 59;
                    break;
                }
                case 192: {
                    n6 = 36;
                    break;
                }
                case 193: {
                    n6 = 86;
                    break;
                }
                case 194: {
                    n6 = 70;
                    break;
                }
                case 195: {
                    n6 = 234;
                    break;
                }
                case 196: {
                    n6 = 223;
                    break;
                }
                case 197: {
                    n6 = 16;
                    break;
                }
                case 198: {
                    n6 = 127;
                    break;
                }
                case 199: {
                    n6 = 226;
                    break;
                }
                case 200: {
                    n6 = 148;
                    break;
                }
                case 201: {
                    n6 = 238;
                    break;
                }
                case 202: {
                    n6 = 167;
                    break;
                }
                case 203: {
                    n6 = 175;
                    break;
                }
                case 204: {
                    n6 = 146;
                    break;
                }
                case 205: {
                    n6 = 224;
                    break;
                }
                case 206: {
                    n6 = 237;
                    break;
                }
                case 207: {
                    n6 = 229;
                    break;
                }
                case 208: {
                    n6 = 93;
                    break;
                }
                case 209: {
                    n6 = 69;
                    break;
                }
                case 210: {
                    n6 = 248;
                    break;
                }
                case 211: {
                    n6 = 190;
                    break;
                }
                case 212: {
                    n6 = 109;
                    break;
                }
                case 213: {
                    n6 = 15;
                    break;
                }
                case 214: {
                    n6 = 62;
                    break;
                }
                case 215: {
                    n6 = 213;
                    break;
                }
                case 216: {
                    n6 = 79;
                    break;
                }
                case 217: {
                    n6 = 187;
                    break;
                }
                case 218: {
                    n6 = 72;
                    break;
                }
                case 219: {
                    n6 = 92;
                    break;
                }
                case 220: {
                    n6 = 14;
                    break;
                }
                case 221: {
                    n6 = 4;
                    break;
                }
                case 222: {
                    n6 = 60;
                    break;
                }
                case 223: {
                    n6 = 219;
                    break;
                }
                case 224: {
                    n6 = 9;
                    break;
                }
                case 225: {
                    n6 = 114;
                    break;
                }
                case 226: {
                    n6 = 182;
                    break;
                }
                case 227: {
                    n6 = 106;
                    break;
                }
                case 228: {
                    n6 = 220;
                    break;
                }
                case 229: {
                    n6 = 228;
                    break;
                }
                case 230: {
                    n6 = 233;
                    break;
                }
                case 231: {
                    n6 = 192;
                    break;
                }
                case 232: {
                    n6 = 236;
                    break;
                }
                case 233: {
                    n6 = 98;
                    break;
                }
                case 234: {
                    n6 = 27;
                    break;
                }
                case 235: {
                    n6 = 23;
                    break;
                }
                case 236: {
                    n6 = 128;
                    break;
                }
                case 237: {
                    n6 = 77;
                    break;
                }
                case 238: {
                    n6 = 71;
                    break;
                }
                case 239: {
                    n6 = 152;
                    break;
                }
                case 240: {
                    n6 = 137;
                    break;
                }
                case 241: {
                    n6 = 104;
                    break;
                }
                case 242: {
                    n6 = 45;
                    break;
                }
                case 243: {
                    n6 = 126;
                    break;
                }
                case 244: {
                    n6 = 180;
                    break;
                }
                case 245: {
                    n6 = 255;
                    break;
                }
                case 246: {
                    n6 = 90;
                    break;
                }
                case 247: {
                    n6 = 245;
                    break;
                }
                case 248: {
                    n6 = 242;
                    break;
                }
                case 249: {
                    n6 = 40;
                    break;
                }
                case 250: {
                    n6 = 210;
                    break;
                }
                case 251: {
                    n6 = 22;
                    break;
                }
                case 252: {
                    n6 = 58;
                    break;
                }
                case 253: {
                    n6 = 199;
                    break;
                }
                case 254: {
                    n6 = 7;
                    break;
                }
                default: {
                    n6 = 209;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            SmartCard.c[n4] = new String(cArray).intern();
        }
        return c[n4];
    }
}

