/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.MA3APIEnvironment;
import tr.gov.tubitak.uekae.esya.api.common.bundle.GenelDil;
import tr.gov.tubitak.uekae.esya.api.common.crypto.Algorithms;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.AsymmetricAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.SmartCardI18n;
import tr.gov.tubitak.uekae.esya.api.smartcard.keyfinder.ModulusFinderFromObjectID;
import tr.gov.tubitak.uekae.esya.api.smartcard.keyfinder.PublicKeyFinderWithLabel;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.Application;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.ISmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.KeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.EncryptionSchemeFactory;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.IEncryptionScheme;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.ISignatureScheme;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.P11SignParameters;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.SignatureSchemeFactory;

public class SmartOp {
    private long a;
    private CardType b;
    private String c;
    private static Logger d;
    private static final String[] e;
    private static final String[] f;

    public SmartOp(long aSlotID, CardType aCardType, String aPassword) {
        this();
        this.initialize(aSlotID, aCardType, aPassword);
    }

    public SmartOp() {
        try {
            LV.getInstance().checkLD(LV.Urunler.AKILLIKART);
        }
        catch (LE lE) {
            throw new RuntimeException(SmartOp.a(-12375, 13192) + lE.getMessage(), lE);
        }
    }

    public void initialize(long aSlotID, CardType aCardType, String aPassword) {
        this.a = aSlotID;
        this.b = aCardType;
        this.c = aPassword;
    }

    public static boolean _in(long aElement, long[] aList) {
        int n2 = CardType.b;
        if (aList == null) {
            return false;
        }
        for (int i2 = 0; i2 < aList.length; ++i2) {
            if (aList[i2] != aElement) continue;
            return true;
        }
        return false;
    }

    public static Pair<Long, CardType> findCardTypeAndSlot(Application aApp) throws SmartCardException {
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            int n2 = list.size();
            String string = "";
            CardTerminal cardTerminal = null;
            while (true) {
                if (n2 == 0) {
                    throw new SmartCardException(SmartOp.a(-12361, -18750));
                }
                if (n2 == 1) {
                    string = list.get(0).getName();
                    cardTerminal = list.get(0);
                    break;
                }
                int n3 = 0;
                n3 = SmartOp.a(list);
                if (n3 != -1) {
                    string = list.get(n3).getName();
                    cardTerminal = terminalFactory.terminals().getTerminal(string);
                    break;
                }
                list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
                n2 = list.size();
            }
            Card card = cardTerminal.connect("*");
            String string2 = SmartOp.a(card.getATR().getBytes());
            card.disconnect(false);
            CardType cardType = CardType.getCardTypeFromATR(string2, aApp);
            if (cardType == CardType.UNKNOWN) {
                return new Pair<Object, CardType>(null, cardType);
            }
            Long l2 = null;
            try {
                l2 = SmartOp.a(cardType, string);
            }
            catch (Exception exception) {
                d.warn(SmartOp.a(-12416, -22237), exception);
                l2 = null;
            }
            return new Pair<Long, CardType>(l2, cardType);
        }
        catch (SmartCardException smartCardException) {
            throw smartCardException;
        }
        catch (Exception exception) {
            throw new SmartCardException(SmartOp.a(-12353, 32110), exception);
        }
    }

    public static List<Pair<Long, CardType>> findCardTypesAndSlots(Application aApp) throws SmartCardException {
        int n2 = CardType.b;
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            int n3 = list.size();
            if (n3 == 0) {
                throw new SmartCardException(SmartOp.a(-12386, -32512));
            }
            ArrayList<Pair<Long, CardType>> arrayList = new ArrayList<Pair<Long, CardType>>();
            for (CardTerminal cardTerminal : list) {
                block11: {
                    CardType cardType;
                    String string;
                    block10: {
                        string = cardTerminal.getName();
                        Card card = cardTerminal.connect("*");
                        String string2 = SmartOp.a(card.getATR().getBytes());
                        card.disconnect(false);
                        cardType = SmartCard.findCardType(string2, aApp);
                        if (cardType != CardType.UNKNOWN) break block10;
                        arrayList.add(new Pair<Object, CardType>(null, cardType));
                        if (n2 == 0) break block11;
                    }
                    Long l2 = null;
                    try {
                        l2 = SmartOp.a(cardType, string);
                    }
                    catch (Exception exception) {
                        d.warn(SmartOp.a(-12416, -22237), exception);
                        l2 = null;
                    }
                    arrayList.add(new Pair<Long, CardType>(l2, cardType));
                }
                if (n2 == 0) continue;
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new SmartCardException(SmartOp.a(-12406, -8127), exception);
        }
    }

    public static Pair<Long, CardType> findCardTypeAndSlot() throws SmartCardException {
        return SmartOp.findCardTypeAndSlot(Application.ESIGNATURE);
    }

    public static List<Pair<Long, CardType>> findCardTypesAndSlots() throws SmartCardException {
        return SmartOp.findCardTypesAndSlots(Application.ESIGNATURE);
    }

    private static List<CardTerminal> a(TerminalFactory terminalFactory, CardTerminals.State state) throws CardException {
        return SmartOp.a(terminalFactory, state, true);
    }

    private static List<CardTerminal> a(TerminalFactory terminalFactory, CardTerminals.State state, boolean bl) throws CardException {
        ArrayList<CardTerminal> arrayList = new ArrayList();
        try {
            arrayList = terminalFactory.terminals().list(state);
        }
        catch (CardException cardException) {
            block11: {
                if (!bl || cardException.getCause() == null) break block11;
                if (!SmartOp.a(-12368, 18322).equals(cardException.getCause().getMessage())) break block11;
                SmartOp.a();
                return SmartOp.a(terminalFactory, state, false);
            }
            if (!cardException.getCause().getMessage().contains(SmartOp.a(-12383, -13248))) {
                throw cardException;
            }
        }
        return arrayList;
    }

    private static void a() {
        try {
            d.warn(SmartOp.a(-12360, 23323));
            Class<?> clazz = Class.forName(SmartOp.a(-12403, -10087));
            Field field = clazz.getDeclaredField(SmartOp.a(-12380, 21981));
            field.setAccessible(true);
            if (field.getLong(clazz) != 0L) {
                Class<?> clazz2 = Class.forName(SmartOp.a(-12370, -2415));
                Method method = clazz2.getDeclaredMethod(SmartOp.a(-12391, -16954), Integer.TYPE);
                method.setAccessible(true);
                Field field2 = clazz2.getDeclaredField(SmartOp.a(-12407, 2496));
                field2.setAccessible(true);
                long l2 = (Long)method.invoke(clazz2, field2.getInt(clazz2));
                field.setLong(clazz, l2);
                TerminalFactory terminalFactory = TerminalFactory.getDefault();
                CardTerminals cardTerminals = terminalFactory.terminals();
                Field field3 = clazz.getDeclaredField(SmartOp.a(-12364, 2581));
                field3.setAccessible(true);
                Class<?> clazz3 = Class.forName(SmartOp.a(-12374, 30858));
                Method method2 = clazz3.getDeclaredMethod(SmartOp.a(-12388, 27521), new Class[0]);
                method2.invoke(field3.get(cardTerminals), new Object[0]);
                Field field4 = clazz.getDeclaredField(SmartOp.a(-12365, -23959));
                field4.setAccessible(true);
                method2.invoke(field4.get(cardTerminals), new Object[0]);
                d.info(SmartOp.a(-12369, 17127));
            }
        }
        catch (Exception exception) {
            d.warn(SmartOp.a(-12372, -10864), exception);
        }
    }

    private static int a(List<CardTerminal> list) {
        int n2 = list.size();
        String[] stringArray = new String[n2];
        int n3 = CardType.b;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = list.get(i2).getName();
            if (n3 == 0) continue;
        }
        return SmartOp.secenekSor(null, null, stringArray, SmartOp.a(-12379, -11908), new String[]{SmartCardI18n.getMsg(E_KEYS.OK, null)});
    }

    private static long a(CardType cardType, String string) throws PKCS11Exception, IOException {
        SmartCard smartCard = new SmartCard(cardType);
        long[] lArray = smartCard.getTokenPresentSlotList();
        long l2 = 0L;
        int n2 = CardType.b;
        for (long l3 : lArray) {
            String string2 = new String(smartCard.getSlotInfo((long)l3).slotDescription).trim();
            if (!string.contains(string2)) continue;
            l2 = l3;
            if (n2 == 0) break;
            if (n2 == 0) continue;
            break;
        }
        return l2;
    }

    private static String a(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n2 = CardType.b;
        if (byArray == null) {
            return SmartOp.a(-12411, -25453);
        }
        if (byArray.length == 0) {
            return SmartOp.a(-12366, 15906);
        }
        byte[] byArray2 = new byte[byArray.length * 2];
        int n3 = 0;
        for (byte by : byArray) {
            byArray2[n3++] = (byte)cArray[(by & 0xF0) >> 4];
            byArray2[n3++] = (byte)cArray[by & 0xF];
            if (n2 == 0) continue;
            break;
        }
        return new String(byArray2);
    }

    public static String[] getCardTerminals() throws SmartCardException {
        int n2 = CardType.b;
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            String[] stringArray = new String[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                stringArray[i2] = list.get(i2).getName();
                if (n2 == 0) continue;
            }
            return stringArray;
        }
        catch (CardException cardException) {
            throw new SmartCardException(SmartOp.a(-12371, 23360), cardException);
        }
    }

    public static String[] getCardATRs() throws SmartCardException {
        String[] stringArray = null;
        int n2 = CardType.b;
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            stringArray = new String[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String string;
                CardTerminal cardTerminal = list.get(i2);
                Card card = cardTerminal.connect("*");
                stringArray[i2] = string = StringUtil.toHexString(card.getATR().getBytes());
                if (n2 == 0) continue;
                break;
            }
        }
        catch (CardException cardException) {
            throw new SmartCardException(SmartOp.a(-12363, 30455), cardException);
        }
        return stringArray;
    }

    public static Pair<Long, CardType> getSlotAndCardType(String terminal, Application aApp) throws SmartCardException {
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            CardTerminal cardTerminal = terminalFactory.terminals().getTerminal(terminal);
            Card card = cardTerminal.connect("*");
            String string = SmartOp.a(card.getATR().getBytes());
            card.disconnect(false);
            CardType cardType = CardType.getCardTypeFromATR(string, aApp);
            Long l2 = null;
            try {
                if (cardType != CardType.UNKNOWN) {
                    l2 = SmartOp.a(cardType, terminal);
                }
            }
            catch (Exception exception) {
                d.warn(SmartOp.a(-12416, -22237), exception);
                l2 = null;
            }
            Pair<Long, CardType> pair = new Pair<Long, CardType>(l2, cardType);
            return pair;
        }
        catch (Exception exception) {
            throw new SmartCardException(SmartOp.a(-12413, 25629), exception);
        }
    }

    public static Pair<Long, CardType> getSlotAndCardType(String terminal) throws SmartCardException {
        return SmartOp.getSlotAndCardType(terminal, Application.ESIGNATURE);
    }

    public String getCardSerialNumber() throws PKCS11Exception, IOException {
        SmartCard smartCard = new SmartCard(this.b);
        return new String(smartCard.getTokenInfo((long)this.a).serialNumber).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importCertificateAndKey(String aCertLabel, String aKeyLabel, PrivateKey aPrivKey, X509Certificate aCert) throws PKCS11Exception, IOException, SmartCardException {
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            smartCard.login(l2, this.c);
            smartCard.importCertificateAndKey(l2, aCertLabel, aKeyLabel, aPrivKey, aCert);
            smartCard.logout(l2);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        if (l2 == -1L) return;
        smartCard.closeSession(l2);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, byte[] aPbCertData, int aSignOrEnc) throws PKCS11Exception, IOException {
        boolean bl;
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            bl = smartCard.importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarLen, aScfname, aContextName, aPbCertData, aSignOrEnc);
            if (smartCard == null) return bl;
            if (l2 == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        smartCard.closeSession(l2);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importKeyPair(String aLabel, KeyPair aKeyPair, byte[] aSubject, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, IOException, SmartCardException {
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            smartCard.login(l2, this.c);
            smartCard.importKeyPair(l2, aLabel, aKeyPair, aSubject, aIsSign, aIsEncrypt);
            smartCard.logout(l2);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        if (l2 == -1L) return;
        smartCard.closeSession(l2);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> readCertificate(String aLabel) throws IOException, PKCS11Exception, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            list = smartCard.readCertificate(l2, aLabel);
            if (smartCard == null) return list;
            if (l2 == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        smartCard.closeSession(l2);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> getSignCertificates() throws PKCS11Exception, IOException, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            list = smartCard.getSignatureCertificates(l2);
            if (smartCard == null) return list;
            if (l2 == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        smartCard.closeSession(l2);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> getEncryptCertificates() throws IOException, PKCS11Exception, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            list = smartCard.getEncryptionCertificates(l2);
            if (smartCard == null) return list;
            if (l2 == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        smartCard.closeSession(l2);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importCertificate(String aCertLabel, X509Certificate aCert) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l2 = -1L;
        int n2 = CardType.b;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            smartCard.importCertificate(l2, aCertLabel, aCert);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (!pKCS11Exception.getMessage().equals(SmartOp.a(-12358, -9612))) throw pKCS11Exception;
            smartCard.login(l2, this.c);
            smartCard.importCertificate(l2, aCertLabel, aCert);
            smartCard.logout(l2);
            if (n2 == 0) return;
            throw pKCS11Exception;
        }
        finally {
            if (smartCard != null && l2 != -1L) {
                smartCard.closeSession(l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> readPrivateData(String aLabel) throws PKCS11Exception, IOException, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            smartCard.login(l2, this.c);
            List<byte[]> list2 = smartCard.readPrivateData(l2, aLabel);
            smartCard.logout(l2);
            list = list2;
            if (smartCard == null) return list;
            if (l2 == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        smartCard.closeSession(l2);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> readPublicData(String aLabel) throws PKCS11Exception, IOException, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            List<byte[]> list2;
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            list = list2 = smartCard.readPublicData(l2, aLabel);
            if (smartCard == null) return list;
            if (l2 == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        smartCard.closeSession(l2);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writePrivateData(String aLabel, byte[] aData) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            smartCard.login(l2, this.c);
            smartCard.writePrivateData(l2, aLabel, aData);
            smartCard.logout(l2);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        if (l2 == -1L) return;
        smartCard.closeSession(l2);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writePublicData(String aLabel, byte[] aData) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            smartCard.login(l2, this.c);
            smartCard.writePublicData(l2, aLabel, aData);
            smartCard.logout(l2);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.warn(SmartOp.a(-12414, 744), pKCS11Exception);
            if (!pKCS11Exception.getMessage().equals(SmartOp.a(-12415, -17930))) return;
            smartCard.login(l2, this.c);
            smartCard.writePublicData(l2, aLabel, aData);
            smartCard.logout(l2);
            return;
        }
        finally {
            if (smartCard != null && l2 != -1L) {
                smartCard.closeSession(l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deletePrivateData(String aLabel) throws IOException, PKCS11Exception, SmartCardException {
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            smartCard.login(l2, this.c);
            smartCard.deletePrivateData(l2, aLabel);
            smartCard.logout(l2);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        if (l2 == -1L) return;
        smartCard.closeSession(l2);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deletePublicData(String aLabel) throws IOException, PKCS11Exception, SmartCardException {
        SmartCard smartCard = null;
        long l2 = -1L;
        int n2 = CardType.b;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            smartCard.deletePublicData(l2, aLabel);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (!pKCS11Exception.getMessage().equals(SmartOp.a(-12358, -9612))) throw pKCS11Exception;
            smartCard.login(l2, this.c);
            smartCard.deletePublicData(l2, aLabel);
            smartCard.logout(l2);
            if (n2 == 0) return;
            throw pKCS11Exception;
        }
        finally {
            if (smartCard != null && l2 != -1L) {
                smartCard.closeSession(l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isObjectExist(String aLabel, boolean aIsPrivate) throws IOException, PKCS11Exception {
        boolean bl;
        SmartCard smartCard = null;
        long l2 = -1L;
        int n2 = CardType.b;
        try {
            boolean bl2;
            block9: {
                block8: {
                    smartCard = new SmartCard(this.b);
                    l2 = smartCard.openSession(this.a);
                    if (!aIsPrivate) break block8;
                    smartCard.login(l2, this.c);
                    bl2 = smartCard.isObjectExist(l2, aLabel);
                    smartCard.logout(l2);
                    if (n2 == 0) break block9;
                }
                bl2 = smartCard.isObjectExist(l2, aLabel);
            }
            bl = bl2;
            if (smartCard == null) return bl;
            if (l2 == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        smartCard.closeSession(l2);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCardEmpty() throws PKCS11Exception, IOException {
        boolean bl;
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            bl = smartCard.isAnyObjectExist(l2);
            if (smartCard == null) return bl;
            if (l2 == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        smartCard.closeSession(l2);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateKeyPair(String aKeyLabel, AlgorithmParameterSpec aParamSpec, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, IOException, SmartCardException {
        SmartCard smartCard = null;
        long l2 = -1L;
        int n2 = CardType.b;
        try {
            if (this.b == null) {
                throw new SmartCardException(SmartOp.a(-12354, -27356));
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            smartCard.login(l2, this.c);
            boolean bl = smartCard.isObjectExist(l2, aKeyLabel);
            if (bl) {
                throw new SmartCardException(aKeyLabel + SmartOp.a(-12404, 10761));
            }
            smartCard.createKeyPair(l2, aKeyLabel, aParamSpec, aIsSign, aIsEncrypt);
            smartCard.logout(l2);
        }
        finally {
            if (smartCard != null && l2 != -1L) {
                smartCard.closeSession(l2);
            }
        }
        if (n2 != 0) {
            int n3 = SmartCardException.b;
            SmartCardException.b = ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeySpec getPublicKeySpec(String aKeyLabel) throws PKCS11Exception, IOException, SmartCardException {
        KeySpec keySpec;
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            KeySpec keySpec2;
            if (this.b == null) {
                throw new SmartCardException(SmartOp.a(-12354, -27356));
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            keySpec = keySpec2 = smartCard.readPublicKeySpec(l2, aKeyLabel);
            if (smartCard == null) return keySpec;
            if (l2 == -1L) return keySpec;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        smartCard.closeSession(l2);
        return keySpec;
    }

    public byte[] sign(byte[] aCertSerialNo, byte[] aToBeSigned, String aSigningAlg) throws PKCS11Exception, IOException, SmartCardException {
        return this.sign(aCertSerialNo, aToBeSigned, aSigningAlg, null);
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, byte[] aCertSerialNo, byte[] aToBeSigned, String aSigningAlg) throws PKCS11Exception, SmartCardException {
        return SmartOp.sign(aSC, aSessionID, aSlotID, aCertSerialNo, aToBeSigned, aSigningAlg, null);
    }

    public byte[] sign(String aKeyLabel, byte[] aToBeSigned, String aSigningAlg) throws IOException, PKCS11Exception, SmartCardException {
        return this.sign(aKeyLabel, aToBeSigned, aSigningAlg, null);
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, String aKeyLabel, byte[] aToBeSigned, String aSigningAlg) throws PKCS11Exception, SmartCardException {
        return SmartOp.sign(aSC, aSessionID, aSlotID, aKeyLabel, aToBeSigned, aSigningAlg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sign(byte[] aCertSerialNo, byte[] aToBeSigned, String aSigningAlg, AlgorithmParameterSpec aParams) throws PKCS11Exception, IOException, SmartCardException {
        byte[] byArray;
        if (this.b == null) {
            throw new SmartCardException(SmartOp.a(-12354, -27356));
        }
        if (this.a == -1L) {
            this.a = SmartOp.findSlotNumber(this.b);
        }
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            smartCard.login(l2, this.c);
            byte[] byArray2 = SmartOp.sign((ISmartCard)smartCard, l2, this.a, aCertSerialNo, aToBeSigned, aSigningAlg, aParams);
            smartCard.logout(l2);
            byArray = byArray2;
            if (smartCard == null) return byArray;
            if (l2 == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        smartCard.closeSession(l2);
        return byArray;
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, byte[] aCertSerialNo, byte[] aImzalanacak, String aSigningAlg, AlgorithmParameterSpec aParamSpec) throws PKCS11Exception, SmartCardException {
        Long l2 = null;
        try {
            l2 = aSC.getPrivateKeyObjIDFromCertificateSerial(aSessionID, aCertSerialNo);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l2);
            long[] lArray = aSC.getMechanismList(aSlotID);
            ISignatureScheme iSignatureScheme = SignatureSchemeFactory.getSignatureScheme(true, aSigningAlg, aParamSpec, lArray, modulusFinderFromObjectID);
            P11SignParameters p11SignParameters = iSignatureScheme.getSignParameters(aImzalanacak);
            byte[] byArray = aSC.signDataWithKeyID(aSessionID, l2, p11SignParameters.getMech(), p11SignParameters.getSignatureInput());
            return byArray;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-12412, 12906), aSC.getCardType(), aSlotID, StringUtil.toHexString(aCertSerialNo), aSigningAlg), smartCardException);
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            block7: {
                d.debug(MessageFormat.format(SmartOp.a(-12355, -15000), aSC.getCardType(), aSlotID, StringUtil.toHexString(aCertSerialNo), aSigningAlg), pKCS11Exception);
                if (l2 == null || pKCS11Exception.getErrorCode() != 99L) break block7;
                SmartOp.checkKeyAndSigningAlgConsistency(aSC, aSessionID, aSigningAlg, l2);
            }
            throw pKCS11Exception;
        }
    }

    protected static void checkKeyAndSigningAlgConsistency(ISmartCard aSC, long aSessionID, String aSigningAlg, long objID) throws PKCS11Exception, SmartCardException {
        block8: {
            block9: {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(256L)};
                aSC.getAttributeValue(aSessionID, objID, cK_ATTRIBUTEArray);
                AsymmetricAlg asymmetricAlg = SignatureAlg.fromName(aSigningAlg).getAsymmetricAlg();
                if (asymmetricAlg.equals(AsymmetricAlg.RSA) && (Long)cK_ATTRIBUTEArray[0].pValue == 0L) break block8;
                if (!asymmetricAlg.equals(AsymmetricAlg.ECDSA)) break block9;
                if ((Long)cK_ATTRIBUTEArray[0].pValue == 3L) break block8;
            }
            throw new SmartCardException(GenelDil.mesaj(GenelDil.IMZA_ANAHTAR_ALGORITMA_UYUMSUZLUGU));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sign(String aAnahtarAdi, byte[] aImzalanacak, String aSigningAlg, AlgorithmParameterSpec aParams) throws IOException, PKCS11Exception, SmartCardException {
        byte[] byArray;
        SmartCard smartCard = null;
        long l2 = -1L;
        if (this.b == null) {
            throw new SmartCardException(SmartOp.a(-12354, -27356));
        }
        if (this.a == -1L) {
            this.a = SmartOp.findSlotNumber(this.b);
        }
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            smartCard.login(l2, this.c);
            byte[] byArray2 = SmartOp.sign((ISmartCard)smartCard, l2, this.a, aAnahtarAdi, aImzalanacak, aSigningAlg, aParams);
            smartCard.logout(l2);
            byArray = byArray2;
            if (smartCard == null) return byArray;
            if (l2 == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        smartCard.closeSession(l2);
        return byArray;
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, Long aKeyID, byte[] aImzalanacak, String aSigningAlg, AlgorithmParameterSpec aParamSpec) throws PKCS11Exception, SmartCardException {
        try {
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, aKeyID);
            long[] lArray = aSC.getMechanismList(aSlotID);
            ISignatureScheme iSignatureScheme = SignatureSchemeFactory.getSignatureScheme(true, aSigningAlg, aParamSpec, lArray, modulusFinderFromObjectID);
            P11SignParameters p11SignParameters = iSignatureScheme.getSignParameters(aImzalanacak);
            CK_MECHANISM cK_MECHANISM = p11SignParameters.getMech();
            byte[] byArray = aSC.signDataWithKeyID(aSessionID, aKeyID, cK_MECHANISM, p11SignParameters.getSignatureInput());
            return byArray;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-12401, -7854), aSC.getCardType(), aSlotID, aKeyID, aSigningAlg), smartCardException);
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            block7: {
                d.debug(MessageFormat.format(SmartOp.a(-12401, -7854), aSC.getCardType(), aSlotID, aKeyID, aSigningAlg), pKCS11Exception);
                if (aKeyID == null || pKCS11Exception.getErrorCode() != 99L) break block7;
                SmartOp.checkKeyAndSigningAlgConsistency(aSC, aSessionID, aSigningAlg, aKeyID);
            }
            throw pKCS11Exception;
        }
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, String aAnahtarAdi, byte[] aImzalanacak, String aSigningAlg, AlgorithmParameterSpec aParamSpec) throws PKCS11Exception, SmartCardException {
        Long l2 = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, aAnahtarAdi);
        return SmartOp.sign(aSC, aSessionID, aSlotID, l2, aImzalanacak, aSigningAlg, aParamSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verify(String aAnahtarAdi, byte[] aImzalanan, byte[] aDogrulanacak, String aSigningAlg) throws IOException, PKCS11Exception, SmartCardException {
        boolean bl;
        ISmartCard iSmartCard = null;
        long l2 = -1L;
        try {
            if (this.b == null) {
                throw new SmartCardException(SmartOp.a(-12359, -3133));
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            iSmartCard = new SmartCard(this.b);
            l2 = iSmartCard.openSession(this.a);
            iSmartCard.login(l2, this.c);
            boolean bl2 = SmartOp.verify(iSmartCard, l2, this.a, aAnahtarAdi, aImzalanan, aDogrulanacak, aSigningAlg);
            iSmartCard.logout(l2);
            bl = bl2;
            if (iSmartCard == null) return bl;
            if (l2 == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (iSmartCard == null) throw throwable;
            if (l2 == -1L) throw throwable;
            iSmartCard.closeSession(l2);
            throw throwable;
        }
        iSmartCard.closeSession(l2);
        return bl;
    }

    public static boolean verify(ISmartCard aSC, long aSessionID, long aSlotID, String aKeyLabel, byte[] aImzalanan, byte[] aDogrulanacak, String aSigningAlg) throws PKCS11Exception, SmartCardException {
        return SmartOp.verify(aSC, aSessionID, aSlotID, aKeyLabel, aImzalanan, aDogrulanacak, aSigningAlg, null);
    }

    public static boolean verify(ISmartCard aSC, long aSessionID, long aSlotID, String aKeyLabel, byte[] aImzalanan, byte[] aDogrulanacak, String aSigningAlg, AlgorithmParams aAlgParams) throws PKCS11Exception, SmartCardException {
        try {
            PublicKeyFinderWithLabel publicKeyFinderWithLabel = new PublicKeyFinderWithLabel(aSC, aSessionID, aKeyLabel);
            long[] lArray = aSC.getMechanismList(aSlotID);
            ISignatureScheme iSignatureScheme = SignatureSchemeFactory.getSignatureScheme(false, aSigningAlg, aAlgParams, lArray, publicKeyFinderWithLabel);
            P11SignParameters p11SignParameters = iSignatureScheme.getSignParameters(aImzalanan);
            CK_MECHANISM cK_MECHANISM = p11SignParameters.getMech();
            byte[] byArray = p11SignParameters.getSignatureInput();
            boolean bl = false;
            try {
                aSC.verifyData(aSessionID, aKeyLabel, byArray, aDogrulanacak, cK_MECHANISM);
                bl = true;
            }
            catch (PKCS11Exception pKCS11Exception) {
                d.error(SmartOp.a(-12377, 20274), pKCS11Exception);
            }
            return bl;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-12401, -7854), aSC.getCardType(), aSlotID, aKeyLabel, aSigningAlg), smartCardException);
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-12401, -7854), aSC.getCardType(), aSlotID, aKeyLabel, aSigningAlg), pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] encrypt(String aAnahtarAdi, byte[] aSifrelenecek, String aAlgoritma, AlgorithmParameterSpec aParametreler) throws IOException, PKCS11Exception, SmartCardException {
        byte[] byArray;
        ISmartCard iSmartCard = null;
        long l2 = -1L;
        try {
            if (this.b == null) {
                throw new SmartCardException(SmartOp.a(-12354, -27356));
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            iSmartCard = new SmartCard(this.b);
            l2 = iSmartCard.openSession(this.a);
            iSmartCard.login(l2, this.c);
            byte[] byArray2 = SmartOp.encrypt(iSmartCard, l2, aAnahtarAdi, aSifrelenecek, aAlgoritma, aParametreler);
            iSmartCard.logout(l2);
            byArray = byArray2;
            if (iSmartCard == null) return byArray;
            if (l2 == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (iSmartCard == null) throw throwable;
            if (l2 == -1L) throw throwable;
            iSmartCard.closeSession(l2);
            throw throwable;
        }
        iSmartCard.closeSession(l2);
        return byArray;
    }

    public static byte[] encrypt(ISmartCard aSC, long aSessionID, String aAnahtarAdi, byte[] aSifrelenecek, String aAlgoritma, AlgorithmParameterSpec aParametreler) throws PKCS11Exception, SmartCardException {
        try {
            long l2 = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, aAnahtarAdi);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l2);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(true, aAlgoritma, aParametreler, aSC, aSessionID, modulusFinderFromObjectID);
            byte[] byArray = aSC.encryptData(aSessionID, aAnahtarAdi, iEncryptionScheme.getResult(aSifrelenecek), iEncryptionScheme.getMechanism());
            return byArray;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-12405, -3360), aSC.getCardType(), aAnahtarAdi, aAlgoritma), smartCardException);
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-12384, 126), aSC.getCardType(), aAnahtarAdi, aAlgoritma), pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] decrypt(String aAnahtarAdi, byte[] aCozulecek, String aAlgoritma, AlgorithmParameterSpec aParam) throws PKCS11Exception, IOException, SmartCardException {
        byte[] byArray;
        if (this.b == null) {
            throw new SmartCardException(SmartOp.a(-12354, -27356));
        }
        if (this.a == -1L) {
            this.a = SmartOp.findSlotNumber(this.b);
        }
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            smartCard.login(l2, this.c);
            byte[] byArray2 = SmartOp.decrypt((ISmartCard)smartCard, l2, this.a, aAnahtarAdi, aCozulecek, aAlgoritma, aParam);
            smartCard.logout(l2);
            byArray = byArray2;
            if (smartCard == null) return byArray;
            if (l2 == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        smartCard.closeSession(l2);
        return byArray;
    }

    @Deprecated
    public byte[] decrypt(String aKeyLabel, byte[] aEncryptedData) throws PKCS11Exception, IOException, SmartCardException {
        return this.decrypt(aKeyLabel, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    @Deprecated
    public byte[] decrypt(byte[] aCertSerialNo, byte[] aEncryptedData) throws PKCS11Exception, IOException, SmartCardException {
        return this.decrypt(aCertSerialNo, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    @Deprecated
    public static byte[] decrypt(ISmartCard aSC, long aSessionID, byte[] aCertSerialNo, byte[] aEncryptedData) throws SmartCardException, PKCS11Exception {
        long l2 = aSC.getSessionInfo((long)aSessionID).slotID;
        return SmartOp.decrypt(aSC, aSessionID, l2, aCertSerialNo, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    @Deprecated
    public static byte[] decrypt(ISmartCard aSC, long aSessionID, String aKeyLabel, byte[] aEncryptedData) throws SmartCardException, PKCS11Exception {
        long l2 = aSC.getSessionInfo((long)aSessionID).slotID;
        return SmartOp.decrypt(aSC, aSessionID, l2, aKeyLabel, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] decrypt(byte[] aCertSerialNo, byte[] aCozulecek, String aAlgoritma, AlgorithmParameterSpec aParam) throws PKCS11Exception, IOException, SmartCardException {
        byte[] byArray;
        int n2;
        block11: {
            n2 = CardType.b;
            if (this.b == null) {
                throw new SmartCardException(SmartOp.a(-12354, -27356));
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            SmartCard smartCard = null;
            long l2 = -1L;
            try {
                smartCard = new SmartCard(this.b);
                l2 = smartCard.openSession(this.a);
                smartCard.login(l2, this.c);
                byte[] byArray2 = SmartOp.decrypt((ISmartCard)smartCard, l2, this.a, aCertSerialNo, aCozulecek, aAlgoritma, aParam);
                smartCard.logout(l2);
                byArray = byArray2;
                if (smartCard == null || l2 == -1L) break block11;
            }
            catch (Throwable throwable) {
                if (smartCard == null) throw throwable;
                if (l2 == -1L) throw throwable;
                smartCard.closeSession(l2);
                throw throwable;
            }
            smartCard.closeSession(l2);
        }
        if (SmartCardException.b == 0) return byArray;
        CardType.b = ++n2;
        return byArray;
    }

    public static byte[] decrypt(ISmartCard aSC, long aSessionID, long aSlot, byte[] aCertSerialNo, byte[] aCozulecek, String aAlgorithm, AlgorithmParameterSpec aParams) throws SmartCardException, PKCS11Exception {
        try {
            long l2 = aSC.getPrivateKeyObjIDFromCertificateSerial(aSessionID, aCertSerialNo);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l2);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            byte[] byArray = aSC.decryptDataWithCertSerialNo(aSessionID, aCertSerialNo, iEncryptionScheme.getMechanism(), aCozulecek);
            return iEncryptionScheme.getResult(byArray);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-12355, -15000), aSC.getCardType(), aSlot, StringUtil.toHexString(aCertSerialNo), aAlgorithm), smartCardException);
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-12355, -15000), aSC.getCardType(), aSlot, StringUtil.toHexString(aCertSerialNo), aAlgorithm), pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public static byte[] decrypt(ISmartCard aSC, long aSessionID, long aSlot, String aAnahtarAdi, byte[] aCozulecek, String aAlgorithm, AlgorithmParameterSpec aParams) throws SmartCardException, PKCS11Exception {
        try {
            long l2 = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, aAnahtarAdi);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l2);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            byte[] byArray = aSC.decryptData(aSessionID, aAnahtarAdi, aCozulecek, iEncryptionScheme.getMechanism());
            return iEncryptionScheme.getResult(byArray);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-12373, 14973), aSC.getCardType(), aSlot, aAnahtarAdi, aAlgorithm), smartCardException);
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-12401, -7854), aSC.getCardType(), aSlot, aAnahtarAdi, aAlgorithm), pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public static byte[] wrap(ISmartCard aSC, long aSessionID, long aSlot, String aAlgorithm, String wrapperKeyLabel, String labelOfKeyToWrap, AlgorithmParameterSpec aParams) throws PKCS11Exception, SmartCardException {
        try {
            long l2 = aSC.getPublicKeyObjIDFromPublicKeyLabel(aSessionID, wrapperKeyLabel);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l2);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            byte[] byArray = aSC.wrapKey(aSessionID, iEncryptionScheme.getMechanism(), wrapperKeyLabel, labelOfKeyToWrap);
            return iEncryptionScheme.getResult(byArray);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-12362, 16696), aSC.getCardType(), aSlot, wrapperKeyLabel, labelOfKeyToWrap, aAlgorithm), smartCardException);
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-12410, -19477), aSC.getCardType(), aSlot, wrapperKeyLabel, labelOfKeyToWrap, aAlgorithm), pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public static void unwrap(ISmartCard aSC, long aSessionID, long aSlot, String aAlgorithm, String unwrapperKeyLabel, byte[] wrappedKey, KeyTemplate unwrappedKeyTemplate, AlgorithmParameterSpec aParams) throws PKCS11Exception, SmartCardException {
        try {
            long l2 = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, unwrapperKeyLabel);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l2);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            aSC.unwrapKey(aSessionID, iEncryptionScheme.getMechanism(), unwrapperKeyLabel, wrappedKey, unwrappedKeyTemplate);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-12402, -13078), aSC.getCardType(), aSlot, unwrapperKeyLabel), smartCardException);
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-12367, 10877), aSC.getCardType(), aSlot, unwrapperKeyLabel), pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public long getSlot() {
        return this.a;
    }

    public CardType getCardType() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void formatToken(String aSOpin, String aNewPIN, String aLabel) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            smartCard.formatToken(aSOpin, aNewPIN, aLabel, (int)this.a);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        if (l2 == -1L) return;
        smartCard.closeSession(l2);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changePassword(String aOldPass, String aNewPass) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            smartCard.changePassword(aOldPass, aNewPass, l2);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        if (l2 == -1L) return;
        smartCard.closeSession(l2);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changePuk(byte[] aSOPin, byte[] aNewSOPin) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l2 = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l2 = smartCard.openSession(this.a);
            smartCard.setSOPin(aSOPin, aNewSOPin, l2);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l2 == -1L) throw throwable;
            smartCard.closeSession(l2);
            throw throwable;
        }
        if (l2 == -1L) return;
        smartCard.closeSession(l2);
        return;
    }

    public static long findSlotNumber(CardType aCardType) throws PKCS11Exception, IOException, SmartCardException {
        return SmartOp.findSlotNumber(aCardType, SmartOp.a(-12356, -20815));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long findSlotNumber(CardType aCardType, String message) throws PKCS11Exception, IOException, SmartCardException {
        int n2 = 1;
        int n3 = CardType.b;
        do {
            Object[] objectArray;
            JComboBox<String> jComboBox;
            SmartCard smartCard;
            long[] lArray;
            int n4;
            if ((n4 = (lArray = (smartCard = new SmartCard(aCardType)).getTokenPresentSlotList()).length) == 0) {
                throw new SmartCardException(SmartOp.a(-12392, 5260));
            }
            if (n4 == 1) {
                return lArray[0];
            }
            String[] stringArray = new String[n4];
            int n5 = lArray.length;
            for (int i2 = 0; i2 < n5; ++i2) {
                long l2 = lArray[i2];
                String string = "";
                try {
                    string = string + " " + new String(smartCard.getSlotInfo((long)l2).slotDescription).trim();
                }
                catch (Exception exception) {
                    d.warn(SmartOp.a(-12416, -22237), exception);
                }
                try {
                    string = string + " " + new String(smartCard.getTokenInfo((long)l2).label).trim().split("\u0000")[0];
                }
                catch (Exception exception) {
                    d.warn(SmartOp.a(-12416, -22237), exception);
                }
                stringArray[i2] = string;
                if (n3 == 0) continue;
            }
            if ((n2 = JOptionPane.showOptionDialog(null, jComboBox = new JComboBox<String>(stringArray), message, 2, -1, null, objectArray = new String[]{SmartOp.a(-12387, 30909), SmartOp.a(-12378, -29571), SmartOp.a(-12385, -26103)}, objectArray[0])) == 0) {
                return lArray[jComboBox.getSelectedIndex()];
            }
            if (n2 != 2) continue;
            throw new SmartCardException(SmartOp.a(-12381, 31003));
        } while (n2 == 1 && n3 == 0);
        throw new ESYARuntimeException(SmartOp.a(-12376, 21405) + n2);
    }

    public static int secenekSor(Component aParent, Icon aIcon, String[] aSecenekList, String aBaslik, String[] aOptions) {
        JComboBox<String> jComboBox = new JComboBox<String>(aSecenekList);
        int n2 = JOptionPane.showOptionDialog(aParent, jComboBox, aBaslik, 2, -1, null, aOptions, aOptions[0]);
        if (n2 == 1) {
            return -1;
        }
        return jComboBox.getSelectedIndex();
    }

    /*
     * Unable to fully structure code
     */
    static {
        block25: {
            block24: {
                block23: {
                    var5 = new String[54];
                    var3_1 = 0;
                    var2_2 = "\u00fdU6\u00e2\u000f:!)F\u00e8\u00b1\u00b4A,4\u00e30\u00c8\u00e8qa\u00d4\u0019\u0011\u00ebB\u00f4\u001c\u00e3\u008f\u00a4F\u0018\u0081\u00ceb=i\u00c1\u00fbI\u00cdy\u001e\u00ad\u0092\u000e\u00bc\u0081\u00c11t^!=\u00c2\u008e\u001dt\u00cb\u00ea\u0005e\u0003\u00d3\u000f.D\u0004]y\u008fz\u00a4\u00ea$\u00ea2!\u00bcX\u0007\u00e8\u00da\u0098S\u00a8,,\u00f9\u00c8\u000e\u009b\u0090\u00c8\u00baX\u00865\u00a0J1\u00dbU\u00d7\u00ec]\u0011\u00d2\u00f0\u009a\u0082\u009f\u00c5\u00f7\u00a5\u00b1\u00dc\u00a9\u00b6\u0088U5\u00b6\u00e2C\u009e\u00e1\b\u00fbP\u00eb\u000f\u00c7\u001c{\u00c7\u00ee\u00010J\u00cd\u0014*\u00be\u0010=\"\u001b\u0000\u00a4\u00a18\u00af\u0014w'\u008c\u009b\u00eeJe\u0018\u0088\u00eb\u00bf\u00b1B7&\u0011\u00a2\u0018\u00ba\u0081o\rZ5\r\u0003\u00dfue\u00cf\u0013\u0084G\u00f2Q@\u00fd\u00c1\u009d\u009d\u0080\u00f3_\u00e8\u00923\u00b3\u001d\u00f5\u008f)\u00bc4\n\u0007v\u0013\u00e7\u0003\u00bd|\u00e7x\u00fb\u00c9?\u0015\u009c\u00a2\u00f4]\u0086\u00bb\u00c3v\u00fd\u009e\u00fe\u0158$+\u000b\u009b%*\u0085\u0084\u00ef\u0017\u009b6\u0099]6+\u0010m)\u00bb\u009f\tF\u0084\u00be\u00ef\u00f9R\u0083\u00a7\u00c7\u000f\u0005\u0002d\u00b6\u00ca\u00ce\u00f6%`\u00fe3\u00073h\u0015\u0007y\u00e9F\u000f\u00ef\u0083]\u0010E\u0019 \u00f9\u00a2\u00b0\u0000\u008fM\u0016ir\u00b2v\u00f6m5\u00b2OtL\u00bd\u00c9\u00f8\u00aff\u00db-\u0000&,S\u00c8{\u0084\u00ee\u00a7.\u00cf\u00a6\u00e6\u0096\r\u00fb(\u00c1Qo\u01fb\u00d7e\u00fdj\u00ffa\u0084,\u00f5\u008a\u00e3\u0081\u0080\u00f1\u00d4\u0084\u00c4\u00a3\u00b7u\u0016\u001c\u000b\u00d1\u000e\u00ca\u00043\b^\u008b' \u00f8\u00d8Ga\u00ed\u00a5\u008a\u001b\u0004\u0080{\u00ec]5\u00c4\u00ae\u00d6\u0007\u00d9\u0003\u0080\u009ar\u00b0g\u001d\u00ea<\u00d0a\u001by/T\u00a8;\u00d7|u71\u008b;\th1\u0084\u00bf\u00a9c\u00b9\u00ccL\r\u00f8\tG+\u00a9y\u007f\u00b4\u00a3\u00f3m?Z\u00f8i\u00ba\u001e\u0017\u008ct\u00e8\u00a0\u00fco\u001c\u00c1\u0014u\u00933\u00f3Q\u008d\u0003\u00d0!\u0006t7\u0089 q(U\u0007\u00c6\u00b8\u00b6Q^\u00e8\u0083mY\t\u00c30\u00e7\u0087\u0089\u0003\n\u0001X'\u001a\"\n\u00bb\u00ff?\u0096\t\u00e8I\u0011&\u00cd\u008a\u0019\u00d1\u009f\u0095\u0013\u00c5\u00d5f6\u0092\u0096NL\u0011.\u001cN\u00af\u00bea\u00bb\u00abM\u0094\u00fbo\u00ae\u00dcZ\u0005\u00e8\u009a\u00ca\u009d%\u00f0\u00c1\u00b7\u00cf[Fn\u00b1\u0092\u00bf\u00eb^S.\u00caSaQ\u007f\u00e0\u008a\u00ea\u0010\u00db}&e\u00108M<x\u00b6\u0097@\u00a66A\u00b2D\u00df\u00ff\u0087F\\\u00ef\u00cbo\u00eb\u008c\u00d1\u008b\u008bn\u00dc\u0086\u001d\u0082\u00e9\u00991\u00b7\u0012\u0017\u00ea*\u0019\u00ccw\u00e4\u00e2D\u00b8\u00ec\u007f%Q\u00b9|\u00b0\u00dcz\u00cb:\u00e6\u00b7\u0089\u00f9\u00d4\u0081\u001f\u00be\u00a1f\u00ffb\u0001\u00d4\u00d3}\u00b2\u001d\u00c0m\u0084%\u00ba+\u00fa5wi[{j#5\u00cbP\u009fp\u00f8\u00adSB\u007f\u00e3E\u0011\u00dc\u0098\u00d5\u00b3:\u00ca\u00e8\u00b9j\u0080\u0093\u009c,\u00c3\u0099\u00e6\u00eb\u0016\u00ca\u000e75Cl\u00d35\u00e1\u00e7N\u00c7\u001dk\u008b\u00c6\u0087\u00bb\u00f3\u00e8\u00fa4\u0003`k\u00b8\t\u00f0\u00aa\u0081x\u008d\u008c\u0095\u008d\u00a5\u0018,\u00d9\u00d7\u00df\u00df\u009d-\u00c2\u0017\bE\u0083\u00f9\u00cb\u00d19l&\u00c1\u00bc\u0097a\u0014\u0005U\fz\u00a3\u00eaG\u001d\u00a75\u008d\u0088Pj\u0089a\u00a6a\u00c5\u00b19\u0001\u00d4\t\u00fb`c\\\u009b\u008c\u00b5\u00d1\u009aAESu\u00f5\u00ba\u00b2\u00d2W\u0007\u00ae\u0094\u00d4\u00c7\u00e0\u00d17-\\\u00d4n\u00eeny< \u00e2~\u00e7bve_v=AXls\u00ac\u00af\u00car?\u009a\r\u00c8\u00a4\u0099B;cv\u00d6\u001f\u00c0\u00a8_\u00a5\u001f\u0017\u00a7\u00a0\u00f9i\u009b\u0004u\u00ce\u008a\u008f\u00e8M[\u00ab\u00d3\u00f7\u0011G$\u00bagz\u009bB\u00a2\u0017\u00f1\u00e2Q\u00ac\u00ef\u00ffu\u00c79\u001e\u00c5\u0090\u00c4\u00ccn\u00c4d\u00f1\u0012\u009d\u00b5\u007f\u00814\u00a0\u00026\u00e5\u00f5\u00fc\u00f1\tG\u000f\t\u009a\u00a2\u007f\u00c3\u00a2i\u00c9\u00ac\u000ef\u00e8\u00ad\\\u00a9\u00db\u00c2|\u009e\u00cf\u00ff\u0082\u00eb7\u00d4\u00e4o\u00c7Y\u000b\n\u0089\u00e2]\u00ec\n7\u009f&&\u00fb\u00ba\u000b\u0083\u00b9\u00de\n4\u00b6\u00b0S\u0000 \u00cc\t\u0091\u0091\u00ad\u001f\b`%\u0010\u00b3\u0010\u000f\u00ff\u00aa\u00d6\u00b9\u00c7X\u00f1Vc'D\u008c\u00f4k\u00a5&\u00a5\u00b2\u00d0*\"\u00e6;\u00b33\u00d3\u00a7\u00af\r\u00d1\u00f4o;]\u00d0\u001dfY\u00b0\u00bb\u00f5M;\u00a1\u00dcp\u00c2+\u0014\u001d-UC\u00834\u00f3\u00ae\\p\u00b8NX_r\u00c5\u00af\u00c3vTY\u00c7:e\u00c6\u009b+Z\u0004\n\u009c\u0011d%J\u00e4e\u00e7\u00b8\u009b\u00beq\"u\u00f0]?CD\u00048!\u00ad\u00fau\u008a\u0091/@S\u00bdH\u0012:\u0002\b\u00d6x\u00f4\u00ee\u00e5^\u0090\\_\u009av\u00d2\u00f9\u00a9\u0016T\u0083\u0096 %\u0003b `\u007f\f\u0088\u0088\t\u00012!\u00c3t9\u0105\u00dc\u0080\u0014\u00ee\u00c6\u0084\u00f9Q`\u00adja\u00a7\u00b7\u00f1v\u00e8\u00c66\u00ce|?\u00a2\u0081\u00f0\u00f3\u00d4+\fP$\u00be\u00aa\t7n\u0001\u00f7'\u00cf\u00e3\u0085U\u00d4%f\u00c4k\u009c!\u00c9\u0004F\u001emwgl\u00ed-\u0092\u00a6\u0096\u00c6Q^\u00d3\u00f8\u00c7@\u00d3*\u00df\f\u00cd0=^&__\u00c8\u008a=8\u0010\u00e6w\u00b3\u001e\u00b3\u00a9\u00e8\u0011BN\"$\u00d1bS\u000e.\u00db7W\u0091~^H\u00f1\u00e8l\u00e0\\-\u0004;#]\u00b3e\n\u00ef$Ts'\u00d1\u00e1Cc\u00e1\u00d5\u0095\u0094W2|~\u00b4\u009c\\\u00f6}\u009f)\u008cx5\u008e\u00c3\u00f3\u00ddM\u00fb\u00e6\u00e9\u00a5\u0013U\u0019)\u000f\u00b2\u00acG\bi6\u00de\u00fd\u00b8\u00a0U\u00c5\u00831\u00cer\u008e\u019f\u00eb\u00e9z\u00fb\u000fS\u009aj6B\u009b\u0098\u008f\u00d25\u00e0\u00f8/0\u00e4\u00e6?\u00c1\u00c6\u001a}p\u00efAkQC\u00cb\u0013\u00faN\u00c8\u0084\b\r\u0080\u0096\u00e3\u00fb\u001d>\u00bf\u0097\u0000\u00f5\u00c6\u00fe\u00f4\u00a4\u009c\u00f8\u00cbq?\u00a6%\u009c\u00d4\u00ba>\u00bf\u00d6h[x\u00984r\u009fI\u00e2\u00ef\u0015\u0002\u001c\b\u00ea\u00efg\u0095\u0004\u001a^\u009b\u00f5U1\u0096\u0004w\u00b3\u00ae9C^F*\u00b3\u00c6ZO\u0006\u00f8]\u009e\u009c \u00bae\u0016\u00b0\u0092\u00e1U\u00fa\u00eas&x\u00bf\u00d2hN\u0001L!\u00d4`\u00ee\r\u0088\u00db8P\u0010\u00b0s\u00f3\u001a\u00dd\u00e7J\u00f3,\u0004>-M\u008c8K\u00d1\u00e6\u00c5\u0098\u00c02\u00d9\u0019\u00bcECB\u00f3M\u00fe\u007f\u00d7\u00c4\u00eb\" /x\u0081s\b\u00cd~\u00d6\u009b\u007f\u00b2:\u00afc\u00a09\u00b1\u0097\u0081DLr\u00f5\u00de]\u00dd\u00049eA\u00f5\u0095\u0012\b\u00f6\u00d9t\u0086n\u00f2\u009d\u0095\u00ee_\u00c5\u008f\u00e1\u0090,v\u0086\u0016\u00fe\u00fd\u00b1K\u0093\u00a3\u00c9\u00cc\u00a2\u00d8& \u0010\u0097*Y\u00b3Hu\u0096*\u00fb\u0012\u001fQ;\u0080\u00da\u00f0yN\u00e4\u0094q\u008aJ\b(\u0011a!\u0017N\u00c3\u009b\u009cV\u00f5\u001c\u00cf1\u00a9\u0081\u00b7aM\u00c2\u00e9\u000e<\u008d\u00ff\u001e\t%\u0005tG\u00f3\u00e1-\u0002\u0096\t\u001fT\u00ab\u00cd\u00c5M\u001b\u00ed!\u00b0Y\u00b2\u0002P\u000e.\u0097|N\u00c9\u00cb\u0081\u00fb[\u00c6m\u008aN|\u00be\u0082\u0006\u0006\u0099|a(\u0002K";
                    var4_3 = "\u00fdU6\u00e2\u000f:!)F\u00e8\u00b1\u00b4A,4\u00e30\u00c8\u00e8qa\u00d4\u0019\u0011\u00ebB\u00f4\u001c\u00e3\u008f\u00a4F\u0018\u0081\u00ceb=i\u00c1\u00fbI\u00cdy\u001e\u00ad\u0092\u000e\u00bc\u0081\u00c11t^!=\u00c2\u008e\u001dt\u00cb\u00ea\u0005e\u0003\u00d3\u000f.D\u0004]y\u008fz\u00a4\u00ea$\u00ea2!\u00bcX\u0007\u00e8\u00da\u0098S\u00a8,,\u00f9\u00c8\u000e\u009b\u0090\u00c8\u00baX\u00865\u00a0J1\u00dbU\u00d7\u00ec]\u0011\u00d2\u00f0\u009a\u0082\u009f\u00c5\u00f7\u00a5\u00b1\u00dc\u00a9\u00b6\u0088U5\u00b6\u00e2C\u009e\u00e1\b\u00fbP\u00eb\u000f\u00c7\u001c{\u00c7\u00ee\u00010J\u00cd\u0014*\u00be\u0010=\"\u001b\u0000\u00a4\u00a18\u00af\u0014w'\u008c\u009b\u00eeJe\u0018\u0088\u00eb\u00bf\u00b1B7&\u0011\u00a2\u0018\u00ba\u0081o\rZ5\r\u0003\u00dfue\u00cf\u0013\u0084G\u00f2Q@\u00fd\u00c1\u009d\u009d\u0080\u00f3_\u00e8\u00923\u00b3\u001d\u00f5\u008f)\u00bc4\n\u0007v\u0013\u00e7\u0003\u00bd|\u00e7x\u00fb\u00c9?\u0015\u009c\u00a2\u00f4]\u0086\u00bb\u00c3v\u00fd\u009e\u00fe\u0158$+\u000b\u009b%*\u0085\u0084\u00ef\u0017\u009b6\u0099]6+\u0010m)\u00bb\u009f\tF\u0084\u00be\u00ef\u00f9R\u0083\u00a7\u00c7\u000f\u0005\u0002d\u00b6\u00ca\u00ce\u00f6%`\u00fe3\u00073h\u0015\u0007y\u00e9F\u000f\u00ef\u0083]\u0010E\u0019 \u00f9\u00a2\u00b0\u0000\u008fM\u0016ir\u00b2v\u00f6m5\u00b2OtL\u00bd\u00c9\u00f8\u00aff\u00db-\u0000&,S\u00c8{\u0084\u00ee\u00a7.\u00cf\u00a6\u00e6\u0096\r\u00fb(\u00c1Qo\u01fb\u00d7e\u00fdj\u00ffa\u0084,\u00f5\u008a\u00e3\u0081\u0080\u00f1\u00d4\u0084\u00c4\u00a3\u00b7u\u0016\u001c\u000b\u00d1\u000e\u00ca\u00043\b^\u008b' \u00f8\u00d8Ga\u00ed\u00a5\u008a\u001b\u0004\u0080{\u00ec]5\u00c4\u00ae\u00d6\u0007\u00d9\u0003\u0080\u009ar\u00b0g\u001d\u00ea<\u00d0a\u001by/T\u00a8;\u00d7|u71\u008b;\th1\u0084\u00bf\u00a9c\u00b9\u00ccL\r\u00f8\tG+\u00a9y\u007f\u00b4\u00a3\u00f3m?Z\u00f8i\u00ba\u001e\u0017\u008ct\u00e8\u00a0\u00fco\u001c\u00c1\u0014u\u00933\u00f3Q\u008d\u0003\u00d0!\u0006t7\u0089 q(U\u0007\u00c6\u00b8\u00b6Q^\u00e8\u0083mY\t\u00c30\u00e7\u0087\u0089\u0003\n\u0001X'\u001a\"\n\u00bb\u00ff?\u0096\t\u00e8I\u0011&\u00cd\u008a\u0019\u00d1\u009f\u0095\u0013\u00c5\u00d5f6\u0092\u0096NL\u0011.\u001cN\u00af\u00bea\u00bb\u00abM\u0094\u00fbo\u00ae\u00dcZ\u0005\u00e8\u009a\u00ca\u009d%\u00f0\u00c1\u00b7\u00cf[Fn\u00b1\u0092\u00bf\u00eb^S.\u00caSaQ\u007f\u00e0\u008a\u00ea\u0010\u00db}&e\u00108M<x\u00b6\u0097@\u00a66A\u00b2D\u00df\u00ff\u0087F\\\u00ef\u00cbo\u00eb\u008c\u00d1\u008b\u008bn\u00dc\u0086\u001d\u0082\u00e9\u00991\u00b7\u0012\u0017\u00ea*\u0019\u00ccw\u00e4\u00e2D\u00b8\u00ec\u007f%Q\u00b9|\u00b0\u00dcz\u00cb:\u00e6\u00b7\u0089\u00f9\u00d4\u0081\u001f\u00be\u00a1f\u00ffb\u0001\u00d4\u00d3}\u00b2\u001d\u00c0m\u0084%\u00ba+\u00fa5wi[{j#5\u00cbP\u009fp\u00f8\u00adSB\u007f\u00e3E\u0011\u00dc\u0098\u00d5\u00b3:\u00ca\u00e8\u00b9j\u0080\u0093\u009c,\u00c3\u0099\u00e6\u00eb\u0016\u00ca\u000e75Cl\u00d35\u00e1\u00e7N\u00c7\u001dk\u008b\u00c6\u0087\u00bb\u00f3\u00e8\u00fa4\u0003`k\u00b8\t\u00f0\u00aa\u0081x\u008d\u008c\u0095\u008d\u00a5\u0018,\u00d9\u00d7\u00df\u00df\u009d-\u00c2\u0017\bE\u0083\u00f9\u00cb\u00d19l&\u00c1\u00bc\u0097a\u0014\u0005U\fz\u00a3\u00eaG\u001d\u00a75\u008d\u0088Pj\u0089a\u00a6a\u00c5\u00b19\u0001\u00d4\t\u00fb`c\\\u009b\u008c\u00b5\u00d1\u009aAESu\u00f5\u00ba\u00b2\u00d2W\u0007\u00ae\u0094\u00d4\u00c7\u00e0\u00d17-\\\u00d4n\u00eeny< \u00e2~\u00e7bve_v=AXls\u00ac\u00af\u00car?\u009a\r\u00c8\u00a4\u0099B;cv\u00d6\u001f\u00c0\u00a8_\u00a5\u001f\u0017\u00a7\u00a0\u00f9i\u009b\u0004u\u00ce\u008a\u008f\u00e8M[\u00ab\u00d3\u00f7\u0011G$\u00bagz\u009bB\u00a2\u0017\u00f1\u00e2Q\u00ac\u00ef\u00ffu\u00c79\u001e\u00c5\u0090\u00c4\u00ccn\u00c4d\u00f1\u0012\u009d\u00b5\u007f\u00814\u00a0\u00026\u00e5\u00f5\u00fc\u00f1\tG\u000f\t\u009a\u00a2\u007f\u00c3\u00a2i\u00c9\u00ac\u000ef\u00e8\u00ad\\\u00a9\u00db\u00c2|\u009e\u00cf\u00ff\u0082\u00eb7\u00d4\u00e4o\u00c7Y\u000b\n\u0089\u00e2]\u00ec\n7\u009f&&\u00fb\u00ba\u000b\u0083\u00b9\u00de\n4\u00b6\u00b0S\u0000 \u00cc\t\u0091\u0091\u00ad\u001f\b`%\u0010\u00b3\u0010\u000f\u00ff\u00aa\u00d6\u00b9\u00c7X\u00f1Vc'D\u008c\u00f4k\u00a5&\u00a5\u00b2\u00d0*\"\u00e6;\u00b33\u00d3\u00a7\u00af\r\u00d1\u00f4o;]\u00d0\u001dfY\u00b0\u00bb\u00f5M;\u00a1\u00dcp\u00c2+\u0014\u001d-UC\u00834\u00f3\u00ae\\p\u00b8NX_r\u00c5\u00af\u00c3vTY\u00c7:e\u00c6\u009b+Z\u0004\n\u009c\u0011d%J\u00e4e\u00e7\u00b8\u009b\u00beq\"u\u00f0]?CD\u00048!\u00ad\u00fau\u008a\u0091/@S\u00bdH\u0012:\u0002\b\u00d6x\u00f4\u00ee\u00e5^\u0090\\_\u009av\u00d2\u00f9\u00a9\u0016T\u0083\u0096 %\u0003b `\u007f\f\u0088\u0088\t\u00012!\u00c3t9\u0105\u00dc\u0080\u0014\u00ee\u00c6\u0084\u00f9Q`\u00adja\u00a7\u00b7\u00f1v\u00e8\u00c66\u00ce|?\u00a2\u0081\u00f0\u00f3\u00d4+\fP$\u00be\u00aa\t7n\u0001\u00f7'\u00cf\u00e3\u0085U\u00d4%f\u00c4k\u009c!\u00c9\u0004F\u001emwgl\u00ed-\u0092\u00a6\u0096\u00c6Q^\u00d3\u00f8\u00c7@\u00d3*\u00df\f\u00cd0=^&__\u00c8\u008a=8\u0010\u00e6w\u00b3\u001e\u00b3\u00a9\u00e8\u0011BN\"$\u00d1bS\u000e.\u00db7W\u0091~^H\u00f1\u00e8l\u00e0\\-\u0004;#]\u00b3e\n\u00ef$Ts'\u00d1\u00e1Cc\u00e1\u00d5\u0095\u0094W2|~\u00b4\u009c\\\u00f6}\u009f)\u008cx5\u008e\u00c3\u00f3\u00ddM\u00fb\u00e6\u00e9\u00a5\u0013U\u0019)\u000f\u00b2\u00acG\bi6\u00de\u00fd\u00b8\u00a0U\u00c5\u00831\u00cer\u008e\u019f\u00eb\u00e9z\u00fb\u000fS\u009aj6B\u009b\u0098\u008f\u00d25\u00e0\u00f8/0\u00e4\u00e6?\u00c1\u00c6\u001a}p\u00efAkQC\u00cb\u0013\u00faN\u00c8\u0084\b\r\u0080\u0096\u00e3\u00fb\u001d>\u00bf\u0097\u0000\u00f5\u00c6\u00fe\u00f4\u00a4\u009c\u00f8\u00cbq?\u00a6%\u009c\u00d4\u00ba>\u00bf\u00d6h[x\u00984r\u009fI\u00e2\u00ef\u0015\u0002\u001c\b\u00ea\u00efg\u0095\u0004\u001a^\u009b\u00f5U1\u0096\u0004w\u00b3\u00ae9C^F*\u00b3\u00c6ZO\u0006\u00f8]\u009e\u009c \u00bae\u0016\u00b0\u0092\u00e1U\u00fa\u00eas&x\u00bf\u00d2hN\u0001L!\u00d4`\u00ee\r\u0088\u00db8P\u0010\u00b0s\u00f3\u001a\u00dd\u00e7J\u00f3,\u0004>-M\u008c8K\u00d1\u00e6\u00c5\u0098\u00c02\u00d9\u0019\u00bcECB\u00f3M\u00fe\u007f\u00d7\u00c4\u00eb\" /x\u0081s\b\u00cd~\u00d6\u009b\u007f\u00b2:\u00afc\u00a09\u00b1\u0097\u0081DLr\u00f5\u00de]\u00dd\u00049eA\u00f5\u0095\u0012\b\u00f6\u00d9t\u0086n\u00f2\u009d\u0095\u00ee_\u00c5\u008f\u00e1\u0090,v\u0086\u0016\u00fe\u00fd\u00b1K\u0093\u00a3\u00c9\u00cc\u00a2\u00d8& \u0010\u0097*Y\u00b3Hu\u0096*\u00fb\u0012\u001fQ;\u0080\u00da\u00f0yN\u00e4\u0094q\u008aJ\b(\u0011a!\u0017N\u00c3\u009b\u009cV\u00f5\u001c\u00cf1\u00a9\u0081\u00b7aM\u00c2\u00e9\u000e<\u008d\u00ff\u001e\t%\u0005tG\u00f3\u00e1-\u0002\u0096\t\u001fT\u00ab\u00cd\u00c5M\u001b\u00ed!\u00b0Y\u00b2\u0002P\u000e.\u0097|N\u00c9\u00cb\u0081\u00fb[\u00c6m\u008aN|\u00be\u0082\u0006\u0006\u0099|a(\u0002K".length();
                    var1_4 = 32;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = ++var0_5;
                        v1 = var2_2.substring(v0, v0 + var1_4);
                        v2 = -1;
                        break block23;
                        break;
                    }
lbl12:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v3.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0007\u00c8Pq\u00a7~\u00dc\u0000*A\u00d7\u008f{\u0083\u0001\u0015g\u001a\u00a3\u0093\u00b5&,\u008e\u00d0^\u00b2d\u00e9\u00a1\u00b0\u0017D\u009d\u00a6\u001ch";
                        var4_3 = "\u0007\u00c8Pq\u00a7~\u00dc\u0000*A\u00d7\u008f{\u0083\u0001\u0015g\u001a\u00a3\u0093\u00b5&,\u008e\u00d0^\u00b2d\u00e9\u00a1\u00b0\u0017D\u009d\u00a6\u001ch".length();
                        var1_4 = 15;
                        var0_5 = -1;
lbl21:
                        // 2 sources

                        while (true) {
                            v4 = ++var0_5;
                            v1 = var2_2.substring(v4, v4 + var1_4);
                            v2 = 0;
                            break block23;
                            break;
                        }
                        break;
                    }
lbl26:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v3.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block24;
                        break;
                    }
                }
                v5 = v1.toCharArray();
                var6_6 = 0;
                v6 = v5.length;
                v7 = v5;
                v8 = v6;
                if (v6 > 1) ** GOTO lbl76
                do {
                    v9 = v7;
                    v10 = v7;
                    v11 = var6_6;
                    while (true) {
                        v12 = v9[v11];
                        switch (var6_6 % 7) {
                            case 0: {
                                v13 = 82;
                                break;
                            }
                            case 1: {
                                v13 = 4;
                                break;
                            }
                            case 2: {
                                v13 = 93;
                                break;
                            }
                            case 3: {
                                v13 = 9;
                                break;
                            }
                            case 4: {
                                v13 = 67;
                                break;
                            }
                            case 5: {
                                v13 = 12;
                                break;
                            }
                            default: {
                                v13 = 105;
                            }
                        }
                        v9[v11] = (char)(v12 ^ v13);
                        ++var6_6;
                        v7 = v10;
                        v8 = v8;
                        if (v8 != 0) break;
                        v10 = v7;
                        v14 = v8;
                        v11 = v8;
                        v9 = v7;
                    }
lbl76:
                    // 2 sources

                    v15 = v7;
                    v14 = v8;
                } while (v8 > var6_6);
                v3 = new String(v15);
                switch (v2) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl85:
                    // 1 sources

                    ** continue;
                }
            }
            SmartOp.e = var5;
            SmartOp.f = new String[54];
            SmartOp.d = LoggerFactory.getLogger(SmartOp.class);
            var7_7 = System.getProperty(SmartOp.a(-12382, 27868)).toLowerCase();
            if (var7_7.indexOf(SmartOp.a(-12357, -15853)) < 0 || !MA3APIEnvironment.SET_MAC_OS_PCSC_PATH) break block25;
            System.setProperty(SmartOp.a(-12409, 20822), SmartOp.a(-12408, -3333));
        }
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0xFFFFCFAC) & 0xFFFF;
        if (f[n4] == null) {
            int n5;
            int n6;
            char[] cArray = e[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 196;
                    break;
                }
                case 1: {
                    n6 = 9;
                    break;
                }
                case 2: {
                    n6 = 191;
                    break;
                }
                case 3: {
                    n6 = 144;
                    break;
                }
                case 4: {
                    n6 = 5;
                    break;
                }
                case 5: {
                    n6 = 2;
                    break;
                }
                case 6: {
                    n6 = 179;
                    break;
                }
                case 7: {
                    n6 = 81;
                    break;
                }
                case 8: {
                    n6 = 40;
                    break;
                }
                case 9: {
                    n6 = 212;
                    break;
                }
                case 10: {
                    n6 = 232;
                    break;
                }
                case 11: {
                    n6 = 61;
                    break;
                }
                case 12: {
                    n6 = 247;
                    break;
                }
                case 13: {
                    n6 = 55;
                    break;
                }
                case 14: {
                    n6 = 86;
                    break;
                }
                case 15: {
                    n6 = 163;
                    break;
                }
                case 16: {
                    n6 = 45;
                    break;
                }
                case 17: {
                    n6 = 29;
                    break;
                }
                case 18: {
                    n6 = 209;
                    break;
                }
                case 19: {
                    n6 = 128;
                    break;
                }
                case 20: {
                    n6 = 102;
                    break;
                }
                case 21: {
                    n6 = 107;
                    break;
                }
                case 22: {
                    n6 = 90;
                    break;
                }
                case 23: {
                    n6 = 224;
                    break;
                }
                case 24: {
                    n6 = 202;
                    break;
                }
                case 25: {
                    n6 = 82;
                    break;
                }
                case 26: {
                    n6 = 159;
                    break;
                }
                case 27: {
                    n6 = 92;
                    break;
                }
                case 28: {
                    n6 = 190;
                    break;
                }
                case 29: {
                    n6 = 0;
                    break;
                }
                case 30: {
                    n6 = 236;
                    break;
                }
                case 31: {
                    n6 = 94;
                    break;
                }
                case 32: {
                    n6 = 133;
                    break;
                }
                case 33: {
                    n6 = 41;
                    break;
                }
                case 34: {
                    n6 = 101;
                    break;
                }
                case 35: {
                    n6 = 111;
                    break;
                }
                case 36: {
                    n6 = 114;
                    break;
                }
                case 37: {
                    n6 = 215;
                    break;
                }
                case 38: {
                    n6 = 60;
                    break;
                }
                case 39: {
                    n6 = 188;
                    break;
                }
                case 40: {
                    n6 = 59;
                    break;
                }
                case 41: {
                    n6 = 112;
                    break;
                }
                case 42: {
                    n6 = 242;
                    break;
                }
                case 43: {
                    n6 = 4;
                    break;
                }
                case 44: {
                    n6 = 108;
                    break;
                }
                case 45: {
                    n6 = 8;
                    break;
                }
                case 46: {
                    n6 = 164;
                    break;
                }
                case 47: {
                    n6 = 231;
                    break;
                }
                case 48: {
                    n6 = 181;
                    break;
                }
                case 49: {
                    n6 = 185;
                    break;
                }
                case 50: {
                    n6 = 180;
                    break;
                }
                case 51: {
                    n6 = 16;
                    break;
                }
                case 52: {
                    n6 = 36;
                    break;
                }
                case 53: {
                    n6 = 96;
                    break;
                }
                case 54: {
                    n6 = 12;
                    break;
                }
                case 55: {
                    n6 = 64;
                    break;
                }
                case 56: {
                    n6 = 169;
                    break;
                }
                case 57: {
                    n6 = 91;
                    break;
                }
                case 58: {
                    n6 = 223;
                    break;
                }
                case 59: {
                    n6 = 134;
                    break;
                }
                case 60: {
                    n6 = 13;
                    break;
                }
                case 61: {
                    n6 = 227;
                    break;
                }
                case 62: {
                    n6 = 200;
                    break;
                }
                case 63: {
                    n6 = 120;
                    break;
                }
                case 64: {
                    n6 = 145;
                    break;
                }
                case 65: {
                    n6 = 244;
                    break;
                }
                case 66: {
                    n6 = 10;
                    break;
                }
                case 67: {
                    n6 = 194;
                    break;
                }
                case 68: {
                    n6 = 15;
                    break;
                }
                case 69: {
                    n6 = 79;
                    break;
                }
                case 70: {
                    n6 = 210;
                    break;
                }
                case 71: {
                    n6 = 131;
                    break;
                }
                case 72: {
                    n6 = 109;
                    break;
                }
                case 73: {
                    n6 = 116;
                    break;
                }
                case 74: {
                    n6 = 204;
                    break;
                }
                case 75: {
                    n6 = 17;
                    break;
                }
                case 76: {
                    n6 = 115;
                    break;
                }
                case 77: {
                    n6 = 206;
                    break;
                }
                case 78: {
                    n6 = 95;
                    break;
                }
                case 79: {
                    n6 = 78;
                    break;
                }
                case 80: {
                    n6 = 74;
                    break;
                }
                case 81: {
                    n6 = 132;
                    break;
                }
                case 82: {
                    n6 = 106;
                    break;
                }
                case 83: {
                    n6 = 198;
                    break;
                }
                case 84: {
                    n6 = 251;
                    break;
                }
                case 85: {
                    n6 = 113;
                    break;
                }
                case 86: {
                    n6 = 37;
                    break;
                }
                case 87: {
                    n6 = 100;
                    break;
                }
                case 88: {
                    n6 = 137;
                    break;
                }
                case 89: {
                    n6 = 54;
                    break;
                }
                case 90: {
                    n6 = 22;
                    break;
                }
                case 91: {
                    n6 = 136;
                    break;
                }
                case 92: {
                    n6 = 67;
                    break;
                }
                case 93: {
                    n6 = 140;
                    break;
                }
                case 94: {
                    n6 = 34;
                    break;
                }
                case 95: {
                    n6 = 39;
                    break;
                }
                case 96: {
                    n6 = 226;
                    break;
                }
                case 97: {
                    n6 = 88;
                    break;
                }
                case 98: {
                    n6 = 147;
                    break;
                }
                case 99: {
                    n6 = 192;
                    break;
                }
                case 100: {
                    n6 = 98;
                    break;
                }
                case 101: {
                    n6 = 225;
                    break;
                }
                case 102: {
                    n6 = 193;
                    break;
                }
                case 103: {
                    n6 = 240;
                    break;
                }
                case 104: {
                    n6 = 49;
                    break;
                }
                case 105: {
                    n6 = 105;
                    break;
                }
                case 106: {
                    n6 = 161;
                    break;
                }
                case 107: {
                    n6 = 253;
                    break;
                }
                case 108: {
                    n6 = 71;
                    break;
                }
                case 109: {
                    n6 = 234;
                    break;
                }
                case 110: {
                    n6 = 124;
                    break;
                }
                case 111: {
                    n6 = 157;
                    break;
                }
                case 112: {
                    n6 = 155;
                    break;
                }
                case 113: {
                    n6 = 211;
                    break;
                }
                case 114: {
                    n6 = 24;
                    break;
                }
                case 115: {
                    n6 = 160;
                    break;
                }
                case 116: {
                    n6 = 237;
                    break;
                }
                case 117: {
                    n6 = 33;
                    break;
                }
                case 118: {
                    n6 = 213;
                    break;
                }
                case 119: {
                    n6 = 245;
                    break;
                }
                case 120: {
                    n6 = 125;
                    break;
                }
                case 121: {
                    n6 = 156;
                    break;
                }
                case 122: {
                    n6 = 167;
                    break;
                }
                case 123: {
                    n6 = 151;
                    break;
                }
                case 124: {
                    n6 = 47;
                    break;
                }
                case 125: {
                    n6 = 72;
                    break;
                }
                case 126: {
                    n6 = 186;
                    break;
                }
                case 127: {
                    n6 = 44;
                    break;
                }
                case 128: {
                    n6 = 73;
                    break;
                }
                case 129: {
                    n6 = 201;
                    break;
                }
                case 130: {
                    n6 = 146;
                    break;
                }
                case 131: {
                    n6 = 35;
                    break;
                }
                case 132: {
                    n6 = 119;
                    break;
                }
                case 133: {
                    n6 = 87;
                    break;
                }
                case 134: {
                    n6 = 38;
                    break;
                }
                case 135: {
                    n6 = 20;
                    break;
                }
                case 136: {
                    n6 = 103;
                    break;
                }
                case 137: {
                    n6 = 121;
                    break;
                }
                case 138: {
                    n6 = 117;
                    break;
                }
                case 139: {
                    n6 = 248;
                    break;
                }
                case 140: {
                    n6 = 199;
                    break;
                }
                case 141: {
                    n6 = 26;
                    break;
                }
                case 142: {
                    n6 = 246;
                    break;
                }
                case 143: {
                    n6 = 30;
                    break;
                }
                case 144: {
                    n6 = 168;
                    break;
                }
                case 145: {
                    n6 = 205;
                    break;
                }
                case 146: {
                    n6 = 233;
                    break;
                }
                case 147: {
                    n6 = 143;
                    break;
                }
                case 148: {
                    n6 = 208;
                    break;
                }
                case 149: {
                    n6 = 221;
                    break;
                }
                case 150: {
                    n6 = 127;
                    break;
                }
                case 151: {
                    n6 = 170;
                    break;
                }
                case 152: {
                    n6 = 153;
                    break;
                }
                case 153: {
                    n6 = 254;
                    break;
                }
                case 154: {
                    n6 = 173;
                    break;
                }
                case 155: {
                    n6 = 149;
                    break;
                }
                case 156: {
                    n6 = 250;
                    break;
                }
                case 157: {
                    n6 = 238;
                    break;
                }
                case 158: {
                    n6 = 171;
                    break;
                }
                case 159: {
                    n6 = 230;
                    break;
                }
                case 160: {
                    n6 = 141;
                    break;
                }
                case 161: {
                    n6 = 1;
                    break;
                }
                case 162: {
                    n6 = 63;
                    break;
                }
                case 163: {
                    n6 = 162;
                    break;
                }
                case 164: {
                    n6 = 56;
                    break;
                }
                case 165: {
                    n6 = 89;
                    break;
                }
                case 166: {
                    n6 = 18;
                    break;
                }
                case 167: {
                    n6 = 220;
                    break;
                }
                case 168: {
                    n6 = 139;
                    break;
                }
                case 169: {
                    n6 = 48;
                    break;
                }
                case 170: {
                    n6 = 19;
                    break;
                }
                case 171: {
                    n6 = 138;
                    break;
                }
                case 172: {
                    n6 = 7;
                    break;
                }
                case 173: {
                    n6 = 229;
                    break;
                }
                case 174: {
                    n6 = 58;
                    break;
                }
                case 175: {
                    n6 = 150;
                    break;
                }
                case 176: {
                    n6 = 97;
                    break;
                }
                case 177: {
                    n6 = 239;
                    break;
                }
                case 178: {
                    n6 = 80;
                    break;
                }
                case 179: {
                    n6 = 166;
                    break;
                }
                case 180: {
                    n6 = 217;
                    break;
                }
                case 181: {
                    n6 = 216;
                    break;
                }
                case 182: {
                    n6 = 184;
                    break;
                }
                case 183: {
                    n6 = 27;
                    break;
                }
                case 184: {
                    n6 = 46;
                    break;
                }
                case 185: {
                    n6 = 222;
                    break;
                }
                case 186: {
                    n6 = 85;
                    break;
                }
                case 187: {
                    n6 = 53;
                    break;
                }
                case 188: {
                    n6 = 142;
                    break;
                }
                case 189: {
                    n6 = 174;
                    break;
                }
                case 190: {
                    n6 = 6;
                    break;
                }
                case 191: {
                    n6 = 228;
                    break;
                }
                case 192: {
                    n6 = 130;
                    break;
                }
                case 193: {
                    n6 = 3;
                    break;
                }
                case 194: {
                    n6 = 241;
                    break;
                }
                case 195: {
                    n6 = 178;
                    break;
                }
                case 196: {
                    n6 = 50;
                    break;
                }
                case 197: {
                    n6 = 243;
                    break;
                }
                case 198: {
                    n6 = 126;
                    break;
                }
                case 199: {
                    n6 = 66;
                    break;
                }
                case 200: {
                    n6 = 70;
                    break;
                }
                case 201: {
                    n6 = 83;
                    break;
                }
                case 202: {
                    n6 = 43;
                    break;
                }
                case 203: {
                    n6 = 129;
                    break;
                }
                case 204: {
                    n6 = 187;
                    break;
                }
                case 205: {
                    n6 = 152;
                    break;
                }
                case 206: {
                    n6 = 182;
                    break;
                }
                case 207: {
                    n6 = 123;
                    break;
                }
                case 208: {
                    n6 = 218;
                    break;
                }
                case 209: {
                    n6 = 110;
                    break;
                }
                case 210: {
                    n6 = 25;
                    break;
                }
                case 211: {
                    n6 = 176;
                    break;
                }
                case 212: {
                    n6 = 51;
                    break;
                }
                case 213: {
                    n6 = 84;
                    break;
                }
                case 214: {
                    n6 = 99;
                    break;
                }
                case 215: {
                    n6 = 23;
                    break;
                }
                case 216: {
                    n6 = 197;
                    break;
                }
                case 217: {
                    n6 = 65;
                    break;
                }
                case 218: {
                    n6 = 14;
                    break;
                }
                case 219: {
                    n6 = 154;
                    break;
                }
                case 220: {
                    n6 = 76;
                    break;
                }
                case 221: {
                    n6 = 122;
                    break;
                }
                case 222: {
                    n6 = 118;
                    break;
                }
                case 223: {
                    n6 = 52;
                    break;
                }
                case 224: {
                    n6 = 214;
                    break;
                }
                case 225: {
                    n6 = 203;
                    break;
                }
                case 226: {
                    n6 = 104;
                    break;
                }
                case 227: {
                    n6 = 32;
                    break;
                }
                case 228: {
                    n6 = 183;
                    break;
                }
                case 229: {
                    n6 = 69;
                    break;
                }
                case 230: {
                    n6 = 207;
                    break;
                }
                case 231: {
                    n6 = 177;
                    break;
                }
                case 232: {
                    n6 = 42;
                    break;
                }
                case 233: {
                    n6 = 189;
                    break;
                }
                case 234: {
                    n6 = 255;
                    break;
                }
                case 235: {
                    n6 = 165;
                    break;
                }
                case 236: {
                    n6 = 175;
                    break;
                }
                case 237: {
                    n6 = 62;
                    break;
                }
                case 238: {
                    n6 = 68;
                    break;
                }
                case 239: {
                    n6 = 158;
                    break;
                }
                case 240: {
                    n6 = 28;
                    break;
                }
                case 241: {
                    n6 = 57;
                    break;
                }
                case 242: {
                    n6 = 195;
                    break;
                }
                case 243: {
                    n6 = 31;
                    break;
                }
                case 244: {
                    n6 = 235;
                    break;
                }
                case 245: {
                    n6 = 219;
                    break;
                }
                case 246: {
                    n6 = 148;
                    break;
                }
                case 247: {
                    n6 = 21;
                    break;
                }
                case 248: {
                    n6 = 249;
                    break;
                }
                case 249: {
                    n6 = 93;
                    break;
                }
                case 250: {
                    n6 = 77;
                    break;
                }
                case 251: {
                    n6 = 172;
                    break;
                }
                case 252: {
                    n6 = 135;
                    break;
                }
                case 253: {
                    n6 = 252;
                    break;
                }
                case 254: {
                    n6 = 11;
                    break;
                }
                default: {
                    n6 = 75;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            SmartOp.f[n4] = new String(cArray).intern();
        }
        return f[n4];
    }
}

