/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec;

import gnu.crypto.sig.ecdsa.ecmath.field.FieldFp;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.DerInputStream;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.DerOutputStream;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.DerValue;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.ObjectIdentifier;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.crypto.ec.ECPointUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec.NamedCurve;

public final class ECParameters
extends AlgorithmParametersSpi {
    private static final ObjectIdentifier a;
    private static final ObjectIdentifier b;
    private static final ObjectIdentifier c;
    private static final ObjectIdentifier d;
    private ECParameterSpec e;
    private static final String[] f;
    private static final String[] g;

    public static ECPoint decodePoint(byte[] data, EllipticCurve curve) throws IOException {
        int n2;
        block10: {
            n2 = NamedCurve.m;
            if (data.length != 0 && data[0] == 4) break block10;
            throw new IOException(ECParameters.a(-28181, -28036));
        }
        int n3 = curve.getField().getFieldSize() + 7 >> 3;
        if (data.length != n3 * 2 + 1) {
            throw new IOException(ECParameters.a(-28191, -30789));
        }
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        System.arraycopy(data, 1, byArray, 0, n3);
        System.arraycopy(data, n3 + 1, byArray2, 0, n3);
        ECPoint eCPoint = new ECPoint(new BigInteger(1, byArray), new BigInteger(1, byArray2));
        if (SmartCardException.b != 0) {
            NamedCurve.m = ++n2;
        }
        return eCPoint;
    }

    public static byte[] encodePoint(ECPoint point, EllipticCurve curve, boolean compress) {
        return ECPointUtil.encodePoint(point, curve, compress);
    }

    public static byte[] encodePoint(ECPoint point, EllipticCurve curve) {
        return ECParameters.encodePoint(point, curve, false);
    }

    static byte[] a(byte[] byArray) {
        return ECPointUtil.trimZeroes(byArray);
    }

    public static NamedCurve getNamedCurve(ECParameterSpec params) {
        int n2;
        block15: {
            n2 = NamedCurve.m;
            if (!(params instanceof NamedCurve) && params != null) break block15;
            return (NamedCurve)params;
        }
        int n3 = params.getCurve().getField().getFieldSize();
        for (ECParameterSpec eCParameterSpec : NamedCurve.knownECParameterSpecs()) {
            if (eCParameterSpec.getCurve().getField().getFieldSize() != n3 && n2 == 0) continue;
            if (!eCParameterSpec.getCurve().equals(params.getCurve()) && n2 == 0) continue;
            if (!eCParameterSpec.getGenerator().equals(params.getGenerator()) && n2 == 0) continue;
            if (!eCParameterSpec.getOrder().equals(params.getOrder()) && n2 == 0) continue;
            if (eCParameterSpec.getCofactor() != params.getCofactor() && n2 == 0) continue;
            return (NamedCurve)eCParameterSpec;
        }
        return null;
    }

    public static String getCurveName(ECParameterSpec params) {
        NamedCurve namedCurve = ECParameters.getNamedCurve(params);
        String string = namedCurve == null ? null : namedCurve.getObjectIdentifier().toString();
        return string;
    }

    public static byte[] encodeParameters(ECParameterSpec params) {
        NamedCurve namedCurve = ECParameters.getNamedCurve(params);
        if (namedCurve != null) {
            return namedCurve.a();
        }
        return ECParameters.encodeECParameterSpec(params);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encodeECParameterSpec(ECParameterSpec params) {
        int n2 = NamedCurve.m;
        try {
            Object object;
            Object object2;
            DerOutputStream derOutputStream;
            DerOutputStream derOutputStream2;
            DerOutputStream derOutputStream3;
            block11: {
                block14: {
                    int[] nArray;
                    block13: {
                        block12: {
                            ECField eCField;
                            block10: {
                                derOutputStream3 = new DerOutputStream();
                                derOutputStream2 = new DerOutputStream();
                                derOutputStream2.putInteger(1);
                                derOutputStream = new DerOutputStream();
                                eCField = params.getCurve().getField();
                                if (!(eCField instanceof ECFieldFp)) break block10;
                                object2 = (ECFieldFp)eCField;
                                derOutputStream.putOID(a);
                                derOutputStream.putInteger(((ECFieldFp)object2).getP());
                                if (n2 == 0) break block11;
                                int n3 = SmartCardException.b;
                                SmartCardException.b = ++n3;
                            }
                            if (!(eCField instanceof FieldFp)) break block12;
                            object2 = (FieldFp)eCField;
                            derOutputStream.putOID(a);
                            derOutputStream.putInteger(((FieldFp)object2).getMP());
                            if (n2 == 0) break block11;
                        }
                        derOutputStream.putOID(b);
                        object2 = (ECFieldF2m)params.getCurve().getField();
                        object = new DerOutputStream();
                        ((DerOutputStream)object).putInteger(((ECFieldF2m)object2).getFieldSize());
                        nArray = ((ECFieldF2m)object2).getMidTermsOfReductionPolynomial();
                        if (nArray.length != 1) break block13;
                        ((DerOutputStream)object).putOID(c);
                        ((DerOutputStream)object).putInteger(nArray[0]);
                        if (n2 == 0) break block14;
                    }
                    if (nArray.length == 3) {
                        ((DerOutputStream)object).putOID(d);
                        DerOutputStream derOutputStream4 = new DerOutputStream();
                        derOutputStream4.putInteger(nArray[2]);
                        derOutputStream4.putInteger(nArray[1]);
                        derOutputStream4.putInteger(nArray[0]);
                        ((DerOutputStream)object).write((byte)48, derOutputStream4);
                    }
                }
                derOutputStream.write((byte)48, (DerOutputStream)object);
            }
            derOutputStream2.write((byte)48, derOutputStream);
            object2 = params.getCurve();
            object = ((EllipticCurve)object2).getA();
            BigInteger bigInteger = ((EllipticCurve)object2).getB();
            int n4 = ((EllipticCurve)object2).getField().getFieldSize();
            DerOutputStream derOutputStream5 = new DerOutputStream();
            derOutputStream5.putOctetString(ECParameters.a((BigInteger)object, n4));
            derOutputStream5.putOctetString(ECParameters.a(bigInteger, n4));
            if (((EllipticCurve)object2).getSeed() != null) {
                derOutputStream5.putBitString(((EllipticCurve)object2).getSeed());
            }
            derOutputStream2.write((byte)48, derOutputStream5);
            byte[] byArray = ECParameters.encodePoint(params.getGenerator(), (EllipticCurve)object2);
            derOutputStream2.putOctetString(byArray);
            derOutputStream2.putInteger(params.getOrder());
            derOutputStream2.putInteger(params.getCofactor());
            derOutputStream3.write((byte)48, derOutputStream2);
            return derOutputStream3.toByteArray();
        }
        catch (IOException iOException) {
            throw new ESYARuntimeException(ECParameters.a(-28183, -31170), iOException);
        }
    }

    private static byte[] a(BigInteger bigInteger, int n2) {
        int n3 = (n2 + 7) / 8;
        byte[] byArray = bigInteger.toByteArray();
        if (n3 < byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, byArray.length - byArray2.length, byArray2, 0, byArray2.length);
            return byArray2;
        }
        if (n3 > byArray.length) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
            return byArray3;
        }
        return byArray;
    }

    public static ECParameterSpec decodeParameters(byte[] params) throws IOException {
        DerValue derValue = new DerValue(params);
        if (derValue.tag == 6) {
            ObjectIdentifier objectIdentifier = derValue.getOID();
            ECParameterSpec eCParameterSpec = NamedCurve.a(objectIdentifier);
            if (eCParameterSpec == null) {
                throw new IOException(ECParameters.a(-28187, -12333) + objectIdentifier);
            }
            return eCParameterSpec;
        }
        derValue.data.reset();
        if (derValue.tag == 48) {
            DerInputStream derInputStream = derValue.data;
            int n2 = derInputStream.getInteger();
            if (n2 != 1) {
                throw new IOException(ECParameters.a(-28186, -12396) + n2);
            }
            ECField eCField = ECParameters.a(derInputStream);
            EllipticCurve ellipticCurve = ECParameters.a(derInputStream, eCField);
            ECPoint eCPoint = ECParameters.a(derInputStream, ellipticCurve);
            BigInteger bigInteger = derInputStream.getBigInteger();
            int n3 = 0;
            if (derInputStream.available() != 0) {
                n3 = derInputStream.getInteger();
            }
            if (derValue.data.available() != 0) {
                throw new IOException(ECParameters.a(-28188, 3128) + derValue.data.available() + ECParameters.a(-28179, -8960));
            }
            return new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n3);
        }
        throw new IOException(ECParameters.a(-28185, 13635));
    }

    private static ECField a(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        ObjectIdentifier objectIdentifier = derValue.data.getOID();
        if (objectIdentifier.equals(a)) {
            BigInteger bigInteger = derValue.data.getBigInteger();
            return new ECFieldFp(bigInteger);
        }
        if (objectIdentifier.equals(b)) {
            DerValue derValue2 = derValue.getData().getDerValue();
            int n2 = derValue2.data.getInteger();
            ObjectIdentifier objectIdentifier2 = derValue2.data.getOID();
            if (objectIdentifier2.equals(c)) {
                int n3 = derValue2.data.getInteger();
                return new ECFieldF2m(n2, new int[]{n3});
            }
            if (objectIdentifier2.equals(d)) {
                DerValue derValue3 = derValue2.getData().getDerValue();
                int n4 = derValue3.data.getInteger();
                int n5 = derValue3.data.getInteger();
                int n6 = derValue3.data.getInteger();
                return new ECFieldF2m(n2, new int[]{n4, n5, n6});
            }
            throw new IOException(ECParameters.a(-28180, 23515));
        }
        throw new IOException(ECParameters.a(-28192, -26579));
    }

    private static EllipticCurve a(DerInputStream derInputStream, ECField eCField) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        byte[] byArray = derValue.data.getOctetString();
        byte[] byArray2 = derValue.data.getOctetString();
        return new EllipticCurve(eCField, new BigInteger(1, byArray), new BigInteger(1, byArray2));
    }

    private static ECPoint a(DerInputStream derInputStream, EllipticCurve ellipticCurve) throws IOException {
        byte[] byArray = derInputStream.getOctetString();
        return ECParameters.decodePoint(byArray, ellipticCurve);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        int n2 = NamedCurve.m;
        if (paramSpec instanceof ECParameterSpec) {
            this.e = ECParameters.getNamedCurve((ECParameterSpec)paramSpec);
            if (this.e != null) return;
            throw new InvalidParameterSpecException(ECParameters.a(-28178, 22103) + paramSpec);
        }
        if (paramSpec instanceof ECGenParameterSpec) {
            String string = ((ECGenParameterSpec)paramSpec).getName();
            ECParameterSpec eCParameterSpec = NamedCurve.getECParameterSpec(string);
            if (eCParameterSpec == null) {
                throw new InvalidParameterSpecException(ECParameters.a(-28184, -17509) + string);
            }
            this.e = eCParameterSpec;
            if (n2 == 0) return;
        }
        if (paramSpec != null) throw new InvalidParameterSpecException(ECParameters.a(-28177, 30738));
        throw new InvalidParameterSpecException(ECParameters.a(-28189, 31742));
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        this.e = ECParameters.decodeParameters(params);
    }

    @Override
    protected void engineInit(byte[] params, String decodingMethod) throws IOException {
        this.engineInit(params);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> spec) throws InvalidParameterSpecException {
        if (spec.isAssignableFrom(ECParameterSpec.class)) {
            return (T)this.e;
        }
        if (spec.isAssignableFrom(ECGenParameterSpec.class)) {
            return (T)new ECGenParameterSpec(ECParameters.getCurveName(this.e));
        }
        throw new InvalidParameterSpecException(ECParameters.a(-28182, 10914));
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return ECParameters.encodeParameters(this.e);
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        return this.e.toString();
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[15];
                var3_1 = 0;
                var2_2 = "\u00d4\u00c5#\u00be\u00a2\u009e\u0086\u009dz\f\u00c7\u00cb#Z\u0082]I\u00f3\u00ff\u0089\u00c8U\u00ae:\u00d8~t\u0086\u0014\u00bbo\u0016sM\u001f\u00e3\u00c4Syv\n\u000e\u009eI\u00fd\u00b7\u00e7\u000b5J\u00e8f|\u00ceNp\u0015\u00b3o\u00e1\u007f\u00c6\u0095\u0015\u00cd\u00ddN$\u0006\u00a3\u00cf\u00c95\u0001\u00c8\u0095}\u009d\u0099\u00cfJ\u0012\u00b7\u00dd\u00bf\u00f8\u00be,\u008e\u001bC\u001fvz$\u00e1\u00fd\u00e3\u00d2}\u00e6\u008a\u001d\u00b0\u00f7\u0000\u00e7X*\u00fbu\u00e5\u00e0\u0016\u00d3\u00e6\u00ed#\u00a3\u0007\u008a\u00ed\u00ab\u00d7\u00fd\u0086\u000b\u0016\u000fI\u00ad\u00a1\u0017\u0095\u00b6\u0012\u0000L\u0099\u0090\u00f0z\u00b1^9r\u000e\u00e7\u00ba~QF\u00d0**\u008c\u000f\u00e2@-~\u000f\u00c9\u00c3\u00e1O\u0088/\u007fn\u00a3E(t\u00d2\u00a1;6\u0096B\u000bs\u00e6'\u00ad-4~\tSs1\u00f7\u00ffs8\b \u0089\u000e\u0010\u00fdA7\u001at\u00fc\u00eb\u00ef\u0086\u00ee2\u00805\u00e55\u0093\u00c7p9\u00a7\u00fbI\u00b2\u00be\u00c4-\u00e2h#r\u0093\u00d1\u00bd\u001d\u00b8\u001e\u00db\u00fb\u0015\u00ca\u00c6v\u00ee\u00b2\u00a4\u00bdj(\u0004F\u00c9\u00fb`\u00e1\u009e@\u00cd\u0091S\u009c\u0013L\u000f\u0088]4\u0015={\u00d6\u0019p%,|\u00bf/\u0082\u000e&\u00e6.z]Y1{\u0001\u0014\u0016H\u008d~\u0019\u00faa\u00d7CZ\u00df\u00a4xd\u008e\u000eqi\u00c5g!\u0082,\u007f\u00e4\u00edv6a\u0019mq\u00c3\u009b\u000bX\u00be\u00c2=\u00b3\u00c1\u0014\u00d1\u00cf\u00c3,\u00ea:87\u00fc\u00f5}\u00e3#\u00c0Oq\u0084\u0080\u00e9\u00cfP\u00f8\u00b6:\u00fc86\u00abj\u00d5\u00faU\u00dcLN\u00d2\u00a4[K\u00d2\u00e6\u00f1\u0091\u008e\u00fb8\u0015J\u001f.\u00a4\u0013\u00c3\u0091)b\u000f6\u00f5\u0094\u000e\u000b\u00d8\u00a2{\u00f4`sL\u008f\u00ebKW\u00fa\u0084L\u00c5\u00a5(p";
                var4_3 = "\u00d4\u00c5#\u00be\u00a2\u009e\u0086\u009dz\f\u00c7\u00cb#Z\u0082]I\u00f3\u00ff\u0089\u00c8U\u00ae:\u00d8~t\u0086\u0014\u00bbo\u0016sM\u001f\u00e3\u00c4Syv\n\u000e\u009eI\u00fd\u00b7\u00e7\u000b5J\u00e8f|\u00ceNp\u0015\u00b3o\u00e1\u007f\u00c6\u0095\u0015\u00cd\u00ddN$\u0006\u00a3\u00cf\u00c95\u0001\u00c8\u0095}\u009d\u0099\u00cfJ\u0012\u00b7\u00dd\u00bf\u00f8\u00be,\u008e\u001bC\u001fvz$\u00e1\u00fd\u00e3\u00d2}\u00e6\u008a\u001d\u00b0\u00f7\u0000\u00e7X*\u00fbu\u00e5\u00e0\u0016\u00d3\u00e6\u00ed#\u00a3\u0007\u008a\u00ed\u00ab\u00d7\u00fd\u0086\u000b\u0016\u000fI\u00ad\u00a1\u0017\u0095\u00b6\u0012\u0000L\u0099\u0090\u00f0z\u00b1^9r\u000e\u00e7\u00ba~QF\u00d0**\u008c\u000f\u00e2@-~\u000f\u00c9\u00c3\u00e1O\u0088/\u007fn\u00a3E(t\u00d2\u00a1;6\u0096B\u000bs\u00e6'\u00ad-4~\tSs1\u00f7\u00ffs8\b \u0089\u000e\u0010\u00fdA7\u001at\u00fc\u00eb\u00ef\u0086\u00ee2\u00805\u00e55\u0093\u00c7p9\u00a7\u00fbI\u00b2\u00be\u00c4-\u00e2h#r\u0093\u00d1\u00bd\u001d\u00b8\u001e\u00db\u00fb\u0015\u00ca\u00c6v\u00ee\u00b2\u00a4\u00bdj(\u0004F\u00c9\u00fb`\u00e1\u009e@\u00cd\u0091S\u009c\u0013L\u000f\u0088]4\u0015={\u00d6\u0019p%,|\u00bf/\u0082\u000e&\u00e6.z]Y1{\u0001\u0014\u0016H\u008d~\u0019\u00faa\u00d7CZ\u00df\u00a4xd\u008e\u000eqi\u00c5g!\u0082,\u007f\u00e4\u00edv6a\u0019mq\u00c3\u009b\u000bX\u00be\u00c2=\u00b3\u00c1\u0014\u00d1\u00cf\u00c3,\u00ea:87\u00fc\u00f5}\u00e3#\u00c0Oq\u0084\u0080\u00e9\u00cfP\u00f8\u00b6:\u00fc86\u00abj\u00d5\u00faU\u00dcLN\u00d2\u00a4[K\u00d2\u00e6\u00f1\u0091\u008e\u00fb8\u0015J\u001f.\u00a4\u0013\u00c3\u0091)b\u000f6\u00f5\u0094\u000e\u000b\u00d8\u00a2{\u00f4`sL\u008f\u00ebKW\u00fa\u0084L\u00c5\u00a5(p".length();
                var1_4 = 12;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "-\u00c0\u00b3\u0001.\u00f66\u00e9&\u0089^\u0012\u00bf\u00da4\u00f3/\u00ab1\u008b\u00b7)kHv\u0085,\n}\u00df1\u00bfp\u009c$\u00bf\u00bc:\u0081\u001a\u0088e\u00f8;\u008d\u00ab\u00cfH\u0013\u0005\u00bb2\u0016'\u009e\u0087}\u009c\u00ce\u00d9VT\u009a>'\u00b3";
                    var4_3 = "-\u00c0\u00b3\u0001.\u00f66\u00e9&\u0089^\u0012\u00bf\u00da4\u00f3/\u00ab1\u008b\u00b7)kHv\u0085,\n}\u00df1\u00bfp\u009c$\u00bf\u00bc:\u0081\u001a\u0088e\u00f8;\u008d\u00ab\u00cfH\u0013\u0005\u00bb2\u0016'\u009e\u0087}\u009c\u00ce\u00d9VT\u009a>'\u00b3".length();
                    var1_4 = 39;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 78;
                            break;
                        }
                        case 1: {
                            v13 = 55;
                            break;
                        }
                        case 2: {
                            v13 = 44;
                            break;
                        }
                        case 3: {
                            v13 = 93;
                            break;
                        }
                        case 4: {
                            v13 = 70;
                            break;
                        }
                        case 5: {
                            v13 = 121;
                            break;
                        }
                        default: {
                            v13 = 6;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        ECParameters.f = var5;
        ECParameters.g = new String[15];
        ECParameters.a = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 10045, 1, 1});
        ECParameters.b = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 10045, 1, 2});
        ECParameters.c = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 10045, 1, 2, 3, 2});
        ECParameters.d = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 10045, 1, 2, 3, 1});
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0xFFFF91ED) & 0xFFFF;
        if (g[n4] == null) {
            int n5;
            int n6;
            char[] cArray = f[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 184;
                    break;
                }
                case 1: {
                    n6 = 32;
                    break;
                }
                case 2: {
                    n6 = 124;
                    break;
                }
                case 3: {
                    n6 = 220;
                    break;
                }
                case 4: {
                    n6 = 199;
                    break;
                }
                case 5: {
                    n6 = 93;
                    break;
                }
                case 6: {
                    n6 = 193;
                    break;
                }
                case 7: {
                    n6 = 52;
                    break;
                }
                case 8: {
                    n6 = 169;
                    break;
                }
                case 9: {
                    n6 = 38;
                    break;
                }
                case 10: {
                    n6 = 207;
                    break;
                }
                case 11: {
                    n6 = 87;
                    break;
                }
                case 12: {
                    n6 = 144;
                    break;
                }
                case 13: {
                    n6 = 111;
                    break;
                }
                case 14: {
                    n6 = 89;
                    break;
                }
                case 15: {
                    n6 = 248;
                    break;
                }
                case 16: {
                    n6 = 53;
                    break;
                }
                case 17: {
                    n6 = 172;
                    break;
                }
                case 18: {
                    n6 = 13;
                    break;
                }
                case 19: {
                    n6 = 227;
                    break;
                }
                case 20: {
                    n6 = 129;
                    break;
                }
                case 21: {
                    n6 = 118;
                    break;
                }
                case 22: {
                    n6 = 33;
                    break;
                }
                case 23: {
                    n6 = 210;
                    break;
                }
                case 24: {
                    n6 = 76;
                    break;
                }
                case 25: {
                    n6 = 119;
                    break;
                }
                case 26: {
                    n6 = 75;
                    break;
                }
                case 27: {
                    n6 = 133;
                    break;
                }
                case 28: {
                    n6 = 163;
                    break;
                }
                case 29: {
                    n6 = 98;
                    break;
                }
                case 30: {
                    n6 = 197;
                    break;
                }
                case 31: {
                    n6 = 235;
                    break;
                }
                case 32: {
                    n6 = 25;
                    break;
                }
                case 33: {
                    n6 = 2;
                    break;
                }
                case 34: {
                    n6 = 86;
                    break;
                }
                case 35: {
                    n6 = 31;
                    break;
                }
                case 36: {
                    n6 = 201;
                    break;
                }
                case 37: {
                    n6 = 20;
                    break;
                }
                case 38: {
                    n6 = 165;
                    break;
                }
                case 39: {
                    n6 = 11;
                    break;
                }
                case 40: {
                    n6 = 122;
                    break;
                }
                case 41: {
                    n6 = 233;
                    break;
                }
                case 42: {
                    n6 = 107;
                    break;
                }
                case 43: {
                    n6 = 230;
                    break;
                }
                case 44: {
                    n6 = 246;
                    break;
                }
                case 45: {
                    n6 = 36;
                    break;
                }
                case 46: {
                    n6 = 252;
                    break;
                }
                case 47: {
                    n6 = 187;
                    break;
                }
                case 48: {
                    n6 = 153;
                    break;
                }
                case 49: {
                    n6 = 249;
                    break;
                }
                case 50: {
                    n6 = 200;
                    break;
                }
                case 51: {
                    n6 = 90;
                    break;
                }
                case 52: {
                    n6 = 54;
                    break;
                }
                case 53: {
                    n6 = 147;
                    break;
                }
                case 54: {
                    n6 = 10;
                    break;
                }
                case 55: {
                    n6 = 224;
                    break;
                }
                case 56: {
                    n6 = 115;
                    break;
                }
                case 57: {
                    n6 = 103;
                    break;
                }
                case 58: {
                    n6 = 7;
                    break;
                }
                case 59: {
                    n6 = 247;
                    break;
                }
                case 60: {
                    n6 = 26;
                    break;
                }
                case 61: {
                    n6 = 21;
                    break;
                }
                case 62: {
                    n6 = 225;
                    break;
                }
                case 63: {
                    n6 = 222;
                    break;
                }
                case 64: {
                    n6 = 120;
                    break;
                }
                case 65: {
                    n6 = 121;
                    break;
                }
                case 66: {
                    n6 = 1;
                    break;
                }
                case 67: {
                    n6 = 145;
                    break;
                }
                case 68: {
                    n6 = 149;
                    break;
                }
                case 69: {
                    n6 = 96;
                    break;
                }
                case 70: {
                    n6 = 88;
                    break;
                }
                case 71: {
                    n6 = 134;
                    break;
                }
                case 72: {
                    n6 = 3;
                    break;
                }
                case 73: {
                    n6 = 71;
                    break;
                }
                case 74: {
                    n6 = 40;
                    break;
                }
                case 75: {
                    n6 = 45;
                    break;
                }
                case 76: {
                    n6 = 183;
                    break;
                }
                case 77: {
                    n6 = 238;
                    break;
                }
                case 78: {
                    n6 = 170;
                    break;
                }
                case 79: {
                    n6 = 105;
                    break;
                }
                case 80: {
                    n6 = 24;
                    break;
                }
                case 81: {
                    n6 = 141;
                    break;
                }
                case 82: {
                    n6 = 22;
                    break;
                }
                case 83: {
                    n6 = 99;
                    break;
                }
                case 84: {
                    n6 = 164;
                    break;
                }
                case 85: {
                    n6 = 126;
                    break;
                }
                case 86: {
                    n6 = 127;
                    break;
                }
                case 87: {
                    n6 = 189;
                    break;
                }
                case 88: {
                    n6 = 251;
                    break;
                }
                case 89: {
                    n6 = 130;
                    break;
                }
                case 90: {
                    n6 = 231;
                    break;
                }
                case 91: {
                    n6 = 168;
                    break;
                }
                case 92: {
                    n6 = 65;
                    break;
                }
                case 93: {
                    n6 = 250;
                    break;
                }
                case 94: {
                    n6 = 214;
                    break;
                }
                case 95: {
                    n6 = 237;
                    break;
                }
                case 96: {
                    n6 = 139;
                    break;
                }
                case 97: {
                    n6 = 177;
                    break;
                }
                case 98: {
                    n6 = 108;
                    break;
                }
                case 99: {
                    n6 = 0;
                    break;
                }
                case 100: {
                    n6 = 82;
                    break;
                }
                case 101: {
                    n6 = 221;
                    break;
                }
                case 102: {
                    n6 = 208;
                    break;
                }
                case 103: {
                    n6 = 150;
                    break;
                }
                case 104: {
                    n6 = 204;
                    break;
                }
                case 105: {
                    n6 = 137;
                    break;
                }
                case 106: {
                    n6 = 61;
                    break;
                }
                case 107: {
                    n6 = 39;
                    break;
                }
                case 108: {
                    n6 = 16;
                    break;
                }
                case 109: {
                    n6 = 219;
                    break;
                }
                case 110: {
                    n6 = 194;
                    break;
                }
                case 111: {
                    n6 = 46;
                    break;
                }
                case 112: {
                    n6 = 171;
                    break;
                }
                case 113: {
                    n6 = 253;
                    break;
                }
                case 114: {
                    n6 = 79;
                    break;
                }
                case 115: {
                    n6 = 173;
                    break;
                }
                case 116: {
                    n6 = 41;
                    break;
                }
                case 117: {
                    n6 = 69;
                    break;
                }
                case 118: {
                    n6 = 213;
                    break;
                }
                case 119: {
                    n6 = 80;
                    break;
                }
                case 120: {
                    n6 = 58;
                    break;
                }
                case 121: {
                    n6 = 142;
                    break;
                }
                case 122: {
                    n6 = 15;
                    break;
                }
                case 123: {
                    n6 = 188;
                    break;
                }
                case 124: {
                    n6 = 47;
                    break;
                }
                case 125: {
                    n6 = 106;
                    break;
                }
                case 126: {
                    n6 = 138;
                    break;
                }
                case 127: {
                    n6 = 113;
                    break;
                }
                case 128: {
                    n6 = 174;
                    break;
                }
                case 129: {
                    n6 = 8;
                    break;
                }
                case 130: {
                    n6 = 12;
                    break;
                }
                case 131: {
                    n6 = 202;
                    break;
                }
                case 132: {
                    n6 = 112;
                    break;
                }
                case 133: {
                    n6 = 23;
                    break;
                }
                case 134: {
                    n6 = 206;
                    break;
                }
                case 135: {
                    n6 = 94;
                    break;
                }
                case 136: {
                    n6 = 125;
                    break;
                }
                case 137: {
                    n6 = 116;
                    break;
                }
                case 138: {
                    n6 = 240;
                    break;
                }
                case 139: {
                    n6 = 100;
                    break;
                }
                case 140: {
                    n6 = 85;
                    break;
                }
                case 141: {
                    n6 = 155;
                    break;
                }
                case 142: {
                    n6 = 185;
                    break;
                }
                case 143: {
                    n6 = 19;
                    break;
                }
                case 144: {
                    n6 = 29;
                    break;
                }
                case 145: {
                    n6 = 50;
                    break;
                }
                case 146: {
                    n6 = 110;
                    break;
                }
                case 147: {
                    n6 = 62;
                    break;
                }
                case 148: {
                    n6 = 123;
                    break;
                }
                case 149: {
                    n6 = 109;
                    break;
                }
                case 150: {
                    n6 = 175;
                    break;
                }
                case 151: {
                    n6 = 239;
                    break;
                }
                case 152: {
                    n6 = 83;
                    break;
                }
                case 153: {
                    n6 = 51;
                    break;
                }
                case 154: {
                    n6 = 70;
                    break;
                }
                case 155: {
                    n6 = 160;
                    break;
                }
                case 156: {
                    n6 = 244;
                    break;
                }
                case 157: {
                    n6 = 229;
                    break;
                }
                case 158: {
                    n6 = 198;
                    break;
                }
                case 159: {
                    n6 = 254;
                    break;
                }
                case 160: {
                    n6 = 151;
                    break;
                }
                case 161: {
                    n6 = 5;
                    break;
                }
                case 162: {
                    n6 = 132;
                    break;
                }
                case 163: {
                    n6 = 114;
                    break;
                }
                case 164: {
                    n6 = 57;
                    break;
                }
                case 165: {
                    n6 = 215;
                    break;
                }
                case 166: {
                    n6 = 84;
                    break;
                }
                case 167: {
                    n6 = 34;
                    break;
                }
                case 168: {
                    n6 = 30;
                    break;
                }
                case 169: {
                    n6 = 218;
                    break;
                }
                case 170: {
                    n6 = 211;
                    break;
                }
                case 171: {
                    n6 = 190;
                    break;
                }
                case 172: {
                    n6 = 162;
                    break;
                }
                case 173: {
                    n6 = 179;
                    break;
                }
                case 174: {
                    n6 = 209;
                    break;
                }
                case 175: {
                    n6 = 27;
                    break;
                }
                case 176: {
                    n6 = 104;
                    break;
                }
                case 177: {
                    n6 = 176;
                    break;
                }
                case 178: {
                    n6 = 243;
                    break;
                }
                case 179: {
                    n6 = 152;
                    break;
                }
                case 180: {
                    n6 = 135;
                    break;
                }
                case 181: {
                    n6 = 97;
                    break;
                }
                case 182: {
                    n6 = 63;
                    break;
                }
                case 183: {
                    n6 = 95;
                    break;
                }
                case 184: {
                    n6 = 255;
                    break;
                }
                case 185: {
                    n6 = 196;
                    break;
                }
                case 186: {
                    n6 = 241;
                    break;
                }
                case 187: {
                    n6 = 14;
                    break;
                }
                case 188: {
                    n6 = 55;
                    break;
                }
                case 189: {
                    n6 = 191;
                    break;
                }
                case 190: {
                    n6 = 37;
                    break;
                }
                case 191: {
                    n6 = 78;
                    break;
                }
                case 192: {
                    n6 = 42;
                    break;
                }
                case 193: {
                    n6 = 203;
                    break;
                }
                case 194: {
                    n6 = 226;
                    break;
                }
                case 195: {
                    n6 = 73;
                    break;
                }
                case 196: {
                    n6 = 242;
                    break;
                }
                case 197: {
                    n6 = 128;
                    break;
                }
                case 198: {
                    n6 = 72;
                    break;
                }
                case 199: {
                    n6 = 43;
                    break;
                }
                case 200: {
                    n6 = 67;
                    break;
                }
                case 201: {
                    n6 = 81;
                    break;
                }
                case 202: {
                    n6 = 186;
                    break;
                }
                case 203: {
                    n6 = 154;
                    break;
                }
                case 204: {
                    n6 = 192;
                    break;
                }
                case 205: {
                    n6 = 44;
                    break;
                }
                case 206: {
                    n6 = 18;
                    break;
                }
                case 207: {
                    n6 = 102;
                    break;
                }
                case 208: {
                    n6 = 232;
                    break;
                }
                case 209: {
                    n6 = 223;
                    break;
                }
                case 210: {
                    n6 = 157;
                    break;
                }
                case 211: {
                    n6 = 140;
                    break;
                }
                case 212: {
                    n6 = 66;
                    break;
                }
                case 213: {
                    n6 = 156;
                    break;
                }
                case 214: {
                    n6 = 101;
                    break;
                }
                case 215: {
                    n6 = 148;
                    break;
                }
                case 216: {
                    n6 = 143;
                    break;
                }
                case 217: {
                    n6 = 195;
                    break;
                }
                case 218: {
                    n6 = 91;
                    break;
                }
                case 219: {
                    n6 = 166;
                    break;
                }
                case 220: {
                    n6 = 161;
                    break;
                }
                case 221: {
                    n6 = 182;
                    break;
                }
                case 222: {
                    n6 = 17;
                    break;
                }
                case 223: {
                    n6 = 131;
                    break;
                }
                case 224: {
                    n6 = 77;
                    break;
                }
                case 225: {
                    n6 = 236;
                    break;
                }
                case 226: {
                    n6 = 217;
                    break;
                }
                case 227: {
                    n6 = 92;
                    break;
                }
                case 228: {
                    n6 = 74;
                    break;
                }
                case 229: {
                    n6 = 6;
                    break;
                }
                case 230: {
                    n6 = 68;
                    break;
                }
                case 231: {
                    n6 = 4;
                    break;
                }
                case 232: {
                    n6 = 146;
                    break;
                }
                case 233: {
                    n6 = 216;
                    break;
                }
                case 234: {
                    n6 = 228;
                    break;
                }
                case 235: {
                    n6 = 136;
                    break;
                }
                case 236: {
                    n6 = 117;
                    break;
                }
                case 237: {
                    n6 = 59;
                    break;
                }
                case 238: {
                    n6 = 28;
                    break;
                }
                case 239: {
                    n6 = 180;
                    break;
                }
                case 240: {
                    n6 = 245;
                    break;
                }
                case 241: {
                    n6 = 158;
                    break;
                }
                case 242: {
                    n6 = 56;
                    break;
                }
                case 243: {
                    n6 = 212;
                    break;
                }
                case 244: {
                    n6 = 9;
                    break;
                }
                case 245: {
                    n6 = 178;
                    break;
                }
                case 246: {
                    n6 = 64;
                    break;
                }
                case 247: {
                    n6 = 205;
                    break;
                }
                case 248: {
                    n6 = 234;
                    break;
                }
                case 249: {
                    n6 = 181;
                    break;
                }
                case 250: {
                    n6 = 48;
                    break;
                }
                case 251: {
                    n6 = 60;
                    break;
                }
                case 252: {
                    n6 = 159;
                    break;
                }
                case 253: {
                    n6 = 49;
                    break;
                }
                case 254: {
                    n6 = 167;
                    break;
                }
                default: {
                    n6 = 35;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            ECParameters.g[n4] = new String(cArray).intern();
        }
        return g[n4];
    }
}

