/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Map;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.DerValue;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.ObjectIdentifier;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec.ECParameters;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec.NamedCurve;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.AsymmKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECKeyTemplate;

public class ECPublicKeyTemplate
extends ECKeyTemplate {
    protected ECPublicKey ecPublicKey;

    public ECPublicKeyTemplate(String label, ECParameterSpec ecParameterSpec) throws SmartCardException {
        super(label, ecParameterSpec);
        this.a();
        this.initECParamsAttribute(ecParameterSpec);
    }

    public ECPublicKeyTemplate(String keyLabel, ECParameterSpec parameterSpec, ECPublicKey ecPublicKey) throws SmartCardException {
        this(keyLabel, parameterSpec);
        this.ecPublicKey = ecPublicKey;
        this.a(ecPublicKey);
    }

    public ECPublicKeyTemplate(String keyLabel, ECParameterSpec parameterSpec, PublicKey aPublic) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, IOException, SmartCardException {
        this(keyLabel, parameterSpec);
        this.ecPublicKey = this.getECPublicKey(aPublic);
        this.a(this.ecPublicKey);
    }

    private void a() {
        this.add(new CK_ATTRIBUTE(0L, 2L));
        this.add(new CK_ATTRIBUTE(2L, false));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(ECPublicKey eCPublicKey) {
        this.initECParamsAttribute((ECParameterSpec)this.spec);
        this.initECPointAttribute(eCPublicKey.getW(), (ECParameterSpec)this.spec);
        boolean bl = ECKeyTemplate.d;
        this.initIDAttribute(eCPublicKey);
        boolean bl2 = false;
        ECParameterSpec eCParameterSpec = (ECParameterSpec)this.spec;
        if (eCParameterSpec instanceof NamedCurve) {
            bl2 = true;
            Map<String, NamedCurve> map = NamedCurve.getNameCurves();
            ObjectIdentifier objectIdentifier = ((NamedCurve)eCParameterSpec).getObjectIdentifier();
            for (NamedCurve namedCurve : map.values()) {
                if (namedCurve.getObjectIdentifier().toString().equals(objectIdentifier.toString())) {
                    bl2 = false;
                    if (!bl) break;
                }
                if (!bl) continue;
            }
        }
        if (!bl2) return;
        this.add(new CK_ATTRIBUTE(2L, bl2));
    }

    @Override
    public ECKeyTemplate getAsSecretECCurve(boolean isSecretECCurve) {
        block4: {
            super.getAsSecretECCurve(isSecretECCurve);
            if (!isSecretECCurve || this.ecPublicKey == null) break block4;
            this.initECPointAttribute(this.ecPublicKey.getW(), (ECParameterSpec)this.spec);
        }
        return this;
    }

    protected ECKeyTemplate initECPointAttribute(ECPoint ecpoint, ECParameterSpec spec) {
        byte[] byArray = ECParameters.encodePoint(ecpoint, spec.getCurve(), this.secretECCurve);
        DerValue derValue = new DerValue(4, byArray);
        try {
            this.add(new CK_ATTRIBUTE(385L, derValue.toByteArray()));
        }
        catch (IOException iOException) {
            throw new ESYARuntimeException(iOException);
        }
        return this;
    }

    public ECKeyTemplate getAsVerifierTemplate() {
        this.add(new CK_ATTRIBUTE(266L, true));
        return this;
    }

    public ECKeyTemplate getAsEcnryptorTemplate() {
        this.add(new CK_ATTRIBUTE(260L, true));
        return this;
    }

    public ECPublicKeyTemplate getAsTokenTemplate(boolean verify, boolean encrypt, boolean isWrap) {
        ECPublicKeyTemplate eCPublicKeyTemplate;
        block4: {
            boolean bl;
            block6: {
                block5: {
                    this.add(new CK_ATTRIBUTE(1L, true));
                    this.add(new CK_ATTRIBUTE(260L, encrypt));
                    boolean bl2 = ECKeyTemplate.d;
                    this.add(new CK_ATTRIBUTE(268L, encrypt));
                    this.add(new CK_ATTRIBUTE(266L, verify));
                    this.add(new CK_ATTRIBUTE(262L, isWrap));
                    eCPublicKeyTemplate = this;
                    if (SmartCardException.b == 0) break block4;
                    if (!bl2) break block5;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
            ECKeyTemplate.d = bl;
        }
        return eCPublicKeyTemplate;
    }

    public ECPublicKey getEcPublicKey() {
        return this.ecPublicKey;
    }

    @Override
    public AsymmKeyTemplate.KeyType getKeyType() {
        return AsymmKeyTemplate.KeyType.PUBLIC;
    }
}

