/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAKeyGenParameterSpec;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import tr.gov.tubitak.uekae.esya.api.common.util.BigIntegerUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.AsymmKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAKeyTemplate;

public class RSAPrivateKeyTemplate
extends RSAKeyTemplate
implements RSAPrivateKey {
    public RSAPrivateKeyTemplate(String label, RSAKeyGenParameterSpec spec) {
        super(label, spec);
        this.add(new CK_ATTRIBUTE(0L, 3L));
        this.add(new CK_ATTRIBUTE(2L, true));
    }

    public RSAPrivateKeyTemplate(String label, RSAPrivateCrtKey privKey, X509Certificate certificate) {
        this(label, new RSAKeyGenParameterSpec(privKey.getModulus().bitLength(), privKey.getPublicExponent()));
        this.encoded = privKey.getEncoded();
        int n2 = RSAKeyTemplate.d;
        byte[] byArray = BigIntegerUtil.toByteArrayWithoutSignByte(privKey.getModulus());
        byte[] byArray2 = BigIntegerUtil.toByteArrayWithoutSignByte(privKey.getPublicExponent());
        byte[] byArray3 = BigIntegerUtil.toByteArrayWithoutSignByte(privKey.getPrivateExponent());
        byte[] byArray4 = BigIntegerUtil.toByteArrayWithoutSignByte(privKey.getPrimeP());
        byte[] byArray5 = BigIntegerUtil.toByteArrayWithoutSignByte(privKey.getPrimeQ());
        byte[] byArray6 = BigIntegerUtil.toByteArrayWithoutSignByte(privKey.getPrimeExponentP());
        byte[] byArray7 = BigIntegerUtil.toByteArrayWithoutSignByte(privKey.getPrimeExponentQ());
        byte[] byArray8 = BigIntegerUtil.toByteArrayWithoutSignByte(privKey.getCrtCoefficient());
        this.OZET_ALICI.update(byArray);
        byte[] byArray9 = this.OZET_ALICI.digest();
        this.add(new CK_ATTRIBUTE(259L, true));
        this.add(new CK_ATTRIBUTE(354L, false));
        this.add(new CK_ATTRIBUTE(288L, byArray));
        this.add(new CK_ATTRIBUTE(290L, byArray2));
        this.add(new CK_ATTRIBUTE(291L, byArray3));
        this.add(new CK_ATTRIBUTE(292L, byArray4));
        this.add(new CK_ATTRIBUTE(293L, byArray5));
        this.add(new CK_ATTRIBUTE(294L, byArray6));
        this.add(new CK_ATTRIBUTE(295L, byArray7));
        this.add(new CK_ATTRIBUTE(296L, byArray8));
        this.add(new CK_ATTRIBUTE(258L, byArray9));
        if (certificate != null) {
            byte[] byArray10 = certificate.getSubjectX500Principal().getEncoded();
            this.add(new CK_ATTRIBUTE(257L, byArray10));
        }
        if (n2 != 0) {
            int n3 = SmartCardException.b;
            SmartCardException.b = ++n3;
        }
    }

    public RSAPrivateKeyTemplate getAsTokenTemplate(boolean sign, boolean decrypt, boolean isUnwrap) {
        this.add(new CK_ATTRIBUTE(1L, true));
        this.add(new CK_ATTRIBUTE(259L, true));
        this.add(new CK_ATTRIBUTE(354L, false));
        this.add(new CK_ATTRIBUTE(261L, decrypt));
        this.add(new CK_ATTRIBUTE(264L, sign));
        this.add(new CK_ATTRIBUTE(265L, sign));
        this.add(new CK_ATTRIBUTE(263L, isUnwrap));
        return this;
    }

    public RSAPrivateKeyTemplate getAsUnwrapperTemplate() {
        return (RSAPrivateKeyTemplate)this.add(new CK_ATTRIBUTE(1L, false)).add(new CK_ATTRIBUTE(263L, true));
    }

    @Override
    public BigInteger getPrivateExponent() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return this.encoded;
    }

    @Override
    public AsymmKeyTemplate.KeyType getKeyType() {
        return AsymmKeyTemplate.KeyType.PRIVATE;
    }
}

