/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa;

import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAKeyGenParameterSpec;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import tr.gov.tubitak.uekae.esya.api.common.util.BigIntegerUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.AsymmKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAKeyTemplate;

public class RSAPublicKeyTemplate
extends RSAKeyTemplate
implements RSAPublicKey {
    private BigInteger c;

    public RSAPublicKeyTemplate(String label, RSAKeyGenParameterSpec spec) {
        super(label, spec);
        this.c = spec.getPublicExponent();
        if (this.c == null) {
            this.c = RSAKeyGenParameterSpec.F4;
        }
        this.add(new CK_ATTRIBUTE(0L, 2L));
        this.add(new CK_ATTRIBUTE(2L, false));
        this.add(new CK_ATTRIBUTE(290L, BigIntegerUtil.toByteArrayWithoutSignByte(this.c)));
        this.add(new CK_ATTRIBUTE(289L, spec.getKeysize()));
    }

    public RSAPublicKeyTemplate(String label, RSAPublicKey publicKey) {
        super(label, new RSAKeyGenParameterSpec(publicKey.getModulus().bitLength(), publicKey.getPublicExponent()));
        int n2 = RSAKeyTemplate.d;
        this.modulus = publicKey.getModulus();
        this.c = ((RSAKeyGenParameterSpec)this.spec).getPublicExponent();
        if (this.c == null) {
            this.c = RSAKeyGenParameterSpec.F4;
        }
        this.add(new CK_ATTRIBUTE(0L, 2L));
        this.add(new CK_ATTRIBUTE(2L, false));
        this.add(new CK_ATTRIBUTE(290L, BigIntegerUtil.toByteArrayWithoutSignByte(this.c)));
        byte[] byArray = BigIntegerUtil.toByteArrayWithoutSignByte(this.modulus);
        this.OZET_ALICI.update(byArray);
        byte[] byArray2 = this.OZET_ALICI.digest();
        this.add(new CK_ATTRIBUTE(288L, byArray));
        this.add(new CK_ATTRIBUTE(258L, byArray2));
        if (SmartCardException.b != 0) {
            RSAKeyTemplate.d = ++n2;
        }
    }

    @Override
    public BigInteger getPublicExponent() {
        return ((RSAKeyGenParameterSpec)this.getSpec()).getPublicExponent();
    }

    public RSAPublicKeyTemplate getAsTokenTemplate(boolean verify, boolean encrypt, boolean isWrap) {
        this.add(new CK_ATTRIBUTE(1L, true));
        this.add(new CK_ATTRIBUTE(260L, encrypt));
        this.add(new CK_ATTRIBUTE(266L, verify));
        this.add(new CK_ATTRIBUTE(267L, verify));
        this.add(new CK_ATTRIBUTE(262L, isWrap));
        return this;
    }

    public RSAPublicKeyTemplate getAsWrapperTemplate() {
        return (RSAPublicKeyTemplate)this.add(new CK_ATTRIBUTE(1L, false)).add(new CK_ATTRIBUTE(262L, true));
    }

    @Override
    public AsymmKeyTemplate.KeyType getKeyType() {
        return AsymmKeyTemplate.KeyType.PUBLIC;
    }
}

