/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops;

import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1OctetString;
import gnu.crypto.key.ecdsa.ECDSAKeyPairX509Codec;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECDomainParameter;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECGNUPoint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.asn.scencryptedpackage.ESCObject;
import tr.gov.tubitak.uekae.esya.api.asn.scencryptedpackage.ESCObjectAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.scencryptedpackage.ESCObjectBag;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.DerValue;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.ObjectIdentifier;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.util.ArrayUtil;
import tr.gov.tubitak.uekae.esya.api.common.util.ByteConversionUtil;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.object.ObjectResult;
import tr.gov.tubitak.uekae.esya.api.smartcard.object.UnwrapObjectsResults;
import tr.gov.tubitak.uekae.esya.api.smartcard.object.WrappedObjectsWithAttributes;
import tr.gov.tubitak.uekae.esya.api.smartcard.object.util.SCObjectUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.PKCS11ExceptionFactory;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.PKCS11Names;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec.ECParameters;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec.NamedCurve;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.KeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.KeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECKeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECPrivateKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECPublicKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAKeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAPrivateKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAPublicKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.symmetric.SecretKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.DirakLibOps;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.ESYAPKCS11;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.IPKCS11Ops;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.PKCS11LibOps;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.key.SecretKey;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.util.OpsUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.ICardTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.util.AttributeUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.util.ECUtil;

public class PKCS11Ops
implements IPKCS11Ops {
    private Logger a = LoggerFactory.getLogger(PKCS11Ops.class);
    protected PKCS11LibOps pkcs11LibOps;
    protected PKCS11 mPKCS11;
    private CardType b;
    protected MessageDigest OZET_ALICI;
    protected ESYAPKCS11 mESYAPKCS11 = null;
    public static int c;
    private static final String[] e;
    private static final String[] f;

    public PKCS11Ops(CardType aKartTip) {
        try {
            this.OZET_ALICI = MessageDigest.getInstance(PKCS11Ops.a(17474, 28582));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.a.error(PKCS11Ops.a(17526, 13781), noSuchAlgorithmException);
            throw new RuntimeException(noSuchAlgorithmException);
        }
        this.b = aKartTip;
    }

    @Override
    public void initialize() throws PKCS11Exception, IOException {
        try {
            CK_C_INITIALIZE_ARGS cK_C_INITIALIZE_ARGS = this.a();
            String string = OpsUtil.getLibPath(this.b.getLibName());
            this.mPKCS11 = PKCS11.getInstance(string, PKCS11Ops.a(17498, 25708), cK_C_INITIALIZE_ARGS, false);
        }
        catch (Exception exception) {
            throw new IOException(PKCS11Ops.a(17512, -8549), exception);
        }
    }

    CK_C_INITIALIZE_ARGS a() {
        return null;
    }

    private PKCS11LibOps b() {
        if (this.pkcs11LibOps == null) {
            return new PKCS11LibOps(this.b);
        }
        return this.pkcs11LibOps;
    }

    @Override
    public long[] getTokenPresentSlotList() throws PKCS11Exception {
        return this.mPKCS11.C_GetSlotList(true);
    }

    @Override
    public List<Pair<Long, String>> getTokenPresentSlotListWithDescription() throws PKCS11Exception {
        long[] lArray = this.getTokenPresentSlotList();
        ArrayList<Pair<Long, String>> arrayList = new ArrayList<Pair<Long, String>>();
        long[] lArray2 = lArray;
        int n2 = lArray2.length;
        int n3 = c;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray2[i2];
            String string = "";
            try {
                string = string + " " + new String(this.getSlotInfo((long)l2).slotDescription).trim();
            }
            catch (Exception exception) {
                this.a.info(PKCS11Ops.a(17521, 2107) + exception.getMessage(), exception);
            }
            try {
                string = string + " " + new String(this.getTokenInfo((long)l2).label).trim().split("\u0000")[0];
            }
            catch (Exception exception) {
                this.a.info(PKCS11Ops.a(17485, -13238) + exception.getMessage(), exception);
            }
            arrayList.add(new Pair<Long, String>(l2, string));
            if (n3 == 0) continue;
        }
        return arrayList;
    }

    @Override
    public long[] getSlotList() throws PKCS11Exception {
        return this.mPKCS11.C_GetSlotList(false);
    }

    @Override
    public CK_SLOT_INFO getSlotInfo(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_GetSlotInfo(aSlotID);
    }

    @Override
    public CK_SESSION_INFO getSessionInfo(long aSessionID) throws PKCS11Exception {
        return this.mPKCS11.C_GetSessionInfo(aSessionID);
    }

    @Override
    public boolean isTokenPresent(long aSlotID) throws PKCS11Exception {
        CK_SLOT_INFO cK_SLOT_INFO = this.mPKCS11.C_GetSlotInfo(aSlotID);
        long l2 = cK_SLOT_INFO.flags;
        if ((l2 & 1L) != 0L) {
            return true;
        }
        return false;
    }

    @Override
    public CK_TOKEN_INFO getTokenInfo(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_GetTokenInfo(aSlotID);
    }

    @Override
    public long[] getMechanismList(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_GetMechanismList(aSlotID);
    }

    @Override
    public long openSession(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_OpenSession(aSlotID, 6L, null, null);
    }

    @Override
    public void closeSession(long aSessionID) throws PKCS11Exception {
        this.mPKCS11.C_CloseSession(aSessionID);
    }

    @Override
    public void login(long aSessionID, String aCardPIN) throws PKCS11Exception {
        this.mPKCS11.C_Login(aSessionID, 1L, aCardPIN.toCharArray());
    }

    @Override
    public void logout(long aSessionID) throws PKCS11Exception {
        this.mPKCS11.C_Logout(aSessionID);
    }

    @Override
    public boolean isAnyObjectExist(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            return false;
        }
        return true;
    }

    @Override
    public void importCertificate(long aSessionID, String aCertLabel, X509Certificate aSertifika) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.b.getCardTemplate().getCertificateTemplate(aCertLabel, aSertifika);
        this.mPKCS11.C_CreateObject(aSessionID, list.toArray(new CK_ATTRIBUTE[0]));
    }

    private long[] a(long l2, String string, RSAKeyGenParameterSpec rSAKeyGenParameterSpec, boolean bl, boolean bl2) throws PKCS11Exception {
        CK_MECHANISM cK_MECHANISM;
        block12: {
            block11: {
                cK_MECHANISM = new CK_MECHANISM(0L);
                cK_MECHANISM.mechanism = 10L;
                cK_MECHANISM.pParameter = null;
                if (this.b == CardType.AKIS || this.b == CardType.ATIKHSM) break block11;
                if (this.b == CardType.DIRAKHSM) break block11;
                if (this.b == CardType.OPENDNSSOFTHSM) break block11;
                if (this.b != CardType.PROCENNEHSM) break block12;
            }
            cK_MECHANISM.mechanism = 0L;
        }
        int n2 = rSAKeyGenParameterSpec.getKeysize();
        BigInteger bigInteger = rSAKeyGenParameterSpec.getPublicExponent();
        if (bigInteger == null) {
            bigInteger = RSAKeyGenParameterSpec.F4;
        }
        ICardTemplate iCardTemplate = this.b.getCardTemplate();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = iCardTemplate.getRSAPublicKeyCreateTemplate(string, n2, bigInteger, bl, bl2).toArray(new CK_ATTRIBUTE[0]);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = iCardTemplate.getRSAPrivateKeyCreateTemplate(string, bl, bl2).toArray(new CK_ATTRIBUTE[0]);
        long[] lArray = this.mPKCS11.C_GenerateKeyPair(l2, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        this.a(l2, string);
        return lArray;
    }

    @Override
    @Deprecated
    public long[] createKeyPair(long aSessionID, String aKeyLabel, AlgorithmParameterSpec aParamSpec, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        if (aParamSpec instanceof RSAKeyGenParameterSpec) {
            return this.a(aSessionID, aKeyLabel, (RSAKeyGenParameterSpec)aParamSpec, aIsSign, aIsEncrypt);
        }
        if (aParamSpec instanceof ECParameterSpec) {
            return this.a(aSessionID, aKeyLabel, (ECParameterSpec)aParamSpec, aIsSign, aIsEncrypt);
        }
        if (aParamSpec instanceof ECGenParameterSpec) {
            ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)aParamSpec;
            ECParameterSpec eCParameterSpec = NamedCurve.getECParameterSpec(eCGenParameterSpec.getName());
            if (eCParameterSpec == null) {
                throw new SmartCardException(PKCS11Ops.a(17487, 18330));
            }
            return this.a(aSessionID, aKeyLabel, eCParameterSpec, aIsSign, aIsEncrypt);
        }
        throw new SmartCardException(PKCS11Ops.a(17478, 27911));
    }

    private long[] a(long l2, String string, ECParameterSpec eCParameterSpec, boolean bl, boolean bl2) throws PKCS11Exception, IOException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = 4160L;
        cK_MECHANISM.pParameter = null;
        byte[] byArray = ECParameters.encodeParameters(eCParameterSpec);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, false), new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(260L, bl2), new CK_ATTRIBUTE(266L, bl), new CK_ATTRIBUTE(384L, byArray), new CK_ATTRIBUTE(3L, string)};
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(261L, bl2), new CK_ATTRIBUTE(264L, bl), new CK_ATTRIBUTE(3L, string)};
        long[] lArray = this.mPKCS11.C_GenerateKeyPair(l2, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray3 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray2 = this.objeAra(l2, cK_ATTRIBUTEArray3);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray4 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L)};
        this.mPKCS11.C_GetAttributeValue(l2, lArray2[0], cK_ATTRIBUTEArray4);
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray4[0].pValue;
        byte[] byArray3 = this.b.getCardTemplate().getPointValue(byArray2);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray5 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string)};
        long[] lArray3 = this.objeAra(l2, cK_ATTRIBUTEArray5);
        byte[] byArray4 = this.OZET_ALICI.digest(byArray3);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray6 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray4)};
        this.mPKCS11.C_SetAttributeValue(l2, lArray3[0], cK_ATTRIBUTEArray6);
        this.mPKCS11.C_SetAttributeValue(l2, lArray3[1], cK_ATTRIBUTEArray6);
        return lArray;
    }

    @Override
    public long createSecretKey(long aSessionID, SecretKey aKey) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.b.getCardTemplate().getSecretKeyCreateTemplate(aKey);
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aKey.getGenerationMechanism();
        cK_MECHANISM.pParameter = null;
        return this.mPKCS11.C_GenerateKey(aSessionID, cK_MECHANISM, list.toArray(new CK_ATTRIBUTE[0]));
    }

    @Override
    public long importSecretKey(long aSessionId, SecretKey aKey) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.b.getCardTemplate().getSecretKeyImportTemplate(aKey);
        return this.mPKCS11.C_CreateObject(aSessionId, list.toArray(new CK_ATTRIBUTE[0]));
    }

    @Override
    public long importSecretKey(long aSessionId, SecretKeyTemplate aKeyTemplate) throws PKCS11Exception, SmartCardException {
        this.b.getCardTemplate().applyTemplate(aKeyTemplate);
        return this.mPKCS11.C_CreateObject(aSessionId, aKeyTemplate.getAttributesAsArr());
    }

    @Override
    public byte[] signDataWithKeyID(long aSessionID, long aKeyID, CK_MECHANISM aMechanism, byte[] aImzalanacak) throws PKCS11Exception {
        this.mPKCS11.C_SignInit(aSessionID, aMechanism, aKeyID);
        byte[] byArray = this.mPKCS11.C_Sign(aSessionID, aImzalanacak);
        return byArray;
    }

    @Override
    public byte[] signDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aImzalanacak) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aSessionID, aSerialNumber);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(258L, byArray), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(1L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(PKCS11Ops.a(17508, -18912));
        }
        this.mPKCS11.C_SignInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray2 = this.mPKCS11.C_Sign(aSessionID, aImzalanacak);
        return byArray2;
    }

    private byte[] a(long l2, byte[] byArray) throws PKCS11Exception, SmartCardException {
        long[] lArray;
        block8: {
            List<List<CK_ATTRIBUTE>> list = this.b.getCardTemplate().getCertSerialNumberTemplates(byArray);
            int n2 = c;
            lArray = null;
            for (List<CK_ATTRIBUTE> object2 : list) {
                lArray = this.objeAra(l2, object2.toArray(new CK_ATTRIBUTE[0]));
                if (lArray.length > 0) {
                    break;
                }
                if (n2 == 0) continue;
            }
            if (lArray != null && lArray.length != 0) break block8;
            throw new SmartCardException(PKCS11Ops.a(17492, -16743));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
        this.mPKCS11.C_GetAttributeValue(l2, lArray[0], cK_ATTRIBUTEArray);
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray[0].pValue;
        return byArray2;
    }

    @Override
    public byte[] decryptDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aData) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.c(aMechanism.mechanism, aData);
        byte[] byArray2 = this.b(aSessionID, aSerialNumber);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(258L, byArray2), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(1L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(PKCS11Ops.a(17518, -30229));
        }
        byte[] byArray3 = new byte[1024];
        this.mPKCS11.C_DecryptInit(aSessionID, aMechanism, lArray[0]);
        int n2 = this.a(aSessionID, byArray, 0, byArray.length, byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray3, 0, byArray4, 0, n2);
        return byArray4;
    }

    private int a(long l2, byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) throws SmartCardException {
        try {
            return this.mPKCS11.C_Decrypt(l2, 0L, byArray, n2, n3, 0L, byArray2, n4, n5);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SmartCardException(pKCS11Exception);
        }
    }

    private byte[] b(long l2, byte[] byArray) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        long[] lArray;
        block8: {
            List<List<CK_ATTRIBUTE>> list = this.b.getCardTemplate().getCertSerialNumberTemplates(byArray);
            lArray = null;
            cK_ATTRIBUTEArray = list.iterator();
            int n2 = c;
            while (cK_ATTRIBUTEArray.hasNext()) {
                List<CK_ATTRIBUTE> list2 = cK_ATTRIBUTEArray.next();
                lArray = this.objeAra(l2, list2.toArray(new CK_ATTRIBUTE[0]));
                if (lArray.length > 0) {
                    break;
                }
                if (n2 == 0) continue;
            }
            if (lArray != null && lArray.length != 0) break block8;
            throw new SmartCardException(PKCS11Ops.a(17514, -18472));
        }
        cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
        this.mPKCS11.C_GetAttributeValue(l2, lArray[0], cK_ATTRIBUTEArray);
        return (byte[])cK_ATTRIBUTEArray[0].pValue;
    }

    @Override
    public List<byte[]> getSignatureCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.a(aSessionID, true);
    }

    @Override
    public List<byte[]> getEncryptionCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.a(aSessionID, false);
    }

    private List<byte[]> a(long l2, boolean bl) throws PKCS11Exception, SmartCardException {
        List<byte[]> list = this.getCertificates(l2);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n2 = c;
        for (byte[] byArray : list) {
            block15: {
                block17: {
                    Object object;
                    block16: {
                        X509Certificate x509Certificate = null;
                        try {
                            object = new ByteArrayInputStream(byArray);
                            CertificateFactory certificateFactory = CertificateFactory.getInstance(PKCS11Ops.a(17522, 10015));
                            x509Certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
                            ((InputStream)object).close();
                        }
                        catch (Exception exception) {
                            throw new SmartCardException(PKCS11Ops.a(17506, -3140) + StringUtil.toHexString(byArray), exception);
                        }
                        object = x509Certificate.getKeyUsage();
                        if (object == null) break block15;
                        if (!bl) break block16;
                        if (object[0] == false) break block15;
                        arrayList.add(byArray);
                        if (n2 == 0) break block15;
                    }
                    if (object[3] != false) break block17;
                    if (object[2] == false) break block15;
                }
                arrayList.add(byArray);
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    @Override
    public List<byte[]> getCertificates(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 1L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        long[] lArray2 = lArray;
        int n2 = lArray2.length;
        int n3 = c;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray2[i2];
            this.mPKCS11.C_GetAttributeValue(aSessionID, l2, cK_ATTRIBUTEArray2);
            byte[] byArray = (byte[])cK_ATTRIBUTEArray2[0].pValue;
            arrayList.add(byArray);
            if (n3 == 0) continue;
        }
        return arrayList;
    }

    @Override
    public String[] getSignatureKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(264L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    @Override
    public String[] getEncryptionKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(260L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    @Override
    public String[] getWrapperKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(262L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    @Override
    public String[] getUnwrapperKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(263L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    public String[] getLabels(long aSessionID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        long[] lArray = this.objeAra(aSessionID, aTemplate);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = c;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
        for (long l2 : lArray) {
            this.mPKCS11.C_GetAttributeValue(aSessionID, l2, cK_ATTRIBUTEArray);
            String string = AttributeUtil.getStringValue(cK_ATTRIBUTEArray[0].pValue);
            arrayList.add(string);
            if (n2 == 0) continue;
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public boolean isObjectExist(long aSessionID, String aLabel) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length > 0) {
            return true;
        }
        return false;
    }

    private boolean a(long l2, String string, long l3) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(0L, l3)};
        long[] lArray = this.objeAra(l2, cK_ATTRIBUTEArray);
        if (lArray.length > 0) {
            return true;
        }
        return false;
    }

    private void a(long l2, String string, byte[] byArray, boolean bl) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(17L, byArray), new CK_ATTRIBUTE(2L, bl)};
        this.mPKCS11.C_CreateObject(l2, cK_ATTRIBUTEArray);
    }

    @Override
    public void writePrivateData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.a(aSessionID, aLabel, aData, true);
    }

    @Override
    public void writePublicData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.a(aSessionID, aLabel, aData, false);
    }

    protected List<byte[]> _readData(long aSessionID, String aLabel, boolean aIsPrivate, long aDataType) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, aIsPrivate, true, aDataType);
    }

    protected List<byte[]> _readData(long aSessionID, String aLabel, boolean aIsPrivate, boolean aIstoken, long aDataType) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, aDataType), new CK_ATTRIBUTE(1L, aIstoken), new CK_ATTRIBUTE(2L, aIsPrivate), new CK_ATTRIBUTE(3L, aLabel)};
        int n2 = c;
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        int n3 = lArray.length;
        if (n3 == 0) {
            throw new SmartCardException(aLabel + PKCS11Ops.a(17477, -9717));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.mPKCS11.C_GetAttributeValue(aSessionID, lArray[i2], cK_ATTRIBUTEArray2);
            byte[] byArray = (byte[])cK_ATTRIBUTEArray2[0].pValue;
            arrayList.add(byArray);
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    @Override
    public List<byte[]> readPrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, true, 0L);
    }

    @Override
    public List<byte[]> readPublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, false, 0L);
    }

    @Override
    public boolean isPrivateKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.a(aSessionID, aLabel, 3L);
    }

    @Override
    public boolean isPublicKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.a(aSessionID, aLabel, 2L);
    }

    @Override
    public boolean isCertificateExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.a(aSessionID, aLabel, 1L);
    }

    @Override
    public List<byte[]> readCertificate(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, false, 1L);
    }

    @Override
    public byte[] readCertificate(long aSessionID, byte[] aCertSerialNo) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 1L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, false), new CK_ATTRIBUTE(130L, aCertSerialNo)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(PKCS11Ops.a(17484, 21620));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        this.mPKCS11.C_GetAttributeValue(aSessionID, lArray[0], cK_ATTRIBUTEArray2);
        return (byte[])cK_ATTRIBUTEArray2[0].pValue;
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(aLabel + PKCS11Ops.a(17479, -5571));
        }
        return this.getPublicKeySpec(aSessionID, lArray[0]);
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, byte[] aCertSerialNo) throws SmartCardException, PKCS11Exception {
        byte[] byArray = this.a(aSessionID, aCertSerialNo);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(258L, byArray)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(StringUtil.toHexString(byArray) + PKCS11Ops.a(17517, 1014));
        }
        return this.getPublicKeySpec(aSessionID, lArray[0]);
    }

    @Override
    public long getPrivateKeyObjIDFromCertificateSerial(long aSessionID, byte[] aCertSerialNo) throws SmartCardException, PKCS11Exception {
        byte[] byArray = this.a(aSessionID, aCertSerialNo);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(258L, byArray)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(StringUtil.toHexString(byArray) + PKCS11Ops.a(17472, 7525) + StringUtil.toHexString(aCertSerialNo));
        }
        return lArray[0];
    }

    public KeySpec getPublicKeySpec(long aSessionID, long aObjectId) throws SmartCardException, PKCS11Exception {
        Long l2;
        block10: {
            block9: {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(256L)};
                this.mPKCS11.C_GetAttributeValue(aSessionID, aObjectId, cK_ATTRIBUTEArray);
                l2 = (Long)cK_ATTRIBUTEArray[0].pValue;
                if (l2 == 0L) {
                    return this.a(aSessionID, aObjectId);
                }
                if (l2 == 3L || l2 == 3L) break block9;
                if (l2 != 0x80000003L) break block10;
            }
            return this._readECPublicKeySpec(aSessionID, aObjectId);
        }
        throw new SmartCardException(PKCS11Ops.a(17509, -26507), l2);
    }

    private RSAPublicKeySpec a(long l2, long l3) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(290L), new CK_ATTRIBUTE(288L)};
        this.mPKCS11.C_GetAttributeValue(l2, l3, cK_ATTRIBUTEArray);
        byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray[1].pValue;
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        return new RSAPublicKeySpec(bigInteger2, bigInteger);
    }

    protected ECPublicKeySpec _readECPublicKeySpec(long aSessionID, long objID) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(384L), new CK_ATTRIBUTE(385L)};
        this.mPKCS11.C_GetAttributeValue(aSessionID, objID, cK_ATTRIBUTEArray);
        byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray[1].pValue;
        try {
            ECParameterSpec eCParameterSpec = ECParameters.decodeParameters(byArray);
            byte[] byArray3 = this.b.getCardTemplate().getPointValue(byArray2);
            ECPoint eCPoint = ECParameters.decodePoint(byArray3, eCParameterSpec.getCurve());
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
            return eCPublicKeySpec;
        }
        catch (IOException iOException) {
            throw new SmartCardException(PKCS11Ops.a(17524, 31368), iOException);
        }
    }

    @Override
    public void updatePrivateData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.b(aSessionID, aLabel, aValue, true);
    }

    @Override
    public void updatePublicData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.b(aSessionID, aLabel, aValue, false);
    }

    private void b(long l2, String string, byte[] byArray, boolean bl) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, bl), new CK_ATTRIBUTE(3L, string)};
        long[] lArray = this.objeAra(l2, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(string + PKCS11Ops.a(17477, -9717));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L, byArray)};
        this.mPKCS11.C_SetAttributeValue(l2, lArray[0], cK_ATTRIBUTEArray2);
    }

    protected void _deleteObject(long aSessionID, String aLabel, boolean aIsPrivate, boolean aIsToken) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, aIsToken), new CK_ATTRIBUTE(2L, aIsPrivate), new CK_ATTRIBUTE(3L, aLabel)};
        int n2 = c;
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(aLabel + PKCS11Ops.a(17477, -9717));
        }
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            this.mPKCS11.C_DestroyObject(aSessionID, lArray[i2]);
            if (n2 == 0) continue;
        }
    }

    @Override
    public void deletePrivateObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this._deleteObject(aSessionID, aLabel, true, true);
    }

    @Override
    public void deleteObject(long sessionId, long objectHandle) throws PKCS11Exception {
        this.mPKCS11.C_DestroyObject(sessionId, objectHandle);
    }

    @Override
    public void deletePublicObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this._deleteObject(aSessionID, aLabel, false, true);
    }

    private void a(long l2, String string, boolean bl) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, bl), new CK_ATTRIBUTE(3L, string)};
        long[] lArray = this.objeAra(l2, cK_ATTRIBUTEArray);
        int n2 = c;
        if (lArray.length == 0) {
            throw new SmartCardException(string + PKCS11Ops.a(17483, -16328));
        }
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            this.mPKCS11.C_DestroyObject(l2, lArray[i2]);
            if (n2 == 0) continue;
        }
    }

    @Override
    public void deletePrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.a(aSessionID, aLabel, true);
    }

    @Override
    public void deletePublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.a(aSessionID, aLabel, false);
    }

    @Override
    public byte[] getRandomData(long aSessionID, int aDataLength) throws PKCS11Exception {
        byte[] byArray = new byte[aDataLength];
        this.mPKCS11.C_GenerateRandom(aSessionID, byArray);
        return byArray;
    }

    @Override
    public byte[] getTokenSerialNo(long aSlotID) throws PKCS11Exception {
        char[] cArray = this.mPKCS11.C_GetTokenInfo((long)aSlotID).serialNumber;
        String string = new String(cArray);
        return string.trim().getBytes();
    }

    @Override
    public byte[] signData(long aSessionID, String aKeyLabel, byte[] aImzalanacak, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(17475, 1597));
            }
        }
        this.mPKCS11.C_SignInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray = this.mPKCS11.C_Sign(aSessionID, aImzalanacak);
        return byArray;
    }

    @Override
    public byte[] signAndRecoverData(long aSessionID, String aKeyLabel, byte[] aImzalanacak, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(17507, -18932));
            }
        }
        this.mPKCS11.C_SignRecoverInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray = new byte[1024];
        int n2 = this.mPKCS11.C_SignRecover(aSessionID, aImzalanacak, 0, aImzalanacak.length, byArray, 0, byArray.length);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    @Override
    public byte[] verifyAndRecoverData(long aSessionID, String aKeyLabel, byte[] aSignature, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(17507, -18932));
            }
        }
        byte[] byArray = null;
        this.mPKCS11.C_VerifyRecoverInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray2 = new byte[1024];
        int n2 = this.mPKCS11.C_VerifyRecover(aSessionID, aSignature, 0, aSignature.length, byArray2, 0, byArray2.length);
        byArray = new byte[n2];
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        return byArray;
    }

    @Override
    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aImza, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(17499, 31608));
            }
        }
        this.verifyData(aSessionID, lArray[0], aData, aImza, aMechanism);
    }

    @Override
    public void verifyData(long aSessionID, long aKeyID, byte[] aData, byte[] aImza, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        this.mPKCS11.C_VerifyInit(aSessionID, aMechanism, aKeyID);
        this.mPKCS11.C_Verify(aSessionID, aData, aImza);
    }

    @Override
    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aImza, long aMechanism) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        this.verifyData(aSessionID, aKeyLabel, aData, aImza, cK_MECHANISM);
    }

    @Override
    public byte[] encryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        long l2 = this.searchKeyToEncryptData(aSessionID, aKeyLabel);
        return this.encryptData(aSessionID, l2, aData, aMechanism);
    }

    public long searchKeyToEncryptData(long aSessionID, String aKeyLabel) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 4L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 2L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(17507, -18932));
            }
        }
        return lArray[0];
    }

    @Override
    public byte[] encryptData(long aSessionID, long keyID, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        ByteArrayOutputStream byteArrayOutputStream;
        block4: {
            int n2;
            byte[] byArray;
            int n3;
            int n4;
            block3: {
                n4 = this.getMaxChunkSize();
                n3 = c;
                byteArrayOutputStream = new ByteArrayOutputStream();
                byArray = new byte[n4 + 128];
                this.mPKCS11.C_EncryptInit(aSessionID, aMechanism, keyID);
                if (aData.length >= n4) break block3;
                n2 = this.b(aSessionID, aData, 0, aData.length, byArray, 0, byArray.length);
                byteArrayOutputStream.write(byArray, 0, n2);
                if (n3 == 0) break block4;
            }
            int n5 = aData.length;
            int n6 = 0;
            while (n5 > 0) {
                int n7;
                block6: {
                    block5: {
                        n7 = 0;
                        if (n5 <= n4) break block5;
                        n7 = n4;
                        if (n3 == 0) break block6;
                    }
                    n7 = n5;
                }
                n2 = this.mPKCS11.C_EncryptUpdate(aSessionID, 0L, aData, n6, n7, 0L, byArray, 0, byArray.length);
                byteArrayOutputStream.write(byArray, 0, n2);
                n5 -= n7;
                n6 += n7;
                if (n3 == 0) continue;
            }
            n2 = this.mPKCS11.C_EncryptFinal(aSessionID, 0L, byArray, 0, byArray.length);
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void encryptData(long aSessionID, long aKeyID, CK_MECHANISM aMechanism, InputStream inputStream, OutputStream outputStream) throws PKCS11Exception, SmartCardException, IOException {
        int n2;
        int n3;
        this.mPKCS11.C_EncryptInit(aSessionID, aMechanism, aKeyID);
        int n4 = this.getMaxChunkSize();
        int n5 = c;
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4 + 128];
        while ((n3 = inputStream.read(byArray, 0, n4)) != -1 || n5 != 0) {
            n2 = this.mPKCS11.C_EncryptUpdate(aSessionID, 0L, byArray, 0, n3, 0L, byArray2, 0, byArray2.length);
            outputStream.write(byArray2, 0, n2);
            if (n3 > 0) continue;
        }
        n2 = this.mPKCS11.C_EncryptFinal(aSessionID, 0L, byArray2, 0, byArray2.length);
        outputStream.write(byArray2, 0, n2);
    }

    public int getMaxChunkSize() {
        return 1024;
    }

    private int b(long l2, byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) throws SmartCardException, PKCS11Exception {
        Class<?> clazz = this.mPKCS11.getClass();
        Method[] methodArray = clazz.getMethods();
        AccessibleObject accessibleObject = null;
        int n6 = 0;
        while (true) {
            block20: {
                if (n6 >= methodArray.length) break;
                if (!methodArray[n6].getName().equals(PKCS11Ops.a(17496, 28884))) break block20;
                accessibleObject = methodArray[n6];
                break;
            }
            ++n6;
        }
        if (accessibleObject == null) {
            throw new SmartCardException(PKCS11Ops.a(17481, -2771));
        }
        if (!accessibleObject.isAccessible()) {
            ((Method)accessibleObject).setAccessible(true);
        }
        Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
        if (classArray.length == 7) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l2, byArray, n2, n3, byArray2, n4, n5);
        }
        if (classArray.length == 9) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l2, 0, byArray, n2, n3, 0, byArray2, n4, n5);
        }
        try {
            throw new SmartCardException(PKCS11Ops.a(17513, 15858));
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof PKCS11Exception) {
                throw (PKCS11Exception)invocationTargetException.getTargetException();
            }
            throw new SmartCardException(PKCS11Ops.a(17495, -11352), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SmartCardException(PKCS11Ops.a(17505, -11475), illegalAccessException);
        }
    }

    @Override
    public byte[] decryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[1] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(17507, -18932));
            }
        }
        long l2 = lArray[0];
        return this.decryptData(aSessionID, l2, aData, aMechanism);
    }

    @Override
    public byte[] decryptData(long aSessionID, long aKeyID, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        ByteArrayOutputStream byteArrayOutputStream;
        block4: {
            int n2;
            byte[] byArray;
            int n3;
            int n4;
            byte[] byArray2;
            block3: {
                byteArrayOutputStream = new ByteArrayOutputStream();
                this.mPKCS11.C_DecryptInit(aSessionID, aMechanism, aKeyID);
                byArray2 = this.c(aMechanism.mechanism, aData);
                n4 = this.getMaxChunkSize();
                n3 = c;
                byArray = new byte[n4 + 16];
                if (byArray2.length >= n4) break block3;
                n2 = this.a(aSessionID, byArray2, 0, byArray2.length, byArray, 0, byArray.length);
                byteArrayOutputStream.write(byArray, 0, n2);
                if (n3 == 0) break block4;
            }
            int n5 = aData.length;
            int n6 = 0;
            while (n5 > 0) {
                int n7 = Math.min(n5, n4);
                n2 = this.mPKCS11.C_DecryptUpdate(aSessionID, 0L, byArray2, n6, n7, 0L, byArray, 0, byArray.length);
                byteArrayOutputStream.write(byArray, 0, n2);
                n5 -= n7;
                n6 += n7;
                if (n3 == 0) continue;
            }
            n2 = this.mPKCS11.C_DecryptFinal(aSessionID, 0L, byArray, 0, byArray.length);
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void decryptData(long aSessionID, long aKeyID, CK_MECHANISM aMechanism, InputStream inputStream, OutputStream outputStream) throws PKCS11Exception, SmartCardException, IOException {
        int n2;
        int n3;
        this.mPKCS11.C_DecryptInit(aSessionID, aMechanism, aKeyID);
        int n4 = this.getMaxChunkSize();
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4 + 128];
        int n5 = c;
        while ((n3 = inputStream.read(byArray, 0, n4)) != -1 || n5 != 0) {
            n2 = this.mPKCS11.C_DecryptUpdate(aSessionID, 0L, byArray, 0, n3, 0L, byArray2, 0, byArray2.length);
            outputStream.write(byArray2, 0, n2);
            if (n3 > 0) continue;
        }
        n2 = this.mPKCS11.C_DecryptFinal(aSessionID, 0L, byArray2, 0, byArray2.length);
        outputStream.write(byArray2, 0, n2);
    }

    byte[] c(long l2, byte[] byArray) {
        int n2;
        block8: {
            block7: {
                if (l2 != 4231L && l2 != 4230L) break block7;
                return byArray;
            }
            n2 = byArray.length % 8;
            if (n2 != 1 || byArray[0] != 0) break block8;
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
            return byArray2;
        }
        if (n2 == 7) {
            byte[] byArray3 = new byte[byArray.length + 1];
            byArray3[0] = 0;
            System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
            return byArray3;
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long[] importCertificateAndKey(long aSessionID, String aCertLabel, String aKeyLabel, PrivateKey aPrivKey, X509Certificate aCert) throws PKCS11Exception, SmartCardException, IOException {
        Object object;
        long[] lArray;
        block14: {
            block15: {
                void var13_17;
                byte[] byArray;
                int n2;
                boolean bl;
                boolean bl2;
                block13: {
                    boolean[] blArray;
                    bl2 = false;
                    bl = false;
                    n2 = c;
                    if (aCert != null && (blArray = aCert.getKeyUsage()) != null) {
                        bl2 = blArray[0];
                        bl = blArray[2] || blArray[3] || blArray[4];
                    }
                    lArray = new long[3];
                    byArray = aCert.getSubjectX500Principal().getEncoded();
                    if (!(aPrivKey instanceof RSAPrivateCrtKey)) break block13;
                    object = (RSAPrivateCrtKey)aPrivKey;
                    long[] lArray2 = this.a(aSessionID, aKeyLabel, (RSAPrivateCrtKey)object, byArray, bl2, bl);
                    lArray[0] = lArray2[0];
                    lArray[1] = lArray2[1];
                    if (n2 == 0) break block14;
                }
                if (!(aPrivKey instanceof ECPrivateKey)) break block15;
                object = (ECPrivateKey)aPrivKey;
                Object var13_14 = null;
                try {
                    ECPublicKey eCPublicKey = (ECPublicKey)aCert.getPublicKey();
                }
                catch (ClassCastException classCastException) {
                    try {
                        PublicKey publicKey = aCert.getPublicKey();
                        Class<?> clazz = Class.forName(PKCS11Ops.a(17516, 18177));
                        Constructor<?> constructor = clazz.getConstructor(byte[].class);
                        ECPublicKey eCPublicKey = (ECPublicKey)constructor.newInstance(new Object[]{publicKey.getEncoded()});
                    }
                    catch (Exception exception) {
                        this.a.warn(PKCS11Ops.a(17500, 12188), exception);
                        throw classCastException;
                    }
                }
                long[] lArray3 = this.a(aSessionID, aKeyLabel, (ECPrivateKey)object, (ECPublicKey)var13_17, byArray, bl2, bl);
                lArray[0] = lArray3[0];
                lArray[1] = lArray3[1];
                if (n2 == 0) break block14;
            }
            throw new SmartCardException(PKCS11Ops.a(17519, -30939));
        }
        object = this.b.getCardTemplate().getCertificateTemplate(aCertLabel, aCert);
        lArray[2] = this.mPKCS11.C_CreateObject(aSessionID, object.toArray(new CK_ATTRIBUTE[0]));
        return lArray;
    }

    private long[] a(long l2, String string, RSAPrivateCrtKey rSAPrivateCrtKey, byte[] byArray, boolean bl, boolean bl2) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.b.getCardTemplate().getRSAPrivateKeyImportTemplate(string, rSAPrivateCrtKey, null, bl, bl2);
        List<CK_ATTRIBUTE> list2 = this.b.getCardTemplate().getRSAPublicKeyImportTemplate(string, rSAPrivateCrtKey, null, bl, bl2);
        if (byArray != null) {
            list.add(new CK_ATTRIBUTE(257L, byArray));
        }
        long[] lArray = new long[]{this.mPKCS11.C_CreateObject(l2, list.toArray(new CK_ATTRIBUTE[0])), this.mPKCS11.C_CreateObject(l2, list2.toArray(new CK_ATTRIBUTE[0]))};
        return lArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long[] a(long l2, String string, ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey, byte[] byArray, boolean bl, boolean bl2) throws PKCS11Exception, IOException {
        Object object;
        Object object2;
        byte[] byArray2;
        int n2;
        ECParameterSpec eCParameterSpec;
        block18: {
            block17: {
                eCParameterSpec = eCPrivateKey.getParams();
                n2 = c;
                if (this.b != CardType.AKIS) break block17;
                byArray2 = ECParameters.encodeECParameterSpec(eCParameterSpec);
                if (n2 == 0) break block18;
            }
            byArray2 = ECParameters.encodeParameters(eCParameterSpec);
        }
        ECPoint eCPoint = eCPublicKey.getW();
        byte[] byArray3 = ECParameters.encodePoint(eCPoint, eCParameterSpec.getCurve());
        DerValue derValue = new DerValue(4, byArray3);
        byte[] byArray4 = this.OZET_ALICI.digest(byArray3);
        ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
        arrayList.add(new CK_ATTRIBUTE(1L, true));
        arrayList.add(new CK_ATTRIBUTE(0L, 2L));
        arrayList.add(new CK_ATTRIBUTE(256L, 3L));
        arrayList.add(new CK_ATTRIBUTE(384L, byArray2));
        arrayList.add(new CK_ATTRIBUTE(385L, derValue.toByteArray()));
        arrayList.add(new CK_ATTRIBUTE(3L, string));
        arrayList.add(new CK_ATTRIBUTE(2L, false));
        arrayList.add(new CK_ATTRIBUTE(258L, byArray4));
        if (bl2) {
            arrayList.add(new CK_ATTRIBUTE(268L, bl2));
        }
        if (bl) {
            arrayList.add(new CK_ATTRIBUTE(266L, bl));
        }
        boolean bl3 = false;
        ECParameterSpec eCParameterSpec2 = eCPublicKey.getParams();
        if (eCParameterSpec2 instanceof NamedCurve) {
            bl3 = true;
            object2 = NamedCurve.getNameCurves();
            object = ((NamedCurve)eCParameterSpec2).getObjectIdentifier();
            for (NamedCurve namedCurve : object2.values()) {
                if (namedCurve.getObjectIdentifier().toString().equals(((ObjectIdentifier)object).toString())) {
                    bl3 = false;
                    if (n2 == 0) break;
                }
                if (n2 == 0) continue;
            }
        }
        arrayList.add(new CK_ATTRIBUTE(2L, bl3));
        object2 = new ArrayList();
        object2.add(new CK_ATTRIBUTE(1L, true));
        object2.add(new CK_ATTRIBUTE(2L, true));
        object2.add(new CK_ATTRIBUTE(0L, 3L));
        object2.add(new CK_ATTRIBUTE(256L, 3L));
        object2.add(new CK_ATTRIBUTE(3L, string));
        object2.add(new CK_ATTRIBUTE(17L, eCPrivateKey.getS()));
        object2.add(new CK_ATTRIBUTE(384L, byArray2));
        object2.add(new CK_ATTRIBUTE(258L, byArray4));
        if (bl2) {
            object2.add(new CK_ATTRIBUTE(268L, bl2));
        }
        if (bl) {
            object2.add(new CK_ATTRIBUTE(264L, bl));
        }
        if (byArray != null) {
            object2.add(new CK_ATTRIBUTE(257L, byArray));
        }
        object = new long[2];
        object[0] = this.mPKCS11.C_CreateObject(l2, arrayList.toArray(new CK_ATTRIBUTE[0]));
        object[1] = this.mPKCS11.C_CreateObject(l2, object2.toArray(new CK_ATTRIBUTE[0]));
        return object;
    }

    @Override
    @Deprecated
    public long[] importKeyPair(long aSessionID, String aLabel, KeyPair aKeyPair, byte[] aSubject, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        block9: {
            PublicKey publicKey;
            PrivateKey privateKey;
            block8: {
                privateKey = aKeyPair.getPrivate();
                publicKey = aKeyPair.getPublic();
                if (!(privateKey instanceof RSAPrivateCrtKey) || !(publicKey instanceof RSAPublicKey)) break block8;
                return this.a(aSessionID, aLabel, (RSAPrivateCrtKey)privateKey, aSubject, aIsSign, aIsEncrypt);
            }
            if (!(privateKey instanceof ECPrivateKey) || !(publicKey instanceof ECPublicKey)) break block9;
            return this.a(aSessionID, aLabel, (ECPrivateKey)privateKey, (ECPublicKey)publicKey, aSubject, aIsSign, aIsEncrypt);
        }
        throw new SmartCardException(PKCS11Ops.a(17497, 12859));
    }

    @Override
    public void changePassword(String aOldPass, String aNewPass, long aSessionID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.b.getLibName());
        }
        int n2 = this.mESYAPKCS11.changePassword(aOldPass, aNewPass, (int)aSessionID);
        if ((long)n2 != 0L) {
            throw PKCS11ExceptionFactory.getPKCS11Exception(n2);
        }
    }

    @Override
    public void formatToken(String aSOpin, String aNewPIN, String aLabel, int slotID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.b.getLibName());
        }
        int n2 = this.mESYAPKCS11.formatToken(aSOpin, aNewPIN, aLabel, slotID);
        if ((long)n2 != 0L) {
            throw PKCS11ExceptionFactory.getPKCS11Exception(n2);
        }
    }

    @Override
    public void setSOPin(byte[] aSOPin, byte[] aNewSOPin, long aSessionID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.b.getLibName());
        }
        int n2 = this.mESYAPKCS11.setSOPin(aSOPin, aSOPin.length, aNewSOPin, aNewSOPin.length, (int)aSessionID);
        if ((long)n2 != 0L) {
            throw PKCS11ExceptionFactory.getPKCS11Exception(n2);
        }
    }

    @Override
    public void changeUserPin(byte[] aSOPin, byte[] aUserPin, long aSessionID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.b.getLibName());
        }
        int n2 = this.mESYAPKCS11.changeUserPin(aSOPin, aSOPin.length, aUserPin, aUserPin.length, (int)aSessionID);
        if ((long)n2 != 0L) {
            throw PKCS11ExceptionFactory.getPKCS11Exception(n2);
        }
    }

    @Override
    public boolean setContainer(byte[] aContainerLabel, long aSessionID) {
        String string = this.b.getLibName();
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(string);
        }
        int n2 = this.mESYAPKCS11.setContainer(aContainerLabel, aContainerLabel.length, (int)aSessionID, string);
        if ((long)n2 == 0L) {
            return true;
        }
        return false;
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, byte[] aPbCertData, int aSignOrEnc) {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.b.getLibName());
        }
        int n2 = this.mESYAPKCS11.importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarCifti.length, aAnahtarLen, aScfname, aScfname.length(), aContextName, aContextName.length(), aPbCertData, aSignOrEnc);
        if ((long)n2 == 0L) {
            return true;
        }
        return false;
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, X509Certificate aPbCertificate, int aSignOrEnc) {
        byte[] byArray = null;
        try {
            byArray = aPbCertificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            this.a.warn(PKCS11Ops.a(17530, -8343), certificateEncodingException);
            return false;
        }
        return this.importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarLen, aScfname, aContextName, byArray, aSignOrEnc);
    }

    protected void changePUK(byte[] aOldPUK, byte[] aNewPUK, long aSessionID) throws PKCS11Exception {
        String string = this.b.getLibName();
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(string);
        }
        int n2 = this.mESYAPKCS11.ChangePUK(aOldPUK, aOldPUK.length, aNewPUK, aNewPUK.length, (int)aSessionID, string);
        if ((long)n2 != 0L) {
            throw PKCS11ExceptionFactory.getPKCS11Exception(n2);
        }
    }

    protected void unBlockPIN(byte[] aPUK, byte[] aUserPIN, long aSessionID) throws PKCS11Exception {
        String string = this.b.getLibName();
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(string);
        }
        int n2 = this.mESYAPKCS11.UnBlockPIN(aPUK, aPUK.length, aUserPIN, aUserPIN.length, (int)aSessionID, string);
        if ((long)n2 != 0L) {
            throw PKCS11ExceptionFactory.getPKCS11Exception(n2);
        }
    }

    @Override
    public long[] objeAra(long aSessionID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        long l2 = 200L;
        this.mPKCS11.C_FindObjectsInit(aSessionID, aTemplate);
        long[] lArray = this.mPKCS11.C_FindObjects(aSessionID, l2);
        this.mPKCS11.C_FindObjectsFinal(aSessionID);
        return lArray;
    }

    @Override
    public void getAttributeValue(long aSessionID, long aObjectID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        this.mPKCS11.C_GetAttributeValue(aSessionID, aObjectID, aTemplate);
    }

    @Override
    public void changeLabel(long aSessionID, String aOldLabel, String aNewLabel) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(3L, aOldLabel)};
        int n2 = c;
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(aOldLabel + PKCS11Ops.a(17477, -9717));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aNewLabel)};
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            this.mPKCS11.C_SetAttributeValue(aSessionID, lArray[i2], cK_ATTRIBUTEArray2);
            if (n2 == 0) continue;
        }
    }

    @Override
    public byte[] generateRSAPrivateKey(long aSessionID, int keySize) throws ESYAException {
        throw new RuntimeException(PKCS11Ops.a(17480, -4310));
    }

    @Override
    public KeyPair generateECKeyPair(long aSessionID, ECParameterSpec ecParameterSpec) throws ESYAException {
        throw new RuntimeException(PKCS11Ops.a(17501, 2935));
    }

    @Override
    public byte[] getModulusOfKey(long aSessionID, long aObjID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
        this.getAttributeValue(aSessionID, aObjID, cK_ATTRIBUTEArray);
        return (byte[])cK_ATTRIBUTEArray[0].pValue;
    }

    private long b(long l2, String string, long l3) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, l3), new CK_ATTRIBUTE(3L, string)};
        long[] lArray = this.objeAra(l2, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(string + PKCS11Ops.a(17507, -18932));
        }
        return lArray[0];
    }

    @Override
    public long getObjIDFromPublicKeyLabel(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this.b(aSessionID, aLabel, 2L);
    }

    @Override
    public long getObjIDFromPrivateKeyLabel(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this.b(aSessionID, aLabel, 3L);
    }

    @Override
    public long getObjIDFromSecretKeyLabel(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this.b(aSessionID, aLabel, 4L);
    }

    @Override
    public byte[] wrapKey(long aSessionID, CK_MECHANISM aMechanism, String wrapperKeyLabel, String aKeyLabel) throws PKCS11Exception, SmartCardException {
        long l2 = this.c(aSessionID, wrapperKeyLabel);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(2L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(aKeyLabel + PKCS11Ops.a(17482, 12011));
        }
        return this.mPKCS11.C_WrapKey(aSessionID, aMechanism, l2, lArray[0]);
    }

    public byte[] wrapKey(long aSessionID, CK_MECHANISM aMechanism, long wrapperKeyID, long keyID) throws PKCS11Exception, SmartCardException {
        return this.mPKCS11.C_WrapKey(aSessionID, aMechanism, wrapperKeyID, keyID);
    }

    @Override
    public byte[] wrapKey(long aSessionID, CK_MECHANISM aMechanism, KeyTemplate wrapperKeyTemplate, KeyTemplate aToBeExportedKeyTemplate) throws PKCS11Exception {
        this.a(aSessionID, wrapperKeyTemplate, aToBeExportedKeyTemplate);
        return this.mPKCS11.C_WrapKey(aSessionID, aMechanism, wrapperKeyTemplate.getKeyId(), aToBeExportedKeyTemplate.getKeyId());
    }

    private void a(long l2, KeyTemplate ... keyTemplateArray) throws PKCS11Exception {
        KeyTemplate[] keyTemplateArray2 = keyTemplateArray;
        int n2 = keyTemplateArray2.length;
        int n3 = c;
        for (int i2 = 0; i2 < n2; ++i2) {
            KeyTemplate keyTemplate = keyTemplateArray2[i2];
            if (keyTemplate.getKeyId() > 0L) continue;
            this.a(l2, keyTemplate);
            continue;
        }
    }

    private void a(long l2, KeyTemplate keyTemplate) throws PKCS11Exception {
        long[] lArray;
        block7: {
            lArray = this.objeAra(l2, keyTemplate.getAttributesAsArr());
            if (lArray != null && lArray.length != 0) break block7;
            return;
        }
        if (lArray.length > 1) {
            this.a.warn(PKCS11Ops.a(17503, 1519) + keyTemplate);
        }
        keyTemplate.setKeyId(lArray[0]);
    }

    @Override
    public long unwrapKey(long aSessionID, CK_MECHANISM aMechanism, String unwrapperKeyLabel, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.c(aMechanism.mechanism, aWrappedKey);
        long l2 = this.b(aSessionID, unwrapperKeyLabel);
        long l3 = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, l2, byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l3);
        String string = aUnwrappedKeyTemplate.getLabel();
        this.a(aSessionID, string);
        return l3;
    }

    public long unwrapKey(long aSessionID, CK_MECHANISM aMechanism, long unwrapperKeyID, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.c(aMechanism.mechanism, aWrappedKey);
        long l2 = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, unwrapperKeyID, byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l2);
        String string = aUnwrappedKeyTemplate.getLabel();
        this.a(aSessionID, string);
        return l2;
    }

    @Override
    public long unwrapKey(long aSessionID, CK_MECHANISM aMechanism, KeyTemplate unwrapperKeyTemplate, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.c(aMechanism.mechanism, aWrappedKey);
        this.a(aUnwrappedKeyTemplate);
        this.a(aSessionID, new KeyTemplate[]{unwrapperKeyTemplate});
        long l2 = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, unwrapperKeyTemplate.getKeyId(), byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l2);
        String string = unwrapperKeyTemplate.getLabel();
        this.a(aSessionID, string);
        return l2;
    }

    private void a(KeyTemplate keyTemplate) throws SmartCardException {
        ICardTemplate iCardTemplate = this.b.getCardTemplate();
        if (keyTemplate instanceof SecretKeyTemplate) {
            iCardTemplate.applyTemplate((SecretKeyTemplate)keyTemplate);
        }
    }

    @Override
    public long unwrapKey(long aSessionID, CK_MECHANISM aMechanism, byte[] certSerialNumber, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.c(aMechanism.mechanism, aWrappedKey);
        byte[] byArray2 = this.b(aSessionID, certSerialNumber);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray2), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(StringUtil.toString(certSerialNumber) + PKCS11Ops.a(17494, -8178));
        }
        long l2 = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, lArray[0], byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l2);
        return l2;
    }

    public PKCS11 getmPKCS11() {
        return this.mPKCS11;
    }

    @Override
    public KeySpec createKeyPair(long aSessionID, KeyPairTemplate template) throws PKCS11Exception, IOException, SmartCardException {
        if (this.a.isDebugEnabled()) {
            this.a(((KeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr());
            this.a(((KeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr());
        }
        if (template instanceof RSAKeyPairTemplate) {
            return this.createKeyPair(aSessionID, (RSAKeyPairTemplate)template);
        }
        if (template instanceof ECKeyPairTemplate) {
            return this.a(aSessionID, (ECKeyPairTemplate)template);
        }
        throw new ESYARuntimeException(PKCS11Ops.a(17528, -31911) + template);
    }

    public KeySpec createKeyPair(long aSessionID, RSAKeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        long[] lArray = this.createKeyPairWithOutRead(aSessionID, template);
        RSAPublicKeySpec rSAPublicKeySpec = this.a(aSessionID, lArray[0]);
        String string = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getLabel();
        this.a(aSessionID, string);
        ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).setKeyId(lArray[0]);
        ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).setKeyId(lArray[1]);
        return rSAPublicKeySpec;
    }

    protected long[] createKeyPairWithOutRead(long aSessionID, RSAKeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = 0L;
        cK_MECHANISM.pParameter = null;
        ICardTemplate iCardTemplate = this.b.getCardTemplate();
        iCardTemplate.applyTemplate(template);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr();
        if (this.a.isDebugEnabled()) {
            this.a(cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        }
        long[] lArray = this.mPKCS11.C_GenerateKeyPair(aSessionID, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        return lArray;
    }

    protected long[] createKeyPairWithOutRead(long aSessionID, ECKeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = 4160L;
        cK_MECHANISM.pParameter = null;
        ICardTemplate iCardTemplate = this.b.getCardTemplate();
        iCardTemplate.applyTemplate(template);
        ECPublicKeyTemplate eCPublicKeyTemplate = (ECPublicKeyTemplate)template.getPublicKeyTemplate();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = eCPublicKeyTemplate.getAttributesAsArr();
        ECPrivateKeyTemplate eCPrivateKeyTemplate = (ECPrivateKeyTemplate)template.getPrivateKeyTemplate();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = eCPrivateKeyTemplate.getAttributesAsArr();
        long[] lArray = this.mPKCS11.C_GenerateKeyPair(aSessionID, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        return lArray;
    }

    private byte[] a(long l2, String string) {
        int n2 = c;
        try {
            long[] lArray;
            block5: {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(1L, true)};
                lArray = this.objeAra(l2, cK_ATTRIBUTEArray);
                if (lArray != null && lArray.length >= 1) break block5;
                return null;
            }
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
            this.mPKCS11.C_GetAttributeValue(l2, lArray[0], cK_ATTRIBUTEArray);
            byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
            this.OZET_ALICI.update(byArray);
            byte[] byArray2 = this.OZET_ALICI.digest();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray2)};
            for (long l3 : lArray) {
                this.mPKCS11.C_SetAttributeValue(l2, l3, cK_ATTRIBUTEArray2);
                if (n2 == 0) continue;
            }
            return byArray2;
        }
        catch (Exception exception) {
            this.a.warn(PKCS11Ops.a(17525, 18616), exception);
            return null;
        }
    }

    private KeySpec a(long l2, ECKeyPairTemplate eCKeyPairTemplate) throws SmartCardException, PKCS11Exception {
        byte[] byArray;
        ECPublicKeySpec eCPublicKeySpec;
        long[] lArray;
        block7: {
            Object object;
            long l3;
            block6: {
                lArray = this.createKeyPairWithOutRead(l2, eCKeyPairTemplate);
                int n2 = c;
                ((KeyTemplate)eCKeyPairTemplate.getPublicKeyTemplate()).setKeyId(lArray[0]);
                ((KeyTemplate)eCKeyPairTemplate.getPrivateKeyTemplate()).setKeyId(lArray[1]);
                l3 = lArray[0];
                ECPublicKeyTemplate eCPublicKeyTemplate = (ECPublicKeyTemplate)eCKeyPairTemplate.getPublicKeyTemplate();
                if (!eCPublicKeyTemplate.isSecretECCurve()) break block6;
                object = (ECParameterSpec)eCPublicKeyTemplate.getSpec();
                ECDomainParameter eCDomainParameter = ECDomainParameter.getInstance((ECParameterSpec)object);
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L)};
                this.mPKCS11.C_GetAttributeValue(l2, l3, cK_ATTRIBUTEArray);
                try {
                    Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer((byte[])cK_ATTRIBUTEArray[0].pValue);
                    Asn1OctetString asn1OctetString = new Asn1OctetString();
                    asn1OctetString.decode(asn1DerDecodeBuffer);
                    byte[] byArray2 = asn1OctetString.value;
                    ECGNUPoint eCGNUPoint = new ECDSAKeyPairX509Codec().getECPoint(eCDomainParameter, byArray2);
                    eCPublicKeySpec = new ECPublicKeySpec(eCGNUPoint, (ECParameterSpec)object);
                    ECPublicKey eCPublicKey = (ECPublicKey)KeyUtil.generatePublicKey(eCPublicKeySpec);
                    byArray = ECUtil.generatePKCS11ID(eCPublicKey);
                }
                catch (Exception exception) {
                    throw new SmartCardException(exception);
                }
                if (n2 == 0) break block7;
            }
            eCPublicKeySpec = (ECPublicKeySpec)this.getPublicKeySpec(l2, l3);
            try {
                object = (ECPublicKey)KeyUtil.generatePublicKey(eCPublicKeySpec);
                byArray = ECUtil.generatePKCS11ID((ECPublicKey)object);
            }
            catch (CryptoException cryptoException) {
                System.err.println(PKCS11Ops.a(17491, 15041));
                throw new ESYARuntimeException(cryptoException);
            }
        }
        this.a(l2, lArray, byArray);
        return eCPublicKeySpec;
    }

    private void a(long l2, long[] lArray, byte[] byArray) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray)};
        int n2 = c;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (lArray[i2] == -1L) continue;
            this.mPKCS11.C_SetAttributeValue(l2, lArray[i2], cK_ATTRIBUTEArray);
            continue;
        }
    }

    @Override
    public long[] importKeyPair(long sessionID, KeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        this.b.getCardTemplate().applyTemplate(template);
        if (template instanceof RSAKeyPairTemplate) {
            return this.importKeyPair(sessionID, (RSAKeyPairTemplate)template);
        }
        if (template instanceof ECKeyPairTemplate) {
            return this.importKeyPair(sessionID, (ECKeyPairTemplate)template);
        }
        throw new ESYARuntimeException(PKCS11Ops.a(17515, 13680) + template);
    }

    public long[] importKeyPair(long sessionID, RSAKeyPairTemplate template) throws PKCS11Exception {
        long l2;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        long[] lArray = new long[]{-1L, -1L};
        String string = null;
        RSAKeyTemplate rSAKeyTemplate = (RSAPublicKeyTemplate)template.getPublicKeyTemplate();
        if (rSAKeyTemplate != null) {
            string = rSAKeyTemplate.getLabel();
            cK_ATTRIBUTEArray = rSAKeyTemplate.getAttributesAsArr();
            l2 = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            rSAKeyTemplate.setKeyId(l2);
            lArray[0] = l2;
        }
        if ((rSAKeyTemplate = (RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()) != null) {
            cK_ATTRIBUTEArray = rSAKeyTemplate.getAttributesAsArr();
            l2 = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            rSAKeyTemplate.setKeyId(l2);
            lArray[1] = l2;
        }
        if (string != null) {
            this.a(sessionID, string);
        }
        return lArray;
    }

    public long[] importKeyPair(long sessionID, ECKeyPairTemplate template) throws PKCS11Exception {
        long l2;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        long[] lArray = new long[]{-1L, -1L};
        Object object = template.getPublicKeyTemplate();
        if (object != null) {
            cK_ATTRIBUTEArray = ((KeyTemplate)object).getAttributesAsArr();
            l2 = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((KeyTemplate)object).setKeyId(l2);
            lArray[0] = l2;
        }
        if ((object = template.getPrivateKeyTemplate()) != null) {
            cK_ATTRIBUTEArray = ((KeyTemplate)object).getAttributesAsArr();
            l2 = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((KeyTemplate)object).setKeyId(l2);
            lArray[1] = l2;
        }
        return lArray;
    }

    @Override
    public long createSecretKey(long sessionID, SecretKeyTemplate template) throws PKCS11Exception, SmartCardException {
        this.b.getCardTemplate().applyTemplate(template);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = template.getAttributesAsArr();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(template.getGenerationMechanism());
        long l2 = this.mPKCS11.C_GenerateKey(sessionID, cK_MECHANISM, cK_ATTRIBUTEArray);
        template.setKeyId(l2);
        return l2;
    }

    @Override
    public int deleteCertificate(long aSessionID, String aKeyLabel) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(0L, 1L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        int n2 = 0;
        int n3 = c;
        if (lArray.length > 0) {
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                this.mPKCS11.C_DestroyObject(aSessionID, lArray[i2]);
                ++n2;
                if (n3 == 0) continue;
            }
        }
        return n2;
    }

    private void a(CK_MECHANISM cK_MECHANISM, CK_ATTRIBUTE[] cK_ATTRIBUTEArray, CK_ATTRIBUTE[] cK_ATTRIBUTEArray2) {
        block4: {
            block5: {
                if (!this.a.isDebugEnabled()) break block4;
                this.a.debug(PKCS11Ops.a(17488, -24056));
                this.a.debug(PKCS11Ops.a(17486, -11179) + cK_MECHANISM.mechanism);
                this.a.debug(PKCS11Ops.a(17511, 6611));
                if (cK_MECHANISM.pParameter != null) break block5;
                this.a.debug(PKCS11Ops.a(17489, 25667));
            }
            this.a.debug("\n");
            this.a.debug(PKCS11Ops.a(17520, -23871));
            this.a(cK_ATTRIBUTEArray2);
            this.a.debug(PKCS11Ops.a(17510, -19465));
            this.a.debug(PKCS11Ops.a(17502, 9363));
            this.a(cK_ATTRIBUTEArray);
            this.a.debug(PKCS11Ops.a(17527, -29529));
        }
    }

    private void a(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = cK_ATTRIBUTEArray;
        int n2 = cK_ATTRIBUTEArray2.length;
        int n3 = c;
        for (int i2 = 0; i2 < n2; ++i2) {
            CK_ATTRIBUTE cK_ATTRIBUTE = cK_ATTRIBUTEArray2[i2];
            this.a.debug(cK_ATTRIBUTE.toString());
            System.out.println(cK_ATTRIBUTE.toString());
            if (n3 == 0) continue;
        }
    }

    public byte[] unwrapAndOP(long sessionID, CK_MECHANISM unwrapMechanism, long unwrapperKeyID, byte[] wrappedKey, CK_ATTRIBUTE[] unwrapTemplate, DirakLibOps.CryptoOperation operation, CK_MECHANISM operationMechanism, byte[] operationData) throws SmartCardException, PKCS11Exception {
        long l2 = this.mPKCS11.C_UnwrapKey(sessionID, unwrapMechanism, unwrapperKeyID, wrappedKey, unwrapTemplate);
        byte[] byArray = null;
        switch (operation) {
            case SIGN: {
                byArray = this.signDataWithKeyID(sessionID, l2, operationMechanism, operationData);
                break;
            }
            case ENCRYPT: {
                byArray = this.encryptData(sessionID, l2, operationData, operationMechanism);
                break;
            }
            case DECRYPT: {
                byArray = this.decryptData(sessionID, l2, operationData, operationMechanism);
            }
        }
        this.getmPKCS11().C_DestroyObject(sessionID, l2);
        return byArray;
    }

    @Override
    public long deriveKey(long sessionId, CK_MECHANISM derive_mechanism, long privateKeyHandle, KeyTemplate unwrappedKeyTemplate) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = unwrappedKeyTemplate.getAttributesAsArr();
        long l2 = this.mPKCS11.C_DeriveKey(sessionId, derive_mechanism, privateKeyHandle, cK_ATTRIBUTEArray);
        return l2;
    }

    private long b(long l2, String string) throws SmartCardException, PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(263L, true)};
        long[] lArray = this.objeAra(l2, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(string + PKCS11Ops.a(17482, 12011));
        }
        if (lArray.length > 1) {
            throw new SmartCardException(string + PKCS11Ops.a(17473, -644));
        }
        return lArray[0];
    }

    private long c(long l2, String string) throws SmartCardException, PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(262L, true)};
        long[] lArray = this.objeAra(l2, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(string + PKCS11Ops.a(17476, -2205));
        }
        if (lArray.length > 1) {
            throw new SmartCardException(string + PKCS11Ops.a(17529, -31399));
        }
        return lArray[0];
    }

    private CK_ATTRIBUTE[] a(long l2, long l3, long[] lArray) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = this.b().getAttributeValueInTwoSteps(l2, l3, lArray);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = this.b(cK_ATTRIBUTEArray);
        return cK_ATTRIBUTEArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CK_ATTRIBUTE[] b(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[cK_ATTRIBUTEArray.length];
        Map<Long, Class> map = PKCS11Names.getAttributeValueTypes();
        map.putAll(this.b.getCardTemplate().getVendorSpecificAttributeValuesType());
        int n2 = c;
        for (int i2 = 0; i2 < cK_ATTRIBUTEArray.length; ++i2) {
            CK_ATTRIBUTE cK_ATTRIBUTE;
            block12: {
                Class clazz;
                block16: {
                    byte[] byArray;
                    block15: {
                        block14: {
                            block13: {
                                block11: {
                                    long l2 = cK_ATTRIBUTEArray[i2].type;
                                    cK_ATTRIBUTE = new CK_ATTRIBUTE();
                                    cK_ATTRIBUTE.type = l2;
                                    clazz = map.get(l2);
                                    if (!clazz.equals(char[].class)) break block11;
                                    byArray = cK_ATTRIBUTEArray[i2].getByteArray();
                                    cK_ATTRIBUTE.pValue = new String(byArray, StandardCharsets.UTF_8).toCharArray();
                                    if (n2 == 0) break block12;
                                }
                                if (!clazz.equals(byte[].class)) break block13;
                                cK_ATTRIBUTE.pValue = cK_ATTRIBUTEArray[i2].getByteArray();
                                if (n2 == 0) break block12;
                            }
                            if (!clazz.equals(Boolean.TYPE)) break block14;
                            byArray = cK_ATTRIBUTEArray[i2].getByteArray();
                            cK_ATTRIBUTE.pValue = ByteConversionUtil.bytesToBoolean(byArray);
                            if (n2 == 0) break block12;
                        }
                        if (!clazz.equals(Long.TYPE)) break block15;
                        byArray = cK_ATTRIBUTEArray[i2].getByteArray();
                        cK_ATTRIBUTE.pValue = ByteConversionUtil.littleEndianBytesToLong(byArray);
                        if (n2 == 0) break block12;
                    }
                    if (!clazz.equals(long[].class)) break block16;
                    byArray = cK_ATTRIBUTEArray[i2].getByteArray();
                    cK_ATTRIBUTE.pValue = ByteConversionUtil.littleEndianBytesToLongArray(byArray);
                    if (n2 == 0) break block12;
                }
                if (clazz.equals(CK_ATTRIBUTE.class)) {
                    // empty if block
                }
            }
            cK_ATTRIBUTEArray2[i2] = cK_ATTRIBUTE;
            if (n2 == 0) continue;
        }
        return cK_ATTRIBUTEArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WrappedObjectsWithAttributes wrapObjectsWithAttributes(long aSessionID, CK_MECHANISM aMechanism, String wrapperKeyLabel, long[] objectIDs) throws PKCS11Exception, SmartCardException {
        Object object;
        long l2 = this.c(aSessionID, wrapperKeyLabel);
        WrappedObjectsWithAttributes wrappedObjectsWithAttributes = new WrappedObjectsWithAttributes();
        wrappedObjectsWithAttributes.setTotalToBeWrappedObject(objectIDs.length);
        ArrayList<ObjectResult> arrayList = new ArrayList<ObjectResult>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n2 = c;
        for (int i2 = 0; i2 < objectIDs.length; ++i2) {
            block16: {
                byte[] byArray;
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray2;
                block17: {
                    Boolean bl;
                    block15: {
                        object = new ObjectResult();
                        ((ObjectResult)object).setObjectID(objectIDs[i2]);
                        long[] lArray = new long[]{0L, 354L};
                        CK_ATTRIBUTE[] cK_ATTRIBUTEArray3 = this.a(aSessionID, objectIDs[i2], lArray);
                        Long l3 = ByteConversionUtil.littleEndianBytesToLong((byte[])cK_ATTRIBUTEArray3[0].pValue);
                        Boolean bl2 = bl = cK_ATTRIBUTEArray3.length == 1 ? null : Boolean.valueOf(ByteConversionUtil.bytesToBoolean((byte[])cK_ATTRIBUTEArray3[1].pValue));
                        if (bl != null || l3 != 2L && l3 != 1L) break block15;
                        long[] lArray2 = this.getAttributeTypes();
                        cK_ATTRIBUTEArray2 = this.a(aSessionID, objectIDs[i2], lArray2);
                        cK_ATTRIBUTEArray = null;
                        try {
                            cK_ATTRIBUTEArray = SCObjectUtil.encodeESCObject(cK_ATTRIBUTEArray2);
                        }
                        catch (ESYAException eSYAException) {
                            ((ObjectResult)object).setSuccess(false);
                            ((ObjectResult)object).setReasonIfFail(PKCS11Ops.a(17523, -5564));
                            arrayList.add((ObjectResult)object);
                            if (n2 == 0) continue;
                        }
                        arrayList2.add(cK_ATTRIBUTEArray);
                        ((ObjectResult)object).setSuccess(true);
                        if (n2 == 0) break block16;
                    }
                    if (bl.booleanValue()) break block17;
                    ((ObjectResult)object).setSuccess(false);
                    ((ObjectResult)object).setReasonIfFail(PKCS11Ops.a(17504, 29409));
                    if (n2 == 0) break block16;
                }
                try {
                    byArray = this.mPKCS11.C_WrapKey(aSessionID, aMechanism, l2, objectIDs[i2]);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    ((ObjectResult)object).setSuccess(false);
                    ((ObjectResult)object).setReasonIfFail(pKCS11Exception.getMessage());
                    arrayList.add((ObjectResult)object);
                    continue;
                }
                cK_ATTRIBUTEArray2 = (CK_ATTRIBUTE[])this.getAttributeTypes();
                cK_ATTRIBUTEArray = this.a(aSessionID, objectIDs[i2], (long[])cK_ATTRIBUTEArray2);
                ESCObject eSCObject = null;
                try {
                    eSCObject = SCObjectUtil.encodeESCObject(byArray, cK_ATTRIBUTEArray);
                }
                catch (ESYAException eSYAException) {
                    ((ObjectResult)object).setSuccess(false);
                    ((ObjectResult)object).setReasonIfFail(PKCS11Ops.a(17490, 11622));
                    arrayList.add((ObjectResult)object);
                    if (n2 == 0) continue;
                }
                arrayList2.add(eSCObject);
                ((ObjectResult)object).setSuccess(true);
            }
            arrayList.add((ObjectResult)object);
            if (n2 == 0) continue;
        }
        wrappedObjectsWithAttributes.setObjectResult(arrayList);
        ESCObjectBag eSCObjectBag = new ESCObjectBag(arrayList2.toArray(new ESCObject[0]));
        object = eSCObjectBag.getEncoded();
        wrappedObjectsWithAttributes.setWrappedObjects((byte[])object);
        return wrappedObjectsWithAttributes;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UnwrapObjectsResults unwrapObjectsWithAttributes(long aSessionID, CK_MECHANISM aMechanism, String wrapperKeyLabel, byte[] wrappedBytes) throws PKCS11Exception, ESYAException {
        long l2 = this.b(aSessionID, wrapperKeyLabel);
        UnwrapObjectsResults unwrapObjectsResults = new UnwrapObjectsResults();
        ESCObjectBag eSCObjectBag = new ESCObjectBag(wrappedBytes);
        ESCObject[] eSCObjectArray = eSCObjectBag.getESCObjects();
        unwrapObjectsResults.setTotalToBeUnwrappedObjects(eSCObjectArray.length);
        ArrayList<ObjectResult> arrayList = new ArrayList<ObjectResult>();
        ESCObject[] eSCObjectArray2 = eSCObjectArray;
        int n2 = c;
        for (ESCObject eSCObject : eSCObjectArray2) {
            ObjectResult objectResult;
            block30: {
                block31: {
                    long l3;
                    Object object;
                    Object object2;
                    int n3;
                    long l4;
                    ArrayList<CK_ATTRIBUTE> arrayList2;
                    block29: {
                        objectResult = new ObjectResult();
                        arrayList2 = new ArrayList<CK_ATTRIBUTE>();
                        l4 = SCObjectUtil.getClassInESCObject(eSCObject);
                        if (l4 != 3L && l4 != 4L) break block29;
                        Object var21_19 = null;
                        ESCObjectAttribute[] eSCObjectAttributeArray = eSCObject.getESCObjectAttributes();
                        n3 = eSCObjectAttributeArray.length;
                        for (int i2 = 0; i2 < n3; ++i2) {
                            ESCObjectAttribute eSCObjectAttribute = eSCObjectAttributeArray[i2];
                            long l5 = ByteConversionUtil.bigEndianBytesToLong(eSCObjectAttribute.getType());
                            if (l5 == 17L) {
                                byte[] byArray = eSCObjectAttribute.getValue();
                                if (n2 == 0) continue;
                            }
                            if (l5 == 358L || l5 == 355L && n2 == 0 || l5 == 353L && n2 == 0 || l5 == 290L || l5 == 288L && n2 == 0 || l5 == 384L && n2 == 0) continue;
                            object2 = eSCObjectAttribute.getValue();
                            CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE(l5, object2);
                            arrayList2.add(cK_ATTRIBUTE);
                            if (n2 == 0) continue;
                        }
                        try {
                            void var21_20;
                            object = this.c(aMechanism.mechanism, (byte[])var21_20);
                            l3 = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, l2, (byte[])object, arrayList2.toArray(new CK_ATTRIBUTE[0]));
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            objectResult.setSuccess(false);
                            objectResult.setReasonIfFail(pKCS11Exception.getMessage());
                            arrayList.add(objectResult);
                            continue;
                        }
                        objectResult.setObjectID(l3);
                        objectResult.setSuccess(true);
                        if (n2 == 0) break block30;
                    }
                    if (l4 != 1L && l4 != 2L) break block31;
                    ESCObjectAttribute[] eSCObjectAttributeArray = eSCObject.getESCObjectAttributes();
                    int n4 = eSCObjectAttributeArray.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        object = eSCObjectAttributeArray[n3];
                        long l6 = ByteConversionUtil.bigEndianBytesToLong(((ESCObjectAttribute)object).getType());
                        if (l6 == 358L || l6 == 355L && n2 == 0 || l6 == 289L && n2 == 0) continue;
                        byte[] byArray = ((ESCObjectAttribute)object).getValue();
                        object2 = new CK_ATTRIBUTE(l6, byArray);
                        arrayList2.add((CK_ATTRIBUTE)object2);
                        if (n2 == 0) continue;
                    }
                    CK_ATTRIBUTE[] cK_ATTRIBUTEArray = arrayList2.toArray(new CK_ATTRIBUTE[0]);
                    try {
                        l3 = this.mPKCS11.C_CreateObject(aSessionID, cK_ATTRIBUTEArray);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        objectResult.setSuccess(false);
                        objectResult.setReasonIfFail(pKCS11Exception.getMessage());
                        arrayList.add(objectResult);
                        continue;
                    }
                    objectResult.setObjectID(l3);
                    objectResult.setSuccess(true);
                    if (n2 == 0) break block30;
                }
                throw new SmartCardException(PKCS11Ops.a(17493, -15751));
            }
            arrayList.add(objectResult);
            if (n2 == 0) continue;
        }
        unwrapObjectsResults.setObjectResult(arrayList);
        return unwrapObjectsResults;
    }

    @Override
    public CK_ATTRIBUTE[] getAllAttributes(long sessionID, long objectID) throws PKCS11Exception {
        long[] lArray = this.getAttributeTypes();
        return this.a(sessionID, objectID, lArray);
    }

    public long[] getAttributeTypes() {
        long[] lArray = PKCS11Names.getAttributeTypes();
        Map<Long, String> map = this.b.getCardTemplate().getVendorSpecificAttributeTypesWithNames();
        if (map == null) {
            return lArray;
        }
        long[] lArray2 = map.keySet().stream().mapToLong(Long::longValue).toArray();
        long[] lArray3 = ArrayUtil.concatArrays(lArray, lArray2);
        return lArray3;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[59];
                var3_1 = 0;
                var2_2 = "\u00e8C\u00c2\u00cdx/\u00805f5\u00e5\u001f\u0084%\b\u00cf\u00fbo\u00c6\u0099\r\u001c\u00a9w\u00ea\u00c2G\u00b6X\u00ba\u008d\u00fd\u00aaY%\u009f\u00f7\u00f1I\"8\u00cb\u00d7cj\u00df\u008fi0g\u00ec\u0080\u0084\u00b5\u00e9\u00c2\u00eb\u01b4\u001bC \n\u0007\u00ed5\u0082\u000e\u00fc6\u00e87\u00a94\u0089WO\n\u0093\u00c7\u00036D\u0186\u000f\u0012\u009b\u00bc\u00c8\u00aaJ\u0084\u00f7\f\u001cK\u0000\u00db\u00e9$msv\u000e\u00bf\u00a3,r\u00b2\u00a6\u0099$'c\u00d0u\u00ef`\u00b6\t\u009c\\\u00c2c\u00ff\u0098\u00fa\u00151D\u00b6'\n\u00f8Vl\u001f\u00f7D\u00ae\u0095\u00cf\u0086\u00ea>\u00fd\u00e9\f\u00cc\u00a2c\u0005^6\fHY\u001az\u00e2\u00a7\u0093\u0004fg\u00f8\u00f5\u00eap\u0016\u000b\u0088\u001c@k\u00af\u0099\u00f05p@\u0085\u00a1\r!\u009eI;\u00e6\u0097\u00c8\u0015-\u00bbP\u00b9A2b;\u001d\u008f\u0004\u0005\u0085\u00a6\u00de2K\u00f5\u00ab,\u00b4\u00cad\u00ca\u00ca\u00fd \u00ee\\5DV\u009c-\u00a7\u00b3\nDf\u00cc\u0001\u00ceY\u0012\u00f0\u008a\u00b9\u00c5\u00ed\u00d5@\u00f6\u0007X`\u00d2\u0094\u00c1\u00b6-\u0081\u00dea\u0099\u00fc.^\u00d9\u0015\u00ccN\u0097\fW<\u00fa\u00af\u0088\u00d4\u0005\u00f8\u0004\u000b\u008b/yC-\u00c1\u0084n\u0019\f\u0084r\u001d\u00e3\u00b9\u00fd8'\u0083\u00a8g\u008e\u001bz\u008e\u00a7\u001e\u0004\u00d7g\u00ce\u00f5,p\u00ce\u000b\u0093\u001c#k\u00c3\u0099}5\u00c1@\u00b3\u00a1\u00cb\u00a4L\u00f3\u00a9~\u0080\u0005\u00aa\u00b9\u00f4\u00c8-Smrv\u0091Ja\u00a6o\u00e4\u000b!y\u000e\u00e7\u00e3\ne\u00d0\u00e3\u00eeI\u00ff\u009c\u00e0\u000b\u008b\u00cf\u009f\u008f\u0096!\u00ce\u0099,\u00b5\u00f6\u00e5\u00898\u0017\u00b0X\u00f1\u00e2 \u0094\u0086z\u00a8\u00f2\u0083F\u00ef\u00bc\u00ee\u00dd\u00c7\u00de\u00c4\"\u00ffb*\u00ffF\"G\u00199\u001b)\u008e\u001dh\u00bd\u0081\u00ca \u00c4\u00dfle\u00b9\u0005\u00cdrHz\u00b3\u00bbCU\u00cc\u00a5b'\u00b8\u00d9{\u00b8!\u0007\u0087\b?\u00f1\u00f3\u00d9J\"\u00bc\u008a\u00dcT\u00d1\u00f7k\u0016\u00ca6\\\u00c0\u00e5\u00fe,lG\u001f)\u00ac\u00d7\u0006\u00bcd \u008a\u00b1\u00b9\u00f9\u00c7+\u001fQ\u00f5\u00d4\u008c\u00bd\u00d5z\u00ed6v\u001d\u0006\u0004TZ\u00e7\u00b6\u00b0\u00d9\u0090\u00bb\u00cb\u00ef\u00e2\u00d9,\u00e2\u00e2\u00b3\u0087\u00beWC0\u0005\u00b7\u00ea7\u000e\b(\u0017\u00eb\u00ceGW\u008aOI\u0097\u00fc3\u00cc\u00959\u0012\u00b5a\u00136\u0003b\u001e]\u00ae\u0091'P\u00b5\u0012\u001a\u00ad\u001a\\4\u00a9\u00026\u00d3\u00d9M!\u0004%\u00cb\u0019\u011d\u000f=8\u00f3\u00a0`m\u0086c\u0090\f\u001d\u00f9]Z\u008a\u0019\u0014\u00f2n\u00c8\by-\u00ed\u00a1\u00ecvM\u00d3hf\u00d3;\u0096i\u0017\u0088_\u0001\u00c3\u00f7Y\u00eaI\u00f9=4\u00e9\u008e\u009b\u00d3\u00da[\r\u00e2`\u00fb\u00ff\u00f2RD\u00cb\u0087\u00e1tp\u0099\u0095H\bn\u00b0j\u00d34q6W<MB\u00d0C\u00aa\u0011\u00af\u00850\u00c3W\u00c2\u00cb\u0092\u00a5\u00fe\u00bf\u00f6G\u00ee{n\u00c7E\u001a\u00d5\u00c5\u00197\u00e6\u00d6\u00be~\u00c3\u00c4!\u0087H\u0012o\u00deNWG\u0093\u00e3\u00c2\u0005\u00a2\u0007\u0091\u00999\u0083^\u008al\u0094\u00f4\u0099.J\u0004\u00b0\u0082f\u0005\u000e\u00e2\u00a4M\u00beF\u0004\u0004R\u001b\u001f\u00f7\u00dc\u0095\u009f\u000bC\u00e5\u00c1\u009cl\u008bF\u00e0w\u00e2s2\u00ef+\u00ac'E\u00f9i#\u00c1\u009a\u00b5s\u0096\nv\u00b3\u00cb&\u00d5\u00a8\u00d0!\u0011\u00da\u00aff\u009c\u001eK>\u00f3\u0003\u00d8\u0019!\u00efP\u00d92\u0094+\u009e>`\u00c2 \u00f4\u009c\u00f4\u00a0\u0014\u0087\u00fd\u00db\u0090\u0092\u00fa\u00f0\u0013\u00ee\u009b\u00d7\u00b8\u0082\u00e4\u008a9\u00a6\u00ab\u00c6w4s\u00d8\u0090\u00b2/?7?\u001b}\u00a71\u0089#dD9!L\u00ef\u0006\u0094\u00b1\u00f8\u00fc\u00c3b3\u00f3R\n\u0091\u00c5\u0086\u009bR\n\u00a5\u009a|\u00f4\u001bd\u000eU\u008d\u00a574?\u001e\u0124 \u00cc\u0001H\u0018\u0007\u00ee\u00d8d\u0005\u0000\u00dd\u0010&\u00d90\u00a5#\u0017\u00be{V\u0018K\u00da\u001e\u00f1]\u00b6\bQ\u00ed\u0086\tc\u0011\u00bd\u001a\u00b9\u00ae\u000fl\u00ff3[i:o\u0097\u00f03\u0002\u00b2\u00be\u00ef\u00ce\u00f6\u00a4\u0014\u00cce>\u00af\u00df\u009d+\u00c5\u00f6\u0091g\n*\u00d91\u00c9N\u0091\u00ee\u00ef\u0088\u00dd\u008e\u0018\u00ca\u0082o4tZ\u00e3o\u008a\u001a\u008f[\u0011\u00ee\u00f0\u000e-\u009a\u0016\u0092\u00d7\u00d6\u0092^G\u00ddh\u0084\u0087\u001f\u001b8f\u00ef\u0003\rtF\u00ba\u00d1\u00a2\u00f4\u001f\u009b\u00a9\u000ed)+\u00d1`<ba\u00c7\u0085E \u0014\u00d4[\u00ea\u00aa\u0088\u00a4|\u00e2Q\u00a9\u00acF\u00c6\u009f\\\u00d5<\u0000`\u00e98\u008e?\u00d1R\u00f0\u00f0\u0007\u00bf\u001fD\u00a9@-\u00d3z\u00fe\u001c0\u00c06\u00fe{\u00c7E0\u008a\u00f0H\u008fF\u0005\u00fd\u0082\nO\u00d9~\u0095!\u00c4AH4\u00b4s\u0010\u001dQ\u00f4\u00ae\u00b8b\u00ad\u00ab\\k-+\u0092\u007f\u0015\u00ca;\u00b27\u00cf\u00f1\u00c3\u00ef|\u0004=>|aNKn\u008b\u00a1\u00d3^i\u00a9R\u009a\u00c8e\u0012\u001cwh\u00be\u0094\u00cd\u00d5\u009c#x4\u0096\u009c1\u00be\u00e6\u00d3)V\u0005,\u0003\u0091\u00c3t\u00b3\u0000\u00df\u00e9z\u00ce6R\u0097\u0096\u0003\u00b2\u009e\u00ef\u00ba\u00e5X\u0019\u009b\u001c,+0\u00c2\u0099)a\u00ebvp\u00c1H\u00bd\u001aJV]D\u0015R\u00c1\u009f\u00a7_$\u001cp \u00ea\u00db\u00b7\u00db\u009d\u00c1j,\u00ca\u00c7_6 G\u00fb9G)\u0005\u001d\u0019\u00bd\u00af\u00ca\u00e5\u00c4glr\u00a8\u00ed\u00cf$x\u00f3\u008e\u00a7\u00a6^JC\u00ea\u00ef\u00b1Q4\u00f4\u001fj\u00bc\u00987p\u00d2\u0017\u00c3(\u00b2\u0093\u00d4\u00ecA\u00eaf\u009dPy\u00d2\u0080\u00ca\u00ab\u00b1\u00a0\u00b3\u00a4[\u0007SB\u001e\u00f1\u00a4\u00adC\u0083\u0013\u00e4m0,\u00a5\u00dfi\u00b9PK\u00c5\u00eb\u001a\u00fa\u0003\u00b7\u00af\u0006\u00e1'\b\u00fd\u00f4q\u00d5+\u00f0\u0018O\u00ebN\u0089\u00cc7\u00f7\u0000u\u00a9\u0013[G\u00e4\u00b9\u00de\u00e7\u00c6=\u00c4Kf\u00e4\u00ec\u00bc\u00f93\u00cdc\u00e9\u00c0NrOW\u00d56\u007f\u008f\u0085\u0011\u00e8\u0090\u00be\u00fdV\u00a4\u00a3\u0085\nw\u00be\u00f3\u00aeJ\u00c5\u00aby\u00ca\u0090\u001a\u0087?\u00faD\u00a9\u000e>A\u00df\u0082}\u00c1\u00cd\u0091\u0015\u00e7\u009dT\u001f}\u0094^&\u0019q\u00e6f\u00abq\u00d2K\u0097\u00b8\u008c\u00f7\u00ebx\f\u00c1\u00a5 <H;c\u00d0E\u00a3\u0090\u00b2\u008a\"\u00a3,\u00d9\u00e7\u0019\bV\u0016\u00e0*a\u0090dV\u00a2\u008d\u00b7\u0002\u001c\u007f\u0006{\u0006C\u00e0\u0089\u00a8\u00b2\u0017\u00cc\u00f3\u0000Sz\u00fa=T\u00e5\u00fe\u00d8\u00a4\u00de\u00c0q\u00b1\u0089\u00d4\u00e85\u00cf*\u000e \u0096\u00ee\u00af\u00fa\u009b\u00b8\u00e6!\u00a4\u000f.P\u0096\u0010\u0095'+\u000f5x\u00bcH\u00b2\u0090\u00bdB.R\u0082o\u00c9\u0006iY7l\u00c3\u0014\u0093\u00d2\u00eb@:-\u00deN\u008bPkMH0\u00e2V\u00c5\u00d0\u00ff\u0018Q|\u00d4\u00ea\u00bb\u000f20\u00aa\u0090\u008a\u0002(&\u00dc\u00a9\fc\u00ad\u00d8A\u00f23\u00e5$\u00d4\u0000<\u0093\u001dF\u00da]1\u00ec\u0088 6F\u00da\u00a7\u00a2\u00fe\u009f\u00b7\u001d>\u00b40\u0083\u0014\u00e3\u00a4\u0001\u0006\u00cf\u0098\u00f5\u0003T\u00b1-Q\u00a2\u00d0B\\\u00a2eg\u00ba\u00ee6\u00e4\u0081\u00bc\u001f%\u008d0}\u0018\u00d2i\u00f63\u00a9\u00e7\u00ab9\u00cba(qD\u0094\u008d\u00b0/1F\u00a8[\u0010A\u00d2(2\u00b3\u00a9'w4\u00f3Gb\u0004\u00b2\rv\u0081\u00aa\u0094\u00a7\u0097\u00a4^\u00f8\u00a1+?\u009bjN$\u001b\\\u009e\u0011\u0017\u0084\u009b\u00aa\u00bf!\u00d3\u001c\u00d5\u00ee\u00b6\u0086e\u00d5\u0080\u0016\u0088\u00a8\"\u0018\u0097a\u00bel\u00c4\u00f8\u00e2F{\u00fb!Q\u00a5\u00a2\u00df\u0081\u00f5\u00938\u00a7\u00d5J^N\u001f\u00d5\u001fv\u00f4\u009e,\u00e3\u00cc=\u0094\r/I\u0098T\u00c8\u007fS\u00d2\b,C\u00feU2@!\u00c6\u00ea\u00f4N\u001a\u00a2\u00f6\u008b{Q\u00f9\u00a5\u00ef\u00c2nqt\u0016HZb\u00b1\u00da\u008f/$\u00ca\u008c\u00adN\u0099[\u001c\u0083\u00d22\u008a[\u0090w\u00fe\u0010R\"j \u00e9\u00f68\u008e\u00ab\u00a2\u001f\u00d2\u00faf\u0083\t9K\u00c71J\u0085\u00a61\u00cfO\u00e8\u0097\u00da\rF\u00d8\u00fc\u000b}\u00a0\u0010\u00abA\u00e0T\u0016)4\u00a3\u008d\u00f4\u00a94\u00b3\u0017\u0014K.\u00bc\u00fa?\u00f3\u0010\t\u00f3\u0095\u00ac\u0007P\u00a8}\u00a8\bp\u00cc\u00df\u00e7\u001b\u0086\u00e5\u00a1r\u0010V\u008a(\u00fbd.\u00ce\u0015\u00c4c\u0084\u009cq\u0096\u00f7\u00070_\u0016\u009f\u0019w\u0097\u00cdO\u00c8\u00dc\u00d6E\u00c6\u00a7\u00b6u\u0011\u00dd\u0007\u00e4!\u00cd\u00d2\u00bf\u0093S.`\u008b\u00166\u00e7_\u0017\u00bb{`U\u00da\u00a5_d\u001b\u001b[a\u00169\u00de\f4~\u008e`\u00c1\u00c8^\u0018\u00a0j\u0018\nS\u00d8p\\+\u0012\u008e\u0012HXN\u001a\u000b\u00ed\u0088\u00ca3\u00dde(\u00b32l\u00eb\u008c6,\u01a2\u00a9\u00ca\u00ec\r:\u00bf>}\t\u00ef\u0005\u00fb\u008f\u00a6\u00c8\u00fe\u000e\u00da}J\u0085\u00a6c\u0018\u00be\u0098\u0082\u0087o\u009b\u00e9,=?\u00d5^k\u00eb\u0094\u00cf,i\r\u00d2t-3nK\u0080\u0081\u00a4\u00d01\u0088\nC\u0098<\u00b4\u00b8\u00e1\u00cc4\\\u00ab\u00e9\t%\u00a3m\u00bcfK\u0096=\u0015J\u00d2\u00b3\u00d5;\u00cd\u00fe\u00eel6\u00d0Y\u00baMx7\u00f1{Wl\u00e4\u0012\u0098\u00c53\t\u00a8\u00bf\u000eH\u0099E\u00be1\u009ar\u00ae*\rr,\u00ba\u00d5M\u00fd\u008c&z\u0094\u00d6\u0088\u009d4*m\u00154\u00b8\u00c12\u00a1\u00add,\u0096\u00c2\u00f7\u00c1\u0015h;\u0017 \u00c7\u009d\u0013\u00e3\u00fbf8\u00e9\u009e\u00d6\u0083C\u0018\u0002w\f\u00ae\u0092\u00a0(M\"\u009a\n}\u00c0's1`\u0085\u008ae\u0083\u0012\u0094E";
                var4_3 = "\u00e8C\u00c2\u00cdx/\u00805f5\u00e5\u001f\u0084%\b\u00cf\u00fbo\u00c6\u0099\r\u001c\u00a9w\u00ea\u00c2G\u00b6X\u00ba\u008d\u00fd\u00aaY%\u009f\u00f7\u00f1I\"8\u00cb\u00d7cj\u00df\u008fi0g\u00ec\u0080\u0084\u00b5\u00e9\u00c2\u00eb\u01b4\u001bC \n\u0007\u00ed5\u0082\u000e\u00fc6\u00e87\u00a94\u0089WO\n\u0093\u00c7\u00036D\u0186\u000f\u0012\u009b\u00bc\u00c8\u00aaJ\u0084\u00f7\f\u001cK\u0000\u00db\u00e9$msv\u000e\u00bf\u00a3,r\u00b2\u00a6\u0099$'c\u00d0u\u00ef`\u00b6\t\u009c\\\u00c2c\u00ff\u0098\u00fa\u00151D\u00b6'\n\u00f8Vl\u001f\u00f7D\u00ae\u0095\u00cf\u0086\u00ea>\u00fd\u00e9\f\u00cc\u00a2c\u0005^6\fHY\u001az\u00e2\u00a7\u0093\u0004fg\u00f8\u00f5\u00eap\u0016\u000b\u0088\u001c@k\u00af\u0099\u00f05p@\u0085\u00a1\r!\u009eI;\u00e6\u0097\u00c8\u0015-\u00bbP\u00b9A2b;\u001d\u008f\u0004\u0005\u0085\u00a6\u00de2K\u00f5\u00ab,\u00b4\u00cad\u00ca\u00ca\u00fd \u00ee\\5DV\u009c-\u00a7\u00b3\nDf\u00cc\u0001\u00ceY\u0012\u00f0\u008a\u00b9\u00c5\u00ed\u00d5@\u00f6\u0007X`\u00d2\u0094\u00c1\u00b6-\u0081\u00dea\u0099\u00fc.^\u00d9\u0015\u00ccN\u0097\fW<\u00fa\u00af\u0088\u00d4\u0005\u00f8\u0004\u000b\u008b/yC-\u00c1\u0084n\u0019\f\u0084r\u001d\u00e3\u00b9\u00fd8'\u0083\u00a8g\u008e\u001bz\u008e\u00a7\u001e\u0004\u00d7g\u00ce\u00f5,p\u00ce\u000b\u0093\u001c#k\u00c3\u0099}5\u00c1@\u00b3\u00a1\u00cb\u00a4L\u00f3\u00a9~\u0080\u0005\u00aa\u00b9\u00f4\u00c8-Smrv\u0091Ja\u00a6o\u00e4\u000b!y\u000e\u00e7\u00e3\ne\u00d0\u00e3\u00eeI\u00ff\u009c\u00e0\u000b\u008b\u00cf\u009f\u008f\u0096!\u00ce\u0099,\u00b5\u00f6\u00e5\u00898\u0017\u00b0X\u00f1\u00e2 \u0094\u0086z\u00a8\u00f2\u0083F\u00ef\u00bc\u00ee\u00dd\u00c7\u00de\u00c4\"\u00ffb*\u00ffF\"G\u00199\u001b)\u008e\u001dh\u00bd\u0081\u00ca \u00c4\u00dfle\u00b9\u0005\u00cdrHz\u00b3\u00bbCU\u00cc\u00a5b'\u00b8\u00d9{\u00b8!\u0007\u0087\b?\u00f1\u00f3\u00d9J\"\u00bc\u008a\u00dcT\u00d1\u00f7k\u0016\u00ca6\\\u00c0\u00e5\u00fe,lG\u001f)\u00ac\u00d7\u0006\u00bcd \u008a\u00b1\u00b9\u00f9\u00c7+\u001fQ\u00f5\u00d4\u008c\u00bd\u00d5z\u00ed6v\u001d\u0006\u0004TZ\u00e7\u00b6\u00b0\u00d9\u0090\u00bb\u00cb\u00ef\u00e2\u00d9,\u00e2\u00e2\u00b3\u0087\u00beWC0\u0005\u00b7\u00ea7\u000e\b(\u0017\u00eb\u00ceGW\u008aOI\u0097\u00fc3\u00cc\u00959\u0012\u00b5a\u00136\u0003b\u001e]\u00ae\u0091'P\u00b5\u0012\u001a\u00ad\u001a\\4\u00a9\u00026\u00d3\u00d9M!\u0004%\u00cb\u0019\u011d\u000f=8\u00f3\u00a0`m\u0086c\u0090\f\u001d\u00f9]Z\u008a\u0019\u0014\u00f2n\u00c8\by-\u00ed\u00a1\u00ecvM\u00d3hf\u00d3;\u0096i\u0017\u0088_\u0001\u00c3\u00f7Y\u00eaI\u00f9=4\u00e9\u008e\u009b\u00d3\u00da[\r\u00e2`\u00fb\u00ff\u00f2RD\u00cb\u0087\u00e1tp\u0099\u0095H\bn\u00b0j\u00d34q6W<MB\u00d0C\u00aa\u0011\u00af\u00850\u00c3W\u00c2\u00cb\u0092\u00a5\u00fe\u00bf\u00f6G\u00ee{n\u00c7E\u001a\u00d5\u00c5\u00197\u00e6\u00d6\u00be~\u00c3\u00c4!\u0087H\u0012o\u00deNWG\u0093\u00e3\u00c2\u0005\u00a2\u0007\u0091\u00999\u0083^\u008al\u0094\u00f4\u0099.J\u0004\u00b0\u0082f\u0005\u000e\u00e2\u00a4M\u00beF\u0004\u0004R\u001b\u001f\u00f7\u00dc\u0095\u009f\u000bC\u00e5\u00c1\u009cl\u008bF\u00e0w\u00e2s2\u00ef+\u00ac'E\u00f9i#\u00c1\u009a\u00b5s\u0096\nv\u00b3\u00cb&\u00d5\u00a8\u00d0!\u0011\u00da\u00aff\u009c\u001eK>\u00f3\u0003\u00d8\u0019!\u00efP\u00d92\u0094+\u009e>`\u00c2 \u00f4\u009c\u00f4\u00a0\u0014\u0087\u00fd\u00db\u0090\u0092\u00fa\u00f0\u0013\u00ee\u009b\u00d7\u00b8\u0082\u00e4\u008a9\u00a6\u00ab\u00c6w4s\u00d8\u0090\u00b2/?7?\u001b}\u00a71\u0089#dD9!L\u00ef\u0006\u0094\u00b1\u00f8\u00fc\u00c3b3\u00f3R\n\u0091\u00c5\u0086\u009bR\n\u00a5\u009a|\u00f4\u001bd\u000eU\u008d\u00a574?\u001e\u0124 \u00cc\u0001H\u0018\u0007\u00ee\u00d8d\u0005\u0000\u00dd\u0010&\u00d90\u00a5#\u0017\u00be{V\u0018K\u00da\u001e\u00f1]\u00b6\bQ\u00ed\u0086\tc\u0011\u00bd\u001a\u00b9\u00ae\u000fl\u00ff3[i:o\u0097\u00f03\u0002\u00b2\u00be\u00ef\u00ce\u00f6\u00a4\u0014\u00cce>\u00af\u00df\u009d+\u00c5\u00f6\u0091g\n*\u00d91\u00c9N\u0091\u00ee\u00ef\u0088\u00dd\u008e\u0018\u00ca\u0082o4tZ\u00e3o\u008a\u001a\u008f[\u0011\u00ee\u00f0\u000e-\u009a\u0016\u0092\u00d7\u00d6\u0092^G\u00ddh\u0084\u0087\u001f\u001b8f\u00ef\u0003\rtF\u00ba\u00d1\u00a2\u00f4\u001f\u009b\u00a9\u000ed)+\u00d1`<ba\u00c7\u0085E \u0014\u00d4[\u00ea\u00aa\u0088\u00a4|\u00e2Q\u00a9\u00acF\u00c6\u009f\\\u00d5<\u0000`\u00e98\u008e?\u00d1R\u00f0\u00f0\u0007\u00bf\u001fD\u00a9@-\u00d3z\u00fe\u001c0\u00c06\u00fe{\u00c7E0\u008a\u00f0H\u008fF\u0005\u00fd\u0082\nO\u00d9~\u0095!\u00c4AH4\u00b4s\u0010\u001dQ\u00f4\u00ae\u00b8b\u00ad\u00ab\\k-+\u0092\u007f\u0015\u00ca;\u00b27\u00cf\u00f1\u00c3\u00ef|\u0004=>|aNKn\u008b\u00a1\u00d3^i\u00a9R\u009a\u00c8e\u0012\u001cwh\u00be\u0094\u00cd\u00d5\u009c#x4\u0096\u009c1\u00be\u00e6\u00d3)V\u0005,\u0003\u0091\u00c3t\u00b3\u0000\u00df\u00e9z\u00ce6R\u0097\u0096\u0003\u00b2\u009e\u00ef\u00ba\u00e5X\u0019\u009b\u001c,+0\u00c2\u0099)a\u00ebvp\u00c1H\u00bd\u001aJV]D\u0015R\u00c1\u009f\u00a7_$\u001cp \u00ea\u00db\u00b7\u00db\u009d\u00c1j,\u00ca\u00c7_6 G\u00fb9G)\u0005\u001d\u0019\u00bd\u00af\u00ca\u00e5\u00c4glr\u00a8\u00ed\u00cf$x\u00f3\u008e\u00a7\u00a6^JC\u00ea\u00ef\u00b1Q4\u00f4\u001fj\u00bc\u00987p\u00d2\u0017\u00c3(\u00b2\u0093\u00d4\u00ecA\u00eaf\u009dPy\u00d2\u0080\u00ca\u00ab\u00b1\u00a0\u00b3\u00a4[\u0007SB\u001e\u00f1\u00a4\u00adC\u0083\u0013\u00e4m0,\u00a5\u00dfi\u00b9PK\u00c5\u00eb\u001a\u00fa\u0003\u00b7\u00af\u0006\u00e1'\b\u00fd\u00f4q\u00d5+\u00f0\u0018O\u00ebN\u0089\u00cc7\u00f7\u0000u\u00a9\u0013[G\u00e4\u00b9\u00de\u00e7\u00c6=\u00c4Kf\u00e4\u00ec\u00bc\u00f93\u00cdc\u00e9\u00c0NrOW\u00d56\u007f\u008f\u0085\u0011\u00e8\u0090\u00be\u00fdV\u00a4\u00a3\u0085\nw\u00be\u00f3\u00aeJ\u00c5\u00aby\u00ca\u0090\u001a\u0087?\u00faD\u00a9\u000e>A\u00df\u0082}\u00c1\u00cd\u0091\u0015\u00e7\u009dT\u001f}\u0094^&\u0019q\u00e6f\u00abq\u00d2K\u0097\u00b8\u008c\u00f7\u00ebx\f\u00c1\u00a5 <H;c\u00d0E\u00a3\u0090\u00b2\u008a\"\u00a3,\u00d9\u00e7\u0019\bV\u0016\u00e0*a\u0090dV\u00a2\u008d\u00b7\u0002\u001c\u007f\u0006{\u0006C\u00e0\u0089\u00a8\u00b2\u0017\u00cc\u00f3\u0000Sz\u00fa=T\u00e5\u00fe\u00d8\u00a4\u00de\u00c0q\u00b1\u0089\u00d4\u00e85\u00cf*\u000e \u0096\u00ee\u00af\u00fa\u009b\u00b8\u00e6!\u00a4\u000f.P\u0096\u0010\u0095'+\u000f5x\u00bcH\u00b2\u0090\u00bdB.R\u0082o\u00c9\u0006iY7l\u00c3\u0014\u0093\u00d2\u00eb@:-\u00deN\u008bPkMH0\u00e2V\u00c5\u00d0\u00ff\u0018Q|\u00d4\u00ea\u00bb\u000f20\u00aa\u0090\u008a\u0002(&\u00dc\u00a9\fc\u00ad\u00d8A\u00f23\u00e5$\u00d4\u0000<\u0093\u001dF\u00da]1\u00ec\u0088 6F\u00da\u00a7\u00a2\u00fe\u009f\u00b7\u001d>\u00b40\u0083\u0014\u00e3\u00a4\u0001\u0006\u00cf\u0098\u00f5\u0003T\u00b1-Q\u00a2\u00d0B\\\u00a2eg\u00ba\u00ee6\u00e4\u0081\u00bc\u001f%\u008d0}\u0018\u00d2i\u00f63\u00a9\u00e7\u00ab9\u00cba(qD\u0094\u008d\u00b0/1F\u00a8[\u0010A\u00d2(2\u00b3\u00a9'w4\u00f3Gb\u0004\u00b2\rv\u0081\u00aa\u0094\u00a7\u0097\u00a4^\u00f8\u00a1+?\u009bjN$\u001b\\\u009e\u0011\u0017\u0084\u009b\u00aa\u00bf!\u00d3\u001c\u00d5\u00ee\u00b6\u0086e\u00d5\u0080\u0016\u0088\u00a8\"\u0018\u0097a\u00bel\u00c4\u00f8\u00e2F{\u00fb!Q\u00a5\u00a2\u00df\u0081\u00f5\u00938\u00a7\u00d5J^N\u001f\u00d5\u001fv\u00f4\u009e,\u00e3\u00cc=\u0094\r/I\u0098T\u00c8\u007fS\u00d2\b,C\u00feU2@!\u00c6\u00ea\u00f4N\u001a\u00a2\u00f6\u008b{Q\u00f9\u00a5\u00ef\u00c2nqt\u0016HZb\u00b1\u00da\u008f/$\u00ca\u008c\u00adN\u0099[\u001c\u0083\u00d22\u008a[\u0090w\u00fe\u0010R\"j \u00e9\u00f68\u008e\u00ab\u00a2\u001f\u00d2\u00faf\u0083\t9K\u00c71J\u0085\u00a61\u00cfO\u00e8\u0097\u00da\rF\u00d8\u00fc\u000b}\u00a0\u0010\u00abA\u00e0T\u0016)4\u00a3\u008d\u00f4\u00a94\u00b3\u0017\u0014K.\u00bc\u00fa?\u00f3\u0010\t\u00f3\u0095\u00ac\u0007P\u00a8}\u00a8\bp\u00cc\u00df\u00e7\u001b\u0086\u00e5\u00a1r\u0010V\u008a(\u00fbd.\u00ce\u0015\u00c4c\u0084\u009cq\u0096\u00f7\u00070_\u0016\u009f\u0019w\u0097\u00cdO\u00c8\u00dc\u00d6E\u00c6\u00a7\u00b6u\u0011\u00dd\u0007\u00e4!\u00cd\u00d2\u00bf\u0093S.`\u008b\u00166\u00e7_\u0017\u00bb{`U\u00da\u00a5_d\u001b\u001b[a\u00169\u00de\f4~\u008e`\u00c1\u00c8^\u0018\u00a0j\u0018\nS\u00d8p\\+\u0012\u008e\u0012HXN\u001a\u000b\u00ed\u0088\u00ca3\u00dde(\u00b32l\u00eb\u008c6,\u01a2\u00a9\u00ca\u00ec\r:\u00bf>}\t\u00ef\u0005\u00fb\u008f\u00a6\u00c8\u00fe\u000e\u00da}J\u0085\u00a6c\u0018\u00be\u0098\u0082\u0087o\u009b\u00e9,=?\u00d5^k\u00eb\u0094\u00cf,i\r\u00d2t-3nK\u0080\u0081\u00a4\u00d01\u0088\nC\u0098<\u00b4\u00b8\u00e1\u00cc4\\\u00ab\u00e9\t%\u00a3m\u00bcfK\u0096=\u0015J\u00d2\u00b3\u00d5;\u00cd\u00fe\u00eel6\u00d0Y\u00baMx7\u00f1{Wl\u00e4\u0012\u0098\u00c53\t\u00a8\u00bf\u000eH\u0099E\u00be1\u009ar\u00ae*\rr,\u00ba\u00d5M\u00fd\u008c&z\u0094\u00d6\u0088\u009d4*m\u00154\u00b8\u00c12\u00a1\u00add,\u0096\u00c2\u00f7\u00c1\u0015h;\u0017 \u00c7\u009d\u0013\u00e3\u00fbf8\u00e9\u009e\u00d6\u0083C\u0018\u0002w\f\u00ae\u0092\u00a0(M\"\u009a\n}\u00c0's1`\u0085\u008ae\u0083\u0012\u0094E".length();
                var1_4 = 105;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u009c#{\u00ab\u009fa\u0014\u0018\u009b\u00f6\u00bd\u0095\u00b2\u00f8+N\u008dnE\u00c8\u00aew3~\u00c9\u0013%u\u00d7{\u0080\u00c8@\u0004\u0012\u00b4Qx\u008a!\u00e2\u00d5\u007f@\u0014%\u00a7\u00d45OW\u0084\u009cNfO\u00bf\u00ba\u00a0\u00d32\u00cd\u00fc^v";
                    var4_3 = "\u009c#{\u00ab\u009fa\u0014\u0018\u009b\u00f6\u00bd\u0095\u00b2\u00f8+N\u008dnE\u00c8\u00aew3~\u00c9\u0013%u\u00d7{\u0080\u00c8@\u0004\u0012\u00b4Qx\u008a!\u00e2\u00d5\u007f@\u0014%\u00a7\u00d45OW\u0084\u009cNfO\u00bf\u00ba\u00a0\u00d32\u00cd\u00fc^v".length();
                    var1_4 = 44;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 87;
                            break;
                        }
                        case 1: {
                            v13 = 93;
                            break;
                        }
                        case 2: {
                            v13 = 85;
                            break;
                        }
                        case 3: {
                            v13 = 73;
                            break;
                        }
                        case 4: {
                            v13 = 42;
                            break;
                        }
                        case 5: {
                            v13 = 21;
                            break;
                        }
                        default: {
                            v13 = 11;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        PKCS11Ops.e = var5;
        PKCS11Ops.f = new String[59];
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0x4440) & 0xFFFF;
        if (f[n4] == null) {
            int n5;
            int n6;
            char[] cArray = e[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 86;
                    break;
                }
                case 1: {
                    n6 = 96;
                    break;
                }
                case 2: {
                    n6 = 5;
                    break;
                }
                case 3: {
                    n6 = 236;
                    break;
                }
                case 4: {
                    n6 = 224;
                    break;
                }
                case 5: {
                    n6 = 155;
                    break;
                }
                case 6: {
                    n6 = 173;
                    break;
                }
                case 7: {
                    n6 = 205;
                    break;
                }
                case 8: {
                    n6 = 239;
                    break;
                }
                case 9: {
                    n6 = 76;
                    break;
                }
                case 10: {
                    n6 = 166;
                    break;
                }
                case 11: {
                    n6 = 12;
                    break;
                }
                case 12: {
                    n6 = 225;
                    break;
                }
                case 13: {
                    n6 = 194;
                    break;
                }
                case 14: {
                    n6 = 229;
                    break;
                }
                case 15: {
                    n6 = 234;
                    break;
                }
                case 16: {
                    n6 = 218;
                    break;
                }
                case 17: {
                    n6 = 183;
                    break;
                }
                case 18: {
                    n6 = 216;
                    break;
                }
                case 19: {
                    n6 = 71;
                    break;
                }
                case 20: {
                    n6 = 100;
                    break;
                }
                case 21: {
                    n6 = 107;
                    break;
                }
                case 22: {
                    n6 = 128;
                    break;
                }
                case 23: {
                    n6 = 27;
                    break;
                }
                case 24: {
                    n6 = 152;
                    break;
                }
                case 25: {
                    n6 = 142;
                    break;
                }
                case 26: {
                    n6 = 195;
                    break;
                }
                case 27: {
                    n6 = 21;
                    break;
                }
                case 28: {
                    n6 = 58;
                    break;
                }
                case 29: {
                    n6 = 90;
                    break;
                }
                case 30: {
                    n6 = 23;
                    break;
                }
                case 31: {
                    n6 = 143;
                    break;
                }
                case 32: {
                    n6 = 133;
                    break;
                }
                case 33: {
                    n6 = 213;
                    break;
                }
                case 34: {
                    n6 = 84;
                    break;
                }
                case 35: {
                    n6 = 112;
                    break;
                }
                case 36: {
                    n6 = 10;
                    break;
                }
                case 37: {
                    n6 = 119;
                    break;
                }
                case 38: {
                    n6 = 203;
                    break;
                }
                case 39: {
                    n6 = 145;
                    break;
                }
                case 40: {
                    n6 = 250;
                    break;
                }
                case 41: {
                    n6 = 65;
                    break;
                }
                case 42: {
                    n6 = 148;
                    break;
                }
                case 43: {
                    n6 = 74;
                    break;
                }
                case 44: {
                    n6 = 46;
                    break;
                }
                case 45: {
                    n6 = 48;
                    break;
                }
                case 46: {
                    n6 = 95;
                    break;
                }
                case 47: {
                    n6 = 245;
                    break;
                }
                case 48: {
                    n6 = 17;
                    break;
                }
                case 49: {
                    n6 = 30;
                    break;
                }
                case 50: {
                    n6 = 78;
                    break;
                }
                case 51: {
                    n6 = 37;
                    break;
                }
                case 52: {
                    n6 = 93;
                    break;
                }
                case 53: {
                    n6 = 111;
                    break;
                }
                case 54: {
                    n6 = 40;
                    break;
                }
                case 55: {
                    n6 = 167;
                    break;
                }
                case 56: {
                    n6 = 140;
                    break;
                }
                case 57: {
                    n6 = 240;
                    break;
                }
                case 58: {
                    n6 = 42;
                    break;
                }
                case 59: {
                    n6 = 129;
                    break;
                }
                case 60: {
                    n6 = 57;
                    break;
                }
                case 61: {
                    n6 = 185;
                    break;
                }
                case 62: {
                    n6 = 233;
                    break;
                }
                case 63: {
                    n6 = 34;
                    break;
                }
                case 64: {
                    n6 = 201;
                    break;
                }
                case 65: {
                    n6 = 49;
                    break;
                }
                case 66: {
                    n6 = 253;
                    break;
                }
                case 67: {
                    n6 = 151;
                    break;
                }
                case 68: {
                    n6 = 11;
                    break;
                }
                case 69: {
                    n6 = 182;
                    break;
                }
                case 70: {
                    n6 = 51;
                    break;
                }
                case 71: {
                    n6 = 163;
                    break;
                }
                case 72: {
                    n6 = 149;
                    break;
                }
                case 73: {
                    n6 = 238;
                    break;
                }
                case 74: {
                    n6 = 235;
                    break;
                }
                case 75: {
                    n6 = 206;
                    break;
                }
                case 76: {
                    n6 = 7;
                    break;
                }
                case 77: {
                    n6 = 176;
                    break;
                }
                case 78: {
                    n6 = 104;
                    break;
                }
                case 79: {
                    n6 = 81;
                    break;
                }
                case 80: {
                    n6 = 123;
                    break;
                }
                case 81: {
                    n6 = 254;
                    break;
                }
                case 82: {
                    n6 = 47;
                    break;
                }
                case 83: {
                    n6 = 181;
                    break;
                }
                case 84: {
                    n6 = 131;
                    break;
                }
                case 85: {
                    n6 = 62;
                    break;
                }
                case 86: {
                    n6 = 97;
                    break;
                }
                case 87: {
                    n6 = 162;
                    break;
                }
                case 88: {
                    n6 = 150;
                    break;
                }
                case 89: {
                    n6 = 109;
                    break;
                }
                case 90: {
                    n6 = 113;
                    break;
                }
                case 91: {
                    n6 = 130;
                    break;
                }
                case 92: {
                    n6 = 44;
                    break;
                }
                case 93: {
                    n6 = 52;
                    break;
                }
                case 94: {
                    n6 = 79;
                    break;
                }
                case 95: {
                    n6 = 137;
                    break;
                }
                case 96: {
                    n6 = 1;
                    break;
                }
                case 97: {
                    n6 = 70;
                    break;
                }
                case 98: {
                    n6 = 45;
                    break;
                }
                case 99: {
                    n6 = 207;
                    break;
                }
                case 100: {
                    n6 = 19;
                    break;
                }
                case 101: {
                    n6 = 170;
                    break;
                }
                case 102: {
                    n6 = 24;
                    break;
                }
                case 103: {
                    n6 = 184;
                    break;
                }
                case 104: {
                    n6 = 160;
                    break;
                }
                case 105: {
                    n6 = 243;
                    break;
                }
                case 106: {
                    n6 = 89;
                    break;
                }
                case 107: {
                    n6 = 190;
                    break;
                }
                case 108: {
                    n6 = 72;
                    break;
                }
                case 109: {
                    n6 = 139;
                    break;
                }
                case 110: {
                    n6 = 237;
                    break;
                }
                case 111: {
                    n6 = 41;
                    break;
                }
                case 112: {
                    n6 = 35;
                    break;
                }
                case 113: {
                    n6 = 241;
                    break;
                }
                case 114: {
                    n6 = 68;
                    break;
                }
                case 115: {
                    n6 = 246;
                    break;
                }
                case 116: {
                    n6 = 222;
                    break;
                }
                case 117: {
                    n6 = 188;
                    break;
                }
                case 118: {
                    n6 = 15;
                    break;
                }
                case 119: {
                    n6 = 159;
                    break;
                }
                case 120: {
                    n6 = 144;
                    break;
                }
                case 121: {
                    n6 = 53;
                    break;
                }
                case 122: {
                    n6 = 242;
                    break;
                }
                case 123: {
                    n6 = 103;
                    break;
                }
                case 124: {
                    n6 = 66;
                    break;
                }
                case 125: {
                    n6 = 91;
                    break;
                }
                case 126: {
                    n6 = 172;
                    break;
                }
                case 127: {
                    n6 = 14;
                    break;
                }
                case 128: {
                    n6 = 247;
                    break;
                }
                case 129: {
                    n6 = 197;
                    break;
                }
                case 130: {
                    n6 = 16;
                    break;
                }
                case 131: {
                    n6 = 200;
                    break;
                }
                case 132: {
                    n6 = 180;
                    break;
                }
                case 133: {
                    n6 = 193;
                    break;
                }
                case 134: {
                    n6 = 2;
                    break;
                }
                case 135: {
                    n6 = 121;
                    break;
                }
                case 136: {
                    n6 = 220;
                    break;
                }
                case 137: {
                    n6 = 215;
                    break;
                }
                case 138: {
                    n6 = 26;
                    break;
                }
                case 139: {
                    n6 = 116;
                    break;
                }
                case 140: {
                    n6 = 105;
                    break;
                }
                case 141: {
                    n6 = 124;
                    break;
                }
                case 142: {
                    n6 = 94;
                    break;
                }
                case 143: {
                    n6 = 98;
                    break;
                }
                case 144: {
                    n6 = 230;
                    break;
                }
                case 145: {
                    n6 = 29;
                    break;
                }
                case 146: {
                    n6 = 217;
                    break;
                }
                case 147: {
                    n6 = 80;
                    break;
                }
                case 148: {
                    n6 = 101;
                    break;
                }
                case 149: {
                    n6 = 20;
                    break;
                }
                case 150: {
                    n6 = 255;
                    break;
                }
                case 151: {
                    n6 = 28;
                    break;
                }
                case 152: {
                    n6 = 187;
                    break;
                }
                case 153: {
                    n6 = 211;
                    break;
                }
                case 154: {
                    n6 = 189;
                    break;
                }
                case 155: {
                    n6 = 208;
                    break;
                }
                case 156: {
                    n6 = 18;
                    break;
                }
                case 157: {
                    n6 = 120;
                    break;
                }
                case 158: {
                    n6 = 102;
                    break;
                }
                case 159: {
                    n6 = 136;
                    break;
                }
                case 160: {
                    n6 = 202;
                    break;
                }
                case 161: {
                    n6 = 196;
                    break;
                }
                case 162: {
                    n6 = 92;
                    break;
                }
                case 163: {
                    n6 = 204;
                    break;
                }
                case 164: {
                    n6 = 73;
                    break;
                }
                case 165: {
                    n6 = 164;
                    break;
                }
                case 166: {
                    n6 = 212;
                    break;
                }
                case 167: {
                    n6 = 223;
                    break;
                }
                case 168: {
                    n6 = 156;
                    break;
                }
                case 169: {
                    n6 = 67;
                    break;
                }
                case 170: {
                    n6 = 221;
                    break;
                }
                case 171: {
                    n6 = 9;
                    break;
                }
                case 172: {
                    n6 = 43;
                    break;
                }
                case 173: {
                    n6 = 127;
                    break;
                }
                case 174: {
                    n6 = 199;
                    break;
                }
                case 175: {
                    n6 = 126;
                    break;
                }
                case 176: {
                    n6 = 61;
                    break;
                }
                case 177: {
                    n6 = 249;
                    break;
                }
                case 178: {
                    n6 = 56;
                    break;
                }
                case 179: {
                    n6 = 179;
                    break;
                }
                case 180: {
                    n6 = 132;
                    break;
                }
                case 181: {
                    n6 = 118;
                    break;
                }
                case 182: {
                    n6 = 3;
                    break;
                }
                case 183: {
                    n6 = 36;
                    break;
                }
                case 184: {
                    n6 = 171;
                    break;
                }
                case 185: {
                    n6 = 114;
                    break;
                }
                case 186: {
                    n6 = 174;
                    break;
                }
                case 187: {
                    n6 = 177;
                    break;
                }
                case 188: {
                    n6 = 54;
                    break;
                }
                case 189: {
                    n6 = 8;
                    break;
                }
                case 190: {
                    n6 = 82;
                    break;
                }
                case 191: {
                    n6 = 198;
                    break;
                }
                case 192: {
                    n6 = 226;
                    break;
                }
                case 193: {
                    n6 = 178;
                    break;
                }
                case 194: {
                    n6 = 168;
                    break;
                }
                case 195: {
                    n6 = 228;
                    break;
                }
                case 196: {
                    n6 = 134;
                    break;
                }
                case 197: {
                    n6 = 175;
                    break;
                }
                case 198: {
                    n6 = 117;
                    break;
                }
                case 199: {
                    n6 = 153;
                    break;
                }
                case 200: {
                    n6 = 141;
                    break;
                }
                case 201: {
                    n6 = 122;
                    break;
                }
                case 202: {
                    n6 = 251;
                    break;
                }
                case 203: {
                    n6 = 110;
                    break;
                }
                case 204: {
                    n6 = 248;
                    break;
                }
                case 205: {
                    n6 = 32;
                    break;
                }
                case 206: {
                    n6 = 209;
                    break;
                }
                case 207: {
                    n6 = 75;
                    break;
                }
                case 208: {
                    n6 = 244;
                    break;
                }
                case 209: {
                    n6 = 147;
                    break;
                }
                case 210: {
                    n6 = 22;
                    break;
                }
                case 211: {
                    n6 = 227;
                    break;
                }
                case 212: {
                    n6 = 77;
                    break;
                }
                case 213: {
                    n6 = 63;
                    break;
                }
                case 214: {
                    n6 = 135;
                    break;
                }
                case 215: {
                    n6 = 115;
                    break;
                }
                case 216: {
                    n6 = 192;
                    break;
                }
                case 217: {
                    n6 = 219;
                    break;
                }
                case 218: {
                    n6 = 13;
                    break;
                }
                case 219: {
                    n6 = 138;
                    break;
                }
                case 220: {
                    n6 = 4;
                    break;
                }
                case 221: {
                    n6 = 59;
                    break;
                }
                case 222: {
                    n6 = 165;
                    break;
                }
                case 223: {
                    n6 = 232;
                    break;
                }
                case 224: {
                    n6 = 25;
                    break;
                }
                case 225: {
                    n6 = 55;
                    break;
                }
                case 226: {
                    n6 = 85;
                    break;
                }
                case 227: {
                    n6 = 125;
                    break;
                }
                case 228: {
                    n6 = 38;
                    break;
                }
                case 229: {
                    n6 = 60;
                    break;
                }
                case 230: {
                    n6 = 31;
                    break;
                }
                case 231: {
                    n6 = 186;
                    break;
                }
                case 232: {
                    n6 = 169;
                    break;
                }
                case 233: {
                    n6 = 50;
                    break;
                }
                case 234: {
                    n6 = 0;
                    break;
                }
                case 235: {
                    n6 = 69;
                    break;
                }
                case 236: {
                    n6 = 108;
                    break;
                }
                case 237: {
                    n6 = 231;
                    break;
                }
                case 238: {
                    n6 = 83;
                    break;
                }
                case 239: {
                    n6 = 88;
                    break;
                }
                case 240: {
                    n6 = 64;
                    break;
                }
                case 241: {
                    n6 = 99;
                    break;
                }
                case 242: {
                    n6 = 157;
                    break;
                }
                case 243: {
                    n6 = 210;
                    break;
                }
                case 244: {
                    n6 = 39;
                    break;
                }
                case 245: {
                    n6 = 33;
                    break;
                }
                case 246: {
                    n6 = 214;
                    break;
                }
                case 247: {
                    n6 = 6;
                    break;
                }
                case 248: {
                    n6 = 146;
                    break;
                }
                case 249: {
                    n6 = 87;
                    break;
                }
                case 250: {
                    n6 = 161;
                    break;
                }
                case 251: {
                    n6 = 106;
                    break;
                }
                case 252: {
                    n6 = 158;
                    break;
                }
                case 253: {
                    n6 = 191;
                    break;
                }
                case 254: {
                    n6 = 252;
                    break;
                }
                default: {
                    n6 = 154;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            PKCS11Ops.f[n4] = new String(cArray).intern();
        }
        return f[n4];
    }
}

