/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.ATR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.DerOutputStream;
import tr.gov.tubitak.uekae.esya.api.common.util.BigIntegerUtil;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.KeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECKeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECPublicKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.AkisOps;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.IPKCS11Ops;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.CardTemplate;

public class AkisTemplate
extends CardTemplate {
    protected static Logger logger;
    public static long CKA_SENSITIVE_EC_PARAMS;
    public static List<String> ATR_HASHES;
    public static List<String> HISTORICAL_BYTE_REGEXES;
    private static final String[] c;
    private static final String[] d;

    public AkisTemplate(CardType aCardType) {
        super(aCardType);
    }

    @Override
    public synchronized IPKCS11Ops getPKCS11Ops() {
        if (this.mIslem == null) {
            this.mIslem = new AkisOps(this.cardType);
        }
        return this.mIslem;
    }

    public static boolean isAkisATR(String atrHex) {
        String string = AkisTemplate.b(-24665, 31638);
        boolean bl = CardTemplate.b;
        String string2 = AkisTemplate.b(-24688, 29310);
        if (atrHex.contains(string) || atrHex.contains(string2)) {
            return true;
        }
        ATR aTR = new ATR(StringUtil.toByteArray(atrHex));
        byte[] byArray = aTR.getHistoricalBytes();
        String string3 = StringUtil.toHexString(byArray);
        for (String string4 : HISTORICAL_BYTE_REGEXES) {
            boolean bl2 = string3.matches(string4);
            if (bl2) {
                return true;
            }
            if (!bl) continue;
        }
        return false;
    }

    @Override
    public List<List<CK_ATTRIBUTE>> getCertSerialNumberTemplates(byte[] aSerialNumber) {
        List<List<CK_ATTRIBUTE>> list = super.getCertSerialNumberTemplates(aSerialNumber);
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE(0L, 1L);
        CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE(2L, false);
        CK_ATTRIBUTE cK_ATTRIBUTE3 = new CK_ATTRIBUTE(1L, true);
        BigInteger bigInteger = new BigInteger(1, aSerialNumber);
        ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
        arrayList.add(cK_ATTRIBUTE);
        arrayList.add(cK_ATTRIBUTE2);
        arrayList.add(new CK_ATTRIBUTE(130L, bigInteger.toString(16)));
        arrayList.add(cK_ATTRIBUTE3);
        ArrayList<CK_ATTRIBUTE> arrayList2 = new ArrayList<CK_ATTRIBUTE>();
        arrayList2.add(cK_ATTRIBUTE);
        boolean bl = CardTemplate.b;
        arrayList2.add(cK_ATTRIBUTE2);
        arrayList2.add(new CK_ATTRIBUTE(130L, aSerialNumber.toString()));
        arrayList2.add(cK_ATTRIBUTE3);
        String string = new BigInteger(aSerialNumber).toString(16);
        CharsetEncoder charsetEncoder = Charset.forName(AkisTemplate.b(-24683, 11743)).newEncoder();
        ByteBuffer byteBuffer = null;
        for (int i2 = 0; i2 <= aSerialNumber.length * 2 - string.length(); ++i2) {
            string = '0' + string;
            if (!bl) continue;
        }
        try {
            byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string.toCharArray()));
        }
        catch (CharacterCodingException characterCodingException) {
            logger.warn(AkisTemplate.b(-24663, -15299), characterCodingException);
        }
        ArrayList<CK_ATTRIBUTE> arrayList3 = new ArrayList<CK_ATTRIBUTE>();
        arrayList3.add(cK_ATTRIBUTE);
        arrayList3.add(cK_ATTRIBUTE2);
        arrayList3.add(new CK_ATTRIBUTE(130L, byteBuffer.array()));
        arrayList3.add(cK_ATTRIBUTE3);
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putInteger(new BigInteger(aSerialNumber));
        }
        catch (Exception exception) {
            logger.warn(AkisTemplate.b(-24649, 14546), exception);
        }
        byte[] byArray = derOutputStream.toByteArray();
        ArrayList<CK_ATTRIBUTE> arrayList4 = new ArrayList<CK_ATTRIBUTE>();
        arrayList4.add(cK_ATTRIBUTE);
        arrayList4.add(cK_ATTRIBUTE2);
        arrayList4.add(new CK_ATTRIBUTE(130L, byArray));
        arrayList4.add(cK_ATTRIBUTE3);
        list.add(arrayList);
        list.add(arrayList2);
        list.add(arrayList3);
        list.add(arrayList4);
        return list;
    }

    @Override
    public List<CK_ATTRIBUTE> getRSAPublicKeyImportTemplate(String aLabel, RSAPrivateCrtKey aPrivKey, X509Certificate aCert, boolean aIsSign, boolean aIsEncrypt) {
        byte[] byArray = BigIntegerUtil.toByteArrayWithoutSignByte(aPrivKey.getModulus());
        List<CK_ATTRIBUTE> list = super.getRSAPublicKeyImportTemplate(aLabel, aPrivKey, aCert, aIsSign, aIsEncrypt);
        list.add(new CK_ATTRIBUTE(289L, byArray.length * 8));
        return list;
    }

    @Override
    public void applyTemplate(KeyPairTemplate template) throws SmartCardException {
        block10: {
            if (template instanceof ECKeyPairTemplate) {
                block9: {
                    ECPublicKeyTemplate eCPublicKeyTemplate = (ECPublicKeyTemplate)template.getPublicKeyTemplate();
                    if (eCPublicKeyTemplate == null) break block9;
                    eCPublicKeyTemplate.getAsExplicitECParameters();
                    if (!eCPublicKeyTemplate.isSecretECCurve()) break block9;
                    eCPublicKeyTemplate.add(new CK_ATTRIBUTE(CKA_SENSITIVE_EC_PARAMS, true));
                }
                ECKeyTemplate eCKeyTemplate = (ECKeyTemplate)template.getPrivateKeyTemplate();
                if (eCKeyTemplate == null || !eCKeyTemplate.isSecretECCurve()) break block10;
                eCKeyTemplate.add(new CK_ATTRIBUTE(CKA_SENSITIVE_EC_PARAMS, true));
            }
        }
    }

    @Override
    public String[] getATRHashes() {
        return ATR_HASHES.toArray(new String[0]);
    }

    public static void addATR(String aATR) {
        ATR_HASHES.add(aATR);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[38];
                var3_1 = 0;
                var2_2 = "i\u00be\u0087\u008a\u001eb\u00a6j\u008e\u00a3\u0094l\u00ac\u00ee{'\u0014c\u00c6\u00b5X?;f.\u008d\u001b~r\u00c8\u000e\u0090H!\u008cj\u00eb\f\u0003 \u00fc\u00ae\u00c38g\u0006ay^\u00f4\u00d8\u00e3\u009f\u00d4m\u0018\u00b5\u00e8k\u00d6a\u00ed\u008as\u001f\u00de!\u00a1<\u0099\u00ad.<\u00f3Ho\u0006\u00af@>;B)2d8-\u009b\u000f-\f\u00f9\u0080\u0095\u00acv\u00ed\u00a3\u0002\u00f2n\u0081xJ;\u00b7V\u00beI\u00b58\u00b9\u00fb\u0096[\u00cf\u00c7\u0002.\u0005\u00b0o\u0007\u00e2\u00a3\u00dc\u009e\u00a8V[\u00b0*h\u00e4\u00916n+\u00d2d\u00d75\u0088}\u0002\u00d2\u00c4\u00f2\u0006\u00dc\u00d8p\u00c6\u00c5\u00d4\u008f<?\u00c9W\u00fb\u0090g\u00b7\u00be.\u009c\r\\\u00b0\u0084T\u0010A1\u00adh\u00cfL\u0087(l\u00af\u00d3\u0018&\u0002n\u00fc\t\u00e7LC\u0000F1}\\\u009buB\u00e6\u00cb\u00beh\u00d8\u00f1\u00ba\u001aJ\u00ef\u00c5.\u00dd\u00det\u00ca\u0081\u001b\u00b0\u00a8%\u0090\u00eah\u001cs\"\u00f2\u00ee\u00000\\\u0007!)\u00e0\u0086qo\u00a7\u00c3\u00c5\u00cd\u00c2\u008d\u00a6\u0080\u009c\u0093\u00f1c1\u0090\u00876\u00e9f1\u0017\u0098\u0012\u007f<\u0092\u00b1\u00d7\u009e':\u00dd\u008d\u000f\u0017\u00bf\u00cd,W\u0014\u00bd;\tp.t\u00ebAl'\u00ced3\u00bf\u00e3\u00b9\u0006v\u00beoKG5\u0005\u00b9\u00a1\u00ba\u008d%j\u00b70r\u00ae\u00d0P\u0001\u0006\u009e\u000b\u00dfV]\u0004\u00e50~|\u00d7V\u00d0.\u0016Q\r;\u00ae$Un\u0099H}s\u00ee\u0010|\u009e%\u008fI\u00ee(P\u00bcxL\u001c\u00f4\u00076~@\u00d7g''\u00e8\u00d3\u00bb\u00b49&\u00e5\u00be\u00a4\u000f\u00c6.r\u001e\u0081\u00d2?\u0019g\u00c9\u00df\u00bc\u00b5\u00ed\u00f7\u00c3_\u00e4A\u00c0\u00c5\u0007\u00b9m\u008e\u00df\n\u00e8<\u0099/\u00add\u00ae\u0004kKa^\u008a\u0005\u001f\u0010!x<\u00d2\u00ad\u001e\u00e5i\u0016s/2\u00e4\u00ec?E\u007fE\u00d1\u00cb\u00c9\u009c\u008c\u00e9\u00a5\u00c3\u008503dw\u0083\u0012\u00d1x<.w)!4+\u00c5\u00e5R\u008f\u00cf\u00bf\u0083\u00b6\u000ew]D\u00f7e\u00e1\u00ad\u00b1\fDZ\u009b6\u00f7n`H\u0016\u0005]k\u00a7ZR\u0085\u0004\u0000BzP\u0096#.sT\u00a1\u009b35\u00ef\u00e9\u00ce\u00b8\u0097m\u00b3\u00d3\u00d7\u00e6P\u0080\u00e7\u000f\u00fdl\u0006\u00ff\u001b\u00ec\u001e\u0019k\u00bd\u00ef\u00af\u0016(\t\t\u0016\u0087\f\u00be1\u0015\\\u00ba&\u007f.\u00a3\u001e\u00bb\u00d2x\u0019\u008f\u00c9\u00c2\u00bc\u0016\u00ed\u0083\u00c3\u00d1\u00e4\u0090\u00c2\u00ff\u0004\u00fe*\u0016\u0081a]\u0093\"\\u>\u00d4\u00f3dO\u00c4j\u00fa\\Pw\u00ab\u00cah\u00f9\u0082.\u001d^l\u00da\u0082\u0019\u00d0\u00e8)\u0098ki,S$\u00f6.\u0080(L\u0004#<\u00a0\u00ffy@\u00a6&\u00e5q\u00c6\u001a&r\u008c\u00cd\u00f3\u00a8q\u00e9\u008f\u0019\u00e8\u008f\u0011.)\u00af\u00ea\u00e4R\u00de\u00ca\u0010j\u0087\u0003\u008a!/\u0085y\u001aq\u00aer\u00d4\u00e4R^\u00c8`\u00a6\u0085\u00fa\u0081\u00eaJi\u00b7\u001c\u00be\u0000\u00b5\u0011\u00b9\u00de\u0096\u00ff\u00cf\\s.S;\u00a5v\u00b3\u008e\u00ffX\u00cc\u008e\u00d7\u00ab\u00bb\u000b\u00d6\u00fdp\u00e3\u00e3c}\u00e1\u0016N\u0019\u00da^\u00dfce\u00ea\u00b42K\u008de\u0086\n\u001e\u000fs#\u0014|+\u00a5.!\u00e8\u00eb\fr\u00c3\u00ce\u00b3\u00ea\u00f3\u0013\u0004#\u00fe\u00c5C\u00126\u00af\u009a\u00f4\u00f9\"\u00fb<\u00128\u00c4)G\u0090\u0092&\u00ac\u00f5\u00dd=\u00d9\u00b64*'a\u00f9\u0080\u00c5.Aq\u00e7?\u00f3\u00a4\u00fe~\u00ecJ\u00d33;\u0018\u00c6\u009fr\u00af\u00a3\u00eau\u00d0\u0017h9\u001eZG\u00e3v\u00fd\u00d47\u0005-\u00ac\u00923\u009c(#\u00c7\u001e\u00e0\u001e5.\u00fc\u0086P\u00c1\r~(\u00806\u0095\u0088\u00c8Pg\u00abp\u00dfR\u0016U\u00c3'\u00c1\u0096\u00e3\u00c1\u0001\u00bc\u0088\t\u00979\u009d\u00faxS8\u00cc\u00c9\u00d7\u00898K\u001f\u00c0\u00cb.\u00bb4\u00b8\u0097\u0018\u00b0\u0083\u00ddC>&\u00bd\u0085\u00c9\u0011\u00a5\u0088\u00ea\u00fc\u0001\u009e\u008ak\u0094\u0091\u00dd\u0085[\u0097\u0011GX\u00dc\u00f5\u00aa\u00f6\u00d6\u00bc\u00cb\u0098\u0085\u00b2\u0094K2\u0094\u0018\u00e4\u00006](\u0098`5RH\u008b\u0011OA\u0007\u00d2\u009b\u00dd7bf\u00c5\u00fc9\n\u00c9\u00ba=\u00ac\t\u00bf\u0001\u00e7\u0099}.\u0094,]\u0094\u00a4\u00d1\u0014\u00d0\u00b1\u009fx\u0089NOhu\u00a7\u00f0\u0019B\"\u00e2\u008d\u0099\u0012\u007f\u00fdf\u0091\u00fd\u0087\u00c5\u00c4F\u00a9\u0080\u00b6r\u00c7A\u0004\u0089\u00a4,4\t\u0017E\u009e\u00c4\u00ad\u00e5\u00839\u00d8\u00fa\u00f2f\u0094x4Q\u00a9\u00f1\u00db\u00af,L;\u009e.\u0014XM\u001a\u00a6\u0000T\u00ea\u00b9\u00d8yanRl\u00d6'\u0086\t\u00cf t\u00bd\u00fcl\u008c\u00f0\u0015\u00b6?S\u009ffM\u0007\u00a5\u00d7\u00124\f6C\u00bcpN\\.\u00fe\u00c2\u0010I\rj!\u00a7\u0017q\u00acT\u00d4\u00f4;\u0002\u00cd\u001cT\u009c\u008b\u001e\u00c8\u00b1\u00c2%% \f\u009atO\u00fc\u00b0T\u001a\u00bd\u00e5y\u00f2\u009f\u009c\u0089\u008b\u0098^.d\u009cC\u0082g\u0013l\u0088\u00be\u0094\u0099\u00e8rc\u00ef\u00f0WB\u0007W\u00e1g\u0085\u009ek\u00c0\u0010\u009c\u00aa\r\u00d8\u00bb\u001e\u00e8\b\u00116\u0084\b\u00de\u00b1\u0019L;#N.\u00ae\u00df\u001a\u00eaL\u001e\t)\u0012\u00a0\fn\u00c0\u00b3\u00b9\u00ea\u009d\u0003^<\u00ca-\u00e6c\u00c7BF\u00ea\u00c7'M\u009e\u009d-\u0082\u00ed\u00d3\u00dfk\u00f4\u0091?\u0016\u00fa\u0015\u00a2.`\u008b\u00c3`wOn\u0003\u00fe\u00e5\u0091\u00c6s\u00a6\u00cfHSU\u0087\u00b5\u00f1;\u0087\u0015+\u00b1\u0018\u00b2\u00ab\u00c9\u00f0\u0003\u0012\u00de\u0089\u00d7\u0006\\\u000e\u00c5qzTWS\u00c3.\u0011:\u00edV\u00b2\u0089\u00d6\u00db\u00e9\u00fes\u00a5/\u00caD\u00c5\"\u00e4\u00a9\u00834\u00fd?\u00cd<\u00aa\u00fa\u00d1\u00f7\u00a4s\u008fkO\u00a6\u00e5\u00e3\u001a\u00b2\r\u00e6c\u00a6t~\u00a4&\u0014\u00926D\u00d5+;iV\u0089\u009b?\u009b\u0013\u00e2\u00f4x:\u0080\u001a0\u00b9\u00bf\u00af,\u00ff\u00fe\u00fa\u00b5`\u00b5\u0090\u00f9\u00bb\u00de\u0081\u00f0\u00e0.\u00c8:\u00d6V\u00d5\u0088:\u00dat\u00de\u00c0\u00a1YJ\u008a\u00d5\u00fb\u00e4\u0092\u00c0S\u00b2\u00d6\u0092\u00a2?\u00ebfS\u00f4\u00df\u00e4\u00cfb\u00c8\u0004\u009a\u00e2BS\u00b4\u00cb\u00b2d\u00faq\n#c \u0097\u00ea\u00d8=\u000b^\u00e0.\u0005\u00b6o\u00c7\u00e2\u00ba\u00dc\u009c\u00a8\u0016[\u00b8*i\u00e4\u00b16h+Qd\u0080E\u00d4\u000b\u00f7\u00dew\u00f5\u00df\u000b\u0081U\u00ce\u009b\u0091\u00f0P\u000f\u0005\u001d\u0001\u0087=P+\u001e'\u00d8NG$\u00f7\u0085s\t\u001c\u00fa\u0090\"\u0096\u00f3P\u0018\u0092\u00f3s\u00b5b\u0081\u00ea\u00fe\u0013o\u00a0\u0097\f";
                var4_3 = "i\u00be\u0087\u008a\u001eb\u00a6j\u008e\u00a3\u0094l\u00ac\u00ee{'\u0014c\u00c6\u00b5X?;f.\u008d\u001b~r\u00c8\u000e\u0090H!\u008cj\u00eb\f\u0003 \u00fc\u00ae\u00c38g\u0006ay^\u00f4\u00d8\u00e3\u009f\u00d4m\u0018\u00b5\u00e8k\u00d6a\u00ed\u008as\u001f\u00de!\u00a1<\u0099\u00ad.<\u00f3Ho\u0006\u00af@>;B)2d8-\u009b\u000f-\f\u00f9\u0080\u0095\u00acv\u00ed\u00a3\u0002\u00f2n\u0081xJ;\u00b7V\u00beI\u00b58\u00b9\u00fb\u0096[\u00cf\u00c7\u0002.\u0005\u00b0o\u0007\u00e2\u00a3\u00dc\u009e\u00a8V[\u00b0*h\u00e4\u00916n+\u00d2d\u00d75\u0088}\u0002\u00d2\u00c4\u00f2\u0006\u00dc\u00d8p\u00c6\u00c5\u00d4\u008f<?\u00c9W\u00fb\u0090g\u00b7\u00be.\u009c\r\\\u00b0\u0084T\u0010A1\u00adh\u00cfL\u0087(l\u00af\u00d3\u0018&\u0002n\u00fc\t\u00e7LC\u0000F1}\\\u009buB\u00e6\u00cb\u00beh\u00d8\u00f1\u00ba\u001aJ\u00ef\u00c5.\u00dd\u00det\u00ca\u0081\u001b\u00b0\u00a8%\u0090\u00eah\u001cs\"\u00f2\u00ee\u00000\\\u0007!)\u00e0\u0086qo\u00a7\u00c3\u00c5\u00cd\u00c2\u008d\u00a6\u0080\u009c\u0093\u00f1c1\u0090\u00876\u00e9f1\u0017\u0098\u0012\u007f<\u0092\u00b1\u00d7\u009e':\u00dd\u008d\u000f\u0017\u00bf\u00cd,W\u0014\u00bd;\tp.t\u00ebAl'\u00ced3\u00bf\u00e3\u00b9\u0006v\u00beoKG5\u0005\u00b9\u00a1\u00ba\u008d%j\u00b70r\u00ae\u00d0P\u0001\u0006\u009e\u000b\u00dfV]\u0004\u00e50~|\u00d7V\u00d0.\u0016Q\r;\u00ae$Un\u0099H}s\u00ee\u0010|\u009e%\u008fI\u00ee(P\u00bcxL\u001c\u00f4\u00076~@\u00d7g''\u00e8\u00d3\u00bb\u00b49&\u00e5\u00be\u00a4\u000f\u00c6.r\u001e\u0081\u00d2?\u0019g\u00c9\u00df\u00bc\u00b5\u00ed\u00f7\u00c3_\u00e4A\u00c0\u00c5\u0007\u00b9m\u008e\u00df\n\u00e8<\u0099/\u00add\u00ae\u0004kKa^\u008a\u0005\u001f\u0010!x<\u00d2\u00ad\u001e\u00e5i\u0016s/2\u00e4\u00ec?E\u007fE\u00d1\u00cb\u00c9\u009c\u008c\u00e9\u00a5\u00c3\u008503dw\u0083\u0012\u00d1x<.w)!4+\u00c5\u00e5R\u008f\u00cf\u00bf\u0083\u00b6\u000ew]D\u00f7e\u00e1\u00ad\u00b1\fDZ\u009b6\u00f7n`H\u0016\u0005]k\u00a7ZR\u0085\u0004\u0000BzP\u0096#.sT\u00a1\u009b35\u00ef\u00e9\u00ce\u00b8\u0097m\u00b3\u00d3\u00d7\u00e6P\u0080\u00e7\u000f\u00fdl\u0006\u00ff\u001b\u00ec\u001e\u0019k\u00bd\u00ef\u00af\u0016(\t\t\u0016\u0087\f\u00be1\u0015\\\u00ba&\u007f.\u00a3\u001e\u00bb\u00d2x\u0019\u008f\u00c9\u00c2\u00bc\u0016\u00ed\u0083\u00c3\u00d1\u00e4\u0090\u00c2\u00ff\u0004\u00fe*\u0016\u0081a]\u0093\"\\u>\u00d4\u00f3dO\u00c4j\u00fa\\Pw\u00ab\u00cah\u00f9\u0082.\u001d^l\u00da\u0082\u0019\u00d0\u00e8)\u0098ki,S$\u00f6.\u0080(L\u0004#<\u00a0\u00ffy@\u00a6&\u00e5q\u00c6\u001a&r\u008c\u00cd\u00f3\u00a8q\u00e9\u008f\u0019\u00e8\u008f\u0011.)\u00af\u00ea\u00e4R\u00de\u00ca\u0010j\u0087\u0003\u008a!/\u0085y\u001aq\u00aer\u00d4\u00e4R^\u00c8`\u00a6\u0085\u00fa\u0081\u00eaJi\u00b7\u001c\u00be\u0000\u00b5\u0011\u00b9\u00de\u0096\u00ff\u00cf\\s.S;\u00a5v\u00b3\u008e\u00ffX\u00cc\u008e\u00d7\u00ab\u00bb\u000b\u00d6\u00fdp\u00e3\u00e3c}\u00e1\u0016N\u0019\u00da^\u00dfce\u00ea\u00b42K\u008de\u0086\n\u001e\u000fs#\u0014|+\u00a5.!\u00e8\u00eb\fr\u00c3\u00ce\u00b3\u00ea\u00f3\u0013\u0004#\u00fe\u00c5C\u00126\u00af\u009a\u00f4\u00f9\"\u00fb<\u00128\u00c4)G\u0090\u0092&\u00ac\u00f5\u00dd=\u00d9\u00b64*'a\u00f9\u0080\u00c5.Aq\u00e7?\u00f3\u00a4\u00fe~\u00ecJ\u00d33;\u0018\u00c6\u009fr\u00af\u00a3\u00eau\u00d0\u0017h9\u001eZG\u00e3v\u00fd\u00d47\u0005-\u00ac\u00923\u009c(#\u00c7\u001e\u00e0\u001e5.\u00fc\u0086P\u00c1\r~(\u00806\u0095\u0088\u00c8Pg\u00abp\u00dfR\u0016U\u00c3'\u00c1\u0096\u00e3\u00c1\u0001\u00bc\u0088\t\u00979\u009d\u00faxS8\u00cc\u00c9\u00d7\u00898K\u001f\u00c0\u00cb.\u00bb4\u00b8\u0097\u0018\u00b0\u0083\u00ddC>&\u00bd\u0085\u00c9\u0011\u00a5\u0088\u00ea\u00fc\u0001\u009e\u008ak\u0094\u0091\u00dd\u0085[\u0097\u0011GX\u00dc\u00f5\u00aa\u00f6\u00d6\u00bc\u00cb\u0098\u0085\u00b2\u0094K2\u0094\u0018\u00e4\u00006](\u0098`5RH\u008b\u0011OA\u0007\u00d2\u009b\u00dd7bf\u00c5\u00fc9\n\u00c9\u00ba=\u00ac\t\u00bf\u0001\u00e7\u0099}.\u0094,]\u0094\u00a4\u00d1\u0014\u00d0\u00b1\u009fx\u0089NOhu\u00a7\u00f0\u0019B\"\u00e2\u008d\u0099\u0012\u007f\u00fdf\u0091\u00fd\u0087\u00c5\u00c4F\u00a9\u0080\u00b6r\u00c7A\u0004\u0089\u00a4,4\t\u0017E\u009e\u00c4\u00ad\u00e5\u00839\u00d8\u00fa\u00f2f\u0094x4Q\u00a9\u00f1\u00db\u00af,L;\u009e.\u0014XM\u001a\u00a6\u0000T\u00ea\u00b9\u00d8yanRl\u00d6'\u0086\t\u00cf t\u00bd\u00fcl\u008c\u00f0\u0015\u00b6?S\u009ffM\u0007\u00a5\u00d7\u00124\f6C\u00bcpN\\.\u00fe\u00c2\u0010I\rj!\u00a7\u0017q\u00acT\u00d4\u00f4;\u0002\u00cd\u001cT\u009c\u008b\u001e\u00c8\u00b1\u00c2%% \f\u009atO\u00fc\u00b0T\u001a\u00bd\u00e5y\u00f2\u009f\u009c\u0089\u008b\u0098^.d\u009cC\u0082g\u0013l\u0088\u00be\u0094\u0099\u00e8rc\u00ef\u00f0WB\u0007W\u00e1g\u0085\u009ek\u00c0\u0010\u009c\u00aa\r\u00d8\u00bb\u001e\u00e8\b\u00116\u0084\b\u00de\u00b1\u0019L;#N.\u00ae\u00df\u001a\u00eaL\u001e\t)\u0012\u00a0\fn\u00c0\u00b3\u00b9\u00ea\u009d\u0003^<\u00ca-\u00e6c\u00c7BF\u00ea\u00c7'M\u009e\u009d-\u0082\u00ed\u00d3\u00dfk\u00f4\u0091?\u0016\u00fa\u0015\u00a2.`\u008b\u00c3`wOn\u0003\u00fe\u00e5\u0091\u00c6s\u00a6\u00cfHSU\u0087\u00b5\u00f1;\u0087\u0015+\u00b1\u0018\u00b2\u00ab\u00c9\u00f0\u0003\u0012\u00de\u0089\u00d7\u0006\\\u000e\u00c5qzTWS\u00c3.\u0011:\u00edV\u00b2\u0089\u00d6\u00db\u00e9\u00fes\u00a5/\u00caD\u00c5\"\u00e4\u00a9\u00834\u00fd?\u00cd<\u00aa\u00fa\u00d1\u00f7\u00a4s\u008fkO\u00a6\u00e5\u00e3\u001a\u00b2\r\u00e6c\u00a6t~\u00a4&\u0014\u00926D\u00d5+;iV\u0089\u009b?\u009b\u0013\u00e2\u00f4x:\u0080\u001a0\u00b9\u00bf\u00af,\u00ff\u00fe\u00fa\u00b5`\u00b5\u0090\u00f9\u00bb\u00de\u0081\u00f0\u00e0.\u00c8:\u00d6V\u00d5\u0088:\u00dat\u00de\u00c0\u00a1YJ\u008a\u00d5\u00fb\u00e4\u0092\u00c0S\u00b2\u00d6\u0092\u00a2?\u00ebfS\u00f4\u00df\u00e4\u00cfb\u00c8\u0004\u009a\u00e2BS\u00b4\u00cb\u00b2d\u00faq\n#c \u0097\u00ea\u00d8=\u000b^\u00e0.\u0005\u00b6o\u00c7\u00e2\u00ba\u00dc\u009c\u00a8\u0016[\u00b8*i\u00e4\u00b16h+Qd\u0080E\u00d4\u000b\u00f7\u00dew\u00f5\u00df\u000b\u0081U\u00ce\u009b\u0091\u00f0P\u000f\u0005\u001d\u0001\u0087=P+\u001e'\u00d8NG$\u00f7\u0085s\t\u001c\u00fa\u0090\"\u0096\u00f3P\u0018\u0092\u00f3s\u00b5b\u0081\u00ea\u00fe\u0013o\u00a0\u0097\f".length();
                var1_4 = 24;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "VhFD~\u00c3cU\u00ed&.\u00ac\u00c7Z\u00e9D~\b%2!\b^@\u00b5\u00a9*\u009f\u0019\u001e<\u00c2\n\u00e13\u00e7u\u0081*\u0098\u00db\u00e6f\u00ae\u00b4\u001e\u009a\u00f4\u00f5P\u00f0\u00ba\u00dc-\u0083\fX";
                    var4_3 = "VhFD~\u00c3cU\u00ed&.\u00ac\u00c7Z\u00e9D~\b%2!\b^@\u00b5\u00a9*\u009f\u0019\u001e<\u00c2\n\u00e13\u00e7u\u0081*\u0098\u00db\u00e6f\u00ae\u00b4\u001e\u009a\u00f4\u00f5P\u00f0\u00ba\u00dc-\u0083\fX".length();
                    var1_4 = 10;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 12;
                            break;
                        }
                        case 1: {
                            v13 = 90;
                            break;
                        }
                        case 2: {
                            v13 = 34;
                            break;
                        }
                        case 3: {
                            v13 = 22;
                            break;
                        }
                        case 4: {
                            v13 = 108;
                            break;
                        }
                        case 5: {
                            v13 = 57;
                            break;
                        }
                        default: {
                            v13 = 43;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        AkisTemplate.c = var5;
        AkisTemplate.d = new String[38];
        AkisTemplate.logger = LoggerFactory.getLogger(AkisTemplate.class);
        AkisTemplate.CKA_SENSITIVE_EC_PARAMS = 0x80000001L;
        AkisTemplate.ATR_HASHES = new ArrayList<String>();
        AkisTemplate.HISTORICAL_BYTE_REGEXES = new ArrayList<String>();
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24658, -29651));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24664, 16941));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24650, -9678));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24646, -3318));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24648, 4697));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24669, 23408));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24671, 18320));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24647, -4402));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24670, 26765));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24643, -27757));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24656, 1203));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24654, 15823));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24659, -15732));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24657, -22862));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24662, 21804));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24660, 10741));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24684, 30764));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24661, -12105));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24687, -1329));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24672, -18202));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24653, -2032));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24652, -25416));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24641, -808));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24685, 17359));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24642, -18923));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24666, -7848));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24644, 22252));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24651, 11707));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(-24667, -25099));
        AkisTemplate.HISTORICAL_BYTE_REGEXES.add(AkisTemplate.b(-24686, 19886));
        AkisTemplate.HISTORICAL_BYTE_REGEXES.add(AkisTemplate.b(-24645, 20510));
        AkisTemplate.HISTORICAL_BYTE_REGEXES.add(AkisTemplate.b(-24655, -377));
        AkisTemplate.HISTORICAL_BYTE_REGEXES.add(AkisTemplate.b(-24668, 26573));
    }

    private static String b(int n2, int n3) {
        int n4 = (n2 ^ 0xFFFF9FB1) & 0xFFFF;
        if (d[n4] == null) {
            int n5;
            int n6;
            char[] cArray = c[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 223;
                    break;
                }
                case 1: {
                    n6 = 52;
                    break;
                }
                case 2: {
                    n6 = 184;
                    break;
                }
                case 3: {
                    n6 = 140;
                    break;
                }
                case 4: {
                    n6 = 43;
                    break;
                }
                case 5: {
                    n6 = 148;
                    break;
                }
                case 6: {
                    n6 = 130;
                    break;
                }
                case 7: {
                    n6 = 3;
                    break;
                }
                case 8: {
                    n6 = 160;
                    break;
                }
                case 9: {
                    n6 = 149;
                    break;
                }
                case 10: {
                    n6 = 189;
                    break;
                }
                case 11: {
                    n6 = 195;
                    break;
                }
                case 12: {
                    n6 = 109;
                    break;
                }
                case 13: {
                    n6 = 158;
                    break;
                }
                case 14: {
                    n6 = 34;
                    break;
                }
                case 15: {
                    n6 = 239;
                    break;
                }
                case 16: {
                    n6 = 139;
                    break;
                }
                case 17: {
                    n6 = 182;
                    break;
                }
                case 18: {
                    n6 = 108;
                    break;
                }
                case 19: {
                    n6 = 175;
                    break;
                }
                case 20: {
                    n6 = 207;
                    break;
                }
                case 21: {
                    n6 = 19;
                    break;
                }
                case 22: {
                    n6 = 163;
                    break;
                }
                case 23: {
                    n6 = 179;
                    break;
                }
                case 24: {
                    n6 = 2;
                    break;
                }
                case 25: {
                    n6 = 0;
                    break;
                }
                case 26: {
                    n6 = 165;
                    break;
                }
                case 27: {
                    n6 = 100;
                    break;
                }
                case 28: {
                    n6 = 129;
                    break;
                }
                case 29: {
                    n6 = 132;
                    break;
                }
                case 30: {
                    n6 = 174;
                    break;
                }
                case 31: {
                    n6 = 183;
                    break;
                }
                case 32: {
                    n6 = 90;
                    break;
                }
                case 33: {
                    n6 = 8;
                    break;
                }
                case 34: {
                    n6 = 128;
                    break;
                }
                case 35: {
                    n6 = 213;
                    break;
                }
                case 36: {
                    n6 = 177;
                    break;
                }
                case 37: {
                    n6 = 255;
                    break;
                }
                case 38: {
                    n6 = 75;
                    break;
                }
                case 39: {
                    n6 = 27;
                    break;
                }
                case 40: {
                    n6 = 116;
                    break;
                }
                case 41: {
                    n6 = 22;
                    break;
                }
                case 42: {
                    n6 = 176;
                    break;
                }
                case 43: {
                    n6 = 155;
                    break;
                }
                case 44: {
                    n6 = 118;
                    break;
                }
                case 45: {
                    n6 = 200;
                    break;
                }
                case 46: {
                    n6 = 247;
                    break;
                }
                case 47: {
                    n6 = 102;
                    break;
                }
                case 48: {
                    n6 = 13;
                    break;
                }
                case 49: {
                    n6 = 53;
                    break;
                }
                case 50: {
                    n6 = 215;
                    break;
                }
                case 51: {
                    n6 = 250;
                    break;
                }
                case 52: {
                    n6 = 64;
                    break;
                }
                case 53: {
                    n6 = 146;
                    break;
                }
                case 54: {
                    n6 = 248;
                    break;
                }
                case 55: {
                    n6 = 92;
                    break;
                }
                case 56: {
                    n6 = 87;
                    break;
                }
                case 57: {
                    n6 = 198;
                    break;
                }
                case 58: {
                    n6 = 86;
                    break;
                }
                case 59: {
                    n6 = 237;
                    break;
                }
                case 60: {
                    n6 = 124;
                    break;
                }
                case 61: {
                    n6 = 229;
                    break;
                }
                case 62: {
                    n6 = 39;
                    break;
                }
                case 63: {
                    n6 = 21;
                    break;
                }
                case 64: {
                    n6 = 65;
                    break;
                }
                case 65: {
                    n6 = 115;
                    break;
                }
                case 66: {
                    n6 = 203;
                    break;
                }
                case 67: {
                    n6 = 47;
                    break;
                }
                case 68: {
                    n6 = 233;
                    break;
                }
                case 69: {
                    n6 = 245;
                    break;
                }
                case 70: {
                    n6 = 6;
                    break;
                }
                case 71: {
                    n6 = 70;
                    break;
                }
                case 72: {
                    n6 = 49;
                    break;
                }
                case 73: {
                    n6 = 31;
                    break;
                }
                case 74: {
                    n6 = 57;
                    break;
                }
                case 75: {
                    n6 = 134;
                    break;
                }
                case 76: {
                    n6 = 208;
                    break;
                }
                case 77: {
                    n6 = 242;
                    break;
                }
                case 78: {
                    n6 = 40;
                    break;
                }
                case 79: {
                    n6 = 32;
                    break;
                }
                case 80: {
                    n6 = 97;
                    break;
                }
                case 81: {
                    n6 = 37;
                    break;
                }
                case 82: {
                    n6 = 141;
                    break;
                }
                case 83: {
                    n6 = 187;
                    break;
                }
                case 84: {
                    n6 = 190;
                    break;
                }
                case 85: {
                    n6 = 45;
                    break;
                }
                case 86: {
                    n6 = 94;
                    break;
                }
                case 87: {
                    n6 = 95;
                    break;
                }
                case 88: {
                    n6 = 226;
                    break;
                }
                case 89: {
                    n6 = 136;
                    break;
                }
                case 90: {
                    n6 = 204;
                    break;
                }
                case 91: {
                    n6 = 249;
                    break;
                }
                case 92: {
                    n6 = 186;
                    break;
                }
                case 93: {
                    n6 = 234;
                    break;
                }
                case 94: {
                    n6 = 54;
                    break;
                }
                case 95: {
                    n6 = 36;
                    break;
                }
                case 96: {
                    n6 = 236;
                    break;
                }
                case 97: {
                    n6 = 4;
                    break;
                }
                case 98: {
                    n6 = 196;
                    break;
                }
                case 99: {
                    n6 = 125;
                    break;
                }
                case 100: {
                    n6 = 220;
                    break;
                }
                case 101: {
                    n6 = 42;
                    break;
                }
                case 102: {
                    n6 = 110;
                    break;
                }
                case 103: {
                    n6 = 67;
                    break;
                }
                case 104: {
                    n6 = 209;
                    break;
                }
                case 105: {
                    n6 = 151;
                    break;
                }
                case 106: {
                    n6 = 227;
                    break;
                }
                case 107: {
                    n6 = 180;
                    break;
                }
                case 108: {
                    n6 = 150;
                    break;
                }
                case 109: {
                    n6 = 135;
                    break;
                }
                case 110: {
                    n6 = 188;
                    break;
                }
                case 111: {
                    n6 = 199;
                    break;
                }
                case 112: {
                    n6 = 159;
                    break;
                }
                case 113: {
                    n6 = 17;
                    break;
                }
                case 114: {
                    n6 = 167;
                    break;
                }
                case 115: {
                    n6 = 93;
                    break;
                }
                case 116: {
                    n6 = 114;
                    break;
                }
                case 117: {
                    n6 = 63;
                    break;
                }
                case 118: {
                    n6 = 117;
                    break;
                }
                case 119: {
                    n6 = 147;
                    break;
                }
                case 120: {
                    n6 = 231;
                    break;
                }
                case 121: {
                    n6 = 35;
                    break;
                }
                case 122: {
                    n6 = 60;
                    break;
                }
                case 123: {
                    n6 = 194;
                    break;
                }
                case 124: {
                    n6 = 55;
                    break;
                }
                case 125: {
                    n6 = 154;
                    break;
                }
                case 126: {
                    n6 = 12;
                    break;
                }
                case 127: {
                    n6 = 71;
                    break;
                }
                case 128: {
                    n6 = 62;
                    break;
                }
                case 129: {
                    n6 = 1;
                    break;
                }
                case 130: {
                    n6 = 119;
                    break;
                }
                case 131: {
                    n6 = 18;
                    break;
                }
                case 132: {
                    n6 = 104;
                    break;
                }
                case 133: {
                    n6 = 105;
                    break;
                }
                case 134: {
                    n6 = 96;
                    break;
                }
                case 135: {
                    n6 = 106;
                    break;
                }
                case 136: {
                    n6 = 112;
                    break;
                }
                case 137: {
                    n6 = 126;
                    break;
                }
                case 138: {
                    n6 = 41;
                    break;
                }
                case 139: {
                    n6 = 68;
                    break;
                }
                case 140: {
                    n6 = 131;
                    break;
                }
                case 141: {
                    n6 = 99;
                    break;
                }
                case 142: {
                    n6 = 26;
                    break;
                }
                case 143: {
                    n6 = 5;
                    break;
                }
                case 144: {
                    n6 = 24;
                    break;
                }
                case 145: {
                    n6 = 145;
                    break;
                }
                case 146: {
                    n6 = 217;
                    break;
                }
                case 147: {
                    n6 = 81;
                    break;
                }
                case 148: {
                    n6 = 15;
                    break;
                }
                case 149: {
                    n6 = 228;
                    break;
                }
                case 150: {
                    n6 = 107;
                    break;
                }
                case 151: {
                    n6 = 123;
                    break;
                }
                case 152: {
                    n6 = 173;
                    break;
                }
                case 153: {
                    n6 = 197;
                    break;
                }
                case 154: {
                    n6 = 162;
                    break;
                }
                case 155: {
                    n6 = 137;
                    break;
                }
                case 156: {
                    n6 = 73;
                    break;
                }
                case 157: {
                    n6 = 76;
                    break;
                }
                case 158: {
                    n6 = 91;
                    break;
                }
                case 159: {
                    n6 = 101;
                    break;
                }
                case 160: {
                    n6 = 153;
                    break;
                }
                case 161: {
                    n6 = 48;
                    break;
                }
                case 162: {
                    n6 = 251;
                    break;
                }
                case 163: {
                    n6 = 218;
                    break;
                }
                case 164: {
                    n6 = 44;
                    break;
                }
                case 165: {
                    n6 = 85;
                    break;
                }
                case 166: {
                    n6 = 25;
                    break;
                }
                case 167: {
                    n6 = 144;
                    break;
                }
                case 168: {
                    n6 = 127;
                    break;
                }
                case 169: {
                    n6 = 168;
                    break;
                }
                case 170: {
                    n6 = 66;
                    break;
                }
                case 171: {
                    n6 = 143;
                    break;
                }
                case 172: {
                    n6 = 83;
                    break;
                }
                case 173: {
                    n6 = 178;
                    break;
                }
                case 174: {
                    n6 = 254;
                    break;
                }
                case 175: {
                    n6 = 80;
                    break;
                }
                case 176: {
                    n6 = 121;
                    break;
                }
                case 177: {
                    n6 = 46;
                    break;
                }
                case 178: {
                    n6 = 79;
                    break;
                }
                case 179: {
                    n6 = 61;
                    break;
                }
                case 180: {
                    n6 = 16;
                    break;
                }
                case 181: {
                    n6 = 84;
                    break;
                }
                case 182: {
                    n6 = 161;
                    break;
                }
                case 183: {
                    n6 = 113;
                    break;
                }
                case 184: {
                    n6 = 235;
                    break;
                }
                case 185: {
                    n6 = 193;
                    break;
                }
                case 186: {
                    n6 = 252;
                    break;
                }
                case 187: {
                    n6 = 210;
                    break;
                }
                case 188: {
                    n6 = 181;
                    break;
                }
                case 189: {
                    n6 = 7;
                    break;
                }
                case 190: {
                    n6 = 191;
                    break;
                }
                case 191: {
                    n6 = 88;
                    break;
                }
                case 192: {
                    n6 = 224;
                    break;
                }
                case 193: {
                    n6 = 33;
                    break;
                }
                case 194: {
                    n6 = 164;
                    break;
                }
                case 195: {
                    n6 = 192;
                    break;
                }
                case 196: {
                    n6 = 216;
                    break;
                }
                case 197: {
                    n6 = 166;
                    break;
                }
                case 198: {
                    n6 = 157;
                    break;
                }
                case 199: {
                    n6 = 222;
                    break;
                }
                case 200: {
                    n6 = 225;
                    break;
                }
                case 201: {
                    n6 = 243;
                    break;
                }
                case 202: {
                    n6 = 69;
                    break;
                }
                case 203: {
                    n6 = 10;
                    break;
                }
                case 204: {
                    n6 = 170;
                    break;
                }
                case 205: {
                    n6 = 74;
                    break;
                }
                case 206: {
                    n6 = 171;
                    break;
                }
                case 207: {
                    n6 = 9;
                    break;
                }
                case 208: {
                    n6 = 20;
                    break;
                }
                case 209: {
                    n6 = 214;
                    break;
                }
                case 210: {
                    n6 = 58;
                    break;
                }
                case 211: {
                    n6 = 30;
                    break;
                }
                case 212: {
                    n6 = 120;
                    break;
                }
                case 213: {
                    n6 = 14;
                    break;
                }
                case 214: {
                    n6 = 82;
                    break;
                }
                case 215: {
                    n6 = 51;
                    break;
                }
                case 216: {
                    n6 = 29;
                    break;
                }
                case 217: {
                    n6 = 78;
                    break;
                }
                case 218: {
                    n6 = 72;
                    break;
                }
                case 219: {
                    n6 = 38;
                    break;
                }
                case 220: {
                    n6 = 98;
                    break;
                }
                case 221: {
                    n6 = 206;
                    break;
                }
                case 222: {
                    n6 = 230;
                    break;
                }
                case 223: {
                    n6 = 138;
                    break;
                }
                case 224: {
                    n6 = 238;
                    break;
                }
                case 225: {
                    n6 = 211;
                    break;
                }
                case 226: {
                    n6 = 244;
                    break;
                }
                case 227: {
                    n6 = 185;
                    break;
                }
                case 228: {
                    n6 = 152;
                    break;
                }
                case 229: {
                    n6 = 28;
                    break;
                }
                case 230: {
                    n6 = 219;
                    break;
                }
                case 231: {
                    n6 = 122;
                    break;
                }
                case 232: {
                    n6 = 253;
                    break;
                }
                case 233: {
                    n6 = 77;
                    break;
                }
                case 234: {
                    n6 = 240;
                    break;
                }
                case 235: {
                    n6 = 232;
                    break;
                }
                case 236: {
                    n6 = 103;
                    break;
                }
                case 237: {
                    n6 = 89;
                    break;
                }
                case 238: {
                    n6 = 205;
                    break;
                }
                case 239: {
                    n6 = 221;
                    break;
                }
                case 240: {
                    n6 = 202;
                    break;
                }
                case 241: {
                    n6 = 59;
                    break;
                }
                case 242: {
                    n6 = 246;
                    break;
                }
                case 243: {
                    n6 = 142;
                    break;
                }
                case 244: {
                    n6 = 156;
                    break;
                }
                case 245: {
                    n6 = 201;
                    break;
                }
                case 246: {
                    n6 = 23;
                    break;
                }
                case 247: {
                    n6 = 133;
                    break;
                }
                case 248: {
                    n6 = 56;
                    break;
                }
                case 249: {
                    n6 = 11;
                    break;
                }
                case 250: {
                    n6 = 169;
                    break;
                }
                case 251: {
                    n6 = 50;
                    break;
                }
                case 252: {
                    n6 = 111;
                    break;
                }
                case 253: {
                    n6 = 212;
                    break;
                }
                case 254: {
                    n6 = 241;
                    break;
                }
                default: {
                    n6 = 172;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            AkisTemplate.d[n4] = new String(cArray).intern();
        }
        return d[n4];
    }
}

