/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.sessionpool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.sessionpool.ObjectSessionInfo;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.sessionpool.SessionQueue;

public class HSMSessionPool {
    private static Logger a;
    public static int DEFAULT_MAX_CAPACITY_PER_KEY;
    public static int DEFAULT_TIMEOUT_INSECONDS;
    private ConcurrentHashMap<String, SessionQueue> b;
    private ArrayList<ObjectSessionInfo> c;
    private SmartCard d;
    private long e;
    private int f;
    private int g;
    public static int h;
    private static final String[] i;
    private static final String[] j;

    private HSMSessionPool() {
        try {
            LV.getInstance().checkLD(LV.Urunler.AKILLIKART);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(HSMSessionPool.a(-8733, -21856) + lE.getMessage(), lE);
        }
    }

    public HSMSessionPool(CardType cardType, long slotNo, String pin, int maxCapacityPerKey, int timeoutInSeconds) throws PKCS11Exception, IOException {
        this();
        this.c = new ArrayList();
        this.b = new ConcurrentHashMap();
        int n2 = h;
        this.e = slotNo;
        this.f = maxCapacityPerKey;
        this.g = timeoutInSeconds;
        this.a(cardType, pin);
        if (SmartCardException.b != 0) {
            h = ++n2;
        }
    }

    public HSMSessionPool(CardType cardType, long slotNo, String pin) throws PKCS11Exception, IOException {
        this(cardType, slotNo, pin, DEFAULT_MAX_CAPACITY_PER_KEY, DEFAULT_TIMEOUT_INSECONDS);
    }

    public CardType getCardType() {
        return this.d.getCardType();
    }

    private void a(CardType cardType, String string) throws PKCS11Exception, IOException {
        this.d = new SmartCard(cardType);
        long l2 = this.d.openSession(this.e);
        try {
            this.d.login(l2, string);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() != 256L) {
                throw pKCS11Exception;
            }
        }
        ObjectSessionInfo objectSessionInfo = new ObjectSessionInfo(l2, 0L, "");
        this.c.add(objectSessionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectSessionInfo a(SessionQueue sessionQueue, String string) throws PKCS11Exception, SmartCardException, InterruptedException {
        long l2 = 0L;
        long l3 = this.d.openSession(this.e);
        if (!StringUtil.isNullorEmpty(string)) {
            l2 = this.a(l3, string);
        }
        ObjectSessionInfo objectSessionInfo = new ObjectSessionInfo(l3, l2, string);
        ArrayList<ObjectSessionInfo> arrayList = this.c;
        synchronized (arrayList) {
            this.c.add(objectSessionInfo);
        }
        sessionQueue.increaseActiveSessionCount();
        return objectSessionInfo;
    }

    private long a(long l2, String string) throws SmartCardException, PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        cK_ATTRIBUTEArray[0].type = 3L;
        cK_ATTRIBUTEArray[0].pValue = string;
        long[] lArray = this.d.findObjects(l2, cK_ATTRIBUTEArray);
        if (lArray.length == 1) {
            return lArray[0];
        }
        if (lArray.length == 0) {
            throw new SmartCardException(string + HSMSessionPool.a(-8729, -7897));
        }
        return this.a(string, l2, lArray);
    }

    private long a(String string, long l2, long[] lArray) throws PKCS11Exception, SmartCardException {
        int n2 = 0;
        int n3 = h;
        long l3 = 0L;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        cK_ATTRIBUTEArray[0].type = 0L;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            this.d.getAttributeValue(l2, lArray[i2], cK_ATTRIBUTEArray);
            long l4 = cK_ATTRIBUTEArray[0].getLong();
            if (l4 != 3L && l4 != 4L) continue;
            ++n2;
            l3 = lArray[i2];
            if (n3 == 0) continue;
        }
        if (n2 > 1) {
            throw new SmartCardException(HSMSessionPool.a(-8731, -23174) + string);
        }
        return l3;
    }

    public synchronized ObjectSessionInfo checkOutItem(String label) throws PKCS11Exception, ESYAException, InterruptedException {
        SessionQueue sessionQueue = this.b.get(label);
        if (sessionQueue == null) {
            sessionQueue = new SessionQueue(this.f);
            this.b.put(label, sessionQueue);
        }
        return this.b(sessionQueue, label);
    }

    private ObjectSessionInfo b(SessionQueue sessionQueue, String string) throws ESYAException {
        try {
            ObjectSessionInfo objectSessionInfo = (ObjectSessionInfo)sessionQueue.poll();
            if (objectSessionInfo != null) {
                return objectSessionInfo;
            }
            if (sessionQueue.getActiveSessionCount() < this.f) {
                try {
                    objectSessionInfo = this.a(sessionQueue, string);
                    return objectSessionInfo;
                }
                catch (PKCS11Exception | SmartCardException exception) {
                    throw new ESYAException(HSMSessionPool.a(-8732, 10070), exception);
                }
            }
            objectSessionInfo = (ObjectSessionInfo)sessionQueue.poll(this.g, TimeUnit.SECONDS);
            if (objectSessionInfo == null) {
                throw new ESYAException(HSMSessionPool.a(-8734, -3380));
            }
            return objectSessionInfo;
        }
        catch (InterruptedException interruptedException) {
            throw new ESYAException(HSMSessionPool.a(-8736, 12823));
        }
    }

    public boolean offer(ObjectSessionInfo poolItem) {
        SessionQueue sessionQueue = this.b.get(poolItem.getObjectLabel());
        return sessionQueue.offer(poolItem);
    }

    public byte[] executeCryptoOp(String label, byte[] data, CryptoOp cryptoOp) throws Exception {
        ObjectSessionInfo objectSessionInfo = null;
        byte[] byArray = null;
        try {
            objectSessionInfo = this.checkOutItem(label);
            byArray = cryptoOp.execute(objectSessionInfo.getSession(), objectSessionInfo.getObjectId(), data);
            this.offer(objectSessionInfo);
            return byArray;
        }
        catch (Exception exception) {
            ObjectSessionInfo objectSessionInfo2 = this.resetFailedSession(objectSessionInfo, label);
            byArray = cryptoOp.execute(objectSessionInfo2.getSession(), objectSessionInfo2.getObjectId(), data);
            this.offer(objectSessionInfo2);
            return byArray;
        }
    }

    public ObjectSessionInfo resetFailedSession(ObjectSessionInfo sessionInfo, String label) throws PKCS11Exception, InterruptedException, SmartCardException {
        if (sessionInfo != null) {
            this.a(sessionInfo);
        }
        SessionQueue sessionQueue = this.b.get(label);
        sessionInfo = this.a(sessionQueue, label);
        return sessionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ObjectSessionInfo objectSessionInfo) {
        SessionQueue sessionQueue = this.b.get(objectSessionInfo.getObjectLabel());
        sessionQueue.decreaseActiveSessionCount();
        ArrayList<ObjectSessionInfo> arrayList = this.c;
        synchronized (arrayList) {
            this.c.remove(objectSessionInfo);
        }
        try {
            this.d.closeSession(objectSessionInfo.getSession());
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.trace(HSMSessionPool.a(-8722, -26841), pKCS11Exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endPool() {
        ArrayList<ObjectSessionInfo> arrayList = this.c;
        synchronized (arrayList) {
            int n2 = h;
            for (ObjectSessionInfo objectSessionInfo : this.c) {
                try {
                    this.d.logout(objectSessionInfo.getSession());
                    break;
                }
                catch (PKCS11Exception pKCS11Exception) {
                    a.debug(HSMSessionPool.a(-8735, -2672) + objectSessionInfo.getSession(), pKCS11Exception);
                    if (n2 == 0) continue;
                    int n3 = SmartCardException.b;
                    SmartCardException.b = ++n3;
                    break;
                }
            }
            for (ObjectSessionInfo objectSessionInfo : this.c) {
                try {
                    this.d.closeSession(objectSessionInfo.getSession());
                }
                catch (PKCS11Exception pKCS11Exception) {
                    a.debug(HSMSessionPool.a(-8730, 80) + objectSessionInfo.getSession(), pKCS11Exception);
                }
                if (n2 == 0) continue;
            }
            this.b.clear();
        }
    }

    protected void finalize() throws Throwable {
        this.endPool();
        super.finalize();
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[9];
                var3_1 = 0;
                var2_2 = "\u00cfO\u0080\u0099#\u00ff8c\u000b\u0083c\u00cc\u00a8\u00c6\u00a5\u00b6\u00b9\u0086i=\u00c26\u00ca\u009a\u000e\\\u00850\u0090t\u00be\u0017\u00de\u00fe\u00e6\u00b7\u00a3\u000fw\u0015I\u00fe\u00bd\u0089\u00eb6#\u00bc\f5\u0003\u000e=\u001c\u0014\u0019H=\u00dd\u0099\u008dt\u00a4\u00cb\u00f2e]v0\u00e5B\u0007t\u00803\u0096\u00f0i\u0080x\u00e0\u00f0\u001drq\u0019\u00af\u00b1\u00de\u008f?\u008e<\u00b3\u0085\u00f1\u0086\u00a3\u00c1\u00be\u00c1\u00bc\u0013\u00f0\u009a\u0002\u0012&\u00f1\u0082\u00d3i+\u00d1\u00e3\u00f0b\u00caro\t\u00f8ww\u0082n\u00e5\u008e\u0001\u007f\u00bf\u001a,\u001b\u00d6\u00ecw=Y\u00be0\u001e\u007fg\u00f5^X5\u0093\u0017\u0003\u00e0\u00b2\u00ce\u00b7\u00f3\u001bl\u0014\u00dd\u0084\u00b5\u00c0\"\u00be\u00f3Y\u00ab\u0087\u008e\u00b7\u00f6\u00cb\u0081\u001f\u0010\u00a1z\u00c0\u00fc\u00d3\u00dbm\u0000\u001c\u00b4\u00f3\\`_2\u00dd\u0001\u00aev\u00bd\u00a27\u00e1\u00a5\u0081\u001a\u00af\u00b6.\u008e\u0096^\u007fkXT0";
                var4_3 = "\u00cfO\u0080\u0099#\u00ff8c\u000b\u0083c\u00cc\u00a8\u00c6\u00a5\u00b6\u00b9\u0086i=\u00c26\u00ca\u009a\u000e\\\u00850\u0090t\u00be\u0017\u00de\u00fe\u00e6\u00b7\u00a3\u000fw\u0015I\u00fe\u00bd\u0089\u00eb6#\u00bc\f5\u0003\u000e=\u001c\u0014\u0019H=\u00dd\u0099\u008dt\u00a4\u00cb\u00f2e]v0\u00e5B\u0007t\u00803\u0096\u00f0i\u0080x\u00e0\u00f0\u001drq\u0019\u00af\u00b1\u00de\u008f?\u008e<\u00b3\u0085\u00f1\u0086\u00a3\u00c1\u00be\u00c1\u00bc\u0013\u00f0\u009a\u0002\u0012&\u00f1\u0082\u00d3i+\u00d1\u00e3\u00f0b\u00caro\t\u00f8ww\u0082n\u00e5\u008e\u0001\u007f\u00bf\u001a,\u001b\u00d6\u00ecw=Y\u00be0\u001e\u007fg\u00f5^X5\u0093\u0017\u0003\u00e0\u00b2\u00ce\u00b7\u00f3\u001bl\u0014\u00dd\u0084\u00b5\u00c0\"\u00be\u00f3Y\u00ab\u0087\u008e\u00b7\u00f6\u00cb\u0081\u001f\u0010\u00a1z\u00c0\u00fc\u00d3\u00dbm\u0000\u001c\u00b4\u00f3\\`_2\u00dd\u0001\u00aev\u00bd\u00a27\u00e1\u00a5\u0081\u001a\u00af\u00b6.\u008e\u0096^\u007fkXT0".length();
                var1_4 = 37;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0092y+_V'\u0096x\u00de\u00e0\u00d9\u00a0\u00f0HH\u0018\u0011\u00d6\u00a4=\u00c2\u0019\u001e\u00b1\u0092a\u0090\u00b8z\u00aa\u00e3\u00ccu\u0085\u0093\u00d8\r/<\u009c\u00fe\u00e3\u00ec\u00b0\u00c1\u008a4\u00be\u0084kT2:(JU\u0017G\ry3s1ab\u0097\u0017\u00a0[\u00a8E5\u001d#\b\u00e6Z\u00fd\u009c\u00ba^\u0016G\u007fu";
                    var4_3 = "\u0092y+_V'\u0096x\u00de\u00e0\u00d9\u00a0\u00f0HH\u0018\u0011\u00d6\u00a4=\u00c2\u0019\u001e\u00b1\u0092a\u0090\u00b8z\u00aa\u00e3\u00ccu\u0085\u0093\u00d8\r/<\u009c\u00fe\u00e3\u00ec\u00b0\u00c1\u008a4\u00be\u0084kT2:(JU\u0017G\ry3s1ab\u0097\u0017\u00a0[\u00a8E5\u001d#\b\u00e6Z\u00fd\u009c\u00ba^\u0016G\u007fu".length();
                    var1_4 = 37;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 60;
                            break;
                        }
                        case 1: {
                            v13 = 91;
                            break;
                        }
                        case 2: {
                            v13 = 97;
                            break;
                        }
                        case 3: {
                            v13 = 72;
                            break;
                        }
                        case 4: {
                            v13 = 81;
                            break;
                        }
                        case 5: {
                            v13 = 103;
                            break;
                        }
                        default: {
                            v13 = 61;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        HSMSessionPool.i = var5;
        HSMSessionPool.j = new String[9];
        HSMSessionPool.a = LoggerFactory.getLogger(HSMSessionPool.class);
        HSMSessionPool.DEFAULT_MAX_CAPACITY_PER_KEY = 64;
        HSMSessionPool.DEFAULT_TIMEOUT_INSECONDS = 20;
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0xFFFFDDE6) & 0xFFFF;
        if (j[n4] == null) {
            int n5;
            int n6;
            char[] cArray = i[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 226;
                    break;
                }
                case 1: {
                    n6 = 254;
                    break;
                }
                case 2: {
                    n6 = 204;
                    break;
                }
                case 3: {
                    n6 = 28;
                    break;
                }
                case 4: {
                    n6 = 79;
                    break;
                }
                case 5: {
                    n6 = 243;
                    break;
                }
                case 6: {
                    n6 = 183;
                    break;
                }
                case 7: {
                    n6 = 42;
                    break;
                }
                case 8: {
                    n6 = 155;
                    break;
                }
                case 9: {
                    n6 = 166;
                    break;
                }
                case 10: {
                    n6 = 145;
                    break;
                }
                case 11: {
                    n6 = 217;
                    break;
                }
                case 12: {
                    n6 = 178;
                    break;
                }
                case 13: {
                    n6 = 215;
                    break;
                }
                case 14: {
                    n6 = 114;
                    break;
                }
                case 15: {
                    n6 = 51;
                    break;
                }
                case 16: {
                    n6 = 147;
                    break;
                }
                case 17: {
                    n6 = 30;
                    break;
                }
                case 18: {
                    n6 = 149;
                    break;
                }
                case 19: {
                    n6 = 170;
                    break;
                }
                case 20: {
                    n6 = 222;
                    break;
                }
                case 21: {
                    n6 = 81;
                    break;
                }
                case 22: {
                    n6 = 47;
                    break;
                }
                case 23: {
                    n6 = 219;
                    break;
                }
                case 24: {
                    n6 = 213;
                    break;
                }
                case 25: {
                    n6 = 251;
                    break;
                }
                case 26: {
                    n6 = 34;
                    break;
                }
                case 27: {
                    n6 = 26;
                    break;
                }
                case 28: {
                    n6 = 119;
                    break;
                }
                case 29: {
                    n6 = 190;
                    break;
                }
                case 30: {
                    n6 = 216;
                    break;
                }
                case 31: {
                    n6 = 52;
                    break;
                }
                case 32: {
                    n6 = 247;
                    break;
                }
                case 33: {
                    n6 = 109;
                    break;
                }
                case 34: {
                    n6 = 206;
                    break;
                }
                case 35: {
                    n6 = 40;
                    break;
                }
                case 36: {
                    n6 = 134;
                    break;
                }
                case 37: {
                    n6 = 232;
                    break;
                }
                case 38: {
                    n6 = 133;
                    break;
                }
                case 39: {
                    n6 = 69;
                    break;
                }
                case 40: {
                    n6 = 246;
                    break;
                }
                case 41: {
                    n6 = 58;
                    break;
                }
                case 42: {
                    n6 = 195;
                    break;
                }
                case 43: {
                    n6 = 142;
                    break;
                }
                case 44: {
                    n6 = 121;
                    break;
                }
                case 45: {
                    n6 = 115;
                    break;
                }
                case 46: {
                    n6 = 163;
                    break;
                }
                case 47: {
                    n6 = 245;
                    break;
                }
                case 48: {
                    n6 = 135;
                    break;
                }
                case 49: {
                    n6 = 205;
                    break;
                }
                case 50: {
                    n6 = 126;
                    break;
                }
                case 51: {
                    n6 = 160;
                    break;
                }
                case 52: {
                    n6 = 1;
                    break;
                }
                case 53: {
                    n6 = 93;
                    break;
                }
                case 54: {
                    n6 = 99;
                    break;
                }
                case 55: {
                    n6 = 62;
                    break;
                }
                case 56: {
                    n6 = 151;
                    break;
                }
                case 57: {
                    n6 = 180;
                    break;
                }
                case 58: {
                    n6 = 164;
                    break;
                }
                case 59: {
                    n6 = 61;
                    break;
                }
                case 60: {
                    n6 = 71;
                    break;
                }
                case 61: {
                    n6 = 21;
                    break;
                }
                case 62: {
                    n6 = 38;
                    break;
                }
                case 63: {
                    n6 = 175;
                    break;
                }
                case 64: {
                    n6 = 152;
                    break;
                }
                case 65: {
                    n6 = 24;
                    break;
                }
                case 66: {
                    n6 = 53;
                    break;
                }
                case 67: {
                    n6 = 220;
                    break;
                }
                case 68: {
                    n6 = 90;
                    break;
                }
                case 69: {
                    n6 = 214;
                    break;
                }
                case 70: {
                    n6 = 253;
                    break;
                }
                case 71: {
                    n6 = 192;
                    break;
                }
                case 72: {
                    n6 = 230;
                    break;
                }
                case 73: {
                    n6 = 182;
                    break;
                }
                case 74: {
                    n6 = 86;
                    break;
                }
                case 75: {
                    n6 = 188;
                    break;
                }
                case 76: {
                    n6 = 15;
                    break;
                }
                case 77: {
                    n6 = 169;
                    break;
                }
                case 78: {
                    n6 = 96;
                    break;
                }
                case 79: {
                    n6 = 127;
                    break;
                }
                case 80: {
                    n6 = 132;
                    break;
                }
                case 81: {
                    n6 = 199;
                    break;
                }
                case 82: {
                    n6 = 7;
                    break;
                }
                case 83: {
                    n6 = 35;
                    break;
                }
                case 84: {
                    n6 = 117;
                    break;
                }
                case 85: {
                    n6 = 168;
                    break;
                }
                case 86: {
                    n6 = 161;
                    break;
                }
                case 87: {
                    n6 = 68;
                    break;
                }
                case 88: {
                    n6 = 157;
                    break;
                }
                case 89: {
                    n6 = 207;
                    break;
                }
                case 90: {
                    n6 = 113;
                    break;
                }
                case 91: {
                    n6 = 89;
                    break;
                }
                case 92: {
                    n6 = 70;
                    break;
                }
                case 93: {
                    n6 = 187;
                    break;
                }
                case 94: {
                    n6 = 48;
                    break;
                }
                case 95: {
                    n6 = 66;
                    break;
                }
                case 96: {
                    n6 = 3;
                    break;
                }
                case 97: {
                    n6 = 240;
                    break;
                }
                case 98: {
                    n6 = 122;
                    break;
                }
                case 99: {
                    n6 = 111;
                    break;
                }
                case 100: {
                    n6 = 158;
                    break;
                }
                case 101: {
                    n6 = 233;
                    break;
                }
                case 102: {
                    n6 = 255;
                    break;
                }
                case 103: {
                    n6 = 176;
                    break;
                }
                case 104: {
                    n6 = 209;
                    break;
                }
                case 105: {
                    n6 = 185;
                    break;
                }
                case 106: {
                    n6 = 59;
                    break;
                }
                case 107: {
                    n6 = 239;
                    break;
                }
                case 108: {
                    n6 = 193;
                    break;
                }
                case 109: {
                    n6 = 174;
                    break;
                }
                case 110: {
                    n6 = 49;
                    break;
                }
                case 111: {
                    n6 = 83;
                    break;
                }
                case 112: {
                    n6 = 17;
                    break;
                }
                case 113: {
                    n6 = 72;
                    break;
                }
                case 114: {
                    n6 = 123;
                    break;
                }
                case 115: {
                    n6 = 184;
                    break;
                }
                case 116: {
                    n6 = 19;
                    break;
                }
                case 117: {
                    n6 = 225;
                    break;
                }
                case 118: {
                    n6 = 140;
                    break;
                }
                case 119: {
                    n6 = 76;
                    break;
                }
                case 120: {
                    n6 = 46;
                    break;
                }
                case 121: {
                    n6 = 235;
                    break;
                }
                case 122: {
                    n6 = 139;
                    break;
                }
                case 123: {
                    n6 = 118;
                    break;
                }
                case 124: {
                    n6 = 57;
                    break;
                }
                case 125: {
                    n6 = 198;
                    break;
                }
                case 126: {
                    n6 = 124;
                    break;
                }
                case 127: {
                    n6 = 103;
                    break;
                }
                case 128: {
                    n6 = 63;
                    break;
                }
                case 129: {
                    n6 = 88;
                    break;
                }
                case 130: {
                    n6 = 25;
                    break;
                }
                case 131: {
                    n6 = 211;
                    break;
                }
                case 132: {
                    n6 = 92;
                    break;
                }
                case 133: {
                    n6 = 137;
                    break;
                }
                case 134: {
                    n6 = 242;
                    break;
                }
                case 135: {
                    n6 = 104;
                    break;
                }
                case 136: {
                    n6 = 87;
                    break;
                }
                case 137: {
                    n6 = 252;
                    break;
                }
                case 138: {
                    n6 = 22;
                    break;
                }
                case 139: {
                    n6 = 5;
                    break;
                }
                case 140: {
                    n6 = 189;
                    break;
                }
                case 141: {
                    n6 = 202;
                    break;
                }
                case 142: {
                    n6 = 80;
                    break;
                }
                case 143: {
                    n6 = 173;
                    break;
                }
                case 144: {
                    n6 = 150;
                    break;
                }
                case 145: {
                    n6 = 73;
                    break;
                }
                case 146: {
                    n6 = 23;
                    break;
                }
                case 147: {
                    n6 = 162;
                    break;
                }
                case 148: {
                    n6 = 153;
                    break;
                }
                case 149: {
                    n6 = 4;
                    break;
                }
                case 150: {
                    n6 = 85;
                    break;
                }
                case 151: {
                    n6 = 181;
                    break;
                }
                case 152: {
                    n6 = 74;
                    break;
                }
                case 153: {
                    n6 = 241;
                    break;
                }
                case 154: {
                    n6 = 20;
                    break;
                }
                case 155: {
                    n6 = 14;
                    break;
                }
                case 156: {
                    n6 = 203;
                    break;
                }
                case 157: {
                    n6 = 112;
                    break;
                }
                case 158: {
                    n6 = 78;
                    break;
                }
                case 159: {
                    n6 = 116;
                    break;
                }
                case 160: {
                    n6 = 41;
                    break;
                }
                case 161: {
                    n6 = 129;
                    break;
                }
                case 162: {
                    n6 = 159;
                    break;
                }
                case 163: {
                    n6 = 13;
                    break;
                }
                case 164: {
                    n6 = 108;
                    break;
                }
                case 165: {
                    n6 = 8;
                    break;
                }
                case 166: {
                    n6 = 27;
                    break;
                }
                case 167: {
                    n6 = 128;
                    break;
                }
                case 168: {
                    n6 = 208;
                    break;
                }
                case 169: {
                    n6 = 60;
                    break;
                }
                case 170: {
                    n6 = 167;
                    break;
                }
                case 171: {
                    n6 = 197;
                    break;
                }
                case 172: {
                    n6 = 2;
                    break;
                }
                case 173: {
                    n6 = 212;
                    break;
                }
                case 174: {
                    n6 = 165;
                    break;
                }
                case 175: {
                    n6 = 237;
                    break;
                }
                case 176: {
                    n6 = 196;
                    break;
                }
                case 177: {
                    n6 = 94;
                    break;
                }
                case 178: {
                    n6 = 16;
                    break;
                }
                case 179: {
                    n6 = 32;
                    break;
                }
                case 180: {
                    n6 = 125;
                    break;
                }
                case 181: {
                    n6 = 98;
                    break;
                }
                case 182: {
                    n6 = 106;
                    break;
                }
                case 183: {
                    n6 = 67;
                    break;
                }
                case 184: {
                    n6 = 44;
                    break;
                }
                case 185: {
                    n6 = 82;
                    break;
                }
                case 186: {
                    n6 = 54;
                    break;
                }
                case 187: {
                    n6 = 248;
                    break;
                }
                case 188: {
                    n6 = 141;
                    break;
                }
                case 189: {
                    n6 = 231;
                    break;
                }
                case 190: {
                    n6 = 130;
                    break;
                }
                case 191: {
                    n6 = 50;
                    break;
                }
                case 192: {
                    n6 = 238;
                    break;
                }
                case 193: {
                    n6 = 186;
                    break;
                }
                case 194: {
                    n6 = 6;
                    break;
                }
                case 195: {
                    n6 = 97;
                    break;
                }
                case 196: {
                    n6 = 234;
                    break;
                }
                case 197: {
                    n6 = 12;
                    break;
                }
                case 198: {
                    n6 = 105;
                    break;
                }
                case 199: {
                    n6 = 191;
                    break;
                }
                case 200: {
                    n6 = 45;
                    break;
                }
                case 201: {
                    n6 = 33;
                    break;
                }
                case 202: {
                    n6 = 227;
                    break;
                }
                case 203: {
                    n6 = 11;
                    break;
                }
                case 204: {
                    n6 = 172;
                    break;
                }
                case 205: {
                    n6 = 218;
                    break;
                }
                case 206: {
                    n6 = 143;
                    break;
                }
                case 207: {
                    n6 = 138;
                    break;
                }
                case 208: {
                    n6 = 136;
                    break;
                }
                case 209: {
                    n6 = 56;
                    break;
                }
                case 210: {
                    n6 = 84;
                    break;
                }
                case 211: {
                    n6 = 131;
                    break;
                }
                case 212: {
                    n6 = 177;
                    break;
                }
                case 213: {
                    n6 = 156;
                    break;
                }
                case 214: {
                    n6 = 146;
                    break;
                }
                case 215: {
                    n6 = 43;
                    break;
                }
                case 216: {
                    n6 = 77;
                    break;
                }
                case 217: {
                    n6 = 101;
                    break;
                }
                case 218: {
                    n6 = 29;
                    break;
                }
                case 219: {
                    n6 = 36;
                    break;
                }
                case 220: {
                    n6 = 200;
                    break;
                }
                case 221: {
                    n6 = 201;
                    break;
                }
                case 222: {
                    n6 = 148;
                    break;
                }
                case 223: {
                    n6 = 100;
                    break;
                }
                case 224: {
                    n6 = 37;
                    break;
                }
                case 225: {
                    n6 = 250;
                    break;
                }
                case 226: {
                    n6 = 229;
                    break;
                }
                case 227: {
                    n6 = 107;
                    break;
                }
                case 228: {
                    n6 = 65;
                    break;
                }
                case 229: {
                    n6 = 110;
                    break;
                }
                case 230: {
                    n6 = 144;
                    break;
                }
                case 231: {
                    n6 = 223;
                    break;
                }
                case 232: {
                    n6 = 221;
                    break;
                }
                case 233: {
                    n6 = 120;
                    break;
                }
                case 234: {
                    n6 = 91;
                    break;
                }
                case 235: {
                    n6 = 18;
                    break;
                }
                case 236: {
                    n6 = 171;
                    break;
                }
                case 237: {
                    n6 = 39;
                    break;
                }
                case 238: {
                    n6 = 236;
                    break;
                }
                case 239: {
                    n6 = 64;
                    break;
                }
                case 240: {
                    n6 = 9;
                    break;
                }
                case 241: {
                    n6 = 95;
                    break;
                }
                case 242: {
                    n6 = 179;
                    break;
                }
                case 243: {
                    n6 = 154;
                    break;
                }
                case 244: {
                    n6 = 75;
                    break;
                }
                case 245: {
                    n6 = 194;
                    break;
                }
                case 246: {
                    n6 = 249;
                    break;
                }
                case 247: {
                    n6 = 224;
                    break;
                }
                case 248: {
                    n6 = 55;
                    break;
                }
                case 249: {
                    n6 = 0;
                    break;
                }
                case 250: {
                    n6 = 228;
                    break;
                }
                case 251: {
                    n6 = 31;
                    break;
                }
                case 252: {
                    n6 = 210;
                    break;
                }
                case 253: {
                    n6 = 10;
                    break;
                }
                case 254: {
                    n6 = 102;
                    break;
                }
                default: {
                    n6 = 244;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            HSMSessionPool.j[n4] = new String(cArray).intern();
        }
        return j[n4];
    }

    public static class DecryptionOperation
    implements CryptoOp {
        private SmartCard a;
        private CK_MECHANISM b;

        public DecryptionOperation(SmartCard sc, CK_MECHANISM mechanism) {
            this.a = sc;
            this.b = mechanism;
        }

        @Override
        public byte[] execute(long session, long objectId, byte[] data) throws Exception {
            return this.a.getCardType().getCardTemplate().getPKCS11Ops().decryptData(session, objectId, data, this.b);
        }
    }

    public static class EncryptionOperation
    implements CryptoOp {
        private SmartCard a;
        private CK_MECHANISM b;

        public EncryptionOperation(SmartCard sc, CK_MECHANISM mechanism) {
            this.a = sc;
            this.b = mechanism;
        }

        @Override
        public byte[] execute(long session, long objectId, byte[] data) throws Exception {
            return this.a.getCardType().getCardTemplate().getPKCS11Ops().encryptData(session, objectId, data, this.b);
        }
    }

    public static class SignOperation
    implements CryptoOp {
        private SmartCard a;
        private CK_MECHANISM b;

        public SignOperation(SmartCard sc, CK_MECHANISM mechanism) {
            this.a = sc;
            this.b = mechanism;
        }

        @Override
        public byte[] execute(long session, long objectId, byte[] data) throws Exception {
            return this.a.signDataWithKeyID(session, objectId, this.b, data);
        }
    }

    public static interface CryptoOp {
        public byte[] execute(long var1, long var3, byte[] var5) throws Exception;
    }
}

