/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.util;

import java.util.List;
import java.util.stream.Collectors;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.TerminalFactory;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tubitak.akis.cif.functions.CommandTransmitterPCSC;

public class PCSCUtil {
    public static CardChannel getCardChannelFromUSBName(String deviceUSBName) throws ESYAException {
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            CardTerminal cardTerminal = terminalFactory.terminals().getTerminal(deviceUSBName);
            CommandTransmitterPCSC commandTransmitterPCSC = new CommandTransmitterPCSC(cardTerminal, false);
            CardChannel cardChannel = commandTransmitterPCSC.card.getBasicChannel();
            return cardChannel;
        }
        catch (Exception exception) {
            throw new ESYAException(exception);
        }
    }

    public static String[] getCardReaderNames() throws ESYAException {
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = terminalFactory.terminals().list();
            return list.stream().map(cardTerminal -> cardTerminal.getName()).collect(Collectors.toList()).toArray(new String[0]);
        }
        catch (Exception exception) {
            throw new ESYAException(exception);
        }
    }
}

