/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.commands;

import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tubitak.akis.cif.akisExceptions.AkisCIFException;
import tubitak.akis.cif.akisExceptions.AkisCardException;
import tubitak.akis.cif.akisExceptions.AkisSWException;
import tubitak.akis.cif.akisExceptions.UnsupportedVersionException;
import tubitak.akis.cif.dataStructures.ARR;
import tubitak.akis.cif.dataStructures.ActivationType;
import tubitak.akis.cif.dataStructures.AkisKey;
import tubitak.akis.cif.dataStructures.Algorithm;
import tubitak.akis.cif.dataStructures.AuthenticationType;
import tubitak.akis.cif.dataStructures.DF_EF;
import tubitak.akis.cif.dataStructures.DiffieHellmanKey;
import tubitak.akis.cif.dataStructures.ECCKey;
import tubitak.akis.cif.dataStructures.ECCKeyGezgin;
import tubitak.akis.cif.dataStructures.ECCParams;
import tubitak.akis.cif.dataStructures.ECCPoint;
import tubitak.akis.cif.dataStructures.FCI;
import tubitak.akis.cif.dataStructures.FileAccessRules;
import tubitak.akis.cif.dataStructures.FileLevel;
import tubitak.akis.cif.dataStructures.FileTypes;
import tubitak.akis.cif.dataStructures.GetDataModes;
import tubitak.akis.cif.dataStructures.LifeCycle;
import tubitak.akis.cif.dataStructures.Manufacturer;
import tubitak.akis.cif.dataStructures.Mechanisms;
import tubitak.akis.cif.dataStructures.P1P2;
import tubitak.akis.cif.dataStructures.PIN;
import tubitak.akis.cif.dataStructures.PSOParameters;
import tubitak.akis.cif.dataStructures.PutDataParameters;
import tubitak.akis.cif.dataStructures.RSAKey;
import tubitak.akis.cif.dataStructures.RSAKeyFields;
import tubitak.akis.cif.dataStructures.RSAKeyGezgin;
import tubitak.akis.cif.dataStructures.SDOHeader;
import tubitak.akis.cif.dataStructures.SymmetricKey;
import tubitak.akis.cif.dataStructures.Version;
import tubitak.akis.cif.functions.Conversions;
import tubitak.akis.cif.functions.ICommandTransmitter;

public abstract class AbstractAkisCommands
implements Mechanisms {
    public ICommandTransmitter mCardChannel;
    protected int phaseBytePosition;
    protected Version version;
    protected Manufacturer manufacturer;
    public FileAccessRules fileAccessRules;
    public FileTypes fileTypes;
    public PSOParameters pso_param = new PSOParameters();
    public PutDataParameters putDataParam = new PutDataParameters();
    public boolean isSecureMessagingActive = false;
    public static boolean isLoggingActive = false;
    protected int[] rsa_enc = new int[]{1, 2, 840, 113549, 1, 1, 1};
    protected byte[] secureMessagingKey_ABA = new byte[24];
    protected final byte SECURE_MSG_LE = (byte)-106;
    protected final byte SECURE_MSG_TAG = (byte)-122;
    protected final byte SECURE_MSG_SW = (byte)-103;
    protected final int CLASS = 0;
    protected final int INS = 1;
    protected final int P1 = 2;
    protected final int P2 = 3;
    protected final int LC = 4;
    protected final int DATAPOS = 5;
    protected final int MAX_IO_DATALEN = 196;
    protected final int MAX_IO_SM_DATALEN = 196;
    protected final int MAX_IO_READ_DATALEN = 208;
    protected final int MAX_IO_DATALEN_EXTENDED = 512;
    protected final int MAX_IO_READ_DATALEN_EXTENDED = 512;
    protected FCI lastFCI = new FCI();
    private static final Logger LOGGER = LoggerFactory.getLogger("AKISCIF_LOG");

    public AbstractAkisCommands(ICommandTransmitter transmitter, Version version) {
        this.mCardChannel = transmitter;
        this.version = version;
        this.manufacturer = Manufacturer.getManufacturer(version);
    }

    public void createFile(FCI fci) throws AkisCIFException, AkisSWException, AkisCardException {
        throw new UnsupportedVersionException();
    }

    public void createBinaryEFbyFID(byte[] FID, FileTypes.FileType type, FileAccessRules.FileAccessRule access) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] createEFCommandTemplate = new byte[]{-128, 21, type.value, access.value, 2};
        byte[] createEFCommand = new byte[createEFCommandTemplate.length + FID.length];
        System.arraycopy(createEFCommandTemplate, 0, createEFCommand, 0, createEFCommandTemplate.length);
        System.arraycopy(FID, 0, createEFCommand, createEFCommandTemplate.length, FID.length);
        this.sendCommand(createEFCommand);
    }

    public abstract void createBinaryEFbySFI(byte[] var1, byte var2, FileTypes.FileType var3, FileAccessRules.FileAccessRule var4) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void createDFbyName(byte[] var1, byte[] var2, FileTypes.FileType var3, FileAccessRules.FileAccessRule var4) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void createDFbyFID(byte[] var1, FileTypes.FileType var2, FileAccessRules.FileAccessRule var3) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void deleteCurrent() throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void deleteByFIDUnderMF(byte[] var1, FileLevel var2) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void deleteByFIDUnderDF(byte[] var1, FileLevel var2) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void deleteDFByName(byte[] var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void deleteByFIDPathFromMF(byte[] var1, FileLevel var2) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void deleteByFIDPathFromDF(byte[] var1, FileLevel var2) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void deleteByNamePathFromMF(byte[] var1, FileLevel var2) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void deleteByNamePathFromDF(byte[] var1, FileLevel var2) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void deleteParentDF() throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract FCI selectMF() throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract FCI selectFileUnderMF(byte[] var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract FCI selectChildDF(byte[] var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract FCI selectEFUnderDF(byte[] var1) throws AkisSWException, AkisCIFException, AkisCardException;

    public abstract FCI selectParentDF() throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract FCI selectDFByName(byte[] var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract FCI selectFromMFByPath(byte[] var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract FCI selectFromDFByPath(byte[] var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract byte[] readFileBySelectingUnderActiveDF(byte[] var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public byte[] readBinaryFile(int len) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public byte[] readBinaryFile(int start, int len) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public byte[] readBinaryFile(int start, int len, byte SFI) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public byte[] readBinaryFile(int start, int len, byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public abstract void updateBinaryFile(byte[] var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public void updateBinaryFile(byte[] data, int start) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void updateBinaryFile(byte[] data, int start, byte SFI) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void updateBinaryFile(byte[] data, int start, byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public byte[] readRecordFile(byte recNo) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public byte[] readRecordFile(byte recNo, byte SFI) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void updateRecordFile(byte recNo, byte[] record) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void updateRecordFile(byte recNo, byte[] record, byte SFI) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void appendRecordFile(byte[] record) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void appendRecordFile(byte[] record, byte SFI) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void eraseBinaryFile() throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void eraseBinaryFile(int start) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void eraseBinaryFile(int start, int len) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void eraseBinaryFile(int start, int len, byte SFI) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void eraseBinaryFile(int start, int len, byte[] FID) throws AkisCIFException, AkisSWException, AkisCardException {
        throw new UnsupportedVersionException();
    }

    public List<DF_EF> dir() throws AkisSWException, AkisCardException, AkisCIFException {
        int lastIndexinData;
        int count;
        int toplamLen;
        byte[] getDir;
        ArrayList<DF_EF> children;
        byte[] temp;
        byte[] data;
        ResponseAPDU response;
        block12: {
            response = null;
            data = new byte[2000];
            temp = new byte[2000];
            children = new ArrayList<DF_EF>();
            getDir = new byte[]{-128, 24, 0, 0, 0};
            if (this.version == Version.V10_UEKAE) {
                getDir[4] = -1;
            }
            try {
                response = this.sendCommand(getDir);
                if (response.getSW() == 36864 || response.getSW() == 27904) {
                    data = response.getData();
                }
            }
            catch (AkisCIFException ex) {
                if (response.getSW() == 27904) break block12;
                throw ex;
            }
        }
        if (response.getData() == null || response.getData().length == 0) {
            throw new AkisCIFException("Get Directory command returns NULL.");
        }
        if (response != null && response.getSW1() == 97) {
            int count2 = 0;
            System.arraycopy(response.getData(), 0, temp, count2, response.getData().length);
            count2 += response.getSW2() * 20;
            while (response != null && response.getSW1() == 97) {
                getDir[2] = (byte)response.getSW2();
                response = this.sendCommand(getDir);
                System.arraycopy(response.getData(), 0, temp, getDir[2] * 20, response.getData().length);
                count2 += response.getData().length;
            }
            data = new byte[count2];
            System.arraycopy(temp, 0, data, 0, count2);
        } else if (response != null && response.getSW() == 27904) {
            int len = 0;
            toplamLen = 0;
            count = 0;
            lastIndexinData = 0;
            while (response.getSW() == 27904) {
                getDir[2] = (byte)(12 * count);
                response = this.sendCommand(getDir);
                len = response.getData().length;
                System.arraycopy(response.getData(), 0, data, toplamLen, len);
                ++count;
                lastIndexinData = toplamLen += len;
            }
        }
        boolean len = false;
        toplamLen = 0;
        count = 0;
        lastIndexinData = 0;
        int length = data.length / 20;
        if (lastIndexinData != 0) {
            length = lastIndexinData / 20;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            DF_EF tempChild = new DF_EF();
            tempChild.type = data[20 * i2];
            tempChild.FID[0] = data[20 * i2 + 1];
            tempChild.FID[1] = data[20 * i2 + 2];
            System.arraycopy(data, 20 * i2 + 3, tempChild.name, 0, 16);
            tempChild.erisimKosulu = data[20 * i2 + 19];
            children.add(tempChild);
        }
        return children;
    }

    public List<FCI> dirV2() throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void closeEF() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] closeEFCommand = new byte[]{-128, 23, 0, 0};
        this.sendCommand(closeEFCommand);
    }

    public abstract AkisKey[] getKeyInfos() throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract int getMaxKeyID() throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract byte[] getPublicExponent(byte var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract int getPinRemainingUsageCount() throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract byte[] getModulus(byte var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void writePrivateKey(RSAKeyFields var1, int var2) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void writePublicKey(RSAKeyFields var1, int var2) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void writeBACKey(byte[] var1, byte var2, byte var3) throws AkisSWException, AkisCardException, AkisCIFException;

    public void writePublicKey(RSAKey pub) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void updatePublicKey(RSAKey pub) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void writePublicKey(RSAKeyGezgin pub) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void writePublicKey(ECCKeyGezgin publicKey) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void writePrivateKey(DiffieHellmanKey privateKey) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void writePrivateKey(RSAKey pri) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void updatePrivateKey(RSAKey pri) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void writePrivateKey(RSAKeyGezgin pri) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void writePrivateKey(ECCKey privateKey) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void updatePrivateKey(ECCKey privateKey) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void writePrivateKey(ECCKeyGezgin privateKey) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void writeSymmetricKey(SymmetricKey sec) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void updateSymmetricKey(SymmetricKey sec) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void writePIN(PIN pin) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public RSAKey readPublicKey(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public RSAKeyGezgin readPublicKeyGezgin(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public RSAKey readPrivateKey(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public RSAKeyGezgin readPrivateKeyGezgin(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public ECCKey readPrivateKeyECC(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public ECCKeyGezgin readPrivateKeyECCGezgin(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public ECCKeyGezgin readPublicKeyECCGezgin(byte keyID) {
        throw new UnsupportedVersionException();
    }

    public DiffieHellmanKey readPrivateKeyDH(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public SymmetricKey readSymmetricKey(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public SymmetricKey readSymmetricKey(byte keyID, byte type) throws AkisCIFException, AkisSWException, AkisCardException {
        throw new UnsupportedVersionException();
    }

    public PIN readPIN(byte pinID) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void deactivateObject(int objectType, byte objectID) throws AkisCIFException, AkisCardException, AkisSWException {
        throw new UnsupportedVersionException();
    }

    public boolean queryObject(int objectType, byte objectID) throws AkisCardException, AkisCIFException, AkisSWException {
        throw new UnsupportedVersionException();
    }

    public abstract void deleteKey(int var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public void deleteKey(int keyType, byte keyID) throws AkisCIFException, AkisSWException, AkisCardException {
        throw new UnsupportedVersionException();
    }

    public RSAKey genKeyPair(int modLen, byte[] pubExp, ARR arrRec, byte keyID) throws AkisCIFException, AkisSWException, AkisCardException {
        throw new UnsupportedVersionException();
    }

    public ECCPoint genKeyPairECC(ECCParams eccParams, ARR arrRec, byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public RSAKey genKeyPair(SDOHeader prvHeader, SDOHeader pubHeader, int modLen, byte[] pubExp) throws AkisCIFException, AkisSWException, AkisCardException {
        throw new UnsupportedVersionException();
    }

    public ECCPoint genKeyPairECC(SDOHeader header, ECCParams eccParams) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public abstract void activate(byte[] var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public void activate(byte[] activation, ActivationType type) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void activate(byte[] data, byte[] cert) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void activate(byte[] data, byte[] cert, ActivationType type) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public int getPersoKeyLength() {
        throw new UnsupportedVersionException();
    }

    public abstract void verifyInit(byte[] var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void verifyPerso(byte[] var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void putData(P1P2 var1, byte[] var2) throws AkisCIFException, AkisSWException, AkisCardException;

    public abstract byte[] getData(byte var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public byte[] getSerial() throws AkisCIFException, AkisSWException, AkisCardException {
        byte[] serial;
        try {
            serial = this.getSerialByKartTest();
        }
        catch (AkisCIFException ex) {
            serial = this.getSerialGetDataForActivation();
        }
        return serial;
    }

    public byte[] getSerialForActivation() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] serial;
        try {
            serial = this.getSerialByKartTest();
        }
        catch (AkisCIFException ex) {
            serial = this.getSerialGetData();
        }
        return serial;
    }

    protected byte[] getSerialByKartTest() throws AkisSWException, AkisCardException, AkisCIFException {
        ResponseAPDU response = null;
        byte[] ins_1b = new byte[]{-128, 27, 0, 17, 0};
        response = this.sendCommand(ins_1b);
        return response.getData();
    }

    protected abstract byte[] getSerialGetData() throws AkisSWException, AkisCardException, AkisCIFException;

    protected abstract byte[] getSerialGetDataForActivation() throws AkisCIFException, AkisSWException, AkisCardException;

    public LifeCycle getLifeCycle() throws AkisCIFException, AkisCardException, AkisSWException {
        LifeCycle faz;
        byte[] bellekData;
        byte bLifeCycle;
        block4: {
            bLifeCycle = 0;
            bellekData = null;
            try {
                bellekData = this.getData(GetDataModes.memory);
                if (bellekData.length < 7) {
                    throw new AkisCIFException("Phase can not be recognized. Returned data is not in expected length.");
                }
            }
            catch (AkisSWException ex) {
                if (ex.getErrorCode() != 28160L && ex.getErrorCode() != 27904L || this.version == null) break block4;
                return LifeCycle.ACTIVATION;
            }
        }
        if ((faz = LifeCycle.getLifeCycle(bLifeCycle = bellekData[this.phaseBytePosition])) == null) {
            throw new AkisCIFException("Phase can not be recognized.");
        }
        return faz;
    }

    public abstract int getEmptyMemory() throws AkisCIFException, AkisSWException, AkisCardException;

    public Version getVersion() {
        return this.version;
    }

    public Manufacturer getManufacturer() {
        return this.manufacturer;
    }

    public byte[] getFID(byte[] AID) throws AkisSWException, AkisCardException, AkisCIFException {
        int len = AID.length;
        byte[] selectFileByAID = new byte[6 + len];
        byte[] selectFileByAIDpart1 = new byte[]{0, -92, 4, 0};
        byte LC = (byte)len;
        int LE2 = -1;
        System.arraycopy(selectFileByAIDpart1, 0, selectFileByAID, 0, 4);
        selectFileByAID[4] = LC;
        System.arraycopy(AID, 0, selectFileByAID, 5, len);
        selectFileByAID[5 + len] = LE2;
        byte[] data = null;
        byte[] FID = null;
        this.selectMF();
        ResponseAPDU response = this.sendCommand(selectFileByAID);
        data = response.getData();
        if (data == null) {
            throw new AkisCIFException("FID cannot be read. Select File Response data is NULL.");
        }
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (data[i2] != -125) continue;
            FID = new byte[]{data[i2 + 2], data[i2 + 3]};
            break;
        }
        if (FID != null) {
            return FID;
        }
        throw new AkisCIFException("FID cannot be read parsed from returned FCI.");
    }

    public byte[] getNextCertFID() throws AkisSWException, AkisCardException, AkisCIFException {
        boolean fileFound = false;
        byte[] certValueFID = new byte[]{47, 15};
        while (!fileFound) {
            certValueFID[1] = (byte)(certValueFID[1] + 1);
            if (certValueFID[1] >= 48) {
                throw new AkisSWException(25603L);
            }
            try {
                this.selectEFUnderDF(certValueFID);
            }
            catch (AkisSWException e2) {
                if (e2.getErrorCode() != 27266L) continue;
                fileFound = true;
            }
        }
        return certValueFID;
    }

    public void format(byte[] encrypted_ba, boolean toInitialization) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] formatCommand = new byte[21];
        formatCommand[0] = -128;
        formatCommand[1] = 64;
        formatCommand[2] = 0;
        formatCommand[3] = toInitialization ? 1 : 2;
        formatCommand[4] = 16;
        System.arraycopy(encrypted_ba, 0, formatCommand, 5, 16);
        this.sendCommand(formatCommand);
    }

    public void format(byte[] arrMF) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void format(byte[] arrMF, byte recordNo) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void changePhaseToAdmin(byte[] adminPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        this.selectMF();
        this.verify(adminPIN, true);
        byte[] changePhase = new byte[]{-128, 9, 0, 2};
        this.sendCommand(changePhase);
    }

    public void changePhaseToOperation() throws AkisSWException, AkisCardException, AkisCIFException {
        this.selectMF();
        byte[] changePhase = new byte[]{-128, 9, 0, 1};
        this.sendCommand(changePhase);
    }

    public void terminateCardUsage() throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public abstract byte[] getChallenge(int var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void verifyWithPinPad(byte var1, boolean var2) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void verify(byte[] var1, boolean var2) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void verify(byte var1, byte[] var2, boolean var3) throws AkisSWException, AkisCardException, AkisCIFException;

    public void logout() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] logout = new byte[]{-128, 26, 1, 0};
        this.sendCommand(logout);
    }

    public abstract void changeDFPIN(byte[] var1, byte[] var2, byte[] var3) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void changeDFPUK(byte[] var1, byte[] var2, byte[] var3) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void changeMFPIN(byte[] var1, byte[] var2) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void changeMFPUK(byte[] var1, byte[] var2, byte[] var3) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void unlockDFPIN(byte[] var1, byte[] var2, byte[] var3) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract void unlockMFPIN(byte[] var1, byte[] var2) throws AkisSWException, AkisCardException, AkisCIFException;

    public void changeDFPIN(byte pinNo, byte[] oldPIN, byte[] newPIN) throws AkisCardException, AkisSWException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void changeMFPIN(byte pinNo, byte[] oldPIN, byte[] newPIN) throws AkisCardException, AkisSWException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void unlockDFPIN(byte pukNo, byte[] PUK, byte pinNo, byte[] newPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void unlockMFPIN(byte pukNo, byte[] PUK, byte pinNo, byte[] newPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public byte[] internalAuthenticate(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public byte[] internalAuthenticate(Algorithm signAlg, Algorithm hashAlg, byte privateKeyICC, byte[] data) throws AkisCIFException, AkisSWException, AkisCardException {
        throw new UnsupportedVersionException();
    }

    public void externalAuthenticate(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void externalAuthenticate(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyRole, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public byte[] externalAuthenticate(Algorithm signAlg, Algorithm hashAlg, byte privateKeyICC, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public abstract void mse(byte var1) throws AkisSWException, AkisCardException, AkisCIFException;

    public void mseSet(byte P1, byte P2, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public abstract byte[] pso(P1P2 var1, byte[] var2) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract byte[] sign(byte[] var1, byte var2) throws AkisSWException, AkisCardException, AkisCIFException;

    public byte[] sign(Algorithm signAlg, Algorithm hashAlg, byte keyID, byte[] data) throws AkisCIFException, AkisSWException, AkisCardException {
        throw new UnsupportedVersionException();
    }

    public byte[] decrypt(Algorithm decAlg, Algorithm hashAlg, byte keyID, byte[] data) throws AkisCIFException, AkisSWException, AkisCardException {
        throw new UnsupportedVersionException();
    }

    public byte[] symmetricOperation(Algorithm alg, byte keyID, byte[] data, boolean encryption) throws AkisCIFException, AkisSWException, AkisCardException {
        throw new UnsupportedVersionException();
    }

    public byte[] cryptographicChecksum(Algorithm alg, byte keyID, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public byte[] hash(Algorithm alg, byte[] data) throws AkisCIFException, AkisSWException, AkisCardException {
        throw new UnsupportedVersionException();
    }

    public void verifyCertificate(Algorithm signAlg, Algorithm hashAlg, byte[] cvCert) throws AkisCIFException, AkisSWException, AkisCardException {
        throw new UnsupportedVersionException();
    }

    public void verifyCertificate(Algorithm signAlg, Algorithm hashAlg, byte[] keyref, byte[] cvCert) throws AkisCIFException, AkisSWException, AkisCardException {
        throw new UnsupportedVersionException();
    }

    public long[] getMechanisms() {
        long[] mechanisms = new long[]{1L, 1L, 289L, 306L, 544L, 592L, 624L, 528L, 0L};
        return mechanisms;
    }

    public void activateSecureMsging() throws AkisCIFException, AkisSWException, AkisCardException {
        this.decideSecureMessageKeyGeneratingKey();
        this.generateSecureMessagingKey();
        this.isSecureMessagingActive = true;
    }

    public void activateSecureMsging(String documentNumber, String dateOfBirth, String expireDate) throws AkisSWException, AkisCardException, AkisCIFException {
        throw new UnsupportedVersionException();
    }

    public void activateSecureMsgingDeviceAuth(byte[] KICC, byte[] RICC, byte[] KIFD, byte[] RIFD) {
        throw new UnsupportedVersionException();
    }

    public void deactivateSecureMsging() {
        throw new UnsupportedVersionException();
    }

    public void activateSecureMsgingMethod2(byte refPrKICC) throws AkisSWException, AkisCardException, AkisCIFException {
        this.generateSecureMessagingKey();
        this.isSecureMessagingActive = true;
    }

    protected abstract void decideSecureMessageKeyGeneratingKey() throws AkisCIFException;

    protected abstract void generateSecureMessagingKey() throws AkisCIFException, AkisSWException, AkisCardException;

    protected abstract void generateSecureMessagingKey(String var1, String var2, String var3) throws AkisSWException, AkisCardException, AkisCIFException;

    protected abstract byte[] exchangeChallenge(byte[] var1) throws AkisSWException, AkisCardException, AkisCIFException;

    protected abstract byte[] createDecryptedCommand(byte[] var1) throws AkisCIFException;

    protected abstract byte[] createEncryptedCommand(byte[] var1) throws AkisCIFException;

    public byte[] sendCommandWithControl(byte[] command) throws AkisCIFException, AkisCardException, AkisSWException {
        byte[] response;
        if (isLoggingActive) {
            LOGGER.info("COMMAND: " + Conversions.hexBytetoHexString(command));
        }
        if (this.isSecureMessagingActive) {
            byte[] encrypted = this.createEncryptedCommand(command);
            if (isLoggingActive) {
                LOGGER.info("ENC_COMMAND: " + Conversions.hexBytetoHexString(encrypted));
            }
            response = this.mCardChannel.control(encrypted);
            int len = response.length;
            long error = 0L;
            if (len == 2 && response[len - 2] != 144 && response[len - 1] != 0) {
                error += ((long)response[len - 2] & 0xFFL) << 8;
                throw new AkisSWException(error += (long)response[len - 1] & 0xFFL);
            }
            if (isLoggingActive) {
                LOGGER.info("ENC_RESPONSE: " + Conversions.hexBytetoHexString(response));
            }
            response = this.createDecryptedCommand(response);
        } else {
            response = this.mCardChannel.control(command);
            int len = response.length;
            long error = 0L;
            if (len == 2 && response[len - 2] != 144 && response[len - 1] != 0) {
                error += ((long)response[len - 2] & 0xFFL) << 8;
                throw new AkisSWException(error += (long)response[len - 1] & 0xFFL);
            }
            if (isLoggingActive) {
                LOGGER.info("RESPONSE: " + Conversions.hexBytetoHexString(response));
            }
        }
        return response;
    }

    public ResponseAPDU sendCommand(byte[] command) throws AkisSWException, AkisCardException, AkisCIFException {
        ResponseAPDU response;
        if (isLoggingActive) {
            LOGGER.info(" COMMAND: " + Conversions.hexBytetoHexString(command));
        }
        if (this.isSecureMessagingActive) {
            byte[] encrypted = this.createEncryptedCommand(command);
            if (isLoggingActive) {
                LOGGER.info("ENC_COMMAND: " + Conversions.hexBytetoHexString(encrypted));
            }
            if ((response = this.mCardChannel.transmit(new CommandAPDU(encrypted))).getBytes().length == 2 && response.getSW() != 36864) {
                throw new AkisSWException(response.getSW());
            }
            if (isLoggingActive) {
                LOGGER.info("ENC_RESPONSE: " + Conversions.hexBytetoHexString(response.getBytes()));
            }
            response = new ResponseAPDU(this.createDecryptedCommand(response.getBytes()));
        } else {
            response = this.mCardChannel.transmit(new CommandAPDU(command));
        }
        if (isLoggingActive) {
            LOGGER.info("RESPONSE: " + Conversions.hexBytetoHexString(response.getBytes()));
        }
        if (response == null) {
            throw new AkisCIFException("Response is NULL");
        }
        byte[] returnData = null;
        while (response.getSW() >= 24832 && response.getSW() <= 25087 && command[1] != 24) {
            ResponseAPDU getResp = this.getResponse((byte)response.getSW2());
            byte[] temp = getResp.getData();
            byte[] tempReturnData = response.getData();
            returnData = new byte[tempReturnData.length + temp.length];
            System.arraycopy(tempReturnData, 0, returnData, 0, tempReturnData.length);
            System.arraycopy(temp, 0, returnData, tempReturnData.length, temp.length);
            response = new ResponseAPDU(getResp.getBytes());
        }
        if (returnData != null) {
            byte[] resp = new byte[returnData.length + 2];
            System.arraycopy(returnData, 0, resp, 0, returnData.length);
            resp[resp.length - 2] = -112;
            resp[resp.length - 1] = 0;
            response = new ResponseAPDU(resp);
        }
        if (command[1] == 24 && response.getSW1() == 97) {
            return response;
        }
        if (response.getSW() != 36864) {
            throw new AkisSWException(response.getSW());
        }
        return response;
    }

    public ResponseAPDU getResponse(byte le) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] getResponse = new byte[]{0, -64, 0, 0, le};
        return this.sendCommand(getResponse);
    }

    public static void activateCommandLogging(String ignored) {
        LOGGER.info("#####  AKISCIF LOGS ENABLED  #####");
        isLoggingActive = true;
    }

    public abstract void externalAuthenticatePure(Algorithm var1, Algorithm var2, byte[] var3, byte var4, byte[] var5) throws AkisSWException, AkisCardException, AkisCIFException;

    public abstract byte[] generateMseData(Algorithm var1, Algorithm var2, byte[] var3, byte var4, AuthenticationType var5) throws AkisCIFException;

    public boolean needsLocking() {
        int akisVersion = this.getVersion().getValue();
        return akisVersion == Version.GEZGIN_V01_UEKAE_NXP.getValue() || akisVersion == Version.GEZGIN_V11_UEKAE_NXP.getValue() || akisVersion == Version.V25_UEKAE_NXP.getValue() || akisVersion == Version.GEZGIN_V10_UEKAE_NXP.getValue();
    }

    public boolean isAES256Activation() {
        int akisVersion = this.getVersion().getValue();
        return akisVersion == Version.GEZGIN_V10_UEKAE_INF.getValue() || akisVersion == Version.GEZGIN_V01_UEKAE_NXP.getValue() || akisVersion == Version.GEZGIN_V10_UEKAE_NXP.getValue() || akisVersion == Version.GEZGIN_V11_UEKAE_INF.getValue() || akisVersion == Version.V25_UEKAE_NXP.getValue() || akisVersion == Version.GEZGIN_V20_UEKAE_NXP.getValue() || akisVersion == Version.V30_UEKAE_INF.getValue();
    }

    public boolean needsCVCActivation() {
        int akisVersion = this.getVersion().getValue();
        return akisVersion == Version.GEZGIN_V01_UEKAE_NXP.getValue() || akisVersion == Version.GEZGIN_V10_UEKAE_NXP.getValue() || akisVersion == Version.GEZGIN_V11_UEKAE_INF.getValue() || akisVersion == Version.V25_UEKAE_NXP.getValue() || akisVersion == Version.GEZGIN_V20_UEKAE_NXP.getValue() || akisVersion == Version.V30_UEKAE_INF.getValue();
    }

    public boolean supportsExtendedLength() {
        int akisVersion = this.getVersion().getValue();
        return akisVersion == Version.GEZGIN_V10_UEKAE_INF.getValue() || akisVersion == Version.GEZGIN_V10_UEKAE_NXP.getValue() || akisVersion == Version.GEZGIN_V01_UEKAE_NXP.getValue() || akisVersion == Version.GEZGIN_V11_UEKAE_INF.getValue() || akisVersion == Version.GEZGIN_V11_UEKAE_NXP.getValue() || akisVersion == Version.GEZGIN_V20_UEKAE_NXP.getValue() || akisVersion == Version.V30_UEKAE_INF.getValue();
    }

    public boolean isGezgin() {
        int akisVersion = this.getVersion().getValue();
        return akisVersion == Version.GEZGIN_V10_UEKAE_INF.getValue() || akisVersion == Version.GEZGIN_V10_UEKAE_NXP.getValue() || akisVersion == Version.GEZGIN_V01_UEKAE_NXP.getValue() || akisVersion == Version.GEZGIN_V11_UEKAE_INF.getValue() || akisVersion == Version.GEZGIN_V11_UEKAE_NXP.getValue() || akisVersion == Version.GEZGIN_V20_UEKAE_NXP.getValue();
    }

    public byte[] getDataSDO(byte[] dataTemplate) throws AkisSWException, AkisCardException, AkisCIFException {
        return new byte[0];
    }
}

