/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.commands;

import java.nio.ByteBuffer;
import javax.smartcardio.ResponseAPDU;
import tubitak.akis.cif.akisExceptions.AkisCIFException;
import tubitak.akis.cif.akisExceptions.AkisCardException;
import tubitak.akis.cif.akisExceptions.AkisSWException;
import tubitak.akis.cif.commands.CommandsV25;
import tubitak.akis.cif.dataStructures.Algorithm;
import tubitak.akis.cif.dataStructures.AuthenticationType;
import tubitak.akis.cif.dataStructures.GetDataModes;
import tubitak.akis.cif.dataStructures.LifeCycle;
import tubitak.akis.cif.dataStructures.Manufacturer;
import tubitak.akis.cif.dataStructures.P1P2;
import tubitak.akis.cif.dataStructures.Version;
import tubitak.akis.cif.functions.Conversions;
import tubitak.akis.cif.functions.Crypto;
import tubitak.akis.cif.functions.ICommandTransmitter;

public class Command30Kimlik
extends CommandsV25 {
    protected byte deletableKeyType = 0;
    protected byte undeletableKeyType = 1;
    protected byte[] K_SM_ENC = new byte[32];
    protected byte[] K_SM_MAC = new byte[32];
    protected byte[] SSC = new byte[16];

    public Command30Kimlik(ICommandTransmitter transmitter, Version vers) {
        super(transmitter, vers);
    }

    @Override
    public LifeCycle getLifeCycle() throws AkisCIFException, AkisCardException, AkisSWException {
        byte[] lifeCycleCommand = new byte[]{0, -54, 1, 4, 0};
        ResponseAPDU responseAPDU = this.sendCommand(lifeCycleCommand);
        byte[] responseAPDUBytes = responseAPDU.getBytes();
        if (responseAPDUBytes[3] == 0 || responseAPDUBytes[3] == 5) {
            return LifeCycle.ACTIVATION;
        }
        if (responseAPDUBytes[3] == 85) {
            return LifeCycle.INITIALIZATION;
        }
        if (responseAPDUBytes[3] == 90) {
            return LifeCycle.PERSONALIZATION;
        }
        if (responseAPDUBytes[3] == -91) {
            return LifeCycle.OPERATION;
        }
        return LifeCycle.DEATH;
    }

    @Override
    protected void putDataSDO(byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandTemplate = new byte[]{0, -37, 63, -1};
        this.sendExtendedCommand(commandTemplate, data);
    }

    @Override
    public void externalAuthenticate(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] externalAuthTmpl = new byte[]{0, -126, 0, 0};
        byte[] mseData = this.generateMseData(signAlg, hashAlg, publicKeyIFD, privateKeyICC, AuthenticationType.ASYM_DEVICE_AUTH_SM);
        this.mseSet((byte)-127, (byte)-92, mseData);
        this.sendExtendedCommand(externalAuthTmpl, data);
    }

    @Override
    public void externalAuthenticatePure(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] externalAuthTmpl = new byte[]{0, -126, 0, 0};
        this.sendExtendedCommand(externalAuthTmpl, data);
    }

    @Override
    public void externalAuthenticate(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyRole, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] externalAuthTmpl = new byte[]{0, -126, 0, 0};
        byte[] mseData = this.generateMseData(signAlg, hashAlg, publicKeyRole, (byte)0, AuthenticationType.ROLE_AUTH_SM);
        this.mseSet((byte)-127, (byte)-92, mseData);
        this.sendExtendedCommand(externalAuthTmpl, data);
    }

    @Override
    public byte[] externalAuthenticate(Algorithm signAlg, Algorithm hashAlg, byte privateKeyICC, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] externalAuthTmpl = new byte[]{0, -126, 0, 0};
        byte[] mseData = this.generateMseData(signAlg, hashAlg, null, privateKeyICC, AuthenticationType.ASYM_DEVICE_AUTH_SM_CDS);
        this.mseSet((byte)-127, (byte)-92, mseData);
        this.getChallenge(8);
        ResponseAPDU response = this.sendExtendedCommand(externalAuthTmpl, data);
        return response.getData();
    }

    @Override
    public void activate(byte[] data, byte[] cert) throws AkisSWException, AkisCardException, AkisCIFException {
        this.pso(this.pso_param.cer, cert);
        this.exchangeChallengeWithP2(data, (byte)0);
    }

    @Override
    public byte[] pso(P1P2 psoMode, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        ResponseAPDU response;
        byte[] psoTempl = new byte[]{0, 42, psoMode.getp1(), psoMode.getp2()};
        byte[] pso = null;
        if (data == null) {
            pso = new byte[psoTempl.length + 1];
            System.arraycopy(psoTempl, 0, pso, 0, psoTempl.length);
            pso[pso.length - 1] = 0;
            response = this.sendCommand(pso);
        } else {
            response = this.sendExtendedCommand(psoTempl, data);
        }
        return response.getData();
    }

    private ResponseAPDU sendExtendedCommand(byte[] commandTempl, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] dataLengthByteArr = ByteBuffer.allocate(4).putInt(data.length).array();
        byte[] command = new byte[commandTempl.length + 3 + dataLengthByteArr.length - 2 + data.length];
        System.arraycopy(commandTempl, 0, command, 0, commandTempl.length);
        System.arraycopy(dataLengthByteArr, 1, command, commandTempl.length, dataLengthByteArr.length - 1);
        System.arraycopy(data, 0, command, 7, data.length);
        return this.sendCommand(command);
    }

    @Override
    public void activateSecureMsgingDeviceAuth(byte[] KICC, byte[] RICC, byte[] KIFD, byte[] RIFD) {
        this.generateSecureMessagingKey(KICC, RICC, KIFD, RIFD);
        this.isSecureMessagingActive = true;
    }

    @Override
    public void deactivateSecureMsging() {
        this.isSecureMessagingActive = false;
        int i2 = 0;
        for (i2 = 0; i2 < this.K_SM_ENC.length; ++i2) {
            this.K_SM_ENC[i2] = 0;
            this.K_SM_MAC[i2] = 0;
        }
        for (i2 = 0; i2 < this.SSC.length; ++i2) {
            this.SSC[i2] = 0;
        }
    }

    @Override
    protected void generateSecureMessagingKey(byte[] KICC, byte[] RICC, byte[] KIFD, byte[] RIFD) {
        byte[] K = new byte[32];
        for (int i2 = 0; i2 < 32; ++i2) {
            K[i2] = (byte)(KIFD[i2] ^ KICC[i2]);
        }
        byte[] c2 = new byte[]{0, 0, 0, 1};
        byte[] dataForHash = new byte[36];
        System.arraycopy(K, 0, dataForHash, 0, K.length);
        System.arraycopy(c2, 0, dataForHash, K.length, c2.length);
        this.K_SM_ENC = Crypto.computeHashValue(dataForHash, "SHA-256");
        c2[3] = 2;
        System.arraycopy(K, 0, dataForHash, 0, K.length);
        System.arraycopy(c2, 0, dataForHash, K.length, c2.length);
        this.K_SM_MAC = Crypto.computeHashValue(dataForHash, "SHA-256");
        this.SSC = new byte[16];
        System.arraycopy(RICC, 0, this.SSC, 0, 8);
        System.arraycopy(RIFD, 0, this.SSC, 8, 8);
    }

    @Override
    protected void decideSecureMessageKeyGeneratingKey() {
    }

    @Override
    protected byte[] exchangeChallenge(byte[] encryptedRandomNumber) throws AkisSWException, AkisCardException, AkisCIFException {
        byte p2 = 0;
        return this.exchangeChallengeWithP2(encryptedRandomNumber, p2);
    }

    private byte[] exchangeChallengeWithP2(byte[] encryptedRandomNumber, byte p2) throws AkisSWException, AkisCardException, AkisCIFException {
        ResponseAPDU response;
        byte[] commandTemplate = new byte[]{-128, -122, 0, 0};
        commandTemplate[3] = p2;
        if (encryptedRandomNumber.length > 240) {
            byte[] encryptedRandomNumberLengthByte = ByteBuffer.allocate(4).putInt(encryptedRandomNumber.length).array();
            byte[] command = new byte[commandTemplate.length + encryptedRandomNumberLengthByte.length - 1 + encryptedRandomNumber.length + 2];
            System.arraycopy(commandTemplate, 0, command, 0, commandTemplate.length);
            System.arraycopy(encryptedRandomNumberLengthByte, 1, command, commandTemplate.length, encryptedRandomNumberLengthByte.length - 1);
            System.arraycopy(encryptedRandomNumber, 0, command, 7, 256);
            response = this.sendCommand(command);
        } else {
            byte[] command = new byte[commandTemplate.length + 1 + encryptedRandomNumber.length];
            command[commandTemplate.length] = (byte)encryptedRandomNumber.length;
            System.arraycopy(commandTemplate, 0, command, 0, commandTemplate.length);
            System.arraycopy(encryptedRandomNumber, 0, command, commandTemplate.length + 1, encryptedRandomNumber.length);
            response = this.sendCommand(command);
        }
        return response.getData();
    }

    @Override
    protected byte[] createEncryptedCommand(byte[] command) throws AkisCIFException {
        byte[] createdCommand;
        int anInt;
        if (command.length > 260) {
            byte[] dataLengthByte = new byte[4];
            System.arraycopy(command, 4, dataLengthByte, 1, 3);
            anInt = ByteBuffer.wrap(dataLengthByte).getInt();
        } else {
            anInt = command[4] & 0xFF;
        }
        int plainCommandLen = command.length;
        int dataBlock87Len = 0;
        int dataBlock97Len = 0;
        int dataBlock8ELen = 18;
        byte[] dataBlock87 = null;
        byte[] dataBlock97 = null;
        if (plainCommandLen > 5) {
            int dataLen = anInt;
            int encdDataLen = 16 - dataLen % 16 + dataLen + 1;
            dataBlock87Len = encdDataLen >= 256 ? 16 - dataLen % 16 + dataLen + 5 : (encdDataLen >= 128 ? 16 - dataLen % 16 + dataLen + 4 : 16 - dataLen % 16 + dataLen + 3);
        }
        if (plainCommandLen >= 5 && (plainCommandLen == 5 || plainCommandLen == anInt + 6)) {
            dataBlock97Len = 3;
        }
        int arrayIndex = 0;
        if (command.length > 260) {
            createdCommand = new byte[7 + dataBlock87Len + dataBlock97Len + dataBlock8ELen + 2];
            createdCommand[0] = (byte)(command[0] | 0xC);
            System.arraycopy(command, 1, createdCommand, ++arrayIndex, 3);
            arrayIndex += 6;
        } else {
            createdCommand = new byte[5 + dataBlock87Len + dataBlock97Len + dataBlock8ELen + 1];
            createdCommand[0] = (byte)(command[0] | 0xC);
            System.arraycopy(command, 1, createdCommand, ++arrayIndex, 3);
            arrayIndex += 3;
            createdCommand[arrayIndex++] = 0;
        }
        this.incrementSSC();
        if (dataBlock87Len > 0) {
            dataBlock87 = this.createDataBlock87(command);
            System.arraycopy(dataBlock87, 0, createdCommand, arrayIndex, dataBlock87Len);
            arrayIndex += dataBlock87Len;
        }
        if (dataBlock97Len > 0) {
            dataBlock97 = this.createDataBlock97(command);
            System.arraycopy(dataBlock97, 0, createdCommand, arrayIndex, dataBlock97Len);
            arrayIndex += dataBlock97Len;
        }
        byte[] header = new byte[4];
        System.arraycopy(createdCommand, 0, header, 0, 4);
        byte[] paddedHeader = Crypto.padData(header, 16);
        if (dataBlock8ELen > 0) {
            byte[] dataBlock8E = this.createDataBlock8E(paddedHeader, dataBlock87, dataBlock97);
            System.arraycopy(dataBlock8E, 0, createdCommand, arrayIndex, dataBlock8ELen);
            arrayIndex += dataBlock8ELen;
        }
        int lc = dataBlock87Len + dataBlock97Len + dataBlock8ELen;
        if (command.length > 260) {
            byte[] lcBytes = ByteBuffer.allocate(4).putInt(lc).array();
            System.arraycopy(lcBytes, 1, createdCommand, 4, 3);
            createdCommand[createdCommand.length - 1] = 0;
            createdCommand[createdCommand.length - 2] = 0;
        } else {
            createdCommand[4] = (byte)lc;
            createdCommand[createdCommand.length - 1] = 0;
        }
        return createdCommand;
    }

    @Override
    protected byte[] createDataBlock87(byte[] command) throws AkisCIFException {
        int anInt;
        if (command.length > 260) {
            byte[] dataLengthByte = new byte[4];
            System.arraycopy(command, 4, dataLengthByte, 1, 3);
            anInt = ByteBuffer.wrap(dataLengthByte).getInt();
        } else {
            anInt = command[4] & 0xFF;
        }
        byte[] data = new byte[anInt];
        if (command.length > 260) {
            System.arraycopy(command, 7, data, 0, data.length);
        } else {
            System.arraycopy(command, 5, data, 0, data.length);
        }
        byte[] paddeddata = Crypto.padData(data, 16);
        byte[] IV = Crypto.aes(this.K_SM_ENC, this.SSC, true);
        byte[] aesData = Crypto.aesCBC(this.K_SM_ENC, IV, paddeddata, true);
        int dataIndex = 0;
        int dataLen = aesData.length;
        dataIndex = dataLen >= 256 ? 5 : (dataLen >= 128 ? 4 : 3);
        byte[] DOB87 = new byte[aesData.length + dataIndex];
        System.arraycopy(aesData, 0, DOB87, dataIndex, aesData.length);
        DOB87[0] = -121;
        byte[] berLen = Conversions.GetBerLen(dataLen + 1);
        int berLenCount = berLen.length;
        System.arraycopy(berLen, 0, DOB87, 1, berLenCount);
        DOB87[berLenCount + 1] = 1;
        return DOB87;
    }

    @Override
    protected byte[] createDataBlock97(byte[] command) {
        byte Le = command[command.length - 1];
        byte[] DOB97 = new byte[]{-105, 1, Le};
        return DOB97;
    }

    @Override
    public byte[] getData(byte mode) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] getDataCommand = new byte[]{0, -54, 1, 0, 0};
        int Le = 0;
        if (mode == GetDataModes.copyright) {
            Le = 28;
        } else if (mode == GetDataModes.chip) {
            Le = 2;
        } else if (mode == GetDataModes.atr) {
            Le = 23;
        } else if (mode == GetDataModes.memory) {
            Le = 7;
        } else if (mode == GetDataModes.cardType) {
            Le = 1;
        } else if (mode == GetDataModes.cardLabel) {
            Le = 32;
        } else if (mode == GetDataModes.romCheckSum) {
            Le = 2;
        } else if (mode == GetDataModes.userInfo) {
            Le = 16;
        } else if (mode == GetDataModes.versionInfo) {
            Le = this.manufacturer == Manufacturer.INF ? 31 : (this.manufacturer == Manufacturer.NXP ? 24 : 27);
        } else {
            if (mode == GetDataModes.serialNumber) {
                ResponseAPDU response = this.sendCommand(new byte[]{-128, 27, 0, 17, 0});
                return response.getData();
            }
            if (mode == GetDataModes.oaoaPublicKey) {
                Le = -121;
            } else if (mode == GetDataModes.company) {
                Le = 16;
            } else if (mode == GetDataModes.applicationUnit) {
                Le = 8;
            } else if (mode == GetDataModes.cardSerialNumber) {
                Le = 8;
            } else if (mode == GetDataModes.currentDate) {
                Le = 4;
            } else if (mode == GetDataModes.atrOptionalBytes) {
                Le = 2;
            } else if (mode == GetDataModes.gemKeySeeds) {
                Le = 80;
            }
        }
        getDataCommand[3] = mode;
        getDataCommand[getDataCommand.length - 1] = Le;
        ResponseAPDU response = this.sendCommand(getDataCommand);
        return response.getData();
    }

    @Override
    protected byte[] createDataBlock8E(byte[] paddedHeader, byte[] DOB87, byte[] DOB97) throws AkisCIFException {
        int inputLen = paddedHeader.length;
        if (DOB87 != null) {
            inputLen += DOB87.length;
        }
        if (DOB97 != null) {
            inputLen += DOB97.length;
        }
        byte[] checkSumInput = new byte[inputLen];
        int arrayIndex = 0;
        System.arraycopy(paddedHeader, 0, checkSumInput, arrayIndex, paddedHeader.length);
        arrayIndex += paddedHeader.length;
        if (DOB87 != null) {
            System.arraycopy(DOB87, 0, checkSumInput, arrayIndex, DOB87.length);
            arrayIndex += DOB87.length;
        }
        if (DOB97 != null) {
            System.arraycopy(DOB97, 0, checkSumInput, arrayIndex, DOB97.length);
            arrayIndex += DOB97.length;
        }
        byte[] datawithSSC = new byte[checkSumInput.length + this.SSC.length];
        System.arraycopy(this.SSC, 0, datawithSSC, 0, this.SSC.length);
        System.arraycopy(checkSumInput, 0, datawithSSC, this.SSC.length, checkSumInput.length);
        byte[] mac = Crypto.retailMacAes(datawithSSC, this.K_SM_MAC);
        byte[] block8E = new byte[mac.length + 2];
        block8E[0] = -114;
        block8E[1] = (byte)mac.length;
        System.arraycopy(mac, 0, block8E, 2, mac.length);
        return block8E;
    }

    @Override
    protected byte[] createDecryptedCommand(byte[] response) throws AkisCIFException {
        int responseLen = response.length;
        byte[] SW = new byte[2];
        byte[] CC = new byte[16];
        byte[] paddedOpenData = null;
        byte[] openData = null;
        int dataBlock99Len = 4;
        int dataBlock8ELen = 18;
        int dataBlock87Len = 0;
        int encryptedDataIndex = 0;
        int indexSW = 2;
        int indexCC = 6;
        this.incrementSSC();
        if (responseLen > 16 && response[0] == -121) {
            if (response[1] == -126) {
                dataBlock87Len = (response[2] & 0xFF) * 256 + (response[2] & 0xFF) + 3;
                encryptedDataIndex = 5;
            }
            if (response[1] == -127) {
                dataBlock87Len = (response[2] & 0xFF) + 3;
                encryptedDataIndex = 4;
            } else {
                dataBlock87Len = (response[1] & 0xFF) + 2;
                encryptedDataIndex = 3;
            }
            indexSW += dataBlock87Len;
            indexCC += dataBlock87Len;
            byte[] toBeDecryptedData = new byte[dataBlock87Len - encryptedDataIndex];
            System.arraycopy(response, encryptedDataIndex, toBeDecryptedData, 0, dataBlock87Len - encryptedDataIndex);
            byte[] IV = Crypto.aes(this.K_SM_ENC, this.SSC, true);
            paddedOpenData = Crypto.aesCBC(this.K_SM_ENC, IV, toBeDecryptedData, false);
            openData = Crypto.unPadData(paddedOpenData);
        }
        if (response[indexSW - 2] != -103) {
            throw new AkisCIFException("Status Word is not found.");
        }
        System.arraycopy(response, indexSW, SW, 0, 2);
        if (response[indexCC - 2] != -114) {
            throw new AkisCIFException("Checksum datablock is not found.");
        }
        System.arraycopy(response, indexCC, CC, 0, 16);
        byte[] toBeCC = new byte[16 + response.length - 20];
        System.arraycopy(this.SSC, 0, toBeCC, 0, 16);
        System.arraycopy(response, 0, toBeCC, 16, response.length - 20);
        byte[] CC_Expected = Crypto.retailMacAes(toBeCC, this.K_SM_MAC);
        for (int i2 = 0; i2 < 16; ++i2) {
            if (CC_Expected[i2] == CC[i2]) continue;
            throw new AkisCIFException("Checksum is not valid.");
        }
        byte[] openResponse = null;
        if (openData != null) {
            openResponse = new byte[openData.length + 2];
            System.arraycopy(openData, 0, openResponse, 0, openData.length);
            System.arraycopy(SW, 0, openResponse, openData.length, 2);
        } else {
            openResponse = new byte[2];
            System.arraycopy(SW, 0, openResponse, 0, 2);
        }
        return openResponse;
    }

    @Override
    protected void incrementSSC() {
        int len = this.SSC.length;
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = len - 1 - i2;
            this.SSC[n2] = (byte)(this.SSC[n2] + 1);
            if (this.SSC[len - 1 - i2] != 0) break;
        }
    }
}

