/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.commands;

import java.util.ArrayList;
import java.util.Random;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import tubitak.akis.cif.akisExceptions.AkisCIFException;
import tubitak.akis.cif.akisExceptions.AkisCardException;
import tubitak.akis.cif.akisExceptions.AkisSWException;
import tubitak.akis.cif.akisExceptions.UnsupportedVersionException;
import tubitak.akis.cif.commands.AbstractAkisCommands;
import tubitak.akis.cif.dataStructures.AkisKey;
import tubitak.akis.cif.dataStructures.Algorithm;
import tubitak.akis.cif.dataStructures.AuthenticationType;
import tubitak.akis.cif.dataStructures.FCI;
import tubitak.akis.cif.dataStructures.FileAccessRules;
import tubitak.akis.cif.dataStructures.FileIDs;
import tubitak.akis.cif.dataStructures.FileLevel;
import tubitak.akis.cif.dataStructures.FileTypes;
import tubitak.akis.cif.dataStructures.GetDataModes;
import tubitak.akis.cif.dataStructures.KeyType;
import tubitak.akis.cif.dataStructures.P1P2;
import tubitak.akis.cif.dataStructures.RSAKeyFields;
import tubitak.akis.cif.dataStructures.Version;
import tubitak.akis.cif.functions.Crypto;
import tubitak.akis.cif.functions.ICommandTransmitter;

public class CommandsV10
extends AbstractAkisCommands {
    protected byte[] OAOA_ABA = new byte[24];

    public CommandsV10(ICommandTransmitter transmitter, Version vers) {
        super(transmitter, vers);
        this.phaseBytePosition = 6;
        this.pso_param.cds = new P1P2(-98, -102);
        this.pso_param.ccc = new P1P2(-114, -128);
        this.pso_param.vcc = new P1P2(0, -94);
        this.pso_param.enc = new P1P2(-122, -128);
        this.pso_param.dec = new P1P2(-128, -122);
        this.pso_param.hash = new P1P2(-112, -128);
        this.pso_param.vds = new P1P2(0, -88);
        this.fileAccessRules = new FileAccessRules(-1, -66, -66, 0);
        this.fileTypes = new FileTypes(-128, 65, 67, 69);
    }

    @Override
    public void createBinaryEFbySFI(byte[] FID, byte SFI, FileTypes.FileType type, FileAccessRules.FileAccessRule access) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void createDFbyFID(byte[] FID, FileTypes.FileType type, FileAccessRules.FileAccessRule access) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{-128, 16, 0, -73, 2, 0, 0};
        commandBytes[5] = FID[0];
        commandBytes[6] = FID[1];
        this.sendCommand(commandBytes);
    }

    @Override
    public void createDFbyName(byte[] FID, byte[] name, FileTypes.FileType type, FileAccessRules.FileAccessRule access) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{-128, 16, 0, 55, 0};
        byte[] createCommand = null;
        commandBytes[4] = (byte)name.length;
        createCommand = new byte[name.length + commandBytes.length];
        System.arraycopy(commandBytes, 0, createCommand, 0, commandBytes.length);
        System.arraycopy(name, 0, createCommand, commandBytes.length, name.length);
        this.sendCommand(createCommand);
    }

    @Override
    public void deleteCurrent() {
        throw new UnsupportedVersionException();
    }

    @Override
    public void deleteByFIDUnderMF(byte[] FID, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte ins = (byte)(level == FileLevel.DF ? 17 : 22);
        byte[] eraseCommand = new byte[]{-128, ins, 0, 0, 2, FID[0], FID[1]};
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByFIDUnderDF(byte[] FID, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte ins = (byte)(level == FileLevel.DF ? 17 : 22);
        byte p1 = (byte)(level == FileLevel.DF ? 1 : 2);
        byte[] eraseCommand = new byte[]{-128, ins, p1, 0, 2, FID[0], FID[1]};
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteDFByName(byte[] name) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] eraseCommandHeader = new byte[]{-128, 17, 4, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + name.length];
        eraseCommandHeader[4] = (byte)name.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(name, 0, eraseCommand, eraseCommandHeader.length, name.length);
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByFIDPathFromMF(byte[] path, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte ins = (byte)(level == FileLevel.DF ? 17 : 22);
        byte[] eraseCommandHeader = new byte[]{-128, ins, 8, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + path.length];
        eraseCommandHeader[4] = (byte)path.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(path, 0, eraseCommand, eraseCommandHeader.length, path.length);
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByFIDPathFromDF(byte[] path, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte ins = (byte)(level == FileLevel.DF ? 17 : 22);
        byte[] eraseCommandHeader = new byte[]{-128, ins, 9, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + path.length];
        eraseCommandHeader[4] = (byte)path.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(path, 0, eraseCommand, eraseCommandHeader.length, path.length);
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByNamePathFromMF(byte[] path, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte ins = (byte)(level == FileLevel.DF ? 17 : 22);
        byte[] eraseCommandHeader = new byte[]{-128, ins, 12, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + path.length];
        eraseCommandHeader[4] = (byte)path.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(path, 0, eraseCommand, eraseCommandHeader.length, path.length);
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByNamePathFromDF(byte[] path, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte ins = (byte)(level == FileLevel.DF ? 17 : 22);
        byte[] eraseCommandHeader = new byte[]{-128, ins, 13, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + path.length];
        eraseCommandHeader[4] = (byte)path.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(path, 0, eraseCommand, eraseCommandHeader.length, path.length);
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteParentDF() {
        throw new UnsupportedVersionException();
    }

    @Override
    public int getPinRemainingUsageCount() throws AkisSWException, AkisCardException, AkisCIFException {
        ResponseAPDU response;
        block2: {
            byte[] remainedPinCountCommand = new byte[]{0, 32, 0, -127, 0};
            response = null;
            try {
                response = this.mCardChannel.transmit(new CommandAPDU(remainedPinCountCommand));
            }
            catch (Exception e2) {
                if (e2.getMessage().contains("63c")) break block2;
                throw new RuntimeException();
            }
        }
        return response.getBytes()[1] & 0xF;
    }

    @Override
    public FCI selectMF() throws AkisSWException, AkisCardException, AkisCIFException {
        return this.selectFileUnderMF(FileIDs.MF);
    }

    @Override
    public FCI selectFileUnderMF(byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 0, 0, 2, 0, 0};
        selectFileCommand[5] = FID[0];
        selectFileCommand[6] = FID[1];
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectChildDF(byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 1, 0, 2, 0, 0};
        selectFileCommand[5] = FID[0];
        selectFileCommand[6] = FID[1];
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectEFUnderDF(byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 2, 0, 2, 0, 0};
        selectFileCommand[5] = FID[0];
        selectFileCommand[6] = FID[1];
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectParentDF() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 3, 0};
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectDFByName(byte[] name) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{0, -92, 4, 0, 0};
        byte[] selectFileCommand = null;
        commandBytes[4] = (byte)name.length;
        selectFileCommand = new byte[name.length + 5];
        System.arraycopy(commandBytes, 0, selectFileCommand, 0, commandBytes.length);
        System.arraycopy(name, 0, selectFileCommand, commandBytes.length, name.length);
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectFromMFByPath(byte[] path) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{0, -92, 8, 0, 0};
        byte[] selectFileCommand = null;
        commandBytes[4] = (byte)path.length;
        selectFileCommand = new byte[path.length + 5];
        System.arraycopy(commandBytes, 0, selectFileCommand, 0, commandBytes.length);
        System.arraycopy(path, 0, selectFileCommand, commandBytes.length, path.length);
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectFromDFByPath(byte[] path) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{0, -92, 9, 0, 0};
        byte[] selectFileCommand = null;
        commandBytes[4] = (byte)path.length;
        selectFileCommand = new byte[path.length + 5];
        System.arraycopy(commandBytes, 0, selectFileCommand, 0, commandBytes.length);
        System.arraycopy(path, 0, selectFileCommand, commandBytes.length, path.length);
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public byte[] readFileBySelectingUnderActiveDF(byte[] FID) throws AkisCardException, AkisCIFException, AkisSWException {
        byte[] data = null;
        int fileLength = this.selectEFUnderDF(FID).getFileLength();
        if (fileLength > 0) {
            data = new byte[fileLength];
            int unReadDataLength = fileLength;
            int index = 0;
            while (unReadDataLength > 0) {
                ResponseAPDU response;
                byte MSB = (byte)((index & 0xFF00) >> 8);
                byte LSB = (byte)(index & 0xFF);
                byte Le = -1;
                if (unReadDataLength < 255) {
                    Le = (byte)unReadDataLength;
                }
                byte[] readFileCommand = new byte[]{0, -80, MSB, LSB, Le};
                try {
                    response = this.sendCommand(readFileCommand);
                }
                catch (AkisSWException ex) {
                    if (ex.getErrorCode() == -126L) continue;
                    throw ex;
                }
                int readDataLength = response.getData().length;
                byte[] responseData = response.getData();
                System.arraycopy(responseData, 0, data, index, readDataLength);
                unReadDataLength -= readDataLength;
                index += readDataLength;
            }
        }
        return data;
    }

    @Override
    public void updateBinaryFile(byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        int dataLenInCommand;
        int index = 0;
        for (int unWritenDataLength = data.length; unWritenDataLength > 0; unWritenDataLength -= dataLenInCommand) {
            byte MSB = (byte)((index & 0xFF00) >> 8);
            byte LSB = (byte)(index & 0xFF);
            byte[] updateBinaryTemplate = new byte[]{0, -42, MSB, LSB, 0};
            dataLenInCommand = 0;
            dataLenInCommand = unWritenDataLength > 196 ? 196 : unWritenDataLength;
            updateBinaryTemplate[4] = (byte)dataLenInCommand;
            byte[] updateBinaryCommand = new byte[updateBinaryTemplate.length + dataLenInCommand];
            System.arraycopy(updateBinaryTemplate, 0, updateBinaryCommand, 0, updateBinaryTemplate.length);
            System.arraycopy(data, index, updateBinaryCommand, updateBinaryTemplate.length, dataLenInCommand);
            this.sendCommand(updateBinaryCommand);
            index += dataLenInCommand;
        }
    }

    @Override
    public AkisKey[] getKeyInfos() throws AkisCardException, AkisCIFException, AkisSWException {
        byte[] readKeysCommand;
        if (this.isSecureMessagingActive) {
            byte[] readKeysCommand1 = new byte[]{-128, 31, 0, 0, 8};
            readKeysCommand = readKeysCommand1;
        } else {
            byte[] readKeysCommand2;
            readKeysCommand = readKeysCommand2 = new byte[]{-128, 31, 0, 0};
        }
        byte[] data = null;
        for (int i2 = 0; i2 < 5; ++i2) {
            try {
                data = this.sendCommand(readKeysCommand).getData();
                break;
            }
            catch (AkisSWException ex) {
                if (ex.getErrorCode() != 27010L) {
                    throw ex;
                }
                readKeysCommand[4] = (byte)(readKeysCommand[4] + 8);
                continue;
            }
        }
        int keyCount = data[2];
        int startIndex = 5;
        AkisKey[] keys = new AkisKey[keyCount];
        for (int i3 = 0; i3 < keyCount; ++i3) {
            byte keyID = data[startIndex + 3 * i3];
            byte durumBilgisi = data[startIndex + 2 + 3 * i3];
            KeyType type = null;
            type = (durumBilgisi & 0x1F) == 31 ? KeyType.PRIVATE_RSA : ((durumBilgisi & 0x60) == 96 ? KeyType.PUBLIC_RSA : KeyType.UNKNOWN);
            keys[i3] = new AkisKey(keyID, type);
        }
        return keys;
    }

    @Override
    public int getMaxKeyID() throws AkisCardException, AkisCIFException, AkisSWException {
        byte[] readKeysCommand = new byte[]{-128, 31, 0, 0, 0};
        byte max = 0;
        ResponseAPDU response = null;
        try {
            response = this.sendCommand(readKeysCommand);
        }
        catch (AkisSWException e2) {
            if (e2.getErrorCode() == 25625L) {
                return 0;
            }
            throw e2;
        }
        byte[] keyAttr = response.getData();
        for (int i2 = 0; i2 < keyAttr[2]; ++i2) {
            max = keyAttr[i2 * 3 + 5] > max ? keyAttr[i2 * 3 + 5] : max;
        }
        return max;
    }

    @Override
    public byte[] getPublicExponent(byte keyID) throws AkisCardException, AkisCIFException, AkisSWException {
        byte[] command = new byte[]{-128, 31, 64, keyID, 1};
        ResponseAPDU response = null;
        ArrayList<Byte> data = new ArrayList<Byte>();
        try {
            response = this.sendCommand(command);
        }
        catch (AkisSWException ex) {
            while (ex.getErrorCode() < -1L && ex.getErrorCode() > 0L) {
                data.add(response.getData()[0]);
                response = this.sendCommand(command);
            }
            byte[] d2 = new byte[data.size()];
            for (int i2 = 0; i2 < data.size(); ++i2) {
                d2[0] = (Byte)data.get(i2);
            }
            return d2;
        }
        return response.getData();
    }

    @Override
    public byte[] getModulus(byte keyID) throws AkisCardException, AkisCIFException, AkisSWException {
        ResponseAPDU response;
        block2: {
            byte[] command = new byte[]{-128, 31, 32, keyID, -128};
            byte[] data = new byte[256];
            response = null;
            try {
                response = this.sendCommand(command);
            }
            catch (AkisSWException ex) {
                if (ex.getErrorCode() >= -1L || ex.getErrorCode() <= 0L) break block2;
                System.arraycopy(response.getBytes(), 0, data, 0, 128);
                response = this.sendCommand(command);
                System.arraycopy(response.getBytes(), 0, data, 128, 128);
                return data;
            }
        }
        return response.getData();
    }

    @Override
    public void writePublicKey(RSAKeyFields fields, int keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] oneField = new byte[fields.public_Exponent.length + 2];
        oneField[0] = -42;
        oneField[1] = (byte)(fields.public_Exponent.length == 256 ? 0 : fields.public_Exponent.length);
        System.arraycopy(fields.public_Exponent, 0, oneField, 2, fields.public_Exponent.length);
        this.writeKey(oneField, (byte)76, keyID);
        oneField = new byte[fields.modBytes.length + 2];
        oneField[0] = -41;
        oneField[1] = (byte)(fields.modBytes.length == 256 ? 0 : fields.modBytes.length);
        System.arraycopy(fields.modBytes, 0, oneField, 2, fields.modBytes.length);
        this.writeKey(oneField, (byte)44, keyID);
    }

    @Override
    public void writePrivateKey(RSAKeyFields fields, int keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] oneField = new byte[fields.prime_1.length + 2];
        oneField[0] = -47;
        oneField[1] = (byte)fields.prime_1.length;
        System.arraycopy(fields.prime_1, 0, oneField, 2, fields.prime_1.length);
        this.writeKey(oneField, (byte)-100, keyID);
        oneField = new byte[fields.prime_2.length + 2];
        oneField[0] = -46;
        oneField[1] = (byte)fields.prime_2.length;
        System.arraycopy(fields.prime_2, 0, oneField, 2, fields.prime_2.length);
        this.writeKey(oneField, (byte)-84, keyID);
        oneField = new byte[fields.exponent_1.length + 2];
        oneField[0] = -45;
        oneField[1] = (byte)fields.exponent_1.length;
        System.arraycopy(fields.exponent_1, 0, oneField, 2, fields.exponent_1.length);
        this.writeKey(oneField, (byte)-68, keyID);
        oneField = new byte[fields.exponent_2.length + 2];
        oneField[0] = -44;
        oneField[1] = (byte)fields.exponent_2.length;
        System.arraycopy(fields.exponent_2, 0, oneField, 2, fields.exponent_1.length);
        this.writeKey(oneField, (byte)-52, keyID);
        oneField = new byte[fields.coefficient.length + 2];
        oneField[0] = -43;
        oneField[1] = (byte)fields.coefficient.length;
        System.arraycopy(fields.coefficient, 0, oneField, 2, fields.coefficient.length);
        this.writeKey(oneField, (byte)-36, keyID);
        oneField = new byte[fields.modBytes.length + 2];
        oneField[0] = -41;
        oneField[1] = (byte)(fields.modBytes.length > 256 ? 0 : fields.modBytes.length);
        System.arraycopy(fields.modBytes, 0, oneField, 2, fields.modBytes.length);
        this.writeKey(oneField, (byte)44, keyID);
    }

    protected void writeKey(byte[] data, byte type, int keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] wk1 = new byte[]{-128, 30, (byte)(keyID | 0x80), type};
        if (data.length > 230) {
            int remaining = data.length;
            int offset = 0;
            do {
                int dataPartLen = remaining > 230 ? 230 : remaining;
                byte[] wk = new byte[wk1.length + 1 + dataPartLen];
                System.arraycopy(wk1, 0, wk, 0, wk1.length);
                wk[wk1.length] = (byte)dataPartLen;
                System.arraycopy(data, offset, wk, wk1.length + 1, dataPartLen);
                if (remaining > 230) {
                    wk[0] = (byte)(wk[0] | 0x10);
                }
                this.sendCommand(wk);
                offset += dataPartLen;
            } while ((remaining -= 230) > 0);
        } else {
            byte[] wk = new byte[wk1.length + 1 + data.length];
            wk[wk1.length] = (byte)data.length;
            System.arraycopy(wk1, 0, wk, 0, wk1.length);
            System.arraycopy(data, 0, wk, wk1.length + 1, data.length);
            this.sendCommand(wk);
        }
    }

    @Override
    public void writeBACKey(byte[] key, byte passportKeyProp, byte passportKeyId) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void deleteKey(int keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] deleteKey = new byte[]{-128, 30, (byte)keyID, 0};
        this.sendCommand(deleteKey);
    }

    @Override
    public void putData(P1P2 params, byte[] data) {
        throw new UnsupportedOperationException("putData Not implemented");
    }

    @Override
    public byte[] getData(byte mode) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] getDataCommand = new byte[]{0, -54, 1, 0, 0};
        int Le = 0;
        if (mode == GetDataModes.copyright) {
            Le = 23;
        } else if (mode == GetDataModes.chip) {
            Le = 2;
        } else if (mode == GetDataModes.atr) {
            Le = 18;
        } else if (mode == GetDataModes.memory) {
            Le = 10;
        } else if (mode == GetDataModes.cardType) {
            Le = 1;
        } else if (mode == GetDataModes.system) {
            Le = 77;
        } else if (mode == GetDataModes.romCheckSum) {
            Le = 2;
        }
        getDataCommand[3] = mode;
        getDataCommand[getDataCommand.length - 1] = Le;
        ResponseAPDU response = this.sendCommand(getDataCommand);
        return response.getData();
    }

    @Override
    public byte[] getSerial() throws AkisCardException, AkisSWException, AkisCIFException {
        byte[] serial;
        try {
            serial = this.getSerialByKartTest();
        }
        catch (AkisCIFException ex) {
            serial = this.getSerialGetDataForActivation();
        }
        catch (AkisSWException ex) {
            serial = this.getSerialGetDataForActivation();
        }
        return serial;
    }

    @Override
    protected byte[] getSerialGetData() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] getDatabytes = this.getData(GetDataModes.system);
        byte[] serial = new byte[8];
        if (getDatabytes.length < 67) {
            throw new AkisCIFException("Serial number can not be read. Get Data command returned insufficient length data.");
        }
        System.arraycopy(getDatabytes, 57, serial, 0, 2);
        System.arraycopy(getDatabytes, 61, serial, 2, 6);
        return serial;
    }

    @Override
    protected byte[] getSerialGetDataForActivation() throws AkisSWException, AkisCardException, AkisCIFException {
        return this.getSerialGetData();
    }

    @Override
    public int getEmptyMemory() throws AkisSWException, AkisCardException, AkisCIFException {
        int emptyMemory = 0;
        byte[] cardSystemInfo = this.getData(GetDataModes.system);
        emptyMemory = 0xFF & cardSystemInfo[73];
        emptyMemory <<= 8;
        return emptyMemory += 0xFF & cardSystemInfo[74];
    }

    @Override
    public void activate(byte[] data) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verifyInit(byte[] initKey) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verifyPerso(byte[] persoKey) {
        throw new UnsupportedVersionException();
    }

    @Override
    protected byte[] exchangeChallenge(byte[] encryptedRandomNumber) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] command = new byte[encryptedRandomNumber.length + 6];
        command[0] = -128;
        command[1] = -122;
        command[2] = 0;
        command[3] = 0;
        command[4] = (byte)encryptedRandomNumber.length;
        command[encryptedRandomNumber.length + 5] = 8;
        System.arraycopy(encryptedRandomNumber, 0, command, 5, encryptedRandomNumber.length);
        ResponseAPDU response = this.sendCommand(command);
        if (response.getSW() != 36864) {
            throw new AkisSWException(response.getSW());
        }
        return response.getData();
    }

    @Override
    public void externalAuthenticatePure(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, byte[] data) {
        throw new UnsupportedVersionException();
    }

    @Override
    public byte[] generateMseData(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, AuthenticationType authType) {
        throw new UnsupportedVersionException();
    }

    @Override
    public byte[] getChallenge(int len) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verifyWithPinPad(byte pinNo, boolean isMF) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verify(byte[] pin, boolean isMF) throws AkisSWException, AkisCardException, AkisCIFException {
        for (int i2 = 0; i2 < pin.length; ++i2) {
            pin[i2] = (byte)(pin[i2] - 48);
        }
        byte[] verifyCommandTemplate = new byte[]{0, 32, 0, -128, 0};
        if (isMF) {
            verifyCommandTemplate[3] = 1;
        }
        verifyCommandTemplate[4] = (byte)pin.length;
        byte[] verifyCommand = new byte[verifyCommandTemplate.length + pin.length];
        System.arraycopy(verifyCommandTemplate, 0, verifyCommand, 0, verifyCommandTemplate.length);
        System.arraycopy(pin, 0, verifyCommand, verifyCommandTemplate.length, pin.length);
        this.sendCommand(verifyCommand);
    }

    @Override
    public void verify(byte pinNo, byte[] pin, boolean isMF) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void unlockDFPIN(byte[] fid, byte[] PUK, byte[] yeniPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        int i2;
        byte[] oldPIN = new byte[PUK.length];
        byte[] newPIN = new byte[yeniPIN.length];
        for (i2 = 0; i2 < PUK.length; ++i2) {
            oldPIN[i2] = (byte)(PUK[i2] - 48);
        }
        for (i2 = 0; i2 < yeniPIN.length; ++i2) {
            newPIN[i2] = (byte)(yeniPIN[i2] - 48);
        }
        this.changePhaseToAdmin(PUK);
        this.selectFileUnderMF(fid);
        byte[] resetCounter = new byte[]{-128, 25, 5, 61, 2, 61, 0};
        if (fid != null) {
            resetCounter[5] = fid[0];
            resetCounter[6] = fid[1];
        }
        this.sendCommand(resetCounter);
        byte[] setPIN_part1 = new byte[]{0, 36, 2, 0};
        int lengthOfCommand = PUK.length + newPIN.length + 2;
        byte[] setPIN = new byte[lengthOfCommand + 5];
        System.arraycopy(setPIN_part1, 0, setPIN, 0, 4);
        setPIN[4] = (byte)lengthOfCommand;
        setPIN[5] = (byte)PUK.length;
        System.arraycopy(PUK, 0, setPIN, 6, PUK.length);
        setPIN[6 + PUK.length] = (byte)newPIN.length;
        System.arraycopy(newPIN, 0, setPIN, 6 + PUK.length + 1, newPIN.length);
        this.sendCommand(setPIN);
    }

    @Override
    public void unlockMFPIN(byte[] PUK, byte[] newPIN) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void changeDFPIN(byte[] fid, byte[] eskiPIN, byte[] yeniPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        int i2;
        byte[] oldPIN = new byte[eskiPIN.length];
        byte[] newPIN = new byte[yeniPIN.length];
        for (i2 = 0; i2 < eskiPIN.length; ++i2) {
            oldPIN[i2] = (byte)(eskiPIN[i2] - 48);
        }
        for (i2 = 0; i2 < yeniPIN.length; ++i2) {
            newPIN[i2] = (byte)(yeniPIN[i2] - 48);
        }
        byte[] changepin = new byte[7 + oldPIN.length + newPIN.length];
        byte[] changepin1 = new byte[]{0, 36, 2, 0};
        byte[] lengthOfCommand = new byte[]{(byte)(newPIN.length + oldPIN.length + 2)};
        System.arraycopy(changepin1, 0, changepin, 0, 4);
        System.arraycopy(lengthOfCommand, 0, changepin, 4, 1);
        byte[] len = new byte[2];
        len[0] = (byte)oldPIN.length;
        System.arraycopy(len, 0, changepin, 5, 1);
        System.arraycopy(oldPIN, 0, changepin, 6, len[0]);
        len[1] = (byte)newPIN.length;
        System.arraycopy(len, 1, changepin, 6 + len[0], 1);
        System.arraycopy(newPIN, 0, changepin, 6 + len[0] + 1, len[1]);
        this.selectMF();
        this.selectFileUnderMF(fid);
        this.sendCommand(changepin);
    }

    @Override
    public void changeDFPUK(byte[] fid, byte[] oldPIN, byte[] newPIN) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void changeMFPIN(byte[] eskiPIN, byte[] yeniPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        int i2;
        byte[] oldPIN = new byte[eskiPIN.length];
        byte[] newPIN = new byte[yeniPIN.length];
        for (i2 = 0; i2 < eskiPIN.length; ++i2) {
            oldPIN[i2] = (byte)(eskiPIN[i2] - 48);
        }
        for (i2 = 0; i2 < yeniPIN.length; ++i2) {
            newPIN[i2] = (byte)(yeniPIN[i2] - 48);
        }
        byte[] changepin = new byte[7 + oldPIN.length + newPIN.length];
        byte[] changepin1 = new byte[]{0, 36, 1, 0};
        byte[] lengthOfCommand = new byte[]{(byte)(newPIN.length + oldPIN.length + 2)};
        System.arraycopy(changepin1, 0, changepin, 0, 4);
        System.arraycopy(lengthOfCommand, 0, changepin, 4, 1);
        byte[] len = new byte[2];
        len[0] = (byte)oldPIN.length;
        System.arraycopy(len, 0, changepin, 5, 1);
        System.arraycopy(oldPIN, 0, changepin, 6, len[0]);
        len[1] = (byte)newPIN.length;
        System.arraycopy(len, 1, changepin, 6 + len[0], 1);
        System.arraycopy(newPIN, 0, changepin, 6 + len[0] + 1, len[1]);
        this.selectMF();
        this.changePhaseToAdmin(yeniPIN);
        this.sendCommand(changepin);
    }

    @Override
    public void changeMFPUK(byte[] mfPIN, byte[] oldPIN, byte[] newPIN) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void mse(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] mse = new byte[]{0, 34, -61, keyID};
        this.sendCommand(mse);
    }

    @Override
    public byte[] pso(P1P2 psoMode, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        int le = -1;
        if (psoMode.equals(this.pso_param.ccc)) {
            le = 8;
        }
        if (psoMode.equals(this.pso_param.cds)) {
            le = -1;
        }
        if (psoMode.equals(this.pso_param.enc)) {
            le = -1;
        }
        if (psoMode.equals(this.pso_param.dec)) {
            le = -1;
        }
        if (psoMode.equals(this.pso_param.vcc)) {
            le = -1;
        }
        if (psoMode.equals(this.pso_param.hash)) {
            le = 20;
        }
        byte[] pso1 = new byte[]{0, 42, psoMode.getp1(), psoMode.getp2()};
        int len = pso1.length + data.length + 1;
        if (le > -1) {
            ++len;
        }
        byte[] pso = new byte[len];
        System.arraycopy(pso1, 0, pso, 0, pso1.length);
        pso[pso1.length] = (byte)data.length;
        System.arraycopy(data, 0, pso, pso1.length + 1, data.length);
        if (le > -1) {
            pso[pso.length - 1] = le;
        }
        return this.sendCommand(pso).getData();
    }

    @Override
    public byte[] sign(byte[] data, byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        this.mse(keyID);
        return this.pso(this.pso_param.cds, data);
    }

    @Override
    public void decideSecureMessageKeyGeneratingKey() {
        byte[] OAOA_A = new byte[]{16, 50, 84, 118, -104, -70, -36, -2};
        byte[] OAOA_B = new byte[]{17, 34, 51, 68, 85, 102, 119, -120};
        this.OAOA_ABA = new byte[24];
        System.arraycopy(OAOA_A, 0, this.OAOA_ABA, 0, 8);
        System.arraycopy(OAOA_B, 0, this.OAOA_ABA, 8, 8);
        System.arraycopy(OAOA_A, 0, this.OAOA_ABA, 16, 8);
    }

    @Override
    public void generateSecureMessagingKey() throws AkisCIFException, AkisSWException, AkisCardException {
        byte[] OA_A = new byte[8];
        byte[] OA_B = new byte[8];
        Random rnd = new Random();
        byte[] rand8bytes = new byte[8];
        rnd.nextBytes(rand8bytes);
        byte[] cipherText_A = new byte[16];
        cipherText_A = Crypto.triDes(this.OAOA_ABA, rand8bytes, true);
        byte[] alinanRandom = new byte[8];
        alinanRandom = this.exchangeChallenge(cipherText_A);
        if (alinanRandom == null || alinanRandom.length != 8) {
            throw new AkisCIFException("Exchange Challange returned data with unexpected length (not 16 byte)");
        }
        byte[] cipherText_B = new byte[16];
        cipherText_B = Crypto.triDes(this.OAOA_ABA, alinanRandom, false);
        System.arraycopy(rand8bytes, 0, OA_A, 0, 8);
        System.arraycopy(cipherText_B, 0, OA_B, 0, 8);
        System.arraycopy(OA_A, 0, this.secureMessagingKey_ABA, 0, 8);
        System.arraycopy(OA_B, 0, this.secureMessagingKey_ABA, 8, 8);
        System.arraycopy(OA_A, 0, this.secureMessagingKey_ABA, 16, 8);
    }

    @Override
    public void generateSecureMessagingKey(String documentNumber, String dateOfBirth, String expireDate) {
        throw new UnsupportedVersionException();
    }

    @Override
    protected byte[] createEncryptedCommand(byte[] command) throws AkisCIFException {
        boolean mode = false;
        int index = 0;
        int secDataLen = 0;
        int dataLen = 0;
        int Le = -2;
        int intLE = -2;
        int returnLe = -2;
        int inputCommandLc = 1000;
        if (command.length > 4) {
            inputCommandLc = command[4] & 0xFF;
        }
        if (command.length >= 5) {
            if (command.length == 5) {
                Le = command[command.length - 1];
                intLE = Le & 0xFF;
            } else if (command.length > 5 && inputCommandLc < command.length - 5) {
                Le = command[command.length - 1];
                intLE = Le & 0xFF;
            }
        }
        if (intLE == 0 || intLE == 255) {
            returnLe = Le;
        } else if (intLE > -2 && intLE % 8 == 0) {
            returnLe = (byte)(intLE + 8);
        } else if (intLE > -2 && intLE % 8 < 2) {
            returnLe = (byte)(intLE + (16 - intLE % 8));
        } else if (intLE > -2) {
            returnLe = (byte)(intLE + (8 - intLE % 8));
        }
        if (command.length <= 5) {
            mode = false;
        } else if (command.length > 5) {
            mode = true;
        }
        byte[] createdCommand = new byte[256];
        System.arraycopy(command, 0, createdCommand, 0, command.length);
        createdCommand[0] = (byte)(createdCommand[0] | 4);
        int createdCommandLen = 0;
        if (!mode) {
            index = 4;
            createdCommandLen = command.length;
            if (intLE > -2) {
                createdCommand[index++] = returnLe;
            }
        } else if (mode) {
            int komutBoyu = 5;
            if (intLE > -2) {
                ++komutBoyu;
            }
            secDataLen = ((dataLen = command.length - komutBoyu) + 2) % 8 > 0 ? dataLen + 2 + (8 - (dataLen + 2) % 8) : dataLen + 2;
            index = 4;
            createdCommand[index++] = (byte)secDataLen;
            createdCommand[index++] = -122;
            createdCommand[index++] = (byte)dataLen;
            for (int i2 = 0; i2 < dataLen; ++i2) {
                createdCommand[index++] = command[i2 + 5];
            }
            index += dataLen;
            createdCommandLen = secDataLen + komutBoyu;
            if (intLE > -2) {
                createdCommand[index++] = returnLe;
            }
        }
        if (secDataLen > 0) {
            for (int j2 = index; j2 < createdCommandLen; ++j2) {
                createdCommand[j2] = 0;
            }
            byte[] plainData = new byte[secDataLen];
            System.arraycopy(createdCommand, 5, plainData, 0, secDataLen);
            byte[] cipherData = Crypto.triDes(this.secureMessagingKey_ABA, plainData, true);
            if (cipherData == null) {
                return null;
            }
            System.arraycopy(cipherData, 0, createdCommand, 5, cipherData.length);
        }
        byte[] newCommand = new byte[createdCommandLen];
        System.arraycopy(createdCommand, 0, newCommand, 0, createdCommandLen);
        return newCommand;
    }

    @Override
    protected byte[] createDecryptedCommand(byte[] response) throws AkisCIFException {
        if (response.length < 3) {
            return response;
        }
        byte[] plain = null;
        if (response.length % 8 <= 2) {
            byte[] cipher;
            if (response.length % 8 <= 2) {
                cipher = new byte[response.length - response.length % 8];
                System.arraycopy(response, 0, cipher, 0, cipher.length);
                plain = Crypto.triDes(this.secureMessagingKey_ABA, cipher, false);
            } else {
                cipher = new byte[response.length - response.length % 8];
                System.arraycopy(response, response.length - (response.length - response.length % 8 + 2), cipher, 0, cipher.length);
                plain = Crypto.triDes(this.secureMessagingKey_ABA, cipher, false);
            }
            if (plain == null || plain.length == 0) {
                return null;
            }
            int i2 = 0;
            int len = plain[1] & 0xFF;
            int dataIndexInMessage = 2;
            if (plain[0] != -122 && plain.length == 256) {
                len = 256;
                dataIndexInMessage = 0;
            }
            byte[] plainWithSW = new byte[len + 2];
            for (i2 = 0; i2 < plainWithSW.length - 2; ++i2) {
                plainWithSW[i2] = plain[dataIndexInMessage++];
            }
            plainWithSW[plainWithSW.length - 2] = response[response.length - 2];
            plainWithSW[plainWithSW.length - 1] = response[response.length - 1];
            return plainWithSW;
        }
        throw new AkisCIFException("Secure Messaging Decrypt Error: data length is not multiple of 8.");
    }
}

