/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.commands;

import java.util.Random;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import tubitak.akis.cif.akisExceptions.AkisCIFException;
import tubitak.akis.cif.akisExceptions.AkisCardException;
import tubitak.akis.cif.akisExceptions.AkisSWException;
import tubitak.akis.cif.akisExceptions.UnsupportedVersionException;
import tubitak.akis.cif.commands.AbstractAkisCommands;
import tubitak.akis.cif.dataStructures.ActivationType;
import tubitak.akis.cif.dataStructures.AkisKey;
import tubitak.akis.cif.dataStructures.Algorithm;
import tubitak.akis.cif.dataStructures.AuthenticationType;
import tubitak.akis.cif.dataStructures.FCI;
import tubitak.akis.cif.dataStructures.FileAccessRules;
import tubitak.akis.cif.dataStructures.FileLevel;
import tubitak.akis.cif.dataStructures.FileTypes;
import tubitak.akis.cif.dataStructures.GetDataModes;
import tubitak.akis.cif.dataStructures.KeyType;
import tubitak.akis.cif.dataStructures.P1P2;
import tubitak.akis.cif.dataStructures.RSAKeyFields;
import tubitak.akis.cif.dataStructures.Version;
import tubitak.akis.cif.functions.Conversions;
import tubitak.akis.cif.functions.Crypto;
import tubitak.akis.cif.functions.ICommandTransmitter;

public class CommandsV14
extends AbstractAkisCommands {
    protected static byte[] icaoAID = new byte[]{-96, 0, 0, 2, 71, 16, 1};
    protected byte deletableKeyType = 0;
    protected byte undeletableKeyType = 1;
    protected byte[] c_ENC = new byte[]{0, 0, 0, 1};
    protected byte[] c_MAC = new byte[]{0, 0, 0, 2};
    protected byte[] bacKeyENC_a = new byte[8];
    protected byte[] bacKeyENC_b = new byte[8];
    protected byte[] bacKeyENC = new byte[24];
    protected byte[] bacKeyMAC_a = new byte[8];
    protected byte[] bacKeyMAC_b = new byte[8];
    protected byte[] bacKeyMAC = new byte[24];
    protected byte[] SSC = new byte[8];

    public CommandsV14(ICommandTransmitter transmitter, Version vers) {
        super(transmitter, vers);
        this.phaseBytePosition = 8;
        this.fileAccessRules = new FileAccessRules(48, 48, 48, 0);
        this.fileTypes = new FileTypes(1, 1, 1, 1);
        this.putDataParam.flag1 = new P1P2(1, 1);
        this.putDataParam.flag2 = new P1P2(1, 2);
        this.putDataParam.flag3 = new P1P2(1, 6);
        this.putDataParam.configuration1 = new P1P2(1, 4);
        this.putDataParam.configuration2 = new P1P2(1, 5);
        this.putDataParam.bacErrorInfo = new P1P2(1, 7);
        this.putDataParam.cardTag = new P1P2(1, 3);
        this.putDataParam.AtsPrivateSpaceInfo = new P1P2(1, 9);
        this.putDataParam.userInfo = new P1P2(1, 8);
        GetDataModes.atr = (byte)12;
    }

    @Override
    public void createBinaryEFbyFID(byte[] FID, FileTypes.FileType type, FileAccessRules.FileAccessRule access) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] createEf = new byte[]{0, -32, 0, 0, 12, 98, 10, -126, 1, 1, -125, 2, FID[0], FID[1], -122, 1, 48};
        this.sendCommand(createEf);
    }

    @Override
    public void createBinaryEFbySFI(byte[] FID, byte SFI, FileTypes.FileType type, FileAccessRules.FileAccessRule access) throws AkisSWException, AkisCardException, AkisCIFException {
        byte commandSFI = (byte)(SFI << 3);
        byte[] createEf = new byte[]{0, -32, 0, 0, 12, 98, 10, -126, 1, 1, -125, 2, FID[0], FID[1], -122, 1, 48, -120, 1, commandSFI};
        this.sendCommand(createEf);
    }

    @Override
    public void createDFbyFID(byte[] FID, FileTypes.FileType type, FileAccessRules.FileAccessRule access) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] createDf = new byte[]{0, -32, 0, 0, 12, 98, 10, -126, 1, 56, -125, 2, FID[0], FID[1], -122, 1, 48};
        this.sendCommand(createDf);
    }

    @Override
    public void createDFbyName(byte[] FID, byte[] name, FileTypes.FileType type, FileAccessRules.FileAccessRule access) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] AIDTag = new byte[name.length + 2];
        AIDTag[0] = -124;
        AIDTag[1] = (byte)name.length;
        System.arraycopy(name, 0, AIDTag, 2, name.length);
        byte[] commandHeader = new byte[]{0, -32, 0, 0, 0, 98, 0};
        byte[] FCP_part1 = new byte[]{-126, 1, 56, -125, 2, FID[0], FID[1]};
        byte[] FCP_part3 = new byte[]{-122, 1, 48};
        int FCPDataLen = FCP_part1.length + AIDTag.length + FCP_part3.length;
        commandHeader[4] = (byte)(FCPDataLen + 2);
        commandHeader[6] = (byte)FCPDataLen;
        byte[] createDf = new byte[commandHeader.length + FCPDataLen];
        int index = 0;
        System.arraycopy(commandHeader, 0, createDf, index, commandHeader.length);
        System.arraycopy(FCP_part1, 0, createDf, index += commandHeader.length, FCP_part1.length);
        System.arraycopy(AIDTag, 0, createDf, index += FCP_part1.length, AIDTag.length);
        System.arraycopy(FCP_part3, 0, createDf, index += AIDTag.length, FCP_part3.length);
        this.sendCommand(createDf);
    }

    @Override
    public void deleteCurrent() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] eraseCommand = new byte[]{0, -28, 0, 0};
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByFIDUnderMF(byte[] FID, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        this.deleteByFIDUnderDF(FID, level);
    }

    @Override
    public void deleteByFIDUnderDF(byte[] FID, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte p1 = (byte)(level == FileLevel.DF ? 1 : 2);
        byte[] eraseCommand = new byte[]{0, -28, p1, 0, 2, FID[0], FID[1]};
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteDFByName(byte[] name) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] eraseCommandHeader = new byte[]{0, -28, 4, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + name.length];
        eraseCommandHeader[4] = (byte)name.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(name, 0, eraseCommand, eraseCommandHeader.length, name.length);
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByFIDPathFromMF(byte[] path, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] eraseCommandHeader = new byte[]{0, -28, 8, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + path.length];
        eraseCommandHeader[4] = (byte)path.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(path, 0, eraseCommand, eraseCommandHeader.length, path.length);
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByFIDPathFromDF(byte[] path, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] eraseCommandHeader = new byte[]{0, -28, 9, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + path.length];
        eraseCommandHeader[4] = (byte)path.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(path, 0, eraseCommand, eraseCommandHeader.length, path.length);
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByNamePathFromMF(byte[] path, FileLevel level) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void deleteByNamePathFromDF(byte[] path, FileLevel level) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void deleteParentDF() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] eraseCommand = new byte[]{0, -28, 3, 0};
        this.sendCommand(eraseCommand);
    }

    @Override
    public void closeEF() {
        throw new UnsupportedVersionException();
    }

    @Override
    public FCI selectMF() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 0, 0, 0};
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectFileUnderMF(byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 0, 0, 2, 0, 0, 0};
        selectFileCommand[5] = FID[0];
        selectFileCommand[6] = FID[1];
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectChildDF(byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 1, 0, 2, 0, 0, 0};
        selectFileCommand[5] = FID[0];
        selectFileCommand[6] = FID[1];
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectEFUnderDF(byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 2, 0, 2, 0, 0, 0};
        selectFileCommand[5] = FID[0];
        selectFileCommand[6] = FID[1];
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectParentDF() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 3, 0, 0};
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectDFByName(byte[] name) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{0, -92, 4, 0, 0};
        byte[] selectFileCommand = null;
        commandBytes[4] = (byte)name.length;
        selectFileCommand = new byte[name.length + 6];
        int index = 0;
        System.arraycopy(commandBytes, 0, selectFileCommand, index, commandBytes.length);
        System.arraycopy(name, 0, selectFileCommand, index += commandBytes.length, name.length);
        selectFileCommand[index += name.length] = 0;
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectFromMFByPath(byte[] path) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{0, -92, 8, 0, 0};
        byte[] selectFileCommand = null;
        commandBytes[4] = (byte)path.length;
        selectFileCommand = new byte[path.length + 6];
        int index = 0;
        System.arraycopy(commandBytes, 0, selectFileCommand, index, commandBytes.length);
        System.arraycopy(path, 0, selectFileCommand, index += commandBytes.length, path.length);
        selectFileCommand[index += path.length] = 0;
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectFromDFByPath(byte[] path) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{0, -92, 9, 0, 0};
        byte[] selectFileCommand = null;
        commandBytes[4] = (byte)path.length;
        selectFileCommand = new byte[path.length + 6];
        int index = 0;
        System.arraycopy(commandBytes, 0, selectFileCommand, index, commandBytes.length);
        System.arraycopy(path, 0, selectFileCommand, index += commandBytes.length, path.length);
        selectFileCommand[index += path.length] = 0;
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public byte[] readFileBySelectingUnderActiveDF(byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] data = null;
        int fileLength = this.selectEFUnderDF(FID).getFileLength();
        if (fileLength > 0) {
            data = new byte[fileLength];
            int unReadDataLength = fileLength;
            int index = 0;
            while (unReadDataLength > 0) {
                byte MSB = (byte)((index & 0xFF00) >> 8);
                byte LSB = (byte)(index & 0xFF);
                byte[] readFileCommand = new byte[]{0, -80, MSB, LSB, 0};
                ResponseAPDU response = this.sendCommand(readFileCommand);
                int readDataLength = response.getData().length;
                byte[] responseData = response.getData();
                System.arraycopy(responseData, 0, data, index, readDataLength);
                unReadDataLength -= readDataLength;
                index += readDataLength;
            }
        }
        return data;
    }

    @Override
    public void updateBinaryFile(byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        int dataLenInCommand;
        int index = 0;
        for (int unWritenDataLength = data.length; unWritenDataLength > 0; unWritenDataLength -= dataLenInCommand) {
            byte MSB = (byte)((index & 0xFF00) >> 8);
            byte LSB = (byte)(index & 0xFF);
            byte[] updateBinaryTemplate = new byte[]{0, -42, MSB, LSB, 0};
            dataLenInCommand = 0;
            dataLenInCommand = unWritenDataLength > 196 ? 196 : unWritenDataLength;
            updateBinaryTemplate[4] = (byte)dataLenInCommand;
            byte[] updateBinaryCommand = new byte[updateBinaryTemplate.length + dataLenInCommand];
            System.arraycopy(updateBinaryTemplate, 0, updateBinaryCommand, 0, updateBinaryTemplate.length);
            System.arraycopy(data, index, updateBinaryCommand, updateBinaryTemplate.length, dataLenInCommand);
            this.sendCommand(updateBinaryCommand);
            index += dataLenInCommand;
        }
    }

    @Override
    public int getPinRemainingUsageCount() throws AkisSWException, AkisCardException, AkisCIFException {
        ResponseAPDU response;
        block2: {
            byte[] remainedPinCountCommand = new byte[]{0, 32, 0, -127, 0};
            response = null;
            try {
                response = this.mCardChannel.transmit(new CommandAPDU(remainedPinCountCommand));
            }
            catch (Exception e2) {
                if (e2.getMessage().contains("63c")) break block2;
                throw new RuntimeException();
            }
        }
        return response.getBytes()[1] & 0xF;
    }

    @Override
    public AkisKey[] getKeyInfos() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] readKeysCommand = new byte[]{-128, 31, 0, 0, 0};
        byte[] data = this.sendCommand(readKeysCommand).getData();
        int keyCount = data[2];
        int startIndex = 5;
        AkisKey[] keys = new AkisKey[keyCount];
        for (int i2 = 0; i2 < keyCount; ++i2) {
            byte keyID = data[startIndex + 4 * i2];
            byte durumBilgisi = data[startIndex + 2 + 4 * i2];
            KeyType type = null;
            type = (durumBilgisi & 0x1F) == 31 ? KeyType.PRIVATE_RSA : ((durumBilgisi & 0x60) == 96 ? KeyType.PUBLIC_RSA : KeyType.UNKNOWN);
            keys[i2] = new AkisKey(keyID, type);
        }
        return keys;
    }

    @Override
    public byte[] getPublicExponent(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] gpe = new byte[]{-128, 31, 64, keyID, 0};
        return this.sendCommand(gpe).getData();
    }

    @Override
    public byte[] getModulus(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] gme = new byte[]{-128, 31, 32, keyID, 0};
        return this.sendCommand(gme).getData();
    }

    @Override
    public int getMaxKeyID() throws AkisCardException, AkisCIFException {
        ResponseAPDU response;
        byte max;
        block3: {
            byte[] readKeysCommand = new byte[]{-128, 31, 0, 0, 0};
            max = 0;
            response = null;
            try {
                response = this.sendCommand(readKeysCommand);
            }
            catch (AkisSWException e2) {
                if (e2.getErrorCode() != 25625L) break block3;
                return 0;
            }
        }
        byte[] keyAttr = response.getData();
        for (int i2 = 0; i2 < keyAttr[2]; ++i2) {
            max = keyAttr[i2 * 4 + 5] > max ? keyAttr[i2 * 4 + 5] : max;
        }
        return max;
    }

    @Override
    public void writePrivateKey(RSAKeyFields fields, int keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] oneField = new byte[fields.prime_1.length + 2];
        oneField[0] = -47;
        oneField[1] = (byte)fields.prime_1.length;
        System.arraycopy(fields.prime_1, 0, oneField, 2, fields.prime_1.length);
        this.writeKey(oneField, this.deletableKeyType, keyID);
        oneField = new byte[fields.prime_2.length + 2];
        oneField[0] = -46;
        oneField[1] = (byte)fields.prime_2.length;
        System.arraycopy(fields.prime_2, 0, oneField, 2, fields.prime_2.length);
        this.writeKey(oneField, this.deletableKeyType, keyID);
        oneField = new byte[fields.exponent_1.length + 2];
        oneField[0] = -45;
        oneField[1] = (byte)fields.exponent_1.length;
        System.arraycopy(fields.exponent_1, 0, oneField, 2, fields.exponent_1.length);
        this.writeKey(oneField, this.deletableKeyType, keyID);
        oneField = new byte[fields.exponent_2.length + 2];
        oneField[0] = -44;
        oneField[1] = (byte)fields.exponent_2.length;
        System.arraycopy(fields.exponent_2, 0, oneField, 2, fields.exponent_2.length);
        this.writeKey(oneField, this.deletableKeyType, keyID);
        oneField = new byte[fields.coefficient.length + 2];
        oneField[0] = -43;
        oneField[1] = (byte)fields.coefficient.length;
        System.arraycopy(fields.coefficient, 0, oneField, 2, fields.coefficient.length);
        this.writeKey(oneField, this.deletableKeyType, keyID);
    }

    @Override
    public void writePublicKey(RSAKeyFields fields, int keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] oneField = new byte[fields.public_Exponent.length + 2];
        oneField[0] = -42;
        oneField[1] = (byte)(fields.public_Exponent.length == 256 ? 0 : fields.public_Exponent.length);
        System.arraycopy(fields.public_Exponent, 0, oneField, 2, fields.public_Exponent.length);
        this.writeKey(oneField, this.deletableKeyType, keyID);
        oneField = new byte[fields.modBytes.length + 2];
        oneField[0] = -41;
        oneField[1] = (byte)(fields.modBytes.length == 256 ? 0 : fields.modBytes.length);
        System.arraycopy(fields.modBytes, 0, oneField, 2, fields.modBytes.length);
        this.writeKey(oneField, this.deletableKeyType, keyID);
    }

    protected void writeKey(byte[] data, byte isUnDeletable, int keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] wk1 = new byte[]{-128, 30, (byte)(keyID | 0x80), isUnDeletable};
        if (data.length > 230) {
            int remaining = data.length;
            int offset = 0;
            do {
                int dataPartLen = remaining > 230 ? 230 : remaining;
                byte[] wk = new byte[wk1.length + 1 + dataPartLen];
                System.arraycopy(wk1, 0, wk, 0, wk1.length);
                wk[wk1.length] = (byte)dataPartLen;
                System.arraycopy(data, offset, wk, wk1.length + 1, dataPartLen);
                if (remaining > 230) {
                    wk[0] = (byte)(wk[0] | 0x10);
                }
                this.sendCommand(wk);
                offset += dataPartLen;
            } while ((remaining -= 230) > 0);
        } else {
            byte[] wk = new byte[wk1.length + 1 + data.length];
            wk[wk1.length] = (byte)data.length;
            System.arraycopy(wk1, 0, wk, 0, wk1.length);
            System.arraycopy(data, 0, wk, wk1.length + 1, data.length);
            this.sendCommand(wk);
        }
    }

    @Override
    public void writeBACKey(byte[] key, byte passportKeyProp, byte passportKeyId) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] des3data = new byte[key.length + 4];
        des3data[0] = -79;
        des3data[1] = 8;
        des3data[10] = -77;
        des3data[11] = 8;
        System.arraycopy(key, 0, des3data, 2, key.length / 2);
        System.arraycopy(key, key.length / 2, des3data, 12, key.length / 2);
        byte[] wk1 = new byte[]{-128, 30, (byte)(passportKeyId | 0x80), passportKeyProp};
        byte[] wk = new byte[wk1.length + 1 + des3data.length];
        wk[wk1.length] = (byte)des3data.length;
        System.arraycopy(wk1, 0, wk, 0, wk1.length);
        System.arraycopy(des3data, 0, wk, wk1.length + 1, des3data.length);
        this.sendCommand(wk);
    }

    @Override
    public void deleteKey(int keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] deleteKey = new byte[]{-128, 30, (byte)keyID, 0};
        this.sendCommand(deleteKey);
    }

    @Override
    public void putData(P1P2 params, byte[] data) throws AkisCIFException, AkisSWException, AkisCardException {
        if (params == null || data.length == 0) {
            throw new AkisCIFException("Invalid input parameter");
        }
        byte[] putData = new byte[5 + data.length];
        byte[] putDataPart1 = new byte[]{0, -38, params.getp1(), params.getp2()};
        System.arraycopy(putDataPart1, 0, putData, 0, putDataPart1.length);
        putData[4] = Byte.parseByte(Integer.toString(data.length));
        System.arraycopy(data, 0, putData, 5, 1);
        for (int i2 = 0; i2 < data.length; ++i2) {
            putData[5 + i2] = data[i2];
        }
        this.sendCommand(putData);
    }

    @Override
    public byte[] getData(byte mode) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] getDataCommand = new byte[]{0, -54, 1, 0, 0};
        int Le = 0;
        if (mode == GetDataModes.copyright) {
            Le = 23;
        } else if (mode == GetDataModes.chip) {
            Le = 2;
        } else if (mode == GetDataModes.atr) {
            Le = 18;
        } else if (mode == GetDataModes.memory) {
            Le = 11;
        } else if (mode == GetDataModes.cardType) {
            Le = 1;
        } else if (mode == GetDataModes.system) {
            Le = 81;
        } else if (mode == GetDataModes.romCheckSum) {
            Le = 2;
        }
        getDataCommand[3] = mode;
        getDataCommand[getDataCommand.length - 1] = Le;
        ResponseAPDU response = this.sendCommand(getDataCommand);
        return response.getData();
    }

    @Override
    public byte[] getSerial() throws AkisCardException, AkisSWException, AkisCIFException {
        byte[] serial;
        try {
            serial = this.getSerialByKartTest();
        }
        catch (AkisCIFException ex) {
            serial = this.getSerialGetDataForActivation();
        }
        catch (AkisSWException ex) {
            serial = this.getSerialGetDataForActivation();
        }
        return serial;
    }

    @Override
    protected byte[] getSerialGetData() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] getDatabytes = this.getData(GetDataModes.system);
        byte[] serial = new byte[8];
        if (getDatabytes.length < 69) {
            throw new AkisCIFException("Serial number can not be read. Get Data command returned insufficient length data.");
        }
        System.arraycopy(getDatabytes, 57, serial, 0, 8);
        return serial;
    }

    @Override
    protected byte[] getSerialGetDataForActivation() throws AkisSWException, AkisCardException, AkisCIFException {
        return this.getSerialGetData();
    }

    @Override
    public int getEmptyMemory() throws AkisSWException, AkisCardException, AkisCIFException {
        int emptyMemory = 0;
        byte[] cardSystemInfo = this.getData(GetDataModes.system);
        emptyMemory = 0xFF & cardSystemInfo[76];
        emptyMemory <<= 8;
        emptyMemory += 0xFF & cardSystemInfo[77];
        emptyMemory <<= 8;
        return emptyMemory += 0xFF & cardSystemInfo[78];
    }

    @Override
    public void activate(byte[] data, ActivationType type) throws AkisSWException, AkisCardException, AkisCIFException {
        this.activate(data);
    }

    @Override
    public void activate(byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandTemplate = new byte[]{-128, -122, 2, 2};
        if (data.length > 248) {
            int remaining = data.length;
            int offset = 0;
            do {
                int dataPartLen = remaining > 248 ? 248 : remaining;
                byte[] command = new byte[commandTemplate.length + 1 + dataPartLen];
                System.arraycopy(commandTemplate, 0, command, 0, commandTemplate.length);
                command[commandTemplate.length] = (byte)dataPartLen;
                System.arraycopy(data, offset, command, commandTemplate.length + 1, dataPartLen);
                if (remaining > 248) {
                    command[0] = (byte)(command[0] | 0x10);
                }
                ResponseAPDU response = this.sendCommand(command);
                offset += dataPartLen;
            } while ((remaining -= 248) > 0);
        } else {
            byte[] command = new byte[commandTemplate.length + 1 + data.length];
            command[commandTemplate.length] = (byte)data.length;
            System.arraycopy(commandTemplate, 0, command, 0, commandTemplate.length);
            System.arraycopy(data, 0, command, commandTemplate.length + 1, data.length);
            ResponseAPDU response = this.sendCommand(command);
        }
    }

    @Override
    public int getPersoKeyLength() {
        return 16;
    }

    @Override
    public void verifyInit(byte[] initKey) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] verifyInit = new byte[21];
        byte[] verifyInit_part1 = new byte[]{-128, 2, -1, -1, 16};
        System.arraycopy(verifyInit_part1, 0, verifyInit, 0, verifyInit_part1.length);
        System.arraycopy(initKey, 0, verifyInit, verifyInit_part1.length, 16);
        this.sendCommand(verifyInit);
    }

    @Override
    public void verifyPerso(byte[] persoKey) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] verifyPerso = new byte[21];
        byte[] verifyPerso_part1 = new byte[]{-128, 8, -1, -1, 16};
        System.arraycopy(verifyPerso_part1, 0, verifyPerso, 0, verifyPerso_part1.length);
        System.arraycopy(persoKey, 0, verifyPerso, verifyPerso_part1.length, 16);
        this.sendCommand(verifyPerso);
    }

    @Override
    protected byte[] exchangeChallenge(byte[] encryptedRandomNumber) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] command = new byte[encryptedRandomNumber.length + 6];
        command[0] = -128;
        command[1] = -122;
        command[2] = 0;
        command[3] = 0;
        command[4] = -128;
        command[133] = 16;
        System.arraycopy(encryptedRandomNumber, 0, command, 5, encryptedRandomNumber.length);
        ResponseAPDU response = this.sendCommand(command);
        return response.getData();
    }

    @Override
    public void externalAuthenticatePure(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, byte[] data) {
        throw new UnsupportedVersionException();
    }

    @Override
    public byte[] generateMseData(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, AuthenticationType authType) {
        throw new UnsupportedVersionException();
    }

    @Override
    public byte[] getChallenge(int len) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] getCh = new byte[]{0, -124, 0, 0, 8};
        byte[] data = this.sendCommand(getCh).getData();
        return data;
    }

    @Override
    public void verify(byte[] pin, boolean isMF) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verify(byte pinNo, byte[] pin, boolean isMF) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verifyWithPinPad(byte pinNo, boolean isMF) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void unlockDFPIN(byte[] fid, byte[] PUK, byte[] newPIN) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void unlockMFPIN(byte[] PUK, byte[] newPIN) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void changeDFPIN(byte[] fid, byte[] oldPIN, byte[] newPIN) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void changeDFPUK(byte[] fid, byte[] oldPIN, byte[] newPIN) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void changeMFPIN(byte[] oldPIN, byte[] newPIN) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void changeMFPUK(byte[] mfPIN, byte[] oldPIN, byte[] newPIN) {
        throw new UnsupportedVersionException();
    }

    public byte[] mutualAuthenticate(byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] mauth1 = new byte[]{0, -126, 0, 0, 40};
        byte[] mauth = new byte[46];
        mauth[45] = 40;
        System.arraycopy(mauth1, 0, mauth, 0, 5);
        System.arraycopy(data, 0, mauth, 5, data.length);
        return this.sendCommand(mauth).getData();
    }

    @Override
    public void mse(byte keyID) {
        throw new UnsupportedVersionException();
    }

    @Override
    public byte[] pso(P1P2 psoMode, byte[] data) {
        throw new UnsupportedVersionException();
    }

    @Override
    public byte[] sign(byte[] data, byte keyID) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void activateSecureMsging(String documentNumber, String dateOfBirth, String expireDate) throws AkisSWException, AkisCardException, AkisCIFException {
        this.decideSecureMessageKeyGeneratingKey();
        this.generateSecureMessagingKey(documentNumber, dateOfBirth, expireDate);
        this.isSecureMessagingActive = true;
    }

    @Override
    protected void decideSecureMessageKeyGeneratingKey() {
    }

    @Override
    protected void generateSecureMessagingKey() {
        throw new UnsupportedVersionException();
    }

    @Override
    protected void generateSecureMessagingKey(String documentNumber, String dateOfBirth, String expireDate) throws AkisSWException, AkisCardException, AkisCIFException {
        String docNum = "AA000106<";
        String dob = "740630";
        String doe = "220207";
        this.selectMF();
        this.selectDFByName(icaoAID);
        byte[] kSeed = this.calculateKSeed(documentNumber, dateOfBirth, expireDate);
        this.generateBACKeys(kSeed);
        byte[] RND_ICC = this.getChallenge(8);
        byte[] RND_IFD = new byte[8];
        Random r2 = new Random();
        r2.nextBytes(RND_IFD);
        byte[] K_IFD = new byte[16];
        r2.nextBytes(K_IFD);
        byte[] S = new byte[32];
        System.arraycopy(RND_IFD, 0, S, 0, 8);
        System.arraycopy(RND_ICC, 0, S, 8, 8);
        System.arraycopy(K_IFD, 0, S, 16, 16);
        byte[] E_IFD = Crypto.triDesCBC(this.bacKeyENC, S, true);
        byte[] M_IFD = Crypto.retailMacDes(E_IFD, this.bacKeyMAC);
        byte[] mutualAuthData = new byte[40];
        System.arraycopy(E_IFD, 0, mutualAuthData, 0, 32);
        System.arraycopy(M_IFD, 0, mutualAuthData, 32, 8);
        byte[] cardReturn = this.mutualAuthenticate(mutualAuthData);
        byte[] E_ICC = new byte[32];
        byte[] M_ICC = new byte[8];
        System.arraycopy(cardReturn, 0, E_ICC, 0, 32);
        System.arraycopy(cardReturn, 32, M_ICC, 0, 8);
        byte[] R = Crypto.triDesCBC(this.bacKeyENC, E_ICC, false);
        byte[] K_ICC = new byte[16];
        System.arraycopy(R, 16, K_ICC, 0, 16);
        byte[] M_ICC_Expected = Crypto.retailMacDes(E_ICC, this.bacKeyMAC);
        for (int i2 = 0; i2 < 8; ++i2) {
            if (M_ICC_Expected[i2] == M_ICC[i2]) continue;
            throw new AkisCIFException("Hash in Mutual Authentication return data is not correct");
        }
        byte[] K_SEED = Conversions.xor(K_IFD, K_ICC);
        this.generateBACKeys(K_SEED);
        System.arraycopy(this.bacKeyENC, 0, this.secureMessagingKey_ABA, 0, 16);
        System.arraycopy(this.bacKeyENC_a, 0, this.secureMessagingKey_ABA, 16, 8);
        System.arraycopy(RND_ICC, 4, this.SSC, 0, 4);
        System.arraycopy(RND_IFD, 4, this.SSC, 4, 4);
    }

    @Override
    protected byte[] createDecryptedCommand(byte[] response) throws AkisCIFException {
        int responseLen = response.length;
        byte[] SW = new byte[2];
        byte[] CC = new byte[8];
        byte[] openData = null;
        int dataBlock99Len = 4;
        int dataBlock8ELen = 10;
        int dataBlock87Len = 0;
        int encryptedDataIndex = 0;
        int indexSW = 2;
        int indexCC = 6;
        if (responseLen > 16 && response[0] == -121) {
            dataBlock87Len = (response[1] & 0xFF) + 2;
            if (response[1] == -126) {
                dataBlock87Len = (response[2] & 0xFF) * 256 + (response[2] & 0xFF) + 3;
                encryptedDataIndex = 5;
            }
            if (response[1] == -127) {
                dataBlock87Len = (response[2] & 0xFF) + 3;
                encryptedDataIndex = 4;
            } else {
                dataBlock87Len = (response[1] & 0xFF) + 2;
                encryptedDataIndex = 3;
            }
            indexSW += dataBlock87Len;
            indexCC += dataBlock87Len;
            byte[] toBeDecryptedData = new byte[dataBlock87Len - encryptedDataIndex];
            System.arraycopy(response, encryptedDataIndex, toBeDecryptedData, 0, dataBlock87Len - encryptedDataIndex);
            openData = Crypto.triDesCBC(this.secureMessagingKey_ABA, toBeDecryptedData, false);
        }
        if (response[indexSW - 2] != -103) {
            throw new AkisCIFException("Status Word is not found.");
        }
        System.arraycopy(response, indexSW, SW, 0, 2);
        if (response[indexCC - 2] != -114) {
            throw new AkisCIFException("Checksum datablock is not found.");
        }
        System.arraycopy(response, indexCC, CC, 0, 8);
        this.incrementSSC();
        byte[] toBeCC = new byte[8 + response.length - 12];
        byte[] repsonsewithoutCC = new byte[response.length - 12];
        System.arraycopy(response, 0, repsonsewithoutCC, 0, response.length - 12);
        System.arraycopy(this.SSC, 0, toBeCC, 0, 8);
        System.arraycopy(repsonsewithoutCC, 0, toBeCC, 8, repsonsewithoutCC.length);
        byte[] CC_Expected = Crypto.retailMacDes(toBeCC, this.bacKeyMAC);
        for (int i2 = 0; i2 < 8; ++i2) {
            if (CC_Expected[i2] == CC[i2]) continue;
            throw new AkisCIFException("Checksum is not valid.");
        }
        byte[] openResponse = null;
        if (openData != null) {
            openResponse = new byte[openData.length + 2];
            System.arraycopy(openData, 0, openResponse, 0, openData.length);
            System.arraycopy(SW, 0, openResponse, openData.length, 2);
        } else {
            openResponse = new byte[2];
            System.arraycopy(SW, 0, openResponse, 0, 2);
        }
        return openResponse;
    }

    @Override
    protected byte[] createEncryptedCommand(byte[] command) throws AkisCIFException {
        int dataLen;
        int plainCommandLen = command.length;
        int dataBlock87Len = 0;
        int dataBlock97Len = 0;
        int dataBlock8ELen = 10;
        byte[] dataBlock87 = null;
        byte[] dataBlock97 = null;
        if (plainCommandLen > 5) {
            dataLen = command[4] & 0xFF;
            dataBlock87Len = 8 - dataLen % 8 + dataLen + 3;
        }
        if (plainCommandLen > 5) {
            dataLen = command[4] & 0xFF;
            dataBlock87Len = dataLen >= 256 ? 8 - dataLen % 8 + dataLen + 5 : (dataLen >= 128 ? 8 - dataLen % 8 + dataLen + 4 : 8 - dataLen % 8 + dataLen + 3);
        }
        if (plainCommandLen >= 5 && (plainCommandLen == 5 || plainCommandLen == (command[4] & 0xFF) + 6)) {
            dataBlock97Len = 3;
        }
        int arrayIndex = 0;
        byte[] createdCommand = new byte[5 + dataBlock87Len + dataBlock97Len + dataBlock8ELen + 1];
        createdCommand[arrayIndex++] = 12;
        System.arraycopy(command, 1, createdCommand, arrayIndex, 3);
        arrayIndex += 3;
        createdCommand[arrayIndex++] = 0;
        if (dataBlock87Len > 0) {
            dataBlock87 = this.createDataBlock87(command);
            System.arraycopy(dataBlock87, 0, createdCommand, arrayIndex, dataBlock87Len);
            arrayIndex += dataBlock87Len;
        }
        if (dataBlock97Len > 0) {
            dataBlock97 = this.createDataBlock97(command);
            System.arraycopy(dataBlock97, 0, createdCommand, arrayIndex, dataBlock97Len);
            arrayIndex += dataBlock97Len;
        }
        this.incrementSSC();
        byte[] header = new byte[4];
        System.arraycopy(createdCommand, 0, header, 0, 4);
        byte[] paddedHeader = Crypto.padData(header, 8);
        if (dataBlock8ELen > 0) {
            byte[] dataBlock8E = this.createDataBlock8E(paddedHeader, dataBlock87, dataBlock97);
            System.arraycopy(dataBlock8E, 0, createdCommand, arrayIndex, dataBlock8ELen);
            arrayIndex += dataBlock8ELen;
        }
        int lc = dataBlock87Len + dataBlock97Len + dataBlock8ELen;
        createdCommand[4] = (byte)lc;
        createdCommand[createdCommand.length - 1] = 0;
        return createdCommand;
    }

    protected byte[] createDataBlock87(byte[] command) throws AkisCIFException {
        byte[] data = new byte[command[4] & 0xFF];
        System.arraycopy(command, 5, data, 0, data.length);
        byte[] paddeddata = Crypto.padData(data, 8);
        byte[] tDesData = Crypto.triDesCBC(this.secureMessagingKey_ABA, paddeddata, true);
        int dataIndex = 0;
        int dataLen = tDesData.length;
        dataIndex = dataLen >= 256 ? 5 : (dataLen >= 128 ? 4 : 3);
        byte[] DOB87 = new byte[tDesData.length + dataIndex];
        System.arraycopy(tDesData, 0, DOB87, dataIndex, tDesData.length);
        DOB87[0] = -121;
        byte[] berLen = Conversions.GetBerLen(dataLen + 1);
        int berLenCount = berLen.length;
        System.arraycopy(berLen, 0, DOB87, 1, berLenCount);
        DOB87[berLenCount + 1] = 1;
        return DOB87;
    }

    protected byte[] createDataBlock97(byte[] command) {
        byte Le = command[command.length - 1];
        byte[] DOB97 = new byte[]{-105, 1, Le};
        return DOB97;
    }

    protected byte[] createDataBlock8E(byte[] paddedHeader, byte[] DOB87, byte[] DOB97) throws AkisCIFException {
        int inputLen = paddedHeader.length;
        if (DOB87 != null) {
            inputLen += DOB87.length;
        }
        if (DOB97 != null) {
            inputLen += DOB97.length;
        }
        byte[] checkSumInput = new byte[inputLen];
        int arrayIndex = 0;
        System.arraycopy(paddedHeader, 0, checkSumInput, arrayIndex, paddedHeader.length);
        arrayIndex += paddedHeader.length;
        if (DOB87 != null) {
            System.arraycopy(DOB87, 0, checkSumInput, arrayIndex, DOB87.length);
            arrayIndex += DOB87.length;
        }
        if (DOB97 != null) {
            System.arraycopy(DOB97, 0, checkSumInput, arrayIndex, DOB97.length);
            arrayIndex += DOB97.length;
        }
        byte[] datawithSSC = new byte[checkSumInput.length + this.SSC.length];
        System.arraycopy(this.SSC, 0, datawithSSC, 0, this.SSC.length);
        System.arraycopy(checkSumInput, 0, datawithSSC, this.SSC.length, checkSumInput.length);
        byte[] mac = Crypto.retailMacDes(datawithSSC, this.bacKeyMAC);
        byte[] block8E = new byte[mac.length + 2];
        block8E[0] = -114;
        block8E[1] = (byte)mac.length;
        System.arraycopy(mac, 0, block8E, 2, mac.length);
        return block8E;
    }

    protected String computeCheckDigit(String data) {
        int[] mul = new int[]{7, 3, 1};
        int counter = 0;
        int sum = 0;
        int temp = 0;
        for (int i2 = 0; i2 < data.length(); ++i2) {
            char c2 = data.charAt(i2);
            temp = c2 >= '0' && c2 <= '9' ? c2 - 48 : (c2 >= 'A' && c2 <= 'Z' ? c2 - 65 + 10 : 0);
            sum += temp * mul[counter];
            if (++counter < mul.length) continue;
            counter = 0;
        }
        return String.valueOf(sum %= 10);
    }

    protected byte[] adjustParityBitsofBACKeys(byte[] key) {
        byte[] adjustedKey = new byte[key.length];
        for (int i2 = 0; i2 < key.length; ++i2) {
            boolean[] bitArray = Conversions.byteTobitArray(key[i2]);
            boolean even = true;
            for (int m2 = 0; m2 < 8; ++m2) {
                if (!(bitArray[m2] | false)) continue;
                even = !even;
            }
            if (even) {
                bitArray[0] = !bitArray[0];
            }
            adjustedKey[i2] = Conversions.bitArraytoByte(bitArray);
        }
        return adjustedKey;
    }

    protected byte[] calculateKSeed(String documentNumber, String dob, String doe) {
        byte[] seed = new byte[16];
        String MRZ_Information = "";
        MRZ_Information = MRZ_Information.concat(documentNumber);
        while (MRZ_Information.length() < 9) {
            MRZ_Information = MRZ_Information.concat("<");
        }
        MRZ_Information = MRZ_Information.concat(this.computeCheckDigit(documentNumber));
        MRZ_Information = MRZ_Information.concat(dob);
        MRZ_Information = MRZ_Information.concat(this.computeCheckDigit(dob));
        MRZ_Information = MRZ_Information.concat(doe);
        MRZ_Information = MRZ_Information.concat(this.computeCheckDigit(doe));
        byte[] mrz_info = Conversions.asciiStringtoHexArray(MRZ_Information);
        byte[] seed_notyet = Crypto.computeHashValue(mrz_info, "SHA-1");
        System.arraycopy(seed_notyet, 0, seed, 0, 16);
        return seed;
    }

    protected void generateBACKeys(byte[] kSeed) {
        byte[] D_ENC = new byte[kSeed.length + 4];
        byte[] D_MAC = new byte[kSeed.length + 4];
        System.arraycopy(kSeed, 0, D_ENC, 0, kSeed.length);
        System.arraycopy(this.c_ENC, 0, D_ENC, kSeed.length, this.c_ENC.length);
        System.arraycopy(kSeed, 0, D_MAC, 0, kSeed.length);
        System.arraycopy(this.c_MAC, 0, D_MAC, kSeed.length, this.c_MAC.length);
        byte[] hash_D_ENC = Crypto.computeHashValue(D_ENC, "SHA-1");
        System.arraycopy(hash_D_ENC, 0, this.bacKeyENC_a, 0, 8);
        System.arraycopy(hash_D_ENC, 8, this.bacKeyENC_b, 0, 8);
        byte[] hash_D_MAC = Crypto.computeHashValue(D_MAC, "SHA-1");
        System.arraycopy(hash_D_MAC, 0, this.bacKeyMAC_a, 0, 8);
        System.arraycopy(hash_D_MAC, 8, this.bacKeyMAC_b, 0, 8);
        this.bacKeyENC_a = this.adjustParityBitsofBACKeys(this.bacKeyENC_a);
        this.bacKeyENC_b = this.adjustParityBitsofBACKeys(this.bacKeyENC_b);
        this.bacKeyMAC_a = this.adjustParityBitsofBACKeys(this.bacKeyMAC_a);
        this.bacKeyMAC_b = this.adjustParityBitsofBACKeys(this.bacKeyMAC_b);
        System.arraycopy(this.bacKeyENC_a, 0, this.bacKeyENC, 0, 8);
        System.arraycopy(this.bacKeyENC_b, 0, this.bacKeyENC, 8, 8);
        System.arraycopy(this.bacKeyENC_a, 0, this.bacKeyENC, 16, 8);
        System.arraycopy(this.bacKeyMAC_a, 0, this.bacKeyMAC, 0, 8);
        System.arraycopy(this.bacKeyMAC_b, 0, this.bacKeyMAC, 8, 8);
        System.arraycopy(this.bacKeyMAC_a, 0, this.bacKeyMAC, 16, 8);
    }

    protected void incrementSSC() {
        int index;
        for (index = this.SSC.length - 1; index >= 0; --index) {
            if (this.SSC[index] == -1) continue;
            this.SSC[index] = (byte)(this.SSC[index] + 1);
            break;
        }
        if (index < 0) {
            index = this.SSC.length - 1;
            while (index >= 0) {
                this.SSC[index--] = 0;
            }
        }
    }
}

