/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.dataStructures;

import tubitak.akis.cif.akisExceptions.AkisRuntimeException;
import tubitak.akis.cif.dataStructures.KeyType;
import tubitak.akis.cif.dataStructures.SDOHeaderGezgin;
import tubitak.akis.cif.functions.Conversions;

public class DiffieHellmanKey {
    public SDOHeaderGezgin header;
    private final byte[] prv;
    private byte[] pub;
    private byte[] modulus;

    public DiffieHellmanKey() {
        this.header = new SDOHeaderGezgin();
        this.prv = null;
        this.pub = null;
        this.modulus = null;
    }

    public DiffieHellmanKey(SDOHeaderGezgin header, byte[] prv, byte[] pub, byte[] modulus) {
        this.header = header;
        if (prv.length % 2 != 0) {
            this.prv = new byte[prv.length + 1];
            this.prv[0] = 0;
            System.arraycopy(prv, 0, this.prv, 1, prv.length);
        } else {
            this.prv = prv;
        }
        if (pub != null) {
            if (pub.length % 2 != 0) {
                this.pub = new byte[pub.length + 1];
                this.pub[0] = 0;
                System.arraycopy(pub, 0, this.pub, 1, pub.length);
            } else {
                this.pub = pub;
            }
        } else {
            this.pub = null;
        }
        if (modulus.length % 2 != 0) {
            this.modulus = new byte[modulus.length + 1];
            this.modulus[0] = 0;
            System.arraycopy(modulus, 0, this.modulus, 1, modulus.length);
        } else {
            this.modulus = modulus;
        }
    }

    public byte[] CreateSDOHeaderList(KeyType keyType, boolean op) {
        int i2 = 0;
        byte[] headerList = new byte[256];
        if (this.header.effectiveDate != null && this.header.effectiveDate.length != 6) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (this.header.expirationDate != null && this.header.expirationDate.length != 6) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (!op) {
            headerList[i2++] = 77;
            headerList[i2++] = 0;
        }
        if (keyType != KeyType.PRIVATE_DH) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        headerList[i2++] = -65;
        headerList[i2++] = -110;
        headerList[i2++] = this.header.keyID;
        headerList[i2++] = 0;
        headerList[i2++] = -96;
        int index = i2;
        headerList[i2++] = 0;
        if (this.header.name != null) {
            headerList[i2++] = -124;
            headerList[i2++] = (byte)this.header.name.length;
            if (op) {
                System.arraycopy(this.header.name, 0, headerList, i2, this.header.name.length);
                i2 += this.header.name.length;
            }
        }
        headerList[index] = (byte)(i2 - index - 1);
        if (keyType == KeyType.PRIVATE_DH && !op) {
            if (this.prv == null || this.modulus == null) {
                throw new AkisRuntimeException("Invalid parameter");
            }
            headerList[i2++] = 127;
            headerList[i2++] = 72;
            index = i2;
            headerList[i2++] = 0;
            headerList[i2++] = -123;
            byte[] temp = Conversions.GetBerLen(this.prv.length);
            System.arraycopy(temp, 0, headerList, i2, temp.length);
            i2 += temp.length;
            if (this.pub != null) {
                headerList[i2++] = -124;
                temp = Conversions.GetBerLen(this.pub.length);
                System.arraycopy(temp, 0, headerList, i2, temp.length);
                i2 += temp.length;
            }
            headerList[i2++] = -127;
            temp = Conversions.GetBerLen(this.modulus.length);
            System.arraycopy(temp, 0, headerList, i2, temp.length);
            headerList[index] = (byte)((i2 += temp.length) - index - 1);
        }
        if (!op) {
            headerList[1] = (byte)(i2 - 2);
            headerList[5] = (byte)(headerList[1] - 4);
        } else {
            headerList[3] = (byte)(i2 - 4);
        }
        byte[] resizedHeaderList = new byte[i2];
        System.arraycopy(headerList, 0, resizedHeaderList, 0, i2);
        return resizedHeaderList;
    }

    public byte[] CreateSDOHeaderListv10(KeyType keyType, boolean op) {
        int i2 = 0;
        int index = 0;
        byte[] headerList = new byte[256];
        if (this.header.effectiveDate != null && this.header.effectiveDate.length != 6) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (this.header.expirationDate != null && this.header.expirationDate.length != 6) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (!op) {
            headerList[i2++] = 77;
            headerList[i2++] = 0;
        }
        if (keyType != KeyType.PRIVATE_DH) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        headerList[i2++] = -65;
        headerList[i2++] = -110;
        headerList[i2++] = this.header.keyID;
        headerList[i2++] = 0;
        headerList[i2++] = -96;
        index = i2;
        headerList[i2++] = 0;
        if (this.header.name != null) {
            headerList[i2++] = -124;
            headerList[i2++] = (byte)this.header.name.length;
            if (op) {
                System.arraycopy(this.header.name, 0, headerList, i2, this.header.name.length);
                i2 += this.header.name.length;
            }
        }
        headerList[index] = (byte)(i2 - index - 1);
        if (keyType == KeyType.PRIVATE_DH && !op) {
            if (this.prv == null || this.modulus == null) {
                throw new AkisRuntimeException("Invalid parameter");
            }
            headerList[i2++] = 127;
            headerList[i2++] = 72;
            index = i2;
            headerList[i2++] = 0;
            headerList[i2++] = -123;
            byte[] temp = Conversions.GetBerLen(this.prv.length);
            System.arraycopy(temp, 0, headerList, i2, temp.length);
            i2 += temp.length;
            if (this.pub != null) {
                headerList[i2++] = -124;
                temp = Conversions.GetBerLen(this.pub.length);
                System.arraycopy(temp, 0, headerList, i2, temp.length);
                i2 += temp.length;
            }
            headerList[i2++] = -127;
            temp = Conversions.GetBerLen(this.modulus.length);
            System.arraycopy(temp, 0, headerList, i2, temp.length);
            i2 += temp.length;
            headerList[i2++] = -126;
            temp = new byte[]{1};
            System.arraycopy(temp, 0, headerList, i2, temp.length);
            i2 += temp.length;
            headerList[i2++] = -125;
            temp = new byte[]{1};
            System.arraycopy(temp, 0, headerList, i2, temp.length);
            headerList[index] = (byte)((i2 += temp.length) - index - 1);
        }
        if (!op) {
            headerList[1] = (byte)(i2 - 2);
            headerList[5] = (byte)(headerList[1] - 4);
        } else {
            headerList[3] = (byte)(i2 - 4);
        }
        byte[] resizedHeaderList = new byte[i2];
        System.arraycopy(headerList, 0, resizedHeaderList, 0, i2);
        return resizedHeaderList;
    }

    public byte[] SDOUpdate(KeyType keyType, int tag) {
        byte[] temp;
        int i2 = 0;
        byte[] data = new byte[512];
        byte[] sdo = new byte[512];
        sdo[0] = -65;
        sdo[2] = this.header.keyID;
        if (keyType == KeyType.PRIVATE_DH) {
            sdo[1] = -110;
            data[i2++] = 127;
            data[i2++] = 72;
            if (tag == 132 && this.pub != null) {
                temp = Conversions.GetBerLen(this.pub.length + 2);
                System.arraycopy(temp, 0, data, i2, temp.length);
                i2 += temp.length;
                data[i2++] = -124;
                temp = Conversions.GetBerLen(this.pub.length);
                System.arraycopy(temp, 0, data, i2, temp.length);
                System.arraycopy(this.pub, 0, data, i2 += temp.length, this.pub.length);
                i2 += this.pub.length;
            } else if (tag == 133) {
                temp = Conversions.GetBerLen(this.prv.length + 2);
                System.arraycopy(temp, 0, data, i2, temp.length);
                i2 += temp.length;
                data[i2++] = -123;
                temp = Conversions.GetBerLen(this.prv.length);
                System.arraycopy(temp, 0, data, i2, temp.length);
                System.arraycopy(this.prv, 0, data, i2 += temp.length, this.prv.length);
                i2 += this.prv.length;
            } else if (tag == 129) {
                temp = Conversions.GetBerLen(this.modulus.length + 2);
                System.arraycopy(temp, 0, data, i2, temp.length);
                i2 += temp.length;
                data[i2++] = -127;
                temp = Conversions.GetBerLen(this.modulus.length);
                System.arraycopy(temp, 0, data, i2, temp.length);
                System.arraycopy(this.modulus, 0, data, i2 += temp.length, this.modulus.length);
                i2 += this.modulus.length;
            }
        } else {
            throw new AkisRuntimeException("Invalid parameter");
        }
        int dataLen = i2;
        temp = Conversions.GetBerLen(dataLen);
        System.arraycopy(temp, 0, sdo, 3, temp.length);
        i2 = temp.length + 3;
        System.arraycopy(data, 0, sdo, i2, dataLen);
        byte[] resizedData = new byte[dataLen + i2];
        System.arraycopy(sdo, 0, resizedData, 0, dataLen + i2);
        return resizedData;
    }

    public void CreateKeyFromSDO(byte[] sdo) {
        if (sdo[0] != -65 && sdo[1] != -110 && sdo[1] != -94) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        int len = sdo[3] < 0 ? (sdo[3] & 0x7F) + 1 : 1;
        int i2 = 3 + len;
        if (sdo[i2] == -96) {
            this.header.CreateHeaderFromSDO(sdo);
        } else if (sdo[i2 + 1] == 73) {
            int n2 = len = sdo[i2 + 2] < 0 ? (sdo[i2 + 2] & 0x7F) + 1 : 1;
            if (sdo[i2 += len + 2] == -124) {
                len = sdo[i2 + 1] < 0 ? (sdo[i2 + 1] & 0x7F) + 1 : 1;
                this.pub = new byte[sdo.length - (i2 += len + 1)];
                System.arraycopy(sdo, i2, this.pub, 0, this.pub.length);
            } else if (sdo[i2] == -127) {
                len = sdo[i2 + 1] < 0 ? (sdo[i2 + 1] & 0x7F) + 1 : 1;
                this.modulus = new byte[sdo.length - (i2 += len + 1)];
                System.arraycopy(sdo, i2, this.modulus, 0, this.modulus.length);
            }
        }
    }
}

