/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.dataStructures;

import tubitak.akis.cif.akisExceptions.AkisRuntimeException;
import tubitak.akis.cif.dataStructures.SDOHeader;

public class PIN {
    public SDOHeader header;
    byte minPinLen;
    byte maxPinLen;
    byte[] pin;
    byte[] pen;

    public PIN() {
        this.header = new SDOHeader();
        this.minPinLen = (byte)4;
        this.maxPinLen = (byte)16;
        this.pin = null;
        this.pen = null;
    }

    public PIN(SDOHeader header, byte minPinLen, byte maxPinLen, byte[] pin, byte[] pen) {
        this.header = header;
        this.minPinLen = minPinLen;
        this.maxPinLen = maxPinLen;
        if (pin == null) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (pin.length > 16 || pen != null && pen.length > 32) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        this.pin = pin;
        this.pen = pen;
    }

    public byte[] CreateSDOHeaderList(boolean op) {
        int i2 = 0;
        byte index = 0;
        int len = 0;
        byte[] headerList = new byte[256];
        if (this.header.access == null || this.pin == null) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (this.header.maxTryCount == -1 || this.maxPinLen == -1 || this.minPinLen == -1) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (!op) {
            headerList[i2++] = 77;
            headerList[i2++] = 0;
        }
        headerList[i2++] = -65;
        headerList[i2++] = -127;
        headerList[i2++] = this.header.keyID;
        headerList[i2++] = 0;
        headerList[i2++] = -96;
        index = (byte)i2;
        headerList[i2++] = 0;
        if (this.header.name != null) {
            headerList[i2++] = -124;
            headerList[i2++] = (byte)this.header.name.length;
            if (op) {
                System.arraycopy(this.header.name, 0, headerList, i2, this.header.name.length);
                i2 += this.header.name.length;
            }
        }
        headerList[i2++] = -102;
        headerList[i2++] = 1;
        if (op) {
            headerList[i2++] = (byte)this.header.maxTryCount;
        }
        if (this.header.maxUsageCount != -1) {
            headerList[i2++] = -100;
            headerList[i2++] = 2;
            if (op) {
                headerList[i2++] = (byte)(this.header.maxUsageCount >> 8);
                headerList[i2++] = (byte)this.header.maxUsageCount;
            }
        }
        if (this.header.len != -1) {
            headerList[i2++] = -128;
            headerList[i2++] = 2;
            if (op) {
                headerList[i2++] = (byte)(this.header.len >> 8);
                headerList[i2++] = (byte)this.header.len;
            }
        }
        headerList[i2++] = -95;
        if (op) {
            len = this.header.access.toByteArray().length;
            headerList[i2++] = (byte)len;
            System.arraycopy(this.header.access.toByteArray(), 0, headerList, i2, len);
            i2 += len;
        } else if (this.header.access.toByteArray().length == 5) {
            headerList[i2++] = 2;
            headerList[i2++] = this.header.access.toByteArray()[0];
            headerList[i2++] = 3;
        } else {
            headerList[i2++] = 4;
            headerList[i2++] = -53;
            headerList[i2++] = 3;
            headerList[i2++] = -52;
            headerList[i2++] = 3;
        }
        if (this.header.berTLVInfo != null) {
            headerList[i2++] = -91;
            headerList[i2++] = (byte)this.header.berTLVInfo.length;
            if (op) {
                System.arraycopy(this.header.berTLVInfo, 0, headerList, i2, this.header.berTLVInfo.length);
                i2 += this.header.berTLVInfo.length;
            }
        }
        if (this.header.info != null) {
            headerList[i2++] = -123;
            headerList[i2++] = (byte)this.header.info.length;
            if (op) {
                System.arraycopy(this.header.info, 0, headerList, i2, this.header.info.length);
                i2 += this.header.info.length;
            }
        }
        headerList[index] = (byte)(i2 - index - 1);
        if (!op) {
            headerList[i2++] = 127;
            headerList[i2++] = 65;
            index = (byte)i2;
            headerList[i2++] = 0;
            headerList[i2++] = -128;
            headerList[i2++] = 1;
            headerList[i2++] = -127;
            headerList[i2++] = 1;
            headerList[i2++] = -126;
            headerList[i2++] = (byte)this.pin.length;
            if (this.pen != null) {
                headerList[i2++] = -64;
                headerList[i2++] = (byte)this.pen.length;
            }
            headerList[1] = (byte)(i2 - 2);
            headerList[5] = (byte)(headerList[1] - 4);
            headerList[index] = (byte)(i2 - index - 1);
        } else {
            headerList[3] = (byte)(i2 - 4);
        }
        byte[] resizedHeaderList = new byte[i2];
        System.arraycopy(headerList, 0, resizedHeaderList, 0, i2);
        return resizedHeaderList;
    }

    public byte[] SDOUpdate() {
        int i2 = 0;
        byte[] data = new byte[512];
        data[i2++] = -65;
        data[i2++] = -127;
        data[i2++] = this.header.keyID;
        data[i2++] = 0;
        data[i2++] = 127;
        data[i2++] = 65;
        data[i2++] = 0;
        data[i2++] = -128;
        data[i2++] = 1;
        data[i2++] = this.maxPinLen;
        data[i2++] = -127;
        data[i2++] = 1;
        data[i2++] = this.minPinLen;
        data[i2++] = -126;
        data[i2++] = (byte)this.pin.length;
        System.arraycopy(this.pin, 0, data, i2, this.pin.length);
        i2 += this.pin.length;
        if (this.pen != null) {
            data[i2++] = -64;
            data[i2++] = (byte)this.pen.length;
            System.arraycopy(this.pen, 0, data, i2, this.pen.length);
            i2 += (byte)this.pen.length;
        }
        data[6] = (byte)(i2 - 7);
        data[3] = (byte)(i2 - 4);
        byte[] resizedData = new byte[i2];
        System.arraycopy(data, 0, resizedData, 0, i2);
        return resizedData;
    }

    public void CreateKeyFromSDO(byte[] sdo) {
        if (sdo[0] != -65 || sdo[1] != -127) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        int i2 = 4;
        if (sdo[i2] == -96) {
            this.header.CreateHeaderFromSDO(sdo);
        } else if (sdo[i2 + 1] == 65) {
            if (sdo[i2 += 3] == -128) {
                this.maxPinLen = sdo[i2 + 2];
                i2 += sdo[i2 + 1];
            }
            if (sdo[i2] == -127) {
                this.minPinLen = sdo[i2 + 2];
                i2 += sdo[i2 + 1];
            }
        }
    }

    public static byte[] UpdatePIN(byte pinNo, byte[] newPIN) {
        byte[] updatePINHeader = new byte[]{-65, -127, pinNo, 0, 127, 65, 0, -126, 0};
        byte[] updatePIN = new byte[updatePINHeader.length + newPIN.length];
        System.arraycopy(updatePINHeader, 0, updatePIN, 0, updatePINHeader.length);
        System.arraycopy(newPIN, 0, updatePIN, updatePINHeader.length, newPIN.length);
        updatePIN[8] = (byte)newPIN.length;
        updatePIN[6] = (byte)(newPIN.length + 2);
        updatePIN[3] = (byte)(newPIN.length + 5);
        return updatePIN;
    }
}

