/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.dataStructures;

import tubitak.akis.cif.akisExceptions.AkisRuntimeException;
import tubitak.akis.cif.dataStructures.KeyType;
import tubitak.akis.cif.dataStructures.SDOHeaderGezgin;
import tubitak.akis.cif.functions.Conversions;

public class RSAKeyGezgin {
    public SDOHeaderGezgin header;
    private byte[] p;
    private byte[] q;
    private byte[] dP;
    private byte[] dQ;
    private byte[] Qinv;
    private byte[] n;
    private byte[] e;
    private byte[] CHR;

    public RSAKeyGezgin() {
        this.header = new SDOHeaderGezgin();
        this.p = null;
        this.q = null;
        this.dP = null;
        this.dQ = null;
        this.Qinv = null;
        this.n = null;
        this.e = null;
        this.CHR = null;
    }

    public boolean isCHRExists() {
        return this.CHR != null;
    }

    public RSAKeyGezgin(SDOHeaderGezgin header, byte[] n2, byte[] e2, byte[] CHR) {
        this.header = header;
        if (n2.length % 2 != 0) {
            this.n = new byte[n2.length + 1];
            this.n[0] = 0;
            System.arraycopy(n2, 0, this.n, 1, n2.length);
        } else {
            this.n = n2;
        }
        if (e2.length % 2 != 0) {
            this.e = new byte[e2.length + 1];
            this.e[0] = 0;
            System.arraycopy(e2, 0, this.e, 1, e2.length);
        } else {
            this.e = e2;
        }
        if (CHR != null) {
            if (CHR.length > 16) {
                throw new AkisRuntimeException("Invalid parameter");
            }
            this.CHR = CHR;
        }
    }

    public RSAKeyGezgin(SDOHeaderGezgin header, byte[] p2, byte[] q2, byte[] dP, byte[] dQ, byte[] Qinv, byte[] n2) {
        this.header = header;
        if (p2.length % 2 != 0) {
            this.p = new byte[p2.length + 1];
            this.p[0] = 0;
            System.arraycopy(p2, 0, this.p, 1, p2.length);
        } else {
            this.p = p2;
        }
        if (q2.length % 2 != 0) {
            this.q = new byte[q2.length + 1];
            this.q[0] = 0;
            System.arraycopy(q2, 0, this.q, 1, q2.length);
        } else {
            this.q = q2;
        }
        if (dP.length % 2 != 0) {
            this.dP = new byte[dP.length + 1];
            this.dP[0] = 0;
            System.arraycopy(dP, 0, this.dP, 1, dP.length);
        } else {
            this.dP = dP;
        }
        if (dQ.length % 2 != 0) {
            this.dQ = new byte[dQ.length + 1];
            this.dQ[0] = 0;
            System.arraycopy(dQ, 0, this.dQ, 1, dQ.length);
        } else {
            this.dQ = dQ;
        }
        if (Qinv.length % 2 != 0) {
            this.Qinv = new byte[Qinv.length + 1];
            this.Qinv[0] = 0;
            System.arraycopy(Qinv, 0, this.Qinv, 1, Qinv.length);
        } else {
            this.Qinv = Qinv;
        }
        if (n2.length % 2 != 0) {
            this.n = new byte[n2.length + 1];
            this.n[0] = 0;
            System.arraycopy(n2, 0, this.n, 1, n2.length);
        } else {
            this.n = n2;
        }
    }

    public byte[] CreateSDOHeaderList(KeyType keyType, boolean op) {
        int i2 = 0;
        int index = 0;
        byte[] headerList = new byte[256];
        if (!op) {
            headerList[i2++] = 77;
            headerList[i2++] = 0;
        }
        if (keyType == KeyType.PRIVATE_RSA) {
            headerList[i2++] = -65;
            headerList[i2++] = -112;
        } else if (keyType == KeyType.PUBLIC_RSA) {
            headerList[i2++] = -65;
            headerList[i2++] = -96;
        } else {
            throw new AkisRuntimeException("Invalid parameter");
        }
        headerList[i2++] = this.header.keyID;
        headerList[i2++] = 0;
        headerList[i2++] = -96;
        index = i2;
        headerList[i2++] = 0;
        if (this.header.name != null) {
            headerList[i2++] = -124;
            headerList[i2++] = (byte)this.header.name.length;
            if (op) {
                System.arraycopy(this.header.name, 0, headerList, i2, this.header.name.length);
                i2 += this.header.name.length;
            }
        }
        if (keyType == KeyType.PUBLIC_RSA) {
            if (this.header.effectiveDate != null) {
                headerList[i2++] = 95;
                headerList[i2++] = 37;
                headerList[i2++] = 6;
                if (op) {
                    System.arraycopy(this.header.effectiveDate, 0, headerList, i2, 6);
                    i2 += 6;
                }
            }
            if (this.header.expirationDate != null) {
                headerList[i2++] = 95;
                headerList[i2++] = 36;
                headerList[i2++] = 6;
                if (op) {
                    System.arraycopy(this.header.expirationDate, 0, headerList, i2, 6);
                    i2 += 6;
                }
            }
            if (this.header.usageOID != null) {
                headerList[i2++] = 6;
                headerList[i2++] = (byte)this.header.usageOID.length;
                if (op) {
                    System.arraycopy(this.header.usageOID, 0, headerList, i2, this.header.usageOID.length);
                    i2 += this.header.usageOID.length;
                }
            }
        }
        headerList[index] = (byte)(i2 - index - 1);
        if (keyType == KeyType.PRIVATE_RSA && !op) {
            if (this.p == null || this.q == null || this.dP == null || this.dQ == null || this.Qinv == null || this.n == null) {
                throw new AkisRuntimeException("Invalid parameter");
            }
            headerList[i2++] = 127;
            headerList[i2++] = 72;
            index = i2;
            headerList[i2++] = 0;
            headerList[i2++] = -110;
            byte[] temp = Conversions.GetBerLen(this.p.length);
            System.arraycopy(temp, 0, headerList, i2, temp.length);
            i2 += temp.length;
            headerList[i2++] = -109;
            temp = Conversions.GetBerLen(this.q.length);
            System.arraycopy(temp, 0, headerList, i2, temp.length);
            i2 += temp.length;
            headerList[i2++] = -107;
            temp = Conversions.GetBerLen(this.dP.length);
            System.arraycopy(temp, 0, headerList, i2, temp.length);
            i2 += temp.length;
            headerList[i2++] = -106;
            temp = Conversions.GetBerLen(this.dQ.length);
            System.arraycopy(temp, 0, headerList, i2, temp.length);
            i2 += temp.length;
            headerList[i2++] = -108;
            temp = Conversions.GetBerLen(this.Qinv.length);
            System.arraycopy(temp, 0, headerList, i2, temp.length);
            i2 += temp.length;
            headerList[i2++] = -127;
            temp = Conversions.GetBerLen(this.n.length);
            System.arraycopy(temp, 0, headerList, i2, temp.length);
            headerList[index] = (byte)((i2 += temp.length) - index - 1);
        } else if (keyType == KeyType.PUBLIC_RSA && !op) {
            if (this.n == null || this.e == null) {
                throw new AkisRuntimeException("Invalid parameter");
            }
            headerList[i2++] = 127;
            headerList[i2++] = 73;
            index = i2;
            headerList[i2++] = 0;
            headerList[i2++] = -127;
            byte[] temp = Conversions.GetBerLen(this.n.length);
            System.arraycopy(temp, 0, headerList, i2, temp.length);
            i2 += temp.length;
            headerList[i2++] = -126;
            temp = Conversions.GetBerLen(this.e.length);
            System.arraycopy(temp, 0, headerList, i2, temp.length);
            i2 += temp.length;
            if (this.CHR != null) {
                headerList[i2++] = 95;
                headerList[i2++] = 32;
                temp = Conversions.GetBerLen(this.CHR.length);
                System.arraycopy(temp, 0, headerList, i2, temp.length);
                i2 += temp.length;
            }
            headerList[index] = (byte)(i2 - index - 1);
        }
        if (!op) {
            headerList[1] = (byte)(i2 - 2);
            headerList[5] = (byte)(headerList[1] - 4);
        } else {
            headerList[3] = (byte)(i2 - 4);
        }
        byte[] resizedHeaderList = new byte[i2];
        System.arraycopy(headerList, 0, resizedHeaderList, 0, i2);
        return resizedHeaderList;
    }

    public byte[] SDOUpdate(KeyType keyType, int tag) {
        byte[] temp;
        int i2 = 0;
        byte[] data = new byte[512];
        byte[] sdo = new byte[512];
        sdo[0] = -65;
        sdo[2] = this.header.keyID;
        if (keyType == KeyType.PRIVATE_RSA) {
            sdo[1] = -112;
            data[i2++] = 127;
            data[i2++] = 72;
            if (tag == 146) {
                temp = Conversions.GetBerLen(this.p.length + 2);
                System.arraycopy(temp, 0, data, i2, temp.length);
                i2 += temp.length;
                data[i2++] = -110;
                temp = Conversions.GetBerLen(this.p.length);
                System.arraycopy(temp, 0, data, i2, temp.length);
                System.arraycopy(this.p, 0, data, i2 += temp.length, this.p.length);
                i2 += this.p.length;
            } else if (tag == 147) {
                temp = Conversions.GetBerLen(this.q.length + 2);
                System.arraycopy(temp, 0, data, i2, temp.length);
                i2 += temp.length;
                data[i2++] = -109;
                temp = Conversions.GetBerLen(this.q.length);
                System.arraycopy(temp, 0, data, i2, temp.length);
                System.arraycopy(this.q, 0, data, i2 += temp.length, this.q.length);
                i2 += this.q.length;
            } else if (tag == 149) {
                temp = Conversions.GetBerLen(this.dP.length + 2);
                System.arraycopy(temp, 0, data, i2, temp.length);
                i2 += temp.length;
                data[i2++] = -107;
                temp = Conversions.GetBerLen(this.dP.length);
                System.arraycopy(temp, 0, data, i2, temp.length);
                System.arraycopy(this.dP, 0, data, i2 += temp.length, this.dP.length);
                i2 += this.dP.length;
            } else if (tag == 150) {
                temp = Conversions.GetBerLen(this.dQ.length + 2);
                System.arraycopy(temp, 0, data, i2, temp.length);
                i2 += temp.length;
                data[i2++] = -106;
                temp = Conversions.GetBerLen(this.dQ.length);
                System.arraycopy(temp, 0, data, i2, temp.length);
                System.arraycopy(this.dQ, 0, data, i2 += temp.length, this.dQ.length);
                i2 += this.dQ.length;
            } else if (tag == 148) {
                temp = Conversions.GetBerLen(this.Qinv.length + 2);
                System.arraycopy(temp, 0, data, i2, temp.length);
                i2 += temp.length;
                data[i2++] = -108;
                temp = Conversions.GetBerLen(this.Qinv.length);
                System.arraycopy(temp, 0, data, i2, temp.length);
                System.arraycopy(this.Qinv, 0, data, i2 += temp.length, this.Qinv.length);
                i2 += this.Qinv.length;
            } else if (tag == 129) {
                temp = Conversions.GetBerLen(this.n.length + 2);
                System.arraycopy(temp, 0, data, i2, temp.length);
                i2 += temp.length;
                data[i2++] = -127;
                temp = Conversions.GetBerLen(this.n.length);
                System.arraycopy(temp, 0, data, i2, temp.length);
                System.arraycopy(this.n, 0, data, i2 += temp.length, this.n.length);
                i2 += this.n.length;
            }
        } else if (keyType == KeyType.PUBLIC_RSA) {
            sdo[1] = -96;
            data[i2++] = 127;
            data[i2++] = 73;
            if (tag == 129) {
                temp = Conversions.GetBerLen(this.n.length + 2);
                System.arraycopy(temp, 0, data, i2, temp.length);
                i2 += temp.length;
                data[i2++] = -127;
                temp = Conversions.GetBerLen(this.n.length);
                System.arraycopy(temp, 0, data, i2, temp.length);
                System.arraycopy(this.n, 0, data, i2 += temp.length, this.n.length);
                i2 += this.n.length;
            } else if (tag == 130) {
                temp = Conversions.GetBerLen(this.e.length + 2);
                System.arraycopy(temp, 0, data, i2, temp.length);
                i2 += temp.length;
                data[i2++] = -126;
                temp = Conversions.GetBerLen(this.e.length);
                System.arraycopy(temp, 0, data, i2, temp.length);
                System.arraycopy(this.e, 0, data, i2 += temp.length, this.e.length);
                i2 += this.e.length;
            } else if (tag == 32) {
                data[i2++] = (byte)(this.CHR.length + 3);
                data[i2++] = 95;
                data[i2++] = 32;
                data[i2++] = (byte)this.CHR.length;
                System.arraycopy(this.CHR, 0, data, i2, this.CHR.length);
                i2 += this.CHR.length;
            }
        } else {
            throw new AkisRuntimeException("Invalid parameter");
        }
        int dataLen = i2;
        temp = Conversions.GetBerLen(dataLen);
        System.arraycopy(temp, 0, sdo, 3, temp.length);
        i2 = temp.length + 3;
        System.arraycopy(data, 0, sdo, i2, dataLen);
        byte[] resizedData = new byte[dataLen + i2];
        System.arraycopy(sdo, 0, resizedData, 0, dataLen + i2);
        return resizedData;
    }

    public void CreateKeyFromSDO(byte[] sdo) {
        if (sdo[0] != -65 && sdo[1] != -112 && sdo[1] != -96) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        int len = sdo[3] < 0 ? (sdo[3] & 0x7F) + 1 : 1;
        int i2 = 3 + len;
        if (sdo[i2] == -96) {
            this.header.CreateHeaderFromSDO(sdo);
        } else if (sdo[i2 + 1] == 73) {
            int n2 = len = sdo[i2 + 2] < 0 ? (sdo[i2 + 2] & 0x7F) + 1 : 1;
            if (sdo[i2 += len + 2] == -127) {
                len = sdo[i2 + 1] < 0 ? (sdo[i2 + 1] & 0x7F) + 1 : 1;
                this.n = new byte[sdo.length - (i2 += len + 1)];
                System.arraycopy(sdo, i2, this.n, 0, this.n.length);
            } else if (sdo[i2] == -126) {
                len = sdo[i2 + 1] < 0 ? (sdo[i2 + 1] & 0x7F) + 1 : 1;
                this.e = new byte[sdo.length - (i2 += len + 1)];
                System.arraycopy(sdo, i2, this.e, 0, this.e.length);
            } else if (sdo[i2] == 95 && sdo[i2 + 1] == 32) {
                this.CHR = new byte[sdo[i2 + 2]];
                System.arraycopy(sdo, i2 + 3, this.CHR, 0, sdo[i2 + 2]);
            }
        }
    }
}

