/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.dataStructures;

import java.math.BigInteger;
import java.util.Arrays;
import javax.smartcardio.ATR;
import tubitak.akis.cif.akisExceptions.UnrecognizedCardException;

public enum Version {
    V10_UEKAE(4114),
    V11_UEKAE_INF(4370),
    V12_UEKAE_INF(4626),
    V12_UEKAE_NXP(4627),
    V121_UEKAE_INF(4690),
    V121_UEKAE_NXP(4691),
    V122_UEKAE_INF(4754),
    V122_UEKAE_NXP(4755),
    V12_UEKAE_UKiS(4641),
    V121_UEKAE_UKiS(4705),
    V121_UEKAE_UKIS_HHNEC(4708),
    V122_UEKAE_UKiS_HHNEC(4772),
    V122_UEKAE_UKiS_SMIC(4773),
    V121_UEKAE_UKiS_SMIC(4769),
    V13_UEKAE_INF(4882),
    V14_UEKAE_INF(5138),
    V14_UEKAE_NXP(5139),
    V2_UEKAE_INF(8210),
    V2_UEKAE_NXP(8211),
    V21_UEKAE_INF(8466),
    V21_UEKAE_NXP(8467),
    V22_UEKAE_INF(8722),
    V22_UEKAE_NXP(8723),
    V22_UEKAE_UKIS_HHNEC(8740),
    V22_UEKAE_UKIS_SMIC(8741),
    V25_UEKAE_NXP(9491),
    V25_UEKAE_INF(9490),
    V26_UEKAE_NXP(9747),
    V26_UEKAE_INF(9746),
    V30_UEKAE_INF(12306),
    GEZGIN_V10_UEKAE_INF(4146),
    GEZGIN_V10_UEKAE_NXP(4147),
    GEZGIN_V01_UEKAE_NXP(307),
    GEZGIN_V11_UEKAE_INF(4402),
    GEZGIN_V11_UEKAE_NXP(4403),
    GEZGIN_V20_UEKAE_NXP(8192);

    protected int mValue;

    private Version(int aValue) {
        this.mValue = aValue;
    }

    public int getValue() {
        return this.mValue;
    }

    public static Version getVersion(int vers) {
        Version[] values;
        for (Version value : values = Version.values()) {
            if (value.getValue() != vers) continue;
            return value;
        }
        return null;
    }

    public static Version getVersion(byte[] atr) {
        byte[] akis = new byte[]{85, 69, 75, 65, 69};
        byte[] versionBytes = new byte[2];
        ATR atrC = new ATR(atr);
        byte[] historicalBytes = atrC.getHistoricalBytes();
        if (!Arrays.equals(akis, Arrays.copyOfRange(historicalBytes, 0, 5))) {
            if (historicalBytes[2] == 71) {
                versionBytes[0] = (byte)(historicalBytes[4] & 0xF0 | ((historicalBytes[4] & 7) << 1) + (historicalBytes[5] >> 7 & 1));
                versionBytes[1] = (byte)(historicalBytes[3] & 0x3F | 0x30);
            } else if (historicalBytes[7] == 32 && historicalBytes[8] == 18) {
                versionBytes[0] = historicalBytes[7];
                versionBytes[1] = historicalBytes[8];
            } else if (historicalBytes[7] == 32 && historicalBytes[8] == 19) {
                versionBytes[0] = historicalBytes[7];
                versionBytes[1] = historicalBytes[8];
            } else if (historicalBytes[5] == 32) {
                if (historicalBytes[4] == 32) {
                    versionBytes[0] = historicalBytes[5];
                    versionBytes[1] = (byte)(historicalBytes[6] & 0x3F);
                } else {
                    versionBytes[0] = (byte)(historicalBytes[5] & 0xF0 | historicalBytes[6] >> 7 & 1);
                    versionBytes[1] = historicalBytes[4];
                }
            } else if ((byte)(historicalBytes[5] & 0xF0) == 32) {
                versionBytes[0] = (byte)(historicalBytes[5] & 0xF0 | ((historicalBytes[5] & 7) << 1) + (historicalBytes[6] >> 7 & 1));
                versionBytes[1] = (byte)(historicalBytes[4] & 0x3F);
            } else if (atrC.getBytes()[9] == 20 && atrC.getBytes()[10] == 19) {
                versionBytes[0] = atrC.getBytes()[9];
                versionBytes[1] = atrC.getBytes()[10];
            } else if (atrC.getBytes()[9] == 20 && atrC.getBytes()[10] == 18) {
                versionBytes[0] = atrC.getBytes()[9];
                versionBytes[1] = atrC.getBytes()[10];
            } else if (historicalBytes[0] == 0 || historicalBytes[0] == -128) {
                if (!Arrays.equals(akis, Arrays.copyOfRange(historicalBytes, 2, 7))) {
                    throw new UnrecognizedCardException();
                }
                versionBytes[0] = historicalBytes[7];
                versionBytes[1] = historicalBytes[8];
            }
        } else {
            if (!Arrays.equals(akis, Arrays.copyOfRange(historicalBytes, 0, 5))) {
                throw new UnrecognizedCardException();
            }
            versionBytes[0] = 16;
            versionBytes[1] = 18;
        }
        return Version.getVersion(new BigInteger(versionBytes).intValue());
    }
}

