/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.functions;

import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import tubitak.akis.cif.akisExceptions.AkisCardException;
import tubitak.akis.cif.functions.ICommandTransmitter;

public class CommandTransmitterPCSC
implements ICommandTransmitter {
    private String protocol;
    public Card card;
    public CardChannel channel;
    private final boolean exclusive;
    private final CardTerminal cardTerminal;

    public CommandTransmitterPCSC(CardTerminal cardTerminal, boolean exclusive) throws AkisCardException {
        this(cardTerminal, exclusive, "*");
    }

    public CommandTransmitterPCSC(CardTerminal cardTerminal, boolean exclusive, String protocol) throws AkisCardException {
        this.cardTerminal = cardTerminal;
        this.exclusive = exclusive;
        this.protocol = protocol;
        if (this.channel == null) {
            this.initialize();
        }
    }

    private void initialize() throws AkisCardException {
        this.closeCardTerminal();
        try {
            this.card = this.cardTerminal.connect(this.protocol);
            if (this.exclusive) {
                this.card.beginExclusive();
            }
            this.channel = this.card.getBasicChannel();
        }
        catch (CardException ex) {
            throw new AkisCardException(ex);
        }
    }

    @Override
    public void reset() throws AkisCardException {
        this.reset(this.protocol);
    }

    @Override
    public void reset(String newProtocol) throws AkisCardException {
        this.protocol = newProtocol;
        this.initialize();
        this.atr();
    }

    @Override
    public void closeCardTerminal() {
        if (this.card == null) {
            return;
        }
        if (this.exclusive) {
            try {
                this.card.endExclusive();
            }
            catch (CardException cardException) {
                // empty catch block
            }
        }
        try {
            this.card.disconnect(false);
        }
        catch (CardException cardException) {
            // empty catch block
        }
    }

    private boolean checkVersionForReset() {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        if ("Oracle Corporation".equalsIgnoreCase(vendor)) {
            if (version.isEmpty()) {
                return true;
            }
            String[] javaVer = version.split("\\.|_|\\+");
            if (javaVer.length < 4) {
                return true;
            }
            int prefix = Integer.parseInt(javaVer[0]);
            int major = Integer.parseInt(javaVer[1]);
            int update = Integer.parseInt(javaVer[3]);
            if (prefix > 1) {
                return true;
            }
            if (major == 7 && update >= 72) {
                return false;
            }
            if (major == 8 && update >= 20) {
                return true;
            }
        }
        return false;
    }

    @Override
    public byte[] control(byte[] apdu) throws AkisCardException {
        byte[] response;
        String OS = System.getProperty("os.name").toLowerCase();
        try {
            response = OS.indexOf("mac") >= 0 ? this.card.transmitControlCommand(1107299331, apdu) : (OS.indexOf("win") >= 0 ? this.card.transmitControlCommand(3223564, apdu) : this.card.transmitControlCommand(3223564, apdu));
        }
        catch (CardException e2) {
            throw new AkisCardException(e2);
        }
        return response;
    }

    @Override
    public ResponseAPDU transmit(CommandAPDU apdu) throws AkisCardException {
        try {
            return this.channel.transmit(apdu);
        }
        catch (CardException ex) {
            if ("sun.security.smartcardio.PCSCException: SCARD_W_REMOVED_CARD".equals(ex.getMessage()) || "sun.security.smartcardio.PCSCException: SCARD_W_RESET_CARD".equals(ex.getMessage())) {
                try {
                    if (!this.cardTerminal.isCardPresent()) {
                        throw new AkisCardException(ex);
                    }
                }
                catch (CardException exx) {
                    throw new AkisCardException(exx);
                }
                if (this.exclusive) {
                    try {
                        this.card.endExclusive();
                    }
                    catch (CardException exx) {
                        // empty catch block
                    }
                }
                this.initialize();
                try {
                    return this.channel.transmit(apdu);
                }
                catch (CardException e2) {
                    throw new AkisCardException(ex);
                }
            }
            throw new AkisCardException(ex);
        }
    }

    @Override
    public int getCommandBufferSize() {
        return 244;
    }

    @Override
    public ATR atr() throws AkisCardException {
        return this.card.getATR();
    }
}

