/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.cipher;

import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.cipher.DES;
import java.security.InvalidKeyException;
import java.util.Collections;
import java.util.Iterator;

public class RC2
extends BaseCipher {
    public static final int BLOCK_SIZE = 8;
    public static final int KEY_SIZE = 64;
    private static final int[] a;
    private static final String c;

    public RC2() {
        super(c, 8, 64);
    }

    @Override
    public Object clone() {
        return new RC2();
    }

    @Override
    public Iterator blockSizes() {
        return Collections.singleton(new Integer(8)).iterator();
    }

    @Override
    public Iterator keySizes() {
        return Collections.singleton(new Integer(64)).iterator();
    }

    @Override
    public Object makeKey(byte[] userkey, int ebits) throws InvalidKeyException {
        int n;
        ebits = 64;
        int[] nArray = new int[64];
        int n2 = userkey.length;
        int n3 = (ebits + 7) / 8;
        byte by = (byte)(255.0 % Math.pow(2.0, 8 + ebits - 8 * n3));
        int[] nArray2 = new int[128];
        boolean bl = DES.a();
        for (n = 0; n < n2; ++n) {
            nArray2[n] = userkey[n] & 0xFF;
            if (!bl) continue;
        }
        for (n = n2; n < 128; ++n) {
            nArray2[n] = a[nArray2[n - n2] + nArray2[n - 1] & 0xFF];
            if (!bl) continue;
        }
        nArray2[128 - n3] = a[nArray2[128 - n3] & by];
        for (n = 127 - n3; n >= 0; --n) {
            nArray2[n] = a[nArray2[n + n3] ^ nArray2[n + 1]];
            if (!bl) continue;
        }
        for (n = 63; n >= 0; --n) {
            nArray[n] = (nArray2[n * 2 + 1] << 8 | nArray2[n * 2]) & 0xFFFF;
            if (!bl) continue;
        }
        return nArray;
    }

    @Override
    public void encrypt(byte[] in, int i2, byte[] out, int o, Object K, int bs) {
        int[] nArray = (int[])K;
        boolean bl = DES.d();
        int n = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8;
        int n2 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8;
        int n3 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8;
        int n4 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8;
        int n5 = 0;
        for (int k = 0; k < 16; ++k) {
            n = n + (n2 & ~n4) + (n3 & n4) + nArray[n5++] & 0xFFFF;
            n = n << 1 | n >>> 15;
            n2 = n2 + (n3 & ~n) + (n4 & n) + nArray[n5++] & 0xFFFF;
            n2 = n2 << 2 | n2 >>> 14;
            n3 = n3 + (n4 & ~n2) + (n & n2) + nArray[n5++] & 0xFFFF;
            n3 = n3 << 3 | n3 >>> 13;
            n4 = n4 + (n & ~n3) + (n2 & n3) + nArray[n5++] & 0xFFFF;
            n4 = n4 << 5 | n4 >>> 11;
            if (k != 4 && k != 10) continue;
            n3 += nArray[(n2 += nArray[(n += nArray[n4 & 0x3F]) & 0x3F]) & 0x3F];
            n4 += nArray[n3 & 0x3F];
            if (bl) continue;
        }
        out[o++] = (byte)n;
        out[o++] = (byte)(n >>> 8);
        out[o++] = (byte)n2;
        out[o++] = (byte)(n2 >>> 8);
        out[o++] = (byte)n3;
        out[o++] = (byte)(n3 >>> 8);
        out[o++] = (byte)n4;
        out[o++] = (byte)(n4 >>> 8);
    }

    @Override
    public void decrypt(byte[] in, int i2, byte[] out, int o, Object K, int bs) {
        int[] nArray = (int[])K;
        int n = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8;
        int n2 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8;
        int n3 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8;
        boolean bl = DES.a();
        int n4 = in[i2++] & 0xFF | (in[i2++] & 0xFF) << 8;
        int n5 = 63;
        for (int k = 15; k >= 0; --k) {
            n4 = (n4 >>> 5 | n4 << 11) & 0xFFFF;
            n4 = n4 - (n & ~n3) - (n2 & n3) - nArray[n5--] & 0xFFFF;
            n3 = (n3 >>> 3 | n3 << 13) & 0xFFFF;
            n3 = n3 - (n4 & ~n2) - (n & n2) - nArray[n5--] & 0xFFFF;
            n2 = (n2 >>> 2 | n2 << 14) & 0xFFFF;
            n2 = n2 - (n3 & ~n) - (n4 & n) - nArray[n5--] & 0xFFFF;
            n = (n >>> 1 | n << 15) & 0xFFFF;
            n = n - (n2 & ~n4) - (n3 & n4) - nArray[n5--] & 0xFFFF;
            if (k != 11 && k != 5) continue;
            n4 = n4 - nArray[n3 & 0x3F] & 0xFFFF;
            n3 = n3 - nArray[n2 & 0x3F] & 0xFFFF;
            n2 = n2 - nArray[n & 0x3F] & 0xFFFF;
            n = n - nArray[n4 & 0x3F] & 0xFFFF;
            if (!bl) continue;
        }
        out[o++] = (byte)n;
        out[o++] = (byte)(n >>> 8);
        out[o++] = (byte)n2;
        out[o++] = (byte)(n2 >>> 8);
        out[o++] = (byte)n3;
        out[o++] = (byte)(n3 >>> 8);
        out[o++] = (byte)n4;
        out[o++] = (byte)(n4 >>> 8);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block12: {
            int n;
            char[] cArray2;
            int n2;
            int n3;
            block11: {
                char[] cArray3 = "P\u0004n".toCharArray();
                int n4 = cArray3.length;
                n3 = 0;
                n2 = 120;
                cArray2 = cArray3;
                n = n4;
                if (n4 <= 1) break block11;
                cArray = cArray2;
                n = n;
                if (n <= n3) break block12;
            }
            do {
                int n5 = n2;
                cArray2 = cArray2;
                char[] cArray4 = cArray2;
                int n6 = n2;
                int n7 = n3;
                while (true) {
                    int n8;
                    switch (n3 % 7) {
                        case 0: {
                            n8 = 90;
                            break;
                        }
                        case 1: {
                            n8 = 31;
                            break;
                        }
                        case 2: {
                            n8 = 36;
                            break;
                        }
                        case 3: {
                            n8 = 12;
                            break;
                        }
                        case 4: {
                            n8 = 54;
                            break;
                        }
                        case 5: {
                            n8 = 3;
                            break;
                        }
                        default: {
                            n8 = 105;
                        }
                    }
                    cArray4[n7] = (char)(cArray4[n7] ^ (n6 ^ n8));
                    ++n3;
                    n2 = n5;
                    if (n5 != 0) break;
                    n5 = n2;
                    cArray2 = cArray2;
                    n7 = n2;
                    cArray4 = cArray2;
                    n6 = n2;
                }
                cArray = cArray2;
                n = n;
            } while (n > n3);
        }
        c = new String(cArray).intern();
        a = new int[]{217, 120, 249, 196, 25, 221, 181, 237, 40, 233, 253, 121, 74, 160, 216, 157, 198, 126, 55, 131, 43, 118, 83, 142, 98, 76, 100, 136, 68, 139, 251, 162, 23, 154, 89, 245, 135, 179, 79, 19, 97, 69, 109, 141, 9, 129, 125, 50, 189, 143, 64, 235, 134, 183, 123, 11, 240, 149, 33, 34, 92, 107, 78, 130, 84, 214, 101, 147, 206, 96, 178, 28, 115, 86, 192, 20, 167, 140, 241, 220, 18, 117, 202, 31, 59, 190, 228, 209, 66, 61, 212, 48, 163, 60, 182, 38, 111, 191, 14, 218, 70, 105, 7, 87, 39, 242, 29, 155, 188, 148, 67, 3, 248, 17, 199, 246, 144, 239, 62, 231, 6, 195, 213, 47, 200, 102, 30, 215, 8, 232, 234, 222, 128, 82, 238, 247, 132, 170, 114, 172, 53, 77, 106, 42, 150, 26, 210, 113, 90, 21, 73, 116, 75, 159, 208, 94, 4, 24, 164, 236, 194, 224, 65, 110, 15, 81, 203, 204, 36, 145, 175, 80, 161, 244, 112, 57, 153, 124, 58, 133, 35, 184, 180, 122, 252, 2, 54, 91, 37, 85, 151, 49, 45, 93, 250, 152, 227, 138, 146, 174, 5, 223, 41, 16, 103, 108, 186, 201, 211, 0, 230, 207, 225, 158, 168, 44, 99, 22, 1, 63, 88, 226, 137, 169, 13, 56, 52, 27, 171, 51, 255, 176, 187, 72, 12, 95, 185, 177, 205, 46, 197, 243, 219, 71, 229, 165, 156, 119, 10, 166, 32, 104, 254, 127, 193, 173};
    }
}

