/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.KeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.DerValue;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.ObjectIdentifier;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.MA3APIEnvironment;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec.ECParameters;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec.NamedCurve;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.KeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.KeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECKeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECPrivateKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECPublicKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAKeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAPrivateKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAPublicKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.symmetric.SecretKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.ESYAPKCS11;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.IPKCS11Ops;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.key.SecretKey;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.ICardTemplate;

public class PKCS11Ops
implements IPKCS11Ops {
    private Logger a = LoggerFactory.getLogger(PKCS11Ops.class);
    private static List<String> b;
    protected PKCS11 mPKCS11;
    private CardType c;
    protected MessageDigest OZET_ALICI;
    protected ESYAPKCS11 mESYAPKCS11 = null;
    public static boolean d;
    private static final String[] f;
    private static final String[] g;

    public PKCS11Ops(CardType aKartTip) {
        try {
            this.OZET_ALICI = MessageDigest.getInstance(PKCS11Ops.a(9485, 31665));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.a.error(PKCS11Ops.a(9575, 14299), (Throwable)noSuchAlgorithmException);
            throw new RuntimeException(noSuchAlgorithmException);
        }
        this.c = aKartTip;
    }

    @Override
    public void initialize() throws PKCS11Exception, IOException {
        try {
            CK_C_INITIALIZE_ARGS cK_C_INITIALIZE_ARGS = this.a();
            String string = this.a(this.c.getLibName());
            this.mPKCS11 = PKCS11.getInstance(string, PKCS11Ops.a(9505, -4018), cK_C_INITIALIZE_ARGS, false);
        }
        catch (Exception exception) {
            throw new IOException(PKCS11Ops.a(9501, 25405), exception);
        }
    }

    CK_C_INITIALIZE_ARGS a() {
        return null;
    }

    @Override
    public long[] getTokenPresentSlotList() throws PKCS11Exception {
        return this.mPKCS11.C_GetSlotList(true);
    }

    @Override
    public List<Pair<Long, String>> getTokenPresentSlotListWithDescription() throws PKCS11Exception {
        long[] lArray = this.getTokenPresentSlotList();
        ArrayList<Pair<Long, String>> arrayList = new ArrayList<Pair<Long, String>>();
        long[] lArray2 = lArray;
        int n = lArray2.length;
        boolean bl = d;
        for (int i = 0; i < n; ++i) {
            long l = lArray2[i];
            String string = "";
            try {
                string = string + " " + new String(this.getSlotInfo((long)l).slotDescription).trim();
            }
            catch (Exception exception) {
                this.a.info(PKCS11Ops.a(9518, 5313) + exception.getMessage(), (Throwable)exception);
            }
            try {
                string = string + " " + new String(this.getTokenInfo((long)l).label).trim().split("\u0000")[0];
            }
            catch (Exception exception) {
                this.a.info(PKCS11Ops.a(9520, -198) + exception.getMessage(), (Throwable)exception);
            }
            arrayList.add((Pair<Long, String>)new Pair((Object)l, (Object)string));
            if (!bl) continue;
        }
        return arrayList;
    }

    @Override
    public long[] getSlotList() throws PKCS11Exception {
        return this.mPKCS11.C_GetSlotList(false);
    }

    @Override
    public CK_SLOT_INFO getSlotInfo(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_GetSlotInfo(aSlotID);
    }

    @Override
    public CK_SESSION_INFO getSessionInfo(long aSessionID) throws PKCS11Exception {
        return this.mPKCS11.C_GetSessionInfo(aSessionID);
    }

    @Override
    public boolean isTokenPresent(long aSlotID) throws PKCS11Exception {
        CK_SLOT_INFO cK_SLOT_INFO = this.mPKCS11.C_GetSlotInfo(aSlotID);
        long l = cK_SLOT_INFO.flags;
        if ((l & 1L) != 0L) {
            return true;
        }
        return false;
    }

    @Override
    public CK_TOKEN_INFO getTokenInfo(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_GetTokenInfo(aSlotID);
    }

    @Override
    public long[] getMechanismList(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_GetMechanismList(aSlotID);
    }

    @Override
    public long openSession(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_OpenSession(aSlotID, 6L, null, null);
    }

    @Override
    public void closeSession(long aSessionID) throws PKCS11Exception {
        this.mPKCS11.C_CloseSession(aSessionID);
    }

    @Override
    public void login(long aSessionID, String aCardPIN) throws PKCS11Exception {
        this.mPKCS11.C_Login(aSessionID, 1L, aCardPIN.toCharArray());
    }

    @Override
    public void logout(long aSessionID) throws PKCS11Exception {
        this.mPKCS11.C_Logout(aSessionID);
    }

    @Override
    public boolean isAnyObjectExist(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            return false;
        }
        return true;
    }

    @Override
    public void importCertificate(long aSessionID, String aCertLabel, X509Certificate aSertifika) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getCertificateTemplate(aCertLabel, aSertifika);
        this.mPKCS11.C_CreateObject(aSessionID, list.toArray(new CK_ATTRIBUTE[0]));
    }

    private void a(long l, String string, RSAKeyGenParameterSpec rSAKeyGenParameterSpec, boolean bl, boolean bl2) throws PKCS11Exception {
        CK_MECHANISM cK_MECHANISM;
        block12: {
            block11: {
                cK_MECHANISM = new CK_MECHANISM(0L);
                cK_MECHANISM.mechanism = 10L;
                cK_MECHANISM.pParameter = null;
                if (this.c == CardType.AKIS || this.c == CardType.ATIKHSM) break block11;
                if (this.c == CardType.DIRAKHSM) break block11;
                if (this.c == CardType.OPENDNSSOFTHSM) break block11;
                if (this.c != CardType.PROCENNEHSM) break block12;
            }
            cK_MECHANISM.mechanism = 0L;
        }
        int n = rSAKeyGenParameterSpec.getKeysize();
        BigInteger bigInteger = rSAKeyGenParameterSpec.getPublicExponent();
        if (bigInteger == null) {
            bigInteger = RSAKeyGenParameterSpec.F4;
        }
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = iCardTemplate.getRSAPublicKeyCreateTemplate(string, n, bigInteger, bl, bl2).toArray(new CK_ATTRIBUTE[0]);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = iCardTemplate.getRSAPrivateKeyCreateTemplate(string, bl, bl2).toArray(new CK_ATTRIBUTE[0]);
        this.mPKCS11.C_GenerateKeyPair(l, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        this.a(l, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public void createKeyPair(long aSessionID, String aKeyLabel, AlgorithmParameterSpec aParamSpec, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        boolean bl;
        block14: {
            bl = d;
            if (aParamSpec instanceof RSAKeyGenParameterSpec) {
                this.a(aSessionID, aKeyLabel, (RSAKeyGenParameterSpec)aParamSpec, aIsSign, aIsEncrypt);
                if (!bl) return;
            }
            if (!(aParamSpec instanceof ECParameterSpec)) break block14;
            this.a(aSessionID, aKeyLabel, (ECParameterSpec)aParamSpec, aIsSign, aIsEncrypt);
            if (!bl) return;
        }
        if (!(aParamSpec instanceof ECGenParameterSpec)) throw new SmartCardException(PKCS11Ops.a(9481, -8506));
        ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)aParamSpec;
        ECParameterSpec eCParameterSpec = NamedCurve.getECParameterSpec(eCGenParameterSpec.getName());
        if (eCParameterSpec == null) {
            throw new SmartCardException(PKCS11Ops.a(9494, 28453));
        }
        this.a(aSessionID, aKeyLabel, eCParameterSpec, aIsSign, aIsEncrypt);
        if (!bl) return;
        throw new SmartCardException(PKCS11Ops.a(9481, -8506));
    }

    private void a(long l, String string, ECParameterSpec eCParameterSpec, boolean bl, boolean bl2) throws PKCS11Exception, IOException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = 4160L;
        cK_MECHANISM.pParameter = null;
        byte[] byArray = ECParameters.encodeParameters(eCParameterSpec);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, false), new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(260L, bl2), new CK_ATTRIBUTE(266L, bl), new CK_ATTRIBUTE(384L, byArray), new CK_ATTRIBUTE(3L, string)};
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(261L, bl2), new CK_ATTRIBUTE(264L, bl), new CK_ATTRIBUTE(3L, string)};
        this.mPKCS11.C_GenerateKeyPair(l, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray3 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray3);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray4 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L)};
        this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray4);
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray4[0].pValue;
        byte[] byArray3 = this.c.getCardTemplate().getPointValue(byArray2);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray5 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string)};
        long[] lArray2 = this.objeAra(l, cK_ATTRIBUTEArray5);
        byte[] byArray4 = this.OZET_ALICI.digest(byArray3);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray6 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray4)};
        this.mPKCS11.C_SetAttributeValue(l, lArray2[0], cK_ATTRIBUTEArray6);
        this.mPKCS11.C_SetAttributeValue(l, lArray2[1], cK_ATTRIBUTEArray6);
    }

    @Override
    public void createSecretKey(long aSessionID, SecretKey aKey) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getSecretKeyCreateTemplate(aKey);
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aKey.getGenerationMechanism();
        cK_MECHANISM.pParameter = null;
        this.mPKCS11.C_GenerateKey(aSessionID, cK_MECHANISM, list.toArray(new CK_ATTRIBUTE[0]));
    }

    @Override
    public void importSecretKey(long aSessionId, SecretKey aKey) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getSecretKeyImportTemplate(aKey);
        this.mPKCS11.C_CreateObject(aSessionId, list.toArray(new CK_ATTRIBUTE[0]));
    }

    @Override
    public void importSecretKey(long aSessionId, SecretKeyTemplate aKeyTemplate) throws PKCS11Exception, SmartCardException {
        this.c.getCardTemplate().applyTemplate(aKeyTemplate);
        this.mPKCS11.C_CreateObject(aSessionId, aKeyTemplate.getAttributesAsArr());
    }

    @Override
    public byte[] signDataWithKeyID(long aSessionID, long aKeyID, CK_MECHANISM aMechanism, byte[] aImzalanacak) throws PKCS11Exception {
        this.mPKCS11.C_SignInit(aSessionID, aMechanism, aKeyID);
        byte[] byArray = this.mPKCS11.C_Sign(aSessionID, aImzalanacak);
        return byArray;
    }

    @Override
    public byte[] signDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aImzalanacak) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aSessionID, aSerialNumber);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(258L, byArray), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(1L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(PKCS11Ops.a(9507, 19154));
        }
        this.mPKCS11.C_SignInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray2 = this.mPKCS11.C_Sign(aSessionID, aImzalanacak);
        return byArray2;
    }

    private byte[] a(long l, byte[] byArray) throws PKCS11Exception, SmartCardException {
        long[] lArray;
        block8: {
            List<List<CK_ATTRIBUTE>> list = this.c.getCardTemplate().getCertSerialNumberTemplates(byArray);
            boolean bl = d;
            lArray = null;
            for (List<CK_ATTRIBUTE> object2 : list) {
                lArray = this.objeAra(l, object2.toArray(new CK_ATTRIBUTE[0]));
                if (lArray.length > 0) {
                    break;
                }
                if (!bl) continue;
            }
            if (lArray != null && lArray.length != 0) break block8;
            throw new SmartCardException(PKCS11Ops.a(9477, 23042));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
        this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray);
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray[0].pValue;
        return byArray2;
    }

    @Override
    public byte[] decryptDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aData) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aData);
        byte[] byArray2 = this.b(aSessionID, aSerialNumber);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(258L, byArray2), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(1L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(PKCS11Ops.a(9570, 32477));
        }
        byte[] byArray3 = new byte[1024];
        this.mPKCS11.C_DecryptInit(aSessionID, aMechanism, lArray[0]);
        int n = this.a(aSessionID, byArray, 0, byArray.length, byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray3, 0, byArray4, 0, n);
        return byArray4;
    }

    private int a(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws SmartCardException {
        Class<?> clazz = this.mPKCS11.getClass();
        Method[] methodArray = clazz.getMethods();
        AccessibleObject accessibleObject = null;
        int n5 = 0;
        while (true) {
            block17: {
                if (n5 >= methodArray.length) break;
                if (!methodArray[n5].getName().equals(PKCS11Ops.a(9526, -24933))) break block17;
                accessibleObject = methodArray[n5];
                break;
            }
            ++n5;
        }
        if (accessibleObject == null) {
            throw new SmartCardException(PKCS11Ops.a(9528, -16980));
        }
        if (!accessibleObject.isAccessible()) {
            ((Method)accessibleObject).setAccessible(true);
        }
        Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
        if (classArray.length == 7) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, byArray, n, n2, byArray2, n3, n4);
        }
        if (classArray.length == 9) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, 0, byArray, n, n2, 0, byArray2, n3, n4);
        }
        try {
            throw new SmartCardException(PKCS11Ops.a(9509, -1817));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SmartCardException(PKCS11Ops.a(9495, -21462), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SmartCardException(PKCS11Ops.a(9516, 29565), illegalAccessException);
        }
    }

    private byte[] b(long l, byte[] byArray) throws PKCS11Exception, SmartCardException {
        long[] lArray;
        block8: {
            List<List<CK_ATTRIBUTE>> list = this.c.getCardTemplate().getCertSerialNumberTemplates(byArray);
            boolean bl = d;
            lArray = null;
            for (List<CK_ATTRIBUTE> list2 : list) {
                lArray = this.objeAra(l, list2.toArray(new CK_ATTRIBUTE[0]));
                if (lArray.length > 0) {
                    break;
                }
                if (!bl) continue;
            }
            if (lArray != null && lArray.length != 0) break block8;
            throw new SmartCardException(PKCS11Ops.a(9514, 24981));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
        this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray);
        return (byte[])cK_ATTRIBUTEArray[0].pValue;
    }

    @Override
    public List<byte[]> getSignatureCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.a(aSessionID, true);
    }

    @Override
    public List<byte[]> getEncryptionCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.a(aSessionID, false);
    }

    private List<byte[]> a(long l, boolean bl) throws PKCS11Exception, SmartCardException {
        List<byte[]> list = this.getCertificates(l);
        boolean bl2 = d;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (byte[] byArray : list) {
            block17: {
                block19: {
                    Object object;
                    block18: {
                        X509Certificate x509Certificate = null;
                        try {
                            object = new ByteArrayInputStream(byArray);
                            CertificateFactory certificateFactory = CertificateFactory.getInstance(PKCS11Ops.a(9478, 20975));
                            x509Certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
                            ((InputStream)object).close();
                        }
                        catch (Exception exception) {
                            throw new SmartCardException(PKCS11Ops.a(9515, -4439) + StringUtil.toHexString((byte[])byArray), exception);
                        }
                        object = x509Certificate.getKeyUsage();
                        if (object == null) break block17;
                        if (!bl) break block18;
                        if (object[0] == false) break block17;
                        arrayList.add(byArray);
                        if (!bl2) break block17;
                    }
                    if (object[3] != false) break block19;
                    if (object[2] != false) break block19;
                    if (object[4] == false) break block17;
                }
                arrayList.add(byArray);
            }
            if (!bl2) continue;
        }
        return arrayList;
    }

    @Override
    public List<byte[]> getCertificates(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 1L)};
        boolean bl = d;
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        for (long l : lArray) {
            this.mPKCS11.C_GetAttributeValue(aSessionID, l, cK_ATTRIBUTEArray2);
            byte[] byArray = (byte[])cK_ATTRIBUTEArray2[0].pValue;
            arrayList.add(byArray);
            if (!bl) continue;
        }
        return arrayList;
    }

    @Override
    public String[] getSignatureKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(264L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    @Override
    public String[] getEncryptionKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(260L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    @Override
    public String[] getWrapperKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(262L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    @Override
    public String[] getUnwrapperKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(263L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    public String[] getLabels(long aSessionID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        long[] lArray = this.objeAra(aSessionID, aTemplate);
        ArrayList<String> arrayList = new ArrayList<String>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
        long[] lArray2 = lArray;
        int n = lArray2.length;
        boolean bl = d;
        for (int i = 0; i < n; ++i) {
            long l = lArray2[i];
            this.mPKCS11.C_GetAttributeValue(aSessionID, l, cK_ATTRIBUTEArray);
            String string = new String((char[])cK_ATTRIBUTEArray[0].pValue);
            arrayList.add(string);
            if (!bl) continue;
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public boolean isObjectExist(long aSessionID, String aLabel) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length > 0) {
            return true;
        }
        return false;
    }

    private boolean a(long l, String string, long l2) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(0L, l2)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        if (lArray.length > 0) {
            return true;
        }
        return false;
    }

    private void a(long l, String string, byte[] byArray, boolean bl) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(17L, byArray), new CK_ATTRIBUTE(2L, bl)};
        this.mPKCS11.C_CreateObject(l, cK_ATTRIBUTEArray);
    }

    @Override
    public void writePrivateData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.a(aSessionID, aLabel, aData, true);
    }

    @Override
    public void writePublicData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.a(aSessionID, aLabel, aData, false);
    }

    protected List<byte[]> _readData(long aSessionID, String aLabel, boolean aIsPrivate, long aDataType) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, aIsPrivate, true, aDataType);
    }

    protected List<byte[]> _readData(long aSessionID, String aLabel, boolean aIsPrivate, boolean aIstoken, long aDataType) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, aDataType), new CK_ATTRIBUTE(1L, aIstoken), new CK_ATTRIBUTE(2L, aIsPrivate), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        boolean bl = d;
        int n = lArray.length;
        if (n == 0) {
            throw new SmartCardException(aLabel + PKCS11Ops.a(9522, -5383));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (int i = 0; i < n; ++i) {
            this.mPKCS11.C_GetAttributeValue(aSessionID, lArray[i], cK_ATTRIBUTEArray2);
            byte[] byArray = (byte[])cK_ATTRIBUTEArray2[0].pValue;
            arrayList.add(byArray);
            if (!bl) continue;
        }
        return arrayList;
    }

    @Override
    public List<byte[]> readPrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, true, 0L);
    }

    @Override
    public List<byte[]> readPublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, false, 0L);
    }

    @Override
    public boolean isPrivateKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.a(aSessionID, aLabel, 3L);
    }

    @Override
    public boolean isPublicKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.a(aSessionID, aLabel, 2L);
    }

    @Override
    public boolean isCertificateExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.a(aSessionID, aLabel, 1L);
    }

    @Override
    public List<byte[]> readCertificate(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, false, 1L);
    }

    @Override
    public byte[] readCertificate(long aSessionID, byte[] aCertSerialNo) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 1L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, false), new CK_ATTRIBUTE(130L, aCertSerialNo)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(PKCS11Ops.a(9510, 8345));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        this.mPKCS11.C_GetAttributeValue(aSessionID, lArray[0], cK_ATTRIBUTEArray2);
        return (byte[])cK_ATTRIBUTEArray2[0].pValue;
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(aLabel + PKCS11Ops.a(9475, 4411));
        }
        return this.a(aSessionID, lArray[0]);
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, byte[] aCertSerialNo) throws SmartCardException, PKCS11Exception {
        byte[] byArray = this.a(aSessionID, aCertSerialNo);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(258L, byArray)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(StringUtil.toHexString((byte[])byArray) + PKCS11Ops.a(9476, -11379));
        }
        return this.a(aSessionID, lArray[0]);
    }

    @Override
    public long getPrivateKeyObjIDFromCertificateSerial(long aSessionID, byte[] aCertSerialNo) throws SmartCardException, PKCS11Exception {
        byte[] byArray = this.a(aSessionID, aCertSerialNo);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(258L, byArray)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(StringUtil.toHexString((byte[])byArray) + PKCS11Ops.a(9583, -3978));
        }
        return lArray[0];
    }

    private KeySpec a(long l, long l2) throws SmartCardException, PKCS11Exception {
        Long l3;
        block7: {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(256L)};
            this.mPKCS11.C_GetAttributeValue(l, l2, cK_ATTRIBUTEArray);
            l3 = (Long)cK_ATTRIBUTEArray[0].pValue;
            if (l3 == 0L) {
                return this.b(l, l2);
            }
            if (l3 != 3L && l3 != 3L) break block7;
            return this._readECPublicKeySpec(l, l2);
        }
        throw new SmartCardException(PKCS11Ops.a(9572, 15381), l3);
    }

    private RSAPublicKeySpec b(long l, long l2) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(290L), new CK_ATTRIBUTE(288L)};
        this.mPKCS11.C_GetAttributeValue(l, l2, cK_ATTRIBUTEArray);
        byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray[1].pValue;
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        return new RSAPublicKeySpec(bigInteger2, bigInteger);
    }

    protected ECPublicKeySpec _readECPublicKeySpec(long aSessionID, long aKeyId) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(384L), new CK_ATTRIBUTE(385L)};
        this.mPKCS11.C_GetAttributeValue(aSessionID, aKeyId, cK_ATTRIBUTEArray);
        byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray[1].pValue;
        try {
            ECParameterSpec eCParameterSpec = ECParameters.decodeParameters(byArray);
            byte[] byArray3 = this.c.getCardTemplate().getPointValue(byArray2);
            ECPoint eCPoint = ECParameters.decodePoint(byArray3, eCParameterSpec.getCurve());
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
            return eCPublicKeySpec;
        }
        catch (IOException iOException) {
            throw new SmartCardException(PKCS11Ops.a(9527, 20452), iOException);
        }
    }

    @Override
    public void updatePrivateData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.b(aSessionID, aLabel, aValue, true);
    }

    @Override
    public void updatePublicData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.b(aSessionID, aLabel, aValue, false);
    }

    private void b(long l, String string, byte[] byArray, boolean bl) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, bl), new CK_ATTRIBUTE(3L, string)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(string + PKCS11Ops.a(9522, -5383));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L, byArray)};
        this.mPKCS11.C_SetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray2);
    }

    protected void _deleteObject(long aSessionID, String aLabel, boolean aIsPrivate, boolean aIsToken) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, aIsToken), new CK_ATTRIBUTE(2L, aIsPrivate), new CK_ATTRIBUTE(3L, aLabel)};
        boolean bl = d;
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(aLabel + PKCS11Ops.a(9522, -5383));
        }
        for (int i = 0; i < lArray.length; ++i) {
            this.mPKCS11.C_DestroyObject(aSessionID, lArray[i]);
            if (!bl) continue;
        }
    }

    @Override
    public void deletePrivateObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this._deleteObject(aSessionID, aLabel, true, true);
    }

    @Override
    public void deletePublicObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this._deleteObject(aSessionID, aLabel, false, true);
    }

    private void a(long l, String string, boolean bl) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, bl), new CK_ATTRIBUTE(3L, string)};
        boolean bl2 = d;
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(string + PKCS11Ops.a(9522, -5383));
        }
        for (int i = 0; i < lArray.length; ++i) {
            this.mPKCS11.C_DestroyObject(l, lArray[i]);
            if (!bl2) continue;
        }
    }

    @Override
    public void deletePrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.a(aSessionID, aLabel, true);
    }

    @Override
    public void deletePublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.a(aSessionID, aLabel, false);
    }

    @Override
    public byte[] getRandomData(long aSessionID, int aDataLength) throws PKCS11Exception {
        byte[] byArray = new byte[aDataLength];
        this.mPKCS11.C_GenerateRandom(aSessionID, byArray);
        return byArray;
    }

    @Override
    public byte[] getTokenSerialNo(long aSlotID) throws PKCS11Exception {
        char[] cArray = this.mPKCS11.C_GetTokenInfo((long)aSlotID).serialNumber;
        String string = new String(cArray);
        return string.trim().getBytes();
    }

    @Override
    public byte[] signData(long aSessionID, String aKeyLabel, byte[] aImzalanacak, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(9508, -30989));
            }
        }
        this.mPKCS11.C_SignInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray = this.mPKCS11.C_Sign(aSessionID, aImzalanacak);
        return byArray;
    }

    @Override
    public byte[] signAndRecoverData(long aSessionID, String aKeyLabel, byte[] aImzalanacak, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(9508, -30989));
            }
        }
        this.mPKCS11.C_SignRecoverInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray = new byte[1024];
        int n = this.mPKCS11.C_SignRecover(aSessionID, aImzalanacak, 0, aImzalanacak.length, byArray, 0, byArray.length);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    @Override
    public byte[] verifyAndRecoverData(long aSessionID, String aKeyLabel, byte[] aSignature, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(9508, -30989));
            }
        }
        byte[] byArray = null;
        this.mPKCS11.C_VerifyRecoverInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray2 = new byte[1024];
        int n = this.mPKCS11.C_VerifyRecover(aSessionID, aSignature, 0, aSignature.length, byArray2, 0, byArray2.length);
        byArray = new byte[n];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return byArray;
    }

    @Override
    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aImza, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(9569, 20878));
            }
        }
        this.mPKCS11.C_VerifyInit(aSessionID, aMechanism, lArray[0]);
        this.mPKCS11.C_Verify(aSessionID, aData, aImza);
    }

    @Override
    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aImza, long aMechanism) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        this.verifyData(aSessionID, aKeyLabel, aData, aImza, cK_MECHANISM);
    }

    @Override
    public byte[] encryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        ByteArrayOutputStream byteArrayOutputStream;
        block10: {
            int n;
            byte[] byArray;
            int n2;
            boolean bl;
            block9: {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L)};
                bl = d;
                long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
                if (lArray.length == 0) {
                    cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
                    lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
                    if (lArray.length == 0) {
                        throw new SmartCardException(aKeyLabel + PKCS11Ops.a(9508, -30989));
                    }
                }
                n2 = 1024;
                byteArrayOutputStream = new ByteArrayOutputStream();
                byArray = new byte[n2 + 128];
                this.mPKCS11.C_EncryptInit(aSessionID, aMechanism, lArray[0]);
                n = 0;
                if (aData.length >= n2) break block9;
                n = this.b(aSessionID, aData, 0, aData.length, byArray, 0, byArray.length);
                byteArrayOutputStream.write(byArray, 0, n);
                if (!bl) break block10;
            }
            int n3 = aData.length;
            int n4 = 0;
            while (n3 > 0) {
                int n5;
                block12: {
                    block11: {
                        n5 = 0;
                        if (n3 <= n2) break block11;
                        n5 = n2;
                        if (!bl) break block12;
                    }
                    n5 = n3;
                }
                n = this.mPKCS11.C_EncryptUpdate(aSessionID, 0L, aData, n4, n5, 0L, byArray, 0, byArray.length);
                byteArrayOutputStream.write(byArray, 0, n);
                n3 -= n5;
                n4 += n5;
                if (!bl) continue;
            }
            n = this.mPKCS11.C_EncryptFinal(aSessionID, 0L, byArray, 0, byArray.length);
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private int b(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws SmartCardException, PKCS11Exception {
        Class<?> clazz = this.mPKCS11.getClass();
        Method[] methodArray = clazz.getMethods();
        AccessibleObject accessibleObject = null;
        int n5 = 0;
        while (true) {
            block20: {
                if (n5 >= methodArray.length) break;
                if (!methodArray[n5].getName().equals(PKCS11Ops.a(9484, 5932))) break block20;
                accessibleObject = methodArray[n5];
                break;
            }
            ++n5;
        }
        if (accessibleObject == null) {
            throw new SmartCardException(PKCS11Ops.a(9530, 29197));
        }
        if (!accessibleObject.isAccessible()) {
            ((Method)accessibleObject).setAccessible(true);
        }
        Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
        if (classArray.length == 7) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, byArray, n, n2, byArray2, n3, n4);
        }
        if (classArray.length == 9) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, 0, byArray, n, n2, 0, byArray2, n3, n4);
        }
        try {
            throw new SmartCardException(PKCS11Ops.a(9473, -16250));
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof PKCS11Exception) {
                throw (PKCS11Exception)invocationTargetException.getTargetException();
            }
            throw new SmartCardException(PKCS11Ops.a(9535, 9785), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SmartCardException(PKCS11Ops.a(9519, 11685), illegalAccessException);
        }
    }

    @Override
    public byte[] decryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        ByteArrayOutputStream byteArrayOutputStream;
        block10: {
            int n;
            int n2;
            byte[] byArray;
            byte[] byArray2;
            boolean bl;
            block9: {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(0L, 3L)};
                bl = d;
                long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
                if (lArray.length == 0) {
                    cK_ATTRIBUTEArray[1] = new CK_ATTRIBUTE(0L, 4L);
                    lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
                    if (lArray.length == 0) {
                        throw new SmartCardException(aKeyLabel + PKCS11Ops.a(9508, -30989));
                    }
                }
                long l = lArray[0];
                byteArrayOutputStream = new ByteArrayOutputStream();
                byArray2 = new byte[1152];
                this.mPKCS11.C_DecryptInit(aSessionID, aMechanism, l);
                byArray = this.a(aData);
                n2 = 1024;
                n = 0;
                if (byArray.length >= n2) break block9;
                n = this.a(aSessionID, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
                byteArrayOutputStream.write(byArray2, 0, n);
                if (!bl) break block10;
            }
            int n3 = aData.length;
            int n4 = 0;
            while (n3 > 0) {
                int n5;
                block12: {
                    block11: {
                        n5 = 0;
                        if (n3 <= n2) break block11;
                        n5 = n2;
                        if (!bl) break block12;
                    }
                    n5 = n3;
                }
                n = this.mPKCS11.C_DecryptUpdate(aSessionID, 0L, byArray, n4, n5, 0L, byArray2, 0, byArray2.length);
                byteArrayOutputStream.write(byArray2, 0, n);
                n3 -= n5;
                n4 += n5;
                if (!bl) continue;
            }
            n = this.mPKCS11.C_DecryptFinal(aSessionID, 0L, byArray2, 0, byArray2.length);
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] a(byte[] byArray) {
        int n;
        block3: {
            n = byArray.length % 8;
            if (n != 1 || byArray[0] != 0) break block3;
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
            return byArray2;
        }
        if (n == 7) {
            byte[] byArray3 = new byte[byArray.length + 1];
            byArray3[0] = 0;
            System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
            return byArray3;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void importCertificateAndKey(long aSessionID, String aCertLabel, String aKeyLabel, PrivateKey aPrivKey, X509Certificate aCert) throws PKCS11Exception, SmartCardException, IOException {
        Object object;
        block14: {
            block15: {
                byte[] byArray;
                boolean bl;
                boolean bl2;
                boolean bl3;
                block13: {
                    boolean[] blArray;
                    bl3 = false;
                    bl2 = d;
                    bl = false;
                    if (aCert != null && (blArray = aCert.getKeyUsage()) != null) {
                        bl3 = blArray[0];
                        bl = blArray[2] || blArray[3] || blArray[4];
                    }
                    byArray = aCert.getSubjectX500Principal().getEncoded();
                    if (!(aPrivKey instanceof RSAPrivateCrtKey)) break block13;
                    object = (RSAPrivateCrtKey)aPrivKey;
                    this.a(aSessionID, aKeyLabel, (RSAPrivateCrtKey)object, byArray, bl3, bl);
                    if (!bl2) break block14;
                }
                if (!(aPrivKey instanceof ECPrivateKey)) break block15;
                object = (ECPrivateKey)aPrivKey;
                ECPublicKey eCPublicKey = null;
                try {
                    eCPublicKey = (ECPublicKey)aCert.getPublicKey();
                }
                catch (ClassCastException classCastException) {
                    try {
                        PublicKey publicKey = aCert.getPublicKey();
                        Class<?> clazz = Class.forName(PKCS11Ops.a(9483, -6480));
                        Constructor<?> constructor = clazz.getConstructor(byte[].class);
                        eCPublicKey = (ECPublicKey)constructor.newInstance(new Object[]{publicKey.getEncoded()});
                    }
                    catch (Exception exception) {
                        this.a.warn(PKCS11Ops.a(9493, 9289), (Throwable)exception);
                        throw classCastException;
                    }
                }
                this.a(aSessionID, aKeyLabel, (ECPrivateKey)object, eCPublicKey, byArray, bl3, bl);
                if (!bl2) break block14;
            }
            throw new SmartCardException(PKCS11Ops.a(9517, 17729));
        }
        object = this.c.getCardTemplate().getCertificateTemplate(aCertLabel, aCert);
        this.mPKCS11.C_CreateObject(aSessionID, object.toArray(new CK_ATTRIBUTE[0]));
    }

    private void a(long l, String string, RSAPrivateCrtKey rSAPrivateCrtKey, byte[] byArray, boolean bl, boolean bl2) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getRSAPrivateKeyImportTemplate(string, rSAPrivateCrtKey, null, bl, bl2);
        List<CK_ATTRIBUTE> list2 = this.c.getCardTemplate().getRSAPublicKeyImportTemplate(string, rSAPrivateCrtKey, null, bl, bl2);
        if (byArray != null) {
            list.add(new CK_ATTRIBUTE(257L, byArray));
        }
        this.mPKCS11.C_CreateObject(l, list.toArray(new CK_ATTRIBUTE[0]));
        this.mPKCS11.C_CreateObject(l, list2.toArray(new CK_ATTRIBUTE[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(long l, String string, ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey, byte[] byArray, boolean bl, boolean bl2) throws PKCS11Exception, IOException {
        Object object;
        byte[] byArray2;
        boolean bl3;
        ECParameterSpec eCParameterSpec;
        block18: {
            block17: {
                eCParameterSpec = eCPrivateKey.getParams();
                bl3 = d;
                if (this.c != CardType.AKIS) break block17;
                byArray2 = ECParameters.encodeECParameterSpec(eCParameterSpec);
                if (!bl3) break block18;
            }
            byArray2 = ECParameters.encodeParameters(eCParameterSpec);
        }
        ECPoint eCPoint = eCPublicKey.getW();
        byte[] byArray3 = ECParameters.encodePoint(eCPoint, eCParameterSpec.getCurve());
        DerValue derValue = new DerValue(4, byArray3);
        byte[] byArray4 = this.OZET_ALICI.digest(byArray3);
        ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
        arrayList.add(new CK_ATTRIBUTE(1L, true));
        arrayList.add(new CK_ATTRIBUTE(0L, 2L));
        arrayList.add(new CK_ATTRIBUTE(256L, 3L));
        arrayList.add(new CK_ATTRIBUTE(384L, byArray2));
        arrayList.add(new CK_ATTRIBUTE(385L, derValue.toByteArray()));
        arrayList.add(new CK_ATTRIBUTE(3L, string));
        arrayList.add(new CK_ATTRIBUTE(2L, false));
        arrayList.add(new CK_ATTRIBUTE(258L, byArray4));
        if (bl2) {
            arrayList.add(new CK_ATTRIBUTE(268L, bl2));
        }
        if (bl) {
            arrayList.add(new CK_ATTRIBUTE(266L, bl));
        }
        boolean bl4 = false;
        ECParameterSpec eCParameterSpec2 = eCPublicKey.getParams();
        if (eCParameterSpec2 instanceof NamedCurve) {
            bl4 = true;
            object = NamedCurve.getNameCurves();
            ObjectIdentifier objectIdentifier = ((NamedCurve)eCParameterSpec2).getObjectIdentifier();
            for (NamedCurve namedCurve : object.values()) {
                if (namedCurve.getObjectIdentifier().toString().equals(objectIdentifier.toString())) {
                    bl4 = false;
                    if (!bl3) break;
                }
                if (!bl3) continue;
            }
        }
        arrayList.add(new CK_ATTRIBUTE(2L, bl4));
        object = new ArrayList();
        object.add(new CK_ATTRIBUTE(1L, true));
        object.add(new CK_ATTRIBUTE(2L, true));
        object.add(new CK_ATTRIBUTE(0L, 3L));
        object.add(new CK_ATTRIBUTE(256L, 3L));
        object.add(new CK_ATTRIBUTE(3L, string));
        object.add(new CK_ATTRIBUTE(17L, eCPrivateKey.getS()));
        object.add(new CK_ATTRIBUTE(384L, byArray2));
        object.add(new CK_ATTRIBUTE(258L, byArray4));
        if (bl2) {
            object.add(new CK_ATTRIBUTE(268L, bl2));
        }
        if (bl) {
            object.add(new CK_ATTRIBUTE(264L, bl));
        }
        if (byArray != null) {
            object.add(new CK_ATTRIBUTE(257L, byArray));
        }
        this.mPKCS11.C_CreateObject(l, arrayList.toArray(new CK_ATTRIBUTE[0]));
        this.mPKCS11.C_CreateObject(l, object.toArray(new CK_ATTRIBUTE[0]));
    }

    @Override
    @Deprecated
    public void importKeyPair(long aSessionID, String aLabel, KeyPair aKeyPair, byte[] aSubject, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        block13: {
            block14: {
                PublicKey publicKey;
                boolean bl;
                PrivateKey privateKey;
                block12: {
                    privateKey = aKeyPair.getPrivate();
                    bl = d;
                    publicKey = aKeyPair.getPublic();
                    if (!(privateKey instanceof RSAPrivateCrtKey) || !(publicKey instanceof RSAPublicKey)) break block12;
                    this.a(aSessionID, aLabel, (RSAPrivateCrtKey)privateKey, aSubject, aIsSign, aIsEncrypt);
                    if (!bl) break block13;
                }
                if (!(privateKey instanceof ECPrivateKey)) break block14;
                if (!(publicKey instanceof ECPublicKey)) break block14;
                this.a(aSessionID, aLabel, (ECPrivateKey)privateKey, (ECPublicKey)publicKey, aSubject, aIsSign, aIsEncrypt);
                if (!bl) break block13;
            }
            throw new SmartCardException(PKCS11Ops.a(9581, -1023));
        }
    }

    @Override
    public void changePassword(String aOldPass, String aNewPass, long aSessionID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.changePassword(aOldPass, aNewPass, (int)aSessionID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public void formatToken(String aSOpin, String aNewPIN, String aLabel, int slotID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.formatToken(aSOpin, aNewPIN, aLabel, slotID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public void setSOPin(byte[] aSOPin, byte[] aNewSOPin, long aSessionID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.setSOPin(aSOPin, aSOPin.length, aNewSOPin, aNewSOPin.length, (int)aSessionID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public void changeUserPin(byte[] aSOPin, byte[] aUserPin, long aSessionID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.changeUserPin(aSOPin, aSOPin.length, aUserPin, aUserPin.length, (int)aSessionID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public boolean setContainer(byte[] aContainerLabel, long aSessionID) {
        String string = this.c.getLibName();
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(string);
        }
        int n = this.mESYAPKCS11.setContainer(aContainerLabel, aContainerLabel.length, (int)aSessionID, string);
        if ((long)n == 0L) {
            return true;
        }
        return false;
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, byte[] aPbCertData, int aSignOrEnc) {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarCifti.length, aAnahtarLen, aScfname, aScfname.length(), aContextName, aContextName.length(), aPbCertData, aSignOrEnc);
        if ((long)n == 0L) {
            return true;
        }
        return false;
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, X509Certificate aPbCertificate, int aSignOrEnc) {
        byte[] byArray = null;
        try {
            byArray = aPbCertificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            this.a.warn(PKCS11Ops.a(9488, -5462), (Throwable)certificateEncodingException);
            return false;
        }
        return this.importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarLen, aScfname, aContextName, byArray, aSignOrEnc);
    }

    protected void changePUK(byte[] aOldPUK, byte[] aNewPUK, long aSessionID) throws PKCS11Exception {
        String string = this.c.getLibName();
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(string);
        }
        int n = this.mESYAPKCS11.ChangePUK(aOldPUK, aOldPUK.length, aNewPUK, aNewPUK.length, (int)aSessionID, string);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    protected void unBlockPIN(byte[] aPUK, byte[] aUserPIN, long aSessionID) throws PKCS11Exception {
        String string = this.c.getLibName();
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(string);
        }
        int n = this.mESYAPKCS11.UnBlockPIN(aPUK, aPUK.length, aUserPIN, aUserPIN.length, (int)aSessionID, string);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public long[] objeAra(long aSessionID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        long l = 200L;
        this.mPKCS11.C_FindObjectsInit(aSessionID, aTemplate);
        long[] lArray = this.mPKCS11.C_FindObjects(aSessionID, l);
        this.mPKCS11.C_FindObjectsFinal(aSessionID);
        return lArray;
    }

    @Override
    public void getAttributeValue(long aSessionID, long aObjectID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        this.mPKCS11.C_GetAttributeValue(aSessionID, aObjectID, aTemplate);
    }

    @Override
    public void changeLabel(long aSessionID, String aOldLabel, String aNewLabel) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(3L, aOldLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        boolean bl = d;
        if (lArray.length == 0) {
            throw new SmartCardException(aOldLabel + PKCS11Ops.a(9587, -19826));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aNewLabel)};
        for (int i = 0; i < lArray.length; ++i) {
            this.mPKCS11.C_SetAttributeValue(aSessionID, lArray[i], cK_ATTRIBUTEArray2);
            if (!bl) continue;
        }
    }

    private String a(String string) {
        String string2 = System.getProperty(PKCS11Ops.a(9506, -1882));
        boolean bl = d;
        this.a.debug(PKCS11Ops.a(9523, -8420) + string2);
        this.a.debug(PKCS11Ops.a(9580, 7292) + string2);
        if (new File(string).exists()) {
            this.a.info(string + PKCS11Ops.a(9571, -5001));
            return string;
        }
        String string3 = System.getProperty(PKCS11Ops.a(9513, -15758));
        String string4 = System.getProperty(PKCS11Ops.a(9499, -3515));
        String[] stringArray = string3.split(string4);
        for (String string5 : stringArray) {
            String string6 = string5 + System.getProperty(PKCS11Ops.a(9512, -13811)) + System.mapLibraryName(string);
            this.a.debug(PKCS11Ops.a(9497, 1049) + string6);
            if (!new File(string6).exists()) continue;
            this.a.info(PKCS11Ops.a(9504, -946) + string6);
            return string6;
        }
        for (String string7 : b) {
            String string8 = string7 + System.mapLibraryName(string);
            this.a.debug(PKCS11Ops.a(9497, 1049) + string8);
            if (new File(string8).exists()) {
                this.a.info(PKCS11Ops.a(9576, 144) + string8);
                return string8;
            }
            this.a.debug(PKCS11Ops.a(9534, -5296) + string8);
            if (!bl) continue;
        }
        this.a.info(PKCS11Ops.a(9576, 144) + System.mapLibraryName(string));
        return System.mapLibraryName(string);
    }

    protected byte[] toByteArray(BigInteger aX) {
        byte[] byArray = aX.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        return byArray;
    }

    @Override
    public byte[] generateRSAPrivateKey(long aSessionID, int keySize) throws ESYAException {
        throw new RuntimeException(PKCS11Ops.a(9524, 16095));
    }

    @Override
    public KeyPair generateECKeyPair(long aSessionID, ECParameterSpec ecParameterSpec) throws ESYAException {
        throw new RuntimeException(PKCS11Ops.a(9503, 14036));
    }

    @Override
    public byte[] getModulusOfKey(long aSessionID, long aObjID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
        this.getAttributeValue(aSessionID, aObjID, cK_ATTRIBUTEArray);
        return (byte[])cK_ATTRIBUTEArray[0].pValue;
    }

    private long b(long l, String string, long l2) throws SmartCardException, PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, l2), new CK_ATTRIBUTE(3L, string)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(l, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(string + PKCS11Ops.a(9492, 121));
            }
        }
        return lArray[0];
    }

    @Override
    public long getObjIDFromPublicKeyLabel(long aSessionID, String aLabel) throws SmartCardException, PKCS11Exception {
        return this.b(aSessionID, aLabel, 2L);
    }

    @Override
    public long getObjIDFromPrivateKeyLabel(long aSessionID, String aLabel) throws SmartCardException, PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aLabel + PKCS11Ops.a(9508, -30989));
            }
        }
        return lArray[0];
    }

    @Override
    public byte[] wrapKey(long aSessionID, CK_MECHANISM aMechanism, String wrapperKeyLabel, String aKeyLabel) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, wrapperKeyLabel), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[1].pValue = 4L;
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(wrapperKeyLabel + PKCS11Ops.a(9498, -7871));
            }
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(2L, true)};
        long[] lArray2 = this.objeAra(aSessionID, cK_ATTRIBUTEArray2);
        if (lArray2.length == 0) {
            throw new SmartCardException(aKeyLabel + PKCS11Ops.a(9533, -1605));
        }
        return this.mPKCS11.C_WrapKey(aSessionID, aMechanism, lArray[0], lArray2[0]);
    }

    @Override
    public byte[] wrapKey(long aSessionID, CK_MECHANISM aMechanism, KeyTemplate wrapperKeyTemplate, KeyTemplate aToBeExportedKeyTemplate) throws PKCS11Exception {
        this.a(aSessionID, wrapperKeyTemplate, aToBeExportedKeyTemplate);
        return this.mPKCS11.C_WrapKey(aSessionID, aMechanism, wrapperKeyTemplate.getKeyId(), aToBeExportedKeyTemplate.getKeyId());
    }

    private void a(long l, KeyTemplate ... keyTemplateArray) throws PKCS11Exception {
        KeyTemplate[] keyTemplateArray2 = keyTemplateArray;
        int n = keyTemplateArray2.length;
        boolean bl = d;
        for (int i = 0; i < n; ++i) {
            KeyTemplate keyTemplate = keyTemplateArray2[i];
            if (keyTemplate.getKeyId() > 0L) continue;
            this.a(l, keyTemplate);
            continue;
        }
    }

    private void a(long l, KeyTemplate keyTemplate) throws PKCS11Exception {
        long[] lArray;
        block7: {
            lArray = this.objeAra(l, keyTemplate.getAttributesAsArr());
            if (lArray != null && lArray.length != 0) break block7;
            return;
        }
        if (lArray.length > 1) {
            this.a.warn(PKCS11Ops.a(9487, -14454) + keyTemplate);
        }
        keyTemplate.setKeyId(lArray[0]);
    }

    @Override
    public void unwrapKey(long aSessionID, CK_MECHANISM aMechanism, String unwrapperKeyLabel, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aWrappedKey);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, unwrapperKeyLabel), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[1].pValue = 4L;
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(unwrapperKeyLabel + PKCS11Ops.a(9533, -1605));
            }
        }
        long l = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, lArray[0], byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l);
        String string = aUnwrappedKeyTemplate.getLabel();
        this.a(aSessionID, string);
    }

    @Override
    public void unwrapKey(long aSessionID, CK_MECHANISM aMechanism, KeyTemplate unwrapperKeyTemplate, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aWrappedKey);
        this.a(aUnwrappedKeyTemplate);
        this.a(aSessionID, new KeyTemplate[]{unwrapperKeyTemplate});
        long l = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, unwrapperKeyTemplate.getKeyId(), byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l);
        String string = unwrapperKeyTemplate.getLabel();
        this.a(aSessionID, string);
    }

    private void a(KeyTemplate keyTemplate) throws SmartCardException {
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        if (keyTemplate instanceof SecretKeyTemplate) {
            iCardTemplate.applyTemplate((SecretKeyTemplate)keyTemplate);
        }
    }

    @Override
    public void unwrapKey(long aSessionID, CK_MECHANISM aMechanism, byte[] certSerialNumber, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aWrappedKey);
        byte[] byArray2 = this.b(aSessionID, certSerialNumber);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray2), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(StringUtil.toString((byte[])certSerialNumber) + PKCS11Ops.a(9479, -25285));
        }
        long l = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, lArray[0], byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l);
    }

    public PKCS11 getmPKCS11() {
        return this.mPKCS11;
    }

    @Override
    public KeySpec createKeyPair(long aSessionID, KeyPairTemplate template) throws PKCS11Exception, IOException, SmartCardException {
        if (this.a.isDebugEnabled()) {
            this.a(((KeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr());
            this.a(((KeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr());
        }
        if (template instanceof RSAKeyPairTemplate) {
            return this.createKeyPair(aSessionID, (RSAKeyPairTemplate)template);
        }
        if (template instanceof ECKeyPairTemplate) {
            return this.a(aSessionID, (ECKeyPairTemplate)template);
        }
        throw new ESYARuntimeException(PKCS11Ops.a(9482, -27729) + template);
    }

    public KeySpec createKeyPair(long aSessionID, RSAKeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        long[] lArray = this.createKeyPairWithOutRead(aSessionID, template);
        RSAPublicKeySpec rSAPublicKeySpec = this.b(aSessionID, lArray[0]);
        String string = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getLabel();
        this.a(aSessionID, string);
        ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).setKeyId(lArray[0]);
        ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).setKeyId(lArray[1]);
        return rSAPublicKeySpec;
    }

    protected long[] createKeyPairWithOutRead(long aSessionID, RSAKeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = 0L;
        cK_MECHANISM.pParameter = null;
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        iCardTemplate.applyTemplate(template);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr();
        if (this.a.isDebugEnabled()) {
            this.a(cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        }
        long[] lArray = this.mPKCS11.C_GenerateKeyPair(aSessionID, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        return lArray;
    }

    protected long[] createKeyPairWithOutRead(long aSessionID, ECKeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = 4160L;
        cK_MECHANISM.pParameter = null;
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        iCardTemplate.applyTemplate(template);
        ECPublicKeyTemplate eCPublicKeyTemplate = (ECPublicKeyTemplate)template.getPublicKeyTemplate();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = eCPublicKeyTemplate.getAttributesAsArr();
        ECPrivateKeyTemplate eCPrivateKeyTemplate = (ECPrivateKeyTemplate)template.getPrivateKeyTemplate();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = eCPrivateKeyTemplate.getAttributesAsArr();
        long[] lArray = this.mPKCS11.C_GenerateKeyPair(aSessionID, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        return lArray;
    }

    private void a(long l, String string) {
        boolean bl = d;
        try {
            long[] lArray;
            block5: {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(1L, true)};
                lArray = this.objeAra(l, cK_ATTRIBUTEArray);
                if (lArray != null && lArray.length >= 1) break block5;
                return;
            }
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
            this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray);
            byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
            this.OZET_ALICI.update(byArray);
            byte[] byArray2 = this.OZET_ALICI.digest();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray2)};
            for (long l2 : lArray) {
                this.mPKCS11.C_SetAttributeValue(l, l2, cK_ATTRIBUTEArray2);
                if (!bl) continue;
                break;
            }
        }
        catch (Exception exception) {
            this.a.warn(PKCS11Ops.a(9521, -19467), (Throwable)exception);
        }
    }

    private KeySpec a(long l, ECKeyPairTemplate eCKeyPairTemplate) throws SmartCardException, IOException, PKCS11Exception {
        long[] lArray = this.createKeyPairWithOutRead(l, eCKeyPairTemplate);
        long l2 = lArray[0];
        byte[] byArray = this.d(l, l2);
        this.a(l, lArray, byArray);
        return this.a(l, l2);
    }

    private byte[] c(long l, long l2) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L)};
        this.mPKCS11.C_GetAttributeValue(l, l2, cK_ATTRIBUTEArray);
        return (byte[])cK_ATTRIBUTEArray[0].pValue;
    }

    private void a(long l, long[] lArray, ECPublicKeyTemplate eCPublicKeyTemplate) throws PKCS11Exception {
        byte[] byArray = this.a(eCPublicKeyTemplate);
        this.a(l, lArray, byArray);
    }

    private void a(long l, long[] lArray, byte[] byArray) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray)};
        boolean bl = d;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == -1L) continue;
            this.mPKCS11.C_SetAttributeValue(l, lArray[i], cK_ATTRIBUTEArray);
            continue;
        }
    }

    private byte[] a(ECPublicKeyTemplate eCPublicKeyTemplate) {
        ECPoint eCPoint = eCPublicKeyTemplate.getEcPublicKey().getW();
        EllipticCurve ellipticCurve = ((ECParameterSpec)eCPublicKeyTemplate.getSpec()).getCurve();
        byte[] byArray = ECParameters.encodePoint(eCPoint, ellipticCurve, false);
        return this.OZET_ALICI.digest(byArray);
    }

    private byte[] d(long l, long l2) throws IOException, PKCS11Exception {
        byte[] byArray = this.c(l, l2);
        byte[] byArray2 = this.c.getCardTemplate().getPointValue(byArray);
        byte[] byArray3 = this.OZET_ALICI.digest(byArray2);
        return byArray3;
    }

    @Override
    public void importKeyPair(long sessionID, KeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        block9: {
            block10: {
                boolean bl;
                block8: {
                    this.c.getCardTemplate().applyTemplate(template);
                    bl = d;
                    if (!(template instanceof RSAKeyPairTemplate)) break block8;
                    this.importKeyPair(sessionID, (RSAKeyPairTemplate)template);
                    if (!bl) break block9;
                }
                if (!(template instanceof ECKeyPairTemplate)) break block10;
                this.importKeyPair(sessionID, (ECKeyPairTemplate)template);
                if (!bl) break block9;
            }
            throw new ESYARuntimeException(PKCS11Ops.a(9490, -22107) + template);
        }
    }

    public void importKeyPair(long sessionID, RSAKeyPairTemplate template) throws PKCS11Exception {
        long l;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        String string = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getLabel();
        if (template.getPublicKeyTemplate() != null) {
            cK_ATTRIBUTEArray = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr();
            l = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).setKeyId(l);
        }
        if (template.getPrivateKeyTemplate() != null) {
            cK_ATTRIBUTEArray = ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr();
            l = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).setKeyId(l);
        }
        this.a(sessionID, string);
    }

    public void importKeyPair(long sessionID, ECKeyPairTemplate template) throws PKCS11Exception {
        long l = -1L;
        if (template.getPublicKeyTemplate() != null) {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = ((KeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr();
            l = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((KeyTemplate)template.getPublicKeyTemplate()).setKeyId(l);
        }
        long l2 = -1L;
        if (template.getPrivateKeyTemplate() != null) {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = ((KeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr();
            l2 = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((KeyTemplate)template.getPrivateKeyTemplate()).setKeyId(l2);
        }
        this.a(sessionID, new long[]{l, l2}, (ECPublicKeyTemplate)template.getPublicKeyTemplate());
    }

    @Override
    public void createSecretKey(long sessionID, SecretKeyTemplate template) throws PKCS11Exception, SmartCardException {
        this.c.getCardTemplate().applyTemplate(template);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = template.getAttributesAsArr();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(template.getGenerationMechanism());
        long l = this.mPKCS11.C_GenerateKey(sessionID, cK_MECHANISM, cK_ATTRIBUTEArray);
        template.setKeyId(l);
    }

    @Override
    public int deleteCertificate(long aSessionID, String aKeyLabel) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(0L, 1L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        boolean bl = d;
        int n = 0;
        if (lArray.length > 0) {
            for (int i = 0; i < lArray.length; ++i) {
                this.mPKCS11.C_DestroyObject(aSessionID, lArray[i]);
                ++n;
                if (!bl) continue;
            }
        }
        return n;
    }

    private void a(CK_MECHANISM cK_MECHANISM, CK_ATTRIBUTE[] cK_ATTRIBUTEArray, CK_ATTRIBUTE[] cK_ATTRIBUTEArray2) {
        block4: {
            block5: {
                if (!this.a.isDebugEnabled()) break block4;
                this.a.debug(PKCS11Ops.a(9531, 4684));
                this.a.debug(PKCS11Ops.a(9579, 5715) + cK_MECHANISM.mechanism);
                this.a.debug(PKCS11Ops.a(9474, 10870));
                if (cK_MECHANISM.pParameter != null) break block5;
                this.a.debug(PKCS11Ops.a(9573, -31567));
            }
            this.a.debug("\n");
            this.a.debug(PKCS11Ops.a(9578, 6119));
            this.a(cK_ATTRIBUTEArray2);
            this.a.debug(PKCS11Ops.a(9574, -6731));
            this.a.debug(PKCS11Ops.a(9491, 15867));
            this.a(cK_ATTRIBUTEArray);
            this.a.debug(PKCS11Ops.a(9480, -5701));
        }
    }

    private void a(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = cK_ATTRIBUTEArray;
        int n = cK_ATTRIBUTEArray2.length;
        boolean bl = d;
        for (int i = 0; i < n; ++i) {
            CK_ATTRIBUTE cK_ATTRIBUTE = cK_ATTRIBUTEArray2[i];
            this.a.debug(cK_ATTRIBUTE.toString());
            System.out.println(cK_ATTRIBUTE.toString());
            if (!bl) continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block26: {
            block25: {
                var5 = new String[81];
                var3_1 = 0;
                var2_2 = ":\u00db.1\u00ff\u00f9\u00e1[\u00ff\u00adz\u007f\u00adTiW\u0010\u00b2D\u00e7=\u0002\u0091D\u00e6\u00a7WAr_\u00c4@\u009dKwx\u00d0I\u00d5<e!\u00e0\u001b\u00c6\u00aa\u008d(-\u00e8\u00f6/u\u00f9\u00ea\u00eb\u00a5J&\u00c7\u00bfX\u0081\u00df\u00ca\u00fc\u00f9\u00d9\n\u0093\u00c8\u00e9\u00f3\u0080Q\u009a\u0082\u0096\u00d8\u008f\u00de\u00cagf\u00eee\u0094j\\\u0097\u00dc\b\u00ea\u0004d\u0005\u0001\u00063\u00d7\u0011\u00a7G\u001f\u00d3R\u000bT\f!\u00d1\u00a8\u00c5\u00c1\u00e7\u007fYX\u001dPZ\\\u0089 Y\u00deM!2\u00bfa\u00e4\u0091\u00cb(\u00b3l*<\u009a>\\f$\u00ac_\u00de9\u0003\u0010*\u0006,\u009ee\u0004\u007f\u00a2\u008a\u001f\u00f3\u00a1\u00f7v\u00d5_\u008bzH\u0099-\u00e3\u00e9\u00c1\u00e0\u000fZ<`\u0016 \u001a\u008b\u00e9Zr\u0093\u00f0\u00aeO\u00fc\u008cO\u00a1T\u001d\u00bd-\u00f0\u00b7\u00dc\u00e875\u00d7\u00ed\u00c3\u0087\u0011#\u00a7\u009a\u00a8\u00ef)a\u0003\u00f0\u00c2\f\u00db\u00a7\u0004\u009f\u00dc\u00e9]T\u00c2\u00df\u00f3\u0083\u00a4*%Z\u000f/\u00b0?D\u0018\u00b0\u001aQ\u00fd\u00faxE\u00d9\u0090w$#B\u00c5\u008f-\u00f4\u00dbN\u00d4\u00d7]#\u00bd\u00ad\u0004\u0014\u00d74\u0089Z\u00fd\u001c\u0080\u00e1\u00acp\u00a3\u00af\u00b6\u00d5\u0082\u00e7\u00b6\b\u0099G\u0019\u00b66vFf{\u00cex\u0083\u00c7rS~\"y\"0\u00f8\u00e9!\u00acrE\u009a\u0006\u00c8\u0092.\u00d2g^\fq2\u0095(\u00dbOA66\u00a2\u0005\u0092%\u0098F\u00a8\u0014\u00c8\u00bfA\u00b1\u0086\u0083\u009cTU\u000f}J\u00a2\u00e9\u0086\u009f\u001c\u00bf8\u0012\u00b3\u0019j\u0013\b\u00cd\u00d2\u009a\u00c6n\u00fc\u008b\u00c5\u00c4\u00f3\u0011&'\u0012\"\u00be\u009b\u00c4}\u00bdg\u0013\u00b2\u008e\u00e1\u00d6%x\u000e\u00b8\"V\u008fo\u00b5\u00f2V\u00e5Az\n\u0093X \u0080N\u00f9\u00f9\u00db\u0010\u009c\u00c3\u00a2\u00cc!c{h\u00e3\u00bca<\u001c\u00dc\u00dd\u0094\u0015s\u00dd.\u00e7\u0092'\u00fa0\u00fb\u001a\u00a0\u00b6\u00c5\u00a9ps\u00d2\u0085j\u00bf_\u00b0(\u0082\u00c0\u011b\f\u00f5\u00b2(.c\u0093\u00de\u00b4q(\u00b6\u00d3\u00bf0\u00cd\u00d9\u00a7_+2hu\u001a\u00bf\u0084\u00c8\u00dc\u00ca\u00f5/B \u0016\t\u0005\u0015~r\u00d9\u00e0\u00c4gWq\u00f4\u0007G\u00de)\u0095\u001a\u001fS\u000bQ\u00a4os,_\\\u0089\u00a0\u0095 \u00f0\u0095$>{\u0013\\)\u00ce\u0019`\u0007\rsT&\u0089\u00fb\u00a7\u00cd\u00faE\u0095\u00d8\u00bc\u00e3 aC\u00fc\u00af\u0085#\u0088((\u00c3?\u00b5a\u00a4\u0003\u00c2\u0093\u008bP\u0014A j\u00c1\t\u00dde\u00e4\r+\u0002I\u0015\u00e7\u00dd><`2Ji\u00d5\u00fe\u00ef\u00aa\u009f\u00ec\u00a4,R\u0010\u00c9\u00c3\u00e8\u001a\"\u008a\u0095.z\u0083\u0093\u009bB|Z\u00c8\u0088\u008d\u00d4\u01fa\u008e\u00c9\u00e2\u00af$\u0093\u00d2\u00c0\u009c\u00b2,E\u00ac\u00e2$gf\u00ca\u0006\u00c8h\u0099\u0018$\u00abA\u0091=w\u00a5\u0098\u008b\u00ce\u00cc\u00cd\u00c3\u008a\u00ee)\u009a}\u00b0\u00af9\u001a\u009aGdRMh\u00a0\u000e6\u00ba\t\u00dc\u0099s\b\u00abD\u0092Ic\u0003yc\u0001L:\u0018\u007f\u00be\u00cf\u00af?,7\u000e\u00a4\u00e3Nxn\u00a4\u00a6s}\u009c\u0096V\u00e5\u00d8|\u00d3\u00bb\u00bc\u009e\u00f7\u001f\u00c3+\u000f\u00a5\u0001\f\u00b6gJKF\rZl\u00c5\u0014)\n\u00d9H\u00b4\u00bb\u009b\\\u00b2;\u00fb\u00b7\u000f\u00a1\u00b5\u00f3Q%\u0001\u00e6\u00d0{\u00f9\u00eew\u00c33!\u00a7H?)n\u008a\u00e2\u00ea\u0088\u0095GpG!S\u00f0\u00a2H\u0096\u00a6\u00fde1n(?\u00d1\u00a1\u00f3\u00c2\u00b6G}S\u00ed \u0080\u0001\u00b9\u00bb\u00b0X\u00e4\u00b6@\u00ed;\u00ec\u00923ox^\u0094O\u00f6R\n\u0082\u0017\u0092M}\u0012{\u008a9\u0093\u0088]\u00aa\u007f\u009d\u00b9\"\u00e4Gu\u00d8J4\u00aeG\u00e4\\\u00e9qb*\u00c0\u00f4\u0014?\u0092\u00f7|\u00b2\u001a\u009a~\u009b\u00a9\u00a3\u00b6\u00c8\u001a,\u00c5\u00c4\b-\u00ecLU\u009b\u00c3\u0018\u0007\"\u0088\u00df\u00f9\u00c0\u00fa]\u00b8j&\u00f9\u00b1\u00c5i\u00bc\u00a1&8e\u0017\u00bc\u00cc\u00db\f\u00b7\u00bc>\u00f1\u0017\u00bd^{\u00fe\u00e9\u009e \u008f\u00fa\u0018o\u00e7\u00c2\u001b\u0099R\u0087?\n\u00b8E\u009b\u0019n\u0088\u00fdJ\u00e1F\u0092)-e\u00f9\u00fb\u00e4\u00d7H^\u001e4\u00f7Dy/\u009a\u00a3|\u00fbEQ\u00e2WI*\u00b9\u00f4\u0092\u00ba\u0098\u00da\u00a9\u0018\u00dfc\u00d4\u0098.D\u0089!\u00dd\u008ckVw\u001c\u00d6\u00cf\u00ec4['\u00acq\u0090P\u00c2\u00a5Fs\u0011x\u00eb\u00a7\u00c6\u00dc\u0088\u0085&mo\u00e3\u00a3\u0003\u00f7\u0005\u00d0\u001b\u00c0\t\u00c8\u00e6\u0003\nX\r=la,\u00eb\u0010x|\u00df \u00e5\u00c3ene~\r\u0098\u00f3\u00185V`\u00a7\u00c7db%\u008f\n&\u00bb\u007f\u00ceN\u009bf-\n\u00d3j\u00eby\u00fe-\u00159`9\u00a0\u000f%\u00aa\u009do\u00da>\u00de8\u008c\u009a\u00c7\u00cf\u00de%y\u00b6\u00ac\u00f0\u00eau\u0001\u00b4\u00e6\u00ff\u00b5\u00aa\u001d-y\u00ff\u009e\u00e0xx^\u00d5\u0099E\u000b\u0003\u0017\u00fa\u00c64\u00ae%\u0013\u0005\u00b5\u000b\u00bb\u00c1\u00a5\u009ax'\u00b0>;\u00c8\u00ea\u00b8\u00dc\u001e\u00cb\u00d2'\b&7\u00fbr\u00b8U[y\u0005Y\\\u00d1\u00dd\u00edh\u009fh\u00b8\u008fU\u0010\u00ee\u00e7\u0099\u00a3\u0092\u00c3\u01a9\u0005\u009f\u0011\u0012\u0013\u00822\u00bb\u00ba\u001e\u001d\u00f9|!\u00eb\u00e7\u00bby\u00bd\u00cd\fe\\\u0091\u00d3t\u00d4;\u00d6C\u001c\u00edT\u0016\u0087b\"\u00ee\u0088\u0091\u00aa\u00d7\u00e1\u00a1 \u0004A/\u00fb\u00c6\u00e3\u00e5X\u00faQ\u00eaa\u001aF3/\u00cb/-\u00b5\r\u00ef\n\u00dc\u0012a[\u00cc/[{8\u00d9\rl\u0086A\u0007\u00ee\u001f\u0090\u00f2\u00e6AfX#:\nr\u00e3\u0019V\u0081\u00cf\u00c44\u00daQ\u00fb\u0083E$\u00ada\u00b5\u0089\u00a7\u0087\u00f7\u00db\u0018\u009c\u00cb\u00e71\u0005\u0091\u0005\u0013\u00a8iS\u00e9)j6\u00b7\u00f0]r\u00bcCQ\u00a3\u0015-\u00d2\u00a33>\\\u0018\u0095gC#\u008c\u0080\u0096j\u0017r\u00f2\u0091\u0095\u00e4\u000f@\u00da;\u001d\u0085\u00c7m)\u00a3K\u00f5B\u00dbd\u008e\u000e\u00f3H\u009bS(^=h,\u009e\u0012\u00f1\r\u00f1\u00fa\nw\u00f7\u00cc\u00b1Vm\u00fe\u0085i\u0092b\u009d\u0017\u0087\u00caF{\u0087\u00a0\u00ab ]\u00b2\u0089\u0019\u00fex\u00eb'\u00cb\u00c66\u0017\u009d\u00d6\u009bl1\u00cci\u00a5\u00d0r\u00f8w\u00c4\u00d5\u0003\u00f4A\u00d2^\u00cbe\u00b2\u00dd7(\u00e5\u008c\u00f3W\u00cfi#\u00fd\u00b9\u00000WD\u009d\u00f0T@\u00e0\u00ce\u00ac\u0016E\u00fc\u0002\u00b4\u00b5i`|\u0007BG8\"\u00a1%T\u0005\u009a\r\u00ac'\u00a7\t\u00ee\u00d74\u00cabv\u00ab\u000fD-\u00e4\u00e0\u00beS\u001817\u000eP\u00ee8\u00e6\u00c1\u00fa\u00f2\u00ce\u00bdw\u009cK\u00eb\u00f3>\u00e4\u00a5e\u0014\fU,\u00a4\u0086\u00ce'\u00ed\u00cc\u000b\u00bb.\u00b8\u009e#\u00fb\u00d2]\u0018\u008e\u00f9\u00a5wMY\f\n\u0089Jw\u008d\u00ad\u00e6\u00a6&\u00e2o0\u00fa\u000b\u0099\u00aa\f\u000e\u001e\u00c6\u0082\u0013\u00f5&\u00a1$\u008f\u000f7\u00c3:a\u0014\u00f4X\u00d6\u00c2\u00e5k\u000ec0\u00a1\u0088\u00ad\u0080=\u00ec\u00ae\u0012gO\u00c7\u001a\"\u00ea\u00acfP\u0089\u00ed\u00f0\u008c\u00c7\u00f3\u00d3\u00daN\u0019X\u0019\u0087\u00dc$\u00a8\u00cfP\u00c5\u00b3\u009c-\u00d9jR\u0007p?\u0010\u0083\u00f3\u00bf\u009a\u0013T\u0018O<\u00f9X\u00f4\u00dd#g_\u00df\u00ad\u0019\u00d1\u00fe\u00eb\u00d1\u0013\u00bbI\u0012\u0005\u00b7\"\u00d4\u00cd\u007f\u00e3\u00b4H\u00ae\u00aa\u0014\u009d\u00d4\u00fbS@Y\u00ba%\u00a6iZ\u00b4\u00da\u001e\u00a7\u00ca{\u00ebbV\u001a\u00ffk/\u00aa\u00ff\u0083\u00c7<\u00ceJ\u001f\u00e8$\u0088\u0081o\u00e0B\u0002\u008f\u0099\u00e7\u00faO\u00fe\u00be\u000e|D\u0002G\u00fe\u0000\u00c0\u00e0\u00a3\u0097\u00b2\u00d0\u008a\u0003!\u0094'B#R\u00b2r\u001ax\u008e\u00c9p\u00fe\u009b\u00da\r\u008b\u000eo\u00064\u00d6OrRf\u001a\u00d2t\u0087%\u00be\u00ea#\u00a9?\u0018\u00e4\u0082\n\u00e2O\u00a2%fl~S_\fRG\u0017m>\u00a3\u00e2\u00bc\u00f8\u00c9\u00fd\u0097x\u0085[\u001f\u000b80?s\u00ecZ=\u0003!fOS\u00cd'\u00e5Uc\u0013l\u00f5\u00df;T\u00de\u00b0nz\u00cej\u000e\u0091\u00c5(W\u00f8\u00cdx\u00e3\u00d3GJ\u00a4\u00c8\u0083\u009b\u00ad\u00cf\u00dc\u00a9\u00a4\u00b9/Kz\u00b0\u001a%\u0014l]#\u00a0$\u00f7s\u00078\u00b4\u0097\u00aeO\u00f5\u0091x\u00eb\u00df\u00f6\u00b9\u00fc\u00ed\u009b\u001a\u00d8(\u00fc\u00acm\u00ach\u00a2\u001f\u0094+\u00a6\u00a3=\u0014k\u00bf\u00a5\u0080t\u00f06\u0088 \u008d\u00a3\u00be\u0010E\u00cf&`U\u0084V\u0099E\u0081\u00a5\u001bu\u00038$\u0003$\u0003,\u00fe\u001e\u00af5SK/\u0016C\u0095\u008d/\u00d5\u00a5{\u00b6N|\u00f8?'(\u00f9\u00fdnF\u00c8u\u00ce\u00fe?\r\u00d2\b\n\u0012\u00f5\u008fv\u00e3\u00a7v\u00d6\u00aa\u00ab\u001b\u000b\u009a\u00adf3\u008dt\u00bd\u00d7T\u00c4\u00ab\u008d\ri\u00da\u00892\u00b4\u00f5\u009d\u0012\u00ffxu\u00ed\u00ab[U]\u00c3\u00e1B\u00e3V\u0018\t\u00c5\u00a4rv\u00f5\u0012c\u007f4\u00a97\u0080\u0018&\u0007\u0010\u00cf\u0089L\u00a9\u00fe\u00bft\u00f2\u00cd\u009a\u00a8mSb\u007f\u0093I>\u0016\u001d\u000b\u00f6\u001cBn\u001b\u00ff\u00c8\u00e3]\u00a8S\"\u00f8\u00cad\u00f9\u00fa\u00eb\u00a5z\u0014\t\u00b7\u0089\u007f\u00aa\u0005\u00e8\u008f\u0097Y7\u00a3\u00bb\u00b1L\u008a\u00b6S\u007f#)\u00aa\u00ff\u0002\u001b\u00d1\r\u00eafG\u001a\u00d0\u000f,,C$\u00af\u0011\u00f0\\\u00ce$\u00c7C!~\u00ed|\u001c\u00d8\u00d1\u0007\u000f=\u00ca>\u00b9\u00f7\u008e\u0012w\u00fe\u00f6f\u00fa\u0090\u009b\u00d5\u0004\u00ce\u0005\u00aa/\u00de`\u0090\u00ec-.\u00d5\u00df\u0098\u00b4\u00dc\u00cd\u00af\u0091C\u0010'\u00cd\u00bf\u008d\u00df\u0007\u00d9\u00af\u00f4\u00ae\u00aa\u00fd\u00e3\u009d3|=\u00bb\u008f\u00c1\u00d3w\u00b5\u00b5\u0082\u009e\u00e6\u00f1\u0093\u00f1)\n\r\u00f7\u0083\u00b1\u0004h|E\u00d2H\u00bb\u0097\u00f8\u00d3L\u0080\u0090\u00f0I\u00d4I\u00dd\u0089F\u00bd\u0092\u0098p\u0011\u00b1(\u0006n\u00d6\u0082\u00d3!OcC\u00c0\u00a6\u00de6\u00e5\n\u0010{\u0090\u0094I`+\u00b3/uM\u0018\u0012\u0000\u00a8l\u00b7\u00ce\u0093\u00e4\u00d3\u001c\u0090\u0007\u000fGiz\u007fP\u0089\u0007f\t\u00cc%\f\u00b8\u00b2\u00d1;\u00f1\u00f7\u00a4WWD'\u0002.\u0012\u0098`\\\u00c3\u00d0L2?i\u00d5\u0011w\u00f9F\u00e0g,\u0004:J#M\u00b3^\u0094\u00a6]h\u00e24?\u0005)8\r\u00b1\u0083y\u00bft\u00c3\u00a6\u00ce\u00f6\u0096 /\u00e1\u0011#\u0098\u0014\u00fc\u00b3\u00f1C\u009c?\u00b9S<\u0005\u00b2sc\u000b\u0080\u00c5V\u00b8J\u00935`\u001dPj\u00d4\u001d\u00b1\u00a5`v\u00a7\u00a6.\u00b2?\u00cd|\u009e\u009cn\u00c4\u00d7R\u0093\u0016\u00c3\u001d\u00c1\u00ac\u0099:S\u009c!AT5\u0098A\u00be\u00e2\u0083\f\u00d8\u00d8\u00b0:E\u00bd\u00b1Wr(\u00d0V\u00ac\u00c0\u00c2?\u00940T\u00de\u00bb\u00134\u00dc$j\u00a0\u00e2\u00d8 !\u00bb\u00d2\u00a4\n<t/5\u00cd\u00f6\u00a7\u00ec1\u00c97v]e\u0005\u016f\u00fe0v\u00a6\u0012\u0000\u00b8\u0007\u00b7\u00a6\u00c3|\u00f1\u0014\u00d46\u00a1z\u000bM\u00c8\u00e0\u00df\u00d2\u0179\u0002\u0005$\u00a4\u0081\u009d93\u0014x\u00ebEGw\u00f6\u008a%\u0097\u0015\u0001k\u0082\u00df'$Km\u00b3\u001a\u00de\u001apb]\u00b6\u00b26\r\f\u00c1\u00c3\u00ddz\u0096@u\u00a3_7\u0002\u00fa\u00f6\u00bb\u00bb\u00b9C\u001f\u00ce\u00d4";
                var4_3 = ":\u00db.1\u00ff\u00f9\u00e1[\u00ff\u00adz\u007f\u00adTiW\u0010\u00b2D\u00e7=\u0002\u0091D\u00e6\u00a7WAr_\u00c4@\u009dKwx\u00d0I\u00d5<e!\u00e0\u001b\u00c6\u00aa\u008d(-\u00e8\u00f6/u\u00f9\u00ea\u00eb\u00a5J&\u00c7\u00bfX\u0081\u00df\u00ca\u00fc\u00f9\u00d9\n\u0093\u00c8\u00e9\u00f3\u0080Q\u009a\u0082\u0096\u00d8\u008f\u00de\u00cagf\u00eee\u0094j\\\u0097\u00dc\b\u00ea\u0004d\u0005\u0001\u00063\u00d7\u0011\u00a7G\u001f\u00d3R\u000bT\f!\u00d1\u00a8\u00c5\u00c1\u00e7\u007fYX\u001dPZ\\\u0089 Y\u00deM!2\u00bfa\u00e4\u0091\u00cb(\u00b3l*<\u009a>\\f$\u00ac_\u00de9\u0003\u0010*\u0006,\u009ee\u0004\u007f\u00a2\u008a\u001f\u00f3\u00a1\u00f7v\u00d5_\u008bzH\u0099-\u00e3\u00e9\u00c1\u00e0\u000fZ<`\u0016 \u001a\u008b\u00e9Zr\u0093\u00f0\u00aeO\u00fc\u008cO\u00a1T\u001d\u00bd-\u00f0\u00b7\u00dc\u00e875\u00d7\u00ed\u00c3\u0087\u0011#\u00a7\u009a\u00a8\u00ef)a\u0003\u00f0\u00c2\f\u00db\u00a7\u0004\u009f\u00dc\u00e9]T\u00c2\u00df\u00f3\u0083\u00a4*%Z\u000f/\u00b0?D\u0018\u00b0\u001aQ\u00fd\u00faxE\u00d9\u0090w$#B\u00c5\u008f-\u00f4\u00dbN\u00d4\u00d7]#\u00bd\u00ad\u0004\u0014\u00d74\u0089Z\u00fd\u001c\u0080\u00e1\u00acp\u00a3\u00af\u00b6\u00d5\u0082\u00e7\u00b6\b\u0099G\u0019\u00b66vFf{\u00cex\u0083\u00c7rS~\"y\"0\u00f8\u00e9!\u00acrE\u009a\u0006\u00c8\u0092.\u00d2g^\fq2\u0095(\u00dbOA66\u00a2\u0005\u0092%\u0098F\u00a8\u0014\u00c8\u00bfA\u00b1\u0086\u0083\u009cTU\u000f}J\u00a2\u00e9\u0086\u009f\u001c\u00bf8\u0012\u00b3\u0019j\u0013\b\u00cd\u00d2\u009a\u00c6n\u00fc\u008b\u00c5\u00c4\u00f3\u0011&'\u0012\"\u00be\u009b\u00c4}\u00bdg\u0013\u00b2\u008e\u00e1\u00d6%x\u000e\u00b8\"V\u008fo\u00b5\u00f2V\u00e5Az\n\u0093X \u0080N\u00f9\u00f9\u00db\u0010\u009c\u00c3\u00a2\u00cc!c{h\u00e3\u00bca<\u001c\u00dc\u00dd\u0094\u0015s\u00dd.\u00e7\u0092'\u00fa0\u00fb\u001a\u00a0\u00b6\u00c5\u00a9ps\u00d2\u0085j\u00bf_\u00b0(\u0082\u00c0\u011b\f\u00f5\u00b2(.c\u0093\u00de\u00b4q(\u00b6\u00d3\u00bf0\u00cd\u00d9\u00a7_+2hu\u001a\u00bf\u0084\u00c8\u00dc\u00ca\u00f5/B \u0016\t\u0005\u0015~r\u00d9\u00e0\u00c4gWq\u00f4\u0007G\u00de)\u0095\u001a\u001fS\u000bQ\u00a4os,_\\\u0089\u00a0\u0095 \u00f0\u0095$>{\u0013\\)\u00ce\u0019`\u0007\rsT&\u0089\u00fb\u00a7\u00cd\u00faE\u0095\u00d8\u00bc\u00e3 aC\u00fc\u00af\u0085#\u0088((\u00c3?\u00b5a\u00a4\u0003\u00c2\u0093\u008bP\u0014A j\u00c1\t\u00dde\u00e4\r+\u0002I\u0015\u00e7\u00dd><`2Ji\u00d5\u00fe\u00ef\u00aa\u009f\u00ec\u00a4,R\u0010\u00c9\u00c3\u00e8\u001a\"\u008a\u0095.z\u0083\u0093\u009bB|Z\u00c8\u0088\u008d\u00d4\u01fa\u008e\u00c9\u00e2\u00af$\u0093\u00d2\u00c0\u009c\u00b2,E\u00ac\u00e2$gf\u00ca\u0006\u00c8h\u0099\u0018$\u00abA\u0091=w\u00a5\u0098\u008b\u00ce\u00cc\u00cd\u00c3\u008a\u00ee)\u009a}\u00b0\u00af9\u001a\u009aGdRMh\u00a0\u000e6\u00ba\t\u00dc\u0099s\b\u00abD\u0092Ic\u0003yc\u0001L:\u0018\u007f\u00be\u00cf\u00af?,7\u000e\u00a4\u00e3Nxn\u00a4\u00a6s}\u009c\u0096V\u00e5\u00d8|\u00d3\u00bb\u00bc\u009e\u00f7\u001f\u00c3+\u000f\u00a5\u0001\f\u00b6gJKF\rZl\u00c5\u0014)\n\u00d9H\u00b4\u00bb\u009b\\\u00b2;\u00fb\u00b7\u000f\u00a1\u00b5\u00f3Q%\u0001\u00e6\u00d0{\u00f9\u00eew\u00c33!\u00a7H?)n\u008a\u00e2\u00ea\u0088\u0095GpG!S\u00f0\u00a2H\u0096\u00a6\u00fde1n(?\u00d1\u00a1\u00f3\u00c2\u00b6G}S\u00ed \u0080\u0001\u00b9\u00bb\u00b0X\u00e4\u00b6@\u00ed;\u00ec\u00923ox^\u0094O\u00f6R\n\u0082\u0017\u0092M}\u0012{\u008a9\u0093\u0088]\u00aa\u007f\u009d\u00b9\"\u00e4Gu\u00d8J4\u00aeG\u00e4\\\u00e9qb*\u00c0\u00f4\u0014?\u0092\u00f7|\u00b2\u001a\u009a~\u009b\u00a9\u00a3\u00b6\u00c8\u001a,\u00c5\u00c4\b-\u00ecLU\u009b\u00c3\u0018\u0007\"\u0088\u00df\u00f9\u00c0\u00fa]\u00b8j&\u00f9\u00b1\u00c5i\u00bc\u00a1&8e\u0017\u00bc\u00cc\u00db\f\u00b7\u00bc>\u00f1\u0017\u00bd^{\u00fe\u00e9\u009e \u008f\u00fa\u0018o\u00e7\u00c2\u001b\u0099R\u0087?\n\u00b8E\u009b\u0019n\u0088\u00fdJ\u00e1F\u0092)-e\u00f9\u00fb\u00e4\u00d7H^\u001e4\u00f7Dy/\u009a\u00a3|\u00fbEQ\u00e2WI*\u00b9\u00f4\u0092\u00ba\u0098\u00da\u00a9\u0018\u00dfc\u00d4\u0098.D\u0089!\u00dd\u008ckVw\u001c\u00d6\u00cf\u00ec4['\u00acq\u0090P\u00c2\u00a5Fs\u0011x\u00eb\u00a7\u00c6\u00dc\u0088\u0085&mo\u00e3\u00a3\u0003\u00f7\u0005\u00d0\u001b\u00c0\t\u00c8\u00e6\u0003\nX\r=la,\u00eb\u0010x|\u00df \u00e5\u00c3ene~\r\u0098\u00f3\u00185V`\u00a7\u00c7db%\u008f\n&\u00bb\u007f\u00ceN\u009bf-\n\u00d3j\u00eby\u00fe-\u00159`9\u00a0\u000f%\u00aa\u009do\u00da>\u00de8\u008c\u009a\u00c7\u00cf\u00de%y\u00b6\u00ac\u00f0\u00eau\u0001\u00b4\u00e6\u00ff\u00b5\u00aa\u001d-y\u00ff\u009e\u00e0xx^\u00d5\u0099E\u000b\u0003\u0017\u00fa\u00c64\u00ae%\u0013\u0005\u00b5\u000b\u00bb\u00c1\u00a5\u009ax'\u00b0>;\u00c8\u00ea\u00b8\u00dc\u001e\u00cb\u00d2'\b&7\u00fbr\u00b8U[y\u0005Y\\\u00d1\u00dd\u00edh\u009fh\u00b8\u008fU\u0010\u00ee\u00e7\u0099\u00a3\u0092\u00c3\u01a9\u0005\u009f\u0011\u0012\u0013\u00822\u00bb\u00ba\u001e\u001d\u00f9|!\u00eb\u00e7\u00bby\u00bd\u00cd\fe\\\u0091\u00d3t\u00d4;\u00d6C\u001c\u00edT\u0016\u0087b\"\u00ee\u0088\u0091\u00aa\u00d7\u00e1\u00a1 \u0004A/\u00fb\u00c6\u00e3\u00e5X\u00faQ\u00eaa\u001aF3/\u00cb/-\u00b5\r\u00ef\n\u00dc\u0012a[\u00cc/[{8\u00d9\rl\u0086A\u0007\u00ee\u001f\u0090\u00f2\u00e6AfX#:\nr\u00e3\u0019V\u0081\u00cf\u00c44\u00daQ\u00fb\u0083E$\u00ada\u00b5\u0089\u00a7\u0087\u00f7\u00db\u0018\u009c\u00cb\u00e71\u0005\u0091\u0005\u0013\u00a8iS\u00e9)j6\u00b7\u00f0]r\u00bcCQ\u00a3\u0015-\u00d2\u00a33>\\\u0018\u0095gC#\u008c\u0080\u0096j\u0017r\u00f2\u0091\u0095\u00e4\u000f@\u00da;\u001d\u0085\u00c7m)\u00a3K\u00f5B\u00dbd\u008e\u000e\u00f3H\u009bS(^=h,\u009e\u0012\u00f1\r\u00f1\u00fa\nw\u00f7\u00cc\u00b1Vm\u00fe\u0085i\u0092b\u009d\u0017\u0087\u00caF{\u0087\u00a0\u00ab ]\u00b2\u0089\u0019\u00fex\u00eb'\u00cb\u00c66\u0017\u009d\u00d6\u009bl1\u00cci\u00a5\u00d0r\u00f8w\u00c4\u00d5\u0003\u00f4A\u00d2^\u00cbe\u00b2\u00dd7(\u00e5\u008c\u00f3W\u00cfi#\u00fd\u00b9\u00000WD\u009d\u00f0T@\u00e0\u00ce\u00ac\u0016E\u00fc\u0002\u00b4\u00b5i`|\u0007BG8\"\u00a1%T\u0005\u009a\r\u00ac'\u00a7\t\u00ee\u00d74\u00cabv\u00ab\u000fD-\u00e4\u00e0\u00beS\u001817\u000eP\u00ee8\u00e6\u00c1\u00fa\u00f2\u00ce\u00bdw\u009cK\u00eb\u00f3>\u00e4\u00a5e\u0014\fU,\u00a4\u0086\u00ce'\u00ed\u00cc\u000b\u00bb.\u00b8\u009e#\u00fb\u00d2]\u0018\u008e\u00f9\u00a5wMY\f\n\u0089Jw\u008d\u00ad\u00e6\u00a6&\u00e2o0\u00fa\u000b\u0099\u00aa\f\u000e\u001e\u00c6\u0082\u0013\u00f5&\u00a1$\u008f\u000f7\u00c3:a\u0014\u00f4X\u00d6\u00c2\u00e5k\u000ec0\u00a1\u0088\u00ad\u0080=\u00ec\u00ae\u0012gO\u00c7\u001a\"\u00ea\u00acfP\u0089\u00ed\u00f0\u008c\u00c7\u00f3\u00d3\u00daN\u0019X\u0019\u0087\u00dc$\u00a8\u00cfP\u00c5\u00b3\u009c-\u00d9jR\u0007p?\u0010\u0083\u00f3\u00bf\u009a\u0013T\u0018O<\u00f9X\u00f4\u00dd#g_\u00df\u00ad\u0019\u00d1\u00fe\u00eb\u00d1\u0013\u00bbI\u0012\u0005\u00b7\"\u00d4\u00cd\u007f\u00e3\u00b4H\u00ae\u00aa\u0014\u009d\u00d4\u00fbS@Y\u00ba%\u00a6iZ\u00b4\u00da\u001e\u00a7\u00ca{\u00ebbV\u001a\u00ffk/\u00aa\u00ff\u0083\u00c7<\u00ceJ\u001f\u00e8$\u0088\u0081o\u00e0B\u0002\u008f\u0099\u00e7\u00faO\u00fe\u00be\u000e|D\u0002G\u00fe\u0000\u00c0\u00e0\u00a3\u0097\u00b2\u00d0\u008a\u0003!\u0094'B#R\u00b2r\u001ax\u008e\u00c9p\u00fe\u009b\u00da\r\u008b\u000eo\u00064\u00d6OrRf\u001a\u00d2t\u0087%\u00be\u00ea#\u00a9?\u0018\u00e4\u0082\n\u00e2O\u00a2%fl~S_\fRG\u0017m>\u00a3\u00e2\u00bc\u00f8\u00c9\u00fd\u0097x\u0085[\u001f\u000b80?s\u00ecZ=\u0003!fOS\u00cd'\u00e5Uc\u0013l\u00f5\u00df;T\u00de\u00b0nz\u00cej\u000e\u0091\u00c5(W\u00f8\u00cdx\u00e3\u00d3GJ\u00a4\u00c8\u0083\u009b\u00ad\u00cf\u00dc\u00a9\u00a4\u00b9/Kz\u00b0\u001a%\u0014l]#\u00a0$\u00f7s\u00078\u00b4\u0097\u00aeO\u00f5\u0091x\u00eb\u00df\u00f6\u00b9\u00fc\u00ed\u009b\u001a\u00d8(\u00fc\u00acm\u00ach\u00a2\u001f\u0094+\u00a6\u00a3=\u0014k\u00bf\u00a5\u0080t\u00f06\u0088 \u008d\u00a3\u00be\u0010E\u00cf&`U\u0084V\u0099E\u0081\u00a5\u001bu\u00038$\u0003$\u0003,\u00fe\u001e\u00af5SK/\u0016C\u0095\u008d/\u00d5\u00a5{\u00b6N|\u00f8?'(\u00f9\u00fdnF\u00c8u\u00ce\u00fe?\r\u00d2\b\n\u0012\u00f5\u008fv\u00e3\u00a7v\u00d6\u00aa\u00ab\u001b\u000b\u009a\u00adf3\u008dt\u00bd\u00d7T\u00c4\u00ab\u008d\ri\u00da\u00892\u00b4\u00f5\u009d\u0012\u00ffxu\u00ed\u00ab[U]\u00c3\u00e1B\u00e3V\u0018\t\u00c5\u00a4rv\u00f5\u0012c\u007f4\u00a97\u0080\u0018&\u0007\u0010\u00cf\u0089L\u00a9\u00fe\u00bft\u00f2\u00cd\u009a\u00a8mSb\u007f\u0093I>\u0016\u001d\u000b\u00f6\u001cBn\u001b\u00ff\u00c8\u00e3]\u00a8S\"\u00f8\u00cad\u00f9\u00fa\u00eb\u00a5z\u0014\t\u00b7\u0089\u007f\u00aa\u0005\u00e8\u008f\u0097Y7\u00a3\u00bb\u00b1L\u008a\u00b6S\u007f#)\u00aa\u00ff\u0002\u001b\u00d1\r\u00eafG\u001a\u00d0\u000f,,C$\u00af\u0011\u00f0\\\u00ce$\u00c7C!~\u00ed|\u001c\u00d8\u00d1\u0007\u000f=\u00ca>\u00b9\u00f7\u008e\u0012w\u00fe\u00f6f\u00fa\u0090\u009b\u00d5\u0004\u00ce\u0005\u00aa/\u00de`\u0090\u00ec-.\u00d5\u00df\u0098\u00b4\u00dc\u00cd\u00af\u0091C\u0010'\u00cd\u00bf\u008d\u00df\u0007\u00d9\u00af\u00f4\u00ae\u00aa\u00fd\u00e3\u009d3|=\u00bb\u008f\u00c1\u00d3w\u00b5\u00b5\u0082\u009e\u00e6\u00f1\u0093\u00f1)\n\r\u00f7\u0083\u00b1\u0004h|E\u00d2H\u00bb\u0097\u00f8\u00d3L\u0080\u0090\u00f0I\u00d4I\u00dd\u0089F\u00bd\u0092\u0098p\u0011\u00b1(\u0006n\u00d6\u0082\u00d3!OcC\u00c0\u00a6\u00de6\u00e5\n\u0010{\u0090\u0094I`+\u00b3/uM\u0018\u0012\u0000\u00a8l\u00b7\u00ce\u0093\u00e4\u00d3\u001c\u0090\u0007\u000fGiz\u007fP\u0089\u0007f\t\u00cc%\f\u00b8\u00b2\u00d1;\u00f1\u00f7\u00a4WWD'\u0002.\u0012\u0098`\\\u00c3\u00d0L2?i\u00d5\u0011w\u00f9F\u00e0g,\u0004:J#M\u00b3^\u0094\u00a6]h\u00e24?\u0005)8\r\u00b1\u0083y\u00bft\u00c3\u00a6\u00ce\u00f6\u0096 /\u00e1\u0011#\u0098\u0014\u00fc\u00b3\u00f1C\u009c?\u00b9S<\u0005\u00b2sc\u000b\u0080\u00c5V\u00b8J\u00935`\u001dPj\u00d4\u001d\u00b1\u00a5`v\u00a7\u00a6.\u00b2?\u00cd|\u009e\u009cn\u00c4\u00d7R\u0093\u0016\u00c3\u001d\u00c1\u00ac\u0099:S\u009c!AT5\u0098A\u00be\u00e2\u0083\f\u00d8\u00d8\u00b0:E\u00bd\u00b1Wr(\u00d0V\u00ac\u00c0\u00c2?\u00940T\u00de\u00bb\u00134\u00dc$j\u00a0\u00e2\u00d8 !\u00bb\u00d2\u00a4\n<t/5\u00cd\u00f6\u00a7\u00ec1\u00c97v]e\u0005\u016f\u00fe0v\u00a6\u0012\u0000\u00b8\u0007\u00b7\u00a6\u00c3|\u00f1\u0014\u00d46\u00a1z\u000bM\u00c8\u00e0\u00df\u00d2\u0179\u0002\u0005$\u00a4\u0081\u009d93\u0014x\u00ebEGw\u00f6\u008a%\u0097\u0015\u0001k\u0082\u00df'$Km\u00b3\u001a\u00de\u001apb]\u00b6\u00b26\r\f\u00c1\u00c3\u00ddz\u0096@u\u00a3_7\u0002\u00fa\u00f6\u00bb\u00bb\u00b9C\u001f\u00ce\u00d4".length();
                var1_4 = 91;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block25;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00d6\u00cf\u00f7\u00fa\u007f\u00c9]7U*\u0098\u008d\u00a1o\u00a4\u008b-\u00b7\u00f8s\u00c3`]\u00c4\u000f\u00c6\u0003v\u00a7\u00b9\u00a0\u0098t\u00c8\u00df \u00d1\u00ee\u00ea\u001aG\u0095\u00d0\u00fe#\u0019^\u00eeM\u00cf\u0086\u00af#&F\u00a1\u0083\u00962\u0017\u0002\u0007\u0004\u00bf!@\u0087$";
                    var4_3 = "\u00d6\u00cf\u00f7\u00fa\u007f\u00c9]7U*\u0098\u008d\u00a1o\u00a4\u008b-\u00b7\u00f8s\u00c3`]\u00c4\u000f\u00c6\u0003v\u00a7\u00b9\u00a0\u0098t\u00c8\u00df \u00d1\u00ee\u00ea\u001aG\u0095\u00d0\u00fe#\u0019^\u00eeM\u00cf\u0086\u00af#&F\u00a1\u0083\u00962\u0017\u0002\u0007\u0004\u00bf!@\u0087$".length();
                    var1_4 = 35;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block25;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block26;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 103;
                            break;
                        }
                        case 1: {
                            v13 = 61;
                            break;
                        }
                        case 2: {
                            v13 = 107;
                            break;
                        }
                        case 3: {
                            v13 = 77;
                            break;
                        }
                        case 4: {
                            v13 = 7;
                            break;
                        }
                        case 5: {
                            v13 = 87;
                            break;
                        }
                        default: {
                            v13 = 113;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        PKCS11Ops.f = var5;
        PKCS11Ops.g = new String[81];
        PKCS11Ops.b = new ArrayList<String>();
        var7_7 = System.getProperty(PKCS11Ops.a(9568, -13730)).toLowerCase();
        if (var7_7.indexOf(PKCS11Ops.a(9486, 10343)) >= 0) {
            var8_8 = System.getenv(PKCS11Ops.a(9500, 16565)) + System.getProperty(PKCS11Ops.a(9489, -29414)) + PKCS11Ops.a(9529, -10392) + System.getProperty(PKCS11Ops.a(9489, -29414));
            PKCS11Ops.b.add(var8_8);
        } else if (var7_7.indexOf(PKCS11Ops.a(9472, -8362)) >= 0) {
            var8_9 = System.getProperty(PKCS11Ops.a(9489, -29414)) + PKCS11Ops.a(9525, -10989) + System.getProperty(PKCS11Ops.a(9489, -29414)) + PKCS11Ops.a(9582, -25130) + System.getProperty(PKCS11Ops.a(9489, -29414)) + PKCS11Ops.a(9502, 7134) + System.getProperty(PKCS11Ops.a(9489, -29414));
            PKCS11Ops.b.add(var8_9);
            var9_11 = System.getProperty(PKCS11Ops.a(9489, -29414)) + PKCS11Ops.a(9532, 28939) + System.getProperty(PKCS11Ops.a(9489, -29414)) + PKCS11Ops.a(9511, 29713) + System.getProperty(PKCS11Ops.a(9489, -29414));
            PKCS11Ops.b.add(var9_11);
            if (!MA3APIEnvironment.SET_MAC_OS_PCSC_PATH) ** GOTO lbl113
            System.setProperty(PKCS11Ops.a(9577, -7050), PKCS11Ops.a(9496, 23316));
        } else {
            var8_10 = System.getProperty(PKCS11Ops.a(9489, -29414)) + PKCS11Ops.a(9511, 29713) + System.getProperty(PKCS11Ops.a(9489, -29414));
            PKCS11Ops.b.add(var8_10);
        }
lbl113:
        // 4 sources

    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x2523) & 0xFFFF;
        if (g[n3] == null) {
            int n4;
            int n5;
            char[] cArray = f[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 185;
                    break;
                }
                case 1: {
                    n5 = 96;
                    break;
                }
                case 2: {
                    n5 = 239;
                    break;
                }
                case 3: {
                    n5 = 107;
                    break;
                }
                case 4: {
                    n5 = 65;
                    break;
                }
                case 5: {
                    n5 = 175;
                    break;
                }
                case 6: {
                    n5 = 211;
                    break;
                }
                case 7: {
                    n5 = 94;
                    break;
                }
                case 8: {
                    n5 = 201;
                    break;
                }
                case 9: {
                    n5 = 194;
                    break;
                }
                case 10: {
                    n5 = 226;
                    break;
                }
                case 11: {
                    n5 = 30;
                    break;
                }
                case 12: {
                    n5 = 145;
                    break;
                }
                case 13: {
                    n5 = 141;
                    break;
                }
                case 14: {
                    n5 = 95;
                    break;
                }
                case 15: {
                    n5 = 80;
                    break;
                }
                case 16: {
                    n5 = 134;
                    break;
                }
                case 17: {
                    n5 = 10;
                    break;
                }
                case 18: {
                    n5 = 204;
                    break;
                }
                case 19: {
                    n5 = 253;
                    break;
                }
                case 20: {
                    n5 = 217;
                    break;
                }
                case 21: {
                    n5 = 49;
                    break;
                }
                case 22: {
                    n5 = 158;
                    break;
                }
                case 23: {
                    n5 = 119;
                    break;
                }
                case 24: {
                    n5 = 219;
                    break;
                }
                case 25: {
                    n5 = 209;
                    break;
                }
                case 26: {
                    n5 = 31;
                    break;
                }
                case 27: {
                    n5 = 218;
                    break;
                }
                case 28: {
                    n5 = 14;
                    break;
                }
                case 29: {
                    n5 = 73;
                    break;
                }
                case 30: {
                    n5 = 168;
                    break;
                }
                case 31: {
                    n5 = 46;
                    break;
                }
                case 32: {
                    n5 = 2;
                    break;
                }
                case 33: {
                    n5 = 140;
                    break;
                }
                case 34: {
                    n5 = 125;
                    break;
                }
                case 35: {
                    n5 = 176;
                    break;
                }
                case 36: {
                    n5 = 29;
                    break;
                }
                case 37: {
                    n5 = 21;
                    break;
                }
                case 38: {
                    n5 = 215;
                    break;
                }
                case 39: {
                    n5 = 83;
                    break;
                }
                case 40: {
                    n5 = 155;
                    break;
                }
                case 41: {
                    n5 = 28;
                    break;
                }
                case 42: {
                    n5 = 153;
                    break;
                }
                case 43: {
                    n5 = 17;
                    break;
                }
                case 44: {
                    n5 = 165;
                    break;
                }
                case 45: {
                    n5 = 72;
                    break;
                }
                case 46: {
                    n5 = 5;
                    break;
                }
                case 47: {
                    n5 = 196;
                    break;
                }
                case 48: {
                    n5 = 178;
                    break;
                }
                case 49: {
                    n5 = 60;
                    break;
                }
                case 50: {
                    n5 = 121;
                    break;
                }
                case 51: {
                    n5 = 113;
                    break;
                }
                case 52: {
                    n5 = 6;
                    break;
                }
                case 53: {
                    n5 = 164;
                    break;
                }
                case 54: {
                    n5 = 221;
                    break;
                }
                case 55: {
                    n5 = 238;
                    break;
                }
                case 56: {
                    n5 = 240;
                    break;
                }
                case 57: {
                    n5 = 20;
                    break;
                }
                case 58: {
                    n5 = 58;
                    break;
                }
                case 59: {
                    n5 = 41;
                    break;
                }
                case 60: {
                    n5 = 78;
                    break;
                }
                case 61: {
                    n5 = 51;
                    break;
                }
                case 62: {
                    n5 = 126;
                    break;
                }
                case 63: {
                    n5 = 91;
                    break;
                }
                case 64: {
                    n5 = 13;
                    break;
                }
                case 65: {
                    n5 = 71;
                    break;
                }
                case 66: {
                    n5 = 25;
                    break;
                }
                case 67: {
                    n5 = 167;
                    break;
                }
                case 68: {
                    n5 = 187;
                    break;
                }
                case 69: {
                    n5 = 36;
                    break;
                }
                case 70: {
                    n5 = 52;
                    break;
                }
                case 71: {
                    n5 = 99;
                    break;
                }
                case 72: {
                    n5 = 59;
                    break;
                }
                case 73: {
                    n5 = 24;
                    break;
                }
                case 74: {
                    n5 = 47;
                    break;
                }
                case 75: {
                    n5 = 18;
                    break;
                }
                case 76: {
                    n5 = 103;
                    break;
                }
                case 77: {
                    n5 = 55;
                    break;
                }
                case 78: {
                    n5 = 144;
                    break;
                }
                case 79: {
                    n5 = 244;
                    break;
                }
                case 80: {
                    n5 = 172;
                    break;
                }
                case 81: {
                    n5 = 173;
                    break;
                }
                case 82: {
                    n5 = 4;
                    break;
                }
                case 83: {
                    n5 = 64;
                    break;
                }
                case 84: {
                    n5 = 34;
                    break;
                }
                case 85: {
                    n5 = 27;
                    break;
                }
                case 86: {
                    n5 = 117;
                    break;
                }
                case 87: {
                    n5 = 170;
                    break;
                }
                case 88: {
                    n5 = 212;
                    break;
                }
                case 89: {
                    n5 = 100;
                    break;
                }
                case 90: {
                    n5 = 130;
                    break;
                }
                case 91: {
                    n5 = 132;
                    break;
                }
                case 92: {
                    n5 = 88;
                    break;
                }
                case 93: {
                    n5 = 199;
                    break;
                }
                case 94: {
                    n5 = 223;
                    break;
                }
                case 95: {
                    n5 = 171;
                    break;
                }
                case 96: {
                    n5 = 235;
                    break;
                }
                case 97: {
                    n5 = 23;
                    break;
                }
                case 98: {
                    n5 = 207;
                    break;
                }
                case 99: {
                    n5 = 8;
                    break;
                }
                case 100: {
                    n5 = 9;
                    break;
                }
                case 101: {
                    n5 = 229;
                    break;
                }
                case 102: {
                    n5 = 188;
                    break;
                }
                case 103: {
                    n5 = 202;
                    break;
                }
                case 104: {
                    n5 = 87;
                    break;
                }
                case 105: {
                    n5 = 177;
                    break;
                }
                case 106: {
                    n5 = 116;
                    break;
                }
                case 107: {
                    n5 = 191;
                    break;
                }
                case 108: {
                    n5 = 43;
                    break;
                }
                case 109: {
                    n5 = 146;
                    break;
                }
                case 110: {
                    n5 = 247;
                    break;
                }
                case 111: {
                    n5 = 54;
                    break;
                }
                case 112: {
                    n5 = 57;
                    break;
                }
                case 113: {
                    n5 = 206;
                    break;
                }
                case 114: {
                    n5 = 85;
                    break;
                }
                case 115: {
                    n5 = 220;
                    break;
                }
                case 116: {
                    n5 = 249;
                    break;
                }
                case 117: {
                    n5 = 143;
                    break;
                }
                case 118: {
                    n5 = 122;
                    break;
                }
                case 119: {
                    n5 = 246;
                    break;
                }
                case 120: {
                    n5 = 66;
                    break;
                }
                case 121: {
                    n5 = 251;
                    break;
                }
                case 122: {
                    n5 = 242;
                    break;
                }
                case 123: {
                    n5 = 184;
                    break;
                }
                case 124: {
                    n5 = 108;
                    break;
                }
                case 125: {
                    n5 = 48;
                    break;
                }
                case 126: {
                    n5 = 225;
                    break;
                }
                case 127: {
                    n5 = 81;
                    break;
                }
                case 128: {
                    n5 = 50;
                    break;
                }
                case 129: {
                    n5 = 102;
                    break;
                }
                case 130: {
                    n5 = 115;
                    break;
                }
                case 131: {
                    n5 = 77;
                    break;
                }
                case 132: {
                    n5 = 192;
                    break;
                }
                case 133: {
                    n5 = 150;
                    break;
                }
                case 134: {
                    n5 = 243;
                    break;
                }
                case 135: {
                    n5 = 157;
                    break;
                }
                case 136: {
                    n5 = 197;
                    break;
                }
                case 137: {
                    n5 = 98;
                    break;
                }
                case 138: {
                    n5 = 228;
                    break;
                }
                case 139: {
                    n5 = 39;
                    break;
                }
                case 140: {
                    n5 = 147;
                    break;
                }
                case 141: {
                    n5 = 174;
                    break;
                }
                case 142: {
                    n5 = 182;
                    break;
                }
                case 143: {
                    n5 = 26;
                    break;
                }
                case 144: {
                    n5 = 38;
                    break;
                }
                case 145: {
                    n5 = 136;
                    break;
                }
                case 146: {
                    n5 = 40;
                    break;
                }
                case 147: {
                    n5 = 230;
                    break;
                }
                case 148: {
                    n5 = 148;
                    break;
                }
                case 149: {
                    n5 = 252;
                    break;
                }
                case 150: {
                    n5 = 7;
                    break;
                }
                case 151: {
                    n5 = 19;
                    break;
                }
                case 152: {
                    n5 = 193;
                    break;
                }
                case 153: {
                    n5 = 189;
                    break;
                }
                case 154: {
                    n5 = 63;
                    break;
                }
                case 155: {
                    n5 = 105;
                    break;
                }
                case 156: {
                    n5 = 232;
                    break;
                }
                case 157: {
                    n5 = 169;
                    break;
                }
                case 158: {
                    n5 = 118;
                    break;
                }
                case 159: {
                    n5 = 135;
                    break;
                }
                case 160: {
                    n5 = 245;
                    break;
                }
                case 161: {
                    n5 = 181;
                    break;
                }
                case 162: {
                    n5 = 190;
                    break;
                }
                case 163: {
                    n5 = 90;
                    break;
                }
                case 164: {
                    n5 = 213;
                    break;
                }
                case 165: {
                    n5 = 11;
                    break;
                }
                case 166: {
                    n5 = 183;
                    break;
                }
                case 167: {
                    n5 = 180;
                    break;
                }
                case 168: {
                    n5 = 214;
                    break;
                }
                case 169: {
                    n5 = 205;
                    break;
                }
                case 170: {
                    n5 = 123;
                    break;
                }
                case 171: {
                    n5 = 139;
                    break;
                }
                case 172: {
                    n5 = 97;
                    break;
                }
                case 173: {
                    n5 = 131;
                    break;
                }
                case 174: {
                    n5 = 154;
                    break;
                }
                case 175: {
                    n5 = 53;
                    break;
                }
                case 176: {
                    n5 = 198;
                    break;
                }
                case 177: {
                    n5 = 127;
                    break;
                }
                case 178: {
                    n5 = 22;
                    break;
                }
                case 179: {
                    n5 = 149;
                    break;
                }
                case 180: {
                    n5 = 233;
                    break;
                }
                case 181: {
                    n5 = 227;
                    break;
                }
                case 182: {
                    n5 = 248;
                    break;
                }
                case 183: {
                    n5 = 133;
                    break;
                }
                case 184: {
                    n5 = 179;
                    break;
                }
                case 185: {
                    n5 = 67;
                    break;
                }
                case 186: {
                    n5 = 33;
                    break;
                }
                case 187: {
                    n5 = 163;
                    break;
                }
                case 188: {
                    n5 = 166;
                    break;
                }
                case 189: {
                    n5 = 75;
                    break;
                }
                case 190: {
                    n5 = 61;
                    break;
                }
                case 191: {
                    n5 = 138;
                    break;
                }
                case 192: {
                    n5 = 203;
                    break;
                }
                case 193: {
                    n5 = 200;
                    break;
                }
                case 194: {
                    n5 = 92;
                    break;
                }
                case 195: {
                    n5 = 124;
                    break;
                }
                case 196: {
                    n5 = 160;
                    break;
                }
                case 197: {
                    n5 = 104;
                    break;
                }
                case 198: {
                    n5 = 114;
                    break;
                }
                case 199: {
                    n5 = 45;
                    break;
                }
                case 200: {
                    n5 = 111;
                    break;
                }
                case 201: {
                    n5 = 82;
                    break;
                }
                case 202: {
                    n5 = 210;
                    break;
                }
                case 203: {
                    n5 = 89;
                    break;
                }
                case 204: {
                    n5 = 42;
                    break;
                }
                case 205: {
                    n5 = 69;
                    break;
                }
                case 206: {
                    n5 = 151;
                    break;
                }
                case 207: {
                    n5 = 161;
                    break;
                }
                case 208: {
                    n5 = 159;
                    break;
                }
                case 209: {
                    n5 = 186;
                    break;
                }
                case 210: {
                    n5 = 16;
                    break;
                }
                case 211: {
                    n5 = 62;
                    break;
                }
                case 212: {
                    n5 = 68;
                    break;
                }
                case 213: {
                    n5 = 208;
                    break;
                }
                case 214: {
                    n5 = 15;
                    break;
                }
                case 215: {
                    n5 = 137;
                    break;
                }
                case 216: {
                    n5 = 70;
                    break;
                }
                case 217: {
                    n5 = 12;
                    break;
                }
                case 218: {
                    n5 = 76;
                    break;
                }
                case 219: {
                    n5 = 101;
                    break;
                }
                case 220: {
                    n5 = 120;
                    break;
                }
                case 221: {
                    n5 = 162;
                    break;
                }
                case 222: {
                    n5 = 129;
                    break;
                }
                case 223: {
                    n5 = 84;
                    break;
                }
                case 224: {
                    n5 = 106;
                    break;
                }
                case 225: {
                    n5 = 37;
                    break;
                }
                case 226: {
                    n5 = 35;
                    break;
                }
                case 227: {
                    n5 = 93;
                    break;
                }
                case 228: {
                    n5 = 237;
                    break;
                }
                case 229: {
                    n5 = 32;
                    break;
                }
                case 230: {
                    n5 = 222;
                    break;
                }
                case 231: {
                    n5 = 1;
                    break;
                }
                case 232: {
                    n5 = 142;
                    break;
                }
                case 233: {
                    n5 = 254;
                    break;
                }
                case 234: {
                    n5 = 112;
                    break;
                }
                case 235: {
                    n5 = 216;
                    break;
                }
                case 236: {
                    n5 = 56;
                    break;
                }
                case 237: {
                    n5 = 224;
                    break;
                }
                case 238: {
                    n5 = 236;
                    break;
                }
                case 239: {
                    n5 = 0;
                    break;
                }
                case 240: {
                    n5 = 109;
                    break;
                }
                case 241: {
                    n5 = 234;
                    break;
                }
                case 242: {
                    n5 = 241;
                    break;
                }
                case 243: {
                    n5 = 110;
                    break;
                }
                case 244: {
                    n5 = 86;
                    break;
                }
                case 245: {
                    n5 = 128;
                    break;
                }
                case 246: {
                    n5 = 152;
                    break;
                }
                case 247: {
                    n5 = 44;
                    break;
                }
                case 248: {
                    n5 = 79;
                    break;
                }
                case 249: {
                    n5 = 231;
                    break;
                }
                case 250: {
                    n5 = 156;
                    break;
                }
                case 251: {
                    n5 = 250;
                    break;
                }
                case 252: {
                    n5 = 74;
                    break;
                }
                case 253: {
                    n5 = 3;
                    break;
                }
                case 254: {
                    n5 = 255;
                    break;
                }
                default: {
                    n5 = 195;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            PKCS11Ops.g[n3] = new String(cArray).intern();
        }
        return g[n3];
    }
}

