/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.signature;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1IA5String;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1UTF8String;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EATSHashIndex;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ECertificateChoices;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EContentInfo;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EIssuerAndSerialNumber;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EOtherHashAlgAndValue;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ERevocationInfoChoice;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESigPolicyQualifierInfo;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignaturePolicy;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignedData;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignerIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignerInfo;
import tr.gov.tubitak.uekae.esya.api.asn.esya.EESYAOID;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.pkixtsp.ETSTInfo;
import tr.gov.tubitak.uekae.esya.api.asn.profile.TurkishESigProfile;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CMSSignatureException;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CMSSignatureUtil;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CertRevocationInfoFinder;
import tr.gov.tubitak.uekae.esya.api.cmssignature.SignableByteArray;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeUtil;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.IAttribute;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.MessageDigestAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.MimeTypeAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.SignaturePolicyIdentifierAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.SignatureTimeStampAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.provider.CMSSigProviderUtil;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.BaseSignedData;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.ESignatureType;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.SignatureParser;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.c;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.CertificateValidationException;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.DefaultValidationParameters;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.Checker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ProfileRevocationValueMatcherChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.TurkishProfileAttributesChecker;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.OID;
import tr.gov.tubitak.uekae.esya.api.common.crypto.BaseSigner;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.tools.Chronometer;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.HashInfo;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.ArgErrorException;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.ECUtil;
import tr.gov.tubitak.uekae.esya.api.infra.mobile.IMobileSigner;
import tr.gov.tubitak.uekae.esya.api.signature.SignatureRuntimeException;
import tr.gov.tubitak.uekae.esya.api.signature.attribute.SignaturePolicyIdentifier;
import tr.gov.tubitak.uekae.esya.api.signature.attribute.TimestampInfo;
import tr.gov.tubitak.uekae.esya.api.signature.certval.ValidationInfoResolver;
import tr.gov.tubitak.uekae.esya.api.signature.certval.ValidationInfoResolverFromCertStore;
import tr.gov.tubitak.uekae.esya.api.signature.impl.TimestampInfoImp;
import tr.gov.tubitak.uekae.esya.asn.cms.SPUserNotice;
import tr.gov.tubitak.uekae.esya.asn.cms.SignerIdentifier;
import tr.gov.tubitak.uekae.esya.asn.cms.SignerInfo;
import tr.gov.tubitak.uekae.esya.asn.cms._etsi101733Values;
import tr.gov.tubitak.uekae.esya.asn.etsiqc._etsiqcValues;
import tr.gov.tubitak.uekae.esya.asn.x509.Attribute;

public abstract class Signer {
    protected EAttribute mParentCounterSignatureAttribute;
    protected Signer mParent;
    protected boolean mIsCounterSignature;
    protected int mCSIndex = -1;
    protected ESignerInfo mSignerInfo;
    protected ESignatureType mSignatureType;
    protected BaseSignedData mSignedData;
    private static final DigestAlg a;
    private static final Boolean b;
    private static final int c = 1;
    private static final Boolean d;
    static Asn1ObjectIdentifier e;
    static Asn1ObjectIdentifier f;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public static int g;
    private static final String[] h;
    private static final String[] i;

    Signer() {
        try {
            LV.getInstance().checkLD(LV.Urunler.CMSIMZA);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(Signer.a(-10664, -30905) + lE.getMessage(), (Throwable)lE);
        }
    }

    Signer(BaseSignedData baseSignedData) {
        try {
            LV.getInstance().checkLD(LV.Urunler.CMSIMZA);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(Signer.a(-10732, 24524) + lE.getMessage(), (Throwable)lE);
        }
        this.mSignedData = baseSignedData;
        this.mSignerInfo = new ESignerInfo(new SignerInfo());
    }

    public ESignerInfo getSignerInfo() {
        return this.mSignerInfo;
    }

    public BaseSignedData getBaseSignedData() {
        return this.mSignedData;
    }

    public ECertificate getSignerCertificate() {
        List list = this.mSignedData.getSignedData().getCertificates();
        return this.mSignerInfo.getSignerCertificate(list);
    }

    public Pair<SignatureAlg, AlgorithmParams> getSignatureAlg() throws CryptoException {
        EAlgorithmIdentifier eAlgorithmIdentifier = this.mSignerInfo.getSignatureAlgorithm();
        Pair pair = SignatureAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eAlgorithmIdentifier);
        return pair;
    }

    public HashInfo getContentHashInfo() throws ESYAException {
        List list = this.mSignerInfo.getSignedAttribute(MessageDigestAttr.OID);
        if (!list.isEmpty()) {
            EAttribute eAttribute = (EAttribute)list.get(0);
            byte[] byArray = MessageDigestAttr.toMessageDigest(eAttribute).getHash();
            DigestAlg digestAlg = DigestAlg.fromOID((int[])this.mSignerInfo.getDigestAlgorithm().getAlgorithm().value);
            return new HashInfo(digestAlg, byArray);
        }
        return null;
    }

    public void convert(ESignatureType aType, Map<String, Object> aParameters) throws CMSSignatureException {
        this.a(null, aType);
        if (this.a()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv2, new String[0]));
        }
        if (this.b()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv3, new String[0]));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (aParameters != null) {
            hashMap.putAll(aParameters);
        }
        this._convert(aType, this.mIsCounterSignature, hashMap);
        this.c();
        this.mSignatureType = aType;
    }

    private boolean a() {
        Signer signer = this.mParent;
        int n = g;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV2()) {
                return true;
            }
            signer = signer.mParent;
            if (n == 0) continue;
        }
        return false;
    }

    public Calendar getESAv2Time() throws ESYAException {
        Signer signer = this.mParent;
        int n = g;
        Calendar calendar = null;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV2()) {
                List<EAttribute> list = signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV2);
                calendar = SignatureTimeStampAttr.toTime(list.get(0));
                return calendar;
            }
            signer = signer.mParent;
            if (n == 0) continue;
        }
        return calendar;
    }

    public List<TimestampInfo> getAllTimeStamps() throws ESYAException {
        ArrayList<TimestampInfo> arrayList = new ArrayList<TimestampInfo>();
        List<TimestampInfo> list = this.a(AttributeOIDs.id_aa_ets_contentTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_escTimeStamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_signatureTimeStampToken);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_certCRLTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV2);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV3);
        this.a(list, arrayList);
        Collections.sort(arrayList, new c(this));
        return arrayList;
    }

    public List<TimestampInfo> getAllArchiveTimeStamps() throws ESYAException {
        ArrayList<TimestampInfo> arrayList = new ArrayList<TimestampInfo>();
        List<TimestampInfo> list = this.a(AttributeOIDs.id_aa_ets_archiveTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV2);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV3);
        this.a(list, arrayList);
        arrayList.sort(Comparator.comparingLong(timestampInfo -> timestampInfo.getTSTInfo().getTime().getTimeInMillis()));
        return arrayList;
    }

    private void a(List<TimestampInfo> list, List<TimestampInfo> list2) {
        Iterator<TimestampInfo> iterator = list.iterator();
        int n = g;
        while (iterator.hasNext()) {
            TimestampInfo timestampInfo = iterator.next();
            list2.add(timestampInfo);
            if (n == 0) continue;
        }
    }

    private List<TimestampInfo> a(Asn1ObjectIdentifier asn1ObjectIdentifier) throws ESYAException {
        List list = this.mSignerInfo.getUnsignedAttribute(asn1ObjectIdentifier);
        int n = g;
        ArrayList<TimestampInfo> arrayList = new ArrayList<TimestampInfo>(list.size());
        for (EAttribute eAttribute : list) {
            EContentInfo eContentInfo = new EContentInfo(eAttribute.getValue(0));
            ESignedData eSignedData = new ESignedData(eContentInfo.getContent());
            ETSTInfo eTSTInfo = new ETSTInfo(eSignedData.getEncapsulatedContentInfo().getContent());
            TimestampInfoImp timestampInfoImp = new TimestampInfoImp(CMSSigProviderUtil.convertTimestampType(asn1ObjectIdentifier), eSignedData, eTSTInfo);
            arrayList.add((TimestampInfo)timestampInfoImp);
            if (n == 0) continue;
        }
        return arrayList;
    }

    public boolean _checkIfSignerIsESAV3() {
        block4: {
            List list = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV3);
            if (list == null || list.size() <= 0) break block4;
            return true;
        }
        return false;
    }

    public boolean _checkIfSignerIsESAV2() {
        block9: {
            List list;
            block8: {
                List list2 = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestamp);
                list = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV2);
                if (list2 == null || list2.size() <= 0) break block8;
                return true;
            }
            if (list == null || list.size() <= 0) break block9;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _convert(ESignatureType aType, boolean aIsCounterSignature, Map<String, Object> aParameters) throws CMSSignatureException {
        ECertificate eCertificate;
        ESignatureType eSignatureType = SignatureParser.parse(this.mSignerInfo, aIsCounterSignature);
        ArrayList<ECertificate> arrayList = new ArrayList<ECertificate>();
        arrayList.addAll(this.mSignedData.getSignedData().getCertificates());
        Object object = aParameters.get(Signer.a(-10710, 15047));
        ECertificate eCertificate2 = null;
        if (object != null && object instanceof ECertificate) {
            eCertificate2 = (ECertificate)object;
            arrayList.add(eCertificate2);
        }
        if ((eCertificate = this.getSignerCertificate()) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error(Signer.a(-10675, -27173));
            }
            throw new CMSSignatureException(Signer.a(-10738, 3269));
        }
        aParameters.put(Signer.a(-10667, -17589), eCertificate);
        Signer signer = null;
        try {
            signer = ESignatureType.createSigner(aType, this.mSignedData, this.mSignerInfo);
        }
        catch (Exception exception) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error(Signer.a(-10714, -4646), (Throwable)exception);
            }
            throw new CMSSignatureException(Signer.a(-10728, -16759), exception);
        }
        this.a(aIsCounterSignature, eCertificate, null, aParameters);
        signer._convert(eSignatureType, aParameters);
    }

    public boolean remove() throws CMSSignatureException {
        if (this.a()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv2, new String[0]));
        }
        if (this.b()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv3, new String[0]));
        }
        if (!this.mIsCounterSignature) {
            return this.mSignedData.removeSigner(this.mSignerInfo);
        }
        return this.mParent.removeUnSignedAttribute(this.mParentCounterSignatureAttribute);
    }

    private boolean b() throws CMSSignatureException {
        Signer signer = this.mParent;
        Signer signer2 = this;
        int n = g;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV3()) {
                List<EAttribute> list = signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV3);
                EATSHashIndex eATSHashIndex = this.a(list.get(list.size() - 1));
                List<Asn1OctetString> list2 = Arrays.asList(eATSHashIndex.getUnsignedAttrsHashIndex());
                DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eATSHashIndex.gethashIndAlgorithm());
                List list3 = signer.getSignerInfo().getUnsignedAttribute(AttributeOIDs.id_countersignature);
                for (EAttribute eAttribute : list3) {
                    try {
                        ESignerInfo eSignerInfo = new ESignerInfo(eAttribute.getValue(0));
                        if (Arrays.equals(eSignerInfo.getSignature(), signer2.getSignerInfo().getSignature())) {
                            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                            ((Attribute)eAttribute.getObject()).encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
                            Asn1OctetString asn1OctetString = new Asn1OctetString(DigestUtil.digest((DigestAlg)digestAlg, (byte[])asn1DerEncodeBuffer.getMsgCopy()));
                            asn1DerEncodeBuffer.reset();
                            if (list2.contains(asn1OctetString)) {
                                return true;
                            }
                        }
                    }
                    catch (ESYAException eSYAException) {
                        this.logger.error(eSYAException.getMessage(), (Throwable)eSYAException);
                        throw new CMSSignatureException(Signer.a(-10705, 17354), eSYAException);
                    }
                    if (n == 0) continue;
                }
            }
            signer2 = signer;
            signer = signer.mParent;
            if (n == 0) continue;
        }
        return false;
    }

    public Calendar getESAv3Time() throws ESYAException {
        Signer signer = this.mParent;
        Signer signer2 = this;
        Calendar calendar = null;
        int n = g;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV3()) {
                List<EAttribute> list = signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV3);
                EATSHashIndex eATSHashIndex = this.a(list.get(list.size() - 1));
                List<Asn1OctetString> list2 = Arrays.asList(eATSHashIndex.getUnsignedAttrsHashIndex());
                DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eATSHashIndex.gethashIndAlgorithm());
                List list3 = signer.getSignerInfo().getUnsignedAttribute(AttributeOIDs.id_countersignature);
                for (EAttribute eAttribute : list3) {
                    try {
                        ESignerInfo eSignerInfo = new ESignerInfo(eAttribute.getValue(0));
                        if (Arrays.equals(eSignerInfo.getSignature(), signer2.getSignerInfo().getSignature())) {
                            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                            ((Attribute)eAttribute.getObject()).encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
                            Asn1OctetString asn1OctetString = new Asn1OctetString(DigestUtil.digest((DigestAlg)digestAlg, (byte[])asn1DerEncodeBuffer.getMsgCopy()));
                            asn1DerEncodeBuffer.reset();
                            if (list2.contains(asn1OctetString)) {
                                int n2 = this.a(list, eAttribute);
                                calendar = SignatureTimeStampAttr.toTime(list.get(n2));
                                return calendar;
                            }
                        }
                    }
                    catch (ESYAException eSYAException) {
                        this.logger.error(eSYAException.getMessage(), (Throwable)eSYAException);
                        throw new ESYAException(Signer.a(-10691, 10430), (Throwable)eSYAException);
                    }
                    if (n == 0) continue;
                }
            }
            signer2 = signer;
            signer = signer.mParent;
            if (n == 0) continue;
        }
        return calendar;
    }

    private int a(List<EAttribute> list, EAttribute eAttribute) throws CryptoException {
        int n = g;
        for (int i = 0; i < list.size() - 1; ++i) {
            EATSHashIndex eATSHashIndex = this.a(list.get(i));
            List<Asn1OctetString> list2 = Arrays.asList(eATSHashIndex.getUnsignedAttrsHashIndex());
            DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eATSHashIndex.gethashIndAlgorithm());
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            ((Attribute)eAttribute.getObject()).encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
            Asn1OctetString asn1OctetString = new Asn1OctetString(DigestUtil.digest((DigestAlg)digestAlg, (byte[])asn1DerEncodeBuffer.getMsgCopy()));
            asn1DerEncodeBuffer.reset();
            if (!list2.contains(asn1OctetString)) continue;
            return i;
        }
        return list.size() - 1;
    }

    private EATSHashIndex a(EAttribute eAttribute) {
        try {
            EContentInfo eContentInfo = new EContentInfo(eAttribute.getValue(0));
            ESignedData eSignedData = new ESignedData(eContentInfo.getContent());
            EAttribute eAttribute2 = (EAttribute)eSignedData.getSignerInfo(0).getUnsignedAttribute(AttributeOIDs.id_aa_ATSHashIndex).get(0);
            return new EATSHashIndex(eAttribute2.getValue(0));
        }
        catch (ESYAException eSYAException) {
            throw new ESYARuntimeException(Signer.a(-10737, -11187), (Throwable)eSYAException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCounterSigner(ESignatureType aType, ECertificate aCer, BaseSigner aSignerInterface, List<IAttribute> aOptionalAttributes, Map<String, Object> aParameters) throws CertificateValidationException, CMSSignatureException {
        this.a(aCer, aType);
        int n = g;
        if (this.mSignedData.checkIfAnyESAv2Exist() && this.b()) {
            if (!this.logger.isDebugEnabled()) throw new CMSSignatureException(Signer.a(-10729, -12366));
            this.logger.error(Signer.a(-10674, -16845));
            throw new CMSSignatureException(Signer.a(-10729, -12366));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (aParameters != null) {
            hashMap.putAll(aParameters);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Signer.a(-10745, 13807) + aCer + Signer.a(-10748, -21242));
        }
        Signer signer = null;
        SignatureAlg signatureAlg = null;
        try {
            signatureAlg = SignatureAlg.fromName((String)aSignerInterface.getSignatureAlgorithmStr());
            signer = ESignatureType.createSigner(aType, this.mSignedData);
        }
        catch (ArgErrorException argErrorException) {
            throw new CMSSignatureException(Signer.a(-10690, -3421), argErrorException);
        }
        catch (Exception exception) {
            throw new CMSSignatureException(Signer.a(-10731, 12328), exception);
        }
        DigestAlg digestAlg = signatureAlg.getDigestAlg();
        AlgorithmParameterSpec algorithmParameterSpec = aSignerInterface.getAlgorithmParameterSpec();
        digestAlg = CMSSignatureUtil.getDigestAlgFromParameters(digestAlg, algorithmParameterSpec);
        hashMap.put(Signer.a(-10709, 29919), new SignableByteArray(this.mSignerInfo.getSignature()));
        signer.a(true, aCer, aSignerInterface, aOptionalAttributes, hashMap, digestAlg);
        EAttribute eAttribute = new EAttribute(new Attribute());
        eAttribute.setType(AttributeOIDs.id_countersignature);
        eAttribute.addValue(signer.getSignerInfo().getEncoded());
        this.mSignerInfo.addUnsignedAttribute(eAttribute);
        if (digestAlg != null) {
            CMSSignatureUtil.addDigestAlgIfNotExist(this.mSignedData.getSignedData(), digestAlg.toAlgorithmIdentifier());
        }
        this.c();
        if (BaseChecker.d == 0) return;
        g = ++n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCounterSigner(Signer signer) {
        int n = g;
        if (this.checkSignerMessageDigest(signer, this.mSignerInfo.getSignature())) {
            EAttribute eAttribute = new EAttribute(new Attribute());
            eAttribute.setType(AttributeOIDs.id_countersignature);
            eAttribute.addValue(signer.getSignerInfo().getEncoded());
            this.mSignerInfo.addUnsignedAttribute(eAttribute);
            CMSSignatureUtil.addCerIfNotExist(this.mSignedData.getSignedData(), signer.getSignerCertificate());
            EAlgorithmIdentifier eAlgorithmIdentifier = signer.getSignerInfo().getDigestAlgorithm();
            if (eAlgorithmIdentifier != null) {
                CMSSignatureUtil.addDigestAlgIfNotExist(this.mSignedData.getSignedData(), eAlgorithmIdentifier);
            }
            this.c();
            if (n == 0) return;
        }
        this.logger.error(Signer.a(-10699, 13986));
    }

    public boolean checkSignerMessageDigest(Signer aSigner, byte[] aContent) {
        Object object;
        List<EAttribute> list = aSigner.getSignedAttribute(AttributeOIDs.id_messageDigest);
        if (list.isEmpty()) {
            this.logger.error(Signer.a(-10703, 16488));
            return false;
        }
        EAttribute eAttribute = list.get(0);
        Asn1OctetString asn1OctetString = new Asn1OctetString();
        try {
            object = new Asn1DerDecodeBuffer(eAttribute.getValue(0));
            asn1OctetString.decode((Asn1BerDecodeBuffer)object);
        }
        catch (Exception exception) {
            this.logger.error(Signer.a(-10739, -19155), (Throwable)exception);
            return false;
        }
        DigestAlg digestAlg = DigestAlg.fromOID((int[])aSigner.getSignerInfo().getDigestAlgorithm().getAlgorithm().value);
        if (digestAlg == null) {
            this.logger.error(Signer.a(-10695, -17969));
            return false;
        }
        try {
            object = DigestUtil.digest((DigestAlg)digestAlg, (byte[])aContent);
        }
        catch (CryptoException cryptoException) {
            this.logger.error(Signer.a(-10672, -12712), (Throwable)cryptoException);
            return false;
        }
        boolean bl = Arrays.equals(asn1OctetString.value, (byte[])object);
        if (!bl) {
            this.logger.error(Signer.a(-10662, 11554));
            return false;
        }
        this.logger.error(Signer.a(-10666, 30579));
        return true;
    }

    public List<Signer> getCounterSigners() throws CMSSignatureException {
        List list = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_countersignature);
        ArrayList<Signer> arrayList = new ArrayList<Signer>();
        Iterator iterator = list.iterator();
        int n = g;
        while (iterator.hasNext()) {
            EAttribute eAttribute = (EAttribute)iterator.next();
            try {
                for (int i = 0; i < eAttribute.getValueCount(); ++i) {
                    ESignerInfo eSignerInfo = new ESignerInfo(eAttribute.getValue(i));
                    ESignatureType eSignatureType = SignatureParser.parse(eSignerInfo, true);
                    Signer signer = ESignatureType.createSigner(eSignatureType, this.mSignedData, eSignerInfo);
                    signer.setParent(this, eAttribute, i);
                    arrayList.add(signer);
                    if (n == 0) continue;
                    break;
                }
            }
            catch (Exception exception) {
                throw new CMSSignatureException(Signer.a(-10698, 13373), exception);
            }
            if (n == 0) continue;
        }
        return arrayList;
    }

    public ESignatureType getType() {
        return this.mSignatureType;
    }

    protected void setParent(Signer aParent, EAttribute aAttr, int aIndex) {
        this.mParent = aParent;
        this.mParentCounterSignatureAttribute = aAttr;
        this.mCSIndex = aIndex;
        if (this.mParent != null) {
            this.mIsCounterSignature = true;
        }
    }

    public boolean isCounterSignature() {
        return this.mIsCounterSignature;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void a(boolean bl, ECertificate eCertificate, BaseSigner baseSigner, List<IAttribute> list, Map<String, Object> map, DigestAlg digestAlg) throws CMSSignatureException {
        Object object2;
        List<IAttribute> list2;
        HashMap<String, Object> hashMap;
        int n;
        block33: {
            block30: {
                block32: {
                    block31: {
                        n = g;
                        if (bl && this.b(list)) {
                            throw new CMSSignatureException(Signer.a(-10696, -17199));
                        }
                        hashMap = new HashMap<String, Object>();
                        if (map != null) {
                            hashMap.putAll(map);
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(Signer.a(-10727, 11519) + digestAlg);
                        }
                        this.a(bl, eCertificate, digestAlg, hashMap);
                        DigestAlg digestAlg2 = (DigestAlg)hashMap.get(Signer.a(-10717, -399));
                        if (this.mSignatureType == ESignatureType.TYPE_EPES && !this.a(list)) {
                            throw new CMSSignatureException(Signer.a(-10659, 28570));
                        }
                        list2 = this._getMandatorySignedAttributes(bl, digestAlg2);
                        this.mSignerInfo.setVersion(1);
                        if (eCertificate != null || !(baseSigner instanceof IMobileSigner)) break block30;
                        object2 = ((IMobileSigner)baseSigner).getSignerIdentifier();
                        if (object2 == null) {
                            throw new CMSSignatureException(Signer.a(-10718, -18400));
                        }
                        this.mSignerInfo.setSignerIdentifier(object2);
                        DigestAlg object3 = ((IMobileSigner)baseSigner).getDigestAlg();
                        list2 = this._getMandatorySignedAttributes(bl, object3);
                        if (!object3.equals((Object)DigestAlg.SHA1)) break block31;
                        hashMap.put(Signer.a(-10692, -27545), ((IMobileSigner)baseSigner).getSigningCertAttr());
                        if (n == 0) break block32;
                        int n2 = BaseChecker.d;
                        BaseChecker.d = ++n2;
                    }
                    hashMap.put(Signer.a(-10689, 12352), ((IMobileSigner)baseSigner).getSigningCertAttrv2());
                }
                if (n == 0) break block33;
            }
            object2 = new ESignerIdentifier(new SignerIdentifier());
            object2.setIssuerAndSerialNumber(new EIssuerAndSerialNumber(eCertificate));
            this.mSignerInfo.setSignerIdentifier(object2);
        }
        if (list != null) {
            list2.addAll(list);
        }
        this.mSignerInfo.setDigestAlgorithm(digestAlg.toAlgorithmIdentifier());
        for (IAttribute exception : list2) {
            if (exception.isSigned()) {
                exception.setParameters(hashMap);
                exception.setValue();
                this.mSignerInfo.addSignedAttribute(exception.getAttribute());
            }
            if (n == 0) continue;
        }
        this.a(hashMap);
        object2 = null;
        try {
            SignatureAlg signatureAlg = SignatureAlg.fromName((String)baseSigner.getSignatureAlgorithmStr());
            AlgorithmParameterSpec algorithmParameterSpec = baseSigner.getAlgorithmParameterSpec();
            EAlgorithmIdentifier eAlgorithmIdentifier = signatureAlg.toAlgorithmIdentifierFromSpec(algorithmParameterSpec);
            this.mSignerInfo.setSignatureAlgorithm(eAlgorithmIdentifier);
            Chronometer chronometer = new Chronometer(Signer.a(-10704, -10636));
            chronometer.start();
            byte[] byArray = this.mSignerInfo.getSignedAttributes().getEncoded();
            object2 = baseSigner.sign(byArray);
            if (eCertificate == null && baseSigner instanceof IMobileSigner) {
                eCertificate = ((IMobileSigner)baseSigner).getSigningCert();
                hashMap.put(Signer.a(-10749, 5233), eCertificate);
            }
            this.logger.info(chronometer.stopSingleRun());
            this.mSignerInfo.setSignature((byte[])object2);
            ECUtil.checkDigestAlgForECCAlgorithm((ECertificate)eCertificate, (SignatureAlg)signatureAlg);
            CMSSignatureUtil.addCerIfNotExist(this.mSignedData.getSignedData(), eCertificate);
        }
        catch (ArgErrorException argErrorException) {
            throw new CMSSignatureException(Signer.a(-10668, 15991), argErrorException);
        }
        catch (Exception exception) {
            throw new CMSSignatureException(Signer.a(-10720, -4039) + exception.getMessage(), exception);
        }
        this._addUnsignedAttributes(hashMap);
    }

    private boolean a(List<IAttribute> list) {
        Iterator<IAttribute> iterator = list.iterator();
        int n = g;
        while (iterator.hasNext()) {
            IAttribute iAttribute = iterator.next();
            if (iAttribute instanceof SignaturePolicyIdentifierAttr) {
                return true;
            }
            if (n == 0) continue;
        }
        return false;
    }

    private boolean b(List<IAttribute> list) {
        int n = g;
        if (list != null) {
            for (IAttribute iAttribute : list) {
                if (iAttribute instanceof MimeTypeAttr) {
                    return true;
                }
                if (n == 0) continue;
            }
        }
        return false;
    }

    protected CertificateStatusInfo _validateCertificate(ECertificate aCer, Map<String, Object> aParams, Calendar aDate, boolean gelismis) throws CMSSignatureException {
        CertificateStatusInfo certificateStatusInfo;
        block8: {
            CertRevocationInfoFinder certRevocationInfoFinder = new CertRevocationInfoFinder(gelismis);
            certificateStatusInfo = certRevocationInfoFinder.validateCertificate(aCer, aParams, aDate);
            List<CertRevocationInfoFinder.CertRevocationInfo> list = certRevocationInfoFinder.getCertRevRefs(certificateStatusInfo);
            aParams.put(Signer.a(-10742, -29050), list);
            int n = g;
            try {
                boolean bl = Boolean.TRUE.equals(aParams.get(Signer.a(-10680, 19396)));
                if (!this.isTurkishProfile() || bl) break block8;
                ArrayList<BaseChecker> arrayList = new ArrayList<BaseChecker>();
                ProfileRevocationValueMatcherChecker profileRevocationValueMatcherChecker = new ProfileRevocationValueMatcherChecker(certificateStatusInfo, true);
                TurkishProfileAttributesChecker turkishProfileAttributesChecker = new TurkishProfileAttributesChecker(true);
                arrayList.add(profileRevocationValueMatcherChecker);
                arrayList.add(turkishProfileAttributesChecker);
                for (Checker checker : arrayList) {
                    CheckerResult checkerResult = new CheckerResult();
                    checker.setParameters(aParams);
                    boolean bl2 = checker.check(this, checkerResult);
                    if (!bl2) {
                        throw new CMSSignatureException(checkerResult.getCheckResult());
                    }
                    if (n == 0) continue;
                    break;
                }
            }
            catch (Exception exception) {
                this.logger.error(Signer.a(-10730, 6206) + exception.getMessage());
                throw new SignatureRuntimeException((Throwable)exception);
            }
        }
        return certificateStatusInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(boolean bl, ECertificate eCertificate, DigestAlg digestAlg, Map<String, Object> map) {
        int n;
        block87: {
            block86: {
                block85: {
                    block84: {
                        block83: {
                            block82: {
                                block81: {
                                    block80: {
                                        block79: {
                                            block78: {
                                                block77: {
                                                    block76: {
                                                        block74: {
                                                            block75: {
                                                                n = g;
                                                                if (digestAlg != null) {
                                                                    map.put(Signer.a(-10750, -10609), digestAlg);
                                                                    map.put(Signer.a(-10719, -25586), digestAlg);
                                                                }
                                                                if (eCertificate != null) {
                                                                    map.put(Signer.a(-10749, 5233), eCertificate);
                                                                }
                                                                map.put(Signer.a(-10751, -9788), this.mSignedData.getSignedData().getEncapsulatedContentInfo().getContentType());
                                                                if (bl) break block74;
                                                                if (this.mSignedData.a() != null) break block75;
                                                                byte[] byArray = this.mSignedData.getSignedData().getEncapsulatedContentInfo().getContent();
                                                                if (byArray != null) {
                                                                    map.put(Signer.a(-10746, -14527), new SignableByteArray(byArray));
                                                                }
                                                                if (n == 0) break block74;
                                                            }
                                                            map.put(Signer.a(-10709, 29919), this.mSignedData.a());
                                                        }
                                                        if (map.containsKey(Signer.a(-10719, -25586))) break block76;
                                                        map.put(Signer.a(-10719, -25586), a);
                                                        if (!this.logger.isDebugEnabled()) break block77;
                                                        this.logger.debug(Signer.a(-10707, -12091) + digestAlg + Signer.a(-10679, -25033));
                                                        if (n == 0) break block77;
                                                    }
                                                    if (!(map.get(Signer.a(-10719, -25586)) instanceof DigestAlg)) {
                                                        map.put(Signer.a(-10719, -25586), a);
                                                        this.logger.debug(Signer.a(-10725, 17618) + digestAlg + Signer.a(-10744, -19352));
                                                    }
                                                }
                                                if (map.containsKey(Signer.a(-10715, 22015))) break block78;
                                                map.put(Signer.a(-10711, 20337), b);
                                                if (!this.logger.isDebugEnabled()) break block79;
                                                this.logger.debug(Signer.a(-10671, 29297));
                                                if (n == 0) break block79;
                                            }
                                            if (!(map.get(Signer.a(-10711, 20337)) instanceof Boolean)) {
                                                map.put(Signer.a(-10711, 20337), b);
                                                this.logger.debug(Signer.a(-10660, -21276));
                                            }
                                        }
                                        if (!map.containsKey(Signer.a(-10706, 25114))) {
                                            map.put(Signer.a(-10716, -17529), new ValidationInfoResolverFromCertStore());
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug(Signer.a(-10673, 6998));
                                            }
                                        }
                                        ValidationInfoResolver validationInfoResolver = (ValidationInfoResolver)map.get(Signer.a(-10716, -17529));
                                        List list = (List)map.get(Signer.a(-10735, -18127));
                                        List list2 = (List)map.get(Signer.a(-10657, 32741));
                                        List list3 = (List)map.get(Signer.a(-10669, 2259));
                                        if (list != null) {
                                            validationInfoResolver.addCertificates(list);
                                        }
                                        if (list2 != null) {
                                            validationInfoResolver.addCRLs(list2);
                                        }
                                        if (list3 != null) {
                                            validationInfoResolver.addOCSPResponses(list3);
                                        }
                                        if (map.containsKey(Signer.a(-10722, -15267))) break block80;
                                        map.put(Signer.a(-10733, -30661), DefaultValidationParameters.DEFAULT_TRUST_SIGNINGTIMEATTR);
                                        if (!this.logger.isDebugEnabled()) break block81;
                                        this.logger.debug(Signer.a(-10741, 4444));
                                        if (n == 0) break block81;
                                    }
                                    if (!(map.get(Signer.a(-10733, -30661)) instanceof Boolean)) {
                                        map.put(Signer.a(-10733, -30661), DefaultValidationParameters.DEFAULT_TRUST_SIGNINGTIMEATTR);
                                        this.logger.debug(Signer.a(-10701, -4369));
                                    }
                                }
                                if (map.containsKey(Signer.a(-10723, -30712))) break block82;
                                map.put(Signer.a(-10677, 8643), DefaultValidationParameters.DEFAULT_GRACE_PERIOD);
                                if (!this.logger.isDebugEnabled()) break block83;
                                this.logger.debug(Signer.a(-10697, 2875) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                                if (n == 0) break block83;
                            }
                            if (!(map.get(Signer.a(-10677, 8643)) instanceof Long)) {
                                map.put(Signer.a(-10677, 8643), DefaultValidationParameters.DEFAULT_GRACE_PERIOD);
                                this.logger.debug(Signer.a(-10736, -9302) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                            }
                        }
                        if (map.containsKey(Signer.a(-10726, -13533))) break block84;
                        map.put(Signer.a(-10670, 16729), DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE);
                        if (!this.logger.isDebugEnabled()) break block85;
                        this.logger.debug(Signer.a(-10700, 30332) + DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE + ".");
                        if (n == 0) break block85;
                    }
                    if (!(map.get(Signer.a(-10670, 16729)) instanceof Long)) {
                        map.put(Signer.a(-10670, 16729), DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE);
                        this.logger.debug(Signer.a(-10694, 5475) + DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE + ".");
                    }
                }
                if (map.containsKey(Signer.a(-10752, -22134))) break block86;
                map.put(Signer.a(-10678, 10450), DefaultValidationParameters.DEFAULT_IGNORE_GRACE);
                if (!this.logger.isDebugEnabled()) break block87;
                this.logger.debug(Signer.a(-10661, -16422) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                if (n == 0) break block87;
            }
            if (!(map.get(Signer.a(-10678, 10450)) instanceof Boolean)) {
                map.put(Signer.a(-10678, 10450), DefaultValidationParameters.DEFAULT_IGNORE_GRACE);
                this.logger.debug(Signer.a(-10713, 18826) + DefaultValidationParameters.DEFAULT_IGNORE_GRACE + ".");
            }
        }
        if (!map.containsKey(Signer.a(-10712, 29595))) {
            map.put(Signer.a(-10747, 24064), d);
            if (!this.logger.isDebugEnabled()) return;
            this.logger.debug(Signer.a(-10721, -20656));
            if (n == 0) return;
        }
        if (map.get(Signer.a(-10747, 24064)) instanceof Boolean) return;
        map.put(Signer.a(-10747, 24064), d);
        this.logger.debug(Signer.a(-10743, 7070));
    }

    public List<EAttribute> getSignedAttribute(Asn1ObjectIdentifier aOID) {
        return this.mSignerInfo.getSignedAttribute(aOID);
    }

    public List<EAttribute> getUnsignedAttribute(Asn1ObjectIdentifier aOID) {
        return this.mSignerInfo.getUnsignedAttribute(aOID);
    }

    public List<EAttribute> getAttribute(Asn1ObjectIdentifier aOID) {
        List list = this.mSignerInfo.getUnsignedAttribute(aOID);
        List list2 = this.mSignerInfo.getSignedAttribute(aOID);
        list.addAll(list2);
        return list;
    }

    public boolean removeUnSignedAttribute(EAttribute aAttribute) {
        boolean bl = this.mSignerInfo.removeUnSignedAttribute(aAttribute);
        this.c();
        return bl;
    }

    private void c() {
        Signer signer = this.mParent;
        int n = g;
        EAttribute eAttribute = this.mParentCounterSignatureAttribute;
        ESignerInfo eSignerInfo = this.mSignerInfo;
        while (signer != null) {
            eAttribute.setValue(this.mCSIndex, eSignerInfo.getEncoded());
            eAttribute = signer.mParentCounterSignatureAttribute;
            eSignerInfo = signer.mSignerInfo;
            signer = signer.mParent;
            if (n == 0) continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(ECertificate eCertificate, ESignatureType eSignatureType) {
        int n = g;
        try {
            block11: {
                block10: {
                    if (eSignatureType != ESignatureType.TYPE_BES && eSignatureType != ESignatureType.TYPE_EPES) break block10;
                    LV.getInstance().checkLD(LV.Urunler.CMSIMZA);
                    if (n == 0) break block11;
                }
                LV.getInstance().checkLD(LV.Urunler.CMSIMZAGELISMIS);
            }
            boolean bl = LV.getInstance().isTL(LV.Urunler.CMSIMZA);
            if (eCertificate == null) return;
            if (!bl) return;
            if (eCertificate.getSubject().getCommonNameAttribute().toLowerCase().contains(Signer.a(-10676, -17542))) return;
            throw new ESYARuntimeException(Signer.a(-10702, 12146));
        }
        catch (LE lE) {
            throw new ESYARuntimeException(Signer.a(-10664, -30905) + lE.getMessage(), (Throwable)lE);
        }
    }

    public boolean isTurkishProfile() {
        try {
            TurkishESigProfile turkishESigProfile = this.mSignerInfo.getProfile();
            if (turkishESigProfile == null) {
                return false;
            }
        }
        catch (Exception exception) {
            this.logger.warn(Signer.a(-10693, -14385), (Throwable)exception);
            return false;
        }
        return true;
    }

    protected void _addCertRevocationValuesToSignedData(List<CertRevocationInfoFinder.CertRevocationInfo> aList) throws CMSSignatureException {
        this.a(aList, this.mSignedData.getSignedData());
    }

    protected void _addCertRevocationValuesToSignedData(List<ECertificate> aCerts, List<ECRL> aCrls, List<EOCSPResponse> aOCSPResponses) throws CMSSignatureException {
        this.a(aCerts, aCrls, aOCSPResponses, this.mSignedData.getSignedData());
    }

    public List<CertRevocationInfoFinder.CertRevocationInfo> findTSCertificateRevocationValues(EAttribute aTSAttr, Map<String, Object> aParamMap) throws CMSSignatureException {
        return this.a(aTSAttr, aParamMap);
    }

    private List<CertRevocationInfoFinder.CertRevocationInfo> a(EAttribute eAttribute, Map<String, Object> map) throws CMSSignatureException {
        CertificateStatusInfo certificateStatusInfo;
        Calendar calendar = null;
        EContentInfo eContentInfo = null;
        try {
            eContentInfo = new EContentInfo(eAttribute.getValue(0));
        }
        catch (Exception exception) {
            throw new CMSSignatureException(Signer.a(-10663, -12255), exception);
        }
        BaseSignedData baseSignedData = new BaseSignedData(eContentInfo);
        ECertificate eCertificate = baseSignedData.getSignerList().get(0).getSignerCertificate();
        if (eCertificate == null) {
            throw new CMSSignatureException(Signer.a(-10658, 13090));
        }
        calendar = Calendar.getInstance();
        CertRevocationInfoFinder certRevocationInfoFinder = new CertRevocationInfoFinder(true);
        try {
            certificateStatusInfo = certRevocationInfoFinder.validateCertificate(eCertificate, map, calendar);
        }
        catch (CertificateValidationException certificateValidationException) {
            try {
                calendar = SignatureTimeStampAttr.toTime(eAttribute);
            }
            catch (ESYAException eSYAException) {
                this.logger.warn(Signer.a(-10665, 747), (Throwable)eSYAException);
                throw certificateValidationException;
            }
            certRevocationInfoFinder = new CertRevocationInfoFinder(true);
            certificateStatusInfo = certRevocationInfoFinder.validateCertificate(eCertificate, map, calendar);
        }
        return certRevocationInfoFinder.getCertRevRefs(certificateStatusInfo);
    }

    protected void _addTSCertRevocationValues(Map<String, Object> aParameters, Asn1ObjectIdentifier aTSOID, boolean intoTimestamp) throws CMSSignatureException {
        List list = this.mSignerInfo.getUnsignedAttribute(aTSOID);
        if (list.isEmpty()) {
            list = this.mSignerInfo.getSignedAttribute(aTSOID);
            if (list.isEmpty()) {
                throw new CMSSignatureException(Signer.a(-10740, 8960) + aTSOID);
            }
        }
        this._addTSCertRevocationValues((EAttribute)list.get(list.size() - 1), aParameters, intoTimestamp);
    }

    protected void _addTSCertRevocationValues(EAttribute aTSAttr, Map<String, Object> aParamMap, boolean intoTimestamp) throws CMSSignatureException {
        block5: {
            List<CertRevocationInfoFinder.CertRevocationInfo> list;
            block4: {
                list = this.a(aTSAttr, aParamMap);
                int n = g;
                if (!intoTimestamp) break block4;
                this.b(list, aTSAttr);
                if (n == 0) break block5;
            }
            this._addCertRevocationValuesToSignedData(list);
        }
    }

    private void b(List<CertRevocationInfoFinder.CertRevocationInfo> list, EAttribute eAttribute) throws CMSSignatureException {
        EContentInfo eContentInfo = null;
        ESignedData eSignedData = null;
        try {
            eContentInfo = new EContentInfo(eAttribute.getValue(0));
            eSignedData = new ESignedData(eContentInfo.getContent());
        }
        catch (Exception exception) {
            throw new CMSSignatureException(Signer.a(-10724, 5167), exception);
        }
        this.a(list, eSignedData);
        eContentInfo.setContent(eSignedData.getEncoded());
        eAttribute.setValue(0, eContentInfo.getEncoded());
    }

    private void a(List<CertRevocationInfoFinder.CertRevocationInfo> list, ESignedData eSignedData) throws CMSSignatureException {
        List<ECertificate> list2 = AttributeUtil.getCertificates(list);
        List<ECRL> list3 = AttributeUtil.getCRLs(list);
        List<EOCSPResponse> list4 = AttributeUtil.getOCSPResponses(list);
        this.a(list2, list3, list4, eSignedData);
    }

    /*
     * WARNING - void declaration
     */
    private void a(List<ECertificate> list, List<ECRL> list2, List<EOCSPResponse> list3, ESignedData eSignedData) throws CMSSignatureException {
        List<Object> list4 = new ArrayList();
        int n = g;
        if (eSignedData.getCertificateSet() != null) {
            list4 = Arrays.asList(eSignedData.getCertificateSet().getCertificates());
        }
        for (ECertificate object2 : list) {
            if (!list4.contains(object2)) {
                eSignedData.addCertificateChoices(new ECertificateChoices(object2));
            }
            if (n == 0) continue;
        }
        Object object3 = new ArrayList();
        if (eSignedData.getRevocationInfoChoices() != null) {
            object3 = eSignedData.getRevocationInfoChoices().getCRLs();
        }
        for (ECRL eCRL : list2) {
            if (!object3.contains(eCRL)) {
                eSignedData.addRevocationInfoChoice(new ERevocationInfoChoice(eCRL));
            }
            if (n == 0) continue;
        }
        ArrayList arrayList = new ArrayList();
        if (eSignedData.getRevocationInfoChoices() != null) {
            List list5 = eSignedData.getOSCPResponses();
        }
        for (EOCSPResponse eOCSPResponse : list3) {
            void var8_12;
            if (!var8_12.contains(eOCSPResponse)) {
                eSignedData.addRevocationInfoChoice(new ERevocationInfoChoice(eOCSPResponse));
            }
            if (n == 0) continue;
        }
    }

    private void a(Map<String, Object> map) throws CMSSignatureException {
        Asn1ObjectIdentifier asn1ObjectIdentifier = AttributeOIDs.id_aa_ets_contentTimestamp;
        if (this.mSignerInfo.getSignedAttribute(asn1ObjectIdentifier).size() > 0) {
            this._addTSCertRevocationValues(map, asn1ObjectIdentifier, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignaturePolicyIdentifier getSignaturePolicy() {
        int n = g;
        if (this.getType() == ESignatureType.TYPE_BES) {
            return null;
        }
        ESignaturePolicy eSignaturePolicy = null;
        try {
            eSignaturePolicy = this.getSignerInfo().getPolicyAttr();
        }
        catch (Exception exception) {
            this.logger.warn(Signer.a(-10734, -18644), (Throwable)exception);
            throw new SignatureRuntimeException();
        }
        if (eSignaturePolicy == null) {
            return null;
        }
        OID oID = new OID(eSignaturePolicy.getSignaturePolicyId().getPolicyObjectIdentifier().value);
        EOtherHashAlgAndValue eOtherHashAlgAndValue = eSignaturePolicy.getSignaturePolicyId().getHashInfo();
        SignaturePolicyIdentifier signaturePolicyIdentifier = eSignaturePolicy.getSignaturePolicyId().getPolicyQualifiers();
        String string = null;
        String string2 = null;
        SignaturePolicyIdentifier signaturePolicyIdentifier2 = signaturePolicyIdentifier;
        int n2 = ((ESigPolicyQualifierInfo[])signaturePolicyIdentifier2).length;
        int n3 = 0;
        do {
            block13: {
                ESigPolicyQualifierInfo eSigPolicyQualifierInfo;
                block14: {
                    Asn1IA5String asn1IA5String;
                    block12: {
                        if (n3 >= n2) return new SignaturePolicyIdentifier(oID, DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eOtherHashAlgAndValue.getHashAlg()), eOtherHashAlgAndValue.getHashValue(), string, string2);
                        eSigPolicyQualifierInfo = signaturePolicyIdentifier2[n3];
                        if (!Arrays.equals(eSigPolicyQualifierInfo.getObjectIdentifier().getValue(), _etsi101733Values.id_spq_ets_uri)) break block12;
                        asn1IA5String = new Asn1IA5String();
                        eSigPolicyQualifierInfo.decodeQualifier((Asn1Type)asn1IA5String);
                        string = asn1IA5String.value;
                        if (n == 0) break block13;
                    }
                    if (!Arrays.equals(eSigPolicyQualifierInfo.getObjectIdentifier().getValue(), _etsi101733Values.id_spq_ets_unotice)) break block14;
                    asn1IA5String = new SPUserNotice();
                    eSigPolicyQualifierInfo.decodeQualifier((Asn1Type)asn1IA5String);
                    string2 = ((Asn1UTF8String)asn1IA5String.explicitText.getElement()).value;
                    if (n == 0) break block13;
                }
                this.logger.warn(Signer.a(-10708, 642) + eSigPolicyQualifierInfo.getObjectIdentifier());
            }
            ++n3;
        } while (n == 0);
        return new SignaturePolicyIdentifier(oID, DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eOtherHashAlgAndValue.getHashAlg()), eOtherHashAlgAndValue.getHashValue(), string, string2);
    }

    protected abstract List<IAttribute> _getMandatorySignedAttributes(boolean var1, DigestAlg var2);

    protected abstract void _addUnsignedAttributes(Map<String, Object> var1) throws CMSSignatureException;

    protected abstract void _convert(ESignatureType var1, Map<String, Object> var2) throws CMSSignatureException;

    public abstract Calendar getTime() throws ESYAException;

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[88];
                var3_1 = 0;
                var2_2 = "!\u00de\u00cb\u008f\u0096\u001f\u00f3B\u00c0\u0001\u007f\u00e5\u0000\u00bc\u0082ZKW\u00be3\u00d2AW\u0010\n\u00bf+[D7\u00c3\u00cb k\u00bcr\u0012\u00c3\u00b1?\"\u00ff\u00ce\u00e8c2\u00eeP\"\u00bb.\u009e\u009b\u00f0\u00d6t\u007f*$a\u008b\u0097\u00f2\u00d5P\u0094\u0088\u00fb\u00ac\u007f\u000f\"\u00bdN\u00eb\u00da\u00a1\u00a3\u00a61\u0014u\u0010\u001a\u0085\u00f0\t\u0091~\u00a5\u00dc\u00f2\u0090\u00c0\u00fa&8\u00c1\u00b3\u00ed\nP\u00da\u00c2_\u00baK\u009c[}\u0018#\u0003\u001c\u0096|6'\u0085h\u0087\u00e5;\u00d0t\u00c2\u008f\u00e0\u0002\u00c7[\u00b8Fj\u0005s\u00afc\u001e<\u00a2\u00e1(\u0014uI\u008a!\u00eaJq\u0016p\u001f,\u009c\u00c3\u0097l\u00e1%\u00a8xV\u00fb\\\u00b6\u00c8\u00aex\u008f\u00d9\\\u00d0\u0002\u00fa.\u0016`\u00a2\u0002\u00a4\u00a6\u00b6Z\u0094t\u00d7\u00a2\n{U\u00fe\u001f6e T\u0096dV\u00dfc\u00bf\u00fa*\u00d7\u008c\u0085\u0018\u0080\u00fc\u0010\u0005\u00cf\u00f0\u00e5\u00d7i>\u009f\"\u00e8\u0015\u00a1\u00c1S\u008f\u007fhdZ\u0003\u0091\u00ce\u001ciB\u00f2O\u00ca\t?\u008d\u0098\u00e4\u0010\u00a75\u0098r\u0017\u00b3w\u009f\u00ad\u00c9\u00b8ox\u0088\u0015\u00ca=\u00f9\u0093\u0011I#\u001f\u00f0\u0000Z4/\u000eU\u00b8PTU\u0097{\u008f:\u00e7\u00ea\u00e9L\u00e4\u0016\u0007S\u0090\u00ee\u0010&\u0083Z\u00a5L\u000by\u00act\u00f7\u0081\u00d19\u00dd\u00da\u0015\u001c\u0017\u00d4ts\u00cdT\u00b4\u00dc\u00f9\u00fe%\u0004; S*QD\u001c\u001c`\u00c78\u009c\u001b\u00fc=\u00b7!\u0012\u00af\u009c\u007f\u0099B\u00f2\u0019q\u00a6\u0090l\u00ab\u0002.\u00d1\u0000\u00bbV\u00e5\u00cb\u001d\u0093\u0016\u001e\u00eb7\"~\u00d1\u001b\u00ac\u00a7D\u00d7\u00c8\u00c5]\u00e0\u00db\u00d2\u0013\u00ca[\u0088\u00efH\u0018*nL\u00a7\u00ea\u00a2\u00ce%\u00d8\u00ef\u00f1\u0097\u00b7F\u00ef'\u00fc\u0002\u00fd;\n\u00ca\u00aa\u00d0\u00b5t\u00ff+\u009fk\u0002\u0099\u0010\u00a3a\u00ca=\u00ae\u00f3\u0010Lj\u00eb\u0006\u0003T\u008d\u00ed!\u00b3-\u00888#G\u009c\b\u00d0\u00f3\u008f\u00be\u00a9\u0089\u00b9\u00b8\u00d3\u00cf\u00d5\u008a\u00f8cN\u00f6I|\u00e1\u00f31T\u008d\u00f9\u0016\u00b3\u00bb\u00b9\u00c0\u001c'\u008e\u00dewt\\\u00ca\u0019\u0094h\u00f2\u00a2\u00ec\u0010\u0006\u00c2\u00a3\u00c6\u008fig\u0080\u00a7\u00e9\u00e5\u007fq\u0092R\u0096l\u00ad\u00bc\u00e4\u0087nZ\u0012\u00d0\u00ee0\u00ecf\u00c4&\u00c0\u00e8\u00a8\u00e1\u00d5\u001a\u009c\u00b3\u00db!9\u00b10\u00da\u00fb\u00b2\u0099\u00c1$/\\\u009d}LK?,\u00ffk{\u001d\u0096\u001b\u000f\u00af\u0083u]\u00cc\u00c2\u00b33y\u0082\u00e3\u00ab\u00d4\u00e0_2k\u008c\u0003\u00ac\u0080\u0018\u00cd\u0080\u00c1\u00e6\u00c78PD\u0086\u00bf8<k\u0094\u00b5\u0093\u000e\u0081\u001a+\u0003H\u001d\u00c4\u001b\u008fU\u00a0*\u00d6=\u00a4\u00d87\u0094\u00b5\u00f2e\u00f3RW\u0014\nn+_HL\u00c3K\u00a3:]2\u00a2\u00af\u0017\u00cf\u00ef\u00af\u0092\u0090H\u00c9\u0096\u0099\u00e6\u001d\u00e7\u00a2\u00ca\u00c0\u00ba\\c\u00efu0ZL\u009a\u00d1\u0093i{\u0014\u00c0*F\u00c9\\\u00d7\u00ed\u001e\u00c9\u008b\u00b8\u007f*\u0003\r\u00be\u00ff\u0081wr3\u00bc\u0095x\u00d1\u00a34\u00a3Mt\u00deH\u00dae\u00cd9\u00a2\u00bd\u0099\u00f5/2/E\u009d\u00170)\u00f6\n\u00ca\u00c6\u00fa\u00e5\u001eHC\u00ca\u00e5\u0082\u001d\u00e9|\u00c3\u00db\u00b0\u0084\u00ba\u0001\u0096\nV\u008f\u00a0\u008d\u00a2\u00a8\u00fd\u0012\u00d1\u00e3\u00b8Unc\u0091\u0016\u0089\u00a9\fo\u00e5\u0017W\u00b2\u008b0\r.\u00d1\u000e\u001e\u00c9xW#\u00b5:ke\u0012\u00eaFI\u00db\u0081\u00ef\u00ec\u00beiA\u00e4k\u00e4\f\u00c6Wu\u0001'\u00c0\u008aQ\u00f4J\u0090\u00b8\u00e6GL\u008b7`\u0011X\u00e7\t\u00a8C\u00c1\u009d\u0010A\u00f3\u00d4F]\u00ec;C\u00b6\u00e0\u0087\u0006\u00c6T)\u00ceT\u00a2TJ6\u00f3\u00cfz42\u009d\n\u008b\u0092\u009es\u0013l\u0015\u009c;\u00f4\u00ce\u0010\u0095=\u00bf\u0080\u001a\u00bdb,y\u00f0\u000e'\u00deN\u008bP\u00f6t\u0096h\u0089\u00ff>\u00c0\u00dd,\u00bf\u0011\u008f\u00d4\u000e~w\u008a\u00f6\u00bfZ\u0087\u00a3L\u0082\u00dc$\u00aa\u0016\u0090\u00d5KlY]s\u00fb\u00b6F2\u00c9\u00c3N\u00ae\u00dd\u00ca\u0003\u0087M\u00d2\u00b1\u0096e\u0084%%6\u001dI\u00fc\u00be\u008b\u00a1\u00d8\u008a\u0003\u00b5\u00baf\u0097\u0001n\u00ad\u00a6YbXJS-]\u00a8\u0081\u00be@q\u00a30y$\u00ca\u00d3'\u001b\u00db\u00da\u00f4\u0004\t\u0094y;{x\u00a23\u0081\u00c4u2\u0084\u00d6.\u009a\u00f1\"\u009c\u0080\u0001\u009a\n\u00f81\u00b9\u008d+\u00b6\u0013y\u00e1/\u0015\u001f\u00ae\u008e\u00a5U\u00b6QW\u00b4?\u0091X\u00c8\u00c0\u0015\u00f89\u00b3Ues\r\u00c7M/?\u008e\u0005AK\u009ab\u0015\u00ce\u00047\u00d8)s>\u00ae\b\u00eaH\u001d6\u00e7\u009e\u008c\u001d\u00f93\u0006\u00b7\u0012\u0095\u00b1KnS\u00aeke\u00e3\u00d4!\u0005\u00e8\u00a0\u00fb\u00b0\u00b0 \u000e%?Z\u00b9\u009f\u0083\u00cc\u00e9\u00c8\u00026\u001c\u000eI\u000e\u0097\u00db\u0006-_\u0003\u00c3\u008a\u00d7\u001c\u00b9\u00dc*J&?7^\u00af\u00d5u\u00cfN~c4\u00f7.\u00d2%\u00f9\u000ew\\rg\u000b\u009b\u00c3|\u0088\u00b4Q\u00ca^\u0093\u00a7\u00e6\u00c9\t\u00e0*\u00be\t\u00dd6E\u0098|\u00a7\u00b0mG\"@\u00cb\u00e3)\u001dC\u00df@\u008b\u00c3Up\u0011`\u000eS\u009f\u00b7\u00d1\u0089|5\u009b\u00b5\u00db\"\u00a7\u0007\u0000v\u00c9\u008dA\u00d0\u001a\u0012/\u00e0X\u00ab\u00b8\u00a0\u00df\u007f]D\u00b2\u008e\u0082U4\u00a4\u00bfnk\u00e1)\u008a\u00e8\u001a}\u0011!m\f+e\u00eerWDGI\u00a9\"\u0096g\u00d4\u00dag5\u0099\u00fa\u00d3Sa\u001d\u0016\u0015\u0083Ec0\u00dd\u0090\u0016l\u001c2>)-Z\u00ee\u00a2@\u0093K\u0086\u00ff\u0019\u00bc[\u00f6N,\u00dc\u00f1\u001b4\u008a\u0096\r\u001b\u00b7\u00bc\u00e5\u00b4\u00a3Kp\u00c7\u00eeE\u00b7\u0004\u00d7\u00dc\u00b1\u00b6n\u00c5g\u00d5p\u0014\u009f\u0081\u00a4\u0081z\u00d4O#\u00e7n\u00ba\u0081\u0006\u0092i\u00cf:,\u00fa\u00c10t\u00fc\u0085\u0097\u0091\u00dbV\u009fu\u000f\u0012\u0081CY\u0086@\u0018Yw\u0092a\r\u00bb\u00b5#\u0016\u00a9\u00e9}\u0090\u001a7<D\u0097s\u0004^\u00e0\u00f7\u00178YtE\n\u00f9\u00ba\u009f\u00d4(#\b\u0085~\u00c5U\u000e|>\u0080[G'a EbL)\u00c1\u00c3c\u008acnxE\u00ad+\u00d0\u009f&\u00e2br#\u0002\u009aK\u00d4J\u0098y\u008e\u0016)p#\u00aa\u00d7\u00a5\u00a4\u00a3=\u00cf\u008b\u008b()\u00caMNu\u0093\u0002*\u008f-\u00eae\u0092\u0093\u001b2\\\u0002\u00c57\u00bf~\u00ca!\u008e \u00d8Q\u00a2\u00a5\u000f%$%\u00d2_W\u0012\u00861 %\u00ab-S\u00a6>\u008aK\u00c5\u0087\u00de\u0014\u00b7\u00c1w\u000b\u00a7H\u00f4\u000b\u00e6\u0097#\u0016\u00ca\u008cP\f\u00d2\u0099E\u0096H\u00a5\u00a2\u00e1\u00ec[\u00a1\u00c8\u0090\u0094\u00b1\u0081\u0016\u00a5\u00e8\u00df\u0005\u0012\u0082\u0012\u00c9%\u009c9\u001cx\u0014\u001b\u00c7\u00dd\u000eV\u0097\u0015\u00b2\u00c1 6+*-\u008f\u00e6-\u00b8\u0017\u00d6\u009e\u00d9\u0095\u00c4\u00cd\u0007^\u0004d\u00c2\u00b3!\u009d\u00cfC\u00a7\u007f]T\u0087\u00f8\u00a9G\u00fa\u0080H\u00ccS52i.6\u0005\t\u009fh\u00b322\b1\u0006\u00be\u00fdX\u00ff\u0093\u00161\u00f8+I\nL[R\u00f4\u00ea\u00aasno\u00fby\u009ck\u00a7\t\u00ed\u00ecI\u00d7\u00f8\u00a2\u00df\u0007\u00f2\u00d9\u00f1\u0092r\u00ac\u00c4Z\u007f\u00fb@\u0093cj\u0094v\u00e7cl0dE\u00b6\u00a5\u0080\u00dbuau\u00b3\u000eB\u00efs\u00fcX\u000b\u00e8%)\u00c0<\u00cca\u00bb\u00bf?v\u00e9\u00e5\u00c7 \u00f3[\u0019\u00d5sn\u0013\u0082\u0082WR\u00e9\u00a4\u001c\u00e4\u00d9x\u0003\u00f4\u00a0\u0001\u00b1E\u00b2x\u00aa4m\u0087\u009a\u001e\u00c1'}\u00a8&\u009f\u00ad\b\u001d&k\u000f\u00dd\u00fa7\u00b3Z\u0002\u001e\u00f2\u00fa\u00c2\u00d0\u0080h\u00d0cV\u00b4\u00c0\u00f0\u0000\u009b~\u009d\u001f\u0003\u00dc\u00faP\u008f,\u007f\u0093\u0011\u00f2w\u0086\u0091t$\u001c\u001e9\u0007\u0001\u00b3,\u00efL^\f\u0081\u009f\u00d8\u00ac\u00df8\u00d2\u008a\u000b\u00b1\u00de\u009d\u00fa\u0015\u0087\u00ae\u00e3\u00b4X\u00b7\u00c9(\u00a0-\u0013\u0093\u00db\u00fd$(\u0090T\u00b1\u00e0bDy>\u00f1\u008dKQ\u00cbD\u001c%*\u00f0Z\u00d3w\u00afL\u00b0#<\u00f49\u00de\u0013\u00a8\u00d5\u0089\u0083\u00e4\u00d3\u00a4\u00c8\u00cd\u000b\u001f%Z+\u0014\u00f2\u0098\u0018y\u009e\u00a0E\u00f1\u00cc\u00c4\u00da\u00c7F)\u00b5p\u00a0\u00a3\u0001e\u00f9#k\u00c6\u00c4E\u008f}L\u00eb\u00e6187\u009e\u009cp\u00a3\tL&\u001d$\u00d3>\u00d1U+\u00e9\u00032\u00ebW\u00d1J)\u001b\u00e1\u00f0$^\u00ca\u0092\u0007\u009e\u0081\u00d3\u00d6XIC\u00a8f>6[\u001eg\u0010N\u00ca\u00b5T\u009c!\u00e6\u0082\u0086\b\u000f\u00b7\u0092\u00f2\u001a=z\b\u00fdE-e\u00ea\u00ca#,\u00d3\"\u001e\u00bd\u0007\u000e\u00a9\u00df\u00b5\u008eVv`\u0011\u0097\u008a\u00de\u00b1l\u0094I\u0000\u00a3*\u00df5]\r\u00b2\u00a7\u0082p4m\u00ad\u00ca\\\u0007\u00a8E\u007f\rKjMB\u0012\u00cbew\u0082l90'\u009c)\u00cf/\u00a5\u00f6h&\u009f\u00813c\u00f4}\u00de\u00020\u00c9\u00e6W\u0095O\u00d2\u00e7\u00aa\u001aw\u00cd\u00ac\u0086\u00d0\u00fc\u00ea\u00b0I\u0087\u009c\u0019\u0015\u00c5Z*\u00a5\u00c1\u00e7\u0093\u00b6\u00a6\u00c8J]\u00e2\"l\u00bc\u008d\u00e0w\u001d\u00825\u00ce\u00a0-og\u00f3\u00f2\u00d5\u00f6\u0092\u00c7\u00cf\u00ff-[\u008c\u008e)a\u00e4\u00f3\u009b\u00ea\u0093;\u00de\u0018\t\u001c\u00e4}\u00c2{\u00ecP\u0004[\u001e\u009ax\u00abF}\u0098\u00de\u00b9j\u001b\u00deD`\u000b+oKo\u0000G\f\u0098\u00d0\u00a5',oY\u009b\u00ef%\u00ce\u00c12h'k\u0098EccHs\u00be\u00eag\u00e4\u0093\u0010\u000eeC\u0089\u0001yt\u00d2j{\u00a7\u00c0\u00ad@z`T\u00ccE\"\u00a8\u00ed\u00fe\u00ed\u00be\u00db\u00abS\u0005\u00a1\u0084<+\u00e9Ibw\u0091\u00ccM\u00df\u00ad\u00ef\u00a6U@vK:\u00ff\u008e\u00bc\u00a9\u00f6H|\u00a2\u00f7\u00a2\u0001\u00b0\u008eX\u00d8\u0096\u00c3\u00cag\u00fc\f\u00e8*H\u00fdn\u0083n\u00d4@9\u001b\u0007\u00f6\u00ca\u00b5A_\n\u00bb\u00d8\u0010\u00be\u009fX\u00ac\u009c\u0081\u00d6\u008e,<\u00d3X:h1\u0003\t\u008ci[n\u00b7\u00a9D\u00f4\u00f4\u009d\u00d8Ld\u0016k&\u00c2\u0086g\u001ax\u00cd\u00e4\u00e9\u00fd[\u00c3C\b\u00af5j\u0019~\u00d0\u00015T\u00e3=\u00ca\f\u00c4\u0096\u00bd\u00ad4\u0015uM\u00faF\u00b1\u00e9\u0097\u0083\u00bb\u0017\u00b2\rV#\u0007\u007f\u00fc8F\u0002\u00efM\u00c5I\u0005C\fI\u00ddb\u0096\u0014\u00c1(U\u009e\u0006\u00a1\u00d3\u00fb\u00c6\u001f\u00d9\u009c\u00c3,\u001d/\u0014b\u0082\u001bG\u009e\u009b\u00bb\u00ab\u00e5d\f\u00b7-A\u00ff\u00ec?\u00bb(\u00c1\u009e>\u00b1\u00bd\u0012\u0090\u0093^\u00c5\u0089\u0016\u00ce\u001e6\u0097)\u001c\u0004\">\r\u00a0d\u00fb\u008c\u00fd\\\u00a4\u0097C+mB\u0019W\u00bf\u008b\u00b9\u0082\u0015%\u00e2r\u001a\u00ba\u00de\u00d9\u0003w\u0099%L7\u0087\u00eck\u00da\u00e2*\u0016\u007f\u0080\u0000D\u00eff\u00dcm%\u00e4\u00c3Y\u0097+p\u00a8\u0015\tu\u00f8\u00ab8\u0019\u0087cE\u0085;\u00e7@2\u00b6> 8\u00e0\u00af_y\u00dc\u00c7P\u0094\u0015Vi\u00a0#HVv\u00a7\u00c7\u009e\u009b\u0085\u00e0\u00cf\brP\u00dd\u0014\u00f5\u00c0\u00bfS\u001d\u0000U\u0094\u0007yi\u00cfC\u00b0\u00cdv\u00b7?\u0002\u00b7\u00d0\u0095\u00a4\u00a3c \u00a96]\u00a4\u00e0\u00ea\u0088\u00b0v\u0088\u00d5\u00d8\u00ff\u007fZU\u00e8\u00a4\u0014j\u001f\u0000\u009a^\u00dfB\u001f\u0090La\u00cb\u001e\u0018C(\u00d1\u008ae\u00c6\u00b8\u008e\u00baW\u00d1\u0097\u00ab\u00ad\u00e4\u001cu\u008cI\u00bd\u0089\u0003\u00f1\u0019%[\u00dc\u0080\u00cbq\u001fR\u00cb:\u00b2cI\u00db\u00ad\u00cb\f\u0006\r\u00bc\u00c6\u0015\u00fd\u00cb\u00f7-\u0003AA\u00c2\u0087\u0001\u00a8\u00ef}\u00e6o\u0013\u001aH\u00e9\u00e2m=\u00cb\u00dbQ\u000b\u00edU\"\u0015wQ \u0005p\u00e5\u00b9\n\u009c\u00dc\u0084\u00be\u00efE\u0019\u008b\u00d92d[]\u0016\u00fe\u00d4r\u008f_(dQ.\u0083Xg\u00deQ\u009fE\u00bfL\u00e6\u0010\u00a6\u00a1\u00e43\u00a4a\u0000\u00ccp#\u00a5\u00f6\u00a5\u009d\u00d2\u00bc\u00d1\u0086\u0096p\u00c1\\\u00fc\u0018\u0087C\u00be1\u0089\u00eaP]\u00ec\u0089\u000ey@!#\u00de\u00f8\u001a\u007f\u00c5\u00a3<=|g\u001fHn\u00aa\u00de<U\u00c4\u00ea\u00a9\u0086<\u00fc\u0006,S\n\tGL\u007fy\u0097\u00d9\r\u00df\u000f\u00b5\u00e8+\u00c5}\u00a7\n\u00146)\u0093\u009d\u0015\u008f\u0005X\u00b8\u00135\u00b0x\u009c\u001891\u00b7\u00d3\u00b6\u000f\u00a9;p\u00cb\t\u00f9\u0095\u0082\u00c9\u00d8Ax\u00ae.\u00e7\u008a\u0013\u00c9\u00a7^\u00bci\u00d6S\u0088W\u00c8v\u00db\u008b\u000f\u0081\u00fdanhx\u0002xz\u001b^\u00d9\u009a\u00bb\u0091\u000fL\u009e*\\\u0016\u00eb\u0011\u00d0\u00dc3\u00c5\u0086T\u00ba\u0018z\u00a4\u0085Vk\u0099\u000et\u0083z/\u00d7p.\u0098\u0001\u00c2\u0003\u000fAW1\u00f8\u00b6KRk\u00b1\u00ec\u00a8H\u0012\u00b1\u00b2\r\u0016\u00fd\u00b6u\u00ba:j\u0092\u009e\u0017\u007f\u00ca\u00af\u00f6{\u009cP\u00d607\u00e0\u001f%6\u00d0)\u00cf\u00b4I\b\u00e0U\u0004gQ,>y;`\u00cbpr\u00ae\u00cd\u000e\u0000\u00de\u00fc\u00e7H\u001f6<\u00eb\u0088'H\u00bcR\u00df\u00d2\u00d3W\u00e6\u0015\u00f6\u00d6X\u000f\u00bdQ\u00e0\u00e8\u0011o\u00ab#6\u0001\u0088\u00f1_\r\u0090\u001a)\u00aeD\u00cd\u00f3c\u00ae\u00aa\u000b:\u008c\u00eb_h\u00bc\t|q\u00eeH\u00a1!D\u00ef\u00ac\u00e2\"\u00d8\u00f4\u00a2\u00e1\u00d8@|\u008a\u00aa8\u001dS^\u008e\u00ea;\u00f2>\u0006\b\u00a8\u001a\u00d5\u008c\u00fa\u00eb\u00ab7\u00a4\u00beT\u0084\u0083\u00a9\u00df\u009c\u00b7m|bh\u00fc\u00a2s?v\u001f\u00f5\u0096\u0013Q\u0004\u0094\u0098v\u00c9\u001e\u00f9\u000e\u00a3L\u001fqS\u00d2\u00aa|s\u007f&\u00ad\u0088\u0089\u00d2\u0011\u00ce\u00f8\f\u0088\u0080|\u00e80i\u00ba\u00aa\u0017mf\u00b3E\u0018>&3\u009b\u00fe\u00e6\u000bJ\u00a5\u0098\u009bU\u00c0,we\u00f8B\u0013x\u008b\u00f3[\u00f3\"\u0089\u00fc\u00d8\u00c18\u009dm\u0016\t\t\u0005.\u001bFD\u00c6\u00a6Z\u00bd\u00f6\u00b7D;\u00d4m\u00c6\u00be\u0004/\u0012\u00a0\u0082G\u00c2lI'\u00c2\u00b49\u00f0[6\u001b\rG\u00be_S[\u00d3\u0014\u00f6\u00fe\u00b9]\u0012\u00c2\n\f\u00bce\u00b6Fy\u0091w\u00fd\u0086\u00a4\u0010[B\u0011\u00bchFU\b\u00f9\b\u0006\u00aeh\u008b\u0081\u00e5\u00de\u00da?/\u00afd\u00fb\u00b1\u0093~\u00ac\u0091\u00c3\u00ba:\u0099\u008f\u0097EO\u00d3a\u0002O\u00c6\u00c8\u00ea@\u00b5L\u00d8\u00b5\u0091\u001f\u00db\u00f9\u008f\u00ad(9\u00c8\\\u0094\u00a4=\u00e3\u00f3\u009a\u00ab\u00b7J\u0018k+*M\u0013\f\u00cd\u00cd=\u00f0\\\u00de\u001b\u007f\u00eeL\u00ce\u00e0DP\u00a3\u00cc\u00f0\u00ad\u0011\u00c3\u00a0P\u0092\u00ee\u00d9\u0003\u00b1j\u009b\u008c2\u009a\u00e5p\u00ba8\u0018H\u0003E\u00e4\u00e1g\u00fc|;\u0002\u00c4S\u00f1\u00e2f\u00ca\u0093\u0096\u00bf.q\u00a4\u0000\u00c4\u0015/\u00d2\u000b\u0002\u00ae(\u00ce\u00c5\u0016\u0087\u008b\u00b0NR\u0091:\u00fc/\u000f\u00dc0\u001b\u00be>\u00a4\u00afLg\u0098\\+!\u00ba\u00bf\u00fb\u00ddN\u00db\u0090\u00c2\u000bV\u00b6M\u00c7\u00a5\u0015)s\u000e\u0098\u0093\u00e91b;\u009d\u001a\u00e6Uq\u00bf?.\u000e\u00f0C\u00ea>\u00c2ap\u00c6\u00a1\u0095w\u00ed\u00f3l\u000e\u009a4\u00f9\u00d6\u00a6]\u00aa\u00e3\u00b3'\u0084\u00eb\u00afg\u0011\u0086`=\\\b\u00e1c\u0087\u00ee\u00ea\u0006\u00c2hv8\u00aaZp\u000f\u0099\nc \nxi\u007f\u00ea\u00db\u00c2\u00c4kk\u00a3B\u0000\r\u00b7\u0017]\u007f\u00bc\u00ca\u00e8\u00d2\u0088\u0016\u00f5\tJ\u00b8\u00bbF\u00f6\u00c9l\u00cbXL\u00bdW\u00fd\u0084[H\u00c4l\u00cck]\u009f\u00a4\u00da\u008eN\u0084k\u00c5\u00f8{\u00c7\u00fa4-\t\u00df\u00aa\u0000\u0090\u0010\u0012\u00ccU\u00ae\u00a3XVc!<3\u00bb\u00ca\u00c6\u0003\u0012_R\u009e\u00a4'\u00d3\u0016\u00af\u00ec_*zK`\u0085D\u007f\u00c0\u0089WKz\u0080}N1\u0086\u0084\u0018\u00ec\u000e\u00b7j\u0085\u00ea<$H3\"YI\u0011\u008f\u008dC\u00f5\u00fas\u0014\u000e-s\u00e1\u00f5\u00fc\u00dd\u0001@\u0091\u009e\u009f\u0098\n\u0002\u0003\u008d\u001d\u00cdg\u009f\u0093\u00c2#H\u0096\u00a3\r\u00ef\r\u00d7\u0090\u009aK\u00b91\u001b\u0096\u009f\u0012\u00d5dJ\u00c4\u001e\u00daVL&t-h2";
                var4_3 = "!\u00de\u00cb\u008f\u0096\u001f\u00f3B\u00c0\u0001\u007f\u00e5\u0000\u00bc\u0082ZKW\u00be3\u00d2AW\u0010\n\u00bf+[D7\u00c3\u00cb k\u00bcr\u0012\u00c3\u00b1?\"\u00ff\u00ce\u00e8c2\u00eeP\"\u00bb.\u009e\u009b\u00f0\u00d6t\u007f*$a\u008b\u0097\u00f2\u00d5P\u0094\u0088\u00fb\u00ac\u007f\u000f\"\u00bdN\u00eb\u00da\u00a1\u00a3\u00a61\u0014u\u0010\u001a\u0085\u00f0\t\u0091~\u00a5\u00dc\u00f2\u0090\u00c0\u00fa&8\u00c1\u00b3\u00ed\nP\u00da\u00c2_\u00baK\u009c[}\u0018#\u0003\u001c\u0096|6'\u0085h\u0087\u00e5;\u00d0t\u00c2\u008f\u00e0\u0002\u00c7[\u00b8Fj\u0005s\u00afc\u001e<\u00a2\u00e1(\u0014uI\u008a!\u00eaJq\u0016p\u001f,\u009c\u00c3\u0097l\u00e1%\u00a8xV\u00fb\\\u00b6\u00c8\u00aex\u008f\u00d9\\\u00d0\u0002\u00fa.\u0016`\u00a2\u0002\u00a4\u00a6\u00b6Z\u0094t\u00d7\u00a2\n{U\u00fe\u001f6e T\u0096dV\u00dfc\u00bf\u00fa*\u00d7\u008c\u0085\u0018\u0080\u00fc\u0010\u0005\u00cf\u00f0\u00e5\u00d7i>\u009f\"\u00e8\u0015\u00a1\u00c1S\u008f\u007fhdZ\u0003\u0091\u00ce\u001ciB\u00f2O\u00ca\t?\u008d\u0098\u00e4\u0010\u00a75\u0098r\u0017\u00b3w\u009f\u00ad\u00c9\u00b8ox\u0088\u0015\u00ca=\u00f9\u0093\u0011I#\u001f\u00f0\u0000Z4/\u000eU\u00b8PTU\u0097{\u008f:\u00e7\u00ea\u00e9L\u00e4\u0016\u0007S\u0090\u00ee\u0010&\u0083Z\u00a5L\u000by\u00act\u00f7\u0081\u00d19\u00dd\u00da\u0015\u001c\u0017\u00d4ts\u00cdT\u00b4\u00dc\u00f9\u00fe%\u0004; S*QD\u001c\u001c`\u00c78\u009c\u001b\u00fc=\u00b7!\u0012\u00af\u009c\u007f\u0099B\u00f2\u0019q\u00a6\u0090l\u00ab\u0002.\u00d1\u0000\u00bbV\u00e5\u00cb\u001d\u0093\u0016\u001e\u00eb7\"~\u00d1\u001b\u00ac\u00a7D\u00d7\u00c8\u00c5]\u00e0\u00db\u00d2\u0013\u00ca[\u0088\u00efH\u0018*nL\u00a7\u00ea\u00a2\u00ce%\u00d8\u00ef\u00f1\u0097\u00b7F\u00ef'\u00fc\u0002\u00fd;\n\u00ca\u00aa\u00d0\u00b5t\u00ff+\u009fk\u0002\u0099\u0010\u00a3a\u00ca=\u00ae\u00f3\u0010Lj\u00eb\u0006\u0003T\u008d\u00ed!\u00b3-\u00888#G\u009c\b\u00d0\u00f3\u008f\u00be\u00a9\u0089\u00b9\u00b8\u00d3\u00cf\u00d5\u008a\u00f8cN\u00f6I|\u00e1\u00f31T\u008d\u00f9\u0016\u00b3\u00bb\u00b9\u00c0\u001c'\u008e\u00dewt\\\u00ca\u0019\u0094h\u00f2\u00a2\u00ec\u0010\u0006\u00c2\u00a3\u00c6\u008fig\u0080\u00a7\u00e9\u00e5\u007fq\u0092R\u0096l\u00ad\u00bc\u00e4\u0087nZ\u0012\u00d0\u00ee0\u00ecf\u00c4&\u00c0\u00e8\u00a8\u00e1\u00d5\u001a\u009c\u00b3\u00db!9\u00b10\u00da\u00fb\u00b2\u0099\u00c1$/\\\u009d}LK?,\u00ffk{\u001d\u0096\u001b\u000f\u00af\u0083u]\u00cc\u00c2\u00b33y\u0082\u00e3\u00ab\u00d4\u00e0_2k\u008c\u0003\u00ac\u0080\u0018\u00cd\u0080\u00c1\u00e6\u00c78PD\u0086\u00bf8<k\u0094\u00b5\u0093\u000e\u0081\u001a+\u0003H\u001d\u00c4\u001b\u008fU\u00a0*\u00d6=\u00a4\u00d87\u0094\u00b5\u00f2e\u00f3RW\u0014\nn+_HL\u00c3K\u00a3:]2\u00a2\u00af\u0017\u00cf\u00ef\u00af\u0092\u0090H\u00c9\u0096\u0099\u00e6\u001d\u00e7\u00a2\u00ca\u00c0\u00ba\\c\u00efu0ZL\u009a\u00d1\u0093i{\u0014\u00c0*F\u00c9\\\u00d7\u00ed\u001e\u00c9\u008b\u00b8\u007f*\u0003\r\u00be\u00ff\u0081wr3\u00bc\u0095x\u00d1\u00a34\u00a3Mt\u00deH\u00dae\u00cd9\u00a2\u00bd\u0099\u00f5/2/E\u009d\u00170)\u00f6\n\u00ca\u00c6\u00fa\u00e5\u001eHC\u00ca\u00e5\u0082\u001d\u00e9|\u00c3\u00db\u00b0\u0084\u00ba\u0001\u0096\nV\u008f\u00a0\u008d\u00a2\u00a8\u00fd\u0012\u00d1\u00e3\u00b8Unc\u0091\u0016\u0089\u00a9\fo\u00e5\u0017W\u00b2\u008b0\r.\u00d1\u000e\u001e\u00c9xW#\u00b5:ke\u0012\u00eaFI\u00db\u0081\u00ef\u00ec\u00beiA\u00e4k\u00e4\f\u00c6Wu\u0001'\u00c0\u008aQ\u00f4J\u0090\u00b8\u00e6GL\u008b7`\u0011X\u00e7\t\u00a8C\u00c1\u009d\u0010A\u00f3\u00d4F]\u00ec;C\u00b6\u00e0\u0087\u0006\u00c6T)\u00ceT\u00a2TJ6\u00f3\u00cfz42\u009d\n\u008b\u0092\u009es\u0013l\u0015\u009c;\u00f4\u00ce\u0010\u0095=\u00bf\u0080\u001a\u00bdb,y\u00f0\u000e'\u00deN\u008bP\u00f6t\u0096h\u0089\u00ff>\u00c0\u00dd,\u00bf\u0011\u008f\u00d4\u000e~w\u008a\u00f6\u00bfZ\u0087\u00a3L\u0082\u00dc$\u00aa\u0016\u0090\u00d5KlY]s\u00fb\u00b6F2\u00c9\u00c3N\u00ae\u00dd\u00ca\u0003\u0087M\u00d2\u00b1\u0096e\u0084%%6\u001dI\u00fc\u00be\u008b\u00a1\u00d8\u008a\u0003\u00b5\u00baf\u0097\u0001n\u00ad\u00a6YbXJS-]\u00a8\u0081\u00be@q\u00a30y$\u00ca\u00d3'\u001b\u00db\u00da\u00f4\u0004\t\u0094y;{x\u00a23\u0081\u00c4u2\u0084\u00d6.\u009a\u00f1\"\u009c\u0080\u0001\u009a\n\u00f81\u00b9\u008d+\u00b6\u0013y\u00e1/\u0015\u001f\u00ae\u008e\u00a5U\u00b6QW\u00b4?\u0091X\u00c8\u00c0\u0015\u00f89\u00b3Ues\r\u00c7M/?\u008e\u0005AK\u009ab\u0015\u00ce\u00047\u00d8)s>\u00ae\b\u00eaH\u001d6\u00e7\u009e\u008c\u001d\u00f93\u0006\u00b7\u0012\u0095\u00b1KnS\u00aeke\u00e3\u00d4!\u0005\u00e8\u00a0\u00fb\u00b0\u00b0 \u000e%?Z\u00b9\u009f\u0083\u00cc\u00e9\u00c8\u00026\u001c\u000eI\u000e\u0097\u00db\u0006-_\u0003\u00c3\u008a\u00d7\u001c\u00b9\u00dc*J&?7^\u00af\u00d5u\u00cfN~c4\u00f7.\u00d2%\u00f9\u000ew\\rg\u000b\u009b\u00c3|\u0088\u00b4Q\u00ca^\u0093\u00a7\u00e6\u00c9\t\u00e0*\u00be\t\u00dd6E\u0098|\u00a7\u00b0mG\"@\u00cb\u00e3)\u001dC\u00df@\u008b\u00c3Up\u0011`\u000eS\u009f\u00b7\u00d1\u0089|5\u009b\u00b5\u00db\"\u00a7\u0007\u0000v\u00c9\u008dA\u00d0\u001a\u0012/\u00e0X\u00ab\u00b8\u00a0\u00df\u007f]D\u00b2\u008e\u0082U4\u00a4\u00bfnk\u00e1)\u008a\u00e8\u001a}\u0011!m\f+e\u00eerWDGI\u00a9\"\u0096g\u00d4\u00dag5\u0099\u00fa\u00d3Sa\u001d\u0016\u0015\u0083Ec0\u00dd\u0090\u0016l\u001c2>)-Z\u00ee\u00a2@\u0093K\u0086\u00ff\u0019\u00bc[\u00f6N,\u00dc\u00f1\u001b4\u008a\u0096\r\u001b\u00b7\u00bc\u00e5\u00b4\u00a3Kp\u00c7\u00eeE\u00b7\u0004\u00d7\u00dc\u00b1\u00b6n\u00c5g\u00d5p\u0014\u009f\u0081\u00a4\u0081z\u00d4O#\u00e7n\u00ba\u0081\u0006\u0092i\u00cf:,\u00fa\u00c10t\u00fc\u0085\u0097\u0091\u00dbV\u009fu\u000f\u0012\u0081CY\u0086@\u0018Yw\u0092a\r\u00bb\u00b5#\u0016\u00a9\u00e9}\u0090\u001a7<D\u0097s\u0004^\u00e0\u00f7\u00178YtE\n\u00f9\u00ba\u009f\u00d4(#\b\u0085~\u00c5U\u000e|>\u0080[G'a EbL)\u00c1\u00c3c\u008acnxE\u00ad+\u00d0\u009f&\u00e2br#\u0002\u009aK\u00d4J\u0098y\u008e\u0016)p#\u00aa\u00d7\u00a5\u00a4\u00a3=\u00cf\u008b\u008b()\u00caMNu\u0093\u0002*\u008f-\u00eae\u0092\u0093\u001b2\\\u0002\u00c57\u00bf~\u00ca!\u008e \u00d8Q\u00a2\u00a5\u000f%$%\u00d2_W\u0012\u00861 %\u00ab-S\u00a6>\u008aK\u00c5\u0087\u00de\u0014\u00b7\u00c1w\u000b\u00a7H\u00f4\u000b\u00e6\u0097#\u0016\u00ca\u008cP\f\u00d2\u0099E\u0096H\u00a5\u00a2\u00e1\u00ec[\u00a1\u00c8\u0090\u0094\u00b1\u0081\u0016\u00a5\u00e8\u00df\u0005\u0012\u0082\u0012\u00c9%\u009c9\u001cx\u0014\u001b\u00c7\u00dd\u000eV\u0097\u0015\u00b2\u00c1 6+*-\u008f\u00e6-\u00b8\u0017\u00d6\u009e\u00d9\u0095\u00c4\u00cd\u0007^\u0004d\u00c2\u00b3!\u009d\u00cfC\u00a7\u007f]T\u0087\u00f8\u00a9G\u00fa\u0080H\u00ccS52i.6\u0005\t\u009fh\u00b322\b1\u0006\u00be\u00fdX\u00ff\u0093\u00161\u00f8+I\nL[R\u00f4\u00ea\u00aasno\u00fby\u009ck\u00a7\t\u00ed\u00ecI\u00d7\u00f8\u00a2\u00df\u0007\u00f2\u00d9\u00f1\u0092r\u00ac\u00c4Z\u007f\u00fb@\u0093cj\u0094v\u00e7cl0dE\u00b6\u00a5\u0080\u00dbuau\u00b3\u000eB\u00efs\u00fcX\u000b\u00e8%)\u00c0<\u00cca\u00bb\u00bf?v\u00e9\u00e5\u00c7 \u00f3[\u0019\u00d5sn\u0013\u0082\u0082WR\u00e9\u00a4\u001c\u00e4\u00d9x\u0003\u00f4\u00a0\u0001\u00b1E\u00b2x\u00aa4m\u0087\u009a\u001e\u00c1'}\u00a8&\u009f\u00ad\b\u001d&k\u000f\u00dd\u00fa7\u00b3Z\u0002\u001e\u00f2\u00fa\u00c2\u00d0\u0080h\u00d0cV\u00b4\u00c0\u00f0\u0000\u009b~\u009d\u001f\u0003\u00dc\u00faP\u008f,\u007f\u0093\u0011\u00f2w\u0086\u0091t$\u001c\u001e9\u0007\u0001\u00b3,\u00efL^\f\u0081\u009f\u00d8\u00ac\u00df8\u00d2\u008a\u000b\u00b1\u00de\u009d\u00fa\u0015\u0087\u00ae\u00e3\u00b4X\u00b7\u00c9(\u00a0-\u0013\u0093\u00db\u00fd$(\u0090T\u00b1\u00e0bDy>\u00f1\u008dKQ\u00cbD\u001c%*\u00f0Z\u00d3w\u00afL\u00b0#<\u00f49\u00de\u0013\u00a8\u00d5\u0089\u0083\u00e4\u00d3\u00a4\u00c8\u00cd\u000b\u001f%Z+\u0014\u00f2\u0098\u0018y\u009e\u00a0E\u00f1\u00cc\u00c4\u00da\u00c7F)\u00b5p\u00a0\u00a3\u0001e\u00f9#k\u00c6\u00c4E\u008f}L\u00eb\u00e6187\u009e\u009cp\u00a3\tL&\u001d$\u00d3>\u00d1U+\u00e9\u00032\u00ebW\u00d1J)\u001b\u00e1\u00f0$^\u00ca\u0092\u0007\u009e\u0081\u00d3\u00d6XIC\u00a8f>6[\u001eg\u0010N\u00ca\u00b5T\u009c!\u00e6\u0082\u0086\b\u000f\u00b7\u0092\u00f2\u001a=z\b\u00fdE-e\u00ea\u00ca#,\u00d3\"\u001e\u00bd\u0007\u000e\u00a9\u00df\u00b5\u008eVv`\u0011\u0097\u008a\u00de\u00b1l\u0094I\u0000\u00a3*\u00df5]\r\u00b2\u00a7\u0082p4m\u00ad\u00ca\\\u0007\u00a8E\u007f\rKjMB\u0012\u00cbew\u0082l90'\u009c)\u00cf/\u00a5\u00f6h&\u009f\u00813c\u00f4}\u00de\u00020\u00c9\u00e6W\u0095O\u00d2\u00e7\u00aa\u001aw\u00cd\u00ac\u0086\u00d0\u00fc\u00ea\u00b0I\u0087\u009c\u0019\u0015\u00c5Z*\u00a5\u00c1\u00e7\u0093\u00b6\u00a6\u00c8J]\u00e2\"l\u00bc\u008d\u00e0w\u001d\u00825\u00ce\u00a0-og\u00f3\u00f2\u00d5\u00f6\u0092\u00c7\u00cf\u00ff-[\u008c\u008e)a\u00e4\u00f3\u009b\u00ea\u0093;\u00de\u0018\t\u001c\u00e4}\u00c2{\u00ecP\u0004[\u001e\u009ax\u00abF}\u0098\u00de\u00b9j\u001b\u00deD`\u000b+oKo\u0000G\f\u0098\u00d0\u00a5',oY\u009b\u00ef%\u00ce\u00c12h'k\u0098EccHs\u00be\u00eag\u00e4\u0093\u0010\u000eeC\u0089\u0001yt\u00d2j{\u00a7\u00c0\u00ad@z`T\u00ccE\"\u00a8\u00ed\u00fe\u00ed\u00be\u00db\u00abS\u0005\u00a1\u0084<+\u00e9Ibw\u0091\u00ccM\u00df\u00ad\u00ef\u00a6U@vK:\u00ff\u008e\u00bc\u00a9\u00f6H|\u00a2\u00f7\u00a2\u0001\u00b0\u008eX\u00d8\u0096\u00c3\u00cag\u00fc\f\u00e8*H\u00fdn\u0083n\u00d4@9\u001b\u0007\u00f6\u00ca\u00b5A_\n\u00bb\u00d8\u0010\u00be\u009fX\u00ac\u009c\u0081\u00d6\u008e,<\u00d3X:h1\u0003\t\u008ci[n\u00b7\u00a9D\u00f4\u00f4\u009d\u00d8Ld\u0016k&\u00c2\u0086g\u001ax\u00cd\u00e4\u00e9\u00fd[\u00c3C\b\u00af5j\u0019~\u00d0\u00015T\u00e3=\u00ca\f\u00c4\u0096\u00bd\u00ad4\u0015uM\u00faF\u00b1\u00e9\u0097\u0083\u00bb\u0017\u00b2\rV#\u0007\u007f\u00fc8F\u0002\u00efM\u00c5I\u0005C\fI\u00ddb\u0096\u0014\u00c1(U\u009e\u0006\u00a1\u00d3\u00fb\u00c6\u001f\u00d9\u009c\u00c3,\u001d/\u0014b\u0082\u001bG\u009e\u009b\u00bb\u00ab\u00e5d\f\u00b7-A\u00ff\u00ec?\u00bb(\u00c1\u009e>\u00b1\u00bd\u0012\u0090\u0093^\u00c5\u0089\u0016\u00ce\u001e6\u0097)\u001c\u0004\">\r\u00a0d\u00fb\u008c\u00fd\\\u00a4\u0097C+mB\u0019W\u00bf\u008b\u00b9\u0082\u0015%\u00e2r\u001a\u00ba\u00de\u00d9\u0003w\u0099%L7\u0087\u00eck\u00da\u00e2*\u0016\u007f\u0080\u0000D\u00eff\u00dcm%\u00e4\u00c3Y\u0097+p\u00a8\u0015\tu\u00f8\u00ab8\u0019\u0087cE\u0085;\u00e7@2\u00b6> 8\u00e0\u00af_y\u00dc\u00c7P\u0094\u0015Vi\u00a0#HVv\u00a7\u00c7\u009e\u009b\u0085\u00e0\u00cf\brP\u00dd\u0014\u00f5\u00c0\u00bfS\u001d\u0000U\u0094\u0007yi\u00cfC\u00b0\u00cdv\u00b7?\u0002\u00b7\u00d0\u0095\u00a4\u00a3c \u00a96]\u00a4\u00e0\u00ea\u0088\u00b0v\u0088\u00d5\u00d8\u00ff\u007fZU\u00e8\u00a4\u0014j\u001f\u0000\u009a^\u00dfB\u001f\u0090La\u00cb\u001e\u0018C(\u00d1\u008ae\u00c6\u00b8\u008e\u00baW\u00d1\u0097\u00ab\u00ad\u00e4\u001cu\u008cI\u00bd\u0089\u0003\u00f1\u0019%[\u00dc\u0080\u00cbq\u001fR\u00cb:\u00b2cI\u00db\u00ad\u00cb\f\u0006\r\u00bc\u00c6\u0015\u00fd\u00cb\u00f7-\u0003AA\u00c2\u0087\u0001\u00a8\u00ef}\u00e6o\u0013\u001aH\u00e9\u00e2m=\u00cb\u00dbQ\u000b\u00edU\"\u0015wQ \u0005p\u00e5\u00b9\n\u009c\u00dc\u0084\u00be\u00efE\u0019\u008b\u00d92d[]\u0016\u00fe\u00d4r\u008f_(dQ.\u0083Xg\u00deQ\u009fE\u00bfL\u00e6\u0010\u00a6\u00a1\u00e43\u00a4a\u0000\u00ccp#\u00a5\u00f6\u00a5\u009d\u00d2\u00bc\u00d1\u0086\u0096p\u00c1\\\u00fc\u0018\u0087C\u00be1\u0089\u00eaP]\u00ec\u0089\u000ey@!#\u00de\u00f8\u001a\u007f\u00c5\u00a3<=|g\u001fHn\u00aa\u00de<U\u00c4\u00ea\u00a9\u0086<\u00fc\u0006,S\n\tGL\u007fy\u0097\u00d9\r\u00df\u000f\u00b5\u00e8+\u00c5}\u00a7\n\u00146)\u0093\u009d\u0015\u008f\u0005X\u00b8\u00135\u00b0x\u009c\u001891\u00b7\u00d3\u00b6\u000f\u00a9;p\u00cb\t\u00f9\u0095\u0082\u00c9\u00d8Ax\u00ae.\u00e7\u008a\u0013\u00c9\u00a7^\u00bci\u00d6S\u0088W\u00c8v\u00db\u008b\u000f\u0081\u00fdanhx\u0002xz\u001b^\u00d9\u009a\u00bb\u0091\u000fL\u009e*\\\u0016\u00eb\u0011\u00d0\u00dc3\u00c5\u0086T\u00ba\u0018z\u00a4\u0085Vk\u0099\u000et\u0083z/\u00d7p.\u0098\u0001\u00c2\u0003\u000fAW1\u00f8\u00b6KRk\u00b1\u00ec\u00a8H\u0012\u00b1\u00b2\r\u0016\u00fd\u00b6u\u00ba:j\u0092\u009e\u0017\u007f\u00ca\u00af\u00f6{\u009cP\u00d607\u00e0\u001f%6\u00d0)\u00cf\u00b4I\b\u00e0U\u0004gQ,>y;`\u00cbpr\u00ae\u00cd\u000e\u0000\u00de\u00fc\u00e7H\u001f6<\u00eb\u0088'H\u00bcR\u00df\u00d2\u00d3W\u00e6\u0015\u00f6\u00d6X\u000f\u00bdQ\u00e0\u00e8\u0011o\u00ab#6\u0001\u0088\u00f1_\r\u0090\u001a)\u00aeD\u00cd\u00f3c\u00ae\u00aa\u000b:\u008c\u00eb_h\u00bc\t|q\u00eeH\u00a1!D\u00ef\u00ac\u00e2\"\u00d8\u00f4\u00a2\u00e1\u00d8@|\u008a\u00aa8\u001dS^\u008e\u00ea;\u00f2>\u0006\b\u00a8\u001a\u00d5\u008c\u00fa\u00eb\u00ab7\u00a4\u00beT\u0084\u0083\u00a9\u00df\u009c\u00b7m|bh\u00fc\u00a2s?v\u001f\u00f5\u0096\u0013Q\u0004\u0094\u0098v\u00c9\u001e\u00f9\u000e\u00a3L\u001fqS\u00d2\u00aa|s\u007f&\u00ad\u0088\u0089\u00d2\u0011\u00ce\u00f8\f\u0088\u0080|\u00e80i\u00ba\u00aa\u0017mf\u00b3E\u0018>&3\u009b\u00fe\u00e6\u000bJ\u00a5\u0098\u009bU\u00c0,we\u00f8B\u0013x\u008b\u00f3[\u00f3\"\u0089\u00fc\u00d8\u00c18\u009dm\u0016\t\t\u0005.\u001bFD\u00c6\u00a6Z\u00bd\u00f6\u00b7D;\u00d4m\u00c6\u00be\u0004/\u0012\u00a0\u0082G\u00c2lI'\u00c2\u00b49\u00f0[6\u001b\rG\u00be_S[\u00d3\u0014\u00f6\u00fe\u00b9]\u0012\u00c2\n\f\u00bce\u00b6Fy\u0091w\u00fd\u0086\u00a4\u0010[B\u0011\u00bchFU\b\u00f9\b\u0006\u00aeh\u008b\u0081\u00e5\u00de\u00da?/\u00afd\u00fb\u00b1\u0093~\u00ac\u0091\u00c3\u00ba:\u0099\u008f\u0097EO\u00d3a\u0002O\u00c6\u00c8\u00ea@\u00b5L\u00d8\u00b5\u0091\u001f\u00db\u00f9\u008f\u00ad(9\u00c8\\\u0094\u00a4=\u00e3\u00f3\u009a\u00ab\u00b7J\u0018k+*M\u0013\f\u00cd\u00cd=\u00f0\\\u00de\u001b\u007f\u00eeL\u00ce\u00e0DP\u00a3\u00cc\u00f0\u00ad\u0011\u00c3\u00a0P\u0092\u00ee\u00d9\u0003\u00b1j\u009b\u008c2\u009a\u00e5p\u00ba8\u0018H\u0003E\u00e4\u00e1g\u00fc|;\u0002\u00c4S\u00f1\u00e2f\u00ca\u0093\u0096\u00bf.q\u00a4\u0000\u00c4\u0015/\u00d2\u000b\u0002\u00ae(\u00ce\u00c5\u0016\u0087\u008b\u00b0NR\u0091:\u00fc/\u000f\u00dc0\u001b\u00be>\u00a4\u00afLg\u0098\\+!\u00ba\u00bf\u00fb\u00ddN\u00db\u0090\u00c2\u000bV\u00b6M\u00c7\u00a5\u0015)s\u000e\u0098\u0093\u00e91b;\u009d\u001a\u00e6Uq\u00bf?.\u000e\u00f0C\u00ea>\u00c2ap\u00c6\u00a1\u0095w\u00ed\u00f3l\u000e\u009a4\u00f9\u00d6\u00a6]\u00aa\u00e3\u00b3'\u0084\u00eb\u00afg\u0011\u0086`=\\\b\u00e1c\u0087\u00ee\u00ea\u0006\u00c2hv8\u00aaZp\u000f\u0099\nc \nxi\u007f\u00ea\u00db\u00c2\u00c4kk\u00a3B\u0000\r\u00b7\u0017]\u007f\u00bc\u00ca\u00e8\u00d2\u0088\u0016\u00f5\tJ\u00b8\u00bbF\u00f6\u00c9l\u00cbXL\u00bdW\u00fd\u0084[H\u00c4l\u00cck]\u009f\u00a4\u00da\u008eN\u0084k\u00c5\u00f8{\u00c7\u00fa4-\t\u00df\u00aa\u0000\u0090\u0010\u0012\u00ccU\u00ae\u00a3XVc!<3\u00bb\u00ca\u00c6\u0003\u0012_R\u009e\u00a4'\u00d3\u0016\u00af\u00ec_*zK`\u0085D\u007f\u00c0\u0089WKz\u0080}N1\u0086\u0084\u0018\u00ec\u000e\u00b7j\u0085\u00ea<$H3\"YI\u0011\u008f\u008dC\u00f5\u00fas\u0014\u000e-s\u00e1\u00f5\u00fc\u00dd\u0001@\u0091\u009e\u009f\u0098\n\u0002\u0003\u008d\u001d\u00cdg\u009f\u0093\u00c2#H\u0096\u00a3\r\u00ef\r\u00d7\u0090\u009aK\u00b91\u001b\u0096\u009f\u0012\u00d5dJ\u00c4\u001e\u00daVL&t-h2".length();
                var1_4 = 48;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0019\u0087\u009a\u007f\fx\u0095Y\u001b\u00b1{\u00d2\u00b5\u008av\u009cR\u001e!/\u009c\u008dX\u009ay@\u00f1\u00b49\u00d1\u008b@,\u00f1\u0004\u00dcn\u00f5\u00d5";
                    var4_3 = "\u0019\u0087\u009a\u007f\fx\u0095Y\u001b\u00b1{\u00d2\u00b5\u008av\u009cR\u001e!/\u009c\u008dX\u009ay@\u00f1\u00b49\u00d1\u008b@,\u00f1\u0004\u00dcn\u00f5\u00d5".length();
                    var1_4 = 34;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 68;
                            break;
                        }
                        case 1: {
                            v13 = 38;
                            break;
                        }
                        case 2: {
                            v13 = 111;
                            break;
                        }
                        case 3: {
                            v13 = 97;
                            break;
                        }
                        case 4: {
                            v13 = 92;
                            break;
                        }
                        case 5: {
                            v13 = 106;
                            break;
                        }
                        default: {
                            v13 = 118;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        Signer.h = var5;
        Signer.i = new String[88];
        Signer.a = DigestAlg.SHA256;
        Signer.b = true;
        Signer.d = true;
        Signer.e = new Asn1ObjectIdentifier(_etsiqcValues.id_etsi_qcs_QcCompliance);
        Signer.f = EESYAOID.oid_TK_nesoid;
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0xFFFFD61B) & 0xFFFF;
        if (i[n3] == null) {
            int n4;
            int n5;
            char[] cArray = h[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 126;
                    break;
                }
                case 1: {
                    n5 = 6;
                    break;
                }
                case 2: {
                    n5 = 166;
                    break;
                }
                case 3: {
                    n5 = 44;
                    break;
                }
                case 4: {
                    n5 = 172;
                    break;
                }
                case 5: {
                    n5 = 179;
                    break;
                }
                case 6: {
                    n5 = 85;
                    break;
                }
                case 7: {
                    n5 = 134;
                    break;
                }
                case 8: {
                    n5 = 17;
                    break;
                }
                case 9: {
                    n5 = 162;
                    break;
                }
                case 10: {
                    n5 = 8;
                    break;
                }
                case 11: {
                    n5 = 12;
                    break;
                }
                case 12: {
                    n5 = 43;
                    break;
                }
                case 13: {
                    n5 = 20;
                    break;
                }
                case 14: {
                    n5 = 175;
                    break;
                }
                case 15: {
                    n5 = 230;
                    break;
                }
                case 16: {
                    n5 = 79;
                    break;
                }
                case 17: {
                    n5 = 199;
                    break;
                }
                case 18: {
                    n5 = 52;
                    break;
                }
                case 19: {
                    n5 = 194;
                    break;
                }
                case 20: {
                    n5 = 214;
                    break;
                }
                case 21: {
                    n5 = 49;
                    break;
                }
                case 22: {
                    n5 = 46;
                    break;
                }
                case 23: {
                    n5 = 216;
                    break;
                }
                case 24: {
                    n5 = 38;
                    break;
                }
                case 25: {
                    n5 = 231;
                    break;
                }
                case 26: {
                    n5 = 241;
                    break;
                }
                case 27: {
                    n5 = 192;
                    break;
                }
                case 28: {
                    n5 = 189;
                    break;
                }
                case 29: {
                    n5 = 129;
                    break;
                }
                case 30: {
                    n5 = 132;
                    break;
                }
                case 31: {
                    n5 = 176;
                    break;
                }
                case 32: {
                    n5 = 9;
                    break;
                }
                case 33: {
                    n5 = 190;
                    break;
                }
                case 34: {
                    n5 = 73;
                    break;
                }
                case 35: {
                    n5 = 221;
                    break;
                }
                case 36: {
                    n5 = 65;
                    break;
                }
                case 37: {
                    n5 = 36;
                    break;
                }
                case 38: {
                    n5 = 24;
                    break;
                }
                case 39: {
                    n5 = 178;
                    break;
                }
                case 40: {
                    n5 = 13;
                    break;
                }
                case 41: {
                    n5 = 128;
                    break;
                }
                case 42: {
                    n5 = 242;
                    break;
                }
                case 43: {
                    n5 = 170;
                    break;
                }
                case 44: {
                    n5 = 125;
                    break;
                }
                case 45: {
                    n5 = 254;
                    break;
                }
                case 46: {
                    n5 = 42;
                    break;
                }
                case 47: {
                    n5 = 26;
                    break;
                }
                case 48: {
                    n5 = 133;
                    break;
                }
                case 49: {
                    n5 = 246;
                    break;
                }
                case 50: {
                    n5 = 93;
                    break;
                }
                case 51: {
                    n5 = 0;
                    break;
                }
                case 52: {
                    n5 = 28;
                    break;
                }
                case 53: {
                    n5 = 249;
                    break;
                }
                case 54: {
                    n5 = 5;
                    break;
                }
                case 55: {
                    n5 = 153;
                    break;
                }
                case 56: {
                    n5 = 77;
                    break;
                }
                case 57: {
                    n5 = 228;
                    break;
                }
                case 58: {
                    n5 = 155;
                    break;
                }
                case 59: {
                    n5 = 163;
                    break;
                }
                case 60: {
                    n5 = 174;
                    break;
                }
                case 61: {
                    n5 = 34;
                    break;
                }
                case 62: {
                    n5 = 167;
                    break;
                }
                case 63: {
                    n5 = 210;
                    break;
                }
                case 64: {
                    n5 = 96;
                    break;
                }
                case 65: {
                    n5 = 139;
                    break;
                }
                case 66: {
                    n5 = 141;
                    break;
                }
                case 67: {
                    n5 = 248;
                    break;
                }
                case 68: {
                    n5 = 225;
                    break;
                }
                case 69: {
                    n5 = 233;
                    break;
                }
                case 70: {
                    n5 = 106;
                    break;
                }
                case 71: {
                    n5 = 252;
                    break;
                }
                case 72: {
                    n5 = 76;
                    break;
                }
                case 73: {
                    n5 = 122;
                    break;
                }
                case 74: {
                    n5 = 63;
                    break;
                }
                case 75: {
                    n5 = 59;
                    break;
                }
                case 76: {
                    n5 = 102;
                    break;
                }
                case 77: {
                    n5 = 148;
                    break;
                }
                case 78: {
                    n5 = 251;
                    break;
                }
                case 79: {
                    n5 = 207;
                    break;
                }
                case 80: {
                    n5 = 255;
                    break;
                }
                case 81: {
                    n5 = 196;
                    break;
                }
                case 82: {
                    n5 = 209;
                    break;
                }
                case 83: {
                    n5 = 68;
                    break;
                }
                case 84: {
                    n5 = 244;
                    break;
                }
                case 85: {
                    n5 = 118;
                    break;
                }
                case 86: {
                    n5 = 138;
                    break;
                }
                case 87: {
                    n5 = 100;
                    break;
                }
                case 88: {
                    n5 = 215;
                    break;
                }
                case 89: {
                    n5 = 239;
                    break;
                }
                case 90: {
                    n5 = 39;
                    break;
                }
                case 91: {
                    n5 = 108;
                    break;
                }
                case 92: {
                    n5 = 146;
                    break;
                }
                case 93: {
                    n5 = 205;
                    break;
                }
                case 94: {
                    n5 = 23;
                    break;
                }
                case 95: {
                    n5 = 33;
                    break;
                }
                case 96: {
                    n5 = 25;
                    break;
                }
                case 97: {
                    n5 = 147;
                    break;
                }
                case 98: {
                    n5 = 56;
                    break;
                }
                case 99: {
                    n5 = 37;
                    break;
                }
                case 100: {
                    n5 = 35;
                    break;
                }
                case 101: {
                    n5 = 157;
                    break;
                }
                case 102: {
                    n5 = 82;
                    break;
                }
                case 103: {
                    n5 = 103;
                    break;
                }
                case 104: {
                    n5 = 131;
                    break;
                }
                case 105: {
                    n5 = 220;
                    break;
                }
                case 106: {
                    n5 = 243;
                    break;
                }
                case 107: {
                    n5 = 16;
                    break;
                }
                case 108: {
                    n5 = 80;
                    break;
                }
                case 109: {
                    n5 = 94;
                    break;
                }
                case 110: {
                    n5 = 247;
                    break;
                }
                case 111: {
                    n5 = 48;
                    break;
                }
                case 112: {
                    n5 = 226;
                    break;
                }
                case 113: {
                    n5 = 62;
                    break;
                }
                case 114: {
                    n5 = 47;
                    break;
                }
                case 115: {
                    n5 = 115;
                    break;
                }
                case 116: {
                    n5 = 71;
                    break;
                }
                case 117: {
                    n5 = 253;
                    break;
                }
                case 118: {
                    n5 = 54;
                    break;
                }
                case 119: {
                    n5 = 21;
                    break;
                }
                case 120: {
                    n5 = 117;
                    break;
                }
                case 121: {
                    n5 = 240;
                    break;
                }
                case 122: {
                    n5 = 169;
                    break;
                }
                case 123: {
                    n5 = 183;
                    break;
                }
                case 124: {
                    n5 = 187;
                    break;
                }
                case 125: {
                    n5 = 18;
                    break;
                }
                case 126: {
                    n5 = 121;
                    break;
                }
                case 127: {
                    n5 = 204;
                    break;
                }
                case 128: {
                    n5 = 83;
                    break;
                }
                case 129: {
                    n5 = 164;
                    break;
                }
                case 130: {
                    n5 = 101;
                    break;
                }
                case 131: {
                    n5 = 160;
                    break;
                }
                case 132: {
                    n5 = 191;
                    break;
                }
                case 133: {
                    n5 = 40;
                    break;
                }
                case 134: {
                    n5 = 91;
                    break;
                }
                case 135: {
                    n5 = 27;
                    break;
                }
                case 136: {
                    n5 = 168;
                    break;
                }
                case 137: {
                    n5 = 92;
                    break;
                }
                case 138: {
                    n5 = 151;
                    break;
                }
                case 139: {
                    n5 = 30;
                    break;
                }
                case 140: {
                    n5 = 105;
                    break;
                }
                case 141: {
                    n5 = 144;
                    break;
                }
                case 142: {
                    n5 = 154;
                    break;
                }
                case 143: {
                    n5 = 218;
                    break;
                }
                case 144: {
                    n5 = 123;
                    break;
                }
                case 145: {
                    n5 = 19;
                    break;
                }
                case 146: {
                    n5 = 78;
                    break;
                }
                case 147: {
                    n5 = 75;
                    break;
                }
                case 148: {
                    n5 = 70;
                    break;
                }
                case 149: {
                    n5 = 203;
                    break;
                }
                case 150: {
                    n5 = 224;
                    break;
                }
                case 151: {
                    n5 = 211;
                    break;
                }
                case 152: {
                    n5 = 142;
                    break;
                }
                case 153: {
                    n5 = 120;
                    break;
                }
                case 154: {
                    n5 = 99;
                    break;
                }
                case 155: {
                    n5 = 51;
                    break;
                }
                case 156: {
                    n5 = 212;
                    break;
                }
                case 157: {
                    n5 = 64;
                    break;
                }
                case 158: {
                    n5 = 67;
                    break;
                }
                case 159: {
                    n5 = 171;
                    break;
                }
                case 160: {
                    n5 = 127;
                    break;
                }
                case 161: {
                    n5 = 173;
                    break;
                }
                case 162: {
                    n5 = 158;
                    break;
                }
                case 163: {
                    n5 = 97;
                    break;
                }
                case 164: {
                    n5 = 112;
                    break;
                }
                case 165: {
                    n5 = 72;
                    break;
                }
                case 166: {
                    n5 = 236;
                    break;
                }
                case 167: {
                    n5 = 107;
                    break;
                }
                case 168: {
                    n5 = 235;
                    break;
                }
                case 169: {
                    n5 = 219;
                    break;
                }
                case 170: {
                    n5 = 10;
                    break;
                }
                case 171: {
                    n5 = 3;
                    break;
                }
                case 172: {
                    n5 = 113;
                    break;
                }
                case 173: {
                    n5 = 137;
                    break;
                }
                case 174: {
                    n5 = 90;
                    break;
                }
                case 175: {
                    n5 = 152;
                    break;
                }
                case 176: {
                    n5 = 201;
                    break;
                }
                case 177: {
                    n5 = 250;
                    break;
                }
                case 178: {
                    n5 = 193;
                    break;
                }
                case 179: {
                    n5 = 159;
                    break;
                }
                case 180: {
                    n5 = 238;
                    break;
                }
                case 181: {
                    n5 = 86;
                    break;
                }
                case 182: {
                    n5 = 181;
                    break;
                }
                case 183: {
                    n5 = 110;
                    break;
                }
                case 184: {
                    n5 = 61;
                    break;
                }
                case 185: {
                    n5 = 184;
                    break;
                }
                case 186: {
                    n5 = 202;
                    break;
                }
                case 187: {
                    n5 = 4;
                    break;
                }
                case 188: {
                    n5 = 58;
                    break;
                }
                case 189: {
                    n5 = 145;
                    break;
                }
                case 190: {
                    n5 = 81;
                    break;
                }
                case 191: {
                    n5 = 32;
                    break;
                }
                case 192: {
                    n5 = 177;
                    break;
                }
                case 193: {
                    n5 = 109;
                    break;
                }
                case 194: {
                    n5 = 50;
                    break;
                }
                case 195: {
                    n5 = 185;
                    break;
                }
                case 196: {
                    n5 = 41;
                    break;
                }
                case 197: {
                    n5 = 208;
                    break;
                }
                case 198: {
                    n5 = 165;
                    break;
                }
                case 199: {
                    n5 = 66;
                    break;
                }
                case 200: {
                    n5 = 213;
                    break;
                }
                case 201: {
                    n5 = 180;
                    break;
                }
                case 202: {
                    n5 = 84;
                    break;
                }
                case 203: {
                    n5 = 69;
                    break;
                }
                case 204: {
                    n5 = 119;
                    break;
                }
                case 205: {
                    n5 = 188;
                    break;
                }
                case 206: {
                    n5 = 29;
                    break;
                }
                case 207: {
                    n5 = 88;
                    break;
                }
                case 208: {
                    n5 = 150;
                    break;
                }
                case 209: {
                    n5 = 14;
                    break;
                }
                case 210: {
                    n5 = 95;
                    break;
                }
                case 211: {
                    n5 = 7;
                    break;
                }
                case 212: {
                    n5 = 198;
                    break;
                }
                case 213: {
                    n5 = 136;
                    break;
                }
                case 214: {
                    n5 = 53;
                    break;
                }
                case 215: {
                    n5 = 1;
                    break;
                }
                case 216: {
                    n5 = 74;
                    break;
                }
                case 217: {
                    n5 = 222;
                    break;
                }
                case 218: {
                    n5 = 31;
                    break;
                }
                case 219: {
                    n5 = 237;
                    break;
                }
                case 220: {
                    n5 = 55;
                    break;
                }
                case 221: {
                    n5 = 22;
                    break;
                }
                case 222: {
                    n5 = 57;
                    break;
                }
                case 223: {
                    n5 = 114;
                    break;
                }
                case 224: {
                    n5 = 140;
                    break;
                }
                case 225: {
                    n5 = 206;
                    break;
                }
                case 226: {
                    n5 = 124;
                    break;
                }
                case 227: {
                    n5 = 2;
                    break;
                }
                case 228: {
                    n5 = 156;
                    break;
                }
                case 229: {
                    n5 = 89;
                    break;
                }
                case 230: {
                    n5 = 234;
                    break;
                }
                case 231: {
                    n5 = 161;
                    break;
                }
                case 232: {
                    n5 = 197;
                    break;
                }
                case 233: {
                    n5 = 195;
                    break;
                }
                case 234: {
                    n5 = 98;
                    break;
                }
                case 235: {
                    n5 = 149;
                    break;
                }
                case 236: {
                    n5 = 223;
                    break;
                }
                case 237: {
                    n5 = 11;
                    break;
                }
                case 238: {
                    n5 = 130;
                    break;
                }
                case 239: {
                    n5 = 245;
                    break;
                }
                case 240: {
                    n5 = 87;
                    break;
                }
                case 241: {
                    n5 = 104;
                    break;
                }
                case 242: {
                    n5 = 217;
                    break;
                }
                case 243: {
                    n5 = 227;
                    break;
                }
                case 244: {
                    n5 = 15;
                    break;
                }
                case 245: {
                    n5 = 45;
                    break;
                }
                case 246: {
                    n5 = 229;
                    break;
                }
                case 247: {
                    n5 = 182;
                    break;
                }
                case 248: {
                    n5 = 60;
                    break;
                }
                case 249: {
                    n5 = 232;
                    break;
                }
                case 250: {
                    n5 = 200;
                    break;
                }
                case 251: {
                    n5 = 143;
                    break;
                }
                case 252: {
                    n5 = 135;
                    break;
                }
                case 253: {
                    n5 = 186;
                    break;
                }
                case 254: {
                    n5 = 111;
                    break;
                }
                default: {
                    n5 = 116;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            Signer.i[n3] = new String(cArray).intern();
        }
        return i[n3];
    }
}

