/*
 * Decompiled with CFR 0.152.
 */
package com.scdroid.ccid;

import com.scdroid.ccid.IReader;
import com.scdroid.smartcard.ATR;
import com.scdroid.smartcard.Card;
import com.scdroid.smartcard.SCException;
import com.scdroid.smartcard.protocol.T1Block;
import com.scdroid.smartcard.protocol.T1BlockEDCErrorException;
import com.scdroid.smartcard.protocol.T1Protocol;
import java.util.Arrays;

public abstract class CCIDReader
extends T1Protocol
implements Cloneable,
IReader {
    private boolean k;
    private byte l;
    private byte m;
    private byte n;
    protected static final String VERSION;
    protected double mCCIDVersion;
    protected int mMaxSlotIndex;
    protected int mVoltageSupport;
    protected int mProtocols;
    protected int mDefaultClock;
    protected int mMaxClock;
    protected byte mNumClockSupported;
    protected int mDataRate;
    protected int mMaxDataRate;
    protected byte mNumDataRatesSupported;
    protected int mMaxIFSD;
    protected int mSynchProtocols;
    protected int mMechanical;
    protected int mFeatures;
    protected int mMaxCCIDMessageLength;
    protected byte mClassGetResponse;
    protected byte mClassEnvelope;
    protected int mLcdLayout;
    protected byte mPINSupport;
    protected byte mMaxCCIDBusySlots;
    protected int[] arrayOfSupportedDataRates;
    private final int o = 8;
    private final int p = 64;
    private final int q = 128;
    private final int r = 0;
    private final int s = 65536;
    private final int t = 131072;
    private final int u = 262144;
    private final int v = 458752;
    private boolean w;
    protected int mLogLevel;
    public static int LOG_INFO;
    public static int LOG_APDU;
    public static int LOG_CCID;
    public static int CARD_EVENT_DETECED;
    public static int CARD_EVENT_REMOVED;
    protected final int bMessageType_OFFSET = 0;
    protected final int STATUS_OFFSET = 7;
    protected final int ERROR_OFFSET = 8;
    private final int x = 9;
    protected final int CCID_ICC_PRESENT_ACTIVE = 0;
    protected final int CCID_ICC_PRESENT_INACTIVE = 1;
    protected final int CCID_ICC_ABSENT = 2;
    private final int y = 3;
    protected final int CCID_COMMAND_FAILED = 64;
    protected final int CCID_TIME_EXTENSION = 128;
    protected final int RDR_to_PC_SlotStatus = 129;
    private final int z = 0;
    private final int A = 1;
    private final int B = 372;
    private final int C = 1;
    public static boolean D;
    private static final String[] db;
    private static final String[] eb;

    public CCIDReader() {
        block4: {
            boolean bl;
            block6: {
                block5: {
                    super(0, 0, 0);
                    this.k = false;
                    this.l = 0;
                    this.m = 1;
                    this.n = 0;
                    this.mCCIDVersion = 1.1f;
                    this.mMaxSlotIndex = 0;
                    this.mVoltageSupport = 1;
                    this.mProtocols = 3;
                    this.mDefaultClock = 3850;
                    this.mMaxClock = 14320;
                    this.mNumClockSupported = 0;
                    this.mDataRate = 9600;
                    this.mMaxDataRate = 115200;
                    this.mNumDataRatesSupported = 0;
                    this.mMaxIFSD = 0;
                    this.mSynchProtocols = 0;
                    this.mMechanical = 0;
                    this.mFeatures = 0;
                    this.mMaxCCIDMessageLength = 0;
                    this.o = 8;
                    boolean bl2 = D;
                    this.p = 64;
                    this.q = 128;
                    this.r = 0;
                    this.s = 65536;
                    this.t = 131072;
                    this.u = 262144;
                    this.v = 458752;
                    this.w = false;
                    this.mLogLevel = 0;
                    this.bMessageType_OFFSET = 0;
                    this.STATUS_OFFSET = 7;
                    this.ERROR_OFFSET = 8;
                    this.x = 9;
                    this.CCID_ICC_PRESENT_ACTIVE = 0;
                    this.CCID_ICC_PRESENT_INACTIVE = 1;
                    this.CCID_ICC_ABSENT = 2;
                    this.y = 3;
                    this.CCID_COMMAND_FAILED = 64;
                    this.CCID_TIME_EXTENSION = 128;
                    this.RDR_to_PC_SlotStatus = 129;
                    this.z = 0;
                    this.A = 1;
                    this.B = 372;
                    this.C = 1;
                    if (!bl2) break block4;
                    if (!SCException.c) break block5;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
            SCException.c = bl;
        }
    }

    protected final void finalize() {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int getSlotCount() {
        return this.mMaxSlotIndex + 1;
    }

    @Override
    public void logLevel(int level) {
        this.mLogLevel = level;
    }

    protected final void logCCID(String message) {
        if ((this.mLogLevel & LOG_CCID) == LOG_CCID) {
            this.logData(CCIDReader.b(-1046, 1124) + message);
        }
    }

    protected final void logData(String module, String message) {
        if (this.mLogLevel > 0) {
            this.logData(module + ":" + message);
        }
    }

    protected final void logData(String title, byte[] data, int length) {
        String string = "";
        boolean bl = D;
        for (int i = 0; i < length; ++i) {
            string = string + String.format(CCIDReader.b(-1054, 13913), data[i]) + " ";
            if (!bl) continue;
        }
        this.logData(title + string);
    }

    protected final void logData(String title, byte[] data) {
        this.logData(title, data, data.length);
    }

    private void a(byte[] byArray) throws SCException {
        byte[] byArray2 = new byte[10 + byArray.length];
        byArray2[0] = 111;
        this.b(byArray2, byArray.length);
        byArray2[5] = this.l;
        this.m = (byte)(this.m + 1);
        byArray2[7] = (byte)this.getBlockWaitingTime();
        byArray2[8] = 0;
        byArray2[9] = 0;
        System.arraycopy(byArray, 0, byArray2, 10, byArray.length);
        this.Write(byArray2);
    }

    private byte[] a(boolean bl) throws SCException {
        byte[] byArray = this.Read();
        if (byArray == null) {
            throw new SCException(CCIDReader.b(-1039, 24598));
        }
        if (byArray.length < 8) {
            throw new SCException(CCIDReader.b(-1036, 24144) + byArray.length + CCIDReader.b(-1040, 26889));
        }
        if ((byArray[7] & 0x80) != 0) {
            return this.a();
        }
        int n = this.f(byArray);
        if (byArray.length - 10 < n) {
            throw new SCException(CCIDReader.b(-1025, 1062) + (byArray.length - 10) + CCIDReader.b(-1027, 18382) + n + CCIDReader.b(-1030, -7338));
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 10, byArray2, 0, n);
        return byArray2;
    }

    private byte[] a() throws SCException {
        return this.a(false);
    }

    private void a(ATR aTR, boolean bl) throws SCException {
        block31: {
            byte[] byArray;
            block29: {
                block30: {
                    block28: {
                        block27: {
                            byArray = new byte[7];
                            byArray[0] = 17;
                            byArray[1] = 16;
                            byArray[2] = 0;
                            byArray[3] = 77;
                            byArray[4] = 0;
                            byArray[5] = 32;
                            byArray[6] = 0;
                            if (aTR.hasPPS1) break block27;
                            if (aTR.TA[2] == null) break block28;
                            if (aTR.TA[1] == null) break block28;
                        }
                        byArray[0] = aTR.TA[1].value;
                    }
                    if (aTR.EDC == 0) {
                        byArray[1] = (byte)(byArray[1] | 1);
                    }
                    if (aTR.TS.value == 63) {
                        byArray[1] = (byte)(byArray[1] | 2);
                    }
                    if (aTR.TC[1] == null) break block29;
                    if (!bl) break block30;
                    if (aTR.TC[1].value == -1) break block29;
                }
                byArray[2] = aTR.TC[1].value;
            }
            byArray[3] = (byte)(aTR.BWI << 4 | aTR.CWI & 0xF);
            if (aTR.IFSC != 32) {
                byArray[5] = aTR.IFSC;
            }
            this.SetParameters((byte)1, byArray);
            if (bl || this.k) break block31;
            if ((this.mFeatures & 0x70000) != 65536) break block31;
            this.initT1Protocol(aTR.IFSD, aTR.IFSC);
            this.k = true;
        }
        this.setBlockWaitingTime(aTR.BWI);
    }

    private void b(ATR aTR, boolean bl) throws SCException {
        byte[] byArray;
        block17: {
            block19: {
                block18: {
                    byArray = new byte[5];
                    byArray[0] = 17;
                    byArray[1] = 0;
                    byArray[2] = 0;
                    byArray[3] = 10;
                    byArray[4] = 0;
                    if (bl) break block17;
                    if (aTR.hasPPS1) break block18;
                    if (aTR.TA[2] == null) break block19;
                    if (aTR.TA[1] == null) break block19;
                }
                byArray[0] = aTR.TA[1].value;
            }
            if (aTR.TS.value == 63) {
                byArray[1] = (byte)(byArray[1] | 2);
            }
            if (aTR.TC[2] != null) {
                byArray[3] = aTR.TC[2].value;
            }
        }
        if (aTR.TC[1] != null) {
            byArray[2] = aTR.TC[1].value;
        }
        this.SetParameters((byte)0, byArray);
    }

    private boolean a(ATR aTR, byte by) throws SCException {
        block60: {
            boolean bl;
            block63: {
                byte[] byArray;
                byte[] byArray2;
                block62: {
                    block61: {
                        int n;
                        int n2;
                        boolean bl2;
                        block59: {
                            block53: {
                                block54: {
                                    block52: {
                                        block51: {
                                            bl2 = D;
                                            if (this.mNumDataRatesSupported != 0) {
                                                this.getReaderDataRates(this.mNumDataRatesSupported);
                                            }
                                            if ((this.mFeatures & 0x40) > 0) {
                                                return true;
                                            }
                                            byArray2 = new byte[6];
                                            this.b(aTR, by);
                                            if (aTR.TC[1] == null || aTR.TC[1].value == 0) break block51;
                                            this.b(aTR, true);
                                        }
                                        if (by != 1) break block52;
                                        byArray2[1] = (byte)(byArray2[1] | 0);
                                        if (!bl2) break block53;
                                    }
                                    if (by != 2) break block54;
                                    byArray2[1] = (byte)(byArray2[1] | 1);
                                    if (!bl2) break block53;
                                }
                                throw new SCException(CCIDReader.b(-1041, -28634));
                            }
                            if (aTR.TA[1] != null) {
                                int n3;
                                block56: {
                                    block58: {
                                        block57: {
                                            block55: {
                                                n2 = aTR.Fi;
                                                n = aTR.Di;
                                                if (0 != n2 && 0 != n) break block55;
                                                n2 = 372;
                                                n = 1;
                                            }
                                            n3 = 1000 * this.mDefaultClock * n / n2;
                                            int n4 = 1000 * this.mDefaultClock * 1 / 372;
                                            if (n3 <= n4 || n3 > this.mMaxDataRate) break block56;
                                            if (this.arrayOfSupportedDataRates == null) break block57;
                                            if (!this.a(n3)) break block58;
                                        }
                                        byArray2[1] = (byte)(byArray2[1] | 0x10);
                                        byArray2[2] = aTR.TA[1].value;
                                        aTR.hasPPS1 = true;
                                        if (!bl2) break block59;
                                    }
                                    if (aTR.TA[2] == null) break block59;
                                    throw new SCException(CCIDReader.b(-1037, 21773));
                                }
                                if (n3 <= this.mMaxDataRate + 2 || aTR.TA[1].value > 151) break block59;
                                if (this.arrayOfSupportedDataRates == null) break block59;
                                byte bl3 = aTR.TA[1].value;
                                while (aTR.TA[1].value > 148) {
                                    aTR.TA[1].value = (byte)(aTR.TA[1].value - 1);
                                    n = aTR.TA[1].value & 0xF;
                                    n2 = aTR.TA[1].value >> 4 & 0xF;
                                    n3 = 1000 * this.mDefaultClock * n / n2;
                                    if (!this.a(n3)) continue;
                                    byArray2[1] = (byte)(byArray2[1] | 0x10);
                                    byArray2[2] = aTR.TA[1].value;
                                    break;
                                }
                                aTR.TA[1].value = bl3;
                            }
                        }
                        byArray2[0] = -1;
                        if ((this.mFeatures & 0x80) != 0 || aTR.TA[2] != null) break block60;
                        n2 = 1;
                        if ((byArray2[1] & 0xF) == 1) {
                            n2 = 2;
                        }
                        if (n2 == aTR.DefaultProtocol && (byArray2[1] & 0x10) <= 0) break block60;
                        n = this.b(byArray2);
                        byte[] byArray3 = new byte[n];
                        System.arraycopy(byArray2, 0, byArray3, 0, n);
                        byArray3[n - 1] = this.a(byArray2, n - 1);
                        byArray = this.c(byArray3);
                        bl = this.a(byArray3, byArray);
                        if (aTR.TA[1] != null) break block61;
                        aTR.setTA1((byte)17);
                        if (!bl2) break block62;
                    }
                    aTR.TA[1].value = (byte)17;
                }
                if ((byArray2[1] & 0x10) <= 0 || (byArray[1] & 0x10) <= 0) break block63;
                aTR.TA[1].value = byArray[2];
            }
            return bl;
        }
        return true;
    }

    private final boolean a(byte[] byArray, byte[] byArray2) {
        block42: {
            block40: {
                block41: {
                    block38: {
                        block39: {
                            block36: {
                                block37: {
                                    block35: {
                                        if (byArray[0] == -1 && byArray2[0] == -1) break block35;
                                        return false;
                                    }
                                    if (Arrays.equals(byArray, byArray2)) {
                                        return true;
                                    }
                                    if ((byArray2[1] & 0xF) != (byArray[1] & 0xF)) {
                                        return false;
                                    }
                                    if ((byArray2[1] & 0x10) != 16) break block36;
                                    if ((byArray[1] & 0x10) == 16) break block37;
                                    return false;
                                }
                                if (byArray[2] != byArray2[2]) {
                                    return false;
                                }
                            }
                            if ((byArray2[1] & 0x20) != 32) break block38;
                            if ((byArray[1] & 0x20) == 32) break block39;
                            return false;
                        }
                        if (byArray[3] != byArray2[3]) {
                            return false;
                        }
                    }
                    if ((byArray2[1] & 0x40) != 64) break block40;
                    if ((byArray[1] & 0x40) == 64) break block41;
                    return false;
                }
                if (byArray[4] != byArray2[4]) {
                    return false;
                }
            }
            if (this.a(byArray, byArray.length) == 0 && this.a(byArray2, byArray2.length) == 0) break block42;
            return false;
        }
        return true;
    }

    private final void b(ATR aTR, byte by) throws SCException {
        block29: {
            boolean bl;
            block31: {
                block30: {
                    int n;
                    int n2;
                    block28: {
                        bl = D;
                        if (aTR.TA[1] == null) {
                            return;
                        }
                        n2 = aTR.Fi;
                        n = aTR.Di;
                        if (0 != n2 && 0 != n) break block28;
                        return;
                    }
                    int n3 = 1000 * this.mDefaultClock * n / n2;
                    int n4 = 1000 * this.mDefaultClock * 1 / 372;
                    if (n3 <= n4) {
                        return;
                    }
                    if (aTR.TC[1] == null) break block29;
                    if (aTR.TC[1].value == 0) break block30;
                    if (aTR.TC[1].value != -1) break block29;
                }
                if (1 != by) break block31;
                aTR.TC[1].value = (byte)2;
            }
            if (2 == by) {
                for (int i = 3; i < 7; ++i) {
                    if (i >= aTR.TB.length || aTR.TB[i] == null) continue;
                    if ((aTR.TB[i].value & 0xF) < 2) continue;
                    aTR.TC[1].value = (byte)2;
                    if (!bl) break;
                    continue;
                }
            }
        }
    }

    private boolean a(int n) {
        boolean bl = D;
        if (this.arrayOfSupportedDataRates == null) {
            return false;
        }
        int n2 = this.arrayOfSupportedDataRates.length;
        int n3 = 2;
        for (int i = 0; i < n2; ++i) {
            if (n >= this.arrayOfSupportedDataRates[i] + 2 || n <= this.arrayOfSupportedDataRates[i] - 2) continue;
            return true;
        }
        return false;
    }

    private int b(byte[] byArray) {
        int n = 3;
        if ((byArray[1] & 0x10) > 0) {
            ++n;
        }
        if ((byArray[1] & 0x20) > 0) {
            ++n;
        }
        if ((byArray[1] & 0x40) > 0) {
            ++n;
        }
        return n;
    }

    private byte a(byte[] byArray, int n) {
        byte by = byArray[0];
        boolean bl = D;
        for (int i = 1; i < n; ++i) {
            by = (byte)(by ^ byArray[i]);
            if (!bl) continue;
        }
        return by;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(byte[] byArray, byte by) throws SCException {
        boolean bl;
        ATR aTR;
        block30: {
            byte by2;
            block29: {
                int n;
                block28: {
                    block27: {
                        aTR = new ATR(byArray);
                        aTR.printATR();
                        this.n = aTR.DefaultProtocol;
                        by = (byte)(by & aTR.AvailableProtocols);
                        by2 = 0;
                        bl = D;
                        if ((by & 2) <= 0) break block27;
                        by2 = 2;
                        if (!bl) break block28;
                    }
                    if ((by & 1) <= 0) throw new SCException(CCIDReader.b(-1043, 22792));
                    by2 = 1;
                    if (bl) {
                        throw new SCException(CCIDReader.b(-1043, 22792));
                    }
                }
                if (by2 == 2) {
                    aTR.setIFSD((byte)this.mMaxIFSD);
                }
                if ((this.mFeatures & 0x40) > 0) {
                    this.n = by2;
                    return;
                }
                if (aTR.TA[2] == null) break block29;
                byte by3 = (byte)(aTR.TA[2].value & 0xF);
                switch (by3) {
                    case 0: {
                        n = 1;
                        if (!bl) break;
                    }
                    case 1: {
                        n = 2;
                        if (!bl) break;
                    }
                    default: {
                        throw new SCException(-10);
                    }
                }
                if ((n & aTR.AvailableProtocols) != n) {
                    throw new SCException(-10);
                }
                this.n = (byte)n;
                if (!bl) break block30;
            }
            if (!this.a(aTR, by2)) throw new SCException(-2);
            this.n = by2;
            if (bl) {
                throw new SCException(-2);
            }
        }
        if (this.n == 2) {
            this.a(aTR, false);
            if (!bl) return;
        }
        this.b(aTR, false);
    }

    private final byte[] a(byte by) throws SCException {
        byte[] byArray = new byte[10];
        byArray[0] = 98;
        byArray[4] = 0;
        byArray[3] = 0;
        byArray[2] = 0;
        byArray[1] = 0;
        byArray[5] = this.l;
        this.m = (byte)(this.m + 1);
        byArray[7] = 0;
        byArray[9] = 0;
        byArray[8] = 0;
        if ((this.mFeatures & 8) > 0) {
            by = 0;
        }
        byArray[7] = by;
        this.Write(byArray);
        byte[] byArray2 = this.Read();
        if (byArray2.length < 8) {
            throw new SCException(CCIDReader.b(-1052, -30215) + byArray2.length + CCIDReader.b(-1040, 26889));
        }
        if ((byArray2[7] & 0x40) != 0) {
            throw new SCException(byArray2[8]);
        }
        int n = this.f(byArray2);
        if (n > byArray2.length) {
            n = byArray2.length;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 10, byArray3, 0, n);
        return byArray3;
    }

    public final byte[] PowerOn() throws SCException {
        Byte by = null;
        boolean bl = D;
        for (byte by2 = 3; by2 > 0; by2 = (byte)(by2 - 1)) {
            try {
                byte[] byArray = this.a(by2);
                return byArray;
            }
            catch (SCException sCException) {
                sCException.printStackTrace();
                by = sCException.getErrorCode();
                if (!bl) continue;
            }
        }
        if (by != null) {
            throw new SCException(by);
        }
        throw new SCException(CCIDReader.b(-1031, -24281));
    }

    public final void PowerOff() throws SCException {
        if (!this.w) {
            return;
        }
        byte[] byArray = new byte[10];
        byArray[0] = 99;
        byArray[4] = 0;
        byArray[3] = 0;
        byArray[2] = 0;
        byArray[1] = 0;
        byArray[5] = this.l;
        this.m = (byte)(this.m + 1);
        byArray[9] = 0;
        byArray[8] = 0;
        byArray[7] = 0;
        this.Write(byArray);
        byte[] byArray2 = this.Read();
        if (byArray2.length < 8) {
            throw new SCException(CCIDReader.b(-1052, -30215) + byArray2.length + CCIDReader.b(-1040, 26889));
        }
        if ((byArray2[7] & 0x40) != 0) {
            throw new SCException(CCIDReader.b(-1088, 15471) + String.format(CCIDReader.b(-1054, 13913), byArray2[8]));
        }
    }

    public final int GetSlotStatus() throws SCException {
        byte[] byArray;
        block7: {
            byte[] byArray2 = new byte[10];
            byArray2[0] = 101;
            byArray2[4] = 0;
            byArray2[3] = 0;
            byArray2[2] = 0;
            byArray2[1] = 0;
            byArray2[5] = this.l;
            this.m = (byte)(this.m + 1);
            byArray2[9] = 0;
            byArray2[8] = 0;
            byArray2[7] = 0;
            this.Write(byArray2);
            byArray = this.Read();
            if (byArray.length < 8) {
                throw new SCException(CCIDReader.b(-1052, -30215) + byArray.length + CCIDReader.b(-1040, 26889));
            }
            if ((byArray[7] & 0x40) == 0 || byArray[8] == -2) break block7;
            throw new SCException(CCIDReader.b(-1088, 15471) + String.format(CCIDReader.b(-1054, 13913), byArray[8]));
        }
        return byArray[7] & 3;
    }

    private final byte[] a(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = new byte[byArray.length + n];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, n);
        return byArray3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] c(byte[] byArray) throws SCException {
        boolean bl = D;
        if (byArray.length > this.mMaxCCIDMessageLength - 10) {
            throw new SCException(CCIDReader.b(-1029, -21903) + byArray.length + CCIDReader.b(-1028, 22887) + (this.mMaxCCIDMessageLength - 10) + CCIDReader.b(-1040, 26889));
        }
        this.a(byArray);
        byte[] byArray2 = this.a();
        if ((this.mFeatures & 0x70000) == 65536) return byArray2;
        if (byArray2.length < 2) return byArray2;
        byte by = (byte)(byArray2[byArray2.length - 2] & 0xFF);
        byte by2 = (byte)(byArray2[byArray2.length - 1] & 0xFF);
        if (by == 108) {
            byArray[byArray.length - 1] = by2;
            this.a(byArray);
            byArray2 = this.a();
            if (!bl) return byArray2;
        }
        if (by != 97) return byArray2;
        byte[] byArray3 = new byte[]{0, -64, 0, 0, 0};
        byte[] byArray4 = new byte[byArray2.length - 2];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length - 2);
        byArray3[4] = by2;
        byArray2 = this.c(byArray3);
        if (byArray2.length >= 2 && byArray2[byArray2.length - 2] == 97) {
            byArray4 = this.a(byArray4, byArray2, byArray2.length - 2);
            if (!bl) return byArray4;
        }
        byArray4 = this.a(byArray4, byArray2, byArray2.length);
        return byArray4;
    }

    @Override
    protected T1Block exchangeData(T1Block sendBlock) throws SCException, T1BlockEDCErrorException {
        byte[] byArray = sendBlock.getBlock();
        try {
            byte[] byArray2 = this.c(byArray);
            T1Block t1Block = new T1Block(byArray2, 1);
            return t1Block;
        }
        catch (T1BlockEDCErrorException t1BlockEDCErrorException) {
            t1BlockEDCErrorException.printStackTrace();
            throw t1BlockEDCErrorException;
        }
        catch (SCException sCException) {
            sCException.printStackTrace();
            throw new SCException(-2);
        }
    }

    private final byte[] d(byte[] byArray) throws SCException {
        byte[] byArray2 = this.transmitT1(byArray);
        return byArray2;
    }

    private final byte[] e(byte[] byArray) throws SCException {
        this.logCCID(CCIDReader.b(-1049, -30761) + byArray.length + CCIDReader.b(-1048, 20404));
        boolean bl = false;
        boolean bl2 = false;
        if (byArray.length > this.mMaxCCIDMessageLength - 10) {
            throw new SCException(CCIDReader.b(-1038, 16200));
        }
        return this.c(byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] XfrBlock(byte[] apdu) throws SCException {
        if (apdu == null) {
            throw new NullPointerException();
        }
        switch (this.mFeatures & 0x70000) {
            case 65536: {
                if (this.n == 1) {
                    return this.c(apdu);
                }
                if (this.n == 2) {
                    return this.d(apdu);
                }
                throw new SCException(CCIDReader.b(-1087, -10382));
            }
            case 131072: {
                return this.c(apdu);
            }
            case 262144: {
                return this.e(apdu);
            }
            case 0: {
                throw new SCException(CCIDReader.b(-1047, 28980));
            }
        }
        throw new SCException(CCIDReader.b(-1045, 30810));
    }

    @Override
    public final byte[] Transmit(byte[] apdu) throws SCException {
        if ((this.mLogLevel & LOG_APDU) == LOG_APDU) {
            this.logData(CCIDReader.b(-1033, 20126), apdu);
        }
        byte[] byArray = this.XfrBlock(apdu);
        if ((this.mLogLevel & LOG_APDU) == LOG_APDU) {
            this.logData(CCIDReader.b(-1051, 2470), byArray);
        }
        return byArray;
    }

    private final void b(byte[] byArray, int n) {
        byArray[1] = (byte)(n & 0xFF);
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n >> 16 & 0xFF);
        byArray[4] = (byte)(n >> 24 & 0xFF);
    }

    private final int f(byte[] byArray) {
        int n = byArray[1] & 0xFF;
        n += byArray[2] << 8 & 0xFF00;
        n += byArray[3] << 16 & 0xFF0000;
        return n += byArray[4] << 24 & 0xFF000000;
    }

    public final byte[] GetParameters() throws SCException {
        byte[] byArray = new byte[10];
        byArray[0] = 108;
        byArray[4] = 0;
        byArray[3] = 0;
        byArray[2] = 0;
        byArray[1] = 0;
        byArray[5] = this.l;
        this.m = (byte)(this.m + 1);
        byArray[9] = 0;
        byArray[8] = 0;
        byArray[7] = 0;
        this.Write(byArray);
        byte[] byArray2 = this.Read();
        if (byArray2.length < 8) {
            throw new SCException(CCIDReader.b(-1052, -30215) + byArray2.length + CCIDReader.b(-1040, 26889));
        }
        if ((byArray2[7] & 0x40) != 0) {
            throw new SCException(CCIDReader.b(-1088, 15471) + String.format(CCIDReader.b(-1054, 13913), byArray2[8]));
        }
        return byArray2;
    }

    public final void SetParameters(byte protocol, byte[] param) throws SCException {
        block11: {
            byte[] byArray;
            block13: {
                byte[] byArray2;
                block12: {
                    byArray2 = new byte[10 + param.length];
                    byArray2[0] = 97;
                    this.b(byArray2, param.length);
                    byArray2[5] = this.l;
                    this.m = (byte)(this.m + 1);
                    byArray2[7] = protocol;
                    byArray2[9] = 0;
                    byArray2[8] = 0;
                    System.arraycopy(param, 0, byArray2, 10, param.length);
                    this.Write(byArray2);
                    byArray = this.Read();
                    if (byArray.length < 8) {
                        throw new SCException(CCIDReader.b(-1052, -30215) + byArray.length + CCIDReader.b(-1040, 26889));
                    }
                    if ((byArray[7] & 0x40) == 0) break block11;
                    if (0 != byArray2[8]) break block12;
                    throw new SCException(CCIDReader.b(-1026, 24732));
                }
                if (byArray2[8] < 1 || byArray2[8] > 127) break block13;
                return;
            }
            throw new SCException(CCIDReader.b(-1088, 15471) + String.format(CCIDReader.b(-1054, 13913), byArray[8]));
        }
    }

    public final byte[] Escape(byte[] espcmd) throws SCException {
        if (espcmd == null) {
            throw new NullPointerException();
        }
        byte[] byArray = new byte[10 + espcmd.length];
        byArray[0] = 107;
        this.b(byArray, espcmd.length);
        byArray[5] = this.l;
        this.m = (byte)(this.m + 1);
        byArray[9] = 0;
        byArray[8] = 0;
        byArray[7] = 0;
        System.arraycopy(espcmd, 0, byArray, 10, espcmd.length);
        this.Write(byArray);
        byte[] byArray2 = this.Read();
        if (byArray2.length < 8) {
            throw new SCException(CCIDReader.b(-1052, -30215) + byArray2.length + CCIDReader.b(-1040, 26889));
        }
        if ((byArray2[7] & 0x40) != 0) {
            throw new SCException(CCIDReader.b(-1053, 14643) + String.format(CCIDReader.b(-1035, 12744), byArray2[8]));
        }
        int n = this.f(byArray2);
        if (n > byArray2.length) {
            n = byArray2.length;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 10, byArray3, 0, n);
        return byArray3;
    }

    public final byte[] ConnectCard(int Slot, byte PreferredProtocols) throws SCException {
        if (Slot > this.mMaxSlotIndex) {
            throw new SCException(CCIDReader.b(-1055, 4837) + this.mMaxSlotIndex);
        }
        this.l = (byte)Slot;
        int n = this.GetSlotStatus();
        if (n == 2) {
            return null;
        }
        byte[] byArray = this.PowerOn();
        this.w = true;
        this.k = false;
        this.a(byArray, PreferredProtocols);
        return byArray;
    }

    public final byte[] ConnectCard(byte PreferredProtocols) throws SCException {
        return this.ConnectCard(0, PreferredProtocols);
    }

    @Override
    public final Card ConnectCard(String CardClass, int Slot, byte PreferredProtocols) throws SCException {
        byte[] byArray = this.ConnectCard(Slot, PreferredProtocols);
        if (byArray == null) {
            return null;
        }
        Card card = null;
        try {
            Class<?> clazz = Class.forName(CardClass);
            card = (Card)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SCException(CCIDReader.b(-1042, -23940), classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new SCException(CCIDReader.b(-1056, 19759), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SCException(CCIDReader.b(-1034, -12031), illegalAccessException);
        }
        try {
            card.AttachReader((IReader)this.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SCException(CCIDReader.b(-1032, -16116));
        }
        if (card.IdentifyCard(byArray)) {
            return card;
        }
        throw new SCException(CCIDReader.b(-1050, -18850) + CardClass);
    }

    @Override
    public final Card ConnectCard(String CardClass, byte PreferredProtocols) throws SCException {
        return this.ConnectCard(CardClass, 0, PreferredProtocols);
    }

    @Override
    public boolean isCardPresent() throws SCException {
        int n = this.GetSlotStatus();
        if (n == 2) {
            return false;
        }
        return true;
    }

    @Override
    public final void DisConnectCard() throws SCException {
        this.PowerOff();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void WaitCardEvent(int event) throws SCException {
        int n = 0;
        while (true) {
            n = this.GetSlotStatus();
            if (event == CARD_EVENT_DETECED ? n == 0 || n == 1 : n == 2) {
                return;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void getReaderDataRates(byte numDataRateSupported) {
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00947\u00e9Dk\u00c1\u0095\u00a8\u00c5a=^`\u00d1\u00e0\u00eb\u00aa\u00df\u00ac\u00eb\u0013\u008e\u00ee\u00a8\u00fb\u00c6)6\u0012'\u009a4K\u00a8\u00fc\u00a6P\u009a\u00dd\u00b8|<\u00a7Gd\u00ccb\u001cJ\f\u00cc!\u008b\u008a\u00b06,\u0094\u00e4r]\u00e1\u00d5\u00cd\u00c8\\\u00e9L\u00e17\u00baO \u00a7H\"\u0006\f\u00a7\u00c3\u001c\u00b8\u00ec\u0005\u001a\u00b6\u00fb\u00a6\u0018\u0019\u00e8\u0001\tM\u00ec\u00e2\u00b1\u008f\u0006\u00a5\u00a4\u00e7\u00d0\u00ea3R\u00be\u00c4\u00da5\u00b7\u001c\u0002\u00b8|\u0010\u00c8)\u0010PNJ\u0016\u00f1\u0005M\u00c2=\u00d5\u00cdm@\u0011x\u0094{KY\u0016\u00e4\u00ba`\u00acB\u0090-\u00eb\u00eb\u007f8$\u0002\u0096p\u00bf\u00d5\u00a7]Zo\u00a0\u00d4Z\u0002\u008d+s\u00ae\u00fe\u00be\u00b4\u00d5z?\u00e9\u00bf\u00c3\"\u001b\u00c5\u00ea\u00f5\u008d\u0082\u00bb\u00f0\u00b4\u0006\u00e1\u009e\u0086F\u00b1@\u0017$_E\u00c8\u0017S\n\u0080!YY\u00b9\u000f\u00c6\u00c0\u0098\u00d5~.\u0098\u00f4E\u0005\u0005,\u00d4\u0000:\b\u001e[c\u00b1\u00fdm\u00fb\u00d0C\u001fUD\u00b2!\nL?\u007f$K\u00dc}w\u00e2_\u0082\u00f1\u00bc-\u007f\u0013\u0005\u0013&\u00a0\u00ce\u0004\u0016\u00d8\u00f8\u00ed\u0098\u0002\u008b'\u0017\u0093\u008a\u00f6\u00d4}\u0099\u00fb\u008b3\u00af8\u0002\u00d4\u00db\u000f=\u00b0.K\u00a9U\u00cc\u00e4\u009b\u00d9 \"\u00da\"\u00e1\u000f\u00a2<\u00d1\u00a7\u00c9[\u009a\u00ed\u001a\u0017\u001b\u0091\u00cd\u0004J\u0006I\u00b3\u0093\u00e3\u0013\u00f4\u0091\u00db\u00cep_X\u00bc\u009a\u00dd*/740\u0016\u00ab\u009d\u00c6\u0004\u0097!\u0011\f>\u0002jY\u00e8F\u00ca\u00f4\u00b7\u001d;\u00e7G\u00bc@Y\u00db\u00f8-\u00f1\u00ce\u00baS3)kY=jc\u0001\u00dak?\u00b2\u00f3\u0093\u00fd\u00bf\u00fb\u00d6?T)\u00be\u00ed\u0093\u007f_\u00e0\u00b6\u0087\u00fc\u00ec\u00b5\u00f1N\u0016&yD\u00ef\u00e9\u00df\u00bf\u00db\u00ec\u000fF\u00be\u00e6\u00b8R\u0018\u00e6\u00a1C\b\u00d7\u0085%@\u00c7~f\u00ff\u00a1$dc\"\u00a8\u00af,\u00bb\n\u00b1\u00d7\u00f5y\u001a8\u0096\u00b5S\u0096d\u00a4\u009f\u00e7\u00d5\u00bd\u00d2\u007f\u001b\u00f1\u00fd\u00f1\u0010\u00ae\u00983S%\nw\u0087\u00c9\u00f2]VGQY\u00c8v\u008b\u00de\u00b8\u00b3\u00e2-\u00a3br\u00a0\u001d\u00b8\u00bb\u00e7\u00e5?\u008d\u009eM\u0090W\u00bd\u00ddt\u00f0\u0006i\u009co{-\u0000\u0019\u00de\u00d1\u00cfW4\u00a1\u00aa\u00e7e\u00a8\u00c8F]\u00de\u0082\u00d4\u0088\u0014\u001c/o_\u0019\u00d0\u001f\u0005\u00b6\u0088Bs\u0083\u000eh\u00e5\u00c2\u00f7\u008cW\u00fc\u0082\u00ca\u00f0\u00b8&j\u00f4\f\u0086\u007f\u001a\u00c7\u00fa\u007f\u0087l\u00e0/\u0010\u0096\u0012\u00b7\u0095U\u00f2\u001f\u00dc\u00e9\u00e8\u00ed\u0083\u00df\n`\"S\u00d4Nt\u0012\u0018\u00ab\u00a2U\u00a7\u0005W&\u00a3h.\u00fd*~\u00cf\u00ff\u009d\u0093\nr\u001a\u00f55\u00fe\u00ba\u00e88V\u0000\b)\u00b5\u0093\u008f\u00dbe\u00b3\u000b\u0011\u0087kJ\u00f8(\u0097o\u00caR\u00f5]N\u00fb\u0006\u00c2b\u00e8\u0015[\u0007\u00c9E\u00bcJ\u0095\r:\u00eb\u00e5\u00a6\u00f5\u007fz\u00bf\u00ed\u00a4\u00c3O\u0097\u001b\u00c1c\u0092:\u009bn\u00d5\u0099G`\u008b\u00d6\u00caL/\u0017\u00d5\u008fa\u00a1\u00cb\u009a\u00bd\u00b8\u008e\u001cN";
                var4_3 = "\u00947\u00e9Dk\u00c1\u0095\u00a8\u00c5a=^`\u00d1\u00e0\u00eb\u00aa\u00df\u00ac\u00eb\u0013\u008e\u00ee\u00a8\u00fb\u00c6)6\u0012'\u009a4K\u00a8\u00fc\u00a6P\u009a\u00dd\u00b8|<\u00a7Gd\u00ccb\u001cJ\f\u00cc!\u008b\u008a\u00b06,\u0094\u00e4r]\u00e1\u00d5\u00cd\u00c8\\\u00e9L\u00e17\u00baO \u00a7H\"\u0006\f\u00a7\u00c3\u001c\u00b8\u00ec\u0005\u001a\u00b6\u00fb\u00a6\u0018\u0019\u00e8\u0001\tM\u00ec\u00e2\u00b1\u008f\u0006\u00a5\u00a4\u00e7\u00d0\u00ea3R\u00be\u00c4\u00da5\u00b7\u001c\u0002\u00b8|\u0010\u00c8)\u0010PNJ\u0016\u00f1\u0005M\u00c2=\u00d5\u00cdm@\u0011x\u0094{KY\u0016\u00e4\u00ba`\u00acB\u0090-\u00eb\u00eb\u007f8$\u0002\u0096p\u00bf\u00d5\u00a7]Zo\u00a0\u00d4Z\u0002\u008d+s\u00ae\u00fe\u00be\u00b4\u00d5z?\u00e9\u00bf\u00c3\"\u001b\u00c5\u00ea\u00f5\u008d\u0082\u00bb\u00f0\u00b4\u0006\u00e1\u009e\u0086F\u00b1@\u0017$_E\u00c8\u0017S\n\u0080!YY\u00b9\u000f\u00c6\u00c0\u0098\u00d5~.\u0098\u00f4E\u0005\u0005,\u00d4\u0000:\b\u001e[c\u00b1\u00fdm\u00fb\u00d0C\u001fUD\u00b2!\nL?\u007f$K\u00dc}w\u00e2_\u0082\u00f1\u00bc-\u007f\u0013\u0005\u0013&\u00a0\u00ce\u0004\u0016\u00d8\u00f8\u00ed\u0098\u0002\u008b'\u0017\u0093\u008a\u00f6\u00d4}\u0099\u00fb\u008b3\u00af8\u0002\u00d4\u00db\u000f=\u00b0.K\u00a9U\u00cc\u00e4\u009b\u00d9 \"\u00da\"\u00e1\u000f\u00a2<\u00d1\u00a7\u00c9[\u009a\u00ed\u001a\u0017\u001b\u0091\u00cd\u0004J\u0006I\u00b3\u0093\u00e3\u0013\u00f4\u0091\u00db\u00cep_X\u00bc\u009a\u00dd*/740\u0016\u00ab\u009d\u00c6\u0004\u0097!\u0011\f>\u0002jY\u00e8F\u00ca\u00f4\u00b7\u001d;\u00e7G\u00bc@Y\u00db\u00f8-\u00f1\u00ce\u00baS3)kY=jc\u0001\u00dak?\u00b2\u00f3\u0093\u00fd\u00bf\u00fb\u00d6?T)\u00be\u00ed\u0093\u007f_\u00e0\u00b6\u0087\u00fc\u00ec\u00b5\u00f1N\u0016&yD\u00ef\u00e9\u00df\u00bf\u00db\u00ec\u000fF\u00be\u00e6\u00b8R\u0018\u00e6\u00a1C\b\u00d7\u0085%@\u00c7~f\u00ff\u00a1$dc\"\u00a8\u00af,\u00bb\n\u00b1\u00d7\u00f5y\u001a8\u0096\u00b5S\u0096d\u00a4\u009f\u00e7\u00d5\u00bd\u00d2\u007f\u001b\u00f1\u00fd\u00f1\u0010\u00ae\u00983S%\nw\u0087\u00c9\u00f2]VGQY\u00c8v\u008b\u00de\u00b8\u00b3\u00e2-\u00a3br\u00a0\u001d\u00b8\u00bb\u00e7\u00e5?\u008d\u009eM\u0090W\u00bd\u00ddt\u00f0\u0006i\u009co{-\u0000\u0019\u00de\u00d1\u00cfW4\u00a1\u00aa\u00e7e\u00a8\u00c8F]\u00de\u0082\u00d4\u0088\u0014\u001c/o_\u0019\u00d0\u001f\u0005\u00b6\u0088Bs\u0083\u000eh\u00e5\u00c2\u00f7\u008cW\u00fc\u0082\u00ca\u00f0\u00b8&j\u00f4\f\u0086\u007f\u001a\u00c7\u00fa\u007f\u0087l\u00e0/\u0010\u0096\u0012\u00b7\u0095U\u00f2\u001f\u00dc\u00e9\u00e8\u00ed\u0083\u00df\n`\"S\u00d4Nt\u0012\u0018\u00ab\u00a2U\u00a7\u0005W&\u00a3h.\u00fd*~\u00cf\u00ff\u009d\u0093\nr\u001a\u00f55\u00fe\u00ba\u00e88V\u0000\b)\u00b5\u0093\u008f\u00dbe\u00b3\u000b\u0011\u0087kJ\u00f8(\u0097o\u00caR\u00f5]N\u00fb\u0006\u00c2b\u00e8\u0015[\u0007\u00c9E\u00bcJ\u0095\r:\u00eb\u00e5\u00a6\u00f5\u007fz\u00bf\u00ed\u00a4\u00c3O\u0097\u001b\u00c1c\u0092:\u009bn\u00d5\u0099G`\u008b\u00d6\u00caL/\u0017\u00d5\u008fa\u00a1\u00cb\u009a\u00bd\u00b8\u008e\u001cN".length();
                var1_4 = 28;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "F\u00a8\t6\u008d\u0091*\u007f}\u0091\u008d\u0003\u0012e\f\u00ae\u00c4\u0093\u009b\u001eR\u00d7\u0093\u00eb\u001c\u00fdX:\u00abU\u00dbk\u001cW\u00d1\u008b\u00da\u00b0\u00f4ho\u007f\b\u001f\u00c6?fae[\u00e2'\u008a";
                    var4_3 = "F\u00a8\t6\u008d\u0091*\u007f}\u0091\u008d\u0003\u0012e\f\u00ae\u00c4\u0093\u009b\u001eR\u00d7\u0093\u00eb\u001c\u00fdX:\u00abU\u00dbk\u001cW\u00d1\u008b\u00da\u00b0\u00f4ho\u007f\b\u001f\u00c6?fae[\u00e2'\u008a".length();
                    var1_4 = 24;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 36;
                            break;
                        }
                        case 1: {
                            v13 = 124;
                            break;
                        }
                        case 2: {
                            v13 = 99;
                            break;
                        }
                        case 3: {
                            v13 = 64;
                            break;
                        }
                        case 4: {
                            v13 = 62;
                            break;
                        }
                        case 5: {
                            v13 = 9;
                            break;
                        }
                        default: {
                            v13 = 77;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CCIDReader.db = var5;
        CCIDReader.eb = new String[34];
        CCIDReader.VERSION = CCIDReader.b(-1044, -7821);
        CCIDReader.LOG_INFO = 1;
        CCIDReader.LOG_APDU = 2;
        CCIDReader.LOG_CCID = 4;
        CCIDReader.CARD_EVENT_DETECED = 1;
        CCIDReader.CARD_EVENT_REMOVED = 2;
    }

    private static String b(int n, int n2) {
        int n3 = (n ^ 0xFFFFFBE1) & 0xFFFF;
        if (eb[n3] == null) {
            int n4;
            int n5;
            char[] cArray = db[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 17;
                    break;
                }
                case 1: {
                    n5 = 88;
                    break;
                }
                case 2: {
                    n5 = 159;
                    break;
                }
                case 3: {
                    n5 = 197;
                    break;
                }
                case 4: {
                    n5 = 105;
                    break;
                }
                case 5: {
                    n5 = 193;
                    break;
                }
                case 6: {
                    n5 = 179;
                    break;
                }
                case 7: {
                    n5 = 64;
                    break;
                }
                case 8: {
                    n5 = 25;
                    break;
                }
                case 9: {
                    n5 = 229;
                    break;
                }
                case 10: {
                    n5 = 211;
                    break;
                }
                case 11: {
                    n5 = 7;
                    break;
                }
                case 12: {
                    n5 = 84;
                    break;
                }
                case 13: {
                    n5 = 161;
                    break;
                }
                case 14: {
                    n5 = 72;
                    break;
                }
                case 15: {
                    n5 = 23;
                    break;
                }
                case 16: {
                    n5 = 201;
                    break;
                }
                case 17: {
                    n5 = 170;
                    break;
                }
                case 18: {
                    n5 = 127;
                    break;
                }
                case 19: {
                    n5 = 33;
                    break;
                }
                case 20: {
                    n5 = 97;
                    break;
                }
                case 21: {
                    n5 = 129;
                    break;
                }
                case 22: {
                    n5 = 36;
                    break;
                }
                case 23: {
                    n5 = 3;
                    break;
                }
                case 24: {
                    n5 = 10;
                    break;
                }
                case 25: {
                    n5 = 2;
                    break;
                }
                case 26: {
                    n5 = 138;
                    break;
                }
                case 27: {
                    n5 = 184;
                    break;
                }
                case 28: {
                    n5 = 144;
                    break;
                }
                case 29: {
                    n5 = 59;
                    break;
                }
                case 30: {
                    n5 = 158;
                    break;
                }
                case 31: {
                    n5 = 48;
                    break;
                }
                case 32: {
                    n5 = 143;
                    break;
                }
                case 33: {
                    n5 = 32;
                    break;
                }
                case 34: {
                    n5 = 198;
                    break;
                }
                case 35: {
                    n5 = 78;
                    break;
                }
                case 36: {
                    n5 = 194;
                    break;
                }
                case 37: {
                    n5 = 145;
                    break;
                }
                case 38: {
                    n5 = 236;
                    break;
                }
                case 39: {
                    n5 = 196;
                    break;
                }
                case 40: {
                    n5 = 76;
                    break;
                }
                case 41: {
                    n5 = 209;
                    break;
                }
                case 42: {
                    n5 = 5;
                    break;
                }
                case 43: {
                    n5 = 239;
                    break;
                }
                case 44: {
                    n5 = 130;
                    break;
                }
                case 45: {
                    n5 = 22;
                    break;
                }
                case 46: {
                    n5 = 210;
                    break;
                }
                case 47: {
                    n5 = 178;
                    break;
                }
                case 48: {
                    n5 = 91;
                    break;
                }
                case 49: {
                    n5 = 148;
                    break;
                }
                case 50: {
                    n5 = 1;
                    break;
                }
                case 51: {
                    n5 = 87;
                    break;
                }
                case 52: {
                    n5 = 118;
                    break;
                }
                case 53: {
                    n5 = 68;
                    break;
                }
                case 54: {
                    n5 = 13;
                    break;
                }
                case 55: {
                    n5 = 109;
                    break;
                }
                case 56: {
                    n5 = 240;
                    break;
                }
                case 57: {
                    n5 = 233;
                    break;
                }
                case 58: {
                    n5 = 120;
                    break;
                }
                case 59: {
                    n5 = 136;
                    break;
                }
                case 60: {
                    n5 = 242;
                    break;
                }
                case 61: {
                    n5 = 181;
                    break;
                }
                case 62: {
                    n5 = 90;
                    break;
                }
                case 63: {
                    n5 = 108;
                    break;
                }
                case 64: {
                    n5 = 81;
                    break;
                }
                case 65: {
                    n5 = 146;
                    break;
                }
                case 66: {
                    n5 = 180;
                    break;
                }
                case 67: {
                    n5 = 208;
                    break;
                }
                case 68: {
                    n5 = 89;
                    break;
                }
                case 69: {
                    n5 = 250;
                    break;
                }
                case 70: {
                    n5 = 227;
                    break;
                }
                case 71: {
                    n5 = 102;
                    break;
                }
                case 72: {
                    n5 = 51;
                    break;
                }
                case 73: {
                    n5 = 237;
                    break;
                }
                case 74: {
                    n5 = 142;
                    break;
                }
                case 75: {
                    n5 = 45;
                    break;
                }
                case 76: {
                    n5 = 220;
                    break;
                }
                case 77: {
                    n5 = 96;
                    break;
                }
                case 78: {
                    n5 = 177;
                    break;
                }
                case 79: {
                    n5 = 190;
                    break;
                }
                case 80: {
                    n5 = 251;
                    break;
                }
                case 81: {
                    n5 = 63;
                    break;
                }
                case 82: {
                    n5 = 57;
                    break;
                }
                case 83: {
                    n5 = 244;
                    break;
                }
                case 84: {
                    n5 = 195;
                    break;
                }
                case 85: {
                    n5 = 113;
                    break;
                }
                case 86: {
                    n5 = 224;
                    break;
                }
                case 87: {
                    n5 = 167;
                    break;
                }
                case 88: {
                    n5 = 134;
                    break;
                }
                case 89: {
                    n5 = 115;
                    break;
                }
                case 90: {
                    n5 = 62;
                    break;
                }
                case 91: {
                    n5 = 20;
                    break;
                }
                case 92: {
                    n5 = 54;
                    break;
                }
                case 93: {
                    n5 = 152;
                    break;
                }
                case 94: {
                    n5 = 110;
                    break;
                }
                case 95: {
                    n5 = 183;
                    break;
                }
                case 96: {
                    n5 = 231;
                    break;
                }
                case 97: {
                    n5 = 125;
                    break;
                }
                case 98: {
                    n5 = 71;
                    break;
                }
                case 99: {
                    n5 = 27;
                    break;
                }
                case 100: {
                    n5 = 199;
                    break;
                }
                case 101: {
                    n5 = 123;
                    break;
                }
                case 102: {
                    n5 = 151;
                    break;
                }
                case 103: {
                    n5 = 61;
                    break;
                }
                case 104: {
                    n5 = 248;
                    break;
                }
                case 105: {
                    n5 = 12;
                    break;
                }
                case 106: {
                    n5 = 11;
                    break;
                }
                case 107: {
                    n5 = 215;
                    break;
                }
                case 108: {
                    n5 = 43;
                    break;
                }
                case 109: {
                    n5 = 188;
                    break;
                }
                case 110: {
                    n5 = 6;
                    break;
                }
                case 111: {
                    n5 = 174;
                    break;
                }
                case 112: {
                    n5 = 212;
                    break;
                }
                case 113: {
                    n5 = 172;
                    break;
                }
                case 114: {
                    n5 = 104;
                    break;
                }
                case 115: {
                    n5 = 93;
                    break;
                }
                case 116: {
                    n5 = 121;
                    break;
                }
                case 117: {
                    n5 = 46;
                    break;
                }
                case 118: {
                    n5 = 40;
                    break;
                }
                case 119: {
                    n5 = 219;
                    break;
                }
                case 120: {
                    n5 = 241;
                    break;
                }
                case 121: {
                    n5 = 165;
                    break;
                }
                case 122: {
                    n5 = 217;
                    break;
                }
                case 123: {
                    n5 = 223;
                    break;
                }
                case 124: {
                    n5 = 147;
                    break;
                }
                case 125: {
                    n5 = 253;
                    break;
                }
                case 126: {
                    n5 = 166;
                    break;
                }
                case 127: {
                    n5 = 234;
                    break;
                }
                case 128: {
                    n5 = 80;
                    break;
                }
                case 129: {
                    n5 = 41;
                    break;
                }
                case 130: {
                    n5 = 155;
                    break;
                }
                case 131: {
                    n5 = 246;
                    break;
                }
                case 132: {
                    n5 = 139;
                    break;
                }
                case 133: {
                    n5 = 252;
                    break;
                }
                case 134: {
                    n5 = 49;
                    break;
                }
                case 135: {
                    n5 = 186;
                    break;
                }
                case 136: {
                    n5 = 69;
                    break;
                }
                case 137: {
                    n5 = 221;
                    break;
                }
                case 138: {
                    n5 = 26;
                    break;
                }
                case 139: {
                    n5 = 82;
                    break;
                }
                case 140: {
                    n5 = 28;
                    break;
                }
                case 141: {
                    n5 = 114;
                    break;
                }
                case 142: {
                    n5 = 157;
                    break;
                }
                case 143: {
                    n5 = 21;
                    break;
                }
                case 144: {
                    n5 = 182;
                    break;
                }
                case 145: {
                    n5 = 70;
                    break;
                }
                case 146: {
                    n5 = 189;
                    break;
                }
                case 147: {
                    n5 = 60;
                    break;
                }
                case 148: {
                    n5 = 9;
                    break;
                }
                case 149: {
                    n5 = 56;
                    break;
                }
                case 150: {
                    n5 = 185;
                    break;
                }
                case 151: {
                    n5 = 160;
                    break;
                }
                case 152: {
                    n5 = 85;
                    break;
                }
                case 153: {
                    n5 = 35;
                    break;
                }
                case 154: {
                    n5 = 153;
                    break;
                }
                case 155: {
                    n5 = 124;
                    break;
                }
                case 156: {
                    n5 = 50;
                    break;
                }
                case 157: {
                    n5 = 95;
                    break;
                }
                case 158: {
                    n5 = 101;
                    break;
                }
                case 159: {
                    n5 = 116;
                    break;
                }
                case 160: {
                    n5 = 135;
                    break;
                }
                case 161: {
                    n5 = 171;
                    break;
                }
                case 162: {
                    n5 = 53;
                    break;
                }
                case 163: {
                    n5 = 228;
                    break;
                }
                case 164: {
                    n5 = 169;
                    break;
                }
                case 165: {
                    n5 = 206;
                    break;
                }
                case 166: {
                    n5 = 235;
                    break;
                }
                case 167: {
                    n5 = 15;
                    break;
                }
                case 168: {
                    n5 = 204;
                    break;
                }
                case 169: {
                    n5 = 100;
                    break;
                }
                case 170: {
                    n5 = 14;
                    break;
                }
                case 171: {
                    n5 = 83;
                    break;
                }
                case 172: {
                    n5 = 243;
                    break;
                }
                case 173: {
                    n5 = 249;
                    break;
                }
                case 174: {
                    n5 = 226;
                    break;
                }
                case 175: {
                    n5 = 168;
                    break;
                }
                case 176: {
                    n5 = 232;
                    break;
                }
                case 177: {
                    n5 = 74;
                    break;
                }
                case 178: {
                    n5 = 16;
                    break;
                }
                case 179: {
                    n5 = 79;
                    break;
                }
                case 180: {
                    n5 = 137;
                    break;
                }
                case 181: {
                    n5 = 24;
                    break;
                }
                case 182: {
                    n5 = 222;
                    break;
                }
                case 183: {
                    n5 = 126;
                    break;
                }
                case 184: {
                    n5 = 225;
                    break;
                }
                case 185: {
                    n5 = 30;
                    break;
                }
                case 186: {
                    n5 = 175;
                    break;
                }
                case 187: {
                    n5 = 141;
                    break;
                }
                case 188: {
                    n5 = 44;
                    break;
                }
                case 189: {
                    n5 = 191;
                    break;
                }
                case 190: {
                    n5 = 19;
                    break;
                }
                case 191: {
                    n5 = 214;
                    break;
                }
                case 192: {
                    n5 = 55;
                    break;
                }
                case 193: {
                    n5 = 192;
                    break;
                }
                case 194: {
                    n5 = 128;
                    break;
                }
                case 195: {
                    n5 = 8;
                    break;
                }
                case 196: {
                    n5 = 133;
                    break;
                }
                case 197: {
                    n5 = 207;
                    break;
                }
                case 198: {
                    n5 = 39;
                    break;
                }
                case 199: {
                    n5 = 254;
                    break;
                }
                case 200: {
                    n5 = 38;
                    break;
                }
                case 201: {
                    n5 = 37;
                    break;
                }
                case 202: {
                    n5 = 42;
                    break;
                }
                case 203: {
                    n5 = 117;
                    break;
                }
                case 204: {
                    n5 = 119;
                    break;
                }
                case 205: {
                    n5 = 65;
                    break;
                }
                case 206: {
                    n5 = 66;
                    break;
                }
                case 207: {
                    n5 = 86;
                    break;
                }
                case 208: {
                    n5 = 245;
                    break;
                }
                case 209: {
                    n5 = 92;
                    break;
                }
                case 210: {
                    n5 = 247;
                    break;
                }
                case 211: {
                    n5 = 94;
                    break;
                }
                case 212: {
                    n5 = 216;
                    break;
                }
                case 213: {
                    n5 = 131;
                    break;
                }
                case 214: {
                    n5 = 106;
                    break;
                }
                case 215: {
                    n5 = 164;
                    break;
                }
                case 216: {
                    n5 = 149;
                    break;
                }
                case 217: {
                    n5 = 213;
                    break;
                }
                case 218: {
                    n5 = 52;
                    break;
                }
                case 219: {
                    n5 = 238;
                    break;
                }
                case 220: {
                    n5 = 47;
                    break;
                }
                case 221: {
                    n5 = 34;
                    break;
                }
                case 222: {
                    n5 = 187;
                    break;
                }
                case 223: {
                    n5 = 162;
                    break;
                }
                case 224: {
                    n5 = 18;
                    break;
                }
                case 225: {
                    n5 = 140;
                    break;
                }
                case 226: {
                    n5 = 103;
                    break;
                }
                case 227: {
                    n5 = 77;
                    break;
                }
                case 228: {
                    n5 = 75;
                    break;
                }
                case 229: {
                    n5 = 230;
                    break;
                }
                case 230: {
                    n5 = 112;
                    break;
                }
                case 231: {
                    n5 = 132;
                    break;
                }
                case 232: {
                    n5 = 200;
                    break;
                }
                case 233: {
                    n5 = 218;
                    break;
                }
                case 234: {
                    n5 = 122;
                    break;
                }
                case 235: {
                    n5 = 67;
                    break;
                }
                case 236: {
                    n5 = 31;
                    break;
                }
                case 237: {
                    n5 = 29;
                    break;
                }
                case 238: {
                    n5 = 99;
                    break;
                }
                case 239: {
                    n5 = 150;
                    break;
                }
                case 240: {
                    n5 = 111;
                    break;
                }
                case 241: {
                    n5 = 203;
                    break;
                }
                case 242: {
                    n5 = 173;
                    break;
                }
                case 243: {
                    n5 = 58;
                    break;
                }
                case 244: {
                    n5 = 163;
                    break;
                }
                case 245: {
                    n5 = 107;
                    break;
                }
                case 246: {
                    n5 = 0;
                    break;
                }
                case 247: {
                    n5 = 255;
                    break;
                }
                case 248: {
                    n5 = 176;
                    break;
                }
                case 249: {
                    n5 = 73;
                    break;
                }
                case 250: {
                    n5 = 156;
                    break;
                }
                case 251: {
                    n5 = 4;
                    break;
                }
                case 252: {
                    n5 = 154;
                    break;
                }
                case 253: {
                    n5 = 205;
                    break;
                }
                case 254: {
                    n5 = 202;
                    break;
                }
                default: {
                    n5 = 98;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            CCIDReader.eb[n3] = new String(cArray).intern();
        }
        return eb[n3];
    }
}

