/*
 * Decompiled with CFR 0.152.
 */
package com.scdroid.smartcard;

import com.scdroid.smartcard.Card;
import com.scdroid.smartcard.SCException;

public class EMVCard
extends Card {
    protected byte[] myATR;
    public static final byte[] PAY1_SYS_DDF01;
    public static final byte[] PAY2_SYS_DDF01;
    private int d = -1;
    private static final String[] g;
    private static final String[] h;

    @Override
    public boolean IdentifyCard(byte[] ATR2) {
        this.myATR = ATR2;
        return true;
    }

    public void SelectFile(byte[] id) throws SCException {
        byte[] byArray = null;
        try {
            this.Transmit(byArray, 36864, EMVCard.b(24907, -15908));
        }
        catch (SCException sCException) {
            throw new SCException(EMVCard.b(24914, 13011) + String.format(EMVCard.b(24927, -9539), id[0], id[1]), sCException);
        }
    }

    public byte[] Select_1PAY_SYS_DDF01() {
        try {
            return this.Select(PAY1_SYS_DDF01);
        }
        catch (SCException sCException) {
            return null;
        }
    }

    public byte[] Select_2PAY_SYS_DDF01() {
        try {
            return this.Select(PAY2_SYS_DDF01);
        }
        catch (SCException sCException) {
            return null;
        }
    }

    public void SelectMF(int id) throws SCException {
        byte[] byArray = null;
        byArray = id == 0 ? new byte[]{0, -92, 0, 0, 0} : new byte[]{0, -92, 0, 0, 2, 63, 0};
        try {
            this.Transmit(byArray, 36864, EMVCard.b(24917, 12198));
        }
        catch (SCException sCException) {
            if (id == 0) {
                throw new SCException(EMVCard.b(24913, -19933), sCException);
            }
            throw new SCException(EMVCard.b(24912, -3849), sCException);
        }
    }

    public byte[] ReadRecord(byte SFI, byte no, int len) throws SCException {
        byte[] byArray = new byte[]{0, -78, 0, 0, 0};
        if (len > 255) {
            throw new SCException(EMVCard.b(24920, -31311));
        }
        byArray[2] = no;
        byArray[3] = (byte)(SFI << 3 | 4);
        byArray[4] = (byte)(len & 0xFF);
        byte[] byArray2 = this.Transmit(byArray, 36864, EMVCard.b(24924, 14316));
        byte[] byArray3 = new byte[byArray2.length - 2];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length - 2);
        return byArray3;
    }

    public byte[] GetProcessingOptions(byte[] PDOL) throws SCException {
        int n = 2;
        if (PDOL != null) {
            n = 2 + PDOL.length;
        }
        byte[] byArray = new byte[6 + n];
        byArray[0] = -128;
        byArray[1] = -88;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = (byte)n;
        byArray[5] = -125;
        byArray[6] = 0;
        if (PDOL != null) {
            System.arraycopy(PDOL, 0, byArray, 7, PDOL.length);
            byArray[6] = (byte)PDOL.length;
        }
        byArray[byArray.length - 1] = 0;
        byte[] byArray2 = this.Transmit(byArray, 36864, EMVCard.b(24916, -30194));
        return byArray2;
    }

    public void internalAuthenticate(byte[] data) throws SCException {
        if (data == null) {
            throw new NullPointerException(EMVCard.b(24906, -10708));
        }
        byte[] byArray = new byte[data.length + 6];
        byArray[0] = 0;
        byArray[1] = -120;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = (byte)data.length;
        System.arraycopy(data, 0, byArray, 5, data.length);
        byArray[byArray.length - 1] = 0;
        this.Transmit(byArray, 36864, EMVCard.b(24922, -32477));
    }

    public byte[] getChallenge() throws SCException {
        byte[] byArray = new byte[]{0, -124, 0, 0, 0};
        byte[] byArray2 = this.Transmit(byArray, 36864, EMVCard.b(24905, -12399));
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray2, 0, byArray3, 0, 8);
        return byArray3;
    }

    public byte[] GetData(byte[] tag, int LE) throws SCException {
        byte[] byArray = new byte[]{-128, -54, 0, 0, 0};
        byArray[2] = tag[0];
        byArray[3] = tag[1];
        byArray[4] = (byte)LE;
        return this.Transmit(byArray, 36864, EMVCard.b(24925, 29664));
    }

    public byte[] GetData(byte[] tag) throws SCException {
        return this.GetData(tag, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void VerifyPIN(byte[] pin, boolean transmitInPlaintext) throws SCException {
        byte[] byArray;
        int n;
        int n2;
        block19: {
            block18: {
                n2 = pin.length;
                n = Card.c;
                if (n2 < 2) throw new SCException(EMVCard.b(24910, -987) + n2);
                if (n2 > 6) {
                    throw new SCException(EMVCard.b(24910, -987) + n2);
                }
                byArray = new byte[13];
                byArray[0] = 0;
                byArray[1] = 32;
                byArray[2] = 0;
                if (!transmitInPlaintext) break block18;
                byArray[3] = -128;
                if (n == 0) break block19;
            }
            byArray[3] = -120;
        }
        byArray[4] = 8;
        if (!transmitInPlaintext) throw new SCException(EMVCard.b(24926, -9949));
        for (int i = 0; i < 7; ++i) {
            byArray[6 + i] = -1;
            if (n == 0) continue;
        }
        byArray[5] = 32;
        byArray[5] = (byte)(byArray[5] | n2 * 2);
        System.arraycopy(pin, 0, byArray, 6, n2);
        if (n != 0) {
            throw new SCException(EMVCard.b(24926, -9949));
        }
        try {
            this.Transmit(byArray, 36864, EMVCard.b(24918, 23771));
            return;
        }
        catch (SCException sCException) {
            int n3 = this.GetSW1SW2();
            if (n3 == 27011) {
                throw new SCException(EMVCard.b(24904, 20566));
            }
            byte by = (byte)(n3 >> 8 & 0xFF);
            byte by2 = (byte)(n3 & 0xFF);
            if (by == 99 && (by2 & 0xF0) == -64) {
                this.d = by2 & 0xF;
                throw new SCException(EMVCard.b(24919, 10175) + this.d);
            }
            throw new SCException(EMVCard.b(24921, -21111) + String.format(EMVCard.b(24923, 2684), n3));
        }
    }

    public int GetPinTryCounter() throws SCException {
        byte[] byArray;
        block9: {
            if (this.d != -1) {
                return this.d;
            }
            byArray = null;
            try {
                byArray = this.GetData(new byte[]{-97, 23});
            }
            catch (SCException sCException) {
                byArray = this.GetData(new byte[]{-97, 23}, 4);
            }
            if (byArray[0] != -97 || byArray[1] != 23) break block9;
            return byArray[3];
        }
        throw new SCException(EMVCard.b(24911, 17497) + this.a(byArray));
    }

    public void VerifyPIN(String pin, boolean transmitInPlaintext) throws SCException {
        this.VerifyPIN(this.a(pin), transmitInPlaintext);
    }

    public void VerifyPIN(long pin, boolean transmitInPlaintext) throws SCException {
        String string = String.valueOf(pin);
        this.VerifyPIN(this.a(string), transmitInPlaintext);
    }

    private byte[] a(String string) {
        int n = string.length() / 2;
        int n2 = Card.c;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(2 * i, 2 * i + 2), 16);
            if (n2 == 0) continue;
        }
        return byArray;
    }

    private String a(byte[] byArray) {
        String string = "";
        int n = Card.c;
        for (int i = 0; i < byArray.length; ++i) {
            string = string + " " + String.format(EMVCard.b(24915, 2809), byArray[i]);
            if (n == 0) continue;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[22];
                var3_1 = 0;
                var2_2 = "\u00a9\u0010\u0097^uT\u00e4\u00a6\u00ee\u00c62\u00ee\u00cdUQ(r\u0006d\u0083\u00b3\u0006A\u0083\u001b\u00c9\u00fck\u0015\u00d8x5\u00fc\u00a8\u00e2[\u0016=\u00d0x\u009e\u009d\u000b\u00ab\u001f'y$\u0002\u00d6\u0018(G]\u00d2\u00fe_b.\u001aG\u009d7\u00fc\u00fd\u00ea\u00a1!\u00bby\u00f0o\u00b7n|\u001cg\u00ae\u00f4\u0081\u00ea U\u00f4xd\u00fc\u0093\u00e3\u0088\u00d0\u00fd.\u00b2\u0087^O7^\u00dc\u00fb-\u0085(\f\u008a\u00e5b\u0005\u00d5\u00f2\u00f8\u00d8\u0081\u00c9<\\\u000b\u00ff\u00ed0\u008aD\u00f3\u00fa\u00c2\u00c6\u00b7\u00a4\bI\u0084D\u00c3\u0019!\u00a8\u00eb\u000b\u00ec\u0016\u0088\u00b8W\u00ed\u00d8\u0081\u00c9\u00eb\u00fb\u0004\u00d8\u00a6>$\u0015\u000f-\u00f4\u00d4\u00d0\u00150=\u00b5\u00d8r]\u00b4\u0099\u00b0\u00f1\u00dc\u00a5\u00a1\u00ed\u0099\u000e\u008dE\u00a4\u00d9\u00da\u00b4q\t\u009d^w\u008d\u0014\u0083\n\u00da\u0010\u000385\u0002\u001b\u008552#qrVp\u009b\u000f\u00ea +\u0082\u009f\u009e\u008a\u0003\u00973\u00a5!\u00f2\b)7_8\u00ce\u009f\u00bc\u00d7\u0099\u00b0\u00e4\u000f*W\u0091\u0016K\u009d\u0004\u00e0\u0005V\u00a6v\f \u00a1\u007f\u007f\u00db\u00af\u00a0\u0017x\u00fa\u00a2bF\u0012H\u00f1\u00ea\b\u00d0\u0084\u0002\u00e4\u001e\u00bd`\u00c0\u00bc\u00c6.\u008e\u0091j\u0015\u008bh{\u00bf\u00be\u00eb\u0095)&\u008e\u00ce\u00912\u00839\n\u00bfx\u00ad\u00fc\u0011\u000b\u0086\u00ef3\u00cb\u00eb\u00fce\u00e0\u00faH\u00e4!\u00fa\u0099nB\u008d\u00c6E#(\u00b3\u00d3\u00c6\u00d5\u0092j\u0080\u00aa\u00cf\u00d9x\u00ac2\u0006\u00a28\u00e3\u00bd'\u0011]]_\u00c2\r\u00d1\u00c9Wj|\u001d\u00f6I\u00c0?\rF_";
                var4_3 = "\u00a9\u0010\u0097^uT\u00e4\u00a6\u00ee\u00c62\u00ee\u00cdUQ(r\u0006d\u0083\u00b3\u0006A\u0083\u001b\u00c9\u00fck\u0015\u00d8x5\u00fc\u00a8\u00e2[\u0016=\u00d0x\u009e\u009d\u000b\u00ab\u001f'y$\u0002\u00d6\u0018(G]\u00d2\u00fe_b.\u001aG\u009d7\u00fc\u00fd\u00ea\u00a1!\u00bby\u00f0o\u00b7n|\u001cg\u00ae\u00f4\u0081\u00ea U\u00f4xd\u00fc\u0093\u00e3\u0088\u00d0\u00fd.\u00b2\u0087^O7^\u00dc\u00fb-\u0085(\f\u008a\u00e5b\u0005\u00d5\u00f2\u00f8\u00d8\u0081\u00c9<\\\u000b\u00ff\u00ed0\u008aD\u00f3\u00fa\u00c2\u00c6\u00b7\u00a4\bI\u0084D\u00c3\u0019!\u00a8\u00eb\u000b\u00ec\u0016\u0088\u00b8W\u00ed\u00d8\u0081\u00c9\u00eb\u00fb\u0004\u00d8\u00a6>$\u0015\u000f-\u00f4\u00d4\u00d0\u00150=\u00b5\u00d8r]\u00b4\u0099\u00b0\u00f1\u00dc\u00a5\u00a1\u00ed\u0099\u000e\u008dE\u00a4\u00d9\u00da\u00b4q\t\u009d^w\u008d\u0014\u0083\n\u00da\u0010\u000385\u0002\u001b\u008552#qrVp\u009b\u000f\u00ea +\u0082\u009f\u009e\u008a\u0003\u00973\u00a5!\u00f2\b)7_8\u00ce\u009f\u00bc\u00d7\u0099\u00b0\u00e4\u000f*W\u0091\u0016K\u009d\u0004\u00e0\u0005V\u00a6v\f \u00a1\u007f\u007f\u00db\u00af\u00a0\u0017x\u00fa\u00a2bF\u0012H\u00f1\u00ea\b\u00d0\u0084\u0002\u00e4\u001e\u00bd`\u00c0\u00bc\u00c6.\u008e\u0091j\u0015\u008bh{\u00bf\u00be\u00eb\u0095)&\u008e\u00ce\u00912\u00839\n\u00bfx\u00ad\u00fc\u0011\u000b\u0086\u00ef3\u00cb\u00eb\u00fce\u00e0\u00faH\u00e4!\u00fa\u0099nB\u008d\u00c6E#(\u00b3\u00d3\u00c6\u00d5\u0092j\u0080\u00aa\u00cf\u00d9x\u00ac2\u0006\u00a28\u00e3\u00bd'\u0011]]_\u00c2\r\u00d1\u00c9Wj|\u001d\u00f6I\u00c0?\rF_".length();
                var1_4 = 21;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u001dU#\u00f6\u00bb\u00c6\u00e1[\u00bf\u0090}Yxyg\u00ba\u00ad*j<\u00f81\u00b3\u001f\u00d5p\u00c7\u0013\u00bf\u0013\u0005+\u00e7\u00c6\u00aa\u0084+T\u00d1G\u00ad\u0006V=\u0017\u00e3ZVay\u00b0\u00f8#\u00ba\u008f\u00a7\u00d1%\u0010z\u0080\u0091\u00c8X\u00ad\u00f0\u009b\u00c3\u00b3\u009f\u00e5&\u00d3\u0016\u00a4\u0019\u0002r\u00b7\u00e3o/81\u00d7\u008a\u0092\u00a2\t\u008f\u00b6\u00e1\u001f\u00ab\u00dc";
                    var4_3 = "\u001dU#\u00f6\u00bb\u00c6\u00e1[\u00bf\u0090}Yxyg\u00ba\u00ad*j<\u00f81\u00b3\u001f\u00d5p\u00c7\u0013\u00bf\u0013\u0005+\u00e7\u00c6\u00aa\u0084+T\u00d1G\u00ad\u0006V=\u0017\u00e3ZVay\u00b0\u00f8#\u00ba\u008f\u00a7\u00d1%\u0010z\u0080\u0091\u00c8X\u00ad\u00f0\u009b\u00c3\u00b3\u009f\u00e5&\u00d3\u0016\u00a4\u0019\u0002r\u00b7\u00e3o/81\u00d7\u008a\u0092\u00a2\t\u008f\u00b6\u00e1\u001f\u00ab\u00dc".length();
                    var1_4 = 57;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 36;
                            break;
                        }
                        case 1: {
                            v13 = 124;
                            break;
                        }
                        case 2: {
                            v13 = 18;
                            break;
                        }
                        case 3: {
                            v13 = 17;
                            break;
                        }
                        case 4: {
                            v13 = 73;
                            break;
                        }
                        case 5: {
                            v13 = 30;
                            break;
                        }
                        default: {
                            v13 = 58;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        EMVCard.g = var5;
        EMVCard.h = new String[22];
        EMVCard.PAY1_SYS_DDF01 = new byte[]{49, 80, 65, 89, 46, 83, 89, 83, 46, 68, 68, 70, 48, 49};
        EMVCard.PAY2_SYS_DDF01 = new byte[]{50, 80, 65, 89, 46, 83, 89, 83, 46, 68, 68, 70, 48, 49};
    }

    private static String b(int n, int n2) {
        int n3 = (n ^ 0x615A) & 0xFFFF;
        if (h[n3] == null) {
            int n4;
            int n5;
            char[] cArray = g[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 189;
                    break;
                }
                case 1: {
                    n5 = 145;
                    break;
                }
                case 2: {
                    n5 = 231;
                    break;
                }
                case 3: {
                    n5 = 39;
                    break;
                }
                case 4: {
                    n5 = 250;
                    break;
                }
                case 5: {
                    n5 = 76;
                    break;
                }
                case 6: {
                    n5 = 191;
                    break;
                }
                case 7: {
                    n5 = 36;
                    break;
                }
                case 8: {
                    n5 = 208;
                    break;
                }
                case 9: {
                    n5 = 186;
                    break;
                }
                case 10: {
                    n5 = 48;
                    break;
                }
                case 11: {
                    n5 = 28;
                    break;
                }
                case 12: {
                    n5 = 47;
                    break;
                }
                case 13: {
                    n5 = 220;
                    break;
                }
                case 14: {
                    n5 = 176;
                    break;
                }
                case 15: {
                    n5 = 225;
                    break;
                }
                case 16: {
                    n5 = 183;
                    break;
                }
                case 17: {
                    n5 = 190;
                    break;
                }
                case 18: {
                    n5 = 80;
                    break;
                }
                case 19: {
                    n5 = 116;
                    break;
                }
                case 20: {
                    n5 = 233;
                    break;
                }
                case 21: {
                    n5 = 136;
                    break;
                }
                case 22: {
                    n5 = 159;
                    break;
                }
                case 23: {
                    n5 = 154;
                    break;
                }
                case 24: {
                    n5 = 236;
                    break;
                }
                case 25: {
                    n5 = 113;
                    break;
                }
                case 26: {
                    n5 = 71;
                    break;
                }
                case 27: {
                    n5 = 31;
                    break;
                }
                case 28: {
                    n5 = 251;
                    break;
                }
                case 29: {
                    n5 = 206;
                    break;
                }
                case 30: {
                    n5 = 87;
                    break;
                }
                case 31: {
                    n5 = 242;
                    break;
                }
                case 32: {
                    n5 = 215;
                    break;
                }
                case 33: {
                    n5 = 13;
                    break;
                }
                case 34: {
                    n5 = 240;
                    break;
                }
                case 35: {
                    n5 = 106;
                    break;
                }
                case 36: {
                    n5 = 109;
                    break;
                }
                case 37: {
                    n5 = 156;
                    break;
                }
                case 38: {
                    n5 = 149;
                    break;
                }
                case 39: {
                    n5 = 62;
                    break;
                }
                case 40: {
                    n5 = 27;
                    break;
                }
                case 41: {
                    n5 = 17;
                    break;
                }
                case 42: {
                    n5 = 0;
                    break;
                }
                case 43: {
                    n5 = 178;
                    break;
                }
                case 44: {
                    n5 = 117;
                    break;
                }
                case 45: {
                    n5 = 15;
                    break;
                }
                case 46: {
                    n5 = 10;
                    break;
                }
                case 47: {
                    n5 = 205;
                    break;
                }
                case 48: {
                    n5 = 157;
                    break;
                }
                case 49: {
                    n5 = 35;
                    break;
                }
                case 50: {
                    n5 = 73;
                    break;
                }
                case 51: {
                    n5 = 169;
                    break;
                }
                case 52: {
                    n5 = 245;
                    break;
                }
                case 53: {
                    n5 = 49;
                    break;
                }
                case 54: {
                    n5 = 196;
                    break;
                }
                case 55: {
                    n5 = 128;
                    break;
                }
                case 56: {
                    n5 = 172;
                    break;
                }
                case 57: {
                    n5 = 181;
                    break;
                }
                case 58: {
                    n5 = 93;
                    break;
                }
                case 59: {
                    n5 = 34;
                    break;
                }
                case 60: {
                    n5 = 123;
                    break;
                }
                case 61: {
                    n5 = 180;
                    break;
                }
                case 62: {
                    n5 = 139;
                    break;
                }
                case 63: {
                    n5 = 216;
                    break;
                }
                case 64: {
                    n5 = 61;
                    break;
                }
                case 65: {
                    n5 = 81;
                    break;
                }
                case 66: {
                    n5 = 218;
                    break;
                }
                case 67: {
                    n5 = 29;
                    break;
                }
                case 68: {
                    n5 = 130;
                    break;
                }
                case 69: {
                    n5 = 239;
                    break;
                }
                case 70: {
                    n5 = 46;
                    break;
                }
                case 71: {
                    n5 = 243;
                    break;
                }
                case 72: {
                    n5 = 163;
                    break;
                }
                case 73: {
                    n5 = 33;
                    break;
                }
                case 74: {
                    n5 = 237;
                    break;
                }
                case 75: {
                    n5 = 119;
                    break;
                }
                case 76: {
                    n5 = 104;
                    break;
                }
                case 77: {
                    n5 = 9;
                    break;
                }
                case 78: {
                    n5 = 248;
                    break;
                }
                case 79: {
                    n5 = 247;
                    break;
                }
                case 80: {
                    n5 = 147;
                    break;
                }
                case 81: {
                    n5 = 246;
                    break;
                }
                case 82: {
                    n5 = 150;
                    break;
                }
                case 83: {
                    n5 = 232;
                    break;
                }
                case 84: {
                    n5 = 14;
                    break;
                }
                case 85: {
                    n5 = 188;
                    break;
                }
                case 86: {
                    n5 = 165;
                    break;
                }
                case 87: {
                    n5 = 24;
                    break;
                }
                case 88: {
                    n5 = 244;
                    break;
                }
                case 89: {
                    n5 = 221;
                    break;
                }
                case 90: {
                    n5 = 23;
                    break;
                }
                case 91: {
                    n5 = 37;
                    break;
                }
                case 92: {
                    n5 = 118;
                    break;
                }
                case 93: {
                    n5 = 74;
                    break;
                }
                case 94: {
                    n5 = 75;
                    break;
                }
                case 95: {
                    n5 = 142;
                    break;
                }
                case 96: {
                    n5 = 197;
                    break;
                }
                case 97: {
                    n5 = 170;
                    break;
                }
                case 98: {
                    n5 = 19;
                    break;
                }
                case 99: {
                    n5 = 54;
                    break;
                }
                case 100: {
                    n5 = 129;
                    break;
                }
                case 101: {
                    n5 = 60;
                    break;
                }
                case 102: {
                    n5 = 105;
                    break;
                }
                case 103: {
                    n5 = 168;
                    break;
                }
                case 104: {
                    n5 = 102;
                    break;
                }
                case 105: {
                    n5 = 84;
                    break;
                }
                case 106: {
                    n5 = 114;
                    break;
                }
                case 107: {
                    n5 = 187;
                    break;
                }
                case 108: {
                    n5 = 103;
                    break;
                }
                case 109: {
                    n5 = 182;
                    break;
                }
                case 110: {
                    n5 = 41;
                    break;
                }
                case 111: {
                    n5 = 230;
                    break;
                }
                case 112: {
                    n5 = 141;
                    break;
                }
                case 113: {
                    n5 = 68;
                    break;
                }
                case 114: {
                    n5 = 111;
                    break;
                }
                case 115: {
                    n5 = 227;
                    break;
                }
                case 116: {
                    n5 = 140;
                    break;
                }
                case 117: {
                    n5 = 152;
                    break;
                }
                case 118: {
                    n5 = 146;
                    break;
                }
                case 119: {
                    n5 = 40;
                    break;
                }
                case 120: {
                    n5 = 26;
                    break;
                }
                case 121: {
                    n5 = 219;
                    break;
                }
                case 122: {
                    n5 = 115;
                    break;
                }
                case 123: {
                    n5 = 5;
                    break;
                }
                case 124: {
                    n5 = 151;
                    break;
                }
                case 125: {
                    n5 = 20;
                    break;
                }
                case 126: {
                    n5 = 43;
                    break;
                }
                case 127: {
                    n5 = 101;
                    break;
                }
                case 128: {
                    n5 = 217;
                    break;
                }
                case 129: {
                    n5 = 135;
                    break;
                }
                case 130: {
                    n5 = 83;
                    break;
                }
                case 131: {
                    n5 = 42;
                    break;
                }
                case 132: {
                    n5 = 143;
                    break;
                }
                case 133: {
                    n5 = 25;
                    break;
                }
                case 134: {
                    n5 = 173;
                    break;
                }
                case 135: {
                    n5 = 67;
                    break;
                }
                case 136: {
                    n5 = 148;
                    break;
                }
                case 137: {
                    n5 = 204;
                    break;
                }
                case 138: {
                    n5 = 63;
                    break;
                }
                case 139: {
                    n5 = 78;
                    break;
                }
                case 140: {
                    n5 = 94;
                    break;
                }
                case 141: {
                    n5 = 95;
                    break;
                }
                case 142: {
                    n5 = 8;
                    break;
                }
                case 143: {
                    n5 = 18;
                    break;
                }
                case 144: {
                    n5 = 194;
                    break;
                }
                case 145: {
                    n5 = 234;
                    break;
                }
                case 146: {
                    n5 = 57;
                    break;
                }
                case 147: {
                    n5 = 200;
                    break;
                }
                case 148: {
                    n5 = 52;
                    break;
                }
                case 149: {
                    n5 = 3;
                    break;
                }
                case 150: {
                    n5 = 66;
                    break;
                }
                case 151: {
                    n5 = 44;
                    break;
                }
                case 152: {
                    n5 = 238;
                    break;
                }
                case 153: {
                    n5 = 137;
                    break;
                }
                case 154: {
                    n5 = 53;
                    break;
                }
                case 155: {
                    n5 = 2;
                    break;
                }
                case 156: {
                    n5 = 199;
                    break;
                }
                case 157: {
                    n5 = 22;
                    break;
                }
                case 158: {
                    n5 = 58;
                    break;
                }
                case 159: {
                    n5 = 107;
                    break;
                }
                case 160: {
                    n5 = 85;
                    break;
                }
                case 161: {
                    n5 = 112;
                    break;
                }
                case 162: {
                    n5 = 235;
                    break;
                }
                case 163: {
                    n5 = 88;
                    break;
                }
                case 164: {
                    n5 = 55;
                    break;
                }
                case 165: {
                    n5 = 82;
                    break;
                }
                case 166: {
                    n5 = 132;
                    break;
                }
                case 167: {
                    n5 = 155;
                    break;
                }
                case 168: {
                    n5 = 131;
                    break;
                }
                case 169: {
                    n5 = 92;
                    break;
                }
                case 170: {
                    n5 = 4;
                    break;
                }
                case 171: {
                    n5 = 64;
                    break;
                }
                case 172: {
                    n5 = 138;
                    break;
                }
                case 173: {
                    n5 = 229;
                    break;
                }
                case 174: {
                    n5 = 50;
                    break;
                }
                case 175: {
                    n5 = 97;
                    break;
                }
                case 176: {
                    n5 = 222;
                    break;
                }
                case 177: {
                    n5 = 69;
                    break;
                }
                case 178: {
                    n5 = 174;
                    break;
                }
                case 179: {
                    n5 = 121;
                    break;
                }
                case 180: {
                    n5 = 124;
                    break;
                }
                case 181: {
                    n5 = 21;
                    break;
                }
                case 182: {
                    n5 = 160;
                    break;
                }
                case 183: {
                    n5 = 108;
                    break;
                }
                case 184: {
                    n5 = 161;
                    break;
                }
                case 185: {
                    n5 = 90;
                    break;
                }
                case 186: {
                    n5 = 153;
                    break;
                }
                case 187: {
                    n5 = 202;
                    break;
                }
                case 188: {
                    n5 = 224;
                    break;
                }
                case 189: {
                    n5 = 253;
                    break;
                }
                case 190: {
                    n5 = 77;
                    break;
                }
                case 191: {
                    n5 = 162;
                    break;
                }
                case 192: {
                    n5 = 211;
                    break;
                }
                case 193: {
                    n5 = 96;
                    break;
                }
                case 194: {
                    n5 = 164;
                    break;
                }
                case 195: {
                    n5 = 59;
                    break;
                }
                case 196: {
                    n5 = 38;
                    break;
                }
                case 197: {
                    n5 = 210;
                    break;
                }
                case 198: {
                    n5 = 185;
                    break;
                }
                case 199: {
                    n5 = 12;
                    break;
                }
                case 200: {
                    n5 = 45;
                    break;
                }
                case 201: {
                    n5 = 125;
                    break;
                }
                case 202: {
                    n5 = 228;
                    break;
                }
                case 203: {
                    n5 = 133;
                    break;
                }
                case 204: {
                    n5 = 195;
                    break;
                }
                case 205: {
                    n5 = 16;
                    break;
                }
                case 206: {
                    n5 = 110;
                    break;
                }
                case 207: {
                    n5 = 255;
                    break;
                }
                case 208: {
                    n5 = 214;
                    break;
                }
                case 209: {
                    n5 = 11;
                    break;
                }
                case 210: {
                    n5 = 207;
                    break;
                }
                case 211: {
                    n5 = 201;
                    break;
                }
                case 212: {
                    n5 = 158;
                    break;
                }
                case 213: {
                    n5 = 120;
                    break;
                }
                case 214: {
                    n5 = 98;
                    break;
                }
                case 215: {
                    n5 = 252;
                    break;
                }
                case 216: {
                    n5 = 134;
                    break;
                }
                case 217: {
                    n5 = 1;
                    break;
                }
                case 218: {
                    n5 = 89;
                    break;
                }
                case 219: {
                    n5 = 99;
                    break;
                }
                case 220: {
                    n5 = 166;
                    break;
                }
                case 221: {
                    n5 = 249;
                    break;
                }
                case 222: {
                    n5 = 198;
                    break;
                }
                case 223: {
                    n5 = 213;
                    break;
                }
                case 224: {
                    n5 = 7;
                    break;
                }
                case 225: {
                    n5 = 122;
                    break;
                }
                case 226: {
                    n5 = 79;
                    break;
                }
                case 227: {
                    n5 = 91;
                    break;
                }
                case 228: {
                    n5 = 171;
                    break;
                }
                case 229: {
                    n5 = 127;
                    break;
                }
                case 230: {
                    n5 = 72;
                    break;
                }
                case 231: {
                    n5 = 177;
                    break;
                }
                case 232: {
                    n5 = 254;
                    break;
                }
                case 233: {
                    n5 = 192;
                    break;
                }
                case 234: {
                    n5 = 226;
                    break;
                }
                case 235: {
                    n5 = 144;
                    break;
                }
                case 236: {
                    n5 = 6;
                    break;
                }
                case 237: {
                    n5 = 203;
                    break;
                }
                case 238: {
                    n5 = 126;
                    break;
                }
                case 239: {
                    n5 = 30;
                    break;
                }
                case 240: {
                    n5 = 86;
                    break;
                }
                case 241: {
                    n5 = 212;
                    break;
                }
                case 242: {
                    n5 = 193;
                    break;
                }
                case 243: {
                    n5 = 175;
                    break;
                }
                case 244: {
                    n5 = 70;
                    break;
                }
                case 245: {
                    n5 = 223;
                    break;
                }
                case 246: {
                    n5 = 56;
                    break;
                }
                case 247: {
                    n5 = 209;
                    break;
                }
                case 248: {
                    n5 = 65;
                    break;
                }
                case 249: {
                    n5 = 179;
                    break;
                }
                case 250: {
                    n5 = 100;
                    break;
                }
                case 251: {
                    n5 = 167;
                    break;
                }
                case 252: {
                    n5 = 32;
                    break;
                }
                case 253: {
                    n5 = 241;
                    break;
                }
                case 254: {
                    n5 = 51;
                    break;
                }
                default: {
                    n5 = 184;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            EMVCard.h[n3] = new String(cArray).intern();
        }
        return h[n3];
    }
}

