/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.xmlsignature.formats;

import java.security.Key;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.api.common.crypto.BaseSigner;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.C14nMethod;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.Context;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.SignatureMethod;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.SignatureValidationResult;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResult;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResultType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignature;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignatureException;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.algorithms.XmlSignatureAlgorithm;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.formats.SignatureFormat;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.BaseElement;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.Manifest;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.Reference;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.SignedInfo;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.KeyValue;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.X509Data;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.x509.X509Certificate;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.I18n;

public abstract class BaseSignatureFormat
implements SignatureFormat {
    private static Logger a;
    protected XMLSignature mSignature;
    protected Context mContext;
    private static String b;
    private static final String[] h;
    private static final String[] i;

    protected BaseSignatureFormat(Context aContext, XMLSignature aSignature) {
        this.mContext = aContext;
        this.mSignature = aSignature;
    }

    protected DigestAlg getDigestAlgorithmUrl() {
        return this.mSignature.getSignedInfo().getSignatureMethod().getDigestAlg();
    }

    protected C14nMethod getC14nMethod() {
        return this.mSignature.getSignedInfo().getCanonicalizationMethod();
    }

    protected SignatureMethod getSignatureMethod() {
        return this.mSignature.getSignedInfo().getSignatureMethod();
    }

    protected void digestReferences(Manifest aReferences) throws XMLSignatureException {
        String string = BaseSignatureFormat.b();
        a.info(BaseSignatureFormat.a(-10214, -20462) + aReferences);
        String string2 = string;
        for (int i = 0; i < aReferences.getReferenceCount(); ++i) {
            Reference reference = aReferences.getReference(i);
            reference.generateDigestValue();
            Manifest manifest = reference.getReferencedManifest();
            try {
                if (manifest == null) continue;
                a.info(BaseSignatureFormat.a(-10216, -28312) + manifest);
                this.digestReferences(manifest);
                continue;
            }
            catch (XMLSignatureException xMLSignatureException) {
                throw BaseSignatureFormat.b((Exception)((Object)xMLSignatureException));
            }
        }
    }

    @Override
    public SignatureValidationResult validateCore() throws XMLSignatureException {
        PublicKey publicKey = this.mSignature.getKeyInfo().resolvePublicKey();
        try {
            if (publicKey == null) {
                throw new XMLSignatureException(BaseSignatureFormat.a(-10234, -11528));
            }
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw BaseSignatureFormat.b((Exception)((Object)xMLSignatureException));
        }
        return this.validateCore(publicKey);
    }

    @Override
    public SignatureValidationResult validateCore(Key aKey) throws XMLSignatureException {
        SignatureValidationResult signatureValidationResult;
        block11: {
            XmlSignatureAlgorithm xmlSignatureAlgorithm;
            a.debug(BaseSignatureFormat.a(-10225, 25083));
            signatureValidationResult = new SignatureValidationResult();
            String string = BaseSignatureFormat.b();
            signatureValidationResult.setVerifierClass(XMLSignature.class);
            SignedInfo signedInfo = this.mSignature.getSignedInfo();
            try {
                xmlSignatureAlgorithm = this.getSignatureMethod().getSignatureImpl();
                xmlSignatureAlgorithm.initVerify(aKey, signedInfo.getSignatureAlgorithmParameters());
            }
            catch (Exception exception) {
                a.warn(BaseSignatureFormat.a(-10227, -31706), (Throwable)exception);
                signatureValidationResult.setStatus(ValidationResultType.INVALID, exception.getMessage());
                return signatureValidationResult;
            }
            byte[] byArray = signedInfo.getCanonicalizedBytes();
            try {
                a.debug(BaseSignatureFormat.a(-10239, 14087) + StringUtil.toHexString((byte[])byArray));
                xmlSignatureAlgorithm.update(byArray);
                if (a.isDebugEnabled()) {
                    this.debugSign(signedInfo, byArray, aKey);
                }
            }
            catch (Exception exception) {
                throw BaseSignatureFormat.b(exception);
            }
            boolean bl = xmlSignatureAlgorithm.verify(this.mSignature.getSignatureValue());
            if (!bl) {
                String string2 = I18n.translate(BaseSignatureFormat.a(-10232, 28436), new Object[0]);
                a.info(string2);
                signatureValidationResult.setStatus(ValidationResultType.INVALID, string2);
                return signatureValidationResult;
            }
            signatureValidationResult.addItem(new ValidationResult(ValidationResultType.VALID, I18n.translate(BaseSignatureFormat.a(-10238, 18148), new Object[0]), I18n.translate(BaseSignatureFormat.a(-10220, -21943), new Object[0]), null, XMLSignature.class));
            a.info(BaseSignatureFormat.a(-10209, 30183));
            ValidationResult validationResult = this.validateReferences(this.mSignature.getSignedInfo());
            try {
                block10: {
                    try {
                        signatureValidationResult.addItem(validationResult);
                        if (validationResult.getType() == ValidationResultType.VALID) break block10;
                        signatureValidationResult.setStatus(validationResult.getType(), I18n.translate(BaseSignatureFormat.a(-10230, -21033), new Object[0]));
                        if (string == null) break block11;
                    }
                    catch (Exception exception) {
                        throw BaseSignatureFormat.b(exception);
                    }
                }
                signatureValidationResult.setStatus(ValidationResultType.VALID, I18n.translate(BaseSignatureFormat.a(-10231, -28204), new Object[0]));
            }
            catch (Exception exception) {
                throw BaseSignatureFormat.b(exception);
            }
        }
        return signatureValidationResult;
    }

    @Override
    public SignatureValidationResult validateCore(ECertificate aCertificate) throws XMLSignatureException {
        try {
            return this.validateCore(KeyUtil.decodePublicKey((ESubjectPublicKeyInfo)aCertificate.getSubjectPublicKeyInfo()));
        }
        catch (CryptoException cryptoException) {
            throw new XMLSignatureException(cryptoException, BaseSignatureFormat.a(-10233, -23037), aCertificate.getSubjectPublicKeyInfo(), BaseSignatureFormat.a(-10228, 27476));
        }
    }

    protected ValidationResult validateReferences(Manifest aReferences) throws XMLSignatureException {
        String string = BaseSignatureFormat.b();
        a.info(BaseSignatureFormat.a(-10219, 1284) + aReferences);
        String string2 = string;
        for (int i = 0; i < aReferences.getReferenceCount(); ++i) {
            Object object;
            Reference reference = aReferences.getReference(i);
            boolean bl = false;
            Exception exception = null;
            try {
                bl = reference.validateDigestValue();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (!bl) {
                object = new ValidationResult(ValidationResultType.INVALID, I18n.translate(BaseSignatureFormat.a(-10240, -21263), new Object[0]), I18n.translate(BaseSignatureFormat.a(-10218, 19743), reference.getURI()), null, XMLSignature.class);
                try {
                    if (exception != null) {
                        ((ValidationResult)object).setMessage(((ValidationResult)object).getMessage() + BaseSignatureFormat.a(-10213, 4677) + exception.getMessage());
                    }
                }
                catch (Exception exception3) {
                    throw BaseSignatureFormat.b(exception3);
                }
                return object;
            }
            if (!this.mContext.isValidateManifests() || (object = reference.getReferencedManifest()) == null) continue;
            a.info(BaseSignatureFormat.a(-10215, -22423) + object);
            ValidationResult validationResult = this.validateReferences((Manifest)object);
            try {
                if (validationResult.getType() == ValidationResultType.VALID) continue;
                return validationResult;
            }
            catch (Exception exception4) {
                throw BaseSignatureFormat.b(exception4);
            }
        }
        a.info(BaseSignatureFormat.a(-10211, 25204));
        return new ValidationResult(ValidationResultType.VALID, I18n.translate(BaseSignatureFormat.a(-10226, -22301), new Object[0]), I18n.translate(BaseSignatureFormat.a(-10235, 20375), new Object[0]), null, this.getClass());
    }

    @Override
    public XMLSignature sign(BaseSigner aSigner) throws XMLSignatureException {
        XMLSignature xMLSignature;
        String string = BaseSignatureFormat.b();
        this.digestReferences(this.mSignature.getSignedInfo());
        String string2 = string;
        SignatureMethod signatureMethod = null;
        try {
            SignedInfo signedInfo = this.mSignature.getSignedInfo();
            String string3 = signedInfo.getSignatureMethod().getSignatureImpl().getAlgorithmName();
            String string4 = aSigner.getSignatureAlgorithmStr();
            signatureMethod = SignatureMethod.fromAlgorithmAndParams(string4, aSigner.getAlgorithmParameterSpec());
            try {
                if (signatureMethod == null) {
                    throw new XMLSignatureException(BaseSignatureFormat.a(-10210, -18871), string4);
                }
            }
            catch (Exception exception) {
                throw BaseSignatureFormat.b(exception);
            }
            try {
                if (!string3.equals(string4)) {
                    a.warn(BaseSignatureFormat.a(-10229, 8955) + string3 + BaseSignatureFormat.a(-10237, -9144) + string4);
                    signedInfo.setSignatureMethod(signatureMethod);
                }
            }
            catch (Exception exception) {
                throw BaseSignatureFormat.b(exception);
            }
            byte[] byArray = this.mSignature.getSignedInfo().getCanonicalizedBytes();
            this.debugSign(signedInfo, byArray, aSigner.getClass());
            byte[] byArray2 = aSigner.sign(byArray);
            this.mSignature.setSignatureValue(byArray2);
        }
        catch (Exception exception) {
            throw new XMLSignatureException(exception, BaseSignatureFormat.a(-10212, -19739));
        }
        try {
            xMLSignature = this.mSignature;
            if (BaseElement.b() != null) {
                BaseSignatureFormat.b("WCsdUb");
            }
        }
        catch (Exception exception) {
            throw BaseSignatureFormat.b(exception);
        }
        return xMLSignature;
    }

    protected void fillSignatureValue(Key aKey) throws XMLSignatureException {
        try {
            SignedInfo signedInfo = this.mSignature.getSignedInfo();
            SignatureMethod signatureMethod = signedInfo.getSignatureMethod();
            XmlSignatureAlgorithm xmlSignatureAlgorithm = signatureMethod.getSignatureImpl();
            xmlSignatureAlgorithm.initSign(aKey, signedInfo.getSignatureAlgorithmParameters());
            byte[] byArray = this.mSignature.getSignedInfo().getCanonicalizedBytes();
            try {
                if (a.isDebugEnabled()) {
                    this.debugSign(signedInfo, byArray, aKey.getClass());
                }
            }
            catch (Exception exception) {
                throw BaseSignatureFormat.b(exception);
            }
            xmlSignatureAlgorithm.update(byArray);
            byte[] byArray2 = xmlSignatureAlgorithm.sign();
            this.mSignature.setSignatureValue(byArray2);
        }
        catch (Exception exception) {
            throw new XMLSignatureException(exception, BaseSignatureFormat.a(-10223, 27723));
        }
    }

    protected void debugSign(SignedInfo si, byte[] canoned, Object aKey) {
        if (a.isDebugEnabled()) {
            a.debug(BaseSignatureFormat.a(-10236, -25417) + si.getCanonicalizationMethod().getURL());
            a.debug(BaseSignatureFormat.a(-10221, 28671) + si.getSignatureMethod().getUrl());
            a.debug(BaseSignatureFormat.a(-10222, -2656) + new String(canoned));
            a.debug(BaseSignatureFormat.a(-10217, 16731) + aKey);
        }
    }

    @Override
    public void addKeyInfo(ECertificate aCertificate) {
        X509Data x509Data = new X509Data(this.mContext);
        X509Certificate x509Certificate = new X509Certificate(this.mContext, aCertificate);
        x509Data.add(x509Certificate);
        this.mSignature.createOrGetKeyInfo().add(x509Data);
    }

    @Override
    public void addKeyInfo(PublicKey pk) throws XMLSignatureException {
        KeyValue keyValue = new KeyValue(this.mContext, pk);
        this.mSignature.createOrGetKeyInfo().add(keyValue);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[31];
                var3_1 = 0;
                var2_2 = "\u00b4\u0006\u00b2\u00de3\u001c\u00d4\u008a\u009f/\u0082xU3\u001a1B&V\u00a1\r\u0086\u00a4\u009aj\u00c5m\u00d9\u00e9\u001c@vF\u00a0p\u0096\u00f7\u00a1x\u00a4)\u001e\u00ecG\u0086\u00f1e\u0011\u00a1\u0080\t\u008e\u007f\u00d0HM\u00008tcDdq\u0095y\u00d8o]\u00f3j\u0002&\t\u0099\u009a\u00df\u00de\\\u00bb\u00aa<\u00d1\u0011\u00aeB_X\u00e1>*n$\u0005\u001a\u0001\u0015\u00af\u0016+\u00b4\u000f9p\u008e\u00d3#2\u00c0\u0006\u00fe\u00e1z2\r2\u00bd\r\u008f\u00c1X\u00e5\u00f9\u00e1\u009f\u00d7\u008ct\u0086\u00a1\u0012\u001e7\u00efO \u001bL\u00c7\u00c9\u001e\u0018f\r\u008e\u00d5\u00cd\u00e1H\u0084\u0093X\u00b6\u00fd1\u00e3\u00a2\u00f6\u001e\u0000\u00da[\u0011\u0011ZM\"\u0007W\u00dc\u00b5\u00ce\u0003\u00dag&mC\u0019[ p\u00a5\u00a7i\u0006ed\u00ecj\u00b8\u00e8\u009cY\u00cc\u00fe\u00c2\u009d\u00dd\u00dd\u00935\tT<\u0095\u001ct8\u0085\u0011\u00a2C\u0017\u00eb`\u00d4\u00d1hc\u00ad\u0017\u00c6\u00eeNo\u0081\u0005m\u00f7\u0016\u00c8HS\u00d7o\u00a0\u0007\u00a1\u00b1\u00dbu\t\u00d5\u000b:k\u008c\u00f2&O\u00cf\u00b4\u0093\u009e\u0004~%\u0099\u00a4\u0080d\u00d6\u00fb\u00d7\u00b1\u000e\u0001S\u008ez\u00df|o\u00bc\u000f\u00fb\u0090\u0086\u0001\u00adu\u0087]X-\u00e2\u00a8\u00fe5@F\u0019gw\u00e7\u00df\u00f9{\u00c3\u00f1\u001e5\u00dd\u001f\u00f0\u00be\u001e\u00c9\u00a6\u00fef\u00da\u0086\u00a5F\u0094\u00a9\u00d6\u0012\u00a7\u00b7\u00bb\u0094\u00ef\u00966\u00da*\u00e9\u001b\u00b5\u00e5g[\u00bc._I\b?Z\u00c8\u000fu`P\u00dc=A\u0001\u00b7\u00e3\u00bd\u0007\u00b9\u00a2CXx\u00e9\u00dc\u00a2<?\u0084\u00f5\u00afD0\t\f\u009b\u007f\u00f6<\u00948\u00c2\u0015\u000e\u0085\u00c6\u001a\u0006e\u00c0\u00b2}\u0091\u001d7\u00e9\u0018\u00ab#\u0014 \u00a5yAaF\u0094Jk:\u00eb\u00d7[\u001a9\u00ae\u00ad\u00c5\u00bf\u008d\u00e1\u0018]\u00cb.\u00dc\u00f3\u008d\u00db\u0095\u0010\u00cd6\u007fm\u00eb\u00ee\u0081y7\u0011c\u00da\b\u00ac\u0088\u00a3\u00d3\u00e2g\u000f\u00fc\u008f\u00844\u00f9u|\u0015\u00cb\u00d5\u00d3,B\u00cb4\u00f2\u009f\u00f6 U\u00a3PqP\u00df\u00ac3\u00e9\u00af \u008a\u00ee\u00f8\u0000\u00edH\u0019I\u00c5\u001d\u0019\u0004\u00ef:\u00bf\"\u00b6V\u009f\u0088\u0083\u001aE@\u00aa`\tH\u00a8&\u00f9z\t\u00de\u00c4!\u00db~\u00bb\u0092\u00ee\u000e\u0017\u00f0\fa\u009a4\f\u00dc4g\u00d1/\u009b]\u00f1RM\u00cc9\u00bf\u00b901\u00dd\u000f\u0097G\u00ac\u00f6\u00b0\u001d\u00e1?\u00de\u00af\u00aa\u00ca[\u00c8\u00d3\u001aCn\u0017\u00d6\u00fa\u0085\u0005\u0005\\\u00f7\\U\u00b6hHQXUElC\u008dn\u00d8\u00d0!\u0006o\u00b8F\u00c4D~\u0019\u00f7\u009aW\u008e\u0018\u0099\u00a7s\u0012O\u00e7\u00e7\u00be\u0088\u00cbJ\u0089\u00fd\u008b\u00f1\u0087\u00b3}\bS\u0017\u00f0\u00fd$%>{*v\u00b9\u0099\u00f4\u0092&\u00d0=i!\u00bd\u0002)\u0087#+\u001c\u00b0\u001c\u00bf^\u0005\u0096\u00009\u007f\u00a9\u00f8\u001a\u00dd\u008a\u0001\f\u008e\u0091\u00db\u0007mI\u00cc\u0097\u000b\u00e2\u00bb\u00f6\r\u008b>\u00df\u00d7\u00dd\u00de\u0005[\u00ea\u00be\u00c5\u00e5^";
                var4_3 = "\u00b4\u0006\u00b2\u00de3\u001c\u00d4\u008a\u009f/\u0082xU3\u001a1B&V\u00a1\r\u0086\u00a4\u009aj\u00c5m\u00d9\u00e9\u001c@vF\u00a0p\u0096\u00f7\u00a1x\u00a4)\u001e\u00ecG\u0086\u00f1e\u0011\u00a1\u0080\t\u008e\u007f\u00d0HM\u00008tcDdq\u0095y\u00d8o]\u00f3j\u0002&\t\u0099\u009a\u00df\u00de\\\u00bb\u00aa<\u00d1\u0011\u00aeB_X\u00e1>*n$\u0005\u001a\u0001\u0015\u00af\u0016+\u00b4\u000f9p\u008e\u00d3#2\u00c0\u0006\u00fe\u00e1z2\r2\u00bd\r\u008f\u00c1X\u00e5\u00f9\u00e1\u009f\u00d7\u008ct\u0086\u00a1\u0012\u001e7\u00efO \u001bL\u00c7\u00c9\u001e\u0018f\r\u008e\u00d5\u00cd\u00e1H\u0084\u0093X\u00b6\u00fd1\u00e3\u00a2\u00f6\u001e\u0000\u00da[\u0011\u0011ZM\"\u0007W\u00dc\u00b5\u00ce\u0003\u00dag&mC\u0019[ p\u00a5\u00a7i\u0006ed\u00ecj\u00b8\u00e8\u009cY\u00cc\u00fe\u00c2\u009d\u00dd\u00dd\u00935\tT<\u0095\u001ct8\u0085\u0011\u00a2C\u0017\u00eb`\u00d4\u00d1hc\u00ad\u0017\u00c6\u00eeNo\u0081\u0005m\u00f7\u0016\u00c8HS\u00d7o\u00a0\u0007\u00a1\u00b1\u00dbu\t\u00d5\u000b:k\u008c\u00f2&O\u00cf\u00b4\u0093\u009e\u0004~%\u0099\u00a4\u0080d\u00d6\u00fb\u00d7\u00b1\u000e\u0001S\u008ez\u00df|o\u00bc\u000f\u00fb\u0090\u0086\u0001\u00adu\u0087]X-\u00e2\u00a8\u00fe5@F\u0019gw\u00e7\u00df\u00f9{\u00c3\u00f1\u001e5\u00dd\u001f\u00f0\u00be\u001e\u00c9\u00a6\u00fef\u00da\u0086\u00a5F\u0094\u00a9\u00d6\u0012\u00a7\u00b7\u00bb\u0094\u00ef\u00966\u00da*\u00e9\u001b\u00b5\u00e5g[\u00bc._I\b?Z\u00c8\u000fu`P\u00dc=A\u0001\u00b7\u00e3\u00bd\u0007\u00b9\u00a2CXx\u00e9\u00dc\u00a2<?\u0084\u00f5\u00afD0\t\f\u009b\u007f\u00f6<\u00948\u00c2\u0015\u000e\u0085\u00c6\u001a\u0006e\u00c0\u00b2}\u0091\u001d7\u00e9\u0018\u00ab#\u0014 \u00a5yAaF\u0094Jk:\u00eb\u00d7[\u001a9\u00ae\u00ad\u00c5\u00bf\u008d\u00e1\u0018]\u00cb.\u00dc\u00f3\u008d\u00db\u0095\u0010\u00cd6\u007fm\u00eb\u00ee\u0081y7\u0011c\u00da\b\u00ac\u0088\u00a3\u00d3\u00e2g\u000f\u00fc\u008f\u00844\u00f9u|\u0015\u00cb\u00d5\u00d3,B\u00cb4\u00f2\u009f\u00f6 U\u00a3PqP\u00df\u00ac3\u00e9\u00af \u008a\u00ee\u00f8\u0000\u00edH\u0019I\u00c5\u001d\u0019\u0004\u00ef:\u00bf\"\u00b6V\u009f\u0088\u0083\u001aE@\u00aa`\tH\u00a8&\u00f9z\t\u00de\u00c4!\u00db~\u00bb\u0092\u00ee\u000e\u0017\u00f0\fa\u009a4\f\u00dc4g\u00d1/\u009b]\u00f1RM\u00cc9\u00bf\u00b901\u00dd\u000f\u0097G\u00ac\u00f6\u00b0\u001d\u00e1?\u00de\u00af\u00aa\u00ca[\u00c8\u00d3\u001aCn\u0017\u00d6\u00fa\u0085\u0005\u0005\\\u00f7\\U\u00b6hHQXUElC\u008dn\u00d8\u00d0!\u0006o\u00b8F\u00c4D~\u0019\u00f7\u009aW\u008e\u0018\u0099\u00a7s\u0012O\u00e7\u00e7\u00be\u0088\u00cbJ\u0089\u00fd\u008b\u00f1\u0087\u00b3}\bS\u0017\u00f0\u00fd$%>{*v\u00b9\u0099\u00f4\u0092&\u00d0=i!\u00bd\u0002)\u0087#+\u001c\u00b0\u001c\u00bf^\u0005\u0096\u00009\u007f\u00a9\u00f8\u001a\u00dd\u008a\u0001\f\u008e\u0091\u00db\u0007mI\u00cc\u0097\u000b\u00e2\u00bb\u00f6\r\u008b>\u00df\u00d7\u00dd\u00de\u0005[\u00ea\u00be\u00c5\u00e5^".length();
                var1_4 = 14;
                BaseSignatureFormat.b(null);
                var0_5 = -1;
lbl8:
                // 2 sources

                while (true) {
                    v0 = 70;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl14:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "Q\u0080^:\u00c5\u00b7\u00e6\u008a\u001dtB\u0095vh\u00e5\u00ea 6bS\u00ad\u00a4\u00c1\fD[\u0080\u00f6\u008b.\u00f7\u00bb\u00a7\n\u00da4%\u00ca\u0093PM4\u00fd\u00e6\u00c7i\u00eb\u00fd\u00ff";
                    var4_3 = "Q\u0080^:\u00c5\u00b7\u00e6\u008a\u001dtB\u0095vh\u00e5\u00ea 6bS\u00ad\u00a4\u00c1\fD[\u0080\u00f6\u008b.\u00f7\u00bb\u00a7\n\u00da4%\u00ca\u0093PM4\u00fd\u00e6\u00c7i\u00eb\u00fd\u00ff".length();
                    var1_4 = 16;
                    var0_5 = -1;
lbl23:
                    // 2 sources

                    while (true) {
                        v0 = 52;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl29:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl86
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 74;
                            break;
                        }
                        case 1: {
                            v15 = 117;
                            break;
                        }
                        case 2: {
                            v15 = 19;
                            break;
                        }
                        case 3: {
                            v15 = 26;
                            break;
                        }
                        case 4: {
                            v15 = 12;
                            break;
                        }
                        case 5: {
                            v15 = 47;
                            break;
                        }
                        default: {
                            v15 = 33;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl86:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl96:
                // 1 sources

                ** continue;
            }
        }
        BaseSignatureFormat.h = var5;
        BaseSignatureFormat.i = new String[31];
        BaseSignatureFormat.a = LoggerFactory.getLogger(BaseSignatureFormat.class);
    }

    public static void b(String string) {
        b = string;
    }

    public static String b() {
        return b;
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0xFFFFD80F) & 0xFFFF;
        if (i[n3] == null) {
            int n4;
            int n5;
            char[] cArray = h[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 160;
                    break;
                }
                case 1: {
                    n5 = 171;
                    break;
                }
                case 2: {
                    n5 = 231;
                    break;
                }
                case 3: {
                    n5 = 136;
                    break;
                }
                case 4: {
                    n5 = 9;
                    break;
                }
                case 5: {
                    n5 = 163;
                    break;
                }
                case 6: {
                    n5 = 149;
                    break;
                }
                case 7: {
                    n5 = 72;
                    break;
                }
                case 8: {
                    n5 = 189;
                    break;
                }
                case 9: {
                    n5 = 89;
                    break;
                }
                case 10: {
                    n5 = 117;
                    break;
                }
                case 11: {
                    n5 = 48;
                    break;
                }
                case 12: {
                    n5 = 101;
                    break;
                }
                case 13: {
                    n5 = 79;
                    break;
                }
                case 14: {
                    n5 = 108;
                    break;
                }
                case 15: {
                    n5 = 39;
                    break;
                }
                case 16: {
                    n5 = 65;
                    break;
                }
                case 17: {
                    n5 = 155;
                    break;
                }
                case 18: {
                    n5 = 142;
                    break;
                }
                case 19: {
                    n5 = 100;
                    break;
                }
                case 20: {
                    n5 = 128;
                    break;
                }
                case 21: {
                    n5 = 131;
                    break;
                }
                case 22: {
                    n5 = 182;
                    break;
                }
                case 23: {
                    n5 = 146;
                    break;
                }
                case 24: {
                    n5 = 52;
                    break;
                }
                case 25: {
                    n5 = 34;
                    break;
                }
                case 26: {
                    n5 = 4;
                    break;
                }
                case 27: {
                    n5 = 161;
                    break;
                }
                case 28: {
                    n5 = 216;
                    break;
                }
                case 29: {
                    n5 = 139;
                    break;
                }
                case 30: {
                    n5 = 175;
                    break;
                }
                case 31: {
                    n5 = 102;
                    break;
                }
                case 32: {
                    n5 = 29;
                    break;
                }
                case 33: {
                    n5 = 218;
                    break;
                }
                case 34: {
                    n5 = 25;
                    break;
                }
                case 35: {
                    n5 = 92;
                    break;
                }
                case 36: {
                    n5 = 211;
                    break;
                }
                case 37: {
                    n5 = 87;
                    break;
                }
                case 38: {
                    n5 = 156;
                    break;
                }
                case 39: {
                    n5 = 125;
                    break;
                }
                case 40: {
                    n5 = 204;
                    break;
                }
                case 41: {
                    n5 = 60;
                    break;
                }
                case 42: {
                    n5 = 238;
                    break;
                }
                case 43: {
                    n5 = 42;
                    break;
                }
                case 44: {
                    n5 = 78;
                    break;
                }
                case 45: {
                    n5 = 206;
                    break;
                }
                case 46: {
                    n5 = 35;
                    break;
                }
                case 47: {
                    n5 = 85;
                    break;
                }
                case 48: {
                    n5 = 119;
                    break;
                }
                case 49: {
                    n5 = 251;
                    break;
                }
                case 50: {
                    n5 = 68;
                    break;
                }
                case 51: {
                    n5 = 176;
                    break;
                }
                case 52: {
                    n5 = 38;
                    break;
                }
                case 53: {
                    n5 = 129;
                    break;
                }
                case 54: {
                    n5 = 254;
                    break;
                }
                case 55: {
                    n5 = 76;
                    break;
                }
                case 56: {
                    n5 = 170;
                    break;
                }
                case 57: {
                    n5 = 191;
                    break;
                }
                case 58: {
                    n5 = 107;
                    break;
                }
                case 59: {
                    n5 = 188;
                    break;
                }
                case 60: {
                    n5 = 140;
                    break;
                }
                case 61: {
                    n5 = 152;
                    break;
                }
                case 62: {
                    n5 = 114;
                    break;
                }
                case 63: {
                    n5 = 183;
                    break;
                }
                case 64: {
                    n5 = 241;
                    break;
                }
                case 65: {
                    n5 = 27;
                    break;
                }
                case 66: {
                    n5 = 253;
                    break;
                }
                case 67: {
                    n5 = 61;
                    break;
                }
                case 68: {
                    n5 = 196;
                    break;
                }
                case 69: {
                    n5 = 157;
                    break;
                }
                case 70: {
                    n5 = 94;
                    break;
                }
                case 71: {
                    n5 = 15;
                    break;
                }
                case 72: {
                    n5 = 32;
                    break;
                }
                case 73: {
                    n5 = 202;
                    break;
                }
                case 74: {
                    n5 = 104;
                    break;
                }
                case 75: {
                    n5 = 134;
                    break;
                }
                case 76: {
                    n5 = 28;
                    break;
                }
                case 77: {
                    n5 = 164;
                    break;
                }
                case 78: {
                    n5 = 186;
                    break;
                }
                case 79: {
                    n5 = 93;
                    break;
                }
                case 80: {
                    n5 = 230;
                    break;
                }
                case 81: {
                    n5 = 12;
                    break;
                }
                case 82: {
                    n5 = 200;
                    break;
                }
                case 83: {
                    n5 = 252;
                    break;
                }
                case 84: {
                    n5 = 123;
                    break;
                }
                case 85: {
                    n5 = 214;
                    break;
                }
                case 86: {
                    n5 = 17;
                    break;
                }
                case 87: {
                    n5 = 239;
                    break;
                }
                case 88: {
                    n5 = 8;
                    break;
                }
                case 89: {
                    n5 = 194;
                    break;
                }
                case 90: {
                    n5 = 203;
                    break;
                }
                case 91: {
                    n5 = 82;
                    break;
                }
                case 92: {
                    n5 = 81;
                    break;
                }
                case 93: {
                    n5 = 84;
                    break;
                }
                case 94: {
                    n5 = 245;
                    break;
                }
                case 95: {
                    n5 = 174;
                    break;
                }
                case 96: {
                    n5 = 173;
                    break;
                }
                case 97: {
                    n5 = 3;
                    break;
                }
                case 98: {
                    n5 = 24;
                    break;
                }
                case 99: {
                    n5 = 83;
                    break;
                }
                case 100: {
                    n5 = 198;
                    break;
                }
                case 101: {
                    n5 = 113;
                    break;
                }
                case 102: {
                    n5 = 50;
                    break;
                }
                case 103: {
                    n5 = 1;
                    break;
                }
                case 104: {
                    n5 = 16;
                    break;
                }
                case 105: {
                    n5 = 124;
                    break;
                }
                case 106: {
                    n5 = 154;
                    break;
                }
                case 107: {
                    n5 = 255;
                    break;
                }
                case 108: {
                    n5 = 95;
                    break;
                }
                case 109: {
                    n5 = 62;
                    break;
                }
                case 110: {
                    n5 = 213;
                    break;
                }
                case 111: {
                    n5 = 47;
                    break;
                }
                case 112: {
                    n5 = 97;
                    break;
                }
                case 113: {
                    n5 = 71;
                    break;
                }
                case 114: {
                    n5 = 240;
                    break;
                }
                case 115: {
                    n5 = 70;
                    break;
                }
                case 116: {
                    n5 = 224;
                    break;
                }
                case 117: {
                    n5 = 201;
                    break;
                }
                case 118: {
                    n5 = 178;
                    break;
                }
                case 119: {
                    n5 = 7;
                    break;
                }
                case 120: {
                    n5 = 229;
                    break;
                }
                case 121: {
                    n5 = 138;
                    break;
                }
                case 122: {
                    n5 = 130;
                    break;
                }
                case 123: {
                    n5 = 59;
                    break;
                }
                case 124: {
                    n5 = 217;
                    break;
                }
                case 125: {
                    n5 = 215;
                    break;
                }
                case 126: {
                    n5 = 212;
                    break;
                }
                case 127: {
                    n5 = 197;
                    break;
                }
                case 128: {
                    n5 = 193;
                    break;
                }
                case 129: {
                    n5 = 103;
                    break;
                }
                case 130: {
                    n5 = 249;
                    break;
                }
                case 131: {
                    n5 = 244;
                    break;
                }
                case 132: {
                    n5 = 167;
                    break;
                }
                case 133: {
                    n5 = 248;
                    break;
                }
                case 134: {
                    n5 = 0;
                    break;
                }
                case 135: {
                    n5 = 11;
                    break;
                }
                case 136: {
                    n5 = 232;
                    break;
                }
                case 137: {
                    n5 = 115;
                    break;
                }
                case 138: {
                    n5 = 145;
                    break;
                }
                case 139: {
                    n5 = 43;
                    break;
                }
                case 140: {
                    n5 = 56;
                    break;
                }
                case 141: {
                    n5 = 148;
                    break;
                }
                case 142: {
                    n5 = 86;
                    break;
                }
                case 143: {
                    n5 = 20;
                    break;
                }
                case 144: {
                    n5 = 235;
                    break;
                }
                case 145: {
                    n5 = 91;
                    break;
                }
                case 146: {
                    n5 = 162;
                    break;
                }
                case 147: {
                    n5 = 179;
                    break;
                }
                case 148: {
                    n5 = 44;
                    break;
                }
                case 149: {
                    n5 = 143;
                    break;
                }
                case 150: {
                    n5 = 132;
                    break;
                }
                case 151: {
                    n5 = 246;
                    break;
                }
                case 152: {
                    n5 = 185;
                    break;
                }
                case 153: {
                    n5 = 77;
                    break;
                }
                case 154: {
                    n5 = 80;
                    break;
                }
                case 155: {
                    n5 = 147;
                    break;
                }
                case 156: {
                    n5 = 46;
                    break;
                }
                case 157: {
                    n5 = 192;
                    break;
                }
                case 158: {
                    n5 = 6;
                    break;
                }
                case 159: {
                    n5 = 165;
                    break;
                }
                case 160: {
                    n5 = 243;
                    break;
                }
                case 161: {
                    n5 = 250;
                    break;
                }
                case 162: {
                    n5 = 10;
                    break;
                }
                case 163: {
                    n5 = 33;
                    break;
                }
                case 164: {
                    n5 = 137;
                    break;
                }
                case 165: {
                    n5 = 122;
                    break;
                }
                case 166: {
                    n5 = 208;
                    break;
                }
                case 167: {
                    n5 = 166;
                    break;
                }
                case 168: {
                    n5 = 112;
                    break;
                }
                case 169: {
                    n5 = 227;
                    break;
                }
                case 170: {
                    n5 = 159;
                    break;
                }
                case 171: {
                    n5 = 54;
                    break;
                }
                case 172: {
                    n5 = 63;
                    break;
                }
                case 173: {
                    n5 = 233;
                    break;
                }
                case 174: {
                    n5 = 45;
                    break;
                }
                case 175: {
                    n5 = 234;
                    break;
                }
                case 176: {
                    n5 = 121;
                    break;
                }
                case 177: {
                    n5 = 23;
                    break;
                }
                case 178: {
                    n5 = 195;
                    break;
                }
                case 179: {
                    n5 = 31;
                    break;
                }
                case 180: {
                    n5 = 53;
                    break;
                }
                case 181: {
                    n5 = 126;
                    break;
                }
                case 182: {
                    n5 = 120;
                    break;
                }
                case 183: {
                    n5 = 118;
                    break;
                }
                case 184: {
                    n5 = 13;
                    break;
                }
                case 185: {
                    n5 = 190;
                    break;
                }
                case 186: {
                    n5 = 30;
                    break;
                }
                case 187: {
                    n5 = 14;
                    break;
                }
                case 188: {
                    n5 = 106;
                    break;
                }
                case 189: {
                    n5 = 18;
                    break;
                }
                case 190: {
                    n5 = 187;
                    break;
                }
                case 191: {
                    n5 = 99;
                    break;
                }
                case 192: {
                    n5 = 40;
                    break;
                }
                case 193: {
                    n5 = 181;
                    break;
                }
                case 194: {
                    n5 = 180;
                    break;
                }
                case 195: {
                    n5 = 153;
                    break;
                }
                case 196: {
                    n5 = 96;
                    break;
                }
                case 197: {
                    n5 = 26;
                    break;
                }
                case 198: {
                    n5 = 168;
                    break;
                }
                case 199: {
                    n5 = 223;
                    break;
                }
                case 200: {
                    n5 = 74;
                    break;
                }
                case 201: {
                    n5 = 73;
                    break;
                }
                case 202: {
                    n5 = 151;
                    break;
                }
                case 203: {
                    n5 = 105;
                    break;
                }
                case 204: {
                    n5 = 37;
                    break;
                }
                case 205: {
                    n5 = 158;
                    break;
                }
                case 206: {
                    n5 = 110;
                    break;
                }
                case 207: {
                    n5 = 51;
                    break;
                }
                case 208: {
                    n5 = 199;
                    break;
                }
                case 209: {
                    n5 = 58;
                    break;
                }
                case 210: {
                    n5 = 109;
                    break;
                }
                case 211: {
                    n5 = 127;
                    break;
                }
                case 212: {
                    n5 = 169;
                    break;
                }
                case 213: {
                    n5 = 55;
                    break;
                }
                case 214: {
                    n5 = 172;
                    break;
                }
                case 215: {
                    n5 = 141;
                    break;
                }
                case 216: {
                    n5 = 236;
                    break;
                }
                case 217: {
                    n5 = 225;
                    break;
                }
                case 218: {
                    n5 = 21;
                    break;
                }
                case 219: {
                    n5 = 207;
                    break;
                }
                case 220: {
                    n5 = 41;
                    break;
                }
                case 221: {
                    n5 = 66;
                    break;
                }
                case 222: {
                    n5 = 228;
                    break;
                }
                case 223: {
                    n5 = 49;
                    break;
                }
                case 224: {
                    n5 = 111;
                    break;
                }
                case 225: {
                    n5 = 88;
                    break;
                }
                case 226: {
                    n5 = 209;
                    break;
                }
                case 227: {
                    n5 = 242;
                    break;
                }
                case 228: {
                    n5 = 210;
                    break;
                }
                case 229: {
                    n5 = 36;
                    break;
                }
                case 230: {
                    n5 = 219;
                    break;
                }
                case 231: {
                    n5 = 19;
                    break;
                }
                case 232: {
                    n5 = 222;
                    break;
                }
                case 233: {
                    n5 = 220;
                    break;
                }
                case 234: {
                    n5 = 2;
                    break;
                }
                case 235: {
                    n5 = 205;
                    break;
                }
                case 236: {
                    n5 = 133;
                    break;
                }
                case 237: {
                    n5 = 237;
                    break;
                }
                case 238: {
                    n5 = 116;
                    break;
                }
                case 239: {
                    n5 = 69;
                    break;
                }
                case 240: {
                    n5 = 75;
                    break;
                }
                case 241: {
                    n5 = 22;
                    break;
                }
                case 242: {
                    n5 = 144;
                    break;
                }
                case 243: {
                    n5 = 64;
                    break;
                }
                case 244: {
                    n5 = 184;
                    break;
                }
                case 245: {
                    n5 = 150;
                    break;
                }
                case 246: {
                    n5 = 221;
                    break;
                }
                case 247: {
                    n5 = 67;
                    break;
                }
                case 248: {
                    n5 = 226;
                    break;
                }
                case 249: {
                    n5 = 57;
                    break;
                }
                case 250: {
                    n5 = 98;
                    break;
                }
                case 251: {
                    n5 = 135;
                    break;
                }
                case 252: {
                    n5 = 90;
                    break;
                }
                case 253: {
                    n5 = 5;
                    break;
                }
                case 254: {
                    n5 = 247;
                    break;
                }
                default: {
                    n5 = 177;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            BaseSignatureFormat.i[n3] = new String(cArray).intern();
        }
        return i[n3];
    }
}

