/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11;

import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.util.ECSignatureTLVUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.Application;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.ISmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SlotInfo;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.KeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.KeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.symmetric.SecretKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.PKCS11Ops;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.key.SecretKey;

public class SmartCard
implements ISmartCard {
    private static Logger a;
    protected CardType mCardType;
    protected Application mApplication;
    protected boolean isFipsEnabled = false;
    protected long mSlotID = -1L;
    protected long mSessionID = -1L;
    private static final String[] b;
    private static final String[] c;

    private SmartCard() {
        try {
            LV.getInstance().checkLD(LV.Urunler.AKILLIKART);
            this.mApplication = Application.ESIGNATURE;
        }
        catch (LE lE) {
            throw new ESYARuntimeException(SmartCard.a(-11489, -17118) + lE.getMessage(), (Throwable)lE);
        }
    }

    public SmartCard(CardType aCardType) throws PKCS11Exception, IOException {
        this(aCardType, Application.ESIGNATURE);
    }

    public SmartCard(CardType aCardType, Application aApplication) throws PKCS11Exception, IOException {
        this();
        a.debug(SmartCard.a(-11494, 22272) + aCardType.getName());
        this.mCardType = aCardType;
        this.mCardType.getCardTemplate().getPKCS11Ops().initialize();
        this.mApplication = aApplication;
    }

    public SmartCard(String aCardTypeName, String smartCardDllName) throws PKCS11Exception, IOException {
        this();
        this.mCardType = CardType.getCardTypeFromName(aCardTypeName);
        if (this.mCardType == CardType.UNKNOWN) {
            this.mCardType = CardType.getCardType(smartCardDllName);
        }
        this.mCardType.getCardTemplate().getPKCS11Ops().initialize();
    }

    public SmartCard(String aCardType) throws PKCS11Exception, IOException {
        this(CardType.getCardType(aCardType));
    }

    public void setFipsMode(boolean mode) {
        this.isFipsEnabled = mode;
    }

    public boolean isFipsModeEnable() {
        return this.isFipsEnabled;
    }

    public void setApplication(Application aApplication) {
        this.mApplication = aApplication;
    }

    public Application getApplication() {
        return this.mApplication;
    }

    @Override
    public long[] getTokenPresentSlotList() throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getTokenPresentSlotList();
    }

    @Override
    public List<Pair<Long, String>> getTokenPresentSlotListWithDescription() throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getTokenPresentSlotListWithDescription();
    }

    @Override
    public long[] getSlotList() throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getSlotList();
    }

    public List<SlotInfo> getSlotInfoList() throws PKCS11Exception {
        long[] lArray = this.getSlotList();
        boolean bl = CardType.b;
        ArrayList<SlotInfo> arrayList = new ArrayList<SlotInfo>();
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            CK_TOKEN_INFO cK_TOKEN_INFO = this.getTokenInfo(l);
            SlotInfo slotInfo = new SlotInfo();
            slotInfo.setSlotId(l);
            slotInfo.setSlotLabel(new String(cK_TOKEN_INFO.label).trim());
            arrayList.add(slotInfo);
            if (!bl) continue;
        }
        return arrayList;
    }

    public long getLatestSlotID() {
        return this.mSlotID;
    }

    public long getLatestSessionID() {
        return this.mSessionID;
    }

    @Override
    public CK_SLOT_INFO getSlotInfo(long aSlotID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getSlotInfo(aSlotID);
    }

    @Override
    public CK_SESSION_INFO getSessionInfo(long aSessionID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getSessionInfo(aSessionID);
    }

    @Override
    public boolean isTokenPresent(long aSlotID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isTokenPresent(aSlotID);
    }

    @Override
    public CK_TOKEN_INFO getTokenInfo(long aSlotID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getTokenInfo(aSlotID);
    }

    @Override
    public long[] getMechanismList(long aSlotID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getMechanismList(aSlotID);
    }

    @Override
    public long openSession(long aSlotID) throws PKCS11Exception {
        long l = this.mCardType.getCardTemplate().getPKCS11Ops().openSession(aSlotID);
        if (l > 0L) {
            this.mSessionID = l;
            this.mSlotID = aSlotID;
        }
        return l;
    }

    @Override
    public void closeSession(long aSessionID) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().closeSession(aSessionID);
    }

    @Override
    public void login(long aSessionID, String aCardPIN) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().login(aSessionID, aCardPIN);
    }

    @Override
    public void logout(long aSessionID) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().logout(aSessionID);
    }

    @Override
    public boolean isAnyObjectExist(long aSessionID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isAnyObjectExist(aSessionID);
    }

    @Override
    public void importCertificate(long aSessionID, String aCertLabel, X509Certificate aSertifika) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().importCertificate(aSessionID, aCertLabel, aSertifika);
    }

    @Override
    public void createKeyPair(long aSessionID, String aKeyLabel, AlgorithmParameterSpec aParamSpec, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        this.mCardType.getCardTemplate().getPKCS11Ops().createKeyPair(aSessionID, aKeyLabel, aParamSpec, aIsSign, aIsEncrypt);
    }

    @Override
    public KeySpec createKeyPair(long aSessionID, KeyPairTemplate template) throws PKCS11Exception, SmartCardException, IOException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().createKeyPair(aSessionID, template);
    }

    @Override
    public byte[] generateRSAPrivateKey(long aSessionID, int keySize) throws ESYAException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().generateRSAPrivateKey(aSessionID, keySize);
    }

    @Override
    public KeyPair generateECKeyPair(long aSessionID, ECParameterSpec ecParameterSpec) throws ESYAException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().generateECKeyPair(aSessionID, ecParameterSpec);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] a(CK_MECHANISM cK_MECHANISM, byte[] byArray) throws SmartCardException {
        byte[] byArray2;
        boolean bl = CardType.b;
        if (this.mApplication == Application.EPASSPORT) {
            return byArray;
        }
        if (this.mApplication != Application.ESIGNATURE) {
            throw new SmartCardException(SmartCard.a(-11491, -25034));
        }
        if (cK_MECHANISM.mechanism != 4161L && cK_MECHANISM.mechanism != 4162L) {
            return byArray;
        }
        if (this.mCardType == CardType.AKIS) {
            byArray2 = ECSignatureTLVUtil.addTLVToSignature((byte[])byArray);
            if (!bl) return byArray2;
        }
        if (this.mCardType == CardType.UTIMACO) {
            byArray2 = byArray;
            if (!bl) return byArray2;
        }
        if (this.mCardType == CardType.NCIPHER) {
            byArray2 = ECSignatureTLVUtil.addTLVToSignature((byte[])byArray);
            if (!bl) return byArray2;
        }
        if (this.mCardType == CardType.DIRAKHSM) {
            byArray2 = ECSignatureTLVUtil.addTLVToSignature((byte[])byArray);
            if (!bl) return byArray2;
        }
        if (ECSignatureTLVUtil.isSignatureInTLVFormat((byte[])byArray)) return byArray;
        byArray2 = ECSignatureTLVUtil.addTLVToSignature((byte[])byArray);
        if (!bl) return byArray2;
        return byArray;
    }

    @Override
    @Deprecated
    public byte[] signDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, long aMechanism, byte[] aToBeSigned) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signDataWithCertSerialNo(aSessionID, aSerialNumber, cK_MECHANISM, aToBeSigned);
        byArray = this.a(cK_MECHANISM, byArray);
        return byArray;
    }

    @Override
    public byte[] signDataWithKeyID(long aSessionID, long aKeyID, CK_MECHANISM aMechanism, byte[] aToBeSigned) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signDataWithKeyID(aSessionID, aKeyID, aMechanism, aToBeSigned);
        byArray = this.a(aMechanism, byArray);
        return byArray;
    }

    @Override
    public byte[] signDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aToBeSigned) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signDataWithCertSerialNo(aSessionID, aSerialNumber, aMechanism, aToBeSigned);
        byArray = this.a(aMechanism, byArray);
        return byArray;
    }

    @Override
    @Deprecated
    public byte[] decryptDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, long aMechanism, byte[] aData) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        return this.mCardType.getCardTemplate().getPKCS11Ops().decryptDataWithCertSerialNo(aSessionID, aSerialNumber, cK_MECHANISM, aData);
    }

    @Override
    public byte[] decryptDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aData) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        return this.mCardType.getCardTemplate().getPKCS11Ops().decryptDataWithCertSerialNo(aSessionID, aSerialNumber, aMechanism, aData);
    }

    @Override
    public List<byte[]> getCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        return this.mCardType.getCardTemplate().getPKCS11Ops().getCertificates(aSessionID);
    }

    @Override
    public List<byte[]> getSignatureCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getSignatureCertificates(aSessionID);
    }

    @Override
    public List<byte[]> getEncryptionCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getEncryptionCertificates(aSessionID);
    }

    @Override
    public String[] getSignatureKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getSignatureKeyLabels(aSessionID);
    }

    @Override
    public long getPrivateKeyObjIDFromCertificateSerial(long aSessionID, byte[] aCertSerialNo) throws SmartCardException, PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getPrivateKeyObjIDFromCertificateSerial(aSessionID, aCertSerialNo);
    }

    @Override
    public long getPrivateKeyObjIDFromPrivateKeyLabel(long aSessionID, String aLabel) throws SmartCardException, PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getObjIDFromPrivateKeyLabel(aSessionID, aLabel);
    }

    @Override
    public long getPublicKeyObjIDFromPublicKeyLabel(long aSessionID, String aLabel) throws SmartCardException, PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getObjIDFromPublicKeyLabel(aSessionID, aLabel);
    }

    @Override
    public String[] getEncryptionKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getEncryptionKeyLabels(aSessionID);
    }

    @Override
    public String[] getWrapperKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getWrapperKeyLabels(aSessionID);
    }

    @Override
    public String[] getUnwrapperKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getUnwrapperKeyLabels(aSessionID);
    }

    @Override
    public boolean isObjectExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isObjectExist(aSessionID, aLabel);
    }

    @Override
    public void writePrivateData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().writePrivateData(aSessionID, aLabel, aData);
    }

    @Override
    public void writePublicData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().writePublicData(aSessionID, aLabel, aData);
    }

    @Override
    public List<byte[]> readPrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readPrivateData(aSessionID, aLabel);
    }

    @Override
    public List<byte[]> readPublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readPublicData(aSessionID, aLabel);
    }

    @Override
    public boolean isPublicKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isPublicKeyExist(aSessionID, aLabel);
    }

    @Override
    public boolean isPrivateKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isPrivateKeyExist(aSessionID, aLabel);
    }

    @Override
    public boolean isCertificateExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isCertificateExist(aSessionID, aLabel);
    }

    @Override
    public List<byte[]> readCertificate(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readCertificate(aSessionID, aLabel);
    }

    @Override
    public byte[] readCertificate(long aSessionID, byte[] aCertSerialNo) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readCertificate(aSessionID, aCertSerialNo);
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readPublicKeySpec(aSessionID, aLabel);
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, byte[] aCertSerialNo) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readPublicKeySpec(aSessionID, aCertSerialNo);
    }

    @Override
    public void updatePrivateData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().updatePrivateData(aSessionID, aLabel, aValue);
    }

    @Override
    public void updatePublicData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().updatePublicData(aSessionID, aLabel, aValue);
    }

    @Override
    public void deletePrivateObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().deletePrivateObject(aSessionID, aLabel);
    }

    @Override
    public void deletePublicObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().deletePublicObject(aSessionID, aLabel);
    }

    @Override
    public void deletePrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().deletePrivateData(aSessionID, aLabel);
    }

    @Override
    public void deletePublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().deletePublicData(aSessionID, aLabel);
    }

    @Override
    public byte[] getRandomData(long aSessionID, int aDataLength) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getRandomData(aSessionID, aDataLength);
    }

    @Override
    public byte[] getTokenSerialNo(long aSlotID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getTokenSerialNo(aSlotID);
    }

    @Override
    @Deprecated
    public byte[] signData(long aSessionID, String aKeyLabel, byte[] aToBeSigned, long aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signData(aSessionID, aKeyLabel, aToBeSigned, cK_MECHANISM);
        byArray = this.a(cK_MECHANISM, byArray);
        return byArray;
    }

    @Override
    public byte[] signData(long aSessionID, String aKeyLabel, byte[] aToBeSigned, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signData(aSessionID, aKeyLabel, aToBeSigned, aMechanism);
        byArray = this.a(aMechanism, byArray);
        return byArray;
    }

    public byte[] signAndRecoverData(long aSessionID, String aKeyLabel, byte[] aToBeSigned, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signAndRecoverData(aSessionID, aKeyLabel, aToBeSigned, aMechanism);
        byArray = this.a(aMechanism, byArray);
        return byArray;
    }

    public byte[] verifyAndRecoverData(long aSessionID, String aKeyLabel, byte[] aSignedData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().verifyAndRecoverData(aSessionID, aKeyLabel, aSignedData, aMechanism);
        byArray = this.a(aMechanism, byArray);
        return byArray;
    }

    @Override
    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aSignature, long aMechanism) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        byte[] byArray = this.decodeSignatureIfItIsEC(aSessionID, aKeyLabel, cK_MECHANISM, aSignature);
        this.mCardType.getCardTemplate().getPKCS11Ops().verifyData(aSessionID, aKeyLabel, aData, byArray, aMechanism);
    }

    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aSignature, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.decodeSignatureIfItIsEC(aSessionID, aKeyLabel, aMechanism, aSignature);
        this.mCardType.getCardTemplate().getPKCS11Ops().verifyData(aSessionID, aKeyLabel, aData, byArray, aMechanism);
    }

    public byte[] decodeSignatureIfItIsEC(long aSessionID, String aKeyLabel, CK_MECHANISM mech, byte[] aSignature) {
        block5: {
            if (mech.mechanism != 4161L && mech.mechanism != 4162L) break block5;
            try {
                if (ECSignatureTLVUtil.isSignatureInTLVFormat((byte[])aSignature)) {
                    ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)this.readPublicKeySpec(aSessionID, aKeyLabel);
                    int n = eCPublicKeySpec.getParams().getOrder().bitLength();
                    return ECSignatureTLVUtil.removeTLVFromSignature((byte[])aSignature, (int)n);
                }
                return aSignature;
            }
            catch (Exception exception) {
                a.error(exception.toString(), (Throwable)exception);
                return aSignature;
            }
        }
        return aSignature;
    }

    @Override
    @Deprecated
    public byte[] encryptData(long aSessionID, String aKeyLabel, byte[] aData, long aMechanism) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        return this.mCardType.getCardTemplate().getPKCS11Ops().encryptData(aSessionID, aKeyLabel, aData, cK_MECHANISM);
    }

    @Override
    public byte[] encryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().encryptData(aSessionID, aKeyLabel, aData, aMechanism);
    }

    @Override
    @Deprecated
    public byte[] decryptData(long aSessionID, String aKeyLabel, byte[] aData, long aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        return this.mCardType.getCardTemplate().getPKCS11Ops().decryptData(aSessionID, aKeyLabel, aData, cK_MECHANISM);
    }

    @Override
    public byte[] decryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        return this.mCardType.getCardTemplate().getPKCS11Ops().decryptData(aSessionID, aKeyLabel, aData, aMechanism);
    }

    @Override
    public void importCertificateAndKey(long aSessionID, String aCertLabel, String aKeyLabel, PrivateKey aPrivKey, X509Certificate aCert) throws PKCS11Exception, SmartCardException, IOException {
        this.mCardType.getCardTemplate().getPKCS11Ops().importCertificateAndKey(aSessionID, aCertLabel, aKeyLabel, aPrivKey, aCert);
    }

    @Override
    @Deprecated
    public void importKeyPair(long aSessionID, String aLabel, KeyPair aKeyPair, byte[] aSubject, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        this.mCardType.getCardTemplate().getPKCS11Ops().importKeyPair(aSessionID, aLabel, aKeyPair, aSubject, aIsSign, aIsEncrypt);
    }

    @Override
    public void changePassword(String aOldPass, String aNewPass, long aSessionID) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().changePassword(aOldPass, aNewPass, aSessionID);
    }

    @Override
    public void formatToken(String aSOpin, String aNewPIN, String aLabel, int slotID) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().formatToken(aSOpin, aNewPIN, aLabel, slotID);
    }

    @Override
    public void setSOPin(byte[] aSOPin, byte[] aNewSOPin, long aSessionHandle) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().setSOPin(aSOPin, aNewSOPin, aSessionHandle);
    }

    @Override
    public void changeUserPin(byte[] aSOPin, byte[] aUserPin, long aSessionHandle) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().changeUserPin(aSOPin, aUserPin, aSessionHandle);
    }

    @Override
    public boolean setContainer(byte[] aContainerLabel, long aSessionHandle) {
        return this.mCardType.getCardTemplate().getPKCS11Ops().setContainer(aContainerLabel, aSessionHandle);
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, X509Certificate aPbCertificate, int aSignOrEnc) {
        return this.mCardType.getCardTemplate().getPKCS11Ops().importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarLen, aScfname, aContextName, aPbCertificate, aSignOrEnc);
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, byte[] aPbCertificate, int aSignOrEnc) {
        return this.mCardType.getCardTemplate().getPKCS11Ops().importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarLen, aScfname, aContextName, aPbCertificate, aSignOrEnc);
    }

    @Override
    public void createSecretKey(long aSessionID, SecretKey aKey) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().createSecretKey(aSessionID, aKey);
    }

    @Override
    public void importSecretKey(long aSessionID, SecretKey aKey) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().importSecretKey(aSessionID, aKey);
    }

    public void importSecretKey(long aSessionID, SecretKeyTemplate aKeyTemplate) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().importSecretKey(aSessionID, aKeyTemplate);
    }

    private void a(long l, List<String> list) throws PKCS11Exception, SmartCardException {
        this.deletePrivateObject(l, list.get(0));
        this.deletePrivateObject(l, list.get(1));
    }

    protected static CardType findCardType(String aATRHex, Application aApp) {
        return CardType.getCardTypeFromATR(aATRHex, aApp);
    }

    @Override
    public CardType getKartTipi() {
        return this.mCardType;
    }

    @Override
    public long[] objeAra(long aSessionID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().objeAra(aSessionID, aTemplate);
    }

    @Override
    public void getAttributeValue(long aSessionID, long aObjectID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().getAttributeValue(aSessionID, aObjectID, aTemplate);
    }

    @Override
    public void changeLabel(long aSessionID, String aOldLabel, String aNewLabel) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().changeLabel(aSessionID, aOldLabel, aNewLabel);
    }

    public static void checkLicense() {
        try {
            boolean bl = LV.getInstance().isTL(LV.Urunler.AKILLIKART);
            if (bl) {
                a.debug(SmartCard.a(-11503, 29095));
                Thread.sleep(2000L);
            }
        }
        catch (LE lE) {
            throw new ESYARuntimeException(SmartCard.a(-11495, 6379) + lE.getMessage(), (Throwable)lE);
        }
        catch (InterruptedException interruptedException) {
            throw new ESYARuntimeException(SmartCard.a(-11492, 11341), (Throwable)interruptedException);
        }
    }

    @Override
    public byte[] getModulusOfKey(long aSessionID, long aObjID) throws SmartCardException, PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getModulusOfKey(aSessionID, aObjID);
    }

    @Override
    public byte[] wrapKey(long sessionID, CK_MECHANISM mechanism, String wrapperKeyLabel, String labelOfKeyToWrap) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().wrapKey(sessionID, mechanism, wrapperKeyLabel, labelOfKeyToWrap);
    }

    @Override
    public byte[] wrapKey(long sessionID, CK_MECHANISM mechanism, KeyTemplate wrapperKeyTemplate, KeyTemplate wrappingKeyTemplate) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().wrapKey(sessionID, mechanism, wrapperKeyTemplate, wrappingKeyTemplate);
    }

    @Override
    public void unwrapKey(long sessionID, CK_MECHANISM mechanism, String unwrapperKeyLabel, byte[] wrappedKey, KeyTemplate unwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().unwrapKey(sessionID, mechanism, unwrapperKeyLabel, wrappedKey, unwrappedKeyTemplate);
    }

    @Override
    public void unwrapKey(long sessionID, CK_MECHANISM mechanism, KeyTemplate unwrapperKeyTemplate, byte[] wrappedKey, KeyTemplate unwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().unwrapKey(sessionID, mechanism, unwrapperKeyTemplate, wrappedKey, unwrappedKeyTemplate);
    }

    @Override
    public void unwrapKey(long sessionID, CK_MECHANISM mechanism, byte[] certSerialNumber, byte[] wrappedKey, KeyTemplate unwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().unwrapKey(sessionID, mechanism, certSerialNumber, wrappedKey, unwrappedKeyTemplate);
    }

    @Override
    public CardType getCardType() {
        return this.mCardType;
    }

    @Override
    public void importKeyPair(long sessionID, KeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().importKeyPair(sessionID, template);
    }

    @Override
    public void createSecretKey(long sessionID, SecretKeyTemplate template) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().createSecretKey(sessionID, template);
    }

    public int deleteCertificate(long aSessionID, String aKeyLabel) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().deleteCertificate(aSessionID, aKeyLabel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSupportsWrapUnwrap(long sessionId) {
        PKCS11Ops pKCS11Ops;
        boolean bl;
        block5: {
            bl = true;
            pKCS11Ops = (PKCS11Ops)this.getCardType().getCardTemplate().getPKCS11Ops();
            try {
                pKCS11Ops.getmPKCS11().C_WrapKey(sessionId, new CK_MECHANISM(1L), -1L, -1L);
            }
            catch (PKCS11Exception pKCS11Exception) {
                a.warn(SmartCard.a(-11490, -21561), (Throwable)pKCS11Exception);
                if (pKCS11Exception.getErrorCode() != 84L) break block5;
                bl = false;
            }
        }
        if (!bl) return bl;
        try {
            pKCS11Ops.getmPKCS11().C_UnwrapKey(sessionId, new CK_MECHANISM(1L), -1L, SmartCard.a(-11496, 21902).getBytes(), null);
            return bl;
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.warn(SmartCard.a(-11493, 19634), (Throwable)pKCS11Exception);
            if (pKCS11Exception.getErrorCode() != 84L) return bl;
            return false;
        }
    }

    public PKCS11 getPKCS11() {
        return ((PKCS11Ops)this.getCardType().getCardTemplate().getPKCS11Ops()).getmPKCS11();
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[9];
                var3_1 = 0;
                var2_2 = "\u00d8\u00aa\u000e]^\u00b1\u009d\u00c6q\u0013\u00f5_\u000fn\u0090\u0085\b\u00d8\u00b0\u0013\u00ac\u00c0S\u0096 T5\u0004\u001aViZ\u0014\u009f\u00cb\u009fwJ\u0007\u00bf\u00e5\u009cU\u00da\u00b66[\u00f2\u00db\u0082\u00cd\u00e5\u00b4\n\u0080y\u00ea+\u00d9\u00d0@\u00af\u00c5\u00bf\"\u001d\u009a\u0094\u00b3\u0017\u0086\u00db\u00ef\u0010\n6\u00bf\u00f5\u00a0\u001d\u00e6$dB\nX\u008cZ\u0090\u000e\u0096m\u00e2\u00d1\u009eA\u0011\u0099\u00b2*\u00fa:JO\u00d6\u00f3\u008c\u008eS\u001a\u00b1~\u0087J\u0081\u0001;@\u00e4\t\u0006\u0083:\u00f3\u00a8Z\u0015\u00d4\u0014\u00d5\u00a9,\u0090\u00ed<$F\u0003j\u00ac\u00a3\u0086\u001b\u00fd{\u00aag\u00ca\u00f6\u000f.#\u000e\u00bf\u00fcF\u001a\u00b9\u000b-\t\u0014)8\u0087\u00c1~rI\u007f";
                var4_3 = "\u00d8\u00aa\u000e]^\u00b1\u009d\u00c6q\u0013\u00f5_\u000fn\u0090\u0085\b\u00d8\u00b0\u0013\u00ac\u00c0S\u0096 T5\u0004\u001aViZ\u0014\u009f\u00cb\u009fwJ\u0007\u00bf\u00e5\u009cU\u00da\u00b66[\u00f2\u00db\u0082\u00cd\u00e5\u00b4\n\u0080y\u00ea+\u00d9\u00d0@\u00af\u00c5\u00bf\"\u001d\u009a\u0094\u00b3\u0017\u0086\u00db\u00ef\u0010\n6\u00bf\u00f5\u00a0\u001d\u00e6$dB\nX\u008cZ\u0090\u000e\u0096m\u00e2\u00d1\u009eA\u0011\u0099\u00b2*\u00fa:JO\u00d6\u00f3\u008c\u008eS\u001a\u00b1~\u0087J\u0081\u0001;@\u00e4\t\u0006\u0083:\u00f3\u00a8Z\u0015\u00d4\u0014\u00d5\u00a9,\u0090\u00ed<$F\u0003j\u00ac\u00a3\u0086\u001b\u00fd{\u00aag\u00ca\u00f6\u000f.#\u000e\u00bf\u00fcF\u001a\u00b9\u000b-\t\u0014)8\u0087\u00c1~rI\u007f".length();
                var1_4 = 27;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "(~i\u00c1\u0094\u00d1d?\u00e7\u000e\u00b5\u00dd\u00db6Ov5x\u0013\u00029\u00b5\u00d6\u00b8J\u00c6\u00fb@k\u00a4\u00bd\u0087\u01c9\u00e5\u00db\u00f2\u00bd\u0181\u00f0\u00a7\u01ea\u00e0\u00a7\u00d0#\u000e\u0094v\u013c`\u00df#s-\u00d9\u00d0\u00ef\u00b3\u0098\u0093Q\u0017\u0017\u00c4\u000f\u0012\u00afNaY\u01a3\u008e\r\u00d0\u008d\u0012\u0000\u00a7";
                    var4_3 = "(~i\u00c1\u0094\u00d1d?\u00e7\u000e\u00b5\u00dd\u00db6Ov5x\u0013\u00029\u00b5\u00d6\u00b8J\u00c6\u00fb@k\u00a4\u00bd\u0087\u01c9\u00e5\u00db\u00f2\u00bd\u0181\u00f0\u00a7\u01ea\u00e0\u00a7\u00d0#\u000e\u0094v\u013c`\u00df#s-\u00d9\u00d0\u00ef\u00b3\u0098\u0093Q\u0017\u0017\u00c4\u000f\u0012\u00afNaY\u01a3\u008e\r\u00d0\u008d\u0012\u0000\u00a7".length();
                    var1_4 = 20;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 39;
                            break;
                        }
                        case 1: {
                            v13 = 35;
                            break;
                        }
                        case 2: {
                            v13 = 71;
                            break;
                        }
                        case 3: {
                            v13 = 73;
                            break;
                        }
                        case 4: {
                            v13 = 4;
                            break;
                        }
                        case 5: {
                            v13 = 13;
                            break;
                        }
                        default: {
                            v13 = 85;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        SmartCard.b = var5;
        SmartCard.c = new String[9];
        SmartCard.a = LoggerFactory.getLogger(SmartCard.class);
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0xFFFFD319) & 0xFFFF;
        if (c[n3] == null) {
            int n4;
            int n5;
            char[] cArray = b[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 116;
                    break;
                }
                case 1: {
                    n5 = 133;
                    break;
                }
                case 2: {
                    n5 = 57;
                    break;
                }
                case 3: {
                    n5 = 228;
                    break;
                }
                case 4: {
                    n5 = 77;
                    break;
                }
                case 5: {
                    n5 = 102;
                    break;
                }
                case 6: {
                    n5 = 234;
                    break;
                }
                case 7: {
                    n5 = 88;
                    break;
                }
                case 8: {
                    n5 = 103;
                    break;
                }
                case 9: {
                    n5 = 196;
                    break;
                }
                case 10: {
                    n5 = 179;
                    break;
                }
                case 11: {
                    n5 = 152;
                    break;
                }
                case 12: {
                    n5 = 38;
                    break;
                }
                case 13: {
                    n5 = 42;
                    break;
                }
                case 14: {
                    n5 = 138;
                    break;
                }
                case 15: {
                    n5 = 111;
                    break;
                }
                case 16: {
                    n5 = 207;
                    break;
                }
                case 17: {
                    n5 = 151;
                    break;
                }
                case 18: {
                    n5 = 97;
                    break;
                }
                case 19: {
                    n5 = 222;
                    break;
                }
                case 20: {
                    n5 = 215;
                    break;
                }
                case 21: {
                    n5 = 134;
                    break;
                }
                case 22: {
                    n5 = 192;
                    break;
                }
                case 23: {
                    n5 = 122;
                    break;
                }
                case 24: {
                    n5 = 181;
                    break;
                }
                case 25: {
                    n5 = 90;
                    break;
                }
                case 26: {
                    n5 = 131;
                    break;
                }
                case 27: {
                    n5 = 0;
                    break;
                }
                case 28: {
                    n5 = 21;
                    break;
                }
                case 29: {
                    n5 = 22;
                    break;
                }
                case 30: {
                    n5 = 68;
                    break;
                }
                case 31: {
                    n5 = 129;
                    break;
                }
                case 32: {
                    n5 = 174;
                    break;
                }
                case 33: {
                    n5 = 29;
                    break;
                }
                case 34: {
                    n5 = 236;
                    break;
                }
                case 35: {
                    n5 = 200;
                    break;
                }
                case 36: {
                    n5 = 232;
                    break;
                }
                case 37: {
                    n5 = 48;
                    break;
                }
                case 38: {
                    n5 = 249;
                    break;
                }
                case 39: {
                    n5 = 19;
                    break;
                }
                case 40: {
                    n5 = 250;
                    break;
                }
                case 41: {
                    n5 = 172;
                    break;
                }
                case 42: {
                    n5 = 51;
                    break;
                }
                case 43: {
                    n5 = 226;
                    break;
                }
                case 44: {
                    n5 = 248;
                    break;
                }
                case 45: {
                    n5 = 171;
                    break;
                }
                case 46: {
                    n5 = 24;
                    break;
                }
                case 47: {
                    n5 = 224;
                    break;
                }
                case 48: {
                    n5 = 53;
                    break;
                }
                case 49: {
                    n5 = 255;
                    break;
                }
                case 50: {
                    n5 = 13;
                    break;
                }
                case 51: {
                    n5 = 93;
                    break;
                }
                case 52: {
                    n5 = 136;
                    break;
                }
                case 53: {
                    n5 = 126;
                    break;
                }
                case 54: {
                    n5 = 241;
                    break;
                }
                case 55: {
                    n5 = 79;
                    break;
                }
                case 56: {
                    n5 = 235;
                    break;
                }
                case 57: {
                    n5 = 12;
                    break;
                }
                case 58: {
                    n5 = 199;
                    break;
                }
                case 59: {
                    n5 = 43;
                    break;
                }
                case 60: {
                    n5 = 4;
                    break;
                }
                case 61: {
                    n5 = 69;
                    break;
                }
                case 62: {
                    n5 = 100;
                    break;
                }
                case 63: {
                    n5 = 39;
                    break;
                }
                case 64: {
                    n5 = 127;
                    break;
                }
                case 65: {
                    n5 = 2;
                    break;
                }
                case 66: {
                    n5 = 176;
                    break;
                }
                case 67: {
                    n5 = 55;
                    break;
                }
                case 68: {
                    n5 = 184;
                    break;
                }
                case 69: {
                    n5 = 223;
                    break;
                }
                case 70: {
                    n5 = 216;
                    break;
                }
                case 71: {
                    n5 = 168;
                    break;
                }
                case 72: {
                    n5 = 3;
                    break;
                }
                case 73: {
                    n5 = 115;
                    break;
                }
                case 74: {
                    n5 = 170;
                    break;
                }
                case 75: {
                    n5 = 154;
                    break;
                }
                case 76: {
                    n5 = 245;
                    break;
                }
                case 77: {
                    n5 = 227;
                    break;
                }
                case 78: {
                    n5 = 173;
                    break;
                }
                case 79: {
                    n5 = 65;
                    break;
                }
                case 80: {
                    n5 = 72;
                    break;
                }
                case 81: {
                    n5 = 71;
                    break;
                }
                case 82: {
                    n5 = 91;
                    break;
                }
                case 83: {
                    n5 = 130;
                    break;
                }
                case 84: {
                    n5 = 5;
                    break;
                }
                case 85: {
                    n5 = 252;
                    break;
                }
                case 86: {
                    n5 = 143;
                    break;
                }
                case 87: {
                    n5 = 15;
                    break;
                }
                case 88: {
                    n5 = 141;
                    break;
                }
                case 89: {
                    n5 = 94;
                    break;
                }
                case 90: {
                    n5 = 32;
                    break;
                }
                case 91: {
                    n5 = 89;
                    break;
                }
                case 92: {
                    n5 = 96;
                    break;
                }
                case 93: {
                    n5 = 201;
                    break;
                }
                case 94: {
                    n5 = 106;
                    break;
                }
                case 95: {
                    n5 = 177;
                    break;
                }
                case 96: {
                    n5 = 34;
                    break;
                }
                case 97: {
                    n5 = 150;
                    break;
                }
                case 98: {
                    n5 = 167;
                    break;
                }
                case 99: {
                    n5 = 191;
                    break;
                }
                case 100: {
                    n5 = 132;
                    break;
                }
                case 101: {
                    n5 = 229;
                    break;
                }
                case 102: {
                    n5 = 253;
                    break;
                }
                case 103: {
                    n5 = 63;
                    break;
                }
                case 104: {
                    n5 = 156;
                    break;
                }
                case 105: {
                    n5 = 104;
                    break;
                }
                case 106: {
                    n5 = 35;
                    break;
                }
                case 107: {
                    n5 = 86;
                    break;
                }
                case 108: {
                    n5 = 238;
                    break;
                }
                case 109: {
                    n5 = 230;
                    break;
                }
                case 110: {
                    n5 = 52;
                    break;
                }
                case 111: {
                    n5 = 74;
                    break;
                }
                case 112: {
                    n5 = 183;
                    break;
                }
                case 113: {
                    n5 = 17;
                    break;
                }
                case 114: {
                    n5 = 147;
                    break;
                }
                case 115: {
                    n5 = 47;
                    break;
                }
                case 116: {
                    n5 = 108;
                    break;
                }
                case 117: {
                    n5 = 62;
                    break;
                }
                case 118: {
                    n5 = 75;
                    break;
                }
                case 119: {
                    n5 = 160;
                    break;
                }
                case 120: {
                    n5 = 231;
                    break;
                }
                case 121: {
                    n5 = 26;
                    break;
                }
                case 122: {
                    n5 = 204;
                    break;
                }
                case 123: {
                    n5 = 157;
                    break;
                }
                case 124: {
                    n5 = 145;
                    break;
                }
                case 125: {
                    n5 = 87;
                    break;
                }
                case 126: {
                    n5 = 220;
                    break;
                }
                case 127: {
                    n5 = 58;
                    break;
                }
                case 128: {
                    n5 = 83;
                    break;
                }
                case 129: {
                    n5 = 142;
                    break;
                }
                case 130: {
                    n5 = 78;
                    break;
                }
                case 131: {
                    n5 = 113;
                    break;
                }
                case 132: {
                    n5 = 45;
                    break;
                }
                case 133: {
                    n5 = 8;
                    break;
                }
                case 134: {
                    n5 = 109;
                    break;
                }
                case 135: {
                    n5 = 112;
                    break;
                }
                case 136: {
                    n5 = 178;
                    break;
                }
                case 137: {
                    n5 = 46;
                    break;
                }
                case 138: {
                    n5 = 14;
                    break;
                }
                case 139: {
                    n5 = 148;
                    break;
                }
                case 140: {
                    n5 = 128;
                    break;
                }
                case 141: {
                    n5 = 211;
                    break;
                }
                case 142: {
                    n5 = 36;
                    break;
                }
                case 143: {
                    n5 = 70;
                    break;
                }
                case 144: {
                    n5 = 194;
                    break;
                }
                case 145: {
                    n5 = 243;
                    break;
                }
                case 146: {
                    n5 = 225;
                    break;
                }
                case 147: {
                    n5 = 16;
                    break;
                }
                case 148: {
                    n5 = 203;
                    break;
                }
                case 149: {
                    n5 = 121;
                    break;
                }
                case 150: {
                    n5 = 37;
                    break;
                }
                case 151: {
                    n5 = 123;
                    break;
                }
                case 152: {
                    n5 = 187;
                    break;
                }
                case 153: {
                    n5 = 185;
                    break;
                }
                case 154: {
                    n5 = 217;
                    break;
                }
                case 155: {
                    n5 = 146;
                    break;
                }
                case 156: {
                    n5 = 31;
                    break;
                }
                case 157: {
                    n5 = 33;
                    break;
                }
                case 158: {
                    n5 = 175;
                    break;
                }
                case 159: {
                    n5 = 92;
                    break;
                }
                case 160: {
                    n5 = 186;
                    break;
                }
                case 161: {
                    n5 = 153;
                    break;
                }
                case 162: {
                    n5 = 169;
                    break;
                }
                case 163: {
                    n5 = 66;
                    break;
                }
                case 164: {
                    n5 = 202;
                    break;
                }
                case 165: {
                    n5 = 60;
                    break;
                }
                case 166: {
                    n5 = 98;
                    break;
                }
                case 167: {
                    n5 = 28;
                    break;
                }
                case 168: {
                    n5 = 80;
                    break;
                }
                case 169: {
                    n5 = 210;
                    break;
                }
                case 170: {
                    n5 = 244;
                    break;
                }
                case 171: {
                    n5 = 137;
                    break;
                }
                case 172: {
                    n5 = 23;
                    break;
                }
                case 173: {
                    n5 = 117;
                    break;
                }
                case 174: {
                    n5 = 165;
                    break;
                }
                case 175: {
                    n5 = 246;
                    break;
                }
                case 176: {
                    n5 = 76;
                    break;
                }
                case 177: {
                    n5 = 10;
                    break;
                }
                case 178: {
                    n5 = 251;
                    break;
                }
                case 179: {
                    n5 = 110;
                    break;
                }
                case 180: {
                    n5 = 239;
                    break;
                }
                case 181: {
                    n5 = 61;
                    break;
                }
                case 182: {
                    n5 = 205;
                    break;
                }
                case 183: {
                    n5 = 161;
                    break;
                }
                case 184: {
                    n5 = 195;
                    break;
                }
                case 185: {
                    n5 = 84;
                    break;
                }
                case 186: {
                    n5 = 219;
                    break;
                }
                case 187: {
                    n5 = 9;
                    break;
                }
                case 188: {
                    n5 = 30;
                    break;
                }
                case 189: {
                    n5 = 124;
                    break;
                }
                case 190: {
                    n5 = 49;
                    break;
                }
                case 191: {
                    n5 = 105;
                    break;
                }
                case 192: {
                    n5 = 44;
                    break;
                }
                case 193: {
                    n5 = 162;
                    break;
                }
                case 194: {
                    n5 = 198;
                    break;
                }
                case 195: {
                    n5 = 240;
                    break;
                }
                case 196: {
                    n5 = 237;
                    break;
                }
                case 197: {
                    n5 = 155;
                    break;
                }
                case 198: {
                    n5 = 221;
                    break;
                }
                case 199: {
                    n5 = 163;
                    break;
                }
                case 200: {
                    n5 = 6;
                    break;
                }
                case 201: {
                    n5 = 164;
                    break;
                }
                case 202: {
                    n5 = 182;
                    break;
                }
                case 203: {
                    n5 = 67;
                    break;
                }
                case 204: {
                    n5 = 158;
                    break;
                }
                case 205: {
                    n5 = 120;
                    break;
                }
                case 206: {
                    n5 = 119;
                    break;
                }
                case 207: {
                    n5 = 209;
                    break;
                }
                case 208: {
                    n5 = 1;
                    break;
                }
                case 209: {
                    n5 = 81;
                    break;
                }
                case 210: {
                    n5 = 214;
                    break;
                }
                case 211: {
                    n5 = 40;
                    break;
                }
                case 212: {
                    n5 = 11;
                    break;
                }
                case 213: {
                    n5 = 213;
                    break;
                }
                case 214: {
                    n5 = 149;
                    break;
                }
                case 215: {
                    n5 = 99;
                    break;
                }
                case 216: {
                    n5 = 208;
                    break;
                }
                case 217: {
                    n5 = 25;
                    break;
                }
                case 218: {
                    n5 = 140;
                    break;
                }
                case 219: {
                    n5 = 180;
                    break;
                }
                case 220: {
                    n5 = 125;
                    break;
                }
                case 221: {
                    n5 = 188;
                    break;
                }
                case 222: {
                    n5 = 82;
                    break;
                }
                case 223: {
                    n5 = 41;
                    break;
                }
                case 224: {
                    n5 = 212;
                    break;
                }
                case 225: {
                    n5 = 54;
                    break;
                }
                case 226: {
                    n5 = 107;
                    break;
                }
                case 227: {
                    n5 = 233;
                    break;
                }
                case 228: {
                    n5 = 64;
                    break;
                }
                case 229: {
                    n5 = 159;
                    break;
                }
                case 230: {
                    n5 = 193;
                    break;
                }
                case 231: {
                    n5 = 206;
                    break;
                }
                case 232: {
                    n5 = 95;
                    break;
                }
                case 233: {
                    n5 = 197;
                    break;
                }
                case 234: {
                    n5 = 50;
                    break;
                }
                case 235: {
                    n5 = 118;
                    break;
                }
                case 236: {
                    n5 = 18;
                    break;
                }
                case 237: {
                    n5 = 139;
                    break;
                }
                case 238: {
                    n5 = 190;
                    break;
                }
                case 239: {
                    n5 = 73;
                    break;
                }
                case 240: {
                    n5 = 114;
                    break;
                }
                case 241: {
                    n5 = 7;
                    break;
                }
                case 242: {
                    n5 = 59;
                    break;
                }
                case 243: {
                    n5 = 85;
                    break;
                }
                case 244: {
                    n5 = 27;
                    break;
                }
                case 245: {
                    n5 = 247;
                    break;
                }
                case 246: {
                    n5 = 189;
                    break;
                }
                case 247: {
                    n5 = 242;
                    break;
                }
                case 248: {
                    n5 = 254;
                    break;
                }
                case 249: {
                    n5 = 166;
                    break;
                }
                case 250: {
                    n5 = 101;
                    break;
                }
                case 251: {
                    n5 = 144;
                    break;
                }
                case 252: {
                    n5 = 218;
                    break;
                }
                case 253: {
                    n5 = 135;
                    break;
                }
                case 254: {
                    n5 = 20;
                    break;
                }
                default: {
                    n5 = 56;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            SmartCard.c[n3] = new String(cArray).intern();
        }
        return c[n3];
    }
}

