/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.dataStructures;

import tubitak.akis.cif.akisExceptions.AkisRuntimeException;
import tubitak.akis.cif.dataStructures.ARR;
import tubitak.akis.cif.dataStructures.KeyType;

public class SDOHeader {
    public byte keyID;
    public byte[] name;
    public int maxTryCount;
    public int remTryCount;
    public int maxUsageCount;
    public int remUsageCount;
    public int nonRepFlag;
    public int len;
    public ARR access;
    public byte[] berTLVInfo;
    public byte[] info;

    public SDOHeader() {
        this.keyID = 0;
        this.name = null;
        this.maxTryCount = 0;
        this.remTryCount = 0;
        this.maxUsageCount = 0;
        this.remUsageCount = 0;
        this.nonRepFlag = -1;
        this.len = -1;
        this.access = null;
        this.berTLVInfo = null;
        this.info = null;
    }

    public SDOHeader(byte id, byte[] name, int maxTryCount, int maxUsageCount, int nonRepFlag, int len, ARR access, byte[] berTLVInfo, byte[] info) {
        this.keyID = id;
        this.name = name;
        this.maxTryCount = maxTryCount;
        this.maxUsageCount = maxUsageCount;
        this.nonRepFlag = nonRepFlag;
        this.len = len;
        this.access = access;
        this.berTLVInfo = berTLVInfo;
        this.info = info;
    }

    public void CreateHeaderFromSDO(byte[] sdo) {
        KeyType keyType;
        int i = 5;
        if (sdo[1] == -118) {
            keyType = KeyType.SYMMETRIC;
        } else if (sdo[1] == -118) {
            keyType = KeyType.SYMMETRIC_AES;
        } else if (sdo[1] == -117) {
            keyType = KeyType.SYMMETRIC_3DES;
        } else if (sdo[1] == -112) {
            keyType = KeyType.PRIVATE_RSA;
        } else if (sdo[1] == -96) {
            keyType = KeyType.PUBLIC_RSA;
        } else if (sdo[1] == -127) {
            keyType = KeyType.PIN;
        } else if (sdo[1] == -111) {
            keyType = KeyType.PRIVATE_ECC;
        } else {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (sdo[4] != -96) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        this.keyID = sdo[2];
        i = 6;
        while (i < sdo.length) {
            switch (sdo[i]) {
                case -124: {
                    this.name = new byte[sdo[i + 1]];
                    System.arraycopy(sdo, i + 2, this.name, 0, sdo[i + 1]);
                    break;
                }
                case -102: {
                    if (keyType != KeyType.SYMMETRIC && keyType != KeyType.SYMMETRIC_3DES && keyType != KeyType.SYMMETRIC_AES && keyType != KeyType.PIN) break;
                    this.maxTryCount = sdo[i + 2];
                    break;
                }
                case -101: {
                    if (keyType != KeyType.SYMMETRIC && keyType != KeyType.SYMMETRIC_3DES && keyType != KeyType.SYMMETRIC_AES && keyType != KeyType.PIN) break;
                    this.remTryCount = sdo[i + 2];
                    break;
                }
                case -100: {
                    this.maxUsageCount = sdo[i + 2] * 256 + sdo[i + 3];
                    break;
                }
                case -99: {
                    this.remUsageCount = sdo[i + 2] * 256 + sdo[i + 3];
                    break;
                }
                case -98: {
                    if (keyType != KeyType.PRIVATE_RSA && keyType != KeyType.PRIVATE_ECC) break;
                    this.nonRepFlag = sdo[i + 2];
                    break;
                }
                case -128: {
                    this.len = sdo[i + 2] * 256 + sdo[i + 3];
                    break;
                }
                case -95: {
                    byte[] temp = new byte[sdo[i + 1]];
                    System.arraycopy(sdo, i + 2, temp, 0, sdo[i + 1]);
                    this.access = new ARR(temp);
                    break;
                }
                case -91: {
                    this.berTLVInfo = new byte[sdo[i + 1]];
                    System.arraycopy(sdo, i + 2, this.berTLVInfo, 0, sdo[i + 1]);
                    break;
                }
                case -123: {
                    this.info = new byte[sdo[i + 1]];
                    System.arraycopy(sdo, i + 2, this.info, 0, sdo[i + 1]);
                    break;
                }
            }
            i = sdo[i + 1] + i + 2;
        }
    }
}

