/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.ocsp;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BigInteger;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1Type;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EBasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ECertID;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EResponseData;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ESingleResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtension;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtensions;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.SignUtil;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.AbstractConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.util.HashMultiMap;
import tr.gov.tubitak.uekae.esya.asn.ocsp.BasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.asn.ocsp.CertID;
import tr.gov.tubitak.uekae.esya.asn.ocsp.OCSPRequest;
import tr.gov.tubitak.uekae.esya.asn.ocsp.OCSPResponse;
import tr.gov.tubitak.uekae.esya.asn.ocsp.Request;
import tr.gov.tubitak.uekae.esya.asn.ocsp.TBSRequest;
import tr.gov.tubitak.uekae.esya.asn.ocsp.Version;
import tr.gov.tubitak.uekae.esya.asn.ocsp._SeqOfRequest;
import tr.gov.tubitak.uekae.esya.asn.ocsp._ocspValues;
import tr.gov.tubitak.uekae.esya.asn.x509.AlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.asn.x509.Extension;
import tr.gov.tubitak.uekae.esya.asn.x509.Extensions;

public class OCSPClient {
    protected static Logger logger;
    public static final int REASON_UNSPECIFIED = 0;
    public static final int REASON_KEY_COMPROMISE = 1;
    public static final int REASON_CA_COMPROMISE = 2;
    public static final int REASON_AFFILIATION_CHANGED = 3;
    public static final int REASON_SUPERSEDED = 4;
    public static final int REASON_CESSATION_OF_OPERATION = 5;
    public static final int REASON_CERTIFICATE_HOLD = 6;
    public static final int REASON_PRIVILEGE_WITHDRAWN = 9;
    public static final int REASON_AA_COMPROMISE = 10;
    public static final int STATUS_RESPONSE_HAS_INVALID_SIGNATURE = 1;
    public static final int STATUS_RESPONSE_CANT_BE_RECEIVED = 2;
    public static final int STATUS_RESPONCE_INVALID_NONCE = 3;
    private static final String a;
    private static final String b;
    private static final String c;
    private static final String d;
    private static final String e;
    public static final Asn1ObjectIdentifier NONCE_OID;
    private int f;
    protected HashMultiMap<BigInteger, ESingleResponse> singleResponses;
    protected ECertificate signingCertificate;
    protected EBasicOCSPResponse mBasicResponse;
    protected EOCSPResponse mOCSPResponce;
    private static final Logger g;
    private String h;
    private HttpURLConnection i;
    private URL j;
    private byte[] k;
    private int l;
    private boolean m;
    private boolean n;
    private boolean o;
    private boolean p;
    public static DigestAlg digestAlgForOcspRequest;
    public static int q;
    private static final String[] r;
    private static final String[] s;

    protected OCSPClient() {
        block6: {
            boolean bl;
            block8: {
                block7: {
                    this.h = null;
                    this.i = null;
                    this.j = null;
                    int n = q;
                    this.k = null;
                    this.l = 0;
                    this.m = true;
                    this.n = true;
                    this.o = true;
                    this.p = false;
                    this.singleResponses = new HashMultiMap();
                    try {
                        LV.getInstance().checkLD(LV.Urunler.ORTAK);
                    }
                    catch (LE lE) {
                        throw new ESYARuntimeException(OCSPClient.a(-9750, 11772) + lE.getMessage());
                    }
                    if (n == 0) break block6;
                    if (!AbstractConfigElement.b) break block7;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
            AbstractConfigElement.b = bl;
        }
    }

    public OCSPClient(String aConnectionAddress) throws ESYAException {
        this();
        try {
            this.j = new URL(aConnectionAddress);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ESYAException((Throwable)malformedURLException);
        }
        this.h = aConnectionAddress;
    }

    public void setCheckSignature(boolean aCheckSignature) {
        this.m = aCheckSignature;
    }

    public void setCheckNonce(boolean aCheckNonce) {
        this.n = aCheckNonce;
    }

    public void setCheckResponseStatus(boolean aCheckResponseStatus) {
        this.o = aCheckResponseStatus;
    }

    public void setCheckDate(boolean aCheckDate) {
        this.p = aCheckDate;
    }

    public void openConnection() throws ESYAException {
        this.openConnection(null);
    }

    public void closeConnection() throws ESYAException {
        this.i.disconnect();
    }

    public void openConnection(String aTimeOut) throws ESYAException {
        int n = q;
        try {
            this.i = (HttpURLConnection)this.j.openConnection();
            if (aTimeOut != null) {
                this.i.setConnectTimeout(Integer.parseInt(aTimeOut));
                this.i.setReadTimeout(Integer.parseInt(aTimeOut));
            }
            this.i.setRequestProperty(OCSPClient.a(-9767, -13490), OCSPClient.a(-9771, 18284));
            this.i.setRequestProperty(OCSPClient.a(-9843, -10864), OCSPClient.a(-9769, -3435));
            this.i.setRequestMethod(OCSPClient.a(-9772, 9592));
            this.i.setDoOutput(true);
            this.i.setUseCaches(false);
            this.i.connect();
        }
        catch (IOException iOException) {
            g.error(OCSPClient.a(-9759, -15387) + this.h, (Throwable)iOException);
            throw new ESYAException(OCSPClient.a(-9740, -11370) + this.h, (Throwable)iOException);
        }
        if (AbstractConfigElement.b) {
            q = ++n;
        }
    }

    public Calendar getProducedAt() {
        return this.mBasicResponse.getProducedAt();
    }

    public void queryCertificate(ECertificate aCertificateToQuery, ECertificate aIssuerCertificate) throws ESYAException {
        this.queryCertificate(new ECertificate[]{aCertificateToQuery}, new ECertificate[]{aIssuerCertificate});
    }

    public EOCSPResponse queryCertificate(ECertificate[] aCertificatesToQuery, ECertificate[] aIssuerCertificates) throws ESYAException {
        if (this.i == null) {
            g.error(OCSPClient.a(-9766, -4823));
            throw new ESYAException(OCSPClient.a(-9845, 949));
        }
        byte[] byArray = this.a(aCertificatesToQuery, aIssuerCertificates);
        this.a(byArray);
        g.debug(OCSPClient.a(-9783, 3394));
        return this.mOCSPResponce;
    }

    public EOCSPResponse queryCertificate(BigInteger aSertifikaSeriNo, byte[] aSMSubjectHashDegeri, byte[] aSMAcikAnahtarHashDegeri) throws ESYAException {
        if (this.i == null) {
            g.error(OCSPClient.a(-9758, 8949));
            throw new ESYAException(OCSPClient.a(-9788, 15874));
        }
        byte[] byArray = this.a(aSertifikaSeriNo, aSMSubjectHashDegeri, aSMAcikAnahtarHashDegeri);
        this.a(byArray);
        g.debug(OCSPClient.a(-9777, -13683));
        return this.mOCSPResponce;
    }

    public int getStatus() {
        return this.l;
    }

    private EOCSPResponse a(byte[] byArray) throws ESYAException {
        block10: {
            block11: {
                int n = q;
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(this.i.getOutputStream());
                    dataOutputStream.write(byArray);
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    g.error(OCSPClient.a(-9764, -3757), (Throwable)iOException);
                    throw new ESYAException(OCSPClient.a(-9744, -25921), (Throwable)iOException);
                }
                try {
                    g.debug(OCSPClient.a(-9791, 13531));
                    this.mOCSPResponce = this.b();
                    g.debug(OCSPClient.a(-9763, 10757));
                }
                catch (Exception exception) {
                    this.l = 2;
                    g.error(OCSPClient.a(-9747, -13784), (Throwable)exception);
                    throw new ESYAException(OCSPClient.a(-9786, -9850), (Throwable)exception);
                }
                if (!this.o) break block10;
                if (!this.checkResponseStatus()) break block11;
                this.a(this.mOCSPResponce);
                if (n == 0) break block10;
            }
            this.mOCSPResponce = null;
            g.error(OCSPClient.a(-9738, -30282));
            throw new ESYAException(OCSPClient.a(-9736, 2917));
        }
        return this.mOCSPResponce;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(ECertificate[] eCertificateArray, ECertificate[] eCertificateArray2) throws ESYAException {
        g.debug(OCSPClient.a(-9781, -8817));
        int n = q;
        if (eCertificateArray == null || eCertificateArray.length == 0) {
            g.error(OCSPClient.a(-9785, 30451));
            throw new ESYAException(OCSPClient.a(-9749, -27981));
        }
        int n2 = eCertificateArray.length;
        Request[] requestArray = new Request[n2];
        for (int i = 0; i < n2; ++i) {
            ECertificate eCertificate = eCertificateArray[i];
            ECertificate eCertificate2 = eCertificateArray2[i];
            try {
                requestArray[i] = this.a(eCertificate, eCertificate2);
                continue;
            }
            catch (Exception exception) {
                g.error(OCSPClient.a(-9737, -28561), (Throwable)exception);
                throw new ESYAException(OCSPClient.a(-9753, -9997), (Throwable)exception);
            }
        }
        return this.a(requestArray);
    }

    private byte[] a(BigInteger bigInteger, byte[] byArray, byte[] byArray2) throws ESYAException {
        Request[] requestArray = new Request[1];
        try {
            requestArray[0] = this.b(bigInteger, byArray, byArray2);
        }
        catch (Exception exception) {
            g.error(OCSPClient.a(-9760, -11770), (Throwable)exception);
            return null;
        }
        return this.a(requestArray);
    }

    private byte[] a(Request[] requestArray) throws ESYAException {
        Extension extension;
        OCSPRequest oCSPRequest = new OCSPRequest();
        TBSRequest tBSRequest = new TBSRequest();
        try {
            extension = this.a();
        }
        catch (Exception exception) {
            g.warn(OCSPClient.a(-9762, -18033), (Throwable)exception);
            throw new ESYAException(OCSPClient.a(-9841, 21070));
        }
        tBSRequest.requestList = new _SeqOfRequest(requestArray);
        tBSRequest.requestExtensions = new Extensions(new Extension[]{extension});
        tBSRequest.version = new Version(0L);
        oCSPRequest.tbsRequest = tBSRequest;
        Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
        try {
            oCSPRequest.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
        }
        catch (Exception exception) {
            g.error(OCSPClient.a(-9780, -17708), (Throwable)exception);
            throw new ESYAException(OCSPClient.a(-9751, 27073));
        }
        byte[] byArray = asn1DerEncodeBuffer.getMsgCopy();
        g.debug(OCSPClient.a(-9733, 12348));
        return byArray;
    }

    private Extension a() throws ESYAException {
        try {
            Extension extension = new Extension();
            extension.extnID = NONCE_OID;
            this.k = new byte[16];
            SecureRandom.getInstance(OCSPClient.a(-9754, -12)).nextBytes(this.k);
            Asn1OctetString asn1OctetString = new Asn1OctetString(this.k);
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            asn1OctetString.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
            extension.extnValue = new Asn1OctetString(asn1DerEncodeBuffer.getMsgCopy());
            return extension;
        }
        catch (Exception exception) {
            throw new ESYAException((Throwable)exception);
        }
    }

    private EOCSPResponse b() throws ESYAException {
        OCSPResponse oCSPResponse = new OCSPResponse();
        InputStream inputStream = null;
        try {
            inputStream = this.i.getInputStream();
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(inputStream);
            oCSPResponse.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
            g.debug(OCSPClient.a(-9732, 14875));
        }
        catch (IOException iOException) {
            g.error(OCSPClient.a(-9761, -20292), (Throwable)iOException);
            throw new ESYAException(OCSPClient.a(-9755, -18865), (Throwable)iOException);
        }
        catch (Exception exception) {
            g.error(OCSPClient.a(-9765, 17246), (Throwable)exception);
            throw new ESYAException(OCSPClient.a(-9784, 20680), (Throwable)exception);
        }
        return new EOCSPResponse(oCSPResponse);
    }

    private Request a(ECertificate eCertificate, ECertificate eCertificate2) throws Exception {
        BigInteger bigInteger = eCertificate.getSerialNumber();
        byte[] byArray = DigestUtil.digest((DigestAlg)digestAlgForOcspRequest, (byte[])eCertificate2.getSubject().getEncoded());
        byte[] byArray2 = DigestUtil.digest((DigestAlg)digestAlgForOcspRequest, (byte[])eCertificate2.getSubjectPublicKeyInfo().getSubjectPublicKey());
        return this.b(bigInteger, byArray, byArray2);
    }

    private Request b(BigInteger bigInteger, byte[] byArray, byte[] byArray2) throws ESYAException {
        CertID certID = new CertID();
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgForOcspRequest.getOID());
        Asn1OctetString asn1OctetString = new Asn1OctetString(byArray);
        Asn1OctetString asn1OctetString2 = new Asn1OctetString(byArray2);
        Asn1BigInteger asn1BigInteger = new Asn1BigInteger(bigInteger);
        certID.hashAlgorithm = algorithmIdentifier;
        certID.issuerNameHash = asn1OctetString;
        certID.issuerKeyHash = asn1OctetString2;
        certID.serialNumber = asn1BigInteger;
        return new Request(certID);
    }

    public int getResponseStatus() {
        return this.f;
    }

    public ESingleResponse getSingleResponse(ECertificate aCertificateToQuery, ECertificate aIssuerCertificate) throws ESYAException {
        List<ESingleResponse> list = this.singleResponses.get(aCertificateToQuery.getSerialNumber());
        int n = q;
        if (list == null) {
            throw new ESYAException(OCSPClient.a(-9789, 18070));
        }
        for (ESingleResponse eSingleResponse : list) {
            ECertID eCertID = eSingleResponse.getCertID();
            if (OCSPClient.isEqual(eCertID, aCertificateToQuery, aIssuerCertificate)) {
                return eSingleResponse;
            }
            if (n == 0) continue;
        }
        throw new ESYAException(OCSPClient.a(-9778, 20562));
    }

    public static boolean isEqual(ECertID certID, ECertificate aCertificateToQuery, ECertificate aIssuerCertificate) {
        block5: {
            if (certID.getSerialNumber().equals(aCertificateToQuery.getSerialNumber())) {
                try {
                    byte[] byArray = aIssuerCertificate.getSubject().getEncoded();
                    byte[] byArray2 = aIssuerCertificate.getSubjectPublicKeyInfo().getSubjectPublicKey();
                    DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)certID.getHashAlgorithm());
                    byte[] byArray3 = DigestUtil.digest((DigestAlg)digestAlg, (byte[])byArray);
                    byte[] byArray4 = DigestUtil.digest((DigestAlg)digestAlg, (byte[])byArray2);
                    if (!Arrays.equals(certID.getIssuerNameHash(), byArray3) || !Arrays.equals(certID.getIssuerKeyHash(), byArray4)) break block5;
                    return true;
                }
                catch (CryptoException cryptoException) {
                    logger.warn(OCSPClient.a(-9742, -20397), (Throwable)cryptoException);
                    return false;
                }
            }
        }
        return false;
    }

    public EBasicOCSPResponse getBasicResponse() {
        return this.mBasicResponse;
    }

    public EOCSPResponse getOCSPResponse() {
        return this.mOCSPResponce;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkResponseStatus() {
        int n;
        this.f = n = this.mOCSPResponce.getResponseStatus();
        g.debug(OCSPClient.a(-9782, 25577) + n);
        switch (n) {
            case 0: {
                g.debug(OCSPClient.a(-9768, 21008));
                return true;
            }
            case 1: {
                g.debug(OCSPClient.a(-9775, -19459));
                return false;
            }
            case 2: {
                g.debug(OCSPClient.a(-9756, -26530));
                return false;
            }
            case 3: {
                g.debug(OCSPClient.a(-9731, -17581));
                return false;
            }
            case 5: {
                g.debug(OCSPClient.a(-9730, 15365));
                return false;
            }
            case 6: {
                g.debug(OCSPClient.a(-9739, -21103));
                return false;
            }
        }
        return false;
    }

    public void checkResponse() throws ESYAException {
        this.a(this.mOCSPResponce);
    }

    private void a(EOCSPResponse eOCSPResponse) throws ESYAException {
        int n;
        block17: {
            block18: {
                block15: {
                    block16: {
                        n = q;
                        try {
                            this.mBasicResponse = eOCSPResponse.getBasicOCSPResponse();
                        }
                        catch (Exception exception) {
                            g.error(OCSPClient.a(-9784, 20680), (Throwable)exception);
                            throw new ESYAException(OCSPClient.a(-9784, 20680), (Throwable)exception);
                        }
                        if (!this.n) break block15;
                        if (this.checkNonce()) break block16;
                        this.mOCSPResponce = null;
                        this.l = 3;
                        g.error(OCSPClient.a(-9757, 1734));
                        throw new ESYAException(OCSPClient.a(-9848, 10825));
                    }
                    g.debug(OCSPClient.a(-9842, 24281));
                }
                if (!this.m) break block17;
                if (this.checkSignature()) break block18;
                this.mOCSPResponce = null;
                this.l = 1;
                g.error(OCSPClient.a(-9743, 18921));
                throw new ESYAException(OCSPClient.a(-9792, -12403));
            }
            g.debug(OCSPClient.a(-9734, -20466));
        }
        EResponseData eResponseData = this.mBasicResponse.getTbsResponseData();
        int n2 = eResponseData.getSingleResponseCount();
        for (int i = 0; i < n2; ++i) {
            ESingleResponse eSingleResponse = eResponseData.getSingleResponse(i);
            if (this.p) {
                Calendar calendar = Calendar.getInstance();
                if (!this.checkDate(eSingleResponse, calendar)) {
                    g.error(OCSPClient.a(-9773, 28938));
                    throw new ESYAException(OCSPClient.a(-9735, -9442));
                }
            }
            this.singleResponses.put(eSingleResponse.getCertID().getSerialNumber(), eSingleResponse);
            if (n == 0) continue;
        }
    }

    public boolean checkDate(ESingleResponse aResponse, Calendar aDate) {
        block7: {
            if (aDate.before(aResponse.getThisUpdate())) {
                g.warn(OCSPClient.a(-9774, -4165));
                return false;
            }
            if (aResponse.getNextUpdate() == null || !aDate.after(aResponse.getNextUpdate())) break block7;
            g.warn(OCSPClient.a(-9847, 9806));
            return false;
        }
        return true;
    }

    public byte[] getNonce() {
        return this.k;
    }

    public boolean checkNonce() {
        EExtensions eExtensions = this.mBasicResponse.getResponseExtensions();
        int n = q;
        if (eExtensions == null) {
            g.error(OCSPClient.a(-9741, -23339));
            return false;
        }
        for (int i = 0; i < eExtensions.getExtensionCount(); ++i) {
            EExtension eExtension = eExtensions.getExtension(i);
            if (!eExtension.getIdentifier().equals((Asn1Type)NONCE_OID)) continue;
            byte[] byArray = eExtension.getValue();
            Asn1OctetString asn1OctetString = new Asn1OctetString();
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(byArray);
            try {
                asn1OctetString.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
            }
            catch (Exception exception) {
                g.error(OCSPClient.a(-9790, 27277), (Throwable)exception);
                return false;
            }
            if (Arrays.equals(asn1OctetString.value, this.k)) {
                return true;
            }
            return false;
        }
        g.error(OCSPClient.a(-9752, -10324));
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkSignature() {
        byte[] byArray = null;
        byArray = this.mBasicResponse.getTbsResponseData().getEncoded();
        int n = q;
        byte[] byArray2 = this.mBasicResponse.getSignature();
        if (this.mBasicResponse.getObject() == null || ((BasicOCSPResponse)this.mBasicResponse.getObject()).certs == null) {
            g.error(OCSPClient.a(-9748, 17126));
            return false;
        }
        for (int i = 0; i < this.mBasicResponse.getCertificateCount(); ++i) {
            ECertificate eCertificate = this.mBasicResponse.getCertificate(i);
            try {
                Pair pair = SignatureAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)this.mBasicResponse.getSignatureAlgorithm());
                PublicKey publicKey = KeyUtil.decodePublicKey((ESubjectPublicKeyInfo)eCertificate.getSubjectPublicKeyInfo());
                if (SignUtil.verify((SignatureAlg)((SignatureAlg)pair.first()), (AlgorithmParams)((AlgorithmParams)pair.second()), (byte[])byArray, (byte[])byArray2, (PublicKey)publicKey)) {
                    return true;
                }
                byte[] byArray3 = new byte[byArray2.length];
                int n2 = byArray2.length - 1;
                for (int j = 0; j < byArray2.length; ++j) {
                    byArray3[j] = byArray2[n2 - j];
                    if (n == 0) continue;
                }
                if (!SignUtil.verify((SignatureAlg)((SignatureAlg)pair.first()), (AlgorithmParams)((AlgorithmParams)pair.second()), (byte[])byArray, (byte[])byArray3, (PublicKey)publicKey)) continue;
                return true;
            }
            catch (CryptoException cryptoException) {
                g.error(OCSPClient.a(-9776, 25990), (Throwable)cryptoException);
                return false;
            }
        }
        g.debug(OCSPClient.a(-9745, -13607));
        return false;
    }

    public ECertificate getSigningCertificate() throws ESYAException {
        if (this.mBasicResponse == null) {
            throw new ESYAException(OCSPClient.a(-9787, 2129));
        }
        if (this.signingCertificate != null) {
            return this.signingCertificate;
        }
        if (this.checkSignature()) {
            return this.signingCertificate;
        }
        return null;
    }

    public void setDigestAlgForOcspRequest(DigestAlg digestAlg) {
        digestAlgForOcspRequest = digestAlg;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[71];
                var3_1 = 0;
                var2_2 = "e\u0016Q\u000b\u0003\u00ab\u00bd\u00be(\u009e\u0094\u000f,\u0014`\u00cfH\u000fd\u00d6\u00f9\u0093\u0016\u00a4F\u008b\u001b\u009c%\u000f\u009c%\u00853g\u00f8<\u00a8\u00c6\u001b\u0016\u00b5CW?\u00ecr\u00b8\u001a\n!\\\u0083\"\u0082\u00ae\t#&?\u0089\u00a3\u00c7\u0000\u00ceT\u00a0\u00df\u00ba\u00f9c\u00a8\u00e8\u009d\u00e0\u01fd\u00df'\u01e7\u00e4\u00b6\u0013(\u00b4\u001ea\u00aa\u00b0\u00cc\u0088\u00f9f\u01cd<\u0015I\u00efm\u000b\u00db@q\u0080\u00e4?\u0082\u007f\r\u0007\u00db\u00d5\u00b5\u00bc\u009b\u00bc\u00e1\u0004\u001d\u00f4-6\u0007\u0010\u00f2\u00de\u00b0u\u0005r\u00c9\u00d0\u00f9\u00bb9\u00a2\u0006lL`*\u00ce\u00d2\u009cd\u008a\u00ee\u00d5s\u00ab\u00b7B\u00d7\u0001\u0003#na\u0080h\u00e6y\u00ea{$:*Eq?\u00aao\u00a8\u01a3\u00d6\u00ec\u01c6\u009d\u0092<\u00acQ\u008e\u00dd\u00b8'\u008ez\u00b18\u01c4.S\u0081't\u0012\u00e9c\u0001\u00f5P\u00ec\u00f6\u0082\r\u00bd\u00e7+\u00c4\u00aa\u0087\u00be\u0013\u008d=F\u00e4\u00d6\\\u001b\u0097H\u00e2\u00bfj~\u00c3\u00bb\u00d1d\u000f\u00f0\u00c9\u00ac\u009a\u0082\u0004\u0019L\u00c0\u00c4\\n\u00e6\u00fa\u00a9\u0016\u0168]>\u00de\u00efi\u0172:\u00b0 \u00e64#5\u00f0\u00fd\u0013\u00ac\u00a2\u00ee\u00c7\u00bdO\u0017\u00ed\u00aa\u00ad\u00a27\u0007\u00d6\u00d9e\u00bb\u001ay\u0010\u0016\u00ba\u00dd\u0085\u0013\u001f}\u009b\u0092\u008a\"\u0007h\u0090\u00b9\u00e56| |\u00865\u0012\u00eb\u00c6iF,l\u00b4\b\u009a\u00d7QI\u00e9\u00d3q\u00b9r\u00da;\u00ff\u00ff\u00b0\u0000f\u00d7LL\u001dA\u00fa6\u00a2\u01c8\u009a\u00da\u00bc'\u0134\u0086\u00c5n\u0092\u0003G\u00e7\u00d0o\u0189\u001e\u00c54LO\u00b7\"\u00c6\u00a3m\u008c2\u00fa9\u00bd\u00ce\u00e2\u0088\u0016\u00bf\u00f3*n\u00e8X\u00e3\u00c1\u0004l\u008e\u0081\u001e\u008a\u0085\u001c\u00f4u\u00e9\u008f\u0017\u007f\u0003\u001a\"@\u00a2 \u00a5\u00fd\u00f2\u00f8\u00c8\u0012C;\u01ac\u00d7\fj\u00cd\u00ac\u01f4\u000e\u00b8\u00b3\u00f2\u00e1y\u000fP\u00ec\u0147\u00aa\u00a1zFK)&2\u0089\u0002\u00c7'\u00d9\u00d8\u00a2k\u0006\u0091\u00df\u00e1\u0016z^w\t\u00f9\u007f\u00db\u00cb\u00e5\r;\t\u00d6\u00f1\u00bb\u00f8\u0089\u00f1*\u012f,\u0012\u01412\u01e1\u007f<\u00adG\u00f8\u00ac\u00e9\u00e3\u001cv\u000b\u0004N\u009eQ\u008e\u00c2\u00abm\u00bb\u00abZ^\u00d9X\u001a\u007f\u00cdG\u001b>q\u001b\u00c0\u00cd\u000be\b2\u00c1\u00e7>)\u00e6\u001dPN\u00a9\u000b\u00a2$j\u009d/7K\u00f7\u00b0\u00c97p\u001f3&\u009f\u0089\u00b7\u00c7\u0091\u00d9\u000e\u00a2\u00a3\u0117\u0095\u00c2\u00110f\u009e5\u00f4\u007f\u00b5Cf\u0016\u00dc\u0081\u0099\u00edd\u0018\u008e\u00f6L\u00aaK\u00d7\u0019\u00c9\u00ba\u00bd\u00ee\u001f4\u0092\u009e\u00e9\u001d\u00efo\u001c|\f\u00ddH^\u009e\u00ec\u00e0\u00e2\u0011\u0111\u0015n\u01df\u001f\u0142\u00f1\u00b2y(\u0098\u0004\u0084Tds\u00f9\u0090\u000fzC\u00d8\u000e\u009cv8\u00ce'M\u0001d6\u001b\u013d\u00fd\u00de'\u00f7\u00b1\u00b3r\u0080)1\u0019\u00bfS\u00a5\u0096\u00ab\u0001\u0098f\u008f\u00ba3\u008a#\\q\u00a0>\u00a2\u00f1\u00dd\u00b0\u00cf\u00bf\u00ea\u00c2!p\u0096\u00ad\u00c5\u00e2\u001e\u0007\u0006\u00b1\u001e\u001f\u00b2/OiC\u0086=D\u00b5\u00e7%\u0088\u00d3\t\u019a\u00ee\u00d7d\u00ec\u00e3\u00c8\u00aeU4\u01e7\fT\u00a1w\u00fd\u00c7u%e;\u00e5\u00f6`\u000e\r?Dp\u00af=\u0089\u00a7\u0171`\u00d7\u019f\u00f4\u01b5.\\\u0019\u00c6g.\u008b\u00e4M\u0005\u00d9\u00f2\u00c7A+\u00c5#$\\K\u0094\u0082q\nq\u00b6m\u00c8m\u00d8\u00b10&\u00b0\u00f2\u009f\u00d0\u0087\u00b3\u00e3C\u0000@\u00b2\u00abA\"\u001c\u00fe\u00da,\u00db3\u00ef\u00ae\u00a4\u00cbi\u0177\u00e3-\u0093\u00d9\u01d1Yy\u0095\u0005|\u00b5\b\u008e\u0093\u0142\u01b3\u0011\u0018\u00eb\u00f7\u00f8\u00d3\u00e7\u00a6\u00b9\u00ea\"pQL\u00b8@\u00a3F\u00fc\u00fb\u009dlo\u00f2t[\u0003\u0098#P\u0011O\u00ac\u00e5\u00064\u00d7D\u00d8L\u00d8\u00af\u00ed\u00e3\u009f\u00bd\u00e8\u00b2\u0018\r\u00ba$z|\u0093\u00caLL\u00a4\u009c\u00d6\u0001\u0013\u0094,\u001a\u00b6A\u00c5\u00f4\u00c7\u0007\u00fd\u001e2\u0088\u00a3\u0086S\u00e3\u0007i\u00ad\u001b\u00b2\u0005\u00e9\u00fdh\u00cb\u0019mB+\u00c7ym\f\u001f\u0007\u0001\u00ba\u00cd\u00db\u001e\u0098\u00cb\u00b1\u00e7\u00cc\u008b\u00b2\u01c3\u0097I\u009d|b\u0193\u00d8?\u00fa\u00b0Y\u0083\u000e$\u00dc\u00e6\u0086{y\u01b1\u00c5\u00c6/\u0013\u00e2/\u0018\u0013dC\u00b0\u00f1fl:\u0092K\u00bb1jL/\u00fa\u000f~\u00a22\u00e3\u008dv\u00f9\u008b\u009di\u0090\u00ed\u0007\u00b5SVG\u00a5y+De\u00a88\u00bc\u019443=+\u00e3\u0093\u001bS_\u00f3\u009b,\u0096\u0097!\u00a1\u0004\u00e1$\u00ccF\u00d1W\u00a6\u0013\u011c!S\u00e43\u01b6\u00930\u00bd\u00f1TV\u009dL\u00c9>K\t\u0005\u00d2\u009e\b\u00ec\u0014\u008e7\"L*\u00ce\u00ea\u0094\u0019dT\u00ad\u00a0;\u00f5\u0092\u00fcQy\u0002\u00de\u00b9\u009dp%\u0003\u00fe\u0019\u011b\u0093\u01aa\u00fdI\u00a3p%\u00fa\u000e\u0010\u008d\u009d\u00a2C\u009c\u0139b\u0086\u001f\u00be\u00a0u\u008a\u0018#\u00fb\u0005{5\u007f~\u00f0\u00c0\u00e6|\u00f8\u009d1\u00c8`sl\u0094\u001c\u00f2g\u00f0\u0085\u008b,0\u00cd\u008e\u001bO\u0099\u009e\u0012\u0161\u00df\u001ad\u00b0\u00de;8p\u00cdm2\u009cg\u009d`^\u00af\tjd.\u0099\u00be!M\u001e\u000e\u00cd\u007f\u00f1.\u0081!\u00dfM\u0004=\u001b\u0134\u00ef\u0011A\u00fe$L\f\u009eC\u00f1\u00ac\u00fd\u00b3I`\u000b\u00cdz\u00bc\u0018\u00cd7;p8LR\u0089\u001a\u00e3\u00abp\u00b3/=z^\u0095\u0088=\u00d9\u00aa\"s-\u00db^6\u008f0\u0096'\u00ee}\u00bf\u01ec\u0016\u00bda\u00dfhc\u00f4KGBD\u0098\u00f6\u0003\u009dbn\u001bha\u00f8\u00b1k\u00f4\u00e9\u00fe\u00c7N\u0098-\u00bd\u00cc\"\u015d\u0017P\u0018\u0015\u00dd\f\u0098\\\u0003&\u00f52tc\u00c6\u00f3T\u008do\u00ad\u00e2\u00ef\u00b0|\u001b1\u0015(\u00b8\u0099w\u00d0\u00dd`k\u00c5SsZ\u00dc\u00bb\u009a\r\u00e1\u00d33\u001b\u0018\u00f6[[ 'v\u00c5\u0083\u00fc\u0086\u00f8\u00f1#\u00a7\u0014\u00a6~\u00cb\u001c\u0094\u00c5\u000e\u00ce\u0003\u0004%\u008d\u00b1\u009a&\u00e5\u00f25\u00d0\u00d2\u00b3ICU@\u0018\u00ab\u0014\"\u001b\u00d8r\u00fe\u00d9\u00f8\br\u0014\u0003\u00b4g\u00f0SC;\u0013\u00ef\u009b\u009a\u008an\u00db\u00f4P>\u00b6\u00d7\u0018\u008d:3\u00d19xr\u000f\u001e3+j\u00a3l?\u0012\u001e\u0098\u0080\u009c\u00d8\u009e\u0002\u00f5\b;a\u00a7c\"w0\u00f4' \u00a4I\u00d0\u00dfm\u00da\u0087\u00d5\u0011Oe\u00ab\u00e3u\u017c7-\u0086\u0187\u007f\u0193M\u00b6\u00cfQN\u0081\u00c9\u0010\u00ad\u00e7x\u00ea\u0098\u01a6\u008d\u00adN\u0014\u01fe'%\u00a3\u00da\u00c3Ru\u008c\u01a8\u0001;\u00f6\u00a9\u00cb\u00beM\u00c4\u00e2\u01ba*\u001c\u0006\u00ce\u0084/\u00f7\u00c4\u00c2\u0001(r\u00f9Q\u00ec\u00c7\u00dbdCI}\u0084\u000bg\u00f6qz\u0018\u00d9\u0097\u009f\u001a\u00b2m\t\u0088\u0115\f\u00dc\u01c2;\u0120`\u001c\u00ac\u00e3f\u00fcz\u000b\u00878\u00ee\u00fa\u01d3\u0091\u00b9\u00ddK\u0118\u000b@\u00df\"5Q!\u0012\u00b6\u01d1\u0117c\u0016\u00f2\u001a\u00bb\u00d4P\u00a9g \u00a123 \u00d9YwL\u00d5\u00c6b7\u0004+#=@\u00eaL\u00ab\u00e0T\u00ea\u0013\u0092y\u00baWr\u00f2S\u0089q\u009bX$\u008f\u009c\b'H\u00d1\u008e\u00b7L\u000e\u0016\u00aa\u00bc\u00bd\n>\u0097\u00e5\u00a2\u00b7wy\u00a7\u00fb\u00f1\u0019Z\u00f3\u00ae\u00e9\u00f2\u000e3\u00d4+\u00acb\u00f3\u00f3#5\u0018d*\u008drm=5>\u00c1/\u0003\u00a4-\u00d0S}K\u0093\u00f0\u0002L\u00b6\u0096\u00da;\u0003z\n-2Og\u00aa\u0011\u00e2\u00e9Vu\u008f\f\u00e9\u00a2\u00fdA\u00b7\u009b\u0016^\u00adZ* E$<-\u0114\u001c\u00aee\u0006*]\u000b*\u00e2[^\u0004XPS\u00c6\u00a0\u0014|\t\u00a2\n\u00c6\u00d2\u00ec \u00a6~1!\u00bb\u00f5:\u00fa\u00b12\u00013i\u013b\u00b2T.\u00af\u01f1\u00e8@\u015e\u00a2\u00ee\u0003Ys\u00db\u00a6\u012a%\u00e4i\u0003\u00c5\u00e0\u00c3(a\u0099aw\u00da\u0089z\r\u00d6\u00d1\u0088\u00c6\u000e\u000b,'\u0019\u00dc\u00e1\u008cbuh0y\u0081\u0087\u0081 Q\u00c2\u00d4\u00b6\u0081\u01c7Y\u000f\u01ef\u008e\u0134\u001a&z!\u00d8\u0003(\r\u0010\u00ec4\u009a\u00e0\u00ecA\u00d0S\u0018\u0083\u00d5\u009dO\u00e13\u00c2x\u00e6\u001b\u00ad\u00b2\u00f8\u0012\u00e95\u001c\u008c\rpTI\u00c8f\u0019\u01cc\u00ba;7\u0145I\u009b\u0094\u00e7\t\u016f\u00ad\u0014\u01da\u00ee\u00a1\u009aJ\u00e4@\u0091\u00ce\u0134I\u00a8\u00ff\u00db\u00ea\u00f0i\rf\u0183\u0014\u009b\u00d4\u0096\r\u00f5\u0092\u00c2R\u0118\u00de\u00fa\u0148Q\u014f\u00ae\u00ab,\u01bd\u00cay)\u009ed\u009e\u00c8%~\u0085\u00f3)\u000ew=\u00f1t\u00d3\u00c8\u00e6!\u001e3\u009d\u0082\u0097\u00ce\u0086^xz\u00df.=;I|\u0138\u00e6\u00f0\u0118n\u01ca\u00f4\u001f\u01c68\"@:\u00bfF`\u001c\u00f8zj\u00b1}^\r\\\u00c7\fO*\u00e9e\u00a9I\u00f8?\u0088\u011c\u008f\u00fa'\u00a3*9\u0001\u00d1G\u001b\u00d4\u00fa\u00f8\u011c\u00fe\u00a3|\u001c\u00cb\u001b\u0080D\u00e2\u00b4\u00a4\u00b5\u00b832J\f\u00aeq<S\u00c6\u00bb\u0002\u00fc]\u0083\u01e8\u0015\u00c3\u000e\u000f\u00dd[((\u00c3\u00d6\u008a\u0081R\t\u00df\u001f\u00b0mk\u00c6\u0019\u0005\n_\u00e2\u00c9\f2\u00a2\u00c9\u001d\u00ed\u00a6\u0003\u008f\u00b0\u00b2\"v\r\u009f\u007f\u00da\u009e\u0097\u00ca~\u00f3d+\u0018wl}\u00f5\u00d50\u008e\u00b1w\u009f\u0017\u00c2\u00a3G\u00f1\u0001\u00de0\u00ac\u00c1U)^\u007f\u0086\u00ab&\u0012\u00e5~%\u00bf\u00f6\u000b\u00c1\u00b2\u00d5\u0010&:\u0001R\u008d\u00eeFJU\u00ed\u009c+\u0007\u00c1\by/p\u00c0\u013a\u00059\u01e3\u0098\u01043\u0083\u0001=dQ\u00eb\u000bA\u00f8XM\u00f4\u00b6%.\u00b7\u00f7R\u000e\u0088\u0089\u008e\u00ad(\u017dF\u007f\b\u00b6\u012b#\u0083\u00ab\u0087\u0096\u0098\u00c5\u0095\u00c2\u0005*n)>\u001b\u0095\u00d9\u00a6\u0010W\u0012";
                var4_3 = "e\u0016Q\u000b\u0003\u00ab\u00bd\u00be(\u009e\u0094\u000f,\u0014`\u00cfH\u000fd\u00d6\u00f9\u0093\u0016\u00a4F\u008b\u001b\u009c%\u000f\u009c%\u00853g\u00f8<\u00a8\u00c6\u001b\u0016\u00b5CW?\u00ecr\u00b8\u001a\n!\\\u0083\"\u0082\u00ae\t#&?\u0089\u00a3\u00c7\u0000\u00ceT\u00a0\u00df\u00ba\u00f9c\u00a8\u00e8\u009d\u00e0\u01fd\u00df'\u01e7\u00e4\u00b6\u0013(\u00b4\u001ea\u00aa\u00b0\u00cc\u0088\u00f9f\u01cd<\u0015I\u00efm\u000b\u00db@q\u0080\u00e4?\u0082\u007f\r\u0007\u00db\u00d5\u00b5\u00bc\u009b\u00bc\u00e1\u0004\u001d\u00f4-6\u0007\u0010\u00f2\u00de\u00b0u\u0005r\u00c9\u00d0\u00f9\u00bb9\u00a2\u0006lL`*\u00ce\u00d2\u009cd\u008a\u00ee\u00d5s\u00ab\u00b7B\u00d7\u0001\u0003#na\u0080h\u00e6y\u00ea{$:*Eq?\u00aao\u00a8\u01a3\u00d6\u00ec\u01c6\u009d\u0092<\u00acQ\u008e\u00dd\u00b8'\u008ez\u00b18\u01c4.S\u0081't\u0012\u00e9c\u0001\u00f5P\u00ec\u00f6\u0082\r\u00bd\u00e7+\u00c4\u00aa\u0087\u00be\u0013\u008d=F\u00e4\u00d6\\\u001b\u0097H\u00e2\u00bfj~\u00c3\u00bb\u00d1d\u000f\u00f0\u00c9\u00ac\u009a\u0082\u0004\u0019L\u00c0\u00c4\\n\u00e6\u00fa\u00a9\u0016\u0168]>\u00de\u00efi\u0172:\u00b0 \u00e64#5\u00f0\u00fd\u0013\u00ac\u00a2\u00ee\u00c7\u00bdO\u0017\u00ed\u00aa\u00ad\u00a27\u0007\u00d6\u00d9e\u00bb\u001ay\u0010\u0016\u00ba\u00dd\u0085\u0013\u001f}\u009b\u0092\u008a\"\u0007h\u0090\u00b9\u00e56| |\u00865\u0012\u00eb\u00c6iF,l\u00b4\b\u009a\u00d7QI\u00e9\u00d3q\u00b9r\u00da;\u00ff\u00ff\u00b0\u0000f\u00d7LL\u001dA\u00fa6\u00a2\u01c8\u009a\u00da\u00bc'\u0134\u0086\u00c5n\u0092\u0003G\u00e7\u00d0o\u0189\u001e\u00c54LO\u00b7\"\u00c6\u00a3m\u008c2\u00fa9\u00bd\u00ce\u00e2\u0088\u0016\u00bf\u00f3*n\u00e8X\u00e3\u00c1\u0004l\u008e\u0081\u001e\u008a\u0085\u001c\u00f4u\u00e9\u008f\u0017\u007f\u0003\u001a\"@\u00a2 \u00a5\u00fd\u00f2\u00f8\u00c8\u0012C;\u01ac\u00d7\fj\u00cd\u00ac\u01f4\u000e\u00b8\u00b3\u00f2\u00e1y\u000fP\u00ec\u0147\u00aa\u00a1zFK)&2\u0089\u0002\u00c7'\u00d9\u00d8\u00a2k\u0006\u0091\u00df\u00e1\u0016z^w\t\u00f9\u007f\u00db\u00cb\u00e5\r;\t\u00d6\u00f1\u00bb\u00f8\u0089\u00f1*\u012f,\u0012\u01412\u01e1\u007f<\u00adG\u00f8\u00ac\u00e9\u00e3\u001cv\u000b\u0004N\u009eQ\u008e\u00c2\u00abm\u00bb\u00abZ^\u00d9X\u001a\u007f\u00cdG\u001b>q\u001b\u00c0\u00cd\u000be\b2\u00c1\u00e7>)\u00e6\u001dPN\u00a9\u000b\u00a2$j\u009d/7K\u00f7\u00b0\u00c97p\u001f3&\u009f\u0089\u00b7\u00c7\u0091\u00d9\u000e\u00a2\u00a3\u0117\u0095\u00c2\u00110f\u009e5\u00f4\u007f\u00b5Cf\u0016\u00dc\u0081\u0099\u00edd\u0018\u008e\u00f6L\u00aaK\u00d7\u0019\u00c9\u00ba\u00bd\u00ee\u001f4\u0092\u009e\u00e9\u001d\u00efo\u001c|\f\u00ddH^\u009e\u00ec\u00e0\u00e2\u0011\u0111\u0015n\u01df\u001f\u0142\u00f1\u00b2y(\u0098\u0004\u0084Tds\u00f9\u0090\u000fzC\u00d8\u000e\u009cv8\u00ce'M\u0001d6\u001b\u013d\u00fd\u00de'\u00f7\u00b1\u00b3r\u0080)1\u0019\u00bfS\u00a5\u0096\u00ab\u0001\u0098f\u008f\u00ba3\u008a#\\q\u00a0>\u00a2\u00f1\u00dd\u00b0\u00cf\u00bf\u00ea\u00c2!p\u0096\u00ad\u00c5\u00e2\u001e\u0007\u0006\u00b1\u001e\u001f\u00b2/OiC\u0086=D\u00b5\u00e7%\u0088\u00d3\t\u019a\u00ee\u00d7d\u00ec\u00e3\u00c8\u00aeU4\u01e7\fT\u00a1w\u00fd\u00c7u%e;\u00e5\u00f6`\u000e\r?Dp\u00af=\u0089\u00a7\u0171`\u00d7\u019f\u00f4\u01b5.\\\u0019\u00c6g.\u008b\u00e4M\u0005\u00d9\u00f2\u00c7A+\u00c5#$\\K\u0094\u0082q\nq\u00b6m\u00c8m\u00d8\u00b10&\u00b0\u00f2\u009f\u00d0\u0087\u00b3\u00e3C\u0000@\u00b2\u00abA\"\u001c\u00fe\u00da,\u00db3\u00ef\u00ae\u00a4\u00cbi\u0177\u00e3-\u0093\u00d9\u01d1Yy\u0095\u0005|\u00b5\b\u008e\u0093\u0142\u01b3\u0011\u0018\u00eb\u00f7\u00f8\u00d3\u00e7\u00a6\u00b9\u00ea\"pQL\u00b8@\u00a3F\u00fc\u00fb\u009dlo\u00f2t[\u0003\u0098#P\u0011O\u00ac\u00e5\u00064\u00d7D\u00d8L\u00d8\u00af\u00ed\u00e3\u009f\u00bd\u00e8\u00b2\u0018\r\u00ba$z|\u0093\u00caLL\u00a4\u009c\u00d6\u0001\u0013\u0094,\u001a\u00b6A\u00c5\u00f4\u00c7\u0007\u00fd\u001e2\u0088\u00a3\u0086S\u00e3\u0007i\u00ad\u001b\u00b2\u0005\u00e9\u00fdh\u00cb\u0019mB+\u00c7ym\f\u001f\u0007\u0001\u00ba\u00cd\u00db\u001e\u0098\u00cb\u00b1\u00e7\u00cc\u008b\u00b2\u01c3\u0097I\u009d|b\u0193\u00d8?\u00fa\u00b0Y\u0083\u000e$\u00dc\u00e6\u0086{y\u01b1\u00c5\u00c6/\u0013\u00e2/\u0018\u0013dC\u00b0\u00f1fl:\u0092K\u00bb1jL/\u00fa\u000f~\u00a22\u00e3\u008dv\u00f9\u008b\u009di\u0090\u00ed\u0007\u00b5SVG\u00a5y+De\u00a88\u00bc\u019443=+\u00e3\u0093\u001bS_\u00f3\u009b,\u0096\u0097!\u00a1\u0004\u00e1$\u00ccF\u00d1W\u00a6\u0013\u011c!S\u00e43\u01b6\u00930\u00bd\u00f1TV\u009dL\u00c9>K\t\u0005\u00d2\u009e\b\u00ec\u0014\u008e7\"L*\u00ce\u00ea\u0094\u0019dT\u00ad\u00a0;\u00f5\u0092\u00fcQy\u0002\u00de\u00b9\u009dp%\u0003\u00fe\u0019\u011b\u0093\u01aa\u00fdI\u00a3p%\u00fa\u000e\u0010\u008d\u009d\u00a2C\u009c\u0139b\u0086\u001f\u00be\u00a0u\u008a\u0018#\u00fb\u0005{5\u007f~\u00f0\u00c0\u00e6|\u00f8\u009d1\u00c8`sl\u0094\u001c\u00f2g\u00f0\u0085\u008b,0\u00cd\u008e\u001bO\u0099\u009e\u0012\u0161\u00df\u001ad\u00b0\u00de;8p\u00cdm2\u009cg\u009d`^\u00af\tjd.\u0099\u00be!M\u001e\u000e\u00cd\u007f\u00f1.\u0081!\u00dfM\u0004=\u001b\u0134\u00ef\u0011A\u00fe$L\f\u009eC\u00f1\u00ac\u00fd\u00b3I`\u000b\u00cdz\u00bc\u0018\u00cd7;p8LR\u0089\u001a\u00e3\u00abp\u00b3/=z^\u0095\u0088=\u00d9\u00aa\"s-\u00db^6\u008f0\u0096'\u00ee}\u00bf\u01ec\u0016\u00bda\u00dfhc\u00f4KGBD\u0098\u00f6\u0003\u009dbn\u001bha\u00f8\u00b1k\u00f4\u00e9\u00fe\u00c7N\u0098-\u00bd\u00cc\"\u015d\u0017P\u0018\u0015\u00dd\f\u0098\\\u0003&\u00f52tc\u00c6\u00f3T\u008do\u00ad\u00e2\u00ef\u00b0|\u001b1\u0015(\u00b8\u0099w\u00d0\u00dd`k\u00c5SsZ\u00dc\u00bb\u009a\r\u00e1\u00d33\u001b\u0018\u00f6[[ 'v\u00c5\u0083\u00fc\u0086\u00f8\u00f1#\u00a7\u0014\u00a6~\u00cb\u001c\u0094\u00c5\u000e\u00ce\u0003\u0004%\u008d\u00b1\u009a&\u00e5\u00f25\u00d0\u00d2\u00b3ICU@\u0018\u00ab\u0014\"\u001b\u00d8r\u00fe\u00d9\u00f8\br\u0014\u0003\u00b4g\u00f0SC;\u0013\u00ef\u009b\u009a\u008an\u00db\u00f4P>\u00b6\u00d7\u0018\u008d:3\u00d19xr\u000f\u001e3+j\u00a3l?\u0012\u001e\u0098\u0080\u009c\u00d8\u009e\u0002\u00f5\b;a\u00a7c\"w0\u00f4' \u00a4I\u00d0\u00dfm\u00da\u0087\u00d5\u0011Oe\u00ab\u00e3u\u017c7-\u0086\u0187\u007f\u0193M\u00b6\u00cfQN\u0081\u00c9\u0010\u00ad\u00e7x\u00ea\u0098\u01a6\u008d\u00adN\u0014\u01fe'%\u00a3\u00da\u00c3Ru\u008c\u01a8\u0001;\u00f6\u00a9\u00cb\u00beM\u00c4\u00e2\u01ba*\u001c\u0006\u00ce\u0084/\u00f7\u00c4\u00c2\u0001(r\u00f9Q\u00ec\u00c7\u00dbdCI}\u0084\u000bg\u00f6qz\u0018\u00d9\u0097\u009f\u001a\u00b2m\t\u0088\u0115\f\u00dc\u01c2;\u0120`\u001c\u00ac\u00e3f\u00fcz\u000b\u00878\u00ee\u00fa\u01d3\u0091\u00b9\u00ddK\u0118\u000b@\u00df\"5Q!\u0012\u00b6\u01d1\u0117c\u0016\u00f2\u001a\u00bb\u00d4P\u00a9g \u00a123 \u00d9YwL\u00d5\u00c6b7\u0004+#=@\u00eaL\u00ab\u00e0T\u00ea\u0013\u0092y\u00baWr\u00f2S\u0089q\u009bX$\u008f\u009c\b'H\u00d1\u008e\u00b7L\u000e\u0016\u00aa\u00bc\u00bd\n>\u0097\u00e5\u00a2\u00b7wy\u00a7\u00fb\u00f1\u0019Z\u00f3\u00ae\u00e9\u00f2\u000e3\u00d4+\u00acb\u00f3\u00f3#5\u0018d*\u008drm=5>\u00c1/\u0003\u00a4-\u00d0S}K\u0093\u00f0\u0002L\u00b6\u0096\u00da;\u0003z\n-2Og\u00aa\u0011\u00e2\u00e9Vu\u008f\f\u00e9\u00a2\u00fdA\u00b7\u009b\u0016^\u00adZ* E$<-\u0114\u001c\u00aee\u0006*]\u000b*\u00e2[^\u0004XPS\u00c6\u00a0\u0014|\t\u00a2\n\u00c6\u00d2\u00ec \u00a6~1!\u00bb\u00f5:\u00fa\u00b12\u00013i\u013b\u00b2T.\u00af\u01f1\u00e8@\u015e\u00a2\u00ee\u0003Ys\u00db\u00a6\u012a%\u00e4i\u0003\u00c5\u00e0\u00c3(a\u0099aw\u00da\u0089z\r\u00d6\u00d1\u0088\u00c6\u000e\u000b,'\u0019\u00dc\u00e1\u008cbuh0y\u0081\u0087\u0081 Q\u00c2\u00d4\u00b6\u0081\u01c7Y\u000f\u01ef\u008e\u0134\u001a&z!\u00d8\u0003(\r\u0010\u00ec4\u009a\u00e0\u00ecA\u00d0S\u0018\u0083\u00d5\u009dO\u00e13\u00c2x\u00e6\u001b\u00ad\u00b2\u00f8\u0012\u00e95\u001c\u008c\rpTI\u00c8f\u0019\u01cc\u00ba;7\u0145I\u009b\u0094\u00e7\t\u016f\u00ad\u0014\u01da\u00ee\u00a1\u009aJ\u00e4@\u0091\u00ce\u0134I\u00a8\u00ff\u00db\u00ea\u00f0i\rf\u0183\u0014\u009b\u00d4\u0096\r\u00f5\u0092\u00c2R\u0118\u00de\u00fa\u0148Q\u014f\u00ae\u00ab,\u01bd\u00cay)\u009ed\u009e\u00c8%~\u0085\u00f3)\u000ew=\u00f1t\u00d3\u00c8\u00e6!\u001e3\u009d\u0082\u0097\u00ce\u0086^xz\u00df.=;I|\u0138\u00e6\u00f0\u0118n\u01ca\u00f4\u001f\u01c68\"@:\u00bfF`\u001c\u00f8zj\u00b1}^\r\\\u00c7\fO*\u00e9e\u00a9I\u00f8?\u0088\u011c\u008f\u00fa'\u00a3*9\u0001\u00d1G\u001b\u00d4\u00fa\u00f8\u011c\u00fe\u00a3|\u001c\u00cb\u001b\u0080D\u00e2\u00b4\u00a4\u00b5\u00b832J\f\u00aeq<S\u00c6\u00bb\u0002\u00fc]\u0083\u01e8\u0015\u00c3\u000e\u000f\u00dd[((\u00c3\u00d6\u008a\u0081R\t\u00df\u001f\u00b0mk\u00c6\u0019\u0005\n_\u00e2\u00c9\f2\u00a2\u00c9\u001d\u00ed\u00a6\u0003\u008f\u00b0\u00b2\"v\r\u009f\u007f\u00da\u009e\u0097\u00ca~\u00f3d+\u0018wl}\u00f5\u00d50\u008e\u00b1w\u009f\u0017\u00c2\u00a3G\u00f1\u0001\u00de0\u00ac\u00c1U)^\u007f\u0086\u00ab&\u0012\u00e5~%\u00bf\u00f6\u000b\u00c1\u00b2\u00d5\u0010&:\u0001R\u008d\u00eeFJU\u00ed\u009c+\u0007\u00c1\by/p\u00c0\u013a\u00059\u01e3\u0098\u01043\u0083\u0001=dQ\u00eb\u000bA\u00f8XM\u00f4\u00b6%.\u00b7\u00f7R\u000e\u0088\u0089\u008e\u00ad(\u017dF\u007f\b\u00b6\u012b#\u0083\u00ab\u0087\u0096\u0098\u00c5\u0095\u00c2\u0005*n)>\u001b\u0095\u00d9\u00a6\u0010W\u0012".length();
                var1_4 = 12;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00e7\u00dc\u00b1\u00df\u00c0\u009c9\u00af\u00be\u0085\u0085L\u00afZ\u0018\r\u009f\u00996&k`\u009a\u009b\u00ce\u00d7\u00efli)\u00c5d\u0096\u00d3\u00f7\u014e\u00e3\u00b7\u013fV\u019f\u00cd\u0015\t%\u00dcw\u00b2p\u008b-\u00d57'\u00c3\u00ed|\u008b\u00f5\u001e#\u00a5{\u00bd";
                    var4_3 = "\u00e7\u00dc\u00b1\u00df\u00c0\u009c9\u00af\u00be\u0085\u0085L\u00afZ\u0018\r\u009f\u00996&k`\u009a\u009b\u00ce\u00d7\u00efli)\u00c5d\u0096\u00d3\u00f7\u014e\u00e3\u00b7\u013fV\u019f\u00cd\u0015\t%\u00dcw\u00b2p\u008b-\u00d57'\u00c3\u00ed|\u008b\u00f5\u001e#\u00a5{\u00bd".length();
                    var1_4 = 42;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 110;
                            break;
                        }
                        case 1: {
                            v13 = 56;
                            break;
                        }
                        case 2: {
                            v13 = 117;
                            break;
                        }
                        case 3: {
                            v13 = 56;
                            break;
                        }
                        case 4: {
                            v13 = 65;
                            break;
                        }
                        case 5: {
                            v13 = 89;
                            break;
                        }
                        default: {
                            v13 = 72;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        OCSPClient.r = var5;
        OCSPClient.s = new String[71];
        OCSPClient.e = OCSPClient.a(-9844, 29002);
        OCSPClient.d = OCSPClient.a(-9746, 6673);
        OCSPClient.a = OCSPClient.a(-9779, 11058);
        OCSPClient.b = OCSPClient.a(-9770, -7438);
        OCSPClient.c = OCSPClient.a(-9729, -7926);
        OCSPClient.logger = LoggerFactory.getLogger(OCSPClient.class);
        OCSPClient.NONCE_OID = new Asn1ObjectIdentifier(_ocspValues.id_pkix_ocsp_nonce);
        OCSPClient.g = LoggerFactory.getLogger(OCSPClient.class);
        OCSPClient.digestAlgForOcspRequest = DigestAlg.SHA256;
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0xFFFFD9CD) & 0xFFFF;
        if (s[n3] == null) {
            int n4;
            int n5;
            char[] cArray = r[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 243;
                    break;
                }
                case 1: {
                    n5 = 40;
                    break;
                }
                case 2: {
                    n5 = 148;
                    break;
                }
                case 3: {
                    n5 = 64;
                    break;
                }
                case 4: {
                    n5 = 165;
                    break;
                }
                case 5: {
                    n5 = 20;
                    break;
                }
                case 6: {
                    n5 = 59;
                    break;
                }
                case 7: {
                    n5 = 157;
                    break;
                }
                case 8: {
                    n5 = 48;
                    break;
                }
                case 9: {
                    n5 = 58;
                    break;
                }
                case 10: {
                    n5 = 197;
                    break;
                }
                case 11: {
                    n5 = 234;
                    break;
                }
                case 12: {
                    n5 = 71;
                    break;
                }
                case 13: {
                    n5 = 99;
                    break;
                }
                case 14: {
                    n5 = 166;
                    break;
                }
                case 15: {
                    n5 = 206;
                    break;
                }
                case 16: {
                    n5 = 62;
                    break;
                }
                case 17: {
                    n5 = 190;
                    break;
                }
                case 18: {
                    n5 = 193;
                    break;
                }
                case 19: {
                    n5 = 75;
                    break;
                }
                case 20: {
                    n5 = 28;
                    break;
                }
                case 21: {
                    n5 = 108;
                    break;
                }
                case 22: {
                    n5 = 68;
                    break;
                }
                case 23: {
                    n5 = 61;
                    break;
                }
                case 24: {
                    n5 = 248;
                    break;
                }
                case 25: {
                    n5 = 195;
                    break;
                }
                case 26: {
                    n5 = 111;
                    break;
                }
                case 27: {
                    n5 = 4;
                    break;
                }
                case 28: {
                    n5 = 247;
                    break;
                }
                case 29: {
                    n5 = 15;
                    break;
                }
                case 30: {
                    n5 = 63;
                    break;
                }
                case 31: {
                    n5 = 188;
                    break;
                }
                case 32: {
                    n5 = 209;
                    break;
                }
                case 33: {
                    n5 = 33;
                    break;
                }
                case 34: {
                    n5 = 34;
                    break;
                }
                case 35: {
                    n5 = 60;
                    break;
                }
                case 36: {
                    n5 = 122;
                    break;
                }
                case 37: {
                    n5 = 92;
                    break;
                }
                case 38: {
                    n5 = 149;
                    break;
                }
                case 39: {
                    n5 = 1;
                    break;
                }
                case 40: {
                    n5 = 101;
                    break;
                }
                case 41: {
                    n5 = 208;
                    break;
                }
                case 42: {
                    n5 = 163;
                    break;
                }
                case 43: {
                    n5 = 242;
                    break;
                }
                case 44: {
                    n5 = 55;
                    break;
                }
                case 45: {
                    n5 = 118;
                    break;
                }
                case 46: {
                    n5 = 110;
                    break;
                }
                case 47: {
                    n5 = 151;
                    break;
                }
                case 48: {
                    n5 = 90;
                    break;
                }
                case 49: {
                    n5 = 44;
                    break;
                }
                case 50: {
                    n5 = 225;
                    break;
                }
                case 51: {
                    n5 = 98;
                    break;
                }
                case 52: {
                    n5 = 142;
                    break;
                }
                case 53: {
                    n5 = 141;
                    break;
                }
                case 54: {
                    n5 = 254;
                    break;
                }
                case 55: {
                    n5 = 47;
                    break;
                }
                case 56: {
                    n5 = 170;
                    break;
                }
                case 57: {
                    n5 = 215;
                    break;
                }
                case 58: {
                    n5 = 213;
                    break;
                }
                case 59: {
                    n5 = 18;
                    break;
                }
                case 60: {
                    n5 = 183;
                    break;
                }
                case 61: {
                    n5 = 86;
                    break;
                }
                case 62: {
                    n5 = 67;
                    break;
                }
                case 63: {
                    n5 = 127;
                    break;
                }
                case 64: {
                    n5 = 214;
                    break;
                }
                case 65: {
                    n5 = 51;
                    break;
                }
                case 66: {
                    n5 = 185;
                    break;
                }
                case 67: {
                    n5 = 65;
                    break;
                }
                case 68: {
                    n5 = 192;
                    break;
                }
                case 69: {
                    n5 = 191;
                    break;
                }
                case 70: {
                    n5 = 177;
                    break;
                }
                case 71: {
                    n5 = 49;
                    break;
                }
                case 72: {
                    n5 = 134;
                    break;
                }
                case 73: {
                    n5 = 249;
                    break;
                }
                case 74: {
                    n5 = 113;
                    break;
                }
                case 75: {
                    n5 = 153;
                    break;
                }
                case 76: {
                    n5 = 123;
                    break;
                }
                case 77: {
                    n5 = 87;
                    break;
                }
                case 78: {
                    n5 = 228;
                    break;
                }
                case 79: {
                    n5 = 229;
                    break;
                }
                case 80: {
                    n5 = 5;
                    break;
                }
                case 81: {
                    n5 = 156;
                    break;
                }
                case 82: {
                    n5 = 56;
                    break;
                }
                case 83: {
                    n5 = 255;
                    break;
                }
                case 84: {
                    n5 = 198;
                    break;
                }
                case 85: {
                    n5 = 238;
                    break;
                }
                case 86: {
                    n5 = 144;
                    break;
                }
                case 87: {
                    n5 = 109;
                    break;
                }
                case 88: {
                    n5 = 115;
                    break;
                }
                case 89: {
                    n5 = 205;
                    break;
                }
                case 90: {
                    n5 = 200;
                    break;
                }
                case 91: {
                    n5 = 130;
                    break;
                }
                case 92: {
                    n5 = 222;
                    break;
                }
                case 93: {
                    n5 = 169;
                    break;
                }
                case 94: {
                    n5 = 72;
                    break;
                }
                case 95: {
                    n5 = 233;
                    break;
                }
                case 96: {
                    n5 = 139;
                    break;
                }
                case 97: {
                    n5 = 81;
                    break;
                }
                case 98: {
                    n5 = 221;
                    break;
                }
                case 99: {
                    n5 = 240;
                    break;
                }
                case 100: {
                    n5 = 37;
                    break;
                }
                case 101: {
                    n5 = 23;
                    break;
                }
                case 102: {
                    n5 = 181;
                    break;
                }
                case 103: {
                    n5 = 145;
                    break;
                }
                case 104: {
                    n5 = 175;
                    break;
                }
                case 105: {
                    n5 = 104;
                    break;
                }
                case 106: {
                    n5 = 117;
                    break;
                }
                case 107: {
                    n5 = 78;
                    break;
                }
                case 108: {
                    n5 = 244;
                    break;
                }
                case 109: {
                    n5 = 252;
                    break;
                }
                case 110: {
                    n5 = 236;
                    break;
                }
                case 111: {
                    n5 = 16;
                    break;
                }
                case 112: {
                    n5 = 120;
                    break;
                }
                case 113: {
                    n5 = 41;
                    break;
                }
                case 114: {
                    n5 = 137;
                    break;
                }
                case 115: {
                    n5 = 8;
                    break;
                }
                case 116: {
                    n5 = 84;
                    break;
                }
                case 117: {
                    n5 = 212;
                    break;
                }
                case 118: {
                    n5 = 168;
                    break;
                }
                case 119: {
                    n5 = 146;
                    break;
                }
                case 120: {
                    n5 = 27;
                    break;
                }
                case 121: {
                    n5 = 140;
                    break;
                }
                case 122: {
                    n5 = 159;
                    break;
                }
                case 123: {
                    n5 = 30;
                    break;
                }
                case 124: {
                    n5 = 6;
                    break;
                }
                case 125: {
                    n5 = 216;
                    break;
                }
                case 126: {
                    n5 = 45;
                    break;
                }
                case 127: {
                    n5 = 46;
                    break;
                }
                case 128: {
                    n5 = 227;
                    break;
                }
                case 129: {
                    n5 = 220;
                    break;
                }
                case 130: {
                    n5 = 171;
                    break;
                }
                case 131: {
                    n5 = 226;
                    break;
                }
                case 132: {
                    n5 = 17;
                    break;
                }
                case 133: {
                    n5 = 136;
                    break;
                }
                case 134: {
                    n5 = 133;
                    break;
                }
                case 135: {
                    n5 = 224;
                    break;
                }
                case 136: {
                    n5 = 203;
                    break;
                }
                case 137: {
                    n5 = 131;
                    break;
                }
                case 138: {
                    n5 = 11;
                    break;
                }
                case 139: {
                    n5 = 38;
                    break;
                }
                case 140: {
                    n5 = 121;
                    break;
                }
                case 141: {
                    n5 = 66;
                    break;
                }
                case 142: {
                    n5 = 88;
                    break;
                }
                case 143: {
                    n5 = 128;
                    break;
                }
                case 144: {
                    n5 = 102;
                    break;
                }
                case 145: {
                    n5 = 246;
                    break;
                }
                case 146: {
                    n5 = 54;
                    break;
                }
                case 147: {
                    n5 = 80;
                    break;
                }
                case 148: {
                    n5 = 231;
                    break;
                }
                case 149: {
                    n5 = 32;
                    break;
                }
                case 150: {
                    n5 = 43;
                    break;
                }
                case 151: {
                    n5 = 7;
                    break;
                }
                case 152: {
                    n5 = 202;
                    break;
                }
                case 153: {
                    n5 = 230;
                    break;
                }
                case 154: {
                    n5 = 52;
                    break;
                }
                case 155: {
                    n5 = 152;
                    break;
                }
                case 156: {
                    n5 = 116;
                    break;
                }
                case 157: {
                    n5 = 26;
                    break;
                }
                case 158: {
                    n5 = 95;
                    break;
                }
                case 159: {
                    n5 = 135;
                    break;
                }
                case 160: {
                    n5 = 57;
                    break;
                }
                case 161: {
                    n5 = 106;
                    break;
                }
                case 162: {
                    n5 = 103;
                    break;
                }
                case 163: {
                    n5 = 239;
                    break;
                }
                case 164: {
                    n5 = 35;
                    break;
                }
                case 165: {
                    n5 = 96;
                    break;
                }
                case 166: {
                    n5 = 2;
                    break;
                }
                case 167: {
                    n5 = 74;
                    break;
                }
                case 168: {
                    n5 = 39;
                    break;
                }
                case 169: {
                    n5 = 158;
                    break;
                }
                case 170: {
                    n5 = 12;
                    break;
                }
                case 171: {
                    n5 = 19;
                    break;
                }
                case 172: {
                    n5 = 91;
                    break;
                }
                case 173: {
                    n5 = 89;
                    break;
                }
                case 174: {
                    n5 = 24;
                    break;
                }
                case 175: {
                    n5 = 9;
                    break;
                }
                case 176: {
                    n5 = 218;
                    break;
                }
                case 177: {
                    n5 = 29;
                    break;
                }
                case 178: {
                    n5 = 143;
                    break;
                }
                case 179: {
                    n5 = 21;
                    break;
                }
                case 180: {
                    n5 = 235;
                    break;
                }
                case 181: {
                    n5 = 178;
                    break;
                }
                case 182: {
                    n5 = 105;
                    break;
                }
                case 183: {
                    n5 = 36;
                    break;
                }
                case 184: {
                    n5 = 124;
                    break;
                }
                case 185: {
                    n5 = 50;
                    break;
                }
                case 186: {
                    n5 = 14;
                    break;
                }
                case 187: {
                    n5 = 250;
                    break;
                }
                case 188: {
                    n5 = 237;
                    break;
                }
                case 189: {
                    n5 = 196;
                    break;
                }
                case 190: {
                    n5 = 154;
                    break;
                }
                case 191: {
                    n5 = 93;
                    break;
                }
                case 192: {
                    n5 = 211;
                    break;
                }
                case 193: {
                    n5 = 161;
                    break;
                }
                case 194: {
                    n5 = 100;
                    break;
                }
                case 195: {
                    n5 = 10;
                    break;
                }
                case 196: {
                    n5 = 31;
                    break;
                }
                case 197: {
                    n5 = 253;
                    break;
                }
                case 198: {
                    n5 = 217;
                    break;
                }
                case 199: {
                    n5 = 179;
                    break;
                }
                case 200: {
                    n5 = 204;
                    break;
                }
                case 201: {
                    n5 = 160;
                    break;
                }
                case 202: {
                    n5 = 129;
                    break;
                }
                case 203: {
                    n5 = 174;
                    break;
                }
                case 204: {
                    n5 = 114;
                    break;
                }
                case 205: {
                    n5 = 83;
                    break;
                }
                case 206: {
                    n5 = 187;
                    break;
                }
                case 207: {
                    n5 = 132;
                    break;
                }
                case 208: {
                    n5 = 77;
                    break;
                }
                case 209: {
                    n5 = 223;
                    break;
                }
                case 210: {
                    n5 = 79;
                    break;
                }
                case 211: {
                    n5 = 94;
                    break;
                }
                case 212: {
                    n5 = 126;
                    break;
                }
                case 213: {
                    n5 = 162;
                    break;
                }
                case 214: {
                    n5 = 70;
                    break;
                }
                case 215: {
                    n5 = 194;
                    break;
                }
                case 216: {
                    n5 = 138;
                    break;
                }
                case 217: {
                    n5 = 155;
                    break;
                }
                case 218: {
                    n5 = 167;
                    break;
                }
                case 219: {
                    n5 = 119;
                    break;
                }
                case 220: {
                    n5 = 201;
                    break;
                }
                case 221: {
                    n5 = 180;
                    break;
                }
                case 222: {
                    n5 = 13;
                    break;
                }
                case 223: {
                    n5 = 210;
                    break;
                }
                case 224: {
                    n5 = 3;
                    break;
                }
                case 225: {
                    n5 = 164;
                    break;
                }
                case 226: {
                    n5 = 251;
                    break;
                }
                case 227: {
                    n5 = 97;
                    break;
                }
                case 228: {
                    n5 = 219;
                    break;
                }
                case 229: {
                    n5 = 25;
                    break;
                }
                case 230: {
                    n5 = 73;
                    break;
                }
                case 231: {
                    n5 = 82;
                    break;
                }
                case 232: {
                    n5 = 173;
                    break;
                }
                case 233: {
                    n5 = 22;
                    break;
                }
                case 234: {
                    n5 = 232;
                    break;
                }
                case 235: {
                    n5 = 241;
                    break;
                }
                case 236: {
                    n5 = 176;
                    break;
                }
                case 237: {
                    n5 = 172;
                    break;
                }
                case 238: {
                    n5 = 125;
                    break;
                }
                case 239: {
                    n5 = 182;
                    break;
                }
                case 240: {
                    n5 = 42;
                    break;
                }
                case 241: {
                    n5 = 245;
                    break;
                }
                case 242: {
                    n5 = 184;
                    break;
                }
                case 243: {
                    n5 = 85;
                    break;
                }
                case 244: {
                    n5 = 150;
                    break;
                }
                case 245: {
                    n5 = 0;
                    break;
                }
                case 246: {
                    n5 = 199;
                    break;
                }
                case 247: {
                    n5 = 207;
                    break;
                }
                case 248: {
                    n5 = 107;
                    break;
                }
                case 249: {
                    n5 = 53;
                    break;
                }
                case 250: {
                    n5 = 69;
                    break;
                }
                case 251: {
                    n5 = 112;
                    break;
                }
                case 252: {
                    n5 = 189;
                    break;
                }
                case 253: {
                    n5 = 147;
                    break;
                }
                case 254: {
                    n5 = 76;
                    break;
                }
                default: {
                    n5 = 186;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            OCSPClient.s[n3] = new String(cArray).intern();
        }
        return s[n3];
    }
}

