/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.crypto.provider.nss;

import java.security.Provider;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.crypto.Cipher;
import tr.gov.tubitak.uekae.esya.api.crypto.Digester;
import tr.gov.tubitak.uekae.esya.api.crypto.KeyAgreement;
import tr.gov.tubitak.uekae.esya.api.crypto.KeyFactory;
import tr.gov.tubitak.uekae.esya.api.crypto.KeyPairGenerator;
import tr.gov.tubitak.uekae.esya.api.crypto.MAC;
import tr.gov.tubitak.uekae.esya.api.crypto.RandomGenerator;
import tr.gov.tubitak.uekae.esya.api.crypto.Signer;
import tr.gov.tubitak.uekae.esya.api.crypto.Verifier;
import tr.gov.tubitak.uekae.esya.api.crypto.Wrapper;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.AsymmetricAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.CipherAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.KeyAgreementAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.MACAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.WrapAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.CryptoProvider;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.nss.NSSCipher;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.nss.NSSKeyAgreement;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.nss.NSSKeyFactory;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.nss.NSSMAC;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.nss.NSSRandomGenerator;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.nss.NSSWrapper;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.sun.SUNDigester;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.sun.SUNKeyPairGenerator;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.sun.SUNSigner;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.sun.SUNVerifier;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCard;

public class NSSCryptoProvider
implements CryptoProvider {
    private static Logger a = LoggerFactory.getLogger(NSSCryptoProvider.class);
    Provider b = null;
    private boolean c;
    private SmartCard d;
    private Long e;
    private Long f;

    public Long getSlotID() {
        return this.e;
    }

    public Long getSessionID() {
        return this.f;
    }

    public SmartCard getNssSoftToken() {
        return this.d;
    }

    NSSCryptoProvider(Provider provider, boolean bl, SmartCard smartCard, Long l) throws CryptoException, PKCS11Exception {
        this.b = provider;
        this.c = bl;
        this.d = smartCard;
        this.e = l;
        this.f = smartCard.openSession(l.longValue());
    }

    public Provider getmProvider() {
        return this.b;
    }

    public Cipher getEncryptor(CipherAlg aCipherAlg) throws CryptoException {
        return new NSSCipher(aCipherAlg, this.b, true);
    }

    public Cipher getDecryptor(CipherAlg aCipherAlg) throws CryptoException {
        return new NSSCipher(aCipherAlg, this.b, false);
    }

    public Digester getDigester(DigestAlg aDigestAlg) throws CryptoException {
        return new SUNDigester(aDigestAlg, this.b);
    }

    public Signer getSigner(SignatureAlg aSignatureAlg) throws CryptoException {
        return new SUNSigner(aSignatureAlg, this.b);
    }

    public Verifier getVerifier(SignatureAlg aSignatureAlg) throws CryptoException {
        return new SUNVerifier(aSignatureAlg, this.b);
    }

    public MAC getMAC(MACAlg aMACAlg) throws CryptoException {
        return new NSSMAC(aMACAlg, this.b);
    }

    public Wrapper getWrapper(WrapAlg aWrapAlg) throws CryptoException {
        return new NSSWrapper(aWrapAlg, true, this.d, this.f);
    }

    public Wrapper getUnwrapper(WrapAlg aWrapAlg) throws CryptoException {
        return new NSSWrapper(aWrapAlg, false, this.d, this.f);
    }

    public KeyAgreement getKeyAgreement(KeyAgreementAlg aKeyAgreementAlg) throws CryptoException {
        return new NSSKeyAgreement(aKeyAgreementAlg, this.d, this.e, this.f);
    }

    public KeyFactory getKeyFactory() throws CryptoException {
        return new NSSKeyFactory(this.b);
    }

    public KeyPairGenerator getKeyPairGenerator(AsymmetricAlg aAsymmetricAlg) throws CryptoException {
        return new SUNKeyPairGenerator(aAsymmetricAlg, this.b);
    }

    public RandomGenerator getRandomGenerator() {
        return new NSSRandomGenerator(this.b);
    }

    public boolean isFipsMode() {
        return this.c;
    }

    public void destroyProvider() {
        try {
            this.b.clear();
            ((SunPKCS11)this.b).logout();
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }
}

