/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.commands;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.TerminalFactory;
import tubitak.akis.cif.akisExceptions.AkisCIFException;
import tubitak.akis.cif.akisExceptions.AkisCardException;
import tubitak.akis.cif.akisExceptions.AkisSWException;
import tubitak.akis.cif.commands.AbstractAkisCommands;
import tubitak.akis.cif.commands.CIFFactory;
import tubitak.akis.cif.functions.CommandTransmitterPCSC;
import tubitak.akis.cif.functions.Conversions;
import tubitak.akis.cif.functions.ICommandTransmitter;

public class PKCS11Functions {
    protected Hashtable<String, Integer> serialCertID;
    protected Hashtable<String, Integer> serialKeyID;
    protected TerminalFactory terminalFact = TerminalFactory.getDefault();
    protected AbstractAkisCommands commands;
    protected ICommandTransmitter card;

    public PKCS11Functions() {
        this.serialCertID = new Hashtable();
        this.serialKeyID = new Hashtable();
    }

    public long[] getSlotList() throws AkisCardException {
        int count = 0;
        try {
            count = this.terminalFact.terminals().list().size();
        }
        catch (CardException e) {
            throw new AkisCardException(e);
        }
        long[] slots = new long[count];
        for (int i = 0; i < count; ++i) {
            slots[i] = i + 1;
        }
        return slots;
    }

    public CardTerminal[] getTerminalList() throws AkisCardException {
        try {
            return this.terminalFact.terminals().list().toArray(new CardTerminal[0]);
        }
        catch (CardException e) {
            throw new AkisCardException(e);
        }
    }

    public void openSession(long aSlot) throws AkisCardException, AkisSWException, AkisCIFException {
        try {
            this.openSession(new CommandTransmitterPCSC(this.terminalFact.terminals().list().get((int)aSlot - 1), false));
        }
        catch (CardException e) {
            throw new AkisCardException(e);
        }
    }

    public void openSession(ICommandTransmitter transmitter) throws AkisSWException, AkisCardException, AkisCIFException {
        this.card = transmitter;
        this.commands = CIFFactory.getAkisCIFInstance(transmitter);
        this.commands.selectMF();
        this.commands.selectDFByName("PKCS-15".getBytes(StandardCharsets.US_ASCII));
    }

    public void closeSession() {
        this.card.closeCardTerminal();
    }

    public void login(String aPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        this.commands.verify(aPIN.getBytes(), false);
    }

    public List<byte[]> getSignatureCertificates() throws AkisCIFException, AkisCardException, AkisSWException {
        byte[] certValueFID = new byte[]{47, 15};
        ArrayList<byte[]> signatureCerts = new ArrayList<byte[]>();
        int index = 1;
        int noFile = 0;
        while (true) {
            try {
                while (true) {
                    certValueFID[1] = (byte)(certValueFID[1] + 1);
                    byte[] certBytes = this.commands.readFileBySelectingUnderActiveDF(certValueFID);
                    noFile = 0;
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes));
                    if (cert.getKeyUsage()[0]) {
                        signatureCerts.add(certBytes);
                        this.serialCertID.put(Conversions.hexBytetoHexString(cert.getSerialNumber().toByteArray()), index);
                    }
                    ++index;
                }
            }
            catch (AkisSWException ex) {
                if (ex.getErrorCode() == 27266L) {
                    if (++noFile <= 2) continue;
                    break;
                }
                throw ex;
            }
            catch (CertificateException e) {
                throw new AkisCIFException(e);
            }
            break;
        }
        return signatureCerts;
    }

    private byte[] signAndCheck(byte[] veri, byte keyID, byte[] aData, String serialStr, X509Certificate cert, String aDigestAlg) throws AkisSWException, AkisCIFException, AkisCardException {
        byte[] signature = this.commands.sign(veri, keyID);
        if (this.checkSignature(signature, aData, cert, aDigestAlg)) {
            this.serialKeyID.put(serialStr, Integer.valueOf(keyID));
            return signature;
        }
        throw new AkisSWException(25616L);
    }

    private boolean isKeyError(Exception ex) {
        long errorCode;
        return ex instanceof AkisSWException && ((errorCode = ((AkisSWException)ex).getErrorCode()) == 25616L || errorCode == 25625L || errorCode == 27015L);
    }

    private boolean checkSignature(byte[] signature, byte[] data, X509Certificate cert, String aDigestAlg) throws AkisCIFException {
        try {
            String fullAlgorithmName = aDigestAlg.replaceAll("-", "") + "withRSA";
            Signature signatureChecker = Signature.getInstance(fullAlgorithmName);
            signatureChecker.initVerify(cert);
            signatureChecker.update(data);
            return signatureChecker.verify(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new AkisCIFException(e.getMessage(), e);
        }
    }
}

