/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.dataStructures;

import tubitak.akis.cif.akisExceptions.AkisRuntimeException;
import tubitak.akis.cif.dataStructures.KeyType;
import tubitak.akis.cif.dataStructures.SDOHeaderGezgin;
import tubitak.akis.cif.functions.Conversions;

public class RSAKeyGezgin {
    public SDOHeaderGezgin header;
    private byte[] p;
    private byte[] q;
    private byte[] dP;
    private byte[] dQ;
    private byte[] Qinv;
    private byte[] n;
    private byte[] e;
    private byte[] CHR;

    public RSAKeyGezgin() {
        this.header = new SDOHeaderGezgin();
        this.p = null;
        this.q = null;
        this.dP = null;
        this.dQ = null;
        this.Qinv = null;
        this.n = null;
        this.e = null;
        this.CHR = null;
    }

    public boolean isCHRExists() {
        return this.CHR != null;
    }

    public RSAKeyGezgin(SDOHeaderGezgin header, byte[] n, byte[] e, byte[] CHR) {
        this.header = header;
        if (n.length % 2 != 0) {
            this.n = new byte[n.length + 1];
            this.n[0] = 0;
            System.arraycopy(n, 0, this.n, 1, n.length);
        } else {
            this.n = n;
        }
        if (e.length % 2 != 0) {
            this.e = new byte[e.length + 1];
            this.e[0] = 0;
            System.arraycopy(e, 0, this.e, 1, e.length);
        } else {
            this.e = e;
        }
        if (CHR != null) {
            if (CHR.length > 16) {
                throw new AkisRuntimeException("Invalid parameter");
            }
            this.CHR = CHR;
        }
    }

    public RSAKeyGezgin(SDOHeaderGezgin header, byte[] p, byte[] q, byte[] dP, byte[] dQ, byte[] Qinv, byte[] n) {
        this.header = header;
        if (p.length % 2 != 0) {
            this.p = new byte[p.length + 1];
            this.p[0] = 0;
            System.arraycopy(p, 0, this.p, 1, p.length);
        } else {
            this.p = p;
        }
        if (q.length % 2 != 0) {
            this.q = new byte[q.length + 1];
            this.q[0] = 0;
            System.arraycopy(q, 0, this.q, 1, q.length);
        } else {
            this.q = q;
        }
        if (dP.length % 2 != 0) {
            this.dP = new byte[dP.length + 1];
            this.dP[0] = 0;
            System.arraycopy(dP, 0, this.dP, 1, dP.length);
        } else {
            this.dP = dP;
        }
        if (dQ.length % 2 != 0) {
            this.dQ = new byte[dQ.length + 1];
            this.dQ[0] = 0;
            System.arraycopy(dQ, 0, this.dQ, 1, dQ.length);
        } else {
            this.dQ = dQ;
        }
        if (Qinv.length % 2 != 0) {
            this.Qinv = new byte[Qinv.length + 1];
            this.Qinv[0] = 0;
            System.arraycopy(Qinv, 0, this.Qinv, 1, Qinv.length);
        } else {
            this.Qinv = Qinv;
        }
        if (n.length % 2 != 0) {
            this.n = new byte[n.length + 1];
            this.n[0] = 0;
            System.arraycopy(n, 0, this.n, 1, n.length);
        } else {
            this.n = n;
        }
    }

    public byte[] CreateSDOHeaderList(KeyType keyType, boolean op) {
        int i = 0;
        int index = 0;
        byte[] headerList = new byte[256];
        if (!op) {
            headerList[i++] = 77;
            headerList[i++] = 0;
        }
        if (keyType == KeyType.PRIVATE_RSA) {
            headerList[i++] = -65;
            headerList[i++] = -112;
        } else if (keyType == KeyType.PUBLIC_RSA) {
            headerList[i++] = -65;
            headerList[i++] = -96;
        } else {
            throw new AkisRuntimeException("Invalid parameter");
        }
        headerList[i++] = this.header.keyID;
        headerList[i++] = 0;
        headerList[i++] = -96;
        index = i;
        headerList[i++] = 0;
        if (this.header.name != null) {
            headerList[i++] = -124;
            headerList[i++] = (byte)this.header.name.length;
            if (op) {
                System.arraycopy(this.header.name, 0, headerList, i, this.header.name.length);
                i += this.header.name.length;
            }
        }
        if (keyType == KeyType.PUBLIC_RSA) {
            if (this.header.effectiveDate != null) {
                headerList[i++] = 95;
                headerList[i++] = 37;
                headerList[i++] = 6;
                if (op) {
                    System.arraycopy(this.header.effectiveDate, 0, headerList, i, 6);
                    i += 6;
                }
            }
            if (this.header.expirationDate != null) {
                headerList[i++] = 95;
                headerList[i++] = 36;
                headerList[i++] = 6;
                if (op) {
                    System.arraycopy(this.header.expirationDate, 0, headerList, i, 6);
                    i += 6;
                }
            }
            if (this.header.usageOID != null) {
                headerList[i++] = 6;
                headerList[i++] = (byte)this.header.usageOID.length;
                if (op) {
                    System.arraycopy(this.header.usageOID, 0, headerList, i, this.header.usageOID.length);
                    i += this.header.usageOID.length;
                }
            }
        }
        headerList[index] = (byte)(i - index - 1);
        if (keyType == KeyType.PRIVATE_RSA && !op) {
            if (this.p == null || this.q == null || this.dP == null || this.dQ == null || this.Qinv == null || this.n == null) {
                throw new AkisRuntimeException("Invalid parameter");
            }
            headerList[i++] = 127;
            headerList[i++] = 72;
            index = i;
            headerList[i++] = 0;
            headerList[i++] = -110;
            byte[] temp = Conversions.GetBerLen(this.p.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            headerList[i++] = -109;
            temp = Conversions.GetBerLen(this.q.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            headerList[i++] = -107;
            temp = Conversions.GetBerLen(this.dP.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            headerList[i++] = -106;
            temp = Conversions.GetBerLen(this.dQ.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            headerList[i++] = -108;
            temp = Conversions.GetBerLen(this.Qinv.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            headerList[i++] = -127;
            temp = Conversions.GetBerLen(this.n.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            headerList[index] = (byte)((i += temp.length) - index - 1);
        } else if (keyType == KeyType.PUBLIC_RSA && !op) {
            if (this.n == null || this.e == null) {
                throw new AkisRuntimeException("Invalid parameter");
            }
            headerList[i++] = 127;
            headerList[i++] = 73;
            index = i;
            headerList[i++] = 0;
            headerList[i++] = -127;
            byte[] temp = Conversions.GetBerLen(this.n.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            headerList[i++] = -126;
            temp = Conversions.GetBerLen(this.e.length);
            System.arraycopy(temp, 0, headerList, i, temp.length);
            i += temp.length;
            if (this.CHR != null) {
                headerList[i++] = 95;
                headerList[i++] = 32;
                temp = Conversions.GetBerLen(this.CHR.length);
                System.arraycopy(temp, 0, headerList, i, temp.length);
                i += temp.length;
            }
            headerList[index] = (byte)(i - index - 1);
        }
        if (!op) {
            headerList[1] = (byte)(i - 2);
            headerList[5] = (byte)(headerList[1] - 4);
        } else {
            headerList[3] = (byte)(i - 4);
        }
        byte[] resizedHeaderList = new byte[i];
        System.arraycopy(headerList, 0, resizedHeaderList, 0, i);
        return resizedHeaderList;
    }

    public byte[] SDOUpdate(KeyType keyType, int tag) {
        byte[] temp;
        int i = 0;
        byte[] data = new byte[512];
        byte[] sdo = new byte[512];
        sdo[0] = -65;
        sdo[2] = this.header.keyID;
        if (keyType == KeyType.PRIVATE_RSA) {
            sdo[1] = -112;
            data[i++] = 127;
            data[i++] = 72;
            if (tag == 146) {
                temp = Conversions.GetBerLen(this.p.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -110;
                temp = Conversions.GetBerLen(this.p.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(this.p, 0, data, i += temp.length, this.p.length);
                i += this.p.length;
            } else if (tag == 147) {
                temp = Conversions.GetBerLen(this.q.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -109;
                temp = Conversions.GetBerLen(this.q.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(this.q, 0, data, i += temp.length, this.q.length);
                i += this.q.length;
            } else if (tag == 149) {
                temp = Conversions.GetBerLen(this.dP.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -107;
                temp = Conversions.GetBerLen(this.dP.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(this.dP, 0, data, i += temp.length, this.dP.length);
                i += this.dP.length;
            } else if (tag == 150) {
                temp = Conversions.GetBerLen(this.dQ.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -106;
                temp = Conversions.GetBerLen(this.dQ.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(this.dQ, 0, data, i += temp.length, this.dQ.length);
                i += this.dQ.length;
            } else if (tag == 148) {
                temp = Conversions.GetBerLen(this.Qinv.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -108;
                temp = Conversions.GetBerLen(this.Qinv.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(this.Qinv, 0, data, i += temp.length, this.Qinv.length);
                i += this.Qinv.length;
            } else if (tag == 129) {
                temp = Conversions.GetBerLen(this.n.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -127;
                temp = Conversions.GetBerLen(this.n.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(this.n, 0, data, i += temp.length, this.n.length);
                i += this.n.length;
            }
        } else if (keyType == KeyType.PUBLIC_RSA) {
            sdo[1] = -96;
            data[i++] = 127;
            data[i++] = 73;
            if (tag == 129) {
                temp = Conversions.GetBerLen(this.n.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -127;
                temp = Conversions.GetBerLen(this.n.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(this.n, 0, data, i += temp.length, this.n.length);
                i += this.n.length;
            } else if (tag == 130) {
                temp = Conversions.GetBerLen(this.e.length + 2);
                System.arraycopy(temp, 0, data, i, temp.length);
                i += temp.length;
                data[i++] = -126;
                temp = Conversions.GetBerLen(this.e.length);
                System.arraycopy(temp, 0, data, i, temp.length);
                System.arraycopy(this.e, 0, data, i += temp.length, this.e.length);
                i += this.e.length;
            } else if (tag == 32) {
                data[i++] = (byte)(this.CHR.length + 3);
                data[i++] = 95;
                data[i++] = 32;
                data[i++] = (byte)this.CHR.length;
                System.arraycopy(this.CHR, 0, data, i, this.CHR.length);
                i += this.CHR.length;
            }
        } else {
            throw new AkisRuntimeException("Invalid parameter");
        }
        int dataLen = i;
        temp = Conversions.GetBerLen(dataLen);
        System.arraycopy(temp, 0, sdo, 3, temp.length);
        i = temp.length + 3;
        System.arraycopy(data, 0, sdo, i, dataLen);
        byte[] resizedData = new byte[dataLen + i];
        System.arraycopy(sdo, 0, resizedData, 0, dataLen + i);
        return resizedData;
    }

    public void CreateKeyFromSDO(byte[] sdo) {
        if (sdo[0] != -65 && sdo[1] != -112 && sdo[1] != -96) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        int len = sdo[3] < 0 ? (sdo[3] & 0x7F) + 1 : 1;
        int i = 3 + len;
        if (sdo[i] == -96) {
            this.header.CreateHeaderFromSDO(sdo);
        } else if (sdo[i + 1] == 73) {
            int n = len = sdo[i + 2] < 0 ? (sdo[i + 2] & 0x7F) + 1 : 1;
            if (sdo[i += len + 2] == -127) {
                len = sdo[i + 1] < 0 ? (sdo[i + 1] & 0x7F) + 1 : 1;
                this.n = new byte[sdo.length - (i += len + 1)];
                System.arraycopy(sdo, i, this.n, 0, this.n.length);
            } else if (sdo[i] == -126) {
                len = sdo[i + 1] < 0 ? (sdo[i + 1] & 0x7F) + 1 : 1;
                this.e = new byte[sdo.length - (i += len + 1)];
                System.arraycopy(sdo, i, this.e, 0, this.e.length);
            } else if (sdo[i] == 95 && sdo[i + 1] == 32) {
                this.CHR = new byte[sdo[i + 2]];
                System.arraycopy(sdo, i + 3, this.CHR, 0, sdo[i + 2]);
            }
        }
    }
}

