/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.functions;

public class Conversions {
    public static String hexBytetoHexString(byte[] hex) {
        String str = "";
        if (hex == null) {
            return str;
        }
        for (int i = 0; i < hex.length; ++i) {
            int ipart = Integer.valueOf(Byte.toString(hex[i]));
            String part = Integer.toHexString(ipart);
            if (part.length() == 1) {
                str = str.concat("0");
                str = str.concat(part);
                continue;
            }
            if (part.length() > 2) {
                part = part.substring(6, 8);
                str = str.concat(part);
                continue;
            }
            str = str.concat(part);
        }
        return str;
    }

    public static String hexBytetoHexString(byte hex) {
        String str = "";
        int ipart = Integer.valueOf(Byte.toString(hex));
        String part = Integer.toHexString(ipart);
        if (part.length() == 1) {
            str = str.concat("0");
            str = str.concat(part);
        } else if (part.length() > 2) {
            part = part.substring(6, 8);
            str = str.concat(part);
        } else {
            str = str.concat(part);
        }
        return str;
    }

    public static String hexBytetoPrintableString(byte[] hex, boolean setText) {
        String str = "";
        if (hex.length < 0) {
            return null;
        }
        for (int i = 0; i < hex.length; ++i) {
            if (hex[i] == -1 && setText) {
                return str;
            }
            String part = ".";
            if (hex[i] > 31 && hex[i] < 127) {
                Character ch = new Character((char)hex[i]);
                part = ch.toString();
            }
            str = str.concat(part);
        }
        return str;
    }

    public static String hexBytetoAsciiString(byte[] hex, boolean setText) {
        String str = "";
        if (hex.length < 0) {
            return null;
        }
        for (int i = 0; i < hex.length; ++i) {
            String part = ".";
            Character ch = new Character((char)hex[i]);
            part = ch.toString();
            str = str.concat(part);
        }
        return str;
    }

    public static byte[] hexStringtohexByte(String str) {
        byte[] byt = new byte[str.length() / 2];
        byt[0] = Byte.parseByte("01", 16);
        for (int i = 0; i < str.length() / 2; ++i) {
            String strpart = str.substring(i * 2, i * 2 + 2);
            byt[i] = Byte.parseByte(strpart, 16);
        }
        return byt;
    }

    public static String asciiStrtoHexStr_v10PIN(String str) {
        byte[] byt = new byte[str.length()];
        byt[0] = Byte.parseByte("01", 16);
        for (int i = 0; i < str.length(); ++i) {
            byt[i] = (byte)(str.charAt(i) - 48);
        }
        return Conversions.hexBytetoAsciiString(byt, false);
    }

    public static String hexStringtoAsciiString(String str) {
        if (str == "") {
            return "";
        }
        byte[] byt = new byte[str.length() / 2];
        for (int i = 0; i < str.length() / 2; ++i) {
            String strpart = str.substring(i * 2, i * 2 + 2);
            byt[i] = (byte)Integer.parseInt(strpart, 16);
        }
        return Conversions.hexBytetoPrintableString(byt, false);
    }

    public static String asciiStringtoHexString(String str) {
        if (str == "") {
            return "";
        }
        byte[] byt = new byte[str.length()];
        byt[0] = Byte.parseByte("01", 16);
        for (int i = 0; i < str.length(); ++i) {
            byt[i] = (byte)str.charAt(i);
        }
        return Conversions.hexBytetoHexString(byt);
    }

    public static String asn1encoder(byte[] tlv) {
        if (tlv == null) {
            return null;
        }
        if (tlv[0] != 2) {
            return Conversions.hexBytetoHexString(tlv);
        }
        if (tlv[0] == 2) {
            byte[] value = new byte[tlv.length - 2];
            System.arraycopy(tlv, 2, value, 0, tlv.length - 2);
            return Conversions.hexBytetoHexString(value);
        }
        return null;
    }

    public static byte[] asn1BerTlvDecoder(byte[] tlv, byte wantedTag) {
        boolean flag = false;
        int pointer = 0;
        byte[] value = null;
        while (!flag) {
            byte length;
            byte tag = tlv[pointer];
            if (tag == wantedTag) {
                flag = true;
            }
            if (tlv[pointer + 1] != 81 && tlv[pointer + 1] != 82) {
                length = tlv[pointer + 1];
                if (flag) {
                    value = new byte[length];
                    System.arraycopy(tlv, pointer + 2, value, 0, length);
                    break;
                }
                pointer += 2;
                continue;
            }
            if (tlv[pointer + 1] == 81) {
                length = tlv[pointer + 2];
                if (flag) {
                    value = new byte[length];
                    System.arraycopy(tlv, pointer + 2, value, 0, length);
                    break;
                }
                pointer += 3;
                continue;
            }
            if (tlv[pointer + 1] != 82) continue;
            int MSB = tlv[pointer + 2] & 0xFF;
            int LSB = tlv[pointer + 3] & 0xFF;
            length = (byte)(MSB * 256 + LSB);
            if (flag) {
                value = new byte[length];
                System.arraycopy(tlv, pointer + 3, value, 0, length);
                break;
            }
            pointer += 4;
        }
        return null;
    }

    public static String padLeft(String input, char padChar, int len) {
        String output = "";
        int padLen = len - input.length();
        if (padLen < 0) {
            padLen = input.length();
        }
        for (int k = 0; k < padLen; ++k) {
            output = output + padChar;
        }
        output = output + input;
        return output;
    }

    public static String padRight(String input, char padChar, int len) {
        String output = "";
        output = output + input;
        int padLen = len - input.length();
        if (padLen < 0) {
            padLen = input.length();
        }
        for (int k = 0; k < padLen; ++k) {
            output = output + padChar;
        }
        return output;
    }

    public static byte[] integerToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static byte[] createTLV(byte[] TAG, byte[] data) {
        byte[] tlv = new byte[data.length + TAG.length + 1];
        System.arraycopy(TAG, 0, tlv, 0, TAG.length);
        tlv[TAG.length] = (byte)data.length;
        System.arraycopy(data, 0, tlv, TAG.length + 1, data.length);
        return tlv;
    }

    public static boolean[] byteTobitArray(byte bayt) {
        boolean[] bits = new boolean[8];
        for (int i = 0; i < 8; ++i) {
            bits[i] = (bayt & 1 << i) != 0;
        }
        return bits;
    }

    public static byte bitArraytoByte(boolean[] bitArray) {
        byte bayt = 0;
        for (int i = 0; i < 8; ++i) {
            boolean bit = false;
            if (bitArray[i]) {
                bit = true;
            }
            bayt = (byte)(bayt + (byte)((double)bit * Math.pow(2.0, i)));
        }
        return bayt;
    }

    public static byte[] asciiStringtoHexArray(String str) {
        if (str == "") {
            return null;
        }
        byte[] byt = new byte[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            byt[i] = (byte)str.charAt(i);
        }
        return byt;
    }

    public static byte[] xor(byte[] input1, byte[] input2) {
        byte[] out = new byte[input1.length];
        for (int i = 0; i < input1.length; ++i) {
            out[i] = (byte)(input1[i] ^ input2[i]);
        }
        return out;
    }

    public static byte[] GetBerLen(int len) {
        byte[] data = len < 128 ? new byte[]{(byte)len} : (len < 256 ? new byte[]{-127, (byte)len} : new byte[]{-126, (byte)(len >> 8), (byte)len});
        return data;
    }

    public static int GetLenOfBerLen(byte[] berlen) {
        int length = 0;
        if ((berlen[0] & 0xFFFFFF80) == 0) {
            length = berlen[0];
        } else if ((berlen[0] & 0xFFFFFF80) == -128 && (berlen[0] & 0x7F) == 1) {
            length = berlen[1] < 0 ? berlen[1] + 256 : berlen[1];
        } else if ((berlen[0] & 0xFFFFFF80) == -128 && (berlen[0] & 0x7F) == 2) {
            length = berlen[1] < 0 ? berlen[1] + 256 : berlen[1];
            length <<= 8;
            length |= berlen[2] < 0 ? berlen[2] + 256 : berlen[2];
        }
        return length;
    }

    public static byte[] MultiplyBy2(byte[] veri) {
        byte bCarriedOver = 0;
        for (int i = veri.length; i > 0; --i) {
            byte bToCarryOver = (veri[i - 1] & 0xFFFFFF80) == -128 ? (byte)1 : 0;
            int n = i - 1;
            veri[n] = (byte)(veri[n] << 1);
            int n2 = i - 1;
            veri[n2] = (byte)(veri[n2] | bCarriedOver);
            bCarriedOver = bToCarryOver;
        }
        return veri;
    }

    public static byte[] parseGenerateKeyPairResponse(byte[] resp) {
        byte[] result = null;
        int lengthOfLength = resp[2] < 0 ? (resp[2] & 0x7F) + 1 : 1;
        int innerTag = 2 + lengthOfLength;
        if (resp[innerTag] == -122) {
            int innerLengthOfLength = resp[innerTag + 1] < 0 ? (resp[innerTag + 1] & 0x7F) + 1 : 1;
            int dataIndex = innerTag + 1 + innerLengthOfLength + 1;
            int resultLength = resp.length - dataIndex;
            result = new byte[resultLength];
            System.arraycopy(resp, dataIndex, result, 0, resultLength);
        }
        return result;
    }
}

